/* $Id: MSResponse.hpp 113131 2007-10-30 14:30:34Z lewisg $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSResponse.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: MSResponse_.hpp


#ifndef OBJECTS_OMSSA_MSRESPONSE_HPP
#define OBJECTS_OMSSA_MSRESPONSE_HPP


// generated includes
#include <objects/omssa/MSResponse_.hpp>
#include <objects/omssa/MSModSpecSet.hpp>
#include <objects/omssa/MSScoreSet.hpp>

#include <set>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_OMSSA_EXPORT CMSResponse : public CMSResponse_Base
{
    typedef CMSResponse_Base Tparent;
public:
    // constructor
    CMSResponse(void);
    // destructor
    ~CMSResponse(void);

	// two interfaces for Print .csv
	string CSVString(const string& in);
	void PrintCSV(ostream& os, CRef <CMSModSpecSet> ModSet);  

    /** 
     * typdef for set of blast oids 
     */
    typedef set <int> TOidSet;

    /**
     * insert oids into oidset if hit is below threhold
     * 
     * @param OidSet the set of oids
     * @param Threshold the evalue threshold
     */
    void GetOidsBelowThreshold(TOidSet& OidSet,
                               const double Threshold) const;

    /**
     * Find hitset with given number
     * 
     * @param Number the number of the hitset
     * @return hitset or null
     */
    CRef <CMSHitSet> 
        FindHitSet(const int Number) const;

private:
    // Prohibit copy constructor and assignment operator
    CMSResponse(const CMSResponse& value);
    CMSResponse& operator=(const CMSResponse& value);

};

/////////////////// CMSResponse inline methods

// constructor
inline
CMSResponse::CMSResponse(void)
{
}


/////////////////// end of CMSResponse inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // OBJECTS_OMSSA_MSRESPONSE_HPP
/* Original file checksum: lines: 94, chars: 2590, CRC32: 3dc9dbf1 */
