/* $Id: Pssm.hpp 124526 2008-04-15 15:27:44Z camacho $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Pssm.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Pssm_.hpp


#ifndef OBJECTS_SCOREMAT_PSSM_HPP
#define OBJECTS_SCOREMAT_PSSM_HPP


// generated includes
#include <objects/scoremat/Pssm_.hpp>

// needed for custom methods
#include <objects/seq/NCBIstdaa.hpp>

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_SCOREMAT_EXPORT CPssm : public CPssm_Base
{
    typedef CPssm_Base Tparent;
public:
    // constructor
    CPssm(void);
    // destructor
    ~CPssm(void);

    /// Return the query length or 0 if no query is available
    SIZE_TYPE GetQueryLength() const;

    /// Retrieve the query sequence data in ncbistdaa format
    /// @param sequence object on which to store the sequence,
    /// it will be empty if there is no sequence data available [in|out]
    void GetQuerySequenceData(CNCBIstdaa& sequence) const;

    static const double kInvalidStat;

    double GetLambda() const;
    double GetKappa() const;
    double GetH() const;
    double GetLambdaUngapped() const;
    double GetKappaUngapped() const;
    double GetHUngapped() const;

    void SetLambda(double val);
    void SetKappa(double val);
    void SetH(double val);
    void SetLambdaUngapped(double val);
    void SetKappaUngapped(double val);
    void SetHUngapped(double val);
private:
    // Prohibit copy constructor and assignment operator
    CPssm(const CPssm& value);
    CPssm& operator=(const CPssm& value);

};

/////////////////// CPssm inline methods

// constructor
inline
CPssm::CPssm(void)
{
}


/////////////////// end of CPssm inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_PSSM_HPP
/* Original file checksum: lines: 86, chars: 2327, CRC32: 4f315e87 */
