/*
 * Copyright (c) 2020 University of Washington
 *
 * SPDX-License-Identifier: GPL-2.0-only
 *
 * Authors: Rohan Patidar <rpatidar@uw.edu>
 *          Sébastien Deronne <sebastien.deronne@gmail.com>
 *          Sian Jin <sianjin@uw.edu>
 */

// This file contains table data for the TableBasedErrorRateModel.  For more
// information on the source of this data, see wifi module documentation.

#include "error-rate-tables.h"

namespace ns3
{

/// AWGN error table for BCC with reference size of 32 bytes
const SnrPerTable AwgnErrorTableBcc32[ERROR_TABLE_BCC_MAX_NUM_MCS] = {
    // MCS-0
    {
        {dB_u{-3.50000}, 1.00000},
        {dB_u{-3.00000}, 0.99500},
        {dB_u{-2.50000}, 0.94080},
        {dB_u{-2.00000}, 0.82590},
        {dB_u{-1.50000}, 0.58950},
        {dB_u{-1.00000}, 0.30830},
        {dB_u{-0.50000}, 0.12540},
        {dB_u{0.00000}, 0.03440},
        {dB_u{0.50000}, 0.00850},
        {dB_u{1.00000}, 0.00150},
        {dB_u{1.50000}, 0.00024},
        {dB_u{2.00000}, 0.00009},
        {dB_u{2.50000}, 0.00000},
    },
    // MCS-1
    {
        {dB_u{-0.50000}, 1.00000},
        {dB_u{0.00000}, 0.99210},
        {dB_u{0.50000}, 0.96710},
        {dB_u{1.00000}, 0.83490},
        {dB_u{1.50000}, 0.58740},
        {dB_u{2.00000}, 0.31690},
        {dB_u{2.50000}, 0.11820},
        {dB_u{3.00000}, 0.03640},
        {dB_u{3.50000}, 0.00850},
        {dB_u{4.00000}, 0.00160},
        {dB_u{4.50000}, 0.00026},
        {dB_u{5.00000}, 0.00003},
        {dB_u{5.50000}, 0.00000},
    },
    // MCS-2
    {
        {dB_u{2.00000}, 1.00000},
        {dB_u{2.50000}, 0.99400},
        {dB_u{3.00000}, 0.95880},
        {dB_u{3.50000}, 0.85120},
        {dB_u{4.00000}, 0.59900},
        {dB_u{4.50000}, 0.31250},
        {dB_u{5.00000}, 0.11710},
        {dB_u{5.50000}, 0.03390},
        {dB_u{6.00000}, 0.00780},
        {dB_u{6.50000}, 0.00160},
        {dB_u{7.00000}, 0.00028},
        {dB_u{7.50000}, 0.00008},
        {dB_u{8.00000}, 0.00000},
    },
    // MCS-3
    {
        {dB_u{4.00000}, 1.00000},
        {dB_u{4.50000}, 0.99900},
        {dB_u{5.00000}, 0.99800},
        {dB_u{5.50000}, 0.96900},
        {dB_u{6.00000}, 0.88430},
        {dB_u{6.50000}, 0.74090},
        {dB_u{7.00000}, 0.46510},
        {dB_u{7.50000}, 0.25710},
        {dB_u{8.00000}, 0.10800},
        {dB_u{8.50000}, 0.03810},
        {dB_u{9.00000}, 0.01190},
        {dB_u{9.50000}, 0.00320},
        {dB_u{10.00000}, 0.00076},
        {dB_u{10.50000}, 0.00017},
        {dB_u{11.00000}, 0.00003},
        {dB_u{11.50000}, 0.00000},
    },
    // MCS-4
    {
        {dB_u{8.00000}, 1.00000},
        {dB_u{8.50000}, 0.99900},
        {dB_u{9.00000}, 0.94790},
        {dB_u{9.50000}, 0.79890},
        {dB_u{10.00000}, 0.59230},
        {dB_u{10.50000}, 0.33700},
        {dB_u{11.00000}, 0.15720},
        {dB_u{11.50000}, 0.05420},
        {dB_u{12.00000}, 0.01580},
        {dB_u{12.50000}, 0.00400},
        {dB_u{13.00000}, 0.00110},
        {dB_u{13.50000}, 0.00027},
        {dB_u{14.00000}, 0.00009},
        {dB_u{14.50000}, 0.00000},
    },
    // MCS-5
    {
        {dB_u{11.50000}, 1.00000},
        {dB_u{12.00000}, 0.99800},
        {dB_u{12.50000}, 0.96530},
        {dB_u{13.00000}, 0.89700},
        {dB_u{13.50000}, 0.73010},
        {dB_u{14.00000}, 0.52570},
        {dB_u{14.50000}, 0.30580},
        {dB_u{15.00000}, 0.15750},
        {dB_u{15.50000}, 0.06460},
        {dB_u{16.00000}, 0.02410},
        {dB_u{16.50000}, 0.00790},
        {dB_u{17.00000}, 0.00230},
        {dB_u{17.50000}, 0.00069},
        {dB_u{18.00000}, 0.00018},
        {dB_u{18.50000}, 0.00004},
        {dB_u{19.00000}, 0.00002},
        {dB_u{19.50000}, 0.00000},
    },
    // MCS-6
    {
        {dB_u{13.00000}, 1.00000},
        {dB_u{13.50000}, 0.99010},
        {dB_u{14.00000}, 0.96250},
        {dB_u{14.50000}, 0.83980},
        {dB_u{15.00000}, 0.68660},
        {dB_u{15.50000}, 0.46340},
        {dB_u{16.00000}, 0.25200},
        {dB_u{16.50000}, 0.11450},
        {dB_u{17.00000}, 0.04610},
        {dB_u{17.50000}, 0.01580},
        {dB_u{18.00000}, 0.00490},
        {dB_u{18.50000}, 0.00160},
        {dB_u{19.00000}, 0.00039},
        {dB_u{19.50000}, 0.00011},
        {dB_u{20.00000}, 0.00002},
        {dB_u{20.50000}, 0.00000},
    },
    // MCS-7
    {
        {dB_u{14.00000}, 1.00000},
        {dB_u{14.50000}, 0.99700},
        {dB_u{15.00000}, 0.98330},
        {dB_u{15.50000}, 0.94260},
        {dB_u{16.00000}, 0.84830},
        {dB_u{16.50000}, 0.63470},
        {dB_u{17.00000}, 0.43770},
        {dB_u{17.50000}, 0.22260},
        {dB_u{18.00000}, 0.11110},
        {dB_u{18.50000}, 0.04400},
        {dB_u{19.00000}, 0.01730},
        {dB_u{19.50000}, 0.00530},
        {dB_u{20.00000}, 0.00190},
        {dB_u{20.50000}, 0.00052},
        {dB_u{21.00000}, 0.00016},
        {dB_u{21.50000}, 0.00004},
        {dB_u{22.00000}, 0.00000},
    },
    // MCS-8
    {
        {dB_u{17.50000}, 1.00000},
        {dB_u{18.00000}, 0.99600},
        {dB_u{18.50000}, 0.98040},
        {dB_u{19.00000}, 0.92860},
        {dB_u{19.50000}, 0.82250},
        {dB_u{20.00000}, 0.67500},
        {dB_u{20.50000}, 0.44140},
        {dB_u{21.00000}, 0.26660},
        {dB_u{21.50000}, 0.13380},
        {dB_u{22.00000}, 0.05950},
        {dB_u{22.50000}, 0.02450},
        {dB_u{23.00000}, 0.00910},
        {dB_u{23.50000}, 0.00320},
        {dB_u{24.00000}, 0.00098},
        {dB_u{24.50000}, 0.00033},
        {dB_u{25.00000}, 0.00014},
        {dB_u{25.50000}, 0.00004},
        {dB_u{26.00000}, 0.00000},
    },
    // MCS-9
    {
        {dB_u{19.00000}, 1.00000},
        {dB_u{19.50000}, 0.99800},
        {dB_u{20.00000}, 0.98910},
        {dB_u{20.50000}, 0.95970},
        {dB_u{21.00000}, 0.87500},
        {dB_u{21.50000}, 0.73170},
        {dB_u{22.00000}, 0.51540},
        {dB_u{22.50000}, 0.30380},
        {dB_u{23.00000}, 0.15240},
        {dB_u{23.50000}, 0.06340},
        {dB_u{24.00000}, 0.02470},
        {dB_u{24.50000}, 0.00850},
        {dB_u{25.00000}, 0.00290},
        {dB_u{25.50000}, 0.00100},
        {dB_u{26.00000}, 0.00017},
        {dB_u{26.50000}, 0.00014},
        {dB_u{27.00000}, 0.00002},
        {dB_u{27.50000}, 0.00000},
    },
};

/// AWGN error table for BCC with reference size of 1458 bytes
const SnrPerTable AwgnErrorTableBcc1458[ERROR_TABLE_BCC_MAX_NUM_MCS] = {
    // MCS-0
    {
        {dB_u{-1.00000}, 1.00000},
        {dB_u{-0.50000}, 0.99400},
        {dB_u{0.00000}, 0.81850},
        {dB_u{0.50000}, 0.29080},
        {dB_u{1.00000}, 0.06630},
        {dB_u{1.50000}, 0.01120},
        {dB_u{2.00000}, 0.00150},
        {dB_u{2.50000}, 0.00015},
        {dB_u{3.00000}, 0.00001},
        {dB_u{3.50000}, 0.00000},
    },
    // MCS-1
    {
        {dB_u{2.00000}, 1.00000},
        {dB_u{2.50000}, 0.99700},
        {dB_u{3.00000}, 0.79440},
        {dB_u{3.50000}, 0.30080},
        {dB_u{4.00000}, 0.07280},
        {dB_u{4.50000}, 0.01200},
        {dB_u{5.00000}, 0.00150},
        {dB_u{5.50000}, 0.00023},
        {dB_u{6.00000}, 0.00000},
    },
    // MCS-2
    {
        {dB_u{4.50000}, 1.00000},
        {dB_u{5.00000}, 0.99800},
        {dB_u{5.50000}, 0.75780},
        {dB_u{6.00000}, 0.30100},
        {dB_u{6.50000}, 0.06760},
        {dB_u{7.00000}, 0.01220},
        {dB_u{7.50000}, 0.00230},
        {dB_u{8.00000}, 0.00035},
        {dB_u{8.50000}, 0.00004},
        {dB_u{9.00000}, 0.00000},
    },
    // MCS-3
    {
        {dB_u{7.50000}, 1.00000},
        {dB_u{8.00000}, 0.99400},
        {dB_u{8.50000}, 0.84050},
        {dB_u{9.00000}, 0.43410},
        {dB_u{9.50000}, 0.14190},
        {dB_u{10.00000}, 0.03740},
        {dB_u{10.50000}, 0.00860},
        {dB_u{11.00000}, 0.00190},
        {dB_u{11.50000}, 0.00036},
        {dB_u{12.00000}, 0.00005},
        {dB_u{12.50000}, 0.00000},
    },
    // MCS-4
    {
        {dB_u{11.00000}, 1.00000},
        {dB_u{11.50000}, 0.92690},
        {dB_u{12.00000}, 0.51390},
        {dB_u{12.50000}, 0.18260},
        {dB_u{13.00000}, 0.04650},
        {dB_u{13.50000}, 0.01100},
        {dB_u{14.00000}, 0.00260},
        {dB_u{14.50000}, 0.00041},
        {dB_u{15.00000}, 0.00010},
        {dB_u{15.50000}, 0.00000},
    },
    // MCS-5
    {
        {dB_u{14.50000}, 1.00000},
        {dB_u{15.00000}, 0.99900},
        {dB_u{15.50000}, 0.94790},
        {dB_u{16.00000}, 0.66250},
        {dB_u{16.50000}, 0.29780},
        {dB_u{17.00000}, 0.10580},
        {dB_u{17.50000}, 0.03340},
        {dB_u{18.00000}, 0.00910},
        {dB_u{18.50000}, 0.00230},
        {dB_u{19.00000}, 0.00064},
        {dB_u{19.50000}, 0.00017},
        {dB_u{20.00000}, 0.00002},
        {dB_u{20.50000}, 0.00000},
    },
    // MCS-6
    {
        {dB_u{16.00000}, 1.00000},
        {dB_u{16.50000}, 0.99500},
        {dB_u{17.00000}, 0.87960},
        {dB_u{17.50000}, 0.51390},
        {dB_u{18.00000}, 0.20910},
        {dB_u{18.50000}, 0.06390},
        {dB_u{19.00000}, 0.01860},
        {dB_u{19.50000}, 0.00460},
        {dB_u{20.00000}, 0.00130},
        {dB_u{20.50000}, 0.00023},
        {dB_u{21.00000}, 0.00002},
        {dB_u{21.50000}, 0.00000},
    },
    // MCS-7
    {
        {dB_u{17.50000}, 1.00000},
        {dB_u{18.00000}, 0.97850},
        {dB_u{18.50000}, 0.73930},
        {dB_u{19.00000}, 0.33750},
        {dB_u{19.50000}, 0.12340},
        {dB_u{20.00000}, 0.03550},
        {dB_u{20.50000}, 0.01000},
        {dB_u{21.00000}, 0.00270},
        {dB_u{21.50000}, 0.00050},
        {dB_u{22.00000}, 0.00009},
        {dB_u{22.50000}, 0.00001},
        {dB_u{23.00000}, 0.00000},
    },
    // MCS-8
    {
        {dB_u{21.00000}, 1.00000},
        {dB_u{21.50000}, 0.99800},
        {dB_u{22.00000}, 0.93990},
        {dB_u{22.50000}, 0.67090},
        {dB_u{23.00000}, 0.35250},
        {dB_u{23.50000}, 0.13760},
        {dB_u{24.00000}, 0.04750},
        {dB_u{24.50000}, 0.01540},
        {dB_u{25.00000}, 0.00520},
        {dB_u{25.50000}, 0.00150},
        {dB_u{26.00000}, 0.00036},
        {dB_u{26.50000}, 0.00007},
        {dB_u{27.00000}, 0.00000},
    },
    // MCS-9
    {
        {dB_u{22.50000}, 1.00000},
        {dB_u{23.00000}, 0.99900},
        {dB_u{23.50000}, 0.95060},
        {dB_u{24.00000}, 0.68470},
        {dB_u{24.50000}, 0.32610},
        {dB_u{25.00000}, 0.12480},
        {dB_u{25.50000}, 0.04090},
        {dB_u{26.00000}, 0.01300},
        {dB_u{26.50000}, 0.00360},
        {dB_u{27.00000}, 0.00082},
        {dB_u{27.50000}, 0.00010},
        {dB_u{28.00000}, 0.00002},
        {dB_u{28.50000}, 0.00001},
        {dB_u{29.00000}, 0.00000},
    },
};

/// AWGN error table for LDPC with reference size of 1458 bytes
const SnrPerTable AwgnErrorTableLdpc1458[ERROR_TABLE_LDPC_MAX_NUM_MCS] = {
    // MCS-0
    {
        {dB_u{-1.50000}, 1.00000},
        {dB_u{-1.25000}, 0.97950},
        {dB_u{-1.00000}, 0.60480},
        {dB_u{-0.75000}, 0.17050},
        {dB_u{-0.50000}, 0.03320},
        {dB_u{-0.25000}, 0.00530},
        {dB_u{0.00000}, 0.00085},
        {dB_u{0.25000}, 0.00022},
        {dB_u{0.50000}, 0.00004},
        {dB_u{0.75000}, 0.00000},
    },
    // MCS-1
    {
        {dB_u{1.50000}, 1.00000},
        {dB_u{1.75000}, 0.97470},
        {dB_u{2.00000}, 0.62330},
        {dB_u{2.25000}, 0.18590},
        {dB_u{2.50000}, 0.03400},
        {dB_u{2.75000}, 0.00550},
        {dB_u{3.00000}, 0.00083},
        {dB_u{3.25000}, 0.00015},
        {dB_u{3.50000}, 0.00003},
        {dB_u{3.75000}, 0.00000},
    },
    // MCS-2
    {
        {dB_u{4.00000}, 1.00000},
        {dB_u{4.25000}, 0.98720},
        {dB_u{4.50000}, 0.62560},
        {dB_u{4.75000}, 0.15800},
        {dB_u{5.00000}, 0.02090},
        {dB_u{5.25000}, 0.00250},
        {dB_u{5.50000}, 0.00034},
        {dB_u{5.75000}, 0.00003},
        {dB_u{6.00000}, 0.00000},
    },
    // MCS-3
    {
        {dB_u{6.75000}, 1.00000},
        {dB_u{7.00000}, 0.99800},
        {dB_u{7.25000}, 0.94340},
        {dB_u{7.50000}, 0.57890},
        {dB_u{7.75000}, 0.20640},
        {dB_u{8.00000}, 0.04840},
        {dB_u{8.25000}, 0.00930},
        {dB_u{8.50000}, 0.00180},
        {dB_u{8.75000}, 0.00040},
        {dB_u{9.00000}, 0.00011},
        {dB_u{9.25000}, 0.00002},
        {dB_u{9.50000}, 0.00000},
    },
    // MCS-4
    {
        {dB_u{10.00000}, 1.00000},
        {dB_u{10.25000}, 0.99310},
        {dB_u{10.50000}, 0.70890},
        {dB_u{10.75000}, 0.24720},
        {dB_u{11.00000}, 0.04700},
        {dB_u{11.25000}, 0.00590},
        {dB_u{11.50000}, 0.00091},
        {dB_u{11.75000}, 0.00016},
        {dB_u{12.00000}, 0.00003},
        {dB_u{12.25000}, 0.00000},
    },
    // MCS-5
    {
        {dB_u{14.00000}, 1.00000},
        {dB_u{14.25000}, 0.99700},
        {dB_u{14.50000}, 0.91830},
        {dB_u{14.75000}, 0.53790},
        {dB_u{15.00000}, 0.16610},
        {dB_u{15.25000}, 0.03690},
        {dB_u{15.50000}, 0.00650},
        {dB_u{15.75000}, 0.00100},
        {dB_u{16.00000}, 0.00031},
        {dB_u{16.25000}, 0.00005},
        {dB_u{16.50000}, 0.00000},
    },
    // MCS-6
    {
        {dB_u{15.50000}, 1.00000},
        {dB_u{15.75000}, 0.98140},
        {dB_u{16.00000}, 0.73930},
        {dB_u{16.25000}, 0.33110},
        {dB_u{16.50000}, 0.08150},
        {dB_u{16.75000}, 0.01620},
        {dB_u{17.00000}, 0.00270},
        {dB_u{17.25000}, 0.00052},
        {dB_u{17.50000}, 0.00005},
        {dB_u{17.75000}, 0.00003},
        {dB_u{18.00000}, 0.00000},
    },
    // MCS-7
    {
        {dB_u{17.00000}, 1.00000},
        {dB_u{17.25000}, 0.97750},
        {dB_u{17.50000}, 0.73980},
        {dB_u{17.75000}, 0.33190},
        {dB_u{18.00000}, 0.09640},
        {dB_u{18.25000}, 0.02180},
        {dB_u{18.50000}, 0.00470},
        {dB_u{18.75000}, 0.00087},
        {dB_u{19.00000}, 0.00018},
        {dB_u{19.25000}, 0.00003},
        {dB_u{19.50000}, 0.00000},
    },
    // MCS-8
    {
        {dB_u{20.50000}, 1.00000},
        {dB_u{20.75000}, 0.99500},
        {dB_u{21.00000}, 0.89700},
        {dB_u{21.25000}, 0.56270},
        {dB_u{21.50000}, 0.20920},
        {dB_u{21.75000}, 0.05600},
        {dB_u{22.00000}, 0.01170},
        {dB_u{22.25000}, 0.00250},
        {dB_u{22.50000}, 0.00038},
        {dB_u{22.75000}, 0.00013},
        {dB_u{23.00000}, 0.00004},
        {dB_u{23.25000}, 0.00001},
        {dB_u{23.50000}, 0.00000},
    },
    // MCS-9
    {
        {dB_u{22.25000}, 1.00000},
        {dB_u{22.50000}, 0.99900},
        {dB_u{22.75000}, 0.94080},
        {dB_u{23.00000}, 0.63600},
        {dB_u{23.25000}, 0.27190},
        {dB_u{23.50000}, 0.08700},
        {dB_u{23.75000}, 0.02210},
        {dB_u{24.00000}, 0.00500},
        {dB_u{24.25000}, 0.00110},
        {dB_u{24.50000}, 0.00032},
        {dB_u{24.75000}, 0.00004},
        {dB_u{25.00000}, 0.00000},
    },
    // MCS-10
    {
        {dB_u{25.75000}, 1.00000},
        {dB_u{26.00000}, 0.94970},
        {dB_u{26.25000}, 0.68660},
        {dB_u{26.50000}, 0.32940},
        {dB_u{26.75000}, 0.11620},
        {dB_u{27.00000}, 0.03440},
        {dB_u{27.25000}, 0.00880},
        {dB_u{27.50000}, 0.00210},
        {dB_u{27.75000}, 0.00054},
        {dB_u{28.00000}, 0.00009},
        {dB_u{28.25000}, 0.00002},
        {dB_u{28.50000}, 0.00000},
    },
    // MCS-11
    {
        {dB_u{27.75000}, 1.00000},
        {dB_u{28.00000}, 0.94880},
        {dB_u{28.25000}, 0.75260},
        {dB_u{28.50000}, 0.40230},
        {dB_u{28.75000}, 0.16210},
        {dB_u{29.00000}, 0.05150},
        {dB_u{29.25000}, 0.01310},
        {dB_u{29.50000}, 0.00360},
        {dB_u{29.75000}, 0.00100},
        {dB_u{30.00000}, 0.00022},
        {dB_u{30.25000}, 0.00006},
        {dB_u{30.50000}, 0.00000},
    },
};

} // namespace ns3
