#include "stdafx.h"
#include "BuiltInSource.h"
#include "Engine.h"

namespace storm {

	BuiltInSource::BuiltInSource(builtin::BuiltIn ref) : myRef(ref) {}

	BuiltInSource::BuiltInSource(builtin::BuiltIn ref, const void *ptr) : myRef(ref) {
		setPtr(ptr);
	}

	Str *BuiltInSource::title() const {
		SimpleName *typeName = parseSimpleName(engine(), S("core.asm.BuiltIn"));
		Type *t = as<Type>(engine().nameSet(typeName));
		if (!t)
			return new (this) Str(S("<failed to find core.asm.BuiltIn>"));

		const Handle &handle = t->handle();
		StrBuf *out = new (this) StrBuf();
		*out << S("C++:");
		(*handle.toSFn)(&myRef, out);
		return out->toS();
	}

}
