use experimental:effects;
use test;
use lang:bs:macro;

// TODO: make sure Backtrack is not possible to create outside of handle blocks.
effect Backtrack {
	// TODO: Allow effects to be marked "unchecked" or similarly - that makes them static and not checked.
	// TODO: Also provide a top-level convenience for cases where we only want a single one?
	effect Bool choose();
	effect void fail();

	Nat choose(Nat first, Nat last) {
		if (first >= last) {
			fail();
			return 0; // NB. Will never be executed.
		} else if (choose()) {
			return first;
		} else {
			return choose(first + 1, last);
		}
	}

	Int choose(Int first, Int last) {
		if (first >= last) {
			fail();
			return 0; // NB. Will never be executed.
		} else if (choose()) {
			return first;
		} else {
			return choose(first + 1, last);
		}
	}

	Int choose(Array<Int> from) {
		return from[choose(0n, from.count)];
	}
}

// TODO: Make sure PickOne is not possible to create outside of handle blocks.
handler PickOne(Array<Int> -> Maybe<Array<Int>>) for Backtrack {
	handle choose(), k {
		var first = k.call(true);
		if (first.empty)
			first = k.call(false);
		return first;
	}

	handle fail(), k {
		return null;
	}

	handle return x {
		return x;
	}
}

handler PickAll(Array<Int> -> Array<Array<Int>>) for Backtrack {
	handle choose(), k {
		var first = k.call(true);
		first.append(k.call(false));
		return first;
	}

	handle fail(), k {
		return [];
	}

	handle return x {
		return [x];
	}
}

test BacktrackTest1 {
	var r = handle (x = PickOne) {
		Int a = x.choose(1, 11);
		Int b = x.choose(1, 11);
		Int c = x.choose(1, 11);
		if (a*a + b*b != c*c)
			x.fail();
		[a, b, c];
	};
	// print("Result: ${r}");
	check r.toS() == "[3, 4, 5]";
}

test BacktrackTest2 {
	var r = handle (x = PickAll) {
		Int a = x.choose(1, 11);
		Int b = x.choose(1, 11);
		Int c = x.choose(1, 11);
		if (a*a + b*b != c*c)
			x.fail();
		[a, b, c];
	};
	// print("Result: ${r}");
	check r.toS() == "[[3, 4, 5], [4, 3, 5], [6, 8, 10], [8, 6, 10]]";
}
