use sound;
use core:io;
use lang:bs:macro;

Url fileUrl() {
	if (url = (named{res}).url) {
		return url;
	} else {
		return Url();
	}
}

void play(Url file) {
	Sound src = file.read.sound;
	print("Playing " # src);
	Player track(src);
	track.play;
	track.waitUntil(4 s);
	track.stop;
}

void playAll(Url file) {
	Sound src = file.read.sound;
	print("Playing " # src);
	Player track(src);
	track.play;
	track.wait;
}

void play() {
	play(fileUrl / "News Theme.ogg");
	play(fileUrl / "News Theme.flac");
	play(fileUrl / "News Theme.wav");
	play(fileUrl / "News Theme.mp3");
}
