/* cond_ace_token_enum.h
 * Token Type definitions from [MS-DTYP] v20180912 section 2.4.4.17
 *
 * John Bankier <opensource.jbankier[AT]gmail.com>
 *
 * Expects DEF_COND_ACE_TOKEN and DEF_COND_ACE_TOKEN_WITH_DATA macros to
 * be defined prior to including this file. Each macro expects the
 * following parameters: value, variable, string, e.g.:
 *
 * const char *foo(int bar) {
 *     switch (bar) {
 * #define DEF_COND_ACE_TOKEN(VAL, VAR, STR) case VAL: return STR;
 * #define DEF_COND_ACE_TOKEN_WITH_DATA(VAL, VAR, STR) case VAL: return STR;
 * #include "cond_ace_token_enum.h"
 *     }
 *     return NULL;
 * }
 *
 * Do not add #ifndef guards to this header file as it designed to be
 * included multiple times (if required).
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */
DEF_COND_ACE_TOKEN(0x00, PAD, "PAD")
DEF_COND_ACE_TOKEN_WITH_DATA(0x01, INT8, "INT8")
DEF_COND_ACE_TOKEN_WITH_DATA(0x02, INT16, "INT16")
DEF_COND_ACE_TOKEN_WITH_DATA(0x03, INT32, "INT32")
DEF_COND_ACE_TOKEN_WITH_DATA(0x04, INT64, "INT64")
DEF_COND_ACE_TOKEN_WITH_DATA(0x10, UNICODE_STRING, "UNICODE_STRING")
DEF_COND_ACE_TOKEN_WITH_DATA(0x18, OCTET_STRING, "OCTET_STRING")
DEF_COND_ACE_TOKEN_WITH_DATA(0x50, COMPOSITE, "COMPOSITE")
DEF_COND_ACE_TOKEN_WITH_DATA(0x51, SID, "SID")
DEF_COND_ACE_TOKEN(0x80, EQUAL, "==")
DEF_COND_ACE_TOKEN(0x81, NOT_EQUAL, "!=")
DEF_COND_ACE_TOKEN(0x82, LESS_THAN, "<")
DEF_COND_ACE_TOKEN(0x83, LESS_THAN_OR_EQUAL, "<=")
DEF_COND_ACE_TOKEN(0x84, GREATER_THAN, ">")
DEF_COND_ACE_TOKEN(0x85, GREATER_THAN_OR_EQUAL, ">=")
DEF_COND_ACE_TOKEN(0x86, CONTAINS, "CONTAINS")
DEF_COND_ACE_TOKEN(0x87, EXISTS, "EXISTS")
DEF_COND_ACE_TOKEN(0x88, ANY_OF, "ANY_OF")
DEF_COND_ACE_TOKEN(0x89, MEMBER_OF, "MEMBER_OF")
DEF_COND_ACE_TOKEN(0x8a, DEVICE_MEMBER_OF, "DEVICE_MEMBER_OF")
DEF_COND_ACE_TOKEN(0x8b, MEMBER_OF_ANY, "MEMBER_OF_ANY" )
DEF_COND_ACE_TOKEN(0x8c, DEVICE_MEMBER_OF_ANY, "DEVICE_MEMBER_OF_ANY")
DEF_COND_ACE_TOKEN(0x8d, NOT_EXISTS, "NOT_EXISTS")
DEF_COND_ACE_TOKEN(0x8e, NOT_CONTAINS, "NOT_CONTAINS")
DEF_COND_ACE_TOKEN(0x8f, NOT_ANY_OF, "NOT_ANY_OF")
DEF_COND_ACE_TOKEN(0x90, NOT_MEMBER_OF, "NOT_MEMBER_OF")
DEF_COND_ACE_TOKEN(0x91, NOT_DEVICE_MEMBER_OF, "NOT_DEVICE_MEMBER_OF")
DEF_COND_ACE_TOKEN(0x92, NOT_MEMBER_OF_ANY, "NOT_MEMBER_OF_ANY")
DEF_COND_ACE_TOKEN(0x93, NOT_DEVICE_MEMBER_OF_ANY, "NOT_DEVICE_MEMBER_OF_ANY" )
DEF_COND_ACE_TOKEN(0xa0, AND, "AND")
DEF_COND_ACE_TOKEN(0xa1, OR, "OR")
DEF_COND_ACE_TOKEN(0xa2, NOT, "NOT")
DEF_COND_ACE_TOKEN_WITH_DATA(0xf8, LOCAL_ATTRIBUTE, "LOCAL_ATTRIBUTE")
DEF_COND_ACE_TOKEN_WITH_DATA(0xf9, USER_ATTRIBUTE, "USER_ATTRIBUTE")
DEF_COND_ACE_TOKEN_WITH_DATA(0xfa, RESOURCE_ATTRIBUTE, "RESOURCE_ATTRIBUTE")
DEF_COND_ACE_TOKEN_WITH_DATA(0xfb, DEVICE_ATTRIBUTE, "DEVICE_ATTRIBUTE")

#undef DEF_COND_ACE_TOKEN
#undef DEF_COND_ACE_TOKEN_WITH_DATA
