include(GNUInstallDirs)
include(VersioningUtils)

SET_PROJECT_VERSION(2 50 0)

set(USER_AGENT_BRANDING "" CACHE STRING "Branding to add to user agent string")

# Update Source/WTF/wtf/Platform.h to match required GLib versions.
find_package(GLIB 2.70.0 REQUIRED COMPONENTS gio gio-unix gobject gthread gmodule)
find_package(HarfBuzz 2.7.4 REQUIRED COMPONENTS ICU)
find_package(ICU 70.1 REQUIRED COMPONENTS data i18n uc)
find_package(JPEG REQUIRED)
find_package(Epoxy 1.5.4 REQUIRED)
find_package(LibGcrypt 1.7.0 REQUIRED)
find_package(Libtasn1 REQUIRED)
find_package(Libxkbcommon 0.4.0 REQUIRED)
find_package(LibXml2 2.9.13 REQUIRED)
find_package(PNG REQUIRED)
find_package(SQLite3 REQUIRED)
find_package(Threads REQUIRED)
find_package(Unifdef REQUIRED)
find_package(WebP REQUIRED COMPONENTS demux)
find_package(WPE REQUIRED)
find_package(ZLIB REQUIRED)

if (ANDROID)
    find_package(Android REQUIRED COMPONENTS Android Log)

    # Media session only supports using MPRIS over D-Bus at the moment.
    # Switching this back would require using Android's MediaSession API.
    set(ENABLE_MEDIA_SESSION_DEFAULT OFF)
else ()
    set(ENABLE_MEDIA_SESSION_DEFAULT ON)
endif ()

WEBKIT_OPTION_BEGIN()

SET_AND_EXPOSE_TO_BUILD(ENABLE_DEVELOPER_MODE ${DEVELOPER_MODE})

include(GStreamerDefinitions)
include(FindGLibCompileResources)

# Public options shared with other WebKit ports. Do not add any options here
# without approval from a WPE reviewer. There must be strong reason to support
# changing the value of the option.
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_ENCRYPTED_MEDIA PUBLIC ${ENABLE_EXPERIMENTAL_FEATURES})
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_PDFJS PUBLIC ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_WEBDRIVER PUBLIC ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_XSLT PUBLIC ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_SPEECH_SYNTHESIS PUBLIC ON)

WEBKIT_OPTION_DEFAULT_PORT_VALUE(USE_AVIF PUBLIC ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(USE_LCMS PUBLIC ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(USE_JPEGXL PUBLIC ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(USE_WOFF2 PUBLIC ON)

# Private options shared with other WebKit ports. Add options here only if
# we need a value different from the default defined in WebKitFeatures.cmake.
# Changing these options is completely unsupported.
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_ASYNC_SCROLLING PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_AUTOCAPITALIZE PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CONTENT_EXTENSIONS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CURSOR_VISIBILITY PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_DARK_MODE_CSS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_DRAG_SUPPORT PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_FTPDIR PRIVATE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_GAMEPAD PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_GPU_PROCESS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEDIA_CONTROLS_CONTEXT_MENUS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEDIA_RECORDER PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEDIA_SESSION PRIVATE ${ENABLE_MEDIA_SESSION_DEFAULT})
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEDIA_SESSION_PLAYLIST PRIVATE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEDIA_STREAM PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MOUSE_CURSOR_SCALE PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MHTML PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_NOTIFICATIONS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_OFFSCREEN_CANVAS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_OFFSCREEN_CANVAS_IN_WORKERS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_PERIODIC_MEMORY_MONITOR PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_SHAREABLE_RESOURCE PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_THUNDER PRIVATE ${ENABLE_DEVELOPER_MODE})
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_TOUCH_EVENTS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_VARIATION_FONTS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_WEB_CODECS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_WEB_RTC PRIVATE ${ENABLE_EXPERIMENTAL_FEATURES})
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_WEBDRIVER_BIDI PRIVATE ${ENABLE_EXPERIMENTAL_FEATURES})
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_WEBXR PRIVATE ${ENABLE_EXPERIMENTAL_FEATURES})

if (CMAKE_CXX_BYTE_ORDER STREQUAL "LITTLE_ENDIAN")
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(USE_SKIA PRIVATE ON)
else ()
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(USE_SKIA PRIVATE OFF)
endif ()

# Public options specific to the WPE port. Do not add any options here unless
# there is a strong reason we should support changing the value of the option,
# and the option is not relevant to other WebKit ports.
WEBKIT_OPTION_DEFINE(ENABLE_DOCUMENTATION "Whether to generate documentation." PUBLIC ON)
WEBKIT_OPTION_DEFINE(ENABLE_INTROSPECTION "Whether to enable GObject introspection." PUBLIC ON)
WEBKIT_OPTION_DEFINE(ENABLE_JOURNALD_LOG "Whether to enable journald logging" PUBLIC ON)
WEBKIT_OPTION_DEFINE(ENABLE_WPE_PLATFORM "Whether to enable the WPEPlatform library" PUBLIC ${ENABLE_DEVELOPER_MODE})
WEBKIT_OPTION_DEFINE(ENABLE_WPE_PLATFORM_DRM "Whether to enable support for DRM platform" PUBLIC ON)
WEBKIT_OPTION_DEFINE(ENABLE_WPE_PLATFORM_HEADLESS "Whether to enable support for headless platform" PUBLIC ON)
WEBKIT_OPTION_DEFINE(ENABLE_WPE_PLATFORM_WAYLAND "Whether to enable support for Wayland platform" PUBLIC ON)
WEBKIT_OPTION_DEFINE(ENABLE_WPE_QT_API "Whether to enable support for the Qt/QML plugin" PUBLIC ${ENABLE_DEVELOPER_MODE})
WEBKIT_OPTION_DEFINE(ENABLE_WPE_1_1_API "Whether to build WPE 1.1 instead of WPE 2.0" PUBLIC OFF)
WEBKIT_OPTION_DEFINE(USE_ATK "Whether to enable usage of ATK." PUBLIC ON)
WEBKIT_OPTION_DEFINE(USE_FLITE "Whether to enable usage of Flite for speech synthesis." PUBLIC ON)
WEBKIT_OPTION_DEFINE(USE_GBM "Whether to enable usage of GBM." PUBLIC ON)
WEBKIT_OPTION_DEFINE(USE_LIBBACKTRACE "Whether to enable usage of libbacktrace." PUBLIC ON)
WEBKIT_OPTION_DEFINE(USE_LIBDRM "Whether to enable usage of libdrm." PUBLIC ON)
WEBKIT_OPTION_DEFINE(USE_SKIA_OPENTYPE_SVG "Whether to use the Skia built-in support for OpenType SVG fonts." PUBLIC ON)
WEBKIT_OPTION_DEFINE(USE_QT6 "Whether to use Qt6 instead of Qt5" PUBLIC OFF)

# Private options specific to the WPE port.
WEBKIT_OPTION_DEFINE(USE_EXTERNAL_HOLEPUNCH "Whether to enable external holepunch" PRIVATE OFF)
WEBKIT_OPTION_DEFINE(USE_SPIEL "Whether to enable usage of LibSpiel for speech synthesis." PRIVATE OFF)
WEBKIT_OPTION_DEFINE(USE_SYSPROF_CAPTURE "Whether to use libsysprof-capture for tracing." PRIVATE ON)
WEBKIT_OPTION_DEFINE(USE_SYSTEM_SYSPROF_CAPTURE "Whether to use a system-provided libsysprof-capture" PRIVATE ON)
WEBKIT_OPTION_DEFINE(USE_SYSTEM_UNIFDEF "Whether to use a system-provided unifdef" PRIVATE ON)
WEBKIT_OPTION_DEFINE(ENABLE_JSC_RESTRICTED_OPTIONS_BY_DEFAULT "Whether to enable dangerous development options in JSC by default." PRIVATE OFF)

WEBKIT_OPTION_CONFLICT(ENABLE_WPE_PLATFORM ENABLE_WPE_1_1_API)

WEBKIT_OPTION_DEPEND(ENABLE_DOCUMENTATION ENABLE_INTROSPECTION)
WEBKIT_OPTION_DEPEND(USE_QT6 ENABLE_WPE_PLATFORM)
WEBKIT_OPTION_DEPEND(USE_SKIA_OPENTYPE_SVG USE_SKIA)
WEBKIT_OPTION_DEPEND(USE_SYSTEM_SYSPROF_CAPTURE USE_SYSPROF_CAPTURE)

if (CMAKE_SYSTEM_NAME MATCHES "Linux")
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_BUBBLEWRAP_SANDBOX PUBLIC ON)
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEMORY_SAMPLER PRIVATE ON)
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_RESOURCE_USAGE PRIVATE ON)
else ()
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_BUBBLEWRAP_SANDBOX PUBLIC OFF)
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEMORY_SAMPLER PRIVATE OFF)
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_RESOURCE_USAGE PRIVATE OFF)
endif ()

if (ENABLE_DEVELOPER_MODE)
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_API_TESTS PRIVATE ON)
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_LAYOUT_TESTS PRIVATE ON)
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MINIBROWSER PUBLIC ON)
    WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_JSC_RESTRICTED_OPTIONS_BY_DEFAULT PRIVATE ON)
endif ()

WEBKIT_OPTION_DEPEND(ENABLE_GPU_PROCESS USE_GBM)
WEBKIT_OPTION_DEPEND(ENABLE_WPE_PLATFORM_DRM USE_GBM)
WEBKIT_OPTION_DEPEND(USE_GBM USE_LIBDRM)
WEBKIT_OPTION_DEPEND(USE_EXTERNAL_HOLEPUNCH ENABLE_VIDEO)
WEBKIT_OPTION_DEPEND(ENABLE_WEBXR ENABLE_GAMEPAD)

include(GStreamerDependencies)

WEBKIT_OPTION_END()

find_package(GI)
if (ENABLE_INTROSPECTION AND NOT GI_FOUND)
    message(FATAL_ERROR "GObjectIntrospection is needed for ENABLE_INTROSPECTION.")
endif ()

find_package(GIDocgen)
if (ENABLE_DOCUMENTATION AND NOT GIDocgen_FOUND)
    message(FATAL_ERROR "gi-docgen is needed for ENABLE_DOCUMENTATION.")
endif ()

if (ENABLE_WPE_1_1_API)
    set(SOUP_MINIMUM_VERSION 3.0.0)
    set(SOUP_API_VERSION 3.0)
    set(WPE_API_VERSION 1.1)
    set(WPE_API_MAJOR_VERSION 1)
    set(ENABLE_SERVER_PRECONNECT ON)
    SET_AND_EXPOSE_TO_BUILD(ENABLE_2022_GLIB_API OFF)
else ()
    set(SOUP_MINIMUM_VERSION 3.0.0)
    set(SOUP_API_VERSION 3.0)
    set(WPE_API_VERSION 2.0)
    set(WPE_API_MAJOR_VERSION 2)
    set(ENABLE_SERVER_PRECONNECT ON)
    SET_AND_EXPOSE_TO_BUILD(ENABLE_2022_GLIB_API ON)
endif ()
find_package(LibSoup ${SOUP_MINIMUM_VERSION} REQUIRED)

if (NOT LibSoup_FOUND)
    message(FATAL_ERROR "libsoup 3 is required.")
endif ()

EXPOSE_STRING_VARIABLE_TO_BUILD(WPE_API_VERSION)

if (WPE_API_VERSION VERSION_EQUAL "1.1")
    CALCULATE_LIBRARY_VERSIONS_FROM_LIBTOOL_TRIPLE(WEBKIT 10 5 10)
else ()
    CALCULATE_LIBRARY_VERSIONS_FROM_LIBTOOL_TRIPLE(WEBKIT 7 5 6)
endif ()

set(CMAKE_C_VISIBILITY_PRESET hidden)
set(CMAKE_CXX_VISIBILITY_PRESET hidden)
set(CMAKE_VISIBILITY_INLINES_HIDDEN ON)
set(bmalloc_LIBRARY_TYPE OBJECT)
set(WTF_LIBRARY_TYPE OBJECT)
set(JavaScriptCore_LIBRARY_TYPE OBJECT)
set(WebCore_LIBRARY_TYPE OBJECT)

# These are shared variables, but we special case their definition so that we can use the
# CMAKE_INSTALL_* variables that are populated by the GNUInstallDirs macro.
set(LIB_INSTALL_DIR "${CMAKE_INSTALL_FULL_LIBDIR}" CACHE PATH "Absolute path to library installation directory")
set(EXEC_INSTALL_DIR "${CMAKE_INSTALL_FULL_BINDIR}" CACHE PATH "Absolute path to executable installation directory")
set(LIBEXEC_INSTALL_DIR "${CMAKE_INSTALL_FULL_LIBEXECDIR}/wpe-webkit-${WPE_API_VERSION}" CACHE PATH "Absolute path to install executables executed by the library")

if (USE_ATK)
    find_package(ATK 2.16.0)
    if (NOT ATK_FOUND)
        message(FATAL_ERROR "atk is required for USE_ATK")
    endif ()
    find_package(ATKBridge)
    if (NOT ATKBridge_FOUND)
        message(FATAL_ERROR "atk-bridge is required for USE_ATK")
    endif ()
endif ()

if (ENABLE_SPEECH_SYNTHESIS)
    if (USE_SPIEL)
        find_package(LibSpiel)
        if (NOT LibSpiel_FOUND)
            message(FATAL_ERROR "LibSpiel is needed for ENABLE_SPEECH_SYNTHESIS")
        endif ()
        SET_AND_EXPOSE_TO_BUILD(USE_SPIEL ON)
    elseif (USE_FLITE)
        find_package(Flite 2.2)
        if (NOT Flite_FOUND)
            message(FATAL_ERROR "Flite is needed for ENABLE_SPEECH_SYNTHESIS")
        endif ()
        SET_AND_EXPOSE_TO_BUILD(USE_FLITE ON)
    else ()
        message(FATAL_ERROR "Either USE_SPIEL or USE_FLITE is needed for ENABLE_SPEECH_SYNTHESIS")
    endif ()
endif ()

if (USE_SKIA)
    SET_AND_EXPOSE_TO_BUILD(USE_CAIRO FALSE)
else ()
    find_package(Cairo 1.16.0 REQUIRED)
    find_package(Fontconfig 2.13.0 REQUIRED)
    find_package(Freetype 2.9.0 REQUIRED)
    SET_AND_EXPOSE_TO_BUILD(USE_CAIRO TRUE)
endif ()

if (USE_JPEGXL)
    find_package(JPEGXL 0.7.0)
    if (NOT JPEGXL_FOUND)
        message(FATAL_ERROR "libjxl is required for USE_JPEGXL")
    endif ()
endif ()

if (USE_WOFF2)
    find_package(WOFF2 1.0.2 COMPONENTS dec)
    if (NOT WOFF2_FOUND)
        message(FATAL_ERROR "libwoff2dec is required for USE_WOFF2")
    endif ()
endif ()

if (ENABLE_WEBDRIVER)
    SET_AND_EXPOSE_TO_BUILD(ENABLE_WEBDRIVER_KEYBOARD_INTERACTIONS ON)
    SET_AND_EXPOSE_TO_BUILD(ENABLE_WEBDRIVER_MOUSE_INTERACTIONS ON)
    if (ENABLE_WPE_PLATFORM)
        SET_AND_EXPOSE_TO_BUILD(ENABLE_WEBDRIVER_TOUCH_INTERACTIONS ON)
    else ()
        SET_AND_EXPOSE_TO_BUILD(ENABLE_WEBDRIVER_TOUCH_INTERACTIONS OFF)
    endif ()
    SET_AND_EXPOSE_TO_BUILD(ENABLE_WEBDRIVER_WHEEL_INTERACTIONS ON)
endif ()

if (ENABLE_XSLT)
    find_package(LibXslt 1.1.13 REQUIRED)
endif ()

if (ENABLE_WPE_PLATFORM)
    if (ANDROID)
        set(WPE_PLATFORM_BUFFER_ANDROID ON)
    endif ()

    if (ENABLE_WPE_PLATFORM_DRM)
        find_package(LibInput 1.19.0 REQUIRED)
        find_package(Udev REQUIRED)
        SET_AND_EXPOSE_TO_BUILD(ENABLE_WPE_PLATFORM_DRM ON)
        set(WPE_PLATFORM_DRM ON)
    endif ()

    if (ENABLE_WPE_PLATFORM_HEADLESS)
        SET_AND_EXPOSE_TO_BUILD(ENABLE_WPE_PLATFORM_HEADLESS ON)
        set(WPE_PLATFORM_HEADLESS ON)
    endif ()

    if (ENABLE_WPE_PLATFORM_WAYLAND)
        find_package(Wayland 1.20 REQUIRED)
        find_package(WaylandProtocols 1.24 REQUIRED)
        SET_AND_EXPOSE_TO_BUILD(ENABLE_WPE_PLATFORM_WAYLAND ON)
        set(WPE_PLATFORM_WAYLAND ON)
    endif ()

    if (ENABLE_GAMEPAD)
        find_package(Manette 0.2.4)
        if (Manette_FOUND)
            SET_AND_EXPOSE_TO_BUILD(USE_MANETTE TRUE)
        endif ()
    endif ()
else ()
    SET_AND_EXPOSE_TO_BUILD(ENABLE_WPE_PLATFORM_DRM OFF)
    SET_AND_EXPOSE_TO_BUILD(ENABLE_WPE_PLATFORM_HEADLESS OFF)
    SET_AND_EXPOSE_TO_BUILD(ENABLE_WPE_PLATFORM_WAYLAND OFF)
endif ()

if (ENABLE_WPE_QT_API)
    if (USE_QT6)
        set(WPE_MAJOR_QT_VERSION 6)
        if (NOT TARGET WrapOpenGL::WrapOpenGL)
            add_library(WrapOpenGL::WrapOpenGL INTERFACE IMPORTED)
            target_link_libraries(WrapOpenGL::WrapOpenGL INTERFACE Epoxy::Epoxy)
        endif ()
    else ()
        set(WPE_MAJOR_QT_VERSION 5)
        find_package(WPEBackendFDO 1.5.0 REQUIRED)
    endif ()
    find_package(Qt${WPE_MAJOR_QT_VERSION} REQUIRED COMPONENTS Core Quick Gui)
    find_package(Qt${WPE_MAJOR_QT_VERSION}Test REQUIRED)
endif ()

if (ENABLE_WEBXR)
    find_package(OpenXR 1.0.20)
    if (NOT OPENXR_FOUND)
        message(FATAL_ERROR "OpenXR is required to enable WebXR support.")
    endif ()
    SET_AND_EXPOSE_TO_BUILD(USE_OPENXR ${OpenXR_FOUND})
    SET_AND_EXPOSE_TO_BUILD(XR_USE_PLATFORM_EGL TRUE)
    SET_AND_EXPOSE_TO_BUILD(XR_USE_GRAPHICS_API_OPENGL_ES TRUE)
    SET_AND_EXPOSE_TO_BUILD(ENABLE_WEBXR_HANDS TRUE)
endif ()

if (USE_AVIF)
    find_package(AVIF 0.9.0)
    if (NOT AVIF_FOUND)
        message(FATAL_ERROR "libavif 0.9.0 is required for USE_AVIF.")
    endif ()
endif ()

if (ENABLE_JOURNALD_LOG)
    find_package(Journald)
    if (NOT Journald_FOUND)
        message(FATAL_ERROR "libsystemd or libelogind are needed for ENABLE_JOURNALD_LOG")
    endif ()
endif ()

if (ENABLE_ENCRYPTED_MEDIA AND ENABLE_THUNDER)
  find_package(Thunder REQUIRED)
endif ()

if (USE_LCMS)
    find_package(LCMS2)
    if (NOT LCMS2_FOUND)
        message(FATAL_ERROR "libcms2 is required for USE_LCMS.")
    endif ()
endif ()

if (ENABLE_BREAKPAD)
    find_package(Breakpad REQUIRED)
    if (NOT Breakpad_FOUND)
        message(FATAL_ERROR "breakpad enabled but not found.")
    endif ()
    if (BREAKPAD_MINIDUMP_DIR)
        add_definitions(-DBREAKPAD_MINIDUMP_DIR="${BREAKPAD_MINIDUMP_DIR}")
    else ()
        message(STATUS "BREAKPAD_MINIDUMP_DIR is not set")
    endif ()
endif ()

add_definitions(-DBUILDING_WPE__=1)
add_definitions(-DGETTEXT_PACKAGE="WPE")
add_definitions(-DJSC_GLIB_API_ENABLED)

if (USER_AGENT_BRANDING)
    add_definitions(-DUSER_AGENT_BRANDING=${USER_AGENT_BRANDING})
endif ()

if (NOT EXISTS "${TOOLS_DIR}/glib/apply-build-revision-to-files.py")
    set(BUILD_REVISION "tarball")
endif ()

SET_AND_EXPOSE_TO_BUILD(USE_ATSPI TRUE)
SET_AND_EXPOSE_TO_BUILD(USE_GCRYPT TRUE)
SET_AND_EXPOSE_TO_BUILD(USE_LIBEPOXY TRUE)
SET_AND_EXPOSE_TO_BUILD(USE_LIBWPE TRUE)
SET_AND_EXPOSE_TO_BUILD(USE_WPE_RENDERER TRUE)
SET_AND_EXPOSE_TO_BUILD(USE_XDGMIME TRUE)

if (WTF_CPU_ARM OR WTF_CPU_MIPS)
    SET_AND_EXPOSE_TO_BUILD(USE_CAPSTONE ${ENABLE_DEVELOPER_MODE})
endif ()

SET_AND_EXPOSE_TO_BUILD(USE_TEXTURE_MAPPER TRUE)
SET_AND_EXPOSE_TO_BUILD(USE_COORDINATED_GRAPHICS TRUE)
SET_AND_EXPOSE_TO_BUILD(USE_ANGLE ${ENABLE_WEBGL})
SET_AND_EXPOSE_TO_BUILD(USE_THEME_ADWAITA TRUE)
SET_AND_EXPOSE_TO_BUILD(HAVE_GL_FENCE TRUE)

if (USE_LIBDRM)
    find_package(LibDRM)
    if (NOT LibDRM_FOUND)
        message(FATAL_ERROR "libdrm is required for USE_LIBDRM")
    endif ()

    set(CMAKE_REQUIRED_LIBRARIES LibDRM::LibDRM)
    WEBKIT_CHECK_HAVE_FUNCTION(HAVE_DRM_GET_FORMAT_MODIFIER_VENDOR drmGetFormatModifierVendor xf86drm.h)
    WEBKIT_CHECK_HAVE_FUNCTION(HAVE_DRM_GET_FORMAT_MODIFIER_NAME drmGetFormatModifierName xf86drm.h)
    unset(CMAKE_REQUIRED_LIBRARIES)
endif ()

if (USE_GBM)
    find_package(GBM)
    if (NOT GBM_FOUND)
        message(FATAL_ERROR "GBM is required for USE_GBM")
    endif ()

    set(CMAKE_REQUIRED_LIBRARIES GBM::GBM)
    WEBKIT_CHECK_HAVE_FUNCTION(HAVE_GBM_BO_GET_FD_FOR_PLANE gbm_bo_get_fd_for_plane gbm.h)
    WEBKIT_CHECK_HAVE_FUNCTION(HAVE_GBM_BO_CREATE_WITH_MODIFIERS2 gbm_bo_create_with_modifiers2 gbm.h)
    unset(CMAKE_REQUIRED_LIBRARIES)
endif ()

if (USE_LIBBACKTRACE)
    find_package(LibBacktrace)
    if (NOT LIBBACKTRACE_FOUND)
        message(FATAL_ERROR "libbacktrace is required for USE_LIBBACKTRACE")
    endif ()
endif ()

if (ENABLE_MALLOC_HEAP_BREAKDOWN)
    set(MALLOC_HEAP_BREAKDOWN_LIBRARIES MallocHeapBreakdown)
endif ()

# Using DERIVED_SOURCES_DIR is deprecated
set(DERIVED_SOURCES_DIR "${CMAKE_BINARY_DIR}/DerivedSources")
set(DERIVED_SOURCES_WEBKIT_DIR ${DERIVED_SOURCES_DIR}/WebKit)
set(DERIVED_SOURCES_WPE_API_DIR ${DERIVED_SOURCES_WEBKIT_DIR}/wpe)
set(DERIVED_SOURCES_WPETOOLINGBACKENDS_DIR "${CMAKE_BINARY_DIR}/DerivedSources/WPEToolingBackends")

# Using FORWARDING_HEADERS_DIR is deprecated
set(FORWARDING_HEADERS_DIR ${DERIVED_SOURCES_DIR}/ForwardingHeaders)
set(FORWARDING_HEADERS_WPE_DIR ${FORWARDING_HEADERS_DIR}/wpe)
set(FORWARDING_HEADERS_WPE_EXTENSION_DIR ${FORWARDING_HEADERS_DIR}/wpe-web-process-extension)
set(FORWARDING_HEADERS_WPE_DOM_DIR ${FORWARDING_HEADERS_DIR}/wpe-dom)
set(FORWARDING_HEADERS_WPE_JSC_DIR ${FORWARDING_HEADERS_DIR}/wpe-jsc)

# FIXME: Remove in https://bugs.webkit.org/show_bug.cgi?id=210891
set(WebKit_FRAMEWORK_HEADERS_DIR ${FORWARDING_HEADERS_DIR})
set(WebKit_PRIVATE_FRAMEWORK_HEADERS_DIR ${FORWARDING_HEADERS_DIR})
set(WebKit_DERIVED_SOURCES_DIR "${CMAKE_BINARY_DIR}/DerivedSources/WebKit")
set(PAL_DERIVED_SOURCES_DIR "${CMAKE_BINARY_DIR}/DerivedSources/PAL")
set(PAL_FRAMEWORK_HEADERS_DIR "${CMAKE_BINARY_DIR}/PAL/Headers")
set(JavaScriptCore_FRAMEWORK_HEADERS_DIR "${CMAKE_BINARY_DIR}/JavaScriptCore/Headers")
set(JavaScriptCore_PRIVATE_FRAMEWORK_HEADERS_DIR "${CMAKE_BINARY_DIR}/JavaScriptCore/PrivateHeaders")
set(WTF_FRAMEWORK_HEADERS_DIR "${CMAKE_BINARY_DIR}/WTF/Headers")
set(WPEPlatform_DERIVED_SOURCES_DIR "${CMAKE_BINARY_DIR}/DerivedSources/WPEPlatform")

set(JavaScriptCoreGLib_FRAMEWORK_HEADERS_DIR "${CMAKE_BINARY_DIR}/JavaScriptCoreGLib/Headers")
set(JavaScriptCoreGLib_DERIVED_SOURCES_DIR "${CMAKE_BINARY_DIR}/JavaScriptCoreGLib/DerivedSources")

set(WPE_PKGCONFIG_FILE ${CMAKE_BINARY_DIR}/wpe-webkit-${WPE_API_VERSION}.pc)
set(WPE_Uninstalled_PKGCONFIG_FILE ${CMAKE_BINARY_DIR}/wpe-webkit-${WPE_API_VERSION}-uninstalled.pc)

if (ENABLE_2022_GLIB_API)
    set(WPE_WEB_PROCESS_EXTENSION_PC_MODULE "wpe-web-process-extension-${WPE_API_VERSION}")
else ()
    set(WPE_WEB_PROCESS_EXTENSION_PC_MODULE "wpe-web-extension-${WPE_API_VERSION}")
endif ()
EXPOSE_STRING_VARIABLE_TO_BUILD(WPE_WEB_PROCESS_EXTENSION_PC_MODULE)

set(WPEWebProcessExtension_PKGCONFIG_FILE ${CMAKE_BINARY_DIR}/${WPE_WEB_PROCESS_EXTENSION_PC_MODULE}.pc)
set(WPEWebProcessExtension_Uninstalled_PKGCONFIG_FILE ${CMAKE_BINARY_DIR}/${WPE_WEB_PROCESS_EXTENSION_PC_MODULE}-uninstalled.pc)

include(BubblewrapSandboxChecks)
include(GStreamerChecks)
