.TH Fotocx 1 2025-07-01 "Linux" "Fotocx man page"

.B NAME
   Fotocx - photo/image editor and collection manager

.B SHORT DESCRIPTION
   Organize and manage a large image collection. Edit and optimize photos and 
   other images, add special effects, edit metadata, search images, create a
   photomontage, perform batch operations. Fotocx is a GTK GUI application. 
   The included user manual explains Fotocx operation in great detail. 

.B LONG DESCRIPTION
      Fotocx is a free Linux program for editing photos or other images and 
   managing a large collection. Fotocx has powerful editing tools to correct 
   and enhance photos. Fotocx can instantly find desired images within a huge 
   collection, based on file/folder names or embedded metadata such as date, 
   keywords, title, description, rating, location ... any metadata.
      Image folders can be viewed as a scrolling gallery of thumbnail images. 
   Navigation of folders and subfolders is simple and fast. Click a thumbnail 
   for a full window view of the image. The image can be zoomed, panned and 
   scrolled using the mouse. Gallery thumbnails can vary from small to huge. 
   Popup windows can be used to view or compare multiple images at any scale. 
   Thumbnail galleries are also used for image search results and albums. 
   Albums are selected images arranged in a desired order. Fotocx has many 
   editing tools that go beyond the basics. Images with severe problems 
   (underexposed, false colors, blurred, uneven lighting, fog/haze) can be 
   brought back to life. Details lost in shadows or haze can be brought out. 
   Images with distorted perspective (esp. wide-angle views) can be corrected.
      Fotocx is standards compliant. Nothing done by Fotocx makes images less 
   usable with other applications. Fotocx uses your image files wherever they 
   are: they are not moved or duplicated. Fotocx does create an index for fast 
   image searching, and thumbnail images for fast gallery displays. These add 
   typically 2% to overall storage requirements. There is no database to 
   manage - the index manages itself. 
      Fotocx can import RAW images and perform all processing in deep color 
   (24 bits per color used internally). Edited images can be saved as JPEG, 
   TIFF (8/16 bits/color), or PNG (8/16 bits). Convert single RAW files or 
   selected batches (click thumbnails from gallery pages).
      Image edit functions are interactive with rapid visual feedback, using 
   the full image or a chosen zoom-in area. Undo and Redo can be applied 
   serially to all the edits of an image. Intermediate and final results can 
   be saved as new files or as new versions (e.g. filename.v02.jpg).
      Areas within an image can be selected and edited separately from the 
   background. Areas can be selected using several methods: drag the mouse 
   to select and flood into matching tones, follow feature edges, or outline 
   an area freehand. Complex feature edges, such as hair or foliage, can be 
   accurately selected. Selected areas can be copied and pasted into the same 
   or other images, resized, rotated, brightened, etc. 
      Layers are not used. Each edit step can be saved separately as a file 
   'version'. These can be re-used to make new versions. 
      An image can be "mouse painted" onto another image. Paint from a chosen 
   source image location to a chosen destination, with optional rescale.
      Batch functions are available to copy, move, rename, resize, upright, 
   convert format, convert RAW files, and add or revise metadata.
      Several tools are available to change size and shape: crop, rescale, 
   rotate, fix perspective, curve/warp the whole image or selected areas within 
   the image. There is a special tool to 'flatten' photos of curved surfaces, 
   e.g. a page from a thick book or a poster on a round column.
      Text can be added to an image. Any font and size can be used, any color, 
   any angle. The text can have variable transparency, an outline, a shadow, 
   or an embossed effect - good for a signature or copyright. Other basic 
   markups are available: lines, arrows, box, oval/circle.
      Advanced edit functions: Dust spots from old slides or photos can be 
   removed, roadside trash or power lines can be erased. Panoramas can be made 
   by stitching photos together seamlessly, automatically matching brightness 
   and color. Photos with a range of exposure values can be combined into an 
   HDR image with adjustable contributions. Photos with varying focus depths 
   can be combined into an image that is sharp over the combined range. Photos 
   of one scene taken at different moments can be combined to remove passing 
   autos or tourists. Multiple photos made under low light conditions can be 
   combined to reduce noise. Images and text can be combined into a mashup 
   (montage), using the mouse to position and resize the components and adjust
   overlaps and transparencies.
      Fotocx has a batch scripting tool to speed the processing of multiple 
   images requiring the same edits: record the edits made to a base image and 
   then apply these edits automatically to any number of selected images.
      Many special effects ('filters') are available to convert a photo into a 
   line drawing, sketch, painting, embossing, cartoon, dithered image, mosaic, 
   or abstract patterns. Background patterns and textures can be added.
      Images can be rapidly searched using file and folder names or partial 
   names, dates, assigned tags, ratings, locations, and any other metadata 
   stored in the image. Some data is automatic from the camera (date, location, 
   exposure data), and other data can be manually entered (tags, captions ...). 
   Search criteria can be used in combination; e.g. find Chicago photos for 
   years 2008-2020 containing tags 'Barbara' or 'Barbie'.
      Locations (from a camera GPS sensor or entered manually) can also be 
   searched. You can view a map of any region in the world, at any scale, 
   using an internet map service. Images having location data show as markers 
   on these maps. Click a marker to get a gallery of the corresponding images. 
   You can jump from a given photo to its location on a world map, where you 
   can find other photos from the same or nearby locations.
      Albums can be made using selected images from your collection. The files 
   are not duplicated. Select images by clicking gallery thumbnails. Arrange 
   the images with drag and drop. Albums can be made into slide shows. Choose 
   animated transitions between images, pan and zoom effects, and places to 
   auto-pause for narration.
      Fotocx includes a comprehensive user manual, also used for interactive 
   help: press F1 while using any function in Fotocx to see the corresponding
   topic. You should take the time to read the overview pages. The function 
   details can be viewed as needed using F1. 

.B CAPABILITIES LIST
 • Organize and manage a very large photo/image collection. 
 • Comprehensive user guide and popup context help via F1 key.
 • Thumbnail browser/navigator with variable thumb size and metadata view.
 • Click thumbnail for full-size view, image zoom in/out and pan/scroll.
 • RAW file conversion, single or batch, output with 8 or 16 bits per color.
 • Large set of functions to edit, repair, refine, and transform images.
 • Internal processing in 24 bits per color (float), output in 8 or 16 bits.
 • Edited files have a version number, originals are retained by default.
 • Fast edit visual feedback using the full image or selected zoom-in area.
 • Undo/Redo button - compare original/edited versions (instant replace). 
 • Conventional edit functions: rotate, upright, crop, rescale, add margins,
   retouch: brightness/color/contrast/saturation/temperature/white balance,
   markup: text (decorative features)/lines/arrows/boxes/circles/ellipses,
   edit colors using RGB or HSL, convert B&W/color/negative/positive/sepia.
 • Repair functions: sharpen, blur selected areas, denoise, defog, red eyes,
   smart erase (remove spoilers), remove halos, suppress JPEG artifacts,
   anti-alias (suppress jaggies), remove dust spots, fix color fringes.
 • Refine functions: edit or flatten brightness histogram (enhance detail),
   increase local contrast (enhance detail), match colors to master image, 
   add soft focus, amplify existing contrast, global and local retinex,
   add brightness ramp in any direction, add/remove vignette (via curve edit).
 • Special effect conversions: sketch, outlines, cartoon, emboss, painting,
   tiles, texture, pattern, dither (5 modes), engrave, mosaic, shift colors,
   add noise (hide color bands), set no. of colors (per RGB), alien colors.
 • Warp image: unbend (wide-angle photos, panoramas), warp selected area,
   fix perspective (photo from an angle), warp image (linear/curved/affine),
   unwarp closeup (fix balloon face), add waves, twist image, make sphere, 
   turn inside-out, tiny planet, escher spiral, flatten curved horizon,
   flatten photo of curved surface (thick book page, poster on a column).
 • Edit functions can be 'painted' locally and gradually, using the mouse.
 • Copy areas within and across images by mouse painting and blending.
 • Create or maintain transparent image areas while editing.
 • Combine images: HDR (combine bright/dark images, adjust contributions), 
   HDF (combine different focus depths), stack/layer combinations by area,
   panorama (2-6 images), make an array or matrix of many images.
 • Mashup: arrange images and text in an arbitrary layout using the mouse.
   (objects can be resized, rotated, overlapped with transparent areas ...)
 • Custom user menu: collect frequently used functions into one menu.
 • Plugins: use Gimp, Imagemagic ... as embedded Fotocx edit functions.
 • Scripts: record image edits, package as an edit function to re-use.
 • Select image objects or areas to edit separately from the background:
   outline by hand, follow feature edges, 'flood' into matching colors ...
 • Complex feature edges can be accurately selected (e.g. hair, foliage).
 • Batch tools: rename, resize, convert, export, add/revise/report metadata,
   convert RAW files, add overlay text, apply custom edit script.
 • Metadata edit and report (tags, dates, titles, geotags ... any metadata).
 • Search images using any metadata and folder/file names or partial names:
   dates, tags, locations, ratings, titles, descriptions, exposure data ...
 • Show a list of images by location and date range, click for image gallery.
 • Show an image calendar, click on year or month for a gallery of images.
 • Scalable internet map, click on marker for gallery of images at location.
 • Add location names and geocoordinates to an image by clicking on the map.
 • View 360 degree panorama image (Google Street View format).
 • Show video files as thumbnails (using any video frame), play video.
 • Show animated GIF files as thumbnails (first frame), play animation.
 • Bookmarks: assign names to folder/file locations, go to name (gallery).
 • Create albums with chosen images arranged by drag & drop. No duplication.
 • Slide show: show album images with animated transitions and pan/zoom.
 • Print an image at any scale. Printer color calibration tool is available.
 • Custom keyboard shortcuts can be assigned to chosen functions.
 • Cycle wallpaper images from a Fotocx album or any folder of image files.
 • Source and binary packages are installable on most recent Linux flavors.
 • Gnu GPL3 license (everything is free to use as you please). 

.B SEE ALSO
   The User Guide is available from the menu Help > User Guide 
   The home page for Fotocx is at https://kornelix.net

.B AUTHORS
   Written by Mike Cornelison <mkornelix@gmail.com>

