// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;
using System.Runtime.CompilerServices;
using Xunit;

public sealed class NamedSet
{
    public NamedSet(HashSet<string> set, string value)
    {
        Set = set;
        Value = value;
    }
    public HashSet<string> Set;
    public string Value;
}

public class Runtime_88091
{
    [Fact]
    public static void Test() => Problem(data);

    // We may mistakenly CSE item.Count here
    //
    [MethodImpl(MethodImplOptions.NoInlining)]
    static void Problem(List<NamedSet>[] list)
    {
        for (var index = 0; index < list.Length; index++)
        {
            var item = list[index];
            var repeatCheck = true;

            while (repeatCheck)
            {
                repeatCheck = false;
                for (var i = item.Count - 2; i >= 0; i--)
                {
                    if (item[i].Set.Count == 0)
                    {
                        repeatCheck = true;
                        break;
                    }
                    DoWork(item, i);
                }
            }

            for (var i = item.Count - 2; i >= 0; i--)
            {
                for (var j = i - 1; j >= 0; j--)
                {
                    if (IsSubsetOf(item, j, i))
                    {
                        item.RemoveAt(i);
                        break;
                    }
                }
            }
        }
    }

    [MethodImpl(MethodImplOptions.NoInlining)]
    static bool IsSubsetOf(List<NamedSet> variantSetAndValueTupleList, int j, int i) => 
        variantSetAndValueTupleList[j].Set.IsSubsetOf(variantSetAndValueTupleList[i].Set);

    [MethodImpl(MethodImplOptions.NoInlining)]
    static void DoWork(List<NamedSet> variantSetAndValueTupleList, int i)
    {
        if (variantSetAndValueTupleList[i].Value != variantSetAndValueTupleList[i + 1].Value)
            return;

        if (variantSetAndValueTupleList[i + 1].Set.Count == 0)
            variantSetAndValueTupleList.RemoveAt(i);
    }

    internal static List<NamedSet>[] data =
    {
        new List<NamedSet> { new(new HashSet<string>{}, "0") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "2"),new(new HashSet<string>{"3"}, "2"),new(new HashSet<string>{"4","5"}, "2"),new(new HashSet<string>{"6","7"}, "2"),new(new HashSet<string>{"8","9","10","11"}, "12"),new(new HashSet<string>{"8","13","10","11"}, "12"),new(new HashSet<string>{"8","9","11","14"}, "12"),new(new HashSet<string>{"8","13","11","14"}, "12"),new(new HashSet<string>{"8","15","10","16"}, "12"),new(new HashSet<string>{"8","15","16","14"}, "12"),new(new HashSet<string>{"6"}, "2"),new(new HashSet<string>{"8","17","18","19","20"}, "12"),new(new HashSet<string>{"8","17","19","11"}, "12"),new(new HashSet<string>{}, "2") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "21"),new(new HashSet<string>{"18","20","3"}, "22"),new(new HashSet<string>{"11","3"}, "22"),new(new HashSet<string>{"3"}, "21"),new(new HashSet<string>{"18","4","20","5"}, "22"),new(new HashSet<string>{"4","11","5"}, "22"),new(new HashSet<string>{"4","5"}, "21"),new(new HashSet<string>{"6","7"}, "21"),new(new HashSet<string>{"8","9","10","11"}, "21"),new(new HashSet<string>{"8","13","10","11"}, "21"),new(new HashSet<string>{"8","9","11","14"}, "21"),new(new HashSet<string>{"8","13","11","14"}, "21"),new(new HashSet<string>{"8","15","10","16"}, "21"),new(new HashSet<string>{"8","15","16","14"}, "21"),new(new HashSet<string>{"8","23","9","11","6"}, "22"),new(new HashSet<string>{"6"}, "21"),new(new HashSet<string>{"8","17","18","19","20"}, "21"),new(new HashSet<string>{"8","17","19","11"}, "21"),new(new HashSet<string>{"8","17","19","24"}, "22"),new(new HashSet<string>{"17","24"}, "22"),new(new HashSet<string>{"17"}, "22"),new(new HashSet<string>{}, "25") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "26"),new(new HashSet<string>{"18","20","3"}, "27"),new(new HashSet<string>{"11","3"}, "27"),new(new HashSet<string>{"3"}, "26"),new(new HashSet<string>{"18","4","20","5"}, "27"),new(new HashSet<string>{"4","11","5"}, "27"),new(new HashSet<string>{"4","5"}, "26"),new(new HashSet<string>{"6","7"}, "27"),new(new HashSet<string>{"8","9","10","11"}, "27"),new(new HashSet<string>{"8","13","10","11"}, "27"),new(new HashSet<string>{"8","9","11","14"}, "27"),new(new HashSet<string>{"8","13","11","14"}, "27"),new(new HashSet<string>{"8","15","10","16"}, "27"),new(new HashSet<string>{"8","15","16","14"}, "27"),new(new HashSet<string>{"8","23","9","11","6"}, "22"),new(new HashSet<string>{"6"}, "27"),new(new HashSet<string>{"8","17","18","19","20"}, "27"),new(new HashSet<string>{"8","17","19","11"}, "27"),new(new HashSet<string>{"8","17","19","24"}, "22"),new(new HashSet<string>{"17","24"}, "22"),new(new HashSet<string>{"17"}, "22"),new(new HashSet<string>{}, "26") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "28"),new(new HashSet<string>{"18","20","3"}, "22"),new(new HashSet<string>{"11","3"}, "22"),new(new HashSet<string>{"3"}, "28"),new(new HashSet<string>{"18","4","20","5"}, "22"),new(new HashSet<string>{"4","11","5"}, "22"),new(new HashSet<string>{"4","5"}, "28"),new(new HashSet<string>{"6","7"}, "28"),new(new HashSet<string>{"8","9","10","11"}, "28"),new(new HashSet<string>{"8","13","10","11"}, "28"),new(new HashSet<string>{"8","9","11","14"}, "28"),new(new HashSet<string>{"8","13","11","14"}, "28"),new(new HashSet<string>{"8","15","10","16"}, "28"),new(new HashSet<string>{"8","15","16","14"}, "28"),new(new HashSet<string>{"8","23","9","11","6"}, "22"),new(new HashSet<string>{"6"}, "28"),new(new HashSet<string>{"8","17","18","19","20"}, "28"),new(new HashSet<string>{"8","17","19","11"}, "28"),new(new HashSet<string>{"8","17","19","24"}, "22"),new(new HashSet<string>{"17","24"}, "22"),new(new HashSet<string>{"17"}, "22"),new(new HashSet<string>{}, "21") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "29"),new(new HashSet<string>{"18","20","3"}, "22"),new(new HashSet<string>{"11","3"}, "22"),new(new HashSet<string>{"3"}, "29"),new(new HashSet<string>{"18","4","20","5"}, "22"),new(new HashSet<string>{"4","11","5"}, "22"),new(new HashSet<string>{"4","5"}, "29"),new(new HashSet<string>{"8","23","9","11","6"}, "22"),new(new HashSet<string>{"8","17","19","24"}, "22"),new(new HashSet<string>{"17","24"}, "22"),new(new HashSet<string>{"17"}, "22"),new(new HashSet<string>{}, "25") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "30"),new(new HashSet<string>{"18","20","3"}, "30"),new(new HashSet<string>{"11","3"}, "30"),new(new HashSet<string>{"3"}, "30"),new(new HashSet<string>{"18","4","20","5"}, "30"),new(new HashSet<string>{"4","11","5"}, "30"),new(new HashSet<string>{"4","5"}, "30"),new(new HashSet<string>{"6","7"}, "30"),new(new HashSet<string>{"8","9","10","11"}, "30"),new(new HashSet<string>{"8","13","10","11"}, "30"),new(new HashSet<string>{"8","9","11","14"}, "30"),new(new HashSet<string>{"8","13","11","14"}, "30"),new(new HashSet<string>{"8","15","10","16"}, "30"),new(new HashSet<string>{"8","15","16","14"}, "30"),new(new HashSet<string>{"8","23","9","11","6"}, "30"),new(new HashSet<string>{"6"}, "30"),new(new HashSet<string>{"8","17","18","19","20"}, "30"),new(new HashSet<string>{"8","17","19","11"}, "30"),new(new HashSet<string>{"8","17","19","24"}, "30"),new(new HashSet<string>{"17","24"}, "30"),new(new HashSet<string>{"17"}, "30"),new(new HashSet<string>{}, "31") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "32"),new(new HashSet<string>{"18","20","3"}, "33"),new(new HashSet<string>{"11","3"}, "33"),new(new HashSet<string>{"3"}, "32"),new(new HashSet<string>{"18","4","20","5"}, "33"),new(new HashSet<string>{"4","11","5"}, "33"),new(new HashSet<string>{"4","5"}, "32"),new(new HashSet<string>{"6","7"}, "32"),new(new HashSet<string>{"8","9","10","11"}, "33"),new(new HashSet<string>{"8","13","10","11"}, "33"),new(new HashSet<string>{"8","9","11","14"}, "33"),new(new HashSet<string>{"8","13","11","14"}, "33"),new(new HashSet<string>{"8","15","10","16"}, "33"),new(new HashSet<string>{"8","15","16","14"}, "33"),new(new HashSet<string>{"8","23","9","11","6"}, "33"),new(new HashSet<string>{"6"}, "32"),new(new HashSet<string>{"8","17","18","19","20"}, "33"),new(new HashSet<string>{"8","17","19","11"}, "33"),new(new HashSet<string>{"8","17","19","24"}, "33"),new(new HashSet<string>{"17","24"}, "33"),new(new HashSet<string>{"17"}, "33"),new(new HashSet<string>{}, "33") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "32"),new(new HashSet<string>{"18","20","3"}, "30"),new(new HashSet<string>{"11","3"}, "30"),new(new HashSet<string>{"3"}, "32"),new(new HashSet<string>{"18","4","20","5"}, "30"),new(new HashSet<string>{"4","11","5"}, "30"),new(new HashSet<string>{"4","5"}, "32"),new(new HashSet<string>{"6","7"}, "30"),new(new HashSet<string>{"8","9","10","11"}, "31"),new(new HashSet<string>{"8","13","10","11"}, "31"),new(new HashSet<string>{"8","9","11","14"}, "31"),new(new HashSet<string>{"8","13","11","14"}, "31"),new(new HashSet<string>{"8","15","10","16"}, "31"),new(new HashSet<string>{"8","15","16","14"}, "31"),new(new HashSet<string>{"8","23","9","11","6"}, "30"),new(new HashSet<string>{"6"}, "30"),new(new HashSet<string>{"8","17","18","19","20"}, "31"),new(new HashSet<string>{"8","17","19","11"}, "31"),new(new HashSet<string>{"8","17","19","24"}, "30"),new(new HashSet<string>{"17","24"}, "30"),new(new HashSet<string>{"17"}, "30"),new(new HashSet<string>{}, "30") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "31"),new(new HashSet<string>{"18","20","3"}, "34"),new(new HashSet<string>{"11","3"}, "34"),new(new HashSet<string>{"3"}, "31"),new(new HashSet<string>{"18","4","20","5"}, "34"),new(new HashSet<string>{"4","11","5"}, "34"),new(new HashSet<string>{"4","5"}, "31"),new(new HashSet<string>{"6","7"}, "31"),new(new HashSet<string>{"8","9","10","11"}, "31"),new(new HashSet<string>{"8","13","10","11"}, "31"),new(new HashSet<string>{"8","9","11","14"}, "31"),new(new HashSet<string>{"8","13","11","14"}, "31"),new(new HashSet<string>{"8","15","10","16"}, "31"),new(new HashSet<string>{"8","15","16","14"}, "31"),new(new HashSet<string>{"8","23","9","11","6"}, "34"),new(new HashSet<string>{"6"}, "31"),new(new HashSet<string>{"8","17","18","19","20"}, "31"),new(new HashSet<string>{"8","17","19","11"}, "31"),new(new HashSet<string>{"8","17","19","24"}, "34"),new(new HashSet<string>{"17","24"}, "34"),new(new HashSet<string>{"17"}, "34"),new(new HashSet<string>{}, "34") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "30"),new(new HashSet<string>{"11","3"}, "30"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "30"),new(new HashSet<string>{"4","11","5"}, "30"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "35"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "30"),new(new HashSet<string>{"6"}, "35"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "31"),new(new HashSet<string>{"17","24"}, "31"),new(new HashSet<string>{"17"}, "31"),new(new HashSet<string>{}, "31") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "35"),new(new HashSet<string>{"11","3"}, "35"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "35"),new(new HashSet<string>{"4","11","5"}, "35"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "35"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "35"),new(new HashSet<string>{"6"}, "35"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "36"),new(new HashSet<string>{"17","24"}, "36"),new(new HashSet<string>{"17"}, "35"),new(new HashSet<string>{}, "35") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "30"),new(new HashSet<string>{"18","20","3"}, "35"),new(new HashSet<string>{"11","3"}, "35"),new(new HashSet<string>{"3"}, "30"),new(new HashSet<string>{"18","4","20","5"}, "35"),new(new HashSet<string>{"4","11","5"}, "35"),new(new HashSet<string>{"4","5"}, "30"),new(new HashSet<string>{"6","7"}, "30"),new(new HashSet<string>{"8","9","10","11"}, "30"),new(new HashSet<string>{"8","13","10","11"}, "30"),new(new HashSet<string>{"8","9","11","14"}, "30"),new(new HashSet<string>{"8","13","11","14"}, "30"),new(new HashSet<string>{"8","15","10","16"}, "30"),new(new HashSet<string>{"8","15","16","14"}, "30"),new(new HashSet<string>{"8","23","9","11","6"}, "31"),new(new HashSet<string>{"6"}, "30"),new(new HashSet<string>{"8","17","18","19","20"}, "30"),new(new HashSet<string>{"8","17","19","11"}, "30"),new(new HashSet<string>{"8","17","19","24"}, "36"),new(new HashSet<string>{"17","24"}, "36"),new(new HashSet<string>{"17"}, "35"),new(new HashSet<string>{}, "37") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "38"),new(new HashSet<string>{"18","20","3"}, "39"),new(new HashSet<string>{"11","3"}, "39"),new(new HashSet<string>{"3"}, "38"),new(new HashSet<string>{"18","4","20","5"}, "39"),new(new HashSet<string>{"4","11","5"}, "39"),new(new HashSet<string>{"4","5"}, "38"),new(new HashSet<string>{"6","7"}, "38"),new(new HashSet<string>{"8","9","10","11"}, "38"),new(new HashSet<string>{"8","13","10","11"}, "38"),new(new HashSet<string>{"8","9","11","14"}, "38"),new(new HashSet<string>{"8","13","11","14"}, "38"),new(new HashSet<string>{"8","15","10","16"}, "38"),new(new HashSet<string>{"8","15","16","14"}, "38"),new(new HashSet<string>{"8","23","9","11","6"}, "39"),new(new HashSet<string>{"6"}, "38"),new(new HashSet<string>{"8","17","18","19","20"}, "38"),new(new HashSet<string>{"8","17","19","11"}, "38"),new(new HashSet<string>{"8","17","19","24"}, "39"),new(new HashSet<string>{"17","24"}, "39"),new(new HashSet<string>{"17"}, "39"),new(new HashSet<string>{}, "39") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "39"),new(new HashSet<string>{"18","20","3"}, "36"),new(new HashSet<string>{"11","3"}, "36"),new(new HashSet<string>{"3"}, "39"),new(new HashSet<string>{"18","4","20","5"}, "36"),new(new HashSet<string>{"4","11","5"}, "36"),new(new HashSet<string>{"4","5"}, "39"),new(new HashSet<string>{"6","7"}, "35"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "36"),new(new HashSet<string>{"6"}, "35"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "36"),new(new HashSet<string>{"17","24"}, "36"),new(new HashSet<string>{"17"}, "36"),new(new HashSet<string>{}, "36") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "35"),new(new HashSet<string>{"11","3"}, "35"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "35"),new(new HashSet<string>{"4","11","5"}, "35"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "35"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "35"),new(new HashSet<string>{"6"}, "35"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "36"),new(new HashSet<string>{"17","24"}, "36"),new(new HashSet<string>{"17"}, "36"),new(new HashSet<string>{}, "36") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "39"),new(new HashSet<string>{"18","20","3"}, "39"),new(new HashSet<string>{"11","3"}, "39"),new(new HashSet<string>{"3"}, "39"),new(new HashSet<string>{"18","4","20","5"}, "39"),new(new HashSet<string>{"4","11","5"}, "39"),new(new HashSet<string>{"4","5"}, "39"),new(new HashSet<string>{"6","7"}, "39"),new(new HashSet<string>{"8","9","10","11"}, "39"),new(new HashSet<string>{"8","13","10","11"}, "39"),new(new HashSet<string>{"8","9","11","14"}, "39"),new(new HashSet<string>{"8","13","11","14"}, "39"),new(new HashSet<string>{"8","15","10","16"}, "39"),new(new HashSet<string>{"8","15","16","14"}, "39"),new(new HashSet<string>{"8","23","9","11","6"}, "39"),new(new HashSet<string>{"6"}, "39"),new(new HashSet<string>{"8","17","18","19","20"}, "39"),new(new HashSet<string>{"8","17","19","11"}, "39"),new(new HashSet<string>{"8","17","19","24"}, "39"),new(new HashSet<string>{"17","24"}, "38"),new(new HashSet<string>{"17"}, "39"),new(new HashSet<string>{}, "39") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "39"),new(new HashSet<string>{"18","20","3"}, "40"),new(new HashSet<string>{"11","3"}, "40"),new(new HashSet<string>{"3"}, "39"),new(new HashSet<string>{"18","4","20","5"}, "40"),new(new HashSet<string>{"4","11","5"}, "40"),new(new HashSet<string>{"4","5"}, "39"),new(new HashSet<string>{"6","7"}, "39"),new(new HashSet<string>{"8","9","10","11"}, "39"),new(new HashSet<string>{"8","13","10","11"}, "39"),new(new HashSet<string>{"8","9","11","14"}, "39"),new(new HashSet<string>{"8","13","11","14"}, "39"),new(new HashSet<string>{"8","15","10","16"}, "39"),new(new HashSet<string>{"8","15","16","14"}, "39"),new(new HashSet<string>{"8","23","9","11","6"}, "40"),new(new HashSet<string>{"6"}, "39"),new(new HashSet<string>{"8","17","18","19","20"}, "39"),new(new HashSet<string>{"8","17","19","11"}, "39"),new(new HashSet<string>{"8","17","19","24"}, "40"),new(new HashSet<string>{"17","24"}, "40"),new(new HashSet<string>{"17"}, "40"),new(new HashSet<string>{}, "41") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "42"),new(new HashSet<string>{"18","20","3"}, "31"),new(new HashSet<string>{"11","3"}, "31"),new(new HashSet<string>{"3"}, "42"),new(new HashSet<string>{"18","4","20","5"}, "31"),new(new HashSet<string>{"4","11","5"}, "31"),new(new HashSet<string>{"4","5"}, "42"),new(new HashSet<string>{"6","7"}, "42"),new(new HashSet<string>{"8","9","10","11"}, "42"),new(new HashSet<string>{"8","13","10","11"}, "42"),new(new HashSet<string>{"8","9","11","14"}, "42"),new(new HashSet<string>{"8","13","11","14"}, "42"),new(new HashSet<string>{"8","15","10","16"}, "42"),new(new HashSet<string>{"8","15","16","14"}, "42"),new(new HashSet<string>{"8","23","9","11","6"}, "31"),new(new HashSet<string>{"6"}, "42"),new(new HashSet<string>{"8","17","18","19","20"}, "42"),new(new HashSet<string>{"8","17","19","11"}, "42"),new(new HashSet<string>{"8","17","19","24"}, "36"),new(new HashSet<string>{"17","24"}, "36"),new(new HashSet<string>{"17"}, "36"),new(new HashSet<string>{}, "42") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "36"),new(new HashSet<string>{"18","20","3"}, "36"),new(new HashSet<string>{"11","3"}, "36"),new(new HashSet<string>{"3"}, "36"),new(new HashSet<string>{"18","4","20","5"}, "36"),new(new HashSet<string>{"4","11","5"}, "36"),new(new HashSet<string>{"4","5"}, "36"),new(new HashSet<string>{"6","7"}, "36"),new(new HashSet<string>{"8","9","10","11"}, "36"),new(new HashSet<string>{"8","13","10","11"}, "36"),new(new HashSet<string>{"8","9","11","14"}, "36"),new(new HashSet<string>{"8","13","11","14"}, "36"),new(new HashSet<string>{"8","15","10","16"}, "36"),new(new HashSet<string>{"8","15","16","14"}, "36"),new(new HashSet<string>{"8","23","9","11","6"}, "36"),new(new HashSet<string>{"6"}, "36"),new(new HashSet<string>{"8","17","18","19","20"}, "36"),new(new HashSet<string>{"8","17","19","11"}, "36"),new(new HashSet<string>{"8","17","19","24"}, "36"),new(new HashSet<string>{"17","24"}, "43"),new(new HashSet<string>{"17"}, "36"),new(new HashSet<string>{}, "36") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "36"),new(new HashSet<string>{"11","3"}, "36"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "36"),new(new HashSet<string>{"4","11","5"}, "36"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "44"),new(new HashSet<string>{"8","9","10","11"}, "44"),new(new HashSet<string>{"8","13","10","11"}, "44"),new(new HashSet<string>{"8","9","11","14"}, "44"),new(new HashSet<string>{"8","13","11","14"}, "44"),new(new HashSet<string>{"8","15","10","16"}, "44"),new(new HashSet<string>{"8","15","16","14"}, "44"),new(new HashSet<string>{"8","23","9","11","6"}, "36"),new(new HashSet<string>{"6"}, "44"),new(new HashSet<string>{"8","17","18","19","20"}, "44"),new(new HashSet<string>{"8","17","19","11"}, "44"),new(new HashSet<string>{"8","17","19","24"}, "36"),new(new HashSet<string>{"17","24"}, "36"),new(new HashSet<string>{"17"}, "36"),new(new HashSet<string>{}, "36") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "45"),new(new HashSet<string>{"18","20","3"}, "45"),new(new HashSet<string>{"11","3"}, "45"),new(new HashSet<string>{"3"}, "45"),new(new HashSet<string>{"18","4","20","5"}, "45"),new(new HashSet<string>{"4","11","5"}, "45"),new(new HashSet<string>{"4","5"}, "45"),new(new HashSet<string>{"6","7"}, "45"),new(new HashSet<string>{"8","9","10","11"}, "45"),new(new HashSet<string>{"8","13","10","11"}, "45"),new(new HashSet<string>{"8","9","11","14"}, "45"),new(new HashSet<string>{"8","13","11","14"}, "45"),new(new HashSet<string>{"8","15","10","16"}, "45"),new(new HashSet<string>{"8","15","16","14"}, "45"),new(new HashSet<string>{"8","23","9","11","6"}, "45"),new(new HashSet<string>{"6"}, "45"),new(new HashSet<string>{"8","17","18","19","20"}, "45"),new(new HashSet<string>{"8","17","19","11"}, "45"),new(new HashSet<string>{"8","17","19","24"}, "46"),new(new HashSet<string>{"17","24"}, "45"),new(new HashSet<string>{"17"}, "47"),new(new HashSet<string>{}, "47") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "39"),new(new HashSet<string>{"18","20","3"}, "39"),new(new HashSet<string>{"11","3"}, "39"),new(new HashSet<string>{"3"}, "39"),new(new HashSet<string>{"18","4","20","5"}, "39"),new(new HashSet<string>{"4","11","5"}, "39"),new(new HashSet<string>{"4","5"}, "39"),new(new HashSet<string>{"6","7"}, "48"),new(new HashSet<string>{"8","9","10","11"}, "48"),new(new HashSet<string>{"8","13","10","11"}, "48"),new(new HashSet<string>{"8","9","11","14"}, "48"),new(new HashSet<string>{"8","13","11","14"}, "48"),new(new HashSet<string>{"8","15","10","16"}, "48"),new(new HashSet<string>{"8","15","16","14"}, "48"),new(new HashSet<string>{"8","23","9","11","6"}, "39"),new(new HashSet<string>{"6"}, "48"),new(new HashSet<string>{"8","17","18","19","20"}, "48"),new(new HashSet<string>{"8","17","19","11"}, "48"),new(new HashSet<string>{"8","17","19","24"}, "39"),new(new HashSet<string>{"17","24"}, "39"),new(new HashSet<string>{"17"}, "39"),new(new HashSet<string>{}, "49") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "40"),new(new HashSet<string>{"18","20","3"}, "39"),new(new HashSet<string>{"11","3"}, "39"),new(new HashSet<string>{"3"}, "40"),new(new HashSet<string>{"18","4","20","5"}, "39"),new(new HashSet<string>{"4","11","5"}, "39"),new(new HashSet<string>{"4","5"}, "40"),new(new HashSet<string>{"6","7"}, "40"),new(new HashSet<string>{"8","9","10","11"}, "40"),new(new HashSet<string>{"8","13","10","11"}, "40"),new(new HashSet<string>{"8","9","11","14"}, "40"),new(new HashSet<string>{"8","13","11","14"}, "40"),new(new HashSet<string>{"8","15","10","16"}, "40"),new(new HashSet<string>{"8","15","16","14"}, "40"),new(new HashSet<string>{"8","23","9","11","6"}, "39"),new(new HashSet<string>{"6"}, "40"),new(new HashSet<string>{"8","17","18","19","20"}, "40"),new(new HashSet<string>{"8","17","19","11"}, "40"),new(new HashSet<string>{"8","17","19","24"}, "39"),new(new HashSet<string>{"17","24"}, "39"),new(new HashSet<string>{"17"}, "39"),new(new HashSet<string>{}, "39") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "50"),new(new HashSet<string>{"18","20","3"}, "50"),new(new HashSet<string>{"11","3"}, "50"),new(new HashSet<string>{"3"}, "50"),new(new HashSet<string>{"18","4","20","5"}, "50"),new(new HashSet<string>{"4","11","5"}, "50"),new(new HashSet<string>{"4","5"}, "50"),new(new HashSet<string>{"6","7"}, "50"),new(new HashSet<string>{"8","9","10","11"}, "50"),new(new HashSet<string>{"8","13","10","11"}, "50"),new(new HashSet<string>{"8","9","11","14"}, "50"),new(new HashSet<string>{"8","13","11","14"}, "50"),new(new HashSet<string>{"8","15","10","16"}, "50"),new(new HashSet<string>{"8","15","16","14"}, "50"),new(new HashSet<string>{"8","23","9","11","6"}, "50"),new(new HashSet<string>{"6"}, "50"),new(new HashSet<string>{"8","17","18","19","20"}, "50"),new(new HashSet<string>{"8","17","19","11"}, "50"),new(new HashSet<string>{"8","17","19","24"}, "51"),new(new HashSet<string>{"17","24"}, "50"),new(new HashSet<string>{"17"}, "50"),new(new HashSet<string>{}, "51") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "46"),new(new HashSet<string>{"18","20","3"}, "46"),new(new HashSet<string>{"11","3"}, "46"),new(new HashSet<string>{"3"}, "46"),new(new HashSet<string>{"18","4","20","5"}, "46"),new(new HashSet<string>{"4","11","5"}, "46"),new(new HashSet<string>{"4","5"}, "46"),new(new HashSet<string>{"6","7"}, "46"),new(new HashSet<string>{"8","9","10","11"}, "46"),new(new HashSet<string>{"8","13","10","11"}, "46"),new(new HashSet<string>{"8","9","11","14"}, "46"),new(new HashSet<string>{"8","13","11","14"}, "46"),new(new HashSet<string>{"8","15","10","16"}, "46"),new(new HashSet<string>{"8","15","16","14"}, "46"),new(new HashSet<string>{"8","23","9","11","6"}, "46"),new(new HashSet<string>{"6"}, "46"),new(new HashSet<string>{"8","17","18","19","20"}, "46"),new(new HashSet<string>{"8","17","19","11"}, "46"),new(new HashSet<string>{"8","17","19","24"}, "46"),new(new HashSet<string>{"17","24"}, "47"),new(new HashSet<string>{"17"}, "46"),new(new HashSet<string>{}, "46") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "52"),new(new HashSet<string>{"18","20","3"}, "53"),new(new HashSet<string>{"11","3"}, "53"),new(new HashSet<string>{"3"}, "52"),new(new HashSet<string>{"18","4","20","5"}, "53"),new(new HashSet<string>{"4","11","5"}, "53"),new(new HashSet<string>{"4","5"}, "52"),new(new HashSet<string>{"6","7"}, "54"),new(new HashSet<string>{"8","9","10","11"}, "54"),new(new HashSet<string>{"8","13","10","11"}, "54"),new(new HashSet<string>{"8","9","11","14"}, "54"),new(new HashSet<string>{"8","13","11","14"}, "54"),new(new HashSet<string>{"8","15","10","16"}, "54"),new(new HashSet<string>{"8","15","16","14"}, "54"),new(new HashSet<string>{"8","23","9","11","6"}, "53"),new(new HashSet<string>{"6"}, "54"),new(new HashSet<string>{"8","17","18","19","20"}, "54"),new(new HashSet<string>{"8","17","19","11"}, "54"),new(new HashSet<string>{"8","17","19","24"}, "53"),new(new HashSet<string>{"17","24"}, "53"),new(new HashSet<string>{"17"}, "53"),new(new HashSet<string>{}, "55") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "56"),new(new HashSet<string>{"18","20","3"}, "57"),new(new HashSet<string>{"11","3"}, "57"),new(new HashSet<string>{"3"}, "56"),new(new HashSet<string>{"18","4","20","5"}, "57"),new(new HashSet<string>{"4","11","5"}, "57"),new(new HashSet<string>{"4","5"}, "56"),new(new HashSet<string>{"6","7"}, "56"),new(new HashSet<string>{"8","9","10","11"}, "56"),new(new HashSet<string>{"8","13","10","11"}, "56"),new(new HashSet<string>{"8","9","11","14"}, "56"),new(new HashSet<string>{"8","13","11","14"}, "56"),new(new HashSet<string>{"8","15","10","16"}, "56"),new(new HashSet<string>{"8","15","16","14"}, "56"),new(new HashSet<string>{"8","23","9","11","6"}, "58"),new(new HashSet<string>{"6"}, "56"),new(new HashSet<string>{"8","17","18","19","20"}, "56"),new(new HashSet<string>{"8","17","19","11"}, "56"),new(new HashSet<string>{"8","17","19","24"}, "58"),new(new HashSet<string>{"17","24"}, "58"),new(new HashSet<string>{"17"}, "58"),new(new HashSet<string>{}, "57") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "41"),new(new HashSet<string>{"18","20","3"}, "59"),new(new HashSet<string>{"11","3"}, "59"),new(new HashSet<string>{"3"}, "41"),new(new HashSet<string>{"18","4","20","5"}, "59"),new(new HashSet<string>{"4","11","5"}, "59"),new(new HashSet<string>{"4","5"}, "41"),new(new HashSet<string>{"6","7"}, "41"),new(new HashSet<string>{"8","9","10","11"}, "48"),new(new HashSet<string>{"8","13","10","11"}, "48"),new(new HashSet<string>{"8","9","11","14"}, "48"),new(new HashSet<string>{"8","13","11","14"}, "48"),new(new HashSet<string>{"8","15","10","16"}, "48"),new(new HashSet<string>{"8","15","16","14"}, "48"),new(new HashSet<string>{"8","23","9","11","6"}, "59"),new(new HashSet<string>{"6"}, "41"),new(new HashSet<string>{"8","17","18","19","20"}, "48"),new(new HashSet<string>{"8","17","19","11"}, "48"),new(new HashSet<string>{"8","17","19","24"}, "39"),new(new HashSet<string>{"17","24"}, "39"),new(new HashSet<string>{"17"}, "39"),new(new HashSet<string>{}, "60") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "48"),new(new HashSet<string>{"18","20","3"}, "61"),new(new HashSet<string>{"11","3"}, "61"),new(new HashSet<string>{"3"}, "48"),new(new HashSet<string>{"18","4","20","5"}, "61"),new(new HashSet<string>{"4","11","5"}, "61"),new(new HashSet<string>{"4","5"}, "48"),new(new HashSet<string>{"6","7"}, "48"),new(new HashSet<string>{"8","9","10","11"}, "48"),new(new HashSet<string>{"8","13","10","11"}, "48"),new(new HashSet<string>{"8","9","11","14"}, "48"),new(new HashSet<string>{"8","13","11","14"}, "48"),new(new HashSet<string>{"8","15","10","16"}, "48"),new(new HashSet<string>{"8","15","16","14"}, "48"),new(new HashSet<string>{"8","23","9","11","6"}, "61"),new(new HashSet<string>{"6"}, "48"),new(new HashSet<string>{"8","17","18","19","20"}, "48"),new(new HashSet<string>{"8","17","19","11"}, "48"),new(new HashSet<string>{"8","17","19","24"}, "61"),new(new HashSet<string>{"17","24"}, "61"),new(new HashSet<string>{"17"}, "61"),new(new HashSet<string>{}, "35") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "48"),new(new HashSet<string>{"18","20","3"}, "48"),new(new HashSet<string>{"11","3"}, "48"),new(new HashSet<string>{"3"}, "48"),new(new HashSet<string>{"18","4","20","5"}, "48"),new(new HashSet<string>{"4","11","5"}, "48"),new(new HashSet<string>{"4","5"}, "48"),new(new HashSet<string>{"6","7"}, "48"),new(new HashSet<string>{"8","9","10","11"}, "48"),new(new HashSet<string>{"8","13","10","11"}, "48"),new(new HashSet<string>{"8","9","11","14"}, "48"),new(new HashSet<string>{"8","13","11","14"}, "48"),new(new HashSet<string>{"8","15","10","16"}, "48"),new(new HashSet<string>{"8","15","16","14"}, "48"),new(new HashSet<string>{"8","23","9","11","6"}, "48"),new(new HashSet<string>{"6"}, "48"),new(new HashSet<string>{"8","17","18","19","20"}, "48"),new(new HashSet<string>{"8","17","19","11"}, "48"),new(new HashSet<string>{"8","17","19","24"}, "39"),new(new HashSet<string>{"17","24"}, "39"),new(new HashSet<string>{"17"}, "39"),new(new HashSet<string>{}, "48") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "32"),new(new HashSet<string>{"18","20","3"}, "36"),new(new HashSet<string>{"11","3"}, "36"),new(new HashSet<string>{"3"}, "32"),new(new HashSet<string>{"18","4","20","5"}, "36"),new(new HashSet<string>{"4","11","5"}, "36"),new(new HashSet<string>{"4","5"}, "32"),new(new HashSet<string>{"6","7"}, "32"),new(new HashSet<string>{"8","9","10","11"}, "32"),new(new HashSet<string>{"8","13","10","11"}, "32"),new(new HashSet<string>{"8","9","11","14"}, "32"),new(new HashSet<string>{"8","13","11","14"}, "32"),new(new HashSet<string>{"8","15","10","16"}, "32"),new(new HashSet<string>{"8","15","16","14"}, "32"),new(new HashSet<string>{"8","23","9","11","6"}, "36"),new(new HashSet<string>{"6"}, "32"),new(new HashSet<string>{"8","17","18","19","20"}, "32"),new(new HashSet<string>{"8","17","19","11"}, "32"),new(new HashSet<string>{"8","17","19","24"}, "33"),new(new HashSet<string>{"17","24"}, "33"),new(new HashSet<string>{"17"}, "33"),new(new HashSet<string>{}, "36") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "30"),new(new HashSet<string>{"18","20","3"}, "36"),new(new HashSet<string>{"11","3"}, "36"),new(new HashSet<string>{"3"}, "30"),new(new HashSet<string>{"18","4","20","5"}, "36"),new(new HashSet<string>{"4","11","5"}, "36"),new(new HashSet<string>{"4","5"}, "30"),new(new HashSet<string>{"6","7"}, "30"),new(new HashSet<string>{"8","9","10","11"}, "30"),new(new HashSet<string>{"8","13","10","11"}, "30"),new(new HashSet<string>{"8","9","11","14"}, "30"),new(new HashSet<string>{"8","13","11","14"}, "30"),new(new HashSet<string>{"8","15","10","16"}, "30"),new(new HashSet<string>{"8","15","16","14"}, "30"),new(new HashSet<string>{"8","23","9","11","6"}, "36"),new(new HashSet<string>{"6"}, "30"),new(new HashSet<string>{"8","17","18","19","20"}, "30"),new(new HashSet<string>{"8","17","19","11"}, "30"),new(new HashSet<string>{"8","17","19","24"}, "36"),new(new HashSet<string>{"17","24"}, "36"),new(new HashSet<string>{"17"}, "36"),new(new HashSet<string>{}, "39") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "44"),new(new HashSet<string>{"18","20","3"}, "32"),new(new HashSet<string>{"11","3"}, "32"),new(new HashSet<string>{"3"}, "44"),new(new HashSet<string>{"18","4","20","5"}, "32"),new(new HashSet<string>{"4","11","5"}, "32"),new(new HashSet<string>{"4","5"}, "44"),new(new HashSet<string>{"6","7"}, "44"),new(new HashSet<string>{"8","9","10","11"}, "44"),new(new HashSet<string>{"8","13","10","11"}, "44"),new(new HashSet<string>{"8","9","11","14"}, "44"),new(new HashSet<string>{"8","13","11","14"}, "44"),new(new HashSet<string>{"8","15","10","16"}, "44"),new(new HashSet<string>{"8","15","16","14"}, "44"),new(new HashSet<string>{"8","23","9","11","6"}, "32"),new(new HashSet<string>{"6"}, "44"),new(new HashSet<string>{"8","17","18","19","20"}, "44"),new(new HashSet<string>{"8","17","19","11"}, "44"),new(new HashSet<string>{"8","17","19","24"}, "32"),new(new HashSet<string>{"17","24"}, "32"),new(new HashSet<string>{"17"}, "32"),new(new HashSet<string>{}, "32") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "32"),new(new HashSet<string>{"18","20","3"}, "32"),new(new HashSet<string>{"11","3"}, "32"),new(new HashSet<string>{"3"}, "32"),new(new HashSet<string>{"18","4","20","5"}, "32"),new(new HashSet<string>{"4","11","5"}, "32"),new(new HashSet<string>{"4","5"}, "32"),new(new HashSet<string>{"6","7"}, "32"),new(new HashSet<string>{"8","9","10","11"}, "32"),new(new HashSet<string>{"8","13","10","11"}, "32"),new(new HashSet<string>{"8","9","11","14"}, "32"),new(new HashSet<string>{"8","13","11","14"}, "32"),new(new HashSet<string>{"8","15","10","16"}, "32"),new(new HashSet<string>{"8","15","16","14"}, "32"),new(new HashSet<string>{"8","23","9","11","6"}, "32"),new(new HashSet<string>{"6"}, "32"),new(new HashSet<string>{"8","17","18","19","20"}, "32"),new(new HashSet<string>{"8","17","19","11"}, "32"),new(new HashSet<string>{"8","17","19","24"}, "33"),new(new HashSet<string>{"17","24"}, "33"),new(new HashSet<string>{"17"}, "33"),new(new HashSet<string>{}, "36") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "37"),new(new HashSet<string>{"18","20","3"}, "30"),new(new HashSet<string>{"11","3"}, "30"),new(new HashSet<string>{"3"}, "37"),new(new HashSet<string>{"18","4","20","5"}, "30"),new(new HashSet<string>{"4","11","5"}, "30"),new(new HashSet<string>{"4","5"}, "37"),new(new HashSet<string>{"6","7"}, "44"),new(new HashSet<string>{"8","9","10","11"}, "44"),new(new HashSet<string>{"8","13","10","11"}, "44"),new(new HashSet<string>{"8","9","11","14"}, "44"),new(new HashSet<string>{"8","13","11","14"}, "44"),new(new HashSet<string>{"8","15","10","16"}, "44"),new(new HashSet<string>{"8","15","16","14"}, "44"),new(new HashSet<string>{"8","23","9","11","6"}, "30"),new(new HashSet<string>{"6"}, "44"),new(new HashSet<string>{"8","17","18","19","20"}, "44"),new(new HashSet<string>{"8","17","19","11"}, "44"),new(new HashSet<string>{"8","17","19","24"}, "31"),new(new HashSet<string>{"17","24"}, "31"),new(new HashSet<string>{"17"}, "31"),new(new HashSet<string>{}, "30") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "62"),new(new HashSet<string>{"18","20","3"}, "62"),new(new HashSet<string>{"11","3"}, "62"),new(new HashSet<string>{"3"}, "62"),new(new HashSet<string>{"18","4","20","5"}, "62"),new(new HashSet<string>{"4","11","5"}, "62"),new(new HashSet<string>{"4","5"}, "62"),new(new HashSet<string>{"6","7"}, "62"),new(new HashSet<string>{"8","9","10","11"}, "62"),new(new HashSet<string>{"8","13","10","11"}, "62"),new(new HashSet<string>{"8","9","11","14"}, "62"),new(new HashSet<string>{"8","13","11","14"}, "62"),new(new HashSet<string>{"8","15","10","16"}, "62"),new(new HashSet<string>{"8","15","16","14"}, "62"),new(new HashSet<string>{"8","23","9","11","6"}, "36"),new(new HashSet<string>{"6"}, "62"),new(new HashSet<string>{"8","17","18","19","20"}, "62"),new(new HashSet<string>{"8","17","19","11"}, "62"),new(new HashSet<string>{"8","17","19","24"}, "36"),new(new HashSet<string>{"17","24"}, "36"),new(new HashSet<string>{"17"}, "36"),new(new HashSet<string>{}, "62") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "30"),new(new HashSet<string>{"11","3"}, "30"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "30"),new(new HashSet<string>{"4","11","5"}, "30"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "44"),new(new HashSet<string>{"8","9","10","11"}, "48"),new(new HashSet<string>{"8","13","10","11"}, "48"),new(new HashSet<string>{"8","9","11","14"}, "48"),new(new HashSet<string>{"8","13","11","14"}, "48"),new(new HashSet<string>{"8","15","10","16"}, "48"),new(new HashSet<string>{"8","15","16","14"}, "48"),new(new HashSet<string>{"8","23","9","11","6"}, "30"),new(new HashSet<string>{"6"}, "44"),new(new HashSet<string>{"8","17","18","19","20"}, "48"),new(new HashSet<string>{"8","17","19","11"}, "48"),new(new HashSet<string>{"8","17","19","24"}, "30"),new(new HashSet<string>{"17","24"}, "30"),new(new HashSet<string>{"17"}, "30"),new(new HashSet<string>{}, "30") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "63"),new(new HashSet<string>{"18","20","3"}, "32"),new(new HashSet<string>{"11","3"}, "32"),new(new HashSet<string>{"3"}, "63"),new(new HashSet<string>{"18","4","20","5"}, "32"),new(new HashSet<string>{"4","11","5"}, "32"),new(new HashSet<string>{"4","5"}, "63"),new(new HashSet<string>{"6","7"}, "32"),new(new HashSet<string>{"8","9","10","11"}, "33"),new(new HashSet<string>{"8","13","10","11"}, "33"),new(new HashSet<string>{"8","9","11","14"}, "33"),new(new HashSet<string>{"8","13","11","14"}, "33"),new(new HashSet<string>{"8","15","10","16"}, "33"),new(new HashSet<string>{"8","15","16","14"}, "33"),new(new HashSet<string>{"8","23","9","11","6"}, "32"),new(new HashSet<string>{"6"}, "32"),new(new HashSet<string>{"8","17","18","19","20"}, "33"),new(new HashSet<string>{"8","17","19","11"}, "33"),new(new HashSet<string>{"8","17","19","24"}, "32"),new(new HashSet<string>{"17","24"}, "32"),new(new HashSet<string>{"17"}, "32"),new(new HashSet<string>{}, "32") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "59"),new(new HashSet<string>{"11","3"}, "59"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "59"),new(new HashSet<string>{"4","11","5"}, "59"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "35"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "59"),new(new HashSet<string>{"6"}, "35"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "30"),new(new HashSet<string>{"17","24"}, "30"),new(new HashSet<string>{"17"}, "30"),new(new HashSet<string>{}, "37") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "60"),new(new HashSet<string>{"11","3"}, "60"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "60"),new(new HashSet<string>{"4","11","5"}, "60"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "44"),new(new HashSet<string>{"8","9","10","11"}, "44"),new(new HashSet<string>{"8","13","10","11"}, "44"),new(new HashSet<string>{"8","9","11","14"}, "44"),new(new HashSet<string>{"8","13","11","14"}, "44"),new(new HashSet<string>{"8","15","10","16"}, "44"),new(new HashSet<string>{"8","15","16","14"}, "44"),new(new HashSet<string>{"8","23","9","11","6"}, "60"),new(new HashSet<string>{"6"}, "44"),new(new HashSet<string>{"8","17","18","19","20"}, "44"),new(new HashSet<string>{"8","17","19","11"}, "44"),new(new HashSet<string>{"8","17","19","24"}, "60"),new(new HashSet<string>{"17","24"}, "60"),new(new HashSet<string>{"17"}, "60"),new(new HashSet<string>{}, "60") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "48"),new(new HashSet<string>{"18","20","3"}, "60"),new(new HashSet<string>{"11","3"}, "60"),new(new HashSet<string>{"3"}, "48"),new(new HashSet<string>{"18","4","20","5"}, "60"),new(new HashSet<string>{"4","11","5"}, "60"),new(new HashSet<string>{"4","5"}, "48"),new(new HashSet<string>{"6","7"}, "48"),new(new HashSet<string>{"8","9","10","11"}, "48"),new(new HashSet<string>{"8","13","10","11"}, "48"),new(new HashSet<string>{"8","9","11","14"}, "48"),new(new HashSet<string>{"8","13","11","14"}, "48"),new(new HashSet<string>{"8","15","10","16"}, "48"),new(new HashSet<string>{"8","15","16","14"}, "48"),new(new HashSet<string>{"8","23","9","11","6"}, "60"),new(new HashSet<string>{"6"}, "48"),new(new HashSet<string>{"8","17","18","19","20"}, "48"),new(new HashSet<string>{"8","17","19","11"}, "48"),new(new HashSet<string>{"8","17","19","24"}, "60"),new(new HashSet<string>{"17","24"}, "60"),new(new HashSet<string>{"17"}, "60"),new(new HashSet<string>{}, "60") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "37"),new(new HashSet<string>{"11","3"}, "37"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "37"),new(new HashSet<string>{"4","11","5"}, "37"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "35"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "37"),new(new HashSet<string>{"6"}, "35"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "37"),new(new HashSet<string>{"17","24"}, "37"),new(new HashSet<string>{"17"}, "37"),new(new HashSet<string>{}, "37") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "37"),new(new HashSet<string>{"18","20","3"}, "39"),new(new HashSet<string>{"11","3"}, "39"),new(new HashSet<string>{"3"}, "37"),new(new HashSet<string>{"18","4","20","5"}, "39"),new(new HashSet<string>{"4","11","5"}, "39"),new(new HashSet<string>{"4","5"}, "37"),new(new HashSet<string>{"6","7"}, "37"),new(new HashSet<string>{"8","9","10","11"}, "37"),new(new HashSet<string>{"8","13","10","11"}, "37"),new(new HashSet<string>{"8","9","11","14"}, "37"),new(new HashSet<string>{"8","13","11","14"}, "37"),new(new HashSet<string>{"8","15","10","16"}, "37"),new(new HashSet<string>{"8","15","16","14"}, "37"),new(new HashSet<string>{"8","23","9","11","6"}, "39"),new(new HashSet<string>{"6"}, "37"),new(new HashSet<string>{"8","17","18","19","20"}, "37"),new(new HashSet<string>{"8","17","19","11"}, "37"),new(new HashSet<string>{"8","17","19","24"}, "37"),new(new HashSet<string>{"17","24"}, "37"),new(new HashSet<string>{"17"}, "37"),new(new HashSet<string>{}, "60") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "37"),new(new HashSet<string>{"11","3"}, "37"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "37"),new(new HashSet<string>{"4","11","5"}, "37"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "35"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "37"),new(new HashSet<string>{"6"}, "35"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "37"),new(new HashSet<string>{"17","24"}, "37"),new(new HashSet<string>{"17"}, "37"),new(new HashSet<string>{}, "37") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "39"),new(new HashSet<string>{"18","20","3"}, "39"),new(new HashSet<string>{"11","3"}, "39"),new(new HashSet<string>{"3"}, "39"),new(new HashSet<string>{"18","4","20","5"}, "39"),new(new HashSet<string>{"4","11","5"}, "39"),new(new HashSet<string>{"4","5"}, "39"),new(new HashSet<string>{"6","7"}, "39"),new(new HashSet<string>{"8","9","10","11"}, "39"),new(new HashSet<string>{"8","13","10","11"}, "39"),new(new HashSet<string>{"8","9","11","14"}, "39"),new(new HashSet<string>{"8","13","11","14"}, "39"),new(new HashSet<string>{"8","15","10","16"}, "39"),new(new HashSet<string>{"8","15","16","14"}, "39"),new(new HashSet<string>{"8","23","9","11","6"}, "39"),new(new HashSet<string>{"6"}, "39"),new(new HashSet<string>{"8","17","18","19","20"}, "39"),new(new HashSet<string>{"8","17","19","11"}, "39"),new(new HashSet<string>{"8","17","19","24"}, "64"),new(new HashSet<string>{"17","24"}, "64"),new(new HashSet<string>{"17"}, "39"),new(new HashSet<string>{}, "39") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "65"),new(new HashSet<string>{"11","3"}, "65"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "65"),new(new HashSet<string>{"4","11","5"}, "65"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "35"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "65"),new(new HashSet<string>{"6"}, "35"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "65"),new(new HashSet<string>{"17","24"}, "65"),new(new HashSet<string>{"17"}, "65"),new(new HashSet<string>{}, "66") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "38"),new(new HashSet<string>{"18","20","3"}, "30"),new(new HashSet<string>{"11","3"}, "30"),new(new HashSet<string>{"3"}, "38"),new(new HashSet<string>{"18","4","20","5"}, "30"),new(new HashSet<string>{"4","11","5"}, "30"),new(new HashSet<string>{"4","5"}, "38"),new(new HashSet<string>{"6","7"}, "44"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "30"),new(new HashSet<string>{"6"}, "44"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "30"),new(new HashSet<string>{"17","24"}, "30"),new(new HashSet<string>{"17"}, "30"),new(new HashSet<string>{}, "30") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "38"),new(new HashSet<string>{"18","20","3"}, "35"),new(new HashSet<string>{"11","3"}, "35"),new(new HashSet<string>{"3"}, "38"),new(new HashSet<string>{"18","4","20","5"}, "35"),new(new HashSet<string>{"4","11","5"}, "35"),new(new HashSet<string>{"4","5"}, "38"),new(new HashSet<string>{"6","7"}, "38"),new(new HashSet<string>{"8","9","10","11"}, "48"),new(new HashSet<string>{"8","13","10","11"}, "48"),new(new HashSet<string>{"8","9","11","14"}, "48"),new(new HashSet<string>{"8","13","11","14"}, "48"),new(new HashSet<string>{"8","15","10","16"}, "48"),new(new HashSet<string>{"8","15","16","14"}, "48"),new(new HashSet<string>{"8","23","9","11","6"}, "35"),new(new HashSet<string>{"6"}, "38"),new(new HashSet<string>{"8","17","18","19","20"}, "48"),new(new HashSet<string>{"8","17","19","11"}, "48"),new(new HashSet<string>{"8","17","19","24"}, "35"),new(new HashSet<string>{"17","24"}, "35"),new(new HashSet<string>{"17"}, "35"),new(new HashSet<string>{}, "35") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "32"),new(new HashSet<string>{"18","20","3"}, "32"),new(new HashSet<string>{"11","3"}, "32"),new(new HashSet<string>{"3"}, "32"),new(new HashSet<string>{"18","4","20","5"}, "32"),new(new HashSet<string>{"4","11","5"}, "32"),new(new HashSet<string>{"4","5"}, "32"),new(new HashSet<string>{"6","7"}, "32"),new(new HashSet<string>{"8","9","10","11"}, "63"),new(new HashSet<string>{"8","13","10","11"}, "63"),new(new HashSet<string>{"8","9","11","14"}, "63"),new(new HashSet<string>{"8","13","11","14"}, "63"),new(new HashSet<string>{"8","15","10","16"}, "63"),new(new HashSet<string>{"8","15","16","14"}, "63"),new(new HashSet<string>{"8","23","9","11","6"}, "32"),new(new HashSet<string>{"6"}, "32"),new(new HashSet<string>{"8","17","18","19","20"}, "63"),new(new HashSet<string>{"8","17","19","11"}, "63"),new(new HashSet<string>{"8","17","19","24"}, "32"),new(new HashSet<string>{"17","24"}, "32"),new(new HashSet<string>{"17"}, "32"),new(new HashSet<string>{}, "32") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "67"),new(new HashSet<string>{"18","20","3"}, "68"),new(new HashSet<string>{"11","3"}, "68"),new(new HashSet<string>{"3"}, "67"),new(new HashSet<string>{"18","4","20","5"}, "68"),new(new HashSet<string>{"4","11","5"}, "68"),new(new HashSet<string>{"4","5"}, "67"),new(new HashSet<string>{"6","7"}, "67"),new(new HashSet<string>{"8","9","10","11"}, "67"),new(new HashSet<string>{"8","13","10","11"}, "67"),new(new HashSet<string>{"8","9","11","14"}, "67"),new(new HashSet<string>{"8","13","11","14"}, "67"),new(new HashSet<string>{"8","15","10","16"}, "67"),new(new HashSet<string>{"8","15","16","14"}, "67"),new(new HashSet<string>{"8","23","9","11","6"}, "68"),new(new HashSet<string>{"6"}, "67"),new(new HashSet<string>{"8","17","18","19","20"}, "67"),new(new HashSet<string>{"8","17","19","11"}, "67"),new(new HashSet<string>{"8","17","19","24"}, "68"),new(new HashSet<string>{"17","24"}, "68"),new(new HashSet<string>{"17"}, "68"),new(new HashSet<string>{}, "69") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "44"),new(new HashSet<string>{"18","20","3"}, "63"),new(new HashSet<string>{"11","3"}, "63"),new(new HashSet<string>{"3"}, "44"),new(new HashSet<string>{"18","4","20","5"}, "63"),new(new HashSet<string>{"4","11","5"}, "63"),new(new HashSet<string>{"4","5"}, "44"),new(new HashSet<string>{"6","7"}, "44"),new(new HashSet<string>{"8","9","10","11"}, "70"),new(new HashSet<string>{"8","13","10","11"}, "70"),new(new HashSet<string>{"8","9","11","14"}, "70"),new(new HashSet<string>{"8","13","11","14"}, "70"),new(new HashSet<string>{"8","15","10","16"}, "70"),new(new HashSet<string>{"8","15","16","14"}, "70"),new(new HashSet<string>{"8","23","9","11","6"}, "63"),new(new HashSet<string>{"6"}, "44"),new(new HashSet<string>{"8","17","18","19","20"}, "70"),new(new HashSet<string>{"8","17","19","11"}, "70"),new(new HashSet<string>{"8","17","19","24"}, "63"),new(new HashSet<string>{"17","24"}, "63"),new(new HashSet<string>{"17"}, "63"),new(new HashSet<string>{}, "71") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "72"),new(new HashSet<string>{"18","20","3"}, "73"),new(new HashSet<string>{"11","3"}, "73"),new(new HashSet<string>{"3"}, "72"),new(new HashSet<string>{"18","4","20","5"}, "73"),new(new HashSet<string>{"4","11","5"}, "73"),new(new HashSet<string>{"4","5"}, "72"),new(new HashSet<string>{"6","7"}, "72"),new(new HashSet<string>{"8","9","10","11"}, "72"),new(new HashSet<string>{"8","13","10","11"}, "72"),new(new HashSet<string>{"8","9","11","14"}, "72"),new(new HashSet<string>{"8","13","11","14"}, "72"),new(new HashSet<string>{"8","15","10","16"}, "72"),new(new HashSet<string>{"8","15","16","14"}, "72"),new(new HashSet<string>{"8","23","9","11","6"}, "73"),new(new HashSet<string>{"6"}, "72"),new(new HashSet<string>{"8","17","18","19","20"}, "72"),new(new HashSet<string>{"8","17","19","11"}, "72"),new(new HashSet<string>{"8","17","19","24"}, "73"),new(new HashSet<string>{"17","24"}, "73"),new(new HashSet<string>{"17"}, "73"),new(new HashSet<string>{}, "73") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "59"),new(new HashSet<string>{"11","3"}, "59"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "59"),new(new HashSet<string>{"4","11","5"}, "59"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "35"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "59"),new(new HashSet<string>{"6"}, "35"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "31"),new(new HashSet<string>{"17","24"}, "31"),new(new HashSet<string>{"17"}, "31"),new(new HashSet<string>{}, "32") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "37"),new(new HashSet<string>{"11","3"}, "37"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "37"),new(new HashSet<string>{"4","11","5"}, "37"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "35"),new(new HashSet<string>{"8","9","10","11"}, "35"),new(new HashSet<string>{"8","13","10","11"}, "35"),new(new HashSet<string>{"8","9","11","14"}, "35"),new(new HashSet<string>{"8","13","11","14"}, "35"),new(new HashSet<string>{"8","15","10","16"}, "35"),new(new HashSet<string>{"8","15","16","14"}, "35"),new(new HashSet<string>{"8","23","9","11","6"}, "37"),new(new HashSet<string>{"6"}, "35"),new(new HashSet<string>{"8","17","18","19","20"}, "35"),new(new HashSet<string>{"8","17","19","11"}, "35"),new(new HashSet<string>{"8","17","19","24"}, "30"),new(new HashSet<string>{"17","24"}, "30"),new(new HashSet<string>{"17"}, "30"),new(new HashSet<string>{}, "37") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "35"),new(new HashSet<string>{"18","20","3"}, "37"),new(new HashSet<string>{"11","3"}, "37"),new(new HashSet<string>{"3"}, "35"),new(new HashSet<string>{"18","4","20","5"}, "37"),new(new HashSet<string>{"4","11","5"}, "37"),new(new HashSet<string>{"4","5"}, "35"),new(new HashSet<string>{"6","7"}, "44"),new(new HashSet<string>{"8","9","10","11"}, "44"),new(new HashSet<string>{"8","13","10","11"}, "44"),new(new HashSet<string>{"8","9","11","14"}, "44"),new(new HashSet<string>{"8","13","11","14"}, "44"),new(new HashSet<string>{"8","15","10","16"}, "44"),new(new HashSet<string>{"8","15","16","14"}, "44"),new(new HashSet<string>{"8","23","9","11","6"}, "37"),new(new HashSet<string>{"6"}, "44"),new(new HashSet<string>{"8","17","18","19","20"}, "44"),new(new HashSet<string>{"8","17","19","11"}, "44"),new(new HashSet<string>{"8","17","19","24"}, "37"),new(new HashSet<string>{"17","24"}, "37"),new(new HashSet<string>{"17"}, "37"),new(new HashSet<string>{}, "37") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "48"),new(new HashSet<string>{"18","20","3"}, "37"),new(new HashSet<string>{"11","3"}, "37"),new(new HashSet<string>{"3"}, "48"),new(new HashSet<string>{"18","4","20","5"}, "37"),new(new HashSet<string>{"4","11","5"}, "37"),new(new HashSet<string>{"4","5"}, "48"),new(new HashSet<string>{"6","7"}, "48"),new(new HashSet<string>{"8","9","10","11"}, "48"),new(new HashSet<string>{"8","13","10","11"}, "48"),new(new HashSet<string>{"8","9","11","14"}, "48"),new(new HashSet<string>{"8","13","11","14"}, "48"),new(new HashSet<string>{"8","15","10","16"}, "48"),new(new HashSet<string>{"8","15","16","14"}, "48"),new(new HashSet<string>{"8","23","9","11","6"}, "37"),new(new HashSet<string>{"6"}, "48"),new(new HashSet<string>{"8","17","18","19","20"}, "48"),new(new HashSet<string>{"8","17","19","11"}, "48"),new(new HashSet<string>{"8","17","19","24"}, "37"),new(new HashSet<string>{"17","24"}, "37"),new(new HashSet<string>{"17"}, "37"),new(new HashSet<string>{}, "37") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "37"),new(new HashSet<string>{"18","20","3"}, "37"),new(new HashSet<string>{"11","3"}, "37"),new(new HashSet<string>{"3"}, "37"),new(new HashSet<string>{"18","4","20","5"}, "37"),new(new HashSet<string>{"4","11","5"}, "37"),new(new HashSet<string>{"4","5"}, "37"),new(new HashSet<string>{"6","7"}, "37"),new(new HashSet<string>{"8","9","10","11"}, "37"),new(new HashSet<string>{"8","13","10","11"}, "37"),new(new HashSet<string>{"8","9","11","14"}, "37"),new(new HashSet<string>{"8","13","11","14"}, "37"),new(new HashSet<string>{"8","15","10","16"}, "37"),new(new HashSet<string>{"8","15","16","14"}, "37"),new(new HashSet<string>{"8","23","9","11","6"}, "48"),new(new HashSet<string>{"6"}, "37"),new(new HashSet<string>{"8","17","18","19","20"}, "37"),new(new HashSet<string>{"8","17","19","11"}, "37"),new(new HashSet<string>{"8","17","19","24"}, "48"),new(new HashSet<string>{"17","24"}, "48"),new(new HashSet<string>{"17"}, "48"),new(new HashSet<string>{}, "37") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "30"),new(new HashSet<string>{"18","20","3"}, "30"),new(new HashSet<string>{"11","3"}, "30"),new(new HashSet<string>{"3"}, "30"),new(new HashSet<string>{"18","4","20","5"}, "30"),new(new HashSet<string>{"4","11","5"}, "30"),new(new HashSet<string>{"4","5"}, "30"),new(new HashSet<string>{"6","7"}, "30"),new(new HashSet<string>{"8","9","10","11"}, "30"),new(new HashSet<string>{"8","13","10","11"}, "30"),new(new HashSet<string>{"8","9","11","14"}, "30"),new(new HashSet<string>{"8","13","11","14"}, "30"),new(new HashSet<string>{"8","15","10","16"}, "30"),new(new HashSet<string>{"8","15","16","14"}, "30"),new(new HashSet<string>{"8","23","9","11","6"}, "30"),new(new HashSet<string>{"6"}, "30"),new(new HashSet<string>{"8","17","18","19","20"}, "30"),new(new HashSet<string>{"8","17","19","11"}, "30"),new(new HashSet<string>{"8","17","19","24"}, "30"),new(new HashSet<string>{"17","24"}, "30"),new(new HashSet<string>{"17"}, "30"),new(new HashSet<string>{}, "37") },
        new List<NamedSet> { new(new HashSet<string>{"1"}, "74"),new(new HashSet<string>{"18","20","3"}, "75"),new(new HashSet<string>{"11","3"}, "75"),new(new HashSet<string>{"3"}, "74"),new(new HashSet<string>{"18","4","20","5"}, "75"),new(new HashSet<string>{"4","11","5"}, "75"),new(new HashSet<string>{"4","5"}, "74"),new(new HashSet<string>{"6","7"}, "74"),new(new HashSet<string>{"8","9","10","11"}, "74"),new(new HashSet<string>{"8","13","10","11"}, "74"),new(new HashSet<string>{"8","9","11","14"}, "74"),new(new HashSet<string>{"8","13","11","14"}, "74"),new(new HashSet<string>{"8","15","10","16"}, "74"),new(new HashSet<string>{"8","15","16","14"}, "74"),new(new HashSet<string>{"8","23","9","11","6"}, "76"),new(new HashSet<string>{"6"}, "74"),new(new HashSet<string>{"8","17","18","19","20"}, "74"),new(new HashSet<string>{"8","17","19","11"}, "74"),new(new HashSet<string>{"8","17","19","24"}, "76"),new(new HashSet<string>{"17","24"}, "77"),new(new HashSet<string>{"17"}, "76"),new(new HashSet<string>{}, "78") },
    };
}
