/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Action;
import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.Macros;
import JFlex.Out;
import JFlex.RegExp;
import JFlex.SemCheck;
import java.util.Enumeration;
import java.util.Vector;

public class RegExps {
    Vector lines;
    Vector states = new Vector();
    Vector regExps = new Vector();
    Vector actions = new Vector();
    Vector BOL = new Vector();
    Vector look = new Vector();
    Vector look_entry;
    int gen_look_count;

    public RegExps() {
        this.lines = new Vector();
        this.look_entry = new Vector();
    }

    public int insert(int line, Vector stateList, RegExp regExp, Action action, Boolean isBOL, RegExp lookAhead) {
        this.states.addElement(stateList);
        this.regExps.addElement(regExp);
        this.actions.addElement(action);
        this.BOL.addElement(isBOL);
        this.look.addElement(lookAhead);
        this.lines.addElement(new Integer(line));
        this.look_entry.addElement(null);
        return this.states.size() - 1;
    }

    public int insert(Vector stateList, Action action) {
        this.states.addElement(stateList);
        this.regExps.addElement(null);
        this.actions.addElement(action);
        this.BOL.addElement(null);
        this.look.addElement(null);
        this.lines.addElement(null);
        this.look_entry.addElement(null);
        return this.states.size() - 1;
    }

    public void addStates(int regNum, Vector newStates) {
        Enumeration s = newStates.elements();
        while (s.hasMoreElements()) {
            ((Vector)this.states.elementAt(regNum)).addElement(s.nextElement());
        }
    }

    public int getNum() {
        return this.states.size();
    }

    public boolean isBOL(int num) {
        return (Boolean)this.BOL.elementAt(num);
    }

    public RegExp getLookAhead(int num) {
        return (RegExp)this.look.elementAt(num);
    }

    public boolean isEOF(int num) {
        return this.BOL.elementAt(num) == null;
    }

    public Vector getStates(int num) {
        return (Vector)this.states.elementAt(num);
    }

    public RegExp getRegExp(int num) {
        return (RegExp)this.regExps.elementAt(num);
    }

    public int getLine(int num) {
        return (Integer)this.lines.elementAt(num);
    }

    public int getLookEntry(int num) {
        return (Integer)this.look_entry.elementAt(num);
    }

    public void checkActions() {
        if (this.actions.elementAt(this.actions.size() - 1) == null) {
            Out.error(ErrorMessages.NO_LAST_ACTION);
            throw new GeneratorException();
        }
    }

    public Action getAction(int num) {
        while (num < this.actions.size() && this.actions.elementAt(num) == null) {
            ++num;
        }
        return (Action)this.actions.elementAt(num);
    }

    public int NFASize(Macros macros) {
        RegExp r;
        int size = 0;
        Enumeration e = this.regExps.elements();
        while (e.hasMoreElements()) {
            r = (RegExp)e.nextElement();
            if (r == null) continue;
            size += r.size(macros);
        }
        e = this.look.elements();
        while (e.hasMoreElements()) {
            r = (RegExp)e.nextElement();
            if (r == null) continue;
            size += r.size(macros);
        }
        return size;
    }

    public void checkLookAheads() {
        for (int i = 0; i < this.regExps.size(); ++i) {
            this.lookAheadCase(i);
        }
    }

    private void lookAheadCase(int regExpNum) {
        if (this.getLookAhead(regExpNum) != null) {
            RegExp r1 = this.getRegExp(regExpNum);
            RegExp r2 = this.getLookAhead(regExpNum);
            Action a = this.getAction(regExpNum);
            int len1 = SemCheck.length(r1);
            int len2 = SemCheck.length(r2);
            if (len1 >= 0) {
                a.setLookAction(1, len1);
            } else if (len2 >= 0) {
                a.setLookAction(2, len2);
            } else if (SemCheck.isFiniteChoice(r2)) {
                a.setLookAction(3, 0);
            } else {
                a.setLookAction(4, 0);
                this.look_entry.setElementAt(new Integer(this.gen_look_count), regExpNum);
                ++this.gen_look_count;
            }
        }
    }
}

