﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Windows.Data;
using System.Globalization;

namespace Fluent.Controls
{
    internal class AnimationFactorToValueConverter : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            if (values[0] is not double completeValue)
            {
                return 0.0;
            }

            if (values[1] is not double factor || factor == double.NaN)
            {
                return 0.0;
            }

            if (parameter is "negative")
            {
                factor = -factor;
            }

            return factor * completeValue;
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
