﻿' Licensed to the .NET Foundation under one or more agreements.
' The .NET Foundation licenses this file to you under the MIT license.

Imports System.Globalization

Namespace Microsoft.VisualBasic.CompilerServices

    ' Purpose: various helpers for the vb runtime functions
    Friend NotInheritable Class Utils

        Friend Shared Function GetResourceString(ResourceId As vbErrors) As String
            Dim id As String = "ID" & CStr(ResourceId)
            Return SR.GetResourceString(id, id)
        End Function

        Friend Shared Function GetResourceString(resourceKey As String, ParamArray args() As String) As String
            Return String.Format(GetCultureInfo(), resourceKey, args)
        End Function

        Friend Shared Function GetCultureInfo() As CultureInfo
            Return Threading.Thread.CurrentThread.CurrentCulture
        End Function

    End Class

End Namespace

