﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.Collections;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Collections.Immutable;
using System.Collections.ObjectModel;
using System.Text.Json.Serialization;
using System.Text.Json.Serialization.Tests;

namespace System.Text.Json.SourceGeneration.Tests
{
    public sealed partial class NumberHandlingTests_Metadata : NumberHandlingTests
    {
        public NumberHandlingTests_Metadata()
            : base(new StringSerializerWrapper(NumberHandlingTestsContext_Metadata.Default))
        {
        }

        [JsonSourceGenerationOptions(GenerationMode = JsonSourceGenerationMode.Metadata)]
        [JsonSerializable(typeof(Class_With_BoxedNumbers))]
        [JsonSerializable(typeof(Class_With_ListsOfBoxedNumbers))]
        [JsonSerializable(typeof(Class_With_BoxedNonNumbers))]
        [JsonSerializable(typeof(Class_With_ListsOfBoxedNonNumbers))]
        [JsonSerializable(typeof(ClassWithNumbers))]
        [JsonSerializable(typeof(ClassWith_StrictAttribute))]
        [JsonSerializable(typeof(ClassWith_ReadAsStringAttribute))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<int[]>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<ConcurrentQueue<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<GenericICollectionWrapper<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<IEnumerable<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<Collection<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<ImmutableList<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<HashSet<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<List<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<IList<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<IList>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<Queue<int>>))]
        [JsonSerializable(typeof(ClassWithComplexListProperty))]
        [JsonSerializable(typeof(ClassWith_AttributeOnComplexListProperty))]
        [JsonSerializable(typeof(ClassWith_AttributeOnComplexDictionaryProperty))]
        [JsonSerializable(typeof(ClassWithSimpleDictionaryProperty))]
        [JsonSerializable(typeof(ClassWithComplexDictionaryProperty))]
        [JsonSerializable(typeof(MyCustomList))]
        [JsonSerializable(typeof(ClassWithCustomList))]
        [JsonSerializable(typeof(MyCustomDictionary))]
        [JsonSerializable(typeof(ClassWithCustomDictionary))]
        [JsonSerializable(typeof(AttributeAppliedToFirstLevelProp))]
        [JsonSerializable(typeof(NonNumberType))]
        [JsonSerializable(typeof(MyCustomListWrapper))]
        [JsonSerializable(typeof(MyCustomDictionaryWrapper))]
        [JsonSerializable(typeof(ClassWith_NumberHandlingOn_ObjectProperty))]
        [JsonSerializable(typeof(ClassWith_NumberHandlingOn_Property_WithCustomConverter))]
        [JsonSerializable(typeof(ClassWith_NumberHandlingOn_Type_WithCustomConverter))]
        [JsonSerializable(typeof(Class_With_NullableUInt64_And_Float))]
        [JsonSerializable(typeof(MyClassWithNumbers))]
        [JsonSerializable(typeof(MyClassWithNumbers_PropsHasAttribute))]
        [JsonSerializable(typeof(ClassWith_Attribute_OnNumber))]
        [JsonSerializable(typeof(Type_AllowFloatConstants))]
        [JsonSerializable(typeof(ClassWith_LooseAttribute))]
        [JsonSerializable(typeof(ClassWith_Attribute_On_TypeAndMember))]
        [JsonSerializable(typeof(ClassWithListPropAndAttribute))]
        [JsonSerializable(typeof(ClassWithDictPropAndAttribute))]
        [JsonSerializable(typeof(ClassWithListPropAndAttribute_ConverterOnProp))]
        [JsonSerializable(typeof(ClassWithDictPropAndAttribute_ConverterOnProp))]
        [JsonSerializable(typeof(PlainClassWithList))]
        [JsonSerializable(typeof(StructWithNumbers))]
        [JsonSerializable(typeof(DateTime))]
        [JsonSerializable(typeof(Guid?))]
        [JsonSerializable(typeof(byte))]
        [JsonSerializable(typeof(sbyte))]
        [JsonSerializable(typeof(short))]
        [JsonSerializable(typeof(int))]
        [JsonSerializable(typeof(long))]
        [JsonSerializable(typeof(ushort))]
        [JsonSerializable(typeof(uint))]
        [JsonSerializable(typeof(ulong))]
        [JsonSerializable(typeof(float))]
        [JsonSerializable(typeof(double))]
        [JsonSerializable(typeof(decimal))]
        [JsonSerializable(typeof(byte?))]
        [JsonSerializable(typeof(sbyte?))]
        [JsonSerializable(typeof(short?))]
        [JsonSerializable(typeof(int?))]
        [JsonSerializable(typeof(long?))]
        [JsonSerializable(typeof(ushort?))]
        [JsonSerializable(typeof(uint?))]
        [JsonSerializable(typeof(ulong?))]
        [JsonSerializable(typeof(float?))]
        [JsonSerializable(typeof(double?))]
        [JsonSerializable(typeof(decimal?))]
        [JsonSerializable(typeof(IEnumerable<string>))]
        [JsonSerializable(typeof(List<float>))]
        [JsonSerializable(typeof(List<double>))]
        [JsonSerializable(typeof(List<decimal>))]
        [JsonSerializable(typeof(KeyValuePair<ulong?, List<float>>))]
        [JsonSerializable(typeof(Dictionary<int, float>))]
        [JsonSerializable(typeof(Dictionary<string, ulong>))]
        [JsonSerializable(typeof(JsonElement))]
        [JsonSerializable(typeof(Queue))]
        [JsonSerializable(typeof(WrapperForIList))]
        [JsonSerializable(typeof(byte[]))]
        [JsonSerializable(typeof(ConcurrentQueue<byte>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<byte>))]
        [JsonSerializable(typeof(IEnumerable<byte>))]
        [JsonSerializable(typeof(Collection<byte>))]
        [JsonSerializable(typeof(HashSet<byte>))]
        [JsonSerializable(typeof(List<byte>))]
        [JsonSerializable(typeof(Queue<byte>))]
        [JsonSerializable(typeof(ImmutableList<byte>))]
        [JsonSerializable(typeof(sbyte[]))]
        [JsonSerializable(typeof(ConcurrentQueue<sbyte>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<sbyte>))]
        [JsonSerializable(typeof(IEnumerable<sbyte>))]
        [JsonSerializable(typeof(Collection<sbyte>))]
        [JsonSerializable(typeof(HashSet<sbyte>))]
        [JsonSerializable(typeof(List<sbyte>))]
        [JsonSerializable(typeof(Queue<sbyte>))]
        [JsonSerializable(typeof(ImmutableList<sbyte>))]
        [JsonSerializable(typeof(short[]))]
        [JsonSerializable(typeof(ConcurrentQueue<short>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<short>))]
        [JsonSerializable(typeof(IEnumerable<short>))]
        [JsonSerializable(typeof(Collection<short>))]
        [JsonSerializable(typeof(HashSet<short>))]
        [JsonSerializable(typeof(List<short>))]
        [JsonSerializable(typeof(Queue<short>))]
        [JsonSerializable(typeof(ImmutableList<short>))]
        [JsonSerializable(typeof(int[]))]
        [JsonSerializable(typeof(ConcurrentQueue<int>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<int>))]
        [JsonSerializable(typeof(IEnumerable<int>))]
        [JsonSerializable(typeof(Collection<int>))]
        [JsonSerializable(typeof(HashSet<int>))]
        [JsonSerializable(typeof(List<int>))]
        [JsonSerializable(typeof(Queue<int>))]
        [JsonSerializable(typeof(ImmutableList<int>))]
        [JsonSerializable(typeof(long[]))]
        [JsonSerializable(typeof(ConcurrentQueue<long>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<long>))]
        [JsonSerializable(typeof(IEnumerable<long>))]
        [JsonSerializable(typeof(Collection<long>))]
        [JsonSerializable(typeof(HashSet<long>))]
        [JsonSerializable(typeof(List<long>))]
        [JsonSerializable(typeof(Queue<long>))]
        [JsonSerializable(typeof(ImmutableList<long>))]
        [JsonSerializable(typeof(ushort[]))]
        [JsonSerializable(typeof(ConcurrentQueue<ushort>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<ushort>))]
        [JsonSerializable(typeof(IEnumerable<ushort>))]
        [JsonSerializable(typeof(Collection<ushort>))]
        [JsonSerializable(typeof(HashSet<ushort>))]
        [JsonSerializable(typeof(List<ushort>))]
        [JsonSerializable(typeof(Queue<ushort>))]
        [JsonSerializable(typeof(ImmutableList<ushort>))]
        [JsonSerializable(typeof(uint[]))]
        [JsonSerializable(typeof(ConcurrentQueue<uint>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<uint>))]
        [JsonSerializable(typeof(IEnumerable<uint>))]
        [JsonSerializable(typeof(Collection<uint>))]
        [JsonSerializable(typeof(HashSet<uint>))]
        [JsonSerializable(typeof(List<uint>))]
        [JsonSerializable(typeof(Queue<uint>))]
        [JsonSerializable(typeof(ImmutableList<uint>))]
        [JsonSerializable(typeof(short?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<short?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<short?>))]
        [JsonSerializable(typeof(IEnumerable<short?>))]
        [JsonSerializable(typeof(Collection<short?>))]
        [JsonSerializable(typeof(HashSet<short?>))]
        [JsonSerializable(typeof(List<short?>))]
        [JsonSerializable(typeof(Queue<short?>))]
        [JsonSerializable(typeof(ImmutableList<short?>))]
        [JsonSerializable(typeof(int?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<int?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<int?>))]
        [JsonSerializable(typeof(IEnumerable<int?>))]
        [JsonSerializable(typeof(Collection<int?>))]
        [JsonSerializable(typeof(HashSet<int?>))]
        [JsonSerializable(typeof(List<int?>))]
        [JsonSerializable(typeof(Queue<int?>))]
        [JsonSerializable(typeof(ImmutableList<int?>))]
        [JsonSerializable(typeof(long?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<long?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<long?>))]
        [JsonSerializable(typeof(IEnumerable<long?>))]
        [JsonSerializable(typeof(Collection<long?>))]
        [JsonSerializable(typeof(HashSet<long?>))]
        [JsonSerializable(typeof(List<long?>))]
        [JsonSerializable(typeof(Queue<long?>))]
        [JsonSerializable(typeof(ImmutableList<long?>))]
        [JsonSerializable(typeof(ushort?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<ushort?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<ushort?>))]
        [JsonSerializable(typeof(IEnumerable<ushort?>))]
        [JsonSerializable(typeof(Collection<ushort?>))]
        [JsonSerializable(typeof(HashSet<ushort?>))]
        [JsonSerializable(typeof(List<ushort?>))]
        [JsonSerializable(typeof(Queue<ushort?>))]
        [JsonSerializable(typeof(ImmutableList<ushort?>))]
        [JsonSerializable(typeof(uint?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<uint?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<uint?>))]
        [JsonSerializable(typeof(IEnumerable<uint?>))]
        [JsonSerializable(typeof(Collection<uint?>))]
        [JsonSerializable(typeof(HashSet<uint?>))]
        [JsonSerializable(typeof(List<uint?>))]
        [JsonSerializable(typeof(Queue<uint?>))]
        [JsonSerializable(typeof(ImmutableList<uint?>))]
        [JsonSerializable(typeof(ulong[]))]
        [JsonSerializable(typeof(ConcurrentQueue<ulong>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<ulong>))]
        [JsonSerializable(typeof(IEnumerable<ulong>))]
        [JsonSerializable(typeof(Collection<ulong>))]
        [JsonSerializable(typeof(HashSet<ulong>))]
        [JsonSerializable(typeof(List<ulong>))]
        [JsonSerializable(typeof(Queue<ulong>))]
        [JsonSerializable(typeof(ImmutableList<ulong>))]
        [JsonSerializable(typeof(float[]))]
        [JsonSerializable(typeof(ConcurrentQueue<float>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<float>))]
        [JsonSerializable(typeof(IEnumerable<float>))]
        [JsonSerializable(typeof(Collection<float>))]
        [JsonSerializable(typeof(HashSet<float>))]
        [JsonSerializable(typeof(List<float>))]
        [JsonSerializable(typeof(Queue<float>))]
        [JsonSerializable(typeof(ImmutableList<float>))]
        [JsonSerializable(typeof(double[]))]
        [JsonSerializable(typeof(ConcurrentQueue<double>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<double>))]
        [JsonSerializable(typeof(IEnumerable<double>))]
        [JsonSerializable(typeof(Collection<double>))]
        [JsonSerializable(typeof(HashSet<double>))]
        [JsonSerializable(typeof(List<double>))]
        [JsonSerializable(typeof(Queue<double>))]
        [JsonSerializable(typeof(ImmutableList<double>))]
        [JsonSerializable(typeof(decimal[]))]
        [JsonSerializable(typeof(ConcurrentQueue<decimal>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<decimal>))]
        [JsonSerializable(typeof(IEnumerable<decimal>))]
        [JsonSerializable(typeof(Collection<decimal>))]
        [JsonSerializable(typeof(HashSet<decimal>))]
        [JsonSerializable(typeof(List<decimal>))]
        [JsonSerializable(typeof(Queue<decimal>))]
        [JsonSerializable(typeof(ImmutableList<decimal>))]
#if NET
        [JsonSerializable(typeof(Int128))]
        [JsonSerializable(typeof(Int128[]))]
        [JsonSerializable(typeof(ConcurrentQueue<Int128>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<Int128>))]
        [JsonSerializable(typeof(IEnumerable<Int128>))]
        [JsonSerializable(typeof(Collection<Int128>))]
        [JsonSerializable(typeof(HashSet<Int128>))]
        [JsonSerializable(typeof(List<Int128>))]
        [JsonSerializable(typeof(Queue<Int128>))]
        [JsonSerializable(typeof(ImmutableList<Int128>))]
        [JsonSerializable(typeof(UInt128))]
        [JsonSerializable(typeof(UInt128[]))]
        [JsonSerializable(typeof(ConcurrentQueue<UInt128>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<UInt128>))]
        [JsonSerializable(typeof(IEnumerable<UInt128>))]
        [JsonSerializable(typeof(Collection<UInt128>))]
        [JsonSerializable(typeof(HashSet<UInt128>))]
        [JsonSerializable(typeof(List<UInt128>))]
        [JsonSerializable(typeof(Queue<UInt128>))]
        [JsonSerializable(typeof(ImmutableList<UInt128>))]
        [JsonSerializable(typeof(Half))]
        [JsonSerializable(typeof(Half[]))]
        [JsonSerializable(typeof(ConcurrentQueue<Half>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<Half>))]
        [JsonSerializable(typeof(IEnumerable<Half>))]
        [JsonSerializable(typeof(Collection<Half>))]
        [JsonSerializable(typeof(HashSet<Half>))]
        [JsonSerializable(typeof(List<Half>))]
        [JsonSerializable(typeof(Queue<Half>))]
        [JsonSerializable(typeof(ImmutableList<Half>))]
        [JsonSerializable(typeof(Int128?))]
        [JsonSerializable(typeof(Int128?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<Int128?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<Int128?>))]
        [JsonSerializable(typeof(IEnumerable<Int128?>))]
        [JsonSerializable(typeof(Collection<Int128?>))]
        [JsonSerializable(typeof(HashSet<Int128?>))]
        [JsonSerializable(typeof(List<Int128?>))]
        [JsonSerializable(typeof(Queue<Int128?>))]
        [JsonSerializable(typeof(ImmutableList<Int128?>))]
        [JsonSerializable(typeof(UInt128?))]
        [JsonSerializable(typeof(UInt128?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<UInt128?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<UInt128?>))]
        [JsonSerializable(typeof(IEnumerable<UInt128?>))]
        [JsonSerializable(typeof(Collection<UInt128?>))]
        [JsonSerializable(typeof(HashSet<UInt128?>))]
        [JsonSerializable(typeof(List<UInt128?>))]
        [JsonSerializable(typeof(Queue<UInt128?>))]
        [JsonSerializable(typeof(ImmutableList<UInt128?>))]
        [JsonSerializable(typeof(Half?))]
        [JsonSerializable(typeof(Half?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<Half?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<Half?>))]
        [JsonSerializable(typeof(IEnumerable<Half?>))]
        [JsonSerializable(typeof(Collection<Half?>))]
        [JsonSerializable(typeof(HashSet<Half?>))]
        [JsonSerializable(typeof(List<Half?>))]
        [JsonSerializable(typeof(Queue<Half?>))]
        [JsonSerializable(typeof(ImmutableList<Half?>))]
#endif
        [JsonSerializable(typeof(List<byte>))]
        [JsonSerializable(typeof(List<sbyte>))]
        [JsonSerializable(typeof(List<short>))]
        [JsonSerializable(typeof(List<int>))]
        [JsonSerializable(typeof(List<long>))]
        [JsonSerializable(typeof(List<ushort>))]
        [JsonSerializable(typeof(List<uint>))]
        [JsonSerializable(typeof(List<ulong>))]
        [JsonSerializable(typeof(List<float>))]
        [JsonSerializable(typeof(List<double>))]
        [JsonSerializable(typeof(List<decimal>))]
        [JsonSerializable(typeof(List<byte?>))]
        [JsonSerializable(typeof(List<sbyte?>))]
        [JsonSerializable(typeof(List<short?>))]
        [JsonSerializable(typeof(List<int?>))]
        [JsonSerializable(typeof(List<long?>))]
        [JsonSerializable(typeof(List<ushort?>))]
        [JsonSerializable(typeof(List<uint?>))]
        [JsonSerializable(typeof(List<ulong?>))]
        [JsonSerializable(typeof(List<float?>))]
        [JsonSerializable(typeof(List<double?>))]
        [JsonSerializable(typeof(List<decimal?>))]
        [JsonSerializable(typeof(Hashtable))]
        [JsonSerializable(typeof(byte?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<byte?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<byte?>))]
        [JsonSerializable(typeof(IEnumerable<byte?>))]
        [JsonSerializable(typeof(Collection<byte?>))]
        [JsonSerializable(typeof(HashSet<byte?>))]
        [JsonSerializable(typeof(List<byte?>))]
        [JsonSerializable(typeof(Queue<byte?>))]
        [JsonSerializable(typeof(ImmutableList<byte?>))]
        [JsonSerializable(typeof(sbyte?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<sbyte?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<sbyte?>))]
        [JsonSerializable(typeof(IEnumerable<sbyte?>))]
        [JsonSerializable(typeof(Collection<sbyte?>))]
        [JsonSerializable(typeof(HashSet<sbyte?>))]
        [JsonSerializable(typeof(List<sbyte?>))]
        [JsonSerializable(typeof(Queue<sbyte?>))]
        [JsonSerializable(typeof(ImmutableList<sbyte?>))]
        [JsonSerializable(typeof(short?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<short?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<short?>))]
        [JsonSerializable(typeof(IEnumerable<short?>))]
        [JsonSerializable(typeof(Collection<short?>))]
        [JsonSerializable(typeof(HashSet<short?>))]
        [JsonSerializable(typeof(List<short?>))]
        [JsonSerializable(typeof(Queue<short?>))]
        [JsonSerializable(typeof(ImmutableList<short?>))]
        [JsonSerializable(typeof(int?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<int?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<int?>))]
        [JsonSerializable(typeof(IEnumerable<int?>))]
        [JsonSerializable(typeof(Collection<int?>))]
        [JsonSerializable(typeof(HashSet<int?>))]
        [JsonSerializable(typeof(List<int?>))]
        [JsonSerializable(typeof(Queue<int?>))]
        [JsonSerializable(typeof(ImmutableList<int?>))]
        [JsonSerializable(typeof(long?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<long?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<long?>))]
        [JsonSerializable(typeof(IEnumerable<long?>))]
        [JsonSerializable(typeof(Collection<long?>))]
        [JsonSerializable(typeof(HashSet<long?>))]
        [JsonSerializable(typeof(List<long?>))]
        [JsonSerializable(typeof(Queue<long?>))]
        [JsonSerializable(typeof(ImmutableList<long?>))]
        [JsonSerializable(typeof(ushort?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<ushort?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<ushort?>))]
        [JsonSerializable(typeof(IEnumerable<ushort?>))]
        [JsonSerializable(typeof(Collection<ushort?>))]
        [JsonSerializable(typeof(HashSet<ushort?>))]
        [JsonSerializable(typeof(List<ushort?>))]
        [JsonSerializable(typeof(Queue<ushort?>))]
        [JsonSerializable(typeof(ImmutableList<ushort?>))]
        [JsonSerializable(typeof(uint?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<uint?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<uint?>))]
        [JsonSerializable(typeof(IEnumerable<uint?>))]
        [JsonSerializable(typeof(Collection<uint?>))]
        [JsonSerializable(typeof(HashSet<uint?>))]
        [JsonSerializable(typeof(List<uint?>))]
        [JsonSerializable(typeof(Queue<uint?>))]
        [JsonSerializable(typeof(ImmutableList<uint?>))]
        [JsonSerializable(typeof(ulong?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<ulong?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<ulong?>))]
        [JsonSerializable(typeof(IEnumerable<ulong?>))]
        [JsonSerializable(typeof(Collection<ulong?>))]
        [JsonSerializable(typeof(HashSet<ulong?>))]
        [JsonSerializable(typeof(List<ulong?>))]
        [JsonSerializable(typeof(Queue<ulong?>))]
        [JsonSerializable(typeof(ImmutableList<ulong?>))]
        [JsonSerializable(typeof(float?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<float?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<float?>))]
        [JsonSerializable(typeof(IEnumerable<float?>))]
        [JsonSerializable(typeof(Collection<float?>))]
        [JsonSerializable(typeof(HashSet<float?>))]
        [JsonSerializable(typeof(List<float?>))]
        [JsonSerializable(typeof(Queue<float?>))]
        [JsonSerializable(typeof(ImmutableList<float?>))]
        [JsonSerializable(typeof(double?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<double?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<double?>))]
        [JsonSerializable(typeof(IEnumerable<double?>))]
        [JsonSerializable(typeof(Collection<double?>))]
        [JsonSerializable(typeof(HashSet<double?>))]
        [JsonSerializable(typeof(List<double?>))]
        [JsonSerializable(typeof(Queue<double?>))]
        [JsonSerializable(typeof(ImmutableList<double?>))]
        [JsonSerializable(typeof(decimal?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<decimal?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<decimal?>))]
        [JsonSerializable(typeof(IEnumerable<decimal?>))]
        [JsonSerializable(typeof(Collection<decimal?>))]
        [JsonSerializable(typeof(HashSet<decimal?>))]
        [JsonSerializable(typeof(List<decimal?>))]
        [JsonSerializable(typeof(Queue<decimal?>))]
        [JsonSerializable(typeof(ImmutableList<decimal?>))]
        [JsonSerializable(typeof(IDictionary))]
        [JsonSerializable(typeof(Dictionary<string, object>))]
        [JsonSerializable(typeof(Dictionary<string, ulong>))]
        [JsonSerializable(typeof(ConcurrentDictionary<string, ulong>))]
        [JsonSerializable(typeof(IDictionary<string, ulong>))]
        [JsonSerializable(typeof(GenericIDictionaryWrapper<string, ulong>))]
        [JsonSerializable(typeof(ImmutableDictionary<string, ulong>))]
        [JsonSerializable(typeof(IReadOnlyDictionary<string, ulong>))]
        [JsonSerializable(typeof(Dictionary<string, float>))]
        [JsonSerializable(typeof(ConcurrentDictionary<string, float>))]
        [JsonSerializable(typeof(IDictionary<string, float>))]
        [JsonSerializable(typeof(GenericIDictionaryWrapper<string, float>))]
        [JsonSerializable(typeof(ImmutableDictionary<string, float>))]
        [JsonSerializable(typeof(IReadOnlyDictionary<string, float>))]
        [JsonSerializable(typeof(Dictionary<string, double>))]
        [JsonSerializable(typeof(ConcurrentDictionary<string, double>))]
        [JsonSerializable(typeof(IDictionary<string, double>))]
        [JsonSerializable(typeof(GenericIDictionaryWrapper<string, double>))]
        [JsonSerializable(typeof(ImmutableDictionary<string, double>))]
        [JsonSerializable(typeof(IReadOnlyDictionary<string, double>))]
        [JsonSerializable(typeof(Dictionary<ulong, ulong>))]
        [JsonSerializable(typeof(Dictionary<float, float>))]
        [JsonSerializable(typeof(Dictionary<double, double>))]
        [JsonSerializable(typeof(SortedList))]
        internal sealed partial class NumberHandlingTestsContext_Metadata : JsonSerializerContext
        {
        }
    }

    public sealed partial class NumberHandlingTests_Default : NumberHandlingTests
    {
        public NumberHandlingTests_Default()
            : base(new StringSerializerWrapper(NumberHandlingTestsContext_Default.Default))
        {
        }

        [JsonSerializable(typeof(Class_With_BoxedNumbers))]
        [JsonSerializable(typeof(Class_With_ListsOfBoxedNumbers))]
        [JsonSerializable(typeof(Class_With_BoxedNonNumbers))]
        [JsonSerializable(typeof(Class_With_ListsOfBoxedNonNumbers))]
        [JsonSerializable(typeof(ClassWithNumbers))]
        [JsonSerializable(typeof(ClassWith_StrictAttribute))]
        [JsonSerializable(typeof(ClassWith_ReadAsStringAttribute))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<int[]>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<ConcurrentQueue<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<GenericICollectionWrapper<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<IEnumerable<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<Collection<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<ImmutableList<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<HashSet<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<List<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<IList<int>>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<IList>))]
        [JsonSerializable(typeof(ClassWithSimpleCollectionProperty<Queue<int>>))]
        [JsonSerializable(typeof(ClassWithComplexListProperty))]
        [JsonSerializable(typeof(ClassWith_AttributeOnComplexListProperty))]
        [JsonSerializable(typeof(ClassWith_AttributeOnComplexDictionaryProperty))]
        [JsonSerializable(typeof(ClassWithSimpleDictionaryProperty))]
        [JsonSerializable(typeof(ClassWithComplexDictionaryProperty))]
        [JsonSerializable(typeof(MyCustomList))]
        [JsonSerializable(typeof(ClassWithCustomList))]
        [JsonSerializable(typeof(MyCustomDictionary))]
        [JsonSerializable(typeof(ClassWithCustomDictionary))]
        [JsonSerializable(typeof(AttributeAppliedToFirstLevelProp))]
        [JsonSerializable(typeof(NonNumberType))]
        [JsonSerializable(typeof(MyCustomListWrapper))]
        [JsonSerializable(typeof(MyCustomDictionaryWrapper))]
        [JsonSerializable(typeof(ClassWith_NumberHandlingOn_ObjectProperty))]
        [JsonSerializable(typeof(ClassWith_NumberHandlingOn_Property_WithCustomConverter))]
        [JsonSerializable(typeof(ClassWith_NumberHandlingOn_Type_WithCustomConverter))]
        [JsonSerializable(typeof(Class_With_NullableUInt64_And_Float))]
        [JsonSerializable(typeof(MyClassWithNumbers))]
        [JsonSerializable(typeof(MyClassWithNumbers_PropsHasAttribute))]
        [JsonSerializable(typeof(ClassWith_Attribute_OnNumber))]
        [JsonSerializable(typeof(Type_AllowFloatConstants))]
        [JsonSerializable(typeof(ClassWith_LooseAttribute))]
        [JsonSerializable(typeof(ClassWith_Attribute_On_TypeAndMember))]
        [JsonSerializable(typeof(ClassWithListPropAndAttribute))]
        [JsonSerializable(typeof(ClassWithDictPropAndAttribute))]
        [JsonSerializable(typeof(ClassWithListPropAndAttribute_ConverterOnProp))]
        [JsonSerializable(typeof(ClassWithDictPropAndAttribute_ConverterOnProp))]
        [JsonSerializable(typeof(PlainClassWithList))]
        [JsonSerializable(typeof(StructWithNumbers))]
        [JsonSerializable(typeof(DateTime))]
        [JsonSerializable(typeof(Guid?))]
        [JsonSerializable(typeof(byte))]
        [JsonSerializable(typeof(sbyte))]
        [JsonSerializable(typeof(short))]
        [JsonSerializable(typeof(int))]
        [JsonSerializable(typeof(long))]
        [JsonSerializable(typeof(ushort))]
        [JsonSerializable(typeof(uint))]
        [JsonSerializable(typeof(ulong))]
        [JsonSerializable(typeof(float))]
        [JsonSerializable(typeof(double))]
        [JsonSerializable(typeof(decimal))]
        [JsonSerializable(typeof(byte?))]
        [JsonSerializable(typeof(sbyte?))]
        [JsonSerializable(typeof(short?))]
        [JsonSerializable(typeof(int?))]
        [JsonSerializable(typeof(long?))]
        [JsonSerializable(typeof(ushort?))]
        [JsonSerializable(typeof(uint?))]
        [JsonSerializable(typeof(ulong?))]
        [JsonSerializable(typeof(float?))]
        [JsonSerializable(typeof(double?))]
        [JsonSerializable(typeof(decimal?))]
        [JsonSerializable(typeof(IEnumerable<string>))]
        [JsonSerializable(typeof(List<float>))]
        [JsonSerializable(typeof(List<double>))]
        [JsonSerializable(typeof(List<decimal>))]
        [JsonSerializable(typeof(KeyValuePair<ulong?, List<float>>))]
        [JsonSerializable(typeof(Dictionary<int, float>))]
        [JsonSerializable(typeof(Dictionary<string, ulong>))]
        [JsonSerializable(typeof(JsonElement))]
        [JsonSerializable(typeof(Queue))]
        [JsonSerializable(typeof(WrapperForIList))]
        [JsonSerializable(typeof(byte[]))]
        [JsonSerializable(typeof(ConcurrentQueue<byte>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<byte>))]
        [JsonSerializable(typeof(IEnumerable<byte>))]
        [JsonSerializable(typeof(Collection<byte>))]
        [JsonSerializable(typeof(HashSet<byte>))]
        [JsonSerializable(typeof(List<byte>))]
        [JsonSerializable(typeof(Queue<byte>))]
        [JsonSerializable(typeof(ImmutableList<byte>))]
        [JsonSerializable(typeof(sbyte[]))]
        [JsonSerializable(typeof(ConcurrentQueue<sbyte>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<sbyte>))]
        [JsonSerializable(typeof(IEnumerable<sbyte>))]
        [JsonSerializable(typeof(Collection<sbyte>))]
        [JsonSerializable(typeof(HashSet<sbyte>))]
        [JsonSerializable(typeof(List<sbyte>))]
        [JsonSerializable(typeof(Queue<sbyte>))]
        [JsonSerializable(typeof(ImmutableList<sbyte>))]
        [JsonSerializable(typeof(short[]))]
        [JsonSerializable(typeof(ConcurrentQueue<short>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<short>))]
        [JsonSerializable(typeof(IEnumerable<short>))]
        [JsonSerializable(typeof(Collection<short>))]
        [JsonSerializable(typeof(HashSet<short>))]
        [JsonSerializable(typeof(List<short>))]
        [JsonSerializable(typeof(Queue<short>))]
        [JsonSerializable(typeof(ImmutableList<short>))]
        [JsonSerializable(typeof(int[]))]
        [JsonSerializable(typeof(ConcurrentQueue<int>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<int>))]
        [JsonSerializable(typeof(IEnumerable<int>))]
        [JsonSerializable(typeof(Collection<int>))]
        [JsonSerializable(typeof(HashSet<int>))]
        [JsonSerializable(typeof(List<int>))]
        [JsonSerializable(typeof(Queue<int>))]
        [JsonSerializable(typeof(ImmutableList<int>))]
        [JsonSerializable(typeof(long[]))]
        [JsonSerializable(typeof(ConcurrentQueue<long>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<long>))]
        [JsonSerializable(typeof(IEnumerable<long>))]
        [JsonSerializable(typeof(Collection<long>))]
        [JsonSerializable(typeof(HashSet<long>))]
        [JsonSerializable(typeof(List<long>))]
        [JsonSerializable(typeof(Queue<long>))]
        [JsonSerializable(typeof(ImmutableList<long>))]
        [JsonSerializable(typeof(ushort[]))]
        [JsonSerializable(typeof(ConcurrentQueue<ushort>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<ushort>))]
        [JsonSerializable(typeof(IEnumerable<ushort>))]
        [JsonSerializable(typeof(Collection<ushort>))]
        [JsonSerializable(typeof(HashSet<ushort>))]
        [JsonSerializable(typeof(List<ushort>))]
        [JsonSerializable(typeof(Queue<ushort>))]
        [JsonSerializable(typeof(ImmutableList<ushort>))]
        [JsonSerializable(typeof(uint[]))]
        [JsonSerializable(typeof(ConcurrentQueue<uint>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<uint>))]
        [JsonSerializable(typeof(IEnumerable<uint>))]
        [JsonSerializable(typeof(Collection<uint>))]
        [JsonSerializable(typeof(HashSet<uint>))]
        [JsonSerializable(typeof(List<uint>))]
        [JsonSerializable(typeof(Queue<uint>))]
        [JsonSerializable(typeof(ImmutableList<uint>))]
        [JsonSerializable(typeof(short?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<short?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<short?>))]
        [JsonSerializable(typeof(IEnumerable<short?>))]
        [JsonSerializable(typeof(Collection<short?>))]
        [JsonSerializable(typeof(HashSet<short?>))]
        [JsonSerializable(typeof(List<short?>))]
        [JsonSerializable(typeof(Queue<short?>))]
        [JsonSerializable(typeof(ImmutableList<short?>))]
        [JsonSerializable(typeof(int?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<int?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<int?>))]
        [JsonSerializable(typeof(IEnumerable<int?>))]
        [JsonSerializable(typeof(Collection<int?>))]
        [JsonSerializable(typeof(HashSet<int?>))]
        [JsonSerializable(typeof(List<int?>))]
        [JsonSerializable(typeof(Queue<int?>))]
        [JsonSerializable(typeof(ImmutableList<int?>))]
        [JsonSerializable(typeof(long?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<long?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<long?>))]
        [JsonSerializable(typeof(IEnumerable<long?>))]
        [JsonSerializable(typeof(Collection<long?>))]
        [JsonSerializable(typeof(HashSet<long?>))]
        [JsonSerializable(typeof(List<long?>))]
        [JsonSerializable(typeof(Queue<long?>))]
        [JsonSerializable(typeof(ImmutableList<long?>))]
        [JsonSerializable(typeof(ushort?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<ushort?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<ushort?>))]
        [JsonSerializable(typeof(IEnumerable<ushort?>))]
        [JsonSerializable(typeof(Collection<ushort?>))]
        [JsonSerializable(typeof(HashSet<ushort?>))]
        [JsonSerializable(typeof(List<ushort?>))]
        [JsonSerializable(typeof(Queue<ushort?>))]
        [JsonSerializable(typeof(ImmutableList<ushort?>))]
        [JsonSerializable(typeof(uint?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<uint?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<uint?>))]
        [JsonSerializable(typeof(IEnumerable<uint?>))]
        [JsonSerializable(typeof(Collection<uint?>))]
        [JsonSerializable(typeof(HashSet<uint?>))]
        [JsonSerializable(typeof(List<uint?>))]
        [JsonSerializable(typeof(Queue<uint?>))]
        [JsonSerializable(typeof(ImmutableList<uint?>))]
        [JsonSerializable(typeof(ulong[]))]
        [JsonSerializable(typeof(ConcurrentQueue<ulong>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<ulong>))]
        [JsonSerializable(typeof(IEnumerable<ulong>))]
        [JsonSerializable(typeof(Collection<ulong>))]
        [JsonSerializable(typeof(HashSet<ulong>))]
        [JsonSerializable(typeof(List<ulong>))]
        [JsonSerializable(typeof(Queue<ulong>))]
        [JsonSerializable(typeof(ImmutableList<ulong>))]
        [JsonSerializable(typeof(float[]))]
        [JsonSerializable(typeof(ConcurrentQueue<float>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<float>))]
        [JsonSerializable(typeof(IEnumerable<float>))]
        [JsonSerializable(typeof(Collection<float>))]
        [JsonSerializable(typeof(HashSet<float>))]
        [JsonSerializable(typeof(List<float>))]
        [JsonSerializable(typeof(Queue<float>))]
        [JsonSerializable(typeof(ImmutableList<float>))]
        [JsonSerializable(typeof(double[]))]
        [JsonSerializable(typeof(ConcurrentQueue<double>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<double>))]
        [JsonSerializable(typeof(IEnumerable<double>))]
        [JsonSerializable(typeof(Collection<double>))]
        [JsonSerializable(typeof(HashSet<double>))]
        [JsonSerializable(typeof(List<double>))]
        [JsonSerializable(typeof(Queue<double>))]
        [JsonSerializable(typeof(ImmutableList<double>))]
        [JsonSerializable(typeof(decimal[]))]
        [JsonSerializable(typeof(ConcurrentQueue<decimal>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<decimal>))]
        [JsonSerializable(typeof(IEnumerable<decimal>))]
        [JsonSerializable(typeof(Collection<decimal>))]
        [JsonSerializable(typeof(HashSet<decimal>))]
        [JsonSerializable(typeof(List<decimal>))]
        [JsonSerializable(typeof(Queue<decimal>))]
        [JsonSerializable(typeof(ImmutableList<decimal>))]
        [JsonSerializable(typeof(List<byte>))]
        [JsonSerializable(typeof(List<sbyte>))]
        [JsonSerializable(typeof(List<short>))]
        [JsonSerializable(typeof(List<int>))]
        [JsonSerializable(typeof(List<long>))]
#if NET
        [JsonSerializable(typeof(Int128))]
        [JsonSerializable(typeof(Int128[]))]
        [JsonSerializable(typeof(ConcurrentQueue<Int128>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<Int128>))]
        [JsonSerializable(typeof(IEnumerable<Int128>))]
        [JsonSerializable(typeof(Collection<Int128>))]
        [JsonSerializable(typeof(HashSet<Int128>))]
        [JsonSerializable(typeof(List<Int128>))]
        [JsonSerializable(typeof(Queue<Int128>))]
        [JsonSerializable(typeof(ImmutableList<Int128>))]
        [JsonSerializable(typeof(UInt128))]
        [JsonSerializable(typeof(UInt128[]))]
        [JsonSerializable(typeof(ConcurrentQueue<UInt128>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<UInt128>))]
        [JsonSerializable(typeof(IEnumerable<UInt128>))]
        [JsonSerializable(typeof(Collection<UInt128>))]
        [JsonSerializable(typeof(HashSet<UInt128>))]
        [JsonSerializable(typeof(List<UInt128>))]
        [JsonSerializable(typeof(Queue<UInt128>))]
        [JsonSerializable(typeof(ImmutableList<UInt128>))]
        [JsonSerializable(typeof(Half))]
        [JsonSerializable(typeof(Half[]))]
        [JsonSerializable(typeof(ConcurrentQueue<Half>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<Half>))]
        [JsonSerializable(typeof(IEnumerable<Half>))]
        [JsonSerializable(typeof(Collection<Half>))]
        [JsonSerializable(typeof(HashSet<Half>))]
        [JsonSerializable(typeof(List<Half>))]
        [JsonSerializable(typeof(Queue<Half>))]
        [JsonSerializable(typeof(ImmutableList<Half>))]
        [JsonSerializable(typeof(Int128?))]
        [JsonSerializable(typeof(Int128?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<Int128?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<Int128?>))]
        [JsonSerializable(typeof(IEnumerable<Int128?>))]
        [JsonSerializable(typeof(Collection<Int128?>))]
        [JsonSerializable(typeof(HashSet<Int128?>))]
        [JsonSerializable(typeof(List<Int128?>))]
        [JsonSerializable(typeof(Queue<Int128?>))]
        [JsonSerializable(typeof(ImmutableList<Int128?>))]
        [JsonSerializable(typeof(UInt128?))]
        [JsonSerializable(typeof(UInt128?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<UInt128?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<UInt128?>))]
        [JsonSerializable(typeof(IEnumerable<UInt128?>))]
        [JsonSerializable(typeof(Collection<UInt128?>))]
        [JsonSerializable(typeof(HashSet<UInt128?>))]
        [JsonSerializable(typeof(List<UInt128?>))]
        [JsonSerializable(typeof(Queue<UInt128?>))]
        [JsonSerializable(typeof(ImmutableList<UInt128?>))]
        [JsonSerializable(typeof(Half?))]
        [JsonSerializable(typeof(Half?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<Half?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<Half?>))]
        [JsonSerializable(typeof(IEnumerable<Half?>))]
        [JsonSerializable(typeof(Collection<Half?>))]
        [JsonSerializable(typeof(HashSet<Half?>))]
        [JsonSerializable(typeof(List<Half?>))]
        [JsonSerializable(typeof(Queue<Half?>))]
        [JsonSerializable(typeof(ImmutableList<Half?>))]
#endif
        [JsonSerializable(typeof(List<ushort>))]
        [JsonSerializable(typeof(List<uint>))]
        [JsonSerializable(typeof(List<ulong>))]
        [JsonSerializable(typeof(List<float>))]
        [JsonSerializable(typeof(List<double>))]
        [JsonSerializable(typeof(List<decimal>))]
        [JsonSerializable(typeof(List<byte?>))]
        [JsonSerializable(typeof(List<sbyte?>))]
        [JsonSerializable(typeof(List<short?>))]
        [JsonSerializable(typeof(List<int?>))]
        [JsonSerializable(typeof(List<long?>))]
        [JsonSerializable(typeof(List<ushort?>))]
        [JsonSerializable(typeof(List<uint?>))]
        [JsonSerializable(typeof(List<ulong?>))]
        [JsonSerializable(typeof(List<float?>))]
        [JsonSerializable(typeof(List<double?>))]
        [JsonSerializable(typeof(List<decimal?>))]
        [JsonSerializable(typeof(Hashtable))]
        [JsonSerializable(typeof(byte?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<byte?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<byte?>))]
        [JsonSerializable(typeof(IEnumerable<byte?>))]
        [JsonSerializable(typeof(Collection<byte?>))]
        [JsonSerializable(typeof(HashSet<byte?>))]
        [JsonSerializable(typeof(List<byte?>))]
        [JsonSerializable(typeof(Queue<byte?>))]
        [JsonSerializable(typeof(ImmutableList<byte?>))]
        [JsonSerializable(typeof(sbyte?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<sbyte?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<sbyte?>))]
        [JsonSerializable(typeof(IEnumerable<sbyte?>))]
        [JsonSerializable(typeof(Collection<sbyte?>))]
        [JsonSerializable(typeof(HashSet<sbyte?>))]
        [JsonSerializable(typeof(List<sbyte?>))]
        [JsonSerializable(typeof(Queue<sbyte?>))]
        [JsonSerializable(typeof(ImmutableList<sbyte?>))]
        [JsonSerializable(typeof(short?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<short?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<short?>))]
        [JsonSerializable(typeof(IEnumerable<short?>))]
        [JsonSerializable(typeof(Collection<short?>))]
        [JsonSerializable(typeof(HashSet<short?>))]
        [JsonSerializable(typeof(List<short?>))]
        [JsonSerializable(typeof(Queue<short?>))]
        [JsonSerializable(typeof(ImmutableList<short?>))]
        [JsonSerializable(typeof(int?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<int?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<int?>))]
        [JsonSerializable(typeof(IEnumerable<int?>))]
        [JsonSerializable(typeof(Collection<int?>))]
        [JsonSerializable(typeof(HashSet<int?>))]
        [JsonSerializable(typeof(List<int?>))]
        [JsonSerializable(typeof(Queue<int?>))]
        [JsonSerializable(typeof(ImmutableList<int?>))]
        [JsonSerializable(typeof(long?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<long?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<long?>))]
        [JsonSerializable(typeof(IEnumerable<long?>))]
        [JsonSerializable(typeof(Collection<long?>))]
        [JsonSerializable(typeof(HashSet<long?>))]
        [JsonSerializable(typeof(List<long?>))]
        [JsonSerializable(typeof(Queue<long?>))]
        [JsonSerializable(typeof(ImmutableList<long?>))]
        [JsonSerializable(typeof(ushort?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<ushort?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<ushort?>))]
        [JsonSerializable(typeof(IEnumerable<ushort?>))]
        [JsonSerializable(typeof(Collection<ushort?>))]
        [JsonSerializable(typeof(HashSet<ushort?>))]
        [JsonSerializable(typeof(List<ushort?>))]
        [JsonSerializable(typeof(Queue<ushort?>))]
        [JsonSerializable(typeof(ImmutableList<ushort?>))]
        [JsonSerializable(typeof(uint?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<uint?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<uint?>))]
        [JsonSerializable(typeof(IEnumerable<uint?>))]
        [JsonSerializable(typeof(Collection<uint?>))]
        [JsonSerializable(typeof(HashSet<uint?>))]
        [JsonSerializable(typeof(List<uint?>))]
        [JsonSerializable(typeof(Queue<uint?>))]
        [JsonSerializable(typeof(ImmutableList<uint?>))]
        [JsonSerializable(typeof(ulong?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<ulong?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<ulong?>))]
        [JsonSerializable(typeof(IEnumerable<ulong?>))]
        [JsonSerializable(typeof(Collection<ulong?>))]
        [JsonSerializable(typeof(HashSet<ulong?>))]
        [JsonSerializable(typeof(List<ulong?>))]
        [JsonSerializable(typeof(Queue<ulong?>))]
        [JsonSerializable(typeof(ImmutableList<ulong?>))]
        [JsonSerializable(typeof(float?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<float?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<float?>))]
        [JsonSerializable(typeof(IEnumerable<float?>))]
        [JsonSerializable(typeof(Collection<float?>))]
        [JsonSerializable(typeof(HashSet<float?>))]
        [JsonSerializable(typeof(List<float?>))]
        [JsonSerializable(typeof(Queue<float?>))]
        [JsonSerializable(typeof(ImmutableList<float?>))]
        [JsonSerializable(typeof(double?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<double?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<double?>))]
        [JsonSerializable(typeof(IEnumerable<double?>))]
        [JsonSerializable(typeof(Collection<double?>))]
        [JsonSerializable(typeof(HashSet<double?>))]
        [JsonSerializable(typeof(List<double?>))]
        [JsonSerializable(typeof(Queue<double?>))]
        [JsonSerializable(typeof(ImmutableList<double?>))]
        [JsonSerializable(typeof(decimal?[]))]
        [JsonSerializable(typeof(ConcurrentQueue<decimal?>))]
        [JsonSerializable(typeof(GenericICollectionWrapper<decimal?>))]
        [JsonSerializable(typeof(IEnumerable<decimal?>))]
        [JsonSerializable(typeof(Collection<decimal?>))]
        [JsonSerializable(typeof(HashSet<decimal?>))]
        [JsonSerializable(typeof(List<decimal?>))]
        [JsonSerializable(typeof(Queue<decimal?>))]
        [JsonSerializable(typeof(ImmutableList<decimal?>))]
        [JsonSerializable(typeof(IDictionary))]
        [JsonSerializable(typeof(Dictionary<string, object>))]
        [JsonSerializable(typeof(Dictionary<string, ulong>))]
        [JsonSerializable(typeof(ConcurrentDictionary<string, ulong>))]
        [JsonSerializable(typeof(IDictionary<string, ulong>))]
        [JsonSerializable(typeof(GenericIDictionaryWrapper<string, ulong>))]
        [JsonSerializable(typeof(ImmutableDictionary<string, ulong>))]
        [JsonSerializable(typeof(IReadOnlyDictionary<string, ulong>))]
        [JsonSerializable(typeof(Dictionary<string, float>))]
        [JsonSerializable(typeof(ConcurrentDictionary<string, float>))]
        [JsonSerializable(typeof(IDictionary<string, float>))]
        [JsonSerializable(typeof(GenericIDictionaryWrapper<string, float>))]
        [JsonSerializable(typeof(ImmutableDictionary<string, float>))]
        [JsonSerializable(typeof(IReadOnlyDictionary<string, float>))]
        [JsonSerializable(typeof(Dictionary<string, double>))]
        [JsonSerializable(typeof(ConcurrentDictionary<string, double>))]
        [JsonSerializable(typeof(IDictionary<string, double>))]
        [JsonSerializable(typeof(GenericIDictionaryWrapper<string, double>))]
        [JsonSerializable(typeof(ImmutableDictionary<string, double>))]
        [JsonSerializable(typeof(IReadOnlyDictionary<string, double>))]
        [JsonSerializable(typeof(Dictionary<ulong, ulong>))]
        [JsonSerializable(typeof(Dictionary<float, float>))]
        [JsonSerializable(typeof(Dictionary<double, double>))]
        [JsonSerializable(typeof(SortedList))]
        internal sealed partial class NumberHandlingTestsContext_Default : JsonSerializerContext
        {
        }
    }
}
