﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace Microsoft.CodeAnalysis;

internal static class SymbolKeyResolutionExtensions
{
    internal static ISymbol? GetAnySymbol(this SymbolKeyResolution resolution)
    {
        if (resolution.Symbol != null)
        {
            return resolution.Symbol;
        }

        if (resolution.CandidateSymbols.Length > 0)
        {
            return resolution.CandidateSymbols[0];
        }

        return null;
    }
}
