C  @(#)minuit.for	19.1 (ESO-DMD) 02/25/03 13:28:05 
C===========================================================================
C Copyright (C) 1995 European Southern Observatory (ESO)
C
C This program is free software; you can redistribute it and/or 
C modify it under the terms of the GNU General Public License as 
C published by the Free Software Foundation; either version 2 of 
C the License, or (at your option) any later version.
C
C This program is distributed in the hope that it will be useful,
C but WITHOUT ANY WARRANTY; without even the implied warranty of
C MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C GNU General Public License for more details.
C
C You should have received a copy of the GNU General Public 
C License along with this program; if not, write to the Free 
C Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
C MA 02139, USA.
C
C Correspondence concerning ESO-MIDAS should be addressed as follows:
C       Internet e-mail: midas@eso.org
C       Postal address: European Southern Observatory
C                       Data Management Division 
C                       Karl-Schwarzschild-Strasse 2
C                       D 85748 Garching bei Muenchen 
C                       GERMANY
C 
C 020913	last modif
C 
C===========================================================================
C

      SUBROUTINEMINUIT(FCN,FUTIL)

      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)			!MNE = 2*MNI
C                              			KB: was (MNE=100,MNI=50) before
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
 
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
 
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
 
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
 
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      CHARACTER*40CWHYXT
 
      DATACWHYXT/'FOR UNKNOWN REASONS                     '/
      DATAJSYSRD,JSYSWR,JSYSSA/5,6,7/
 
 
      WRITE(JSYSWR,'(1X,75(1H*))')
      CALLMNINIT(JSYSRD,JSYSWR,JSYSSA)
  100 CONTINUE
      WRITE(ISYSWR,'(1X,75(1H*))')
      NBLOCK=NBLOCK+1
      WRITE(ISYSWR,'(26X,A,I4)')'MINUIT DATA BLOCK NO.',NBLOCK
      WRITE(ISYSWR,'(1X,75(1H*))')
      CALLMNCLER
      CALLMNREAD(FCN,1,IFLGUT,FUTIL)
      IF(IFLGUT.EQ.2)GOTO500
      IF(IFLGUT.EQ.3)GOTO600
      CALLMNREAD(FCN,2,IFLGUT,FUTIL)
      IF(IFLGUT.EQ.2)GOTO500
      IF(IFLGUT.EQ.3)GOTO600
      IF(IFLGUT.EQ.4)GOTO700
      WRITE(ISYSWR,'(/A,A)')' MINUIT: FIRST CALL TO USER FUNCTION,',' WI
     +TH IFLAG=1'
      NPARX=NPAR
      CALLMNINEX(X)
      FZERO=UNDEFI
      CALLFCN(NPARX,GIN,FZERO,U,1,FUTIL)
      FIRST=UNDEFI
      CALLFCN(NPARX,GIN,FIRST,U,4,FUTIL)
      NFCN=2
      IF(FZERO.EQ.UNDEFI.AND.FIRST.EQ.UNDEFI)THEN
      CWHYXT='BY ERROR IN USER FUNCTION.  '
      WRITE(ISYSWR,'(/A,A/)')' USER HAS NOT CALCULATED FUNCTION',' VALUE
     + WHEN IFLAG=1 OR 4'
      GOTO800
      ENDIF
      AMIN=FIRST
      IF(FIRST.EQ.UNDEFI)AMIN=FZERO
      CALLMNPRIN(1,AMIN)
      NFCN=2
      IF(FIRST.EQ.FZERO)GOTO300
      FNEW=0.0
      CALLFCN(NPARX,GIN,FNEW,U,4,FUTIL)
      IF(FNEW.NE.AMIN)WRITE(ISYSWR,280)AMIN,FNEW
  280 FORMAT(/' MINUIT WARNING: PROBABLE ERROR IN USER FUNCTION.'/' FOR 
     +FIXED VALUES OF PARAMETERS, FCN IS TIME-DEPENDENT'/' F =',E22.14,'
     + FOR FIRST CALL'/' F =',E22.14,' FOR SECOND CALL.'/)
      NFCN=3
  300 FVAL3=2.0*AMIN+1.0
      CALLMNREAD(FCN,3,IFLGUT,FUTIL)
      IF(IFLGUT.EQ.2)GOTO500
      IF(IFLGUT.EQ.3)GOTO600
      IF(IFLGUT.EQ.4)GOTO700
      CWHYXT='BY MINUIT COMMAND: '//CWORD
      IF(INDEX(CWORD,'STOP').GT.0)GOTO800
      IF(INDEX(CWORD,'EXI').GT.0)GOTO800
      IF(INDEX(CWORD,'RET').EQ.0)GOTO100
      CWHYXT='AND RETURNS TO USER PROGRAM.    '
      WRITE(ISYSWR,'(A,A)')' ..........MINUIT TERMINATED ',CWHYXT
      RETURN
  500 CONTINUE
      CWHYXT='BY END-OF-DATA ON PRIMARY INPUT FILE.   '
      GOTO800
  600 CONTINUE
      CWHYXT='BY UNRECOVERABLE READ ERROR ON INPUT.   '
      GOTO800
  700 CONTINUE
      CWHYXT=': FATAL ERROR IN PARAMETER DEFINITIONS. '
  800 WRITE(ISYSWR,'(A,A)')' ..........MINUIT TERMINATED ',CWHYXT
      STOP
      ENTRYMINTIO(I1,I2,I3)
      JSYSRD=I1
      JSYSWR=I2
      JSYSSA=I3
      RETURN
      END
 
      SUBROUTINEMNAMIN(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      NPARX=NPAR
      IF(ISW(5).GE.1)WRITE(ISYSWR,'(/A,A)')' FIRST CALL TO ','USER FUNCT
     +ION AT NEW START POINT, WITH IFLAG=4.'
      CALLMNEXIN(X)
      CALLFCN(NPARX,GIN,FNEW,U,4,FUTIL)
      NFCN=NFCN+1
      AMIN=FNEW
      EDM=BIGEDM
      RETURN
      END
      SUBROUTINEMNBINS(A1,A2,NAA,BL,BH,NB,BWID)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(ZERO=0.0,ONE=1.0)
      AL=MIN(A1,A2)
      AH=MAX(A1,A2)
      IF(AL.EQ.AH)AH=AL+1.
      IF(NAA.EQ.-1)GOTO150
   10 NA=NAA-1
      IF(NA.LT.1)NA=1
   20 AWID=(AH-AL)/FLOAT(NA)
      LOG=INT(DLOG10(DBLE(AWID)))
      IF(AWID.LE.ONE)LOG=LOG-1
      SIGFIG=AWID*(10.00**(-LOG))
      IF(SIGFIG.GT.2.0)GOTO40
      SIGRND=2.0
      GOTO100
   40 IF(SIGFIG.GT.2.5)GOTO50
      SIGRND=2.5
      GOTO100
   50 IF(SIGFIG.GT.5.0)GOTO60
      SIGRND=5.0
      GOTO100
   60 SIGRND=1.0
      LOG=LOG+1
  100 CONTINUE
      BWID=SIGRND*10.0**LOG
      GOTO200
  150 IF(BWID.LE.ZERO)GOTO10
  200 CONTINUE
      ALB=AL/BWID
      LWID=ALB
      IF(ALB.LT.ZERO)LWID=LWID-1
      BL=BWID*FLOAT(LWID)
      ALB=AH/BWID+1.0
      KWID=ALB
      IF(ALB.LT.ZERO)KWID=KWID-1
      BH=BWID*FLOAT(KWID)
      NB=KWID-LWID
      IF(NAA.GT.5)GOTO240
      IF(NAA.EQ.-1)RETURN
      IF(NAA.GT.1.OR.NB.EQ.1)RETURN
      BWID=BWID*2.0
      NB=1
      RETURN
  240 IF(2*NB.NE.NAA)RETURN
      NA=NA+1
      GOTO20
      END
 
      SUBROUTINEMNCALF(FCN,PVEC,YCALF,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      DIMENSIONPVEC(15)
      NPARX=NPAR
      CALLMNINEX(PVEC)
      CALLFCN(NPARX,GIN,F,U,4,FUTIL)
      NFCN=NFCN+1
      DO200I=1,NPAR
      GRD(I)=0.
      DO200J=1,NPAR
      M=MAX(I,J)
      N=MIN(I,J)
      NDEX=M*(M-1)/2+N
  200 GRD(I)=GRD(I)+VTHMAT(NDEX)*(XT(J)-PVEC(J))
      DENOM=0.
      DO210I=1,NPAR
  210 DENOM=DENOM+GRD(I)*(XT(I)-PVEC(I))
      IF(DENOM.LE.ZERO)THEN
      DCOVAR=1.
      ISW(2)=0
      DENOM=1.0
      ENDIF
      YCALF=(F-APSI)/DENOM
      RETURN
      END
 
      SUBROUTINEMNCLER
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      NPFIX=0
      NU=0
      NPAR=0
      NFCN=0
      NWRMES(1)=0
      NWRMES(2)=0
      DO10I=1,MAXEXT
      U(I)=0.0
      CPNAM(I)=CUNDEF
      NVARL(I)=-1
   10 NIOFEX(I)=0
      CALLMNRSET(1)
      CFROM='CLEAR   '
      NFCNFR=NFCN
      CSTATU='UNDEFINED '
      LNOLIM=.TRUE.
      LPHEAD=.TRUE.
      RETURN
      END
      SUBROUTINEMNCNTR(FCN,KE1,KE2,IERRF,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      PARAMETER(NUMBCS=20,NXMAX=115)
      DIMENSIONCONTUR(NUMBCS),FCNA(NXMAX),FCNB(NXMAX)
      CHARACTERCLABEL*(NUMBCS)
      CHARACTERCHLN*(NXMAX),CHMID*(NXMAX),CHZERO*(NXMAX)
      DATACLABEL/'0123456789ABCDEFGHIJ'/
      IF(KE1.LE.0.OR.KE2.LE.0)GOTO1350
      IF(KE1.GT.NU.OR.KE2.GT.NU)GOTO1350
      KI1=NIOFEX(KE1)
      KI2=NIOFEX(KE2)
      IF(KI1.LE.0.OR.KI2.LE.0)GOTO1350
      IF(KI1.EQ.KI2)GOTO1350
      IF(ISW(2).LT.1)THEN
      CALLMNHESS(FCN,FUTIL)
      CALLMNWERR
      ENDIF
      NPARX=NPAR
      XSAV=U(KE1)
      YSAV=U(KE2)
      DEVS=WORD7(3)
      IF(DEVS.LE.ZERO)DEVS=2.
      XLO=U(KE1)-DEVS*WERR(KI1)
      XUP=U(KE1)+DEVS*WERR(KI1)
      YLO=U(KE2)-DEVS*WERR(KI2)
      YUP=U(KE2)+DEVS*WERR(KI2)
      NGRID=WORD7(4)
      IF(NGRID.LE.0)THEN
      NGRID=25
      NX=MIN(NPAGWD-15,NGRID)
      NY=MIN(NPAGLN-7,NGRID)
      ELSE
      NX=NGRID
      NY=NGRID
      ENDIF
      IF(NX.LT.11)NX=11
      IF(NY.LT.11)NY=11
      IF(NX.GE.NXMAX)NX=NXMAX-1
      IF(NVARL(KE1).GT.1)THEN
      IF(XLO.LT.ALIM(KE1))XLO=ALIM(KE1)
      IF(XUP.GT.BLIM(KE1))XUP=BLIM(KE1)
      ENDIF
      IF(NVARL(KE2).GT.1)THEN
      IF(YLO.LT.ALIM(KE2))YLO=ALIM(KE2)
      IF(YUP.GT.BLIM(KE2))YUP=BLIM(KE2)
      ENDIF
      BWIDX=(XUP-XLO)/REAL(NX)
      BWIDY=(YUP-YLO)/REAL(NY)
      IXMID=INT((XSAV-XLO)*REAL(NX)/(XUP-XLO))+1
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      DO185I=1,NUMBCS
      CONTUR(I)=AMIN+UP*FLOAT(I-1)**2
  185 CONTINUE
      CONTUR(1)=CONTUR(1)+0.01*UP
      U(KE2)=YUP
      IXZERO=0
      XB4=ONE
      DO200IX=1,NX+1
      U(KE1)=XLO+REAL(IX-1)*BWIDX
      CALLFCN(NPARX,GIN,FF,U,4,FUTIL)
      FCNB(IX)=FF
      IF(XB4.LT.ZERO.AND.U(KE1).GT.ZERO)IXZERO=IX-1
      XB4=U(KE1)
      CHMID(IX:IX)='*'
      CHZERO(IX:IX)='-'
  200 CONTINUE
      WRITE(ISYSWR,'(A,I3,A,A)')' Y-AXIS: PARAMETER ',KE2,': ',CPNAM(KE2
     +)
      IF(IXZERO.GT.0)THEN
      CHZERO(IXZERO:IXZERO)='+'
      CHLN=' '
      WRITE(ISYSWR,'(12X,A,A)')CHLN(1:IXZERO),'X=0'
      ENDIF
      DO280IY=1,NY
      UNEXT=U(KE2)-BWIDY
      CHLN=' '
      CHLN(IXMID:IXMID)='*'
      IF(IXZERO.NE.0)CHLN(IXZERO:IXZERO)=':'
      IF(U(KE2).GT.YSAV.AND.UNEXT.LT.YSAV)CHLN=CHMID
      IF(U(KE2).GT.ZERO.AND.UNEXT.LT.ZERO)CHLN=CHZERO
      U(KE2)=UNEXT
      YLABEL=U(KE2)+0.5*BWIDY
      DO220IX=1,NX+1
      FCNA(IX)=FCNB(IX)
      U(KE1)=XLO+REAL(IX-1)*BWIDX
      CALLFCN(NPARX,GIN,FF,U,4,FUTIL)
      FCNB(IX)=FF
  220 CONTINUE
      DO250IX=1,NX
      FMX=MAX(FCNA(IX),FCNB(IX),FCNA(IX+1),FCNB(IX+1))
      FMN=MIN(FCNA(IX),FCNB(IX),FCNA(IX+1),FCNB(IX+1))
      DO230ICS=1,NUMBCS
      IF(CONTUR(ICS).GT.FMN)GOTO240
  230 CONTINUE
      GOTO250
  240 IF(CONTUR(ICS).LT.FMX)CHLN(IX:IX)=CLABEL(ICS:ICS)
  250 CONTINUE
      WRITE(ISYSWR,'(1X,G12.4,1X,A)')YLABEL,CHLN(1:NX)
  280 CONTINUE
      CHLN=' '
      CHLN(1:1)='I'
      CHLN(IXMID:IXMID)='I'
      CHLN(NX:NX)='I'
      WRITE(ISYSWR,'(14X,A)')CHLN(1:NX)
      CHLN=' '
      IF(NX.LE.26)THEN
      NL=MAX(NX-12,2)
      NL2=NL/2
      WRITE(ISYSWR,'(8X,G12.4,A,G12.4)')XLO,CHLN(1:NL),XUP
      WRITE(ISYSWR,'(14X,A,G12.4)')CHLN(1:NL2),XSAV
      ELSE
      NL=MAX(NX-24,2)/2
      NL2=NL
      IF(NL.GT.10)NL2=NL-6
      WRITE(ISYSWR,'(8X,G12.4,A,G12.4,A,G12.4)')XLO,CHLN(1:NL),XSAV,CHLN
     +(1:NL2),XUP
      ENDIF
      WRITE(ISYSWR,'(6X,A,I3,A,A,A,G12.4)')' X-AXIS: PARAMETER',KE1,': '
     +,CPNAM(KE1),'  ONE COLUMN=',BWIDX
      WRITE(ISYSWR,'(A,G12.4,A,G12.4,A)')' FUNCTION VALUES: F(I)=',AMIN,
     +' +',UP,' *I**2'
      U(KE1)=XSAV
      U(KE2)=YSAV
      IERRF=0
      RETURN
 1350 WRITE(ISYSWR,1351)
 1351 FORMAT(' INVALID PARAMETER NUMBER(S) REQUESTED.  IGNORED.'/)
      IERRF=1
      RETURN
      END
 
      SUBROUTINEMNCOMD(FCN,CRDBUF,ICONDN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      DIMENSIONPLIST(MAXP)
      CHARACTERCOMAND*(MAXCWD)
      CHARACTERCLOWER*26,CUPPER*26
      EXTERNALFCN,FUTIL
      CHARACTER*(*)CRDBUF
      DATACLOWER/'abcdefghijklmnopqrstuvwxyz'/
      DATACUPPER/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
      LENBUF=LEN(CRDBUF)
      ICONDN=0
  100 CONTINUE
      DO110I=1,MAXCWD
      IF(CRDBUF(I:I).EQ.'''')GOTO111
      DO108IC=1,26
      IF(CRDBUF(I:I).EQ.CLOWER(IC:IC))CRDBUF(I:I)=CUPPER(IC:IC)
  108 CONTINUE
  110 CONTINUE
  111 CONTINUE
      IF(INDEX(CRDBUF,'PAR').EQ.1)THEN
      ICONDN=5
      LPHEAD=.TRUE.
      GOTO900
      ENDIF
      IF(INDEX(CRDBUF,'SET INP').EQ.1)THEN
      ICONDN=6
      LPHEAD=.TRUE.
      GOTO900
      ENDIF
      IF(INDEX(CRDBUF,'SET TIT').EQ.1)THEN
      ICONDN=7
      LPHEAD=.TRUE.
      GOTO900
      ENDIF
      IF(INDEX(CRDBUF,'SET COV').EQ.1)THEN
      ICONDN=8
      LPHEAD=.TRUE.
      GOTO900
      ENDIF
      DO350IPOS=1,LENBUF
      IF(CRDBUF(IPOS:IPOS).NE.' ')GOTO355
  350 CONTINUE
      WRITE(ISYSWR,'(A)')' BLANK COMMAND IGNORED.'
      ICONDN=1
      GOTO900
  355 IBEGIN=IPOS
      CALLMNCRCK(CRDBUF(IBEGIN:),MAXCWD,COMAND,LNC,MAXP,PLIST,LLIST,IERR
     +,ISYSWR)
      IF(IERR.GT.0)THEN
      WRITE(ISYSWR,'(A)')' COMMAND CANNOT BE INTERPRETED'
      ICONDN=2
      GOTO900
      ENDIF
      CALLMNEXCM(FCN,COMAND(1:LNC),PLIST,LLIST,IERR,FUTIL)
      IF(IERR.EQ.2)ICONDN=3
      IF(IERR.EQ.1)ICONDN=4
      IF(COMAND(1:3).EQ.'END')ICONDN=10
      IF(COMAND(1:3).EQ.'EXI')ICONDN=11
      IF(COMAND(1:3).EQ.'RET')ICONDN=12
      IF(COMAND(1:3).EQ.'STO')ICONDN=11
  900 RETURN
      END
 
      SUBROUTINEMNCONT(FCN,KE1,KE2,NPTU,XPTU,YPTU,IERRF,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      DIMENSIONXPTU(NPTU),YPTU(NPTU),W(MNI),GCC(MNI)
      CHARACTERCHERE*10
      PARAMETER(CHERE='MNContour ')
      LOGICALLDEBUG
      EXTERNALFCN,FUTIL
      LDEBUG=(IDBG(6).GE.1)
      IF(KE1.LE.0.OR.KE2.LE.0)GOTO1350
      IF(KE1.GT.NU.OR.KE2.GT.NU)GOTO1350
      KI1=NIOFEX(KE1)
      KI2=NIOFEX(KE2)
      IF(KI1.LE.0.OR.KI2.LE.0)GOTO1350
      IF(KI1.EQ.KI2)GOTO1350
      IF(NPTU.LT.4)GOTO1400
      NFCNCO=NFCN
      NFCNMX=100*(NPTU+5)*(NPAR+1)
      CALLMNCUVE(FCN,FUTIL)
      U1MIN=U(KE1)
      U2MIN=U(KE2)
      IERRF=0
      CFROM=CHERE
      NFCNFR=NFCNCO
      IF(ISW(5).GE.0)THEN
      WRITE(ISYSWR,'(1X,A,I4,A)')'START MNCONTOUR CALCULATION OF',NPTU,'
     + POINTS ON CONTOUR.'
      IF(NPAR.GT.2)THEN
      IF(NPAR.EQ.3)THEN
      KI3=6-KI1-KI2
      KE3=NEXOFI(KI3)
      WRITE(ISYSWR,'(1X,A,I3,2X,A)')'EACH POINT IS A MINIMUM WITH RESPEC
     +T TO PARAMETER ',KE3,CPNAM(KE3)
      ELSE
      WRITE(ISYSWR,'(1X,A,I3,A)')'EACH POINT IS A MINIMUM WITH RESPECT T
     +O THE OTHER',NPAR-2,' VARIABLE PARAMETERS.'
      ENDIF
      ENDIF
      ENDIF
      CALLMNMNOT(FCN,KE1,KE2,VAL2PL,VAL2MI,FUTIL)
      IF(ERN(KI1).EQ.UNDEFI)THEN
      XPTU(1)=ALIM(KE1)
      CALLMNWARN('W',CHERE,'Contour squeezed by parameter limits.')
      ELSE
      IF(ERN(KI1).GE.ZERO)GOTO1500
      XPTU(1)=U1MIN+ERN(KI1)
      ENDIF
      YPTU(1)=VAL2MI
      IF(ERP(KI1).EQ.UNDEFI)THEN
      XPTU(3)=BLIM(KE1)
      CALLMNWARN('W',CHERE,'Contour squeezed by parameter limits.')
      ELSE
      IF(ERP(KI1).LE.ZERO)GOTO1500
      XPTU(3)=U1MIN+ERP(KI1)
      ENDIF
      YPTU(3)=VAL2PL
      SCALX=1.0/(XPTU(3)-XPTU(1))
      CALLMNMNOT(FCN,KE2,KE1,VAL2PL,VAL2MI,FUTIL)
      IF(ERN(KI2).EQ.UNDEFI)THEN
      YPTU(2)=ALIM(KE2)
      CALLMNWARN('W',CHERE,'Contour squeezed by parameter limits.')
      ELSE
      IF(ERN(KI2).GE.ZERO)GOTO1500
      YPTU(2)=U2MIN+ERN(KI2)
      ENDIF
      XPTU(2)=VAL2MI
      IF(ERP(KI2).EQ.UNDEFI)THEN
      YPTU(4)=BLIM(KE2)
      CALLMNWARN('W',CHERE,'Contour squeezed by parameter limits.')
      ELSE
      IF(ERP(KI2).LE.ZERO)GOTO1500
      YPTU(4)=U2MIN+ERP(KI2)
      ENDIF
      XPTU(4)=VAL2PL
      SCALY=1.0/(YPTU(4)-YPTU(2))
      NOWPTS=4
      NEXT=5
      IF(LDEBUG)THEN
      WRITE(ISYSWR,'(A)')' Plot of four points found by MINOS'
      XPT(1)=U1MIN
      YPT(1)=U2MIN
      CHPT(1)=' '
      NALL=MIN(NOWPTS+1,MAXCPT)
      DO85I=2,NALL
      XPT(I)=XPTU(I-1)
      YPT(I)=YPTU(I-1)
   85 CONTINUE
      CHPT(2)='A'
      CHPT(3)='B'
      CHPT(4)='C'
      CHPT(5)='D'
      CALLMNPLOT(XPT,YPT,CHPT,NALL,ISYSWR,NPAGWD,NPAGLN)
      ENDIF
      ISW2=ISW(2)
      ISW4=ISW(4)
      SIGSAV=EDM
      ISTRAV=ISTRAT
      DC=DCOVAR
      APSI=EPSI*0.5
      ABEST=AMIN
      MPAR=NPAR
      NFMXIN=NFCNMX
      DO125I=1,MPAR
  125 XT(I)=X(I)
      DO130J=1,MPAR*(MPAR+1)/2
  130 VTHMAT(J)=VHMAT(J)
      DO135I=1,MPAR
      GCC(I)=GLOBCC(I)
  135 W(I)=WERR(I)
      KINTS=NIOFEX(KE1)
      CALLMNFIXP(KINTS,IERR)
      KINTS=NIOFEX(KE2)
      CALLMNFIXP(KINTS,IERR)
      DO900INEW=NEXT,NPTU
      BIGDIS=0.
      DO200IOLD=1,INEW-1
      I2=IOLD+1
      IF(I2.EQ.INEW)I2=1
      DIST=(SCALX*(XPTU(IOLD)-XPTU(I2)))**2+(SCALY*(YPTU(IOLD)-YPTU(I2))
     +)**2
      IF(DIST.GT.BIGDIS)THEN
      BIGDIS=DIST
      IDIST=IOLD
      ENDIF
  200 CONTINUE
      I1=IDIST
      I2=I1+1
      IF(I2.EQ.INEW)I2=1
      A1=HALF
      A2=HALF
  300 XMIDCR=A1*XPTU(I1)+A2*XPTU(I2)
      YMIDCR=A1*YPTU(I1)+A2*YPTU(I2)
      XDIR=YPTU(I2)-YPTU(I1)
      YDIR=XPTU(I1)-XPTU(I2)
      SCLFAC=MAX(ABS(XDIR*SCALX),ABS(YDIR*SCALY))
      XDIRCR=XDIR/SCLFAC
      YDIRCR=YDIR/SCLFAC
      KE1CR=KE1
      KE2CR=KE2
      AMIN=ABEST
      CALLMNCROS(FCN,AOPT,IERCR,FUTIL)
      IF(IERCR.GT.1)THEN
      IF(A1.GT.HALF)THEN
      IF(ISW(5).GE.0)WRITE(ISYSWR,'(A,A,I3,A)')' MNCONT CANNOT FIND NEXT
     +',' POINT ON CONTOUR.  ONLY ',NOWPTS,' POINTS FOUND.'
      GOTO950
      ENDIF
      CALLMNWARN('W',CHERE,'Cannot find midpoint, try closer.')
      A1=0.75
      A2=0.25
      GOTO300
      ENDIF
      DO830MOVE=NOWPTS,I1+1,-1
      XPTU(MOVE+1)=XPTU(MOVE)
      YPTU(MOVE+1)=YPTU(MOVE)
  830 CONTINUE
      NOWPTS=NOWPTS+1
      XPTU(I1+1)=XMIDCR+XDIRCR*AOPT
      YPTU(I1+1)=YMIDCR+YDIRCR*AOPT
  900 CONTINUE
  950 CONTINUE
      IERRF=NOWPTS
      CSTATU='SUCCESSFUL'
      IF(NOWPTS.LT.NPTU)CSTATU='INCOMPLETE'
      IF(ISW(5).GE.0)THEN
      XPT(1)=U1MIN
      YPT(1)=U2MIN
      CHPT(1)=' '
      NALL=MIN(NOWPTS+1,MAXCPT)
      DO1000I=2,NALL
      XPT(I)=XPTU(I-1)
      YPT(I)=YPTU(I-1)
      CHPT(I)='X'
 1000 CONTINUE
      WRITE(ISYSWR,'(A,I3,2X,A)')' Y-AXIS: PARAMETER ',KE2,CPNAM(KE2)
      CALLMNPLOT(XPT,YPT,CHPT,NALL,ISYSWR,NPAGWD,NPAGLN)
      WRITE(ISYSWR,'(25X,A,I3,2X,A)')'X-AXIS: PARAMETER ',KE1,CPNAM(KE1)
      ENDIF
      IF(ISW(5).GE.1)THEN
      NPCOL=(NOWPTS+1)/2
      NFCOL=NOWPTS/2
      WRITE(ISYSWR,'(/I5,A,G13.5,A,G11.3)')NOWPTS,' POINTS ON CONTOUR.  
     + FMIN=',ABEST,'   ERRDEF=',UP
      WRITE(ISYSWR,'(9X,A,3X,A,18X,A,3X,A)')CPNAM(KE1),CPNAM(KE2),CPNAM(
     +KE1),CPNAM(KE2)
      DO1050LINE=1,NFCOL
      LR=LINE+NPCOL
      WRITE(ISYSWR,'(1X,I5,2G13.5,10X,I5,2G13.5)')LINE,XPTU(LINE),YPTU(L
     +INE),LR,XPTU(LR),YPTU(LR)
 1050 CONTINUE
      IF(NFCOL.LT.NPCOL)WRITE(ISYSWR,'(1X,I5,2G13.5)')NPCOL,XPTU(NPCOL),
     +YPTU(NPCOL)
      ENDIF
      ITAUR=1
      CALLMNFREE(1)
      CALLMNFREE(1)
      DO1100J=1,MPAR*(MPAR+1)/2
 1100 VHMAT(J)=VTHMAT(J)
      DO1120I=1,MPAR
      GLOBCC(I)=GCC(I)
      WERR(I)=W(I)
 1120 X(I)=XT(I)
      CALLMNINEX(X)
      EDM=SIGSAV
      AMIN=ABEST
      ISW(2)=ISW2
      ISW(4)=ISW4
      DCOVAR=DC
      ITAUR=0
      NFCNMX=NFMXIN
      ISTRAT=ISTRAV
      U(KE1)=U1MIN
      U(KE2)=U2MIN
      GOTO2000
 1350 WRITE(ISYSWR,'(A)')' INVALID PARAMETER NUMBERS.'
      GOTO1450
 1400 WRITE(ISYSWR,'(A)')' LESS THAN FOUR POINTS REQUESTED.'
 1450 IERRF=-1
      CSTATU='USER ERROR'
      GOTO2000
 1500 WRITE(ISYSWR,'(A)')' MNCONT UNABLE TO FIND FOUR POINTS.'
      U(KE1)=U1MIN
      U(KE2)=U2MIN
      IERRF=0
      CSTATU='FAILED'
 2000 CONTINUE
      CFROM=CHERE
      NFCNFR=NFCNCO
      RETURN
      END
      SUBROUTINEMNCRCK(CRDBUF,MAXCWD,COMAND,LNC,MXP,PLIST,LLIST,IERR,ISY
     +SWR)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MAXELM=25,MXLNEL=19)
      CHARACTER*(*)COMAND,CRDBUF
      CHARACTERCNUMER*13,CELMNT(MAXELM)*(MXLNEL),CNULL*15
      DIMENSIONLELMNT(MAXELM),PLIST(MXP)
      DATACNULL/')NULL STRING   '/
      DATACNUMER/'123456789-.0+'/
      IELMNT=0
      LEND=LEN(CRDBUF)
      NEXTB=1
      IERR=0
   10 CONTINUE
      DO100IPOS=NEXTB,LEND
      IBEGIN=IPOS
      IF(CRDBUF(IPOS:IPOS).EQ.' ')GOTO100
      IF(CRDBUF(IPOS:IPOS).EQ.',')GOTO250
      GOTO150
  100 CONTINUE
      GOTO300
  150 CONTINUE
      DO180IPOS=IBEGIN+1,LEND
      IF(CRDBUF(IPOS:IPOS).EQ.' ')GOTO250
      IF(CRDBUF(IPOS:IPOS).EQ.',')GOTO250
  180 CONTINUE
      IPOS=LEND+1
  250 IEND=IPOS-1
      IELMNT=IELMNT+1
      IF(IEND.GE.IBEGIN)THEN
      CELMNT(IELMNT)=CRDBUF(IBEGIN:IEND)
      ELSE
      CELMNT(IELMNT)=CNULL
      ENDIF
      LELMNT(IELMNT)=IEND-IBEGIN+1
      IF(LELMNT(IELMNT).GT.MXLNEL)THEN
      WRITE(ISYSWR,253)CRDBUF(IBEGIN:IEND),CELMNT(IELMNT)
  253 FORMAT(' MINUIT WARNING: INPUT DATA WORD TOO LONG.'/'     ORIGINAL
     +:',A/' TRUNCATED TO:',A)
      LELMNT(IELMNT)=MXLNEL
      ENDIF
      IF(IPOS.GE.LEND)GOTO300
      IF(IELMNT.GE.MAXELM)GOTO300
      DO280IPOS=IEND+1,LEND
      IF(CRDBUF(IPOS:IPOS).EQ.' ')GOTO280
      NEXTB=IPOS
      IF(CRDBUF(IPOS:IPOS).EQ.',')NEXTB=IPOS+1
      GOTO10
  280 CONTINUE
  300 CONTINUE
      NELMNT=IELMNT
      COMAND=' '
      LNC=1
      PLIST(1)=0.
      LLIST=0
      IF(IELMNT.EQ.0)GOTO900
      KCMND=0
      DO400IELMNT=1,NELMNT
      IF(CELMNT(IELMNT).EQ.CNULL)GOTO450
      DO350IC=1,13
      IF(CELMNT(IELMNT)(1:1).EQ.CNUMER(IC:IC))GOTO450
  350 CONTINUE
      IF(KCMND.GE.MAXCWD)GOTO400
      LEFT=MAXCWD-KCMND
      LTOADD=LELMNT(IELMNT)
      IF(LTOADD.GT.LEFT)LTOADD=LEFT
      COMAND(KCMND+1:KCMND+LTOADD)=CELMNT(IELMNT)(1:LTOADD)
      KCMND=KCMND+LTOADD
      IF(KCMND.EQ.MAXCWD)GOTO400
      KCMND=KCMND+1
      COMAND(KCMND:KCMND)=' '
  400 CONTINUE
      LNC=KCMND
      GOTO900
  450 CONTINUE
      LNC=KCMND
      LLIST=0
      DO600IFLD=IELMNT,NELMNT
      LLIST=LLIST+1
      IF(LLIST.GT.MXP)THEN
      NREQ=NELMNT-IELMNT+1
      WRITE(ISYSWR,511)NREQ,MXP
  511 FORMAT(/' MINUIT WARNING IN MNCRCK: '/' COMMAND HAS INPUT',I5,' NU
     +MERIC FIELDS, BUT MINUIT CAN ACCEPT ONLY',I3)
      GOTO900
      ENDIF
      IF(CELMNT(IFLD).EQ.CNULL)THEN
      PLIST(LLIST)=0.
      ELSE
      READ(CELMNT(IFLD),'(BN,F19.0)',ERR=575)PLIST(LLIST)
      ENDIF
      GOTO600
  575 WRITE(ISYSWR,'(A,A,A)')' FORMAT ERROR IN NUMERIC FIELD: "',CELMNT(
     +IFLD)(1:LELMNT(IFLD)),'"'
      IERR=1
      PLIST(LLIST)=0.
  600 CONTINUE
  900 CONTINUE
      IF(LNC.LE.0)LNC=1
      RETURN
      END
 
      SUBROUTINEMNCROS(FCN,AOPT,IERCR,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      CHARACTERCHERE*10,CHARAL*28,CHSIGN*4
      PARAMETER(CHERE='MNCONTour ',MLSB=3,MAXITR=15,TLR=0.01)
      DIMENSIONFLSB(MLSB),ALSB(MLSB),COEFF(3)
      LOGICALLDEBUG
      EXTERNALFCN,FUTIL
      DATACHARAL/' .ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
      LDEBUG=(IDBG(6).GE.1)
      AMINSV=AMIN
      AIM=AMIN+UP
      TLF=TLR*UP
      TLA=TLR*0.1
      XPT(1)=0.0
      YPT(1)=AIM
      CHPT(1)=' '
      XPT(2)=-1.0
      YPT(2)=AMIN
      CHPT(2)='.'
      IPT=2
      AULIM=100.
      DO100IK=1,2
      IF(IK.EQ.1)THEN
      KEX=KE1CR
      ZMID=XMIDCR
      ZDIR=XDIRCR
      ELSE
      IF(KE2CR.EQ.0)GOTO100
      KEX=KE2CR
      ZMID=YMIDCR
      ZDIR=YDIRCR
      ENDIF
      IF(NVARL(KEX).LE.1)GOTO100
      IF(ZDIR.EQ.ZERO)GOTO100
      ZLIM=ALIM(KEX)
      IF(ZDIR.GT.ZERO)ZLIM=BLIM(KEX)
      AULIM=MIN(AULIM,(ZLIM-ZMID)/ZDIR)
  100 CONTINUE
      ANEXT=0.
      AOPT=ANEXT
      LIMSET=.FALSE.
      IF(AULIM.LT.AOPT+TLA)LIMSET=.TRUE.
      CALLMNEVAL(FCN,ANEXT,FNEXT,IEREV,FUTIL)
      IF(LDEBUG)WRITE(ISYSWR,'(A,I8,A,F10.5,A,2F10.5)')' MNCROS: calls='
     +,NFCN,'   AIM=',AIM,'  F,A=',FNEXT,AOPT
      IF(IEREV.GT.0)GOTO900
      IF(LIMSET.AND.FNEXT.LE.AIM)GOTO930
      IPT=IPT+1
      XPT(IPT)=ANEXT
      YPT(IPT)=FNEXT
      CHPT(IPT)=CHARAL(IPT:IPT)
      ALSB(1)=ANEXT
      FLSB(1)=FNEXT
      FNEXT=MAX(FNEXT,AMINSV+0.1*UP)
      AOPT=SQRT((UP)/(FNEXT-AMINSV))-1.0
      IF(ABS(FNEXT-AIM).LT.TLF)GOTO800
      IF(AOPT.LT.-0.5)AOPT=-0.5
      LIMSET=.FALSE.
      IF(AOPT.GT.AULIM)THEN
      AOPT=AULIM
      LIMSET=.TRUE.
      ENDIF
      CALLMNEVAL(FCN,AOPT,FNEXT,IEREV,FUTIL)
      IF(LDEBUG)WRITE(ISYSWR,'(A,I8,A,F10.5,A,2F10.5)')' MNCROS: calls='
     +,NFCN,'   AIM=',AIM,'  F,A=',FNEXT,AOPT
      IF(IEREV.GT.0)GOTO900
      IF(LIMSET.AND.FNEXT.LE.AIM)GOTO930
      ALSB(2)=AOPT
      IPT=IPT+1
      XPT(IPT)=ALSB(2)
      YPT(IPT)=FNEXT
      CHPT(IPT)=CHARAL(IPT:IPT)
      FLSB(2)=FNEXT
      DFDA=(FLSB(2)-FLSB(1))/(ALSB(2)-ALSB(1))
      IF(DFDA.GT.ZERO)GOTO460
  300 CALLMNWARN('D',CHERE,'Looking for slope of the right sign')
      MAXLK=MAXITR-IPT
      DO400IT=1,MAXLK
      ALSB(1)=ALSB(2)
      FLSB(1)=FLSB(2)
      AOPT=ALSB(1)+0.2*REAL(IT)
      LIMSET=.FALSE.
      IF(AOPT.GT.AULIM)THEN
      AOPT=AULIM
      LIMSET=.TRUE.
      ENDIF
      CALLMNEVAL(FCN,AOPT,FNEXT,IEREV,FUTIL)
      IF(LDEBUG)WRITE(ISYSWR,'(A,I8,A,F10.5,A,2F10.5)')' MNCROS: calls='
     +,NFCN,'   AIM=',AIM,'  F,A=',FNEXT,AOPT
      IF(IEREV.GT.0)GOTO900
      IF(LIMSET.AND.FNEXT.LE.AIM)GOTO930
      ALSB(2)=AOPT
      IPT=IPT+1
      XPT(IPT)=ALSB(2)
      YPT(IPT)=FNEXT
      CHPT(IPT)=CHARAL(IPT:IPT)
      FLSB(2)=FNEXT
      DFDA=(FLSB(2)-FLSB(1))/(ALSB(2)-ALSB(1))
      IF(DFDA.GT.ZERO)GOTO450
  400 CONTINUE
      CALLMNWARN('W',CHERE,'Cannot find slope of the right sign')
      GOTO950
  450 CONTINUE
  460 AOPT=ALSB(2)+(AIM-FLSB(2))/DFDA
      IF(MIN(ABS(AOPT-ALSB(1)),ABS(AOPT-ALSB(2))).LT.TLA)GOTO800
      IF(IPT.GE.MAXITR)GOTO950
      BMIN=MIN(ALSB(1),ALSB(2))-1.0
      IF(AOPT.LT.BMIN)AOPT=BMIN
      BMAX=MAX(ALSB(1),ALSB(2))+1.0
      IF(AOPT.GT.BMAX)AOPT=BMAX
      LIMSET=.FALSE.
      IF(AOPT.GT.AULIM)THEN
      AOPT=AULIM
      LIMSET=.TRUE.
      ENDIF
      CALLMNEVAL(FCN,AOPT,FNEXT,IEREV,FUTIL)
      IF(LDEBUG)WRITE(ISYSWR,'(A,I8,A,F10.5,A,2F10.5)')' MNCROS: calls='
     +,NFCN,'   AIM=',AIM,'  F,A=',FNEXT,AOPT
      IF(IEREV.GT.0)GOTO900
      IF(LIMSET.AND.FNEXT.LE.AIM)GOTO930
      ALSB(3)=AOPT
      IPT=IPT+1
      XPT(IPT)=ALSB(3)
      YPT(IPT)=FNEXT
      CHPT(IPT)=CHARAL(IPT:IPT)
      FLSB(3)=FNEXT
      INEW=3
      ECARMN=ABS(FNEXT-AIM)
      IBEST=3
      ECARMX=0.
      NOLESS=0
      DO480I=1,3
      ECART=ABS(FLSB(I)-AIM)
      IF(ECART.GT.ECARMX)THEN
      ECARMX=ECART
      IWORST=I
      ENDIF
      IF(ECART.LT.ECARMN)THEN
      ECARMN=ECART
      IBEST=I
      ENDIF
      IF(FLSB(I).LT.AIM)NOLESS=NOLESS+1
  480 CONTINUE
      IF(NOLESS.EQ.1.OR.NOLESS.EQ.2)GOTO500
      IF(NOLESS.EQ.0.AND.IBEST.NE.3)GOTO950
      IF(NOLESS.EQ.3.AND.IBEST.NE.3)THEN
      ALSB(2)=ALSB(3)
      FLSB(2)=FLSB(3)
      GOTO300
      ENDIF
      ALSB(IWORST)=ALSB(3)
      FLSB(IWORST)=FLSB(3)
      DFDA=(FLSB(2)-FLSB(1))/(ALSB(2)-ALSB(1))
      GOTO460
  500 CALLMNPFIT(ALSB,FLSB,3,COEFF,SDEV)
      IF(COEFF(3).LE.ZERO)CALLMNWARN('D',CHERE,'Curvature is negative ne
     +ar contour line.')
      DETERM=COEFF(2)**2-4.*COEFF(3)*(COEFF(1)-AIM)
      IF(DETERM.LE.ZERO)THEN
      CALLMNWARN('D',CHERE,'Problem 2, impossible determinant')
      GOTO950
      ENDIF
      RT=SQRT(DETERM)
      X1=(-COEFF(2)+RT)/(2.*COEFF(3))
      X2=(-COEFF(2)-RT)/(2.*COEFF(3))
      S1=COEFF(2)+2.*X1*COEFF(3)
      S2=COEFF(2)+2.*X2*COEFF(3)
      IF(S1*S2.GT.ZERO)WRITE(ISYSWR,'(A)')' MNCONTour problem 1'
      AOPT=X1
      IF(S2.GT.ZERO)AOPT=X2
      IF(ABS(AOPT-ALSB(INEW)).LT.TLA)GOTO800
      IF(IPT.GE.MAXITR)GOTO950
      LIMSET=.FALSE.
      IF(AOPT.GT.AULIM)THEN
      AOPT=AULIM
      LIMSET=.TRUE.
      ENDIF
      CALLMNEVAL(FCN,AOPT,FNEXT,IEREV,FUTIL)
      IF(LDEBUG)WRITE(ISYSWR,'(A,I8,A,F10.5,A,2F10.5)')' MNCROS: calls='
     +,NFCN,'   AIM=',AIM,'  F,A=',FNEXT,AOPT
      IF(IEREV.GT.0)GOTO900
      IF(LIMSET.AND.FNEXT.LE.AIM)GOTO930
      IPT=IPT+1
      XPT(IPT)=AOPT
      YPT(IPT)=FNEXT
      CHPT(IPT)=CHARAL(IPT:IPT)
      INEAR=1
      ANEAR=ALSB(1)
      IFAR=1
      AFAR=ALSB(1)
      DO620I=1,3
      IF(ALSB(I).LT.ANEAR)THEN
      ANEAR=ALSB(I)
      INEAR=I
      ENDIF
      IF(ALSB(I).GT.AFAR)THEN
      AFAR=ALSB(I)
      IFAR=I
      ENDIF
  620 CONTINUE
      IMID=6-INEAR-IFAR
      FDIST=FLSB(IMID)-AIM
      IF(FDIST*(FLSB(INEAR)-AIM).GT.ZERO)THEN
      INEW=INEAR
      ELSE
      INEW=IFAR
      ENDIF
      ALSB(INEW)=AOPT
      FLSB(INEW)=FNEXT
      GOTO500
  800 CONTINUE
      IERCR=0
      GOTO1000
  900 IF(IEREV.EQ.1)GOTO940
      GOTO950
  930 IERCR=1
      GOTO1000
  940 IERCR=2
      GOTO1000
  950 IERCR=3
 1000 CONTINUE
      IF(LDEBUG)THEN
      ITOOHI=0
      DO1100I=1,IPT
      IF(YPT(I).GT.AIM+UP)THEN
      YPT(I)=AIM+UP
      CHPT(I)='+'
      ITOOHI=1
      ENDIF
 1100 CONTINUE
      CHSIGN='POSI'
      IF(XDIRCR.LT.ZERO)CHSIGN='NEGA'
      IF(KE2CR.EQ.0)WRITE(ISYSWR,'(2X,A,A,I3)')CHSIGN,'TIVE MINOS ERROR,
     + PARAMETER ',KE1CR
      IF(ITOOHI.EQ.1)WRITE(ISYSWR,'(10X,A)')'POINTS LABELLED "+" WERE TO
     +O HIGH TO PLOT.'
      IF(IERCR.EQ.1)WRITE(ISYSWR,'(10X,A)')'RIGHTMOST POINT IS UP AGAINS
     +T LIMIT.'
      CALLMNPLOT(XPT,YPT,CHPT,IPT,ISYSWR,NPAGWD,NPAGLN)
      ENDIF
      RETURN
      END
 
      SUBROUTINEMNCUVE(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      IF(ISW(4).LT.1)THEN
      WRITE(ISYSWR,'(/A,A)')' FUNCTION MUST BE MINIMIZED BEFORE CALLING 
     +',CFROM
      APSI=EPSI
      CALLMNMIGR(FCN,FUTIL)
      ENDIF
      IF(ISW(2).LT.3)THEN
      CALLMNHESS(FCN,FUTIL)
      IF(ISW(2).LT.1)THEN
      CALLMNWARN('W',CFROM,'NO ERROR MATRIX.  WILL IMPROVISE.')
      DO555I=1,NPAR
      NDEX=I*(I-1)/2
      DO554J=1,I-1
      NDEX=NDEX+1
  554 VHMAT(NDEX)=0.
      NDEX=NDEX+1
      IF(G2(I).LE.ZERO)THEN
      WINT=WERR(I)
      IEXT=NEXOFI(I)
      IF(NVARL(IEXT).GT.1)THEN
      CALLMNDXDI(X(I),I,DXDI)
      IF(ABS(DXDI).LT..001)THEN
      WINT=.01
      ELSE
      WINT=WINT/ABS(DXDI)
      ENDIF
      ENDIF
      G2(I)=UP/WINT**2
      ENDIF
      VHMAT(NDEX)=2./G2(I)
  555 CONTINUE
      ISW(2)=1
      DCOVAR=1.
      ELSE
      CALLMNWERR
      ENDIF
      ENDIF
      RETURN
      END
 
      SUBROUTINEMNDERI(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      LOGICALLDEBUG
      CHARACTERCBF1*22
      NPARX=NPAR
      LDEBUG=(IDBG(2).GE.1)
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      IF(ISW(3).EQ.1)GOTO100
      IF(LDEBUG)THEN
      CALLMNINEX(X)
      NPARX=NPAR
      CALLFCN(NPARX,GIN,FS1,U,4,FUTIL)
      NFCN=NFCN+1
      IF(FS1.NE.AMIN)THEN
      DF=AMIN-FS1
      WRITE(CBF1(1:12),'(G12.3)')DF
      CALLMNWARN('D','MNDERI','function value differs from AMIN by '//CB
     +F1(1:12))
      AMIN=FS1
      ENDIF
      WRITE(ISYSWR,'(/''  FIRST DERIVATIVE DEBUG PRINTOUT.  MNDERI''/   
     +'' PAR    DERIV     STEP      MINSTEP   OPTSTEP '',   '' D1-D2    
     +2ND DRV'')')
      ENDIF
      DFMIN=8.*EPSMA2*(ABS(AMIN)+UP)
      IF(ISTRAT.LE.0)THEN
      NCYC=2
      TLRSTP=0.5
      TLRGRD=0.1
      ELSEIF(ISTRAT.EQ.1)THEN
      NCYC=3
      TLRSTP=0.3
      TLRGRD=0.05
      ELSE
      NCYC=5
      TLRSTP=0.1
      TLRGRD=0.02
      ENDIF
      DO60I=1,NPAR
      EPSPRI=EPSMA2+ABS(GRD(I)*EPSMA2)
      XTF=X(I)
      STEPB4=0.
      DO45ICYC=1,NCYC
      OPTSTP=SQRT(DFMIN/(ABS(G2(I))+EPSPRI))
      STEP=MAX(OPTSTP,ABS(0.1*GSTEP(I)))
      IF(GSTEP(I).LT.ZERO.AND.STEP.GT.0.5)STEP=0.5
      STPMAX=10.*ABS(GSTEP(I))
      IF(STEP.GT.STPMAX)STEP=STPMAX
      STPMIN=8.*ABS(EPSMA2*X(I))
      IF(STEP.LT.STPMIN)STEP=STPMIN
      IF(ABS((STEP-STEPB4)/STEP).LT.TLRSTP)GOTO50
      GSTEP(I)=SIGN(STEP,GSTEP(I))
      STEPB4=STEP
      X(I)=XTF+STEP
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,FS1,U,4,FUTIL)
      NFCN=NFCN+1
      X(I)=XTF-STEP
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,FS2,U,4,FUTIL)
      NFCN=NFCN+1
      GRBFOR=GRD(I)
      GRD(I)=(FS1-FS2)/(2.0*STEP)
      G2(I)=(FS1+FS2-2.0*AMIN)/(STEP**2)
      X(I)=XTF
      IF(LDEBUG)THEN
      D1D2=(FS1+FS2-2.0*AMIN)/STEP
      WRITE(ISYSWR,41)I,GRD(I),STEP,STPMIN,OPTSTP,D1D2,G2(I)
   41 FORMAT(I4,2G11.3,5G10.2)
      ENDIF
      IF(ABS(GRBFOR-GRD(I))/(ABS(GRD(I))+DFMIN/STEP).LT.TLRGRD)GOTO50
   45 CONTINUE
      IF(NCYC.EQ.1)GOTO50
      WRITE(CBF1,'(2E11.3)')GRD(I),GRBFOR
      CALLMNWARN('D','MNDERI','First derivative not converged. '//CBF1)
   50 CONTINUE
   60 CONTINUE
      CALLMNINEX(X)
      RETURN
  100 DO150IINT=1,NPAR
      IEXT=NEXOFI(IINT)
      IF(NVARL(IEXT).GT.1)GOTO120
      GRD(IINT)=GIN(IEXT)
      GOTO150
  120 DD=(BLIM(IEXT)-ALIM(IEXT))*0.5*COS(X(IINT))
      GRD(IINT)=GIN(IEXT)*DD
  150 CONTINUE
  200 RETURN
      END
 
      SUBROUTINEMNDXDI(PINT,IPAR,DXDI)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      I=NEXOFI(IPAR)
      DXDI=1.0
      IF(NVARL(I).GT.1)DXDI=0.5*ABS((BLIM(I)-ALIM(I))*COS(PINT))
      RETURN
      END
      SUBROUTINEMNEIG(A,NDIMA,N,MITS,WORK,PRECIS,IFAULT)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(ZERO=0.0,ONE=1.0,TWO=2.0)
      PARAMETER(TOL=1.0E-35)
      DIMENSIONA(NDIMA,*),WORK(*)
      IFAULT=1
      I=N
      DO70I1=2,N
      L=I-2
      F=A(I,I-1)
      GL=ZERO
      IF(L.LT.1)GOTO25
      DO20K=1,L
   20 GL=GL+A(I,K)**2
   25 H=GL+F**2
      IF(GL.GT.TOL)GOTO30
      WORK(I)=ZERO
      WORK(N+I)=F
      GOTO65
   30 L=L+1
      GL=SQRT(H)
      IF(F.GE.ZERO)GL=-GL
      WORK(N+I)=GL
      H=H-F*GL
      A(I,I-1)=F-GL
      F=ZERO
      DO50J=1,L
      A(J,I)=A(I,J)/H
      GL=ZERO
      DO40K=1,J
   40 GL=GL+A(J,K)*A(I,K)
      IF(J.GE.L)GOTO47
      J1=J+1
      DO45K=J1,L
   45 GL=GL+A(K,J)*A(I,K)
   47 WORK(N+J)=GL/H
      F=F+GL*A(J,I)
   50 CONTINUE
      HH=F/(H+H)
      DO60J=1,L
      F=A(I,J)
      GL=WORK(N+J)-HH*F
      WORK(N+J)=GL
      DO60K=1,J
      A(J,K)=A(J,K)-F*WORK(N+K)-GL*A(I,K)
   60 CONTINUE
      WORK(I)=H
   65 I=I-1
   70 CONTINUE
      WORK(1)=ZERO
      WORK(N+1)=ZERO
      DO110I=1,N
      L=I-1
      IF(WORK(I).EQ.ZERO.OR.L.EQ.0)GOTO100
      DO90J=1,L
      GL=ZERO
      DO80K=1,L
   80 GL=GL+A(I,K)*A(K,J)
      DO90K=1,L
      A(K,J)=A(K,J)-GL*A(K,I)
   90 CONTINUE
  100 WORK(I)=A(I,I)
      A(I,I)=ONE
      IF(L.EQ.0)GOTO110
      DO105J=1,L
      A(I,J)=ZERO
      A(J,I)=ZERO
  105 CONTINUE
  110 CONTINUE
      N1=N-1
      DO130I=2,N
      I0=N+I-1
  130 WORK(I0)=WORK(I0+1)
      WORK(N+N)=ZERO
      B=ZERO
      F=ZERO
      DO210L=1,N
      J=0
      H=PRECIS*(ABS(WORK(L))+ABS(WORK(N+L)))
      IF(B.LT.H)B=H
      DO140M1=L,N
      M=M1
      IF(ABS(WORK(N+M)).LE.B)GOTO150
  140 CONTINUE
  150 IF(M.EQ.L)GOTO205
  160 IF(J.EQ.MITS)RETURN
      J=J+1
      PT=(WORK(L+1)-WORK(L))/(TWO*WORK(N+L))
      R=SQRT(PT*PT+ONE)
      PR=PT+R
      IF(PT.LT.ZERO)PR=PT-R
      H=WORK(L)-WORK(N+L)/PR
      DO170I=L,N
  170 WORK(I)=WORK(I)-H
      F=F+H
      PT=WORK(M)
      C=ONE
      S=ZERO
      M1=M-1
      I=M
      DO200I1=L,M1
      J=I
      I=I-1
      GL=C*WORK(N+I)
      H=C*PT
      IF(ABS(PT).GE.ABS(WORK(N+I)))GOTO180
      C=PT/WORK(N+I)
      R=SQRT(C*C+ONE)
      WORK(N+J)=S*WORK(N+I)*R
      S=ONE/R
      C=C/R
      GOTO190
  180 C=WORK(N+I)/PT
      R=SQRT(C*C+ONE)
      WORK(N+J)=S*PT*R
      S=C/R
      C=ONE/R
  190 PT=C*WORK(I)-S*GL
      WORK(J)=H+S*(C*GL+S*WORK(I))
      DO200K=1,N
      H=A(K,J)
      A(K,J)=S*A(K,I)+C*H
      A(K,I)=C*A(K,I)-S*H
  200 CONTINUE
      WORK(N+L)=S*PT
      WORK(L)=C*PT
      IF(ABS(WORK(N+L)).GT.B)GOTO160
  205 WORK(L)=WORK(L)+F
  210 CONTINUE
      DO240I=1,N1
      K=I
      PT=WORK(I)
      I1=I+1
      DO220J=I1,N
      IF(WORK(J).GE.PT)GOTO220
      K=J
      PT=WORK(J)
  220 CONTINUE
      IF(K.EQ.I)GOTO240
      WORK(K)=WORK(I)
      WORK(I)=PT
      DO230J=1,N
      PT=A(J,I)
      A(J,I)=A(J,K)
      A(J,K)=PT
  230 CONTINUE
  240 CONTINUE
      IFAULT=0
      RETURN
      END
 
      SUBROUTINEMNEMAT(EMAT,NDIM)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      DIMENSIONEMAT(NDIM,NDIM)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      IF(ISW(2).LT.1)RETURN
      IF(ISW(5).GE.2)WRITE(ISYSWR,'(/A,I4,A,I3,A,G10.2)')' EXTERNAL ERRO
     +R MATRIX.    NDIM=',NDIM,'    NPAR=',NPAR,'    ERR DEF=',UP
      NPARD=NPAR
      IF(NDIM.LT.NPAR)THEN
      NPARD=NDIM
      IF(ISW(5).GE.0)WRITE(ISYSWR,'(A,A)')' USER-DIMENSIONED ',' ARRAY E
     +MAT NOT BIG ENOUGH. REDUCED MATRIX CALCULATED.'
      ENDIF
      NPERLN=(NPAGWD-5)/10
      NPERLN=MIN(NPERLN,13)
      IF(ISW(5).GE.1.AND.NPARD.GT.NPERLN)WRITE(ISYSWR,'(A)')' ELEMENTS A
     +BOVE DIAGONAL ARE NOT PRINTED.'
      DO110I=1,NPARD
      CALLMNDXDI(X(I),I,DXDI)
      KGA=I*(I-1)/2
      DO100J=1,I
      CALLMNDXDI(X(J),J,DXDJ)
      KGB=KGA+J
      EMAT(I,J)=DXDI*VHMAT(KGB)*DXDJ*UP
      EMAT(J,I)=EMAT(I,J)
  100 CONTINUE
  110 CONTINUE
      IF(ISW(5).GE.2)THEN
      DO160I=1,NPARD
      IZ=NPARD
      IF(NPARD.GE.NPERLN)IZ=I
      DO150K=1,IZ,NPERLN
      K2=K+NPERLN-1
      IF(K2.GT.IZ)K2=IZ
      WRITE(ISYSWR,'(1X,13E10.3)')(EMAT(I,KK),KK=K,K2)
  150 CONTINUE
  160 CONTINUE
      ENDIF
      RETURN
      END
 
      SUBROUTINEMNERRS(NUMBER,EPLUS,EMINUS,EPARAB,GCC)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      IEX=NUMBER
      IF(NUMBER.LT.0)THEN
      IIN=-NUMBER
      IF(IIN.GT.NPAR)GOTO900
      IEX=NEXOFI(IIN)
      ENDIF
      IF(IEX.GT.NU.OR.IEX.LE.0)GOTO900
      IIN=NIOFEX(IEX)
      IF(IIN.LE.0)GOTO900
      EPLUS=ERP(IIN)
      IF(EPLUS.EQ.UNDEFI)EPLUS=0.
      EMINUS=ERN(IIN)
      IF(EMINUS.EQ.UNDEFI)EMINUS=0.
      CALLMNDXDI(X(IIN),IIN,DXDI)
      NDIAG=IIN*(IIN+1)/2
      EPARAB=ABS(DXDI*SQRT(ABS(UP*VHMAT(NDIAG))))
      GCC=0.
      IF(ISW(2).LT.2)GOTO990
      GCC=GLOBCC(IIN)
      GOTO990
  900 EPLUS=0.
      EMINUS=0.
      EPARAB=0.
      GCC=0.
  990 RETURN
      END
 
      SUBROUTINEMNEVAL(FCN,ANEXT,FNEXT,IEREV,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      U(KE1CR)=XMIDCR+ANEXT*XDIRCR
      IF(KE2CR.NE.0)U(KE2CR)=YMIDCR+ANEXT*YDIRCR
      CALLMNINEX(X)
      NPARX=NPAR
      CALLFCN(NPARX,GIN,FNEXT,U,4,FUTIL)
      NFCN=NFCN+1
      IEREV=0
      IF(NPAR.GT.0)THEN
      ITAUR=1
      AMIN=FNEXT
      ISW(1)=0
      CALLMNMIGR(FCN,FUTIL)
      ITAUR=0
      FNEXT=AMIN
      IF(ISW(1).GE.1)IEREV=1
      IF(ISW(4).LT.1)IEREV=2
      ENDIF
      RETURN
      END
 
      SUBROUTINEMNEXCM(FCN,COMAND,PLIST,LLIST,IERFLG,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      CHARACTER*(*)COMAND
      DIMENSIONPLIST(*)
      PARAMETER(MXPT=101)
      DIMENSIONXPTU(MXPT),YPTU(MXPT)
      CHARACTER*10CNAME(40),CNEWAY,CHWHY*18,C26*30,CVBLNK*2
      LOGICALLTOFIX,LFIXED,LFREED
      CHARACTERCOMD*4
      CHARACTERCLOWER*26,CUPPER*26
      DATACLOWER/'abcdefghijklmnopqrstuvwxyz'/
      DATACUPPER/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
      DATACNAME(1)/'MINImize  '/
      DATACNAME(2)/'SEEk      '/
      DATACNAME(3)/'SIMplex   '/
      DATACNAME(4)/'MIGrad    '/
      DATACNAME(5)/'MINOs     '/
      DATACNAME(6)/'SET xxx   '/
      DATACNAME(7)/'SHOw xxx  '/
      DATACNAME(8)/'TOP of pag'/
      DATACNAME(9)/'FIX       '/
      DATACNAME(10)/'REStore   '/
      DATACNAME(11)/'RELease   '/
      DATACNAME(12)/'SCAn      '/
      DATACNAME(13)/'CONtour   '/
      DATACNAME(14)/'HESse     '/
      DATACNAME(15)/'SAVe      '/
      DATACNAME(16)/'IMProve   '/
      DATACNAME(17)/'CALl fcn  '/
      DATACNAME(18)/'STAndard  '/
      DATACNAME(19)/'END       '/
      DATACNAME(20)/'EXIt      '/
      DATACNAME(21)/'RETurn    '/
      DATACNAME(22)/'CLEar     '/
      DATACNAME(23)/'HELP      '/
      DATACNAME(24)/'MNContour '/
      DATACNAME(25)/'STOp      '/
      DATACNAME(26)/'JUMp      '/
      DATANNAME/26/
      DATACNAME(27)/'          '/
      DATACNAME(28)/'          '/
      DATACNAME(29)/'          '/
      DATACNAME(30)/'          '/
      DATACNAME(31)/'          '/
      DATACNAME(32)/'          '/
      DATACNAME(33)/'          '/
      DATACNAME(34)/'COVARIANCE'/
      DATACNAME(35)/'PRINTOUT  '/
      DATACNAME(36)/'GRADIENT  '/
      DATACNAME(37)/'MATOUT    '/
      DATACNAME(38)/'ERROR DEF '/
      DATACNAME(39)/'LIMITS    '/
      DATACNAME(40)/'PUNCH     '/
      DATANNTOT/40/
      LK=LEN(COMAND)
      IF(LK.GT.MAXCWD)LK=MAXCWD
      CWORD=COMAND(1:LK)
      DO16ICOL=1,LK
      DO15LET=1,26
      IF(CWORD(ICOL:ICOL).EQ.CLOWER(LET:LET))CWORD(ICOL:ICOL)=CUPPER(LET
     +:LET)
   15 CONTINUE
   16 CONTINUE
      DO20IW=1,MAXP
      WORD7(IW)=ZERO
      IF(IW.LE.LLIST)WORD7(IW)=PLIST(IW)
   20 CONTINUE
      ICOMND=ICOMND+1
      NFCNLC=NFCN
      IF(CWORD(1:7).NE.'SET PRI'.OR.WORD7(1).GE.0.)THEN
      IF(ISW(5).GE.0)THEN
      LNOW=LLIST
      IF(LNOW.GT.4)LNOW=4
      WRITE(ISYSWR,25)ICOMND,CWORD(1:LK),(PLIST(I),I=1,LNOW)
   25 FORMAT(' **********'/' **',I5,' **',A,4G12.4)
      IF(LLIST.GT.LNOW)THEN
      WRITE(CVBLNK,'(I2)')LK
      C26='(11H **********,'//CVBLNK//'X,4G12.4)'
      WRITE(ISYSWR,C26)(PLIST(I),I=LNOW+1,LLIST)
      ENDIF
      WRITE(ISYSWR,'(1H ,10(1H*))')
      ENDIF
      ENDIF
      NFCNMX=WORD7(1)
      IF(NFCNMX.LE.0)NFCNMX=200+100*NPAR+5*NPAR**2
      EPSI=WORD7(2)
      IF(EPSI.LE.ZERO)EPSI=0.1*UP
      LNEWMN=.FALSE.
      LPHEAD=.TRUE.
      ISW(1)=0
      IERFLG=0
      DO80I=1,NNTOT
      IF(CWORD(1:3).EQ.CNAME(I)(1:3))GOTO90
   80 CONTINUE
      WRITE(ISYSWR,'(11X,''UNKNOWN COMMAND IGNORED:'',A)')COMAND
      IERFLG=2
      GOTO5000
   90 CONTINUE
      IF(CWORD(1:4).EQ.'MINO')I=5
      IF(I.NE.6.AND.I.NE.7.AND.I.NE.8.AND.I.NE.23)THEN
      CFROM=CNAME(I)
      NFCNFR=NFCN
      ENDIF
      GOTO(400,200,300,400,500,700,700,800,900,1000,1100,1200,1300,1400,
     +1500,1600,1700,1800,1900,1900,1900,2200,2300,2400,1900,2600,3300,3
     +300,3300,3300,3300,3300,3300,3400,3500,3600,3700,3800,3900,4000),I
  200 CALLMNSEEK(FCN,FUTIL)
      GOTO5000
  300 CALLMNSIMP(FCN,FUTIL)
      GOTO5000
  400 CONTINUE
      NF=NFCN
      APSI=EPSI
      CALLMNMIGR(FCN,FUTIL)
      CALLMNWERR
      IF(ISW(4).GE.1)GOTO5000
      IF(ISW(1).EQ.1)GOTO5000
      IF(CWORD(1:3).EQ.'MIG')GOTO5000
      NFCNMX=NFCNMX+NF-NFCN
      NF=NFCN
      CALLMNSIMP(FCN,FUTIL)
      IF(ISW(1).EQ.1)GOTO5000
      NFCNMX=NFCNMX+NF-NFCN
      CALLMNMIGR(FCN,FUTIL)
      CALLMNWERR
      GOTO5000
  500 CONTINUE
      NSUPER=NFCN+2*(NPAR+1)*NFCNMX
      EPSI=0.1*UP
  510 CONTINUE
      CALLMNCUVE(FCN,FUTIL)
      CALLMNMNOS(FCN,FUTIL)
      IF(.NOT.LNEWMN)GOTO5000
      CALLMNRSET(0)
      CALLMNMIGR(FCN,FUTIL)
      CALLMNWERR
      IF(NFCN.LT.NSUPER)GOTO510
      WRITE(ISYSWR,'(/'' TOO MANY FUNCTION CALLS. MINOS GIVES UP''/)')
      IERFLG=1
      GOTO5000
  700 CALLMNSET(FCN,FUTIL)
      GOTO5000
  800 CONTINUE
      WRITE(ISYSWR,'(1H1)')
      GOTO5000
  900 LTOFIX=.TRUE.
  901 CONTINUE
      LFREED=.FALSE.
      LFIXED=.FALSE.
      IF(LLIST.EQ.0)THEN
      WRITE(ISYSWR,'(A,A)')CWORD,':  NO PARAMETERS REQUESTED '
      GOTO5000
      ENDIF
      DO950ILIST=1,LLIST
      IEXT=PLIST(ILIST)
      CHWHY=' IS UNDEFINED.'
      IF(IEXT.LE.0)GOTO930
      IF(IEXT.GT.NU)GOTO930
      IF(NVARL(IEXT).LT.0)GOTO930
      CHWHY=' IS CONSTANT.  '
      IF(NVARL(IEXT).EQ.0)GOTO930
      IINT=NIOFEX(IEXT)
      IF(LTOFIX)THEN
      CHWHY=' ALREADY FIXED.'
      IF(IINT.EQ.0)GOTO930
      CALLMNFIXP(IINT,IERR)
      IF(IERR.EQ.0)THEN
      LFIXED=.TRUE.
      ELSE
      IERFLG=1
      ENDIF
      ELSE
      CHWHY=' ALREADY VARIABLE.'
      IF(IINT.GT.0)GOTO930
      KRL=-IABS(IEXT)
      CALLMNFREE(KRL)
      LFREED=.TRUE.
      ENDIF
      GOTO950
  930 WRITE(ISYSWR,'(A,I4,A,A)')' PARAMETER',IEXT,CHWHY,' IGNORED.'
  950 CONTINUE
      IF(LFREED.OR.LFIXED)CALLMNRSET(0)
      IF(LFREED)THEN
      ISW(2)=0
      DCOVAR=1.
      EDM=BIGEDM
      ISW(4)=0
      ENDIF
      CALLMNWERR
      IF(ISW(5).GT.1)CALLMNPRIN(5,AMIN)
      GOTO5000
 1000 IT=WORD7(1)
      IF(IT.GT.1.OR.IT.LT.0)GOTO1005
      LFREED=(NPFIX.GT.0)
      CALLMNFREE(IT)
      IF(LFREED)THEN
      CALLMNRSET(0)
      ISW(2)=0
      DCOVAR=1.
      EDM=BIGEDM
      ENDIF
      GOTO5000
 1005 WRITE(ISYSWR,'(A,I4)')' IGNORED.  UNKNOWN ARGUMENT:',IT
      GOTO5000
 1100 LTOFIX=.FALSE.
      GOTO901
 1200 CONTINUE
      IEXT=WORD7(1)
      IF(IEXT.LE.0)GOTO1210
      IT2=0
      IF(IEXT.LE.NU)IT2=NIOFEX(IEXT)
      IF(IT2.LE.0)GOTO1250
 1210 CALLMNSCAN(FCN,FUTIL)
      GOTO5000
 1250 WRITE(ISYSWR,'(A,I4,A)')' PARAMETER',IEXT,' NOT VARIABLE.'
      GOTO5000
 1300 CONTINUE
      KE1=WORD7(1)
      KE2=WORD7(2)
      IF(KE1.EQ.0)THEN
      IF(NPAR.EQ.2)THEN
      KE1=NEXOFI(1)
      KE2=NEXOFI(2)
      ELSE
      WRITE(ISYSWR,'(A,A)')CWORD,':  NO PARAMETERS REQUESTED '
      GOTO5000
      ENDIF
      ENDIF
      NFCNMX=1000
      CALLMNCNTR(FCN,KE1,KE2,IERRF,FUTIL)
      IERFLG=IERRF
      GOTO5000
 1400 CONTINUE
      CALLMNHESS(FCN,FUTIL)
      CALLMNWERR
      IF(ISW(5).GE.0)CALLMNPRIN(2,AMIN)
      IF(ISW(5).GE.1)CALLMNMATU(1)
      GOTO5000
 1500 CONTINUE
      CALLMNSAVE
      GOTO5000
 1600 CONTINUE
      CALLMNCUVE(FCN,FUTIL)
      CALLMNIMPR(FCN,FUTIL)
      IF(LNEWMN)GOTO400
      GOTO5000
 1700 IFLAG=WORD7(1)
      NPARX=NPAR
      F=UNDEFI
      CALLFCN(NPARX,GIN,F,U,IFLAG,FUTIL)
      NFCN=NFCN+1
      NOWPRT=0
      IF(F.NE.UNDEFI)THEN
      IF(AMIN.EQ.UNDEFI)THEN
      AMIN=F
      NOWPRT=1
      ELSEIF(F.LT.AMIN)THEN
      AMIN=F
      NOWPRT=1
      ENDIF
      IF(ISW(5).GE.0.AND.IFLAG.LE.5.AND.NOWPRT.EQ.1)CALLMNPRIN(5,AMIN)
      IF(IFLAG.EQ.3)FVAL3=F
      ENDIF
      IF(IFLAG.GT.5)CALLMNRSET(1)
      GOTO5000
 1800 CALLSTAND
      GOTO5000
 1900 IT=PLIST(1)
      IF(FVAL3.EQ.AMIN.OR.IT.GT.0)GOTO5000
      IFLAG=3
      WRITE(ISYSWR,'(/A/)')' CALL TO USER FUNCTION WITH IFLAG = 3'
      NPARX=NPAR
      CALLFCN(NPARX,GIN,F,U,IFLAG,FUTIL)
      NFCN=NFCN+1
      GOTO5000
 2200 CONTINUE
      CALLMNCLER
      IF(ISW(5).GE.1)WRITE(ISYSWR,'(A)')' MINUIT MEMORY CLEARED. NO PARA
     +METERS NOW DEFINED.'
      GOTO5000
 2300 CONTINUE
      KCOL=0
      DO2310ICOL=5,LK
      IF(CWORD(ICOL:ICOL).EQ.' ')GOTO2310
      KCOL=ICOL
      GOTO2320
 2310 CONTINUE
 2320 CONTINUE
      IF(KCOL.EQ.0)THEN
      COMD='*   '
      ELSE
      COMD=CWORD(KCOL:LK)
      ENDIF
      CALLMNHELP(COMD,ISYSWR)
      GOTO5000
 2400 CONTINUE
      EPSI=0.05*UP
      KE1=WORD7(1)
      KE2=WORD7(2)
      IF(KE1.EQ.0.AND.NPAR.EQ.2)THEN
      KE1=NEXOFI(1)
      KE2=NEXOFI(2)
      ENDIF
      NPTU=WORD7(3)
      IF(NPTU.LE.0)NPTU=20
      IF(NPTU.GT.MXPT)NPTU=MXPT
      NFCNMX=100*(NPTU+5)*(NPAR+1)
      CALLMNCONT(FCN,KE1,KE2,NPTU,XPTU,YPTU,IERRF,FUTIL)
      GOTO5000
 2600 CONTINUE
      STEP=WORD7(1)
      IF(STEP.LE.ZERO)STEP=2.
      RNO=0.
      IZERO=0
      DO2620I=1,NPAR
      CALLMNRN15(RNO,IZERO)
      RNO=2.0*RNO-1.0
 2620 X(I)=X(I)+RNO*STEP*WERR(I)
      CALLMNINEX(X)
      CALLMNAMIN(FCN,FUTIL)
      CALLMNRSET(0)
      GOTO5000
 3300 CONTINUE
      WRITE(ISYSWR,'(10X,A)')' BLANK COMMAND IGNORED.'
      GOTO5000
 3400 CONTINUE
      WRITE(ISYSWR,'(A)')' THE "COVARIANCE" COMMAND IS OSBSOLETE.',' THE
     + COVARIANCE MATRIX IS NOW SAVED IN A DIFFERENT FORMAT',' WITH THE 
     +"SAVE" COMMAND AND READ IN WITH:"SET COVARIANCE"'
      GOTO5000
 3500 CONTINUE
      CNEWAY='SET PRInt '
      GOTO3100
 3600 CONTINUE
      CNEWAY='SET GRAd  '
      GOTO3100
 3700 CONTINUE
      CNEWAY='SHOW COVar'
      GOTO3100
 3800 CONTINUE
      CNEWAY='SET ERRdef'
      GOTO3100
 3900 CONTINUE
      CNEWAY='SET LIMits'
      GOTO3100
 4000 CONTINUE
      CNEWAY='SAVE      '
 3100 WRITE(ISYSWR,3101)CWORD,CNEWAY
 3101 FORMAT(' OBSOLETE COMMAND:',1X,A10,5X,'PLEASE USE:',1X,A10)
      CWORD=CNEWAY
      IF(CWORD.EQ.'SAVE      ')GOTO1500
      GOTO700
 5000 RETURN
      END
 
      SUBROUTINEMNEXIN(PINT)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      DIMENSIONPINT(*)
      LIMSET=.FALSE.
      DO100IINT=1,NPAR
      IEXT=NEXOFI(IINT)
      CALLMNPINT(U(IEXT),IEXT,PINTI)
      PINT(IINT)=PINTI
  100 CONTINUE
      RETURN
      END
 
      SUBROUTINEMNFIXP(IINT,IERR)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      DIMENSIONYY(MNI)
      IERR=0
      IF(IINT.GT.NPAR.OR.IINT.LE.0)THEN
      IERR=1
      WRITE(ISYSWR,'(A,I4)')' MINUIT ERROR.  ARGUMENT TO MNFIXP=',IINT
      GOTO300
      ENDIF
      IEXT=NEXOFI(IINT)
      IF(NPFIX.GE.MNI)THEN
      IERR=1
      WRITE(ISYSWR,'(A,I4,A,I4)')' MINUIT CANNOT FIX PARAMETER',IEXT,' M
     +AXIMUM NUMBER THAT CAN BE FIXED IS',MNI
      GOTO300
      ENDIF
      NIOFEX(IEXT)=0
      NOLD=NPAR
      NPAR=NPAR-1
      NPFIX=NPFIX+1
      IPFIX(NPFIX)=IEXT
      LC=IINT
      XS(NPFIX)=X(LC)
      XTS(NPFIX)=XT(LC)
      DIRINS(NPFIX)=WERR(LC)
      GRDS(NPFIX)=GRD(LC)
      G2S(NPFIX)=G2(LC)
      GSTEPS(NPFIX)=GSTEP(LC)
      DO100IK=IEXT+1,NU
      IF(NIOFEX(IK).GT.0)THEN
      LC=NIOFEX(IK)-1
      NIOFEX(IK)=LC
      NEXOFI(LC)=IK
      X(LC)=X(LC+1)
      XT(LC)=XT(LC+1)
      DIRIN(LC)=DIRIN(LC+1)
      WERR(LC)=WERR(LC+1)
      GRD(LC)=GRD(LC+1)
      G2(LC)=G2(LC+1)
      GSTEP(LC)=GSTEP(LC+1)
      ENDIF
  100 CONTINUE
      IF(ISW(2).LE.0)GOTO300
      IF(NPAR.LE.0)GOTO300
      DO260I=1,NOLD
      M=MAX(I,IINT)
      N=MIN(I,IINT)
      NDEX=M*(M-1)/2+N
  260 YY(I)=VHMAT(NDEX)
      YYOVER=1.0/YY(IINT)
      KNEW=0
      KOLD=0
      DO294I=1,NOLD
      DO292J=1,I
      KOLD=KOLD+1
      IF(J.EQ.IINT.OR.I.EQ.IINT)GOTO292
      KNEW=KNEW+1
      VHMAT(KNEW)=VHMAT(KOLD)-YY(J)*YY(I)*YYOVER
  292 CONTINUE
  294 CONTINUE
  300 RETURN
      END
 
      SUBROUTINEMNFREE(K)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      IF(K.GT.1)WRITE(ISYSWR,510)
      IF(NPFIX.LT.1)WRITE(ISYSWR,500)
      IF(K.EQ.1.OR.K.EQ.0)GOTO40
      KA=IABS(K)
      IF(NIOFEX(KA).EQ.0)GOTO15
      WRITE(ISYSWR,540)
  540 FORMAT(' IGNORED.  PARAMETER SPECIFIED IS ALREADY VARIABLE.')
      RETURN
   15 IF(NPFIX.LT.1)GOTO21
      DO20IK=1,NPFIX
      IF(IPFIX(IK).EQ.KA)GOTO24
   20 CONTINUE
   21 WRITE(ISYSWR,530)KA
  530 FORMAT(' PARAMETER',I4,' NOT FIXED.  CANNOT BE RELEASED.')
      RETURN
   24 IF(IK.EQ.NPFIX)GOTO40
      IPSAV=KA
      XV=XS(IK)
      XTV=XTS(IK)
      DIRINV=DIRINS(IK)
      GRDV=GRDS(IK)
      G2V=G2S(IK)
      GSTEPV=GSTEPS(IK)
      DO30I=IK+1,NPFIX
      IPFIX(I-1)=IPFIX(I)
      XS(I-1)=XS(I)
      XTS(I-1)=XTS(I)
      DIRINS(I-1)=DIRINS(I)
      GRDS(I-1)=GRDS(I)
      G2S(I-1)=G2S(I)
      GSTEPS(I-1)=GSTEPS(I)
   30 CONTINUE
      IPFIX(NPFIX)=IPSAV
      XS(NPFIX)=XV
      XTS(NPFIX)=XTV
      DIRINS(NPFIX)=DIRINV
      GRDS(NPFIX)=GRDV
      G2S(NPFIX)=G2V
      GSTEPS(NPFIX)=GSTEPV
   40 CONTINUE
      IF(NPFIX.LT.1)GOTO300
      IR=IPFIX(NPFIX)
      IS=0
      DO100IK=NU,IR,-1
      IF(NIOFEX(IK).GT.0)THEN
      LC=NIOFEX(IK)+1
      IS=LC-1
      NIOFEX(IK)=LC
      NEXOFI(LC)=IK
      X(LC)=X(LC-1)
      XT(LC)=XT(LC-1)
      DIRIN(LC)=DIRIN(LC-1)
      WERR(LC)=WERR(LC-1)
      GRD(LC)=GRD(LC-1)
      G2(LC)=G2(LC-1)
      GSTEP(LC)=GSTEP(LC-1)
      ENDIF
  100 CONTINUE
      NPAR=NPAR+1
      IF(IS.EQ.0)IS=NPAR
      NIOFEX(IR)=IS
      NEXOFI(IS)=IR
      IQ=NPFIX
      X(IS)=XS(IQ)
      XT(IS)=XTS(IQ)
      DIRIN(IS)=DIRINS(IQ)
      WERR(IS)=DIRINS(IQ)
      GRD(IS)=GRDS(IQ)
      G2(IS)=G2S(IQ)
      GSTEP(IS)=GSTEPS(IQ)
      NPFIX=NPFIX-1
      ISW(2)=0
      DCOVAR=1.
      IF(ITAUR.LT.1)WRITE(ISYSWR,520)IR,CPNAM(IR)
      IF(K.EQ.0)GOTO40
  300 CONTINUE
      CALLMNEXIN(X)
  400 RETURN
  500 FORMAT(' CALL TO MNFREE IGNORED.  THERE ARE NO FIXED PA','RAMETERS
     +'/)
  510 FORMAT(' CALL TO MNFREE IGNORED.  ARGUMENT GREATER THAN ONE'/)
  520 FORMAT(20X,'PARAMETER',I4,',',A10,' RESTORED TO VARIABLE.')
      END
 
      SUBROUTINEMNGRAD(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      CHARACTER*4CGOOD,CBAD,CNONE,CWD
      LOGICALLNONE
      DIMENSIONGF(MNI)
      PARAMETER(CGOOD='GOOD',CBAD=' BAD',CNONE='NONE')
      ISW(3)=1
      NPARX=NPAR
      IF(WORD7(1).GT.ZERO)GOTO2000
      DO30I=1,NU
   30 GIN(I)=UNDEFI
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,FZERO,U,2,FUTIL)
      NFCN=NFCN+1
      CALLMNDERI(FCN,FUTIL)
      DO40I=1,NPAR
   40 GF(I)=GRD(I)
      ISW(3)=0
      ISTSAV=ISTRAT
      ISTRAT=2
      CALLMNHES1(FCN,FUTIL)
      ISTRAT=ISTSAV
      WRITE(ISYSWR,51)
   51 FORMAT(/' CHECK OF GRADIENT CALCULATION IN FCN'/12X,
     +      'PARAMETER',6X,'G(INFCN)',3X,'G(MINUIT)',2X,
     +      'DG(MINUIT)',3X,'AGREEMENT')
      ISW(3)=1
      LNONE=.FALSE.
      DO100LC=1,NPAR
      I=NEXOFI(LC)
      CWD=CGOOD
      ERR=DGRD(LC)
      IF(ABS(GF(LC)-GRD(LC)).GT.ERR)CWD=CBAD
      IF(GIN(I).EQ.UNDEFI)THEN
      CWD=CNONE
      LNONE=.TRUE.
      GF(LC)=0.
      ENDIF
      IF(CWD.NE.CGOOD)ISW(3)=0
      WRITE(ISYSWR,99)I,CPNAM(I),GF(LC),GRD(LC),ERR,CWD
   99 FORMAT(7X,I5,2X,A10,3E12.4,4X,A4)
  100 CONTINUE
      IF(LNONE)WRITE(ISYSWR,'(A)')'  AGREEMENT=NONE  MEANS FCN DID NOT C
     +ALCULATE THE DERIVATIVE'
      IF(ISW(3).EQ.0)WRITE(ISYSWR,1003)
 1003 FORMAT(/' MINUIT DOES NOT ACCEPT DERIVATIVE CALCULATIONS BY FCN'/'
     + TO FORCE ACCEPTANCE, ENTER "SET GRAD    1"'/)
 2000 CONTINUE
      RETURN
      END
      SUBROUTINEMNHELP(COMD,LOUT)
      IMPLICITINTEGER(I-N)
      CHARACTER*(*)COMD
      CHARACTER*3CMD3
      IF(COMD(1:1).EQ.'*')THEN
      WRITE(LOUT,10000)
      WRITE(LOUT,10001)
      GOTO99
      ENDIF
10000 FORMAT('   ==>List of MINUIT Interactive commands:',/,' CLEar     
     +Reset all parameter names and values undefined',/,' CONtour   Make
     + contour map of the user function',/,' EXIT      Exit from Interac
     +tive Minuit',/,' FIX       Cause parameter(s) to remain constant',
     +/,' HESse     Calculate the Hessian or error matrix.',/,' IMPROVE 
     +  Search for a new minimum around current minimum',/,' MIGrad    M
     +inimize by the method of Migrad',/,' MINImize  MIGRAD + SIMPLEX me
     +thod if Migrad fails',/,' MINOs     Exact (non-linear) parameter e
     +rror analysis')
10001 FORMAT(' MNContour Calculate one MINOS function contour',/,' PARam
     +eter Define or redefine new parameters and values',/,' RELease   M
     +ake previously FIXed parameters variable again',/,' REStore   Rele
     +ase last parameter fixed',/,' SAVe      Save current parameter val
     +ues on a file',/,' SCAn      Scan the user function by varying par
     +ameters',/,' SEEk      Minimize by the method of Monte Carlo',/,' 
     +SET       Set various MINUIT constants or conditions',/,' SHOw    
     +  Show values of current constants or conditions',/,' SIMplex   Mi
     +nimize by the method of Simplex')
      CMD3=COMD(1:3)
      IF(CMD3.EQ.'CLE')THEN
      WRITE(LOUT,10100)
      GOTO99
      ENDIF
10100 FORMAT(' ***>CLEAR',/,' Resets all parameter names and values to u
     +ndefined.',/,' Must normally be followed by a PARameters command o
     +r ',/,' equivalent, in order to define parameter values.')
      IF(CMD3.EQ.'CON')THEN
      WRITE(LOUT,10200)
      GOTO99
      ENDIF
10200 FORMAT(' ***>CONTOUR <par1>  <par2>  [devs]  [ngrid]',/,' Instruct
     +s Minuit to trace contour lines of the user function',/,' with res
     +pect to the two parameters whose external numbers',/,' are <par1> 
     +and <par2>.',/,' Other variable parameters of the function, if any
     +, will have',/,' their values fixed at the current values during t
     +he contour',/,' tracing. The optional parameter [devs] (default va
     +lue 2.)',/,' gives the number of standard deviations in each param
     +eter',/,' which should lie entirely within the plotting area.',/,'
     + Optional parameter [ngrid] (default value 25 unless page',/,' siz
     +e is too small) determines the resolution of the plot,',/,' i.e. t
     +he number of rows and columns of the grid at which the',/,' functi
     +on will be evaluated. [See also MNContour.]')
      IF(CMD3.EQ.'END')THEN
      WRITE(LOUT,10300)
      GOTO99
      ENDIF
10300 FORMAT(' ***>END',/,' Signals the end of a data block (i.e., the e
     +nd of a fit),',/,' and implies that execution should continue, bec
     +ause another',/,' Data Block follows. A Data Block is a set of Min
     +uit data',/,' consisting of',/,'     (1) A Title,',/,'     (2) One
     + or more Parameter Definitions,',/,'     (3) A blank line, and',/,
     +'     (4) A set of Minuit Commands.',/,' The END command is used w
     +hen more than one Data Block is to',/,' be used with the same FCN 
     +function. It first causes Minuit',/,' to issue a CALL FCN with IFL
     +AG=3, in order to allow FCN to',/,' perform any calculations assoc
     +iated with the final fitted',/,' parameter values, unless a CALL F
     +CN 3 command has already',/,' been executed at the current FCN val
     +ue.')
      IF(CMD3.EQ.'EXI')THEN
      WRITE(LOUT,10400)
      GOTO99
      ENDIF
10400 FORMAT(' ***>EXIT',/,' Signals the end of execution.',/,' The EXIT
     + command first causes Minuit to issue a CALL FCN',/,' with IFLAG=3
     +, to allow FCN to perform any calculations',/,' associated with th
     +e final fitted parameter values, unless a',/,' CALL FCN 3 command 
     +has already been executed.')
      IF(CMD3.EQ.'FIX')THEN
      WRITE(LOUT,10500)
      GOTO99
      ENDIF
10500 FORMAT(' ***>FIX} <parno> [parno] ... [parno]',/,' Causes paramete
     +r(s) <parno> to be removed from the list of',/,' variable paramete
     +rs, and their value(s) will remain constant',/,' during subsequent
     + minimizations, etc., until another command',/,' changes their val
     +ue(s) or status.')
      IF(CMD3.EQ.'HES')THEN
      WRITE(LOUT,10600)
      GOTO99
      ENDIF
10600 FORMAT(' ***>HESse  [maxcalls]',/,' Calculate, by finite differenc
     +es, the Hessian or error matrix.',/,'  That is, it calculates the 
     +full matrix of second derivatives',/,' of the function with respec
     +t to the currently variable',/,' parameters, and inverts it, print
     +ing out the resulting error',/,' matrix. The optional argument [ma
     +xcalls] specifies the',/,' (approximate) maximum number of functio
     +n calls after which',/,' the calculation will be stopped.')
      IF(CMD3.EQ.'IMP')THEN
      WRITE(LOUT,10700)
      GOTO99
      ENDIF
10700 FORMAT(' ***>IMPROVE  [maxcalls]',/,' If a previous minimization h
     +as converged, and the current',/,' values of the parameters theref
     +ore correspond to a local',/,' minimum of the function, this comma
     +nd requests a search for',/,' additional distinct local minima.',/
     +,' The optional argument [maxcalls] specifies the (approximate)',/
     +,' maximum number of function calls after which the calculation',/
     +,' will be stopped.')
      IF(CMD3.EQ.'MIG')THEN
      WRITE(LOUT,10800)
      GOTO99
      ENDIF
10800 FORMAT(' ***>MIGrad  [maxcalls]  [tolerance]',/,' Causes minimizat
     +ion of the function by the method of Migrad,',/,' the most efficie
     +nt and complete single method, recommended',/,' for general functi
     +ons (see also MINImize).',/,' The minimization produces as a by-pr
     +oduct the error matrix',/,' of the parameters, which is usually re
     +liable unless warning',/,' messages are produced.',/,' The optiona
     +l argument [maxcalls] specifies the (approximate)',/,' maximum num
     +ber of function calls after which the calculation',/,' will be sto
     +pped even if it has not yet converged.',/,' The optional argument 
     +[tolerance] specifies required tolerance',/,' on the function valu
     +e at the minimum.',/,' The default tolerance is 0.1, and the minim
     +ization will stop',/,' when the estimated vertical distance to the
     + minimum (EDM) is',/,' less than 0.001*[tolerance]*UP (see [SET ER
     +Rordef]).')
      IF(COMD(1:4).EQ.'MINI')THEN
      WRITE(LOUT,10900)
      GOTO99
      ENDIF
10900 FORMAT(' ***>MINImize  [maxcalls] [tolerance]',/,' Causes minimiza
     +tion of the function by the method of Migrad,',/,' as does the MIG
     +rad command, but switches to the SIMplex method',/,' if Migrad fai
     +ls to converge. Arguments are as for MIGrad.',/,' Note that comman
     +d requires four characters to be unambiguous.')
      IF(COMD(1:4).EQ.'MINO')THEN
      WRITE(LOUT,11000)
      GOTO99
      ENDIF
11000 FORMAT(' ***>MINOs  [maxcalls]  [parno] [parno] ...',/,' Causes a 
     +Minos error analysis to be performed on the parameters',/,' whose 
     +numbers [parno] are specified. If none are specified,',/,' Minos e
     +rrors are calculated for all variable parameters.',/,' Minos error
     +s may be expensive to calculate, but are very',/,' reliable since 
     +they take account of non-linearities in the',/,' problem as well a
     +s parameter correlations, and are in general',/' asymmetric.',/,' 
     +The optional argument [maxcalls] specifies the (approximate)',/,' 
     +maximum number of function calls per parameter requested,',/,' aft
     +er which the calculation will stop for that parameter.')
      IF(CMD3.EQ.'MNC')THEN
      WRITE(LOUT,11100)
      GOTO99
      ENDIF
11100 FORMAT(' ***>MNContour  <par1> <par2> [npts]',/,' Calculates one f
     +unction contour of FCN with respect to',/,' parameters par1 and pa
     +r2, with FCN minimized always with',/,' respect to all other NPAR-
     +2 variable parameters (if any).',/,' Minuit will try to find npts 
     +points on the contour (default 20)',/,' If only two parameters are
     + variable at the time, it is not',/,' necessary to specify their n
     +umbers. To calculate more than',/,' one contour, it is necessary t
     +o SET ERRordef to the appropriate',/,' value and issue the MNConto
     +ur command for each contour.')
      IF(CMD3.EQ.'PAR')THEN
      WRITE(LOUT,11150)
      GOTO99
      ENDIF
11150 FORMAT(' ***>PARameters',/,' followed by one or more parameter def
     +initions.',/,' Parameter definitions are of the form:',/,'   <numb
     +er>  ''name''  <value>  <step>  [lolim] [uplim] ',/,' for example:
     +',/,'  3  ''K width''  1.2   0.1',/,' the last definition is follo
     +wed by a blank line or a zero.')
      IF(CMD3.EQ.'REL')THEN
      WRITE(LOUT,11200)
      GOTO99
      ENDIF
11200 FORMAT(' ***>RELease  <parno> [parno] ... [parno]',/,' If <parno> 
     +is the number of a previously variable parameter',/,' which has be
     +en fixed by a command: FIX <parno>, then that',/,' parameter will 
     +return to variable status.  Otherwise a warning',/,' message is pr
     +inted and the command is ignored.',/,' Note that this command oper
     +ates only on parameters which were',/' at one time variable and ha
     +ve been FIXed. It cannot make',/,' constant parameters variable; t
     +hat must be done by redefining',/' the parameter with a PARameters
     + command.')
      IF(CMD3.EQ.'RES')THEN
      WRITE(LOUT,11300)
      GOTO99
      ENDIF
11300 FORMAT(' ***>REStore  [code]',/,' If no [code] is specified, this 
     +command restores all previously',/,' FIXed parameters to variable 
     +status. If [code]=1, then only',/,' the last parameter FIXed is re
     +stored to variable status.',/,' If code is neither zero nor one, t
     +he command is ignored.')
      IF(CMD3.EQ.'RET')THEN
      WRITE(LOUT,11400)
      GOTO99
      ENDIF
11400 FORMAT(' ***>RETURN',/,' Signals the end of a data block, and inst
     +ructs Minuit to return',/,' to the program which called it. The RE
     +Turn command first',/,' causes Minuit to CALL FCN with IFLAG=3, in
     + order to allow FCN',/,' to perform any calculations associated wi
     +th the final fitted',/,' parameter values, unless a CALL FCN 3 com
     +mand has already been',/,' executed at the current FCN value.')
      IF(CMD3.EQ.'SAV')THEN
      WRITE(LOUT,11500)
      GOTO99
      ENDIF
11500 FORMAT(' ***>SAVe',/,' Causes the current parameter values to be s
     +aved on a file in',/,' such a format that they can be read in agai
     +n as Minuit',/,' parameter definitions. If the covariance matrix e
     +xists, it is',/,' also output in such a format. The unit number is
     + by default 7,',/,' or that specified by the user in his call to M
     +INTIO or',/,' MNINIT. The user is responsible for opening the file
     + previous',/,' to issuing the [SAVe] command (except where this ca
     +n be done',/,' interactively).')
      IF(CMD3.EQ.'SCA')THEN
      WRITE(LOUT,11600)
      GOTO99
      ENDIF
11600 FORMAT(' ***>SCAn  [parno]  [numpts] [from]  [to]',/,' Scans the v
     +alue of the user function by varying parameter',/,' number [parno]
     +, leaving all other parameters fixed at the',/,' current value. If
     + [parno] is not specified, all variable',/,' parameters are scanne
     +d in sequence.',/,' The number of points [numpts] in the scan is 4
     +0 by default,',/,' and cannot exceed 100. The range of the scan is
     + by default',/,' 2 standard deviations on each side of the current
     + best value,',/,' but can be specified as from [from] to [to].',/,
     +' After each scan, if a new minimum is found, the best parameter',
     +/,' values are retained as start values for future scans or',/,' m
     +inimizations. The curve resulting from each scan is plotted',/,' o
     +n the output unit in order to show the approximate behaviour',/,' 
     +of the function.',/,' This command is not intended for minimizatio
     +n, but is sometimes',/,' useful for debugging the user function or
     + finding a',/,' reasonable starting point.')
      IF(CMD3.EQ.'SEE')THEN
      WRITE(LOUT,11700)
      GOTO99
      ENDIF
11700 FORMAT(' ***>SEEk  [maxcalls]  [devs]',/,' Causes a Monte Carlo mi
     +nimization of the function, by choosing',/,' random values of the 
     +variable parameters, chosen uniformly',/,' over a hypercube center
     +ed at the current best value.',/,' The region size is by default 3
     + standard deviations on each',/,' side, but can be changed by spec
     +ifying the value of [devs].')
      IF(CMD3.EQ.'SET')THEN
      WRITE(LOUT,11800)
      WRITE(LOUT,11801)
      WRITE(LOUT,11802)
      WRITE(LOUT,11803)
      WRITE(LOUT,11804)
      WRITE(LOUT,11805)
      WRITE(LOUT,11806)
      WRITE(LOUT,11807)
      WRITE(LOUT,11808)
      WRITE(LOUT,11809)
      WRITE(LOUT,11810)
      WRITE(LOUT,11811)
      WRITE(LOUT,11812)
      WRITE(LOUT,11813)
      WRITE(LOUT,11814)
      WRITE(LOUT,11815)
      WRITE(LOUT,11816)
      WRITE(LOUT,11817)
      GOTO99
      ENDIF
11800 FORMAT(' ***>SET <option_name>',/,/,'  SET BATch',/,'    Informs M
     +inuit that it is running in batch mode.',//,'  SET EPSmachine  <ac
     +curacy>',/,'    Informs Minuit that the relative floating point ar
     +ithmetic',/'    precision is <accuracy>. Minuit determines the nom
     +inal',/,'    precision itself, but the SET EPSmachine command can 
     +be',/,'    used to override Minuit own determination, when the use
     +r',/,'    knows that the FCN function value is not calculated to',
     +/,'    the nominal machine accuracy. Typical values of <accuracy>'
     +,/'    are between 10**-5 and 10**-14.')
11801 FORMAT(/,'  SET ERRordef  <up>',/,'    Sets the value of UP (defau
     +lt value= 1.), defining parameter',/,'    errors. Minuit defines p
     +arameter errors as the change',/,'    in parameter value required 
     +to change the function value',/,'    by UP. Normally, for chisquar
     +ed fits UP=1, and for negative',/,'    log likelihood, UP=0.5.')
11802 FORMAT(/,'   SET GRAdient  [force]',/,'    Informs Minuit that the
     + user function is prepared to',/,'    calculate its own first deri
     +vatives and return their values',/,'    in the array GRAD when IFL
     +AG=2 (see specs of FCN).',/,'    If [force] is not specified, Minu
     +it will calculate',/,'    the FCN derivatives by finite difference
     +s at the current',/,'    point and compare with the user calculati
     +on at that point,',/,'    accepting the user values only if they a
     +gree.',/,'    If [force]=1, Minuit does not do its own derivative'
     +,/,'    calculation, and uses the derivatives calculated in FCN.')
11803 FORMAT(/,'   SET INPut  [unitno]  [filename]',/,'    Causes Minuit
     +, in data-driven mode only, to read subsequent',/,'    commands (o
     +r parameter definitions) from a different input',/,'    file. If n
     +o [unitno] is specified, reading reverts to the',/,'    previous i
     +nput file, assuming that there was one.',/,'    If [unitno] is spe
     +cified, and that unit has not been opened,',/,'    then Minuit att
     +empts to open the file [filename]} if a',/,'    name is specified.
     + If running in interactive mode and',/,'    [filename] is not spec
     +ified and [unitno] is not opened,',/,'    Minuit prompts the user 
     +to enter a file name.',/,'    If the word REWIND is added to the c
     +ommand (note:no blanks',/'    between INPUT and REWIND), the file 
     +is rewound before',/,'    reading. Note that this command is imple
     +mented in standard',/'    Fortran 77 and the results may depend on
     + the  system;',/,'    for example, if a filename is given under VM
     +/CMS, it must',/,'    be preceded by a slash.')
11804 FORMAT(/,'   SET INTeractive',/,'    Informs Minuit that it is run
     +ning interactively.')
11805 FORMAT(/,'   SET LIMits  [parno]  [lolim]  [uplim]',/,'    Allows 
     +the user to change the limits on one or all',/,'    parameters. If
     + no arguments are specified, all limits are',/,'    removed from a
     +ll parameters. If [parno] alone is specified,',/,'    limits are r
     +emoved from parameter [parno].',/,'    If all arguments are specif
     +ied, then parameter [parno] will',/,'    be bounded between [lolim
     +] and [uplim].',/,'    Limits can be specified in either order, Mi
     +nuit will take',/,'    the smaller as [lolim] and the larger as [u
     +plim].',/,'    However, if [lolim] is equal to [uplim], an error c
     +ondition',/,'    results.')
11806 FORMAT(/,'   SET LINesperpage',/,'     Sets the number of lines fo
     +r one page of output.',/,'     Default value is 24 for interactive
     + mode')
11807 FORMAT(/,'   SET NOGradient',/,'    The inverse of {SET GRAdient},
     + instructs Minuit not to',/,'    use the first derivatives ca
     +lculated by the user in FCN.')
11808 FORMAT(/,'   SET NOWarnings',/,'    Supresses Minuit warning messa
     +ges.')
11809 FORMAT(/,'   SET OUTputfile  <unitno>',/,'    Instructs Minuit to 
     +write further output to unit <unitno>.')
11810 FORMAT(/,'   SET PAGethrow  <integer>',/,'    Sets the carriage co
     +ntrol character for ``new page'' to',/,'    <integer>. Thus the va
     +lue 1 produces a new page, and 0',/,'    produces a blank line, on
     + some devices (see TOPofpage)')
11811 FORMAT(/,'   SET PARameter  <parno>  <value>',/,'    Sets the valu
     +e of parameter <parno> to <value>.',/,'    The parameter in questi
     +on may be variable, fixed, or',/,'    constant, but must be define
     +d.')
11812 FORMAT(/,'   SET PRIntout  <level>',/,'    Sets the print level, d
     +etermining how much output will be',/,'    produced. Allowed value
     +s and their meanings are displayed',/,'    after a SHOw PRInt comm
     +and, and are currently <level>=:',/,'      [-1]  no output except 
     +from SHOW commands',/,'       [0]  minimum output',/,'       [1]  
     +default value, normal output',/,'       [2]  additional output giv
     +ing intermediate results.',/,'       [3]  maximum output, showing 
     +progress of minimizations.',/'    Note: See also the SET WARnings 
     +command.')
11813 FORMAT(/,'   SET RANdomgenerator  <seed>',/,'    Sets the seed of 
     +the random number generator used in SEEk.',/'    This can be any i
     +nteger between 10000 and 900000000, for',/,'    example one which 
     +was output from a SHOw RANdom command of',/'    a previous run.')
11814 FORMAT(/,'   SET STRategy  <level>',/,'    Sets the strategy to be
     + used in calculating first and second',/,'    derivatives and in c
     +ertain minimization methods.',/,'    In general, low values of <le
     +vel> mean fewer function calls',/,'    and high values mean more r
     +eliable minimization.',/,'    Currently allowed values are 0, 1 (d
     +efault), and 2.')
11815 FORMAT(/,'   SET TITle',/,'    Informs Minuit that the next input 
     +line is to be considered',/,'    the (new) title for this task or 
     +sub-task.  This is for',/,'    the convenience of the user in read
     +ing his output.')
11816 FORMAT(/,'   SET WARnings',/,'    Instructs Minuit to output warni
     +ng messages when suspicious',/,'    conditions arise which may ind
     +icate unreliable results.',/'    This is the default.')
11817 FORMAT(/,'    SET WIDthpage',/,'    Informs Minuit of the output p
     +age width.',/,'    Default values are 80 for interactive jobs')
      IF(CMD3.EQ.'SHO')THEN
      WRITE(LOUT,11900)
      WRITE(LOUT,11901)
      WRITE(LOUT,11902)
      WRITE(LOUT,11903)
      WRITE(LOUT,11904)
      GOTO99
      ENDIF
11900 FORMAT(' ***>SHOw  <option_name>',/,'  All SET XXXX commands have 
     +a corresponding SHOw XXXX command.',/,'  In addition, the SHOw com
     +mands listed starting here have no',/,'  corresponding SET command
     + for obvious reasons.')
11901 FORMAT(/,'   SHOw CORrelations',/,'    Calculates and prints the p
     +arameter correlations from the',/,'    error matrix.')
11902 FORMAT(/,'   SHOw COVariance',/,'    Prints the (external) covaria
     +nce (error) matrix.')
11903 FORMAT(/,'   SHOw EIGenvalues',/,'    Calculates and prints the ei
     +genvalues of the covariance',/,'    matrix.')
11904 FORMAT(/,'   SHOw FCNvalue',/,'    Prints the current value of FCN
     +.')
      IF(CMD3.EQ.'SIM')THEN
      WRITE(LOUT,12000)
      GOTO99
      ENDIF
12000 FORMAT(' ***>SIMplex  [maxcalls]  [tolerance]',/,' Performs a func
     +tion minimization using the simplex method of',/' Nelder and Mead.
     + Minimization terminates either when the',/,' function has been ca
     +lled (approximately) [maxcalls] times,',/,' or when the estimated 
     +vertical distance to minimum (EDM) is',/,' less than [tolerance].'
     +,/,' The default value of [tolerance] is 0.1*UP(see SET ERRordef).
     +')
      IF(CMD3.EQ.'STA')THEN
      WRITE(LOUT,12100)
      GOTO99
      ENDIF
12100 FORMAT(' ***>STAndard',/,' Causes Minuit to execute the Fortran in
     +struction CALL STAND',/,' where STAND is a subroutine supplied by 
     +the user.')
      IF(CMD3.EQ.'STO')THEN
      WRITE(LOUT,12200)
      GOTO99
      ENDIF
12200 FORMAT(' ***>STOP',/,' Same as EXIT.')
      IF(CMD3.EQ.'TOP')THEN
      WRITE(LOUT,12300)
      GOTO99
      ENDIF
12300 FORMAT(' ***>TOPofpage',/,' Causes Minuit to write the character s
     +pecified in a',/,' SET PAGethrow command (default = 1) to column 1
     + of the output',/,' file, which may or may not position your outpu
     +t medium to',/,' the top of a page depending on the device and sys
     +tem.')
      WRITE(LOUT,13000)
13000 FORMAT(' Unknown MINUIT command. Type HELP for list of commands.')
   99 RETURN
      END
 
      SUBROUTINEMNHESS(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      DIMENSIONYY(MNI)
      LOGICALLDEBUG
      CHARACTERCBF1*22
      LDEBUG=(IDBG(3).GE.1)
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      IF(ISTRAT.LE.0)THEN
      NCYC=3
      TLRSTP=0.5
      TLRG2=0.1
      ELSEIF(ISTRAT.EQ.1)THEN
      NCYC=5
      TLRSTP=0.3
      TLRG2=0.05
      ELSE
      NCYC=7
      TLRSTP=0.1
      TLRG2=0.02
      ENDIF
      IF(ISW(5).GE.2.OR.LDEBUG)WRITE(ISYSWR,'(A)')'   START COVARIANCE M
     +ATRIX CALCULATION.'
      CFROM='HESSE   '
      NFCNFR=NFCN
      CSTATU='OK        '
      NPARD=NPAR
      CALLMNINEX(X)
      NPARX=NPAR
      CALLFCN(NPARX,GIN,FS1,U,4,FUTIL)
      NFCN=NFCN+1
      IF(FS1.NE.AMIN)THEN
      DF=AMIN-FS1
      WRITE(CBF1(1:12),'(G12.3)')DF
      CALLMNWARN('D','MNHESS','function value differs from AMIN by '//CB
     +F1(1:12))
      ENDIF
      AMIN=FS1
      IF(LDEBUG)WRITE(ISYSWR,'(A,A)')' PAR D   GSTEP          ',' D     
     +     G2         GRD         SAG    '
      AIMSAG=SQRT(EPSMA2)*(ABS(AMIN)+UP)
      NPAR2=NPAR*(NPAR+1)/2
      DO10I=1,NPAR2
   10 VHMAT(I)=0.
      IDRV=2
      DO100ID=1,NPARD
      I=ID+NPAR-NPARD
      IEXT=NEXOFI(I)
      IF(G2(I).EQ.ZERO)THEN
      WRITE(CBF1(1:4),'(I4)')IEXT
      CALLMNWARN('W','HESSE','Second derivative enters zero, param '//CB
     +F1(1:4))
      WINT=WERR(I)
      IF(NVARL(IEXT).GT.1)THEN
      CALLMNDXDI(X(I),I,DXDI)
      IF(ABS(DXDI).LT..001)THEN
      WINT=.01
      ELSE
      WINT=WINT/ABS(DXDI)
      ENDIF
      ENDIF
      G2(I)=UP/WINT**2
      ENDIF
      XTF=X(I)
      DMIN=8.*EPSMA2*ABS(XTF)
      D=ABS(GSTEP(I))
      DO40ICYC=1,NCYC
      DO25MULTPY=1,5
      X(I)=XTF+D
      CALLMNINEX(X)
      NPARX=NPAR
      CALLFCN(NPARX,GIN,FS1,U,4,FUTIL)
      NFCN=NFCN+1
      X(I)=XTF-D
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,FS2,U,4,FUTIL)
      NFCN=NFCN+1
      X(I)=XTF
      SAG=0.5*(FS1+FS2-2.0*AMIN)
      IF(SAG.NE.ZERO)GOTO30
      IF(GSTEP(I).LT.ZERO)THEN
      IF(D.GE..5)GOTO26
      D=10.*D
      IF(D.GT.0.5)D=0.51
      GOTO25
      ENDIF
      D=10.*D
   25 CONTINUE
   26 WRITE(CBF1(1:4),'(I4)')IEXT
      CALLMNWARN('W','HESSE','Second derivative zero for parameter'//CBF
     +1(1:4))
      GOTO390
   30 G2BFOR=G2(I)
      G2(I)=2.*SAG/D**2
      GRD(I)=(FS1-FS2)/(2.*D)
      IF(LDEBUG)WRITE(ISYSWR,31)I,IDRV,GSTEP(I),D,G2(I),GRD(I),SAG
   31 FORMAT(I4,I2,6G12.5)
      GSTEP(I)=SIGN(D,GSTEP(I))
      DIRIN(I)=D
      YY(I)=FS1
      DLAST=D
      D=SQRT(2.0*AIMSAG/ABS(G2(I)))
      STPINM=0.5
      IF(GSTEP(I).LT.ZERO)D=MIN(D,STPINM)
      IF(D.LT.DMIN)D=DMIN
      IF(ABS((D-DLAST)/D).LT.TLRSTP)GOTO50
      IF(ABS((G2(I)-G2BFOR)/G2(I)).LT.TLRG2)GOTO50
      D=MIN(D,10.*DLAST)
      D=MAX(D,0.1*DLAST)
   40 CONTINUE
      WRITE(CBF1,'(I2,2E10.2)')IEXT,SAG,AIMSAG
      CALLMNWARN('D','MNHESS','Second Deriv. SAG,AIM= '//CBF1)
   50 CONTINUE
      NDEX=I*(I+1)/2
      VHMAT(NDEX)=G2(I)
  100 CONTINUE
      CALLMNINEX(X)
      IF(ISTRAT.GT.0)CALLMNHES1(FCN,FUTIL)
      ISW(2)=3
      DCOVAR=0.
      IF(NPAR.EQ.1)GOTO214
      DO200I=1,NPAR
      DO180J=1,I-1
      XTI=X(I)
      XTJ=X(J)
      X(I)=XTI+DIRIN(I)
      X(J)=XTJ+DIRIN(J)
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,FS1,U,4,FUTIL)
      NFCN=NFCN+1
      X(I)=XTI
      X(J)=XTJ
      ELEM=(FS1+AMIN-YY(I)-YY(J))/(DIRIN(I)*DIRIN(J))
      NDEX=I*(I-1)/2+J
      VHMAT(NDEX)=ELEM
  180 CONTINUE
  200 CONTINUE
  214 CALLMNINEX(X)
      CALLMNPSDF
      DO220I=1,NPAR
      DO219J=1,I
      NDEX=I*(I-1)/2+J
      P(I,J)=VHMAT(NDEX)
  219 P(J,I)=P(I,J)
  220 CONTINUE
      CALLMNVERT(P,MAXINT,MAXINT,NPAR,IFAIL)
      IF(IFAIL.GT.0)THEN
      CALLMNWARN('W','HESSE','Matrix inversion fails.')
      GOTO390
      ENDIF
      EDM=0.
      DO230I=1,NPAR
      NDEX=I*(I-1)/2
      DO225J=1,I-1
      NDEX=NDEX+1
      ZTEMP=2.0*P(I,J)
      EDM=EDM+GRD(I)*ZTEMP*GRD(J)
  225 VHMAT(NDEX)=ZTEMP
      NDEX=NDEX+1
      VHMAT(NDEX)=2.0*P(I,I)
      EDM=EDM+P(I,I)*GRD(I)**2
  230 CONTINUE
      IF(ISW(5).GE.1.AND.ISW(2).EQ.3.AND.ITAUR.EQ.0)WRITE(ISYSWR,'(A)')'
     + COVARIANCE MATRIX CALCULATED SUCCESSFULLY'
      GOTO900
  390 ISW(2)=1
      DCOVAR=1.
      CSTATU='FAILED    '
      IF(ISW(5).GE.0)WRITE(ISYSWR,'(A)')'  MNHESS FAILS AND WILL RETURN 
     +DIAGONAL MATRIX. '
      DO395I=1,NPAR
      NDEX=I*(I-1)/2
      DO394J=1,I-1
      NDEX=NDEX+1
  394 VHMAT(NDEX)=0.0
      NDEX=NDEX+1
      G2I=G2(I)
      IF(G2I.LE.ZERO)G2I=1.0
  395 VHMAT(NDEX)=2.0/G2I
  900 RETURN
      END
 
      SUBROUTINEMNHES1(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      LOGICALLDEBUG
      CHARACTERCBF1*22
      LDEBUG=(IDBG(5).GE.1)
      IF(ISTRAT.LE.0)NCYC=1
      IF(ISTRAT.EQ.1)NCYC=2
      IF(ISTRAT.GT.1)NCYC=6
      IDRV=1
      NPARX=NPAR
      DFMIN=4.*EPSMA2*(ABS(AMIN)+UP)
      DO100I=1,NPAR
      XTF=X(I)
      DMIN=4.*EPSMA2*ABS(XTF)
      EPSPRI=EPSMA2+ABS(GRD(I)*EPSMA2)
      OPTSTP=SQRT(DFMIN/(ABS(G2(I))+EPSPRI))
      D=0.2*ABS(GSTEP(I))
      IF(D.GT.OPTSTP)D=OPTSTP
      IF(D.LT.DMIN)D=DMIN
      CHGOLD=10000.
      DO50ICYC=1,NCYC
      X(I)=XTF+D
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,FS1,U,4,FUTIL)
      NFCN=NFCN+1
      X(I)=XTF-D
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,FS2,U,4,FUTIL)
      NFCN=NFCN+1
      X(I)=XTF
      SAG=0.5*(FS1+FS2-2.0*AMIN)
      GRDOLD=GRD(I)
      GRDNEW=(FS1-FS2)/(2.0*D)
      DGMIN=EPSMAC*(ABS(FS1)+ABS(FS2))/D
      IF(LDEBUG)WRITE(ISYSWR,11)I,IDRV,GSTEP(I),D,G2(I),GRDNEW,SAG
   11 FORMAT(I4,I2,6G12.5)
      IF(GRDNEW.EQ.ZERO)GOTO60
      CHANGE=ABS((GRDOLD-GRDNEW)/GRDNEW)
      IF(CHANGE.GT.CHGOLD.AND.ICYC.GT.1)GOTO60
      CHGOLD=CHANGE
      GRD(I)=GRDNEW
      GSTEP(I)=SIGN(D,GSTEP(I))
      IF(CHANGE.LT.0.05)GOTO60
      IF(ABS(GRDOLD-GRDNEW).LT.DGMIN)GOTO60
      IF(D.LT.DMIN)THEN
      CALLMNWARN('D','MNHES1','Step size too small for 1st drv.')
      GOTO60
      ENDIF
      D=0.2*D
   50 CONTINUE
      WRITE(CBF1,'(2G11.3)')GRDOLD,GRDNEW
      CALLMNWARN('D','MNHES1','Too many iterations on D1.'//CBF1)
   60 CONTINUE
      DGRD(I)=MAX(DGMIN,ABS(GRDOLD-GRDNEW))
  100 CONTINUE
      CALLMNINEX(X)
      RETURN
      END
 
      SUBROUTINEMNIMPR(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      DIMENSIONDSAV(MNI),Y(MNI+1)
      PARAMETER(ALPHA=1.,BETA=0.5,GAMMA=2.0)
      DATARNUM/0./
      IF(NPAR.LE.0)RETURN
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      CSTATU='UNCHANGED '
      ITAUR=1
      EPSI=0.1*UP
      NPFN=NFCN
      NLOOP=WORD7(2)
      IF(NLOOP.LE.0)NLOOP=NPAR+4
      NPARX=NPAR
      NPARP1=NPAR+1
      WG=1.0/FLOAT(NPAR)
      SIGSAV=EDM
      APSI=AMIN
      DO2I=1,NPAR
      XT(I)=X(I)
      DSAV(I)=WERR(I)
      DO2J=1,I
      NDEX=I*(I-1)/2+J
      P(I,J)=VHMAT(NDEX)
    2 P(J,I)=P(I,J)
      CALLMNVERT(P,MAXINT,MAXINT,NPAR,IFAIL)
      IF(IFAIL.GE.1)GOTO280
      DO12I=1,NPAR
      NDEX=I*(I-1)/2
      DO12J=1,I
      NDEX=NDEX+1
   12 VTHMAT(NDEX)=P(I,J)
      LOOP=0
   20 CONTINUE
      DO25I=1,NPAR
      DIRIN(I)=2.0*DSAV(I)
      CALLMNRN15(RNUM,ISEED)
   25 X(I)=XT(I)+2.0*DIRIN(I)*(RNUM-0.5)
      LOOP=LOOP+1
      REG=2.0
      IF(ISW(5).GE.0)WRITE(ISYSWR,1040)LOOP
   30 CALLMNCALF(FCN,X,YCALF,FUTIL)
      AMIN=YCALF
      JL=NPARP1
      JH=NPARP1
      Y(NPARP1)=AMIN
      AMAX=AMIN
      DO45I=1,NPAR
      XI=X(I)
      CALLMNRN15(RNUM,ISEED)
      X(I)=XI-DIRIN(I)*(RNUM-0.5)
      CALLMNCALF(FCN,X,YCALF,FUTIL)
      Y(I)=YCALF
      IF(Y(I).LT.AMIN)THEN
      AMIN=Y(I)
      JL=I
      ELSEIF(Y(I).GT.AMAX)THEN
      AMAX=Y(I)
      JH=I
      ENDIF
      DO40J=1,NPAR
   40 P(J,I)=X(J)
      P(I,NPARP1)=XI
      X(I)=XI
   45 CONTINUE
      EDM=AMIN
      SIG2=EDM
   50 CONTINUE
      IF(AMIN.LT.ZERO)GOTO95
      IF(ISW(2).LE.2)GOTO280
      EP=0.1*AMIN
      IF(SIG2.LT.EP.AND.EDM.LT.EP)GOTO100
      SIG2=EDM
      IF((NFCN-NPFN).GT.NFCNMX)GOTO300
      DO60I=1,NPAR
      PB=0.
      DO59J=1,NPARP1
   59 PB=PB+WG*P(I,J)
      PBAR(I)=PB-WG*P(I,JH)
   60 PSTAR(I)=(1.+ALPHA)*PBAR(I)-ALPHA*P(I,JH)
      CALLMNCALF(FCN,PSTAR,YCALF,FUTIL)
      YSTAR=YCALF
      IF(YSTAR.GE.AMIN)GOTO70
      DO61I=1,NPAR
   61 PSTST(I)=GAMMA*PSTAR(I)+(1.-GAMMA)*PBAR(I)
      CALLMNCALF(FCN,PSTST,YCALF,FUTIL)
      YSTST=YCALF
   66 IF(YSTST.LT.Y(JL))GOTO67
      CALLMNRAZZ(YSTAR,PSTAR,Y,JH,JL)
      GOTO50
   67 CALLMNRAZZ(YSTST,PSTST,Y,JH,JL)
      GOTO50
   70 IF(YSTAR.GE.Y(JH))GOTO73
      JHOLD=JH
      CALLMNRAZZ(YSTAR,PSTAR,Y,JH,JL)
      IF(JHOLD.NE.JH)GOTO50
   73 DO74I=1,NPAR
   74 PSTST(I)=BETA*P(I,JH)+(1.-BETA)*PBAR(I)
      CALLMNCALF(FCN,PSTST,YCALF,FUTIL)
      YSTST=YCALF
      IF(YSTST.GT.Y(JH))GOTO30
      IF(YSTST.LT.AMIN)GOTO67
      CALLMNRAZZ(YSTST,PSTST,Y,JH,JL)
      GOTO50
   95 IF(ISW(5).GE.0)WRITE(ISYSWR,1000)
      REG=0.1
  100 CALLMNINEX(X)
      CALLFCN(NPARX,GIN,AMIN,U,4,FUTIL)
      NFCN=NFCN+1
      DO120I=1,NPAR
      DIRIN(I)=REG*DSAV(I)
      IF(ABS(X(I)-XT(I)).GT.DIRIN(I))GOTO150
  120 CONTINUE
      GOTO230
  150 NFCNMX=NFCNMX+NPFN-NFCN
      NPFN=NFCN
      CALLMNSIMP(FCN,FUTIL)
      IF(AMIN.GE.APSI)GOTO325
      DO220I=1,NPAR
      DIRIN(I)=0.1*DSAV(I)
      IF(ABS(X(I)-XT(I)).GT.DIRIN(I))GOTO250
  220 CONTINUE
  230 IF(AMIN.LT.APSI)GOTO350
      GOTO325
  250 LNEWMN=.TRUE.
      IF(ISW(2).GE.1)THEN
      ISW(2)=1
      DCOVAR=MAX(DCOVAR,HALF)
      ELSE
      DCOVAR=1.
      ENDIF
      ITAUR=0
      NFCNMX=NFCNMX+NPFN-NFCN
      CSTATU='NEW MINIMU'
      IF(ISW(5).GE.0)WRITE(ISYSWR,1030)
      RETURN
  280 IF(ISW(5).GT.0)WRITE(ISYSWR,1020)
      GOTO325
  300 ISW(1)=1
  325 DO330I=1,NPAR
      DIRIN(I)=0.01*DSAV(I)
  330 X(I)=XT(I)
      AMIN=APSI
      EDM=SIGSAV
  350 CALLMNINEX(X)
      IF(ISW(5).GT.0)WRITE(ISYSWR,1010)
      CSTATU='UNCHANGED '
      CALLMNRSET(0)
      IF(ISW(2).LT.2)GOTO380
      IF(LOOP.LT.NLOOP.AND.ISW(1).LT.1)GOTO20
  380 CALLMNPRIN(5,AMIN)
      ITAUR=0
      RETURN
 1000 FORMAT('AN IMPROVEMENT ON THE PREVIOUS MINIMUM HAS BEEN FOUND')
 1010 FORMAT('IMPROVE HAS RETURNED TO REGION OF ORIGINAL MINIMUM')
 1020 FORMAT(/' COVARIANCE MATRIX WAS NOT POSITIVE-DEFINITE')
 1030 FORMAT(/' IMPROVE HAS FOUND A TRULY NEW MINIMUM')
 1040 FORMAT(/' START ATTEMPT NO.',I2,' TO FIND NEW MINIMUM')
      END
 
      SUBROUTINEMNINEX(PINT)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      DIMENSIONPINT(*)
      DO100J=1,NPAR
      I=NEXOFI(J)
      IF(NVARL(I).EQ.1)THEN
      U(I)=PINT(J)
      ELSE
      U(I)=ALIM(I)+0.5*(SIN(PINT(J))+1.0)*(BLIM(I)-ALIM(I))
      ENDIF
  100 CONTINUE
      RETURN
      END
 
      SUBROUTINEMNINIT(I1,I2,I3)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALINTRAC
      LOGICALINTRAC
      ISYSRD=I1
      ISYSWR=I2
      ISTKWR(1)=ISYSWR
      NSTKWR=1
      ISYSSA=I3
      NSTKRD=0
      CVRSN='93.08 '
      MAXINT=MNI
      MAXEXT=MNE
      UNDEFI=-54321.
      BIGEDM=123456.
      CUNDEF=')UNDEFINED'
      COVMES(0)='NO ERROR MATRIX       '
      COVMES(1)='ERR MATRIX APPROXIMATE'
      COVMES(2)='ERR MATRIX NOT POS-DEF'
      COVMES(3)='ERROR MATRIX ACCURATE '
      NBLOCK=0
      ICOMND=0
      CTITL=CUNDEF
      CFROM='INPUT   '
      NFCNFR=NFCN
      CSTATU='INITIALIZE'
      ISW(3)=0
      ISW(4)=0
      ISW(5)=1
      ISW(6)=0
      IF(INTRAC(DUMMY))ISW(6)=1
      DO10IDB=0,MAXDBG
   10 IDBG(IDB)=0
      LREPOR=.FALSE.
      LWARN=.TRUE.
      LIMSET=.FALSE.
      LNEWMN=.FALSE.
      ISTRAT=1
      ITAUR=0
      NPAGWD=120
      NPAGLN=56
      NEWPAG=1
      IF(ISW(6).GT.0)THEN
      NPAGWD=80
      NPAGLN=30
      NEWPAG=0
      ENDIF
      UP=1.0
      UPDFLT=UP
      EPSTRY=0.5
      DO33I=1,100
      EPSTRY=EPSTRY*0.5
      EPSP1=ONE+EPSTRY
      CALLMNTINY(EPSP1,EPSBAK)
      IF(EPSBAK.LT.EPSTRY)GOTO35
   33 CONTINUE
      EPSTRY=1.0E-7
      EPSMAC=4.0*EPSTRY
      WRITE(ISYSWR,'(A,A,E10.2)')' MNINIT UNABLE TO DETERMINE',' ARITHME
     +TIC PRECISION. WILL ASSUME:',EPSMAC
   35 EPSMAC=8.0*EPSTRY
      EPSMA2=2.0*SQRT(EPSMAC)
      PIBY2=2.0*ATAN(1.0)
      DISTNN=8.0*SQRT(EPSMA2)
      VLIMHI=PIBY2-DISTNN
      VLIMLO=-PIBY2+DISTNN
      CALLMNCLER
      WRITE(ISYSWR,'(3A,I3,A,I3,A,E10.2)')'  MINUIT RELEASE ',CVRSN,' IN
     +ITIALIZED.   DIMENSIONS ',MNE,'/',MNI,'  EPSMAC=',EPSMAC
      RETURN
      END
 
      SUBROUTINEMNINPU(IUNIT,IERR)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      IERR=0
      IF(IUNIT.EQ.0)THEN
      IF(NSTKRD.EQ.0)THEN
      WRITE(ISYSWR,'(A)')' CALL TO MNINPU(0) IGNORED'
      WRITE(ISYSWR,'(A)')' ALREADY READING FROM PRIMARY INPUT'
      ELSE
      ISYSRD=ISTKRD(NSTKRD)
      NSTKRD=NSTKRD-1
      ENDIF
      ELSE
      IF(NSTKRD.GE.MAXSTK)THEN
      WRITE(ISYSWR,'(A)')' INPUT FILE STACK SIZE EXCEEDED.'
      GOTO800
      ENDIF
      NSTKRD=NSTKRD+1
      ISTKRD(NSTKRD)=ISYSRD
      ISYSRD=IUNIT
      ENDIF
      RETURN
  800 IERR=1
      RETURN
      END
 
      SUBROUTINEMNINTR(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      IFLGIN=3
      CALLMNREAD(FCN,IFLGIN,IFLGUT,FUTIL)
      WRITE(ISYSWR,'(2A/)')' END OF MINUIT COMMAND INPUT. ','   RETURN T
     +O USER PROGRAM.'
      RETURN
      END
 
      SUBROUTINEMNLIMS(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      CFROM='SET LIM '
      NFCNFR=NFCN
      CSTATU='NO CHANGE '
      I2=WORD7(1)
      IF(I2.GT.MAXEXT.OR.I2.LT.0)GOTO900
      IF(I2.GT.0)GOTO30
      NEWCOD=4
      IF(WORD7(2).EQ.WORD7(3))NEWCOD=1
      DO20INU=1,NU
      IF(NVARL(INU).LE.0)GOTO20
      IF(NVARL(INU).EQ.1.AND.NEWCOD.EQ.1)GOTO20
      KINT=NIOFEX(INU)
      IF(KINT.LE.0)THEN
      IF(ISW(5).GE.0)WRITE(ISYSWR,'(11X,A,I3)')' LIMITS NOT CHANGED FOR 
     +FIXED PARAMETER:',INU
      GOTO20
      ENDIF
      IF(NEWCOD.EQ.1)THEN
      IF(ISW(5).GT.0)WRITE(ISYSWR,134)INU
      CSTATU='NEW LIMITS'
      CALLMNDXDI(X(KINT),KINT,DXDI)
      SNEW=GSTEP(KINT)*DXDI
      GSTEP(KINT)=ABS(SNEW)
      NVARL(INU)=1
      ELSE
      ALIM(INU)=MIN(WORD7(2),WORD7(3))
      BLIM(INU)=MAX(WORD7(2),WORD7(3))
      IF(ISW(5).GT.0)WRITE(ISYSWR,237)INU,ALIM(INU),BLIM(INU)
      NVARL(INU)=4
      CSTATU='NEW LIMITS'
      GSTEP(KINT)=-0.1
      ENDIF
   20 CONTINUE
      GOTO900
   30 IF(NVARL(I2).LE.0)THEN
      WRITE(ISYSWR,'(A,I3,A)')' PARAMETER ',I2,' IS NOT VARIABLE.'
      GOTO900
      ENDIF
      KINT=NIOFEX(I2)
      IF(KINT.EQ.0)THEN
      WRITE(ISYSWR,'(A,I3)')' REQUEST TO CHANGE LIMITS ON FIXED PARAMETE
     +R:',I2
      DO82IFX=1,NPFIX
      IF(I2.EQ.IPFIX(IFX))GOTO92
   82 CONTINUE
      WRITE(ISYSWR,'(A)')' MINUIT BUG IN MNLIMS. SEE F. JAMES'
   92 CONTINUE
      ENDIF
      IF(WORD7(2).NE.WORD7(3))GOTO235
      IF(NVARL(I2).NE.1)THEN
      IF(ISW(5).GT.0)WRITE(ISYSWR,134)I2
  134 FORMAT(' LIMITS REMOVED FROM PARAMETER ',I4)
      CSTATU='NEW LIMITS'
      IF(KINT.LE.0)THEN
      GSTEPS(IFX)=ABS(GSTEPS(IFX))
      ELSE
      CALLMNDXDI(X(KINT),KINT,DXDI)
      IF(ABS(DXDI).LT.0.01)DXDI=0.01
      GSTEP(KINT)=ABS(GSTEP(KINT)*DXDI)
      GRD(KINT)=GRD(KINT)*DXDI
      ENDIF
      NVARL(I2)=1
      ELSE
      WRITE(ISYSWR,'(A,I3)')' NO LIMITS SPECIFIED.  PARAMETER ',I2,' IS 
     +ALREADY UNLIMITED.  NO CHANGE.'
      ENDIF
      GOTO900
  235 ALIM(I2)=MIN(WORD7(2),WORD7(3))
      BLIM(I2)=MAX(WORD7(2),WORD7(3))
      NVARL(I2)=4
      IF(ISW(5).GT.0)WRITE(ISYSWR,237)I2,ALIM(I2),BLIM(I2)
  237 FORMAT(' PARAMETER ',I3,' LIMITS SET TO',2G15.5)
      CSTATU='NEW LIMITS'
      IF(KINT.LE.0)THEN
      GSTEPS(IFX)=-0.1
      ELSE
      GSTEP(KINT)=-0.1
      ENDIF
  900 CONTINUE
      IF(CSTATU.NE.'NO CHANGE ')THEN
      CALLMNEXIN(X)
      CALLMNRSET(1)
      ENDIF
      RETURN
      END
 
      SUBROUTINEMNLINE(FCN,START,FSTART,STEP,SLOPE,TOLER,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      DIMENSIONSTART(*),STEP(*)
      PARAMETER(MAXPT=12)
      DIMENSIONXPQ(MAXPT),YPQ(MAXPT)
      CHARACTER*1CHPQ(MAXPT)
      DIMENSIONXVALS(3),FVALS(3),COEFF(3)
      CHARACTER*26CHARAL
      CHARACTER*60CMESS
      PARAMETER(SLAMBG=5.,ALPHA=2.)
      LOGICALLDEBUG
      DATACHARAL/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
      LDEBUG=(IDBG(1).GE.1)
      OVERAL=1000.
      UNDRAL=-100.
      IF(LDEBUG)THEN
      CALLMNINEX(START)
      CALLFCN(NPARX,GIN,F1,U,4,FUTIL)
      NFCN=NFCN+1
      IF(F1.NE.FSTART)THEN
      WRITE(ISYSWR,'(A/2E14.5/2X,10F10.5)')' MNLINE start point not cons
     +istent, F values, parameters=',(X(KK),KK=1,NPAR)
      ENDIF
      ENDIF
      FVMIN=FSTART
      XVMIN=ZERO
      NXYPT=1
      CHPQ(1)=CHARAL(1:1)
      XPQ(1)=0.
      YPQ(1)=FSTART
      SLAMIN=ZERO
      DO20I=1,NPAR
      IF(STEP(I).EQ.ZERO)GOTO20
      RATIO=ABS(START(I)/STEP(I))
      IF(SLAMIN.EQ.ZERO)SLAMIN=RATIO
      IF(RATIO.LT.SLAMIN)SLAMIN=RATIO
   20 X(I)=START(I)+STEP(I)
      IF(SLAMIN.EQ.ZERO)SLAMIN=EPSMAC
      SLAMIN=SLAMIN*EPSMA2
      NPARX=NPAR
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,F1,U,4,FUTIL)
      NFCN=NFCN+1
      NXYPT=NXYPT+1
      CHPQ(NXYPT)=CHARAL(NXYPT:NXYPT)
      XPQ(NXYPT)=1.
      YPQ(NXYPT)=F1
      IF(F1.LT.FSTART)THEN
      FVMIN=F1
      XVMIN=1.0
      ENDIF
      SLAM=1.
      TOLER8=TOLER
      SLAMAX=SLAMBG
      FLAST=F1
   25 CONTINUE
      DENOM=2.0*(FLAST-FSTART-SLOPE*SLAM)/SLAM**2
      SLAM=1.
      IF(DENOM.NE.ZERO)SLAM=-SLOPE/DENOM
      IF(SLAM.LT.ZERO)SLAM=SLAMAX
      IF(SLAM.GT.SLAMAX)SLAM=SLAMAX
      IF(SLAM.LT.TOLER8)SLAM=TOLER8
      IF(SLAM.LT.SLAMIN)GOTO80
      IF(ABS(SLAM-1.0).LT.TOLER8.AND.F1.LT.FSTART)GOTO70
      IF(ABS(SLAM-1.0).LT.TOLER8)SLAM=1.0+TOLER8
      IF(NXYPT.GE.MAXPT)GOTO65
      DO30I=1,NPAR
   30 X(I)=START(I)+SLAM*STEP(I)
      CALLMNINEX(X)
      CALLFCN(NPAR,GIN,F2,U,4,FUTIL)
      NFCN=NFCN+1
      NXYPT=NXYPT+1
      CHPQ(NXYPT)=CHARAL(NXYPT:NXYPT)
      XPQ(NXYPT)=SLAM
      YPQ(NXYPT)=F2
      IF(F2.LT.FVMIN)THEN
      FVMIN=F2
      XVMIN=SLAM
      ENDIF
      IF(FSTART.EQ.FVMIN)THEN
      FLAST=F2
      TOLER8=TOLER*SLAM
      OVERAL=SLAM-TOLER8
      SLAMAX=OVERAL
      GOTO25
      ENDIF
      XVALS(1)=XPQ(1)
      FVALS(1)=YPQ(1)
      XVALS(2)=XPQ(NXYPT-1)
      FVALS(2)=YPQ(NXYPT-1)
      XVALS(3)=XPQ(NXYPT)
      FVALS(3)=YPQ(NXYPT)
   50 CONTINUE
      SLAMAX=MAX(SLAMAX,ALPHA*ABS(XVMIN))
      CALLMNPFIT(XVALS,FVALS,3,COEFF,SDEV)
      IF(COEFF(3).LE.ZERO)THEN
      SLOPEM=2.0*COEFF(3)*XVMIN+COEFF(2)
      IF(SLOPEM.LE.ZERO)THEN
      SLAM=XVMIN+SLAMAX
      ELSE
      SLAM=XVMIN-SLAMAX
      ENDIF
      ELSE
      SLAM=-COEFF(2)/(2.0*COEFF(3))
      IF(SLAM.GT.XVMIN+SLAMAX)SLAM=XVMIN+SLAMAX
      IF(SLAM.LT.XVMIN-SLAMAX)SLAM=XVMIN-SLAMAX
      ENDIF
      IF(SLAM.GT.ZERO)THEN
      IF(SLAM.GT.OVERAL)SLAM=OVERAL
      ELSE
      IF(SLAM.LT.UNDRAL)SLAM=UNDRAL
      ENDIF
   52 CONTINUE
      TOLER9=MAX(TOLER8,ABS(TOLER8*SLAM))
      DO55IPT=1,3
      IF(ABS(SLAM-XVALS(IPT)).LT.TOLER9)GOTO70
   55 CONTINUE
      IF(NXYPT.GE.MAXPT)GOTO65
      DO60I=1,NPAR
   60 X(I)=START(I)+SLAM*STEP(I)
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,F3,U,4,FUTIL)
      NFCN=NFCN+1
      NXYPT=NXYPT+1
      CHPQ(NXYPT)=CHARAL(NXYPT:NXYPT)
      XPQ(NXYPT)=SLAM
      YPQ(NXYPT)=F3
      FVMAX=FVALS(1)
      NVMAX=1
      IF(FVALS(2).GT.FVMAX)THEN
      FVMAX=FVALS(2)
      NVMAX=2
      ENDIF
      IF(FVALS(3).GT.FVMAX)THEN
      FVMAX=FVALS(3)
      NVMAX=3
      ENDIF
      IF(F3.GE.FVMAX)THEN
      IF(NXYPT.GE.MAXPT)GOTO65
      IF(SLAM.GT.XVMIN)OVERAL=MIN(OVERAL,SLAM-TOLER8)
      IF(SLAM.LT.XVMIN)UNDRAL=MAX(UNDRAL,SLAM+TOLER8)
      SLAM=0.5*(SLAM+XVMIN)
      GOTO52
      ENDIF
      XVALS(NVMAX)=SLAM
      FVALS(NVMAX)=F3
      IF(F3.LT.FVMIN)THEN
      FVMIN=F3
      XVMIN=SLAM
      ELSE
      IF(SLAM.GT.XVMIN)OVERAL=MIN(OVERAL,SLAM-TOLER8)
      IF(SLAM.LT.XVMIN)UNDRAL=MAX(UNDRAL,SLAM+TOLER8)
      ENDIF
      IF(NXYPT.LT.MAXPT)GOTO50
   65 CMESS=' LINE SEARCH HAS EXHAUSTED THE LIMIT OF FUNCTION CALLS '
      IF(LDEBUG)THEN
      WRITE(ISYSWR,'(A/(2X,6G12.4))')' MNLINE DEBUG: steps=',(STEP(KK),K
     +K=1,NPAR)
      ENDIF
      GOTO100
   70 CONTINUE
      CMESS=' LINE SEARCH HAS ATTAINED TOLERANCE '
      GOTO100
   80 CONTINUE
      CMESS=' STEP SIZE AT ARITHMETICALLY ALLOWED MINIMUM'
  100 CONTINUE
      AMIN=FVMIN
      DO120I=1,NPAR
      DIRIN(I)=STEP(I)*XVMIN
  120 X(I)=START(I)+DIRIN(I)
      CALLMNINEX(X)
      IF(XVMIN.LT.0.)CALLMNWARN('D','MNLINE',' LINE MINIMUM IN BACKWARDS
     + DIRECTION')
      IF(FVMIN.EQ.FSTART)CALLMNWARN('D','MNLINE',' LINE SEARCH FINDS NO 
     +IMPROVEMENT ')
      IF(LDEBUG)THEN
      WRITE(ISYSWR,'('' AFTER'',I3,'' POINTS,'',A)')NXYPT,CMESS
      CALLMNPLOT(XPQ,YPQ,CHPQ,NXYPT,ISYSWR,NPAGWD,NPAGLN)
      ENDIF
      RETURN
      END
 
      SUBROUTINEMNMATU(KODE)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      DIMENSIONVLINE(MNI)
      ISW2=ISW(2)
      IF(ISW2.LT.1)THEN
      WRITE(ISYSWR,'(1X,A)')COVMES(ISW2)
      GOTO500
      ENDIF
      IF(NPAR.EQ.0)THEN
      WRITE(ISYSWR,'('' MNMATU: NPAR=0'')')
      GOTO500
      ENDIF
      IF(KODE.EQ.1)THEN
      ISW5=ISW(5)
      ISW(5)=2
      CALLMNEMAT(P,MAXINT)
      IF(ISW2.LT.3)WRITE(ISYSWR,'(1X,A)')COVMES(ISW2)
      ISW(5)=ISW5
      ENDIF
      IF(NPAR.LE.1)GOTO500
      CALLMNWERR
      NCOEF=(NPAGWD-19)/6
      NCOEF=MIN(NCOEF,20)
      NPARM=MIN(NPAR,NCOEF)
      WRITE(ISYSWR,150)(NEXOFI(ID),ID=1,NPARM)
  150 FORMAT(/'PARAMETER  CORRELATION COEFFICIENTS  ','       NO.  GLOBA
     +L  ',20I6)
      DO200I=1,NPAR
      IX=NEXOFI(I)
      NDI=I*(I+1)/2
      DO170J=1,NPAR
      M=MAX(I,J)
      N=MIN(I,J)
      NDEX=M*(M-1)/2+N
      NDJ=J*(J+1)/2
  170 VLINE(J)=VHMAT(NDEX)/SQRT(ABS(VHMAT(NDI)*VHMAT(NDJ)))
      NPARM=MIN(NPAR,NCOEF)
      WRITE(ISYSWR,171)IX,GLOBCC(I),(VLINE(IT),IT=1,NPARM)
  171 FORMAT(6X,I3,2X,F7.5,1X,20F6.3)
      IF(I.LE.NPARM)GOTO200
      DO190ISO=1,10
      NSOFAR=NPARM
      NPARM=MIN(NPAR,NSOFAR+NCOEF)
      WRITE(ISYSWR,181)(VLINE(IT),IT=NSOFAR+1,NPARM)
  181 FORMAT(19X,20F6.3)
      IF(I.LE.NPARM)GOTO192
  190 CONTINUE
  192 CONTINUE
  200 CONTINUE
      IF(ISW2.LT.3)WRITE(ISYSWR,'(1X,A)')COVMES(ISW2)
  500 RETURN
      END
 
      SUBROUTINEMNMIGR(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      DIMENSIONGS(MNI),STEP(MNI),XXS(MNI),FLNU(MNI),VG(MNI)
      LOGICALLDEBUG
      PARAMETER(TOLER=0.05)
      IF(NPAR.LE.0)RETURN
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      LDEBUG=(IDBG(4).GE.1)
      CFROM='MIGRAD  '
      NFCNFR=NFCN
      NFCNMG=NFCN
      CSTATU='INITIATE  '
      ISWTR=ISW(5)-2*ITAUR
      NPFN=NFCN
      NPARX=NPAR
      VLEN=NPAR*(NPAR+1)/2
      NRSTRT=0
      NPSDF=0
      LINED2=0
      ISW(4)=-1
      RHOTOL=1.0E-3*APSI
      IF(ISWTR.GE.1)WRITE(ISYSWR,470)ISTRAT,RHOTOL
  470 FORMAT(' START MIGRAD MINIMIZATION.  STRATEGY',I2,'.  CONVERGENCE 
     +WHEN EDM .LT.',E9.2)
      IF(ISTRAT.LT.2.OR.ISW(2).GE.3)GOTO2
    1 CONTINUE
      IF(NRSTRT.GT.ISTRAT)THEN
      CSTATU='FAILED    '
      ISW(4)=-1
      GOTO230
      ENDIF
      CALLMNHESS(FCN,FUTIL)
      CALLMNWERR
      NPSDF=0
      IF(ISW(2).GE.1)GOTO10
    2 CONTINUE
      CALLMNINEX(X)
      IF(ISW(3).EQ.1)THEN
      CALLFCN(NPARX,GIN,FZERO,U,2,FUTIL)
      NFCN=NFCN+1
      ENDIF
      CALLMNDERI(FCN,FUTIL)
      IF(ISW(2).GE.1)GOTO10
      DO3I=1,NPAR
      XXS(I)=X(I)
      STEP(I)=ZERO
    3 CONTINUE
      LINED2=LINED2+1
      IF(LINED2.LT.(ISTRAT+1)*NPAR)THEN
      DO5I=1,NPAR
      IF(G2(I).GT.ZERO)GOTO5
      STEP(I)=-SIGN(GSTEP(I),GRD(I))
      GDEL=STEP(I)*GRD(I)
      FS=AMIN
      CALLMNLINE(FCN,XXS,FS,STEP,GDEL,TOLER,FUTIL)
      CALLMNWARN('D','MNMIGR','Negative G2 line search')
      IEXT=NEXOFI(I)
      IF(LDEBUG)WRITE(ISYSWR,'(A,I3,2G13.3)')' Negative G2 line search, 
     +param ',IEXT,FS,AMIN
      GOTO2
    5 CONTINUE
      ENDIF
      DO8I=1,NPAR
      NDEX=I*(I-1)/2
      DO7J=1,I-1
      NDEX=NDEX+1
    7 VHMAT(NDEX)=0.
      NDEX=NDEX+1
      IF(G2(I).LE.ZERO)G2(I)=1.
      VHMAT(NDEX)=2./G2(I)
    8 CONTINUE
      DCOVAR=1.
      IF(LDEBUG)WRITE(ISYSWR,'(A,A/(1X,10G10.2))')' DEBUG MNMIGR,',' STA
     +RTING MATRIX DIAGONAL,  VHMAT=',(VHMAT(KK),KK=1,VLEN)
   10 CONTINUE
      NRSTRT=NRSTRT+1
      IF(NRSTRT.GT.ISTRAT+1)THEN
      CSTATU='FAILED    '
      GOTO230
      ENDIF
      FS=AMIN
      EDM=0.
      DO18I=1,NPAR
      GS(I)=GRD(I)
      XXS(I)=X(I)
      NDEX=I*(I-1)/2
      DO17J=1,I-1
      NDEX=NDEX+1
   17 EDM=EDM+GS(I)*VHMAT(NDEX)*GS(J)
      NDEX=NDEX+1
   18 EDM=EDM+0.5*GS(I)**2*VHMAT(NDEX)
      EDM=EDM*0.5*(1.0+3.0*DCOVAR)
      IF(EDM.LT.ZERO)THEN
      CALLMNWARN('W','MIGRAD','STARTING MATRIX NOT POS-DEFINITE.')
      ISW(2)=0
      DCOVAR=1.
      GOTO2
      ENDIF
      IF(ISW(2).EQ.0)EDM=BIGEDM
      ITER=0
      CALLMNINEX(X)
      CALLMNWERR
      IF(ISWTR.GE.1)CALLMNPRIN(3,AMIN)
      IF(ISWTR.GE.2)CALLMNMATU(0)
   24 CONTINUE
      IF(NFCN-NPFN.GE.NFCNMX)GOTO190
      GDEL=0.
      GSSQ=0.
      DO30I=1,NPAR
      RI=0.
      GSSQ=GSSQ+GS(I)**2
      DO25J=1,NPAR
      M=MAX(I,J)
      N=MIN(I,J)
      NDEX=M*(M-1)/2+N
   25 RI=RI+VHMAT(NDEX)*GS(J)
      STEP(I)=-0.5*RI
   30 GDEL=GDEL+STEP(I)*GS(I)
      IF(GSSQ.EQ.ZERO)THEN
      CALLMNWARN('D','MIGRAD',' FIRST DERIVATIVES OF FCN ARE ALL ZERO')
      GOTO300
      ENDIF
      IF(GDEL.GE.ZERO)THEN
      CALLMNWARN('D','MIGRAD',' NEWTON STEP NOT DESCENT.')
      IF(NPSDF.EQ.1)GOTO1
      CALLMNPSDF
      NPSDF=1
      GOTO24
      ENDIF
      CALLMNLINE(FCN,XXS,FS,STEP,GDEL,TOLER,FUTIL)
      IF(AMIN.EQ.FS)GOTO200
      CFROM='MIGRAD  '
      NFCNFR=NFCNMG
      CSTATU='PROGRESS  '
      CALLMNINEX(X)
      IF(ISW(3).EQ.1)THEN
      CALLFCN(NPARX,GIN,FZERO,U,2,FUTIL)
      NFCN=NFCN+1
      ENDIF
      CALLMNDERI(FCN,FUTIL)
      NPSDF=0
   81 EDM=0.
      GVG=0.
      DELGAM=0.
      GDGSSQ=0.
      DO100I=1,NPAR
      RI=0.
      VGI=0.
      DO90J=1,NPAR
      M=MAX(I,J)
      N=MIN(I,J)
      NDEX=M*(M-1)/2+N
      VGI=VGI+VHMAT(NDEX)*(GRD(J)-GS(J))
   90 RI=RI+VHMAT(NDEX)*GRD(J)
      VG(I)=VGI*0.5
      GAMI=GRD(I)-GS(I)
      GDGSSQ=GDGSSQ+GAMI**2
      GVG=GVG+GAMI*VG(I)
      DELGAM=DELGAM+DIRIN(I)*GAMI
  100 EDM=EDM+GRD(I)*RI*0.5
      EDM=EDM*0.5*(1.0+3.0*DCOVAR)
      IF(EDM.LT.ZERO.OR.GVG.LE.ZERO)THEN
      CALLMNWARN('D','MIGRAD','NOT POS-DEF. EDM OR GVG NEGATIVE.')
      CSTATU='NOT POSDEF'
      IF(NPSDF.EQ.1)GOTO230
      CALLMNPSDF
      NPSDF=1
      GOTO81
      ENDIF
      ITER=ITER+1
      IF(ISWTR.GE.3.OR.(ISWTR.EQ.2.AND.MOD(ITER,10).EQ.1))THEN
      CALLMNWERR
      CALLMNPRIN(3,AMIN)
      ENDIF
      IF(GDGSSQ.EQ.ZERO)CALLMNWARN('D','MIGRAD','NO CHANGE IN FIRST DERI
     +VATIVES OVER LAST STEP')
      IF(DELGAM.LT.ZERO)CALLMNWARN('D','MIGRAD','FIRST DERIVATIVES INCRE
     +ASING ALONG SEARCH LINE')
      CSTATU='IMPROVEMNT'
      IF(LDEBUG)WRITE(ISYSWR,'(A,(1X,10G10.3))')' VHMAT 1 =',(VHMAT(KK),
     +KK=1,10)
      DSUM=0.
      VSUM=0.
      DO120I=1,NPAR
      DO120J=1,I
      D=DIRIN(I)*DIRIN(J)/DELGAM-VG(I)*VG(J)/GVG
      DSUM=DSUM+ABS(D)
      NDEX=I*(I-1)/2+J
      VHMAT(NDEX)=VHMAT(NDEX)+2.0*D
      VSUM=VSUM+ABS(VHMAT(NDEX))
  120 CONTINUE
      DCOVAR=0.5*(DCOVAR+DSUM/VSUM)
      IF(ISWTR.GE.3.OR.LDEBUG)WRITE(ISYSWR,'(A,F5.1,A)')' RELATIVE CHANG
     +E IN COV. MATRIX=',DCOVAR*100.,'%'
      IF(LDEBUG)WRITE(ISYSWR,'(A,(1X,10G10.3))')' VHMAT 2 =',(VHMAT(KK),
     +KK=1,10)
      IF(DELGAM.LE.GVG)GOTO135
      DO125I=1,NPAR
  125 FLNU(I)=DIRIN(I)/DELGAM-VG(I)/GVG
      DO130I=1,NPAR
      DO130J=1,I
      NDEX=I*(I-1)/2+J
  130 VHMAT(NDEX)=VHMAT(NDEX)+2.0*GVG*FLNU(I)*FLNU(J)
  135 CONTINUE
      IF(EDM.LT.0.1*RHOTOL)GOTO300
      DO140I=1,NPAR
      XXS(I)=X(I)
      GS(I)=GRD(I)
  140 CONTINUE
      FS=AMIN
      IF(ISW(2).EQ.0.AND.DCOVAR.LT.0.5)ISW(2)=1
      IF(ISW(2).EQ.3.AND.DCOVAR.GT.0.1)ISW(2)=1
      IF(ISW(2).EQ.1.AND.DCOVAR.LT.0.05)ISW(2)=3
      GOTO24
  190 ISW(1)=1
      IF(ISW(5).GE.0)WRITE(ISYSWR,'(A)')' CALL LIMIT EXCEEDED IN MIGRAD.
     +'
      CSTATU='CALL LIMIT'
      GOTO230
  200 IF(ISWTR.GE.1)WRITE(ISYSWR,'(A)')' MIGRAD FAILS TO FIND IMPROVEMEN
     +T'
      DO210I=1,NPAR
  210 X(I)=XXS(I)
      IF(EDM.LT.RHOTOL)GOTO300
      IF(EDM.LT.ABS(EPSMA2*AMIN))THEN
      IF(ISWTR.GE.0)WRITE(ISYSWR,'(A)')' MACHINE ACCURACY LIMITS FURTHER
     + IMPROVEMENT.'
      GOTO300
      ENDIF
      IF(ISTRAT.LT.1)THEN
      IF(ISW(5).GE.0)WRITE(ISYSWR,'(A)')' MIGRAD FAILS WITH STRATEGY=0. 
     +  WILL TRY WITH STRATEGY=1.'
      ISTRAT=1
      ENDIF
      GOTO1
  230 IF(ISWTR.GE.0)WRITE(ISYSWR,'(A)')' MIGRAD TERMINATED WITHOUT CONVE
     +RGENCE.'
      IF(ISW(2).EQ.3)ISW(2)=1
      ISW(4)=-1
      GOTO400
  300 IF(ISWTR.GE.0)WRITE(ISYSWR,'(/A)')' MIGRAD MINIMIZATION HAS CONVER
     +GED.'
      IF(ITAUR.EQ.0)THEN
      IF(ISTRAT.GE.2.OR.(ISTRAT.EQ.1.AND.ISW(2).LT.3))THEN
      IF(ISW(5).GE.0)WRITE(ISYSWR,'(/A)')' MIGRAD WILL VERIFY CONVERGENC
     +E AND ERROR MATRIX.'
      CALLMNHESS(FCN,FUTIL)
      CALLMNWERR
      NPSDF=0
      IF(EDM.GT.RHOTOL)GOTO10
      ENDIF
      ENDIF
      CSTATU='CONVERGED '
      ISW(4)=1
  400 CONTINUE
      CFROM='MIGRAD  '
      NFCNFR=NFCNMG
      CALLMNINEX(X)
      CALLMNWERR
      IF(ISWTR.GE.0)CALLMNPRIN(3,AMIN)
      IF(ISWTR.GE.1)CALLMNMATU(1)
      RETURN
      END
 
      SUBROUTINEMNMNOS(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      IF(NPAR.LE.0)GOTO700
      NGOOD=0
      NBAD=0
      NFCNMI=NFCN
      DO570KNT=1,NPAR
      IF(INT(WORD7(2)).EQ.0)THEN
      ILAX=NEXOFI(KNT)
      ELSE
      IF(KNT.GE.7)GOTO580
      ILAX=INT(WORD7(KNT+1))
      IF(ILAX.EQ.0)GOTO580
      IF(ILAX.GT.0.AND.ILAX.LE.NU)THEN
      IF(NIOFEX(ILAX).GT.0)GOTO565
      ENDIF
      WRITE(ISYSWR,564)ILAX
  564 FORMAT(' PARAMETER NUMBER ',I5,' NOT VARIABLE. IGNORED.')
      GOTO570
      ENDIF
  565 CONTINUE
      ILAX2=0
      CALLMNMNOT(FCN,ILAX,ILAX2,VAL2PL,VAL2MI,FUTIL)
      IF(LNEWMN)GOTO650
      IIN=NIOFEX(ILAX)
      IF(ERP(IIN).GT.ZERO)THEN
      NGOOD=NGOOD+1
      ELSE
      NBAD=NBAD+1
      ENDIF
      IF(ERN(IIN).LT.ZERO)THEN
      NGOOD=NGOOD+1
      ELSE
      NBAD=NBAD+1
      ENDIF
  570 CONTINUE
  580 CONTINUE
      CFROM='MINOS   '
      NFCNFR=NFCNMI
      CSTATU='UNCHANGED '
      IF(NGOOD.EQ.0.AND.NBAD.EQ.0)GOTO700
      IF(NGOOD.GT.0.AND.NBAD.EQ.0)CSTATU='SUCCESSFUL'
      IF(NGOOD.EQ.0.AND.NBAD.GT.0)CSTATU='FAILURE   '
      IF(NGOOD.GT.0.AND.NBAD.GT.0)CSTATU='PROBLEMS  '
      IF(ISW(5).GE.0)CALLMNPRIN(4,AMIN)
      IF(ISW(5).GE.2)CALLMNMATU(0)
      GOTO900
  650 CONTINUE
      CFROM='MINOS   '
      NFCNFR=NFCNMI
      CSTATU='NEW MINIMU'
      IF(ISW(5).GE.0)CALLMNPRIN(4,AMIN)
      WRITE(ISYSWR,675)
  675 FORMAT(/' NEW MINIMUM FOUND.  GO BACK TO MINIMIZATION STEP.',60(1H
     +=)/60X,1HV/60X,1HV/60X,1HV/57X,7HVVVVVVV/58X,5HVVVVV/59X,3HVVV/60X
     +,1HV//)
      GOTO900
  700 WRITE(ISYSWR,'(A)')' THERE ARE NO MINOS ERRORS TO CALCULATE.'
  900 RETURN
      END
 
      SUBROUTINEMNMNOT(FCN,ILAX,ILAX2,VAL2PL,VAL2MI,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      DIMENSIONXDEV(MNI),W(MNI),GCC(MNI)
      CHARACTER*4CPOS,CNEG,CSIG
      CHARACTER*1CDOT,CSTAR,CBLANK
      PARAMETER(CPOS='POSI',CNEG='NEGA',CDOT='.',CSTAR='*',CBLANK=' ')
      ISW2=ISW(2)
      ISW4=ISW(4)
      SIGSAV=EDM
      ISTRAV=ISTRAT
      DC=DCOVAR
      LNEWMN=.FALSE.
      APSI=EPSI*0.5
      ABEST=AMIN
      MPAR=NPAR
      NFMXIN=NFCNMX
      DO125I=1,MPAR
  125 XT(I)=X(I)
      DO130J=1,MPAR*(MPAR+1)/2
  130 VTHMAT(J)=VHMAT(J)
      DO135I=1,MPAR
      GCC(I)=GLOBCC(I)
  135 W(I)=WERR(I)
      IT=NIOFEX(ILAX)
      ERP(IT)=0.
      ERN(IT)=0.
      CALLMNINEX(XT)
      UT=U(ILAX)
      IF(NVARL(ILAX).EQ.1)THEN
      ALIM(ILAX)=UT-100.*W(IT)
      BLIM(ILAX)=UT+100.*W(IT)
      ENDIF
      NDEX=IT*(IT+1)/2
      XUNIT=SQRT(UP/VTHMAT(NDEX))
      MARC=0
      DO162I=1,MPAR
      IF(I.EQ.IT)GOTO162
      MARC=MARC+1
      IMAX=MAX(IT,I)
      INDX=IMAX*(IMAX-1)/2+MIN(IT,I)
      XDEV(MARC)=XUNIT*VTHMAT(INDX)
  162 CONTINUE
      CALLMNFIXP(IT,IERR)
      IF(IERR.GT.0)THEN
      WRITE(ISYSWR,'(A,I5,A,I5)')' MINUIT ERROR. CANNOT FIX PARAMETER',I
     +LAX,'    INTERNAL',IT
      GOTO700
      ENDIF
      DO500ISIG=1,2
      IF(ISIG.EQ.1)THEN
      SIG=1.0
      CSIG=CPOS
      ELSE
      SIG=-1.0
      CSIG=CNEG
      ENDIF
      IF(ISW(5).GT.1)WRITE(ISYSWR,806)CSIG,ILAX,CPNAM(ILAX)
  806 FORMAT(/' DETERMINATION OF ',A4,'TIVE MINOS ERROR FOR PARAMETER',I
     +3,2X,A)
      IF(ISW(2).LE.0)CALLMNWARN('D','MINOS','NO COVARIANCE MATRIX.')
      NLIMIT=NFCN+NFMXIN
      ISTRAT=MAX(ISTRAV-1,0)
      DU1=W(IT)
      U(ILAX)=UT+SIG*DU1
      U(ILAX)=MIN(U(ILAX),BLIM(ILAX))
      U(ILAX)=MAX(U(ILAX),ALIM(ILAX))
      DELU=U(ILAX)-UT
      IF(ABS(DELU)/(ABS(UT)+ABS(U(ILAX))).LT.EPSMAC)GOTO440
      FAC=DELU/W(IT)
      DO185I=1,NPAR
  185 X(I)=XT(I)+FAC*XDEV(I)
      IF(ISW(5).GT.1)WRITE(ISYSWR,801)ILAX,UT,DELU,U(ILAX)
  801 FORMAT(/' PARAMETER',I4,' SET TO',E11.3,' + ',E10.3,' = ',E12.3)
      KE1CR=ILAX
      KE2CR=0
      XMIDCR=U(ILAX)
      XDIRCR=DELU
      AMIN=ABEST
      NFCNMX=NLIMIT-NFCN
      CALLMNCROS(FCN,AOPT,IERCR,FUTIL)
      IF(ABEST-AMIN.GT.0.01*UP)GOTO650
      IF(IERCR.EQ.1)GOTO440
      IF(IERCR.EQ.2)GOTO450
      IF(IERCR.EQ.3)GOTO460
      EROS=SIG*DU1+AOPT*XDIRCR
      IF(ISW(5).GT.1)WRITE(ISYSWR,808)CSIG,ILAX,CPNAM(ILAX),EROS
  808 FORMAT(/9X,'THE',A4,29HTIVE MINOS ERROR OF PARAMETER',I3,',
     +   ',A10,',IS',E12.4)
      GOTO480
  440 IF(ISW(5).GE.1)WRITE(ISYSWR,807)CSIG,ILAX,CPNAM(ILAX)
  807 FORMAT(5X,'THE ',A4,'TIVE MINOS ERROR OF PARAMETER',I3,', ',A,', E
     +XCEEDS ITS LIMIT.'/)
      EROS=UNDEFI
      GOTO480
  450 IF(ISW(5).GE.1)WRITE(ISYSWR,802)CSIG,ILAX,NFMXIN
  802 FORMAT(9X,'THE ',A,'TIVE MINOS ERROR',I4,' REQUIRES MORE THAN',I5,
     +' FUNCTION CALLS.'/)
      EROS=0.
      GOTO480
  460 IF(ISW(5).GE.1)WRITE(ISYSWR,805)CSIG,ILAX
  805 FORMAT(25X,A,'TIVE MINOS ERROR NOT CALCULATED FOR PARAMETER',I4/)
      EROS=0.
  480 IF(ISW(5).GT.1)WRITE(ISYSWR,'(5X, 74(1H*))')
      IF(SIG.LT.ZERO)THEN
      ERN(IT)=EROS
      IF(ILAX2.GT.0.AND.ILAX2.LE.NU)VAL2MI=U(ILAX2)
      ELSE
      ERP(IT)=EROS
      IF(ILAX2.GT.0.AND.ILAX2.LE.NU)VAL2PL=U(ILAX2)
      ENDIF
  500 CONTINUE
      ITAUR=1
      CALLMNFREE(1)
      DO550J=1,MPAR*(MPAR+1)/2
  550 VHMAT(J)=VTHMAT(J)
      DO595I=1,MPAR
      WERR(I)=W(I)
      GLOBCC(I)=GCC(I)
  595 X(I)=XT(I)
      CALLMNINEX(X)
      EDM=SIGSAV
      AMIN=ABEST
      ISW(2)=ISW2
      ISW(4)=ISW4
      DCOVAR=DC
      GOTO700
  650 LNEWMN=.TRUE.
      ISW(2)=0
      DCOVAR=1.
      ISW(4)=0
      SAV=U(ILAX)
      ITAUR=1
      CALLMNFREE(1)
      U(ILAX)=SAV
      CALLMNEXIN(X)
      EDM=BIGEDM
  700 CONTINUE
      ITAUR=0
      NFCNMX=NFMXIN
      ISTRAT=ISTRAV
      RETURN
      END
 
      SUBROUTINEMNPARM(K,CNAMJ,UK,WK,A,B,IERFLG)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      CHARACTER*(*)CNAMJ
      CHARACTERCNAMK*10,CHBUFI*4
      CNAMK=CNAMJ
      KINT=NPAR
      IF(K.LT.1.OR.K.GT.MAXEXT)THEN
      WRITE(ISYSWR,9)K,MAXEXT
    9 FORMAT(/' MINUIT USER ERROR.  PARAMETER NUMBER IS',I11/',  ALLOWED
     + RANGE IS ONE TO',I4/)
      GOTO800
      ENDIF
      KTOFIX=0
      IF(NVARL(K).LT.0)GOTO50
      DO40IX=1,NPFIX
      IF(IPFIX(IX).EQ.K)KTOFIX=K
   40 CONTINUE
      IF(KTOFIX.GT.0)THEN
      CALLMNWARN('W','PARAM DEF','REDEFINING A FIXED PARAMETER.')
      IF(KINT.GE.MAXINT)THEN
      WRITE(ISYSWR,'(A)')' CANNOT RELEASE. MAX NPAR EXCEEDED.'
      GOTO800
      ENDIF
      CALLMNFREE(-K)
      ENDIF
      IF(NIOFEX(K).GT.0)KINT=NPAR-1
   50 CONTINUE
      IF(LPHEAD.AND.ISW(5).GE.0.AND.ISW(6).LT.1)THEN
      WRITE(ISYSWR,61)
      LPHEAD=.FALSE.
      ENDIF
   61 FORMAT(/' PARAMETER DEFINITIONS:'/'    NO.   NAME         VALUE   
     +   STEP SIZE      LIMITS')
      IF(WK.GT.ZERO)GOTO122
      IF(ISW(5).GE.0)WRITE(ISYSWR,82)K,CNAMK,UK
   82 FORMAT(1X,I5,1X,1H',A10,1H',1X,G13.5,'  constant')
      NVL=0
      GOTO200
  122 IF(A.EQ.ZERO.AND.B.EQ.ZERO)THEN
      NVL=1
      IF(ISW(5).GE.0)WRITE(ISYSWR,127)K,CNAMK,UK,WK
  127 FORMAT(1X,I5,1X,1H',A10,1H',1X,2G13.5,'     no limits')
      ELSE
      NVL=4
      LNOLIM=.FALSE.
      IF(ISW(5).GE.0)WRITE(ISYSWR,132)K,CNAMK,UK,WK,A,B
  132 FORMAT(1X,I5,1X,1H',A10,1H',1X,2G13.5,2X,2G13.5)
      ENDIF
      KINT=KINT+1
      IF(KINT.GT.MAXINT)THEN
      WRITE(ISYSWR,135)MAXINT
  135 FORMAT(/' MINUIT USER ERROR.   TOO MANY VARIABLE PARAMETERS.'/' TH
     +IS VERSION OF MINUIT DIMENSIONED FOR',I4//)
      GOTO800
      ENDIF
      IF(NVL.EQ.1)GOTO200
      IF(A.EQ.B)THEN
      WRITE(ISYSWR,'(/A,A/A/)')' USER ERROR IN MINUIT PARAMETER',' DEFIN
     +ITION',' UPPER AND LOWER LIMITS EQUAL.'
      GOTO800
      ENDIF
      IF(B.LT.A)THEN
      SAV=B
      B=A
      A=SAV
      CALLMNWARN('W','PARAM DEF','PARAMETER LIMITS WERE REVERSED.')
      IF(LWARN)LPHEAD=.TRUE.
      ENDIF
      IF((B-A).GT.1.0E7)THEN
      WRITE(CHBUFI,'(I4)')K
      CALLMNWARN('W','PARAM DEF','LIMITS ON PARAM'//CHBUFI//' TOO FAR AP
     +ART.')
      IF(LWARN)LPHEAD=.TRUE.
      ENDIF
      DANGER=(B-UK)*(UK-A)
      IF(DANGER.LT.0.)CALLMNWARN('W','PARAM DEF','STARTING VALUE OUTSIDE
     + LIMITS.')
      IF(DANGER.EQ.0.)CALLMNWARN('W','PARAM DEF','STARTING VALUE IS AT L
     +IMIT.')
  200 CONTINUE
      CFROM='PARAMETR'
      NFCNFR=NFCN
      CSTATU='NEW VALUES'
      NU=MAX(NU,K)
      CPNAM(K)=CNAMK
      U(K)=UK
      ALIM(K)=A
      BLIM(K)=B
      NVARL(K)=NVL
      CALLMNRSET(1)
      LASTIN=0
      DO240IX=1,K-1
      IF(NIOFEX(IX).GT.0)LASTIN=LASTIN+1
  240 CONTINUE
      IF(KINT.EQ.NPAR)GOTO280
      IF(KINT.GT.NPAR)THEN
      DO260IN=NPAR,LASTIN+1,-1
      IX=NEXOFI(IN)
      NIOFEX(IX)=IN+1
      NEXOFI(IN+1)=IX
      X(IN+1)=X(IN)
      XT(IN+1)=XT(IN)
      DIRIN(IN+1)=DIRIN(IN)
      G2(IN+1)=G2(IN)
      GSTEP(IN+1)=GSTEP(IN)
  260 CONTINUE
      ELSE
      DO270IN=LASTIN+1,KINT
      IX=NEXOFI(IN+1)
      NIOFEX(IX)=IN
      NEXOFI(IN)=IX
      X(IN)=X(IN+1)
      XT(IN)=XT(IN+1)
      DIRIN(IN)=DIRIN(IN+1)
      G2(IN)=G2(IN+1)
      GSTEP(IN)=GSTEP(IN+1)
  270 CONTINUE
      ENDIF
  280 CONTINUE
      IX=K
      NIOFEX(IX)=0
      NPAR=KINT
      IF(NVL.GT.0)THEN
      IN=LASTIN+1
      NEXOFI(IN)=IX
      NIOFEX(IX)=IN
      SAV=U(IX)
      CALLMNPINT(SAV,IX,PINTI)
      X(IN)=PINTI
      XT(IN)=X(IN)
      WERR(IN)=WK
      SAV2=SAV+WK
      CALLMNPINT(SAV2,IX,PINTI)
      VPLU=PINTI-X(IN)
      SAV2=SAV-WK
      CALLMNPINT(SAV2,IX,PINTI)
      VMINU=PINTI-X(IN)
      DIRIN(IN)=0.5*(ABS(VPLU)+ABS(VMINU))
      G2(IN)=2.0*UP/DIRIN(IN)**2
      GSMIN=8.*EPSMA2*ABS(X(IN))
      GSTEP(IN)=MAX(GSMIN,0.1*DIRIN(IN))
      IF(AMIN.NE.UNDEFI)THEN
      SMALL=SQRT(EPSMA2*(AMIN+UP)/UP)
      GSTEP(IN)=MAX(GSMIN,SMALL*DIRIN(IN))
      ENDIF
      GRD(IN)=G2(IN)*DIRIN(IN)
      IF(NVARL(K).GT.1)THEN
      IF(GSTEP(IN).GT.0.5)GSTEP(IN)=0.5
      GSTEP(IN)=-GSTEP(IN)
      ENDIF
      ENDIF
      IF(KTOFIX.GT.0)THEN
      KINFIX=NIOFEX(KTOFIX)
      IF(KINFIX.GT.0)CALLMNFIXP(KINFIX,IERR)
      IF(IERR.GT.0)GOTO800
      ENDIF
      IERFLG=0
      RETURN
  800 CONTINUE
      IERFLG=1
      RETURN
      END
 
      SUBROUTINEMNPARS(CRDBUF,ICONDN)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      DIMENSIONPLIST(MAXP)
      CHARACTERCNAMK*10,CRDBUF*(*),CELMNT*20,COMAND*(MAXCWD)
      KAPO1=INDEX(CRDBUF,'''')
      IF(KAPO1.EQ.0)GOTO150
      KAPO2=INDEX(CRDBUF(KAPO1+1:),'''')
      IF(KAPO2.EQ.0)GOTO150
      KAPO2=KAPO2+KAPO1
      DO115ISTART=1,KAPO1-1
      IF(CRDBUF(ISTART:ISTART).NE.' ')GOTO120
  115 CONTINUE
      ISTART=KAPO1-1
  120 CONTINUE
      IF(ISTART.LT.1)GOTO210
      CELMNT=CRDBUF(ISTART:KAPO1-1)
      READ(CELMNT,'(BN,F20.0)',ERR=180)FK
      K=FK
      IF(K.LE.0)GOTO210
      CNAMK='PARAM '//CELMNT
      IF(KAPO2-KAPO1.GT.1)CNAMK=CRDBUF(KAPO1+1:KAPO2-1)
      CALLMNCRCK(CRDBUF(KAPO2+1:),MAXCWD,COMAND,LNC,MAXP,PLIST,LLIST,IER
     +R,ISYSWR)
      IF(IERR.GT.0)GOTO180
      UK=PLIST(1)
      WK=0.
      IF(LLIST.GE.2)WK=PLIST(2)
      A=0.
      IF(LLIST.GE.3)A=PLIST(3)
      B=0.
      IF(LLIST.GE.4)B=PLIST(4)
      GOTO170
  150 CONTINUE
      READ(CRDBUF,158,ERR=180)XK,CNAMK,UK,WK,A,B
  158 FORMAT(BN,F10.0,A10,4F10.0)
      K=XK
      IF(K.EQ.0)GOTO210
  170 CALLMNPARM(K,CNAMK,UK,WK,A,B,IERR)
      ICONDN=IERR
      RETURN
  180 CONTINUE
      ICONDN=1
      RETURN
  210 CONTINUE
      ICONDN=2
      RETURN
      END
      SUBROUTINEMNPFIT(PARX2P,PARY2P,NPAR2P,COEF2P,SDEV2P)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      DIMENSIONPARX2P(NPAR2P),PARY2P(NPAR2P),COEF2P(NPAR2P)
      DIMENSIONCZ(3)
      DO3I=1,3
    3 CZ(I)=0.
      SDEV2P=0.
      IF(NPAR2P.LT.3)GOTO10
      F=NPAR2P
      XM=0.
      DO2I=1,NPAR2P
    2 XM=XM+PARX2P(I)
      XM=XM/F
      X2=0.
      X3=0.
      X4=0.
      Y=0.
      Y2=0.
      XY=0.
      X2Y=0.
      DO1I=1,NPAR2P
      S=PARX2P(I)-XM
      T=PARY2P(I)
      S2=S*S
      X2=X2+S2
      X3=X3+S*S2
      X4=X4+S2*S2
      Y=Y+T
      Y2=Y2+T*T
      XY=XY+S*T
      X2Y=X2Y+S2*T
    1 CONTINUE
      A=(F*X4-X2**2)*X2-F*X3**2
      IF(A.EQ.0.)GOTO10
      CZ(3)=(X2*(F*X2Y-X2*Y)-F*X3*XY)/A
      CZ(2)=(XY-X3*CZ(3))/X2
      CZ(1)=(Y-X2*CZ(3))/F
      IF(NPAR2P.EQ.3)GOTO6
      SDEV2P=Y2-(CZ(1)*Y+CZ(2)*XY+CZ(3)*X2Y)
      IF(SDEV2P.LT.0.)SDEV2P=0.
      SDEV2P=SDEV2P/(F-3.)
    6 CZ(1)=CZ(1)+XM*(XM*CZ(3)-CZ(2))
      CZ(2)=CZ(2)-2.*XM*CZ(3)
   10 CONTINUE
      DO11I=1,3
   11 COEF2P(I)=CZ(I)
      RETURN
      END
 
      SUBROUTINEMNPINT(PEXTI,I,PINTI)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      CHARACTERCHBUFI*4,CHBUF2*30
      PINTI=PEXTI
      IGO=NVARL(I)
      IF(IGO.EQ.4)THEN
      ALIMI=ALIM(I)
      BLIMI=BLIM(I)
      YY=2.0*(PEXTI-ALIMI)/(BLIMI-ALIMI)-1.0
      YY2=YY**2
      IF(YY2.GE.(1.0-EPSMA2))THEN
      IF(YY.LT.0.)THEN
      A=VLIMLO
      CHBUF2=' IS AT ITS LOWER ALLOWED LIMIT.'
      ELSE
      A=VLIMHI
      CHBUF2=' IS AT ITS UPPER ALLOWED LIMIT.'
      ENDIF
      PINTI=A
      PEXTI=ALIMI+0.5*(BLIMI-ALIMI)*(SIN(A)+1.0)
      LIMSET=.TRUE.
      WRITE(CHBUFI,'(I4)')I
      IF(YY2.GT.1.0)CHBUF2=' BROUGHT BACK INSIDE LIMITS.'
      CALLMNWARN('W',CFROM,'VARIABLE'//CHBUFI//CHBUF2)
      ELSE
      PINTI=ASIN(YY)
      ENDIF
      ENDIF
      RETURN
      END
      SUBROUTINEMNPLOT(XPT,YPT,CHPT,NXYPT,NUNIT,NPAGWD,NPAGLN)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      DIMENSIONXPT(*),YPT(*)
      CHARACTER*1CHPT(*),CHSAV,CHBEST,CDOT,CSLASH,CBLANK
      PARAMETER(MAXWID=100)
      CHARACTERCLINE*100,CHMESS*30
      DIMENSIONXVALUS(12)
      LOGICALOVERPR
      DATACDOT,CSLASH,CBLANK/'.','/',' '/
      MAXNX=MIN(NPAGWD-20,MAXWID)
      IF(MAXNX.LT.10)MAXNX=10
      MAXNY=NPAGLN
      IF(MAXNY.LT.10)MAXNY=10
      IF(NXYPT.LE.1)RETURN
      XBEST=XPT(1)
      YBEST=YPT(1)
      CHBEST=CHPT(1)
      KM1=NXYPT-1
      DO150I=1,KM1
      IQUIT=0
      NI=NXYPT-I
      DO140J=1,NI
      IF(YPT(J).GT.YPT(J+1))GOTO140
      SAVX=XPT(J)
      XPT(J)=XPT(J+1)
      XPT(J+1)=SAVX
      SAVY=YPT(J)
      YPT(J)=YPT(J+1)
      YPT(J+1)=SAVY
      CHSAV=CHPT(J)
      CHPT(J)=CHPT(J+1)
      CHPT(J+1)=CHSAV
      IQUIT=1
  140 CONTINUE
      IF(IQUIT.EQ.0)GOTO160
  150 CONTINUE
  160 CONTINUE
      XMAX=XPT(1)
      XMIN=XMAX
      DO200I=1,NXYPT
      IF(XPT(I).GT.XMAX)XMAX=XPT(I)
      IF(XPT(I).LT.XMIN)XMIN=XPT(I)
  200 CONTINUE
      DXX=0.001*(XMAX-XMIN)
      XMAX=XMAX+DXX
      XMIN=XMIN-DXX
      CALLMNBINS(XMIN,XMAX,MAXNX,XMIN,XMAX,NX,BWIDX)
      YMAX=YPT(1)
      YMIN=YPT(NXYPT)
      IF(YMAX.EQ.YMIN)YMAX=YMIN+1.0
      DYY=0.001*(YMAX-YMIN)
      YMAX=YMAX+DYY
      YMIN=YMIN-DYY
      CALLMNBINS(YMIN,YMAX,MAXNY,YMIN,YMAX,NY,BWIDY)
      ANY=NY
      IF(CHBEST.EQ.CBLANK)GOTO50
      XBEST=0.5*(XMAX+XMIN)
      YBEST=0.5*(YMAX+YMIN)
   50 CONTINUE
      AX=1.0/BWIDX
      AY=1.0/BWIDY
      BX=-AX*XMIN+2.0
      BY=-AY*YMIN-2.0
      DO300I=1,NXYPT
      XPT(I)=AX*XPT(I)+BX
  300 YPT(I)=ANY-AY*YPT(I)-BY
      NXBEST=AX*XBEST+BX
      NYBEST=ANY-AY*YBEST-BY
      NY=NY+2
      NX=NX+2
      ISP1=1
      LINODD=1
      OVERPR=.FALSE.
      DO400I=1,NY
      DO310IBK=1,NX
  310 CLINE(IBK:IBK)=CBLANK
      CLINE(1:1)=CDOT
      CLINE(NX:NX)=CDOT
      CLINE(NXBEST:NXBEST)=CDOT
      IF(I.NE.1.AND.I.NE.NYBEST.AND.I.NE.NY)GOTO320
      DO315J=1,NX
  315 CLINE(J:J)=CDOT
  320 CONTINUE
      YPRT=YMAX-FLOAT(I-1)*BWIDY
      IF(ISP1.GT.NXYPT)GOTO350
      DO341K=ISP1,NXYPT
      KS=YPT(K)
      IF(KS.GT.I)GOTO345
      IX=XPT(K)
      IF(CLINE(IX:IX).EQ.CDOT)GOTO340
      IF(CLINE(IX:IX).EQ.CBLANK)GOTO340
      IF(CLINE(IX:IX).EQ.CHPT(K))GOTO341
      OVERPR=.TRUE.
      CLINE(IX:IX)='&'
      GOTO341
  340 CLINE(IX:IX)=CHPT(K)
  341 CONTINUE
      ISP1=NXYPT+1
      GOTO350
  345 ISP1=K
  350 CONTINUE
      IF(LINODD.EQ.1.OR.I.EQ.NY)GOTO380
      LINODD=1
      WRITE(NUNIT,'(18X,A)')CLINE(:NX)
      GOTO400
  380 WRITE(NUNIT,'(1X,G14.7,A,A)')YPRT,' ..',CLINE(:NX)
      LINODD=0
  400 CONTINUE
      DO410IBK=1,NX
      CLINE(IBK:IBK)=CBLANK
      IF(MOD(IBK,10).EQ.1)CLINE(IBK:IBK)=CSLASH
  410 CONTINUE
      WRITE(NUNIT,'(18X,A)')CLINE(:NX)
      DO430IBK=1,12
  430 XVALUS(IBK)=XMIN+FLOAT(IBK-1)*10.*BWIDX
      ITEN=(NX+9)/10
      WRITE(NUNIT,'(12X,12G10.4)')(XVALUS(IBK),IBK=1,ITEN)
      CHMESS=' '
      IF(OVERPR)CHMESS='   Overprint character is &'
      WRITE(NUNIT,'(25X,A,G13.7,A)')'ONE COLUMN=',BWIDX,CHMESS
  500 RETURN
      END
 
      SUBROUTINEMNPOUT(IUEXT,CHNAM,VAL,ERR,XLOLIM,XUPLIM,IUINT)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      CHARACTER*(*)CHNAM
      XLOLIM=0.
      XUPLIM=0.
      ERR=0.
      IF(IUEXT.EQ.0)GOTO100
      IF(IUEXT.LT.0)THEN
      IINT=-IUEXT
      IF(IINT.GT.NPAR)GOTO100
      IEXT=NEXOFI(IINT)
      IUINT=IEXT
      ELSE
      IEXT=IUEXT
      IF(IEXT.EQ.0)GOTO100
      IF(IEXT.GT.NU)GOTO100
      IINT=NIOFEX(IEXT)
      IUINT=IINT
      ENDIF
      NVL=NVARL(IEXT)
      IF(NVL.LT.0)GOTO100
      CHNAM=CPNAM(IEXT)
      VAL=U(IEXT)
      IF(IINT.GT.0)ERR=WERR(IINT)
      IF(NVL.EQ.4)THEN
      XLOLIM=ALIM(IEXT)
      XUPLIM=BLIM(IEXT)
      ENDIF
      RETURN
  100 IUINT=-1
      CHNAM='undefined'
      VAL=0.
      RETURN
      END
 
      SUBROUTINEMNPRIN(INKODE,FVAL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      CHARACTER*14COLHDU(6),COLHDL(6),CX2,CX3,CGETX
      CHARACTER*11CNAMBF,CBLANK
      CHARACTERCHEDM*10,CHEVAL*15
      PARAMETER(CGETX='PLEASE GET X..')
      DATACBLANK/'          '/
      IF(NU.EQ.0)THEN
      WRITE(ISYSWR,'(A)')' THERE ARE CURRENTLY NO PARAMETERS DEFINED'
      GOTO700
      ENDIF
      IKODE=INKODE
      IF(INKODE.EQ.5)THEN
      IKODE=ISW(2)+1
      IF(IKODE.GT.3)IKODE=3
      ENDIF
      DO5K=1,6
      COLHDU(K)='UNDEFINED'
    5 COLHDL(K)='COLUMN HEAD'
      IF(IKODE.EQ.4.AND.CTITL.NE.CUNDEF)WRITE(ISYSWR,'(/A,A)')' MINUIT T
     +ASK: ',CTITL
      IF(FVAL.EQ.UNDEFI)THEN
      CHEVAL=' unknown       '
      ELSE
      WRITE(CHEVAL,'(G15.7)')FVAL
      ENDIF
      IF(EDM.EQ.BIGEDM)THEN
      CHEDM=' unknown  '
      ELSE
      WRITE(CHEDM,'(E10.2)')EDM
      ENDIF
      NC=NFCN-NFCNFR
      WRITE(ISYSWR,905)CHEVAL,CFROM,CSTATU,NC,NFCN
  905 FORMAT(/' FCN=',A,' FROM ',A8,'  STATUS=',A10,I6,' CALLS',I9,' TOT
     +AL')
      M=ISW(2)
      IF(M.EQ.0.OR.M.EQ.2.OR.DCOVAR.EQ.ZERO)THEN
      WRITE(ISYSWR,907)CHEDM,ISTRAT,COVMES(M)
  907 FORMAT(21X,'EDM=',A,'    STRATEGY=',I2,6X,A)
      ELSE
      DCMAX=1.
      DC=MIN(DCOVAR,DCMAX)*100.
      WRITE(ISYSWR,908)CHEDM,ISTRAT,DC
  908 FORMAT(21X,'EDM=',A,'  STRATEGY=',I1,'  ERROR MATRIX',' UNCERTAINT
     +Y=',F5.1,'%')
      ENDIF
      IF(IKODE.EQ.0)GOTO700
      NTRAIL=10
      DO20I=1,NU
      IF(NVARL(I).LT.0)GOTO20
      DO15IC=10,1,-1
      IF(CPNAM(I)(IC:IC).NE.' ')GOTO16
   15 CONTINUE
      IC=1
   16 LBL=10-IC
      IF(LBL.LT.NTRAIL)NTRAIL=LBL
   20 CONTINUE
      NADD=NTRAIL/2+1
      IF(IKODE.EQ.1)THEN
      COLHDU(1)='              '
      COLHDL(1)='      ERROR   '
      COLHDU(2)='      PHYSICAL'
      COLHDU(3)=' LIMITS       '
      COLHDL(2)='    NEGATIVE  '
      COLHDL(3)='    POSITIVE  '
      ENDIF
      IF(IKODE.EQ.2)THEN
      COLHDU(1)='              '
      COLHDL(1)='      ERROR   '
      COLHDU(2)='    INTERNAL  '
      COLHDL(2)='    STEP SIZE '
      COLHDU(3)='    INTERNAL  '
      COLHDL(3)='      VALUE   '
      ENDIF
      IF(IKODE.EQ.3)THEN
      COLHDU(1)='              '
      COLHDL(1)='      ERROR   '
      COLHDU(2)='       STEP   '
      COLHDL(2)='       SIZE   '
      COLHDU(3)='      FIRST   '
      COLHDL(3)='   DERIVATIVE '
      ENDIF
      IF(IKODE.EQ.4)THEN
      COLHDU(1)='    PARABOLIC '
      COLHDL(1)='      ERROR   '
      COLHDU(2)='        MINOS '
      COLHDU(3)='ERRORS        '
      COLHDL(2)='   NEGATIVE   '
      COLHDL(3)='   POSITIVE   '
      ENDIF
      IF(IKODE.NE.4)THEN
      IF(ISW(2).LT.3)COLHDU(1)='  APPROXIMATE '
      IF(ISW(2).LT.1)COLHDU(1)=' CURRENT GUESS'
      ENDIF
      NCOL=3
      WRITE(ISYSWR,910)(COLHDU(KK),KK=1,NCOL)
      WRITE(ISYSWR,911)(COLHDL(KK),KK=1,NCOL)
  910 FORMAT(/'  EXT PARAMETER ',13X,6A14)
  911 FORMAT('  NO.   NAME    ','    VALUE    ',6A14)
      DO200I=1,NU
      IF(NVARL(I).LT.0)GOTO200
      L=NIOFEX(I)
      CNAMBF=CBLANK(1:NADD)//CPNAM(I)
      IF(L.EQ.0)GOTO55
      X1=WERR(L)
      CX2=CGETX
      CX3=CGETX
      IF(IKODE.EQ.1)THEN
      IF(NVARL(I).LE.1)THEN
      WRITE(ISYSWR,952)I,CNAMBF,U(I),X1
      GOTO200
      ELSE
      X2=ALIM(I)
      X3=BLIM(I)
      ENDIF
      ENDIF
      IF(IKODE.EQ.2)THEN
      X2=DIRIN(L)
      X3=X(L)
      ENDIF
      IF(IKODE.EQ.3)THEN
      X2=DIRIN(L)
      X3=GRD(L)
      IF(NVARL(I).GT.1.AND.ABS(COS(X(L))).LT.0.001)CX3='** at limit **'
      ENDIF
      IF(IKODE.EQ.4)THEN
      X2=ERN(L)
      IF(X2.EQ.ZERO)CX2=' '
      IF(X2.EQ.UNDEFI)CX2='   at limit   '
      X3=ERP(L)
      IF(X3.EQ.ZERO)CX3=' '
      IF(X3.EQ.UNDEFI)CX3='   at limit   '
      ENDIF
      IF(CX2.EQ.CGETX)WRITE(CX2,'(G14.5)')X2
      IF(CX3.EQ.CGETX)WRITE(CX3,'(G14.5)')X3
      WRITE(ISYSWR,952)I,CNAMBF,U(I),X1,CX2,CX3
  952 FORMAT(I4,1X,A11,2G14.5,2A)
      IF(NVARL(I).LE.1.OR.IKODE.EQ.3)GOTO200
      IF(ABS(COS(X(L))).LT.0.001)WRITE(ISYSWR,1004)
 1004 FORMAT(33X,'WARNING -   - ABOVE PARAMETER IS AT LIMIT.')
      GOTO200
   55 CONTINUE
      COLHDU(1)='   constant   '
      IF(NVARL(I).GT.0)COLHDU(1)='     fixed    '
      IF(NVARL(I).EQ.4.AND.IKODE.EQ.1)THEN
      WRITE(ISYSWR,'(I4,1X,A11,G14.5,A,2G14.5)')I,CNAMBF,U(I),COLHDU(1),
     +ALIM(I),BLIM(I)
      ELSE
      WRITE(ISYSWR,'(I4,1X,A11,G14.5,A)')I,CNAMBF,U(I),COLHDU(1)
      ENDIF
  200 CONTINUE
      IF(UP.NE.UPDFLT)WRITE(ISYSWR,'(31X,A,G10.2)')'ERR DEF=',UP
  700 CONTINUE
      RETURN
      END
 
      SUBROUTINEMNPSDF
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      CHARACTERCHBUFF*12
      DIMENSIONS(MNI)
      EPSMIN=1.0E-6
      EPSPDF=MAX(EPSMIN,EPSMA2)
      DGMIN=VHMAT(1)
      DO200I=1,NPAR
      NDEX=I*(I+1)/2
      IF(VHMAT(NDEX).LE.ZERO)THEN
      WRITE(CHBUFF(1:3),'(I3)')I
      CALLMNWARN('W',CFROM,'Negative diagonal element'//CHBUFF(1:3)//' i
     +n Error Matrix')
      ENDIF
      IF(VHMAT(NDEX).LT.DGMIN)DGMIN=VHMAT(NDEX)
  200 CONTINUE
      IF(DGMIN.LE.ZERO)THEN
      DG=(ONE+EPSPDF)-DGMIN
      WRITE(CHBUFF,'(E12.2)')DG
      CALLMNWARN('W',CFROM,CHBUFF//' added to diagonal of error matrix')
      ELSE
      DG=ZERO
      ENDIF
      DO213I=1,NPAR
      NDEX=I*(I-1)/2
      NDEXD=NDEX+I
      VHMAT(NDEXD)=VHMAT(NDEXD)+DG
      S(I)=1.0/SQRT(VHMAT(NDEXD))
      DO213J=1,I
      NDEX=NDEX+1
  213 P(I,J)=VHMAT(NDEX)*S(I)*S(J)
      CALLMNEIG(P,MAXINT,NPAR,MAXINT,PSTAR,EPSPDF,IFAULT)
      PMIN=PSTAR(1)
      PMAX=PSTAR(1)
      DO215IP=2,NPAR
      IF(PSTAR(IP).LT.PMIN)PMIN=PSTAR(IP)
      IF(PSTAR(IP).GT.PMAX)PMAX=PSTAR(IP)
  215 CONTINUE
      PMAX=MAX(ABS(PMAX),ONE)
      IF((PMIN.LE.ZERO.AND.LWARN).OR.ISW(5).GE.2)THEN
      WRITE(ISYSWR,550)
      WRITE(ISYSWR,551)(PSTAR(IP),IP=1,NPAR)
      ENDIF
      IF(PMIN.GT.EPSPDF*PMAX)GOTO217
      IF(ISW(2).EQ.3)ISW(2)=2
      PADD=1.0E-3*PMAX-PMIN
      DO216IP=1,NPAR
      NDEX=IP*(IP+1)/2
  216 VHMAT(NDEX)=VHMAT(NDEX)*(1.0+PADD)
      CSTATU='NOT POSDEF'
      WRITE(CHBUFF,'(G12.5)')PADD
      CALLMNWARN('W',CFROM,'MATRIX FORCED POS-DEF BY ADDING '//CHBUFF//'
     + TO DIAGONAL.')
  217 CONTINUE
  550 FORMAT(' EIGENVALUES OF SECOND-DERIVATIVE MATRIX:')
  551 FORMAT(7X,6E12.4)
      RETURN
      END
 
      SUBROUTINEMNRAZZ(YNEW,PNEW,Y,JH,JL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      DIMENSIONPNEW(*),Y(*)
      DO10I=1,NPAR
   10 P(I,JH)=PNEW(I)
      Y(JH)=YNEW
      IF(YNEW.LT.AMIN)THEN
      DO15I=1,NPAR
   15 X(I)=PNEW(I)
      CALLMNINEX(X)
      AMIN=YNEW
      CSTATU='PROGRESS  '
      JL=JH
      ENDIF
      JH=1
      NPARP1=NPAR+1
   20 DO25J=2,NPARP1
      IF(Y(J).GT.Y(JH))JH=J
   25 CONTINUE
      EDM=Y(JH)-Y(JL)
      IF(EDM.LE.ZERO)GOTO45
      DO35I=1,NPAR
      PBIG=P(I,1)
      PLIT=PBIG
      DO30J=2,NPARP1
      IF(P(I,J).GT.PBIG)PBIG=P(I,J)
      IF(P(I,J).LT.PLIT)PLIT=P(I,J)
   30 CONTINUE
      DIRIN(I)=PBIG-PLIT
   35 CONTINUE
   40 RETURN
   45 WRITE(ISYSWR,1000)NPAR
      GOTO40
 1000 FORMAT('   FUNCTION VALUE DOES NOT SEEM TO DEPEND ON ANY OF THE',I
     +3,' VARIABLE PARAMETERS.'/10X,'VERIFY THAT STEP SIZES ARE',' BIG E
     +NOUGH AND CHECK FCN LOGIC.'/1X,79(1H*)/1X,79(1H*)/)
      END
 
      SUBROUTINEMNREAD(FCN,IFLGIN,IFLGUT,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      CHARACTERCRDBUF*80,CUPBUF*10
      CHARACTERCPROMT(3)*40,CLOWER*26,CUPPER*26
      LOGICALLEOF
      DATACPROMT/' ENTER MINUIT TITLE, or "SET INPUT n" : ',' ENTER MINU
     +IT PARAMETER DEFINITION:     ',' ENTER MINUIT COMMAND:            
     +      '/
      DATACLOWER/'abcdefghijklmnopqrstuvwxyz'/
      DATACUPPER/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
      IFLGUT=1
      IFLGDO=IFLGIN
      LEOF=.FALSE.
      INCOMP=0
   10 CONTINUE
      IF(ISW(6).EQ.1)WRITE(ISYSWR,'(A)')CPROMT(IFLGDO)
      CRDBUF='   '
      READ(ISYSRD,'(A)',ERR=500,END=45)CRDBUF
      CUPBUF(1:10)=CRDBUF(1:10)
      DO12I=1,10
      IF(CRDBUF(I:I).EQ.'''')GOTO13
      DO11IC=1,26
      IF(CRDBUF(I:I).EQ.CLOWER(IC:IC))CUPBUF(I:I)=CUPPER(IC:IC)
   11 CONTINUE
   12 CONTINUE
   13 CONTINUE
      LEOF=.FALSE.
      IF(INDEX(CUPBUF,'*EOF').EQ.1)THEN
      WRITE(ISYSWR,'(A,I3)')' *EOF ENCOUNTERED ON UNIT NO.',ISYSRD
      LPHEAD=.TRUE.
      GOTO50
      ENDIF
      IF(INDEX(CUPBUF,'SET INP').EQ.1)THEN
      ICOMND=ICOMND+1
      WRITE(ISYSWR,21)ICOMND,CRDBUF(1:50)
   21 FORMAT(' **********'/' **',I5,' **',A/' **********')
      LPHEAD=.TRUE.
      GOTO50
      ENDIF
      GOTO80
   45 CRDBUF='*EOF '
      WRITE(ISYSWR,'(A,I3)')' END OF DATA ON UNIT NO.',ISYSRD
   50 CONTINUE
      CALLMNSTIN(CRDBUF,IERR)
      IF(IERR.EQ.0)GOTO10
      IF(IERR.EQ.2)THEN
      IF(.NOT.LEOF)THEN
      WRITE(ISYSWR,'(A,A/)')' TWO CONSECUTIVE EOFs ON ','PRIMARY INPUT F
     +ILE WILL TERMINATE EXECUTION.'
      LEOF=.TRUE.
      GOTO10
      ENDIF
      ENDIF
      IFLGUT=IERR
      GOTO900
   80 IF(IFLGDO.GT.1)GOTO100
      IF(INDEX(CUPBUF,'SET TIT').EQ.1)GOTO10
      CALLMNSETI(CRDBUF(1:50))
      WRITE(ISYSWR,'(1X,A50)')CTITL
      WRITE(ISYSWR,'(1X,78(1H*))')
      LPHEAD=.TRUE.
      IF(IFLGIN.EQ.IFLGDO)GOTO900
      IFLGDO=IFLGIN
      GOTO10
  100 CONTINUE
      IF(IFLGDO.GT.2)GOTO300
      IF(INDEX(CUPBUF,'PAR').EQ.1)GOTO10
      IF(INDEX(CUPBUF,'SET TIT').EQ.1)THEN
      IFLGDO=1
      GOTO10
      ENDIF
      CALLMNPARS(CRDBUF,ICONDP)
      IF(ICONDP.EQ.0)GOTO10
      IF(ICONDP.EQ.1)THEN
      IF(ISW(6).EQ.1)THEN
      WRITE(ISYSWR,'(A)')' FORMAT ERROR.  IGNORED.  ENTER AGAIN.'
      GOTO10
      ELSE
      WRITE(ISYSWR,'(A)')' ERROR IN PARAMETER DEFINITION'
      IFLGUT=4
      GOTO900
      ENDIF
      ENDIF
      IF(ISW(5).GE.0.AND.ISW(6).LT.1)WRITE(ISYSWR,'(4X,75(1H*))')
      LPHEAD=.TRUE.
      IF(IFLGIN.EQ.IFLGDO)GOTO900
      IFLGDO=IFLGIN
      GOTO10
  300 CONTINUE
      CALLMNCOMD(FCN,CRDBUF,ICONDN,FUTIL)
      IF(ICONDN.EQ.2.OR.ICONDN.EQ.3)THEN
      INCOMP=INCOMP+1
      IF(INCOMP.GT.100)THEN
      IFLGUT=5
      GOTO900
      ENDIF
      ENDIF
      IF(ICONDN.EQ.5)IFLGDO=2
      IF(ICONDN.EQ.6)GOTO50
      IF(ICONDN.EQ.7)IFLGDO=1
      IF(ICONDN.EQ.8)THEN
      ICOMND=ICOMND+1
      WRITE(ISYSWR,405)ICOMND,CRDBUF(1:50)
  405 FORMAT(' **********'/' **',I5,' **',A)
      WRITE(ISYSWR,'(1H ,10(1H*))')
      NPAR2=NPAR*(NPAR+1)/2
      READ(ISYSRD,420,ERR=500,END=45)(VHMAT(I),I=1,NPAR2)
  420 FORMAT(BN,7E11.4,3X)
      ISW(2)=3
      DCOVAR=0.0
      IF(ISW(5).GE.0)CALLMNMATU(1)
      IF(ISW(5).GE.1)CALLMNPRIN(2,AMIN)
      GOTO10
      ENDIF
      IF(ICONDN.LT.10)GOTO10
      GOTO900
  500 IFLGUT=3
  900 RETURN
      END
      SUBROUTINEMNRN15(VAL,INSEED)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(THREE=3.0)
      DATAISEED/12345/
      IF(VAL.EQ.THREE)GOTO100
      INSEED=ISEED
      K=ISEED/53668
      ISEED=40014*(ISEED-K*53668)-K*12211
      IF(ISEED.LT.0)ISEED=ISEED+2147483563
      VAL=REAL(ISEED)*4.656613E-10
      RETURN
  100 ISEED=INSEED
      RETURN
      END
 
      SUBROUTINEMNRSET(IOPT)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      CSTATU='RESET     '
      IF(IOPT.GE.1)THEN
      AMIN=UNDEFI
      FVAL3=2.0*ABS(AMIN)+1.
      EDM=BIGEDM
      ISW(4)=0
      ISW(2)=0
      DCOVAR=1.
      ISW(1)=0
      ENDIF
      LNOLIM=.TRUE.
      DO10I=1,NPAR
      IEXT=NEXOFI(I)
      IF(NVARL(IEXT).GE.4)LNOLIM=.FALSE.
      ERP(I)=ZERO
      ERN(I)=ZERO
      GLOBCC(I)=ZERO
   10 CONTINUE
      IF(ISW(2).GE.1)THEN
      ISW(2)=1
      DCOVAR=MAX(DCOVAR,HALF)
      ENDIF
      RETURN
      END
 
      SUBROUTINEMNSAVE
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      LOGICALLOPEN,LNAME
      CHARACTERCGNAME*64,CFNAME*64,CANSWR*1
      INQUIRE(UNIT=ISYSSA,OPENED=LOPEN,NAMED=LNAME,NAME=CGNAME)
      IF(LOPEN)THEN
      IF(.NOT.LNAME)CGNAME='UNNAMED FILE'
      WRITE(ISYSWR,32)ISYSSA,CGNAME
   32 FORMAT(' CURRENT VALUES WILL BE SAVED ON UNIT',I3,': ',A/)
      ELSE
      WRITE(ISYSWR,35)ISYSSA
   35 FORMAT(' UNIT',I3,' IS NOT OPENED.')
      IF(ISW(6).EQ.1)THEN
      WRITE(ISYSWR,'(A)')' PLEASE GIVE FILE NAME:'
      READ(ISYSRD,'(A)')CFNAME
      OPEN(UNIT=ISYSSA,FILE=CFNAME,STATUS='NEW',ERR=600)
      CGNAME=CFNAME
      ELSE
      GOTO650
      ENDIF
      ENDIF
      IF(ISW(6).EQ.1)THEN
      WRITE(ISYSWR,37)ISYSSA
   37 FORMAT(' SHOULD UNIT',I3,' BE REWOUND BEFORE WRITING TO IT?')
      READ(ISYSRD,'(A)')CANSWR
      IF(CANSWR.EQ.'Y'.OR.CANSWR.EQ.'y')REWINDISYSSA
      ENDIF
      WRITE(ISYSSA,'(10HSET TITLE )',ERR=700)
      WRITE(ISYSSA,'(A)')CTITL
      WRITE(ISYSSA,'(10HPARAMETERS)')
      NLINES=3
      DO200I=1,NU
      IF(NVARL(I).LT.0)GOTO200
      NLINES=NLINES+1
      IINT=NIOFEX(I)
      IF(NVARL(I).GT.1)GOTO100
      WRITE(ISYSSA,1001)I,CPNAM(I),U(I),WERR(IINT)
      GOTO200
  100 CONTINUE
      WRITE(ISYSSA,1001)I,CPNAM(I),U(I),WERR(IINT),ALIM(I),BLIM(I)
 1001 FORMAT(1X,I5,1H',A10,1H',4E13.5)
  200 CONTINUE
      WRITE(ISYSSA,'(A)')' '
      NLINES=NLINES+1
      IF(ISW(2).LT.1)GOTO750
      WRITE(ISYSSA,1003,ERR=700)NPAR
 1003 FORMAT('SET COVARIANCE',I6)
      NPAR2=NPAR*(NPAR+1)/2
      WRITE(ISYSSA,1004)(VHMAT(I),I=1,NPAR2)
 1004 FORMAT(BN,7E11.4,3X)
      NCOVAR=NPAR2/7+1
      IF(MOD(NPAR2,7).GT.0)NCOVAR=NCOVAR+1
      NLINES=NLINES+NCOVAR
      WRITE(ISYSWR,501)NLINES,ISYSSA,CGNAME(1:45)
  501 FORMAT(1X,I5,' RECORDS WRITTEN TO UNIT',I4,':',A)
      IF(NCOVAR.GT.0)WRITE(ISYSWR,502)NCOVAR
  502 FORMAT(' INCLUDING',I5,' RECORDS FOR THE COVARIANCE MATRIX.'/)
      GOTO900
  600 WRITE(ISYSWR,'(A,I4)')' I/O ERROR: UNABLE TO OPEN UNIT',ISYSSA
      GOTO900
  650 WRITE(ISYSWR,'(A,I4,A)')' UNIT',ISYSSA,' IS NOT OPENED.'
      GOTO900
  700 WRITE(ISYSWR,'(A,I4)')' ERROR: UNABLE TO WRITE TO UNIT',ISYSSA
      GOTO900
  750 WRITE(ISYSWR,'(A)')' THERE IS NO COVARIANCE MATRIX TO SAVE.'
  900 RETURN
      END
 
      SUBROUTINEMNSCAN(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      XLREQ=MIN(WORD7(3),WORD7(4))
      XHREQ=MAX(WORD7(3),WORD7(4))
      NCALL=WORD7(2)+0.01
      IF(NCALL.LE.1)NCALL=41
      IF(NCALL.GT.MAXCPT)NCALL=MAXCPT
      NCCALL=NCALL
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      IPARWD=WORD7(1)+0.1
      IPAR=MAX(IPARWD,0)
      IINT=NIOFEX(IPAR)
      CSTATU='NO CHANGE'
      IF(IPARWD.GT.0)GOTO200
  100 IPAR=IPAR+1
      IF(IPAR.GT.NU)GOTO900
      IINT=NIOFEX(IPAR)
      IF(IINT.LE.0)GOTO100
  200 CONTINUE
      UBEST=U(IPAR)
      XPT(1)=UBEST
      YPT(1)=AMIN
      CHPT(1)=' '
      XPT(2)=UBEST
      YPT(2)=AMIN
      CHPT(2)='X'
      NXYPT=2
      IF(NVARL(IPAR).GT.1)GOTO300
      IF(XLREQ.EQ.XHREQ)GOTO250
      UNEXT=XLREQ
      STEP=(XHREQ-XLREQ)/FLOAT(NCALL-1)
      GOTO500
  250 CONTINUE
      XL=UBEST-WERR(IINT)
      XH=UBEST+WERR(IINT)
      CALLMNBINS(XL,XH,NCALL,UNEXT,UHIGH,NBINS,STEP)
      NCCALL=NBINS+1
      GOTO500
  300 CONTINUE
      IF(XLREQ.EQ.XHREQ)GOTO350
      XL=MAX(XLREQ,ALIM(IPAR))
      XH=MIN(XHREQ,BLIM(IPAR))
      IF(XL.GE.XH)GOTO700
      UNEXT=XL
      STEP=(XH-XL)/FLOAT(NCALL-1)
      GOTO500
  350 CONTINUE
      UNEXT=ALIM(IPAR)
      STEP=(BLIM(IPAR)-ALIM(IPAR))/FLOAT(NCALL-1)
  500 CONTINUE
      DO600ICALL=1,NCCALL
      U(IPAR)=UNEXT
      NPARX=NPAR
      CALLFCN(NPARX,GIN,FNEXT,U,4,FUTIL)
      NFCN=NFCN+1
      NXYPT=NXYPT+1
      XPT(NXYPT)=UNEXT
      YPT(NXYPT)=FNEXT
      CHPT(NXYPT)='*'
      IF(FNEXT.LT.AMIN)THEN
      AMIN=FNEXT
      UBEST=UNEXT
      CSTATU='IMPROVED  '
      ENDIF
  530 CONTINUE
      UNEXT=UNEXT+STEP
  600 CONTINUE
      U(IPAR)=UBEST
      CALLMNEXIN(X)
      WRITE(ISYSWR,1001)NEWPAG,IPAR,CPNAM(IPAR)
      NUNIT=ISYSWR
      CALLMNPLOT(XPT,YPT,CHPT,NXYPT,NUNIT,NPAGWD,NPAGLN)
      GOTO800
  700 CONTINUE
      WRITE(ISYSWR,1000)IPAR
  800 CONTINUE
      IF(IPARWD.LE.0)GOTO100
  900 CONTINUE
      CALLMNPRIN(5,AMIN)
      RETURN
 1000 FORMAT(' REQUESTED RANGE OUTSIDE LIMITS FOR PARAMETER ',I3/)
 1001 FORMAT(I1,'SCAN OF PARAMETER NO.',I3,3X,A10)
      END
 
      SUBROUTINEMNSEEK(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      PARAMETER(TWOPI=2.0*3.141593)
      DIMENSIONXBEST(MNI),XMID(MNI)
      MXFAIL=WORD7(1)
      IF(MXFAIL.LE.0)MXFAIL=100+20*NPAR
      MXSTEP=10*MXFAIL
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      ALPHA=WORD7(2)
      IF(ALPHA.LE.ZERO)ALPHA=3.
      IF(ISW(5).GE.1)WRITE(ISYSWR,3)MXFAIL,MXSTEP,ALPHA
    3 FORMAT(' MNSEEK: MONTE CARLO MINIMIZATION USING METROPOLIS',' ALGO
     +RITHM'/' TO STOP AFTER',I6,' SUCCESSIVE FAILURES, OR',I7,' STEPS'/
     +' MAXIMUM STEP SIZE IS',F9.3,' ERROR BARS.')
      CSTATU='INITIAL  '
      IF(ISW(5).GE.2)CALLMNPRIN(2,AMIN)
      CSTATU='UNCHANGED '
      IFAIL=0
      RNUM=ZERO
      RNUM1=ZERO
      RNUM2=ZERO
      NPARX=NPAR
      FLAST=AMIN
      DO10IPAR=1,NPAR
      IEXT=NEXOFI(IPAR)
      DIRIN(IPAR)=2.0*ALPHA*WERR(IPAR)
      IF(NVARL(IEXT).GT.1)THEN
      CALLMNDXDI(X(IPAR),IPAR,DXDI)
      IF(DXDI.EQ.ZERO)DXDI=1.
      DIRIN(IPAR)=2.0*ALPHA*WERR(IPAR)/DXDI
      IF(ABS(DIRIN(IPAR)).GT.TWOPI)DIRIN(IPAR)=TWOPI
      ENDIF
      XMID(IPAR)=X(IPAR)
   10 XBEST(IPAR)=X(IPAR)
      DO500ISTEP=1,MXSTEP
      IF(IFAIL.GE.MXFAIL)GOTO600
      DO100IPAR=1,NPAR
      CALLMNRN15(RNUM1,ISEED)
      CALLMNRN15(RNUM2,ISEED)
  100 X(IPAR)=XMID(IPAR)+0.5*(RNUM1+RNUM2-1.)*DIRIN(IPAR)
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,FTRY,U,4,FUTIL)
      NFCN=NFCN+1
      IF(FTRY.LT.FLAST)THEN
      IF(FTRY.LT.AMIN)THEN
      CSTATU='IMPROVEMNT'
      AMIN=FTRY
      DO200IB=1,NPAR
  200 XBEST(IB)=X(IB)
      IFAIL=0
      IF(ISW(5).GE.2)CALLMNPRIN(2,AMIN)
      ENDIF
      GOTO300
      ELSE
      IFAIL=IFAIL+1
      BAR=EXP((AMIN-FTRY)/UP)
      CALLMNRN15(RNUM,ISEED)
      IF(BAR.LT.RNUM)GOTO500
      ENDIF
  300 CONTINUE
      DO350J=1,NPAR
      XMID(J)=X(J)
  350 CONTINUE
      FLAST=FTRY
  500 CONTINUE
  600 CONTINUE
      IF(ISW(5).GT.1)WRITE(ISYSWR,601)IFAIL
  601 FORMAT(' MNSEEK:',I5,' SUCCESSIVE UNSUCCESSFUL TRIALS.')
      DO700IB=1,NPAR
  700 X(IB)=XBEST(IB)
      CALLMNINEX(X)
      IF(ISW(5).GE.1)CALLMNPRIN(2,AMIN)
      IF(ISW(5).EQ.0)CALLMNPRIN(0,AMIN)
      RETURN
      END
 
      SUBROUTINEMNSET(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      LOGICALLNAME
      CHARACTERCFNAME*64,CMODE*16
      CHARACTERCKIND*4,COPT*3,CWARN*10
      CHARACTERCPRLEV(-1:3)*34,CSTRAT(0:2)*44
      PARAMETER(NUMDBG=6)
      CHARACTER*40CDBOPT(0:NUMDBG)
      CHARACTER*10CNAME(30)
      DATACNAME(1)/'FCN value '/
      DATACNAME(2)/'PARameters'/
      DATACNAME(3)/'LIMits    '/
      DATACNAME(4)/'COVariance'/
      DATACNAME(5)/'CORrelatio'/
      DATACNAME(6)/'PRInt levl'/
      DATACNAME(7)/'NOGradient'/
      DATACNAME(8)/'GRAdient  '/
      DATACNAME(9)/'ERRor def '/
      DATACNAME(10)/'INPut file'/
      DATACNAME(11)/'WIDth page'/
      DATACNAME(12)/'LINes page'/
      DATACNAME(13)/'NOWarnings'/
      DATACNAME(14)/'WARnings  '/
      DATACNAME(15)/'RANdom gen'/
      DATACNAME(16)/'TITle     '/
      DATACNAME(17)/'STRategy  '/
      DATACNAME(18)/'EIGenvalue'/
      DATACNAME(19)/'PAGe throw'/
      DATACNAME(20)/'MINos errs'/
      DATACNAME(21)/'EPSmachine'/
      DATACNAME(22)/'OUTputfile'/
      DATACNAME(23)/'BATch     '/
      DATACNAME(24)/'INTeractiv'/
      DATANNAME/24/
      DATACNAME(25)/'reserve   '/
      DATACNAME(26)/'reserve   '/
      DATACNAME(27)/'NODebug   '/
      DATACNAME(28)/'DEBug     '/
      DATACNAME(29)/'SHOw      '/
      DATACNAME(30)/'SET       '/
      DATANNTOT/30/
      DATACPRLEV(-1)/'-1: NO OUTPUT EXCEPT FROM "SHOW"  '/
      DATACPRLEV(0)/' 0: REDUCED OUTPUT                '/
      DATACPRLEV(1)/' 1: NORMAL OUTPUT                 '/
      DATACPRLEV(2)/' 2: EXTRA OUTPUT FOR PROBLEM CASES'/
      DATACPRLEV(3)/' 3: MAXIMUM OUTPUT                '/
      DATACSTRAT(0)/' 0: MINIMIZE THE NUMBER OF CALLS TO FUNCTION'/
      DATACSTRAT(1)/' 1: TRY TO BALANCE SPEED AGAINST RELIABILITY'/
      DATACSTRAT(2)/' 2: MAKE SURE MINIMUM TRUE, ERRORS CORRECT  '/
      DATACDBOPT(0)/'REPORT ALL EXCEPTIONAL CONDITIONS      '/
      DATACDBOPT(1)/'MNLINE: LINE SEARCH MINIMIZATION       '/
      DATACDBOPT(2)/'MNDERI: FIRST DERIVATIVE CALCULATIONS  '/
      DATACDBOPT(3)/'MNHESS: SECOND DERIVATIVE CALCULATIONS '/
      DATACDBOPT(4)/'MNMIGR: COVARIANCE MATRIX UPDATES      '/
      DATACDBOPT(5)/'MNHES1: FIRST DERIVATIVE UNCERTAINTIES '/
      DATACDBOPT(6)/'MNCONT: MNCONTOUR PLOT (MNCROS SEARCH) '/
      DO2I=1,NNTOT
      IF(INDEX(CWORD(4:10),CNAME(I)(1:3)).GT.0)GOTO5
    2 CONTINUE
      I=0
    5 KNAME=I
      IF(INDEX(CWORD(1:4),'HEL').GT.0)GOTO2000
      IF(INDEX(CWORD(1:4),'SHO').GT.0)GOTO1000
      IF(INDEX(CWORD(1:4),'SET').EQ.0)GOTO1900
      CKIND='SET '
      IF(KNAME.LE.0)GOTO1900
      GOTO(3000,20,30,40,3000,60,70,80,90,100,110,120,130,140,150,160,17
     +0,3000,190,3000,210,220,230,240,1900,1900,270,280,290,300),KNAME
   20 CONTINUE
      IPRM=WORD7(1)
      IF(IPRM.GT.NU)GOTO25
      IF(IPRM.LE.0)GOTO25
      IF(NVARL(IPRM).LT.0)GOTO25
      U(IPRM)=WORD7(2)
      CALLMNEXIN(X)
      ISW2=ISW(2)
      CALLMNRSET(1)
      ISW(2)=MIN(ISW2,1)
      CFROM='SET PARM'
      NFCNFR=NFCN
      CSTATU='NEW VALUES'
      GOTO4000
   25 WRITE(ISYSWR,'(A/)')' UNDEFINED PARAMETER NUMBER.  IGNORED.'
      GOTO4000
   30 CALLMNLIMS(FCN,FUTIL)
      GOTO4000
   40 CONTINUE
      GOTO3000
   60 ISW(5)=WORD7(1)
      GOTO4000
   70 ISW(3)=0
      GOTO4000
   80 CALLMNGRAD(FCN,FUTIL)
      GOTO4000
   90 IF(WORD7(1).EQ.UP)GOTO4000
      IF(WORD7(1).LE.ZERO)THEN
      IF(UP.EQ.UPDFLT)GOTO4000
      UP=UPDFLT
      ELSE
      UP=WORD7(1)
      ENDIF
      DO95I=1,NPAR
      ERN(I)=0.
   95 ERP(I)=0.
      CALLMNWERR
      GOTO4000
  100 CONTINUE
      GOTO3000
  110 NPAGWD=WORD7(1)
      NPAGWD=MAX(NPAGWD,50)
      GOTO4000
  120 NPAGLN=WORD7(1)
      GOTO4000
  130 LWARN=.FALSE.
      GOTO4000
  140 LWARN=.TRUE.
      CALLMNWARN('W','SHO','SHO')
      GOTO4000
  150 JSEED=INT(WORD7(1))
      VAL=3.
      CALLMNRN15(VAL,JSEED)
      IF(ISW(5).GT.0)WRITE(ISYSWR,151)JSEED
  151 FORMAT(' MINUIT RANDOM NUMBER SEED SET TO ',I10)
      GOTO4000
  160 CONTINUE
      GOTO3000
  170 ISTRAT=WORD7(1)
      ISTRAT=MAX(ISTRAT,0)
      ISTRAT=MIN(ISTRAT,2)
      IF(ISW(5).GT.0)GOTO1172
      GOTO4000
  190 NEWPAG=WORD7(1)
      GOTO1190
  210 IF(WORD7(1).GT.ZERO.AND.WORD7(1).LT.0.1)EPSMAC=WORD7(1)
      EPSMA2=SQRT(EPSMAC)
      GOTO1210
  220 CONTINUE
      IUNIT=WORD7(1)
      ISYSWR=IUNIT
      ISTKWR(1)=IUNIT
      IF(ISW(5).GE.0)GOTO1220
      GOTO4000
  230 ISW(6)=0
      IF(ISW(5).GE.0)GOTO1100
      GOTO4000
  240 ISW(6)=1
      IF(ISW(5).GE.0)GOTO1100
      GOTO4000
  270 ISET=0
      GOTO281
  280 ISET=1
  281 CONTINUE
      IDBOPT=WORD7(1)
      IF(IDBOPT.GT.NUMDBG)GOTO288
      IF(IDBOPT.GE.0)THEN
      IDBG(IDBOPT)=ISET
      IF(ISET.EQ.1)IDBG(0)=1
      ELSE
      DO285ID=0,NUMDBG
  285 IDBG(ID)=ISET
      ENDIF
      LREPOR=(IDBG(0).GE.1)
      CALLMNWARN('D','SHO','SHO')
      GOTO4000
  288 WRITE(ISYSWR,289)IDBOPT
  289 FORMAT(' UNKNOWN DEBUG OPTION',I6,' REQUESTED. IGNORED')
      GOTO4000
  290 CONTINUE
  300 CONTINUE
      GOTO3000
 1000 CONTINUE
      CKIND='SHOW'
      IF(KNAME.LE.0)GOTO1900
      GOTO(1010,1020,1030,1040,1050,1060,1070,1070,1090,1100,1110,1120,1
     +130,1130,1150,1160,1170,1180,1190,1200,1210,1220,1100,1100,1900,19
     +00,1270,1270,1290,1300),KNAME
 1010 CONTINUE
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      CALLMNPRIN(0,AMIN)
      GOTO4000
 1020 CONTINUE
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      CALLMNPRIN(5,AMIN)
      GOTO4000
 1030 CONTINUE
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      CALLMNPRIN(1,AMIN)
      GOTO4000
 1040 CALLMNMATU(1)
      GOTO4000
 1050 CALLMNMATU(0)
      GOTO4000
 1060 CONTINUE
      IF(ISW(5).LT.-1)ISW(5)=-1
      IF(ISW(5).GT.3)ISW(5)=3
      WRITE(ISYSWR,'(A)')' ALLOWED PRINT LEVELS ARE:'
      WRITE(ISYSWR,'(27X,A)')CPRLEV
      WRITE(ISYSWR,1061)CPRLEV(ISW(5))
 1061 FORMAT(/' CURRENT PRINTOUT LEVEL IS ',A)
      GOTO4000
 1070 CONTINUE
      IF(ISW(3).LE.0)THEN
      WRITE(ISYSWR,1081)
 1081 FORMAT(' NOGRAD IS SET.  DERIVATIVES NOT COMPUTED IN FCN.')
      ELSE
      WRITE(ISYSWR,1082)
 1082 FORMAT('   GRAD IS SET.  USER COMPUTES DERIVATIVES IN FCN.')
      ENDIF
      GOTO4000
 1090 WRITE(ISYSWR,1091)UP
 1091 FORMAT(' ERRORS CORRESPOND TO FUNCTION CHANGE OF',G13.5)
      GOTO4000
 1100 CONTINUE
      INQUIRE(UNIT=ISYSRD,NAMED=LNAME,NAME=CFNAME)
      CMODE='BATCH MODE      '
      IF(ISW(6).EQ.1)CMODE='INTERACTIVE MODE'
      IF(.NOT.LNAME)CFNAME='unknown'
      WRITE(ISYSWR,1002)CMODE,ISYSRD,CFNAME
 1002 FORMAT(' INPUT NOW BEING READ IN ',A,' FROM UNIT NO.',I3/' FILENAM
     +E: ',A)
      GOTO4000
 1110 WRITE(ISYSWR,1111)NPAGWD
 1111 FORMAT(10X,'PAGE WIDTH IS SET TO',I4,' COLUMNS')
      GOTO4000
 1120 WRITE(ISYSWR,1121)NPAGLN
 1121 FORMAT(10X,'PAGE LENGTH IS SET TO',I4,' LINES')
      GOTO4000
 1130 CONTINUE
      CWARN='SUPPRESSED'
      IF(LWARN)CWARN='REPORTED  '
      WRITE(ISYSWR,1141)CWARN
 1141 FORMAT(' MINUIT WARNING MESSAGES ARE ',A)
      IF(.NOT.LWARN)CALLMNWARN('W','SHO','SHO')
      GOTO4000
 1150 VAL=0.
      CALLMNRN15(VAL,IGRAIN)
      IKSEED=IGRAIN
      WRITE(ISYSWR,1151)IKSEED
 1151 FORMAT(' MINUIT RNDM SEED IS CURRENTLY=',I10/)
      VAL=3.0
      ISEED=IKSEED
      CALLMNRN15(VAL,ISEED)
      GOTO4000
 1160 WRITE(ISYSWR,'(A,A)')' TITLE OF CURRENT TASK IS:',CTITL
      GOTO4000
 1170 WRITE(ISYSWR,'(A)')' ALLOWED STRATEGIES ARE:'
      WRITE(ISYSWR,'(20X,A)')CSTRAT
 1172 WRITE(ISYSWR,1175)CSTRAT(ISTRAT)
 1175 FORMAT(/' NOW USING STRATEGY ',A/)
      GOTO4000
 1180 CONTINUE
      ISWSAV=ISW(5)
      ISW(5)=3
      IF(ISW(2).LT.1)THEN
      WRITE(ISYSWR,'(1X,A)')COVMES(0)
      ELSE
      CALLMNPSDF
      ENDIF
      ISW(5)=ISWSAV
      GOTO4000
 1190 WRITE(ISYSWR,'(A,I3)')' PAGE THROW CARRIAGE CONTROL =',NEWPAG
      IF(NEWPAG.EQ.0)WRITE(ISYSWR,'(A)')' NO PAGE THROWS IN MINUIT OUTPU
     +T'
      GOTO4000
 1200 CONTINUE
      DO1202II=1,NPAR
      IF(ERP(II).GT.ZERO.OR.ERN(II).LT.ZERO)GOTO1204
 1202 CONTINUE
      WRITE(ISYSWR,'(A)')'       THERE ARE NO MINOS ERRORS CURRENTLY VAL
     +ID.'
      GOTO4000
 1204 CONTINUE
      CALLMNPRIN(4,AMIN)
      GOTO4000
 1210 WRITE(ISYSWR,'(A,E12.3)')' FLOATING-POINT NUMBERS ASSUMED ACCURATE
     + TO',EPSMAC
      GOTO4000
 1220 CONTINUE
      WRITE(ISYSWR,'(A,I4)')'  MINUIT PRIMARY OUTPUT TO UNIT',ISYSWR
      GOTO4000
 1270 CONTINUE
      DO1285ID=0,NUMDBG
      COPT='OFF'
      IF(IDBG(ID).GE.1)COPT='ON '
 1285 WRITE(ISYSWR,1286)ID,COPT,CDBOPT(ID)
 1286 FORMAT(10X,'DEBUG OPTION',I3,' IS ',A3,' :',A)
      IF(.NOT.LREPOR)CALLMNWARN('D','SHO','SHO')
      GOTO4000
 1290 CKIND='SHOW'
      GOTO2100
 1300 CKIND='SET '
      GOTO2100
 1900 WRITE(ISYSWR,1901)CWORD
 1901 FORMAT(' THE COMMAND:',A10,' IS UNKNOWN.'/)
      GOTO2100
 2000 CKIND='SET '
      IF(INDEX(CWORD(4:10),'SHO').GT.0)CKIND='SHOW'
 2100 WRITE(ISYSWR,2101)CKIND,CKIND,(CNAME(KK),KK=1,NNAME)
 2101 FORMAT(' THE FORMAT OF THE ',A4,' COMMAND IS:'//1X,A4,' xxx    [nu
     +merical arguments if any]'//' WHERE xxx MAY BE ONE OF THE FOLLOWIN
     +G:'/(7X,6A12))
      GOTO4000
 3000 WRITE(ISYSWR,'('' ABOVE COMMAND IS ILLEGAL.   IGNORED'')')
 4000 RETURN
      END

      SUBROUTINEMNSETI(TIT)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      CHARACTER*(*)TIT
      CTITL=TIT
      RETURN
      END

      SUBROUTINEMNSIMP(FCN,FUTIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      EXTERNALFCN,FUTIL
      DIMENSIONY(MNI+1)
      DATAALPHA,BETA,GAMMA,RHOMIN,RHOMAX/1.0,0.5,2.0,4.0,8.0/
      IF(NPAR.LE.0)RETURN
      IF(AMIN.EQ.UNDEFI)CALLMNAMIN(FCN,FUTIL)
      CFROM='SIMPLEX '
      NFCNFR=NFCN
      CSTATU='UNCHANGED '
      NPFN=NFCN
      NPARP1=NPAR+1
      NPARX=NPAR
      RHO1=1.0+ALPHA
      RHO2=RHO1+ALPHA*GAMMA
      WG=1.0/FLOAT(NPAR)
      IF(ISW(5).GE.0)WRITE(ISYSWR,100)EPSI
  100 FORMAT(' START SIMPLEX MINIMIZATION.    CONVERGENCE WHEN EDM .LT.'
     +,E10.2)
      DO2I=1,NPAR
      DIRIN(I)=WERR(I)
      CALLMNDXDI(X(I),I,DXDI)
      IF(DXDI.NE.ZERO)DIRIN(I)=WERR(I)/DXDI
      DMIN=EPSMA2*ABS(X(I))
      IF(DIRIN(I).LT.DMIN)DIRIN(I)=DMIN
    2 CONTINUE
    1 CONTINUE
      YNPP1=AMIN
      JL=NPARP1
      Y(NPARP1)=AMIN
      ABSMIN=AMIN
      DO10I=1,NPAR
      AMING=AMIN
      PBAR(I)=X(I)
      BESTX=X(I)
      KG=0
      NS=0
      NF=0
    4 X(I)=BESTX+DIRIN(I)
      CALLMNINEX(X)
      CALLFCN(NPARX,GIN,F,U,4,FUTIL)
      NFCN=NFCN+1
      IF(F.LE.AMING)GOTO6
      IF(KG.EQ.1)GOTO8
      KG=-1
      NF=NF+1
      DIRIN(I)=DIRIN(I)*(-0.4)
      IF(NF.LT.3)GOTO4
      NS=6
    6 BESTX=X(I)
      DIRIN(I)=DIRIN(I)*3.0
      AMING=F
      CSTATU='PROGRESS  '
      KG=1
      NS=NS+1
      IF(NS.LT.6)GOTO4
    8 Y(I)=AMING
      IF(AMING.LT.ABSMIN)JL=I
      IF(AMING.LT.ABSMIN)ABSMIN=AMING
      X(I)=BESTX
      DO9K=1,NPAR
    9 P(K,I)=X(K)
   10 CONTINUE
      JH=NPARP1
      AMIN=Y(JL)
      CALLMNRAZZ(YNPP1,PBAR,Y,JH,JL)
      DO20I=1,NPAR
   20 X(I)=P(I,JL)
      CALLMNINEX(X)
      CSTATU='PROGRESS  '
      IF(ISW(5).GE.1)CALLMNPRIN(5,AMIN)
      EDM=BIGEDM
      SIG2=EDM
      NCYCL=0
   50 CONTINUE
      IF(SIG2.LT.EPSI.AND.EDM.LT.EPSI)GOTO76
      SIG2=EDM
      IF((NFCN-NPFN).GT.NFCNMX)GOTO78
      DO60I=1,NPAR
      PB=0.
      DO59J=1,NPARP1
   59 PB=PB+WG*P(I,J)
      PBAR(I)=PB-WG*P(I,JH)
   60 PSTAR(I)=(1.+ALPHA)*PBAR(I)-ALPHA*P(I,JH)
      CALLMNINEX(PSTAR)
      CALLFCN(NPARX,GIN,YSTAR,U,4,FUTIL)
      NFCN=NFCN+1
      IF(YSTAR.GE.AMIN)GOTO70
      DO61I=1,NPAR
   61 PSTST(I)=GAMMA*PSTAR(I)+(1.-GAMMA)*PBAR(I)
      CALLMNINEX(PSTST)
      CALLFCN(NPARX,GIN,YSTST,U,4,FUTIL)
      NFCN=NFCN+1
      Y1=(YSTAR-Y(JH))*RHO2
      Y2=(YSTST-Y(JH))*RHO1
      RHO=0.5*(RHO2*Y1-RHO1*Y2)/(Y1-Y2)
      IF(RHO.LT.RHOMIN)GOTO66
      IF(RHO.GT.RHOMAX)RHO=RHOMAX
      DO64I=1,NPAR
   64 PRHO(I)=RHO*PBAR(I)+(1.0-RHO)*P(I,JH)
      CALLMNINEX(PRHO)
      CALLFCN(NPARX,GIN,YRHO,U,4,FUTIL)
      NFCN=NFCN+1
      IF(YRHO.LT.Y(JL).AND.YRHO.LT.YSTST)GOTO65
      IF(YSTST.LT.Y(JL))GOTO67
      IF(YRHO.GT.Y(JL))GOTO66
   65 CALLMNRAZZ(YRHO,PRHO,Y,JH,JL)
      GOTO68
   66 IF(YSTST.LT.Y(JL))GOTO67
      CALLMNRAZZ(YSTAR,PSTAR,Y,JH,JL)
      GOTO68
   67 CALLMNRAZZ(YSTST,PSTST,Y,JH,JL)
   68 NCYCL=NCYCL+1
      IF(ISW(5).LT.2)GOTO50
      IF(ISW(5).GE.3.OR.MOD(NCYCL,10).EQ.0)CALLMNPRIN(5,AMIN)
      GOTO50
   70 IF(YSTAR.GE.Y(JH))GOTO73
      JHOLD=JH
      CALLMNRAZZ(YSTAR,PSTAR,Y,JH,JL)
      IF(JHOLD.NE.JH)GOTO50
   73 DO74I=1,NPAR
   74 PSTST(I)=BETA*P(I,JH)+(1.-BETA)*PBAR(I)
      CALLMNINEX(PSTST)
      CALLFCN(NPARX,GIN,YSTST,U,4,FUTIL)
      NFCN=NFCN+1
      IF(YSTST.GT.Y(JH))GOTO1
      IF(YSTST.LT.AMIN)GOTO67
      CALLMNRAZZ(YSTST,PSTST,Y,JH,JL)
      GOTO50
   76 IF(ISW(5).GE.0)WRITE(ISYSWR,'(A)')' SIMPLEX MINIMIZATION HAS CONVE
     +RGED.'
      ISW(4)=1
      GOTO80
   78 IF(ISW(5).GE.0)WRITE(ISYSWR,'(A)')' SIMPLEX TERMINATES WITHOUT CON
     +VERGENCE.'
      CSTATU='CALL LIMIT'
      ISW(4)=-1
      ISW(1)=1
   80 DO82I=1,NPAR
      PB=0.
      DO81J=1,NPARP1
   81 PB=PB+WG*P(I,J)
   82 PBAR(I)=PB-WG*P(I,JH)
      CALLMNINEX(PBAR)
      CALLFCN(NPARX,GIN,YPBAR,U,4,FUTIL)
      NFCN=NFCN+1
      IF(YPBAR.LT.AMIN)CALLMNRAZZ(YPBAR,PBAR,Y,JH,JL)
      CALLMNINEX(X)
      IF(NFCNMX+NPFN-NFCN.LT.3*NPAR)GOTO90
      IF(EDM.GT.2.0*EPSI)GOTO1
   90 IF(ISW(5).GE.0)CALLMNPRIN(5,AMIN)
      RETURN
      END

      SUBROUTINEMNSTAT(FMIN,FEDM,ERRDEF,NPARI,NPARX,ISTAT)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      FMIN=AMIN
      FEDM=EDM
      ERRDEF=UP
      NPARI=NPAR
      NPARX=NU
      ISTAT=ISW(2)
      IF(EDM.EQ.BIGEDM)THEN
      FEDM=UP
      ENDIF
      IF(AMIN.EQ.UNDEFI)THEN
      FMIN=0.0
      FEDM=UP
      ISTAT=0
      ENDIF
      RETURN
      END

      SUBROUTINEMNSTIN(CRDBUF,IERR)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      CHARACTERCRDBUF*(*),CUNIT*10,CFNAME*64,CGNAME*64,CANSWR*1
      CHARACTERCMODE*16
      LOGICALLOPEN,LREWIN,NONAME,LNAME,MNUNPT
      NONAME=.TRUE.
      IERR=0
      IF(INDEX(CRDBUF,'*EOF').EQ.1)GOTO190
      IF(INDEX(CRDBUF,'*eof').EQ.1)GOTO190
      LEND=LEN(CRDBUF)
      DO20IC=8,LEND
      IF(CRDBUF(IC:IC).EQ.' ')GOTO25
      IF(CRDBUF(IC:IC).EQ.',')GOTO53
   20 CONTINUE
      GOTO200
   25 CONTINUE
      ICOL=IC+1
      DO50IC=ICOL,LEND
      IF(CRDBUF(IC:IC).EQ.' ')GOTO50
      IF(CRDBUF(IC:IC).EQ.',')GOTO53
      GOTO55
   50 CONTINUE
      GOTO200
   53 IC=IC+1
   55 IC1=IC
      LREWIN=.FALSE.
      IF(INDEX(CRDBUF(1:IC1),'REW').GT.5)LREWIN=.TRUE.
      IF(INDEX(CRDBUF(1:IC1),'rew').GT.5)LREWIN=.TRUE.
      DO75IC=IC1,LEND
      IF(CRDBUF(IC:IC).EQ.' ')GOTO75
      IF(CRDBUF(IC:IC).EQ.',')GOTO200
      GOTO80
   75 CONTINUE
      GOTO200
   80 IC1=IC
      DO100IC=IC1+1,LEND
      IF(CRDBUF(IC:IC).EQ.' ')GOTO108
      IF(CRDBUF(IC:IC).EQ.',')GOTO108
  100 CONTINUE
      IC=LEND+1
  108 IC2=IC-1
  110 CONTINUE
      CUNIT=CRDBUF(IC1:IC2)
      WRITE(ISYSWR,'(A,A)')' UNIT NO. :',CUNIT
      READ(CUNIT,'(BN,F10.0)',ERR=500)FUNIT
      IUNIT=FUNIT
      IF(IUNIT.EQ.0)GOTO200
      DO120IC=IC2+1,LEND
      IF(CRDBUF(IC:IC).EQ.' ')GOTO120
      IF(CRDBUF(IC:IC).EQ.',')GOTO120
      GOTO130
  120 CONTINUE
      GOTO131
  130 CONTINUE
      CFNAME=CRDBUF(IC:LEND)
      NONAME=.FALSE.
      WRITE(ISYSWR,'(A,A)')' FILE NAME IS:',CFNAME
  131 CONTINUE
      INQUIRE(UNIT=IUNIT,OPENED=LOPEN,NAMED=LNAME,NAME=CGNAME)
      IF(LOPEN)THEN
      IF(NONAME)THEN
      GOTO136
      ELSE
      IF(.NOT.LNAME)CGNAME='unknown'
      WRITE(ISYSWR,132)IUNIT,CGNAME,CFNAME
  132 FORMAT(' UNIT',I3,' ALREADY OPENED WITH NAME:',A/'                
     + NEW NAME IGNORED:',A)
      ENDIF
      ELSE
      WRITE(ISYSWR,135)IUNIT
  135 FORMAT(' UNIT',I3,' IS NOT OPENED.')
      IF(NONAME)THEN
      WRITE(ISYSWR,'(A)')' NO FILE NAME GIVEN IN COMMAND.'
      IF(ISW(6).LT.1)GOTO800
      WRITE(ISYSWR,'(A)')' PLEASE GIVE FILE NAME:'
      READ(ISYSRD,'(A)')CFNAME
      ENDIF
      OPEN(UNIT=IUNIT,FILE=CFNAME,STATUS='OLD',ERR=600)
      WRITE(ISYSWR,'(A)')' FILE OPENED SUCCESSFULLY.'
      ENDIF
  136 IF(LREWIN)GOTO150
      IF(ISW(6).LT.1)GOTO300
      WRITE(ISYSWR,137)IUNIT
  137 FORMAT(' SHOULD UNIT',I3,' BE REWOUND?')
      READ(ISYSRD,'(A)')CANSWR
      IF(CANSWR.NE.'Y'.AND.CANSWR.NE.'y')GOTO300
  150 REWINDIUNIT
      GOTO300
  190 CONTINUE
      IF(NSTKRD.EQ.0)THEN
      IERR=2
      GOTO900
      ENDIF
  200 CONTINUE
      IF(NSTKRD.EQ.0)THEN
      WRITE(ISYSWR,'(A,A)')' COMMAND IGNORED:',CRDBUF
      WRITE(ISYSWR,'(A)')' ALREADY READING FROM PRIMARY INPUT'
      ELSE
      ISYSRD=ISTKRD(NSTKRD)
      NSTKRD=NSTKRD-1
      IF(NSTKRD.EQ.0)ISW(6)=IABS(ISW(6))
      IF(ISW(5).GE.0)THEN
      INQUIRE(UNIT=ISYSRD,NAMED=LNAME,NAME=CFNAME)
      CMODE='BATCH MODE      '
      IF(ISW(6).EQ.1)CMODE='INTERACTIVE MODE'
      IF(.NOT.LNAME)CFNAME='unknown'
      IF(MNUNPT(CFNAME))CFNAME='unprintable'
      WRITE(ISYSWR,290)CMODE,ISYSRD,CFNAME
  290 FORMAT(' INPUT WILL NOW BE READ IN ',A,' FROM UNIT NO.',I3/' FILEN
     +AME: ',A)
      ENDIF
      ENDIF
      GOTO900
  300 CONTINUE
      IF(NSTKRD.GE.MAXSTK)THEN
      WRITE(ISYSWR,'(A)')' INPUT FILE STACK SIZE EXCEEDED.'
      GOTO800
      ENDIF
      NSTKRD=NSTKRD+1
      ISTKRD(NSTKRD)=ISYSRD
      ISYSRD=IUNIT
      IF(ISW(6).EQ.1)ISW(6)=-1
      GOTO900
  500 CONTINUE
      WRITE(ISYSWR,'(A,A)')' CANNOT READ FOLLOWING AS INTEGER:',CUNIT
      GOTO800
  600 CONTINUE
      WRITE(ISYSWR,601)CFNAME
  601 FORMAT(' SYSTEM IS UNABLE TO OPEN FILE:',A)
  800 CONTINUE
      IERR=3
  900 CONTINUE
      RETURN
      END

      SUBROUTINEMNTINY(EPSP1,EPSBAK)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(ONE=1.0)
      EPSBAK=EPSP1-ONE
      RETURN
      END
      LOGICALFUNCTIONMNUNPT(CFNAME)
      IMPLICITINTEGER(I-N)
      CHARACTERCFNAME*(*)
      CHARACTERCPT*80,CP1*40,CP2*40
      PARAMETER(CP1=' ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklm')
      PARAMETER(CP2='nopqrstuvwxyz1234567890./;:[]$%*_!@#&+()')
      CPT=CP1//CP2
      MNUNPT=.FALSE.
      L=LEN(CFNAME)
      DO100I=1,L
      DO50IC=1,80
      IF(CFNAME(I:I).EQ.CPT(IC:IC))GOTO100
   50 CONTINUE
      MNUNPT=.TRUE.
      GOTO150
  100 CONTINUE
  150 CONTINUE
      RETURN
      END

      SUBROUTINEMNVERT(A,L,M,N,IFAIL)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      DIMENSIONA(L,M),PP(MNI),Q(MNI),S(MNI)
      IFAIL=0
      IF(N.LT.1)GOTO100
      IF(N.GT.MAXINT)GOTO100
      DO8I=1,N
      SI=A(I,I)
      IF(SI)100,100,8
    8 S(I)=1.0/SQRT(SI)
      DO20I=1,N
      DO20J=1,N
   20 A(I,J)=A(I,J)*S(I)*S(J)
      DO65I=1,N
      K=I
      Q(K)=1./A(K,K)
      PP(K)=1.0
      A(K,K)=0.0
      KP1=K+1
      KM1=K-1
      IF(KM1)100,50,40
   40 DO49J=1,KM1
      PP(J)=A(J,K)
      Q(J)=A(J,K)*Q(K)
   49 A(J,K)=0.
   50 IF(K-N)51,60,100
   51 DO59J=KP1,N
      PP(J)=A(K,J)
      Q(J)=-A(K,J)*Q(K)
   59 A(K,J)=0.0
   60 DO65J=1,N
      DO65K=J,N
   65 A(J,K)=A(J,K)+PP(J)*Q(K)
      DO70J=1,N
      DO70K=1,J
      A(K,J)=A(K,J)*S(K)*S(J)
   70 A(J,K)=A(K,J)
      RETURN
  100 IFAIL=1
      RETURN
      END

      SUBROUTINEMNWARN(COPT,CORG,CMES)
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      CHARACTERCOPT*1,CORG*(*),CMES*(*),CTYP*7
      PARAMETER(MAXMES=10)
      CHARACTERORIGIN(MAXMES,2)*10,WARMES(MAXMES,2)*60
      COMMON/MN7WRC/ORIGIN,WARMES
      COMMON/MN7WRI/NFCWAR(MAXMES,2),ICIRC(2)
      CHARACTERENGLSH*20
      IF(CORG(1:3).EQ.'SHO'.AND.CMES(1:3).EQ.'SHO')GOTO200
      IF(COPT.EQ.'W')THEN
      ITYP=1
      IF(LWARN)THEN
      WRITE(ISYSWR,'(A,A/A,A)')' MINUIT WARNING IN ',CORG,' ============
     +== ',CMES
      RETURN
      ENDIF
      ELSE
      ITYP=2
      IF(LREPOR)THEN
      WRITE(ISYSWR,'(A,A/A,A)')' MINUIT DEBUG FOR  ',CORG,' ============
     +== ',CMES
      RETURN
      ENDIF
      ENDIF
      IF(NWRMES(ITYP).EQ.0)ICIRC(ITYP)=0
      NWRMES(ITYP)=NWRMES(ITYP)+1
      ICIRC(ITYP)=ICIRC(ITYP)+1
      IF(ICIRC(ITYP).GT.MAXMES)ICIRC(ITYP)=1
      IC=ICIRC(ITYP)
      ORIGIN(IC,ITYP)=CORG
      WARMES(IC,ITYP)=CMES
      NFCWAR(IC,ITYP)=NFCN
      RETURN
  200 CONTINUE
      IF(COPT.EQ.'W')THEN
      ITYP=1
      CTYP='WARNING'
      ELSE
      ITYP=2
      CTYP='*DEBUG*'
      ENDIF
      IF(NWRMES(ITYP).GT.0)THEN
      ENGLSH=' WAS SUPPRESSED.  '
      IF(NWRMES(ITYP).GT.1)ENGLSH='S WERE SUPPRESSED.'
      WRITE(ISYSWR,'(/1X,I5,A,A,A,A/)')NWRMES(ITYP),' MINUIT ',CTYP,' ME
     +SSAGE',ENGLSH
      NM=NWRMES(ITYP)
      IC=0
      IF(NM.GT.MAXMES)THEN
      WRITE(ISYSWR,'(A,I2,A)')' ONLY THE MOST RECENT ',MAXMES,' WILL BE 
     +LISTED BELOW.'
      NM=MAXMES
      IC=ICIRC(ITYP)
      ENDIF
      WRITE(ISYSWR,'(A)')'  CALLS  ORIGIN         MESSAGE'
      DO300I=1,NM
      IC=IC+1
      IF(IC.GT.MAXMES)IC=1
      WRITE(ISYSWR,'(1X,I6,1X,A,1X,A)')NFCWAR(IC,ITYP),ORIGIN(IC,ITYP),W
     +ARMES(IC,ITYP)
  300 CONTINUE
      NWRMES(ITYP)=0
      WRITE(ISYSWR,'(1H )')
      ENDIF
      RETURN
      END

      SUBROUTINEMNWERR
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      PARAMETER(MNE=198,MNI=99)                 !MNE = 2*MNI
      PARAMETER(MNIHL=MNI*(MNI+1)/2)
      CHARACTER*10CPNAM
      COMMON/MN7NAM/CPNAM(MNE)/MN7EXT/U(MNE),ALIM(MNE),BLIM(MNE)/MN7ERR/
     +ERP(MNI),ERN(MNI),WERR(MNI),GLOBCC(MNI)/MN7INX/NVARL(MNE),NIOFEX(M
     +NE),NEXOFI(MNI)/MN7INT/X(MNI),XT(MNI),DIRIN(MNI)/MN7FX2/XS(MNI),XT
     +S(MNI),DIRINS(MNI)/MN7DER/GRD(MNI),G2(MNI),GSTEP(MNI),GIN(MNE),DGR
     +D(MNI)/MN7FX3/GRDS(MNI),G2S(MNI),GSTEPS(MNI)/MN7FX1/IPFIX(MNI),NPF
     +IX/MN7VAR/VHMAT(MNIHL)/MN7VAT/VTHMAT(MNIHL)/MN7SIM/P(MNI,MNI+1),PS
     +TAR(MNI),PSTST(MNI),PBAR(MNI),PRHO(MNI)
      PARAMETER(MAXDBG=10,MAXSTK=10,MAXCWD=20,MAXP=30,MAXCPT=101)
      PARAMETER(ZERO=0.0,ONE=1.0,HALF=0.5)
      COMMON/MN7NPR/MAXINT,NPAR,MAXEXT,NU/MN7IOU/ISYSRD,ISYSWR,ISYSSA,NP
     +AGWD,NPAGLN,NEWPAG/MN7IO2/ISTKRD(MAXSTK),NSTKRD,ISTKWR(MAXSTK),NST
     +KWR/MN7TIT/CFROM,CSTATU,CTITL,CWORD,CUNDEF,CVRSN,COVMES/MN7FLG/ISW
     +(7),IDBG(0:MAXDBG),NBLOCK,ICOMND/MN7MIN/AMIN,UP,EDM,FVAL3,EPSI,APS
     +I,DCOVAR/MN7CNV/NFCN,NFCNMX,NFCNLC,NFCNFR,ITAUR,ISTRAT,NWRMES(2)/M
     +N7ARG/WORD7(MAXP)/MN7LOG/LWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD/
     +MN7CNS/EPSMAC,EPSMA2,VLIMLO,VLIMHI,UNDEFI,BIGEDM,UPDFLT/MN7RPT/XPT
     +(MAXCPT),YPT(MAXCPT)/MN7CPT/CHPT(MAXCPT)/MN7XCR/XMIDCR,YMIDCR,XDIR
     +CR,YDIRCR,KE1CR,KE2CR
      CHARACTERCTITL*50,CWORD*(MAXCWD),CUNDEF*10,CFROM*8,CVRSN*6,COVMES(
     +0:3)*22,CSTATU*10,CHPT*1
      LOGICALLWARN,LREPOR,LIMSET,LNOLIM,LNEWMN,LPHEAD
      IF(ISW(2).GE.1)THEN
      DO100L=1,NPAR
      NDEX=L*(L+1)/2
      DX=SQRT(ABS(VHMAT(NDEX)*UP))
      I=NEXOFI(L)
      IF(NVARL(I).GT.1)THEN
      AL=ALIM(I)
      BA=BLIM(I)-AL
      DU1=AL+0.5*(SIN(X(L)+DX)+1.0)*BA-U(I)
      DU2=AL+0.5*(SIN(X(L)-DX)+1.0)*BA-U(I)
      IF(DX.GT.1.0)DU1=BA
      DX=0.5*(ABS(DU1)+ABS(DU2))
      ENDIF
      WERR(L)=DX
  100 CONTINUE
      ENDIF
      IF(ISW(2).GE.1)THEN
      DO130I=1,NPAR
      GLOBCC(I)=0.
      K1=I*(I-1)/2
      DO130J=1,I
      K=K1+J
      P(I,J)=VHMAT(K)
  130 P(J,I)=P(I,J)
      CALLMNVERT(P,MAXINT,MAXINT,NPAR,IERR)
      IF(IERR.EQ.0)THEN
      DO150IIN=1,NPAR
      NDIAG=IIN*(IIN+1)/2
      DENOM=P(IIN,IIN)*VHMAT(NDIAG)
      IF(DENOM.LE.ONE.AND.DENOM.GE.ZERO)THEN
      GLOBCC(IIN)=0.
      ELSE
      GLOBCC(IIN)=SQRT(1.0-1.0/DENOM)
      ENDIF
  150 CONTINUE
      ENDIF
      ENDIF
      RETURN
      END

      SUBROUTINESTAND
      IMPLICITDOUBLEPRECISION(A-H,O-Z)
      IMPLICITINTEGER(I-N)
      RETURN
      END
