/++
REQUIRED_ARGS: -HC=verbose
TEST_OUTPUT:
---
// Automatically generated by Digital Mars D Compiler v$n$

#pragma once

#include <assert.h>
#include <stddef.h>
#include <stdint.h>
#include <math.h>

#ifdef CUSTOM_D_ARRAY_TYPE
#define _d_dynamicArray CUSTOM_D_ARRAY_TYPE
#else
/// Represents a D [] array
template<typename T>
struct _d_dynamicArray final
{
    size_t length;
    T *ptr;

    _d_dynamicArray() : length(0), ptr(NULL) { }

    _d_dynamicArray(size_t length_in, T *ptr_in)
        : length(length_in), ptr(ptr_in) { }

    T& operator[](const size_t idx) {
        assert(idx < length);
        return ptr[idx];
    }

    const T& operator[](const size_t idx) const {
        assert(idx < length);
        return ptr[idx];
    }
};
#endif

extern "C" int32_t freeC();

// Ignored function dtoh_mangling.bar because C++ doesn't support explicit mangling
struct Data final
{
    // Ignored function dtoh_mangling.Data.foo because of linkage
    // Ignored function dtoh_mangling.Data.bar because C++ doesn't support explicit mangling
    Data()
    {
    }
};

extern void accept(Data data);

extern "C" void hasDefault(int32_t i = freeC());

extern "C" void hasDefaultMember(int32_t i = memberC());

extern "C" int32_t someVarC;

// Ignored variable dtoh_mangling.var2 because C++ doesn't support explicit mangling
struct HasMangleMember final
{
    int32_t someAttrC;
    int32_t someAttrCpp;
    void hasDefaultVar(int32_t i = someAttrC);
    HasMangleMember()
    {
    }
};

extern "C" void hasDefaultVar(int32_t i = someVarC);
---
++/

extern(C):

pragma(mangle, "freeC")
int foo() { return 0; }

pragma(mangle, "freeCpp")
extern (C++) void bar() {}

pragma(mangle, "Aggregate")
struct Data
{
    pragma(mangle, "memberC")
    static int foo() { return 0; }

    pragma(mangle, "memberCpp")
    extern (C++) void bar() {}
}

extern(C++)
void accept(Data data) {}

void hasDefault(int i = foo()) {}

void hasDefaultMember(int i = Data.foo()) {}

pragma(mangle, "someVarC")
__gshared int var;

pragma(mangle, "someVarCpp")
extern(C++) __gshared int var2;

struct HasMangleMember
{
    pragma(mangle, "someAttrC")
    int var;

    pragma(mangle, "someAttrCpp")
    extern(C++) int var2;

    extern(C++) void hasDefaultVar(int i = var) {}
}

void hasDefaultVar(int i = var) {}
