/* dbus.c
 *
 * Copyright 2024 Christopher Talbot
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gio/gio.h>

#include "geoclue-stumbler-http-dbus.h"

static GDBusConnection *connection;
static GDBusNodeInfo *introspection_data = NULL;

GDBusConnection *
geoclue_stumbler_dbus_get_connection (void)
{
  return connection;
}

void
__geoclue_stumbler_dbus_set_connection (GDBusConnection *conn)
{
  connection = conn;
}

GDBusNodeInfo *
geoclue_stumbler_dbus_get_introspection_data (void)
{
  return introspection_data;
}

void
__geoclue_stumbler_dbus_set_introspection_data (void)
{
  introspection_data = g_dbus_node_info_new_for_xml (introspection_xml, NULL);
  g_assert (introspection_data != NULL);
}

void
__geoclue_stumbler_dbus_unref_introspection_data (void)
{
  g_dbus_node_info_unref (introspection_data);
}
