/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.logdata;

import gmonitor.logdata.UTY;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class BinaryBlock {
    protected static int STRLEN = 65536;
    boolean valid = false;
    int size = 0;
    byte[] rawbytes;

    protected byte[] readBytesWithNull(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[STRLEN];
        int n = this.readBytesWithNull(inputStream, byArray);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    protected int readBytesWithNull(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        if (byArray == null || byArray.length == 0) {
            throw new NullPointerException("No space is allocated in buffer.");
        }
        int n2 = byArray.length;
        int n3 = 0;
        do {
            if ((n3 = inputStream.read()) < 0) {
                ++n;
                break;
            }
            byArray[n] = (byte)n3;
        } while (++n < n2 && n3 != 0);
        return n - 1;
    }

    private int readInt(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 != n) {
            throw new IOException("Invalid binary format, readInt.");
        }
        return UTY.byte2int(byArray);
    }

    protected int read2bytesInt(InputStream inputStream) throws IOException {
        return this.readInt(inputStream, 2);
    }

    protected int read4bytesInt(InputStream inputStream) throws IOException {
        return this.readInt(inputStream, 4);
    }

    protected long read8bytesLong(InputStream inputStream) throws IOException {
        int n = 8;
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 != n) {
            throw new IOException("Invalid binary format, read8bytes as long.");
        }
        return UTY.byte2long(byArray);
    }

    protected abstract void parse_binary_block(InputStream var1) throws IOException;

    protected void deserialize(InputStream inputStream, int n, boolean bl) throws IOException {
        this.size = n;
        byte[] byArray = this.rawbytes = new byte[n];
        if (!bl) {
            this.rawbytes = null;
            byArray = new byte[n];
        }
        inputStream.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.parse_binary_block(byteArrayInputStream);
        this.valid = true;
    }

    protected void deserialize(InputStream inputStream, int n) throws IOException {
        this.deserialize(inputStream, n, true);
    }

    public int getSize() {
        return this.size;
    }

    public boolean isValid() {
        return this.valid;
    }

    public byte[] getRawBytes() {
        if (this.rawbytes == null) {
            return null;
        }
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.rawbytes, 0, byArray, 0, this.size);
        return byArray;
    }
}

