/* Glotski Header */
/* Defines datatypes and low-level (#define) functions */

#define GLOTNAME "Glotski"
#define GLOTVER "0.2"

#ifndef LEVELPATH
#define LEVELPATH "/usr/share/games/glotski/"
#endif

enum _glottype;
typedef enum _glottype glottype;
enum _dirtype;
typedef enum _dirtype dirtype;

enum _glottype {IMMOBILE = 0, HORIZONTAL, VERTICAL, BIMOBILE}; 
enum _dirtype {LEFT = 0, UP, RIGHT, DOWN}; /* Harkens back to GFP */

#define X 0
#define Y 1
#define SPLIT 2

struct _pair;
typedef struct _pair pair;
struct _glot;
typedef struct _glot glot;
struct _goal;
typedef struct _goal goal;
struct _setuplist;
typedef struct _setuplist setuplist;
struct _movelist;
typedef struct _movelist movelist;
struct _level;
typedef struct _level level;

struct _pair {      /* A pair of void pointers as one object */
  void *a;
  void *b;
};

struct _glot {      /* A moving block, aka a glot */
  glottype type;    /* The type of glot */
  level *parent;    /* The level that the glot belongs to */
  unsigned int red, green, blue; /* The glot's color */
  int loc[2];       /* Location - offset of mask.  Can be negative. */
  int size[2];      /* Bounding box of piece */
  char *field;      /* Mask of piece's shape */
  int id;           /* The designation in the parsed file */
  void *element;    /* The graphical element representing the glot */
};

struct _goal {      /* A doubly-linked list of goals */
  glot **field;     /* Pointers to necessary glots (or NULL for unnecessary) */
  int size[2];      /* Redundant, kinda, but necessary for LOOKUP macro */
  goal *prev;       /* Previous goal satisfied */
  goal *next;       /* Next goal to be satisfied */
};

struct _setuplist { /* A singly-linked list of glots */
  glot *this;       /* The current glot */
  setuplist *next;  /* The glot after that */
};

struct _movelist {  /* A doubly-linked list of moves */
  glot *myglot;     /* The piece being moved */
  int startloc[2];  /* The location the piece began with */
  int endloc[2];    /* The new location of the piece */
  int goalsat;      /* Did it satisfy a goal? */
  movelist *prev;   /* The previous move made (null if the first move) */
  movelist *next;   /* The next move made (null if the last move */
};

struct _level {     /* A series of glots with a goal, aka a level*/
  glot **field;     /* Pointers to glots when full, null when empty */
  int size[2];      /* Size of board, X and Y */
  double usize[2];  /* Unit size for drawing, X and Y (start as 32) */
  double scale[2];  /* Scale, X and Y (start as 1) (for bevel sizes) */
  double zoom[2];   /* Zoom, X and Y (start as 1)  (for resizing win)*/
  double gzoom[2];  /* Goal window zoom, X and Y (start as 0.5) */
  setuplist *setup; /* List of glots - the board setup */
  goal *mygoal;     /* Trying to bring level to this glot state */
  int state;        /* What goal has currently been achieved */
  int numgoals;     /* Total number of goals */
  int *equiv;       /* For the eq routines */
  int nextid;       /* The next identifier to be assigned: starts at 0 */
                    /* Also functions as number of glots on level */
  int uniteid;      /* The next union identifier to be assigned: starts at 1 */
  movelist *move;   /* The current move being made */
  int nummoves;     /* The number of moves made */
  int step;         /* The minimum number of moves needed to win */
  int won;          /* Beat level */
  void *lelement;   /* The graphical element representing the level */
  void *gelement;   /* The graphical element representing the goal */
  void *telement;   /* The UI element representing the goal toggle */
  void *selement;   /* The UI element representing the status */
  int showgoal;     /* Show the goal element?  (Default: True) */
};


/* mod 2 finds axis */
/* if dirtype >= SPLIT or dirtype & SPLIT then negative, else positive */
/* if (axis + 1) & jifftype then piece can move in that direction */ 
#define AXIS(a) ((a) & 1) /* 0 if X axis, 1 if Y axis */
#define SIGN(a) ((a) & SPLIT) /* true if positive direction */
#define COMPAT(piece, dir) ((AXIS(dir)+1) & (piece->type)) /* true if piece can
							      go that dir */
#define LOOKUP(w, x, y) ((w)->field[(x) + (y)*(w)->size[X]])

#define XDIR(newx, prevx) (((newx) < (prevx)) ? LEFT : RIGHT)
#define YDIR(newy, prevy) (((newy) < (prevy)) ? UP : DOWN)

/* From glotski.c */
level *makelevel(int xsize, int ysize);
glot *makeglot(level *mylevel, int xloc, int yloc);
goal *makegoal(level *mylevel);
movelist *makemove(level *mylevel);
void deleteglot(glot *myglot);
void deletegoal(goal *mygoal);
void popgoal(goal **mygoal);
void deletelevel(level *mylevel);
void deletemove(movelist *mymove);
void popmove(movelist **mymove);
int goalequiv(level *mylevel);
int glotplace(glot *myglot, int xloc, int yloc, int perform);
int glotmove(glot *moving, dirtype dir, int perform);
void undo(level *mylevel);
void redo(level *mylevel);

/* From equiv.c */
void eq_init(level *mylevel);
int eq_equiv(int *eq, int node1, int node2);
int eq_unite(int *eq, int *id, int parent, int node);

/* From parse.c */
level *loadlev(char *levname, int usepath);

/* From canvas.c */
void moveelement(glot *myglot, int xloc, int yloc);
void redrawgoal(level *mylevel);
void updatestatus(level *mylevel);

