// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package locationservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateTrackerConsumer = "AssociateTrackerConsumer"

// AssociateTrackerConsumerRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTrackerConsumer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTrackerConsumer for more information on using the AssociateTrackerConsumer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateTrackerConsumerRequest method.
//	req, resp := client.AssociateTrackerConsumerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/AssociateTrackerConsumer
func (c *LocationService) AssociateTrackerConsumerRequest(input *AssociateTrackerConsumerInput) (req *request.Request, output *AssociateTrackerConsumerOutput) {
	op := &request.Operation{
		Name:       opAssociateTrackerConsumer,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/consumers",
	}

	if input == nil {
		input = &AssociateTrackerConsumerInput{}
	}

	output = &AssociateTrackerConsumerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssociateTrackerConsumer API operation for Amazon Location Service.
//
// Creates an association between a geofence collection and a tracker resource.
// This allows the tracker resource to communicate location data to the linked
// geofence collection.
//
// You can associate up to five geofence collections to each tracker resource.
//
// Currently not supported — Cross-account configurations, such as creating
// associations between a tracker resource in one account and a geofence collection
// in another account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation AssociateTrackerConsumer for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - ConflictException
//     The request was unsuccessful because of a conflict.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ServiceQuotaExceededException
//     The operation was denied because the request would exceed the maximum quota
//     (https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html)
//     set for Amazon Location Service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/AssociateTrackerConsumer
func (c *LocationService) AssociateTrackerConsumer(input *AssociateTrackerConsumerInput) (*AssociateTrackerConsumerOutput, error) {
	req, out := c.AssociateTrackerConsumerRequest(input)
	return out, req.Send()
}

// AssociateTrackerConsumerWithContext is the same as AssociateTrackerConsumer with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTrackerConsumer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) AssociateTrackerConsumerWithContext(ctx aws.Context, input *AssociateTrackerConsumerInput, opts ...request.Option) (*AssociateTrackerConsumerOutput, error) {
	req, out := c.AssociateTrackerConsumerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteDevicePositionHistory = "BatchDeleteDevicePositionHistory"

// BatchDeleteDevicePositionHistoryRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteDevicePositionHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteDevicePositionHistory for more information on using the BatchDeleteDevicePositionHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteDevicePositionHistoryRequest method.
//	req, resp := client.BatchDeleteDevicePositionHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteDevicePositionHistory
func (c *LocationService) BatchDeleteDevicePositionHistoryRequest(input *BatchDeleteDevicePositionHistoryInput) (req *request.Request, output *BatchDeleteDevicePositionHistoryOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteDevicePositionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/delete-positions",
	}

	if input == nil {
		input = &BatchDeleteDevicePositionHistoryInput{}
	}

	output = &BatchDeleteDevicePositionHistoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchDeleteDevicePositionHistory API operation for Amazon Location Service.
//
// Deletes the position history of one or more devices from a tracker resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchDeleteDevicePositionHistory for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteDevicePositionHistory
func (c *LocationService) BatchDeleteDevicePositionHistory(input *BatchDeleteDevicePositionHistoryInput) (*BatchDeleteDevicePositionHistoryOutput, error) {
	req, out := c.BatchDeleteDevicePositionHistoryRequest(input)
	return out, req.Send()
}

// BatchDeleteDevicePositionHistoryWithContext is the same as BatchDeleteDevicePositionHistory with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteDevicePositionHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchDeleteDevicePositionHistoryWithContext(ctx aws.Context, input *BatchDeleteDevicePositionHistoryInput, opts ...request.Option) (*BatchDeleteDevicePositionHistoryOutput, error) {
	req, out := c.BatchDeleteDevicePositionHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteGeofence = "BatchDeleteGeofence"

// BatchDeleteGeofenceRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteGeofence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteGeofence for more information on using the BatchDeleteGeofence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteGeofenceRequest method.
//	req, resp := client.BatchDeleteGeofenceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteGeofence
func (c *LocationService) BatchDeleteGeofenceRequest(input *BatchDeleteGeofenceInput) (req *request.Request, output *BatchDeleteGeofenceOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteGeofence,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/delete-geofences",
	}

	if input == nil {
		input = &BatchDeleteGeofenceInput{}
	}

	output = &BatchDeleteGeofenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchDeleteGeofence API operation for Amazon Location Service.
//
// Deletes a batch of geofences from a geofence collection.
//
// This operation deletes the resource permanently.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchDeleteGeofence for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteGeofence
func (c *LocationService) BatchDeleteGeofence(input *BatchDeleteGeofenceInput) (*BatchDeleteGeofenceOutput, error) {
	req, out := c.BatchDeleteGeofenceRequest(input)
	return out, req.Send()
}

// BatchDeleteGeofenceWithContext is the same as BatchDeleteGeofence with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteGeofence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchDeleteGeofenceWithContext(ctx aws.Context, input *BatchDeleteGeofenceInput, opts ...request.Option) (*BatchDeleteGeofenceOutput, error) {
	req, out := c.BatchDeleteGeofenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchEvaluateGeofences = "BatchEvaluateGeofences"

// BatchEvaluateGeofencesRequest generates a "aws/request.Request" representing the
// client's request for the BatchEvaluateGeofences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchEvaluateGeofences for more information on using the BatchEvaluateGeofences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchEvaluateGeofencesRequest method.
//	req, resp := client.BatchEvaluateGeofencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchEvaluateGeofences
func (c *LocationService) BatchEvaluateGeofencesRequest(input *BatchEvaluateGeofencesInput) (req *request.Request, output *BatchEvaluateGeofencesOutput) {
	op := &request.Operation{
		Name:       opBatchEvaluateGeofences,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/positions",
	}

	if input == nil {
		input = &BatchEvaluateGeofencesInput{}
	}

	output = &BatchEvaluateGeofencesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchEvaluateGeofences API operation for Amazon Location Service.
//
// Evaluates device positions against the geofence geometries from a given geofence
// collection.
//
// This operation always returns an empty response because geofences are asynchronously
// evaluated. The evaluation determines if the device has entered or exited
// a geofenced area, and then publishes one of the following events to Amazon
// EventBridge:
//
//   - ENTER if Amazon Location determines that the tracked device has entered
//     a geofenced area.
//
//   - EXIT if Amazon Location determines that the tracked device has exited
//     a geofenced area.
//
// The last geofence that a device was observed within is tracked for 30 days
// after the most recent device position update.
//
// Geofence evaluation uses the given device position. It does not account for
// the optional Accuracy of a DevicePositionUpdate.
//
// The DeviceID is used as a string to represent the device. You do not need
// to have a Tracker associated with the DeviceID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchEvaluateGeofences for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchEvaluateGeofences
func (c *LocationService) BatchEvaluateGeofences(input *BatchEvaluateGeofencesInput) (*BatchEvaluateGeofencesOutput, error) {
	req, out := c.BatchEvaluateGeofencesRequest(input)
	return out, req.Send()
}

// BatchEvaluateGeofencesWithContext is the same as BatchEvaluateGeofences with the addition of
// the ability to pass a context and additional request options.
//
// See BatchEvaluateGeofences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchEvaluateGeofencesWithContext(ctx aws.Context, input *BatchEvaluateGeofencesInput, opts ...request.Option) (*BatchEvaluateGeofencesOutput, error) {
	req, out := c.BatchEvaluateGeofencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetDevicePosition = "BatchGetDevicePosition"

// BatchGetDevicePositionRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetDevicePosition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetDevicePosition for more information on using the BatchGetDevicePosition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetDevicePositionRequest method.
//	req, resp := client.BatchGetDevicePositionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchGetDevicePosition
func (c *LocationService) BatchGetDevicePositionRequest(input *BatchGetDevicePositionInput) (req *request.Request, output *BatchGetDevicePositionOutput) {
	op := &request.Operation{
		Name:       opBatchGetDevicePosition,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/get-positions",
	}

	if input == nil {
		input = &BatchGetDevicePositionInput{}
	}

	output = &BatchGetDevicePositionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchGetDevicePosition API operation for Amazon Location Service.
//
// Lists the latest device positions for requested devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchGetDevicePosition for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchGetDevicePosition
func (c *LocationService) BatchGetDevicePosition(input *BatchGetDevicePositionInput) (*BatchGetDevicePositionOutput, error) {
	req, out := c.BatchGetDevicePositionRequest(input)
	return out, req.Send()
}

// BatchGetDevicePositionWithContext is the same as BatchGetDevicePosition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetDevicePosition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchGetDevicePositionWithContext(ctx aws.Context, input *BatchGetDevicePositionInput, opts ...request.Option) (*BatchGetDevicePositionOutput, error) {
	req, out := c.BatchGetDevicePositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutGeofence = "BatchPutGeofence"

// BatchPutGeofenceRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutGeofence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutGeofence for more information on using the BatchPutGeofence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchPutGeofenceRequest method.
//	req, resp := client.BatchPutGeofenceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchPutGeofence
func (c *LocationService) BatchPutGeofenceRequest(input *BatchPutGeofenceInput) (req *request.Request, output *BatchPutGeofenceOutput) {
	op := &request.Operation{
		Name:       opBatchPutGeofence,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/put-geofences",
	}

	if input == nil {
		input = &BatchPutGeofenceInput{}
	}

	output = &BatchPutGeofenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchPutGeofence API operation for Amazon Location Service.
//
// A batch request for storing geofence geometries into a given geofence collection,
// or updates the geometry of an existing geofence if a geofence ID is included
// in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchPutGeofence for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchPutGeofence
func (c *LocationService) BatchPutGeofence(input *BatchPutGeofenceInput) (*BatchPutGeofenceOutput, error) {
	req, out := c.BatchPutGeofenceRequest(input)
	return out, req.Send()
}

// BatchPutGeofenceWithContext is the same as BatchPutGeofence with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutGeofence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchPutGeofenceWithContext(ctx aws.Context, input *BatchPutGeofenceInput, opts ...request.Option) (*BatchPutGeofenceOutput, error) {
	req, out := c.BatchPutGeofenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateDevicePosition = "BatchUpdateDevicePosition"

// BatchUpdateDevicePositionRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateDevicePosition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateDevicePosition for more information on using the BatchUpdateDevicePosition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateDevicePositionRequest method.
//	req, resp := client.BatchUpdateDevicePositionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchUpdateDevicePosition
func (c *LocationService) BatchUpdateDevicePositionRequest(input *BatchUpdateDevicePositionInput) (req *request.Request, output *BatchUpdateDevicePositionOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateDevicePosition,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/positions",
	}

	if input == nil {
		input = &BatchUpdateDevicePositionInput{}
	}

	output = &BatchUpdateDevicePositionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchUpdateDevicePosition API operation for Amazon Location Service.
//
// Uploads position update data for one or more devices to a tracker resource
// (up to 10 devices per batch). Amazon Location uses the data when it reports
// the last known device position and position history. Amazon Location retains
// location data for 30 days.
//
// Position updates are handled based on the PositionFiltering property of the
// tracker. When PositionFiltering is set to TimeBased, updates are evaluated
// against linked geofence collections, and location data is stored at a maximum
// of one position per 30 second interval. If your update frequency is more
// often than every 30 seconds, only one update per 30 seconds is stored for
// each unique device ID.
//
// When PositionFiltering is set to DistanceBased filtering, location data is
// stored and evaluated against linked geofence collections only if the device
// has moved more than 30 m (98.4 ft).
//
// When PositionFiltering is set to AccuracyBased filtering, location data is
// stored and evaluated against linked geofence collections only if the device
// has moved more than the measured accuracy. For example, if two consecutive
// updates from a device have a horizontal accuracy of 5 m and 10 m, the second
// update is neither stored or evaluated if the device has moved less than 15
// m. If PositionFiltering is set to AccuracyBased filtering, Amazon Location
// uses the default value { "Horizontal": 0} when accuracy is not provided on
// a DevicePositionUpdate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchUpdateDevicePosition for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchUpdateDevicePosition
func (c *LocationService) BatchUpdateDevicePosition(input *BatchUpdateDevicePositionInput) (*BatchUpdateDevicePositionOutput, error) {
	req, out := c.BatchUpdateDevicePositionRequest(input)
	return out, req.Send()
}

// BatchUpdateDevicePositionWithContext is the same as BatchUpdateDevicePosition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateDevicePosition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchUpdateDevicePositionWithContext(ctx aws.Context, input *BatchUpdateDevicePositionInput, opts ...request.Option) (*BatchUpdateDevicePositionOutput, error) {
	req, out := c.BatchUpdateDevicePositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCalculateRoute = "CalculateRoute"

// CalculateRouteRequest generates a "aws/request.Request" representing the
// client's request for the CalculateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CalculateRoute for more information on using the CalculateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CalculateRouteRequest method.
//	req, resp := client.CalculateRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CalculateRoute
func (c *LocationService) CalculateRouteRequest(input *CalculateRouteInput) (req *request.Request, output *CalculateRouteOutput) {
	op := &request.Operation{
		Name:       opCalculateRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/routes/v0/calculators/{CalculatorName}/calculate/route",
	}

	if input == nil {
		input = &CalculateRouteInput{}
	}

	output = &CalculateRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("routes.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CalculateRoute API operation for Amazon Location Service.
//
// Calculates a route (https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html)
// given the following required parameters: DeparturePosition and DestinationPosition.
// Requires that you first create a route calculator resource (https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
//
// By default, a request that doesn't specify a departure time uses the best
// time of day to travel with the best traffic conditions when calculating the
// route.
//
// Additional options include:
//
//   - Specifying a departure time (https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html)
//     using either DepartureTime or DepartNow. This calculates a route based
//     on predictive traffic data at the given time. You can't specify both DepartureTime
//     and DepartNow in a single request. Specifying both parameters returns
//     a validation error.
//
//   - Specifying a travel mode (https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html)
//     using TravelMode sets the transportation mode used to calculate the routes.
//     This also lets you specify additional route preferences in CarModeOptions
//     if traveling by Car, or TruckModeOptions if traveling by Truck. If you
//     specify walking for the travel mode and your data provider is Esri, the
//     start and destination must be within 40km.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CalculateRoute for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CalculateRoute
func (c *LocationService) CalculateRoute(input *CalculateRouteInput) (*CalculateRouteOutput, error) {
	req, out := c.CalculateRouteRequest(input)
	return out, req.Send()
}

// CalculateRouteWithContext is the same as CalculateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CalculateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CalculateRouteWithContext(ctx aws.Context, input *CalculateRouteInput, opts ...request.Option) (*CalculateRouteOutput, error) {
	req, out := c.CalculateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCalculateRouteMatrix = "CalculateRouteMatrix"

// CalculateRouteMatrixRequest generates a "aws/request.Request" representing the
// client's request for the CalculateRouteMatrix operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CalculateRouteMatrix for more information on using the CalculateRouteMatrix
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CalculateRouteMatrixRequest method.
//	req, resp := client.CalculateRouteMatrixRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CalculateRouteMatrix
func (c *LocationService) CalculateRouteMatrixRequest(input *CalculateRouteMatrixInput) (req *request.Request, output *CalculateRouteMatrixOutput) {
	op := &request.Operation{
		Name:       opCalculateRouteMatrix,
		HTTPMethod: "POST",
		HTTPPath:   "/routes/v0/calculators/{CalculatorName}/calculate/route-matrix",
	}

	if input == nil {
		input = &CalculateRouteMatrixInput{}
	}

	output = &CalculateRouteMatrixOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("routes.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CalculateRouteMatrix API operation for Amazon Location Service.
//
//	Calculates a route matrix (https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html)
//	given the following required parameters: DeparturePositions and DestinationPositions.
//	CalculateRouteMatrix calculates routes and returns the travel time and travel
//	distance from each departure position to each destination position in the
//	request. For example, given departure positions A and B, and destination
//	positions X and Y, CalculateRouteMatrix will return time and distance for
//	routes from A to X, A to Y, B to X, and B to Y (in that order). The number
//	of results returned (and routes calculated) will be the number of DeparturePositions
//	times the number of DestinationPositions.
//
// Your account is charged for each route calculated, not the number of requests.
//
// Requires that you first create a route calculator resource (https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
//
// By default, a request that doesn't specify a departure time uses the best
// time of day to travel with the best traffic conditions when calculating routes.
//
// Additional options include:
//
//   - Specifying a departure time (https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html)
//     using either DepartureTime or DepartNow. This calculates routes based
//     on predictive traffic data at the given time. You can't specify both DepartureTime
//     and DepartNow in a single request. Specifying both parameters returns
//     a validation error.
//
//   - Specifying a travel mode (https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html)
//     using TravelMode sets the transportation mode used to calculate the routes.
//     This also lets you specify additional route preferences in CarModeOptions
//     if traveling by Car, or TruckModeOptions if traveling by Truck.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CalculateRouteMatrix for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CalculateRouteMatrix
func (c *LocationService) CalculateRouteMatrix(input *CalculateRouteMatrixInput) (*CalculateRouteMatrixOutput, error) {
	req, out := c.CalculateRouteMatrixRequest(input)
	return out, req.Send()
}

// CalculateRouteMatrixWithContext is the same as CalculateRouteMatrix with the addition of
// the ability to pass a context and additional request options.
//
// See CalculateRouteMatrix for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CalculateRouteMatrixWithContext(ctx aws.Context, input *CalculateRouteMatrixInput, opts ...request.Option) (*CalculateRouteMatrixOutput, error) {
	req, out := c.CalculateRouteMatrixRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGeofenceCollection = "CreateGeofenceCollection"

// CreateGeofenceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateGeofenceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGeofenceCollection for more information on using the CreateGeofenceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGeofenceCollectionRequest method.
//	req, resp := client.CreateGeofenceCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateGeofenceCollection
func (c *LocationService) CreateGeofenceCollectionRequest(input *CreateGeofenceCollectionInput) (req *request.Request, output *CreateGeofenceCollectionOutput) {
	op := &request.Operation{
		Name:       opCreateGeofenceCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/collections",
	}

	if input == nil {
		input = &CreateGeofenceCollectionInput{}
	}

	output = &CreateGeofenceCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateGeofenceCollection API operation for Amazon Location Service.
//
// Creates a geofence collection, which manages and stores geofences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CreateGeofenceCollection for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ConflictException
//     The request was unsuccessful because of a conflict.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ServiceQuotaExceededException
//     The operation was denied because the request would exceed the maximum quota
//     (https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html)
//     set for Amazon Location Service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateGeofenceCollection
func (c *LocationService) CreateGeofenceCollection(input *CreateGeofenceCollectionInput) (*CreateGeofenceCollectionOutput, error) {
	req, out := c.CreateGeofenceCollectionRequest(input)
	return out, req.Send()
}

// CreateGeofenceCollectionWithContext is the same as CreateGeofenceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGeofenceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CreateGeofenceCollectionWithContext(ctx aws.Context, input *CreateGeofenceCollectionInput, opts ...request.Option) (*CreateGeofenceCollectionOutput, error) {
	req, out := c.CreateGeofenceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKey = "CreateKey"

// CreateKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKey for more information on using the CreateKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKeyRequest method.
//	req, resp := client.CreateKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateKey
func (c *LocationService) CreateKeyRequest(input *CreateKeyInput) (req *request.Request, output *CreateKeyOutput) {
	op := &request.Operation{
		Name:       opCreateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/metadata/v0/keys",
	}

	if input == nil {
		input = &CreateKeyInput{}
	}

	output = &CreateKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.metadata.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateKey API operation for Amazon Location Service.
//
// Creates an API key resource in your Amazon Web Services account, which lets
// you grant actions for Amazon Location resources to the API key bearer.
//
// For more information, see Using API keys (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CreateKey for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ConflictException
//     The request was unsuccessful because of a conflict.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ServiceQuotaExceededException
//     The operation was denied because the request would exceed the maximum quota
//     (https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html)
//     set for Amazon Location Service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateKey
func (c *LocationService) CreateKey(input *CreateKeyInput) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	return out, req.Send()
}

// CreateKeyWithContext is the same as CreateKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CreateKeyWithContext(ctx aws.Context, input *CreateKeyInput, opts ...request.Option) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMap = "CreateMap"

// CreateMapRequest generates a "aws/request.Request" representing the
// client's request for the CreateMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMap for more information on using the CreateMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMapRequest method.
//	req, resp := client.CreateMapRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateMap
func (c *LocationService) CreateMapRequest(input *CreateMapInput) (req *request.Request, output *CreateMapOutput) {
	op := &request.Operation{
		Name:       opCreateMap,
		HTTPMethod: "POST",
		HTTPPath:   "/maps/v0/maps",
	}

	if input == nil {
		input = &CreateMapInput{}
	}

	output = &CreateMapOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateMap API operation for Amazon Location Service.
//
// Creates a map resource in your Amazon Web Services account, which provides
// map tiles of different styles sourced from global location data providers.
//
// If your application is tracking or routing assets you use in your business,
// such as delivery vehicles or employees, you must not use Esri as your geolocation
// provider. See section 82 of the Amazon Web Services service terms (http://aws.amazon.com/service-terms)
// for more details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CreateMap for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ConflictException
//     The request was unsuccessful because of a conflict.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ServiceQuotaExceededException
//     The operation was denied because the request would exceed the maximum quota
//     (https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html)
//     set for Amazon Location Service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateMap
func (c *LocationService) CreateMap(input *CreateMapInput) (*CreateMapOutput, error) {
	req, out := c.CreateMapRequest(input)
	return out, req.Send()
}

// CreateMapWithContext is the same as CreateMap with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CreateMapWithContext(ctx aws.Context, input *CreateMapInput, opts ...request.Option) (*CreateMapOutput, error) {
	req, out := c.CreateMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlaceIndex = "CreatePlaceIndex"

// CreatePlaceIndexRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlaceIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlaceIndex for more information on using the CreatePlaceIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePlaceIndexRequest method.
//	req, resp := client.CreatePlaceIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreatePlaceIndex
func (c *LocationService) CreatePlaceIndexRequest(input *CreatePlaceIndexInput) (req *request.Request, output *CreatePlaceIndexOutput) {
	op := &request.Operation{
		Name:       opCreatePlaceIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/places/v0/indexes",
	}

	if input == nil {
		input = &CreatePlaceIndexInput{}
	}

	output = &CreatePlaceIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreatePlaceIndex API operation for Amazon Location Service.
//
// Creates a place index resource in your Amazon Web Services account. Use a
// place index resource to geocode addresses and other text queries by using
// the SearchPlaceIndexForText operation, and reverse geocode coordinates by
// using the SearchPlaceIndexForPosition operation, and enable autosuggestions
// by using the SearchPlaceIndexForSuggestions operation.
//
// If your application is tracking or routing assets you use in your business,
// such as delivery vehicles or employees, you must not use Esri as your geolocation
// provider. See section 82 of the Amazon Web Services service terms (http://aws.amazon.com/service-terms)
// for more details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CreatePlaceIndex for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ConflictException
//     The request was unsuccessful because of a conflict.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ServiceQuotaExceededException
//     The operation was denied because the request would exceed the maximum quota
//     (https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html)
//     set for Amazon Location Service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreatePlaceIndex
func (c *LocationService) CreatePlaceIndex(input *CreatePlaceIndexInput) (*CreatePlaceIndexOutput, error) {
	req, out := c.CreatePlaceIndexRequest(input)
	return out, req.Send()
}

// CreatePlaceIndexWithContext is the same as CreatePlaceIndex with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlaceIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CreatePlaceIndexWithContext(ctx aws.Context, input *CreatePlaceIndexInput, opts ...request.Option) (*CreatePlaceIndexOutput, error) {
	req, out := c.CreatePlaceIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRouteCalculator = "CreateRouteCalculator"

// CreateRouteCalculatorRequest generates a "aws/request.Request" representing the
// client's request for the CreateRouteCalculator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRouteCalculator for more information on using the CreateRouteCalculator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRouteCalculatorRequest method.
//	req, resp := client.CreateRouteCalculatorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateRouteCalculator
func (c *LocationService) CreateRouteCalculatorRequest(input *CreateRouteCalculatorInput) (req *request.Request, output *CreateRouteCalculatorOutput) {
	op := &request.Operation{
		Name:       opCreateRouteCalculator,
		HTTPMethod: "POST",
		HTTPPath:   "/routes/v0/calculators",
	}

	if input == nil {
		input = &CreateRouteCalculatorInput{}
	}

	output = &CreateRouteCalculatorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.routes.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateRouteCalculator API operation for Amazon Location Service.
//
// Creates a route calculator resource in your Amazon Web Services account.
//
// You can send requests to a route calculator resource to estimate travel time,
// distance, and get directions. A route calculator sources traffic and road
// network data from your chosen data provider.
//
// If your application is tracking or routing assets you use in your business,
// such as delivery vehicles or employees, you must not use Esri as your geolocation
// provider. See section 82 of the Amazon Web Services service terms (http://aws.amazon.com/service-terms)
// for more details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CreateRouteCalculator for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ConflictException
//     The request was unsuccessful because of a conflict.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ServiceQuotaExceededException
//     The operation was denied because the request would exceed the maximum quota
//     (https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html)
//     set for Amazon Location Service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateRouteCalculator
func (c *LocationService) CreateRouteCalculator(input *CreateRouteCalculatorInput) (*CreateRouteCalculatorOutput, error) {
	req, out := c.CreateRouteCalculatorRequest(input)
	return out, req.Send()
}

// CreateRouteCalculatorWithContext is the same as CreateRouteCalculator with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRouteCalculator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CreateRouteCalculatorWithContext(ctx aws.Context, input *CreateRouteCalculatorInput, opts ...request.Option) (*CreateRouteCalculatorOutput, error) {
	req, out := c.CreateRouteCalculatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTracker = "CreateTracker"

// CreateTrackerRequest generates a "aws/request.Request" representing the
// client's request for the CreateTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTracker for more information on using the CreateTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrackerRequest method.
//	req, resp := client.CreateTrackerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateTracker
func (c *LocationService) CreateTrackerRequest(input *CreateTrackerInput) (req *request.Request, output *CreateTrackerOutput) {
	op := &request.Operation{
		Name:       opCreateTracker,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers",
	}

	if input == nil {
		input = &CreateTrackerInput{}
	}

	output = &CreateTrackerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateTracker API operation for Amazon Location Service.
//
// Creates a tracker resource in your Amazon Web Services account, which lets
// you retrieve current and historical location of devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CreateTracker for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ConflictException
//     The request was unsuccessful because of a conflict.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ServiceQuotaExceededException
//     The operation was denied because the request would exceed the maximum quota
//     (https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html)
//     set for Amazon Location Service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateTracker
func (c *LocationService) CreateTracker(input *CreateTrackerInput) (*CreateTrackerOutput, error) {
	req, out := c.CreateTrackerRequest(input)
	return out, req.Send()
}

// CreateTrackerWithContext is the same as CreateTracker with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CreateTrackerWithContext(ctx aws.Context, input *CreateTrackerInput, opts ...request.Option) (*CreateTrackerOutput, error) {
	req, out := c.CreateTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGeofenceCollection = "DeleteGeofenceCollection"

// DeleteGeofenceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGeofenceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGeofenceCollection for more information on using the DeleteGeofenceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGeofenceCollectionRequest method.
//	req, resp := client.DeleteGeofenceCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteGeofenceCollection
func (c *LocationService) DeleteGeofenceCollectionRequest(input *DeleteGeofenceCollectionInput) (req *request.Request, output *DeleteGeofenceCollectionOutput) {
	op := &request.Operation{
		Name:       opDeleteGeofenceCollection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}",
	}

	if input == nil {
		input = &DeleteGeofenceCollectionInput{}
	}

	output = &DeleteGeofenceCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteGeofenceCollection API operation for Amazon Location Service.
//
// Deletes a geofence collection from your Amazon Web Services account.
//
// This operation deletes the resource permanently. If the geofence collection
// is the target of a tracker resource, the devices will no longer be monitored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DeleteGeofenceCollection for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteGeofenceCollection
func (c *LocationService) DeleteGeofenceCollection(input *DeleteGeofenceCollectionInput) (*DeleteGeofenceCollectionOutput, error) {
	req, out := c.DeleteGeofenceCollectionRequest(input)
	return out, req.Send()
}

// DeleteGeofenceCollectionWithContext is the same as DeleteGeofenceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGeofenceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DeleteGeofenceCollectionWithContext(ctx aws.Context, input *DeleteGeofenceCollectionInput, opts ...request.Option) (*DeleteGeofenceCollectionOutput, error) {
	req, out := c.DeleteGeofenceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKey = "DeleteKey"

// DeleteKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKey for more information on using the DeleteKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKeyRequest method.
//	req, resp := client.DeleteKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteKey
func (c *LocationService) DeleteKeyRequest(input *DeleteKeyInput) (req *request.Request, output *DeleteKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/metadata/v0/keys/{KeyName}",
	}

	if input == nil {
		input = &DeleteKeyInput{}
	}

	output = &DeleteKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.metadata.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteKey API operation for Amazon Location Service.
//
// Deletes the specified API key. The API key must have been deactivated more
// than 90 days previously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DeleteKey for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteKey
func (c *LocationService) DeleteKey(input *DeleteKeyInput) (*DeleteKeyOutput, error) {
	req, out := c.DeleteKeyRequest(input)
	return out, req.Send()
}

// DeleteKeyWithContext is the same as DeleteKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DeleteKeyWithContext(ctx aws.Context, input *DeleteKeyInput, opts ...request.Option) (*DeleteKeyOutput, error) {
	req, out := c.DeleteKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMap = "DeleteMap"

// DeleteMapRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMap for more information on using the DeleteMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMapRequest method.
//	req, resp := client.DeleteMapRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteMap
func (c *LocationService) DeleteMapRequest(input *DeleteMapInput) (req *request.Request, output *DeleteMapOutput) {
	op := &request.Operation{
		Name:       opDeleteMap,
		HTTPMethod: "DELETE",
		HTTPPath:   "/maps/v0/maps/{MapName}",
	}

	if input == nil {
		input = &DeleteMapInput{}
	}

	output = &DeleteMapOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteMap API operation for Amazon Location Service.
//
// Deletes a map resource from your Amazon Web Services account.
//
// This operation deletes the resource permanently. If the map is being used
// in an application, the map may not render.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DeleteMap for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteMap
func (c *LocationService) DeleteMap(input *DeleteMapInput) (*DeleteMapOutput, error) {
	req, out := c.DeleteMapRequest(input)
	return out, req.Send()
}

// DeleteMapWithContext is the same as DeleteMap with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DeleteMapWithContext(ctx aws.Context, input *DeleteMapInput, opts ...request.Option) (*DeleteMapOutput, error) {
	req, out := c.DeleteMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlaceIndex = "DeletePlaceIndex"

// DeletePlaceIndexRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlaceIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlaceIndex for more information on using the DeletePlaceIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePlaceIndexRequest method.
//	req, resp := client.DeletePlaceIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeletePlaceIndex
func (c *LocationService) DeletePlaceIndexRequest(input *DeletePlaceIndexInput) (req *request.Request, output *DeletePlaceIndexOutput) {
	op := &request.Operation{
		Name:       opDeletePlaceIndex,
		HTTPMethod: "DELETE",
		HTTPPath:   "/places/v0/indexes/{IndexName}",
	}

	if input == nil {
		input = &DeletePlaceIndexInput{}
	}

	output = &DeletePlaceIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeletePlaceIndex API operation for Amazon Location Service.
//
// Deletes a place index resource from your Amazon Web Services account.
//
// This operation deletes the resource permanently.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DeletePlaceIndex for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeletePlaceIndex
func (c *LocationService) DeletePlaceIndex(input *DeletePlaceIndexInput) (*DeletePlaceIndexOutput, error) {
	req, out := c.DeletePlaceIndexRequest(input)
	return out, req.Send()
}

// DeletePlaceIndexWithContext is the same as DeletePlaceIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlaceIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DeletePlaceIndexWithContext(ctx aws.Context, input *DeletePlaceIndexInput, opts ...request.Option) (*DeletePlaceIndexOutput, error) {
	req, out := c.DeletePlaceIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRouteCalculator = "DeleteRouteCalculator"

// DeleteRouteCalculatorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRouteCalculator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRouteCalculator for more information on using the DeleteRouteCalculator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRouteCalculatorRequest method.
//	req, resp := client.DeleteRouteCalculatorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteRouteCalculator
func (c *LocationService) DeleteRouteCalculatorRequest(input *DeleteRouteCalculatorInput) (req *request.Request, output *DeleteRouteCalculatorOutput) {
	op := &request.Operation{
		Name:       opDeleteRouteCalculator,
		HTTPMethod: "DELETE",
		HTTPPath:   "/routes/v0/calculators/{CalculatorName}",
	}

	if input == nil {
		input = &DeleteRouteCalculatorInput{}
	}

	output = &DeleteRouteCalculatorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.routes.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteRouteCalculator API operation for Amazon Location Service.
//
// Deletes a route calculator resource from your Amazon Web Services account.
//
// This operation deletes the resource permanently.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DeleteRouteCalculator for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteRouteCalculator
func (c *LocationService) DeleteRouteCalculator(input *DeleteRouteCalculatorInput) (*DeleteRouteCalculatorOutput, error) {
	req, out := c.DeleteRouteCalculatorRequest(input)
	return out, req.Send()
}

// DeleteRouteCalculatorWithContext is the same as DeleteRouteCalculator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRouteCalculator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DeleteRouteCalculatorWithContext(ctx aws.Context, input *DeleteRouteCalculatorInput, opts ...request.Option) (*DeleteRouteCalculatorOutput, error) {
	req, out := c.DeleteRouteCalculatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTracker = "DeleteTracker"

// DeleteTrackerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTracker for more information on using the DeleteTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrackerRequest method.
//	req, resp := client.DeleteTrackerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteTracker
func (c *LocationService) DeleteTrackerRequest(input *DeleteTrackerInput) (req *request.Request, output *DeleteTrackerOutput) {
	op := &request.Operation{
		Name:       opDeleteTracker,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}",
	}

	if input == nil {
		input = &DeleteTrackerInput{}
	}

	output = &DeleteTrackerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteTracker API operation for Amazon Location Service.
//
// Deletes a tracker resource from your Amazon Web Services account.
//
// This operation deletes the resource permanently. If the tracker resource
// is in use, you may encounter an error. Make sure that the target resource
// isn't a dependency for your applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DeleteTracker for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteTracker
func (c *LocationService) DeleteTracker(input *DeleteTrackerInput) (*DeleteTrackerOutput, error) {
	req, out := c.DeleteTrackerRequest(input)
	return out, req.Send()
}

// DeleteTrackerWithContext is the same as DeleteTracker with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DeleteTrackerWithContext(ctx aws.Context, input *DeleteTrackerInput, opts ...request.Option) (*DeleteTrackerOutput, error) {
	req, out := c.DeleteTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGeofenceCollection = "DescribeGeofenceCollection"

// DescribeGeofenceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGeofenceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGeofenceCollection for more information on using the DescribeGeofenceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGeofenceCollectionRequest method.
//	req, resp := client.DescribeGeofenceCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeGeofenceCollection
func (c *LocationService) DescribeGeofenceCollectionRequest(input *DescribeGeofenceCollectionInput) (req *request.Request, output *DescribeGeofenceCollectionOutput) {
	op := &request.Operation{
		Name:       opDescribeGeofenceCollection,
		HTTPMethod: "GET",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}",
	}

	if input == nil {
		input = &DescribeGeofenceCollectionInput{}
	}

	output = &DescribeGeofenceCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeGeofenceCollection API operation for Amazon Location Service.
//
// Retrieves the geofence collection details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DescribeGeofenceCollection for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeGeofenceCollection
func (c *LocationService) DescribeGeofenceCollection(input *DescribeGeofenceCollectionInput) (*DescribeGeofenceCollectionOutput, error) {
	req, out := c.DescribeGeofenceCollectionRequest(input)
	return out, req.Send()
}

// DescribeGeofenceCollectionWithContext is the same as DescribeGeofenceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGeofenceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DescribeGeofenceCollectionWithContext(ctx aws.Context, input *DescribeGeofenceCollectionInput, opts ...request.Option) (*DescribeGeofenceCollectionOutput, error) {
	req, out := c.DescribeGeofenceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeKey = "DescribeKey"

// DescribeKeyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeKey for more information on using the DescribeKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeKeyRequest method.
//	req, resp := client.DescribeKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeKey
func (c *LocationService) DescribeKeyRequest(input *DescribeKeyInput) (req *request.Request, output *DescribeKeyOutput) {
	op := &request.Operation{
		Name:       opDescribeKey,
		HTTPMethod: "GET",
		HTTPPath:   "/metadata/v0/keys/{KeyName}",
	}

	if input == nil {
		input = &DescribeKeyInput{}
	}

	output = &DescribeKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.metadata.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeKey API operation for Amazon Location Service.
//
// Retrieves the API key resource details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DescribeKey for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeKey
func (c *LocationService) DescribeKey(input *DescribeKeyInput) (*DescribeKeyOutput, error) {
	req, out := c.DescribeKeyRequest(input)
	return out, req.Send()
}

// DescribeKeyWithContext is the same as DescribeKey with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DescribeKeyWithContext(ctx aws.Context, input *DescribeKeyInput, opts ...request.Option) (*DescribeKeyOutput, error) {
	req, out := c.DescribeKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMap = "DescribeMap"

// DescribeMapRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMap for more information on using the DescribeMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMapRequest method.
//	req, resp := client.DescribeMapRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeMap
func (c *LocationService) DescribeMapRequest(input *DescribeMapInput) (req *request.Request, output *DescribeMapOutput) {
	op := &request.Operation{
		Name:       opDescribeMap,
		HTTPMethod: "GET",
		HTTPPath:   "/maps/v0/maps/{MapName}",
	}

	if input == nil {
		input = &DescribeMapInput{}
	}

	output = &DescribeMapOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeMap API operation for Amazon Location Service.
//
// Retrieves the map resource details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DescribeMap for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeMap
func (c *LocationService) DescribeMap(input *DescribeMapInput) (*DescribeMapOutput, error) {
	req, out := c.DescribeMapRequest(input)
	return out, req.Send()
}

// DescribeMapWithContext is the same as DescribeMap with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DescribeMapWithContext(ctx aws.Context, input *DescribeMapInput, opts ...request.Option) (*DescribeMapOutput, error) {
	req, out := c.DescribeMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePlaceIndex = "DescribePlaceIndex"

// DescribePlaceIndexRequest generates a "aws/request.Request" representing the
// client's request for the DescribePlaceIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePlaceIndex for more information on using the DescribePlaceIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePlaceIndexRequest method.
//	req, resp := client.DescribePlaceIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribePlaceIndex
func (c *LocationService) DescribePlaceIndexRequest(input *DescribePlaceIndexInput) (req *request.Request, output *DescribePlaceIndexOutput) {
	op := &request.Operation{
		Name:       opDescribePlaceIndex,
		HTTPMethod: "GET",
		HTTPPath:   "/places/v0/indexes/{IndexName}",
	}

	if input == nil {
		input = &DescribePlaceIndexInput{}
	}

	output = &DescribePlaceIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribePlaceIndex API operation for Amazon Location Service.
//
// Retrieves the place index resource details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DescribePlaceIndex for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribePlaceIndex
func (c *LocationService) DescribePlaceIndex(input *DescribePlaceIndexInput) (*DescribePlaceIndexOutput, error) {
	req, out := c.DescribePlaceIndexRequest(input)
	return out, req.Send()
}

// DescribePlaceIndexWithContext is the same as DescribePlaceIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePlaceIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DescribePlaceIndexWithContext(ctx aws.Context, input *DescribePlaceIndexInput, opts ...request.Option) (*DescribePlaceIndexOutput, error) {
	req, out := c.DescribePlaceIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRouteCalculator = "DescribeRouteCalculator"

// DescribeRouteCalculatorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRouteCalculator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRouteCalculator for more information on using the DescribeRouteCalculator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRouteCalculatorRequest method.
//	req, resp := client.DescribeRouteCalculatorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeRouteCalculator
func (c *LocationService) DescribeRouteCalculatorRequest(input *DescribeRouteCalculatorInput) (req *request.Request, output *DescribeRouteCalculatorOutput) {
	op := &request.Operation{
		Name:       opDescribeRouteCalculator,
		HTTPMethod: "GET",
		HTTPPath:   "/routes/v0/calculators/{CalculatorName}",
	}

	if input == nil {
		input = &DescribeRouteCalculatorInput{}
	}

	output = &DescribeRouteCalculatorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.routes.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeRouteCalculator API operation for Amazon Location Service.
//
// Retrieves the route calculator resource details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DescribeRouteCalculator for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeRouteCalculator
func (c *LocationService) DescribeRouteCalculator(input *DescribeRouteCalculatorInput) (*DescribeRouteCalculatorOutput, error) {
	req, out := c.DescribeRouteCalculatorRequest(input)
	return out, req.Send()
}

// DescribeRouteCalculatorWithContext is the same as DescribeRouteCalculator with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRouteCalculator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DescribeRouteCalculatorWithContext(ctx aws.Context, input *DescribeRouteCalculatorInput, opts ...request.Option) (*DescribeRouteCalculatorOutput, error) {
	req, out := c.DescribeRouteCalculatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTracker = "DescribeTracker"

// DescribeTrackerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTracker for more information on using the DescribeTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTrackerRequest method.
//	req, resp := client.DescribeTrackerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeTracker
func (c *LocationService) DescribeTrackerRequest(input *DescribeTrackerInput) (req *request.Request, output *DescribeTrackerOutput) {
	op := &request.Operation{
		Name:       opDescribeTracker,
		HTTPMethod: "GET",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}",
	}

	if input == nil {
		input = &DescribeTrackerInput{}
	}

	output = &DescribeTrackerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeTracker API operation for Amazon Location Service.
//
// Retrieves the tracker resource details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DescribeTracker for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeTracker
func (c *LocationService) DescribeTracker(input *DescribeTrackerInput) (*DescribeTrackerOutput, error) {
	req, out := c.DescribeTrackerRequest(input)
	return out, req.Send()
}

// DescribeTrackerWithContext is the same as DescribeTracker with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DescribeTrackerWithContext(ctx aws.Context, input *DescribeTrackerInput, opts ...request.Option) (*DescribeTrackerOutput, error) {
	req, out := c.DescribeTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateTrackerConsumer = "DisassociateTrackerConsumer"

// DisassociateTrackerConsumerRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateTrackerConsumer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateTrackerConsumer for more information on using the DisassociateTrackerConsumer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateTrackerConsumerRequest method.
//	req, resp := client.DisassociateTrackerConsumerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DisassociateTrackerConsumer
func (c *LocationService) DisassociateTrackerConsumerRequest(input *DisassociateTrackerConsumerInput) (req *request.Request, output *DisassociateTrackerConsumerOutput) {
	op := &request.Operation{
		Name:       opDisassociateTrackerConsumer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/consumers/{ConsumerArn}",
	}

	if input == nil {
		input = &DisassociateTrackerConsumerInput{}
	}

	output = &DisassociateTrackerConsumerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DisassociateTrackerConsumer API operation for Amazon Location Service.
//
// Removes the association between a tracker resource and a geofence collection.
//
// Once you unlink a tracker resource from a geofence collection, the tracker
// positions will no longer be automatically evaluated against geofences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DisassociateTrackerConsumer for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DisassociateTrackerConsumer
func (c *LocationService) DisassociateTrackerConsumer(input *DisassociateTrackerConsumerInput) (*DisassociateTrackerConsumerOutput, error) {
	req, out := c.DisassociateTrackerConsumerRequest(input)
	return out, req.Send()
}

// DisassociateTrackerConsumerWithContext is the same as DisassociateTrackerConsumer with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateTrackerConsumer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DisassociateTrackerConsumerWithContext(ctx aws.Context, input *DisassociateTrackerConsumerInput, opts ...request.Option) (*DisassociateTrackerConsumerOutput, error) {
	req, out := c.DisassociateTrackerConsumerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevicePosition = "GetDevicePosition"

// GetDevicePositionRequest generates a "aws/request.Request" representing the
// client's request for the GetDevicePosition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevicePosition for more information on using the GetDevicePosition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDevicePositionRequest method.
//	req, resp := client.GetDevicePositionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePosition
func (c *LocationService) GetDevicePositionRequest(input *GetDevicePositionInput) (req *request.Request, output *GetDevicePositionOutput) {
	op := &request.Operation{
		Name:       opGetDevicePosition,
		HTTPMethod: "GET",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/devices/{DeviceId}/positions/latest",
	}

	if input == nil {
		input = &GetDevicePositionInput{}
	}

	output = &GetDevicePositionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetDevicePosition API operation for Amazon Location Service.
//
// Retrieves a device's most recent position according to its sample time.
//
// Device positions are deleted after 30 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetDevicePosition for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePosition
func (c *LocationService) GetDevicePosition(input *GetDevicePositionInput) (*GetDevicePositionOutput, error) {
	req, out := c.GetDevicePositionRequest(input)
	return out, req.Send()
}

// GetDevicePositionWithContext is the same as GetDevicePosition with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevicePosition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetDevicePositionWithContext(ctx aws.Context, input *GetDevicePositionInput, opts ...request.Option) (*GetDevicePositionOutput, error) {
	req, out := c.GetDevicePositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevicePositionHistory = "GetDevicePositionHistory"

// GetDevicePositionHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetDevicePositionHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevicePositionHistory for more information on using the GetDevicePositionHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDevicePositionHistoryRequest method.
//	req, resp := client.GetDevicePositionHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory
func (c *LocationService) GetDevicePositionHistoryRequest(input *GetDevicePositionHistoryInput) (req *request.Request, output *GetDevicePositionHistoryOutput) {
	op := &request.Operation{
		Name:       opGetDevicePositionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/devices/{DeviceId}/list-positions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDevicePositionHistoryInput{}
	}

	output = &GetDevicePositionHistoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetDevicePositionHistory API operation for Amazon Location Service.
//
// Retrieves the device position history from a tracker resource within a specified
// range of time.
//
// Device positions are deleted after 30 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetDevicePositionHistory for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory
func (c *LocationService) GetDevicePositionHistory(input *GetDevicePositionHistoryInput) (*GetDevicePositionHistoryOutput, error) {
	req, out := c.GetDevicePositionHistoryRequest(input)
	return out, req.Send()
}

// GetDevicePositionHistoryWithContext is the same as GetDevicePositionHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevicePositionHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetDevicePositionHistoryWithContext(ctx aws.Context, input *GetDevicePositionHistoryInput, opts ...request.Option) (*GetDevicePositionHistoryOutput, error) {
	req, out := c.GetDevicePositionHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDevicePositionHistoryPages iterates over the pages of a GetDevicePositionHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDevicePositionHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetDevicePositionHistory operation.
//	pageNum := 0
//	err := client.GetDevicePositionHistoryPages(params,
//	    func(page *locationservice.GetDevicePositionHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LocationService) GetDevicePositionHistoryPages(input *GetDevicePositionHistoryInput, fn func(*GetDevicePositionHistoryOutput, bool) bool) error {
	return c.GetDevicePositionHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDevicePositionHistoryPagesWithContext same as GetDevicePositionHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetDevicePositionHistoryPagesWithContext(ctx aws.Context, input *GetDevicePositionHistoryInput, fn func(*GetDevicePositionHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDevicePositionHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDevicePositionHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDevicePositionHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetGeofence = "GetGeofence"

// GetGeofenceRequest generates a "aws/request.Request" representing the
// client's request for the GetGeofence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGeofence for more information on using the GetGeofence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGeofenceRequest method.
//	req, resp := client.GetGeofenceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetGeofence
func (c *LocationService) GetGeofenceRequest(input *GetGeofenceInput) (req *request.Request, output *GetGeofenceOutput) {
	op := &request.Operation{
		Name:       opGetGeofence,
		HTTPMethod: "GET",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/geofences/{GeofenceId}",
	}

	if input == nil {
		input = &GetGeofenceInput{}
	}

	output = &GetGeofenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetGeofence API operation for Amazon Location Service.
//
// Retrieves the geofence details from a geofence collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetGeofence for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetGeofence
func (c *LocationService) GetGeofence(input *GetGeofenceInput) (*GetGeofenceOutput, error) {
	req, out := c.GetGeofenceRequest(input)
	return out, req.Send()
}

// GetGeofenceWithContext is the same as GetGeofence with the addition of
// the ability to pass a context and additional request options.
//
// See GetGeofence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetGeofenceWithContext(ctx aws.Context, input *GetGeofenceInput, opts ...request.Option) (*GetGeofenceOutput, error) {
	req, out := c.GetGeofenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMapGlyphs = "GetMapGlyphs"

// GetMapGlyphsRequest generates a "aws/request.Request" representing the
// client's request for the GetMapGlyphs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMapGlyphs for more information on using the GetMapGlyphs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMapGlyphsRequest method.
//	req, resp := client.GetMapGlyphsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapGlyphs
func (c *LocationService) GetMapGlyphsRequest(input *GetMapGlyphsInput) (req *request.Request, output *GetMapGlyphsOutput) {
	op := &request.Operation{
		Name:       opGetMapGlyphs,
		HTTPMethod: "GET",
		HTTPPath:   "/maps/v0/maps/{MapName}/glyphs/{FontStack}/{FontUnicodeRange}",
	}

	if input == nil {
		input = &GetMapGlyphsInput{}
	}

	output = &GetMapGlyphsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetMapGlyphs API operation for Amazon Location Service.
//
// Retrieves glyphs used to display labels on a map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetMapGlyphs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapGlyphs
func (c *LocationService) GetMapGlyphs(input *GetMapGlyphsInput) (*GetMapGlyphsOutput, error) {
	req, out := c.GetMapGlyphsRequest(input)
	return out, req.Send()
}

// GetMapGlyphsWithContext is the same as GetMapGlyphs with the addition of
// the ability to pass a context and additional request options.
//
// See GetMapGlyphs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetMapGlyphsWithContext(ctx aws.Context, input *GetMapGlyphsInput, opts ...request.Option) (*GetMapGlyphsOutput, error) {
	req, out := c.GetMapGlyphsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMapSprites = "GetMapSprites"

// GetMapSpritesRequest generates a "aws/request.Request" representing the
// client's request for the GetMapSprites operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMapSprites for more information on using the GetMapSprites
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMapSpritesRequest method.
//	req, resp := client.GetMapSpritesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapSprites
func (c *LocationService) GetMapSpritesRequest(input *GetMapSpritesInput) (req *request.Request, output *GetMapSpritesOutput) {
	op := &request.Operation{
		Name:       opGetMapSprites,
		HTTPMethod: "GET",
		HTTPPath:   "/maps/v0/maps/{MapName}/sprites/{FileName}",
	}

	if input == nil {
		input = &GetMapSpritesInput{}
	}

	output = &GetMapSpritesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetMapSprites API operation for Amazon Location Service.
//
// Retrieves the sprite sheet corresponding to a map resource. The sprite sheet
// is a PNG image paired with a JSON document describing the offsets of individual
// icons that will be displayed on a rendered map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetMapSprites for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapSprites
func (c *LocationService) GetMapSprites(input *GetMapSpritesInput) (*GetMapSpritesOutput, error) {
	req, out := c.GetMapSpritesRequest(input)
	return out, req.Send()
}

// GetMapSpritesWithContext is the same as GetMapSprites with the addition of
// the ability to pass a context and additional request options.
//
// See GetMapSprites for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetMapSpritesWithContext(ctx aws.Context, input *GetMapSpritesInput, opts ...request.Option) (*GetMapSpritesOutput, error) {
	req, out := c.GetMapSpritesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMapStyleDescriptor = "GetMapStyleDescriptor"

// GetMapStyleDescriptorRequest generates a "aws/request.Request" representing the
// client's request for the GetMapStyleDescriptor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMapStyleDescriptor for more information on using the GetMapStyleDescriptor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMapStyleDescriptorRequest method.
//	req, resp := client.GetMapStyleDescriptorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapStyleDescriptor
func (c *LocationService) GetMapStyleDescriptorRequest(input *GetMapStyleDescriptorInput) (req *request.Request, output *GetMapStyleDescriptorOutput) {
	op := &request.Operation{
		Name:       opGetMapStyleDescriptor,
		HTTPMethod: "GET",
		HTTPPath:   "/maps/v0/maps/{MapName}/style-descriptor",
	}

	if input == nil {
		input = &GetMapStyleDescriptorInput{}
	}

	output = &GetMapStyleDescriptorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetMapStyleDescriptor API operation for Amazon Location Service.
//
// Retrieves the map style descriptor from a map resource.
//
// The style descriptor contains speciﬁcations on how features render on a
// map. For example, what data to display, what order to display the data in,
// and the style for the data. Style descriptors follow the Mapbox Style Specification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetMapStyleDescriptor for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapStyleDescriptor
func (c *LocationService) GetMapStyleDescriptor(input *GetMapStyleDescriptorInput) (*GetMapStyleDescriptorOutput, error) {
	req, out := c.GetMapStyleDescriptorRequest(input)
	return out, req.Send()
}

// GetMapStyleDescriptorWithContext is the same as GetMapStyleDescriptor with the addition of
// the ability to pass a context and additional request options.
//
// See GetMapStyleDescriptor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetMapStyleDescriptorWithContext(ctx aws.Context, input *GetMapStyleDescriptorInput, opts ...request.Option) (*GetMapStyleDescriptorOutput, error) {
	req, out := c.GetMapStyleDescriptorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMapTile = "GetMapTile"

// GetMapTileRequest generates a "aws/request.Request" representing the
// client's request for the GetMapTile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMapTile for more information on using the GetMapTile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMapTileRequest method.
//	req, resp := client.GetMapTileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapTile
func (c *LocationService) GetMapTileRequest(input *GetMapTileInput) (req *request.Request, output *GetMapTileOutput) {
	op := &request.Operation{
		Name:       opGetMapTile,
		HTTPMethod: "GET",
		HTTPPath:   "/maps/v0/maps/{MapName}/tiles/{Z}/{X}/{Y}",
	}

	if input == nil {
		input = &GetMapTileInput{}
	}

	output = &GetMapTileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetMapTile API operation for Amazon Location Service.
//
// Retrieves a vector data tile from the map resource. Map tiles are used by
// clients to render a map. they're addressed using a grid arrangement with
// an X coordinate, Y coordinate, and Z (zoom) level.
//
// The origin (0, 0) is the top left of the map. Increasing the zoom level by
// 1 doubles both the X and Y dimensions, so a tile containing data for the
// entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1,
// 1/1/0, 1/1/1).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetMapTile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapTile
func (c *LocationService) GetMapTile(input *GetMapTileInput) (*GetMapTileOutput, error) {
	req, out := c.GetMapTileRequest(input)
	return out, req.Send()
}

// GetMapTileWithContext is the same as GetMapTile with the addition of
// the ability to pass a context and additional request options.
//
// See GetMapTile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetMapTileWithContext(ctx aws.Context, input *GetMapTileInput, opts ...request.Option) (*GetMapTileOutput, error) {
	req, out := c.GetMapTileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPlace = "GetPlace"

// GetPlaceRequest generates a "aws/request.Request" representing the
// client's request for the GetPlace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPlace for more information on using the GetPlace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPlaceRequest method.
//	req, resp := client.GetPlaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetPlace
func (c *LocationService) GetPlaceRequest(input *GetPlaceInput) (req *request.Request, output *GetPlaceOutput) {
	op := &request.Operation{
		Name:       opGetPlace,
		HTTPMethod: "GET",
		HTTPPath:   "/places/v0/indexes/{IndexName}/places/{PlaceId}",
	}

	if input == nil {
		input = &GetPlaceInput{}
	}

	output = &GetPlaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetPlace API operation for Amazon Location Service.
//
// Finds a place by its unique ID. A PlaceId is returned by other search operations.
//
// A PlaceId is valid only if all of the following are the same in the original
// search request and the call to GetPlace.
//
//   - Customer Amazon Web Services account
//
//   - Amazon Web Services Region
//
//   - Data provider specified in the place index resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetPlace for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetPlace
func (c *LocationService) GetPlace(input *GetPlaceInput) (*GetPlaceOutput, error) {
	req, out := c.GetPlaceRequest(input)
	return out, req.Send()
}

// GetPlaceWithContext is the same as GetPlace with the addition of
// the ability to pass a context and additional request options.
//
// See GetPlace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetPlaceWithContext(ctx aws.Context, input *GetPlaceInput, opts ...request.Option) (*GetPlaceOutput, error) {
	req, out := c.GetPlaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDevicePositions = "ListDevicePositions"

// ListDevicePositionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDevicePositions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevicePositions for more information on using the ListDevicePositions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDevicePositionsRequest method.
//	req, resp := client.ListDevicePositionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListDevicePositions
func (c *LocationService) ListDevicePositionsRequest(input *ListDevicePositionsInput) (req *request.Request, output *ListDevicePositionsOutput) {
	op := &request.Operation{
		Name:       opListDevicePositions,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/list-positions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicePositionsInput{}
	}

	output = &ListDevicePositionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListDevicePositions API operation for Amazon Location Service.
//
// A batch request to retrieve all device positions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListDevicePositions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListDevicePositions
func (c *LocationService) ListDevicePositions(input *ListDevicePositionsInput) (*ListDevicePositionsOutput, error) {
	req, out := c.ListDevicePositionsRequest(input)
	return out, req.Send()
}

// ListDevicePositionsWithContext is the same as ListDevicePositions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevicePositions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListDevicePositionsWithContext(ctx aws.Context, input *ListDevicePositionsInput, opts ...request.Option) (*ListDevicePositionsOutput, error) {
	req, out := c.ListDevicePositionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevicePositionsPages iterates over the pages of a ListDevicePositions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevicePositions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDevicePositions operation.
//	pageNum := 0
//	err := client.ListDevicePositionsPages(params,
//	    func(page *locationservice.ListDevicePositionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LocationService) ListDevicePositionsPages(input *ListDevicePositionsInput, fn func(*ListDevicePositionsOutput, bool) bool) error {
	return c.ListDevicePositionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevicePositionsPagesWithContext same as ListDevicePositionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListDevicePositionsPagesWithContext(ctx aws.Context, input *ListDevicePositionsInput, fn func(*ListDevicePositionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevicePositionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevicePositionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDevicePositionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGeofenceCollections = "ListGeofenceCollections"

// ListGeofenceCollectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListGeofenceCollections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGeofenceCollections for more information on using the ListGeofenceCollections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGeofenceCollectionsRequest method.
//	req, resp := client.ListGeofenceCollectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections
func (c *LocationService) ListGeofenceCollectionsRequest(input *ListGeofenceCollectionsInput) (req *request.Request, output *ListGeofenceCollectionsOutput) {
	op := &request.Operation{
		Name:       opListGeofenceCollections,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/list-collections",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGeofenceCollectionsInput{}
	}

	output = &ListGeofenceCollectionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListGeofenceCollections API operation for Amazon Location Service.
//
// Lists geofence collections in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListGeofenceCollections for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections
func (c *LocationService) ListGeofenceCollections(input *ListGeofenceCollectionsInput) (*ListGeofenceCollectionsOutput, error) {
	req, out := c.ListGeofenceCollectionsRequest(input)
	return out, req.Send()
}

// ListGeofenceCollectionsWithContext is the same as ListGeofenceCollections with the addition of
// the ability to pass a context and additional request options.
//
// See ListGeofenceCollections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListGeofenceCollectionsWithContext(ctx aws.Context, input *ListGeofenceCollectionsInput, opts ...request.Option) (*ListGeofenceCollectionsOutput, error) {
	req, out := c.ListGeofenceCollectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGeofenceCollectionsPages iterates over the pages of a ListGeofenceCollections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGeofenceCollections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGeofenceCollections operation.
//	pageNum := 0
//	err := client.ListGeofenceCollectionsPages(params,
//	    func(page *locationservice.ListGeofenceCollectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LocationService) ListGeofenceCollectionsPages(input *ListGeofenceCollectionsInput, fn func(*ListGeofenceCollectionsOutput, bool) bool) error {
	return c.ListGeofenceCollectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGeofenceCollectionsPagesWithContext same as ListGeofenceCollectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListGeofenceCollectionsPagesWithContext(ctx aws.Context, input *ListGeofenceCollectionsInput, fn func(*ListGeofenceCollectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGeofenceCollectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGeofenceCollectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGeofenceCollectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGeofences = "ListGeofences"

// ListGeofencesRequest generates a "aws/request.Request" representing the
// client's request for the ListGeofences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGeofences for more information on using the ListGeofences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGeofencesRequest method.
//	req, resp := client.ListGeofencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences
func (c *LocationService) ListGeofencesRequest(input *ListGeofencesInput) (req *request.Request, output *ListGeofencesOutput) {
	op := &request.Operation{
		Name:       opListGeofences,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/list-geofences",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGeofencesInput{}
	}

	output = &ListGeofencesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListGeofences API operation for Amazon Location Service.
//
// Lists geofences stored in a given geofence collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListGeofences for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences
func (c *LocationService) ListGeofences(input *ListGeofencesInput) (*ListGeofencesOutput, error) {
	req, out := c.ListGeofencesRequest(input)
	return out, req.Send()
}

// ListGeofencesWithContext is the same as ListGeofences with the addition of
// the ability to pass a context and additional request options.
//
// See ListGeofences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListGeofencesWithContext(ctx aws.Context, input *ListGeofencesInput, opts ...request.Option) (*ListGeofencesOutput, error) {
	req, out := c.ListGeofencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGeofencesPages iterates over the pages of a ListGeofences operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGeofences method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGeofences operation.
//	pageNum := 0
//	err := client.ListGeofencesPages(params,
//	    func(page *locationservice.ListGeofencesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LocationService) ListGeofencesPages(input *ListGeofencesInput, fn func(*ListGeofencesOutput, bool) bool) error {
	return c.ListGeofencesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGeofencesPagesWithContext same as ListGeofencesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListGeofencesPagesWithContext(ctx aws.Context, input *ListGeofencesInput, fn func(*ListGeofencesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGeofencesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGeofencesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGeofencesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKeys = "ListKeys"

// ListKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeys for more information on using the ListKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKeysRequest method.
//	req, resp := client.ListKeysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListKeys
func (c *LocationService) ListKeysRequest(input *ListKeysInput) (req *request.Request, output *ListKeysOutput) {
	op := &request.Operation{
		Name:       opListKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/metadata/v0/list-keys",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeysInput{}
	}

	output = &ListKeysOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.metadata.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListKeys API operation for Amazon Location Service.
//
// Lists API key resources in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListKeys for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListKeys
func (c *LocationService) ListKeys(input *ListKeysInput) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	return out, req.Send()
}

// ListKeysWithContext is the same as ListKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListKeysWithContext(ctx aws.Context, input *ListKeysInput, opts ...request.Option) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKeysPages iterates over the pages of a ListKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKeys operation.
//	pageNum := 0
//	err := client.ListKeysPages(params,
//	    func(page *locationservice.ListKeysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LocationService) ListKeysPages(input *ListKeysInput, fn func(*ListKeysOutput, bool) bool) error {
	return c.ListKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKeysPagesWithContext same as ListKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListKeysPagesWithContext(ctx aws.Context, input *ListKeysInput, fn func(*ListKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMaps = "ListMaps"

// ListMapsRequest generates a "aws/request.Request" representing the
// client's request for the ListMaps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMaps for more information on using the ListMaps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMapsRequest method.
//	req, resp := client.ListMapsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps
func (c *LocationService) ListMapsRequest(input *ListMapsInput) (req *request.Request, output *ListMapsOutput) {
	op := &request.Operation{
		Name:       opListMaps,
		HTTPMethod: "POST",
		HTTPPath:   "/maps/v0/list-maps",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMapsInput{}
	}

	output = &ListMapsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListMaps API operation for Amazon Location Service.
//
// Lists map resources in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListMaps for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps
func (c *LocationService) ListMaps(input *ListMapsInput) (*ListMapsOutput, error) {
	req, out := c.ListMapsRequest(input)
	return out, req.Send()
}

// ListMapsWithContext is the same as ListMaps with the addition of
// the ability to pass a context and additional request options.
//
// See ListMaps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListMapsWithContext(ctx aws.Context, input *ListMapsInput, opts ...request.Option) (*ListMapsOutput, error) {
	req, out := c.ListMapsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMapsPages iterates over the pages of a ListMaps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMaps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMaps operation.
//	pageNum := 0
//	err := client.ListMapsPages(params,
//	    func(page *locationservice.ListMapsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LocationService) ListMapsPages(input *ListMapsInput, fn func(*ListMapsOutput, bool) bool) error {
	return c.ListMapsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMapsPagesWithContext same as ListMapsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListMapsPagesWithContext(ctx aws.Context, input *ListMapsInput, fn func(*ListMapsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMapsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMapsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMapsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPlaceIndexes = "ListPlaceIndexes"

// ListPlaceIndexesRequest generates a "aws/request.Request" representing the
// client's request for the ListPlaceIndexes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlaceIndexes for more information on using the ListPlaceIndexes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPlaceIndexesRequest method.
//	req, resp := client.ListPlaceIndexesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes
func (c *LocationService) ListPlaceIndexesRequest(input *ListPlaceIndexesInput) (req *request.Request, output *ListPlaceIndexesOutput) {
	op := &request.Operation{
		Name:       opListPlaceIndexes,
		HTTPMethod: "POST",
		HTTPPath:   "/places/v0/list-indexes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlaceIndexesInput{}
	}

	output = &ListPlaceIndexesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListPlaceIndexes API operation for Amazon Location Service.
//
// Lists place index resources in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListPlaceIndexes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes
func (c *LocationService) ListPlaceIndexes(input *ListPlaceIndexesInput) (*ListPlaceIndexesOutput, error) {
	req, out := c.ListPlaceIndexesRequest(input)
	return out, req.Send()
}

// ListPlaceIndexesWithContext is the same as ListPlaceIndexes with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlaceIndexes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListPlaceIndexesWithContext(ctx aws.Context, input *ListPlaceIndexesInput, opts ...request.Option) (*ListPlaceIndexesOutput, error) {
	req, out := c.ListPlaceIndexesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPlaceIndexesPages iterates over the pages of a ListPlaceIndexes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlaceIndexes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPlaceIndexes operation.
//	pageNum := 0
//	err := client.ListPlaceIndexesPages(params,
//	    func(page *locationservice.ListPlaceIndexesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LocationService) ListPlaceIndexesPages(input *ListPlaceIndexesInput, fn func(*ListPlaceIndexesOutput, bool) bool) error {
	return c.ListPlaceIndexesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPlaceIndexesPagesWithContext same as ListPlaceIndexesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListPlaceIndexesPagesWithContext(ctx aws.Context, input *ListPlaceIndexesInput, fn func(*ListPlaceIndexesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPlaceIndexesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPlaceIndexesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPlaceIndexesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRouteCalculators = "ListRouteCalculators"

// ListRouteCalculatorsRequest generates a "aws/request.Request" representing the
// client's request for the ListRouteCalculators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRouteCalculators for more information on using the ListRouteCalculators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRouteCalculatorsRequest method.
//	req, resp := client.ListRouteCalculatorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListRouteCalculators
func (c *LocationService) ListRouteCalculatorsRequest(input *ListRouteCalculatorsInput) (req *request.Request, output *ListRouteCalculatorsOutput) {
	op := &request.Operation{
		Name:       opListRouteCalculators,
		HTTPMethod: "POST",
		HTTPPath:   "/routes/v0/list-calculators",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRouteCalculatorsInput{}
	}

	output = &ListRouteCalculatorsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.routes.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListRouteCalculators API operation for Amazon Location Service.
//
// Lists route calculator resources in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListRouteCalculators for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListRouteCalculators
func (c *LocationService) ListRouteCalculators(input *ListRouteCalculatorsInput) (*ListRouteCalculatorsOutput, error) {
	req, out := c.ListRouteCalculatorsRequest(input)
	return out, req.Send()
}

// ListRouteCalculatorsWithContext is the same as ListRouteCalculators with the addition of
// the ability to pass a context and additional request options.
//
// See ListRouteCalculators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListRouteCalculatorsWithContext(ctx aws.Context, input *ListRouteCalculatorsInput, opts ...request.Option) (*ListRouteCalculatorsOutput, error) {
	req, out := c.ListRouteCalculatorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRouteCalculatorsPages iterates over the pages of a ListRouteCalculators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRouteCalculators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRouteCalculators operation.
//	pageNum := 0
//	err := client.ListRouteCalculatorsPages(params,
//	    func(page *locationservice.ListRouteCalculatorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LocationService) ListRouteCalculatorsPages(input *ListRouteCalculatorsInput, fn func(*ListRouteCalculatorsOutput, bool) bool) error {
	return c.ListRouteCalculatorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRouteCalculatorsPagesWithContext same as ListRouteCalculatorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListRouteCalculatorsPagesWithContext(ctx aws.Context, input *ListRouteCalculatorsInput, fn func(*ListRouteCalculatorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRouteCalculatorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRouteCalculatorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRouteCalculatorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTagsForResource
func (c *LocationService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.metadata.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTagsForResource API operation for Amazon Location Service.
//
// Returns a list of tags that are applied to the specified Amazon Location
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTagsForResource
func (c *LocationService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTrackerConsumers = "ListTrackerConsumers"

// ListTrackerConsumersRequest generates a "aws/request.Request" representing the
// client's request for the ListTrackerConsumers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrackerConsumers for more information on using the ListTrackerConsumers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTrackerConsumersRequest method.
//	req, resp := client.ListTrackerConsumersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers
func (c *LocationService) ListTrackerConsumersRequest(input *ListTrackerConsumersInput) (req *request.Request, output *ListTrackerConsumersOutput) {
	op := &request.Operation{
		Name:       opListTrackerConsumers,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/list-consumers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrackerConsumersInput{}
	}

	output = &ListTrackerConsumersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTrackerConsumers API operation for Amazon Location Service.
//
// Lists geofence collections currently associated to the given tracker resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListTrackerConsumers for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers
func (c *LocationService) ListTrackerConsumers(input *ListTrackerConsumersInput) (*ListTrackerConsumersOutput, error) {
	req, out := c.ListTrackerConsumersRequest(input)
	return out, req.Send()
}

// ListTrackerConsumersWithContext is the same as ListTrackerConsumers with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrackerConsumers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListTrackerConsumersWithContext(ctx aws.Context, input *ListTrackerConsumersInput, opts ...request.Option) (*ListTrackerConsumersOutput, error) {
	req, out := c.ListTrackerConsumersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrackerConsumersPages iterates over the pages of a ListTrackerConsumers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrackerConsumers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTrackerConsumers operation.
//	pageNum := 0
//	err := client.ListTrackerConsumersPages(params,
//	    func(page *locationservice.ListTrackerConsumersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LocationService) ListTrackerConsumersPages(input *ListTrackerConsumersInput, fn func(*ListTrackerConsumersOutput, bool) bool) error {
	return c.ListTrackerConsumersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrackerConsumersPagesWithContext same as ListTrackerConsumersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListTrackerConsumersPagesWithContext(ctx aws.Context, input *ListTrackerConsumersInput, fn func(*ListTrackerConsumersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrackerConsumersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrackerConsumersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrackerConsumersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrackers = "ListTrackers"

// ListTrackersRequest generates a "aws/request.Request" representing the
// client's request for the ListTrackers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrackers for more information on using the ListTrackers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTrackersRequest method.
//	req, resp := client.ListTrackersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers
func (c *LocationService) ListTrackersRequest(input *ListTrackersInput) (req *request.Request, output *ListTrackersOutput) {
	op := &request.Operation{
		Name:       opListTrackers,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/list-trackers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrackersInput{}
	}

	output = &ListTrackersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTrackers API operation for Amazon Location Service.
//
// Lists tracker resources in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListTrackers for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers
func (c *LocationService) ListTrackers(input *ListTrackersInput) (*ListTrackersOutput, error) {
	req, out := c.ListTrackersRequest(input)
	return out, req.Send()
}

// ListTrackersWithContext is the same as ListTrackers with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrackers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListTrackersWithContext(ctx aws.Context, input *ListTrackersInput, opts ...request.Option) (*ListTrackersOutput, error) {
	req, out := c.ListTrackersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrackersPages iterates over the pages of a ListTrackers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrackers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTrackers operation.
//	pageNum := 0
//	err := client.ListTrackersPages(params,
//	    func(page *locationservice.ListTrackersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LocationService) ListTrackersPages(input *ListTrackersInput, fn func(*ListTrackersOutput, bool) bool) error {
	return c.ListTrackersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrackersPagesWithContext same as ListTrackersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListTrackersPagesWithContext(ctx aws.Context, input *ListTrackersInput, fn func(*ListTrackersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrackersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrackersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrackersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutGeofence = "PutGeofence"

// PutGeofenceRequest generates a "aws/request.Request" representing the
// client's request for the PutGeofence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutGeofence for more information on using the PutGeofence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutGeofenceRequest method.
//	req, resp := client.PutGeofenceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/PutGeofence
func (c *LocationService) PutGeofenceRequest(input *PutGeofenceInput) (req *request.Request, output *PutGeofenceOutput) {
	op := &request.Operation{
		Name:       opPutGeofence,
		HTTPMethod: "PUT",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/geofences/{GeofenceId}",
	}

	if input == nil {
		input = &PutGeofenceInput{}
	}

	output = &PutGeofenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutGeofence API operation for Amazon Location Service.
//
// Stores a geofence geometry in a given geofence collection, or updates the
// geometry of an existing geofence if a geofence ID is included in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation PutGeofence for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - ConflictException
//     The request was unsuccessful because of a conflict.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/PutGeofence
func (c *LocationService) PutGeofence(input *PutGeofenceInput) (*PutGeofenceOutput, error) {
	req, out := c.PutGeofenceRequest(input)
	return out, req.Send()
}

// PutGeofenceWithContext is the same as PutGeofence with the addition of
// the ability to pass a context and additional request options.
//
// See PutGeofence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) PutGeofenceWithContext(ctx aws.Context, input *PutGeofenceInput, opts ...request.Option) (*PutGeofenceOutput, error) {
	req, out := c.PutGeofenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchPlaceIndexForPosition = "SearchPlaceIndexForPosition"

// SearchPlaceIndexForPositionRequest generates a "aws/request.Request" representing the
// client's request for the SearchPlaceIndexForPosition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchPlaceIndexForPosition for more information on using the SearchPlaceIndexForPosition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchPlaceIndexForPositionRequest method.
//	req, resp := client.SearchPlaceIndexForPositionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForPosition
func (c *LocationService) SearchPlaceIndexForPositionRequest(input *SearchPlaceIndexForPositionInput) (req *request.Request, output *SearchPlaceIndexForPositionOutput) {
	op := &request.Operation{
		Name:       opSearchPlaceIndexForPosition,
		HTTPMethod: "POST",
		HTTPPath:   "/places/v0/indexes/{IndexName}/search/position",
	}

	if input == nil {
		input = &SearchPlaceIndexForPositionInput{}
	}

	output = &SearchPlaceIndexForPositionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SearchPlaceIndexForPosition API operation for Amazon Location Service.
//
// Reverse geocodes a given coordinate and returns a legible address. Allows
// you to search for Places or points of interest near a given position.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation SearchPlaceIndexForPosition for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForPosition
func (c *LocationService) SearchPlaceIndexForPosition(input *SearchPlaceIndexForPositionInput) (*SearchPlaceIndexForPositionOutput, error) {
	req, out := c.SearchPlaceIndexForPositionRequest(input)
	return out, req.Send()
}

// SearchPlaceIndexForPositionWithContext is the same as SearchPlaceIndexForPosition with the addition of
// the ability to pass a context and additional request options.
//
// See SearchPlaceIndexForPosition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) SearchPlaceIndexForPositionWithContext(ctx aws.Context, input *SearchPlaceIndexForPositionInput, opts ...request.Option) (*SearchPlaceIndexForPositionOutput, error) {
	req, out := c.SearchPlaceIndexForPositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchPlaceIndexForSuggestions = "SearchPlaceIndexForSuggestions"

// SearchPlaceIndexForSuggestionsRequest generates a "aws/request.Request" representing the
// client's request for the SearchPlaceIndexForSuggestions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchPlaceIndexForSuggestions for more information on using the SearchPlaceIndexForSuggestions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchPlaceIndexForSuggestionsRequest method.
//	req, resp := client.SearchPlaceIndexForSuggestionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForSuggestions
func (c *LocationService) SearchPlaceIndexForSuggestionsRequest(input *SearchPlaceIndexForSuggestionsInput) (req *request.Request, output *SearchPlaceIndexForSuggestionsOutput) {
	op := &request.Operation{
		Name:       opSearchPlaceIndexForSuggestions,
		HTTPMethod: "POST",
		HTTPPath:   "/places/v0/indexes/{IndexName}/search/suggestions",
	}

	if input == nil {
		input = &SearchPlaceIndexForSuggestionsInput{}
	}

	output = &SearchPlaceIndexForSuggestionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SearchPlaceIndexForSuggestions API operation for Amazon Location Service.
//
// Generates suggestions for addresses and points of interest based on partial
// or misspelled free-form text. This operation is also known as autocomplete,
// autosuggest, or fuzzy matching.
//
// Optional parameters let you narrow your search results by bounding box or
// country, or bias your search toward a specific position on the globe.
//
// You can search for suggested place names near a specified position by using
// BiasPosition, or filter results within a bounding box by using FilterBBox.
// These parameters are mutually exclusive; using both BiasPosition and FilterBBox
// in the same command returns an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation SearchPlaceIndexForSuggestions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForSuggestions
func (c *LocationService) SearchPlaceIndexForSuggestions(input *SearchPlaceIndexForSuggestionsInput) (*SearchPlaceIndexForSuggestionsOutput, error) {
	req, out := c.SearchPlaceIndexForSuggestionsRequest(input)
	return out, req.Send()
}

// SearchPlaceIndexForSuggestionsWithContext is the same as SearchPlaceIndexForSuggestions with the addition of
// the ability to pass a context and additional request options.
//
// See SearchPlaceIndexForSuggestions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) SearchPlaceIndexForSuggestionsWithContext(ctx aws.Context, input *SearchPlaceIndexForSuggestionsInput, opts ...request.Option) (*SearchPlaceIndexForSuggestionsOutput, error) {
	req, out := c.SearchPlaceIndexForSuggestionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchPlaceIndexForText = "SearchPlaceIndexForText"

// SearchPlaceIndexForTextRequest generates a "aws/request.Request" representing the
// client's request for the SearchPlaceIndexForText operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchPlaceIndexForText for more information on using the SearchPlaceIndexForText
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchPlaceIndexForTextRequest method.
//	req, resp := client.SearchPlaceIndexForTextRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForText
func (c *LocationService) SearchPlaceIndexForTextRequest(input *SearchPlaceIndexForTextInput) (req *request.Request, output *SearchPlaceIndexForTextOutput) {
	op := &request.Operation{
		Name:       opSearchPlaceIndexForText,
		HTTPMethod: "POST",
		HTTPPath:   "/places/v0/indexes/{IndexName}/search/text",
	}

	if input == nil {
		input = &SearchPlaceIndexForTextInput{}
	}

	output = &SearchPlaceIndexForTextOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SearchPlaceIndexForText API operation for Amazon Location Service.
//
// Geocodes free-form text, such as an address, name, city, or region to allow
// you to search for Places or points of interest.
//
// Optional parameters let you narrow your search results by bounding box or
// country, or bias your search toward a specific position on the globe.
//
// You can search for places near a given position using BiasPosition, or filter
// results within a bounding box using FilterBBox. Providing both parameters
// simultaneously returns an error.
//
// Search results are returned in order of highest to lowest relevance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation SearchPlaceIndexForText for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForText
func (c *LocationService) SearchPlaceIndexForText(input *SearchPlaceIndexForTextInput) (*SearchPlaceIndexForTextOutput, error) {
	req, out := c.SearchPlaceIndexForTextRequest(input)
	return out, req.Send()
}

// SearchPlaceIndexForTextWithContext is the same as SearchPlaceIndexForText with the addition of
// the ability to pass a context and additional request options.
//
// See SearchPlaceIndexForText for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) SearchPlaceIndexForTextWithContext(ctx aws.Context, input *SearchPlaceIndexForTextInput, opts ...request.Option) (*SearchPlaceIndexForTextOutput, error) {
	req, out := c.SearchPlaceIndexForTextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/TagResource
func (c *LocationService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.metadata.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// TagResource API operation for Amazon Location Service.
//
// Assigns one or more tags (key-value pairs) to the specified Amazon Location
// Service resource.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions, by granting a user permission to access or
// change only resources with certain tag values.
//
// You can use the TagResource operation with an Amazon Location Service resource
// that already has tags. If you specify a new tag key for the resource, this
// tag is appended to the tags already associated with the resource. If you
// specify a tag key that's already associated with the resource, the new tag
// value that you specify replaces the previous value for that tag.
//
// You can associate up to 50 tags with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/TagResource
func (c *LocationService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UntagResource
func (c *LocationService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.metadata.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UntagResource API operation for Amazon Location Service.
//
// Removes one or more tags from the specified Amazon Location resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UntagResource
func (c *LocationService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGeofenceCollection = "UpdateGeofenceCollection"

// UpdateGeofenceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGeofenceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGeofenceCollection for more information on using the UpdateGeofenceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGeofenceCollectionRequest method.
//	req, resp := client.UpdateGeofenceCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateGeofenceCollection
func (c *LocationService) UpdateGeofenceCollectionRequest(input *UpdateGeofenceCollectionInput) (req *request.Request, output *UpdateGeofenceCollectionOutput) {
	op := &request.Operation{
		Name:       opUpdateGeofenceCollection,
		HTTPMethod: "PATCH",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}",
	}

	if input == nil {
		input = &UpdateGeofenceCollectionInput{}
	}

	output = &UpdateGeofenceCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateGeofenceCollection API operation for Amazon Location Service.
//
// Updates the specified properties of a given geofence collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation UpdateGeofenceCollection for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateGeofenceCollection
func (c *LocationService) UpdateGeofenceCollection(input *UpdateGeofenceCollectionInput) (*UpdateGeofenceCollectionOutput, error) {
	req, out := c.UpdateGeofenceCollectionRequest(input)
	return out, req.Send()
}

// UpdateGeofenceCollectionWithContext is the same as UpdateGeofenceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGeofenceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) UpdateGeofenceCollectionWithContext(ctx aws.Context, input *UpdateGeofenceCollectionInput, opts ...request.Option) (*UpdateGeofenceCollectionOutput, error) {
	req, out := c.UpdateGeofenceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKey = "UpdateKey"

// UpdateKeyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKey for more information on using the UpdateKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKeyRequest method.
//	req, resp := client.UpdateKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateKey
func (c *LocationService) UpdateKeyRequest(input *UpdateKeyInput) (req *request.Request, output *UpdateKeyOutput) {
	op := &request.Operation{
		Name:       opUpdateKey,
		HTTPMethod: "PATCH",
		HTTPPath:   "/metadata/v0/keys/{KeyName}",
	}

	if input == nil {
		input = &UpdateKeyInput{}
	}

	output = &UpdateKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.metadata.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateKey API operation for Amazon Location Service.
//
// Updates the specified properties of a given API key resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation UpdateKey for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateKey
func (c *LocationService) UpdateKey(input *UpdateKeyInput) (*UpdateKeyOutput, error) {
	req, out := c.UpdateKeyRequest(input)
	return out, req.Send()
}

// UpdateKeyWithContext is the same as UpdateKey with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) UpdateKeyWithContext(ctx aws.Context, input *UpdateKeyInput, opts ...request.Option) (*UpdateKeyOutput, error) {
	req, out := c.UpdateKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMap = "UpdateMap"

// UpdateMapRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMap for more information on using the UpdateMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMapRequest method.
//	req, resp := client.UpdateMapRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateMap
func (c *LocationService) UpdateMapRequest(input *UpdateMapInput) (req *request.Request, output *UpdateMapOutput) {
	op := &request.Operation{
		Name:       opUpdateMap,
		HTTPMethod: "PATCH",
		HTTPPath:   "/maps/v0/maps/{MapName}",
	}

	if input == nil {
		input = &UpdateMapInput{}
	}

	output = &UpdateMapOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateMap API operation for Amazon Location Service.
//
// Updates the specified properties of a given map resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation UpdateMap for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateMap
func (c *LocationService) UpdateMap(input *UpdateMapInput) (*UpdateMapOutput, error) {
	req, out := c.UpdateMapRequest(input)
	return out, req.Send()
}

// UpdateMapWithContext is the same as UpdateMap with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) UpdateMapWithContext(ctx aws.Context, input *UpdateMapInput, opts ...request.Option) (*UpdateMapOutput, error) {
	req, out := c.UpdateMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePlaceIndex = "UpdatePlaceIndex"

// UpdatePlaceIndexRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePlaceIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePlaceIndex for more information on using the UpdatePlaceIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePlaceIndexRequest method.
//	req, resp := client.UpdatePlaceIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdatePlaceIndex
func (c *LocationService) UpdatePlaceIndexRequest(input *UpdatePlaceIndexInput) (req *request.Request, output *UpdatePlaceIndexOutput) {
	op := &request.Operation{
		Name:       opUpdatePlaceIndex,
		HTTPMethod: "PATCH",
		HTTPPath:   "/places/v0/indexes/{IndexName}",
	}

	if input == nil {
		input = &UpdatePlaceIndexInput{}
	}

	output = &UpdatePlaceIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdatePlaceIndex API operation for Amazon Location Service.
//
// Updates the specified properties of a given place index resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation UpdatePlaceIndex for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdatePlaceIndex
func (c *LocationService) UpdatePlaceIndex(input *UpdatePlaceIndexInput) (*UpdatePlaceIndexOutput, error) {
	req, out := c.UpdatePlaceIndexRequest(input)
	return out, req.Send()
}

// UpdatePlaceIndexWithContext is the same as UpdatePlaceIndex with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePlaceIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) UpdatePlaceIndexWithContext(ctx aws.Context, input *UpdatePlaceIndexInput, opts ...request.Option) (*UpdatePlaceIndexOutput, error) {
	req, out := c.UpdatePlaceIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRouteCalculator = "UpdateRouteCalculator"

// UpdateRouteCalculatorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRouteCalculator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRouteCalculator for more information on using the UpdateRouteCalculator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRouteCalculatorRequest method.
//	req, resp := client.UpdateRouteCalculatorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateRouteCalculator
func (c *LocationService) UpdateRouteCalculatorRequest(input *UpdateRouteCalculatorInput) (req *request.Request, output *UpdateRouteCalculatorOutput) {
	op := &request.Operation{
		Name:       opUpdateRouteCalculator,
		HTTPMethod: "PATCH",
		HTTPPath:   "/routes/v0/calculators/{CalculatorName}",
	}

	if input == nil {
		input = &UpdateRouteCalculatorInput{}
	}

	output = &UpdateRouteCalculatorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.routes.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateRouteCalculator API operation for Amazon Location Service.
//
// Updates the specified properties for a given route calculator resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation UpdateRouteCalculator for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateRouteCalculator
func (c *LocationService) UpdateRouteCalculator(input *UpdateRouteCalculatorInput) (*UpdateRouteCalculatorOutput, error) {
	req, out := c.UpdateRouteCalculatorRequest(input)
	return out, req.Send()
}

// UpdateRouteCalculatorWithContext is the same as UpdateRouteCalculator with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRouteCalculator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) UpdateRouteCalculatorWithContext(ctx aws.Context, input *UpdateRouteCalculatorInput, opts ...request.Option) (*UpdateRouteCalculatorOutput, error) {
	req, out := c.UpdateRouteCalculatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTracker = "UpdateTracker"

// UpdateTrackerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTracker for more information on using the UpdateTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTrackerRequest method.
//	req, resp := client.UpdateTrackerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateTracker
func (c *LocationService) UpdateTrackerRequest(input *UpdateTrackerInput) (req *request.Request, output *UpdateTrackerOutput) {
	op := &request.Operation{
		Name:       opUpdateTracker,
		HTTPMethod: "PATCH",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}",
	}

	if input == nil {
		input = &UpdateTrackerInput{}
	}

	output = &UpdateTrackerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("cp.tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateTracker API operation for Amazon Location Service.
//
// Updates the specified properties of a given tracker resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation UpdateTracker for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed to process because of an unknown server error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The resource that you've entered was not found in your AWS account.
//
//   - AccessDeniedException
//     The request was denied because of insufficient access or permissions. Check
//     with an administrator to verify your permissions.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ThrottlingException
//     The request was denied because of request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateTracker
func (c *LocationService) UpdateTracker(input *UpdateTrackerInput) (*UpdateTrackerOutput, error) {
	req, out := c.UpdateTrackerRequest(input)
	return out, req.Send()
}

// UpdateTrackerWithContext is the same as UpdateTracker with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) UpdateTrackerWithContext(ctx aws.Context, input *UpdateTrackerInput, opts ...request.Option) (*UpdateTrackerOutput, error) {
	req, out := c.UpdateTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The request was denied because of insufficient access or permissions. Check
// with an administrator to verify your permissions.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Options for filtering API keys.
type ApiKeyFilter struct {
	_ struct{} `type:"structure"`

	// Filter on Active or Expired API keys.
	KeyStatus *string `type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiKeyFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiKeyFilter) GoString() string {
	return s.String()
}

// SetKeyStatus sets the KeyStatus field's value.
func (s *ApiKeyFilter) SetKeyStatus(v string) *ApiKeyFilter {
	s.KeyStatus = &v
	return s
}

// API Restrictions on the allowed actions, resources, and referers for an API
// key resource.
type ApiKeyRestrictions struct {
	_ struct{} `type:"structure"`

	// A list of allowed actions that an API key resource grants permissions to
	// perform. You must have at least one action for each type of resource. For
	// example, if you have a place resource, you must include at least one place
	// action.
	//
	// The following are valid values for the actions.
	//
	//    * Map actions geo:GetMap* - Allows all actions needed for map rendering.
	//
	//    * Place actions geo:SearchPlaceIndexForText - Allows geocoding. geo:SearchPlaceIndexForPosition
	//    - Allows reverse geocoding. geo:SearchPlaceIndexForSuggestions - Allows
	//    generating suggestions from text. GetPlace - Allows finding a place by
	//    place ID.
	//
	//    * Route actions geo:CalculateRoute - Allows point to point routing. geo:CalculateRouteMatrix
	//    - Allows calculating a matrix of routes.
	//
	// You must use these strings exactly. For example, to provide access to map
	// rendering, the only valid action is geo:GetMap* as an input to the list.
	// ["geo:GetMap*"] is valid but ["geo:GetMapTile"] is not. Similarly, you cannot
	// use ["geo:SearchPlaceIndexFor*"] - you must list each of the Place actions
	// separately.
	//
	// AllowActions is a required field
	AllowActions []*string `min:"1" type:"list" required:"true"`

	// An optional list of allowed HTTP referers for which requests must originate
	// from. Requests using this API key from other domains will not be allowed.
	//
	// Requirements:
	//
	//    * Contain only alphanumeric characters (A–Z, a–z, 0–9) or any symbols
	//    in this list $\-._+!*`(),;/?:@=&
	//
	//    * May contain a percent (%) if followed by 2 hexadecimal digits (A-F,
	//    a-f, 0-9); this is used for URL encoding purposes.
	//
	//    * May contain wildcard characters question mark (?) and asterisk (*).
	//    Question mark (?) will replace any single character (including hexadecimal
	//    digits). Asterisk (*) will replace any multiple characters (including
	//    multiple hexadecimal digits).
	//
	//    * No spaces allowed. For example, https://example.com.
	AllowReferers []*string `min:"1" type:"list"`

	// A list of allowed resource ARNs that a API key bearer can perform actions
	// on.
	//
	//    * The ARN must be the correct ARN for a map, place, or route ARN. You
	//    may include wildcards in the resource-id to match multiple resources of
	//    the same type.
	//
	//    * The resources must be in the same partition, region, and account-id
	//    as the key that is being created.
	//
	//    * Other than wildcards, you must include the full ARN, including the arn,
	//    partition, service, region, account-id and resource-id, delimited by colons
	//    (:).
	//
	//    * No spaces allowed, even with wildcards. For example, arn:aws:geo:region:account-id:map/ExampleMap*.
	//
	// For more information about ARN format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// AllowResources is a required field
	AllowResources []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiKeyRestrictions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiKeyRestrictions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApiKeyRestrictions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApiKeyRestrictions"}
	if s.AllowActions == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowActions"))
	}
	if s.AllowActions != nil && len(s.AllowActions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowActions", 1))
	}
	if s.AllowReferers != nil && len(s.AllowReferers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowReferers", 1))
	}
	if s.AllowResources == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowResources"))
	}
	if s.AllowResources != nil && len(s.AllowResources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowResources", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowActions sets the AllowActions field's value.
func (s *ApiKeyRestrictions) SetAllowActions(v []*string) *ApiKeyRestrictions {
	s.AllowActions = v
	return s
}

// SetAllowReferers sets the AllowReferers field's value.
func (s *ApiKeyRestrictions) SetAllowReferers(v []*string) *ApiKeyRestrictions {
	s.AllowReferers = v
	return s
}

// SetAllowResources sets the AllowResources field's value.
func (s *ApiKeyRestrictions) SetAllowResources(v []*string) *ApiKeyRestrictions {
	s.AllowResources = v
	return s
}

type AssociateTrackerConsumerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the geofence collection to be associated
	// to tracker resource. Used when you need to specify a resource across all
	// Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer
	//
	// ConsumerArn is a required field
	ConsumerArn *string `type:"string" required:"true"`

	// The name of the tracker resource to be associated with a geofence collection.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTrackerConsumerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTrackerConsumerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTrackerConsumerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateTrackerConsumerInput"}
	if s.ConsumerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConsumerArn"))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsumerArn sets the ConsumerArn field's value.
func (s *AssociateTrackerConsumerInput) SetConsumerArn(v string) *AssociateTrackerConsumerInput {
	s.ConsumerArn = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *AssociateTrackerConsumerInput) SetTrackerName(v string) *AssociateTrackerConsumerInput {
	s.TrackerName = &v
	return s
}

type AssociateTrackerConsumerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTrackerConsumerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateTrackerConsumerOutput) GoString() string {
	return s.String()
}

// Contains the tracker resource details.
type BatchDeleteDevicePositionHistoryError struct {
	_ struct{} `type:"structure"`

	// The ID of the device for this position.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// Contains the batch request error details associated with the request.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDevicePositionHistoryError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDevicePositionHistoryError) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *BatchDeleteDevicePositionHistoryError) SetDeviceId(v string) *BatchDeleteDevicePositionHistoryError {
	s.DeviceId = &v
	return s
}

// SetError sets the Error field's value.
func (s *BatchDeleteDevicePositionHistoryError) SetError(v *BatchItemError) *BatchDeleteDevicePositionHistoryError {
	s.Error = v
	return s
}

type BatchDeleteDevicePositionHistoryInput struct {
	_ struct{} `type:"structure"`

	// Devices whose position history you want to delete.
	//
	//    * For example, for two devices: “DeviceIds” : [DeviceId1,DeviceId2]
	//
	// DeviceIds is a required field
	DeviceIds []*string `min:"1" type:"list" required:"true"`

	// The name of the tracker resource to delete the device position history from.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDevicePositionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDevicePositionHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteDevicePositionHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteDevicePositionHistoryInput"}
	if s.DeviceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceIds"))
	}
	if s.DeviceIds != nil && len(s.DeviceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceIds", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceIds sets the DeviceIds field's value.
func (s *BatchDeleteDevicePositionHistoryInput) SetDeviceIds(v []*string) *BatchDeleteDevicePositionHistoryInput {
	s.DeviceIds = v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *BatchDeleteDevicePositionHistoryInput) SetTrackerName(v string) *BatchDeleteDevicePositionHistoryInput {
	s.TrackerName = &v
	return s
}

type BatchDeleteDevicePositionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// Contains error details for each device history that failed to delete.
	//
	// Errors is a required field
	Errors []*BatchDeleteDevicePositionHistoryError `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDevicePositionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDevicePositionHistoryOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteDevicePositionHistoryOutput) SetErrors(v []*BatchDeleteDevicePositionHistoryError) *BatchDeleteDevicePositionHistoryOutput {
	s.Errors = v
	return s
}

// Contains error details for each geofence that failed to delete from the geofence
// collection.
type BatchDeleteGeofenceError struct {
	_ struct{} `type:"structure"`

	// Contains details associated to the batch error.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`

	// The geofence associated with the error message.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteGeofenceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteGeofenceError) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *BatchDeleteGeofenceError) SetError(v *BatchItemError) *BatchDeleteGeofenceError {
	s.Error = v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *BatchDeleteGeofenceError) SetGeofenceId(v string) *BatchDeleteGeofenceError {
	s.GeofenceId = &v
	return s
}

type BatchDeleteGeofenceInput struct {
	_ struct{} `type:"structure"`

	// The geofence collection storing the geofences to be deleted.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// The batch of geofences to be deleted.
	//
	// GeofenceIds is a required field
	GeofenceIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteGeofenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteGeofenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteGeofenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteGeofenceInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.GeofenceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GeofenceIds"))
	}
	if s.GeofenceIds != nil && len(s.GeofenceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeofenceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *BatchDeleteGeofenceInput) SetCollectionName(v string) *BatchDeleteGeofenceInput {
	s.CollectionName = &v
	return s
}

// SetGeofenceIds sets the GeofenceIds field's value.
func (s *BatchDeleteGeofenceInput) SetGeofenceIds(v []*string) *BatchDeleteGeofenceInput {
	s.GeofenceIds = v
	return s
}

type BatchDeleteGeofenceOutput struct {
	_ struct{} `type:"structure"`

	// Contains error details for each geofence that failed to delete.
	//
	// Errors is a required field
	Errors []*BatchDeleteGeofenceError `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteGeofenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteGeofenceOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteGeofenceOutput) SetErrors(v []*BatchDeleteGeofenceError) *BatchDeleteGeofenceOutput {
	s.Errors = v
	return s
}

// Contains error details for each device that failed to evaluate its position
// against the geofences in a given geofence collection.
type BatchEvaluateGeofencesError struct {
	_ struct{} `type:"structure"`

	// The device associated with the position evaluation error.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// Contains details associated to the batch error.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`

	// Specifies a timestamp for when the error occurred in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEvaluateGeofencesError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEvaluateGeofencesError) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *BatchEvaluateGeofencesError) SetDeviceId(v string) *BatchEvaluateGeofencesError {
	s.DeviceId = &v
	return s
}

// SetError sets the Error field's value.
func (s *BatchEvaluateGeofencesError) SetError(v *BatchItemError) *BatchEvaluateGeofencesError {
	s.Error = v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *BatchEvaluateGeofencesError) SetSampleTime(v time.Time) *BatchEvaluateGeofencesError {
	s.SampleTime = &v
	return s
}

type BatchEvaluateGeofencesInput struct {
	_ struct{} `type:"structure"`

	// The geofence collection used in evaluating the position of devices against
	// its geofences.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// Contains device details for each device to be evaluated against the given
	// geofence collection.
	//
	// DevicePositionUpdates is a required field
	DevicePositionUpdates []*DevicePositionUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEvaluateGeofencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEvaluateGeofencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchEvaluateGeofencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchEvaluateGeofencesInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.DevicePositionUpdates == nil {
		invalidParams.Add(request.NewErrParamRequired("DevicePositionUpdates"))
	}
	if s.DevicePositionUpdates != nil && len(s.DevicePositionUpdates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DevicePositionUpdates", 1))
	}
	if s.DevicePositionUpdates != nil {
		for i, v := range s.DevicePositionUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DevicePositionUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *BatchEvaluateGeofencesInput) SetCollectionName(v string) *BatchEvaluateGeofencesInput {
	s.CollectionName = &v
	return s
}

// SetDevicePositionUpdates sets the DevicePositionUpdates field's value.
func (s *BatchEvaluateGeofencesInput) SetDevicePositionUpdates(v []*DevicePositionUpdate) *BatchEvaluateGeofencesInput {
	s.DevicePositionUpdates = v
	return s
}

type BatchEvaluateGeofencesOutput struct {
	_ struct{} `type:"structure"`

	// Contains error details for each device that failed to evaluate its position
	// against the given geofence collection.
	//
	// Errors is a required field
	Errors []*BatchEvaluateGeofencesError `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEvaluateGeofencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEvaluateGeofencesOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchEvaluateGeofencesOutput) SetErrors(v []*BatchEvaluateGeofencesError) *BatchEvaluateGeofencesOutput {
	s.Errors = v
	return s
}

// Contains error details for each device that didn't return a position.
type BatchGetDevicePositionError struct {
	_ struct{} `type:"structure"`

	// The ID of the device that didn't return a position.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// Contains details related to the error code.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDevicePositionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDevicePositionError) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *BatchGetDevicePositionError) SetDeviceId(v string) *BatchGetDevicePositionError {
	s.DeviceId = &v
	return s
}

// SetError sets the Error field's value.
func (s *BatchGetDevicePositionError) SetError(v *BatchItemError) *BatchGetDevicePositionError {
	s.Error = v
	return s
}

type BatchGetDevicePositionInput struct {
	_ struct{} `type:"structure"`

	// Devices whose position you want to retrieve.
	//
	//    * For example, for two devices: device-ids=DeviceId1&device-ids=DeviceId2
	//
	// DeviceIds is a required field
	DeviceIds []*string `min:"1" type:"list" required:"true"`

	// The tracker resource retrieving the device position.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDevicePositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDevicePositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetDevicePositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetDevicePositionInput"}
	if s.DeviceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceIds"))
	}
	if s.DeviceIds != nil && len(s.DeviceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceIds", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceIds sets the DeviceIds field's value.
func (s *BatchGetDevicePositionInput) SetDeviceIds(v []*string) *BatchGetDevicePositionInput {
	s.DeviceIds = v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *BatchGetDevicePositionInput) SetTrackerName(v string) *BatchGetDevicePositionInput {
	s.TrackerName = &v
	return s
}

type BatchGetDevicePositionOutput struct {
	_ struct{} `type:"structure"`

	// Contains device position details such as the device ID, position, and timestamps
	// for when the position was received and sampled.
	//
	// DevicePositions is a required field
	DevicePositions []*DevicePosition `type:"list" required:"true"`

	// Contains error details for each device that failed to send its position to
	// the tracker resource.
	//
	// Errors is a required field
	Errors []*BatchGetDevicePositionError `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDevicePositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDevicePositionOutput) GoString() string {
	return s.String()
}

// SetDevicePositions sets the DevicePositions field's value.
func (s *BatchGetDevicePositionOutput) SetDevicePositions(v []*DevicePosition) *BatchGetDevicePositionOutput {
	s.DevicePositions = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchGetDevicePositionOutput) SetErrors(v []*BatchGetDevicePositionError) *BatchGetDevicePositionOutput {
	s.Errors = v
	return s
}

// Contains the batch request error details associated with the request.
type BatchItemError struct {
	_ struct{} `type:"structure"`

	// The error code associated with the batch request error.
	Code *string `type:"string" enum:"BatchItemErrorCode"`

	// A message with the reason for the batch request error.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchItemError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchItemError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchItemError) SetCode(v string) *BatchItemError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchItemError) SetMessage(v string) *BatchItemError {
	s.Message = &v
	return s
}

// Contains error details for each geofence that failed to be stored in a given
// geofence collection.
type BatchPutGeofenceError struct {
	_ struct{} `type:"structure"`

	// Contains details associated to the batch error.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`

	// The geofence associated with the error message.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutGeofenceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutGeofenceError) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *BatchPutGeofenceError) SetError(v *BatchItemError) *BatchPutGeofenceError {
	s.Error = v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *BatchPutGeofenceError) SetGeofenceId(v string) *BatchPutGeofenceError {
	s.GeofenceId = &v
	return s
}

type BatchPutGeofenceInput struct {
	_ struct{} `type:"structure"`

	// The geofence collection storing the geofences.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// The batch of geofences to be stored in a geofence collection.
	//
	// Entries is a required field
	Entries []*BatchPutGeofenceRequestEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutGeofenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutGeofenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutGeofenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutGeofenceInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *BatchPutGeofenceInput) SetCollectionName(v string) *BatchPutGeofenceInput {
	s.CollectionName = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *BatchPutGeofenceInput) SetEntries(v []*BatchPutGeofenceRequestEntry) *BatchPutGeofenceInput {
	s.Entries = v
	return s
}

type BatchPutGeofenceOutput struct {
	_ struct{} `type:"structure"`

	// Contains additional error details for each geofence that failed to be stored
	// in a geofence collection.
	//
	// Errors is a required field
	Errors []*BatchPutGeofenceError `type:"list" required:"true"`

	// Contains each geofence that was successfully stored in a geofence collection.
	//
	// Successes is a required field
	Successes []*BatchPutGeofenceSuccess `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutGeofenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutGeofenceOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchPutGeofenceOutput) SetErrors(v []*BatchPutGeofenceError) *BatchPutGeofenceOutput {
	s.Errors = v
	return s
}

// SetSuccesses sets the Successes field's value.
func (s *BatchPutGeofenceOutput) SetSuccesses(v []*BatchPutGeofenceSuccess) *BatchPutGeofenceOutput {
	s.Successes = v
	return s
}

// Contains geofence geometry details.
type BatchPutGeofenceRequestEntry struct {
	_ struct{} `type:"structure"`

	// The identifier for the geofence to be stored in a given geofence collection.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`

	// Associates one of more properties with the geofence. A property is a key-value
	// pair stored with the geofence and added to any geofence event triggered with
	// that geofence.
	//
	// Format: "key" : "value"
	//
	// GeofenceProperties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchPutGeofenceRequestEntry's
	// String and GoString methods.
	GeofenceProperties map[string]*string `type:"map" sensitive:"true"`

	// Contains the details of the position of the geofence. Can be either a polygon
	// or a circle. Including both will return a validation error.
	//
	// Each geofence polygon (https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html)
	// can have a maximum of 1,000 vertices.
	//
	// Geometry is a required field
	Geometry *GeofenceGeometry `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutGeofenceRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutGeofenceRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutGeofenceRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutGeofenceRequestEntry"}
	if s.GeofenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeofenceId"))
	}
	if s.GeofenceId != nil && len(*s.GeofenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeofenceId", 1))
	}
	if s.Geometry == nil {
		invalidParams.Add(request.NewErrParamRequired("Geometry"))
	}
	if s.Geometry != nil {
		if err := s.Geometry.Validate(); err != nil {
			invalidParams.AddNested("Geometry", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *BatchPutGeofenceRequestEntry) SetGeofenceId(v string) *BatchPutGeofenceRequestEntry {
	s.GeofenceId = &v
	return s
}

// SetGeofenceProperties sets the GeofenceProperties field's value.
func (s *BatchPutGeofenceRequestEntry) SetGeofenceProperties(v map[string]*string) *BatchPutGeofenceRequestEntry {
	s.GeofenceProperties = v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *BatchPutGeofenceRequestEntry) SetGeometry(v *GeofenceGeometry) *BatchPutGeofenceRequestEntry {
	s.Geometry = v
	return s
}

// Contains a summary of each geofence that was successfully stored in a given
// geofence collection.
type BatchPutGeofenceSuccess struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the geofence was stored in a geofence collection in
	// ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The geofence successfully stored in a geofence collection.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the geofence was last updated in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutGeofenceSuccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutGeofenceSuccess) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *BatchPutGeofenceSuccess) SetCreateTime(v time.Time) *BatchPutGeofenceSuccess {
	s.CreateTime = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *BatchPutGeofenceSuccess) SetGeofenceId(v string) *BatchPutGeofenceSuccess {
	s.GeofenceId = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *BatchPutGeofenceSuccess) SetUpdateTime(v time.Time) *BatchPutGeofenceSuccess {
	s.UpdateTime = &v
	return s
}

// Contains error details for each device that failed to update its position.
type BatchUpdateDevicePositionError struct {
	_ struct{} `type:"structure"`

	// The device associated with the failed location update.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// Contains details related to the error code such as the error code and error
	// message.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`

	// The timestamp at which the device position was determined. Uses ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateDevicePositionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateDevicePositionError) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *BatchUpdateDevicePositionError) SetDeviceId(v string) *BatchUpdateDevicePositionError {
	s.DeviceId = &v
	return s
}

// SetError sets the Error field's value.
func (s *BatchUpdateDevicePositionError) SetError(v *BatchItemError) *BatchUpdateDevicePositionError {
	s.Error = v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *BatchUpdateDevicePositionError) SetSampleTime(v time.Time) *BatchUpdateDevicePositionError {
	s.SampleTime = &v
	return s
}

type BatchUpdateDevicePositionInput struct {
	_ struct{} `type:"structure"`

	// The name of the tracker resource to update.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`

	// Contains the position update details for each device, up to 10 devices.
	//
	// Updates is a required field
	Updates []*DevicePositionUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateDevicePositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateDevicePositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateDevicePositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateDevicePositionInput"}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrackerName sets the TrackerName field's value.
func (s *BatchUpdateDevicePositionInput) SetTrackerName(v string) *BatchUpdateDevicePositionInput {
	s.TrackerName = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *BatchUpdateDevicePositionInput) SetUpdates(v []*DevicePositionUpdate) *BatchUpdateDevicePositionInput {
	s.Updates = v
	return s
}

type BatchUpdateDevicePositionOutput struct {
	_ struct{} `type:"structure"`

	// Contains error details for each device that failed to update its position.
	//
	// Errors is a required field
	Errors []*BatchUpdateDevicePositionError `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateDevicePositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateDevicePositionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchUpdateDevicePositionOutput) SetErrors(v []*BatchUpdateDevicePositionError) *BatchUpdateDevicePositionOutput {
	s.Errors = v
	return s
}

// Contains details about additional route preferences for requests that specify
// TravelMode as Car.
type CalculateRouteCarModeOptions struct {
	_ struct{} `type:"structure"`

	// Avoids ferries when calculating routes.
	//
	// Default Value: false
	//
	// Valid Values: false | true
	AvoidFerries *bool `type:"boolean"`

	// Avoids tolls when calculating routes.
	//
	// Default Value: false
	//
	// Valid Values: false | true
	AvoidTolls *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteCarModeOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteCarModeOptions) GoString() string {
	return s.String()
}

// SetAvoidFerries sets the AvoidFerries field's value.
func (s *CalculateRouteCarModeOptions) SetAvoidFerries(v bool) *CalculateRouteCarModeOptions {
	s.AvoidFerries = &v
	return s
}

// SetAvoidTolls sets the AvoidTolls field's value.
func (s *CalculateRouteCarModeOptions) SetAvoidTolls(v bool) *CalculateRouteCarModeOptions {
	s.AvoidTolls = &v
	return s
}

type CalculateRouteInput struct {
	_ struct{} `type:"structure"`

	// The name of the route calculator resource that you want to use to calculate
	// the route.
	//
	// CalculatorName is a required field
	CalculatorName *string `location:"uri" locationName:"CalculatorName" min:"1" type:"string" required:"true"`

	// Specifies route preferences when traveling by Car, such as avoiding routes
	// that use ferries or tolls.
	//
	// Requirements: TravelMode must be specified as Car.
	CarModeOptions *CalculateRouteCarModeOptions `type:"structure"`

	// Sets the time of departure as the current time. Uses the current time to
	// calculate a route. Otherwise, the best time of day to travel with the best
	// traffic conditions is used to calculate the route.
	//
	// Default Value: false
	//
	// Valid Values: false | true
	DepartNow *bool `type:"boolean"`

	// The start position for the route. Defined in World Geodetic System (WGS 84)
	// (https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format: [longitude,
	// latitude].
	//
	//    * For example, [-123.115, 49.285]
	//
	// If you specify a departure that's not located on a road, Amazon Location
	// moves the position to the nearest road (https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
	// If Esri is the provider for your route calculator, specifying a route that
	// is longer than 400 km returns a 400 RoutesValidationException error.
	//
	// Valid Values: [-180 to 180,-90 to 90]
	//
	// DeparturePosition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CalculateRouteInput's
	// String and GoString methods.
	//
	// DeparturePosition is a required field
	DeparturePosition []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// Specifies the desired time of departure. Uses the given time to calculate
	// the route. Otherwise, the best time of day to travel with the best traffic
	// conditions is used to calculate the route.
	//
	// Setting a departure time in the past returns a 400 ValidationException error.
	//
	//    * In ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	//    format: YYYY-MM-DDThh:mm:ss.sssZ. For example, 2020–07-2T12:15:20.000Z+01:00
	DepartureTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The finish position for the route. Defined in World Geodetic System (WGS
	// 84) (https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format:
	// [longitude, latitude].
	//
	//    * For example, [-122.339, 47.615]
	//
	// If you specify a destination that's not located on a road, Amazon Location
	// moves the position to the nearest road (https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
	//
	// Valid Values: [-180 to 180,-90 to 90]
	//
	// DestinationPosition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CalculateRouteInput's
	// String and GoString methods.
	//
	// DestinationPosition is a required field
	DestinationPosition []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// Set the unit system to specify the distance.
	//
	// Default Value: Kilometers
	DistanceUnit *string `type:"string" enum:"DistanceUnit"`

	// Set to include the geometry details in the result for each path between a
	// pair of positions.
	//
	// Default Value: false
	//
	// Valid Values: false | true
	IncludeLegGeometry *bool `type:"boolean"`

	// The optional API key (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
	// to authorize the request.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CalculateRouteInput's
	// String and GoString methods.
	Key *string `location:"querystring" locationName:"key" type:"string" sensitive:"true"`

	// Specifies the mode of transport when calculating a route. Used in estimating
	// the speed of travel and road compatibility. You can choose Car, Truck, Walking,
	// Bicycle or Motorcycle as options for the TravelMode.
	//
	// Bicycle and Motorcycle are only valid when using Grab as a data provider,
	// and only within Southeast Asia.
	//
	// Truck is not available for Grab.
	//
	// For more details on the using Grab for routing, including areas of coverage,
	// see GrabMaps (https://docs.aws.amazon.com/location/latest/developerguide/grab.html)
	// in the Amazon Location Service Developer Guide.
	//
	// The TravelMode you specify also determines how you specify route preferences:
	//
	//    * If traveling by Car use the CarModeOptions parameter.
	//
	//    * If traveling by Truck use the TruckModeOptions parameter.
	//
	// Default Value: Car
	TravelMode *string `type:"string" enum:"TravelMode"`

	// Specifies route preferences when traveling by Truck, such as avoiding routes
	// that use ferries or tolls, and truck specifications to consider when choosing
	// an optimal road.
	//
	// Requirements: TravelMode must be specified as Truck.
	TruckModeOptions *CalculateRouteTruckModeOptions `type:"structure"`

	// Specifies an ordered list of up to 23 intermediate positions to include along
	// a route between the departure position and destination position.
	//
	//    * For example, from the DeparturePosition [-123.115, 49.285], the route
	//    follows the order that the waypoint positions are given [[-122.757, 49.0021],[-122.349,
	//    47.620]]
	//
	// If you specify a waypoint position that's not located on a road, Amazon Location
	// moves the position to the nearest road (https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
	//
	// Specifying more than 23 waypoints returns a 400 ValidationException error.
	//
	// If Esri is the provider for your route calculator, specifying a route that
	// is longer than 400 km returns a 400 RoutesValidationException error.
	//
	// Valid Values: [-180 to 180,-90 to 90]
	WaypointPositions [][]*float64 `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CalculateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CalculateRouteInput"}
	if s.CalculatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatorName"))
	}
	if s.CalculatorName != nil && len(*s.CalculatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatorName", 1))
	}
	if s.DeparturePosition == nil {
		invalidParams.Add(request.NewErrParamRequired("DeparturePosition"))
	}
	if s.DeparturePosition != nil && len(s.DeparturePosition) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DeparturePosition", 2))
	}
	if s.DestinationPosition == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPosition"))
	}
	if s.DestinationPosition != nil && len(s.DestinationPosition) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationPosition", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalculatorName sets the CalculatorName field's value.
func (s *CalculateRouteInput) SetCalculatorName(v string) *CalculateRouteInput {
	s.CalculatorName = &v
	return s
}

// SetCarModeOptions sets the CarModeOptions field's value.
func (s *CalculateRouteInput) SetCarModeOptions(v *CalculateRouteCarModeOptions) *CalculateRouteInput {
	s.CarModeOptions = v
	return s
}

// SetDepartNow sets the DepartNow field's value.
func (s *CalculateRouteInput) SetDepartNow(v bool) *CalculateRouteInput {
	s.DepartNow = &v
	return s
}

// SetDeparturePosition sets the DeparturePosition field's value.
func (s *CalculateRouteInput) SetDeparturePosition(v []*float64) *CalculateRouteInput {
	s.DeparturePosition = v
	return s
}

// SetDepartureTime sets the DepartureTime field's value.
func (s *CalculateRouteInput) SetDepartureTime(v time.Time) *CalculateRouteInput {
	s.DepartureTime = &v
	return s
}

// SetDestinationPosition sets the DestinationPosition field's value.
func (s *CalculateRouteInput) SetDestinationPosition(v []*float64) *CalculateRouteInput {
	s.DestinationPosition = v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *CalculateRouteInput) SetDistanceUnit(v string) *CalculateRouteInput {
	s.DistanceUnit = &v
	return s
}

// SetIncludeLegGeometry sets the IncludeLegGeometry field's value.
func (s *CalculateRouteInput) SetIncludeLegGeometry(v bool) *CalculateRouteInput {
	s.IncludeLegGeometry = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CalculateRouteInput) SetKey(v string) *CalculateRouteInput {
	s.Key = &v
	return s
}

// SetTravelMode sets the TravelMode field's value.
func (s *CalculateRouteInput) SetTravelMode(v string) *CalculateRouteInput {
	s.TravelMode = &v
	return s
}

// SetTruckModeOptions sets the TruckModeOptions field's value.
func (s *CalculateRouteInput) SetTruckModeOptions(v *CalculateRouteTruckModeOptions) *CalculateRouteInput {
	s.TruckModeOptions = v
	return s
}

// SetWaypointPositions sets the WaypointPositions field's value.
func (s *CalculateRouteInput) SetWaypointPositions(v [][]*float64) *CalculateRouteInput {
	s.WaypointPositions = v
	return s
}

type CalculateRouteMatrixInput struct {
	_ struct{} `type:"structure"`

	// The name of the route calculator resource that you want to use to calculate
	// the route matrix.
	//
	// CalculatorName is a required field
	CalculatorName *string `location:"uri" locationName:"CalculatorName" min:"1" type:"string" required:"true"`

	// Specifies route preferences when traveling by Car, such as avoiding routes
	// that use ferries or tolls.
	//
	// Requirements: TravelMode must be specified as Car.
	CarModeOptions *CalculateRouteCarModeOptions `type:"structure"`

	// Sets the time of departure as the current time. Uses the current time to
	// calculate the route matrix. You can't set both DepartureTime and DepartNow.
	// If neither is set, the best time of day to travel with the best traffic conditions
	// is used to calculate the route matrix.
	//
	// Default Value: false
	//
	// Valid Values: false | true
	DepartNow *bool `type:"boolean"`

	// The list of departure (origin) positions for the route matrix. An array of
	// points, each of which is itself a 2-value array defined in WGS 84 (https://earth-info.nga.mil/GandG/wgs84/index.html)
	// format: [longitude, latitude]. For example, [-123.115, 49.285].
	//
	// Depending on the data provider selected in the route calculator resource
	// there may be additional restrictions on the inputs you can choose. See Position
	// restrictions (https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits)
	// in the Amazon Location Service Developer Guide.
	//
	// For route calculators that use Esri as the data provider, if you specify
	// a departure that's not located on a road, Amazon Location moves the position
	// to the nearest road (https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
	// The snapped value is available in the result in SnappedDeparturePositions.
	//
	// Valid Values: [-180 to 180,-90 to 90]
	//
	// DeparturePositions is a required field
	DeparturePositions [][]*float64 `min:"1" type:"list" required:"true"`

	// Specifies the desired time of departure. Uses the given time to calculate
	// the route matrix. You can't set both DepartureTime and DepartNow. If neither
	// is set, the best time of day to travel with the best traffic conditions is
	// used to calculate the route matrix.
	//
	// Setting a departure time in the past returns a 400 ValidationException error.
	//
	//    * In ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	//    format: YYYY-MM-DDThh:mm:ss.sssZ. For example, 2020–07-2T12:15:20.000Z+01:00
	DepartureTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The list of destination positions for the route matrix. An array of points,
	// each of which is itself a 2-value array defined in WGS 84 (https://earth-info.nga.mil/GandG/wgs84/index.html)
	// format: [longitude, latitude]. For example, [-122.339, 47.615]
	//
	// Depending on the data provider selected in the route calculator resource
	// there may be additional restrictions on the inputs you can choose. See Position
	// restrictions (https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits)
	// in the Amazon Location Service Developer Guide.
	//
	// For route calculators that use Esri as the data provider, if you specify
	// a destination that's not located on a road, Amazon Location moves the position
	// to the nearest road (https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
	// The snapped value is available in the result in SnappedDestinationPositions.
	//
	// Valid Values: [-180 to 180,-90 to 90]
	//
	// DestinationPositions is a required field
	DestinationPositions [][]*float64 `min:"1" type:"list" required:"true"`

	// Set the unit system to specify the distance.
	//
	// Default Value: Kilometers
	DistanceUnit *string `type:"string" enum:"DistanceUnit"`

	// The optional API key (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
	// to authorize the request.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CalculateRouteMatrixInput's
	// String and GoString methods.
	Key *string `location:"querystring" locationName:"key" type:"string" sensitive:"true"`

	// Specifies the mode of transport when calculating a route. Used in estimating
	// the speed of travel and road compatibility.
	//
	// The TravelMode you specify also determines how you specify route preferences:
	//
	//    * If traveling by Car use the CarModeOptions parameter.
	//
	//    * If traveling by Truck use the TruckModeOptions parameter.
	//
	// Bicycle or Motorcycle are only valid when using Grab as a data provider,
	// and only within Southeast Asia.
	//
	// Truck is not available for Grab.
	//
	// For more information about using Grab as a data provider, see GrabMaps (https://docs.aws.amazon.com/location/latest/developerguide/grab.html)
	// in the Amazon Location Service Developer Guide.
	//
	// Default Value: Car
	TravelMode *string `type:"string" enum:"TravelMode"`

	// Specifies route preferences when traveling by Truck, such as avoiding routes
	// that use ferries or tolls, and truck specifications to consider when choosing
	// an optimal road.
	//
	// Requirements: TravelMode must be specified as Truck.
	TruckModeOptions *CalculateRouteTruckModeOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteMatrixInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteMatrixInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CalculateRouteMatrixInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CalculateRouteMatrixInput"}
	if s.CalculatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatorName"))
	}
	if s.CalculatorName != nil && len(*s.CalculatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatorName", 1))
	}
	if s.DeparturePositions == nil {
		invalidParams.Add(request.NewErrParamRequired("DeparturePositions"))
	}
	if s.DeparturePositions != nil && len(s.DeparturePositions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeparturePositions", 1))
	}
	if s.DestinationPositions == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPositions"))
	}
	if s.DestinationPositions != nil && len(s.DestinationPositions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationPositions", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalculatorName sets the CalculatorName field's value.
func (s *CalculateRouteMatrixInput) SetCalculatorName(v string) *CalculateRouteMatrixInput {
	s.CalculatorName = &v
	return s
}

// SetCarModeOptions sets the CarModeOptions field's value.
func (s *CalculateRouteMatrixInput) SetCarModeOptions(v *CalculateRouteCarModeOptions) *CalculateRouteMatrixInput {
	s.CarModeOptions = v
	return s
}

// SetDepartNow sets the DepartNow field's value.
func (s *CalculateRouteMatrixInput) SetDepartNow(v bool) *CalculateRouteMatrixInput {
	s.DepartNow = &v
	return s
}

// SetDeparturePositions sets the DeparturePositions field's value.
func (s *CalculateRouteMatrixInput) SetDeparturePositions(v [][]*float64) *CalculateRouteMatrixInput {
	s.DeparturePositions = v
	return s
}

// SetDepartureTime sets the DepartureTime field's value.
func (s *CalculateRouteMatrixInput) SetDepartureTime(v time.Time) *CalculateRouteMatrixInput {
	s.DepartureTime = &v
	return s
}

// SetDestinationPositions sets the DestinationPositions field's value.
func (s *CalculateRouteMatrixInput) SetDestinationPositions(v [][]*float64) *CalculateRouteMatrixInput {
	s.DestinationPositions = v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *CalculateRouteMatrixInput) SetDistanceUnit(v string) *CalculateRouteMatrixInput {
	s.DistanceUnit = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CalculateRouteMatrixInput) SetKey(v string) *CalculateRouteMatrixInput {
	s.Key = &v
	return s
}

// SetTravelMode sets the TravelMode field's value.
func (s *CalculateRouteMatrixInput) SetTravelMode(v string) *CalculateRouteMatrixInput {
	s.TravelMode = &v
	return s
}

// SetTruckModeOptions sets the TruckModeOptions field's value.
func (s *CalculateRouteMatrixInput) SetTruckModeOptions(v *CalculateRouteTruckModeOptions) *CalculateRouteMatrixInput {
	s.TruckModeOptions = v
	return s
}

// Returns the result of the route matrix calculation.
type CalculateRouteMatrixOutput struct {
	_ struct{} `type:"structure"`

	// The calculated route matrix containing the results for all pairs of DeparturePositions
	// to DestinationPositions. Each row corresponds to one entry in DeparturePositions.
	// Each entry in the row corresponds to the route from that entry in DeparturePositions
	// to an entry in DestinationPositions.
	//
	// RouteMatrix is a required field
	RouteMatrix [][]*RouteMatrixEntry `type:"list" required:"true"`

	// For routes calculated using an Esri route calculator resource, departure
	// positions are snapped to the closest road. For Esri route calculator resources,
	// this returns the list of departure/origin positions used for calculation
	// of the RouteMatrix.
	SnappedDeparturePositions [][]*float64 `min:"1" type:"list"`

	// The list of destination positions for the route matrix used for calculation
	// of the RouteMatrix.
	SnappedDestinationPositions [][]*float64 `min:"1" type:"list"`

	// Contains information about the route matrix, DataSource, DistanceUnit, RouteCount
	// and ErrorCount.
	//
	// Summary is a required field
	Summary *CalculateRouteMatrixSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteMatrixOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteMatrixOutput) GoString() string {
	return s.String()
}

// SetRouteMatrix sets the RouteMatrix field's value.
func (s *CalculateRouteMatrixOutput) SetRouteMatrix(v [][]*RouteMatrixEntry) *CalculateRouteMatrixOutput {
	s.RouteMatrix = v
	return s
}

// SetSnappedDeparturePositions sets the SnappedDeparturePositions field's value.
func (s *CalculateRouteMatrixOutput) SetSnappedDeparturePositions(v [][]*float64) *CalculateRouteMatrixOutput {
	s.SnappedDeparturePositions = v
	return s
}

// SetSnappedDestinationPositions sets the SnappedDestinationPositions field's value.
func (s *CalculateRouteMatrixOutput) SetSnappedDestinationPositions(v [][]*float64) *CalculateRouteMatrixOutput {
	s.SnappedDestinationPositions = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *CalculateRouteMatrixOutput) SetSummary(v *CalculateRouteMatrixSummary) *CalculateRouteMatrixOutput {
	s.Summary = v
	return s
}

// A summary of the calculated route matrix.
type CalculateRouteMatrixSummary struct {
	_ struct{} `type:"structure"`

	// The data provider of traffic and road network data used to calculate the
	// routes. Indicates one of the available providers:
	//
	//    * Esri
	//
	//    * Grab
	//
	//    * Here
	//
	// For more information about data providers, see Amazon Location Service data
	// providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The unit of measurement for route distances.
	//
	// DistanceUnit is a required field
	DistanceUnit *string `type:"string" required:"true" enum:"DistanceUnit"`

	// The count of error results in the route matrix. If this number is 0, all
	// routes were calculated successfully.
	//
	// ErrorCount is a required field
	ErrorCount *int64 `min:"1" type:"integer" required:"true"`

	// The count of cells in the route matrix. Equal to the number of DeparturePositions
	// multiplied by the number of DestinationPositions.
	//
	// RouteCount is a required field
	RouteCount *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteMatrixSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteMatrixSummary) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *CalculateRouteMatrixSummary) SetDataSource(v string) *CalculateRouteMatrixSummary {
	s.DataSource = &v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *CalculateRouteMatrixSummary) SetDistanceUnit(v string) *CalculateRouteMatrixSummary {
	s.DistanceUnit = &v
	return s
}

// SetErrorCount sets the ErrorCount field's value.
func (s *CalculateRouteMatrixSummary) SetErrorCount(v int64) *CalculateRouteMatrixSummary {
	s.ErrorCount = &v
	return s
}

// SetRouteCount sets the RouteCount field's value.
func (s *CalculateRouteMatrixSummary) SetRouteCount(v int64) *CalculateRouteMatrixSummary {
	s.RouteCount = &v
	return s
}

// Returns the result of the route calculation. Metadata includes legs and route
// summary.
type CalculateRouteOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about each path between a pair of positions included along
	// a route such as: StartPosition, EndPosition, Distance, DurationSeconds, Geometry,
	// and Steps. The number of legs returned corresponds to one fewer than the
	// total number of positions in the request.
	//
	// For example, a route with a departure position and destination position returns
	// one leg with the positions snapped to a nearby road (https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html):
	//
	//    * The StartPosition is the departure position.
	//
	//    * The EndPosition is the destination position.
	//
	// A route with a waypoint between the departure and destination position returns
	// two legs with the positions snapped to a nearby road:
	//
	//    * Leg 1: The StartPosition is the departure position . The EndPosition
	//    is the waypoint positon.
	//
	//    * Leg 2: The StartPosition is the waypoint position. The EndPosition is
	//    the destination position.
	//
	// Legs is a required field
	Legs []*Leg `type:"list" required:"true"`

	// Contains information about the whole route, such as: RouteBBox, DataSource,
	// Distance, DistanceUnit, and DurationSeconds.
	//
	// Summary is a required field
	Summary *CalculateRouteSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteOutput) GoString() string {
	return s.String()
}

// SetLegs sets the Legs field's value.
func (s *CalculateRouteOutput) SetLegs(v []*Leg) *CalculateRouteOutput {
	s.Legs = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *CalculateRouteOutput) SetSummary(v *CalculateRouteSummary) *CalculateRouteOutput {
	s.Summary = v
	return s
}

// A summary of the calculated route.
type CalculateRouteSummary struct {
	_ struct{} `type:"structure"`

	// The data provider of traffic and road network data used to calculate the
	// route. Indicates one of the available providers:
	//
	//    * Esri
	//
	//    * Grab
	//
	//    * Here
	//
	// For more information about data providers, see Amazon Location Service data
	// providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The total distance covered by the route. The sum of the distance travelled
	// between every stop on the route.
	//
	// If Esri is the data source for the route calculator, the route distance can’t
	// be greater than 400 km. If the route exceeds 400 km, the response is a 400
	// RoutesValidationException error.
	//
	// Distance is a required field
	Distance *float64 `type:"double" required:"true"`

	// The unit of measurement for route distances.
	//
	// DistanceUnit is a required field
	DistanceUnit *string `type:"string" required:"true" enum:"DistanceUnit"`

	// The total travel time for the route measured in seconds. The sum of the travel
	// time between every stop on the route.
	//
	// DurationSeconds is a required field
	DurationSeconds *float64 `type:"double" required:"true"`

	// Specifies a geographical box surrounding a route. Used to zoom into a route
	// when displaying it in a map. For example, [min x, min y, max x, max y].
	//
	// The first 2 bbox parameters describe the lower southwest corner:
	//
	//    * The first bbox position is the X coordinate or longitude of the lower
	//    southwest corner.
	//
	//    * The second bbox position is the Y coordinate or latitude of the lower
	//    southwest corner.
	//
	// The next 2 bbox parameters describe the upper northeast corner:
	//
	//    * The third bbox position is the X coordinate, or longitude of the upper
	//    northeast corner.
	//
	//    * The fourth bbox position is the Y coordinate, or latitude of the upper
	//    northeast corner.
	//
	// RouteBBox is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CalculateRouteSummary's
	// String and GoString methods.
	//
	// RouteBBox is a required field
	RouteBBox []*float64 `min:"4" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteSummary) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *CalculateRouteSummary) SetDataSource(v string) *CalculateRouteSummary {
	s.DataSource = &v
	return s
}

// SetDistance sets the Distance field's value.
func (s *CalculateRouteSummary) SetDistance(v float64) *CalculateRouteSummary {
	s.Distance = &v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *CalculateRouteSummary) SetDistanceUnit(v string) *CalculateRouteSummary {
	s.DistanceUnit = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *CalculateRouteSummary) SetDurationSeconds(v float64) *CalculateRouteSummary {
	s.DurationSeconds = &v
	return s
}

// SetRouteBBox sets the RouteBBox field's value.
func (s *CalculateRouteSummary) SetRouteBBox(v []*float64) *CalculateRouteSummary {
	s.RouteBBox = v
	return s
}

// Contains details about additional route preferences for requests that specify
// TravelMode as Truck.
type CalculateRouteTruckModeOptions struct {
	_ struct{} `type:"structure"`

	// Avoids ferries when calculating routes.
	//
	// Default Value: false
	//
	// Valid Values: false | true
	AvoidFerries *bool `type:"boolean"`

	// Avoids tolls when calculating routes.
	//
	// Default Value: false
	//
	// Valid Values: false | true
	AvoidTolls *bool `type:"boolean"`

	// Specifies the truck's dimension specifications including length, height,
	// width, and unit of measurement. Used to avoid roads that can't support the
	// truck's dimensions.
	Dimensions *TruckDimensions `type:"structure"`

	// Specifies the truck's weight specifications including total weight and unit
	// of measurement. Used to avoid roads that can't support the truck's weight.
	Weight *TruckWeight `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteTruckModeOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculateRouteTruckModeOptions) GoString() string {
	return s.String()
}

// SetAvoidFerries sets the AvoidFerries field's value.
func (s *CalculateRouteTruckModeOptions) SetAvoidFerries(v bool) *CalculateRouteTruckModeOptions {
	s.AvoidFerries = &v
	return s
}

// SetAvoidTolls sets the AvoidTolls field's value.
func (s *CalculateRouteTruckModeOptions) SetAvoidTolls(v bool) *CalculateRouteTruckModeOptions {
	s.AvoidTolls = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *CalculateRouteTruckModeOptions) SetDimensions(v *TruckDimensions) *CalculateRouteTruckModeOptions {
	s.Dimensions = v
	return s
}

// SetWeight sets the Weight field's value.
func (s *CalculateRouteTruckModeOptions) SetWeight(v *TruckWeight) *CalculateRouteTruckModeOptions {
	s.Weight = v
	return s
}

// A circle on the earth, as defined by a center point and a radius.
type Circle struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A single point geometry, specifying the center of the circle, using WGS 84
	// (https://gisgeography.com/wgs84-world-geodetic-system/) coordinates, in the
	// form [longitude, latitude].
	//
	// Center is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Circle's
	// String and GoString methods.
	//
	// Center is a required field
	Center []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// The radius of the circle in meters. Must be greater than zero and no larger
	// than 100,000 (100 kilometers).
	//
	// Radius is a required field
	Radius *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Circle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Circle) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Circle) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Circle"}
	if s.Center == nil {
		invalidParams.Add(request.NewErrParamRequired("Center"))
	}
	if s.Center != nil && len(s.Center) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Center", 2))
	}
	if s.Radius == nil {
		invalidParams.Add(request.NewErrParamRequired("Radius"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCenter sets the Center field's value.
func (s *Circle) SetCenter(v []*float64) *Circle {
	s.Center = v
	return s
}

// SetRadius sets the Radius field's value.
func (s *Circle) SetRadius(v float64) *Circle {
	s.Radius = &v
	return s
}

// The request was unsuccessful because of a conflict.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateGeofenceCollectionInput struct {
	_ struct{} `type:"structure"`

	// A custom name for the geofence collection.
	//
	// Requirements:
	//
	//    * Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens
	//    (-), periods (.), and underscores (_).
	//
	//    * Must be a unique geofence collection name.
	//
	//    * No spaces allowed. For example, ExampleGeofenceCollection.
	//
	// CollectionName is a required field
	CollectionName *string `min:"1" type:"string" required:"true"`

	// An optional description for the geofence collection.
	Description *string `type:"string"`

	// A key identifier for an Amazon Web Services KMS customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
	// Enter a key ID, key ARN, alias name, or alias ARN.
	KmsKeyId *string `min:"1" type:"string"`

	// No longer used. If included, the only allowed value is RequestBasedUsage.
	//
	// Deprecated: Deprecated. If included, the only allowed value is RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// This parameter is no longer used.
	//
	// Deprecated: Deprecated. No longer allowed.
	PricingPlanDataSource *string `deprecated:"true" type:"string"`

	// Applies one or more tags to the geofence collection. A tag is a key-value
	// pair helps manage, identify, search, and filter your resources by labelling
	// them.
	//
	// Format: "key" : "value"
	//
	// Restrictions:
	//
	//    * Maximum 50 tags per resource
	//
	//    * Each resource tag must be unique with a maximum of one value.
	//
	//    * Maximum key length: 128 Unicode characters in UTF-8
	//
	//    * Maximum value length: 256 Unicode characters in UTF-8
	//
	//    * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
	//    characters: + - = . _ : / @.
	//
	//    * Cannot use "aws:" as a prefix for a key.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGeofenceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGeofenceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGeofenceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGeofenceCollectionInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *CreateGeofenceCollectionInput) SetCollectionName(v string) *CreateGeofenceCollectionInput {
	s.CollectionName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGeofenceCollectionInput) SetDescription(v string) *CreateGeofenceCollectionInput {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateGeofenceCollectionInput) SetKmsKeyId(v string) *CreateGeofenceCollectionInput {
	s.KmsKeyId = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *CreateGeofenceCollectionInput) SetPricingPlan(v string) *CreateGeofenceCollectionInput {
	s.PricingPlan = &v
	return s
}

// SetPricingPlanDataSource sets the PricingPlanDataSource field's value.
func (s *CreateGeofenceCollectionInput) SetPricingPlanDataSource(v string) *CreateGeofenceCollectionInput {
	s.PricingPlanDataSource = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGeofenceCollectionInput) SetTags(v map[string]*string) *CreateGeofenceCollectionInput {
	s.Tags = v
	return s
}

type CreateGeofenceCollectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the geofence collection resource. Used
	// when you need to specify a resource across all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection
	//
	// CollectionArn is a required field
	CollectionArn *string `type:"string" required:"true"`

	// The name for the geofence collection.
	//
	// CollectionName is a required field
	CollectionName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the geofence collection was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGeofenceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGeofenceCollectionOutput) GoString() string {
	return s.String()
}

// SetCollectionArn sets the CollectionArn field's value.
func (s *CreateGeofenceCollectionOutput) SetCollectionArn(v string) *CreateGeofenceCollectionOutput {
	s.CollectionArn = &v
	return s
}

// SetCollectionName sets the CollectionName field's value.
func (s *CreateGeofenceCollectionOutput) SetCollectionName(v string) *CreateGeofenceCollectionOutput {
	s.CollectionName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreateGeofenceCollectionOutput) SetCreateTime(v time.Time) *CreateGeofenceCollectionOutput {
	s.CreateTime = &v
	return s
}

type CreateKeyInput struct {
	_ struct{} `type:"structure"`

	// An optional description for the API key resource.
	Description *string `type:"string"`

	// The optional timestamp for when the API key resource will expire in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	// One of NoExpiry or ExpireTime must be set.
	ExpireTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A custom name for the API key resource.
	//
	// Requirements:
	//
	//    * Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens
	//    (-), periods (.), and underscores (_).
	//
	//    * Must be a unique API key name.
	//
	//    * No spaces allowed. For example, ExampleAPIKey.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// Optionally set to true to set no expiration time for the API key. One of
	// NoExpiry or ExpireTime must be set.
	NoExpiry *bool `type:"boolean"`

	// The API key restrictions for the API key resource.
	//
	// Restrictions is a required field
	Restrictions *ApiKeyRestrictions `type:"structure" required:"true"`

	// Applies one or more tags to the map resource. A tag is a key-value pair that
	// helps manage, identify, search, and filter your resources by labelling them.
	//
	// Format: "key" : "value"
	//
	// Restrictions:
	//
	//    * Maximum 50 tags per resource
	//
	//    * Each resource tag must be unique with a maximum of one value.
	//
	//    * Maximum key length: 128 Unicode characters in UTF-8
	//
	//    * Maximum value length: 256 Unicode characters in UTF-8
	//
	//    * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
	//    characters: + - = . _ : / @.
	//
	//    * Cannot use "aws:" as a prefix for a key.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyInput"}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.Restrictions == nil {
		invalidParams.Add(request.NewErrParamRequired("Restrictions"))
	}
	if s.Restrictions != nil {
		if err := s.Restrictions.Validate(); err != nil {
			invalidParams.AddNested("Restrictions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateKeyInput) SetDescription(v string) *CreateKeyInput {
	s.Description = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *CreateKeyInput) SetExpireTime(v time.Time) *CreateKeyInput {
	s.ExpireTime = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *CreateKeyInput) SetKeyName(v string) *CreateKeyInput {
	s.KeyName = &v
	return s
}

// SetNoExpiry sets the NoExpiry field's value.
func (s *CreateKeyInput) SetNoExpiry(v bool) *CreateKeyInput {
	s.NoExpiry = &v
	return s
}

// SetRestrictions sets the Restrictions field's value.
func (s *CreateKeyInput) SetRestrictions(v *ApiKeyRestrictions) *CreateKeyInput {
	s.Restrictions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKeyInput) SetTags(v map[string]*string) *CreateKeyInput {
	s.Tags = v
	return s
}

type CreateKeyOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the API key resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The key value/string of an API key. This value is used when making API calls
	// to authorize the call. For example, see GetMapGlyphs (https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapGlyphs.html).
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateKeyOutput's
	// String and GoString methods.
	//
	// Key is a required field
	Key *string `type:"string" required:"true" sensitive:"true"`

	// The Amazon Resource Name (ARN) for the API key resource. Used when you need
	// to specify a resource across all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:key/ExampleKey
	//
	// KeyArn is a required field
	KeyArn *string `type:"string" required:"true"`

	// The name of the API key resource.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreateKeyOutput) SetCreateTime(v time.Time) *CreateKeyOutput {
	s.CreateTime = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CreateKeyOutput) SetKey(v string) *CreateKeyOutput {
	s.Key = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *CreateKeyOutput) SetKeyArn(v string) *CreateKeyOutput {
	s.KeyArn = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *CreateKeyOutput) SetKeyName(v string) *CreateKeyOutput {
	s.KeyName = &v
	return s
}

type CreateMapInput struct {
	_ struct{} `type:"structure"`

	// Specifies the MapConfiguration, including the map style, for the map resource
	// that you create. The map style defines the look of maps and the data provider
	// for your map resource.
	//
	// Configuration is a required field
	Configuration *MapConfiguration `type:"structure" required:"true"`

	// An optional description for the map resource.
	Description *string `type:"string"`

	// The name for the map resource.
	//
	// Requirements:
	//
	//    * Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens
	//    (-), periods (.), and underscores (_).
	//
	//    * Must be a unique map resource name.
	//
	//    * No spaces allowed. For example, ExampleMap.
	//
	// MapName is a required field
	MapName *string `min:"1" type:"string" required:"true"`

	// No longer used. If included, the only allowed value is RequestBasedUsage.
	//
	// Deprecated: Deprecated. If included, the only allowed value is RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// Applies one or more tags to the map resource. A tag is a key-value pair helps
	// manage, identify, search, and filter your resources by labelling them.
	//
	// Format: "key" : "value"
	//
	// Restrictions:
	//
	//    * Maximum 50 tags per resource
	//
	//    * Each resource tag must be unique with a maximum of one value.
	//
	//    * Maximum key length: 128 Unicode characters in UTF-8
	//
	//    * Maximum value length: 256 Unicode characters in UTF-8
	//
	//    * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
	//    characters: + - = . _ : / @.
	//
	//    * Cannot use "aws:" as a prefix for a key.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMapInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateMapInput) SetConfiguration(v *MapConfiguration) *CreateMapInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateMapInput) SetDescription(v string) *CreateMapInput {
	s.Description = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *CreateMapInput) SetMapName(v string) *CreateMapInput {
	s.MapName = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *CreateMapInput) SetPricingPlan(v string) *CreateMapInput {
	s.PricingPlan = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMapInput) SetTags(v map[string]*string) *CreateMapInput {
	s.Tags = v
	return s
}

type CreateMapOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the map resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) for the map resource. Used to specify a resource
	// across all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:map/ExampleMap
	//
	// MapArn is a required field
	MapArn *string `type:"string" required:"true"`

	// The name of the map resource.
	//
	// MapName is a required field
	MapName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMapOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreateMapOutput) SetCreateTime(v time.Time) *CreateMapOutput {
	s.CreateTime = &v
	return s
}

// SetMapArn sets the MapArn field's value.
func (s *CreateMapOutput) SetMapArn(v string) *CreateMapOutput {
	s.MapArn = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *CreateMapOutput) SetMapName(v string) *CreateMapOutput {
	s.MapName = &v
	return s
}

type CreatePlaceIndexInput struct {
	_ struct{} `type:"structure"`

	// Specifies the geospatial data provider for the new place index.
	//
	// This field is case-sensitive. Enter the valid values as shown. For example,
	// entering HERE returns an error.
	//
	// Valid values include:
	//
	//    * Esri – For additional information about Esri (https://docs.aws.amazon.com/location/latest/developerguide/esri.html)'s
	//    coverage in your region of interest, see Esri details on geocoding coverage
	//    (https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm).
	//
	//    * Grab – Grab provides place index functionality for Southeast Asia.
	//    For additional information about GrabMaps (https://docs.aws.amazon.com/location/latest/developerguide/grab.html)'
	//    coverage, see GrabMaps countries and areas covered (https://docs.aws.amazon.com/location/latest/developerguide/grab.html#grab-coverage-area).
	//
	//    * Here – For additional information about HERE Technologies (https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)'
	//    coverage in your region of interest, see HERE details on goecoding coverage
	//    (https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html).
	//    If you specify HERE Technologies (Here) as the data provider, you may
	//    not store results (https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html)
	//    for locations in Japan. For more information, see the Amazon Web Services
	//    Service Terms (http://aws.amazon.com/service-terms/) for Amazon Location
	//    Service.
	//
	// For additional information , see Data providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html)
	// on the Amazon Location Service Developer Guide.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// Specifies the data storage option requesting Places.
	DataSourceConfiguration *DataSourceConfiguration `type:"structure"`

	// The optional description for the place index resource.
	Description *string `type:"string"`

	// The name of the place index resource.
	//
	// Requirements:
	//
	//    * Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens
	//    (-), periods (.), and underscores (_).
	//
	//    * Must be a unique place index resource name.
	//
	//    * No spaces allowed. For example, ExamplePlaceIndex.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// No longer used. If included, the only allowed value is RequestBasedUsage.
	//
	// Deprecated: Deprecated. If included, the only allowed value is RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// Applies one or more tags to the place index resource. A tag is a key-value
	// pair that helps you manage, identify, search, and filter your resources.
	//
	// Format: "key" : "value"
	//
	// Restrictions:
	//
	//    * Maximum 50 tags per resource.
	//
	//    * Each tag key must be unique and must have exactly one associated value.
	//
	//    * Maximum key length: 128 Unicode characters in UTF-8.
	//
	//    * Maximum value length: 256 Unicode characters in UTF-8.
	//
	//    * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
	//    characters: + - = . _ : / @
	//
	//    * Cannot use "aws:" as a prefix for a key.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlaceIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlaceIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlaceIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlaceIndexInput"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *CreatePlaceIndexInput) SetDataSource(v string) *CreatePlaceIndexInput {
	s.DataSource = &v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *CreatePlaceIndexInput) SetDataSourceConfiguration(v *DataSourceConfiguration) *CreatePlaceIndexInput {
	s.DataSourceConfiguration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePlaceIndexInput) SetDescription(v string) *CreatePlaceIndexInput {
	s.Description = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *CreatePlaceIndexInput) SetIndexName(v string) *CreatePlaceIndexInput {
	s.IndexName = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *CreatePlaceIndexInput) SetPricingPlan(v string) *CreatePlaceIndexInput {
	s.PricingPlan = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePlaceIndexInput) SetTags(v map[string]*string) *CreatePlaceIndexInput {
	s.Tags = v
	return s
}

type CreatePlaceIndexOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the place index resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) for the place index resource. Used to specify
	// a resource across Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex
	//
	// IndexArn is a required field
	IndexArn *string `type:"string" required:"true"`

	// The name for the place index resource.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlaceIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlaceIndexOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreatePlaceIndexOutput) SetCreateTime(v time.Time) *CreatePlaceIndexOutput {
	s.CreateTime = &v
	return s
}

// SetIndexArn sets the IndexArn field's value.
func (s *CreatePlaceIndexOutput) SetIndexArn(v string) *CreatePlaceIndexOutput {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *CreatePlaceIndexOutput) SetIndexName(v string) *CreatePlaceIndexOutput {
	s.IndexName = &v
	return s
}

type CreateRouteCalculatorInput struct {
	_ struct{} `type:"structure"`

	// The name of the route calculator resource.
	//
	// Requirements:
	//
	//    * Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-),
	//    periods (.), and underscores (_).
	//
	//    * Must be a unique Route calculator resource name.
	//
	//    * No spaces allowed. For example, ExampleRouteCalculator.
	//
	// CalculatorName is a required field
	CalculatorName *string `min:"1" type:"string" required:"true"`

	// Specifies the data provider of traffic and road network data.
	//
	// This field is case-sensitive. Enter the valid values as shown. For example,
	// entering HERE returns an error.
	//
	// Valid values include:
	//
	//    * Esri – For additional information about Esri (https://docs.aws.amazon.com/location/latest/developerguide/esri.html)'s
	//    coverage in your region of interest, see Esri details on street networks
	//    and traffic coverage (https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm).
	//    Route calculators that use Esri as a data source only calculate routes
	//    that are shorter than 400 km.
	//
	//    * Grab – Grab provides routing functionality for Southeast Asia. For
	//    additional information about GrabMaps (https://docs.aws.amazon.com/location/latest/developerguide/grab.html)'
	//    coverage, see GrabMaps countries and areas covered (https://docs.aws.amazon.com/location/latest/developerguide/grab.html#grab-coverage-area).
	//
	//    * Here – For additional information about HERE Technologies (https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)'
	//    coverage in your region of interest, see HERE car routing coverage (https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html)
	//    and HERE truck routing coverage (https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html).
	//
	// For additional information , see Data providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html)
	// on the Amazon Location Service Developer Guide.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The optional description for the route calculator resource.
	Description *string `type:"string"`

	// No longer used. If included, the only allowed value is RequestBasedUsage.
	//
	// Deprecated: Deprecated. If included, the only allowed value is RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// Applies one or more tags to the route calculator resource. A tag is a key-value
	// pair helps manage, identify, search, and filter your resources by labelling
	// them.
	//
	//    * For example: { "tag1" : "value1", "tag2" : "value2"}
	//
	// Format: "key" : "value"
	//
	// Restrictions:
	//
	//    * Maximum 50 tags per resource
	//
	//    * Each resource tag must be unique with a maximum of one value.
	//
	//    * Maximum key length: 128 Unicode characters in UTF-8
	//
	//    * Maximum value length: 256 Unicode characters in UTF-8
	//
	//    * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
	//    characters: + - = . _ : / @.
	//
	//    * Cannot use "aws:" as a prefix for a key.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteCalculatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteCalculatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteCalculatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRouteCalculatorInput"}
	if s.CalculatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatorName"))
	}
	if s.CalculatorName != nil && len(*s.CalculatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatorName", 1))
	}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalculatorName sets the CalculatorName field's value.
func (s *CreateRouteCalculatorInput) SetCalculatorName(v string) *CreateRouteCalculatorInput {
	s.CalculatorName = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *CreateRouteCalculatorInput) SetDataSource(v string) *CreateRouteCalculatorInput {
	s.DataSource = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRouteCalculatorInput) SetDescription(v string) *CreateRouteCalculatorInput {
	s.Description = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *CreateRouteCalculatorInput) SetPricingPlan(v string) *CreateRouteCalculatorInput {
	s.PricingPlan = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRouteCalculatorInput) SetTags(v map[string]*string) *CreateRouteCalculatorInput {
	s.Tags = v
	return s
}

type CreateRouteCalculatorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the route calculator resource. Use the
	// ARN when you specify a resource across all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:route-calculator/ExampleCalculator
	//
	// CalculatorArn is a required field
	CalculatorArn *string `type:"string" required:"true"`

	// The name of the route calculator resource.
	//
	//    * For example, ExampleRouteCalculator.
	//
	// CalculatorName is a required field
	CalculatorName *string `min:"1" type:"string" required:"true"`

	// The timestamp when the route calculator resource was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	//    * For example, 2020–07-2T12:15:20.000Z+01:00
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteCalculatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteCalculatorOutput) GoString() string {
	return s.String()
}

// SetCalculatorArn sets the CalculatorArn field's value.
func (s *CreateRouteCalculatorOutput) SetCalculatorArn(v string) *CreateRouteCalculatorOutput {
	s.CalculatorArn = &v
	return s
}

// SetCalculatorName sets the CalculatorName field's value.
func (s *CreateRouteCalculatorOutput) SetCalculatorName(v string) *CreateRouteCalculatorOutput {
	s.CalculatorName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreateRouteCalculatorOutput) SetCreateTime(v time.Time) *CreateRouteCalculatorOutput {
	s.CreateTime = &v
	return s
}

type CreateTrackerInput struct {
	_ struct{} `type:"structure"`

	// An optional description for the tracker resource.
	Description *string `type:"string"`

	// Whether to enable position UPDATE events from this tracker to be sent to
	// EventBridge.
	//
	// You do not need enable this feature to get ENTER and EXIT events for geofences
	// with this tracker. Those events are always sent to EventBridge.
	EventBridgeEnabled *bool `type:"boolean"`

	// Enables GeospatialQueries for a tracker that uses a Amazon Web Services KMS
	// customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
	//
	// This parameter is only used if you are using a KMS customer managed key.
	//
	// If you wish to encrypt your data using your own KMS customer managed key,
	// then the Bounding Polygon Queries feature will be disabled by default. This
	// is because by using this feature, a representation of your device positions
	// will not be encrypted using the your KMS managed key. The exact device position,
	// however; is still encrypted using your managed key.
	//
	// You can choose to opt-in to the Bounding Polygon Quseries feature. This is
	// done by setting the KmsKeyEnableGeospatialQueries parameter to true when
	// creating or updating a Tracker.
	KmsKeyEnableGeospatialQueries *bool `type:"boolean"`

	// A key identifier for an Amazon Web Services KMS customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
	// Enter a key ID, key ARN, alias name, or alias ARN.
	KmsKeyId *string `min:"1" type:"string"`

	// Specifies the position filtering for the tracker resource.
	//
	// Valid values:
	//
	//    * TimeBased - Location updates are evaluated against linked geofence collections,
	//    but not every location update is stored. If your update frequency is more
	//    often than 30 seconds, only one update per 30 seconds is stored for each
	//    unique device ID.
	//
	//    * DistanceBased - If the device has moved less than 30 m (98.4 ft), location
	//    updates are ignored. Location updates within this area are neither evaluated
	//    against linked geofence collections, nor stored. This helps control costs
	//    by reducing the number of geofence evaluations and historical device positions
	//    to paginate through. Distance-based filtering can also reduce the effects
	//    of GPS noise when displaying device trajectories on a map.
	//
	//    * AccuracyBased - If the device has moved less than the measured accuracy,
	//    location updates are ignored. For example, if two consecutive updates
	//    from a device have a horizontal accuracy of 5 m and 10 m, the second update
	//    is ignored if the device has moved less than 15 m. Ignored location updates
	//    are neither evaluated against linked geofence collections, nor stored.
	//    This can reduce the effects of GPS noise when displaying device trajectories
	//    on a map, and can help control your costs by reducing the number of geofence
	//    evaluations.
	//
	// This field is optional. If not specified, the default value is TimeBased.
	PositionFiltering *string `type:"string" enum:"PositionFiltering"`

	// No longer used. If included, the only allowed value is RequestBasedUsage.
	//
	// Deprecated: Deprecated. If included, the only allowed value is RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// This parameter is no longer used.
	//
	// Deprecated: Deprecated. No longer allowed.
	PricingPlanDataSource *string `deprecated:"true" type:"string"`

	// Applies one or more tags to the tracker resource. A tag is a key-value pair
	// helps manage, identify, search, and filter your resources by labelling them.
	//
	// Format: "key" : "value"
	//
	// Restrictions:
	//
	//    * Maximum 50 tags per resource
	//
	//    * Each resource tag must be unique with a maximum of one value.
	//
	//    * Maximum key length: 128 Unicode characters in UTF-8
	//
	//    * Maximum value length: 256 Unicode characters in UTF-8
	//
	//    * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
	//    characters: + - = . _ : / @.
	//
	//    * Cannot use "aws:" as a prefix for a key.
	Tags map[string]*string `type:"map"`

	// The name for the tracker resource.
	//
	// Requirements:
	//
	//    * Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-),
	//    periods (.), and underscores (_).
	//
	//    * Must be a unique tracker resource name.
	//
	//    * No spaces allowed. For example, ExampleTracker.
	//
	// TrackerName is a required field
	TrackerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrackerInput"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateTrackerInput) SetDescription(v string) *CreateTrackerInput {
	s.Description = &v
	return s
}

// SetEventBridgeEnabled sets the EventBridgeEnabled field's value.
func (s *CreateTrackerInput) SetEventBridgeEnabled(v bool) *CreateTrackerInput {
	s.EventBridgeEnabled = &v
	return s
}

// SetKmsKeyEnableGeospatialQueries sets the KmsKeyEnableGeospatialQueries field's value.
func (s *CreateTrackerInput) SetKmsKeyEnableGeospatialQueries(v bool) *CreateTrackerInput {
	s.KmsKeyEnableGeospatialQueries = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateTrackerInput) SetKmsKeyId(v string) *CreateTrackerInput {
	s.KmsKeyId = &v
	return s
}

// SetPositionFiltering sets the PositionFiltering field's value.
func (s *CreateTrackerInput) SetPositionFiltering(v string) *CreateTrackerInput {
	s.PositionFiltering = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *CreateTrackerInput) SetPricingPlan(v string) *CreateTrackerInput {
	s.PricingPlan = &v
	return s
}

// SetPricingPlanDataSource sets the PricingPlanDataSource field's value.
func (s *CreateTrackerInput) SetPricingPlanDataSource(v string) *CreateTrackerInput {
	s.PricingPlanDataSource = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrackerInput) SetTags(v map[string]*string) *CreateTrackerInput {
	s.Tags = v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *CreateTrackerInput) SetTrackerName(v string) *CreateTrackerInput {
	s.TrackerName = &v
	return s
}

type CreateTrackerOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the tracker resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) for the tracker resource. Used when you need
	// to specify a resource across all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:tracker/ExampleTracker
	//
	// TrackerArn is a required field
	TrackerArn *string `type:"string" required:"true"`

	// The name of the tracker resource.
	//
	// TrackerName is a required field
	TrackerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrackerOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreateTrackerOutput) SetCreateTime(v time.Time) *CreateTrackerOutput {
	s.CreateTime = &v
	return s
}

// SetTrackerArn sets the TrackerArn field's value.
func (s *CreateTrackerOutput) SetTrackerArn(v string) *CreateTrackerOutput {
	s.TrackerArn = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *CreateTrackerOutput) SetTrackerName(v string) *CreateTrackerOutput {
	s.TrackerName = &v
	return s
}

// Specifies the data storage option chosen for requesting Places.
//
// When using Amazon Location Places:
//
//   - If using HERE Technologies as a data provider, you can't store results
//     for locations in Japan by setting IntendedUse to Storage. parameter.
//
//   - Under the MobileAssetTracking or MobilAssetManagement pricing plan,
//     you can't store results from your place index resources by setting IntendedUse
//     to Storage. This returns a validation exception error.
//
// For more information, see the AWS Service Terms (https://aws.amazon.com/service-terms/)
// for Amazon Location Service.
type DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies how the results of an operation will be stored by the caller.
	//
	// Valid values include:
	//
	//    * SingleUse specifies that the results won't be stored.
	//
	//    * Storage specifies that the result can be cached or stored in a database.
	//
	// Default value: SingleUse
	IntendedUse *string `type:"string" enum:"IntendedUse"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) GoString() string {
	return s.String()
}

// SetIntendedUse sets the IntendedUse field's value.
func (s *DataSourceConfiguration) SetIntendedUse(v string) *DataSourceConfiguration {
	s.IntendedUse = &v
	return s
}

type DeleteGeofenceCollectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the geofence collection to be deleted.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGeofenceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGeofenceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGeofenceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGeofenceCollectionInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *DeleteGeofenceCollectionInput) SetCollectionName(v string) *DeleteGeofenceCollectionInput {
	s.CollectionName = &v
	return s
}

type DeleteGeofenceCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGeofenceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGeofenceCollectionOutput) GoString() string {
	return s.String()
}

type DeleteKeyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the API key to delete.
	//
	// KeyName is a required field
	KeyName *string `location:"uri" locationName:"KeyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeyInput"}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyName sets the KeyName field's value.
func (s *DeleteKeyInput) SetKeyName(v string) *DeleteKeyInput {
	s.KeyName = &v
	return s
}

type DeleteKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyOutput) GoString() string {
	return s.String()
}

type DeleteMapInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the map resource to be deleted.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMapInput"}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMapName sets the MapName field's value.
func (s *DeleteMapInput) SetMapName(v string) *DeleteMapInput {
	s.MapName = &v
	return s
}

type DeleteMapOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMapOutput) GoString() string {
	return s.String()
}

type DeletePlaceIndexInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the place index resource to be deleted.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaceIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaceIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePlaceIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePlaceIndexInput"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *DeletePlaceIndexInput) SetIndexName(v string) *DeletePlaceIndexInput {
	s.IndexName = &v
	return s
}

type DeletePlaceIndexOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaceIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlaceIndexOutput) GoString() string {
	return s.String()
}

type DeleteRouteCalculatorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the route calculator resource to be deleted.
	//
	// CalculatorName is a required field
	CalculatorName *string `location:"uri" locationName:"CalculatorName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteCalculatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteCalculatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteCalculatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteCalculatorInput"}
	if s.CalculatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatorName"))
	}
	if s.CalculatorName != nil && len(*s.CalculatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalculatorName sets the CalculatorName field's value.
func (s *DeleteRouteCalculatorInput) SetCalculatorName(v string) *DeleteRouteCalculatorInput {
	s.CalculatorName = &v
	return s
}

type DeleteRouteCalculatorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteCalculatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteCalculatorOutput) GoString() string {
	return s.String()
}

type DeleteTrackerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the tracker resource to be deleted.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrackerInput"}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrackerName sets the TrackerName field's value.
func (s *DeleteTrackerInput) SetTrackerName(v string) *DeleteTrackerInput {
	s.TrackerName = &v
	return s
}

type DeleteTrackerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrackerOutput) GoString() string {
	return s.String()
}

type DescribeGeofenceCollectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the geofence collection.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGeofenceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGeofenceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGeofenceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGeofenceCollectionInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *DescribeGeofenceCollectionInput) SetCollectionName(v string) *DescribeGeofenceCollectionInput {
	s.CollectionName = &v
	return s
}

type DescribeGeofenceCollectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the geofence collection resource. Used
	// when you need to specify a resource across all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection
	//
	// CollectionArn is a required field
	CollectionArn *string `type:"string" required:"true"`

	// The name of the geofence collection.
	//
	// CollectionName is a required field
	CollectionName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the geofence resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The optional description for the geofence collection.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The number of geofences in the geofence collection.
	GeofenceCount *int64 `type:"integer"`

	// A key identifier for an Amazon Web Services KMS customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html)
	// assigned to the Amazon Location resource
	KmsKeyId *string `min:"1" type:"string"`

	// No longer used. Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// No longer used. Always returns an empty string.
	//
	// Deprecated: Deprecated. Unused.
	PricingPlanDataSource *string `deprecated:"true" type:"string"`

	// Displays the key, value pairs of tags associated with this resource.
	Tags map[string]*string `type:"map"`

	// The timestamp for when the geofence collection was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGeofenceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGeofenceCollectionOutput) GoString() string {
	return s.String()
}

// SetCollectionArn sets the CollectionArn field's value.
func (s *DescribeGeofenceCollectionOutput) SetCollectionArn(v string) *DescribeGeofenceCollectionOutput {
	s.CollectionArn = &v
	return s
}

// SetCollectionName sets the CollectionName field's value.
func (s *DescribeGeofenceCollectionOutput) SetCollectionName(v string) *DescribeGeofenceCollectionOutput {
	s.CollectionName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DescribeGeofenceCollectionOutput) SetCreateTime(v time.Time) *DescribeGeofenceCollectionOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeGeofenceCollectionOutput) SetDescription(v string) *DescribeGeofenceCollectionOutput {
	s.Description = &v
	return s
}

// SetGeofenceCount sets the GeofenceCount field's value.
func (s *DescribeGeofenceCollectionOutput) SetGeofenceCount(v int64) *DescribeGeofenceCollectionOutput {
	s.GeofenceCount = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DescribeGeofenceCollectionOutput) SetKmsKeyId(v string) *DescribeGeofenceCollectionOutput {
	s.KmsKeyId = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *DescribeGeofenceCollectionOutput) SetPricingPlan(v string) *DescribeGeofenceCollectionOutput {
	s.PricingPlan = &v
	return s
}

// SetPricingPlanDataSource sets the PricingPlanDataSource field's value.
func (s *DescribeGeofenceCollectionOutput) SetPricingPlanDataSource(v string) *DescribeGeofenceCollectionOutput {
	s.PricingPlanDataSource = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeGeofenceCollectionOutput) SetTags(v map[string]*string) *DescribeGeofenceCollectionOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DescribeGeofenceCollectionOutput) SetUpdateTime(v time.Time) *DescribeGeofenceCollectionOutput {
	s.UpdateTime = &v
	return s
}

type DescribeKeyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the API key resource.
	//
	// KeyName is a required field
	KeyName *string `location:"uri" locationName:"KeyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeKeyInput"}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyName sets the KeyName field's value.
func (s *DescribeKeyInput) SetKeyName(v string) *DescribeKeyInput {
	s.KeyName = &v
	return s
}

type DescribeKeyOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the API key resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The optional description for the API key resource.
	Description *string `type:"string"`

	// The timestamp for when the API key resource will expire in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// ExpireTime is a required field
	ExpireTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The key value/string of an API key.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeKeyOutput's
	// String and GoString methods.
	//
	// Key is a required field
	Key *string `type:"string" required:"true" sensitive:"true"`

	// The Amazon Resource Name (ARN) for the API key resource. Used when you need
	// to specify a resource across all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:key/ExampleKey
	//
	// KeyArn is a required field
	KeyArn *string `type:"string" required:"true"`

	// The name of the API key resource.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// API Restrictions on the allowed actions, resources, and referers for an API
	// key resource.
	//
	// Restrictions is a required field
	Restrictions *ApiKeyRestrictions `type:"structure" required:"true"`

	// Tags associated with the API key resource.
	Tags map[string]*string `type:"map"`

	// The timestamp for when the API key resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *DescribeKeyOutput) SetCreateTime(v time.Time) *DescribeKeyOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeKeyOutput) SetDescription(v string) *DescribeKeyOutput {
	s.Description = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *DescribeKeyOutput) SetExpireTime(v time.Time) *DescribeKeyOutput {
	s.ExpireTime = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DescribeKeyOutput) SetKey(v string) *DescribeKeyOutput {
	s.Key = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *DescribeKeyOutput) SetKeyArn(v string) *DescribeKeyOutput {
	s.KeyArn = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *DescribeKeyOutput) SetKeyName(v string) *DescribeKeyOutput {
	s.KeyName = &v
	return s
}

// SetRestrictions sets the Restrictions field's value.
func (s *DescribeKeyOutput) SetRestrictions(v *ApiKeyRestrictions) *DescribeKeyOutput {
	s.Restrictions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeKeyOutput) SetTags(v map[string]*string) *DescribeKeyOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DescribeKeyOutput) SetUpdateTime(v time.Time) *DescribeKeyOutput {
	s.UpdateTime = &v
	return s
}

type DescribeMapInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the map resource.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMapInput"}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMapName sets the MapName field's value.
func (s *DescribeMapInput) SetMapName(v string) *DescribeMapInput {
	s.MapName = &v
	return s
}

type DescribeMapOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the map tile style selected from a partner data provider.
	//
	// Configuration is a required field
	Configuration *MapConfiguration `type:"structure" required:"true"`

	// The timestamp for when the map resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Specifies the data provider for the associated map tiles.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The optional description for the map resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the map resource. Used to specify a resource
	// across all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:map/ExampleMap
	//
	// MapArn is a required field
	MapArn *string `type:"string" required:"true"`

	// The map style selected from an available provider.
	//
	// MapName is a required field
	MapName *string `min:"1" type:"string" required:"true"`

	// No longer used. Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// Tags associated with the map resource.
	Tags map[string]*string `type:"map"`

	// The timestamp for when the map resource was last update in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMapOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *DescribeMapOutput) SetConfiguration(v *MapConfiguration) *DescribeMapOutput {
	s.Configuration = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DescribeMapOutput) SetCreateTime(v time.Time) *DescribeMapOutput {
	s.CreateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *DescribeMapOutput) SetDataSource(v string) *DescribeMapOutput {
	s.DataSource = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeMapOutput) SetDescription(v string) *DescribeMapOutput {
	s.Description = &v
	return s
}

// SetMapArn sets the MapArn field's value.
func (s *DescribeMapOutput) SetMapArn(v string) *DescribeMapOutput {
	s.MapArn = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *DescribeMapOutput) SetMapName(v string) *DescribeMapOutput {
	s.MapName = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *DescribeMapOutput) SetPricingPlan(v string) *DescribeMapOutput {
	s.PricingPlan = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeMapOutput) SetTags(v map[string]*string) *DescribeMapOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DescribeMapOutput) SetUpdateTime(v time.Time) *DescribeMapOutput {
	s.UpdateTime = &v
	return s
}

type DescribePlaceIndexInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the place index resource.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlaceIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlaceIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePlaceIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePlaceIndexInput"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *DescribePlaceIndexInput) SetIndexName(v string) *DescribePlaceIndexInput {
	s.IndexName = &v
	return s
}

type DescribePlaceIndexOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the place index resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The data provider of geospatial data. Values can be one of the following:
	//
	//    * Esri
	//
	//    * Grab
	//
	//    * Here
	//
	// For more information about data providers, see Amazon Location Service data
	// providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The specified data storage option for requesting Places.
	//
	// DataSourceConfiguration is a required field
	DataSourceConfiguration *DataSourceConfiguration `type:"structure" required:"true"`

	// The optional description for the place index resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the place index resource. Used to specify
	// a resource across Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex
	//
	// IndexArn is a required field
	IndexArn *string `type:"string" required:"true"`

	// The name of the place index resource being described.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// No longer used. Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// Tags associated with place index resource.
	Tags map[string]*string `type:"map"`

	// The timestamp for when the place index resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlaceIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlaceIndexOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *DescribePlaceIndexOutput) SetCreateTime(v time.Time) *DescribePlaceIndexOutput {
	s.CreateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *DescribePlaceIndexOutput) SetDataSource(v string) *DescribePlaceIndexOutput {
	s.DataSource = &v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *DescribePlaceIndexOutput) SetDataSourceConfiguration(v *DataSourceConfiguration) *DescribePlaceIndexOutput {
	s.DataSourceConfiguration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribePlaceIndexOutput) SetDescription(v string) *DescribePlaceIndexOutput {
	s.Description = &v
	return s
}

// SetIndexArn sets the IndexArn field's value.
func (s *DescribePlaceIndexOutput) SetIndexArn(v string) *DescribePlaceIndexOutput {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *DescribePlaceIndexOutput) SetIndexName(v string) *DescribePlaceIndexOutput {
	s.IndexName = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *DescribePlaceIndexOutput) SetPricingPlan(v string) *DescribePlaceIndexOutput {
	s.PricingPlan = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribePlaceIndexOutput) SetTags(v map[string]*string) *DescribePlaceIndexOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DescribePlaceIndexOutput) SetUpdateTime(v time.Time) *DescribePlaceIndexOutput {
	s.UpdateTime = &v
	return s
}

type DescribeRouteCalculatorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the route calculator resource.
	//
	// CalculatorName is a required field
	CalculatorName *string `location:"uri" locationName:"CalculatorName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRouteCalculatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRouteCalculatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRouteCalculatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRouteCalculatorInput"}
	if s.CalculatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatorName"))
	}
	if s.CalculatorName != nil && len(*s.CalculatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalculatorName sets the CalculatorName field's value.
func (s *DescribeRouteCalculatorInput) SetCalculatorName(v string) *DescribeRouteCalculatorInput {
	s.CalculatorName = &v
	return s
}

type DescribeRouteCalculatorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Route calculator resource. Use the
	// ARN when you specify a resource across Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:route-calculator/ExampleCalculator
	//
	// CalculatorArn is a required field
	CalculatorArn *string `type:"string" required:"true"`

	// The name of the route calculator resource being described.
	//
	// CalculatorName is a required field
	CalculatorName *string `min:"1" type:"string" required:"true"`

	// The timestamp when the route calculator resource was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	//    * For example, 2020–07-2T12:15:20.000Z+01:00
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The data provider of traffic and road network data. Indicates one of the
	// available providers:
	//
	//    * Esri
	//
	//    * Grab
	//
	//    * Here
	//
	// For more information about data providers, see Amazon Location Service data
	// providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The optional description of the route calculator resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// Tags associated with route calculator resource.
	Tags map[string]*string `type:"map"`

	// The timestamp when the route calculator resource was last updated in ISO
	// 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	//    * For example, 2020–07-2T12:15:20.000Z+01:00
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRouteCalculatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRouteCalculatorOutput) GoString() string {
	return s.String()
}

// SetCalculatorArn sets the CalculatorArn field's value.
func (s *DescribeRouteCalculatorOutput) SetCalculatorArn(v string) *DescribeRouteCalculatorOutput {
	s.CalculatorArn = &v
	return s
}

// SetCalculatorName sets the CalculatorName field's value.
func (s *DescribeRouteCalculatorOutput) SetCalculatorName(v string) *DescribeRouteCalculatorOutput {
	s.CalculatorName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DescribeRouteCalculatorOutput) SetCreateTime(v time.Time) *DescribeRouteCalculatorOutput {
	s.CreateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *DescribeRouteCalculatorOutput) SetDataSource(v string) *DescribeRouteCalculatorOutput {
	s.DataSource = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeRouteCalculatorOutput) SetDescription(v string) *DescribeRouteCalculatorOutput {
	s.Description = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *DescribeRouteCalculatorOutput) SetPricingPlan(v string) *DescribeRouteCalculatorOutput {
	s.PricingPlan = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeRouteCalculatorOutput) SetTags(v map[string]*string) *DescribeRouteCalculatorOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DescribeRouteCalculatorOutput) SetUpdateTime(v time.Time) *DescribeRouteCalculatorOutput {
	s.UpdateTime = &v
	return s
}

type DescribeTrackerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the tracker resource.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrackerInput"}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrackerName sets the TrackerName field's value.
func (s *DescribeTrackerInput) SetTrackerName(v string) *DescribeTrackerInput {
	s.TrackerName = &v
	return s
}

type DescribeTrackerOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the tracker resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The optional description for the tracker resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// Whether UPDATE events from this tracker in EventBridge are enabled. If set
	// to true these events will be sent to EventBridge.
	EventBridgeEnabled *bool `type:"boolean"`

	// Enables GeospatialQueries for a tracker that uses a Amazon Web Services KMS
	// customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
	//
	// This parameter is only used if you are using a KMS customer managed key.
	//
	// If you wish to encrypt your data using your own KMS customer managed key,
	// then the Bounding Polygon Queries feature will be disabled by default. This
	// is because by using this feature, a representation of your device positions
	// will not be encrypted using the your KMS managed key. The exact device position,
	// however; is still encrypted using your managed key.
	//
	// You can choose to opt-in to the Bounding Polygon Quseries feature. This is
	// done by setting the KmsKeyEnableGeospatialQueries parameter to true when
	// creating or updating a Tracker.
	KmsKeyEnableGeospatialQueries *bool `type:"boolean"`

	// A key identifier for an Amazon Web Services KMS customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html)
	// assigned to the Amazon Location resource.
	KmsKeyId *string `min:"1" type:"string"`

	// The position filtering method of the tracker resource.
	PositionFiltering *string `type:"string" enum:"PositionFiltering"`

	// Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// No longer used. Always returns an empty string.
	//
	// Deprecated: Deprecated. Unused.
	PricingPlanDataSource *string `deprecated:"true" type:"string"`

	// The tags associated with the tracker resource.
	Tags map[string]*string `type:"map"`

	// The Amazon Resource Name (ARN) for the tracker resource. Used when you need
	// to specify a resource across all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:tracker/ExampleTracker
	//
	// TrackerArn is a required field
	TrackerArn *string `type:"string" required:"true"`

	// The name of the tracker resource.
	//
	// TrackerName is a required field
	TrackerName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the tracker resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrackerOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *DescribeTrackerOutput) SetCreateTime(v time.Time) *DescribeTrackerOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeTrackerOutput) SetDescription(v string) *DescribeTrackerOutput {
	s.Description = &v
	return s
}

// SetEventBridgeEnabled sets the EventBridgeEnabled field's value.
func (s *DescribeTrackerOutput) SetEventBridgeEnabled(v bool) *DescribeTrackerOutput {
	s.EventBridgeEnabled = &v
	return s
}

// SetKmsKeyEnableGeospatialQueries sets the KmsKeyEnableGeospatialQueries field's value.
func (s *DescribeTrackerOutput) SetKmsKeyEnableGeospatialQueries(v bool) *DescribeTrackerOutput {
	s.KmsKeyEnableGeospatialQueries = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DescribeTrackerOutput) SetKmsKeyId(v string) *DescribeTrackerOutput {
	s.KmsKeyId = &v
	return s
}

// SetPositionFiltering sets the PositionFiltering field's value.
func (s *DescribeTrackerOutput) SetPositionFiltering(v string) *DescribeTrackerOutput {
	s.PositionFiltering = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *DescribeTrackerOutput) SetPricingPlan(v string) *DescribeTrackerOutput {
	s.PricingPlan = &v
	return s
}

// SetPricingPlanDataSource sets the PricingPlanDataSource field's value.
func (s *DescribeTrackerOutput) SetPricingPlanDataSource(v string) *DescribeTrackerOutput {
	s.PricingPlanDataSource = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeTrackerOutput) SetTags(v map[string]*string) *DescribeTrackerOutput {
	s.Tags = v
	return s
}

// SetTrackerArn sets the TrackerArn field's value.
func (s *DescribeTrackerOutput) SetTrackerArn(v string) *DescribeTrackerOutput {
	s.TrackerArn = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *DescribeTrackerOutput) SetTrackerName(v string) *DescribeTrackerOutput {
	s.TrackerName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DescribeTrackerOutput) SetUpdateTime(v time.Time) *DescribeTrackerOutput {
	s.UpdateTime = &v
	return s
}

// Contains the device position details.
type DevicePosition struct {
	_ struct{} `type:"structure"`

	// The accuracy of the device position.
	Accuracy *PositionalAccuracy `type:"structure"`

	// The device whose position you retrieved.
	DeviceId *string `min:"1" type:"string"`

	// The last known device position.
	//
	// Position is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DevicePosition's
	// String and GoString methods.
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// The properties associated with the position.
	//
	// PositionProperties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DevicePosition's
	// String and GoString methods.
	PositionProperties map[string]*string `type:"map" sensitive:"true"`

	// The timestamp for when the tracker resource received the device position
	// in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// ReceivedTime is a required field
	ReceivedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The timestamp at which the device's position was determined. Uses ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DevicePosition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DevicePosition) GoString() string {
	return s.String()
}

// SetAccuracy sets the Accuracy field's value.
func (s *DevicePosition) SetAccuracy(v *PositionalAccuracy) *DevicePosition {
	s.Accuracy = v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *DevicePosition) SetDeviceId(v string) *DevicePosition {
	s.DeviceId = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *DevicePosition) SetPosition(v []*float64) *DevicePosition {
	s.Position = v
	return s
}

// SetPositionProperties sets the PositionProperties field's value.
func (s *DevicePosition) SetPositionProperties(v map[string]*string) *DevicePosition {
	s.PositionProperties = v
	return s
}

// SetReceivedTime sets the ReceivedTime field's value.
func (s *DevicePosition) SetReceivedTime(v time.Time) *DevicePosition {
	s.ReceivedTime = &v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *DevicePosition) SetSampleTime(v time.Time) *DevicePosition {
	s.SampleTime = &v
	return s
}

// Contains the position update details for a device.
type DevicePositionUpdate struct {
	_ struct{} `type:"structure"`

	// The accuracy of the device position.
	Accuracy *PositionalAccuracy `type:"structure"`

	// The device associated to the position update.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// The latest device position defined in WGS 84 (https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84)
	// format: [X or longitude, Y or latitude].
	//
	// Position is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DevicePositionUpdate's
	// String and GoString methods.
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// Associates one of more properties with the position update. A property is
	// a key-value pair stored with the position update and added to any geofence
	// event the update may trigger.
	//
	// Format: "key" : "value"
	//
	// PositionProperties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DevicePositionUpdate's
	// String and GoString methods.
	PositionProperties map[string]*string `type:"map" sensitive:"true"`

	// The timestamp at which the device's position was determined. Uses ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DevicePositionUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DevicePositionUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DevicePositionUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DevicePositionUpdate"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.Position == nil {
		invalidParams.Add(request.NewErrParamRequired("Position"))
	}
	if s.Position != nil && len(s.Position) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Position", 2))
	}
	if s.SampleTime == nil {
		invalidParams.Add(request.NewErrParamRequired("SampleTime"))
	}
	if s.Accuracy != nil {
		if err := s.Accuracy.Validate(); err != nil {
			invalidParams.AddNested("Accuracy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccuracy sets the Accuracy field's value.
func (s *DevicePositionUpdate) SetAccuracy(v *PositionalAccuracy) *DevicePositionUpdate {
	s.Accuracy = v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *DevicePositionUpdate) SetDeviceId(v string) *DevicePositionUpdate {
	s.DeviceId = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *DevicePositionUpdate) SetPosition(v []*float64) *DevicePositionUpdate {
	s.Position = v
	return s
}

// SetPositionProperties sets the PositionProperties field's value.
func (s *DevicePositionUpdate) SetPositionProperties(v map[string]*string) *DevicePositionUpdate {
	s.PositionProperties = v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *DevicePositionUpdate) SetSampleTime(v time.Time) *DevicePositionUpdate {
	s.SampleTime = &v
	return s
}

type DisassociateTrackerConsumerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) for the geofence collection to be disassociated
	// from the tracker resource. Used when you need to specify a resource across
	// all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer
	//
	// ConsumerArn is a required field
	ConsumerArn *string `location:"uri" locationName:"ConsumerArn" type:"string" required:"true"`

	// The name of the tracker resource to be dissociated from the consumer.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTrackerConsumerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTrackerConsumerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateTrackerConsumerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateTrackerConsumerInput"}
	if s.ConsumerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConsumerArn"))
	}
	if s.ConsumerArn != nil && len(*s.ConsumerArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConsumerArn", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsumerArn sets the ConsumerArn field's value.
func (s *DisassociateTrackerConsumerInput) SetConsumerArn(v string) *DisassociateTrackerConsumerInput {
	s.ConsumerArn = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *DisassociateTrackerConsumerInput) SetTrackerName(v string) *DisassociateTrackerConsumerInput {
	s.TrackerName = &v
	return s
}

type DisassociateTrackerConsumerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTrackerConsumerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateTrackerConsumerOutput) GoString() string {
	return s.String()
}

// Contains the geofence geometry details.
//
// A geofence geometry is made up of either a polygon or a circle. Can be either
// a polygon or a circle. Including both will return a validation error.
//
// Amazon Location doesn't currently support polygons with holes, multipolygons,
// polygons that are wound clockwise, or that cross the antimeridian.
type GeofenceGeometry struct {
	_ struct{} `type:"structure"`

	// A circle on the earth, as defined by a center point and a radius.
	//
	// Circle is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GeofenceGeometry's
	// String and GoString methods.
	Circle *Circle `type:"structure" sensitive:"true"`

	// A polygon is a list of linear rings which are each made up of a list of vertices.
	//
	// Each vertex is a 2-dimensional point of the form: [longitude, latitude].
	// This is represented as an array of doubles of length 2 (so [double, double]).
	//
	// An array of 4 or more vertices, where the first and last vertex are the same
	// (to form a closed boundary), is called a linear ring. The linear ring vertices
	// must be listed in counter-clockwise order around the ring’s interior. The
	// linear ring is represented as an array of vertices, or an array of arrays
	// of doubles ([[double, double], ...]).
	//
	// A geofence consists of a single linear ring. To allow for future expansion,
	// the Polygon parameter takes an array of linear rings, which is represented
	// as an array of arrays of arrays of doubles ([[[double, double], ...], ...]).
	//
	// A linear ring for use in geofences can consist of between 4 and 1,000 vertices.
	Polygon [][][]*float64 `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeofenceGeometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeofenceGeometry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeofenceGeometry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeofenceGeometry"}
	if s.Polygon != nil && len(s.Polygon) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Polygon", 1))
	}
	if s.Circle != nil {
		if err := s.Circle.Validate(); err != nil {
			invalidParams.AddNested("Circle", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCircle sets the Circle field's value.
func (s *GeofenceGeometry) SetCircle(v *Circle) *GeofenceGeometry {
	s.Circle = v
	return s
}

// SetPolygon sets the Polygon field's value.
func (s *GeofenceGeometry) SetPolygon(v [][][]*float64) *GeofenceGeometry {
	s.Polygon = v
	return s
}

type GetDevicePositionHistoryInput struct {
	_ struct{} `type:"structure"`

	// The device whose position history you want to retrieve.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`

	// Specify the end time for the position history in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ. By default, the value will be the time
	// that the request is made.
	//
	// Requirement:
	//
	//    * The time specified for EndTimeExclusive must be after the time for StartTimeInclusive.
	EndTimeExclusive *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional limit for the number of device positions returned in a single
	// call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`

	// Specify the start time for the position history in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ. By default, the value will be 24 hours
	// prior to the time that the request is made.
	//
	// Requirement:
	//
	//    * The time specified for StartTimeInclusive must be before EndTimeExclusive.
	StartTimeInclusive *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The tracker resource receiving the request for the device position history.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePositionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePositionHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicePositionHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevicePositionHistoryInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *GetDevicePositionHistoryInput) SetDeviceId(v string) *GetDevicePositionHistoryInput {
	s.DeviceId = &v
	return s
}

// SetEndTimeExclusive sets the EndTimeExclusive field's value.
func (s *GetDevicePositionHistoryInput) SetEndTimeExclusive(v time.Time) *GetDevicePositionHistoryInput {
	s.EndTimeExclusive = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDevicePositionHistoryInput) SetMaxResults(v int64) *GetDevicePositionHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDevicePositionHistoryInput) SetNextToken(v string) *GetDevicePositionHistoryInput {
	s.NextToken = &v
	return s
}

// SetStartTimeInclusive sets the StartTimeInclusive field's value.
func (s *GetDevicePositionHistoryInput) SetStartTimeInclusive(v time.Time) *GetDevicePositionHistoryInput {
	s.StartTimeInclusive = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *GetDevicePositionHistoryInput) SetTrackerName(v string) *GetDevicePositionHistoryInput {
	s.TrackerName = &v
	return s
}

type GetDevicePositionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// Contains the position history details for the requested device.
	//
	// DevicePositions is a required field
	DevicePositions []*DevicePosition `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePositionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePositionHistoryOutput) GoString() string {
	return s.String()
}

// SetDevicePositions sets the DevicePositions field's value.
func (s *GetDevicePositionHistoryOutput) SetDevicePositions(v []*DevicePosition) *GetDevicePositionHistoryOutput {
	s.DevicePositions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDevicePositionHistoryOutput) SetNextToken(v string) *GetDevicePositionHistoryOutput {
	s.NextToken = &v
	return s
}

type GetDevicePositionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The device whose position you want to retrieve.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`

	// The tracker resource receiving the position update.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicePositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevicePositionInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *GetDevicePositionInput) SetDeviceId(v string) *GetDevicePositionInput {
	s.DeviceId = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *GetDevicePositionInput) SetTrackerName(v string) *GetDevicePositionInput {
	s.TrackerName = &v
	return s
}

type GetDevicePositionOutput struct {
	_ struct{} `type:"structure"`

	// The accuracy of the device position.
	Accuracy *PositionalAccuracy `type:"structure"`

	// The device whose position you retrieved.
	DeviceId *string `min:"1" type:"string"`

	// The last known device position.
	//
	// Position is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetDevicePositionOutput's
	// String and GoString methods.
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// The properties associated with the position.
	//
	// PositionProperties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetDevicePositionOutput's
	// String and GoString methods.
	PositionProperties map[string]*string `type:"map" sensitive:"true"`

	// The timestamp for when the tracker resource received the device position
	// in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// ReceivedTime is a required field
	ReceivedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The timestamp at which the device's position was determined. Uses ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePositionOutput) GoString() string {
	return s.String()
}

// SetAccuracy sets the Accuracy field's value.
func (s *GetDevicePositionOutput) SetAccuracy(v *PositionalAccuracy) *GetDevicePositionOutput {
	s.Accuracy = v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *GetDevicePositionOutput) SetDeviceId(v string) *GetDevicePositionOutput {
	s.DeviceId = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetDevicePositionOutput) SetPosition(v []*float64) *GetDevicePositionOutput {
	s.Position = v
	return s
}

// SetPositionProperties sets the PositionProperties field's value.
func (s *GetDevicePositionOutput) SetPositionProperties(v map[string]*string) *GetDevicePositionOutput {
	s.PositionProperties = v
	return s
}

// SetReceivedTime sets the ReceivedTime field's value.
func (s *GetDevicePositionOutput) SetReceivedTime(v time.Time) *GetDevicePositionOutput {
	s.ReceivedTime = &v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *GetDevicePositionOutput) SetSampleTime(v time.Time) *GetDevicePositionOutput {
	s.SampleTime = &v
	return s
}

type GetGeofenceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The geofence collection storing the target geofence.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// The geofence you're retrieving details for.
	//
	// GeofenceId is a required field
	GeofenceId *string `location:"uri" locationName:"GeofenceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeofenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeofenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGeofenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGeofenceInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.GeofenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeofenceId"))
	}
	if s.GeofenceId != nil && len(*s.GeofenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeofenceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *GetGeofenceInput) SetCollectionName(v string) *GetGeofenceInput {
	s.CollectionName = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *GetGeofenceInput) SetGeofenceId(v string) *GetGeofenceInput {
	s.GeofenceId = &v
	return s
}

type GetGeofenceOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the geofence collection was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The geofence identifier.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`

	// User defined properties of the geofence. A property is a key-value pair stored
	// with the geofence and added to any geofence event triggered with that geofence.
	//
	// Format: "key" : "value"
	//
	// GeofenceProperties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetGeofenceOutput's
	// String and GoString methods.
	GeofenceProperties map[string]*string `type:"map" sensitive:"true"`

	// Contains the geofence geometry details describing a polygon or a circle.
	//
	// Geometry is a required field
	Geometry *GeofenceGeometry `type:"structure" required:"true"`

	// Identifies the state of the geofence. A geofence will hold one of the following
	// states:
	//
	//    * ACTIVE — The geofence has been indexed by the system.
	//
	//    * PENDING — The geofence is being processed by the system.
	//
	//    * FAILED — The geofence failed to be indexed by the system.
	//
	//    * DELETED — The geofence has been deleted from the system index.
	//
	//    * DELETING — The geofence is being deleted from the system index.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// The timestamp for when the geofence collection was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeofenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeofenceOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetGeofenceOutput) SetCreateTime(v time.Time) *GetGeofenceOutput {
	s.CreateTime = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *GetGeofenceOutput) SetGeofenceId(v string) *GetGeofenceOutput {
	s.GeofenceId = &v
	return s
}

// SetGeofenceProperties sets the GeofenceProperties field's value.
func (s *GetGeofenceOutput) SetGeofenceProperties(v map[string]*string) *GetGeofenceOutput {
	s.GeofenceProperties = v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *GetGeofenceOutput) SetGeometry(v *GeofenceGeometry) *GetGeofenceOutput {
	s.Geometry = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetGeofenceOutput) SetStatus(v string) *GetGeofenceOutput {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetGeofenceOutput) SetUpdateTime(v time.Time) *GetGeofenceOutput {
	s.UpdateTime = &v
	return s
}

type GetMapGlyphsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A comma-separated list of fonts to load glyphs from in order of preference.
	// For example, Noto Sans Regular, Arial Unicode.
	//
	// Valid font stacks for Esri (https://docs.aws.amazon.com/location/latest/developerguide/esri.html)
	// styles:
	//
	//    * VectorEsriDarkGrayCanvas – Ubuntu Medium Italic | Ubuntu Medium |
	//    Ubuntu Italic | Ubuntu Regular | Ubuntu Bold
	//
	//    * VectorEsriLightGrayCanvas – Ubuntu Italic | Ubuntu Regular | Ubuntu
	//    Light | Ubuntu Bold
	//
	//    * VectorEsriTopographic – Noto Sans Italic | Noto Sans Regular | Noto
	//    Sans Bold | Noto Serif Regular | Roboto Condensed Light Italic
	//
	//    * VectorEsriStreets – Arial Regular | Arial Italic | Arial Bold
	//
	//    * VectorEsriNavigation – Arial Regular | Arial Italic | Arial Bold
	//
	// Valid font stacks for HERE Technologies (https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)
	// styles:
	//
	//    * VectorHereContrast – Fira GO Regular | Fira GO Bold
	//
	//    * VectorHereExplore, VectorHereExploreTruck, HybridHereExploreSatellite
	//    – Fira GO Italic | Fira GO Map | Fira GO Map Bold | Noto Sans CJK JP
	//    Bold | Noto Sans CJK JP Light | Noto Sans CJK JP Regular
	//
	// Valid font stacks for GrabMaps (https://docs.aws.amazon.com/location/latest/developerguide/grab.html)
	// styles:
	//
	//    * VectorGrabStandardLight, VectorGrabStandardDark – Noto Sans Regular
	//    | Noto Sans Medium | Noto Sans Bold
	//
	// Valid font stacks for Open Data (https://docs.aws.amazon.com/location/latest/developerguide/open-data.html)
	// styles:
	//
	//    * VectorOpenDataStandardLight, VectorOpenDataStandardDark, VectorOpenDataVisualizationLight,
	//    VectorOpenDataVisualizationDark – Amazon Ember Regular,Noto Sans Regular
	//    | Amazon Ember Bold,Noto Sans Bold | Amazon Ember Medium,Noto Sans Medium
	//    | Amazon Ember Regular Italic,Noto Sans Italic | Amazon Ember Condensed
	//    RC Regular,Noto Sans Regular | Amazon Ember Condensed RC Bold,Noto Sans
	//    Bold | Amazon Ember Regular,Noto Sans Regular,Noto Sans Arabic Regular
	//    | Amazon Ember Condensed RC Bold,Noto Sans Bold,Noto Sans Arabic Condensed
	//    Bold | Amazon Ember Bold,Noto Sans Bold,Noto Sans Arabic Bold | Amazon
	//    Ember Regular Italic,Noto Sans Italic,Noto Sans Arabic Regular | Amazon
	//    Ember Condensed RC Regular,Noto Sans Regular,Noto Sans Arabic Condensed
	//    Regular | Amazon Ember Medium,Noto Sans Medium,Noto Sans Arabic Medium
	//
	// The fonts used by the Open Data map styles are combined fonts that use Amazon
	// Ember for most glyphs but Noto Sans for glyphs unsupported by Amazon Ember.
	//
	// FontStack is a required field
	FontStack *string `location:"uri" locationName:"FontStack" type:"string" required:"true"`

	// A Unicode range of characters to download glyphs for. Each response will
	// contain 256 characters. For example, 0–255 includes all characters from
	// range U+0000 to 00FF. Must be aligned to multiples of 256.
	//
	// FontUnicodeRange is a required field
	FontUnicodeRange *string `location:"uri" locationName:"FontUnicodeRange" type:"string" required:"true"`

	// The optional API key (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
	// to authorize the request.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetMapGlyphsInput's
	// String and GoString methods.
	Key *string `location:"querystring" locationName:"key" type:"string" sensitive:"true"`

	// The map resource associated with the glyph ﬁle.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapGlyphsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapGlyphsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMapGlyphsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMapGlyphsInput"}
	if s.FontStack == nil {
		invalidParams.Add(request.NewErrParamRequired("FontStack"))
	}
	if s.FontStack != nil && len(*s.FontStack) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FontStack", 1))
	}
	if s.FontUnicodeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("FontUnicodeRange"))
	}
	if s.FontUnicodeRange != nil && len(*s.FontUnicodeRange) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FontUnicodeRange", 1))
	}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFontStack sets the FontStack field's value.
func (s *GetMapGlyphsInput) SetFontStack(v string) *GetMapGlyphsInput {
	s.FontStack = &v
	return s
}

// SetFontUnicodeRange sets the FontUnicodeRange field's value.
func (s *GetMapGlyphsInput) SetFontUnicodeRange(v string) *GetMapGlyphsInput {
	s.FontUnicodeRange = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetMapGlyphsInput) SetKey(v string) *GetMapGlyphsInput {
	s.Key = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *GetMapGlyphsInput) SetMapName(v string) *GetMapGlyphsInput {
	s.MapName = &v
	return s
}

type GetMapGlyphsOutput struct {
	_ struct{} `type:"structure" payload:"Blob"`

	// The glyph, as binary blob.
	Blob []byte `type:"blob"`

	// The HTTP Cache-Control directive for the value.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// The map glyph content type. For example, application/octet-stream.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapGlyphsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapGlyphsOutput) GoString() string {
	return s.String()
}

// SetBlob sets the Blob field's value.
func (s *GetMapGlyphsOutput) SetBlob(v []byte) *GetMapGlyphsOutput {
	s.Blob = v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *GetMapGlyphsOutput) SetCacheControl(v string) *GetMapGlyphsOutput {
	s.CacheControl = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetMapGlyphsOutput) SetContentType(v string) *GetMapGlyphsOutput {
	s.ContentType = &v
	return s
}

type GetMapSpritesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the sprite ﬁle. Use the following ﬁle names for the sprite
	// sheet:
	//
	//    * sprites.png
	//
	//    * sprites@2x.png for high pixel density displays
	//
	// For the JSON document containing image offsets. Use the following ﬁle names:
	//
	//    * sprites.json
	//
	//    * sprites@2x.json for high pixel density displays
	//
	// FileName is a required field
	FileName *string `location:"uri" locationName:"FileName" type:"string" required:"true"`

	// The optional API key (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
	// to authorize the request.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetMapSpritesInput's
	// String and GoString methods.
	Key *string `location:"querystring" locationName:"key" type:"string" sensitive:"true"`

	// The map resource associated with the sprite ﬁle.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapSpritesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapSpritesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMapSpritesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMapSpritesInput"}
	if s.FileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FileName"))
	}
	if s.FileName != nil && len(*s.FileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileName", 1))
	}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileName sets the FileName field's value.
func (s *GetMapSpritesInput) SetFileName(v string) *GetMapSpritesInput {
	s.FileName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetMapSpritesInput) SetKey(v string) *GetMapSpritesInput {
	s.Key = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *GetMapSpritesInput) SetMapName(v string) *GetMapSpritesInput {
	s.MapName = &v
	return s
}

type GetMapSpritesOutput struct {
	_ struct{} `type:"structure" payload:"Blob"`

	// Contains the body of the sprite sheet or JSON offset ﬁle.
	Blob []byte `type:"blob"`

	// The HTTP Cache-Control directive for the value.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// The content type of the sprite sheet and offsets. For example, the sprite
	// sheet content type is image/png, and the sprite offset JSON document is application/json.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapSpritesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapSpritesOutput) GoString() string {
	return s.String()
}

// SetBlob sets the Blob field's value.
func (s *GetMapSpritesOutput) SetBlob(v []byte) *GetMapSpritesOutput {
	s.Blob = v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *GetMapSpritesOutput) SetCacheControl(v string) *GetMapSpritesOutput {
	s.CacheControl = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetMapSpritesOutput) SetContentType(v string) *GetMapSpritesOutput {
	s.ContentType = &v
	return s
}

type GetMapStyleDescriptorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The optional API key (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
	// to authorize the request.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetMapStyleDescriptorInput's
	// String and GoString methods.
	Key *string `location:"querystring" locationName:"key" type:"string" sensitive:"true"`

	// The map resource to retrieve the style descriptor from.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapStyleDescriptorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapStyleDescriptorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMapStyleDescriptorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMapStyleDescriptorInput"}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *GetMapStyleDescriptorInput) SetKey(v string) *GetMapStyleDescriptorInput {
	s.Key = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *GetMapStyleDescriptorInput) SetMapName(v string) *GetMapStyleDescriptorInput {
	s.MapName = &v
	return s
}

type GetMapStyleDescriptorOutput struct {
	_ struct{} `type:"structure" payload:"Blob"`

	// Contains the body of the style descriptor.
	Blob []byte `type:"blob"`

	// The HTTP Cache-Control directive for the value.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// The style descriptor's content type. For example, application/json.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapStyleDescriptorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapStyleDescriptorOutput) GoString() string {
	return s.String()
}

// SetBlob sets the Blob field's value.
func (s *GetMapStyleDescriptorOutput) SetBlob(v []byte) *GetMapStyleDescriptorOutput {
	s.Blob = v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *GetMapStyleDescriptorOutput) SetCacheControl(v string) *GetMapStyleDescriptorOutput {
	s.CacheControl = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetMapStyleDescriptorOutput) SetContentType(v string) *GetMapStyleDescriptorOutput {
	s.ContentType = &v
	return s
}

type GetMapTileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The optional API key (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
	// to authorize the request.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetMapTileInput's
	// String and GoString methods.
	Key *string `location:"querystring" locationName:"key" type:"string" sensitive:"true"`

	// The map resource to retrieve the map tiles from.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`

	// The X axis value for the map tile.
	//
	// X is a required field
	X *string `location:"uri" locationName:"X" type:"string" required:"true"`

	// The Y axis value for the map tile.
	//
	// Y is a required field
	Y *string `location:"uri" locationName:"Y" type:"string" required:"true"`

	// The zoom value for the map tile.
	//
	// Z is a required field
	Z *string `location:"uri" locationName:"Z" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapTileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapTileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMapTileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMapTileInput"}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}
	if s.X == nil {
		invalidParams.Add(request.NewErrParamRequired("X"))
	}
	if s.X != nil && len(*s.X) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("X", 1))
	}
	if s.Y == nil {
		invalidParams.Add(request.NewErrParamRequired("Y"))
	}
	if s.Y != nil && len(*s.Y) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Y", 1))
	}
	if s.Z == nil {
		invalidParams.Add(request.NewErrParamRequired("Z"))
	}
	if s.Z != nil && len(*s.Z) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Z", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *GetMapTileInput) SetKey(v string) *GetMapTileInput {
	s.Key = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *GetMapTileInput) SetMapName(v string) *GetMapTileInput {
	s.MapName = &v
	return s
}

// SetX sets the X field's value.
func (s *GetMapTileInput) SetX(v string) *GetMapTileInput {
	s.X = &v
	return s
}

// SetY sets the Y field's value.
func (s *GetMapTileInput) SetY(v string) *GetMapTileInput {
	s.Y = &v
	return s
}

// SetZ sets the Z field's value.
func (s *GetMapTileInput) SetZ(v string) *GetMapTileInput {
	s.Z = &v
	return s
}

type GetMapTileOutput struct {
	_ struct{} `type:"structure" payload:"Blob"`

	// Contains Mapbox Vector Tile (MVT) data.
	Blob []byte `type:"blob"`

	// The HTTP Cache-Control directive for the value.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// The map tile's content type. For example, application/vnd.mapbox-vector-tile.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapTileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMapTileOutput) GoString() string {
	return s.String()
}

// SetBlob sets the Blob field's value.
func (s *GetMapTileOutput) SetBlob(v []byte) *GetMapTileOutput {
	s.Blob = v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *GetMapTileOutput) SetCacheControl(v string) *GetMapTileOutput {
	s.CacheControl = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetMapTileOutput) SetContentType(v string) *GetMapTileOutput {
	s.ContentType = &v
	return s
}

type GetPlaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the place index resource that you want to use for the search.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`

	// The optional API key (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
	// to authorize the request.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPlaceInput's
	// String and GoString methods.
	Key *string `location:"querystring" locationName:"key" type:"string" sensitive:"true"`

	// The preferred language used to return results. The value must be a valid
	// BCP 47 (https://tools.ietf.org/search/bcp47) language tag, for example, en
	// for English.
	//
	// This setting affects the languages used in the results, but not the results
	// themselves. If no language is specified, or not supported for a particular
	// result, the partner automatically chooses a language for the result.
	//
	// For an example, we'll use the Greek language. You search for a location around
	// Athens, Greece, with the language parameter set to en. The city in the results
	// will most likely be returned as Athens.
	//
	// If you set the language parameter to el, for Greek, then the city in the
	// results will more likely be returned as Αθήνα.
	//
	// If the data provider does not have a value for Greek, the result will be
	// in a language that the provider does support.
	Language *string `location:"querystring" locationName:"language" min:"2" type:"string"`

	// The identifier of the place to find.
	//
	// PlaceId is a required field
	PlaceId *string `location:"uri" locationName:"PlaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPlaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPlaceInput"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.Language != nil && len(*s.Language) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Language", 2))
	}
	if s.PlaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlaceId"))
	}
	if s.PlaceId != nil && len(*s.PlaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *GetPlaceInput) SetIndexName(v string) *GetPlaceInput {
	s.IndexName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetPlaceInput) SetKey(v string) *GetPlaceInput {
	s.Key = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *GetPlaceInput) SetLanguage(v string) *GetPlaceInput {
	s.Language = &v
	return s
}

// SetPlaceId sets the PlaceId field's value.
func (s *GetPlaceInput) SetPlaceId(v string) *GetPlaceInput {
	s.PlaceId = &v
	return s
}

type GetPlaceOutput struct {
	_ struct{} `type:"structure"`

	// Details about the result, such as its address and position.
	//
	// Place is a required field
	Place *Place `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlaceOutput) GoString() string {
	return s.String()
}

// SetPlace sets the Place field's value.
func (s *GetPlaceOutput) SetPlace(v *Place) *GetPlaceOutput {
	s.Place = v
	return s
}

// The request has failed to process because of an unknown server error, exception,
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the calculated route's details for each path between a pair of positions.
// The number of legs returned corresponds to one fewer than the total number
// of positions in the request.
//
// For example, a route with a departure position and destination position returns
// one leg with the positions snapped to a nearby road (https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html):
//
//   - The StartPosition is the departure position.
//
//   - The EndPosition is the destination position.
//
// A route with a waypoint between the departure and destination position returns
// two legs with the positions snapped to a nearby road:
//
//   - Leg 1: The StartPosition is the departure position . The EndPosition
//     is the waypoint positon.
//
//   - Leg 2: The StartPosition is the waypoint position. The EndPosition is
//     the destination position.
type Leg struct {
	_ struct{} `type:"structure"`

	// The distance between the leg's StartPosition and EndPosition along a calculated
	// route.
	//
	//    * The default measurement is Kilometers unless the request specifies a
	//    DistanceUnit of Miles.
	//
	// Distance is a required field
	Distance *float64 `type:"double" required:"true"`

	// The estimated travel time between the leg's StartPosition and EndPosition.
	// The travel mode and departure time that you specify in the request determines
	// the calculated time.
	//
	// DurationSeconds is a required field
	DurationSeconds *float64 `type:"double" required:"true"`

	// The terminating position of the leg. Follows the format [longitude,latitude].
	//
	// If the EndPosition isn't located on a road, it's snapped to a nearby road
	// (https://docs.aws.amazon.com/location/latest/developerguide/nap-to-nearby-road.html).
	//
	// EndPosition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Leg's
	// String and GoString methods.
	//
	// EndPosition is a required field
	EndPosition []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// Contains the calculated route's path as a linestring geometry.
	Geometry *LegGeometry `type:"structure"`

	// The starting position of the leg. Follows the format [longitude,latitude].
	//
	// If the StartPosition isn't located on a road, it's snapped to a nearby road
	// (https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
	//
	// StartPosition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Leg's
	// String and GoString methods.
	//
	// StartPosition is a required field
	StartPosition []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// Contains a list of steps, which represent subsections of a leg. Each step
	// provides instructions for how to move to the next step in the leg such as
	// the step's start position, end position, travel distance, travel duration,
	// and geometry offset.
	//
	// Steps is a required field
	Steps []*Step `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Leg) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Leg) GoString() string {
	return s.String()
}

// SetDistance sets the Distance field's value.
func (s *Leg) SetDistance(v float64) *Leg {
	s.Distance = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *Leg) SetDurationSeconds(v float64) *Leg {
	s.DurationSeconds = &v
	return s
}

// SetEndPosition sets the EndPosition field's value.
func (s *Leg) SetEndPosition(v []*float64) *Leg {
	s.EndPosition = v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *Leg) SetGeometry(v *LegGeometry) *Leg {
	s.Geometry = v
	return s
}

// SetStartPosition sets the StartPosition field's value.
func (s *Leg) SetStartPosition(v []*float64) *Leg {
	s.StartPosition = v
	return s
}

// SetSteps sets the Steps field's value.
func (s *Leg) SetSteps(v []*Step) *Leg {
	s.Steps = v
	return s
}

// Contains the geometry details for each path between a pair of positions.
// Used in plotting a route leg on a map.
type LegGeometry struct {
	_ struct{} `type:"structure"`

	// An ordered list of positions used to plot a route on a map.
	//
	// The first position is closest to the start position for the leg, and the
	// last position is the closest to the end position for the leg.
	//
	//    * For example, [[-123.117, 49.284],[-123.115, 49.285],[-123.115, 49.285]]
	LineString [][]*float64 `min:"2" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LegGeometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LegGeometry) GoString() string {
	return s.String()
}

// SetLineString sets the LineString field's value.
func (s *LegGeometry) SetLineString(v [][]*float64) *LegGeometry {
	s.LineString = v
	return s
}

type ListDevicePositionsInput struct {
	_ struct{} `type:"structure"`

	// The geomerty used to filter device positions.
	FilterGeometry *TrackingFilterGeometry `type:"structure"`

	// An optional limit for the number of entries returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`

	// The tracker resource containing the requested devices.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicePositionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicePositionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicePositionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicePositionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}
	if s.FilterGeometry != nil {
		if err := s.FilterGeometry.Validate(); err != nil {
			invalidParams.AddNested("FilterGeometry", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterGeometry sets the FilterGeometry field's value.
func (s *ListDevicePositionsInput) SetFilterGeometry(v *TrackingFilterGeometry) *ListDevicePositionsInput {
	s.FilterGeometry = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDevicePositionsInput) SetMaxResults(v int64) *ListDevicePositionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicePositionsInput) SetNextToken(v string) *ListDevicePositionsInput {
	s.NextToken = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *ListDevicePositionsInput) SetTrackerName(v string) *ListDevicePositionsInput {
	s.TrackerName = &v
	return s
}

type ListDevicePositionsOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about each device's last known position.
	//
	// Entries is a required field
	Entries []*ListDevicePositionsResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicePositionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicePositionsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListDevicePositionsOutput) SetEntries(v []*ListDevicePositionsResponseEntry) *ListDevicePositionsOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicePositionsOutput) SetNextToken(v string) *ListDevicePositionsOutput {
	s.NextToken = &v
	return s
}

// Contains the tracker resource details.
type ListDevicePositionsResponseEntry struct {
	_ struct{} `type:"structure"`

	// The accuracy of the device position.
	Accuracy *PositionalAccuracy `type:"structure"`

	// The ID of the device for this position.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// The last known device position. Empty if no positions currently stored.
	//
	// Position is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListDevicePositionsResponseEntry's
	// String and GoString methods.
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// The properties associated with the position.
	//
	// PositionProperties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListDevicePositionsResponseEntry's
	// String and GoString methods.
	PositionProperties map[string]*string `type:"map" sensitive:"true"`

	// The timestamp at which the device position was determined. Uses ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicePositionsResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicePositionsResponseEntry) GoString() string {
	return s.String()
}

// SetAccuracy sets the Accuracy field's value.
func (s *ListDevicePositionsResponseEntry) SetAccuracy(v *PositionalAccuracy) *ListDevicePositionsResponseEntry {
	s.Accuracy = v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *ListDevicePositionsResponseEntry) SetDeviceId(v string) *ListDevicePositionsResponseEntry {
	s.DeviceId = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *ListDevicePositionsResponseEntry) SetPosition(v []*float64) *ListDevicePositionsResponseEntry {
	s.Position = v
	return s
}

// SetPositionProperties sets the PositionProperties field's value.
func (s *ListDevicePositionsResponseEntry) SetPositionProperties(v map[string]*string) *ListDevicePositionsResponseEntry {
	s.PositionProperties = v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *ListDevicePositionsResponseEntry) SetSampleTime(v time.Time) *ListDevicePositionsResponseEntry {
	s.SampleTime = &v
	return s
}

type ListGeofenceCollectionsInput struct {
	_ struct{} `type:"structure"`

	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofenceCollectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofenceCollectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGeofenceCollectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGeofenceCollectionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGeofenceCollectionsInput) SetMaxResults(v int64) *ListGeofenceCollectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeofenceCollectionsInput) SetNextToken(v string) *ListGeofenceCollectionsInput {
	s.NextToken = &v
	return s
}

type ListGeofenceCollectionsOutput struct {
	_ struct{} `type:"structure"`

	// Lists the geofence collections that exist in your Amazon Web Services account.
	//
	// Entries is a required field
	Entries []*ListGeofenceCollectionsResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofenceCollectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofenceCollectionsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListGeofenceCollectionsOutput) SetEntries(v []*ListGeofenceCollectionsResponseEntry) *ListGeofenceCollectionsOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeofenceCollectionsOutput) SetNextToken(v string) *ListGeofenceCollectionsOutput {
	s.NextToken = &v
	return s
}

// Contains the geofence collection details.
type ListGeofenceCollectionsResponseEntry struct {
	_ struct{} `type:"structure"`

	// The name of the geofence collection.
	//
	// CollectionName is a required field
	CollectionName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the geofence collection was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description for the geofence collection
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// No longer used. Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// No longer used. Always returns an empty string.
	//
	// Deprecated: Deprecated. Unused.
	PricingPlanDataSource *string `deprecated:"true" type:"string"`

	// Specifies a timestamp for when the resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofenceCollectionsResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofenceCollectionsResponseEntry) GoString() string {
	return s.String()
}

// SetCollectionName sets the CollectionName field's value.
func (s *ListGeofenceCollectionsResponseEntry) SetCollectionName(v string) *ListGeofenceCollectionsResponseEntry {
	s.CollectionName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListGeofenceCollectionsResponseEntry) SetCreateTime(v time.Time) *ListGeofenceCollectionsResponseEntry {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListGeofenceCollectionsResponseEntry) SetDescription(v string) *ListGeofenceCollectionsResponseEntry {
	s.Description = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *ListGeofenceCollectionsResponseEntry) SetPricingPlan(v string) *ListGeofenceCollectionsResponseEntry {
	s.PricingPlan = &v
	return s
}

// SetPricingPlanDataSource sets the PricingPlanDataSource field's value.
func (s *ListGeofenceCollectionsResponseEntry) SetPricingPlanDataSource(v string) *ListGeofenceCollectionsResponseEntry {
	s.PricingPlanDataSource = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListGeofenceCollectionsResponseEntry) SetUpdateTime(v time.Time) *ListGeofenceCollectionsResponseEntry {
	s.UpdateTime = &v
	return s
}

// Contains a list of geofences stored in a given geofence collection.
type ListGeofenceResponseEntry struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the geofence was stored in a geofence collection in
	// ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The geofence identifier.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`

	// User defined properties of the geofence. A property is a key-value pair stored
	// with the geofence and added to any geofence event triggered with that geofence.
	//
	// Format: "key" : "value"
	//
	// GeofenceProperties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListGeofenceResponseEntry's
	// String and GoString methods.
	GeofenceProperties map[string]*string `type:"map" sensitive:"true"`

	// Contains the geofence geometry details describing a polygon or a circle.
	//
	// Geometry is a required field
	Geometry *GeofenceGeometry `type:"structure" required:"true"`

	// Identifies the state of the geofence. A geofence will hold one of the following
	// states:
	//
	//    * ACTIVE — The geofence has been indexed by the system.
	//
	//    * PENDING — The geofence is being processed by the system.
	//
	//    * FAILED — The geofence failed to be indexed by the system.
	//
	//    * DELETED — The geofence has been deleted from the system index.
	//
	//    * DELETING — The geofence is being deleted from the system index.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// The timestamp for when the geofence was last updated in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofenceResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofenceResponseEntry) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListGeofenceResponseEntry) SetCreateTime(v time.Time) *ListGeofenceResponseEntry {
	s.CreateTime = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *ListGeofenceResponseEntry) SetGeofenceId(v string) *ListGeofenceResponseEntry {
	s.GeofenceId = &v
	return s
}

// SetGeofenceProperties sets the GeofenceProperties field's value.
func (s *ListGeofenceResponseEntry) SetGeofenceProperties(v map[string]*string) *ListGeofenceResponseEntry {
	s.GeofenceProperties = v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *ListGeofenceResponseEntry) SetGeometry(v *GeofenceGeometry) *ListGeofenceResponseEntry {
	s.Geometry = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListGeofenceResponseEntry) SetStatus(v string) *ListGeofenceResponseEntry {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListGeofenceResponseEntry) SetUpdateTime(v time.Time) *ListGeofenceResponseEntry {
	s.UpdateTime = &v
	return s
}

type ListGeofencesInput struct {
	_ struct{} `type:"structure"`

	// The name of the geofence collection storing the list of geofences.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// An optional limit for the number of geofences returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGeofencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGeofencesInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *ListGeofencesInput) SetCollectionName(v string) *ListGeofencesInput {
	s.CollectionName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGeofencesInput) SetMaxResults(v int64) *ListGeofencesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeofencesInput) SetNextToken(v string) *ListGeofencesInput {
	s.NextToken = &v
	return s
}

type ListGeofencesOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of geofences stored in the geofence collection.
	//
	// Entries is a required field
	Entries []*ListGeofenceResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeofencesOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListGeofencesOutput) SetEntries(v []*ListGeofenceResponseEntry) *ListGeofencesOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeofencesOutput) SetNextToken(v string) *ListGeofencesOutput {
	s.NextToken = &v
	return s
}

type ListKeysInput struct {
	_ struct{} `type:"structure"`

	// Optionally filter the list to only Active or Expired API keys.
	Filter *ApiKeyFilter `type:"structure"`

	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeysInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListKeysInput) SetFilter(v *ApiKeyFilter) *ListKeysInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKeysInput) SetMaxResults(v int64) *ListKeysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeysInput) SetNextToken(v string) *ListKeysInput {
	s.NextToken = &v
	return s
}

type ListKeysOutput struct {
	_ struct{} `type:"structure"`

	// Contains API key resources in your Amazon Web Services account. Details include
	// API key name, allowed referers and timestamp for when the API key will expire.
	//
	// Entries is a required field
	Entries []*ListKeysResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListKeysOutput) SetEntries(v []*ListKeysResponseEntry) *ListKeysOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeysOutput) SetNextToken(v string) *ListKeysOutput {
	s.NextToken = &v
	return s
}

// An API key resource listed in your Amazon Web Services account.
type ListKeysResponseEntry struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the API key was created, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The optional description for the API key resource.
	Description *string `type:"string"`

	// The timestamp for when the API key resource will expire, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// ExpireTime is a required field
	ExpireTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the API key resource.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// API Restrictions on the allowed actions, resources, and referers for an API
	// key resource.
	//
	// Restrictions is a required field
	Restrictions *ApiKeyRestrictions `type:"structure" required:"true"`

	// The timestamp of when the API key was last updated, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysResponseEntry) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListKeysResponseEntry) SetCreateTime(v time.Time) *ListKeysResponseEntry {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListKeysResponseEntry) SetDescription(v string) *ListKeysResponseEntry {
	s.Description = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *ListKeysResponseEntry) SetExpireTime(v time.Time) *ListKeysResponseEntry {
	s.ExpireTime = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *ListKeysResponseEntry) SetKeyName(v string) *ListKeysResponseEntry {
	s.KeyName = &v
	return s
}

// SetRestrictions sets the Restrictions field's value.
func (s *ListKeysResponseEntry) SetRestrictions(v *ApiKeyRestrictions) *ListKeysResponseEntry {
	s.Restrictions = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListKeysResponseEntry) SetUpdateTime(v time.Time) *ListKeysResponseEntry {
	s.UpdateTime = &v
	return s
}

type ListMapsInput struct {
	_ struct{} `type:"structure"`

	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMapsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMapsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMapsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMapsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMapsInput) SetMaxResults(v int64) *ListMapsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMapsInput) SetNextToken(v string) *ListMapsInput {
	s.NextToken = &v
	return s
}

type ListMapsOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of maps in your Amazon Web Services account
	//
	// Entries is a required field
	Entries []*ListMapsResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMapsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMapsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListMapsOutput) SetEntries(v []*ListMapsResponseEntry) *ListMapsOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMapsOutput) SetNextToken(v string) *ListMapsOutput {
	s.NextToken = &v
	return s
}

// Contains details of an existing map resource in your Amazon Web Services
// account.
type ListMapsResponseEntry struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the map resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Specifies the data provider for the associated map tiles.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The description for the map resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the associated map resource.
	//
	// MapName is a required field
	MapName *string `min:"1" type:"string" required:"true"`

	// No longer used. Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// The timestamp for when the map resource was last updated in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMapsResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMapsResponseEntry) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListMapsResponseEntry) SetCreateTime(v time.Time) *ListMapsResponseEntry {
	s.CreateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *ListMapsResponseEntry) SetDataSource(v string) *ListMapsResponseEntry {
	s.DataSource = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListMapsResponseEntry) SetDescription(v string) *ListMapsResponseEntry {
	s.Description = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *ListMapsResponseEntry) SetMapName(v string) *ListMapsResponseEntry {
	s.MapName = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *ListMapsResponseEntry) SetPricingPlan(v string) *ListMapsResponseEntry {
	s.PricingPlan = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListMapsResponseEntry) SetUpdateTime(v time.Time) *ListMapsResponseEntry {
	s.UpdateTime = &v
	return s
}

type ListPlaceIndexesInput struct {
	_ struct{} `type:"structure"`

	// An optional limit for the maximum number of results returned in a single
	// call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaceIndexesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaceIndexesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPlaceIndexesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPlaceIndexesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPlaceIndexesInput) SetMaxResults(v int64) *ListPlaceIndexesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlaceIndexesInput) SetNextToken(v string) *ListPlaceIndexesInput {
	s.NextToken = &v
	return s
}

type ListPlaceIndexesOutput struct {
	_ struct{} `type:"structure"`

	// Lists the place index resources that exist in your Amazon Web Services account
	//
	// Entries is a required field
	Entries []*ListPlaceIndexesResponseEntry `type:"list" required:"true"`

	// A pagination token indicating that there are additional pages available.
	// You can use the token in a new request to fetch the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaceIndexesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaceIndexesOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListPlaceIndexesOutput) SetEntries(v []*ListPlaceIndexesResponseEntry) *ListPlaceIndexesOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlaceIndexesOutput) SetNextToken(v string) *ListPlaceIndexesOutput {
	s.NextToken = &v
	return s
}

// A place index resource listed in your Amazon Web Services account.
type ListPlaceIndexesResponseEntry struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the place index resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The data provider of geospatial data. Values can be one of the following:
	//
	//    * Esri
	//
	//    * Grab
	//
	//    * Here
	//
	// For more information about data providers, see Amazon Location Service data
	// providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The optional description for the place index resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the place index resource.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// No longer used. Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// The timestamp for when the place index resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaceIndexesResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlaceIndexesResponseEntry) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListPlaceIndexesResponseEntry) SetCreateTime(v time.Time) *ListPlaceIndexesResponseEntry {
	s.CreateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *ListPlaceIndexesResponseEntry) SetDataSource(v string) *ListPlaceIndexesResponseEntry {
	s.DataSource = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListPlaceIndexesResponseEntry) SetDescription(v string) *ListPlaceIndexesResponseEntry {
	s.Description = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ListPlaceIndexesResponseEntry) SetIndexName(v string) *ListPlaceIndexesResponseEntry {
	s.IndexName = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *ListPlaceIndexesResponseEntry) SetPricingPlan(v string) *ListPlaceIndexesResponseEntry {
	s.PricingPlan = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListPlaceIndexesResponseEntry) SetUpdateTime(v time.Time) *ListPlaceIndexesResponseEntry {
	s.UpdateTime = &v
	return s
}

type ListRouteCalculatorsInput struct {
	_ struct{} `type:"structure"`

	// An optional maximum number of results returned in a single call.
	//
	// Default Value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default Value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRouteCalculatorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRouteCalculatorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRouteCalculatorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRouteCalculatorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRouteCalculatorsInput) SetMaxResults(v int64) *ListRouteCalculatorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRouteCalculatorsInput) SetNextToken(v string) *ListRouteCalculatorsInput {
	s.NextToken = &v
	return s
}

type ListRouteCalculatorsOutput struct {
	_ struct{} `type:"structure"`

	// Lists the route calculator resources that exist in your Amazon Web Services
	// account
	//
	// Entries is a required field
	Entries []*ListRouteCalculatorsResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a subsequent request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRouteCalculatorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRouteCalculatorsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListRouteCalculatorsOutput) SetEntries(v []*ListRouteCalculatorsResponseEntry) *ListRouteCalculatorsOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRouteCalculatorsOutput) SetNextToken(v string) *ListRouteCalculatorsOutput {
	s.NextToken = &v
	return s
}

// A route calculator resource listed in your Amazon Web Services account.
type ListRouteCalculatorsResponseEntry struct {
	_ struct{} `type:"structure"`

	// The name of the route calculator resource.
	//
	// CalculatorName is a required field
	CalculatorName *string `min:"1" type:"string" required:"true"`

	// The timestamp when the route calculator resource was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	//    * For example, 2020–07-2T12:15:20.000Z+01:00
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The data provider of traffic and road network data. Indicates one of the
	// available providers:
	//
	//    * Esri
	//
	//    * Grab
	//
	//    * Here
	//
	// For more information about data providers, see Amazon Location Service data
	// providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The optional description of the route calculator resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// The timestamp when the route calculator resource was last updated in ISO
	// 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	//    * For example, 2020–07-2T12:15:20.000Z+01:00
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRouteCalculatorsResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRouteCalculatorsResponseEntry) GoString() string {
	return s.String()
}

// SetCalculatorName sets the CalculatorName field's value.
func (s *ListRouteCalculatorsResponseEntry) SetCalculatorName(v string) *ListRouteCalculatorsResponseEntry {
	s.CalculatorName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListRouteCalculatorsResponseEntry) SetCreateTime(v time.Time) *ListRouteCalculatorsResponseEntry {
	s.CreateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *ListRouteCalculatorsResponseEntry) SetDataSource(v string) *ListRouteCalculatorsResponseEntry {
	s.DataSource = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListRouteCalculatorsResponseEntry) SetDescription(v string) *ListRouteCalculatorsResponseEntry {
	s.Description = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *ListRouteCalculatorsResponseEntry) SetPricingPlan(v string) *ListRouteCalculatorsResponseEntry {
	s.PricingPlan = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListRouteCalculatorsResponseEntry) SetUpdateTime(v time.Time) *ListRouteCalculatorsResponseEntry {
	s.UpdateTime = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.
	//
	//    * Format example: arn:aws:geo:region:account-id:resourcetype/ExampleResource
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Tags that have been applied to the specified resource. Tags are mapped from
	// the tag key to the tag value: "TagKey" : "TagValue".
	//
	//    * Format example: {"tag1" : "value1", "tag2" : "value2"}
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTrackerConsumersInput struct {
	_ struct{} `type:"structure"`

	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`

	// The tracker resource whose associated geofence collections you want to list.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrackerConsumersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrackerConsumersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrackerConsumersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrackerConsumersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTrackerConsumersInput) SetMaxResults(v int64) *ListTrackerConsumersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrackerConsumersInput) SetNextToken(v string) *ListTrackerConsumersInput {
	s.NextToken = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *ListTrackerConsumersInput) SetTrackerName(v string) *ListTrackerConsumersInput {
	s.TrackerName = &v
	return s
}

type ListTrackerConsumersOutput struct {
	_ struct{} `type:"structure"`

	// Contains the list of geofence collection ARNs associated to the tracker resource.
	//
	// ConsumerArns is a required field
	ConsumerArns []*string `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrackerConsumersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrackerConsumersOutput) GoString() string {
	return s.String()
}

// SetConsumerArns sets the ConsumerArns field's value.
func (s *ListTrackerConsumersOutput) SetConsumerArns(v []*string) *ListTrackerConsumersOutput {
	s.ConsumerArns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrackerConsumersOutput) SetNextToken(v string) *ListTrackerConsumersOutput {
	s.NextToken = &v
	return s
}

type ListTrackersInput struct {
	_ struct{} `type:"structure"`

	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrackersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrackersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrackersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrackersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTrackersInput) SetMaxResults(v int64) *ListTrackersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrackersInput) SetNextToken(v string) *ListTrackersInput {
	s.NextToken = &v
	return s
}

type ListTrackersOutput struct {
	_ struct{} `type:"structure"`

	// Contains tracker resources in your Amazon Web Services account. Details include
	// tracker name, description and timestamps for when the tracker was created
	// and last updated.
	//
	// Entries is a required field
	Entries []*ListTrackersResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrackersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrackersOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListTrackersOutput) SetEntries(v []*ListTrackersResponseEntry) *ListTrackersOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrackersOutput) SetNextToken(v string) *ListTrackersOutput {
	s.NextToken = &v
	return s
}

// Contains the tracker resource details.
type ListTrackersResponseEntry struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the tracker resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description for the tracker resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// No longer used. Always returns an empty string.
	//
	// Deprecated: Deprecated. Unused.
	PricingPlanDataSource *string `deprecated:"true" type:"string"`

	// The name of the tracker resource.
	//
	// TrackerName is a required field
	TrackerName *string `min:"1" type:"string" required:"true"`

	// The timestamp at which the device's position was determined. Uses ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrackersResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrackersResponseEntry) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListTrackersResponseEntry) SetCreateTime(v time.Time) *ListTrackersResponseEntry {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListTrackersResponseEntry) SetDescription(v string) *ListTrackersResponseEntry {
	s.Description = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *ListTrackersResponseEntry) SetPricingPlan(v string) *ListTrackersResponseEntry {
	s.PricingPlan = &v
	return s
}

// SetPricingPlanDataSource sets the PricingPlanDataSource field's value.
func (s *ListTrackersResponseEntry) SetPricingPlanDataSource(v string) *ListTrackersResponseEntry {
	s.PricingPlanDataSource = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *ListTrackersResponseEntry) SetTrackerName(v string) *ListTrackersResponseEntry {
	s.TrackerName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListTrackersResponseEntry) SetUpdateTime(v time.Time) *ListTrackersResponseEntry {
	s.UpdateTime = &v
	return s
}

// Specifies the map tile style selected from an available provider.
type MapConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the political view for the style. Leave unset to not use a political
	// view, or, for styles that support specific political views, you can choose
	// a view, such as IND for the Indian view.
	//
	// Default is unset.
	//
	// Not all map resources or styles support political view styles. See Political
	// views (https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html#political-views)
	// for more information.
	PoliticalView *string `min:"3" type:"string"`

	// Specifies the map style selected from an available data provider.
	//
	// Valid Esri map styles (https://docs.aws.amazon.com/location/latest/developerguide/esri.html):
	//
	//    * VectorEsriDarkGrayCanvas – The Esri Dark Gray Canvas map style. A
	//    vector basemap with a dark gray, neutral background with minimal colors,
	//    labels, and features that's designed to draw attention to your thematic
	//    content.
	//
	//    * RasterEsriImagery – The Esri Imagery map style. A raster basemap that
	//    provides one meter or better satellite and aerial imagery in many parts
	//    of the world and lower resolution satellite imagery worldwide.
	//
	//    * VectorEsriLightGrayCanvas – The Esri Light Gray Canvas map style,
	//    which provides a detailed vector basemap with a light gray, neutral background
	//    style with minimal colors, labels, and features that's designed to draw
	//    attention to your thematic content.
	//
	//    * VectorEsriTopographic – The Esri Light map style, which provides a
	//    detailed vector basemap with a classic Esri map style.
	//
	//    * VectorEsriStreets – The Esri Street Map style, which provides a detailed
	//    vector basemap for the world symbolized with a classic Esri street map
	//    style. The vector tile layer is similar in content and style to the World
	//    Street Map raster map.
	//
	//    * VectorEsriNavigation – The Esri Navigation map style, which provides
	//    a detailed basemap for the world symbolized with a custom navigation map
	//    style that's designed for use during the day in mobile devices.
	//
	// Valid HERE Technologies map styles (https://docs.aws.amazon.com/location/latest/developerguide/HERE.html):
	//
	//    * VectorHereContrast – The HERE Contrast (Berlin) map style is a high
	//    contrast detailed base map of the world that blends 3D and 2D rendering.
	//    The VectorHereContrast style has been renamed from VectorHereBerlin. VectorHereBerlin
	//    has been deprecated, but will continue to work in applications that use
	//    it.
	//
	//    * VectorHereExplore – A default HERE map style containing a neutral,
	//    global map and its features including roads, buildings, landmarks, and
	//    water features. It also now includes a fully designed map of Japan.
	//
	//    * VectorHereExploreTruck – A global map containing truck restrictions
	//    and attributes (e.g. width / height / HAZMAT) symbolized with highlighted
	//    segments and icons on top of HERE Explore to support use cases within
	//    transport and logistics.
	//
	//    * RasterHereExploreSatellite – A global map containing high resolution
	//    satellite imagery.
	//
	//    * HybridHereExploreSatellite – A global map displaying the road network,
	//    street names, and city labels over satellite imagery. This style will
	//    automatically retrieve both raster and vector tiles, and your charges
	//    will be based on total tiles retrieved. Hybrid styles use both vector
	//    and raster tiles when rendering the map that you see. This means that
	//    more tiles are retrieved than when using either vector or raster tiles
	//    alone. Your charges will include all tiles retrieved.
	//
	// Valid GrabMaps map styles (https://docs.aws.amazon.com/location/latest/developerguide/grab.html):
	//
	//    * VectorGrabStandardLight – The Grab Standard Light map style provides
	//    a basemap with detailed land use coloring, area names, roads, landmarks,
	//    and points of interest covering Southeast Asia.
	//
	//    * VectorGrabStandardDark – The Grab Standard Dark map style provides
	//    a dark variation of the standard basemap covering Southeast Asia.
	//
	// Grab provides maps only for countries in Southeast Asia, and is only available
	// in the Asia Pacific (Singapore) Region (ap-southeast-1). For more information,
	// see GrabMaps countries and area covered (https://docs.aws.amazon.com/location/latest/developerguide/grab.html#grab-coverage-area).
	//
	// Valid Open Data map styles (https://docs.aws.amazon.com/location/latest/developerguide/open-data.html):
	//
	//    * VectorOpenDataStandardLight – The Open Data Standard Light map style
	//    provides a detailed basemap for the world suitable for website and mobile
	//    application use. The map includes highways major roads, minor roads, railways,
	//    water features, cities, parks, landmarks, building footprints, and administrative
	//    boundaries.
	//
	//    * VectorOpenDataStandardDark – Open Data Standard Dark is a dark-themed
	//    map style that provides a detailed basemap for the world suitable for
	//    website and mobile application use. The map includes highways major roads,
	//    minor roads, railways, water features, cities, parks, landmarks, building
	//    footprints, and administrative boundaries.
	//
	//    * VectorOpenDataVisualizationLight – The Open Data Visualization Light
	//    map style is a light-themed style with muted colors and fewer features
	//    that aids in understanding overlaid data.
	//
	//    * VectorOpenDataVisualizationDark – The Open Data Visualization Dark
	//    map style is a dark-themed style with muted colors and fewer features
	//    that aids in understanding overlaid data.
	//
	// Style is a required field
	Style *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MapConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MapConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MapConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MapConfiguration"}
	if s.PoliticalView != nil && len(*s.PoliticalView) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PoliticalView", 3))
	}
	if s.Style == nil {
		invalidParams.Add(request.NewErrParamRequired("Style"))
	}
	if s.Style != nil && len(*s.Style) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Style", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoliticalView sets the PoliticalView field's value.
func (s *MapConfiguration) SetPoliticalView(v string) *MapConfiguration {
	s.PoliticalView = &v
	return s
}

// SetStyle sets the Style field's value.
func (s *MapConfiguration) SetStyle(v string) *MapConfiguration {
	s.Style = &v
	return s
}

// Specifies the political view for the style.
type MapConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies the political view for the style. Set to an empty string to not
	// use a political view, or, for styles that support specific political views,
	// you can choose a view, such as IND for the Indian view.
	//
	// Not all map resources or styles support political view styles. See Political
	// views (https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html#political-views)
	// for more information.
	PoliticalView *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MapConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MapConfigurationUpdate) GoString() string {
	return s.String()
}

// SetPoliticalView sets the PoliticalView field's value.
func (s *MapConfigurationUpdate) SetPoliticalView(v string) *MapConfigurationUpdate {
	s.PoliticalView = &v
	return s
}

// Contains details about addresses or points of interest that match the search
// criteria.
//
// Not all details are included with all responses. Some details may only be
// returned by specific data partners.
type Place struct {
	_ struct{} `type:"structure"`

	// The numerical portion of an address, such as a building number.
	AddressNumber *string `type:"string"`

	// The Amazon Location categories that describe this Place.
	//
	// For more information about using categories, including a list of Amazon Location
	// categories, see Categories and filtering (https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html),
	// in the Amazon Location Service Developer Guide.
	Categories []*string `min:"1" type:"list"`

	// A country/region specified using ISO 3166 (https://www.iso.org/iso-3166-country-codes.html)
	// 3-digit country/region code. For example, CAN.
	Country *string `type:"string"`

	// Places uses a point geometry to specify a location or a Place.
	//
	// Geometry is a required field
	Geometry *PlaceGeometry `type:"structure" required:"true"`

	// True if the result is interpolated from other known places.
	//
	// False if the Place is a known place.
	//
	// Not returned when the partner does not provide the information.
	//
	// For example, returns False for an address location that is found in the partner
	// data, but returns True if an address does not exist in the partner data and
	// its location is calculated by interpolating between other known addresses.
	Interpolated *bool `type:"boolean"`

	// The full name and address of the point of interest such as a city, region,
	// or country. For example, 123 Any Street, Any Town, USA.
	Label *string `type:"string"`

	// A name for a local area, such as a city or town name. For example, Toronto.
	Municipality *string `type:"string"`

	// The name of a community district. For example, Downtown.
	Neighborhood *string `type:"string"`

	// A group of numbers and letters in a country-specific format, which accompanies
	// the address for the purpose of identifying a location.
	PostalCode *string `type:"string"`

	// A name for an area or geographical division, such as a province or state
	// name. For example, British Columbia.
	Region *string `type:"string"`

	// The name for a street or a road to identify a location. For example, Main
	// Street.
	Street *string `type:"string"`

	// A county, or an area that's part of a larger region. For example, Metro Vancouver.
	SubRegion *string `type:"string"`

	// Categories from the data provider that describe the Place that are not mapped
	// to any Amazon Location categories.
	SupplementalCategories []*string `min:"1" type:"list"`

	// The time zone in which the Place is located. Returned only when using HERE
	// or Grab as the selected partner.
	TimeZone *TimeZone `type:"structure"`

	// For addresses with multiple units, the unit identifier. Can include numbers
	// and letters, for example 3B or Unit 123.
	//
	// Returned only for a place index that uses Esri or Grab as a data provider.
	// Is not returned for SearchPlaceIndexForPosition.
	UnitNumber *string `type:"string"`

	// For addresses with a UnitNumber, the type of unit. For example, Apartment.
	//
	// Returned only for a place index that uses Esri as a data provider.
	UnitType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Place) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Place) GoString() string {
	return s.String()
}

// SetAddressNumber sets the AddressNumber field's value.
func (s *Place) SetAddressNumber(v string) *Place {
	s.AddressNumber = &v
	return s
}

// SetCategories sets the Categories field's value.
func (s *Place) SetCategories(v []*string) *Place {
	s.Categories = v
	return s
}

// SetCountry sets the Country field's value.
func (s *Place) SetCountry(v string) *Place {
	s.Country = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *Place) SetGeometry(v *PlaceGeometry) *Place {
	s.Geometry = v
	return s
}

// SetInterpolated sets the Interpolated field's value.
func (s *Place) SetInterpolated(v bool) *Place {
	s.Interpolated = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *Place) SetLabel(v string) *Place {
	s.Label = &v
	return s
}

// SetMunicipality sets the Municipality field's value.
func (s *Place) SetMunicipality(v string) *Place {
	s.Municipality = &v
	return s
}

// SetNeighborhood sets the Neighborhood field's value.
func (s *Place) SetNeighborhood(v string) *Place {
	s.Neighborhood = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Place) SetPostalCode(v string) *Place {
	s.PostalCode = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Place) SetRegion(v string) *Place {
	s.Region = &v
	return s
}

// SetStreet sets the Street field's value.
func (s *Place) SetStreet(v string) *Place {
	s.Street = &v
	return s
}

// SetSubRegion sets the SubRegion field's value.
func (s *Place) SetSubRegion(v string) *Place {
	s.SubRegion = &v
	return s
}

// SetSupplementalCategories sets the SupplementalCategories field's value.
func (s *Place) SetSupplementalCategories(v []*string) *Place {
	s.SupplementalCategories = v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *Place) SetTimeZone(v *TimeZone) *Place {
	s.TimeZone = v
	return s
}

// SetUnitNumber sets the UnitNumber field's value.
func (s *Place) SetUnitNumber(v string) *Place {
	s.UnitNumber = &v
	return s
}

// SetUnitType sets the UnitType field's value.
func (s *Place) SetUnitType(v string) *Place {
	s.UnitType = &v
	return s
}

// Places uses a point geometry to specify a location or a Place.
type PlaceGeometry struct {
	_ struct{} `type:"structure"`

	// A single point geometry specifies a location for a Place using WGS 84 (https://gisgeography.com/wgs84-world-geodetic-system/)
	// coordinates:
	//
	//    * x — Specifies the x coordinate or longitude.
	//
	//    * y — Specifies the y coordinate or latitude.
	//
	// Point is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PlaceGeometry's
	// String and GoString methods.
	Point []*float64 `min:"2" type:"list" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaceGeometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaceGeometry) GoString() string {
	return s.String()
}

// SetPoint sets the Point field's value.
func (s *PlaceGeometry) SetPoint(v []*float64) *PlaceGeometry {
	s.Point = v
	return s
}

// Defines the level of certainty of the position.
type PositionalAccuracy struct {
	_ struct{} `type:"structure"`

	// Estimated maximum distance, in meters, between the measured position and
	// the true position of a device, along the Earth's surface.
	//
	// Horizontal is a required field
	Horizontal *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PositionalAccuracy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PositionalAccuracy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PositionalAccuracy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PositionalAccuracy"}
	if s.Horizontal == nil {
		invalidParams.Add(request.NewErrParamRequired("Horizontal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHorizontal sets the Horizontal field's value.
func (s *PositionalAccuracy) SetHorizontal(v float64) *PositionalAccuracy {
	s.Horizontal = &v
	return s
}

type PutGeofenceInput struct {
	_ struct{} `type:"structure"`

	// The geofence collection to store the geofence in.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// An identifier for the geofence. For example, ExampleGeofence-1.
	//
	// GeofenceId is a required field
	GeofenceId *string `location:"uri" locationName:"GeofenceId" min:"1" type:"string" required:"true"`

	// Associates one of more properties with the geofence. A property is a key-value
	// pair stored with the geofence and added to any geofence event triggered with
	// that geofence.
	//
	// Format: "key" : "value"
	//
	// GeofenceProperties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutGeofenceInput's
	// String and GoString methods.
	GeofenceProperties map[string]*string `type:"map" sensitive:"true"`

	// Contains the details to specify the position of the geofence. Can be either
	// a polygon or a circle. Including both will return a validation error.
	//
	// Each geofence polygon (https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html)
	// can have a maximum of 1,000 vertices.
	//
	// Geometry is a required field
	Geometry *GeofenceGeometry `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutGeofenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutGeofenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutGeofenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutGeofenceInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.GeofenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeofenceId"))
	}
	if s.GeofenceId != nil && len(*s.GeofenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeofenceId", 1))
	}
	if s.Geometry == nil {
		invalidParams.Add(request.NewErrParamRequired("Geometry"))
	}
	if s.Geometry != nil {
		if err := s.Geometry.Validate(); err != nil {
			invalidParams.AddNested("Geometry", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *PutGeofenceInput) SetCollectionName(v string) *PutGeofenceInput {
	s.CollectionName = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *PutGeofenceInput) SetGeofenceId(v string) *PutGeofenceInput {
	s.GeofenceId = &v
	return s
}

// SetGeofenceProperties sets the GeofenceProperties field's value.
func (s *PutGeofenceInput) SetGeofenceProperties(v map[string]*string) *PutGeofenceInput {
	s.GeofenceProperties = v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *PutGeofenceInput) SetGeometry(v *GeofenceGeometry) *PutGeofenceInput {
	s.Geometry = v
	return s
}

type PutGeofenceOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the geofence was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The geofence identifier entered in the request.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the geofence was last updated in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutGeofenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutGeofenceOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *PutGeofenceOutput) SetCreateTime(v time.Time) *PutGeofenceOutput {
	s.CreateTime = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *PutGeofenceOutput) SetGeofenceId(v string) *PutGeofenceOutput {
	s.GeofenceId = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *PutGeofenceOutput) SetUpdateTime(v time.Time) *PutGeofenceOutput {
	s.UpdateTime = &v
	return s
}

// The resource that you've entered was not found in your AWS account.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The result for the calculated route of one DeparturePosition DestinationPosition
// pair.
type RouteMatrixEntry struct {
	_ struct{} `type:"structure"`

	// The total distance of travel for the route.
	Distance *float64 `type:"double"`

	// The expected duration of travel for the route.
	DurationSeconds *float64 `type:"double"`

	// An error corresponding to the calculation of a route between the DeparturePosition
	// and DestinationPosition.
	Error *RouteMatrixEntryError `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteMatrixEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteMatrixEntry) GoString() string {
	return s.String()
}

// SetDistance sets the Distance field's value.
func (s *RouteMatrixEntry) SetDistance(v float64) *RouteMatrixEntry {
	s.Distance = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *RouteMatrixEntry) SetDurationSeconds(v float64) *RouteMatrixEntry {
	s.DurationSeconds = &v
	return s
}

// SetError sets the Error field's value.
func (s *RouteMatrixEntry) SetError(v *RouteMatrixEntryError) *RouteMatrixEntry {
	s.Error = v
	return s
}

// An error corresponding to the calculation of a route between the DeparturePosition
// and DestinationPosition.
//
// The error code can be one of the following:
//
//   - RouteNotFound - Unable to find a valid route with the given parameters.
//
//   - RouteTooLong - Route calculation went beyond the maximum size of a route
//     and was terminated before completion.
//
//   - PositionsNotFound - One or more of the input positions were not found
//     on the route network.
//
//   - DestinationPositionNotFound - The destination position was not found
//     on the route network.
//
//   - DeparturePositionNotFound - The departure position was not found on
//     the route network.
//
//   - OtherValidationError - The given inputs were not valid or a route was
//     not found. More information is given in the error Message
type RouteMatrixEntryError struct {
	_ struct{} `type:"structure"`

	// The type of error which occurred for the route calculation.
	//
	// Code is a required field
	Code *string `type:"string" required:"true" enum:"RouteMatrixErrorCode"`

	// A message about the error that occurred for the route calculation.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteMatrixEntryError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteMatrixEntryError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *RouteMatrixEntryError) SetCode(v string) *RouteMatrixEntryError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *RouteMatrixEntryError) SetMessage(v string) *RouteMatrixEntryError {
	s.Message = &v
	return s
}

// Contains a search result from a position search query that is run on a place
// index resource.
type SearchForPositionResult struct {
	_ struct{} `type:"structure"`

	// The distance in meters of a great-circle arc between the query position and
	// the result.
	//
	// A great-circle arc is the shortest path on a sphere, in this case the Earth.
	// This returns the shortest distance between two locations.
	//
	// Distance is a required field
	Distance *float64 `type:"double" required:"true"`

	// Details about the search result, such as its address and position.
	//
	// Place is a required field
	Place *Place `type:"structure" required:"true"`

	// The unique identifier of the place. You can use this with the GetPlace operation
	// to find the place again later.
	//
	// For SearchPlaceIndexForPosition operations, the PlaceId is returned only
	// by place indexes that use HERE or Grab as a data provider.
	PlaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchForPositionResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchForPositionResult) GoString() string {
	return s.String()
}

// SetDistance sets the Distance field's value.
func (s *SearchForPositionResult) SetDistance(v float64) *SearchForPositionResult {
	s.Distance = &v
	return s
}

// SetPlace sets the Place field's value.
func (s *SearchForPositionResult) SetPlace(v *Place) *SearchForPositionResult {
	s.Place = v
	return s
}

// SetPlaceId sets the PlaceId field's value.
func (s *SearchForPositionResult) SetPlaceId(v string) *SearchForPositionResult {
	s.PlaceId = &v
	return s
}

// Contains a place suggestion resulting from a place suggestion query that
// is run on a place index resource.
type SearchForSuggestionsResult struct {
	_ struct{} `type:"structure"`

	// The Amazon Location categories that describe the Place.
	//
	// For more information about using categories, including a list of Amazon Location
	// categories, see Categories and filtering (https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html),
	// in the Amazon Location Service Developer Guide.
	Categories []*string `min:"1" type:"list"`

	// The unique identifier of the Place. You can use this with the GetPlace operation
	// to find the place again later, or to get full information for the Place.
	//
	// The GetPlace request must use the same PlaceIndex resource as the SearchPlaceIndexForSuggestions
	// that generated the Place ID.
	//
	// For SearchPlaceIndexForSuggestions operations, the PlaceId is returned by
	// place indexes that use Esri, Grab, or HERE as data providers.
	PlaceId *string `type:"string"`

	// Categories from the data provider that describe the Place that are not mapped
	// to any Amazon Location categories.
	SupplementalCategories []*string `min:"1" type:"list"`

	// The text of the place suggestion, typically formatted as an address string.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchForSuggestionsResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchForSuggestionsResult) GoString() string {
	return s.String()
}

// SetCategories sets the Categories field's value.
func (s *SearchForSuggestionsResult) SetCategories(v []*string) *SearchForSuggestionsResult {
	s.Categories = v
	return s
}

// SetPlaceId sets the PlaceId field's value.
func (s *SearchForSuggestionsResult) SetPlaceId(v string) *SearchForSuggestionsResult {
	s.PlaceId = &v
	return s
}

// SetSupplementalCategories sets the SupplementalCategories field's value.
func (s *SearchForSuggestionsResult) SetSupplementalCategories(v []*string) *SearchForSuggestionsResult {
	s.SupplementalCategories = v
	return s
}

// SetText sets the Text field's value.
func (s *SearchForSuggestionsResult) SetText(v string) *SearchForSuggestionsResult {
	s.Text = &v
	return s
}

// Contains a search result from a text search query that is run on a place
// index resource.
type SearchForTextResult struct {
	_ struct{} `type:"structure"`

	// The distance in meters of a great-circle arc between the bias position specified
	// and the result. Distance will be returned only if a bias position was specified
	// in the query.
	//
	// A great-circle arc is the shortest path on a sphere, in this case the Earth.
	// This returns the shortest distance between two locations.
	Distance *float64 `type:"double"`

	// Details about the search result, such as its address and position.
	//
	// Place is a required field
	Place *Place `type:"structure" required:"true"`

	// The unique identifier of the place. You can use this with the GetPlace operation
	// to find the place again later.
	//
	// For SearchPlaceIndexForText operations, the PlaceId is returned only by place
	// indexes that use HERE or Grab as a data provider.
	PlaceId *string `type:"string"`

	// The relative confidence in the match for a result among the results returned.
	// For example, if more fields for an address match (including house number,
	// street, city, country/region, and postal code), the relevance score is closer
	// to 1.
	//
	// Returned only when the partner selected is Esri or Grab.
	Relevance *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchForTextResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchForTextResult) GoString() string {
	return s.String()
}

// SetDistance sets the Distance field's value.
func (s *SearchForTextResult) SetDistance(v float64) *SearchForTextResult {
	s.Distance = &v
	return s
}

// SetPlace sets the Place field's value.
func (s *SearchForTextResult) SetPlace(v *Place) *SearchForTextResult {
	s.Place = v
	return s
}

// SetPlaceId sets the PlaceId field's value.
func (s *SearchForTextResult) SetPlaceId(v string) *SearchForTextResult {
	s.PlaceId = &v
	return s
}

// SetRelevance sets the Relevance field's value.
func (s *SearchForTextResult) SetRelevance(v float64) *SearchForTextResult {
	s.Relevance = &v
	return s
}

type SearchPlaceIndexForPositionInput struct {
	_ struct{} `type:"structure"`

	// The name of the place index resource you want to use for the search.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`

	// The optional API key (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
	// to authorize the request.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForPositionInput's
	// String and GoString methods.
	Key *string `location:"querystring" locationName:"key" type:"string" sensitive:"true"`

	// The preferred language used to return results. The value must be a valid
	// BCP 47 (https://tools.ietf.org/search/bcp47) language tag, for example, en
	// for English.
	//
	// This setting affects the languages used in the results, but not the results
	// themselves. If no language is specified, or not supported for a particular
	// result, the partner automatically chooses a language for the result.
	//
	// For an example, we'll use the Greek language. You search for a location around
	// Athens, Greece, with the language parameter set to en. The city in the results
	// will most likely be returned as Athens.
	//
	// If you set the language parameter to el, for Greek, then the city in the
	// results will more likely be returned as Αθήνα.
	//
	// If the data provider does not have a value for Greek, the result will be
	// in a language that the provider does support.
	Language *string `min:"2" type:"string"`

	// An optional parameter. The maximum number of results returned per request.
	//
	// Default value: 50
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies the longitude and latitude of the position to query.
	//
	// This parameter must contain a pair of numbers. The first number represents
	// the X coordinate, or longitude; the second number represents the Y coordinate,
	// or latitude.
	//
	// For example, [-123.1174, 49.2847] represents a position with longitude -123.1174
	// and latitude 49.2847.
	//
	// Position is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForPositionInput's
	// String and GoString methods.
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForPositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForPositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchPlaceIndexForPositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchPlaceIndexForPositionInput"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.Language != nil && len(*s.Language) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Language", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Position == nil {
		invalidParams.Add(request.NewErrParamRequired("Position"))
	}
	if s.Position != nil && len(s.Position) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Position", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *SearchPlaceIndexForPositionInput) SetIndexName(v string) *SearchPlaceIndexForPositionInput {
	s.IndexName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *SearchPlaceIndexForPositionInput) SetKey(v string) *SearchPlaceIndexForPositionInput {
	s.Key = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *SearchPlaceIndexForPositionInput) SetLanguage(v string) *SearchPlaceIndexForPositionInput {
	s.Language = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchPlaceIndexForPositionInput) SetMaxResults(v int64) *SearchPlaceIndexForPositionInput {
	s.MaxResults = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *SearchPlaceIndexForPositionInput) SetPosition(v []*float64) *SearchPlaceIndexForPositionInput {
	s.Position = v
	return s
}

type SearchPlaceIndexForPositionOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of Places closest to the specified position. Each result contains
	// additional information about the Places returned.
	//
	// Results is a required field
	Results []*SearchForPositionResult `type:"list" required:"true"`

	// Contains a summary of the request. Echoes the input values for Position,
	// Language, MaxResults, and the DataSource of the place index.
	//
	// Summary is a required field
	Summary *SearchPlaceIndexForPositionSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForPositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForPositionOutput) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *SearchPlaceIndexForPositionOutput) SetResults(v []*SearchForPositionResult) *SearchPlaceIndexForPositionOutput {
	s.Results = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *SearchPlaceIndexForPositionOutput) SetSummary(v *SearchPlaceIndexForPositionSummary) *SearchPlaceIndexForPositionOutput {
	s.Summary = v
	return s
}

// A summary of the request sent by using SearchPlaceIndexForPosition.
type SearchPlaceIndexForPositionSummary struct {
	_ struct{} `type:"structure"`

	// The geospatial data provider attached to the place index resource specified
	// in the request. Values can be one of the following:
	//
	//    * Esri
	//
	//    * Grab
	//
	//    * Here
	//
	// For more information about data providers, see Amazon Location Service data
	// providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The preferred language used to return results. Matches the language in the
	// request. The value is a valid BCP 47 (https://tools.ietf.org/search/bcp47)
	// language tag, for example, en for English.
	Language *string `min:"2" type:"string"`

	// Contains the optional result count limit that is specified in the request.
	//
	// Default value: 50
	MaxResults *int64 `min:"1" type:"integer"`

	// The position specified in the request.
	//
	// Position is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForPositionSummary's
	// String and GoString methods.
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForPositionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForPositionSummary) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *SearchPlaceIndexForPositionSummary) SetDataSource(v string) *SearchPlaceIndexForPositionSummary {
	s.DataSource = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *SearchPlaceIndexForPositionSummary) SetLanguage(v string) *SearchPlaceIndexForPositionSummary {
	s.Language = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchPlaceIndexForPositionSummary) SetMaxResults(v int64) *SearchPlaceIndexForPositionSummary {
	s.MaxResults = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *SearchPlaceIndexForPositionSummary) SetPosition(v []*float64) *SearchPlaceIndexForPositionSummary {
	s.Position = v
	return s
}

type SearchPlaceIndexForSuggestionsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that indicates a preference for place suggestions that
	// are closer to a specified position.
	//
	// If provided, this parameter must contain a pair of numbers. The first number
	// represents the X coordinate, or longitude; the second number represents the
	// Y coordinate, or latitude.
	//
	// For example, [-123.1174, 49.2847] represents the position with longitude
	// -123.1174 and latitude 49.2847.
	//
	// BiasPosition and FilterBBox are mutually exclusive. Specifying both options
	// results in an error.
	//
	// BiasPosition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForSuggestionsInput's
	// String and GoString methods.
	BiasPosition []*float64 `min:"2" type:"list" sensitive:"true"`

	// An optional parameter that limits the search results by returning only suggestions
	// within a specified bounding box.
	//
	// If provided, this parameter must contain a total of four consecutive numbers
	// in two pairs. The first pair of numbers represents the X and Y coordinates
	// (longitude and latitude, respectively) of the southwest corner of the bounding
	// box; the second pair of numbers represents the X and Y coordinates (longitude
	// and latitude, respectively) of the northeast corner of the bounding box.
	//
	// For example, [-12.7935, -37.4835, -12.0684, -36.9542] represents a bounding
	// box where the southwest corner has longitude -12.7935 and latitude -37.4835,
	// and the northeast corner has longitude -12.0684 and latitude -36.9542.
	//
	// FilterBBox and BiasPosition are mutually exclusive. Specifying both options
	// results in an error.
	//
	// FilterBBox is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForSuggestionsInput's
	// String and GoString methods.
	FilterBBox []*float64 `min:"4" type:"list" sensitive:"true"`

	// A list of one or more Amazon Location categories to filter the returned places.
	// If you include more than one category, the results will include results that
	// match any of the categories listed.
	//
	// For more information about using categories, including a list of Amazon Location
	// categories, see Categories and filtering (https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html),
	// in the Amazon Location Service Developer Guide.
	FilterCategories []*string `min:"1" type:"list"`

	// An optional parameter that limits the search results by returning only suggestions
	// within the provided list of countries.
	//
	//    * Use the ISO 3166 (https://www.iso.org/iso-3166-country-codes.html) 3-digit
	//    country code. For example, Australia uses three upper-case characters:
	//    AUS.
	FilterCountries []*string `min:"1" type:"list"`

	// The name of the place index resource you want to use for the search.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`

	// The optional API key (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
	// to authorize the request.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForSuggestionsInput's
	// String and GoString methods.
	Key *string `location:"querystring" locationName:"key" type:"string" sensitive:"true"`

	// The preferred language used to return results. The value must be a valid
	// BCP 47 (https://tools.ietf.org/search/bcp47) language tag, for example, en
	// for English.
	//
	// This setting affects the languages used in the results. If no language is
	// specified, or not supported for a particular result, the partner automatically
	// chooses a language for the result.
	//
	// For an example, we'll use the Greek language. You search for Athens, Gr to
	// get suggestions with the language parameter set to en. The results found
	// will most likely be returned as Athens, Greece.
	//
	// If you set the language parameter to el, for Greek, then the result found
	// will more likely be returned as Αθήνα, Ελλάδα.
	//
	// If the data provider does not have a value for Greek, the result will be
	// in a language that the provider does support.
	Language *string `min:"2" type:"string"`

	// An optional parameter. The maximum number of results returned per request.
	//
	// The default: 5
	MaxResults *int64 `min:"1" type:"integer"`

	// The free-form partial text to use to generate place suggestions. For example,
	// eiffel tow.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForSuggestionsInput's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForSuggestionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForSuggestionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchPlaceIndexForSuggestionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchPlaceIndexForSuggestionsInput"}
	if s.BiasPosition != nil && len(s.BiasPosition) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BiasPosition", 2))
	}
	if s.FilterBBox != nil && len(s.FilterBBox) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("FilterBBox", 4))
	}
	if s.FilterCategories != nil && len(s.FilterCategories) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterCategories", 1))
	}
	if s.FilterCountries != nil && len(s.FilterCountries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterCountries", 1))
	}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.Language != nil && len(*s.Language) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Language", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBiasPosition sets the BiasPosition field's value.
func (s *SearchPlaceIndexForSuggestionsInput) SetBiasPosition(v []*float64) *SearchPlaceIndexForSuggestionsInput {
	s.BiasPosition = v
	return s
}

// SetFilterBBox sets the FilterBBox field's value.
func (s *SearchPlaceIndexForSuggestionsInput) SetFilterBBox(v []*float64) *SearchPlaceIndexForSuggestionsInput {
	s.FilterBBox = v
	return s
}

// SetFilterCategories sets the FilterCategories field's value.
func (s *SearchPlaceIndexForSuggestionsInput) SetFilterCategories(v []*string) *SearchPlaceIndexForSuggestionsInput {
	s.FilterCategories = v
	return s
}

// SetFilterCountries sets the FilterCountries field's value.
func (s *SearchPlaceIndexForSuggestionsInput) SetFilterCountries(v []*string) *SearchPlaceIndexForSuggestionsInput {
	s.FilterCountries = v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *SearchPlaceIndexForSuggestionsInput) SetIndexName(v string) *SearchPlaceIndexForSuggestionsInput {
	s.IndexName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *SearchPlaceIndexForSuggestionsInput) SetKey(v string) *SearchPlaceIndexForSuggestionsInput {
	s.Key = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *SearchPlaceIndexForSuggestionsInput) SetLanguage(v string) *SearchPlaceIndexForSuggestionsInput {
	s.Language = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchPlaceIndexForSuggestionsInput) SetMaxResults(v int64) *SearchPlaceIndexForSuggestionsInput {
	s.MaxResults = &v
	return s
}

// SetText sets the Text field's value.
func (s *SearchPlaceIndexForSuggestionsInput) SetText(v string) *SearchPlaceIndexForSuggestionsInput {
	s.Text = &v
	return s
}

type SearchPlaceIndexForSuggestionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of place suggestions that best match the search text.
	//
	// Results is a required field
	Results []*SearchForSuggestionsResult `type:"list" required:"true"`

	// Contains a summary of the request. Echoes the input values for BiasPosition,
	// FilterBBox, FilterCountries, Language, MaxResults, and Text. Also includes
	// the DataSource of the place index.
	//
	// Summary is a required field
	Summary *SearchPlaceIndexForSuggestionsSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForSuggestionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForSuggestionsOutput) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *SearchPlaceIndexForSuggestionsOutput) SetResults(v []*SearchForSuggestionsResult) *SearchPlaceIndexForSuggestionsOutput {
	s.Results = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *SearchPlaceIndexForSuggestionsOutput) SetSummary(v *SearchPlaceIndexForSuggestionsSummary) *SearchPlaceIndexForSuggestionsOutput {
	s.Summary = v
	return s
}

// A summary of the request sent by using SearchPlaceIndexForSuggestions.
type SearchPlaceIndexForSuggestionsSummary struct {
	_ struct{} `type:"structure"`

	// Contains the coordinates for the optional bias position specified in the
	// request.
	//
	// This parameter contains a pair of numbers. The first number represents the
	// X coordinate, or longitude; the second number represents the Y coordinate,
	// or latitude.
	//
	// For example, [-123.1174, 49.2847] represents the position with longitude
	// -123.1174 and latitude 49.2847.
	//
	// BiasPosition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForSuggestionsSummary's
	// String and GoString methods.
	BiasPosition []*float64 `min:"2" type:"list" sensitive:"true"`

	// The geospatial data provider attached to the place index resource specified
	// in the request. Values can be one of the following:
	//
	//    * Esri
	//
	//    * Grab
	//
	//    * Here
	//
	// For more information about data providers, see Amazon Location Service data
	// providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// Contains the coordinates for the optional bounding box specified in the request.
	//
	// FilterBBox is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForSuggestionsSummary's
	// String and GoString methods.
	FilterBBox []*float64 `min:"4" type:"list" sensitive:"true"`

	// The optional category filter specified in the request.
	FilterCategories []*string `min:"1" type:"list"`

	// Contains the optional country filter specified in the request.
	FilterCountries []*string `min:"1" type:"list"`

	// The preferred language used to return results. Matches the language in the
	// request. The value is a valid BCP 47 (https://tools.ietf.org/search/bcp47)
	// language tag, for example, en for English.
	Language *string `min:"2" type:"string"`

	// Contains the optional result count limit specified in the request.
	MaxResults *int64 `type:"integer"`

	// The free-form partial text input specified in the request.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForSuggestionsSummary's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForSuggestionsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForSuggestionsSummary) GoString() string {
	return s.String()
}

// SetBiasPosition sets the BiasPosition field's value.
func (s *SearchPlaceIndexForSuggestionsSummary) SetBiasPosition(v []*float64) *SearchPlaceIndexForSuggestionsSummary {
	s.BiasPosition = v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *SearchPlaceIndexForSuggestionsSummary) SetDataSource(v string) *SearchPlaceIndexForSuggestionsSummary {
	s.DataSource = &v
	return s
}

// SetFilterBBox sets the FilterBBox field's value.
func (s *SearchPlaceIndexForSuggestionsSummary) SetFilterBBox(v []*float64) *SearchPlaceIndexForSuggestionsSummary {
	s.FilterBBox = v
	return s
}

// SetFilterCategories sets the FilterCategories field's value.
func (s *SearchPlaceIndexForSuggestionsSummary) SetFilterCategories(v []*string) *SearchPlaceIndexForSuggestionsSummary {
	s.FilterCategories = v
	return s
}

// SetFilterCountries sets the FilterCountries field's value.
func (s *SearchPlaceIndexForSuggestionsSummary) SetFilterCountries(v []*string) *SearchPlaceIndexForSuggestionsSummary {
	s.FilterCountries = v
	return s
}

// SetLanguage sets the Language field's value.
func (s *SearchPlaceIndexForSuggestionsSummary) SetLanguage(v string) *SearchPlaceIndexForSuggestionsSummary {
	s.Language = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchPlaceIndexForSuggestionsSummary) SetMaxResults(v int64) *SearchPlaceIndexForSuggestionsSummary {
	s.MaxResults = &v
	return s
}

// SetText sets the Text field's value.
func (s *SearchPlaceIndexForSuggestionsSummary) SetText(v string) *SearchPlaceIndexForSuggestionsSummary {
	s.Text = &v
	return s
}

type SearchPlaceIndexForTextInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that indicates a preference for places that are closer
	// to a specified position.
	//
	// If provided, this parameter must contain a pair of numbers. The first number
	// represents the X coordinate, or longitude; the second number represents the
	// Y coordinate, or latitude.
	//
	// For example, [-123.1174, 49.2847] represents the position with longitude
	// -123.1174 and latitude 49.2847.
	//
	// BiasPosition and FilterBBox are mutually exclusive. Specifying both options
	// results in an error.
	//
	// BiasPosition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForTextInput's
	// String and GoString methods.
	BiasPosition []*float64 `min:"2" type:"list" sensitive:"true"`

	// An optional parameter that limits the search results by returning only places
	// that are within the provided bounding box.
	//
	// If provided, this parameter must contain a total of four consecutive numbers
	// in two pairs. The first pair of numbers represents the X and Y coordinates
	// (longitude and latitude, respectively) of the southwest corner of the bounding
	// box; the second pair of numbers represents the X and Y coordinates (longitude
	// and latitude, respectively) of the northeast corner of the bounding box.
	//
	// For example, [-12.7935, -37.4835, -12.0684, -36.9542] represents a bounding
	// box where the southwest corner has longitude -12.7935 and latitude -37.4835,
	// and the northeast corner has longitude -12.0684 and latitude -36.9542.
	//
	// FilterBBox and BiasPosition are mutually exclusive. Specifying both options
	// results in an error.
	//
	// FilterBBox is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForTextInput's
	// String and GoString methods.
	FilterBBox []*float64 `min:"4" type:"list" sensitive:"true"`

	// A list of one or more Amazon Location categories to filter the returned places.
	// If you include more than one category, the results will include results that
	// match any of the categories listed.
	//
	// For more information about using categories, including a list of Amazon Location
	// categories, see Categories and filtering (https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html),
	// in the Amazon Location Service Developer Guide.
	FilterCategories []*string `min:"1" type:"list"`

	// An optional parameter that limits the search results by returning only places
	// that are in a specified list of countries.
	//
	//    * Valid values include ISO 3166 (https://www.iso.org/iso-3166-country-codes.html)
	//    3-digit country codes. For example, Australia uses three upper-case characters:
	//    AUS.
	FilterCountries []*string `min:"1" type:"list"`

	// The name of the place index resource you want to use for the search.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`

	// The optional API key (https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
	// to authorize the request.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForTextInput's
	// String and GoString methods.
	Key *string `location:"querystring" locationName:"key" type:"string" sensitive:"true"`

	// The preferred language used to return results. The value must be a valid
	// BCP 47 (https://tools.ietf.org/search/bcp47) language tag, for example, en
	// for English.
	//
	// This setting affects the languages used in the results, but not the results
	// themselves. If no language is specified, or not supported for a particular
	// result, the partner automatically chooses a language for the result.
	//
	// For an example, we'll use the Greek language. You search for Athens, Greece,
	// with the language parameter set to en. The result found will most likely
	// be returned as Athens.
	//
	// If you set the language parameter to el, for Greek, then the result found
	// will more likely be returned as Αθήνα.
	//
	// If the data provider does not have a value for Greek, the result will be
	// in a language that the provider does support.
	Language *string `min:"2" type:"string"`

	// An optional parameter. The maximum number of results returned per request.
	//
	// The default: 50
	MaxResults *int64 `min:"1" type:"integer"`

	// The address, name, city, or region to be used in the search in free-form
	// text format. For example, 123 Any Street.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForTextInput's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForTextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForTextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchPlaceIndexForTextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchPlaceIndexForTextInput"}
	if s.BiasPosition != nil && len(s.BiasPosition) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BiasPosition", 2))
	}
	if s.FilterBBox != nil && len(s.FilterBBox) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("FilterBBox", 4))
	}
	if s.FilterCategories != nil && len(s.FilterCategories) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterCategories", 1))
	}
	if s.FilterCountries != nil && len(s.FilterCountries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterCountries", 1))
	}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.Language != nil && len(*s.Language) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Language", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBiasPosition sets the BiasPosition field's value.
func (s *SearchPlaceIndexForTextInput) SetBiasPosition(v []*float64) *SearchPlaceIndexForTextInput {
	s.BiasPosition = v
	return s
}

// SetFilterBBox sets the FilterBBox field's value.
func (s *SearchPlaceIndexForTextInput) SetFilterBBox(v []*float64) *SearchPlaceIndexForTextInput {
	s.FilterBBox = v
	return s
}

// SetFilterCategories sets the FilterCategories field's value.
func (s *SearchPlaceIndexForTextInput) SetFilterCategories(v []*string) *SearchPlaceIndexForTextInput {
	s.FilterCategories = v
	return s
}

// SetFilterCountries sets the FilterCountries field's value.
func (s *SearchPlaceIndexForTextInput) SetFilterCountries(v []*string) *SearchPlaceIndexForTextInput {
	s.FilterCountries = v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *SearchPlaceIndexForTextInput) SetIndexName(v string) *SearchPlaceIndexForTextInput {
	s.IndexName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *SearchPlaceIndexForTextInput) SetKey(v string) *SearchPlaceIndexForTextInput {
	s.Key = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *SearchPlaceIndexForTextInput) SetLanguage(v string) *SearchPlaceIndexForTextInput {
	s.Language = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchPlaceIndexForTextInput) SetMaxResults(v int64) *SearchPlaceIndexForTextInput {
	s.MaxResults = &v
	return s
}

// SetText sets the Text field's value.
func (s *SearchPlaceIndexForTextInput) SetText(v string) *SearchPlaceIndexForTextInput {
	s.Text = &v
	return s
}

type SearchPlaceIndexForTextOutput struct {
	_ struct{} `type:"structure"`

	// A list of Places matching the input text. Each result contains additional
	// information about the specific point of interest.
	//
	// Not all response properties are included with all responses. Some properties
	// may only be returned by specific data partners.
	//
	// Results is a required field
	Results []*SearchForTextResult `type:"list" required:"true"`

	// Contains a summary of the request. Echoes the input values for BiasPosition,
	// FilterBBox, FilterCountries, Language, MaxResults, and Text. Also includes
	// the DataSource of the place index and the bounding box, ResultBBox, which
	// surrounds the search results.
	//
	// Summary is a required field
	Summary *SearchPlaceIndexForTextSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForTextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForTextOutput) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *SearchPlaceIndexForTextOutput) SetResults(v []*SearchForTextResult) *SearchPlaceIndexForTextOutput {
	s.Results = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *SearchPlaceIndexForTextOutput) SetSummary(v *SearchPlaceIndexForTextSummary) *SearchPlaceIndexForTextOutput {
	s.Summary = v
	return s
}

// A summary of the request sent by using SearchPlaceIndexForText.
type SearchPlaceIndexForTextSummary struct {
	_ struct{} `type:"structure"`

	// Contains the coordinates for the optional bias position specified in the
	// request.
	//
	// This parameter contains a pair of numbers. The first number represents the
	// X coordinate, or longitude; the second number represents the Y coordinate,
	// or latitude.
	//
	// For example, [-123.1174, 49.2847] represents the position with longitude
	// -123.1174 and latitude 49.2847.
	//
	// BiasPosition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForTextSummary's
	// String and GoString methods.
	BiasPosition []*float64 `min:"2" type:"list" sensitive:"true"`

	// The geospatial data provider attached to the place index resource specified
	// in the request. Values can be one of the following:
	//
	//    * Esri
	//
	//    * Grab
	//
	//    * Here
	//
	// For more information about data providers, see Amazon Location Service data
	// providers (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// Contains the coordinates for the optional bounding box specified in the request.
	//
	// FilterBBox is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForTextSummary's
	// String and GoString methods.
	FilterBBox []*float64 `min:"4" type:"list" sensitive:"true"`

	// The optional category filter specified in the request.
	FilterCategories []*string `min:"1" type:"list"`

	// Contains the optional country filter specified in the request.
	FilterCountries []*string `min:"1" type:"list"`

	// The preferred language used to return results. Matches the language in the
	// request. The value is a valid BCP 47 (https://tools.ietf.org/search/bcp47)
	// language tag, for example, en for English.
	Language *string `min:"2" type:"string"`

	// Contains the optional result count limit specified in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The bounding box that fully contains all search results.
	//
	// If you specified the optional FilterBBox parameter in the request, ResultBBox
	// is contained within FilterBBox.
	//
	// ResultBBox is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForTextSummary's
	// String and GoString methods.
	ResultBBox []*float64 `min:"4" type:"list" sensitive:"true"`

	// The search text specified in the request.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchPlaceIndexForTextSummary's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForTextSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchPlaceIndexForTextSummary) GoString() string {
	return s.String()
}

// SetBiasPosition sets the BiasPosition field's value.
func (s *SearchPlaceIndexForTextSummary) SetBiasPosition(v []*float64) *SearchPlaceIndexForTextSummary {
	s.BiasPosition = v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *SearchPlaceIndexForTextSummary) SetDataSource(v string) *SearchPlaceIndexForTextSummary {
	s.DataSource = &v
	return s
}

// SetFilterBBox sets the FilterBBox field's value.
func (s *SearchPlaceIndexForTextSummary) SetFilterBBox(v []*float64) *SearchPlaceIndexForTextSummary {
	s.FilterBBox = v
	return s
}

// SetFilterCategories sets the FilterCategories field's value.
func (s *SearchPlaceIndexForTextSummary) SetFilterCategories(v []*string) *SearchPlaceIndexForTextSummary {
	s.FilterCategories = v
	return s
}

// SetFilterCountries sets the FilterCountries field's value.
func (s *SearchPlaceIndexForTextSummary) SetFilterCountries(v []*string) *SearchPlaceIndexForTextSummary {
	s.FilterCountries = v
	return s
}

// SetLanguage sets the Language field's value.
func (s *SearchPlaceIndexForTextSummary) SetLanguage(v string) *SearchPlaceIndexForTextSummary {
	s.Language = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchPlaceIndexForTextSummary) SetMaxResults(v int64) *SearchPlaceIndexForTextSummary {
	s.MaxResults = &v
	return s
}

// SetResultBBox sets the ResultBBox field's value.
func (s *SearchPlaceIndexForTextSummary) SetResultBBox(v []*float64) *SearchPlaceIndexForTextSummary {
	s.ResultBBox = v
	return s
}

// SetText sets the Text field's value.
func (s *SearchPlaceIndexForTextSummary) SetText(v string) *SearchPlaceIndexForTextSummary {
	s.Text = &v
	return s
}

// The operation was denied because the request would exceed the maximum quota
// (https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html)
// set for Amazon Location Service.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message with the reason for the service quota exceeded exception error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents an element of a leg within a route. A step contains instructions
// for how to move to the next step in the leg.
type Step struct {
	_ struct{} `type:"structure"`

	// The travel distance between the step's StartPosition and EndPosition.
	//
	// Distance is a required field
	Distance *float64 `type:"double" required:"true"`

	// The estimated travel time, in seconds, from the step's StartPosition to the
	// EndPosition. . The travel mode and departure time that you specify in the
	// request determines the calculated time.
	//
	// DurationSeconds is a required field
	DurationSeconds *float64 `type:"double" required:"true"`

	// The end position of a step. If the position the last step in the leg, this
	// position is the same as the end position of the leg.
	//
	// EndPosition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Step's
	// String and GoString methods.
	//
	// EndPosition is a required field
	EndPosition []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// Represents the start position, or index, in a sequence of steps within the
	// leg's line string geometry. For example, the index of the first step in a
	// leg geometry is 0.
	//
	// Included in the response for queries that set IncludeLegGeometry to True.
	GeometryOffset *int64 `type:"integer"`

	// The starting position of a step. If the position is the first step in the
	// leg, this position is the same as the start position of the leg.
	//
	// StartPosition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Step's
	// String and GoString methods.
	//
	// StartPosition is a required field
	StartPosition []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Step) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Step) GoString() string {
	return s.String()
}

// SetDistance sets the Distance field's value.
func (s *Step) SetDistance(v float64) *Step {
	s.Distance = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *Step) SetDurationSeconds(v float64) *Step {
	s.DurationSeconds = &v
	return s
}

// SetEndPosition sets the EndPosition field's value.
func (s *Step) SetEndPosition(v []*float64) *Step {
	s.EndPosition = v
	return s
}

// SetGeometryOffset sets the GeometryOffset field's value.
func (s *Step) SetGeometryOffset(v int64) *Step {
	s.GeometryOffset = &v
	return s
}

// SetStartPosition sets the StartPosition field's value.
func (s *Step) SetStartPosition(v []*float64) *Step {
	s.StartPosition = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource whose tags you want to update.
	//
	//    * Format example: arn:aws:geo:region:account-id:resourcetype/ExampleResource
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// Applies one or more tags to specific resource. A tag is a key-value pair
	// that helps you manage, identify, search, and filter your resources.
	//
	// Format: "key" : "value"
	//
	// Restrictions:
	//
	//    * Maximum 50 tags per resource.
	//
	//    * Each tag key must be unique and must have exactly one associated value.
	//
	//    * Maximum key length: 128 Unicode characters in UTF-8.
	//
	//    * Maximum value length: 256 Unicode characters in UTF-8.
	//
	//    * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
	//    characters: + - = . _ : / @
	//
	//    * Cannot use "aws:" as a prefix for a key.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied because of request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a time zone. Includes the name of the time zone and the
// offset from UTC in seconds.
type TimeZone struct {
	_ struct{} `type:"structure"`

	// The name of the time zone, following the IANA time zone standard (https://www.iana.org/time-zones).
	// For example, America/Los_Angeles.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The time zone's offset, in seconds, from UTC.
	Offset *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *TimeZone) SetName(v string) *TimeZone {
	s.Name = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *TimeZone) SetOffset(v int64) *TimeZone {
	s.Offset = &v
	return s
}

// The geomerty used to filter device positions.
type TrackingFilterGeometry struct {
	_ struct{} `type:"structure"`

	// The set of arrays which define the polygon. A polygon can have between 4
	// and 1000 vertices.
	Polygon [][][]*float64 `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrackingFilterGeometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrackingFilterGeometry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrackingFilterGeometry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrackingFilterGeometry"}
	if s.Polygon != nil && len(s.Polygon) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Polygon", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolygon sets the Polygon field's value.
func (s *TrackingFilterGeometry) SetPolygon(v [][][]*float64) *TrackingFilterGeometry {
	s.Polygon = v
	return s
}

// Contains details about the truck dimensions in the unit of measurement that
// you specify. Used to filter out roads that can't support or allow the specified
// dimensions for requests that specify TravelMode as Truck.
type TruckDimensions struct {
	_ struct{} `type:"structure"`

	// The height of the truck.
	//
	//    * For example, 4.5.
	//
	// For routes calculated with a HERE resource, this value must be between 0
	// and 50 meters.
	Height *float64 `type:"double"`

	// The length of the truck.
	//
	//    * For example, 15.5.
	//
	// For routes calculated with a HERE resource, this value must be between 0
	// and 300 meters.
	Length *float64 `type:"double"`

	// Specifies the unit of measurement for the truck dimensions.
	//
	// Default Value: Meters
	Unit *string `type:"string" enum:"DimensionUnit"`

	// The width of the truck.
	//
	//    * For example, 4.5.
	//
	// For routes calculated with a HERE resource, this value must be between 0
	// and 50 meters.
	Width *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TruckDimensions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TruckDimensions) GoString() string {
	return s.String()
}

// SetHeight sets the Height field's value.
func (s *TruckDimensions) SetHeight(v float64) *TruckDimensions {
	s.Height = &v
	return s
}

// SetLength sets the Length field's value.
func (s *TruckDimensions) SetLength(v float64) *TruckDimensions {
	s.Length = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *TruckDimensions) SetUnit(v string) *TruckDimensions {
	s.Unit = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *TruckDimensions) SetWidth(v float64) *TruckDimensions {
	s.Width = &v
	return s
}

// Contains details about the truck's weight specifications. Used to avoid roads
// that can't support or allow the total weight for requests that specify TravelMode
// as Truck.
type TruckWeight struct {
	_ struct{} `type:"structure"`

	// The total weight of the truck.
	//
	//    * For example, 3500.
	Total *float64 `type:"double"`

	// The unit of measurement to use for the truck weight.
	//
	// Default Value: Kilograms
	Unit *string `type:"string" enum:"VehicleWeightUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TruckWeight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TruckWeight) GoString() string {
	return s.String()
}

// SetTotal sets the Total field's value.
func (s *TruckWeight) SetTotal(v float64) *TruckWeight {
	s.Total = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *TruckWeight) SetUnit(v string) *TruckWeight {
	s.Unit = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource from which you want to remove
	// tags.
	//
	//    * Format example: arn:aws:geo:region:account-id:resourcetype/ExampleResource
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The list of tag keys to remove from the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateGeofenceCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the geofence collection to update.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// Updates the description for the geofence collection.
	Description *string `type:"string"`

	// No longer used. If included, the only allowed value is RequestBasedUsage.
	//
	// Deprecated: Deprecated. If included, the only allowed value is RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// This parameter is no longer used.
	//
	// Deprecated: Deprecated. No longer allowed.
	PricingPlanDataSource *string `deprecated:"true" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGeofenceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGeofenceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGeofenceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGeofenceCollectionInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *UpdateGeofenceCollectionInput) SetCollectionName(v string) *UpdateGeofenceCollectionInput {
	s.CollectionName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateGeofenceCollectionInput) SetDescription(v string) *UpdateGeofenceCollectionInput {
	s.Description = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *UpdateGeofenceCollectionInput) SetPricingPlan(v string) *UpdateGeofenceCollectionInput {
	s.PricingPlan = &v
	return s
}

// SetPricingPlanDataSource sets the PricingPlanDataSource field's value.
func (s *UpdateGeofenceCollectionInput) SetPricingPlanDataSource(v string) *UpdateGeofenceCollectionInput {
	s.PricingPlanDataSource = &v
	return s
}

type UpdateGeofenceCollectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated geofence collection. Used to
	// specify a resource across Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection
	//
	// CollectionArn is a required field
	CollectionArn *string `type:"string" required:"true"`

	// The name of the updated geofence collection.
	//
	// CollectionName is a required field
	CollectionName *string `min:"1" type:"string" required:"true"`

	// The time when the geofence collection was last updated in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGeofenceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGeofenceCollectionOutput) GoString() string {
	return s.String()
}

// SetCollectionArn sets the CollectionArn field's value.
func (s *UpdateGeofenceCollectionOutput) SetCollectionArn(v string) *UpdateGeofenceCollectionOutput {
	s.CollectionArn = &v
	return s
}

// SetCollectionName sets the CollectionName field's value.
func (s *UpdateGeofenceCollectionOutput) SetCollectionName(v string) *UpdateGeofenceCollectionOutput {
	s.CollectionName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateGeofenceCollectionOutput) SetUpdateTime(v time.Time) *UpdateGeofenceCollectionOutput {
	s.UpdateTime = &v
	return s
}

type UpdateKeyInput struct {
	_ struct{} `type:"structure"`

	// Updates the description for the API key resource.
	Description *string `type:"string"`

	// Updates the timestamp for when the API key resource will expire in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	ExpireTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The boolean flag to be included for updating ExpireTime or Restrictions details.
	//
	// Must be set to true to update an API key resource that has been used in the
	// past 7 days.
	//
	// False if force update is not preferred
	//
	// Default value: False
	ForceUpdate *bool `type:"boolean"`

	// The name of the API key resource to update.
	//
	// KeyName is a required field
	KeyName *string `location:"uri" locationName:"KeyName" min:"1" type:"string" required:"true"`

	// Whether the API key should expire. Set to true to set the API key to have
	// no expiration time.
	NoExpiry *bool `type:"boolean"`

	// Updates the API key restrictions for the API key resource.
	Restrictions *ApiKeyRestrictions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKeyInput"}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.Restrictions != nil {
		if err := s.Restrictions.Validate(); err != nil {
			invalidParams.AddNested("Restrictions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateKeyInput) SetDescription(v string) *UpdateKeyInput {
	s.Description = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *UpdateKeyInput) SetExpireTime(v time.Time) *UpdateKeyInput {
	s.ExpireTime = &v
	return s
}

// SetForceUpdate sets the ForceUpdate field's value.
func (s *UpdateKeyInput) SetForceUpdate(v bool) *UpdateKeyInput {
	s.ForceUpdate = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *UpdateKeyInput) SetKeyName(v string) *UpdateKeyInput {
	s.KeyName = &v
	return s
}

// SetNoExpiry sets the NoExpiry field's value.
func (s *UpdateKeyInput) SetNoExpiry(v bool) *UpdateKeyInput {
	s.NoExpiry = &v
	return s
}

// SetRestrictions sets the Restrictions field's value.
func (s *UpdateKeyInput) SetRestrictions(v *ApiKeyRestrictions) *UpdateKeyInput {
	s.Restrictions = v
	return s
}

type UpdateKeyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the API key resource. Used when you need
	// to specify a resource across all Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:key/ExampleKey
	//
	// KeyArn is a required field
	KeyArn *string `type:"string" required:"true"`

	// The name of the API key resource.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the API key resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeyOutput) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *UpdateKeyOutput) SetKeyArn(v string) *UpdateKeyOutput {
	s.KeyArn = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *UpdateKeyOutput) SetKeyName(v string) *UpdateKeyOutput {
	s.KeyName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateKeyOutput) SetUpdateTime(v time.Time) *UpdateKeyOutput {
	s.UpdateTime = &v
	return s
}

type UpdateMapInput struct {
	_ struct{} `type:"structure"`

	// Updates the parts of the map configuration that can be updated, including
	// the political view.
	ConfigurationUpdate *MapConfigurationUpdate `type:"structure"`

	// Updates the description for the map resource.
	Description *string `type:"string"`

	// The name of the map resource to update.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`

	// No longer used. If included, the only allowed value is RequestBasedUsage.
	//
	// Deprecated: Deprecated. If included, the only allowed value is RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMapInput"}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationUpdate sets the ConfigurationUpdate field's value.
func (s *UpdateMapInput) SetConfigurationUpdate(v *MapConfigurationUpdate) *UpdateMapInput {
	s.ConfigurationUpdate = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateMapInput) SetDescription(v string) *UpdateMapInput {
	s.Description = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *UpdateMapInput) SetMapName(v string) *UpdateMapInput {
	s.MapName = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *UpdateMapInput) SetPricingPlan(v string) *UpdateMapInput {
	s.PricingPlan = &v
	return s
}

type UpdateMapOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated map resource. Used to specify
	// a resource across AWS.
	//
	//    * Format example: arn:aws:geo:region:account-id:map/ExampleMap
	//
	// MapArn is a required field
	MapArn *string `type:"string" required:"true"`

	// The name of the updated map resource.
	//
	// MapName is a required field
	MapName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the map resource was last updated in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMapOutput) GoString() string {
	return s.String()
}

// SetMapArn sets the MapArn field's value.
func (s *UpdateMapOutput) SetMapArn(v string) *UpdateMapOutput {
	s.MapArn = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *UpdateMapOutput) SetMapName(v string) *UpdateMapOutput {
	s.MapName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateMapOutput) SetUpdateTime(v time.Time) *UpdateMapOutput {
	s.UpdateTime = &v
	return s
}

type UpdatePlaceIndexInput struct {
	_ struct{} `type:"structure"`

	// Updates the data storage option for the place index resource.
	DataSourceConfiguration *DataSourceConfiguration `type:"structure"`

	// Updates the description for the place index resource.
	Description *string `type:"string"`

	// The name of the place index resource to update.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`

	// No longer used. If included, the only allowed value is RequestBasedUsage.
	//
	// Deprecated: Deprecated. If included, the only allowed value is RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePlaceIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePlaceIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePlaceIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePlaceIndexInput"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *UpdatePlaceIndexInput) SetDataSourceConfiguration(v *DataSourceConfiguration) *UpdatePlaceIndexInput {
	s.DataSourceConfiguration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdatePlaceIndexInput) SetDescription(v string) *UpdatePlaceIndexInput {
	s.Description = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *UpdatePlaceIndexInput) SetIndexName(v string) *UpdatePlaceIndexInput {
	s.IndexName = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *UpdatePlaceIndexInput) SetPricingPlan(v string) *UpdatePlaceIndexInput {
	s.PricingPlan = &v
	return s
}

type UpdatePlaceIndexOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the upated place index resource. Used to
	// specify a resource across Amazon Web Services.
	//
	//    * Format example: arn:aws:geo:region:account-id:place- index/ExamplePlaceIndex
	//
	// IndexArn is a required field
	IndexArn *string `type:"string" required:"true"`

	// The name of the updated place index resource.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the place index resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePlaceIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePlaceIndexOutput) GoString() string {
	return s.String()
}

// SetIndexArn sets the IndexArn field's value.
func (s *UpdatePlaceIndexOutput) SetIndexArn(v string) *UpdatePlaceIndexOutput {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *UpdatePlaceIndexOutput) SetIndexName(v string) *UpdatePlaceIndexOutput {
	s.IndexName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdatePlaceIndexOutput) SetUpdateTime(v time.Time) *UpdatePlaceIndexOutput {
	s.UpdateTime = &v
	return s
}

type UpdateRouteCalculatorInput struct {
	_ struct{} `type:"structure"`

	// The name of the route calculator resource to update.
	//
	// CalculatorName is a required field
	CalculatorName *string `location:"uri" locationName:"CalculatorName" min:"1" type:"string" required:"true"`

	// Updates the description for the route calculator resource.
	Description *string `type:"string"`

	// No longer used. If included, the only allowed value is RequestBasedUsage.
	//
	// Deprecated: Deprecated. If included, the only allowed value is RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRouteCalculatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRouteCalculatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRouteCalculatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRouteCalculatorInput"}
	if s.CalculatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("CalculatorName"))
	}
	if s.CalculatorName != nil && len(*s.CalculatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CalculatorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCalculatorName sets the CalculatorName field's value.
func (s *UpdateRouteCalculatorInput) SetCalculatorName(v string) *UpdateRouteCalculatorInput {
	s.CalculatorName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateRouteCalculatorInput) SetDescription(v string) *UpdateRouteCalculatorInput {
	s.Description = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *UpdateRouteCalculatorInput) SetPricingPlan(v string) *UpdateRouteCalculatorInput {
	s.PricingPlan = &v
	return s
}

type UpdateRouteCalculatorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated route calculator resource.
	// Used to specify a resource across AWS.
	//
	//    * Format example: arn:aws:geo:region:account-id:route- calculator/ExampleCalculator
	//
	// CalculatorArn is a required field
	CalculatorArn *string `type:"string" required:"true"`

	// The name of the updated route calculator resource.
	//
	// CalculatorName is a required field
	CalculatorName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the route calculator was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRouteCalculatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRouteCalculatorOutput) GoString() string {
	return s.String()
}

// SetCalculatorArn sets the CalculatorArn field's value.
func (s *UpdateRouteCalculatorOutput) SetCalculatorArn(v string) *UpdateRouteCalculatorOutput {
	s.CalculatorArn = &v
	return s
}

// SetCalculatorName sets the CalculatorName field's value.
func (s *UpdateRouteCalculatorOutput) SetCalculatorName(v string) *UpdateRouteCalculatorOutput {
	s.CalculatorName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateRouteCalculatorOutput) SetUpdateTime(v time.Time) *UpdateRouteCalculatorOutput {
	s.UpdateTime = &v
	return s
}

type UpdateTrackerInput struct {
	_ struct{} `type:"structure"`

	// Updates the description for the tracker resource.
	Description *string `type:"string"`

	// Whether to enable position UPDATE events from this tracker to be sent to
	// EventBridge.
	//
	// You do not need enable this feature to get ENTER and EXIT events for geofences
	// with this tracker. Those events are always sent to EventBridge.
	EventBridgeEnabled *bool `type:"boolean"`

	// Enables GeospatialQueries for a tracker that uses a Amazon Web Services KMS
	// customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
	//
	// This parameter is only used if you are using a KMS customer managed key.
	KmsKeyEnableGeospatialQueries *bool `type:"boolean"`

	// Updates the position filtering for the tracker resource.
	//
	// Valid values:
	//
	//    * TimeBased - Location updates are evaluated against linked geofence collections,
	//    but not every location update is stored. If your update frequency is more
	//    often than 30 seconds, only one update per 30 seconds is stored for each
	//    unique device ID.
	//
	//    * DistanceBased - If the device has moved less than 30 m (98.4 ft), location
	//    updates are ignored. Location updates within this distance are neither
	//    evaluated against linked geofence collections, nor stored. This helps
	//    control costs by reducing the number of geofence evaluations and historical
	//    device positions to paginate through. Distance-based filtering can also
	//    reduce the effects of GPS noise when displaying device trajectories on
	//    a map.
	//
	//    * AccuracyBased - If the device has moved less than the measured accuracy,
	//    location updates are ignored. For example, if two consecutive updates
	//    from a device have a horizontal accuracy of 5 m and 10 m, the second update
	//    is ignored if the device has moved less than 15 m. Ignored location updates
	//    are neither evaluated against linked geofence collections, nor stored.
	//    This helps educe the effects of GPS noise when displaying device trajectories
	//    on a map, and can help control costs by reducing the number of geofence
	//    evaluations.
	PositionFiltering *string `type:"string" enum:"PositionFiltering"`

	// No longer used. If included, the only allowed value is RequestBasedUsage.
	//
	// Deprecated: Deprecated. If included, the only allowed value is RequestBasedUsage.
	PricingPlan *string `deprecated:"true" type:"string" enum:"PricingPlan"`

	// This parameter is no longer used.
	//
	// Deprecated: Deprecated. No longer allowed.
	PricingPlanDataSource *string `deprecated:"true" type:"string"`

	// The name of the tracker resource to update.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrackerInput"}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateTrackerInput) SetDescription(v string) *UpdateTrackerInput {
	s.Description = &v
	return s
}

// SetEventBridgeEnabled sets the EventBridgeEnabled field's value.
func (s *UpdateTrackerInput) SetEventBridgeEnabled(v bool) *UpdateTrackerInput {
	s.EventBridgeEnabled = &v
	return s
}

// SetKmsKeyEnableGeospatialQueries sets the KmsKeyEnableGeospatialQueries field's value.
func (s *UpdateTrackerInput) SetKmsKeyEnableGeospatialQueries(v bool) *UpdateTrackerInput {
	s.KmsKeyEnableGeospatialQueries = &v
	return s
}

// SetPositionFiltering sets the PositionFiltering field's value.
func (s *UpdateTrackerInput) SetPositionFiltering(v string) *UpdateTrackerInput {
	s.PositionFiltering = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *UpdateTrackerInput) SetPricingPlan(v string) *UpdateTrackerInput {
	s.PricingPlan = &v
	return s
}

// SetPricingPlanDataSource sets the PricingPlanDataSource field's value.
func (s *UpdateTrackerInput) SetPricingPlanDataSource(v string) *UpdateTrackerInput {
	s.PricingPlanDataSource = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *UpdateTrackerInput) SetTrackerName(v string) *UpdateTrackerInput {
	s.TrackerName = &v
	return s
}

type UpdateTrackerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated tracker resource. Used to specify
	// a resource across AWS.
	//
	//    * Format example: arn:aws:geo:region:account-id:tracker/ExampleTracker
	//
	// TrackerArn is a required field
	TrackerArn *string `type:"string" required:"true"`

	// The name of the updated tracker resource.
	//
	// TrackerName is a required field
	TrackerName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the tracker resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrackerOutput) GoString() string {
	return s.String()
}

// SetTrackerArn sets the TrackerArn field's value.
func (s *UpdateTrackerOutput) SetTrackerArn(v string) *UpdateTrackerOutput {
	s.TrackerArn = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *UpdateTrackerOutput) SetTrackerName(v string) *UpdateTrackerOutput {
	s.TrackerName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateTrackerOutput) SetUpdateTime(v time.Time) *UpdateTrackerOutput {
	s.UpdateTime = &v
	return s
}

// The input failed to meet the constraints specified by the AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The field where the invalid entry was detected.
	//
	// FieldList is a required field
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// A message with the reason for the validation exception error.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input failed to meet the constraints specified by the AWS service in
// a specified field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message with the reason for the validation exception error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The field name where the invalid entry was detected.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// BatchItemErrorCodeAccessDeniedError is a BatchItemErrorCode enum value
	BatchItemErrorCodeAccessDeniedError = "AccessDeniedError"

	// BatchItemErrorCodeConflictError is a BatchItemErrorCode enum value
	BatchItemErrorCodeConflictError = "ConflictError"

	// BatchItemErrorCodeInternalServerError is a BatchItemErrorCode enum value
	BatchItemErrorCodeInternalServerError = "InternalServerError"

	// BatchItemErrorCodeResourceNotFoundError is a BatchItemErrorCode enum value
	BatchItemErrorCodeResourceNotFoundError = "ResourceNotFoundError"

	// BatchItemErrorCodeThrottlingError is a BatchItemErrorCode enum value
	BatchItemErrorCodeThrottlingError = "ThrottlingError"

	// BatchItemErrorCodeValidationError is a BatchItemErrorCode enum value
	BatchItemErrorCodeValidationError = "ValidationError"
)

// BatchItemErrorCode_Values returns all elements of the BatchItemErrorCode enum
func BatchItemErrorCode_Values() []string {
	return []string{
		BatchItemErrorCodeAccessDeniedError,
		BatchItemErrorCodeConflictError,
		BatchItemErrorCodeInternalServerError,
		BatchItemErrorCodeResourceNotFoundError,
		BatchItemErrorCodeThrottlingError,
		BatchItemErrorCodeValidationError,
	}
}

const (
	// DimensionUnitMeters is a DimensionUnit enum value
	DimensionUnitMeters = "Meters"

	// DimensionUnitFeet is a DimensionUnit enum value
	DimensionUnitFeet = "Feet"
)

// DimensionUnit_Values returns all elements of the DimensionUnit enum
func DimensionUnit_Values() []string {
	return []string{
		DimensionUnitMeters,
		DimensionUnitFeet,
	}
}

const (
	// DistanceUnitKilometers is a DistanceUnit enum value
	DistanceUnitKilometers = "Kilometers"

	// DistanceUnitMiles is a DistanceUnit enum value
	DistanceUnitMiles = "Miles"
)

// DistanceUnit_Values returns all elements of the DistanceUnit enum
func DistanceUnit_Values() []string {
	return []string{
		DistanceUnitKilometers,
		DistanceUnitMiles,
	}
}

const (
	// IntendedUseSingleUse is a IntendedUse enum value
	IntendedUseSingleUse = "SingleUse"

	// IntendedUseStorage is a IntendedUse enum value
	IntendedUseStorage = "Storage"
)

// IntendedUse_Values returns all elements of the IntendedUse enum
func IntendedUse_Values() []string {
	return []string{
		IntendedUseSingleUse,
		IntendedUseStorage,
	}
}

const (
	// PositionFilteringTimeBased is a PositionFiltering enum value
	PositionFilteringTimeBased = "TimeBased"

	// PositionFilteringDistanceBased is a PositionFiltering enum value
	PositionFilteringDistanceBased = "DistanceBased"

	// PositionFilteringAccuracyBased is a PositionFiltering enum value
	PositionFilteringAccuracyBased = "AccuracyBased"
)

// PositionFiltering_Values returns all elements of the PositionFiltering enum
func PositionFiltering_Values() []string {
	return []string{
		PositionFilteringTimeBased,
		PositionFilteringDistanceBased,
		PositionFilteringAccuracyBased,
	}
}

const (
	// PricingPlanRequestBasedUsage is a PricingPlan enum value
	PricingPlanRequestBasedUsage = "RequestBasedUsage"

	// PricingPlanMobileAssetTracking is a PricingPlan enum value
	PricingPlanMobileAssetTracking = "MobileAssetTracking"

	// PricingPlanMobileAssetManagement is a PricingPlan enum value
	PricingPlanMobileAssetManagement = "MobileAssetManagement"
)

// PricingPlan_Values returns all elements of the PricingPlan enum
func PricingPlan_Values() []string {
	return []string{
		PricingPlanRequestBasedUsage,
		PricingPlanMobileAssetTracking,
		PricingPlanMobileAssetManagement,
	}
}

const (
	// RouteMatrixErrorCodeRouteNotFound is a RouteMatrixErrorCode enum value
	RouteMatrixErrorCodeRouteNotFound = "RouteNotFound"

	// RouteMatrixErrorCodeRouteTooLong is a RouteMatrixErrorCode enum value
	RouteMatrixErrorCodeRouteTooLong = "RouteTooLong"

	// RouteMatrixErrorCodePositionsNotFound is a RouteMatrixErrorCode enum value
	RouteMatrixErrorCodePositionsNotFound = "PositionsNotFound"

	// RouteMatrixErrorCodeDestinationPositionNotFound is a RouteMatrixErrorCode enum value
	RouteMatrixErrorCodeDestinationPositionNotFound = "DestinationPositionNotFound"

	// RouteMatrixErrorCodeDeparturePositionNotFound is a RouteMatrixErrorCode enum value
	RouteMatrixErrorCodeDeparturePositionNotFound = "DeparturePositionNotFound"

	// RouteMatrixErrorCodeOtherValidationError is a RouteMatrixErrorCode enum value
	RouteMatrixErrorCodeOtherValidationError = "OtherValidationError"
)

// RouteMatrixErrorCode_Values returns all elements of the RouteMatrixErrorCode enum
func RouteMatrixErrorCode_Values() []string {
	return []string{
		RouteMatrixErrorCodeRouteNotFound,
		RouteMatrixErrorCodeRouteTooLong,
		RouteMatrixErrorCodePositionsNotFound,
		RouteMatrixErrorCodeDestinationPositionNotFound,
		RouteMatrixErrorCodeDeparturePositionNotFound,
		RouteMatrixErrorCodeOtherValidationError,
	}
}

const (
	// StatusActive is a Status enum value
	StatusActive = "Active"

	// StatusExpired is a Status enum value
	StatusExpired = "Expired"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusActive,
		StatusExpired,
	}
}

const (
	// TravelModeCar is a TravelMode enum value
	TravelModeCar = "Car"

	// TravelModeTruck is a TravelMode enum value
	TravelModeTruck = "Truck"

	// TravelModeWalking is a TravelMode enum value
	TravelModeWalking = "Walking"

	// TravelModeBicycle is a TravelMode enum value
	TravelModeBicycle = "Bicycle"

	// TravelModeMotorcycle is a TravelMode enum value
	TravelModeMotorcycle = "Motorcycle"
)

// TravelMode_Values returns all elements of the TravelMode enum
func TravelMode_Values() []string {
	return []string{
		TravelModeCar,
		TravelModeTruck,
		TravelModeWalking,
		TravelModeBicycle,
		TravelModeMotorcycle,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UnknownOperation"

	// ValidationExceptionReasonMissing is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissing = "Missing"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "Other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonMissing,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

const (
	// VehicleWeightUnitKilograms is a VehicleWeightUnit enum value
	VehicleWeightUnitKilograms = "Kilograms"

	// VehicleWeightUnitPounds is a VehicleWeightUnit enum value
	VehicleWeightUnitPounds = "Pounds"
)

// VehicleWeightUnit_Values returns all elements of the VehicleWeightUnit enum
func VehicleWeightUnit_Values() []string {
	return []string{
		VehicleWeightUnitKilograms,
		VehicleWeightUnitPounds,
	}
}
