package mimedb

var (
	mimeTypeToExts = map[string][]string{
		"application/x-authorware-map":                           []string{"aam"},
		"text/x-nfo":                                             []string{"nfo"},
		"text/x-java-source":                                     []string{"java"},
		"application/mp4":                                        []string{"mp4s", "m4p"},
		"application/vnd.osgi.subsystem":                         []string{"esa"},
		"application/vnd.xara":                                   []string{"xar"},
		"application/vnd.crick.clicker.template":                 []string{"clkt"},
		"application/vnd.ms-powerpoint.template.macroenabled.12": []string{"potm"},
		"image/vnd.ms-modi":                                      []string{"mdi"},
		"application/x-virtualbox-hdd":                           []string{"hdd"},
		"application/vnd.anser-web-funds-transfer-initiation":    []string{"fti"},
		"audio/mp3":                                               []string{"mp3"},
		"application/vnd.micrografx.flo":                          []string{"flo"},
		"text/markdown":                                           []string{"markdown", "md"},
		"application/x-install-instructions":                      []string{"install"},
		"application/metalink4+xml":                               []string{"meta4"},
		"audio/x-wav":                                             []string{"wav"},
		"text/x-sfv":                                              []string{"sfv"},
		"application/atomsvc+xml":                                 []string{"atomsvc"},
		"application/set-registration-initiation":                 []string{"setreg"},
		"application/vnd.tao.intent-module-archive":               []string{"tao"},
		"application/oebps-package+xml":                           []string{"opf"},
		"application/vnd.ms-officetheme":                          []string{"thmx"},
		"image/vnd.fst":                                           []string{"fst"},
		"text/vnd.graphviz":                                       []string{"gv"},
		"application/x-cdlink":                                    []string{"vcd"},
		"application/vnd.smart.teacher":                           []string{"teacher"},
		"application/sparql-query":                                []string{"rq"},
		"video/vnd.dece.sd":                                       []string{"uvs", "uvvs"},
		"application/vnd.publishare-delta-tree":                   []string{"qps"},
		"application/vnd.recordare.musicxml":                      []string{"mxl"},
		"application/vnd.stardivision.math":                       []string{"smf"},
		"application/vnd.wap.wmlscriptc":                          []string{"wmlsc"},
		"application/vnd.dolby.mlp":                               []string{"mlp"},
		"application/vnd.fujitsu.oasys2":                          []string{"oa2"},
		"application/vnd.fujitsu.oasys3":                          []string{"oa3"},
		"application/vnd.nokia.radio-preset":                      []string{"rpst"},
		"application/x-nzb":                                       []string{"nzb"},
		"application/vnd.smaf":                                    []string{"mmf"},
		"text/vnd.curl.dcurl":                                     []string{"dcurl"},
		"application/vnd.geoplan":                                 []string{"g2w"},
		"application/x-pkcs7-certreqresp":                         []string{"p7r"},
		"application/vnd.lotus-organizer":                         []string{"org"},
		"application/vnd.trueapp":                                 []string{"tra"},
		"application/x-cpio":                                      []string{"cpio"},
		"application/vnd.is-xpr":                                  []string{"xpr"},
		"application/vnd.oasis.opendocument.spreadsheet-template": []string{"ots"},
		"text/coffeescript":                                       []string{"coffee", "litcoffee"},
		"application/resource-lists-diff+xml":                     []string{"rld"},
		"application/smil+xml":                                    []string{"smi", "smil"},
		"application/jsonml+json":                                 []string{"jsonml"},
		"application/mets+xml":                                    []string{"mets"},
		"application/vnd.vcx":                                     []string{"vcx"},
		"application/x-bzip2":                                     []string{"bz2", "boz"},
		"video/mpeg":                                              []string{"mpeg", "mpg", "mpe", "m1v", "m2v"},
		"application/vnd.dreamfactory":                            []string{"dfac"},
		"application/vnd.previewsystems.box":                      []string{"box"},
		"application/vnd.geonext":                                 []string{"gxt"},
		"audio/ogg":                                               []string{"oga", "ogg", "spx"},
		"application/cu-seeme":                                    []string{"cu"},
		"application/vnd.kenameaapp":                              []string{"htke"},
		"application/vnd.yamaha.smaf-audio":                       []string{"saf"},
		"audio/mpeg":                                              []string{"mpga", "mp2", "mp2a", "mp3", "m2a", "m3a"},
		"application/vnd.ms-word.template.macroenabled.12":                          []string{"dotm"},
		"application/vnd.oasis.opendocument.presentation":                           []string{"odp"},
		"application/vnd.intu.qfx":                                                  []string{"qfx"},
		"application/x-lua-bytecode":                                                []string{"luac"},
		"application/x-virtualbox-vbox-extpack":                                     []string{"vbox-extpack"},
		"application/vnd.mfmp":                                                      []string{"mfm"},
		"application/vnd.pg.format":                                                 []string{"str"},
		"application/vnd.simtech-mindmapper":                                        []string{"twd", "twds"},
		"application/vnd.cups-ppd":                                                  []string{"ppd"},
		"application/vnd.groove-identity-message":                                   []string{"gim"},
		"application/docbook+xml":                                                   []string{"dbk"},
		"application/vnd.zul":                                                       []string{"zir", "zirz"},
		"image/vnd.dvb.subtitle":                                                    []string{"sub"},
		"video/x-f4v":                                                               []string{"f4v"},
		"image/jp2":                                                                 []string{"jp2", "jpg2"},
		"application/vnd.adobe.xdp+xml":                                             []string{"xdp"},
		"application/vnd.claymore":                                                  []string{"cla"},
		"application/vnd.ezpix-album":                                               []string{"ez2"},
		"application/vnd.zzazz.deck+xml":                                            []string{"zaz"},
		"application/vnd.triscape.mxs":                                              []string{"mxs"},
		"image/x-cmu-raster":                                                        []string{"ras"},
		"video/vnd.dece.pd":                                                         []string{"uvp", "uvvp"},
		"application/vnd.groove-vcard":                                              []string{"vcg"},
		"application/vnd.ms-powerpoint.addin.macroenabled.12":                       []string{"ppam"},
		"application/vnd.realvnc.bed":                                               []string{"bed"},
		"application/vnd.yamaha.hv-dic":                                             []string{"hvd"},
		"application/x-dtbncx+xml":                                                  []string{"ncx"},
		"application/x-xz":                                                          []string{"xz"},
		"image/x-xwindowdump":                                                       []string{"xwd"},
		"application/pdf":                                                           []string{"pdf"},
		"application/vnd.isac.fcs":                                                  []string{"fcs"},
		"text/vnd.wap.wmlscript":                                                    []string{"wmls"},
		"video/vnd.uvvu.mp4":                                                        []string{"uvu", "uvvu"},
		"application/vnd.jam":                                                       []string{"jam"},
		"application/vnd.ms-wpl":                                                    []string{"wpl"},
		"application/vnd.ahead.space":                                               []string{"ahead"},
		"application/vnd.sun.xml.calc.template":                                     []string{"stc"},
		"text/html":                                                                 []string{"html", "htm", "shtml"},
		"application/vnd.amiga.ami":                                                 []string{"ami"},
		"application/vnd.ms-powerpoint":                                             []string{"ppt", "pps", "pot"},
		"application/vnd.businessobjects":                                           []string{"rep"},
		"application/vnd.hp-hpgl":                                                   []string{"hpgl"},
		"application/vnd.mediastation.cdkey":                                        []string{"cdkey"},
		"application/x-sh":                                                          []string{"sh"},
		"application/ld+json":                                                       []string{"jsonld"},
		"application/vnd.fuzzysheet":                                                []string{"fzs"},
		"application/vnd.flographit":                                                []string{"gph"},
		"application/vnd.shana.informed.package":                                    []string{"ipk"},
		"audio/x-ms-wma":                                                            []string{"wma"},
		"image/sgi":                                                                 []string{"sgi"},
		"application/ipfix":                                                         []string{"ipfix"},
		"application/vnd.geogebra.tool":                                             []string{"ggt"},
		"application/marc":                                                          []string{"mrc"},
		"application/x-font-linux-psf":                                              []string{"psf"},
		"application/vnd.kde.kivio":                                                 []string{"flw"},
		"application/vnd.mynfc":                                                     []string{"taglet"},
		"application/vnd.osgeo.mapguide.package":                                    []string{"mgp"},
		"text/vnd.in3d.spot":                                                        []string{"spot"},
		"application/oda":                                                           []string{"oda"},
		"application/marcxml+xml":                                                   []string{"mrcx"},
		"audio/x-flac":                                                              []string{"flac"},
		"video/vnd.vivo":                                                            []string{"viv"},
		"application/vnd.adobe.formscentral.fcdt":                                   []string{"fcdt"},
		"model/x3d+binary":                                                          []string{"x3db", "x3dbz"},
		"text/rtf":                                                                  []string{"rtf"},
		"video/vnd.ms-playready.media.pyv":                                          []string{"pyv"},
		"application/tei+xml":                                                       []string{"tei", "teicorpus"},
		"application/vnd.ms-powerpoint.presentation.macroenabled.12":                []string{"pptm"},
		"font/collection":                                                           []string{"ttc"},
		"application/x-ns-proxy-autoconfig":                                         []string{"pac"},
		"application/vnd.accpac.simply.aso":                                         []string{"aso"},
		"application/x-font-pcf":                                                    []string{"pcf"},
		"application/x-zmachine":                                                    []string{"z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8"},
		"application/vnd.commonspace":                                               []string{"csp"},
		"application/vnd.syncml.dm+wbxml":                                           []string{"bdm"},
		"application/x-dtbresource+xml":                                             []string{"res"},
		"application/vnd.wap.wbxml":                                                 []string{"wbxml"},
		"application/vnd.openxmlformats-officedocument.presentationml.presentation": []string{"pptx"},
		"application/set-payment-initiation":                                        []string{"setpay"},
		"application/vnd.oasis.opendocument.formula":                                []string{"odf"},
		"application/x-msmediaview":                                                 []string{"mvb", "m13", "m14"},
		"application/onenote":                                                       []string{"onetoc", "onetoc2", "onetmp", "onepkg"},
		"application/vnd.oasis.opendocument.formula-template":                       []string{"odft"},
		"application/rpki-ghostbusters":                                             []string{"gbr"},
		"application/vnd.intergeo":                                                  []string{"i2g"},
		"application/vnd.oasis.opendocument.image":                                  []string{"odi"},
		"text/n3":                                        []string{"n3"},
		"image/x-pcx":                                    []string{"pcx"},
		"video/3gpp2":                                    []string{"3g2"},
		"application/pkix-crl":                           []string{"crl"},
		"application/vnd.geometry-explorer":              []string{"gex", "gre"},
		"application/vnd.mcd":                            []string{"mcd"},
		"application/vnd.blueice.multipass":              []string{"mpm"},
		"application/wsdl+xml":                           []string{"wsdl"},
		"application/x-httpd-php":                        []string{"php"},
		"application/x-xpinstall":                        []string{"xpi"},
		"text/vnd.in3d.3dml":                             []string{"3dml"},
		"video/x-fli":                                    []string{"fli"},
		"application/vnd.yamaha.hv-voice":                []string{"hvp"},
		"image/x-icon":                                   []string{"ico"},
		"application/vnd.novadigm.edx":                   []string{"edx"},
		"application/vnd.rim.cod":                        []string{"cod"},
		"text/jade":                                      []string{"jade"},
		"application/epub+zip":                           []string{"epub"},
		"application/x-doom":                             []string{"wad"},
		"application/pkcs7-mime":                         []string{"p7m", "p7c"},
		"application/vnd.airzip.filesecure.azs":          []string{"azs"},
		"application/x-texinfo":                          []string{"texinfo", "texi"},
		"application/x-silverlight-app":                  []string{"xap"},
		"video/quicktime":                                []string{"qt", "mov"},
		"application/hjson":                              []string{"hjson"},
		"application/x-msdos-program":                    []string{"exe"},
		"image/bmp":                                      []string{"bmp"},
		"text/x-component":                               []string{"htc"},
		"application/vnd.hydrostatix.sof-data":           []string{"sfd-hdstx"},
		"application/vnd.mophun.certificate":             []string{"mpc"},
		"application/winhlp":                             []string{"hlp"},
		"image/ktx":                                      []string{"ktx"},
		"application/vnd.chemdraw+xml":                   []string{"cdxml"},
		"application/vnd.enliven":                        []string{"nml"},
		"application/vnd.stepmania.stepchart":            []string{"sm"},
		"audio/silk":                                     []string{"sil"},
		"application/scvp-vp-response":                   []string{"spp"},
		"application/x-mie":                              []string{"mie"},
		"application/vnd.ms-excel.addin.macroenabled.12": []string{"xlam"},
		"application/vnd.noblenet-sealer":                []string{"nns"},
		"application/xv+xml":                             []string{"mxml", "xhvml", "xvml", "xvm"},
		"application/vnd.lotus-wordpro":                  []string{"lwp"},
		"application/vnd.rn-realmedia":                   []string{"rm"},
		"video/x-ms-wm":                                  []string{"wm"},
		"application/vnd.mobius.daf":                     []string{"daf"},
		"application/vnd.powerbuilder6":                  []string{"pbd"},
		"application/x-font-ghostscript":                 []string{"gsf"},
		"application/x-virtualbox-ova":                   []string{"ova"},
		"application/vnd.mobius.msl":                     []string{"msl"},
		"application/vnd.sun.xml.draw":                   []string{"sxd"},
		"application/vnd.sun.xml.impress":                []string{"sxi"},
		"application/vnd.osgi.dp":                        []string{"dp"},
		"message/global-disposition-notification":        []string{"u8mdn"},
		"application/x-ms-xbap":                          []string{"xbap"},
		"image/x-tga":                                    []string{"tga"},
		"application/srgs":                               []string{"gram"},
		"application/vnd.dece.unspecified":               []string{"uvx", "uvvx"},
		"application/vnd.igloader":                       []string{"igl"},
		"application/json5":                              []string{"json5"},
		"application/pkcs10":                             []string{"p10"},
		"application/vnd.quark.quarkxpress":              []string{"qxd", "qxt", "qwd", "qwt", "qxl", "qxb"},
		"image/x-xbitmap":                                []string{"xbm"},
		"video/vnd.dece.mobile":                          []string{"uvm", "uvvm"},
		"text/x-suse-ymp":                                []string{"ymp"},
		"application/mac-binhex40":                       []string{"hqx"},
		"application/mads+xml":                           []string{"mads"},
		"application/vnd.ipunplugged.rcprofile":          []string{"rcprofile"},
		"application/vnd.fujitsu.oasys":                  []string{"oas"},
		"application/x-chrome-extension":                 []string{"crx"},
		"application/vnd.acucobol":                       []string{"acu"},
		"application/vnd.rig.cryptonote":                 []string{"cryptonote"},
		"application/vnd.shana.informed.formtemplate":    []string{"itp"},
		"video/jpm":                                                             []string{"jpm", "jpgm"},
		"application/vnd.crick.clicker.keyboard":                                []string{"clkk"},
		"application/vnd.stardivision.impress":                                  []string{"sdd"},
		"application/vnd.ds-keypoint":                                           []string{"kpxx"},
		"application/vnd.fdf":                                                   []string{"fdf"},
		"application/x-rar-compressed":                                          []string{"rar"},
		"text/css":                                                              []string{"css"},
		"text/shex":                                                             []string{"shex"},
		"application/rls-services+xml":                                          []string{"rs"},
		"application/vnd.picsel":                                                []string{"efif"},
		"application/vnd.adobe.air-application-installer-package+zip":           []string{"air"},
		"message/vnd.wfa.wsc":                                                   []string{"wsc"},
		"application/vnd.dece.data":                                             []string{"uvf", "uvvf", "uvd", "uvvd"},
		"application/vnd.macports.portpkg":                                      []string{"portpkg"},
		"application/x-director":                                                []string{"dir", "dcr", "dxr", "cst", "cct", "cxt", "w3d", "fgd", "swa"},
		"text/turtle":                                                           []string{"ttl"},
		"text/calendar":                                                         []string{"ics", "ifb"},
		"application/vnd.bmi":                                                   []string{"bmi"},
		"message/rfc822":                                                        []string{"eml", "mime"},
		"application/vnd.dpgraph":                                               []string{"dpg"},
		"application/vnd.seemail":                                               []string{"see"},
		"application/davmount+xml":                                              []string{"davmount"},
		"audio/vnd.dra":                                                         []string{"dra"},
		"chemical/x-cmdf":                                                       []string{"cmdf"},
		"model/gltf+json":                                                       []string{"gltf"},
		"video/x-matroska":                                                      []string{"mkv", "mk3d", "mks"},
		"application/sbml+xml":                                                  []string{"sbml"},
		"application/vnd.crick.clicker":                                         []string{"clkx"},
		"application/vnd.intercon.formnet":                                      []string{"xpw", "xpx"},
		"application/vnd.3m.post-it-notes":                                      []string{"pwn"},
		"application/x-msaccess":                                                []string{"mdb"},
		"application/vnd.epson.msf":                                             []string{"msf"},
		"application/cdmi-container":                                            []string{"cdmic"},
		"application/vnd.oasis.opendocument.image-template":                     []string{"oti"},
		"application/x-font-snf":                                                []string{"snf"},
		"audio/vnd.nuera.ecelp4800":                                             []string{"ecelp4800"},
		"application/vnd.contact.cmsg":                                          []string{"cdbcmsg"},
		"application/vnd.ms-lrm":                                                []string{"lrm"},
		"audio/mp4":                                                             []string{"m4a", "mp4a"},
		"application/vnd.ms-artgalry":                                           []string{"cil"},
		"video/vnd.dece.hd":                                                     []string{"uvh", "uvvh"},
		"video/x-m4v":                                                           []string{"m4v"},
		"audio/x-pn-realaudio":                                                  []string{"ram", "ra"},
		"application/vnd.aristanetworks.swi":                                    []string{"swi"},
		"application/vnd.hp-hps":                                                []string{"hps"},
		"image/vnd.fujixerox.edmics-mmr":                                        []string{"mmr"},
		"application/rpki-roa":                                                  []string{"roa"},
		"application/vnd.sun.xml.impress.template":                              []string{"sti"},
		"model/mesh":                                                            []string{"msh", "mesh", "silo"},
		"application/vnd.crick.clicker.wordbank":                                []string{"clkw"},
		"application/vnd.irepository.package+xml":                               []string{"irp"},
		"application/vnd.yamaha.openscoreformat.osfpvg+xml":                     []string{"osfpvg"},
		"application/x-tar":                                                     []string{"tar"},
		"font/woff2":                                                            []string{"woff2"},
		"video/x-smv":                                                           []string{"smv"},
		"application/vnd.ibm.modcap":                                            []string{"afp", "listafp", "list3820"},
		"application/x-bdoc":                                                    []string{"bdoc"},
		"video/vnd.dvb.file":                                                    []string{"dvb"},
		"application/vnd.openxmlformats-officedocument.presentationml.template": []string{"potx"},
		"application/x-bittorrent":                                              []string{"torrent"},
		"text/slim":                                                             []string{"slim", "slm"},
		"application/pkix-cert":                                                 []string{"cer"},
		"application/relax-ng-compact-syntax":                                   []string{"rnc"},
		"application/vnd.kinar":                                                 []string{"kne", "knp"},
		"audio/midi":                                                            []string{"mid", "midi", "kar", "rmi"},
		"application/vnd.wqd":                                                   []string{"wqd"},
		"application/x-stuffit":                                                 []string{"sit"},
		"application/sdp":                                                       []string{"sdp"},
		"image/jpm":                                                             []string{"jpm"},
		"video/x-ms-wmx":                                                        []string{"wmx"},
		"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": []string{"xlsx"},
		"audio/x-caf":                                []string{"caf"},
		"image/svg+xml":                              []string{"svg", "svgz"},
		"application/vnd.shana.informed.interchange": []string{"iif"},
		"text/x-asm":                                 []string{"s", "asm"},
		"application/pkix-attr-cert":                 []string{"ac"},
		"application/vnd.groove-help":                []string{"ghf"},
		"application/vnd.mobius.mqy":                 []string{"mqy"},
		"application/ssdl+xml":                       []string{"ssdl"},
		"application/vnd.recordare.musicxml+xml":     []string{"musicxml"},
		"application/gzip":                           []string{"gz"},
		"image/png":                                  []string{"png"},
		"video/mp2t":                                 []string{"ts"},
		"application/vnd.openofficeorg.extension":    []string{"oxt"},
		"video/x-flv":                                []string{"flv"},
		"application/x-virtualbox-vbox":              []string{"vbox"},
		"text/x-vcard":                               []string{"vcf"},
		"text/vnd.curl.mcurl":                        []string{"mcurl"},
		"application/vnd.route66.link66+xml":         []string{"link66"},
		"video/h264":                                 []string{"h264"},
		"application/vnd.joost.joda-archive":         []string{"joda"},
		"application/xml":                            []string{"xml", "xsl", "xsd", "rng"},
		"image/x-portable-bitmap":                    []string{"pbm"},
		"application/vnd.nitf":                       []string{"ntf", "nitf"},
		"image/x-portable-pixmap":                    []string{"ppm"},
		"video/jpeg":                                 []string{"jpgv"},
		"image/vnd.xiff":                             []string{"xif"},
		"application/vnd.openxmlformats-officedocument.spreadsheetml.template": []string{"xltx"},
		"text/x-markdown":                             []string{"mkd"},
		"video/x-msvideo":                             []string{"avi"},
		"application/x-virtualbox-vhd":                []string{"vhd"},
		"application/x-tads":                          []string{"gam"},
		"application/vnd.dece.ttml+xml":               []string{"uvt", "uvvt"},
		"chemical/x-xyz":                              []string{"xyz"},
		"image/x-3ds":                                 []string{"3ds"},
		"model/vnd.gtw":                               []string{"gtw"},
		"application/vnd.mobius.dis":                  []string{"dis"},
		"audio/x-mpegurl":                             []string{"m3u"},
		"application/vnd.pawaafile":                   []string{"paw"},
		"application/x-authorware-bin":                []string{"aab", "x32", "u32", "vox"},
		"application/postscript":                      []string{"ai", "eps", "ps"},
		"application/vnd.oasis.opendocument.graphics": []string{"odg"},
		"audio/xm":                                     []string{"xm"},
		"application/x-shockwave-flash":                []string{"swf"},
		"application/applixware":                       []string{"aw"},
		"video/vnd.fvt":                                []string{"fvt"},
		"application/x-ace-compressed":                 []string{"ace"},
		"application/vnd.semf":                         []string{"semf"},
		"application/vnd.spotfire.dxp":                 []string{"dxp"},
		"application/x-bcpio":                          []string{"bcpio"},
		"audio/wav":                                    []string{"wav"},
		"text/x-uuencode":                              []string{"uu"},
		"application/vnd.noblenet-directory":           []string{"nnd"},
		"image/vnd.djvu":                               []string{"djvu", "djv"},
		"application/vnd.kde.kontour":                  []string{"kon"},
		"application/ecmascript":                       []string{"ecma"},
		"application/mp21":                             []string{"m21", "mp21"},
		"application/vnd.yamaha.hv-script":             []string{"hvs"},
		"image/vnd.dxf":                                []string{"dxf"},
		"application/vnd.cluetrust.cartomobile-config": []string{"c11amc"},
		"text/x-opml":                                  []string{"opml"},
		"audio/x-pn-realaudio-plugin":                  []string{"rmp"},
		"application/vnd.americandynamics.acc":         []string{"acc"},
		"application/vnd.webturbo":                     []string{"wtb"},
		"application/xcap-diff+xml":                    []string{"xdf"},
		"image/x-portable-graymap":                     []string{"pgm"},
		"video/mp4":                                    []string{"mp4", "mp4v", "mpg4"},
		"application/timestamped-data":                 []string{"tsd"},
		"application/dssc+xml":                         []string{"xdssc"},
		"application/vnd.groove-injector":              []string{"grv"},
		"application/x-gca-compressed":                 []string{"gca"},
		"image/x-jng":                                  []string{"jng"},
		"application/vnd.ms-powerpoint.slideshow.macroenabled.12":                 []string{"ppsm"},
		"application/vnd.openxmlformats-officedocument.presentationml.slideshow":  []string{"ppsx"},
		"application/vnd.kahootz":                                                 []string{"ktz", "ktr"},
		"application/vnd.mobius.plc":                                              []string{"plc"},
		"application/vnd.unity":                                                   []string{"unityweb"},
		"text/vnd.fmi.flexstor":                                                   []string{"flx"},
		"application/vnd.crick.clicker.palette":                                   []string{"clkp"},
		"application/vnd.grafeq":                                                  []string{"gqf", "gqs"},
		"font/otf":                                                                []string{"otf"},
		"application/java-serialized-object":                                      []string{"ser"},
		"application/vnd.mophun.application":                                      []string{"mpn"},
		"application/java-archive":                                                []string{"jar", "war", "ear"},
		"application/ogg":                                                         []string{"ogx"},
		"application/resource-lists+xml":                                          []string{"rl"},
		"application/vnd.visionary":                                               []string{"vis"},
		"text/vtt":                                                                []string{"vtt"},
		"application/vnd.stardivision.draw":                                       []string{"sda"},
		"application/cdmi-queue":                                                  []string{"cdmiq"},
		"application/vnd.novadigm.ext":                                            []string{"ext"},
		"application/vnd.sun.xml.draw.template":                                   []string{"std"},
		"text/xml":                                                                []string{"xml"},
		"application/rdf+xml":                                                     []string{"rdf"},
		"application/x-futuresplash":                                              []string{"spl"},
		"application/geo+json":                                                    []string{"geojson"},
		"application/vnd.ms-works":                                                []string{"wps", "wks", "wcm", "wdb"},
		"application/x-msmetafile":                                                []string{"wmf", "wmz", "emf", "emz"},
		"text/x-pascal":                                                           []string{"p", "pas"},
		"application/rpki-manifest":                                               []string{"mft"},
		"application/x-pkcs7-certificates":                                        []string{"p7b", "spc"},
		"application/xslt+xml":                                                    []string{"xslt"},
		"video/webm":                                                              []string{"webm"},
		"application/scvp-vp-request":                                             []string{"spq"},
		"application/vnd.antix.game-component":                                    []string{"atx"},
		"application/vnd.kidspiration":                                            []string{"kia"},
		"application/vnd.yellowriver-custom-menu":                                 []string{"cmp"},
		"application/x-chess-pgn":                                                 []string{"pgn"},
		"application/vnd.frogans.fnc":                                             []string{"fnc"},
		"application/vnd.lotus-approach":                                          []string{"apr"},
		"application/vnd.oasis.opendocument.graphics-template":                    []string{"otg"},
		"application/voicexml+xml":                                                []string{"vxml"},
		"video/x-ms-asf":                                                          []string{"asf", "asx"},
		"application/vnd.ms-excel.template.macroenabled.12":                       []string{"xltm"},
		"application/vnd.xfdl":                                                    []string{"xfdl"},
		"image/vnd.fpx":                                                           []string{"fpx"},
		"text/x-handlebars-template":                                              []string{"hbs"},
		"video/h263":                                                              []string{"h263"},
		"application/vnd.3gpp.pic-bw-var":                                         []string{"pvb"},
		"message/global-headers":                                                  []string{"u8hdr"},
		"video/x-mng":                                                             []string{"mng"},
		"text/vcard":                                                              []string{"vcard"},
		"application/vnd.ecowin.chart":                                            []string{"mag"},
		"audio/x-m4a":                                                             []string{"m4a"},
		"text/csv":                                                                []string{"csv"},
		"application/vnd.epson.ssf":                                               []string{"ssf"},
		"application/vnd.acucorp":                                                 []string{"atc", "acutc"},
		"application/x-perl":                                                      []string{"pl", "pm"},
		"application/xhtml+xml":                                                   []string{"xhtml", "xht"},
		"audio/x-matroska":                                                        []string{"mka"},
		"application/patch-ops-error+xml":                                         []string{"xer"},
		"application/sru+xml":                                                     []string{"sru"},
		"application/vnd.audiograph":                                              []string{"aep"},
		"application/vnd.wap.wmlc":                                                []string{"wmlc"},
		"application/atom+xml":                                                    []string{"atom"},
		"application/vnd.openxmlformats-officedocument.wordprocessingml.template": []string{"dotx"},
		"application/vnd.ibm.secure-container":                                    []string{"sc"},
		"application/x-t3vm-image":                                                []string{"t3"},
		"application/wasm":                                                        []string{"wasm"},
		"audio/x-aiff":                                                            []string{"aif", "aiff", "aifc"},
		"text/sgml":                                                               []string{"sgml", "sgm"},
		"image/vnd.dwg":                                                           []string{"dwg"},
		"application/vnd.ms-htmlhelp":                                             []string{"chm"},
		"application/vnd.stepmania.package":                                       []string{"smzip"},
		"text/richtext":                                                           []string{"rtx"},
		"application/vnd.frogans.ltf":                                             []string{"ltf"},
		"application/vnd.nokia.n-gage.symbian.install":                            []string{"n-gage"},
		"application/vnd.syncml.dm+xml":                                           []string{"xdm"},
		"application/vnd.curl.pcurl":                                              []string{"pcurl"},
		"application/vnd.spotfire.sfs":                                            []string{"sfs"},
		"application/vnd.fujixerox.docuworks":                                     []string{"xdw"},
		"application/x-dgc-compressed":                                            []string{"dgc"},
		"application/vnd.lotus-1-2-3":                                             []string{"123"},
		"application/vnd.airzip.filesecure.azf":                                   []string{"azf"},
		"application/vnd.yamaha.smaf-phrase":                                      []string{"spf"},
		"application/x-msdownload":                                                []string{"exe", "dll", "com", "bat", "msi"},
		"application/manifest+json":                                               []string{"webmanifest"},
		"application/exi":                                                         []string{"exi"},
		"application/javascript":                                                  []string{"js", "mjs"},
		"application/vnd.oasis.opendocument.chart-template":                       []string{"otc"},
		"application/pkcs7-signature":                                             []string{"p7s"},
		"application/x-ms-wmz":                                                    []string{"wmz"},
		"video/x-sgi-movie":                                                       []string{"movie"},
		"audio/vnd.nuera.ecelp7470":                                               []string{"ecelp7470"},
		"video/mj2":                                                               []string{"mj2", "mjp2"},
		"application/mods+xml":                                                    []string{"mods"},
		"application/rss+xml":                                                     []string{"rss"},
		"application/vnd.tmobile-livetv":                                          []string{"tmo"},
		"image/vnd.fujixerox.edmics-rlc":                                          []string{"rlc"},
		"application/x-ms-wmd":                                                    []string{"wmd"},
		"application/vnd.hp-pcl":                                                  []string{"pcl"},
		"text/vnd.dvb.subtitle":                                                   []string{"sub"},
		"chemical/x-cdx":                                                          []string{"cdx"},
		"message/disposition-notification":                                        []string{"disposition-notification"},
		"application/oxps":                                                        []string{"oxps"},
		"application/x-sv4crc":                                                    []string{"sv4crc"},
		"application/widget":                                                      []string{"wgt"},
		"application/srgs+xml":                                                    []string{"grxml"},
		"application/vnd.musician":                                                []string{"mus"},
		"application/vnd.openxmlformats-officedocument.presentationml.slide":      []string{"sldx"},
		"video/3gpp":                                          []string{"3gp", "3gpp"},
		"application/vnd.trid.tpt":                            []string{"tpt"},
		"application/vnd.data-vision.rdz":                     []string{"rdz"},
		"application/vnd.ms-powerpoint.slide.macroenabled.12": []string{"sldm"},
		"application/vnd.dart":                                []string{"dart"},
		"application/vnd.ms-cab-compressed":                   []string{"cab"},
		"application/x-xliff+xml":                             []string{"xlf"},
		"text/tab-separated-values":                           []string{"tsv"},
		"application/vnd.oasis.opendocument.database":         []string{"odb"},
		"application/x-java-archive-diff":                     []string{"jardiff"},
		"message/global":                                      []string{"u8msg"},
		"application/vnd.hp-pclxl":                            []string{"pclxl"},
		"image/jpx":                                           []string{"jpx", "jpf"},
		"application/vnd.ms-pki.seccat":                       []string{"cat"},
		"application/vnd.pg.osasli":                           []string{"ei6"},
		"application/vnd.fujitsu.oasysprs":                    []string{"bh2"},
		"application/vnd.3gpp.pic-bw-small":                   []string{"psb"},
		"application/x-csh":                                   []string{"csh"},
		"model/vnd.dwf":                                       []string{"dwf"},
		"application/inkml+xml":                               []string{"ink", "inkml"},
		"application/vnd.hal+xml":                             []string{"hal"},
		"chemical/x-csml":                                     []string{"csml"},
		"application/x-pilot":                                 []string{"prc", "pdb"},
		"application/x-redhat-package-manager":                []string{"rpm"},
		"application/vnd.pvi.ptid1":                           []string{"ptid"},
		"application/xspf+xml":                                []string{"xspf"},
		"text/x-fortran":                                      []string{"f", "for", "f77", "f90"},
		"application/ccxml+xml":                               []string{"ccxml"},
		"application/metalink+xml":                            []string{"metalink"},
		"application/vnd.dna":                                 []string{"dna"},
		"application/x-sea":                                   []string{"sea"},
		"application/pics-rules":                              []string{"prf"},
		"image/g3fax":                                         []string{"g3"},
		"application/vnd.ms-excel.sheet.binary.macroenabled.12": []string{"xlsb"},
		"application/reginfo+xml":                               []string{"rif"},
		"application/vnd.medcalcdata":                           []string{"mc1"},
		"model/vnd.collada+xml":                                 []string{"dae"},
		"application/vnd.epson.salt":                            []string{"slt"},
		"application/x-msmoney":                                 []string{"mny"},
		"application/vnd.sema":                                  []string{"sema"},
		"image/vnd.adobe.photoshop":                             []string{"psd"},
		"application/vnd.olpc-sugar":                            []string{"xo"},
		"application/x-xfig":                                    []string{"fig"},
		"application/vnd.3gpp2.tcap":                            []string{"tcap"},
		"application/vnd.google-earth.kmz":                      []string{"kmz"},
		"application/vnd.ibm.minipay":                           []string{"mpy"},
		"application/pkixcmp":                                   []string{"pki"},
		"application/vnd.jisp":                                  []string{"jisp"},
		"application/vnd.curl.car":                              []string{"car"},
		"application/vnd.ms-pki.stl":                            []string{"stl"},
		"application/vnd.ms-outlook":                            []string{"msg"},
		"image/x-freehand":                                      []string{"fh", "fhc", "fh4", "fh5", "fh7"},
		"application/vnd.nokia.n-gage.data":                     []string{"ngdat"},
		"application/x-abiword":                                 []string{"abw"},
		"model/x3d+xml":                                         []string{"x3d", "x3dz"},
		"application/json":                                      []string{"json", "map"},
		"application/xml-dtd":                                   []string{"dtd"},
		"audio/vnd.dece.audio":                                  []string{"uva", "uvva"},
		"application/vnd.kde.kspread":                           []string{"ksp"},
		"application/vnd.pmi.widget":                            []string{"wg"},
		"application/x-iso9660-image":                           []string{"iso"},
		"application/vnd.genomatix.tuxedo":                      []string{"txd"},
		"application/vnd.groove-tool-message":                   []string{"gtm"},
		"application/sparql-results+xml":                        []string{"srx"},
		"application/vnd.llamagraphics.life-balance.desktop":    []string{"lbd"},
		"application/vnd.sun.xml.writer.template":               []string{"stw"},
		"application/rtf":                                       []string{"rtf"},
		"application/vnd.neurolanguage.nlu":                     []string{"nlu"},
		"application/vnd.hp-jlyt":                               []string{"jlt"},
		"application/x-cocoa":                                   []string{"cco"},
		"text/x-scss":                                           []string{"scss"},
		"text/x-org":                                            []string{"org"},
		"application/xaml+xml":                                  []string{"xaml"},
		"application/vnd.las.las+xml":                           []string{"lasxml"},
		"application/x-apple-diskimage":                         []string{"dmg"},
		"application/x-msclip":                                  []string{"clp"},
		"application/gpx+xml":                                   []string{"gpx"},
		"application/vnd.vsf":                                   []string{"vsf"},
		"image/x-xpixmap":                                       []string{"xpm"},
		"video/x-ms-wmv":                                        []string{"wmv"},
		"application/pskc+xml":                                  []string{"pskcxml"},
		"application/vnd.fdsn.seed":                             []string{"seed", "dataless"},
		"application/mediaservercontrol+xml":                    []string{"mscml"},
		"application/vnd.epson.esf":                             []string{"esf"},
		"application/vnd.ms-word.document.macroenabled.12":      []string{"docm"},
		"application/x-mscardfile":                              []string{"crd"},
		"application/xenc+xml":                                  []string{"xenc"},
		"application/vnd.cluetrust.cartomobile-config-pkg":      []string{"c11amz"},
		"application/x-lzh-compressed":                          []string{"lzh", "lha"},
		"application/vnd.adobe.fxp":                             []string{"fxp", "fxpl"},
		"application/vnd.stardivision.writer-global":            []string{"sgl"},
		"image/ief":                                                               []string{"ief"},
		"text/mathml":                                                             []string{"mml"},
		"application/font-woff":                                                   []string{"woff"},
		"application/gxf":                                                         []string{"gxf"},
		"application/x-ms-shortcut":                                               []string{"lnk"},
		"application/vnd.uiq.theme":                                               []string{"utz"},
		"application/x-msschedule":                                                []string{"scd"},
		"application/vnd.gmx":                                                     []string{"gmx"},
		"application/vnd.framemaker":                                              []string{"fm", "frame", "maker", "book"},
		"application/emma+xml":                                                    []string{"emma"},
		"application/vnd.oasis.opendocument.text-web":                             []string{"oth"},
		"application/vnd.astraea-software.iota":                                   []string{"iota"},
		"image/vnd.ms-photo":                                                      []string{"wdp"},
		"application/x-debian-package":                                            []string{"deb", "udeb"},
		"text/vnd.curl.scurl":                                                     []string{"scurl"},
		"application/vnd.apple.mpegurl":                                           []string{"m3u8"},
		"application/vnd.pocketlearn":                                             []string{"plf"},
		"application/vnd.semd":                                                    []string{"semd"},
		"application/x-sql":                                                       []string{"sql"},
		"application/vnd.groove-tool-template":                                    []string{"tpl"},
		"audio/vnd.dts":                                                           []string{"dts"},
		"audio/x-ms-wax":                                                          []string{"wax"},
		"text/prs.lines.tag":                                                      []string{"dsc"},
		"application/vnd.fluxtime.clip":                                           []string{"ftc"},
		"application/vnd.geogebra.file":                                           []string{"ggb"},
		"application/vnd.kde.kchart":                                              []string{"chrt"},
		"image/x-portable-anymap":                                                 []string{"pnm"},
		"model/vrml":                                                              []string{"wrl", "vrml"},
		"text/cache-manifest":                                                     []string{"appcache", "manifest"},
		"application/vnd.hp-hpid":                                                 []string{"hpid"},
		"image/jpeg":                                                              []string{"jpeg", "jpg", "jpe"},
		"application/vnd.sus-calendar":                                            []string{"sus", "susp"},
		"application/vnd.fujitsu.oasysgp":                                         []string{"fg5"},
		"application/vnd.ufdl":                                                    []string{"ufd", "ufdl"},
		"application/vnd.ibm.rights-management":                                   []string{"irm"},
		"application/vnd.kodak-descriptor":                                        []string{"sse"},
		"application/vnd.mseq":                                                    []string{"mseq"},
		"application/vnd.tcpdump.pcap":                                            []string{"pcap", "cap", "dmp"},
		"application/x-latex":                                                     []string{"latex"},
		"application/vnd.criticaltools.wbs+xml":                                   []string{"wbs"},
		"application/vnd.dvb.service":                                             []string{"svc"},
		"application/vnd.insors.igm":                                              []string{"igm"},
		"application/vnd.eszigno3+xml":                                            []string{"es3", "et3"},
		"application/vnd.kde.karbon":                                              []string{"karbon"},
		"application/vnd.oma.dd2+xml":                                             []string{"dd2"},
		"application/vnd.rn-realmedia-vbr":                                        []string{"rmvb"},
		"application/atomcat+xml":                                                 []string{"atomcat"},
		"application/mxf":                                                         []string{"mxf"},
		"application/vnd.fsc.weblaunch":                                           []string{"fsc"},
		"application/vnd.amazon.ebook":                                            []string{"azw"},
		"application/cdmi-domain":                                                 []string{"cdmid"},
		"application/vnd.anser-web-certificate-issue-initiation":                  []string{"cii"},
		"application/vnd.ctc-posml":                                               []string{"pml"},
		"application/vnd.denovo.fcselayout-link":                                  []string{"fe_launch"},
		"model/x3d+vrml":                                                          []string{"x3dv", "x3dvz"},
		"application/vnd.google-apps.presentation":                                []string{"gslides"},
		"application/vnd.wolfram.player":                                          []string{"nbp"},
		"image/webp":                                                              []string{"webp"},
		"application/x-stuffitx":                                                  []string{"sitx"},
		"application/vnd.android.package-archive":                                 []string{"apk"},
		"application/x-cfs-compressed":                                            []string{"cfs"},
		"application/x-hdf":                                                       []string{"hdf"},
		"application/vnd.ms-fontobject":                                           []string{"eot"},
		"application/vnd.oasis.opendocument.spreadsheet":                          []string{"ods"},
		"image/vnd.wap.wbmp":                                                      []string{"wbmp"},
		"text/vnd.fly":                                                            []string{"fly"},
		"application/vnd.muvee.style":                                             []string{"msty"},
		"application/x-sv4cpio":                                                   []string{"sv4cpio"},
		"application/font-tdpfr":                                                  []string{"pfr"},
		"image/vnd.fastbidsheet":                                                  []string{"fbs"},
		"image/x-ms-bmp":                                                          []string{"bmp"},
		"application/vnd.fdsn.mseed":                                              []string{"mseed"},
		"image/x-cmx":                                                             []string{"cmx"},
		"image/tiff":                                                              []string{"tiff", "tif"},
		"application/vnd.mfer":                                                    []string{"mwf"},
		"application/vnd.ms-excel.sheet.macroenabled.12":                          []string{"xlsm"},
		"application/mbox":                                                        []string{"mbox"},
		"application/vnd.hbci":                                                    []string{"hbci"},
		"application/x-mswrite":                                                   []string{"wri"},
		"application/shf+xml":                                                     []string{"shf"},
		"application/vnd.micrografx.igx":                                          []string{"igx"},
		"image/x-pict":                                                            []string{"pic", "pct"},
		"application/x-mspublisher":                                               []string{"pub"},
		"application/mathml+xml":                                                  []string{"mathml"},
		"application/vnd.syncml+xml":                                              []string{"xsm"},
		"application/vnd.accpac.simply.imp":                                       []string{"imp"},
		"application/x-gnumeric":                                                  []string{"gnumeric"},
		"application/pgp-encrypted":                                               []string{"pgp"},
		"model/vnd.vtu":                                                           []string{"vtu"},
		"video/vnd.dece.video":                                                    []string{"uvv", "uvvv"},
		"application/x-gtar":                                                      []string{"gtar"},
		"audio/s3m":                                                               []string{"s3m"},
		"text/plain":                                                              []string{"txt", "text", "conf", "def", "list", "log", "in", "ini"},
		"audio/webm":                                                              []string{"weba"},
		"application/vnd.cloanto.rp9":                                             []string{"rp9"},
		"application/rsd+xml":                                                     []string{"rsd"},
		"application/x-authorware-seg":                                            []string{"aas"},
		"application/pkcs8":                                                       []string{"p8"},
		"application/x-shar":                                                      []string{"shar"},
		"application/x-msbinder":                                                  []string{"obd"},
		"application/vnd.lotus-freelance":                                         []string{"pre"},
		"image/gif":                                                               []string{"gif"},
		"application/cdmi-capability":                                             []string{"cdmia"},
		"application/hyperstudio":                                                 []string{"stk"},
		"application/vnd.sailingtracker.track":                                    []string{"st"},
		"application/vnd.ms-project":                                              []string{"mpp", "mpt"},
		"text/vnd.curl":                                                           []string{"curl"},
		"audio/x-aac":                                                             []string{"aac"},
		"application/x-virtualbox-vmdk":                                           []string{"vmdk"},
		"application/dash+xml":                                                    []string{"mpd"},
		"application/vnd.lotus-screencam":                                         []string{"scm"},
		"text/troff":                                                              []string{"t", "tr", "roff", "man", "me", "ms"},
		"application/ssml+xml":                                                    []string{"ssml"},
		"application/x-7z-compressed":                                             []string{"7z"},
		"application/dssc+der":                                                    []string{"dssc"},
		"message/global-delivery-status":                                          []string{"u8dsn"},
		"text/x-vcalendar":                                                        []string{"vcs"},
		"application/vnd.google-apps.spreadsheet":                                 []string{"gsheet"},
		"application/vnd.ms-ims":                                                  []string{"ims"},
		"text/x-lua":                                                              []string{"lua"},
		"image/prs.btif":                                                          []string{"btif"},
		"application/vnd.oasis.opendocument.text-master":                          []string{"odm"},
		"application/java-vm":                                                     []string{"class"},
		"application/vnd.immervision-ivp":                                         []string{"ivp"},
		"application/zip":                                                         []string{"zip"},
		"application/vnd.google-earth.kml+xml":                                    []string{"kml"},
		"application/vnd.apple.installer+xml":                                     []string{"mpkg"},
		"application/vnd.palm":                                                    []string{"pdb", "pqa", "oprc"},
		"application/vnd.sun.xml.writer":                                          []string{"sxw"},
		"image/apng":                                                              []string{"apng"},
		"application/vnd.solent.sdkm+xml":                                         []string{"sdkm", "sdkd"},
		"application/vnd.sun.wadl+xml":                                            []string{"wadl"},
		"model/gltf-binary":                                                       []string{"glb"},
		"application/mac-compactpro":                                              []string{"cpt"},
		"application/vnd.adobe.xfdf":                                              []string{"xfdf"},
		"audio/adpcm":                                                             []string{"adp"},
		"application/vnd.shana.informed.formdata":                                 []string{"ifm"},
		"application/vnd.3gpp.pic-bw-large":                                       []string{"plb"},
		"application/vnd.kde.kformula":                                            []string{"kfo"},
		"application/x-tex":                                                       []string{"tex"},
		"chemical/x-cif":                                                          []string{"cif"},
		"application/x-font-bdf":                                                  []string{"bdf"},
		"audio/vnd.dts.hd":                                                        []string{"dtshd"},
		"application/x-glulx":                                                     []string{"ulx"},
		"audio/3gpp":                                                              []string{"3gpp"},
		"x-conference/x-cooltalk":                                                 []string{"ice"},
		"chemical/x-cml":                                                          []string{"cml"},
		"application/omdoc+xml":                                                   []string{"omdoc"},
		"application/prs.cww":                                                     []string{"cww"},
		"text/stylus":                                                             []string{"stylus", "styl"},
		"application/vnd.handheld-entertainment+xml":                              []string{"zmm"},
		"application/vnd.oasis.opendocument.chart":                                []string{"odc"},
		"application/vnd.umajin":                                                  []string{"umj"},
		"application/x-web-app-manifest+json":                                     []string{"webapp"},
		"application/vnd.svd":                                                     []string{"svd"},
		"application/x-cbr":                                                       []string{"cbr", "cba", "cbt", "cbz", "cb7"},
		"text/uri-list":                                                           []string{"uri", "uris", "urls"},
		"application/vnd.sun.xml.math":                                            []string{"sxm"},
		"application/x-virtualbox-ovf":                                            []string{"ovf"},
		"model/vnd.mts":                                                           []string{"mts"},
		"application/vnd.mobius.txf":                                              []string{"txf"},
		"audio/wave":                                                              []string{"wav"},
		"application/vnd.sun.xml.writer.global":                                   []string{"sxg"},
		"audio/vnd.digital-winds":                                                 []string{"eol"},
		"image/vnd.net-fpx":                                                       []string{"npx"},
		"application/x-msterminal":                                                []string{"trm"},
		"audio/vnd.ms-playready.media.pya":                                        []string{"pya"},
		"application/msword":                                                      []string{"doc", "dot"},
		"application/vnd.koan":                                                    []string{"skp", "skd", "skt", "skm"},
		"application/vnd.proteus.magazine":                                        []string{"mgz"},
		"image/x-mrsid-image":                                                     []string{"sid"},
		"font/ttf":                                                                []string{"ttf"},
		"application/x-freearc":                                                   []string{"arc"},
		"image/cgm":                                                               []string{"cgm"},
		"text/x-setext":                                                           []string{"etx"},
		"application/yin+xml":                                                     []string{"yin"},
		"image/x-rgb":                                                             []string{"rgb"},
		"audio/vnd.nuera.ecelp9600":                                               []string{"ecelp9600"},
		"application/raml+yaml":                                                   []string{"raml"},
		"application/vnd.google-apps.document":                                    []string{"gdoc"},
		"application/vnd.oasis.opendocument.presentation-template":                []string{"otp"},
		"application/x-subrip":                                                    []string{"srt"},
		"application/x-virtualbox-vdi":                                            []string{"vdi"},
		"application/bdoc":                                                        []string{"bdoc"},
		"application/vnd.ms-excel":                                                []string{"xls", "xlm", "xla", "xlc", "xlt", "xlw"},
		"application/x-x509-ca-cert":                                              []string{"der", "crt", "pem"},
		"application/xproc+xml":                                                   []string{"xpl"},
		"application/vnd.stardivision.calc":                                       []string{"sdc"},
		"application/x-mobipocket-ebook":                                          []string{"prc", "mobi"},
		"application/x-ustar":                                                     []string{"ustar"},
		"application/lost+xml":                                                    []string{"lostxml"},
		"application/vnd.immervision-ivu":                                         []string{"ivu"},
		"application/andrew-inset":                                                []string{"ez"},
		"application/vnd.fujixerox.docuworks.binder":                              []string{"xbd"},
		"application/vnd.ms-xpsdocument":                                          []string{"xps"},
		"application/vnd.wordperfect":                                             []string{"wpd"},
		"text/x-c":                                                                []string{"c", "cc", "cxx", "cpp", "h", "hh", "dic"},
		"application/x-arj":                                                       []string{"arj"},
		"application/vnd.jcp.javame.midlet-rms":                                   []string{"rms"},
		"application/vnd.cosmocaller":                                             []string{"cmc"},
		"model/iges":                                                              []string{"igs", "iges"},
		"application/thraud+xml":                                                  []string{"tfi"},
		"application/vnd.stardivision.writer":                                     []string{"sdw", "vor"},
		"application/vnd.epson.quickanime":                                        []string{"qam"},
		"application/yang":                                                        []string{"yang"},
		"text/yaml":                                                               []string{"yaml", "yml"},
		"application/x-tex-tfm":                                                   []string{"tfm"},
		"text/x-sass":                                                             []string{"sass"},
		"video/ogg":                                                               []string{"ogv"},
		"application/vnd.wt.stf":                                                  []string{"stf"},
		"application/x-tgif":                                                      []string{"obj"},
		"audio/vnd.rip":                                                           []string{"rip"},
		"video/x-ms-wvx":                                                          []string{"wvx"},
		"application/x-pkcs12":                                                    []string{"p12", "pfx"},
		"application/vnd.ezpix-package":                                           []string{"ez3"},
		"application/xop+xml":                                                     []string{"xop"},
		"application/vnd.dynageo":                                                 []string{"geo"},
		"application/vnd.uoml+xml":                                                []string{"uoml"},
		"application/wspolicy+xml":                                                []string{"wspolicy"},
		"audio/vnd.lucent.voice":                                                  []string{"lvp"},
		"application/vnd.clonk.c4group":                                           []string{"c4g", "c4d", "c4f", "c4p", "c4u"},
		"image/vnd.dece.graphic":                                                  []string{"uvi", "uvvi", "uvg", "uvvg"},
		"video/x-ms-vob":                                                          []string{"vob"},
		"application/pgp-signature":                                               []string{"asc", "sig"},
		"application/pkix-pkipath":                                                []string{"pkipath"},
		"application/vnd.cinderella":                                              []string{"cdy"},
		"application/x-wais-source":                                               []string{"src"},
		"application/vnd.groove-account":                                          []string{"gac"},
		"video/vnd.mpegurl":                                                       []string{"mxu", "m4u"},
		"application/x-dvi":                                                       []string{"dvi"},
		"application/x-java-jnlp-file":                                            []string{"jnlp"},
		"application/scvp-cv-response":                                            []string{"scs"},
		"application/x-font-type1":                                                []string{"pfa", "pfb", "pfm", "afm"},
		"application/vnd.geospace":                                                []string{"g3w"},
		"application/vnd.iccprofile":                                              []string{"icc", "icm"},
		"application/vnd.lotus-notes":                                             []string{"nsf"},
		"application/vnd.mobius.mbk":                                              []string{"mbk"},
		"application/octet-stream":                                                []string{"bin", "dms", "lrf", "mar", "so", "dist", "distz", "pkg", "bpk", "dump", "elc", "deploy", "exe", "dll", "deb", "dmg", "iso", "img", "msi", "msp", "msm", "buffer"},
		"application/vnd.mozilla.xul+xml":                                         []string{"xul"},
		"application/scvp-cv-request":                                             []string{"scq"},
		"application/vnd.dvb.ait":                                                 []string{"ait"},
		"application/x-eva":                                                       []string{"eva"},
		"application/x-chat":                                                      []string{"chat"},
		"application/vnd.symbian.install":                                         []string{"sis", "sisx"},
		"model/vnd.gdl":                                                           []string{"gdl"},
		"text/jsx":                                                                []string{"jsx"},
		"application/x-envoy":                                                     []string{"evy"},
		"application/x-netcdf":                                                    []string{"nc", "cdf"},
		"font/woff":                                                               []string{"woff"},
		"application/vnd.apple.pkpass":                                            []string{"pkpass"},
		"application/vnd.dece.zip":                                                []string{"uvz", "uvvz"},
		"application/vnd.openxmlformats-officedocument.wordprocessingml.document": []string{"docx"},
		"application/vnd.yamaha.openscoreformat":                                  []string{"osf"},
		"text/less":                                                               []string{"less"},
		"application/vnd.kde.kpresenter":                                          []string{"kpr", "kpt"},
		"application/x-tcl":                                                       []string{"tcl", "tk"},
		"application/gml+xml":                                                     []string{"gml"},
		"video/h261":                                                              []string{"h261"},
		"application/vnd.novadigm.edm":                                            []string{"edm"},
		"application/vnd.sun.xml.calc":                                            []string{"sxc"},
		"application/mathematica":                                                 []string{"ma", "nb", "mb"},
		"application/vnd.intu.qbo":                                                []string{"qbo"},
		"application/x-gramps-xml":                                                []string{"gramps"},
		"text/x-processing":                                                       []string{"pde"},
		"application/vnd.nokia.radio-presets":                                     []string{"rpss"},
		"application/vnd.llamagraphics.life-balance.exchange+xml":                 []string{"lbe"},
		"application/x-research-info-systems":                                     []string{"ris"},
		"text/vnd.wap.wml":                                                        []string{"wml"},
		"application/x-blorb":                                                     []string{"blb", "blorb"},
		"application/vnd.noblenet-web":                                            []string{"nnw"},
		"text/vnd.sun.j2me.app-descriptor":                                        []string{"jad"},
		"application/x-conference":                                                []string{"nsc"},
		"audio/basic":                                                             []string{"au", "snd"},
		"application/x-makeself":                                                  []string{"run"},
		"application/x-ms-application":                                            []string{"application"},
		"application/vnd.kde.kword":                                               []string{"kwd", "kwt"},
		"application/vnd.oasis.opendocument.text":                                 []string{"odt"},
		"application/x-bzip":                                                      []string{"bz"},
		"application/cdmi-object":                                                 []string{"cdmio"},
		"application/vnd.fujixerox.ddd":                                           []string{"ddd"},
		"application/vnd.hhe.lesson-player":                                       []string{"les"},
		"application/vnd.mif":                                                     []string{"mif"},
		"application/x-dtbook+xml":                                                []string{"dtb"},
		"application/vnd.chipnuts.karaoke-mmd":                                    []string{"mmd"},
		"application/vnd.oasis.opendocument.text-template":                        []string{"ott"},
		"application/pls+xml":                                                     []string{"pls"},
		"application/vnd.visio":                                                   []string{"vsd", "vst", "vss", "vsw"},
		"audio/x-realaudio":                                                       []string{"ra"},
	}
)
