/*
    Garmin icon tables
    Based on information provided by Ian Cowley, Sigurd Humerfelt,
	and Garmin MapSource

    Copyright (C) 2003-2007 Robert Lipe, robertlipe+source@gpsbabel.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef GARMIN_ICON_TABLES_H
#define GARMIN_ICON_TABLES_H

#include <QString>
#include <QVector>

#include "garmin_tables.h"

struct icon_mapping_t {
  int mpssymnum;
  int pcxsymnum;
  QString icon;
};

/* MapSource 4.13 */
static const QVector<icon_mapping_t> garmin_icon_table = {
  /*	  mps    pcx    desc */
  {   107, 16384, "Airport" },
  {    73,  8204, "Amusement Park" },
  {    55,   169, "Ball Park" },
  {     6,     6, "Bank" },
  {    13,    13, "Bar" },
  {   104,  8244, "Beach" },
  {     1,     1, "Bell" },
  {    37,   150, "Boat Ramp" },
  {    74,  8205, "Bowling" },
  {    93,  8233, "Bridge" },
  {    94,  8234, "Building" },
  {    38,   151, "Campground" },
  {    56,   170, "Car" },
  {    75,  8206, "Car Rental" },
  {    76,  8207, "Car Repair" },
  {    95,  8235, "Cemetery" },
  {    96,  8236, "Church" },
  {    65,   179, "Circle with X" },
  {    72,  8203, "City (Capitol)" },
  {    71,  8200, "City (Large)" },
  {    70,  8199, "City (Medium)" },
  {    69,  8198, "City (Small)" },
  {    69,  8198, "Small City" },
  {    97,  8237, "Civil" },
  {   119,  8262, "Contact, Afro" },
  {   120,  8272, "Contact, Alien" },
  {   121,  8258, "Contact, Ball Cap" },
  {   122,  8259, "Contact, Big Ears" },
  {   123,  8271, "Contact, Biker" },
  {   124,  8273, "Contact, Bug" },
  {   125,  8274, "Contact, Cat" },
  {   126,  8275, "Contact, Dog" },
  {   127,  8263, "Contact, Dreadlocks" },
  {   128,  8264, "Contact, Female1" },
  {   129,  8265, "Contact, Female2" },
  {   130,  8266, "Contact, Female3" },
  {   131,  8261, "Contact, Goatee" },
  {   132,  8268, "Contact, Kung-Fu" },
  {   133,  8276, "Contact, Pig" },
  {   134,  8270, "Contact, Pirate" },
  {   135,  8267, "Contact, Ranger" },
  {   136,  8257, "Contact, Smiley" },
  {   137,  8260, "Contact, Spike" },
  {   138,  8269, "Contact, Sumo" },
  {    52,   165, "Controlled Area" },
  {    89,  8220, "Convenience Store" },
  {    98,  8238, "Crossing" },
  {    51,   164, "Dam" },
  {    53,   166, "Danger Area" },
  {    87,  8218, "Department Store" },
  {     4,     4, "Diver Down Flag 1" },
  {     5,     5, "Diver Down Flag 2" },
  {    41,   154, "Drinking Water" },
  {    63,   177, "Exit" },
  {    77,  8208, "Fast Food" },
  {     7,     7, "Fishing Area" },
  {    78,  8209, "Fitness Center" },
  {    64,   178, "Flag" },
  {   105,  8245, "Forest" },
  {     8,     8, "Gas Station" },
  {   117,  8255, "Geocache" },
  {   118,  8256, "Geocache Found" },
  {    99,  8239, "Ghost Town" },
  {   113, 16393, "Glider Area" },
  {    68,  8197, "Golf Course" },
  {     2,     2, "Diamond, Green" },
  {    15,    15, "Square, Green" },
  {   108, 16388, "Heliport" },
  {     9,     9, "Horn" },
  {    57,   171, "Hunting Area" },
  {    44,   157, "Information" },
  {   100,  8240, "Levee" },
  {    12,    12, "Light" },
  {    90,  8221, "Live Theater" },
  {    59,   173, "Lodging" },
  {    59,   173, "Hotel" },
  {    20,    21, "Man Overboard" },
  {     0,     0, "Anchor" },
  {    43,   156, "Medical Facility" },
  {    66,  8195, "Mile Marker" },
  {   101,  8241, "Military" },
  {    60,   174, "Mine" },
  {    79,  8210, "Movie Theater" },
  {    80,  8211, "Museum" },
  {    21,    22, "Navaid, Amber" },
  {    22,    23, "Navaid, Black" },
  {    23,    24, "Navaid, Blue" },
  {    24,    25, "Navaid, Green" },
  {    25,    26, "Navaid, Green/Red" },
  {    26,    27, "Navaid, Green/White" },
  {    27,    28, "Navaid, Orange" },
  {    28,    29, "Navaid, Red" },
  {    29,    30, "Navaid, Red/Green" },
  {    30,    31, "Navaid, Red/White" },
  {    31,    32, "Navaid, Violet" },
  {    32,    33, "Navaid, White" },
  {    33,    34, "Navaid, White/Green" },
  {    34,    35, "Navaid, White/Red" },
  {   102,  8242, "Oil Field" },
  {   115, 16395, "Parachute Area" },
  {    46,   159, "Park" },
  {    45,   158, "Parking Area" },
  {    81,  8212, "Pharmacy" },
  {    47,   160, "Picnic Area" },
  {    82,  8213, "Pizza" },
  {    83,  8214, "Post Office" },
  {   109, 16389, "Private Field" },
  {    36,    37, "Radio Beacon" },
  {     3,     3, "Diamond, Red" },
  {    16,    16, "Square, Red" },
  {    10,    10, "Residence" },
  {    10,    10, "House" },
  {    11,    11, "Restaurant" },
  {    54,   167, "Restricted Area" },
  {    39,   152, "Restroom" },
  {    84,  8215, "RV Park" },
  {    91,  8226, "Scales" },
  {    48,   161, "Scenic Area" },
  {    85,  8216, "School" },
  {   116, 16402, "Seaplane Base" },
  {    19,    19, "Shipwreck" },
  {    58,   172, "Shopping Center" },
  {   112, 16392, "Short Tower" },
  {    40,   153, "Shower" },
  {    49,   162, "Skiing Area" },
  {    14,    14, "Skull and Crossbones" },
  {   110, 16390, "Soft Field" },
  {    86,  8217, "Stadium" },
  {   106,  8246, "Summit" },
  {    50,   163, "Swimming Area" },
  {   111, 16391, "Tall Tower" },
  {    42,   155, "Telephone" },
  {    92,  8227, "Toll Booth" },
  {    67,  8196, "TracBack Point" },
  {    61,   175, "Trail Head" },
  {    62,   176, "Truck Stop" },
  {   103,  8243, "Tunnel" },
  {   114, 16394, "Ultralight Area" },
  {   139,  8282, "Water Hydrant" },	/* new in MapSource V5 */
  {    18,    18, "Waypoint" },
  {    17,    17, "Buoy, White" },
  {    35,    36, "Dot, White" },
  {    88,  8219, "Zoo" },

  /* Custom icons.   The spec reserves 7680-8191 for the custom
   * icons on the C units, Quest, 27xx, 276, 296,  and other units.
   * Note that firmware problems on the earlier unit result in these
   * being mangled, so be sure you're on a version from at least
   * late 2005.
   * {    -2,  7680, "Custom 0" },
   * ....
   * {    -2,  8192, "Custom 511" },
   */
  /* MapSource V6.x */

  {   140,  8286, "Flag, Red" },
  {   141,  8284, "Flag, Blue" },
  {   142,  8285, "Flag, Green" },
  {   143,  8289, "Pin, Red" },
  {   144,  8287, "Pin, Blue" },
  {   145,  8288, "Pin, Green" },
  {   146,  8292, "Block, Red" },
  {   147,  8290, "Block, Blue" },
  {   148,  8291, "Block, Green" },
  {   149,  8293, "Bike Trail" },
  {   150,   181, "Fishing Hot Spot Facility" },
  {   151,  8249, "Police Station"},
  {   152,  8251, "Ski Resort" },
  {   153,  8252, "Ice Skating" },
  {   154,  8253, "Wrecker" },
  {   155,   184, "Anchor Prohibited" },
  {   156,   185, "Beacon" },
  {   157,   186, "Coast Guard" },
  {   158,   187, "Reef" },
  {   159,   188, "Weed Bed" },
  {   160,   189, "Dropoff" },
  {   161,   190, "Dock" },
  {   162,   191, "Marina" },
  {   163,   192, "Bait and Tackle" },
  {   164,   193, "Stump" },

  /* New in Garmin protocol spec from June 2006.  Extracted from
   * spec and fed through some horrible awk to add ones we didn't
   * have before but normalized for consistency. */
  { -1,  8359, "Asian Food" },
  { 167,  8296, "Circle, Blue" },
  { 168,  8299, "Diamond, Blue" },
  { 178,  8317, "Letter A, Blue" },
  { 181,  8318, "Letter B, Blue" },
  { 184,  8319, "Letter C, Blue" },
  { 187,  8320, "Letter D, Blue" },
  { 190,  8341, "Number 0, Blue" },
  { 193,  8342, "Number 1, Blue" },
  { 196,  8343, "Number 2, Blue" },
  { 199,  8344, "Number 3, Blue" },
  { 202,  8345, "Number 4, Blue" },
  { 205,  8346, "Number 5, Blue" },
  { 208,  8347, "Number 6, Blue" },
  { 211,  8348, "Number 7, Blue" },
  { 214,  8349, "Number 8, Blue" },
  { 217,  8350, "Number 9, Blue" },
  { 171,  8302, "Oval, Blue" },
  { 174,  8305, "Rectangle, Blue" },
  { 175,  8308, "Square, Blue" },
  { 218,  8351, "Triangle, Blue" },
  { -1,  8254, "Border Crossing (Port Of Entry)" },
  { -1,   182, "Bottom Conditions" },
  { -1,  8360, "Deli" },
  { -1,  8228, "Elevation point" },
  { -1,  8229, "Exit without services" },
  { -1, 16398, "First approach fix" },
  { -1,  8250, "Gambling/casino" },
  { -1,  8232, "Geographic place name, land" },
  { -1,  8230, "Geographic place name, Man-made" },
  { -1,  8231, "Geographic place name, water" },
  { 166,  8295, "Circle, Green" },
  { 177,  8313, "Letter A, Green" },
  { 180,  8315, "Letter B, Green" },
  { 183,  8314, "Letter C, Green" },
  { 186,  8316, "Letter D, Green" },
  { 189,  8331, "Number 0, Green" },
  { 192,  8332, "Number 1, Green" },
  { 195,  8333, "Number 2, Green" },
  { 198,  8334, "Number 3, Green" },
  { 201,  8335, "Number 4, Green" },
  { 204,  8336, "Number 5, Green" },
  { 207,  8337, "Number 6, Green" },
  { 210,  8338, "Number 7, Green" },
  { 213,  8339, "Number 8, Green" },
  { 216,  8340, "Number 9, Green" },
  { 170,  8301, "Oval, Green" },
  { 173,  8304, "Rectangle, Green" },
  { 219,  8352, "Triangle, Green" },
  { -1, 16385, "Intersection" },
  { -1,  8201, "Intl freeway hwy" },
  { -1,  8202, "Intl national hwy" },
  { -1,  8361, "Italian food" },
  { -1,  8248, "Large exit without services" },
  { -1,  8247, "Large Ramp intersection" },
  { -1, 16399, "Localizer Outer Marker" },
  { -1, 16400, "Missed approach point" },
  { -1, 16386, "Non-directional beacon" },
  { -1,   168, "Null" },
  { -1,   180, "Open 24 Hours" },
  { -1,  8222, "Ramp intersection" },
  { 165,  8294, "Circle, Red" },
  { 176,  8309, "Letter A, Red" },
  { 179,  8310, "Letter B, Red" },
  { 182,  8311, "Letter C, Red" },
  { 185,  8312, "Letter D, Red" },
  { 188,  8321, "Number 0, Red" },
  { 191,  8322, "Number 1, Red" },
  { 194,  8323, "Number 2, Red" },
  { 197,  8324, "Number 3, Red" },
  { 200,  8325, "Number 4, Red" },
  { 203,  8326, "Number 5, Red" },
  { 206,  8327, "Number 6, Red" },
  { 209,  8328, "Number 7, Red" },
  { 212,  8329, "Number 8, Red" },
  { 215,  8330, "Number 9, Red" },
  { 169,  8300, "Oval, Red" },
  { 172,  8303, "Rectangle, Red" },
  { 220,  8353, "Triangle, Red" },
  { -1,  8362, "Seafood" },
  { -1,  8194, "State Hwy" },
  { -1,  8363, "Steak" },
  { -1,  8223, "Street Intersection" },
  { -1, 16401, "TACAN" },
  { -1,   183, "Tide/Current Prediction Station" },
  { -1,   191, "U Marina" },
  { -1,  8193, "US hwy" },
  { -1,   193, "U stump" },
  { -1, 16387, "VHF Omni-range" },
  { -1, 16397, "VOR-DME" },
  { -1, 16396, "VOR/TACAN" },

  /* This block new on 1/15 from the Mapsource 6.12 beta */
  { 221, -1, "Contact, Blonde" },
  { 222, -1, "Contact, Clown" },
  { 223, -1, "Contact, Glasses" },
  { 224, -1, "Contact, Panda" },
  { 225, -1, "Multi-Cache" },
  { 226, -1, "Letterbox Cache" },
  { 227, -1, "Puzzle Cache" },
  { 228, -1, "Library" },
  { 229, -1, "Ground Transportation" },
  { 230, -1, "City Hall" },
  { 231, -1, "Winery" },
  { 232, -1, "ATV" },
  { 233, -1, "Big Game" },
  { 234, -1, "Blind" },
  { 235, -1, "Blood Trail" },
  { 236, -1, "Cover" },
  { 237, -1, "Covey" },
  { 238, -1, "Food Source" },
  { 239, -1, "Furbearer" },
  { 240, -1, "Lodge" },
  { 241, -1, "Small Game" },
  { 242, -1, "Animal Tracks" },
  { 243, -1, "Treed Quarry" },
  { 244, -1, "Tree Stand" },
  { 245, -1, "Truck" },
  { 246, -1, "Upland Game" },
  { 247, -1, "Waterfowl" },
  { 248, -1, "Water Source" },
};

static const QVector<icon_mapping_t> garmin_smart_icon_table = {
  /* Additional (optional, activated with -Si) icons */
  {    92,  8227, "Micro-Cache" },   	/* icon for "Toll Booth" */
  {    48,   161, "Virtual cache" }, 	/* icon for "Scenic Area" */
  {    86,  8217, "Multi-Cache" },   	/* icon for "Stadium" */
  {    44,   157, "Unknown Cache" },   	/* icon for "Information" */
  {    64,   178, "Locationless (Reverse) Cache" }, /* Icon for "Flag" */
  {    83,  8214, "Post Office" },  	/* Icon for "Post Office" */
  {    47,   160, "Event Cache" }, 	/* Icon for "Event" */
  {    90,  8221, "Webcam Cache" }, 	/* Icon for "Live Theatre" */
};
#endif // GARMIN_ICON_TABLES_H
