;;; GnuTLS --- Guile bindings for GnuTLS.
;;; Copyright (C) 2023-2025 Free Software Foundation, Inc.
;;;
;;; This file is part of Guile-GnuTLS.
;;;
;;; This library is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU Lesser General Public
;;; License as published by the Free Software Foundation; either
;;; version 2.1 of the License, or (at your option) any later version.
;;;
;;; This library is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; Lesser General Public License for more details.
;;;
;;; You should have received a copy of the GNU Lesser General Public
;;; License along with this library; if not, see <https://www.gnu.org/licenses/>.

(use-modules (ice-9 rdelim) (rnrs bytevectors) (gnutls))

(format #t "What is the secret?\n")

(let ((secret (read-line)))
  (format #t "What message do you want to hash?\n")
  (let ((message (read-line)))
    (format #t "The digest is: ~s\n"
            (hmac-direct mac/sha256
                         (string->utf8 secret)
                         (string->utf8 message)))))
