! -*- F90 -*-


!***********************************************************************
!                                                                       
!                         eks98.f                                       
!                                                                       
! An interface for calculating the SCALE DEPENDENT NUCLEAR RATIOS       
!                 R_f^A(x,Q) = f_A(x,Q)/f_p(x,Q)                        
! where f_A is the distribution of parton flavour f in a proton of a    
! nucleus A, and f_p is the corresponding parton distribution in the    
! free proton.                                                          
!                                                                       
! When you are using this interface, please REFER TO:                   
! K.J. Eskola, V.J. Kolhinen and C.A. Salgado,                          
! "The scale dependent nuclear effects in parton distributions for      
! practical applications", Eur. Phys. J. C9 (1999) 61,                  
! JYFL-8/98, US-FT/14-98, hep-ph/9807297.                               
!                                                                       
! The detailed formulation of our approach is given in                  
! K.J. Eskola, V.J. Kolhinen and P.V. Ruuskanen,                        
! "Scale evolution of nuclear parton distributions"                     
! Nucl. Phys. B535 (1998) 351, CERN-TH/97-345, JYFL-2/98, hep-ph/9802350
! so please refer also to this paper.                                   
!                                                                       
! The ratios R_f^A are to a good approximation independent of the choice
! of the parton distribution set for the free proton, so the absolute   
! distributions of parton flavour f in a proton of a nucleus A can be   
! obtained simply by:                                                   
! f_A(x,Q) = R_f^A(x,Q) * f_p(x,Q),                                     
! where f_p is from any modern (lowest order) set of parton distribution
! The corresponding distributions in a neutron of the nucleus can be    
! obtained through the isospin symmetry (=an approximation for non-isosc
! nuclei)                                                               
!                                                                       
! Questions & comments to:                                              
!           salgado@fpaxp1.usc.es                                       
!           vesa.kolhinen@phys.jyu.fi                                   
!           kari.eskola@phys.jyu.fi                                     
!                                                                       
! August 4, 1998                                                        
! April 12, 2000 Modified for PDFLIB: common areas removed,             
!                unnecessary functions eksar0, eksara removed           
!                and code inserted in the main program.                 
!                                                                       
!-------------------------------------------------------------------    
!                                                                       
! INSTRUCTIONS:                                                         
!                                                                       
! call eks98(x,Q,A,ruv,rdv,ru,rd,rs,rc,rb,rt,rg)                        
!                                                                       
! Returns the nuclear corrections R_f^A(x,Q) in double precision for f= 
!                                                                       
!        u_valence: ruv                                                 
!        d_valence: rdv (=ruv)                                          
!        u_sea: ru                                                      
!        d_sea: rd (=ru)                                                
!        s: rs                                                          
!        c: rc                                                          
!        b: rb                                                          
!        t: rt (always set to 1)                                        
!        glue: rg                                                       
!                                                                       
! For x, Q (Q is in GeV) and atomic number A.                           
! x, Q and A are in DOUBLE PRECISION                                    
!                                                                       
! No initialization is needed.                                          
!                                                                       
! This program needs data files par0.all and parxQA.all.                
! They must be located in current working directory.                    
!                                                                       
! This parametrization should only be applied at                        
! 1e-6 < x < almost 1,     1.5 < Q< 100 GeV                             
! Warning: No warning is given if the above kinematic region            
!           in x&Q is exceeded.                                         
! If A<=2, the function returns 1.                                      
!                                                                       
!                                                                       
!                                                                       
!-------------------------------------------------------------------    
                                                                        
      subroutine eks98(x,q,a,ruv,rdv,ru,rd,rs,rc,rb,rt,rg) 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
      dimension pqq(3),r(5),qq0(3),ptm(10) 
      dimension pa(3,10,3,8) 
      dimension pk0(3,180,8) 
      dimension nm(5), kpt(5) 
                                                                        
       data qq0 /2.25d0, 2.54958d0, 21.3474d0/,                         &
     &     x1 /1.d-6/, x116 /.263553d-01/,                              &
     &     aa1 /4.d0/, aa8 /208.d0/                                     
      data nm/1, 1, 2, 3, 1/,                                           &
     &     kpt/1, 3, 6, 7, 8/                                           
                                                                        
      data ((pa(l,k, 1, 1),l=1,3),k=1,10)/                              &
     &     0.14090000E-04,0.35210931E-04,-.10411635E-05,                &
     &     -.23558300E-04,-.47985653E-04,0.16458061E-06,                &
     &     0.13239300E-04,0.29205666E-04,-.45352667E-06,                &
     &     -.64469800E-02,-.17417529E-01,0.49554572E-02,                &
     &     -.30124100E+00,-.12625918E+01,-.11011743E+00,                &
     &     -.29042100E-02,0.17355629E-01,0.18402482E-02,                &
     &     0.80649600E-03,-.29284958E-01,-.32113722E-02,                &
     &     0.14213800E-01,0.29406779E-01,0.17581578E-02,                &
     &     -.29676000E-01,-.29727508E-01,-.62500264E-04,                &
     &     -.77003800E-03,-.23781571E-02,-.10994586E-03/                
      data ((pa(l,k, 2, 1),l=1,3),k=1,10)/                              &
     &     0.17000000E-06,0.18985118E-06,0.82013212E-08,                &
     &     0.16474400E-05,0.36813732E-05,-.59321277E-07,                &
     &     -.55010200E-06,-.12540454E-05,0.27720641E-07,                &
     &     -.13804600E-02,-.30966872E-02,-.18530724E-03,                &
     &     0.40170100E-01,0.12539375E+00,0.21618396E-02,                &
     &     0.15982700E-03,-.11026677E-02,-.12710860E-03,                &
     &     0.90663000E-04,0.19106476E-02,0.21070340E-03,                &
     &     -.79382100E-03,-.17157888E-02,-.11568196E-03,                &
     &     0.13137200E-02,0.13618002E-02,0.11352389E-04,                &
     &     0.35091800E-04,0.14286549E-03,0.86585471E-05/                
      data ((pa(l,k, 3, 1),l=1,3),k=1,10)/                              &
     &     -.16400000E-05,-.50839329E-05,-.15011569E-07,                &
     &     -.13462100E-04,-.31763817E-04,0.81732900E-06,                &
     &     0.32475600E-05,0.79437036E-05,-.27370123E-06,                &
     &     0.43531300E-01,0.99797852E-01,-.33765052E-05,                &
     &     -.76361300E+00,-.20805721E+01,0.72384172E-01,                &
     &     -.71183400E-02,0.16229048E-01,0.22778774E-02,                &
     &     0.71346100E-02,-.25258922E-01,-.35348045E-02,                &
     &     0.47070800E-02,0.20942318E-01,0.18750739E-02,                &
     &     -.28156400E-01,-.30653515E-01,-.34157177E-03,                &
     &     -.17631200E-03,-.23306961E-02,-.17336719E-03/                
      data ((pa(l,k, 1, 2),l=1,3),k=1,10)/                              &
     &     0.61380000E-04,0.14853900E-03,-.36750639E-05,                &
     &     0.15968100E-04,0.41020319E-04,-.16392288E-05,                &
     &     0.88363500E-05,0.19033020E-04,-.16968139E-06,                &
     &     -.16496400E-01,-.40413725E-01,0.43192710E-02,                &
     &     0.10657600E+00,-.27029148E+00,-.93432786E-01,                &
     &     -.28217000E-02,0.17181617E-01,0.18454212E-02,                &
     &     -.86241900E-03,-.30223559E-01,-.31258007E-02,                &
     &     0.13956700E-01,0.28853854E-01,0.16995086E-02,                &
     &     -.24456600E-01,-.25064682E-01,-.10377551E-03,                &
     &     -.62888900E-03,-.22721641E-02,-.11715903E-03/                
      data ((pa(l,k, 2, 2),l=1,3),k=1,10)/                              &
     &     -.19000000E-06,-.10044773E-05,0.61298878E-07,                &
     &     0.33967100E-06,0.73940302E-06,0.31650756E-07,                &
     &     -.53868400E-06,-.12281937E-05,0.18049452E-07,                &
     &     0.21490200E-03,0.63825136E-03,-.19376196E-03,                &
     &     0.31242300E-02,0.30844484E-01,0.23502040E-02,                &
     &     0.14637900E-03,-.10280021E-02,-.11516974E-03,                &
     &     0.13515000E-03,0.18142272E-02,0.18674764E-03,                &
     &     -.72518000E-03,-.15785224E-02,-.10146757E-03,                &
     &     0.10602500E-02,0.11233630E-02,0.10292593E-04,                &
     &     0.27129200E-04,0.13007019E-03,0.81434799E-05/                
      data ((pa(l,k, 3, 2),l=1,3),k=1,10)/                              &
     &     -.90700000E-05,-.26248056E-04,0.49314368E-06,                &
     &     -.23052500E-04,-.49923281E-04,0.27354603E-06,                &
     &     0.80499500E-05,0.18679598E-04,-.33424836E-06,                &
     &     0.12089900E-01,0.25464894E-01,0.11934209E-02,                &
     &     -.28895900E+00,-.83762649E+00,0.42726650E-01,                &
     &     -.48770900E-02,0.13994036E-01,0.18830252E-02,                &
     &     0.33748500E-02,-.22264470E-01,-.28819285E-02,                &
     &     0.54743100E-02,0.18101633E-01,0.15213690E-02,                &
     &     -.22589700E-01,-.24105648E-01,-.33008792E-03,                &
     &     -.17070800E-03,-.19670336E-02,-.14766491E-03/                
      data ((pa(l,k, 1, 3),l=1,3),k=1,10)/                              &
     &     0.44222800E-02,0.74796930E-02,-.48653299E-03,                &
     &     0.59383000E-03,0.10192475E-02,-.71331775E-04,                &
     &     -.39855500E-04,-.61655017E-04,0.11503163E-04,                &
     &     -.22521400E+00,-.40590456E+00,0.16937813E-01,                &
     &     0.37195900E+01,0.60005449E+01,-.48930655E+00,                &
     &     0.30258700E-02,-.54273565E-03,0.76587657E-04,                &
     &     -.42620500E-02,0.43944658E-02,-.25228842E-03,                &
     &     0.14056100E-01,0.70383618E-02,-.33994041E-04,                &
     &     -.26556200E-01,-.21355055E-01,0.49703670E-03,                &
     &     -.20423500E-02,-.24351757E-02,-.39484822E-05/                
      data ((pa(l,k, 2, 3),l=1,3),k=1,10)/                              &
     &     -.16147000E-03,-.26895650E-03,0.20678351E-04,                &
     &     -.33956600E-04,-.56432821E-04,0.47413027E-05,                &
     &     0.89641200E-06,0.97071095E-06,-.51137705E-06,                &
     &     0.14154800E-01,0.25838370E-01,-.18537242E-02,                &
     &     -.23950500E+00,-.42226853E+00,0.41208339E-01,                &
     &     0.10307600E-03,-.76253410E-03,-.42040028E-04,                &
     &     0.29854600E-03,0.19112958E-02,0.99559330E-04,                &
     &     -.10087600E-02,-.20066724E-02,-.55885278E-04,                &
     &     0.14489900E-02,0.16363993E-02,-.10654975E-04,                &
     &     0.88101000E-04,0.18509813E-03,0.14169991E-05/                
      data ((pa(l,k, 3, 3),l=1,3),k=1,10)/                              &
     &     -.20939400E-02,-.36074626E-02,0.19156847E-03,                &
     &     -.11838200E-03,-.27260062E-03,-.93137551E-05,                &
     &     0.84978700E-04,0.14943069E-03,-.10654041E-04,                &
     &     -.16893400E+00,-.23871983E+00,0.69182509E-01,                &
     &     0.32437100E+01,0.41987821E+01,-.11809893E+01,                &
     &     0.22920000E-02,0.19368165E-01,0.11864272E-02,                &
     &     -.40666100E-01,-.80447246E-01,-.31240079E-02,                &
     &     0.50270100E-01,0.76175679E-01,0.18308670E-02,                &
     &     -.44848100E-01,-.57740531E-01,0.23954032E-03,                &
     &     -.52800800E-03,-.17673218E-02,0.20697993E-04/                
      data ((pa(l,k, 1, 4),l=1,3),k=1,10)/                              &
     &     0.44222800E-02,0.74796930E-02,-.48653299E-03,                &
     &     0.59383000E-03,0.10192475E-02,-.71331775E-04,                &
     &     -.39855500E-04,-.61655017E-04,0.11503163E-04,                &
     &     -.22521400E+00,-.40590456E+00,0.16937813E-01,                &
     &     0.37195900E+01,0.60005449E+01,-.48930655E+00,                &
     &     0.30258700E-02,-.54273565E-03,0.76587657E-04,                &
     &     -.42620500E-02,0.43944658E-02,-.25228842E-03,                &
     &     0.14056100E-01,0.70383618E-02,-.33994041E-04,                &
     &     -.26556200E-01,-.21355055E-01,0.49703670E-03,                &
     &     -.20423500E-02,-.24351757E-02,-.39484822E-05/                
      data ((pa(l,k, 2, 4),l=1,3),k=1,10)/                              &
     &     -.16147000E-03,-.26895650E-03,0.20678351E-04,                &
     &     -.33956600E-04,-.56432821E-04,0.47413027E-05,                &
     &     0.89641200E-06,0.97071095E-06,-.51137705E-06,                &
     &     0.14154800E-01,0.25838370E-01,-.18537242E-02,                &
     &     -.23950500E+00,-.42226853E+00,0.41208339E-01,                &
     &     0.10307600E-03,-.76253410E-03,-.42040028E-04,                &
     &     0.29854600E-03,0.19112958E-02,0.99559330E-04,                &
     &     -.10087600E-02,-.20066724E-02,-.55885278E-04,                &
     &     0.14489900E-02,0.16363993E-02,-.10654975E-04,                &
     &     0.88101000E-04,0.18509813E-03,0.14169991E-05/                
      data ((pa(l,k, 3, 4),l=1,3),k=1,10)/                              &
     &     -.20939400E-02,-.36074626E-02,0.19156847E-03,                &
     &     -.11838200E-03,-.27260062E-03,-.93137551E-05,                &
     &     0.84978700E-04,0.14943069E-03,-.10654041E-04,                &
     &     -.16893400E+00,-.23871983E+00,0.69182509E-01,                &
     &     0.32437100E+01,0.41987821E+01,-.11809893E+01,                &
     &     0.22920000E-02,0.19368165E-01,0.11864272E-02,                &
     &     -.40666100E-01,-.80447246E-01,-.31240079E-02,                &
     &     0.50270100E-01,0.76175679E-01,0.18308670E-02,                &
     &     -.44848100E-01,-.57740531E-01,0.23954032E-03,                &
     &     -.52800800E-03,-.17673218E-02,0.20697993E-04/                
      data ((pa(l,k, 1, 5),l=1,3),k=1,10)/                              &
     &     0.44845800E-02,0.75813459E-02,-.49633111E-03,                &
     &     0.62746000E-03,0.10650655E-02,-.79101830E-04,                &
     &     -.50490100E-04,-.76547625E-04,0.13978409E-04,                &
     &     -.26483700E+00,-.50371666E+00,0.11914335E-01,                &
     &     0.33268000E+01,0.63907392E+01,-.49536068E+00,                &
     &     0.15007800E-01,0.37291585E-01,0.22229452E-02,                &
     &     -.22978200E-01,-.61596530E-01,-.37776891E-02,                &
     &     0.23703900E-01,0.46152502E-01,0.20695893E-02,                &
     &     -.25386800E-01,-.28920674E-01,-.54551888E-04,                &
     &     -.21454100E-02,-.37248798E-02,-.16659417E-03/                
      data ((pa(l,k, 2, 5),l=1,3),k=1,10)/                              &
     &     -.16048000E-03,-.26724915E-03,0.20709354E-04,                &
     &     -.33396500E-04,-.55088829E-04,0.49309457E-05,                &
     &     0.56120600E-06,0.29620983E-06,-.54778567E-06,                &
     &     0.12460300E-01,0.23127396E-01,-.20231139E-02,                &
     &     -.15550600E+00,-.28039359E+00,0.45451576E-01,                &
     &     0.11876200E-03,-.58939849E-03,-.62714393E-04,                &
     &     -.33678900E-04,0.13657628E-02,0.13448844E-03,                &
     &     -.67097200E-03,-.15695610E-02,-.78462377E-04,                &
     &     0.13328300E-02,0.15163247E-02,-.52430392E-05,                &
     &     0.10240500E-03,0.18954366E-03,0.40054816E-05/                
      data ((pa(l,k, 3, 5),l=1,3),k=1,10)/                              &
     &     -.23352600E-02,-.40041989E-02,0.22280333E-03,                &
     &     -.28523500E-03,-.56130916E-03,0.11583071E-04,                &
     &     0.14209200E-03,0.24635266E-03,-.18223806E-04,                &
     &     0.13243600E+00,0.30806831E+00,0.95226565E-01,                &
     &     -.13163400E+01,-.39408794E+01,-.12402760E+01,                &
     &     -.68116000E-01,-.98238919E-01,-.34258159E-02,                &
     &     0.96171400E-01,0.13422345E+00,0.33947152E-02,                &
     &     -.36353500E-01,-.52689855E-01,-.14904227E-02,                &
     &     -.41063700E-01,-.38415039E-01,0.14310422E-02,                &
     &     0.37885100E-03,-.51323741E-04,0.34237799E-03/                
      data ((pa(l,k, 1, 6),l=1,3),k=1,10)/                              &
     &     0.35266000E-02,0.59933727E-02,-.36692786E-03,                &
     &     0.36285000E-03,0.63679303E-03,-.36104798E-04,                &
     &     -.36462300E-04,-.60025589E-04,0.81293376E-05,                &
     &     -.18853200E+00,-.32876665E+00,0.79975149E-02,                &
     &     0.22463800E+01,0.33126946E+01,-.38302624E+00,                &
     &     0.10597500E-01,0.11040625E-01,0.28139630E-03,                &
     &     -.19728000E-02,0.69755582E-02,-.13699242E-03,                &
     &     0.72868300E-02,-.33399200E-02,-.23761882E-03,                &
     &     -.26059800E-01,-.16839722E-01,0.58515148E-03,                &
     &     -.20515600E-02,-.23252028E-02,-.34962122E-04/                
      data ((pa(l,k, 2, 6),l=1,3),k=1,10)/                              &
     &     -.13317000E-03,-.22276611E-03,0.16454499E-04,                &
     &     -.25562000E-04,-.42991824E-04,0.35028592E-05,                &
     &     0.96007200E-06,0.12213552E-05,-.48153415E-06,                &
     &     0.12991300E-01,0.23827400E-01,-.11280363E-02,                &
     &     -.13709100E+00,-.24324855E+00,0.32625195E-01,                &
     &     -.11790700E-02,-.26475520E-02,-.88878320E-04,                &
     &     0.13084100E-02,0.32913187E-02,0.12900752E-03,                &
     &     -.11930900E-02,-.21489951E-02,-.61358893E-04,                &
     &     0.15210600E-02,0.15176937E-02,-.70379041E-05,                &
     &     0.16704500E-03,0.29529963E-03,0.78644942E-05/                
      data ((pa(l,k, 3, 6),l=1,3),k=1,10)/                              &
     &     -.11418000E-03,-.28801533E-03,-.50162205E-04,                &
     &     0.40845500E-03,0.63815903E-03,-.86521388E-04,                &
     &     0.33060300E-04,0.69342929E-04,0.49976234E-05,                &
     &     -.27146800E+00,-.48641306E+00,0.46499887E-01,                &
     &     0.22103200E+01,0.35696673E+01,-.10038513E+01,                &
     &     0.28317600E-01,0.60547503E-01,0.16782368E-02,                &
     &     -.35867300E-01,-.78056467E-01,-.22058781E-02,                &
     &     0.26307000E-01,0.46634608E-01,0.98735335E-03,                &
     &     -.41748400E-01,-.44276120E-01,0.27442134E-03,                &
     &     -.37396200E-02,-.68228378E-02,-.16825971E-03/                
      data ((pa(l,k, 1, 7),l=1,3),k=1,10)/                              &
     &     0.21692300E-02,0.36952769E-02,-.21010349E-03,                &
     &     0.17592800E-03,0.31783026E-03,-.15502296E-04,                &
     &     -.18683600E-04,-.31611478E-04,0.40080356E-05,                &
     &     -.12202000E+00,-.20622823E+00,0.61096182E-02,                &
     &     0.15770800E+01,0.21750242E+01,-.25358005E+00,                &
     &     0.83402700E-02,0.67734664E-02,0.22627540E-03,                &
     &     -.27332400E-02,0.63426934E-02,-.72491227E-04,                &
     &     0.86311100E-02,-.55382432E-03,-.28636130E-03,                &
     &     -.26152900E-01,-.19105241E-01,0.65797151E-03,                &
     &     -.15538600E-02,-.15893496E-02,-.24541168E-04/                
      data ((pa(l,k, 2, 7),l=1,3),k=1,10)/                              &
     &     -.76380000E-04,-.12733149E-03,0.86215493E-05,                &
     &     -.12255000E-04,-.21528506E-04,0.15487340E-05,                &
     &     0.48724600E-06,0.72344695E-06,-.23221259E-06,                &
     &     0.69999500E-02,0.12663170E-01,-.53981131E-03,                &
     &     -.72149800E-01,-.12775289E+00,0.16386406E-01,                &
     &     -.50290300E-03,-.13183355E-02,-.49142332E-04,                &
     &     0.48767200E-03,0.15498641E-02,0.69481269E-04,                &
     &     -.76578300E-03,-.12339477E-02,-.27788711E-04,                &
     &     0.13320600E-02,0.12715671E-02,-.13519969E-04,                &
     &     0.89711000E-04,0.16032593E-03,0.41675546E-05/                
      data ((pa(l,k, 3, 7),l=1,3),k=1,10)/                              &
     &     0.17840000E-04,0.35458069E-04,-.11614547E-04,                &
     &     0.63084400E-04,0.94159278E-04,-.98121820E-05,                &
     &     0.24251500E-05,0.63701608E-05,0.70554838E-06,                &
     &     -.32182300E-01,-.59258463E-01,0.49396169E-02,                &
     &     0.21794500E+00,0.36064906E+00,-.11054416E+00,                &
     &     0.29890200E-02,0.74401436E-02,0.24613170E-03,                &
     &     -.37742000E-02,-.93764364E-02,-.31786519E-03,                &
     &     0.41737100E-02,0.66501930E-02,0.12548505E-03,                &
     &     -.98392800E-02,-.93367060E-02,0.32700119E-04,                &
     &     -.49142500E-03,-.90951301E-03,-.23706858E-04/                
      data ((pa(l,k, 1, 8),l=1,3),k=1,10)/                              &
     &     0.45569100E-02,0.77982882E-02,-.44016735E-03,                &
     &     0.33143000E-03,0.59861127E-03,-.16446211E-04,                &
     &     -.49979300E-04,-.84282669E-04,0.81672928E-05,                &
     &     -.14697500E+00,-.27088643E+00,-.65341872E-03,                &
     &     0.12453800E+01,0.21262786E+01,-.20137579E+00,                &
     &     0.17633600E-01,0.37868613E-01,0.20909133E-02,                &
     &     -.31127900E-01,-.52905407E-01,-.28222375E-02,                &
     &     0.49221700E-01,0.54858710E-01,0.98233606E-03,                &
     &     -.67330200E-01,-.60969566E-01,0.56950780E-03,                &
     &     -.28949100E-02,-.46048285E-02,-.17187653E-03/                
      data ((pa(l,k, 2, 8),l=1,3),k=1,10)/                              &
     &     -.21141000E-03,-.35691000E-03,0.23971219E-04,                &
     &     -.29700200E-04,-.50563745E-04,0.33904455E-05,                &
     &     0.11311100E-05,0.15438373E-05,-.47771887E-06,                &
     &     0.11091600E-01,0.19439138E-01,-.16586512E-02,                &
     &     -.41908500E-01,-.23856210E-01,0.36544019E-01,                &
     &     -.29486000E-02,-.54287526E-02,-.17324155E-03,                &
     &     0.51199700E-02,0.79784550E-02,0.21583359E-03,                &
     &     -.47555400E-02,-.58710962E-02,-.81300361E-04,                &
     &     0.32006800E-02,0.30646671E-02,-.14162448E-04,                &
     &     0.36106200E-03,0.60841738E-03,0.16983488E-04/                
      data ((pa(l,k, 3, 8),l=1,3),k=1,10)/                              &
     &     0.78489000E-03,0.11365806E-02,-.21063087E-03,                &
     &     0.78569200E-03,0.12087424E-02,-.16201037E-03,                &
     &     0.90177800E-04,0.17930061E-03,0.32461910E-05,                &
     &     -.35399100E+00,-.58029245E+00,0.12341179E+00,                &
     &     -.13867800E+00,-.25956776E+01,-.19832421E+01,                &
     &     0.10291500E+00,0.21979607E+00,0.44907795E-02,                &
     &     -.12476100E+00,-.27286984E+00,-.52889947E-02,                &
     &     0.72597700E-01,0.14439439E+00,0.22982672E-02,                &
     &     -.54130600E-01,-.68893260E-01,0.24353123E-03,                &
     &     -.13702100E-01,-.25940355E-01,-.53133565E-03/                
                                                                        
                                                                        
      data ((pk0(l,k, 1),l=1,3),k=  1, 15)/                             &
     &     0.98805500E+00,-.29579874E-01,0.41936474E-03,                &
     &     0.98805600E+00,-.29577460E-01,0.41913443E-03,                &
     &     0.98805600E+00,-.29574714E-01,0.41897684E-03,                &
     &     0.98805800E+00,-.29573275E-01,0.41902654E-03,                &
     &     0.98805800E+00,-.29570265E-01,0.41882206E-03,                &
     &     0.98805900E+00,-.29567222E-01,0.41858194E-03,                &
     &     0.98806100E+00,-.29564971E-01,0.41862252E-03,                &
     &     0.98806300E+00,-.29560869E-01,0.41826973E-03,                &
     &     0.98807100E+00,-.29560883E-01,0.41866558E-03,                &
     &     0.98806800E+00,-.29553342E-01,0.41770607E-03,                &
     &     0.98806600E+00,-.29552281E-01,0.41830376E-03,                &
     &     0.98806300E+00,-.29548063E-01,0.41804157E-03,                &
     &     0.98806800E+00,-.29544846E-01,0.41788272E-03,                &
     &     0.98806500E+00,-.29532692E-01,0.41594764E-03,                &
     &     0.98807100E+00,-.29532367E-01,0.41660640E-03/                
      data ((pk0(l,k, 1),l=1,3),k= 16, 30)/                             &
     &     0.98807700E+00,-.29531715E-01,0.41769536E-03,                &
     &     0.98808300E+00,-.29530264E-01,0.41801263E-03,                &
     &     0.98808200E+00,-.29521192E-01,0.41708452E-03,                &
     &     0.98808300E+00,-.29513120E-01,0.41645956E-03,                &
     &     0.98808400E+00,-.29503972E-01,0.41546815E-03,                &
     &     0.98808700E+00,-.29497753E-01,0.41541099E-03,                &
     &     0.98809200E+00,-.29492909E-01,0.41558773E-03,                &
     &     0.98809100E+00,-.29486954E-01,0.41580607E-03,                &
     &     0.98809900E+00,-.29478824E-01,0.41534508E-03,                &
     &     0.98809600E+00,-.29468423E-01,0.41473919E-03,                &
     &     0.98810100E+00,-.29460799E-01,0.41458652E-03,                &
     &     0.98810900E+00,-.29451330E-01,0.41421981E-03,                &
     &     0.98811300E+00,-.29441179E-01,0.41395156E-03,                &
     &     0.98811300E+00,-.29427432E-01,0.41291184E-03,                &
     &     0.98812200E+00,-.29417874E-01,0.41272928E-03/                
      data ((pk0(l,k, 1),l=1,3),k= 31, 45)/                             &
     &     0.98812800E+00,-.29404982E-01,0.41210654E-03,                &
     &     0.98813100E+00,-.29393646E-01,0.41196984E-03,                &
     &     0.98813800E+00,-.29378057E-01,0.41110962E-03,                &
     &     0.98814200E+00,-.29363157E-01,0.41052055E-03,                &
     &     0.98814900E+00,-.29348119E-01,0.41022056E-03,                &
     &     0.98816000E+00,-.29332713E-01,0.40957699E-03,                &
     &     0.98816400E+00,-.29314311E-01,0.40896478E-03,                &
     &     0.98817200E+00,-.29291110E-01,0.40704747E-03,                &
     &     0.98817900E+00,-.29273512E-01,0.40717798E-03,                &
     &     0.98818900E+00,-.29251814E-01,0.40621427E-03,                &
     &     0.98819900E+00,-.29228853E-01,0.40512445E-03,                &
     &     0.98820800E+00,-.29204449E-01,0.40412969E-03,                &
     &     0.98822100E+00,-.29179043E-01,0.40329040E-03,                &
     &     0.98823000E+00,-.29150607E-01,0.40198100E-03,                &
     &     0.98824300E+00,-.29123106E-01,0.40126168E-03/                
      data ((pk0(l,k, 1),l=1,3),k= 46, 60)/                             &
     &     0.98825500E+00,-.29091675E-01,0.39991981E-03,                &
     &     0.98827200E+00,-.29059487E-01,0.39882305E-03,                &
     &     0.98828500E+00,-.29023922E-01,0.39735082E-03,                &
     &     0.98829900E+00,-.28985348E-01,0.39551940E-03,                &
     &     0.98831400E+00,-.28945167E-01,0.39388608E-03,                &
     &     0.98833300E+00,-.28906000E-01,0.39291261E-03,                &
     &     0.98834900E+00,-.28858687E-01,0.39051615E-03,                &
     &     0.98836900E+00,-.28812875E-01,0.38911143E-03,                &
     &     0.98839100E+00,-.28761597E-01,0.38697151E-03,                &
     &     0.98841300E+00,-.28709159E-01,0.38497692E-03,                &
     &     0.98843400E+00,-.28651219E-01,0.38252825E-03,                &
     &     0.98846100E+00,-.28591488E-01,0.38038817E-03,                &
     &     0.98848800E+00,-.28527928E-01,0.37793833E-03,                &
     &     0.98851200E+00,-.28458456E-01,0.37498109E-03,                &
     &     0.98854400E+00,-.28388390E-01,0.37269367E-03/                
      data ((pk0(l,k, 1),l=1,3),k= 61, 75)/                             &
     &     0.98857400E+00,-.28311034E-01,0.36954463E-03,                &
     &     0.98860800E+00,-.28231022E-01,0.36660487E-03,                &
     &     0.98864400E+00,-.28145957E-01,0.36351441E-03,                &
     &     0.98868100E+00,-.28054036E-01,0.35980195E-03,                &
     &     0.98872000E+00,-.27957403E-01,0.35607963E-03,                &
     &     0.98876400E+00,-.27857152E-01,0.35272440E-03,                &
     &     0.98880600E+00,-.27746515E-01,0.34809236E-03,                &
     &     0.98885400E+00,-.27633423E-01,0.34416643E-03,                &
     &     0.98890300E+00,-.27511837E-01,0.33956954E-03,                &
     &     0.98895600E+00,-.27383732E-01,0.33490582E-03,                &
     &     0.98901100E+00,-.27246542E-01,0.32963692E-03,                &
     &     0.98907000E+00,-.27104335E-01,0.32480728E-03,                &
     &     0.98913300E+00,-.26952741E-01,0.31935086E-03,                &
     &     0.98919800E+00,-.26790835E-01,0.31340954E-03,                &
     &     0.98926800E+00,-.26621619E-01,0.30751914E-03/                
      data ((pk0(l,k, 1),l=1,3),k= 76, 90)/                             &
     &     0.98934100E+00,-.26441398E-01,0.30109164E-03,                &
     &     0.98942000E+00,-.26252020E-01,0.29444788E-03,                &
     &     0.98950100E+00,-.26050504E-01,0.28731111E-03,                &
     &     0.98958800E+00,-.25838372E-01,0.27993224E-03,                &
     &     0.98968100E+00,-.25616559E-01,0.27270793E-03,                &
     &     0.98977600E+00,-.25379392E-01,0.26451913E-03,                &
     &     0.98987800E+00,-.25130589E-01,0.25634065E-03,                &
     &     0.98998600E+00,-.24867667E-01,0.24769411E-03,                &
     &     0.99009800E+00,-.24588894E-01,0.23832791E-03,                &
     &     0.99021800E+00,-.24297120E-01,0.22923106E-03,                &
     &     0.99034500E+00,-.23989402E-01,0.21961454E-03,                &
     &     0.99047800E+00,-.23663977E-01,0.20948636E-03,                &
     &     0.99061700E+00,-.23319923E-01,0.19886184E-03,                &
     &     0.99076500E+00,-.22958411E-01,0.18798797E-03,                &
     &     0.99092100E+00,-.22577868E-01,0.17692038E-03/                
      data ((pk0(l,k, 1),l=1,3),k= 91,105)/                             &
     &     0.99108500E+00,-.22176430E-01,0.16550703E-03,                &
     &     0.99125700E+00,-.21752277E-01,0.15344099E-03,                &
     &     0.99143900E+00,-.21305047E-01,0.14108019E-03,                &
     &     0.99162400E+00,-.20834344E-01,0.12877821E-03,                &
     &     0.99182700E+00,-.20334672E-01,0.11488639E-03,                &
     &     0.99204600E+00,-.19813472E-01,0.10237765E-03,                &
     &     0.99227200E+00,-.19263641E-01,0.89224701E-04,                &
     &     0.99251100E+00,-.18679496E-01,0.75420170E-04,                &
     &     0.99275500E+00,-.18061734E-01,0.61050831E-04,                &
     &     0.99302600E+00,-.17420251E-01,0.49219499E-04,                &
     &     0.99330600E+00,-.16731847E-01,0.35382781E-04,                &
     &     0.99360100E+00,-.16004447E-01,0.21237047E-04,                &
     &     0.99391600E+00,-.15234560E-01,0.74743978E-05,                &
     &     0.99424900E+00,-.14417068E-01,-.64800042E-05,                &
     &     0.99460300E+00,-.13551375E-01,-.19830104E-04/                
      data ((pk0(l,k, 1),l=1,3),k=106,120)/                             &
     &     0.99497500E+00,-.12631829E-01,-.32253740E-04,                &
     &     0.99538100E+00,-.11656034E-01,-.44328786E-04,                &
     &     0.99580400E+00,-.10616951E-01,-.55042428E-04,                &
     &     0.99626200E+00,-.95135519E-02,-.63675877E-04,                &
     &     0.99675100E+00,-.83280611E-02,-.72663823E-04,                &
     &     0.99727400E+00,-.70622158E-02,-.79424860E-04,                &
     &     0.99784000E+00,-.57154893E-02,-.81837119E-04,                &
     &     0.99844600E+00,-.42649820E-02,-.82798792E-04,                &
     &     0.99910100E+00,-.27124368E-02,-.78960178E-04,                &
     &     0.99980500E+00,-.10447937E-02,-.69975933E-04,                &
     &     0.10005700E+01,0.73538220E-03,-.52967542E-04,                &
     &     0.10013600E+01,0.25715563E-02,-.30311898E-04,                &
     &     0.10021800E+01,0.44194917E-02,-.12766878E-05,                &
     &     0.10030100E+01,0.62578295E-02,0.34893028E-04,                &
     &     0.10038400E+01,0.80714467E-02,0.75584238E-04/                
      data ((pk0(l,k, 1),l=1,3),k=121,135)/                             &
     &     0.10046800E+01,0.98148722E-02,0.12340889E-03,                &
     &     0.10055100E+01,0.11478096E-01,0.17096066E-03,                &
     &     0.10063300E+01,0.13007302E-01,0.22030138E-03,                &
     &     0.10071200E+01,0.14380777E-01,0.26511540E-03,                &
     &     0.10078800E+01,0.15544251E-01,0.30407445E-03,                &
     &     0.10086000E+01,0.16466054E-01,0.33188516E-03,                &
     &     0.10092600E+01,0.17121077E-01,0.34107920E-03,                &
     &     0.10098600E+01,0.17478694E-01,0.32792040E-03,                &
     &     0.10112200E+01,0.18307583E-01,0.26138702E-03,                &
     &     0.10122800E+01,0.18619387E-01,0.15939029E-03,                &
     &     0.10130900E+01,0.18519253E-01,0.27009905E-04,                &
     &     0.10136700E+01,0.18110723E-01,-.12344489E-03,                &
     &     0.10140300E+01,0.17496051E-01,-.27769739E-03,                &
     &     0.10141900E+01,0.16749844E-01,-.41810465E-03,                &
     &     0.10141200E+01,0.15920406E-01,-.52615496E-03/                
      data ((pk0(l,k, 1),l=1,3),k=136,150)/                             &
     &     0.10138000E+01,0.15005243E-01,-.58672528E-03,                &
     &     0.10131700E+01,0.13975559E-01,-.59192299E-03,                &
     &     0.10121800E+01,0.12740951E-01,-.53813782E-03,                &
     &     0.10107500E+01,0.11236568E-01,-.43905669E-03,                &
     &     0.10088600E+01,0.93505682E-02,-.30574238E-03,                &
     &     0.10064600E+01,0.70411372E-02,-.15948770E-03,                &
     &     0.10035300E+01,0.42762699E-02,-.17404487E-04,                &
     &     0.10000500E+01,0.10410833E-02,0.11229892E-03,                &
     &     0.99611500E+00,-.27586838E-02,0.24273533E-03,                &
     &     0.99174800E+00,-.71635519E-02,0.38513059E-03,                &
     &     0.98678000E+00,-.11857106E-01,0.47076429E-03,                &
     &     0.98127900E+00,-.16583879E-01,0.45718377E-03,                &
     &     0.97539500E+00,-.21782577E-01,0.53296129E-03,                &
     &     0.96939000E+00,-.27132384E-01,0.61156658E-03,                &
     &     0.96369400E+00,-.32215089E-01,0.67535930E-03/                
      data ((pk0(l,k, 1),l=1,3),k=151,165)/                             &
     &     0.96241400E+00,-.33360577E-01,0.68795480E-03,                &
     &     0.96123000E+00,-.34423853E-01,0.69963768E-03,                &
     &     0.96014000E+00,-.35391481E-01,0.70959966E-03,                &
     &     0.95916700E+00,-.36260184E-01,0.71735378E-03,                &
     &     0.95831100E+00,-.37027861E-01,0.72488951E-03,                &
     &     0.95758100E+00,-.37681782E-01,0.73088783E-03,                &
     &     0.95698100E+00,-.38220825E-01,0.73595805E-03,                &
     &     0.95652000E+00,-.38632853E-01,0.73938901E-03,                &
     &     0.95620700E+00,-.38914732E-01,0.74167984E-03,                &
     &     0.95604500E+00,-.39057645E-01,0.74264427E-03,                &
     &     0.95622000E+00,-.38902390E-01,0.73954442E-03,                &
     &     0.95778500E+00,-.37514334E-01,0.71344315E-03,                &
     &     0.96091200E+00,-.34734622E-01,0.66036545E-03,                &
     &     0.96560200E+00,-.30567869E-01,0.58152764E-03,                &
     &     0.97185600E+00,-.25008112E-01,0.47536361E-03/                
      data ((pk0(l,k, 1),l=1,3),k=166,180)/                             &
     &     0.97967300E+00,-.18059299E-01,0.34285939E-03,                &
     &     0.98906000E+00,-.97286265E-02,0.18559549E-03,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14,                &
     &     0.10125000E+01,0.11119766E-01,-.21243592E-03,                &
     &     0.10265800E+01,0.23616219E-01,-.44808781E-03,                &
     &     0.10422200E+01,0.37510483E-01,-.71302034E-03,                &
     &     0.10594200E+01,0.52792213E-01,-.10027142E-02,                &
     &     0.10781800E+01,0.69462743E-01,-.13193591E-02,                &
     &     0.10985000E+01,0.87535352E-01,-.16654905E-02,                &
     &     0.11203900E+01,0.10698448E+00,-.20338674E-02,                &
     &     0.11438500E+01,0.12781732E+00,-.24288130E-02,                &
     &     0.11688600E+01,0.15005424E+00,-.28529975E-02,                &
     &     0.11954400E+01,0.17367534E+00,-.33024553E-02,                &
     &     0.12235900E+01,0.19867996E+00,-.37770251E-02,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14/                
      data ((pk0(l,k, 2),l=1,3),k=  1, 15)/                             &
     &     0.98805500E+00,-.29579422E-01,0.41918637E-03,                &
     &     0.98805600E+00,-.29577255E-01,0.41912607E-03,                &
     &     0.98805700E+00,-.29575099E-01,0.41901529E-03,                &
     &     0.98805700E+00,-.29572995E-01,0.41898641E-03,                &
     &     0.98805800E+00,-.29569798E-01,0.41870508E-03,                &
     &     0.98805900E+00,-.29566762E-01,0.41851172E-03,                &
     &     0.98806100E+00,-.29564500E-01,0.41847276E-03,                &
     &     0.98806500E+00,-.29565946E-01,0.41928874E-03,                &
     &     0.98806800E+00,-.29562397E-01,0.41904924E-03,                &
     &     0.98806700E+00,-.29557672E-01,0.41874452E-03,                &
     &     0.98806500E+00,-.29547754E-01,0.41690676E-03,                &
     &     0.98807200E+00,-.29548491E-01,0.41779847E-03,                &
     &     0.98807100E+00,-.29543145E-01,0.41761585E-03,                &
     &     0.98807200E+00,-.29539157E-01,0.41760575E-03,                &
     &     0.98807600E+00,-.29537403E-01,0.41779584E-03/                
      data ((pk0(l,k, 2),l=1,3),k= 16, 30)/                             &
     &     0.98807000E+00,-.29528117E-01,0.41695576E-03,                &
     &     0.98807600E+00,-.29523422E-01,0.41652643E-03,                &
     &     0.98808100E+00,-.29517279E-01,0.41619558E-03,                &
     &     0.98808000E+00,-.29511410E-01,0.41605618E-03,                &
     &     0.98808600E+00,-.29510141E-01,0.41687506E-03,                &
     &     0.98809000E+00,-.29501900E-01,0.41609066E-03,                &
     &     0.98809200E+00,-.29493344E-01,0.41563413E-03,                &
     &     0.98809800E+00,-.29487687E-01,0.41573871E-03,                &
     &     0.98809500E+00,-.29476777E-01,0.41497622E-03,                &
     &     0.98809800E+00,-.29469183E-01,0.41472176E-03,                &
     &     0.98810500E+00,-.29462639E-01,0.41498449E-03,                &
     &     0.98810600E+00,-.29449045E-01,0.41362074E-03,                &
     &     0.98811200E+00,-.29442003E-01,0.41401876E-03,                &
     &     0.98811500E+00,-.29427270E-01,0.41263684E-03,                &
     &     0.98812100E+00,-.29417525E-01,0.41260094E-03/                
      data ((pk0(l,k, 2),l=1,3),k= 31, 45)/                             &
     &     0.98812400E+00,-.29404390E-01,0.41197122E-03,                &
     &     0.98813400E+00,-.29393587E-01,0.41201594E-03,                &
     &     0.98813700E+00,-.29377078E-01,0.41098551E-03,                &
     &     0.98814300E+00,-.29363177E-01,0.41044204E-03,                &
     &     0.98815000E+00,-.29346938E-01,0.40969978E-03,                &
     &     0.98815700E+00,-.29330933E-01,0.40932537E-03,                &
     &     0.98816600E+00,-.29312769E-01,0.40846381E-03,                &
     &     0.98817200E+00,-.29293908E-01,0.40777243E-03,                &
     &     0.98818000E+00,-.29272371E-01,0.40676801E-03,                &
     &     0.98819000E+00,-.29251629E-01,0.40602360E-03,                &
     &     0.98819900E+00,-.29228230E-01,0.40497727E-03,                &
     &     0.98820700E+00,-.29203913E-01,0.40415329E-03,                &
     &     0.98821900E+00,-.29179447E-01,0.40335511E-03,                &
     &     0.98823200E+00,-.29151742E-01,0.40218934E-03,                &
     &     0.98824300E+00,-.29122463E-01,0.40102918E-03/                
      data ((pk0(l,k, 2),l=1,3),k= 46, 60)/                             &
     &     0.98825500E+00,-.29091818E-01,0.39993138E-03,                &
     &     0.98826900E+00,-.29058597E-01,0.39857081E-03,                &
     &     0.98828300E+00,-.29022917E-01,0.39710944E-03,                &
     &     0.98829900E+00,-.28986253E-01,0.39581522E-03,                &
     &     0.98831500E+00,-.28946108E-01,0.39404654E-03,                &
     &     0.98833300E+00,-.28904441E-01,0.39250854E-03,                &
     &     0.98835100E+00,-.28860047E-01,0.39083459E-03,                &
     &     0.98837100E+00,-.28812606E-01,0.38895691E-03,                &
     &     0.98839000E+00,-.28761328E-01,0.38682235E-03,                &
     &     0.98841400E+00,-.28709131E-01,0.38495965E-03,                &
     &     0.98843700E+00,-.28652534E-01,0.38286068E-03,                &
     &     0.98846100E+00,-.28591659E-01,0.38036712E-03,                &
     &     0.98848700E+00,-.28530106E-01,0.37842096E-03,                &
     &     0.98851000E+00,-.28455867E-01,0.37445697E-03,                &
     &     0.98854600E+00,-.28387063E-01,0.37230645E-03/                
      data ((pk0(l,k, 2),l=1,3),k= 61, 75)/                             &
     &     0.98857700E+00,-.28315116E-01,0.37042360E-03,                &
     &     0.98860500E+00,-.28229924E-01,0.36649952E-03,                &
     &     0.98864700E+00,-.28147210E-01,0.36369733E-03,                &
     &     0.98868000E+00,-.28055986E-01,0.36033572E-03,                &
     &     0.98872700E+00,-.27959354E-01,0.35638864E-03,                &
     &     0.98876000E+00,-.27854857E-01,0.35223250E-03,                &
     &     0.98880800E+00,-.27750707E-01,0.34894082E-03,                &
     &     0.98885000E+00,-.27631049E-01,0.34378450E-03,                &
     &     0.98890200E+00,-.27510766E-01,0.33920808E-03,                &
     &     0.98895500E+00,-.27382868E-01,0.33478069E-03,                &
     &     0.98901200E+00,-.27249588E-01,0.33016442E-03,                &
     &     0.98906700E+00,-.27103681E-01,0.32473835E-03,                &
     &     0.98913500E+00,-.26954085E-01,0.31971153E-03,                &
     &     0.98919800E+00,-.26790600E-01,0.31330552E-03,                &
     &     0.98927000E+00,-.26623148E-01,0.30776191E-03/                
      data ((pk0(l,k, 2),l=1,3),k= 76, 90)/                             &
     &     0.98934200E+00,-.26441154E-01,0.30089075E-03,                &
     &     0.98941900E+00,-.26253614E-01,0.29486609E-03,                &
     &     0.98950100E+00,-.26051183E-01,0.28739844E-03,                &
     &     0.98958700E+00,-.25840329E-01,0.28051278E-03,                &
     &     0.98967900E+00,-.25615225E-01,0.27251777E-03,                &
     &     0.98977800E+00,-.25380845E-01,0.26488027E-03,                &
     &     0.98987800E+00,-.25130104E-01,0.25613287E-03,                &
     &     0.98998500E+00,-.24867669E-01,0.24767884E-03,                &
     &     0.99009900E+00,-.24590881E-01,0.23892411E-03,                &
     &     0.99021700E+00,-.24296717E-01,0.22908159E-03,                &
     &     0.99034600E+00,-.23989222E-01,0.21958444E-03,                &
     &     0.99047500E+00,-.23662171E-01,0.20912645E-03,                &
     &     0.99061600E+00,-.23319130E-01,0.19868654E-03,                &
     &     0.99076600E+00,-.22959887E-01,0.18832960E-03,                &
     &     0.99092000E+00,-.22577449E-01,0.17688179E-03/                
      data ((pk0(l,k, 2),l=1,3),k= 91,105)/                             &
     &     0.99108500E+00,-.22175675E-01,0.16530403E-03,                &
     &     0.99125700E+00,-.21753393E-01,0.15367794E-03,                &
     &     0.99143900E+00,-.21306679E-01,0.14142751E-03,                &
     &     0.99163000E+00,-.20836087E-01,0.12886254E-03,                &
     &     0.99183300E+00,-.20338732E-01,0.11577485E-03,                &
     &     0.99204600E+00,-.19815237E-01,0.10263771E-03,                &
     &     0.99227100E+00,-.19264134E-01,0.89528699E-04,                &
     &     0.99250800E+00,-.18681008E-01,0.75880463E-04,                &
     &     0.99275900E+00,-.18067005E-01,0.62547218E-04,                &
     &     0.99302400E+00,-.17415435E-01,0.48312314E-04,                &
     &     0.99330400E+00,-.16728941E-01,0.34611857E-04,                &
     &     0.99360000E+00,-.16001145E-01,0.20586329E-04,                &
     &     0.99391400E+00,-.15231651E-01,0.68684177E-05,                &
     &     0.99424800E+00,-.14416633E-01,-.65055015E-05,                &
     &     0.99460100E+00,-.13550693E-01,-.19753475E-04/                
      data ((pk0(l,k, 2),l=1,3),k=106,120)/                             &
     &     0.99497600E+00,-.12634288E-01,-.31975398E-04,                &
     &     0.99537300E+00,-.11654449E-01,-.44279286E-04,                &
     &     0.99579800E+00,-.10613818E-01,-.55376119E-04,                &
     &     0.99626900E+00,-.95115958E-02,-.64486309E-04,                &
     &     0.99674600E+00,-.83228618E-02,-.74190358E-04,                &
     &     0.99727000E+00,-.70592795E-02,-.80132292E-04,                &
     &     0.99784100E+00,-.57163068E-02,-.81697957E-04,                &
     &     0.99844900E+00,-.42650027E-02,-.82897883E-04,                &
     &     0.99909900E+00,-.27108850E-02,-.79382365E-04,                &
     &     0.99980100E+00,-.10407039E-02,-.70860060E-04,                &
     &     0.10005700E+01,0.73496284E-03,-.52853587E-04,                &
     &     0.10013600E+01,0.25779583E-02,-.31954040E-04,                &
     &     0.10021800E+01,0.44193494E-02,-.98916638E-06,                &
     &     0.10030100E+01,0.62550459E-02,0.35649425E-04,                &
     &     0.10038400E+01,0.80714467E-02,0.75584238E-04/                
      data ((pk0(l,k, 2),l=1,3),k=121,135)/                             &
     &     0.10046800E+01,0.98198157E-02,0.12206626E-03,                &
     &     0.10055100E+01,0.11477953E-01,0.17124818E-03,                &
     &     0.10063300E+01,0.13004872E-01,0.22091642E-03,                &
     &     0.10071200E+01,0.14380777E-01,0.26511540E-03,                &
     &     0.10078800E+01,0.15544251E-01,0.30407445E-03,                &
     &     0.10086000E+01,0.16466054E-01,0.33188516E-03,                &
     &     0.10092600E+01,0.17122955E-01,0.34066574E-03,                &
     &     0.10098600E+01,0.17483841E-01,0.32582259E-03,                &
     &     0.10112200E+01,0.18307583E-01,0.26138702E-03,                &
     &     0.10122800E+01,0.18624601E-01,0.15801885E-03,                &
     &     0.10130900E+01,0.18519253E-01,0.27009905E-04,                &
     &     0.10136700E+01,0.18108292E-01,-.12282984E-03,                &
     &     0.10140300E+01,0.17500442E-01,-.27883844E-03,                &
     &     0.10141900E+01,0.16749844E-01,-.41810465E-03,                &
     &     0.10141300E+01,0.15911342E-01,-.52439906E-03/                
      data ((pk0(l,k, 2),l=1,3),k=136,150)/                             &
     &     0.10138000E+01,0.15005243E-01,-.58672528E-03,                &
     &     0.10131700E+01,0.13973270E-01,-.59159547E-03,                &
     &     0.10121800E+01,0.12740951E-01,-.53813782E-03,                &
     &     0.10107500E+01,0.11236568E-01,-.43905669E-03,                &
     &     0.10088600E+01,0.93480554E-02,-.30501479E-03,                &
     &     0.10064500E+01,0.70477706E-02,-.16062856E-03,                &
     &     0.10035200E+01,0.42808098E-02,-.17931712E-04,                &
     &     0.10000500E+01,0.10431767E-02,0.11168529E-03,                &
     &     0.99611100E+00,-.27563642E-02,0.24240882E-03,                &
     &     0.99174800E+00,-.71610203E-02,0.38448017E-03,                &
     &     0.98677500E+00,-.11856521E-01,0.47077353E-03,                &
     &     0.98127900E+00,-.16584692E-01,0.45765935E-03,                &
     &     0.97539600E+00,-.21783703E-01,0.53320789E-03,                &
     &     0.96939000E+00,-.27133682E-01,0.61199590E-03,                &
     &     0.96369600E+00,-.32216511E-01,0.67564928E-03/                
      data ((pk0(l,k, 2),l=1,3),k=151,165)/                             &
     &     0.96241400E+00,-.33361165E-01,0.68800456E-03,                &
     &     0.96122800E+00,-.34423928E-01,0.69970926E-03,                &
     &     0.96014400E+00,-.35392551E-01,0.70953920E-03,                &
     &     0.95916900E+00,-.36264643E-01,0.71839860E-03,                &
     &     0.95831300E+00,-.37031377E-01,0.72575471E-03,                &
     &     0.95757600E+00,-.37681048E-01,0.73072509E-03,                &
     &     0.95698600E+00,-.38223649E-01,0.73649836E-03,                &
     &     0.95651800E+00,-.38632128E-01,0.73926571E-03,                &
     &     0.95620200E+00,-.38912153E-01,0.74136405E-03,                &
     &     0.95604500E+00,-.39057706E-01,0.74271120E-03,                &
     &     0.95622200E+00,-.38902954E-01,0.73961296E-03,                &
     &     0.95778400E+00,-.37512940E-01,0.71313056E-03,                &
     &     0.96091200E+00,-.34734810E-01,0.66040680E-03,                &
     &     0.96560200E+00,-.30566472E-01,0.58115604E-03,                &
     &     0.97185600E+00,-.25007680E-01,0.47515663E-03/                
      data ((pk0(l,k, 2),l=1,3),k=166,180)/                             &
     &     0.97967500E+00,-.18061875E-01,0.34342023E-03,                &
     &     0.98905800E+00,-.97255699E-02,0.18481515E-03,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14,                &
     &     0.10125100E+01,0.11112990E-01,-.21100754E-03,                &
     &     0.10265800E+01,0.23621096E-01,-.44945784E-03,                &
     &     0.10422100E+01,0.37517055E-01,-.71369353E-03,                &
     &     0.10594100E+01,0.52801676E-01,-.10049392E-02,                &
     &     0.10781800E+01,0.69469519E-01,-.13207875E-02,                &
     &     0.10985000E+01,0.87532718E-01,-.16641203E-02,                &
     &     0.11203900E+01,0.10697980E+00,-.20330527E-02,                &
     &     0.11438400E+01,0.12783116E+00,-.24319791E-02,                &
     &     0.11688600E+01,0.15005237E+00,-.28525840E-02,                &
     &     0.11954400E+01,0.17367747E+00,-.33030503E-02,                &
     &     0.12235900E+01,0.19867522E+00,-.37759426E-02,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14/                
      data ((pk0(l,k, 3),l=1,3),k=  1, 15)/                             &
     &     0.94051600E+00,-.10489579E+00,0.48715284E-02,                &
     &     0.94051700E+00,-.10489404E+00,0.48710030E-02,                &
     &     0.94051900E+00,-.10489153E+00,0.48704553E-02,                &
     &     0.94051900E+00,-.10488780E+00,0.48696017E-02,                &
     &     0.94052300E+00,-.10488456E+00,0.48688296E-02,                &
     &     0.94052600E+00,-.10487964E+00,0.48676979E-02,                &
     &     0.94052900E+00,-.10487553E+00,0.48667815E-02,                &
     &     0.94053300E+00,-.10487066E+00,0.48656727E-02,                &
     &     0.94053600E+00,-.10486555E+00,0.48645820E-02,                &
     &     0.94054100E+00,-.10486048E+00,0.48635400E-02,                &
     &     0.94054400E+00,-.10485316E+00,0.48619598E-02,                &
     &     0.94054900E+00,-.10484693E+00,0.48607066E-02,                &
     &     0.94055300E+00,-.10483849E+00,0.48589269E-02,                &
     &     0.94055800E+00,-.10483053E+00,0.48573568E-02,                &
     &     0.94056500E+00,-.10482288E+00,0.48557996E-02/                
      data ((pk0(l,k, 3),l=1,3),k= 16, 30)/                             &
     &     0.94057100E+00,-.10481312E+00,0.48539251E-02,                &
     &     0.94057800E+00,-.10480329E+00,0.48520071E-02,                &
     &     0.94058500E+00,-.10479213E+00,0.48498371E-02,                &
     &     0.94059300E+00,-.10478051E+00,0.48476639E-02,                &
     &     0.94060300E+00,-.10476852E+00,0.48453988E-02,                &
     &     0.94061100E+00,-.10475352E+00,0.48426394E-02,                &
     &     0.94062000E+00,-.10473818E+00,0.48398114E-02,                &
     &     0.94063200E+00,-.10472289E+00,0.48369962E-02,                &
     &     0.94064300E+00,-.10470517E+00,0.48337586E-02,                &
     &     0.94065600E+00,-.10468669E+00,0.48305374E-02,                &
     &     0.94066900E+00,-.10466632E+00,0.48268946E-02,                &
     &     0.94068400E+00,-.10464439E+00,0.48229787E-02,                &
     &     0.94070000E+00,-.10462153E+00,0.48190192E-02,                &
     &     0.94071600E+00,-.10459559E+00,0.48145052E-02,                &
     &     0.94073400E+00,-.10456954E+00,0.48101036E-02/                
      data ((pk0(l,k, 3),l=1,3),k= 31, 45)/                             &
     &     0.94075400E+00,-.10454042E+00,0.48051454E-02,                &
     &     0.94077400E+00,-.10450802E+00,0.47996399E-02,                &
     &     0.94079600E+00,-.10447371E+00,0.47938437E-02,                &
     &     0.94082100E+00,-.10443845E+00,0.47879584E-02,                &
     &     0.94084600E+00,-.10439889E+00,0.47814248E-02,                &
     &     0.94087300E+00,-.10435708E+00,0.47746171E-02,                &
     &     0.94090300E+00,-.10431131E+00,0.47669746E-02,                &
     &     0.94093500E+00,-.10426349E+00,0.47593740E-02,                &
     &     0.94097000E+00,-.10421115E+00,0.47507777E-02,                &
     &     0.94100800E+00,-.10415626E+00,0.47420034E-02,                &
     &     0.94104400E+00,-.10409522E+00,0.47322911E-02,                &
     &     0.94108700E+00,-.10403239E+00,0.47224022E-02,                &
     &     0.94113300E+00,-.10396366E+00,0.47116258E-02,                &
     &     0.94118100E+00,-.10388976E+00,0.47000362E-02,                &
     &     0.94123300E+00,-.10381108E+00,0.46878408E-02/                
      data ((pk0(l,k, 3),l=1,3),k= 46, 60)/                             &
     &     0.94128700E+00,-.10372604E+00,0.46746893E-02,                &
     &     0.94134700E+00,-.10363695E+00,0.46610886E-02,                &
     &     0.94141100E+00,-.10354017E+00,0.46463506E-02,                &
     &     0.94147900E+00,-.10343543E+00,0.46302788E-02,                &
     &     0.94155000E+00,-.10332211E+00,0.46130279E-02,                &
     &     0.94162700E+00,-.10320533E+00,0.45957277E-02,                &
     &     0.94171000E+00,-.10307847E+00,0.45767402E-02,                &
     &     0.94179900E+00,-.10294307E+00,0.45566523E-02,                &
     &     0.94189300E+00,-.10279733E+00,0.45350974E-02,                &
     &     0.94199300E+00,-.10264231E+00,0.45124000E-02,                &
     &     0.94210100E+00,-.10247579E+00,0.44879939E-02,                &
     &     0.94221400E+00,-.10229881E+00,0.44622560E-02,                &
     &     0.94233800E+00,-.10211028E+00,0.44350670E-02,                &
     &     0.94246700E+00,-.10190857E+00,0.44060822E-02,                &
     &     0.94260500E+00,-.10169310E+00,0.43754108E-02/                
      data ((pk0(l,k, 3),l=1,3),k= 61, 75)/                             &
     &     0.94275300E+00,-.10146313E+00,0.43427253E-02,                &
     &     0.94290900E+00,-.10121892E+00,0.43083875E-02,                &
     &     0.94307500E+00,-.10095816E+00,0.42718661E-02,                &
     &     0.94325500E+00,-.10068124E+00,0.42332193E-02,                &
     &     0.94344100E+00,-.10038444E+00,0.41922240E-02,                &
     &     0.94364300E+00,-.10007120E+00,0.41492262E-02,                &
     &     0.94385600E+00,-.99736735E-01,0.41035380E-02,                &
     &     0.94408200E+00,-.99378942E-01,0.40548772E-02,                &
     &     0.94432300E+00,-.99002645E-01,0.40042297E-02,                &
     &     0.94457500E+00,-.98598802E-01,0.39501093E-02,                &
     &     0.94484400E+00,-.98170855E-01,0.38930944E-02,                &
     &     0.94513000E+00,-.97719666E-01,0.38336228E-02,                &
     &     0.94543000E+00,-.97237328E-01,0.37703421E-02,                &
     &     0.94575100E+00,-.96730771E-01,0.37049429E-02,                &
     &     0.94608600E+00,-.96189509E-01,0.36350707E-02/                
      data ((pk0(l,k, 3),l=1,3),k= 76, 90)/                             &
     &     0.94644200E+00,-.95618951E-01,0.35621343E-02,                &
     &     0.94681500E+00,-.95014272E-01,0.34855445E-02,                &
     &     0.94721200E+00,-.94375945E-01,0.34054298E-02,                &
     &     0.94762600E+00,-.93700439E-01,0.33216907E-02,                &
     &     0.94806500E+00,-.92991241E-01,0.32346442E-02,                &
     &     0.94852300E+00,-.92237194E-01,0.31425553E-02,                &
     &     0.94900600E+00,-.91447332E-01,0.30476655E-02,                &
     &     0.94951500E+00,-.90613643E-01,0.29484184E-02,                &
     &     0.95004500E+00,-.89737513E-01,0.28454922E-02,                &
     &     0.95060100E+00,-.88816909E-01,0.27388927E-02,                &
     &     0.95118300E+00,-.87847995E-01,0.26274728E-02,                &
     &     0.95179600E+00,-.86836954E-01,0.25136794E-02,                &
     &     0.95242500E+00,-.85769916E-01,0.23944759E-02,                &
     &     0.95309200E+00,-.84660480E-01,0.22732017E-02,                &
     &     0.95378300E+00,-.83496408E-01,0.21474545E-02/                
      data ((pk0(l,k, 3),l=1,3),k= 91,105)/                             &
     &     0.95450100E+00,-.82282802E-01,0.20190161E-02,                &
     &     0.95524600E+00,-.81015982E-01,0.18872765E-02,                &
     &     0.95601600E+00,-.79692699E-01,0.17519318E-02,                &
     &     0.95682000E+00,-.78317905E-01,0.16141570E-02,                &
     &     0.95765100E+00,-.76887515E-01,0.14741437E-02,                &
     &     0.95851000E+00,-.75406868E-01,0.13329105E-02,                &
     &     0.95939800E+00,-.73865930E-01,0.11887084E-02,                &
     &     0.96031600E+00,-.72277198E-01,0.10448877E-02,                &
     &     0.96125600E+00,-.70629274E-01,0.89938631E-03,                &
     &     0.96222700E+00,-.68923924E-01,0.75250841E-03,                &
     &     0.96322800E+00,-.67171996E-01,0.60735176E-03,                &
     &     0.96425300E+00,-.65364956E-01,0.46250599E-03,                &
     &     0.96529900E+00,-.63505098E-01,0.31908929E-03,                &
     &     0.96638200E+00,-.61601483E-01,0.17865032E-03,                &
     &     0.96748400E+00,-.59644723E-01,0.39548326E-04/                
      data ((pk0(l,k, 3),l=1,3),k=106,120)/                             &
     &     0.96861000E+00,-.57639565E-01,-.96555044E-04,                &
     &     0.96976400E+00,-.55598945E-01,-.22688480E-03,                &
     &     0.97094000E+00,-.53515509E-01,-.35296675E-03,                &
     &     0.97213800E+00,-.51398581E-01,-.47323236E-03,                &
     &     0.97335800E+00,-.49248920E-01,-.58784941E-03,                &
     &     0.97460000E+00,-.47079449E-01,-.69450336E-03,                &
     &     0.97585400E+00,-.44894291E-01,-.79329273E-03,                &
     &     0.97712200E+00,-.42701967E-01,-.88385405E-03,                &
     &     0.97841000E+00,-.40526023E-01,-.96429278E-03,                &
     &     0.97969300E+00,-.38366552E-01,-.10375401E-02,                &
     &     0.98098500E+00,-.36257763E-01,-.11003177E-02,                &
     &     0.98229400E+00,-.34179783E-01,-.11534616E-02,                &
     &     0.98360300E+00,-.32120367E-01,-.11988169E-02,                &
     &     0.98494000E+00,-.30101841E-01,-.12334068E-02,                &
     &     0.98629400E+00,-.28122503E-01,-.12598669E-02/                
      data ((pk0(l,k, 3),l=1,3),k=121,135)/                             &
     &     0.98766100E+00,-.26194901E-01,-.12775121E-02,                &
     &     0.98904300E+00,-.24317995E-01,-.12895868E-02,                &
     &     0.99043800E+00,-.22507118E-01,-.12951502E-02,                &
     &     0.99185100E+00,-.20757308E-01,-.12987447E-02,                &
     &     0.99327300E+00,-.19085296E-01,-.12984059E-02,                &
     &     0.99471800E+00,-.17483854E-01,-.12984710E-02,                &
     &     0.99615200E+00,-.15949496E-01,-.13014977E-02,                &
     &     0.99751600E+00,-.14574443E-01,-.13204913E-02,                &
     &     0.99752000E+00,-.14578003E-01,-.13199632E-02,                &
     &     0.99751800E+00,-.14575385E-01,-.13203117E-02,                &
     &     0.99751800E+00,-.14574061E-01,-.13206655E-02,                &
     &     0.99751800E+00,-.14574988E-01,-.13204144E-02,                &
     &     0.99751900E+00,-.14575169E-01,-.13204198E-02,                &
     &     0.99751900E+00,-.14575643E-01,-.13203115E-02,                &
     &     0.99751800E+00,-.14574669E-01,-.13205369E-02/                
      data ((pk0(l,k, 3),l=1,3),k=136,150)/                             &
     &     0.99751800E+00,-.14574284E-01,-.13205754E-02,                &
     &     0.99752000E+00,-.14576291E-01,-.13201361E-02,                &
     &     0.99751900E+00,-.14575495E-01,-.13203060E-02,                &
     &     0.99751900E+00,-.14575069E-01,-.13203659E-02,                &
     &     0.99752100E+00,-.14575803E-01,-.13202931E-02,                &
     &     0.99751800E+00,-.14576127E-01,-.13201530E-02,                &
     &     0.99752100E+00,-.14576630E-01,-.13201782E-02,                &
     &     0.99751500E+00,-.14574665E-01,-.13204692E-02,                &
     &     0.99611100E+00,-.13299123E-01,-.15676561E-02,                &
     &     0.99174700E+00,-.93435647E-02,-.23338257E-02,                &
     &     0.98677800E+00,-.77463430E-02,-.23593058E-02,                &
     &     0.98127900E+00,-.15677166E-01,0.62981698E-04,                &
     &     0.97539500E+00,-.21784370E-01,0.53342489E-03,                &
     &     0.96938700E+00,-.27131873E-01,0.61159911E-03,                &
     &     0.96369600E+00,-.32215883E-01,0.67548543E-03/                
      data ((pk0(l,k, 3),l=1,3),k=151,165)/                             &
     &     0.96241400E+00,-.33362549E-01,0.68832117E-03,                &
     &     0.96122600E+00,-.34423292E-01,0.69962733E-03,                &
     &     0.96014300E+00,-.35392434E-01,0.70945212E-03,                &
     &     0.95917000E+00,-.36263826E-01,0.71824208E-03,                &
     &     0.95831200E+00,-.37028908E-01,0.72532537E-03,                &
     &     0.95758000E+00,-.37683966E-01,0.73126832E-03,                &
     &     0.95698200E+00,-.38221559E-01,0.73606070E-03,                &
     &     0.95652200E+00,-.38632504E-01,0.73928543E-03,                &
     &     0.95620600E+00,-.38910023E-01,0.74069082E-03,                &
     &     0.95604600E+00,-.39058042E-01,0.74274698E-03,                &
     &     0.95622100E+00,-.38903045E-01,0.73964725E-03,                &
     &     0.95778300E+00,-.37513059E-01,0.71322236E-03,                &
     &     0.96091300E+00,-.34735600E-01,0.66051381E-03,                &
     &     0.96560000E+00,-.30564832E-01,0.58082345E-03,                &
     &     0.97185800E+00,-.25009451E-01,0.47546715E-03/                
      data ((pk0(l,k, 3),l=1,3),k=166,180)/                             &
     &     0.97967200E+00,-.18059928E-01,0.34280564E-03,                &
     &     0.98905500E+00,-.97255290E-02,0.18483470E-03,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14,                &
     &     0.10125100E+01,0.11112990E-01,-.21100754E-03,                &
     &     0.10265800E+01,0.23616219E-01,-.44808781E-03,                &
     &     0.10422200E+01,0.37507991E-01,-.71193763E-03,                &
     &     0.10594100E+01,0.52799245E-01,-.10043241E-02,                &
     &     0.10781800E+01,0.69467404E-01,-.13205290E-02,                &
     &     0.10985000E+01,0.87535210E-01,-.16652030E-02,                &
     &     0.11203900E+01,0.10698480E+00,-.20348630E-02,                &
     &     0.11438500E+01,0.12782210E+00,-.24302232E-02,                &
     &     0.11688600E+01,0.15005703E+00,-.28537539E-02,                &
     &     0.11954500E+01,0.17366628E+00,-.33006994E-02,                &
     &     0.12235900E+01,0.19868247E+00,-.37777527E-02,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14/                
      data ((pk0(l,k, 4),l=1,3),k=  1, 15)/                             &
     &     0.94051600E+00,-.10489579E+00,0.48715284E-02,                &
     &     0.94051700E+00,-.10489404E+00,0.48710030E-02,                &
     &     0.94051900E+00,-.10489153E+00,0.48704553E-02,                &
     &     0.94051900E+00,-.10488780E+00,0.48696017E-02,                &
     &     0.94052300E+00,-.10488456E+00,0.48688296E-02,                &
     &     0.94052600E+00,-.10487964E+00,0.48676979E-02,                &
     &     0.94052900E+00,-.10487553E+00,0.48667815E-02,                &
     &     0.94053300E+00,-.10487066E+00,0.48656727E-02,                &
     &     0.94053600E+00,-.10486555E+00,0.48645820E-02,                &
     &     0.94054100E+00,-.10486048E+00,0.48635400E-02,                &
     &     0.94054400E+00,-.10485316E+00,0.48619598E-02,                &
     &     0.94054900E+00,-.10484693E+00,0.48607066E-02,                &
     &     0.94055300E+00,-.10483849E+00,0.48589269E-02,                &
     &     0.94055800E+00,-.10483053E+00,0.48573568E-02,                &
     &     0.94056500E+00,-.10482288E+00,0.48557996E-02/                
      data ((pk0(l,k, 4),l=1,3),k= 16, 30)/                             &
     &     0.94057100E+00,-.10481312E+00,0.48539251E-02,                &
     &     0.94057800E+00,-.10480329E+00,0.48520071E-02,                &
     &     0.94058500E+00,-.10479213E+00,0.48498371E-02,                &
     &     0.94059300E+00,-.10478051E+00,0.48476639E-02,                &
     &     0.94060300E+00,-.10476852E+00,0.48453988E-02,                &
     &     0.94061100E+00,-.10475352E+00,0.48426394E-02,                &
     &     0.94062000E+00,-.10473818E+00,0.48398114E-02,                &
     &     0.94063200E+00,-.10472289E+00,0.48369962E-02,                &
     &     0.94064300E+00,-.10470517E+00,0.48337586E-02,                &
     &     0.94065600E+00,-.10468669E+00,0.48305374E-02,                &
     &     0.94066900E+00,-.10466632E+00,0.48268946E-02,                &
     &     0.94068400E+00,-.10464439E+00,0.48229787E-02,                &
     &     0.94070000E+00,-.10462153E+00,0.48190192E-02,                &
     &     0.94071600E+00,-.10459559E+00,0.48145052E-02,                &
     &     0.94073400E+00,-.10456954E+00,0.48101036E-02/                
      data ((pk0(l,k, 4),l=1,3),k= 31, 45)/                             &
     &     0.94075400E+00,-.10454042E+00,0.48051454E-02,                &
     &     0.94077400E+00,-.10450802E+00,0.47996399E-02,                &
     &     0.94079600E+00,-.10447371E+00,0.47938437E-02,                &
     &     0.94082100E+00,-.10443845E+00,0.47879584E-02,                &
     &     0.94084600E+00,-.10439889E+00,0.47814248E-02,                &
     &     0.94087300E+00,-.10435708E+00,0.47746171E-02,                &
     &     0.94090300E+00,-.10431131E+00,0.47669746E-02,                &
     &     0.94093500E+00,-.10426349E+00,0.47593740E-02,                &
     &     0.94097000E+00,-.10421115E+00,0.47507777E-02,                &
     &     0.94100800E+00,-.10415626E+00,0.47420034E-02,                &
     &     0.94104400E+00,-.10409522E+00,0.47322911E-02,                &
     &     0.94108700E+00,-.10403239E+00,0.47224022E-02,                &
     &     0.94113300E+00,-.10396366E+00,0.47116258E-02,                &
     &     0.94118100E+00,-.10388976E+00,0.47000362E-02,                &
     &     0.94123300E+00,-.10381108E+00,0.46878408E-02/                
      data ((pk0(l,k, 4),l=1,3),k= 46, 60)/                             &
     &     0.94128700E+00,-.10372604E+00,0.46746893E-02,                &
     &     0.94134700E+00,-.10363695E+00,0.46610886E-02,                &
     &     0.94141100E+00,-.10354017E+00,0.46463506E-02,                &
     &     0.94147900E+00,-.10343543E+00,0.46302788E-02,                &
     &     0.94155000E+00,-.10332211E+00,0.46130279E-02,                &
     &     0.94162700E+00,-.10320533E+00,0.45957277E-02,                &
     &     0.94171000E+00,-.10307847E+00,0.45767402E-02,                &
     &     0.94179900E+00,-.10294307E+00,0.45566523E-02,                &
     &     0.94189300E+00,-.10279733E+00,0.45350974E-02,                &
     &     0.94199300E+00,-.10264231E+00,0.45124000E-02,                &
     &     0.94210100E+00,-.10247579E+00,0.44879939E-02,                &
     &     0.94221400E+00,-.10229881E+00,0.44622560E-02,                &
     &     0.94233800E+00,-.10211028E+00,0.44350670E-02,                &
     &     0.94246700E+00,-.10190857E+00,0.44060822E-02,                &
     &     0.94260500E+00,-.10169310E+00,0.43754108E-02/                
      data ((pk0(l,k, 4),l=1,3),k= 61, 75)/                             &
     &     0.94275300E+00,-.10146313E+00,0.43427253E-02,                &
     &     0.94290900E+00,-.10121892E+00,0.43083875E-02,                &
     &     0.94307500E+00,-.10095816E+00,0.42718661E-02,                &
     &     0.94325500E+00,-.10068124E+00,0.42332193E-02,                &
     &     0.94344100E+00,-.10038444E+00,0.41922240E-02,                &
     &     0.94364300E+00,-.10007120E+00,0.41492262E-02,                &
     &     0.94385600E+00,-.99736735E-01,0.41035380E-02,                &
     &     0.94408200E+00,-.99378942E-01,0.40548772E-02,                &
     &     0.94432300E+00,-.99002645E-01,0.40042297E-02,                &
     &     0.94457500E+00,-.98598802E-01,0.39501093E-02,                &
     &     0.94484400E+00,-.98170855E-01,0.38930944E-02,                &
     &     0.94513000E+00,-.97719666E-01,0.38336228E-02,                &
     &     0.94543000E+00,-.97237328E-01,0.37703421E-02,                &
     &     0.94575100E+00,-.96730771E-01,0.37049429E-02,                &
     &     0.94608600E+00,-.96189509E-01,0.36350707E-02/                
      data ((pk0(l,k, 4),l=1,3),k= 76, 90)/                             &
     &     0.94644200E+00,-.95618951E-01,0.35621343E-02,                &
     &     0.94681500E+00,-.95014272E-01,0.34855445E-02,                &
     &     0.94721200E+00,-.94375945E-01,0.34054298E-02,                &
     &     0.94762600E+00,-.93700439E-01,0.33216907E-02,                &
     &     0.94806500E+00,-.92991241E-01,0.32346442E-02,                &
     &     0.94852300E+00,-.92237194E-01,0.31425553E-02,                &
     &     0.94900600E+00,-.91447332E-01,0.30476655E-02,                &
     &     0.94951500E+00,-.90613643E-01,0.29484184E-02,                &
     &     0.95004500E+00,-.89737513E-01,0.28454922E-02,                &
     &     0.95060100E+00,-.88816909E-01,0.27388927E-02,                &
     &     0.95118300E+00,-.87847995E-01,0.26274728E-02,                &
     &     0.95179600E+00,-.86836954E-01,0.25136794E-02,                &
     &     0.95242500E+00,-.85769916E-01,0.23944759E-02,                &
     &     0.95309200E+00,-.84660480E-01,0.22732017E-02,                &
     &     0.95378300E+00,-.83496408E-01,0.21474545E-02/                
      data ((pk0(l,k, 4),l=1,3),k= 91,105)/                             &
     &     0.95450100E+00,-.82282802E-01,0.20190161E-02,                &
     &     0.95524600E+00,-.81015982E-01,0.18872765E-02,                &
     &     0.95601600E+00,-.79692699E-01,0.17519318E-02,                &
     &     0.95682000E+00,-.78317905E-01,0.16141570E-02,                &
     &     0.95765100E+00,-.76887515E-01,0.14741437E-02,                &
     &     0.95851000E+00,-.75406868E-01,0.13329105E-02,                &
     &     0.95939800E+00,-.73865930E-01,0.11887084E-02,                &
     &     0.96031600E+00,-.72277198E-01,0.10448877E-02,                &
     &     0.96125600E+00,-.70629274E-01,0.89938631E-03,                &
     &     0.96222700E+00,-.68923924E-01,0.75250841E-03,                &
     &     0.96322800E+00,-.67171996E-01,0.60735176E-03,                &
     &     0.96425300E+00,-.65364956E-01,0.46250599E-03,                &
     &     0.96529900E+00,-.63505098E-01,0.31908929E-03,                &
     &     0.96638200E+00,-.61601483E-01,0.17865032E-03,                &
     &     0.96748400E+00,-.59644723E-01,0.39548326E-04/                
      data ((pk0(l,k, 4),l=1,3),k=106,120)/                             &
     &     0.96861000E+00,-.57639565E-01,-.96555044E-04,                &
     &     0.96976400E+00,-.55598945E-01,-.22688480E-03,                &
     &     0.97094000E+00,-.53515509E-01,-.35296675E-03,                &
     &     0.97213800E+00,-.51398581E-01,-.47323236E-03,                &
     &     0.97335800E+00,-.49248920E-01,-.58784941E-03,                &
     &     0.97460000E+00,-.47079449E-01,-.69450336E-03,                &
     &     0.97585400E+00,-.44894291E-01,-.79329273E-03,                &
     &     0.97712200E+00,-.42701967E-01,-.88385405E-03,                &
     &     0.97841000E+00,-.40526023E-01,-.96429278E-03,                &
     &     0.97969300E+00,-.38366552E-01,-.10375401E-02,                &
     &     0.98098500E+00,-.36257763E-01,-.11003177E-02,                &
     &     0.98229400E+00,-.34179783E-01,-.11534616E-02,                &
     &     0.98360300E+00,-.32120367E-01,-.11988169E-02,                &
     &     0.98494000E+00,-.30101841E-01,-.12334068E-02,                &
     &     0.98629400E+00,-.28122503E-01,-.12598669E-02/                
      data ((pk0(l,k, 4),l=1,3),k=121,135)/                             &
     &     0.98766100E+00,-.26194901E-01,-.12775121E-02,                &
     &     0.98904300E+00,-.24317995E-01,-.12895868E-02,                &
     &     0.99043800E+00,-.22507118E-01,-.12951502E-02,                &
     &     0.99185100E+00,-.20757308E-01,-.12987447E-02,                &
     &     0.99327300E+00,-.19085296E-01,-.12984059E-02,                &
     &     0.99471800E+00,-.17483854E-01,-.12984710E-02,                &
     &     0.99615200E+00,-.15949496E-01,-.13014977E-02,                &
     &     0.99751600E+00,-.14574443E-01,-.13204913E-02,                &
     &     0.99752000E+00,-.14578003E-01,-.13199632E-02,                &
     &     0.99751800E+00,-.14575385E-01,-.13203117E-02,                &
     &     0.99751800E+00,-.14574061E-01,-.13206655E-02,                &
     &     0.99751800E+00,-.14574988E-01,-.13204144E-02,                &
     &     0.99751900E+00,-.14575169E-01,-.13204198E-02,                &
     &     0.99751900E+00,-.14575643E-01,-.13203115E-02,                &
     &     0.99751800E+00,-.14574669E-01,-.13205369E-02/                
      data ((pk0(l,k, 4),l=1,3),k=136,150)/                             &
     &     0.99751800E+00,-.14574284E-01,-.13205754E-02,                &
     &     0.99752000E+00,-.14576291E-01,-.13201361E-02,                &
     &     0.99751900E+00,-.14575495E-01,-.13203060E-02,                &
     &     0.99751900E+00,-.14575069E-01,-.13203659E-02,                &
     &     0.99752100E+00,-.14575803E-01,-.13202931E-02,                &
     &     0.99751800E+00,-.14576127E-01,-.13201530E-02,                &
     &     0.99752100E+00,-.14576630E-01,-.13201782E-02,                &
     &     0.99751500E+00,-.14574665E-01,-.13204692E-02,                &
     &     0.99611100E+00,-.13299123E-01,-.15676561E-02,                &
     &     0.99174700E+00,-.93435647E-02,-.23338257E-02,                &
     &     0.98677800E+00,-.77463430E-02,-.23593058E-02,                &
     &     0.98127900E+00,-.15677166E-01,0.62981698E-04,                &
     &     0.97539500E+00,-.21784370E-01,0.53342489E-03,                &
     &     0.96938700E+00,-.27131873E-01,0.61159911E-03,                &
     &     0.96369600E+00,-.32215883E-01,0.67548543E-03/                
      data ((pk0(l,k, 4),l=1,3),k=151,165)/                             &
     &     0.96241400E+00,-.33362549E-01,0.68832117E-03,                &
     &     0.96122600E+00,-.34423292E-01,0.69962733E-03,                &
     &     0.96014300E+00,-.35392434E-01,0.70945212E-03,                &
     &     0.95917000E+00,-.36263826E-01,0.71824208E-03,                &
     &     0.95831200E+00,-.37028908E-01,0.72532537E-03,                &
     &     0.95758000E+00,-.37683966E-01,0.73126832E-03,                &
     &     0.95698200E+00,-.38221559E-01,0.73606070E-03,                &
     &     0.95652200E+00,-.38632504E-01,0.73928543E-03,                &
     &     0.95620600E+00,-.38910023E-01,0.74069082E-03,                &
     &     0.95604600E+00,-.39058042E-01,0.74274698E-03,                &
     &     0.95622100E+00,-.38903045E-01,0.73964725E-03,                &
     &     0.95778300E+00,-.37513059E-01,0.71322236E-03,                &
     &     0.96091300E+00,-.34735600E-01,0.66051381E-03,                &
     &     0.96560000E+00,-.30564832E-01,0.58082345E-03,                &
     &     0.97185800E+00,-.25009451E-01,0.47546715E-03/                
      data ((pk0(l,k, 4),l=1,3),k=166,180)/                             &
     &     0.97967200E+00,-.18059928E-01,0.34280564E-03,                &
     &     0.98905500E+00,-.97255290E-02,0.18483470E-03,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14,                &
     &     0.10125100E+01,0.11112990E-01,-.21100754E-03,                &
     &     0.10265800E+01,0.23616219E-01,-.44808781E-03,                &
     &     0.10422200E+01,0.37507991E-01,-.71193763E-03,                &
     &     0.10594100E+01,0.52799245E-01,-.10043241E-02,                &
     &     0.10781800E+01,0.69467404E-01,-.13205290E-02,                &
     &     0.10985000E+01,0.87535210E-01,-.16652030E-02,                &
     &     0.11203900E+01,0.10698480E+00,-.20348630E-02,                &
     &     0.11438500E+01,0.12782210E+00,-.24302232E-02,                &
     &     0.11688600E+01,0.15005703E+00,-.28537539E-02,                &
     &     0.11954500E+01,0.17366628E+00,-.33006994E-02,                &
     &     0.12235900E+01,0.19868247E+00,-.37777527E-02,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14/                
      data ((pk0(l,k, 5),l=1,3),k=  1, 15)/                             &
     &     0.94051800E+00,-.10489927E+00,0.48721665E-02,                &
     &     0.94051700E+00,-.10489526E+00,0.48714084E-02,                &
     &     0.94052000E+00,-.10489276E+00,0.48706977E-02,                &
     &     0.94052100E+00,-.10488659E+00,0.48692605E-02,                &
     &     0.94052500E+00,-.10488518E+00,0.48688837E-02,                &
     &     0.94052600E+00,-.10488170E+00,0.48682060E-02,                &
     &     0.94052900E+00,-.10487543E+00,0.48668201E-02,                &
     &     0.94053500E+00,-.10487153E+00,0.48657996E-02,                &
     &     0.94053500E+00,-.10486561E+00,0.48646134E-02,                &
     &     0.94053600E+00,-.10485692E+00,0.48628164E-02,                &
     &     0.94054700E+00,-.10485306E+00,0.48618460E-02,                &
     &     0.94055300E+00,-.10484740E+00,0.48606687E-02,                &
     &     0.94055400E+00,-.10484014E+00,0.48593123E-02,                &
     &     0.94055900E+00,-.10483165E+00,0.48575938E-02,                &
     &     0.94056500E+00,-.10482224E+00,0.48556709E-02/                
      data ((pk0(l,k, 5),l=1,3),k= 16, 30)/                             &
     &     0.94057100E+00,-.10481336E+00,0.48539866E-02,                &
     &     0.94057800E+00,-.10480381E+00,0.48521380E-02,                &
     &     0.94058500E+00,-.10479209E+00,0.48498370E-02,                &
     &     0.94059300E+00,-.10478057E+00,0.48477216E-02,                &
     &     0.94060200E+00,-.10476826E+00,0.48453986E-02,                &
     &     0.94061100E+00,-.10475369E+00,0.48426192E-02,                &
     &     0.94062100E+00,-.10473876E+00,0.48398824E-02,                &
     &     0.94063200E+00,-.10472362E+00,0.48371592E-02,                &
     &     0.94064200E+00,-.10470454E+00,0.48336412E-02,                &
     &     0.94065500E+00,-.10468596E+00,0.48303564E-02,                &
     &     0.94066900E+00,-.10466609E+00,0.48268063E-02,                &
     &     0.94068400E+00,-.10464483E+00,0.48230728E-02,                &
     &     0.94069900E+00,-.10462042E+00,0.48187997E-02,                &
     &     0.94071600E+00,-.10459605E+00,0.48145867E-02,                &
     &     0.94073400E+00,-.10456829E+00,0.48097527E-02/                
      data ((pk0(l,k, 5),l=1,3),k= 31, 45)/                             &
     &     0.94075300E+00,-.10453947E+00,0.48049469E-02,                &
     &     0.94077400E+00,-.10450777E+00,0.47995672E-02,                &
     &     0.94079700E+00,-.10447440E+00,0.47939405E-02,                &
     &     0.94082100E+00,-.10443896E+00,0.47881241E-02,                &
     &     0.94084600E+00,-.10439823E+00,0.47812577E-02,                &
     &     0.94087400E+00,-.10435734E+00,0.47745992E-02,                &
     &     0.94090300E+00,-.10431171E+00,0.47670973E-02,                &
     &     0.94093500E+00,-.10426349E+00,0.47593560E-02,                &
     &     0.94097000E+00,-.10421141E+00,0.47509147E-02,                &
     &     0.94100800E+00,-.10415763E+00,0.47424216E-02,                &
     &     0.94104500E+00,-.10409502E+00,0.47322118E-02,                &
     &     0.94108700E+00,-.10403304E+00,0.47226460E-02,                &
     &     0.94113200E+00,-.10396220E+00,0.47112837E-02,                &
     &     0.94118300E+00,-.10389106E+00,0.47002677E-02,                &
     &     0.94123200E+00,-.10380917E+00,0.46873355E-02/                
      data ((pk0(l,k, 5),l=1,3),k= 46, 60)/                             &
     &     0.94128600E+00,-.10372566E+00,0.46746509E-02,                &
     &     0.94134600E+00,-.10363545E+00,0.46608132E-02,                &
     &     0.94141100E+00,-.10353955E+00,0.46462155E-02,                &
     &     0.94147800E+00,-.10343542E+00,0.46303638E-02,                &
     &     0.94155100E+00,-.10332462E+00,0.46135086E-02,                &
     &     0.94162700E+00,-.10320559E+00,0.45957125E-02,                &
     &     0.94171100E+00,-.10307817E+00,0.45765917E-02,                &
     &     0.94179900E+00,-.10294294E+00,0.45565872E-02,                &
     &     0.94189200E+00,-.10279643E+00,0.45349311E-02,                &
     &     0.94199400E+00,-.10264394E+00,0.45128139E-02,                &
     &     0.94210200E+00,-.10247802E+00,0.44884585E-02,                &
     &     0.94221600E+00,-.10230034E+00,0.44626258E-02,                &
     &     0.94233500E+00,-.10210978E+00,0.44350482E-02,                &
     &     0.94246500E+00,-.10190818E+00,0.44061459E-02,                &
     &     0.94260500E+00,-.10169206E+00,0.43752241E-02/                
      data ((pk0(l,k, 5),l=1,3),k= 61, 75)/                             &
     &     0.94275000E+00,-.10146216E+00,0.43424527E-02,                &
     &     0.94290800E+00,-.10121846E+00,0.43081910E-02,                &
     &     0.94307600E+00,-.10095842E+00,0.42718863E-02,                &
     &     0.94325400E+00,-.10068134E+00,0.42332605E-02,                &
     &     0.94344200E+00,-.10038417E+00,0.41921131E-02,                &
     &     0.94364200E+00,-.10006989E+00,0.41489387E-02,                &
     &     0.94385500E+00,-.99733574E-01,0.41028285E-02,                &
     &     0.94408200E+00,-.99379297E-01,0.40547561E-02,                &
     &     0.94432000E+00,-.99000000E-01,0.40036563E-02,                &
     &     0.94457500E+00,-.98599499E-01,0.39501051E-02,                &
     &     0.94484300E+00,-.98172777E-01,0.38935760E-02,                &
     &     0.94513100E+00,-.97720122E-01,0.38337351E-02,                &
     &     0.94543200E+00,-.97239302E-01,0.37708312E-02,                &
     &     0.94575000E+00,-.96729365E-01,0.37044929E-02,                &
     &     0.94608400E+00,-.96188368E-01,0.36348208E-02/                
      data ((pk0(l,k, 5),l=1,3),k= 76, 90)/                             &
     &     0.94644000E+00,-.95619707E-01,0.35623625E-02,                &
     &     0.94681400E+00,-.95011393E-01,0.34849301E-02,                &
     &     0.94720900E+00,-.94375253E-01,0.34053878E-02,                &
     &     0.94762200E+00,-.93700380E-01,0.33217959E-02,                &
     &     0.94806300E+00,-.92988322E-01,0.32342508E-02,                &
     &     0.94852800E+00,-.92240573E-01,0.31432276E-02,                &
     &     0.94901000E+00,-.91448018E-01,0.30478539E-02,                &
     &     0.94951100E+00,-.90611102E-01,0.29478617E-02,                &
     &     0.95004800E+00,-.89738838E-01,0.28456873E-02,                &
     &     0.95060300E+00,-.88819151E-01,0.27394469E-02,                &
     &     0.95119000E+00,-.87852205E-01,0.26283834E-02,                &
     &     0.95179000E+00,-.86834794E-01,0.25131843E-02,                &
     &     0.95242800E+00,-.85771806E-01,0.23948526E-02,                &
     &     0.95309300E+00,-.84661131E-01,0.22732222E-02,                &
     &     0.95377700E+00,-.83494651E-01,0.21472670E-02/                
      data ((pk0(l,k, 5),l=1,3),k= 91,105)/                             &
     &     0.95449600E+00,-.82282556E-01,0.20191048E-02,                &
     &     0.95524900E+00,-.81018000E-01,0.18877668E-02,                &
     &     0.95602300E+00,-.79695230E-01,0.17523131E-02,                &
     &     0.95681700E+00,-.78314658E-01,0.16135400E-02,                &
     &     0.95765500E+00,-.76892606E-01,0.14751914E-02,                &
     &     0.95850500E+00,-.75404417E-01,0.13324193E-02,                &
     &     0.95939100E+00,-.73864207E-01,0.11884763E-02,                &
     &     0.96031600E+00,-.72276656E-01,0.10446806E-02,                &
     &     0.96126000E+00,-.70628157E-01,0.89896085E-03,                &
     &     0.96222800E+00,-.68926676E-01,0.75313433E-03,                &
     &     0.96322600E+00,-.67171332E-01,0.60731316E-03,                &
     &     0.96425200E+00,-.65364959E-01,0.46263818E-03,                &
     &     0.96530300E+00,-.63506858E-01,0.31933858E-03,                &
     &     0.96638100E+00,-.61597972E-01,0.17767399E-03,                &
     &     0.96748400E+00,-.59642946E-01,0.39211281E-04/                
      data ((pk0(l,k, 5),l=1,3),k=106,120)/                             &
     &     0.96861300E+00,-.57642431E-01,-.95909921E-04,                &
     &     0.96976400E+00,-.55598255E-01,-.22700177E-03,                &
     &     0.97094000E+00,-.53515378E-01,-.35308858E-03,                &
     &     0.97213700E+00,-.51396959E-01,-.47359298E-03,                &
     &     0.97335700E+00,-.49250448E-01,-.58736734E-03,                &
     &     0.97459600E+00,-.47079175E-01,-.69427829E-03,                &
     &     0.97585100E+00,-.44893476E-01,-.79324535E-03,                &
     &     0.97712300E+00,-.42703523E-01,-.88369229E-03,                &
     &     0.97840600E+00,-.40523717E-01,-.96483373E-03,                &
     &     0.97969400E+00,-.38368184E-01,-.10370794E-02,                &
     &     0.98098500E+00,-.36258308E-01,-.11002307E-02,                &
     &     0.98229100E+00,-.34179213E-01,-.11535924E-02,                &
     &     0.98360800E+00,-.32123194E-01,-.11983136E-02,                &
     &     0.98494300E+00,-.30102757E-01,-.12332308E-02,                &
     &     0.98629300E+00,-.28121962E-01,-.12599465E-02/                
      data ((pk0(l,k, 5),l=1,3),k=121,135)/                             &
     &     0.98765800E+00,-.26192207E-01,-.12779998E-02,                &
     &     0.98904100E+00,-.24317305E-01,-.12895695E-02,                &
     &     0.99043900E+00,-.22506077E-01,-.12953099E-02,                &
     &     0.99185300E+00,-.20761320E-01,-.12977667E-02,                &
     &     0.99327600E+00,-.19085711E-01,-.12983204E-02,                &
     &     0.99471300E+00,-.17483438E-01,-.12983620E-02,                &
     &     0.99614800E+00,-.15947607E-01,-.13017554E-02,                &
     &     0.99751800E+00,-.14575165E-01,-.13203890E-02,                &
     &     0.99751900E+00,-.14573745E-01,-.13206503E-02,                &
     &     0.99752000E+00,-.14576742E-01,-.13199577E-02,                &
     &     0.99751700E+00,-.14574336E-01,-.13204642E-02,                &
     &     0.99751900E+00,-.14574886E-01,-.13205282E-02,                &
     &     0.99752000E+00,-.14575833E-01,-.13202857E-02,                &
     &     0.99751700E+00,-.14575289E-01,-.13203482E-02,                &
     &     0.99752100E+00,-.14576566E-01,-.13200389E-02/                
      data ((pk0(l,k, 5),l=1,3),k=136,150)/                             &
     &     0.99751600E+00,-.14574271E-01,-.13205695E-02,                &
     &     0.99752200E+00,-.14576311E-01,-.13201008E-02,                &
     &     0.99752200E+00,-.14577331E-01,-.13198203E-02,                &
     &     0.99752000E+00,-.14577444E-01,-.13200046E-02,                &
     &     0.99751700E+00,-.14573437E-01,-.13208271E-02,                &
     &     0.99752200E+00,-.14577228E-01,-.13201381E-02,                &
     &     0.99751800E+00,-.14573177E-01,-.13208026E-02,                &
     &     0.99751700E+00,-.14574866E-01,-.13203565E-02,                &
     &     0.99611500E+00,-.13302124E-01,-.15670510E-02,                &
     &     0.99174600E+00,-.93432647E-02,-.23339214E-02,                &
     &     0.98677900E+00,-.77467985E-02,-.23592684E-02,                &
     &     0.98127800E+00,-.15675498E-01,0.62620242E-04,                &
     &     0.97539500E+00,-.21783557E-01,0.53319817E-03,                &
     &     0.96939200E+00,-.27132454E-01,0.61171928E-03,                &
     &     0.96369600E+00,-.32215883E-01,0.67548543E-03/                
      data ((pk0(l,k, 5),l=1,3),k=151,165)/                             &
     &     0.96241300E+00,-.33361374E-01,0.68806592E-03,                &
     &     0.96122700E+00,-.34423495E-01,0.69964192E-03,                &
     &     0.96014300E+00,-.35393005E-01,0.70966679E-03,                &
     &     0.95917000E+00,-.36263486E-01,0.71806012E-03,                &
     &     0.95831000E+00,-.37027813E-01,0.72500464E-03,                &
     &     0.95758000E+00,-.37682858E-01,0.73090799E-03,                &
     &     0.95698200E+00,-.38220775E-01,0.73589149E-03,                &
     &     0.95652100E+00,-.38635326E-01,0.73989907E-03,                &
     &     0.95620800E+00,-.38911433E-01,0.74070396E-03,                &
     &     0.95604700E+00,-.39062098E-01,0.74380474E-03,                &
     &     0.95622100E+00,-.38902097E-01,0.73944003E-03,                &
     &     0.95778400E+00,-.37513365E-01,0.71323615E-03,                &
     &     0.96091100E+00,-.34733938E-01,0.66022535E-03,                &
     &     0.96560200E+00,-.30566980E-01,0.58125515E-03,                &
     &     0.97185500E+00,-.25006518E-01,0.47484624E-03/                
      data ((pk0(l,k, 5),l=1,3),k=166,180)/                             &
     &     0.97967700E+00,-.18062892E-01,0.34359296E-03,                &
     &     0.98905600E+00,-.97270665E-02,0.18524243E-03,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14,                &
     &     0.10125100E+01,0.11112990E-01,-.21100754E-03,                &
     &     0.10265800E+01,0.23619003E-01,-.44884420E-03,                &
     &     0.10422200E+01,0.37507849E-01,-.71165011E-03,                &
     &     0.10594100E+01,0.52801892E-01,-.10051393E-02,                &
     &     0.10781800E+01,0.69469917E-01,-.13212566E-02,                &
     &     0.10985000E+01,0.87532718E-01,-.16641203E-02,                &
     &     0.11204000E+01,0.10697986E+00,-.20335203E-02,                &
     &     0.11438500E+01,0.12781718E+00,-.24285255E-02,                &
     &     0.11688600E+01,0.15005237E+00,-.28525840E-02,                &
     &     0.11954500E+01,0.17366892E+00,-.33011683E-02,                &
     &     0.12235900E+01,0.19868198E+00,-.37777261E-02,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14/                
      data ((pk0(l,k, 6),l=1,3),k=  1, 15)/                             &
     &     0.94109400E+00,-.10395382E+00,0.47926122E-02,                &
     &     0.94111600E+00,-.10391988E+00,0.47890616E-02,                &
     &     0.94113600E+00,-.10388665E+00,0.47860324E-02,                &
     &     0.94116000E+00,-.10385001E+00,0.47822053E-02,                &
     &     0.94118200E+00,-.10380738E+00,0.47773965E-02,                &
     &     0.94121200E+00,-.10377003E+00,0.47738376E-02,                &
     &     0.94123300E+00,-.10372765E+00,0.47696293E-02,                &
     &     0.94126300E+00,-.10368148E+00,0.47645417E-02,                &
     &     0.94129400E+00,-.10363988E+00,0.47608436E-02,                &
     &     0.94132800E+00,-.10359299E+00,0.47560336E-02,                &
     &     0.94135400E+00,-.10353669E+00,0.47497259E-02,                &
     &     0.94138900E+00,-.10348322E+00,0.47440918E-02,                &
     &     0.94142500E+00,-.10343005E+00,0.47389282E-02,                &
     &     0.94145900E+00,-.10337244E+00,0.47331463E-02,                &
     &     0.94149300E+00,-.10330704E+00,0.47259639E-02/                
      data ((pk0(l,k, 6),l=1,3),k= 16, 30)/                             &
     &     0.94154200E+00,-.10324853E+00,0.47203686E-02,                &
     &     0.94158000E+00,-.10317885E+00,0.47129443E-02,                &
     &     0.94163300E+00,-.10310923E+00,0.47056355E-02,                &
     &     0.94167500E+00,-.10303002E+00,0.46969598E-02,                &
     &     0.94172000E+00,-.10295449E+00,0.46894442E-02,                &
     &     0.94177500E+00,-.10287276E+00,0.46808326E-02,                &
     &     0.94183000E+00,-.10278642E+00,0.46717674E-02,                &
     &     0.94188700E+00,-.10269507E+00,0.46620755E-02,                &
     &     0.94194800E+00,-.10260081E+00,0.46522889E-02,                &
     &     0.94201000E+00,-.10250060E+00,0.46417847E-02,                &
     &     0.94207700E+00,-.10239536E+00,0.46306538E-02,                &
     &     0.94214700E+00,-.10228439E+00,0.46188544E-02,                &
     &     0.94222000E+00,-.10216867E+00,0.46067870E-02,                &
     &     0.94229700E+00,-.10204665E+00,0.45939388E-02,                &
     &     0.94237700E+00,-.10191830E+00,0.45804342E-02/                
      data ((pk0(l,k, 6),l=1,3),k= 31, 45)/                             &
     &     0.94246300E+00,-.10178285E+00,0.45659942E-02,                &
     &     0.94255100E+00,-.10164072E+00,0.45510736E-02,                &
     &     0.94264600E+00,-.10149277E+00,0.45356530E-02,                &
     &     0.94274400E+00,-.10133501E+00,0.45189050E-02,                &
     &     0.94284900E+00,-.10117132E+00,0.45017608E-02,                &
     &     0.94295900E+00,-.10099750E+00,0.44833630E-02,                &
     &     0.94307300E+00,-.10081582E+00,0.44642982E-02,                &
     &     0.94319400E+00,-.10062530E+00,0.44444051E-02,                &
     &     0.94332100E+00,-.10042309E+00,0.44230275E-02,                &
     &     0.94345400E+00,-.10021135E+00,0.44007895E-02,                &
     &     0.94359400E+00,-.99988154E-01,0.43773028E-02,                &
     &     0.94374000E+00,-.99753491E-01,0.43526188E-02,                &
     &     0.94389400E+00,-.99508369E-01,0.43271723E-02,                &
     &     0.94405500E+00,-.99248926E-01,0.42999677E-02,                &
     &     0.94422500E+00,-.98978445E-01,0.42718677E-02/                
      data ((pk0(l,k, 6),l=1,3),k= 46, 60)/                             &
     &     0.94440400E+00,-.98692456E-01,0.42419831E-02,                &
     &     0.94459100E+00,-.98393170E-01,0.42110451E-02,                &
     &     0.94478800E+00,-.98078577E-01,0.41785450E-02,                &
     &     0.94499500E+00,-.97748812E-01,0.41444943E-02,                &
     &     0.94520900E+00,-.97401236E-01,0.41088161E-02,                &
     &     0.94543700E+00,-.97036701E-01,0.40712695E-02,                &
     &     0.94567500E+00,-.96656137E-01,0.40327532E-02,                &
     &     0.94592300E+00,-.96254511E-01,0.39916373E-02,                &
     &     0.94618400E+00,-.95832967E-01,0.39488176E-02,                &
     &     0.94645800E+00,-.95393111E-01,0.39045521E-02,                &
     &     0.94674400E+00,-.94930433E-01,0.38580018E-02,                &
     &     0.94704600E+00,-.94446016E-01,0.38095342E-02,                &
     &     0.94735700E+00,-.93937420E-01,0.37590751E-02,                &
     &     0.94768500E+00,-.93403800E-01,0.37059738E-02,                &
     &     0.94803100E+00,-.92848365E-01,0.36516533E-02/                
      data ((pk0(l,k, 6),l=1,3),k= 61, 75)/                             &
     &     0.94838800E+00,-.92263289E-01,0.35942171E-02,                &
     &     0.94876400E+00,-.91651946E-01,0.35347517E-02,                &
     &     0.94915500E+00,-.91014061E-01,0.34734450E-02,                &
     &     0.94956500E+00,-.90344269E-01,0.34090305E-02,                &
     &     0.94999200E+00,-.89644425E-01,0.33423585E-02,                &
     &     0.95043500E+00,-.88911916E-01,0.32732158E-02,                &
     &     0.95090200E+00,-.88149314E-01,0.32020915E-02,                &
     &     0.95138400E+00,-.87352144E-01,0.31284930E-02,                &
     &     0.95188900E+00,-.86516565E-01,0.30513966E-02,                &
     &     0.95241400E+00,-.85649275E-01,0.29730470E-02,                &
     &     0.95296200E+00,-.84741321E-01,0.28915217E-02,                &
     &     0.95353400E+00,-.83798337E-01,0.28084985E-02,                &
     &     0.95412000E+00,-.82808267E-01,0.27214881E-02,                &
     &     0.95473300E+00,-.81780062E-01,0.26328031E-02,                &
     &     0.95537800E+00,-.80711421E-01,0.25417395E-02/                
      data ((pk0(l,k, 6),l=1,3),k= 76, 90)/                             &
     &     0.95603600E+00,-.79593530E-01,0.24478547E-02,                &
     &     0.95672700E+00,-.78434382E-01,0.23524147E-02,                &
     &     0.95744000E+00,-.77224264E-01,0.22539632E-02,                &
     &     0.95818600E+00,-.75968720E-01,0.21537520E-02,                &
     &     0.95895400E+00,-.74667204E-01,0.20528775E-02,                &
     &     0.95974900E+00,-.73306289E-01,0.19481479E-02,                &
     &     0.96057700E+00,-.71897916E-01,0.18428588E-02,                &
     &     0.96143900E+00,-.70436031E-01,0.17360222E-02,                &
     &     0.96232100E+00,-.68916103E-01,0.16275994E-02,                &
     &     0.96323600E+00,-.67339680E-01,0.15182472E-02,                &
     &     0.96419000E+00,-.65703864E-01,0.14074898E-02,                &
     &     0.96516400E+00,-.64000186E-01,0.12948368E-02,                &
     &     0.96618400E+00,-.62243056E-01,0.11835809E-02,                &
     &     0.96723700E+00,-.60418894E-01,0.10715517E-02,                &
     &     0.96832300E+00,-.58528666E-01,0.95975299E-03/                
      data ((pk0(l,k, 6),l=1,3),k= 91,105)/                             &
     &     0.96944000E+00,-.56568291E-01,0.84819515E-03,                &
     &     0.97060600E+00,-.54535797E-01,0.73685940E-03,                &
     &     0.97180300E+00,-.52428747E-01,0.62645033E-03,                &
     &     0.97305000E+00,-.50246146E-01,0.51758060E-03,                &
     &     0.97433000E+00,-.47978109E-01,0.40938247E-03,                &
     &     0.97566000E+00,-.45626773E-01,0.30340512E-03,                &
     &     0.97704100E+00,-.43186961E-01,0.19984400E-03,                &
     &     0.97847300E+00,-.40649938E-01,0.98336265E-04,                &
     &     0.97996200E+00,-.38010099E-01,-.71780752E-06,                &
     &     0.98151100E+00,-.35262685E-01,-.96433306E-04,                &
     &     0.98312500E+00,-.32397444E-01,-.18909779E-03,                &
     &     0.98481000E+00,-.29409098E-01,-.27775771E-03,                &
     &     0.98656600E+00,-.26286570E-01,-.36275705E-03,                &
     &     0.98840100E+00,-.23024771E-01,-.44325990E-03,                &
     &     0.99031800E+00,-.19619179E-01,-.51846068E-03/                
      data ((pk0(l,k, 6),l=1,3),k=106,120)/                             &
     &     0.99231600E+00,-.16069022E-01,-.58730401E-03,                &
     &     0.99439600E+00,-.12375506E-01,-.64927423E-03,                &
     &     0.99655500E+00,-.85483897E-02,-.70260403E-03,                &
     &     0.99878100E+00,-.45980707E-02,-.74696629E-03,                &
     &     0.10010700E+01,-.55627421E-03,-.77892348E-03,                &
     &     0.10033900E+01,0.35574767E-02,-.79964143E-03,                &
     &     0.10057400E+01,0.76933230E-02,-.80483551E-03,                &
     &     0.10080700E+01,0.11822733E-01,-.79688409E-03,                &
     &     0.10103800E+01,0.15871931E-01,-.77083835E-03,                &
     &     0.10126200E+01,0.19807879E-01,-.73006473E-03,                &
     &     0.10147800E+01,0.23559271E-01,-.67160095E-03,                &
     &     0.10168200E+01,0.27090433E-01,-.59922858E-03,                &
     &     0.10187200E+01,0.30362805E-01,-.51513320E-03,                &
     &     0.10204700E+01,0.33328592E-01,-.42031855E-03,                &
     &     0.10220600E+01,0.35975702E-01,-.31912734E-03/                
      data ((pk0(l,k, 6),l=1,3),k=121,135)/                             &
     &     0.10234700E+01,0.38298332E-01,-.21695143E-03,                &
     &     0.10247200E+01,0.40279467E-01,-.11534940E-03,                &
     &     0.10258000E+01,0.41933013E-01,-.18748739E-04,                &
     &     0.10267300E+01,0.43276457E-01,0.64478314E-04,                &
     &     0.10274900E+01,0.44311601E-01,0.13449307E-03,                &
     &     0.10281000E+01,0.45057082E-01,0.18392936E-03,                &
     &     0.10285600E+01,0.45496509E-01,0.21359471E-03,                &
     &     0.10288400E+01,0.45647847E-01,0.22030041E-03,                &
     &     0.10289600E+01,0.45501819E-01,0.20784383E-03,                &
     &     0.10288700E+01,0.45063295E-01,0.17848282E-03,                &
     &     0.10285900E+01,0.44313589E-01,0.13993585E-03,                &
     &     0.10280600E+01,0.43256417E-01,0.95886597E-04,                &
     &     0.10272500E+01,0.41854750E-01,0.57740914E-04,                &
     &     0.10261400E+01,0.40086701E-01,0.32009573E-04,                &
     &     0.10246900E+01,0.37927772E-01,0.24160248E-04/                
      data ((pk0(l,k, 6),l=1,3),k=136,150)/                             &
     &     0.10228600E+01,0.35345170E-01,0.37875655E-04,                &
     &     0.10206200E+01,0.32335860E-01,0.66964384E-04,                &
     &     0.10179600E+01,0.28873036E-01,0.11139332E-03,                &
     &     0.10148700E+01,0.24965690E-01,0.16272753E-03,                &
     &     0.10113600E+01,0.20636723E-01,0.21484270E-03,                &
     &     0.10074400E+01,0.15928527E-01,0.26248359E-03,                &
     &     0.10031200E+01,0.10902477E-01,0.30147539E-03,                &
     &     0.99844600E+00,0.55939282E-02,0.33817677E-03,                &
     &     0.99344100E+00,0.71209519E-04,0.37253025E-03,                &
     &     0.98814900E+00,-.56070352E-02,0.40939211E-03,                &
     &     0.98266000E+00,-.11371452E-01,0.45183488E-03,                &
     &     0.97708000E+00,-.17115286E-01,0.49946980E-03,                &
     &     0.97160200E+00,-.22658282E-01,0.54818223E-03,                &
     &     0.96651500E+00,-.27748597E-01,0.59393420E-03,                &
     &     0.96237200E+00,-.31906542E-01,0.63167611E-03/                
      data ((pk0(l,k, 6),l=1,3),k=151,165)/                             &
     &     0.96159200E+00,-.32697322E-01,0.63793026E-03,                &
     &     0.96095700E+00,-.33358719E-01,0.64369653E-03,                &
     &     0.96047900E+00,-.33865188E-01,0.64727459E-03,                &
     &     0.96019500E+00,-.34198309E-01,0.64869250E-03,                &
     &     0.96012800E+00,-.34328429E-01,0.64729839E-03,                &
     &     0.96032800E+00,-.34220553E-01,0.64318452E-03,                &
     &     0.96085300E+00,-.33814103E-01,0.63415387E-03,                &
     &     0.96179500E+00,-.33034937E-01,0.61977710E-03,                &
     &     0.96329200E+00,-.31758265E-01,0.59746312E-03,                &
     &     0.96550700E+00,-.29826762E-01,0.56313247E-03,                &
     &     0.96879200E+00,-.26962929E-01,0.51406263E-03,                &
     &     0.97326400E+00,-.23019555E-01,0.44520254E-03,                &
     &     0.97895400E+00,-.17995214E-01,0.35652278E-03,                &
     &     0.98585100E+00,-.11896730E-01,0.24863867E-03,                &
     &     0.99394700E+00,-.47271855E-02,0.11999481E-03/                
      data ((pk0(l,k, 6),l=1,3),k=166,180)/                             &
     &     0.10032300E+01,0.35038488E-02,-.27903889E-04,                &
     &     0.10137100E+01,0.12782894E-01,-.19415889E-03,                &
     &     0.10253600E+01,0.23118512E-01,-.38226199E-03,                &
     &     0.10381800E+01,0.34487196E-01,-.58823893E-03,                &
     &     0.10521600E+01,0.46900639E-01,-.81611719E-03,                &
     &     0.10672900E+01,0.60337415E-01,-.10624948E-02,                &
     &     0.10835700E+01,0.74797213E-01,-.13302408E-02,                &
     &     0.11009900E+01,0.90259372E-01,-.16148269E-02,                &
     &     0.11195300E+01,0.10672487E+00,-.19197944E-02,                &
     &     0.11391800E+01,0.12417862E+00,-.22441098E-02,                &
     &     0.11599900E+01,0.14264489E+00,-.25864390E-02,                &
     &     0.11791300E+01,0.15965863E+00,-.29047314E-02,                &
     &     0.12012500E+01,0.17929509E+00,-.32693768E-02,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14/                
      data ((pk0(l,k, 7),l=1,3),k=  1, 15)/                             &
     &     0.95235500E+00,-.84969702E-01,0.35149944E-02,                &
     &     0.95251700E+00,-.84706057E-01,0.34979614E-02,                &
     &     0.95267400E+00,-.84437382E-01,0.34807445E-02,                &
     &     0.95283100E+00,-.84156997E-01,0.34617001E-02,                &
     &     0.95300100E+00,-.83879612E-01,0.34439024E-02,                &
     &     0.95316200E+00,-.83595425E-01,0.34255485E-02,                &
     &     0.95333500E+00,-.83306528E-01,0.34066974E-02,                &
     &     0.95351200E+00,-.83011412E-01,0.33874157E-02,                &
     &     0.95369000E+00,-.82711461E-01,0.33676825E-02,                &
     &     0.95387000E+00,-.82412887E-01,0.33493170E-02,                &
     &     0.95404900E+00,-.82099306E-01,0.33284042E-02,                &
     &     0.95423500E+00,-.81783494E-01,0.33079002E-02,                &
     &     0.95442800E+00,-.81467020E-01,0.32880563E-02,                &
     &     0.95462100E+00,-.81138360E-01,0.32664744E-02,                &
     &     0.95481800E+00,-.80806913E-01,0.32452840E-02/                
      data ((pk0(l,k, 7),l=1,3),k= 16, 30)/                             &
     &     0.95501700E+00,-.80467541E-01,0.32232046E-02,                &
     &     0.95522200E+00,-.80124110E-01,0.32012545E-02,                &
     &     0.95542900E+00,-.79773259E-01,0.31785793E-02,                &
     &     0.95563900E+00,-.79416131E-01,0.31556583E-02,                &
     &     0.95585400E+00,-.79053186E-01,0.31324654E-02,                &
     &     0.95607200E+00,-.78682049E-01,0.31085271E-02,                &
     &     0.95629600E+00,-.78306082E-01,0.30846056E-02,                &
     &     0.95652200E+00,-.77922231E-01,0.30600955E-02,                &
     &     0.95675400E+00,-.77531230E-01,0.30350288E-02,                &
     &     0.95698800E+00,-.77131678E-01,0.30094643E-02,                &
     &     0.95722700E+00,-.76726668E-01,0.29838369E-02,                &
     &     0.95747300E+00,-.76313793E-01,0.29576618E-02,                &
     &     0.95772000E+00,-.75891596E-01,0.29307972E-02,                &
     &     0.95797500E+00,-.75463072E-01,0.29036189E-02,                &
     &     0.95823200E+00,-.75024948E-01,0.28759136E-02/                
      data ((pk0(l,k, 7),l=1,3),k= 31, 45)/                             &
     &     0.95849500E+00,-.74578981E-01,0.28476505E-02,                &
     &     0.95876400E+00,-.74124729E-01,0.28190553E-02,                &
     &     0.95903700E+00,-.73661106E-01,0.27898110E-02,                &
     &     0.95931600E+00,-.73188778E-01,0.27601523E-02,                &
     &     0.95960000E+00,-.72706668E-01,0.27297733E-02,                &
     &     0.95988900E+00,-.72215548E-01,0.26989749E-02,                &
     &     0.96018500E+00,-.71713730E-01,0.26674301E-02,                &
     &     0.96048500E+00,-.71202768E-01,0.26355387E-02,                &
     &     0.96079200E+00,-.70682302E-01,0.26032425E-02,                &
     &     0.96110700E+00,-.70150527E-01,0.25699181E-02,                &
     &     0.96142500E+00,-.69608719E-01,0.25364422E-02,                &
     &     0.96175300E+00,-.69055212E-01,0.25019906E-02,                &
     &     0.96208500E+00,-.68489747E-01,0.24667335E-02,                &
     &     0.96242500E+00,-.67915394E-01,0.24316973E-02,                &
     &     0.96277000E+00,-.67326497E-01,0.23951902E-02/                
      data ((pk0(l,k, 7),l=1,3),k= 46, 60)/                             &
     &     0.96312300E+00,-.66726618E-01,0.23583250E-02,                &
     &     0.96348400E+00,-.66114006E-01,0.23206868E-02,                &
     &     0.96384800E+00,-.65487373E-01,0.22821726E-02,                &
     &     0.96422800E+00,-.64852726E-01,0.22439985E-02,                &
     &     0.96461000E+00,-.64201268E-01,0.22044071E-02,                &
     &     0.96499800E+00,-.63533171E-01,0.21634454E-02,                &
     &     0.96539900E+00,-.62855868E-01,0.21228206E-02,                &
     &     0.96580300E+00,-.62160127E-01,0.20806175E-02,                &
     &     0.96621900E+00,-.61451477E-01,0.20380220E-02,                &
     &     0.96664300E+00,-.60728208E-01,0.19946205E-02,                &
     &     0.96708000E+00,-.59991088E-01,0.19509104E-02,                &
     &     0.96752000E+00,-.59235444E-01,0.19060071E-02,                &
     &     0.96797500E+00,-.58467816E-01,0.18611045E-02,                &
     &     0.96843300E+00,-.57676646E-01,0.18137332E-02,                &
     &     0.96890700E+00,-.56876568E-01,0.17677014E-02/                
      data ((pk0(l,k, 7),l=1,3),k= 61, 75)/                             &
     &     0.96938500E+00,-.56053732E-01,0.17197571E-02,                &
     &     0.96987500E+00,-.55212823E-01,0.16706444E-02,                &
     &     0.97037500E+00,-.54355281E-01,0.16210886E-02,                &
     &     0.97089000E+00,-.53483096E-01,0.15717470E-02,                &
     &     0.97141000E+00,-.52589322E-01,0.15212875E-02,                &
     &     0.97194100E+00,-.51671177E-01,0.14687000E-02,                &
     &     0.97248500E+00,-.50739993E-01,0.14172029E-02,                &
     &     0.97304200E+00,-.49790263E-01,0.13649320E-02,                &
     &     0.97360800E+00,-.48814300E-01,0.13109817E-02,                &
     &     0.97419000E+00,-.47821546E-01,0.12571509E-02,                &
     &     0.97477700E+00,-.46802078E-01,0.12018895E-02,                &
     &     0.97538200E+00,-.45766116E-01,0.11468533E-02,                &
     &     0.97599500E+00,-.44706196E-01,0.10911307E-02,                &
     &     0.97661300E+00,-.43615582E-01,0.10331017E-02,                &
     &     0.97725100E+00,-.42510802E-01,0.97659144E-03/                
      data ((pk0(l,k, 7),l=1,3),k= 76, 90)/                             &
     &     0.97791700E+00,-.41387934E-01,0.92062648E-03,                &
     &     0.97857600E+00,-.40233816E-01,0.86304621E-03,                &
     &     0.97925500E+00,-.39054834E-01,0.80492862E-03,                &
     &     0.97994800E+00,-.37852703E-01,0.74700356E-03,                &
     &     0.98065400E+00,-.36626264E-01,0.68922457E-03,                &
     &     0.98137200E+00,-.35371450E-01,0.63072983E-03,                &
     &     0.98210700E+00,-.34093341E-01,0.57303390E-03,                &
     &     0.98285500E+00,-.32787501E-01,0.51521225E-03,                &
     &     0.98361700E+00,-.31454463E-01,0.45763494E-03,                &
     &     0.98439400E+00,-.30092948E-01,0.40015672E-03,                &
     &     0.98518700E+00,-.28705090E-01,0.34368706E-03,                &
     &     0.98599600E+00,-.27287726E-01,0.28749764E-03,                &
     &     0.98681800E+00,-.25840584E-01,0.23203107E-03,                &
     &     0.98765800E+00,-.24363425E-01,0.17743863E-03,                &
     &     0.98851500E+00,-.22856529E-01,0.12405703E-03/                
      data ((pk0(l,k, 7),l=1,3),k= 91,105)/                             &
     &     0.98938700E+00,-.21317350E-01,0.71621853E-04,                &
     &     0.99027700E+00,-.19746121E-01,0.20574717E-04,                &
     &     0.99118600E+00,-.18141116E-01,-.29149398E-04,                &
     &     0.99211300E+00,-.16501155E-01,-.77354445E-04,                &
     &     0.99305900E+00,-.14825134E-01,-.12398274E-03,                &
     &     0.99402400E+00,-.13113789E-01,-.16823268E-03,                &
     &     0.99501300E+00,-.11361227E-01,-.21127706E-03,                &
     &     0.99602300E+00,-.95723810E-02,-.25127040E-03,                &
     &     0.99705300E+00,-.77404123E-02,-.28912585E-03,                &
     &     0.99810800E+00,-.58640576E-02,-.32512970E-03,                &
     &     0.99919100E+00,-.39498867E-02,-.35676633E-03,                &
     &     0.10002900E+01,-.19841359E-02,-.38755957E-03,                &
     &     0.10014200E+01,0.18816645E-04,-.41395543E-03,                &
     &     0.10025700E+01,0.20640567E-02,-.43693906E-03,                &
     &     0.10037400E+01,0.41406020E-02,-.45424312E-03/                
      data ((pk0(l,k, 7),l=1,3),k=106,120)/                             &
     &     0.10049300E+01,0.62600592E-02,-.47007478E-03,                &
     &     0.10061400E+01,0.83833077E-02,-.47614257E-03,                &
     &     0.10073500E+01,0.10540248E-01,-.48187632E-03,                &
     &     0.10085700E+01,0.12680000E-01,-.47802504E-03,                &
     &     0.10097700E+01,0.14820217E-01,-.47103719E-03,                &
     &     0.10109600E+01,0.16913123E-01,-.45525503E-03,                &
     &     0.10121200E+01,0.18962367E-01,-.43507382E-03,                &
     &     0.10132400E+01,0.20928863E-01,-.40610649E-03,                &
     &     0.10143100E+01,0.22806127E-01,-.37325332E-03,                &
     &     0.10153100E+01,0.24557237E-01,-.33265757E-03,                &
     &     0.10162400E+01,0.26175089E-01,-.28791124E-03,                &
     &     0.10170900E+01,0.27644659E-01,-.23988125E-03,                &
     &     0.10178600E+01,0.28930035E-01,-.18522098E-03,                &
     &     0.10185200E+01,0.30060834E-01,-.13363398E-03,                &
     &     0.10191000E+01,0.31002247E-01,-.81774481E-04/                
      data ((pk0(l,k, 7),l=1,3),k=121,135)/                             &
     &     0.10195700E+01,0.31772549E-01,-.34136782E-04,                &
     &     0.10199500E+01,0.32353657E-01,0.11376809E-04,                &
     &     0.10202200E+01,0.32769581E-01,0.48089795E-04,                &
     &     0.10204000E+01,0.32996418E-01,0.79940644E-04,                &
     &     0.10204700E+01,0.33055045E-01,0.10215330E-03,                &
     &     0.10204400E+01,0.32935182E-01,0.11465650E-03,                &
     &     0.10202800E+01,0.32640638E-01,0.11788856E-03,                &
     &     0.10200000E+01,0.32155419E-01,0.11476627E-03,                &
     &     0.10195800E+01,0.31486051E-01,0.10494415E-03,                &
     &     0.10190100E+01,0.30613851E-01,0.92830537E-04,                &
     &     0.10182700E+01,0.29524648E-01,0.82989383E-04,                &
     &     0.10173300E+01,0.28211722E-01,0.75886340E-04,                &
     &     0.10161700E+01,0.26667821E-01,0.73121772E-04,                &
     &     0.10147800E+01,0.24841298E-01,0.83874034E-04,                &
     &     0.10131300E+01,0.22729400E-01,0.10631839E-03/                
      data ((pk0(l,k, 7),l=1,3),k=136,150)/                             &
     &     0.10112000E+01,0.20324338E-01,0.13677618E-03,                &
     &     0.10089700E+01,0.17622056E-01,0.17265905E-03,                &
     &     0.10064400E+01,0.14594168E-01,0.21523796E-03,                &
     &     0.10036000E+01,0.11265273E-01,0.25833683E-03,                &
     &     0.10004500E+01,0.76518006E-02,0.29879656E-03,                &
     &     0.99700000E+00,0.37718292E-02,0.33645387E-03,                &
     &     0.99326900E+00,-.33719714E-03,0.37001506E-03,                &
     &     0.98927900E+00,-.46480833E-02,0.40351736E-03,                &
     &     0.98506800E+00,-.91117258E-02,0.43753516E-03,                &
     &     0.98068400E+00,-.13666612E-01,0.47319156E-03,                &
     &     0.97622300E+00,-.18234828E-01,0.51177388E-03,                &
     &     0.97182000E+00,-.22680858E-01,0.54996382E-03,                &
     &     0.96771200E+00,-.26798407E-01,0.58585926E-03,                &
     &     0.96419000E+00,-.30338349E-01,0.61541498E-03,                &
     &     0.96231600E+00,-.32320355E-01,0.62598807E-03/                
      data ((pk0(l,k, 7),l=1,3),k=151,165)/                             &
     &     0.96218700E+00,-.32507812E-01,0.62453556E-03,                &
     &     0.96224700E+00,-.32520835E-01,0.62052235E-03,                &
     &     0.96254200E+00,-.32322598E-01,0.61355606E-03,                &
     &     0.96310800E+00,-.31878689E-01,0.60306541E-03,                &
     &     0.96399500E+00,-.31143393E-01,0.58788873E-03,                &
     &     0.96526600E+00,-.30060220E-01,0.56702265E-03,                &
     &     0.96700600E+00,-.28558116E-01,0.53946958E-03,                &
     &     0.96931600E+00,-.26543174E-01,0.50282005E-03,                &
     &     0.97233200E+00,-.23909194E-01,0.45569054E-03,                &
     &     0.97617400E+00,-.20521797E-01,0.39532538E-03,                &
     &     0.98100600E+00,-.16260262E-01,0.31933515E-03,                &
     &     0.98685400E+00,-.11088106E-01,0.22618120E-03,                &
     &     0.99371600E+00,-.50167195E-02,0.11702011E-03,                &
     &     0.10015800E+01,0.19481780E-02,-.87074678E-05,                &
     &     0.10104400E+01,0.97992347E-02,-.15146582E-03/                
      data ((pk0(l,k, 7),l=1,3),k=166,180)/                             &
     &     0.10202900E+01,0.18529139E-01,-.31108955E-03,                &
     &     0.10311100E+01,0.28137513E-01,-.48756304E-03,                &
     &     0.10429100E+01,0.38603323E-01,-.67888754E-03,                &
     &     0.10556800E+01,0.49931095E-01,-.88739298E-03,                &
     &     0.10694000E+01,0.62128210E-01,-.11141357E-02,                &
     &     0.10840900E+01,0.75165728E-01,-.13551184E-02,                &
     &     0.10997600E+01,0.89063308E-01,-.16132238E-02,                &
     &     0.11164100E+01,0.10383650E+00,-.18867012E-02,                &
     &     0.11340800E+01,0.11954941E+00,-.21822401E-02,                &
     &     0.11529300E+01,0.13627364E+00,-.24936969E-02,                &
     &     0.11737100E+01,0.15473172E+00,-.28409284E-02,                &
     &     0.11938700E+01,0.17264047E+00,-.31782963E-02,                &
     &     0.12194500E+01,0.19534615E+00,-.36048393E-02,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14/                
      data ((pk0(l,k, 8),l=1,3),k=  1, 15)/                             &
     &     0.94059400E+00,-.10476988E+00,0.48643361E-02,                &
     &     0.94060100E+00,-.10476099E+00,0.48632393E-02,                &
     &     0.94060700E+00,-.10475064E+00,0.48619364E-02,                &
     &     0.94061300E+00,-.10474016E+00,0.48607408E-02,                &
     &     0.94062100E+00,-.10473029E+00,0.48597003E-02,                &
     &     0.94062800E+00,-.10471820E+00,0.48582348E-02,                &
     &     0.94063700E+00,-.10470636E+00,0.48568392E-02,                &
     &     0.94064500E+00,-.10469233E+00,0.48552050E-02,                &
     &     0.94065400E+00,-.10467871E+00,0.48536152E-02,                &
     &     0.94066300E+00,-.10466187E+00,0.48513824E-02,                &
     &     0.94067500E+00,-.10464700E+00,0.48497764E-02,                &
     &     0.94068500E+00,-.10462972E+00,0.48477851E-02,                &
     &     0.94069600E+00,-.10461140E+00,0.48455879E-02,                &
     &     0.94070900E+00,-.10459227E+00,0.48433507E-02,                &
     &     0.94072400E+00,-.10457256E+00,0.48410537E-02/                
      data ((pk0(l,k, 8),l=1,3),k= 16, 30)/                             &
     &     0.94073700E+00,-.10455020E+00,0.48384892E-02,                &
     &     0.94075200E+00,-.10452675E+00,0.48356810E-02,                &
     &     0.94076800E+00,-.10450248E+00,0.48328497E-02,                &
     &     0.94078500E+00,-.10447613E+00,0.48297833E-02,                &
     &     0.94080400E+00,-.10444845E+00,0.48265332E-02,                &
     &     0.94082200E+00,-.10441679E+00,0.48225828E-02,                &
     &     0.94084400E+00,-.10438656E+00,0.48192181E-02,                &
     &     0.94086600E+00,-.10435269E+00,0.48151522E-02,                &
     &     0.94088700E+00,-.10431577E+00,0.48107455E-02,                &
     &     0.94091300E+00,-.10427942E+00,0.48067624E-02,                &
     &     0.94093900E+00,-.10423732E+00,0.48015096E-02,                &
     &     0.94096800E+00,-.10419414E+00,0.47964666E-02,                &
     &     0.94099700E+00,-.10414840E+00,0.47911822E-02,                &
     &     0.94102900E+00,-.10409932E+00,0.47853797E-02,                &
     &     0.94106300E+00,-.10404835E+00,0.47794833E-02/                
      data ((pk0(l,k, 8),l=1,3),k= 31, 45)/                             &
     &     0.94109800E+00,-.10399371E+00,0.47731849E-02,                &
     &     0.94113600E+00,-.10393298E+00,0.47658114E-02,                &
     &     0.94117700E+00,-.10387088E+00,0.47585283E-02,                &
     &     0.94121800E+00,-.10380443E+00,0.47508709E-02,                &
     &     0.94126400E+00,-.10373366E+00,0.47426432E-02,                &
     &     0.94131400E+00,-.10365936E+00,0.47339752E-02,                &
     &     0.94136800E+00,-.10358047E+00,0.47247561E-02,                &
     &     0.94142000E+00,-.10349462E+00,0.47147789E-02,                &
     &     0.94147700E+00,-.10340367E+00,0.47041375E-02,                &
     &     0.94154100E+00,-.10330931E+00,0.46931457E-02,                &
     &     0.94160600E+00,-.10320691E+00,0.46812216E-02,                &
     &     0.94167700E+00,-.10309859E+00,0.46685599E-02,                &
     &     0.94175200E+00,-.10298326E+00,0.46551571E-02,                &
     &     0.94183100E+00,-.10286179E+00,0.46411490E-02,                &
     &     0.94191400E+00,-.10273271E+00,0.46263089E-02/                
      data ((pk0(l,k, 8),l=1,3),k= 46, 60)/                             &
     &     0.94200000E+00,-.10259278E+00,0.46099730E-02,                &
     &     0.94209300E+00,-.10244492E+00,0.45925330E-02,                &
     &     0.94219600E+00,-.10229236E+00,0.45752111E-02,                &
     &     0.94230000E+00,-.10212512E+00,0.45557262E-02,                &
     &     0.94241400E+00,-.10195003E+00,0.45354007E-02,                &
     &     0.94253300E+00,-.10176549E+00,0.45142722E-02,                &
     &     0.94266100E+00,-.10156755E+00,0.44913309E-02,                &
     &     0.94279300E+00,-.10135852E+00,0.44674797E-02,                &
     &     0.94293400E+00,-.10113628E+00,0.44420964E-02,                &
     &     0.94308200E+00,-.10089829E+00,0.44144396E-02,                &
     &     0.94324300E+00,-.10064968E+00,0.43862502E-02,                &
     &     0.94341200E+00,-.10038681E+00,0.43563187E-02,                &
     &     0.94359200E+00,-.10010720E+00,0.43244509E-02,                &
     &     0.94378500E+00,-.99813361E-01,0.42914732E-02,                &
     &     0.94397900E+00,-.99495217E-01,0.42552498E-02/                
      data ((pk0(l,k, 8),l=1,3),k= 61, 75)/                             &
     &     0.94419000E+00,-.99163800E-01,0.42180893E-02,                &
     &     0.94441300E+00,-.98809822E-01,0.41779865E-02,                &
     &     0.94465300E+00,-.98442285E-01,0.41372470E-02,                &
     &     0.94490300E+00,-.98047247E-01,0.40928755E-02,                &
     &     0.94516000E+00,-.97628433E-01,0.40461149E-02,                &
     &     0.94543900E+00,-.97188052E-01,0.39968478E-02,                &
     &     0.94573500E+00,-.96728565E-01,0.39466602E-02,                &
     &     0.94604200E+00,-.96237153E-01,0.38924908E-02,                &
     &     0.94637300E+00,-.95719600E-01,0.38355202E-02,                &
     &     0.94670800E+00,-.95172401E-01,0.37760094E-02,                &
     &     0.94707300E+00,-.94597221E-01,0.37133254E-02,                &
     &     0.94745000E+00,-.93994737E-01,0.36488318E-02,                &
     &     0.94785100E+00,-.93358011E-01,0.35806935E-02,                &
     &     0.94826900E+00,-.92686001E-01,0.35090527E-02,                &
     &     0.94869700E+00,-.91974440E-01,0.34331870E-02/                
      data ((pk0(l,k, 8),l=1,3),k= 76, 90)/                             &
     &     0.94915800E+00,-.91233372E-01,0.33554379E-02,                &
     &     0.94964600E+00,-.90457384E-01,0.32746954E-02,                &
     &     0.95014200E+00,-.89635725E-01,0.31893927E-02,                &
     &     0.95067600E+00,-.88777216E-01,0.31011247E-02,                &
     &     0.95122200E+00,-.87876987E-01,0.30095449E-02,                &
     &     0.95179700E+00,-.86935232E-01,0.29147022E-02,                &
     &     0.95239600E+00,-.85949021E-01,0.28162863E-02,                &
     &     0.95302000E+00,-.84918086E-01,0.27145995E-02,                &
     &     0.95367200E+00,-.83841511E-01,0.26095746E-02,                &
     &     0.95434800E+00,-.82717814E-01,0.25014191E-02,                &
     &     0.95505000E+00,-.81546426E-01,0.23902002E-02,                &
     &     0.95578000E+00,-.80325984E-01,0.22758707E-02,                &
     &     0.95653700E+00,-.79056682E-01,0.21588993E-02,                &
     &     0.95731900E+00,-.77735808E-01,0.20390305E-02,                &
     &     0.95813000E+00,-.76364019E-01,0.19167679E-02/                
      data ((pk0(l,k, 8),l=1,3),k= 91,105)/                             &
     &     0.95896800E+00,-.74941013E-01,0.17924232E-02,                &
     &     0.95983300E+00,-.73465361E-01,0.16659918E-02,                &
     &     0.96072400E+00,-.71935499E-01,0.15377731E-02,                &
     &     0.96164600E+00,-.70351924E-01,0.14081479E-02,                &
     &     0.96259500E+00,-.68711470E-01,0.12772577E-02,                &
     &     0.96357300E+00,-.67013233E-01,0.11455719E-02,                &
     &     0.96458200E+00,-.65253582E-01,0.10134026E-02,                &
     &     0.96562700E+00,-.63427563E-01,0.88060944E-03,                &
     &     0.96670800E+00,-.61529750E-01,0.74806344E-03,                &
     &     0.96783100E+00,-.59546608E-01,0.61469288E-03,                &
     &     0.96900500E+00,-.57470271E-01,0.48181574E-03,                &
     &     0.97023800E+00,-.55280169E-01,0.34829552E-03,                &
     &     0.97154400E+00,-.52958541E-01,0.21496190E-03,                &
     &     0.97293400E+00,-.50477316E-01,0.81241477E-04,                &
     &     0.97442900E+00,-.47810235E-01,-.52358496E-04/                
      data ((pk0(l,k, 8),l=1,3),k=106,120)/                             &
     &     0.97604500E+00,-.44919547E-01,-.18680518E-03,                &
     &     0.97779800E+00,-.41772983E-01,-.32071742E-03,                &
     &     0.97971300E+00,-.38337767E-01,-.45363222E-03,                &
     &     0.98180700E+00,-.34587716E-01,-.58334172E-03,                &
     &     0.98408600E+00,-.30494651E-01,-.70966769E-03,                &
     &     0.98655800E+00,-.26059426E-01,-.82746422E-03,                &
     &     0.98922000E+00,-.21284059E-01,-.93517401E-03,                &
     &     0.99205000E+00,-.16195871E-01,-.10283596E-02,                &
     &     0.99502900E+00,-.10852597E-01,-.11009720E-02,                &
     &     0.99811500E+00,-.53117183E-02,-.11512421E-02,                &
     &     0.10012600E+01,0.32997879E-03,-.11732838E-02,                &
     &     0.10044100E+01,0.59838560E-02,-.11663937E-02,                &
     &     0.10075200E+01,0.11519301E-01,-.11224844E-02,                &
     &     0.10105200E+01,0.16867585E-01,-.10501179E-02,                &
     &     0.10133700E+01,0.21918561E-01,-.94570631E-03/                
      data ((pk0(l,k, 8),l=1,3),k=121,135)/                             &
     &     0.10160300E+01,0.26613762E-01,-.81694804E-03,                &
     &     0.10185000E+01,0.30879617E-01,-.66237422E-03,                &
     &     0.10207400E+01,0.34717135E-01,-.49503916E-03,                &
     &     0.10227800E+01,0.38115411E-01,-.32040593E-03,                &
     &     0.10246300E+01,0.41096209E-01,-.14762822E-03,                &
     &     0.10263000E+01,0.43680602E-01,0.15774997E-04,                &
     &     0.10278300E+01,0.45886991E-01,0.16252758E-03,                &
     &     0.10291900E+01,0.47706552E-01,0.27037782E-03,                &
     &     0.10303700E+01,0.49140868E-01,0.33614823E-03,                &
     &     0.10313900E+01,0.50209897E-01,0.35489836E-03,                &
     &     0.10322400E+01,0.50904549E-01,0.33125458E-03,                &
     &     0.10328700E+01,0.51246626E-01,0.26516534E-03,                &
     &     0.10332800E+01,0.51180433E-01,0.17686697E-03,                &
     &     0.10333800E+01,0.50690926E-01,0.78870717E-04,                &
     &     0.10331200E+01,0.49727997E-01,-.84494076E-05/                
      data ((pk0(l,k, 8),l=1,3),k=136,150)/                             &
     &     0.10324200E+01,0.48238686E-01,-.68915230E-04,                &
     &     0.10312100E+01,0.46160489E-01,-.90709546E-04,                &
     &     0.10294200E+01,0.43425857E-01,-.70895804E-04,                &
     &     0.10270100E+01,0.39987526E-01,-.17389344E-04,                &
     &     0.10239500E+01,0.35831762E-01,0.56501292E-04,                &
     &     0.10202400E+01,0.31000964E-01,0.13221232E-03,                &
     &     0.10159000E+01,0.25570795E-01,0.19550358E-03,                &
     &     0.10109900E+01,0.19604510E-01,0.24918183E-03,                &
     &     0.10055300E+01,0.13229129E-01,0.28817197E-03,                &
     &     0.99956200E+00,0.65055762E-02,0.32514379E-03,                &
     &     0.99314400E+00,-.48405797E-03,0.36750779E-03,                &
     &     0.98636200E+00,-.76450544E-02,0.41828283E-03,                &
     &     0.97937700E+00,-.14839168E-01,0.47858660E-03,                &
     &     0.97244500E+00,-.21814878E-01,0.53925043E-03,                &
     &     0.96599800E+00,-.28222181E-01,0.59900754E-03/                
      data ((pk0(l,k, 8),l=1,3),k=151,165)/                             &
     &     0.96455600E+00,-.29650458E-01,0.61246712E-03,                &
     &     0.96321700E+00,-.30971286E-01,0.62491475E-03,                &
     &     0.96199600E+00,-.32179818E-01,0.63623776E-03,                &
     &     0.96089300E+00,-.33273659E-01,0.64734500E-03,                &
     &     0.95992400E+00,-.34245951E-01,0.65723720E-03,                &
     &     0.95908200E+00,-.35089686E-01,0.66585983E-03,                &
     &     0.95837900E+00,-.35798879E-01,0.67301379E-03,                &
     &     0.95782900E+00,-.36373251E-01,0.67929856E-03,                &
     &     0.95743100E+00,-.36809421E-01,0.68623596E-03,                &
     &     0.95718700E+00,-.37086794E-01,0.68972774E-03,                &
     &     0.95728800E+00,-.37058557E-01,0.69023751E-03,                &
     &     0.95878500E+00,-.35784004E-01,0.66952880E-03,                &
     &     0.96185100E+00,-.33108007E-01,0.62414454E-03,                &
     &     0.96648500E+00,-.29030736E-01,0.55347105E-03,                &
     &     0.97268800E+00,-.23556955E-01,0.45798312E-03/                
      data ((pk0(l,k, 8),l=1,3),k=166,180)/                             &
     &     0.98045800E+00,-.16680459E-01,0.33540170E-03,                &
     &     0.98979800E+00,-.84135625E-02,0.18878148E-03,                &
     &     0.10007100E+01,0.12484545E-02,0.16020231E-04,                &
     &     0.10131800E+01,0.12310747E-01,-.18421235E-03,                &
     &     0.10272200E+01,0.24762793E-01,-.40958970E-03,                &
     &     0.10428200E+01,0.38616849E-01,-.66323716E-03,                &
     &     0.10599900E+01,0.53861952E-01,-.94418186E-03,                &
     &     0.10787300E+01,0.70498191E-01,-.12502559E-02,                &
     &     0.10990300E+01,0.88524884E-01,-.15826029E-02,                &
     &     0.11209100E+01,0.10793378E+00,-.19400499E-02,                &
     &     0.11443400E+01,0.12874635E+00,-.23266218E-02,                &
     &     0.11693300E+01,0.15095911E+00,-.27419202E-02,                &
     &     0.11959000E+01,0.17454826E+00,-.31816023E-02,                &
     &     0.12240200E+01,0.19953275E+00,-.36480860E-02,                &
     &     0.10000000E+01,-.23134272E-13,-.64878658E-14/                
                                                                        
      rt=1.d0 
      if ((a.le.2.d0).or.(1.d0.le.x)) then 
         ruv=1.d0 
         rdv=1.d0 
         ru=1.d0 
         rd=1.d0 
         rs=1.d0 
         rc=1.d0 
         rb=1.d0 
         rg=1.d0 
         return 
      endif 
      v1= log(a/aa1) 
      v2= log(x/x1) 
      if (x.le.0.6d0) then 
         vtem= log10(0.6d0)+6.d0 
         aindx= aint(( log10(x)+6.d0)/vtem*                             &
     &        149.d0+1.d-7)                                             
         indx=1+ int(aindx) 
         if (indx.lt.2) indx=2 
      else 
         aindx= aint(75.d0*(x-0.6d0)+1.d-7) 
         indx=150+ int(aindx) 
      endif 
      do 33 inum=1,5 
         aqq=q*q 
         nmin=nm(inum) 
         ikpt=kpt(inum) 
         if (aqq.lt.qq0(nmin)) aqq=qq0(nmin) 
         qlq= log(aqq/qq0(nmin)) 
         q1=pk0(1,indx,ikpt)+pk0(2,indx,ikpt)*v1                        &
     &        +pk0(3,indx,ikpt)*v1*v1                                   
         indx=indx+1 
         q2=pk0(1,indx,ikpt)+pk0(2,indx,ikpt)*v1                        &
     &        +pk0(3,indx,ikpt)*v1*v1                                   
         indx=indx-1 
         if (x.le.0.6d0) then 
            xxp=10.d0**(-6.d0+(indx-1)*vtem/149.d0) 
            xxu=10.d0**(-6.d0+(indx)*vtem/149.d0) 
         else 
            xxp=0.6d0+(indx-150)*0.4d0/30.d0 
            xxu=0.6d0+(indx+1-150)*0.4d0/30.d0 
         endif 
         r0=q1+(q2-q1)/(xxp-xxu)*(xxp-x) 
         do 32 jk=1,3 
            indpi=jk 
            do 31 kl=1,10 
               p0=pa(1,kl,indpi,ikpt) 
               p1=pa(2,kl,indpi,ikpt) 
               p2=pa(3,kl,indpi,ikpt) 
               ptm(kl)=p0+p1*v1+p2*v1*v1 
   31       continue 
            pqq(jk)=eksarp(x,v2,x1,x116,ptm,indpi) 
   32    continue 
         r(inum)=r0+pqq(1)*qlq+pqq(2)*qlq*qlq+pqq(3)*dsqrt(qlq) 
         if (inum.eq.2) then 
            do 34 jk=1,3 
               indpi=jk 
               do 35 kl=1,10 
                  p0=pa(1,kl,indpi,5) 
                  p1=pa(2,kl,indpi,5) 
                  p2=pa(3,kl,indpi,5) 
                  ptm(kl)=p0+p1*v1+p2*v1*v1 
   35          continue 
               pqq(jk)=eksarp(x,v2,x1,x116,ptm,indpi) 
   34       continue 
            rs=r0+pqq(1)*qlq+pqq(2)*qlq*qlq+pqq(3)*dsqrt(qlq) 
         endif 
   33 continue 
      ruv=r(1) 
      rdv=ruv 
      ru=r(2) 
      rd=ru 
      rc=r(3) 
      rb=r(4) 
      rg=r(5) 
                                                                        
      return 
      END                                           
