; AVX testcases from gas
;------------------------

;
; This file is taken from there
;     http://sourceware.org/ml/binutils/2011-06/msg00150.html
; So the original author is "H.J. Lu" <hongjiu dot lu at intel dot com>
;
; nasm64developer adopted it for the nasm testing suite

%macro testcase 2
 %ifdef BIN
  db %1
 %endif
 %ifdef SRC
  %2
 %endif
%endmacro

bits 32

; b/gas/testsuite/gas/i386/avx-gather-intel.d
testcase	{ 0xc4, 0xe2, 0xe9, 0x92, 0x4c, 0x7d, 0x00			}, { vgatherdpd xmm1,QWORD [ebp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0xe9, 0x93, 0x4c, 0x7d, 0x00			}, { vgatherqpd xmm1,QWORD [ebp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0xed, 0x92, 0x4c, 0x7d, 0x00			}, { vgatherdpd ymm1,QWORD [ebp+xmm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0xe2, 0xed, 0x93, 0x4c, 0x7d, 0x00			}, { vgatherqpd ymm1,QWORD [ebp+ymm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0x25, 0x08, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*1+0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0x25, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdpd ymm6,QWORD [xmm4*1-0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0x25, 0x00, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*1+0x0],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0x25, 0x98, 0x02, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*1+0x298],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0xe5, 0x08, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*8+0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0xe5, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdpd ymm6,QWORD [xmm4*8-0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0xe5, 0x00, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*8+0x0],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0xe5, 0x98, 0x02, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*8+0x298],ymm5		}
testcase	{ 0xc4, 0xe2, 0x69, 0x92, 0x4c, 0x7d, 0x00			}, { vgatherdps xmm1,DWORD [ebp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0x69, 0x93, 0x4c, 0x7d, 0x00			}, { vgatherqps xmm1,DWORD [ebp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0x6d, 0x92, 0x4c, 0x7d, 0x00			}, { vgatherdps ymm1,DWORD [ebp+ymm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0xe2, 0x6d, 0x93, 0x4c, 0x7d, 0x00			}, { vgatherqps xmm1,DWORD [ebp+ymm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0x25, 0x08, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*1+0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0x25, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdps xmm6,DWORD [xmm4*1-0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0x25, 0x00, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*1+0x0],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0x25, 0x98, 0x02, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*1+0x298],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0xe5, 0x08, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*8+0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0xe5, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdps xmm6,DWORD [xmm4*8-0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0xe5, 0x00, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*8+0x0],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0xe5, 0x98, 0x02, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*8+0x298],xmm5		}
testcase	{ 0xc4, 0xe2, 0x69, 0x90, 0x4c, 0x7d, 0x00			}, { vpgatherdd xmm1,DWORD [ebp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0x69, 0x91, 0x4c, 0x7d, 0x00			}, { vpgatherqd xmm1,DWORD [ebp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0x6d, 0x90, 0x4c, 0x7d, 0x00			}, { vpgatherdd ymm1,DWORD [ebp+ymm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0xe2, 0x6d, 0x91, 0x4c, 0x7d, 0x00			}, { vpgatherqd xmm1,DWORD [ebp+ymm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0x25, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*1+0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0x25, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdd xmm6,DWORD [xmm4*1-0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0x25, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*1+0x0],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0x25, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*1+0x298],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0xe5, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*8+0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0xe5, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdd xmm6,DWORD [xmm4*8-0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0xe5, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*8+0x0],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0xe5, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*8+0x298],xmm5		}
testcase	{ 0xc4, 0xe2, 0xe9, 0x90, 0x4c, 0x7d, 0x00			}, { vpgatherdq xmm1,QWORD [ebp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0xe9, 0x91, 0x4c, 0x7d, 0x00			}, { vpgatherqq xmm1,QWORD [ebp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0xed, 0x90, 0x4c, 0x7d, 0x00			}, { vpgatherdq ymm1,QWORD [ebp+xmm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0xe2, 0xed, 0x91, 0x4c, 0x7d, 0x00			}, { vpgatherqq ymm1,QWORD [ebp+ymm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0x25, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*1+0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0x25, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdq ymm6,QWORD [xmm4*1-0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0x25, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*1+0x0],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0x25, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*1+0x298],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0xe5, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*8+0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0xe5, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdq ymm6,QWORD [xmm4*8-0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0xe5, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*8+0x0],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0xe5, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*8+0x298],ymm5		}

; b/gas/testsuite/gas/i386/avx2-intel.d
testcase	{ 0xc4, 0xe2, 0x5d, 0x8c, 0x31					}, { vpmaskmovd ymm6,ymm4,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x8e, 0x21					}, { vpmaskmovd YWORD [ecx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe2, 0xdd, 0x8c, 0x31					}, { vpmaskmovq ymm6,ymm4,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x8e, 0x21					}, { vpmaskmovq YWORD [ecx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x01, 0xd6, 0x07				}, { vpermpd ymm2,ymm6,0x7				}
testcase	{ 0xc4, 0xe3, 0xfd, 0x01, 0x31, 0x07				}, { vpermpd ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x00, 0xd6, 0x07				}, { vpermq ymm2,ymm6,0x7				}
testcase	{ 0xc4, 0xe3, 0xfd, 0x00, 0x31, 0x07				}, { vpermq ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x36, 0xd4					}, { vpermd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x36, 0x11					}, { vpermd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x16, 0xd4					}, { vpermps ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x16, 0x11					}, { vpermps ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x47, 0xd4					}, { vpsllvd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x47, 0x11					}, { vpsllvd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x47, 0xd4					}, { vpsllvq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0xcd, 0x47, 0x11					}, { vpsllvq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x46, 0xd4					}, { vpsravd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x46, 0x11					}, { vpsravd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x45, 0xd4					}, { vpsrlvd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x45, 0x11					}, { vpsrlvd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x45, 0xd4					}, { vpsrlvq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0xcd, 0x45, 0x11					}, { vpsrlvq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x2a, 0x21					}, { vmovntdqa ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x19, 0xf4					}, { vbroadcastsd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x18, 0xf4					}, { vbroadcastss ymm6,xmm4				}
testcase	{ 0xc4, 0xe3, 0x4d, 0x02, 0xd4, 0x07				}, { vpblendd ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x02, 0x11, 0x07				}, { vpblendd ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x46, 0xd4, 0x07				}, { vperm2i128 ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x46, 0x11, 0x07				}, { vperm2i128 ymm2,ymm6,YWORD [ecx],0x7		}
testcase	{ 0xc4, 0xe3, 0x5d, 0x38, 0xf4, 0x07				}, { vinserti128 ymm6,ymm4,xmm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x5d, 0x38, 0x31, 0x07				}, { vinserti128 ymm6,ymm4,OWORD [ecx],0x7		}
testcase	{ 0xc4, 0xe2, 0x7d, 0x5a, 0x21					}, { vbroadcasti128 ymm4,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x47, 0xd4					}, { vpsllvd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x47, 0x39					}, { vpsllvd xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x47, 0xd4					}, { vpsllvq xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0xc9, 0x47, 0x39					}, { vpsllvq xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x46, 0xd4					}, { vpsravd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x46, 0x39					}, { vpsravd xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x45, 0xd4					}, { vpsrlvd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x45, 0x39					}, { vpsrlvd xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x45, 0xd4					}, { vpsrlvq xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0xc9, 0x45, 0x39					}, { vpsrlvq xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x59, 0x8c, 0x31					}, { vpmaskmovd xmm6,xmm4,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xd9, 0x8c, 0x31					}, { vpmaskmovq xmm6,xmm4,OWORD [ecx]			}
testcase	{ 0xc4, 0xe3, 0x7d, 0x39, 0xe6, 0x07				}, { vextracti128 xmm6,ymm4,0x7				}
testcase	{ 0xc4, 0xe3, 0x7d, 0x39, 0x21, 0x07				}, { vextracti128 OWORD [ecx],ymm4,0x7			}
testcase	{ 0xc4, 0xe2, 0x49, 0x8e, 0x21					}, { vpmaskmovd OWORD [ecx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x8e, 0x21					}, { vpmaskmovq OWORD [ecx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe3, 0x49, 0x02, 0xd4, 0x07				}, { vpblendd xmm2,xmm6,xmm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x49, 0x02, 0x11, 0x07				}, { vpblendd xmm2,xmm6,OWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe2, 0x79, 0x59, 0xf4					}, { vpbroadcastq xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x59, 0x21					}, { vpbroadcastq xmm4,QWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x59, 0xf4					}, { vpbroadcastq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x59, 0x21					}, { vpbroadcastq ymm4,QWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x58, 0xe4					}, { vpbroadcastd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x58, 0x21					}, { vpbroadcastd ymm4,DWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x58, 0xf4					}, { vpbroadcastd xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x58, 0x21					}, { vpbroadcastd xmm4,DWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x79, 0xf4					}, { vpbroadcastw xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x79, 0x21					}, { vpbroadcastw xmm4,WORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x79, 0xf4					}, { vpbroadcastw ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x79, 0x21					}, { vpbroadcastw ymm4,WORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x78, 0xf4					}, { vpbroadcastb xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x78, 0x21					}, { vpbroadcastb xmm4,BYTE [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x78, 0xf4					}, { vpbroadcastb ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x78, 0x21					}, { vpbroadcastb ymm4,BYTE [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x18, 0xf4					}, { vbroadcastss xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x5d, 0x8c, 0x31					}, { vpmaskmovd ymm6,ymm4,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x8e, 0x21					}, { vpmaskmovd YWORD [ecx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe2, 0x5d, 0x8c, 0x31					}, { vpmaskmovd ymm6,ymm4,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x8e, 0x21					}, { vpmaskmovd YWORD [ecx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe2, 0xdd, 0x8c, 0x31					}, { vpmaskmovq ymm6,ymm4,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x8e, 0x21					}, { vpmaskmovq YWORD [ecx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe2, 0xdd, 0x8c, 0x31					}, { vpmaskmovq ymm6,ymm4,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x8e, 0x21					}, { vpmaskmovq YWORD [ecx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x01, 0xd6, 0x07				}, { vpermpd ymm2,ymm6,0x7				}
testcase	{ 0xc4, 0xe3, 0xfd, 0x01, 0x31, 0x07				}, { vpermpd ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x01, 0x31, 0x07				}, { vpermpd ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x00, 0xd6, 0x07				}, { vpermq ymm2,ymm6,0x7				}
testcase	{ 0xc4, 0xe3, 0xfd, 0x00, 0x31, 0x07				}, { vpermq ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x00, 0x31, 0x07				}, { vpermq ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x36, 0xd4					}, { vpermd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x36, 0x11					}, { vpermd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x36, 0x11					}, { vpermd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x16, 0xd4					}, { vpermps ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x16, 0x11					}, { vpermps ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x16, 0x11					}, { vpermps ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x47, 0xd4					}, { vpsllvd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x47, 0x11					}, { vpsllvd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x47, 0x11					}, { vpsllvd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x47, 0xd4					}, { vpsllvq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0xcd, 0x47, 0x11					}, { vpsllvq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x47, 0x11					}, { vpsllvq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x46, 0xd4					}, { vpsravd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x46, 0x11					}, { vpsravd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x46, 0x11					}, { vpsravd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x45, 0xd4					}, { vpsrlvd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x45, 0x11					}, { vpsrlvd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x45, 0x11					}, { vpsrlvd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x45, 0xd4					}, { vpsrlvq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0xcd, 0x45, 0x11					}, { vpsrlvq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x45, 0x11					}, { vpsrlvq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x2a, 0x21					}, { vmovntdqa ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x2a, 0x21					}, { vmovntdqa ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x19, 0xf4					}, { vbroadcastsd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x18, 0xf4					}, { vbroadcastss ymm6,xmm4				}
testcase	{ 0xc4, 0xe3, 0x4d, 0x02, 0xd4, 0x07				}, { vpblendd ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x02, 0x11, 0x07				}, { vpblendd ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x02, 0x11, 0x07				}, { vpblendd ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x46, 0xd4, 0x07				}, { vperm2i128 ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x46, 0x11, 0x07				}, { vperm2i128 ymm2,ymm6,YWORD [ecx],0x7		}
testcase	{ 0xc4, 0xe3, 0x4d, 0x46, 0x11, 0x07				}, { vperm2i128 ymm2,ymm6,YWORD [ecx],0x7		}
testcase	{ 0xc4, 0xe3, 0x5d, 0x38, 0xf4, 0x07				}, { vinserti128 ymm6,ymm4,xmm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x5d, 0x38, 0x31, 0x07				}, { vinserti128 ymm6,ymm4,OWORD [ecx],0x7		}
testcase	{ 0xc4, 0xe3, 0x5d, 0x38, 0x31, 0x07				}, { vinserti128 ymm6,ymm4,OWORD [ecx],0x7		}
testcase	{ 0xc4, 0xe2, 0x7d, 0x5a, 0x21					}, { vbroadcasti128 ymm4,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x5a, 0x21					}, { vbroadcasti128 ymm4,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x47, 0xd4					}, { vpsllvd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x47, 0x39					}, { vpsllvd xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x47, 0x39					}, { vpsllvd xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x47, 0xd4					}, { vpsllvq xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0xc9, 0x47, 0x39					}, { vpsllvq xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x47, 0x39					}, { vpsllvq xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x46, 0xd4					}, { vpsravd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x46, 0x39					}, { vpsravd xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x46, 0x39					}, { vpsravd xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x45, 0xd4					}, { vpsrlvd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x45, 0x39					}, { vpsrlvd xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x45, 0x39					}, { vpsrlvd xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x45, 0xd4					}, { vpsrlvq xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0xc9, 0x45, 0x39					}, { vpsrlvq xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x45, 0x39					}, { vpsrlvq xmm7,xmm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x59, 0x8c, 0x31					}, { vpmaskmovd xmm6,xmm4,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x59, 0x8c, 0x31					}, { vpmaskmovd xmm6,xmm4,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xd9, 0x8c, 0x31					}, { vpmaskmovq xmm6,xmm4,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0xd9, 0x8c, 0x31					}, { vpmaskmovq xmm6,xmm4,OWORD [ecx]			}
testcase	{ 0xc4, 0xe3, 0x7d, 0x39, 0xe6, 0x07				}, { vextracti128 xmm6,ymm4,0x7				}
testcase	{ 0xc4, 0xe3, 0x7d, 0x39, 0x21, 0x07				}, { vextracti128 OWORD [ecx],ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x7d, 0x39, 0x21, 0x07				}, { vextracti128 OWORD [ecx],ymm4,0x7			}
testcase	{ 0xc4, 0xe2, 0x49, 0x8e, 0x21					}, { vpmaskmovd OWORD [ecx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe2, 0x49, 0x8e, 0x21					}, { vpmaskmovd OWORD [ecx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x8e, 0x21					}, { vpmaskmovq OWORD [ecx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x8e, 0x21					}, { vpmaskmovq OWORD [ecx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe3, 0x49, 0x02, 0xd4, 0x07				}, { vpblendd xmm2,xmm6,xmm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x49, 0x02, 0x11, 0x07				}, { vpblendd xmm2,xmm6,OWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x49, 0x02, 0x11, 0x07				}, { vpblendd xmm2,xmm6,OWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe2, 0x79, 0x59, 0xf4					}, { vpbroadcastq xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x59, 0x21					}, { vpbroadcastq xmm4,QWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x59, 0x21					}, { vpbroadcastq xmm4,QWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x59, 0xf4					}, { vpbroadcastq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x59, 0x21					}, { vpbroadcastq ymm4,QWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x59, 0x21					}, { vpbroadcastq ymm4,QWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x58, 0xe4					}, { vpbroadcastd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x58, 0x21					}, { vpbroadcastd ymm4,DWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x58, 0x21					}, { vpbroadcastd ymm4,DWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x58, 0xf4					}, { vpbroadcastd xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x58, 0x21					}, { vpbroadcastd xmm4,DWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x58, 0x21					}, { vpbroadcastd xmm4,DWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x79, 0xf4					}, { vpbroadcastw xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x79, 0x21					}, { vpbroadcastw xmm4,WORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x79, 0x21					}, { vpbroadcastw xmm4,WORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x79, 0xf4					}, { vpbroadcastw ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x79, 0x21					}, { vpbroadcastw ymm4,WORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x79, 0x21					}, { vpbroadcastw ymm4,WORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x78, 0xf4					}, { vpbroadcastb xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x78, 0x21					}, { vpbroadcastb xmm4,BYTE [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x78, 0x21					}, { vpbroadcastb xmm4,BYTE [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x78, 0xf4					}, { vpbroadcastb ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x78, 0x21					}, { vpbroadcastb ymm4,BYTE [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x78, 0x21					}, { vpbroadcastb ymm4,BYTE [ecx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x18, 0xf4					}, { vbroadcastss xmm6,xmm4				}

; b/gas/testsuite/gas/i386/avx256int-intel.d
testcase	{ 0xc5, 0xfd, 0xd7, 0xcc					}, { vpmovmskb ecx,ymm4					}
testcase	{ 0xc5, 0xed, 0x72, 0xf6, 0x07					}, { vpslld ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xfe, 0x07					}, { vpslldq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xf6, 0x07					}, { vpsllq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xf6, 0x07					}, { vpsllw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x72, 0xe6, 0x07					}, { vpsrad ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xe6, 0x07					}, { vpsraw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x72, 0xd6, 0x07					}, { vpsrld ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xde, 0x07					}, { vpsrldq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xd6, 0x07					}, { vpsrlq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xd6, 0x07					}, { vpsrlw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfd, 0x70, 0xd6, 0x07					}, { vpshufd ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfd, 0x70, 0x31, 0x07					}, { vpshufd ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc5, 0xfe, 0x70, 0xd6, 0x07					}, { vpshufhw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfe, 0x70, 0x31, 0x07					}, { vpshufhw ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc5, 0xff, 0x70, 0xd6, 0x07					}, { vpshuflw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xff, 0x70, 0x31, 0x07					}, { vpshuflw ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc5, 0xcd, 0x6b, 0xd4					}, { vpackssdw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6b, 0x11					}, { vpackssdw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x63, 0xd4					}, { vpacksswb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x63, 0x11					}, { vpacksswb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x2b, 0xd4					}, { vpackusdw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x2b, 0x11					}, { vpackusdw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x67, 0xd4					}, { vpackuswb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x67, 0x11					}, { vpackuswb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfc, 0xd4					}, { vpaddb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfc, 0x11					}, { vpaddb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfd, 0xd4					}, { vpaddw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfd, 0x11					}, { vpaddw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfe, 0xd4					}, { vpaddd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfe, 0x11					}, { vpaddd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd4, 0xd4					}, { vpaddq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd4, 0x11					}, { vpaddq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xec, 0xd4					}, { vpaddsb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xec, 0x11					}, { vpaddsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xed, 0xd4					}, { vpaddsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xed, 0x11					}, { vpaddsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdc, 0xd4					}, { vpaddusb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdc, 0x11					}, { vpaddusb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdd, 0xd4					}, { vpaddusw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdd, 0x11					}, { vpaddusw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdb, 0xd4					}, { vpand ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdb, 0x11					}, { vpand ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdf, 0xd4					}, { vpandn ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdf, 0x11					}, { vpandn ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe0, 0xd4					}, { vpavgb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe0, 0x11					}, { vpavgb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe3, 0xd4					}, { vpavgw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe3, 0x11					}, { vpavgw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x74, 0xd4					}, { vpcmpeqb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x74, 0x11					}, { vpcmpeqb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x75, 0xd4					}, { vpcmpeqw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x75, 0x11					}, { vpcmpeqw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x76, 0xd4					}, { vpcmpeqd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x76, 0x11					}, { vpcmpeqd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x29, 0xd4					}, { vpcmpeqq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x29, 0x11					}, { vpcmpeqq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x64, 0xd4					}, { vpcmpgtb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x64, 0x11					}, { vpcmpgtb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x65, 0xd4					}, { vpcmpgtw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x65, 0x11					}, { vpcmpgtw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x66, 0xd4					}, { vpcmpgtd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x66, 0x11					}, { vpcmpgtd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x37, 0xd4					}, { vpcmpgtq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x37, 0x11					}, { vpcmpgtq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x01, 0xd4					}, { vphaddw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x01, 0x11					}, { vphaddw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x02, 0xd4					}, { vphaddd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x02, 0x11					}, { vphaddd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x03, 0xd4					}, { vphaddsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x03, 0x11					}, { vphaddsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x05, 0xd4					}, { vphsubw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x05, 0x11					}, { vphsubw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x06, 0xd4					}, { vphsubd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x06, 0x11					}, { vphsubd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x07, 0xd4					}, { vphsubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x07, 0x11					}, { vphsubsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf5, 0xd4					}, { vpmaddwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf5, 0x11					}, { vpmaddwd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x04, 0xd4					}, { vpmaddubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x04, 0x11					}, { vpmaddubsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3c, 0xd4					}, { vpmaxsb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3c, 0x11					}, { vpmaxsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xee, 0xd4					}, { vpmaxsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xee, 0x11					}, { vpmaxsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3d, 0xd4					}, { vpmaxsd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3d, 0x11					}, { vpmaxsd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xde, 0xd4					}, { vpmaxub ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xde, 0x11					}, { vpmaxub ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3e, 0xd4					}, { vpmaxuw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3e, 0x11					}, { vpmaxuw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3f, 0xd4					}, { vpmaxud ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3f, 0x11					}, { vpmaxud ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x38, 0xd4					}, { vpminsb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x38, 0x11					}, { vpminsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xea, 0xd4					}, { vpminsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xea, 0x11					}, { vpminsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x39, 0xd4					}, { vpminsd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x39, 0x11					}, { vpminsd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xda, 0xd4					}, { vpminub ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xda, 0x11					}, { vpminub ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3a, 0xd4					}, { vpminuw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3a, 0x11					}, { vpminuw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3b, 0xd4					}, { vpminud ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3b, 0x11					}, { vpminud ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe4, 0xd4					}, { vpmulhuw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe4, 0x11					}, { vpmulhuw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0b, 0xd4					}, { vpmulhrsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0b, 0x11					}, { vpmulhrsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe5, 0xd4					}, { vpmulhw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe5, 0x11					}, { vpmulhw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd5, 0xd4					}, { vpmullw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd5, 0x11					}, { vpmullw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x40, 0xd4					}, { vpmulld ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x40, 0x11					}, { vpmulld ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf4, 0xd4					}, { vpmuludq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf4, 0x11					}, { vpmuludq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x28, 0xd4					}, { vpmuldq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x28, 0x11					}, { vpmuldq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xeb, 0xd4					}, { vpor ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xeb, 0x11					}, { vpor ymm2,ymm6,YWORD [ecx]				}
testcase	{ 0xc5, 0xcd, 0xf6, 0xd4					}, { vpsadbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf6, 0x11					}, { vpsadbw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x00, 0xd4					}, { vpshufb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x00, 0x11					}, { vpshufb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x08, 0xd4					}, { vpsignb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x08, 0x11					}, { vpsignb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x09, 0xd4					}, { vpsignw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x09, 0x11					}, { vpsignw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0a, 0xd4					}, { vpsignd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0a, 0x11					}, { vpsignd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf8, 0xd4					}, { vpsubb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf8, 0x11					}, { vpsubb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf9, 0xd4					}, { vpsubw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf9, 0x11					}, { vpsubw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfa, 0xd4					}, { vpsubd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfa, 0x11					}, { vpsubd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfb, 0xd4					}, { vpsubq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfb, 0x11					}, { vpsubq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe8, 0xd4					}, { vpsubsb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe8, 0x11					}, { vpsubsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe9, 0xd4					}, { vpsubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe9, 0x11					}, { vpsubsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd8, 0xd4					}, { vpsubusb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd8, 0x11					}, { vpsubusb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd9, 0xd4					}, { vpsubusw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd9, 0x11					}, { vpsubusw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x68, 0xd4					}, { vpunpckhbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x68, 0x11					}, { vpunpckhbw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x69, 0xd4					}, { vpunpckhwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x69, 0x11					}, { vpunpckhwd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x6a, 0xd4					}, { vpunpckhdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6a, 0x11					}, { vpunpckhdq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x6d, 0xd4					}, { vpunpckhqdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6d, 0x11					}, { vpunpckhqdq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x60, 0xd4					}, { vpunpcklbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x60, 0x11					}, { vpunpcklbw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x61, 0xd4					}, { vpunpcklwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x61, 0x11					}, { vpunpcklwd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x62, 0xd4					}, { vpunpckldq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x62, 0x11					}, { vpunpckldq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x6c, 0xd4					}, { vpunpcklqdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6c, 0x11					}, { vpunpcklqdq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xef, 0xd4					}, { vpxor ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xef, 0x11					}, { vpxor ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1c, 0xf4					}, { vpabsb ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1c, 0x21					}, { vpabsb ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1d, 0xf4					}, { vpabsw ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1d, 0x21					}, { vpabsw ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1e, 0xf4					}, { vpabsd ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1e, 0x21					}, { vpabsd ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe3, 0x4d, 0x42, 0xd4, 0x07				}, { vmpsadbw ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x42, 0x11, 0x07				}, { vmpsadbw ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0f, 0xd4, 0x07				}, { vpalignr ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0f, 0x11, 0x07				}, { vpalignr ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0e, 0xd4, 0x07				}, { vpblendw ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0e, 0x11, 0x07				}, { vpblendw ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x6d, 0x4c, 0xfe, 0x40				}, { vpblendvb ymm7,ymm2,ymm6,ymm4			}
testcase	{ 0xc4, 0xe3, 0x6d, 0x4c, 0x39, 0x40				}, { vpblendvb ymm7,ymm2,YWORD [ecx],ymm4		}
testcase	{ 0xc5, 0xcd, 0xf1, 0xd4					}, { vpsllw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf1, 0x11					}, { vpsllw ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf2, 0xd4					}, { vpslld ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf2, 0x11					}, { vpslld ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf3, 0xd4					}, { vpsllq ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf3, 0x11					}, { vpsllq ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe1, 0xd4					}, { vpsraw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xe1, 0x11					}, { vpsraw ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe2, 0xd4					}, { vpsrad ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xe2, 0x11					}, { vpsrad ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd1, 0xd4					}, { vpsrlw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd1, 0x11					}, { vpsrlw ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd2, 0xd4					}, { vpsrld ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd2, 0x11					}, { vpsrld ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd3, 0xd4					}, { vpsrlq ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd3, 0x11					}, { vpsrlq ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x20, 0xe4					}, { vpmovsxbw ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x20, 0x21					}, { vpmovsxbw ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x23, 0xe4					}, { vpmovsxwd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x23, 0x21					}, { vpmovsxwd ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x25, 0xe4					}, { vpmovsxdq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x25, 0x21					}, { vpmovsxdq ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x30, 0xe4					}, { vpmovzxbw ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x30, 0x21					}, { vpmovzxbw ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x33, 0xe4					}, { vpmovzxwd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x33, 0x21					}, { vpmovzxwd ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x35, 0xe4					}, { vpmovzxdq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x35, 0x21					}, { vpmovzxdq ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x21, 0xf4					}, { vpmovsxbd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x21, 0x21					}, { vpmovsxbd ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x24, 0xf4					}, { vpmovsxwq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x24, 0x21					}, { vpmovsxwq ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x31, 0xf4					}, { vpmovzxbd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x31, 0x21					}, { vpmovzxbd ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x34, 0xf4					}, { vpmovzxwq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x34, 0x21					}, { vpmovzxwq ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x22, 0xe4					}, { vpmovsxbq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x22, 0x21					}, { vpmovsxbq ymm4,DWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x32, 0xe4					}, { vpmovzxbq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x32, 0x21					}, { vpmovzxbq ymm4,DWORD [ecx]				}
testcase	{ 0xc5, 0xfd, 0xd7, 0xcc					}, { vpmovmskb ecx,ymm4					}
testcase	{ 0xc5, 0xed, 0x72, 0xf6, 0x07					}, { vpslld ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xfe, 0x07					}, { vpslldq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xf6, 0x07					}, { vpsllq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xf6, 0x07					}, { vpsllw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x72, 0xe6, 0x07					}, { vpsrad ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xe6, 0x07					}, { vpsraw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x72, 0xd6, 0x07					}, { vpsrld ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xde, 0x07					}, { vpsrldq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xd6, 0x07					}, { vpsrlq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xd6, 0x07					}, { vpsrlw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfd, 0x70, 0xd6, 0x07					}, { vpshufd ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfd, 0x70, 0x31, 0x07					}, { vpshufd ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc5, 0xfd, 0x70, 0x31, 0x07					}, { vpshufd ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc5, 0xfe, 0x70, 0xd6, 0x07					}, { vpshufhw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfe, 0x70, 0x31, 0x07					}, { vpshufhw ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc5, 0xfe, 0x70, 0x31, 0x07					}, { vpshufhw ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc5, 0xff, 0x70, 0xd6, 0x07					}, { vpshuflw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xff, 0x70, 0x31, 0x07					}, { vpshuflw ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc5, 0xff, 0x70, 0x31, 0x07					}, { vpshuflw ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc5, 0xcd, 0x6b, 0xd4					}, { vpackssdw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6b, 0x11					}, { vpackssdw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x6b, 0x11					}, { vpackssdw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x63, 0xd4					}, { vpacksswb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x63, 0x11					}, { vpacksswb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x63, 0x11					}, { vpacksswb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x2b, 0xd4					}, { vpackusdw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x2b, 0x11					}, { vpackusdw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x2b, 0x11					}, { vpackusdw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x67, 0xd4					}, { vpackuswb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x67, 0x11					}, { vpackuswb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x67, 0x11					}, { vpackuswb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfc, 0xd4					}, { vpaddb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfc, 0x11					}, { vpaddb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfc, 0x11					}, { vpaddb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfd, 0xd4					}, { vpaddw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfd, 0x11					}, { vpaddw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfd, 0x11					}, { vpaddw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfe, 0xd4					}, { vpaddd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfe, 0x11					}, { vpaddd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfe, 0x11					}, { vpaddd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd4, 0xd4					}, { vpaddq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd4, 0x11					}, { vpaddq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd4, 0x11					}, { vpaddq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xec, 0xd4					}, { vpaddsb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xec, 0x11					}, { vpaddsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xec, 0x11					}, { vpaddsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xed, 0xd4					}, { vpaddsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xed, 0x11					}, { vpaddsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xed, 0x11					}, { vpaddsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdc, 0xd4					}, { vpaddusb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdc, 0x11					}, { vpaddusb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdc, 0x11					}, { vpaddusb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdd, 0xd4					}, { vpaddusw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdd, 0x11					}, { vpaddusw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdd, 0x11					}, { vpaddusw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdb, 0xd4					}, { vpand ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdb, 0x11					}, { vpand ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdb, 0x11					}, { vpand ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdf, 0xd4					}, { vpandn ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdf, 0x11					}, { vpandn ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xdf, 0x11					}, { vpandn ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe0, 0xd4					}, { vpavgb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe0, 0x11					}, { vpavgb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe0, 0x11					}, { vpavgb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe3, 0xd4					}, { vpavgw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe3, 0x11					}, { vpavgw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe3, 0x11					}, { vpavgw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x74, 0xd4					}, { vpcmpeqb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x74, 0x11					}, { vpcmpeqb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x74, 0x11					}, { vpcmpeqb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x75, 0xd4					}, { vpcmpeqw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x75, 0x11					}, { vpcmpeqw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x75, 0x11					}, { vpcmpeqw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x76, 0xd4					}, { vpcmpeqd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x76, 0x11					}, { vpcmpeqd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x76, 0x11					}, { vpcmpeqd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x29, 0xd4					}, { vpcmpeqq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x29, 0x11					}, { vpcmpeqq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x29, 0x11					}, { vpcmpeqq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x64, 0xd4					}, { vpcmpgtb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x64, 0x11					}, { vpcmpgtb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x64, 0x11					}, { vpcmpgtb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x65, 0xd4					}, { vpcmpgtw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x65, 0x11					}, { vpcmpgtw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x65, 0x11					}, { vpcmpgtw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x66, 0xd4					}, { vpcmpgtd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x66, 0x11					}, { vpcmpgtd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x66, 0x11					}, { vpcmpgtd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x37, 0xd4					}, { vpcmpgtq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x37, 0x11					}, { vpcmpgtq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x37, 0x11					}, { vpcmpgtq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x01, 0xd4					}, { vphaddw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x01, 0x11					}, { vphaddw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x01, 0x11					}, { vphaddw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x02, 0xd4					}, { vphaddd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x02, 0x11					}, { vphaddd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x02, 0x11					}, { vphaddd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x03, 0xd4					}, { vphaddsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x03, 0x11					}, { vphaddsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x03, 0x11					}, { vphaddsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x05, 0xd4					}, { vphsubw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x05, 0x11					}, { vphsubw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x05, 0x11					}, { vphsubw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x06, 0xd4					}, { vphsubd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x06, 0x11					}, { vphsubd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x06, 0x11					}, { vphsubd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x07, 0xd4					}, { vphsubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x07, 0x11					}, { vphsubsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x07, 0x11					}, { vphsubsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf5, 0xd4					}, { vpmaddwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf5, 0x11					}, { vpmaddwd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf5, 0x11					}, { vpmaddwd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x04, 0xd4					}, { vpmaddubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x04, 0x11					}, { vpmaddubsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x04, 0x11					}, { vpmaddubsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3c, 0xd4					}, { vpmaxsb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3c, 0x11					}, { vpmaxsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3c, 0x11					}, { vpmaxsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xee, 0xd4					}, { vpmaxsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xee, 0x11					}, { vpmaxsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xee, 0x11					}, { vpmaxsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3d, 0xd4					}, { vpmaxsd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3d, 0x11					}, { vpmaxsd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3d, 0x11					}, { vpmaxsd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xde, 0xd4					}, { vpmaxub ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xde, 0x11					}, { vpmaxub ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xde, 0x11					}, { vpmaxub ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3e, 0xd4					}, { vpmaxuw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3e, 0x11					}, { vpmaxuw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3e, 0x11					}, { vpmaxuw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3f, 0xd4					}, { vpmaxud ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3f, 0x11					}, { vpmaxud ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3f, 0x11					}, { vpmaxud ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x38, 0xd4					}, { vpminsb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x38, 0x11					}, { vpminsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x38, 0x11					}, { vpminsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xea, 0xd4					}, { vpminsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xea, 0x11					}, { vpminsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xea, 0x11					}, { vpminsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x39, 0xd4					}, { vpminsd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x39, 0x11					}, { vpminsd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x39, 0x11					}, { vpminsd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xda, 0xd4					}, { vpminub ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xda, 0x11					}, { vpminub ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xda, 0x11					}, { vpminub ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3a, 0xd4					}, { vpminuw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3a, 0x11					}, { vpminuw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3a, 0x11					}, { vpminuw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3b, 0xd4					}, { vpminud ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3b, 0x11					}, { vpminud ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3b, 0x11					}, { vpminud ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe4, 0xd4					}, { vpmulhuw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe4, 0x11					}, { vpmulhuw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe4, 0x11					}, { vpmulhuw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0b, 0xd4					}, { vpmulhrsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0b, 0x11					}, { vpmulhrsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0b, 0x11					}, { vpmulhrsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe5, 0xd4					}, { vpmulhw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe5, 0x11					}, { vpmulhw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe5, 0x11					}, { vpmulhw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd5, 0xd4					}, { vpmullw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd5, 0x11					}, { vpmullw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd5, 0x11					}, { vpmullw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x40, 0xd4					}, { vpmulld ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x40, 0x11					}, { vpmulld ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x40, 0x11					}, { vpmulld ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf4, 0xd4					}, { vpmuludq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf4, 0x11					}, { vpmuludq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf4, 0x11					}, { vpmuludq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x28, 0xd4					}, { vpmuldq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x28, 0x11					}, { vpmuldq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x28, 0x11					}, { vpmuldq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xeb, 0xd4					}, { vpor ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xeb, 0x11					}, { vpor ymm2,ymm6,YWORD [ecx]				}
testcase	{ 0xc5, 0xcd, 0xeb, 0x11					}, { vpor ymm2,ymm6,YWORD [ecx]				}
testcase	{ 0xc5, 0xcd, 0xf6, 0xd4					}, { vpsadbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf6, 0x11					}, { vpsadbw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf6, 0x11					}, { vpsadbw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x00, 0xd4					}, { vpshufb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x00, 0x11					}, { vpshufb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x00, 0x11					}, { vpshufb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x08, 0xd4					}, { vpsignb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x08, 0x11					}, { vpsignb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x08, 0x11					}, { vpsignb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x09, 0xd4					}, { vpsignw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x09, 0x11					}, { vpsignw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x09, 0x11					}, { vpsignw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0a, 0xd4					}, { vpsignd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0a, 0x11					}, { vpsignd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0a, 0x11					}, { vpsignd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf8, 0xd4					}, { vpsubb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf8, 0x11					}, { vpsubb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf8, 0x11					}, { vpsubb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf9, 0xd4					}, { vpsubw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf9, 0x11					}, { vpsubw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf9, 0x11					}, { vpsubw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfa, 0xd4					}, { vpsubd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfa, 0x11					}, { vpsubd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfa, 0x11					}, { vpsubd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfb, 0xd4					}, { vpsubq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfb, 0x11					}, { vpsubq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xfb, 0x11					}, { vpsubq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe8, 0xd4					}, { vpsubsb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe8, 0x11					}, { vpsubsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe8, 0x11					}, { vpsubsb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe9, 0xd4					}, { vpsubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe9, 0x11					}, { vpsubsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe9, 0x11					}, { vpsubsw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd8, 0xd4					}, { vpsubusb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd8, 0x11					}, { vpsubusb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd8, 0x11					}, { vpsubusb ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd9, 0xd4					}, { vpsubusw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd9, 0x11					}, { vpsubusw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd9, 0x11					}, { vpsubusw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x68, 0xd4					}, { vpunpckhbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x68, 0x11					}, { vpunpckhbw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x68, 0x11					}, { vpunpckhbw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x69, 0xd4					}, { vpunpckhwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x69, 0x11					}, { vpunpckhwd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x69, 0x11					}, { vpunpckhwd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x6a, 0xd4					}, { vpunpckhdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6a, 0x11					}, { vpunpckhdq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x6a, 0x11					}, { vpunpckhdq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x6d, 0xd4					}, { vpunpckhqdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6d, 0x11					}, { vpunpckhqdq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x6d, 0x11					}, { vpunpckhqdq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x60, 0xd4					}, { vpunpcklbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x60, 0x11					}, { vpunpcklbw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x60, 0x11					}, { vpunpcklbw ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x61, 0xd4					}, { vpunpcklwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x61, 0x11					}, { vpunpcklwd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x61, 0x11					}, { vpunpcklwd ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x62, 0xd4					}, { vpunpckldq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x62, 0x11					}, { vpunpckldq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x62, 0x11					}, { vpunpckldq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x6c, 0xd4					}, { vpunpcklqdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6c, 0x11					}, { vpunpcklqdq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0x6c, 0x11					}, { vpunpcklqdq ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xef, 0xd4					}, { vpxor ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xef, 0x11					}, { vpxor ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xef, 0x11					}, { vpxor ymm2,ymm6,YWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1c, 0xf4					}, { vpabsb ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1c, 0x21					}, { vpabsb ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1c, 0x21					}, { vpabsb ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1d, 0xf4					}, { vpabsw ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1d, 0x21					}, { vpabsw ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1d, 0x21					}, { vpabsw ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1e, 0xf4					}, { vpabsd ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1e, 0x21					}, { vpabsd ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1e, 0x21					}, { vpabsd ymm4,YWORD [ecx]				}
testcase	{ 0xc4, 0xe3, 0x4d, 0x42, 0xd4, 0x07				}, { vmpsadbw ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x42, 0x11, 0x07				}, { vmpsadbw ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x42, 0x11, 0x07				}, { vmpsadbw ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0f, 0xd4, 0x07				}, { vpalignr ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0f, 0x11, 0x07				}, { vpalignr ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0f, 0x11, 0x07				}, { vpalignr ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0e, 0xd4, 0x07				}, { vpblendw ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0e, 0x11, 0x07				}, { vpblendw ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0e, 0x11, 0x07				}, { vpblendw ymm2,ymm6,YWORD [ecx],0x7			}
testcase	{ 0xc4, 0xe3, 0x6d, 0x4c, 0xfe, 0x40				}, { vpblendvb ymm7,ymm2,ymm6,ymm4			}
testcase	{ 0xc4, 0xe3, 0x6d, 0x4c, 0x39, 0x40				}, { vpblendvb ymm7,ymm2,YWORD [ecx],ymm4		}
testcase	{ 0xc4, 0xe3, 0x6d, 0x4c, 0x39, 0x40				}, { vpblendvb ymm7,ymm2,YWORD [ecx],ymm4		}
testcase	{ 0xc5, 0xcd, 0xf1, 0xd4					}, { vpsllw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf1, 0x11					}, { vpsllw ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf1, 0x11					}, { vpsllw ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf2, 0xd4					}, { vpslld ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf2, 0x11					}, { vpslld ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf2, 0x11					}, { vpslld ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf3, 0xd4					}, { vpsllq ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf3, 0x11					}, { vpsllq ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xf3, 0x11					}, { vpsllq ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe1, 0xd4					}, { vpsraw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xe1, 0x11					}, { vpsraw ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe1, 0x11					}, { vpsraw ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe2, 0xd4					}, { vpsrad ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xe2, 0x11					}, { vpsrad ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xe2, 0x11					}, { vpsrad ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd1, 0xd4					}, { vpsrlw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd1, 0x11					}, { vpsrlw ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd1, 0x11					}, { vpsrlw ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd2, 0xd4					}, { vpsrld ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd2, 0x11					}, { vpsrld ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd2, 0x11					}, { vpsrld ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd3, 0xd4					}, { vpsrlq ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd3, 0x11					}, { vpsrlq ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc5, 0xcd, 0xd3, 0x11					}, { vpsrlq ymm2,ymm6,OWORD [ecx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x20, 0xe4					}, { vpmovsxbw ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x20, 0x21					}, { vpmovsxbw ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x20, 0x21					}, { vpmovsxbw ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x23, 0xe4					}, { vpmovsxwd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x23, 0x21					}, { vpmovsxwd ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x23, 0x21					}, { vpmovsxwd ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x25, 0xe4					}, { vpmovsxdq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x25, 0x21					}, { vpmovsxdq ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x25, 0x21					}, { vpmovsxdq ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x30, 0xe4					}, { vpmovzxbw ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x30, 0x21					}, { vpmovzxbw ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x30, 0x21					}, { vpmovzxbw ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x33, 0xe4					}, { vpmovzxwd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x33, 0x21					}, { vpmovzxwd ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x33, 0x21					}, { vpmovzxwd ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x35, 0xe4					}, { vpmovzxdq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x35, 0x21					}, { vpmovzxdq ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x35, 0x21					}, { vpmovzxdq ymm4,OWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x21, 0xf4					}, { vpmovsxbd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x21, 0x21					}, { vpmovsxbd ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x21, 0x21					}, { vpmovsxbd ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x24, 0xf4					}, { vpmovsxwq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x24, 0x21					}, { vpmovsxwq ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x24, 0x21					}, { vpmovsxwq ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x31, 0xf4					}, { vpmovzxbd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x31, 0x21					}, { vpmovzxbd ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x31, 0x21					}, { vpmovzxbd ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x34, 0xf4					}, { vpmovzxwq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x34, 0x21					}, { vpmovzxwq ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x34, 0x21					}, { vpmovzxwq ymm4,QWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x22, 0xe4					}, { vpmovsxbq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x22, 0x21					}, { vpmovsxbq ymm4,DWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x22, 0x21					}, { vpmovsxbq ymm4,DWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x32, 0xe4					}, { vpmovzxbq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x32, 0x21					}, { vpmovzxbq ymm4,DWORD [ecx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x32, 0x21					}, { vpmovzxbq ymm4,DWORD [ecx]				}

bits 64

; b/gas/testsuite/gas/i386/x86-64-avx-gather-intel.d
testcase	{ 0xc4, 0xe2, 0xe9, 0x92, 0x4c, 0x7d, 0x00			}, { vgatherdpd xmm1,QWORD [rbp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0xe9, 0x93, 0x4c, 0x7d, 0x00			}, { vgatherqpd xmm1,QWORD [rbp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0xed, 0x92, 0x4c, 0x7d, 0x00			}, { vgatherdpd ymm1,QWORD [rbp+xmm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0xe2, 0xed, 0x93, 0x4c, 0x7d, 0x00			}, { vgatherqpd ymm1,QWORD [rbp+ymm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0x02, 0x99, 0x92, 0x5c, 0x75, 0x00			}, { vgatherdpd xmm11,QWORD [r13+xmm14*2+0x0],xmm12	}
testcase	{ 0xc4, 0x02, 0x99, 0x93, 0x5c, 0x75, 0x00			}, { vgatherqpd xmm11,QWORD [r13+xmm14*2+0x0],xmm12	}
testcase	{ 0xc4, 0x02, 0x9d, 0x92, 0x5c, 0x75, 0x00			}, { vgatherdpd ymm11,QWORD [r13+xmm14*2+0x0],ymm12	}
testcase	{ 0xc4, 0x02, 0x9d, 0x93, 0x5c, 0x75, 0x00			}, { vgatherqpd ymm11,QWORD [r13+ymm14*2+0x0],ymm12	}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0x25, 0x08, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*1+0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0x25, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdpd ymm6,QWORD [xmm4*1-0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0x25, 0x00, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*1+0x0],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0x25, 0x98, 0x02, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*1+0x298],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0xe5, 0x08, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*8+0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0xe5, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdpd ymm6,QWORD [xmm4*8-0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0xe5, 0x00, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*8+0x0],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x92, 0x34, 0xe5, 0x98, 0x02, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm4*8+0x298],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x92, 0x34, 0x35, 0x08, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm14*1+0x8],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x92, 0x34, 0x35, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdpd ymm6,QWORD [xmm14*1-0x8],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x92, 0x34, 0x35, 0x00, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm14*1+0x0],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x92, 0x34, 0x35, 0x98, 0x02, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm14*1+0x298],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x92, 0x34, 0xf5, 0x08, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm14*8+0x8],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x92, 0x34, 0xf5, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdpd ymm6,QWORD [xmm14*8-0x8],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x92, 0x34, 0xf5, 0x00, 0x00, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm14*8+0x0],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x92, 0x34, 0xf5, 0x98, 0x02, 0x00, 0x00	}, { vgatherdpd ymm6,QWORD [xmm14*8+0x298],ymm5		}
testcase	{ 0xc4, 0xe2, 0x69, 0x92, 0x4c, 0x7d, 0x00			}, { vgatherdps xmm1,DWORD [rbp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0x69, 0x93, 0x4c, 0x7d, 0x00			}, { vgatherqps xmm1,DWORD [rbp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0x6d, 0x92, 0x4c, 0x7d, 0x00			}, { vgatherdps ymm1,DWORD [rbp+ymm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0xe2, 0x6d, 0x93, 0x4c, 0x7d, 0x00			}, { vgatherqps xmm1,DWORD [rbp+ymm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0x02, 0x19, 0x92, 0x5c, 0x75, 0x00			}, { vgatherdps xmm11,DWORD [r13+xmm14*2+0x0],xmm12	}
testcase	{ 0xc4, 0x02, 0x19, 0x93, 0x5c, 0x75, 0x00			}, { vgatherqps xmm11,DWORD [r13+xmm14*2+0x0],xmm12	}
testcase	{ 0xc4, 0x02, 0x1d, 0x92, 0x5c, 0x75, 0x00			}, { vgatherdps ymm11,DWORD [r13+ymm14*2+0x0],ymm12	}
testcase	{ 0xc4, 0x02, 0x1d, 0x93, 0x5c, 0x75, 0x00			}, { vgatherqps xmm11,DWORD [r13+ymm14*2+0x0],xmm12	}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0x25, 0x08, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*1+0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0x25, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdps xmm6,DWORD [xmm4*1-0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0x25, 0x00, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*1+0x0],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0x25, 0x98, 0x02, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*1+0x298],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0xe5, 0x08, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*8+0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0xe5, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdps xmm6,DWORD [xmm4*8-0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0xe5, 0x00, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*8+0x0],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x92, 0x34, 0xe5, 0x98, 0x02, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm4*8+0x298],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x92, 0x34, 0x35, 0x08, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm14*1+0x8],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x92, 0x34, 0x35, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdps xmm6,DWORD [xmm14*1-0x8],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x92, 0x34, 0x35, 0x00, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm14*1+0x0],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x92, 0x34, 0x35, 0x98, 0x02, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm14*1+0x298],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x92, 0x34, 0xf5, 0x08, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm14*8+0x8],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x92, 0x34, 0xf5, 0xf8, 0xff, 0xff, 0xff	}, { vgatherdps xmm6,DWORD [xmm14*8-0x8],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x92, 0x34, 0xf5, 0x00, 0x00, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm14*8+0x0],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x92, 0x34, 0xf5, 0x98, 0x02, 0x00, 0x00	}, { vgatherdps xmm6,DWORD [xmm14*8+0x298],xmm5		}
testcase	{ 0xc4, 0xe2, 0x69, 0x90, 0x4c, 0x7d, 0x00			}, { vpgatherdd xmm1,DWORD [rbp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0x69, 0x91, 0x4c, 0x7d, 0x00			}, { vpgatherqd xmm1,DWORD [rbp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0x6d, 0x90, 0x4c, 0x7d, 0x00			}, { vpgatherdd ymm1,DWORD [rbp+ymm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0xe2, 0x6d, 0x91, 0x4c, 0x7d, 0x00			}, { vpgatherqd xmm1,DWORD [rbp+ymm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0x02, 0x19, 0x90, 0x5c, 0x75, 0x00			}, { vpgatherdd xmm11,DWORD [r13+xmm14*2+0x0],xmm12	}
testcase	{ 0xc4, 0x02, 0x19, 0x91, 0x5c, 0x75, 0x00			}, { vpgatherqd xmm11,DWORD [r13+xmm14*2+0x0],xmm12	}
testcase	{ 0xc4, 0x02, 0x1d, 0x90, 0x5c, 0x75, 0x00			}, { vpgatherdd ymm11,DWORD [r13+ymm14*2+0x0],ymm12	}
testcase	{ 0xc4, 0x02, 0x1d, 0x91, 0x5c, 0x75, 0x00			}, { vpgatherqd xmm11,DWORD [r13+ymm14*2+0x0],xmm12	}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0x25, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*1+0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0x25, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdd xmm6,DWORD [xmm4*1-0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0x25, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*1+0x0],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0x25, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*1+0x298],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0xe5, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*8+0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0xe5, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdd xmm6,DWORD [xmm4*8-0x8],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0xe5, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*8+0x0],xmm5		}
testcase	{ 0xc4, 0xe2, 0x51, 0x90, 0x34, 0xe5, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm4*8+0x298],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x90, 0x34, 0x35, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm14*1+0x8],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x90, 0x34, 0x35, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdd xmm6,DWORD [xmm14*1-0x8],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x90, 0x34, 0x35, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm14*1+0x0],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x90, 0x34, 0x35, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm14*1+0x298],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x90, 0x34, 0xf5, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm14*8+0x8],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x90, 0x34, 0xf5, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdd xmm6,DWORD [xmm14*8-0x8],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x90, 0x34, 0xf5, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm14*8+0x0],xmm5		}
testcase	{ 0xc4, 0xa2, 0x51, 0x90, 0x34, 0xf5, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdd xmm6,DWORD [xmm14*8+0x298],xmm5		}
testcase	{ 0xc4, 0xe2, 0xe9, 0x90, 0x4c, 0x7d, 0x00			}, { vpgatherdq xmm1,QWORD [rbp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0xe9, 0x91, 0x4c, 0x7d, 0x00			}, { vpgatherqq xmm1,QWORD [rbp+xmm7*2+0x0],xmm2	}
testcase	{ 0xc4, 0xe2, 0xed, 0x90, 0x4c, 0x7d, 0x00			}, { vpgatherdq ymm1,QWORD [rbp+xmm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0xe2, 0xed, 0x91, 0x4c, 0x7d, 0x00			}, { vpgatherqq ymm1,QWORD [rbp+ymm7*2+0x0],ymm2	}
testcase	{ 0xc4, 0x02, 0x99, 0x90, 0x5c, 0x75, 0x00			}, { vpgatherdq xmm11,QWORD [r13+xmm14*2+0x0],xmm12	}
testcase	{ 0xc4, 0x02, 0x99, 0x91, 0x5c, 0x75, 0x00			}, { vpgatherqq xmm11,QWORD [r13+xmm14*2+0x0],xmm12	}
testcase	{ 0xc4, 0x02, 0x9d, 0x90, 0x5c, 0x75, 0x00			}, { vpgatherdq ymm11,QWORD [r13+xmm14*2+0x0],ymm12	}
testcase	{ 0xc4, 0x02, 0x9d, 0x91, 0x5c, 0x75, 0x00			}, { vpgatherqq ymm11,QWORD [r13+ymm14*2+0x0],ymm12	}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0x25, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*1+0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0x25, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdq ymm6,QWORD [xmm4*1-0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0x25, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*1+0x0],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0x25, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*1+0x298],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0xe5, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*8+0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0xe5, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdq ymm6,QWORD [xmm4*8-0x8],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0xe5, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*8+0x0],ymm5		}
testcase	{ 0xc4, 0xe2, 0xd5, 0x90, 0x34, 0xe5, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm4*8+0x298],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x90, 0x34, 0x35, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm14*1+0x8],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x90, 0x34, 0x35, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdq ymm6,QWORD [xmm14*1-0x8],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x90, 0x34, 0x35, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm14*1+0x0],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x90, 0x34, 0x35, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm14*1+0x298],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x90, 0x34, 0xf5, 0x08, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm14*8+0x8],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x90, 0x34, 0xf5, 0xf8, 0xff, 0xff, 0xff	}, { vpgatherdq ymm6,QWORD [xmm14*8-0x8],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x90, 0x34, 0xf5, 0x00, 0x00, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm14*8+0x0],ymm5		}
testcase	{ 0xc4, 0xa2, 0xd5, 0x90, 0x34, 0xf5, 0x98, 0x02, 0x00, 0x00	}, { vpgatherdq ymm6,QWORD [xmm14*8+0x298],ymm5		}

; b/gas/testsuite/gas/i386/x86-64-avx2-intel.d
testcase	{ 0xc4, 0xe2, 0x5d, 0x8c, 0x31					}, { vpmaskmovd ymm6,ymm4,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x8e, 0x21					}, { vpmaskmovd YWORD [rcx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe2, 0xdd, 0x8c, 0x31					}, { vpmaskmovq ymm6,ymm4,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x8e, 0x21					}, { vpmaskmovq YWORD [rcx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x01, 0xd6, 0x07				}, { vpermpd ymm2,ymm6,0x7				}
testcase	{ 0xc4, 0xe3, 0xfd, 0x01, 0x31, 0x07				}, { vpermpd ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x00, 0xd6, 0x07				}, { vpermq ymm2,ymm6,0x7				}
testcase	{ 0xc4, 0xe3, 0xfd, 0x00, 0x31, 0x07				}, { vpermq ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x36, 0xd4					}, { vpermd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x36, 0x11					}, { vpermd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x16, 0xd4					}, { vpermps ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x16, 0x11					}, { vpermps ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x47, 0xd4					}, { vpsllvd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x47, 0x11					}, { vpsllvd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x47, 0xd4					}, { vpsllvq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0xcd, 0x47, 0x11					}, { vpsllvq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x46, 0xd4					}, { vpsravd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x46, 0x11					}, { vpsravd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x45, 0xd4					}, { vpsrlvd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x45, 0x11					}, { vpsrlvd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x45, 0xd4					}, { vpsrlvq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0xcd, 0x45, 0x11					}, { vpsrlvq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x2a, 0x21					}, { vmovntdqa ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x19, 0xf4					}, { vbroadcastsd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x18, 0xf4					}, { vbroadcastss ymm6,xmm4				}
testcase	{ 0xc4, 0xe3, 0x4d, 0x02, 0xd4, 0x07				}, { vpblendd ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x02, 0x11, 0x07				}, { vpblendd ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x46, 0xd4, 0x07				}, { vperm2i128 ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x46, 0x11, 0x07				}, { vperm2i128 ymm2,ymm6,YWORD [rcx],0x7		}
testcase	{ 0xc4, 0xe3, 0x5d, 0x38, 0xf4, 0x07				}, { vinserti128 ymm6,ymm4,xmm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x5d, 0x38, 0x31, 0x07				}, { vinserti128 ymm6,ymm4,OWORD [rcx],0x7		}
testcase	{ 0xc4, 0xe2, 0x7d, 0x5a, 0x21					}, { vbroadcasti128 ymm4,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x47, 0xd4					}, { vpsllvd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x47, 0x39					}, { vpsllvd xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x47, 0xd4					}, { vpsllvq xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0xc9, 0x47, 0x39					}, { vpsllvq xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x46, 0xd4					}, { vpsravd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x46, 0x39					}, { vpsravd xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x45, 0xd4					}, { vpsrlvd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x45, 0x39					}, { vpsrlvd xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x45, 0xd4					}, { vpsrlvq xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0xc9, 0x45, 0x39					}, { vpsrlvq xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x59, 0x8c, 0x31					}, { vpmaskmovd xmm6,xmm4,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xd9, 0x8c, 0x31					}, { vpmaskmovq xmm6,xmm4,OWORD [rcx]			}
testcase	{ 0xc4, 0xe3, 0x7d, 0x39, 0xe6, 0x07				}, { vextracti128 xmm6,ymm4,0x7				}
testcase	{ 0xc4, 0xe3, 0x7d, 0x39, 0x21, 0x07				}, { vextracti128 OWORD [rcx],ymm4,0x7			}
testcase	{ 0xc4, 0xe2, 0x49, 0x8e, 0x21					}, { vpmaskmovd OWORD [rcx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x8e, 0x21					}, { vpmaskmovq OWORD [rcx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe3, 0x49, 0x02, 0xd4, 0x07				}, { vpblendd xmm2,xmm6,xmm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x49, 0x02, 0x11, 0x07				}, { vpblendd xmm2,xmm6,OWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe2, 0x79, 0x59, 0xf4					}, { vpbroadcastq xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x59, 0x21					}, { vpbroadcastq xmm4,QWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x59, 0xf4					}, { vpbroadcastq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x59, 0x21					}, { vpbroadcastq ymm4,QWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x58, 0xe4					}, { vpbroadcastd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x58, 0x21					}, { vpbroadcastd ymm4,DWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x58, 0xf4					}, { vpbroadcastd xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x58, 0x21					}, { vpbroadcastd xmm4,DWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x79, 0xf4					}, { vpbroadcastw xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x79, 0x21					}, { vpbroadcastw xmm4,WORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x79, 0xf4					}, { vpbroadcastw ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x79, 0x21					}, { vpbroadcastw ymm4,WORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x78, 0xf4					}, { vpbroadcastb xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x78, 0x21					}, { vpbroadcastb xmm4,BYTE [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x78, 0xf4					}, { vpbroadcastb ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x78, 0x21					}, { vpbroadcastb ymm4,BYTE [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x18, 0xf4					}, { vbroadcastss xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x5d, 0x8c, 0x31					}, { vpmaskmovd ymm6,ymm4,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x8e, 0x21					}, { vpmaskmovd YWORD [rcx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe2, 0x5d, 0x8c, 0x31					}, { vpmaskmovd ymm6,ymm4,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x8e, 0x21					}, { vpmaskmovd YWORD [rcx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe2, 0xdd, 0x8c, 0x31					}, { vpmaskmovq ymm6,ymm4,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x8e, 0x21					}, { vpmaskmovq YWORD [rcx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe2, 0xdd, 0x8c, 0x31					}, { vpmaskmovq ymm6,ymm4,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x8e, 0x21					}, { vpmaskmovq YWORD [rcx],ymm6,ymm4			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x01, 0xd6, 0x07				}, { vpermpd ymm2,ymm6,0x7				}
testcase	{ 0xc4, 0xe3, 0xfd, 0x01, 0x31, 0x07				}, { vpermpd ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x01, 0x31, 0x07				}, { vpermpd ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x00, 0xd6, 0x07				}, { vpermq ymm2,ymm6,0x7				}
testcase	{ 0xc4, 0xe3, 0xfd, 0x00, 0x31, 0x07				}, { vpermq ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0xfd, 0x00, 0x31, 0x07				}, { vpermq ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x36, 0xd4					}, { vpermd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x36, 0x11					}, { vpermd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x36, 0x11					}, { vpermd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x16, 0xd4					}, { vpermps ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x16, 0x11					}, { vpermps ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x16, 0x11					}, { vpermps ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x47, 0xd4					}, { vpsllvd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x47, 0x11					}, { vpsllvd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x47, 0x11					}, { vpsllvd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x47, 0xd4					}, { vpsllvq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0xcd, 0x47, 0x11					}, { vpsllvq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x47, 0x11					}, { vpsllvq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x46, 0xd4					}, { vpsravd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x46, 0x11					}, { vpsravd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x46, 0x11					}, { vpsravd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x45, 0xd4					}, { vpsrlvd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x45, 0x11					}, { vpsrlvd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x45, 0x11					}, { vpsrlvd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x45, 0xd4					}, { vpsrlvq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0xcd, 0x45, 0x11					}, { vpsrlvq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xcd, 0x45, 0x11					}, { vpsrlvq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x2a, 0x21					}, { vmovntdqa ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x2a, 0x21					}, { vmovntdqa ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x19, 0xf4					}, { vbroadcastsd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x18, 0xf4					}, { vbroadcastss ymm6,xmm4				}
testcase	{ 0xc4, 0xe3, 0x4d, 0x02, 0xd4, 0x07				}, { vpblendd ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x02, 0x11, 0x07				}, { vpblendd ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x02, 0x11, 0x07				}, { vpblendd ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x46, 0xd4, 0x07				}, { vperm2i128 ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x46, 0x11, 0x07				}, { vperm2i128 ymm2,ymm6,YWORD [rcx],0x7		}
testcase	{ 0xc4, 0xe3, 0x4d, 0x46, 0x11, 0x07				}, { vperm2i128 ymm2,ymm6,YWORD [rcx],0x7		}
testcase	{ 0xc4, 0xe3, 0x5d, 0x38, 0xf4, 0x07				}, { vinserti128 ymm6,ymm4,xmm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x5d, 0x38, 0x31, 0x07				}, { vinserti128 ymm6,ymm4,OWORD [rcx],0x7		}
testcase	{ 0xc4, 0xe3, 0x5d, 0x38, 0x31, 0x07				}, { vinserti128 ymm6,ymm4,OWORD [rcx],0x7		}
testcase	{ 0xc4, 0xe2, 0x7d, 0x5a, 0x21					}, { vbroadcasti128 ymm4,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x5a, 0x21					}, { vbroadcasti128 ymm4,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x47, 0xd4					}, { vpsllvd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x47, 0x39					}, { vpsllvd xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x47, 0x39					}, { vpsllvd xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x47, 0xd4					}, { vpsllvq xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0xc9, 0x47, 0x39					}, { vpsllvq xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x47, 0x39					}, { vpsllvq xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x46, 0xd4					}, { vpsravd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x46, 0x39					}, { vpsravd xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x46, 0x39					}, { vpsravd xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x45, 0xd4					}, { vpsrlvd xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x49, 0x45, 0x39					}, { vpsrlvd xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x49, 0x45, 0x39					}, { vpsrlvd xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x45, 0xd4					}, { vpsrlvq xmm2,xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0xc9, 0x45, 0x39					}, { vpsrlvq xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x45, 0x39					}, { vpsrlvq xmm7,xmm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x59, 0x8c, 0x31					}, { vpmaskmovd xmm6,xmm4,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x59, 0x8c, 0x31					}, { vpmaskmovd xmm6,xmm4,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xd9, 0x8c, 0x31					}, { vpmaskmovq xmm6,xmm4,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0xd9, 0x8c, 0x31					}, { vpmaskmovq xmm6,xmm4,OWORD [rcx]			}
testcase	{ 0xc4, 0xe3, 0x7d, 0x39, 0xe6, 0x07				}, { vextracti128 xmm6,ymm4,0x7				}
testcase	{ 0xc4, 0xe3, 0x7d, 0x39, 0x21, 0x07				}, { vextracti128 OWORD [rcx],ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x7d, 0x39, 0x21, 0x07				}, { vextracti128 OWORD [rcx],ymm4,0x7			}
testcase	{ 0xc4, 0xe2, 0x49, 0x8e, 0x21					}, { vpmaskmovd OWORD [rcx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe2, 0x49, 0x8e, 0x21					}, { vpmaskmovd OWORD [rcx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x8e, 0x21					}, { vpmaskmovq OWORD [rcx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe2, 0xc9, 0x8e, 0x21					}, { vpmaskmovq OWORD [rcx],xmm6,xmm4			}
testcase	{ 0xc4, 0xe3, 0x49, 0x02, 0xd4, 0x07				}, { vpblendd xmm2,xmm6,xmm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x49, 0x02, 0x11, 0x07				}, { vpblendd xmm2,xmm6,OWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x49, 0x02, 0x11, 0x07				}, { vpblendd xmm2,xmm6,OWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe2, 0x79, 0x59, 0xf4					}, { vpbroadcastq xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x59, 0x21					}, { vpbroadcastq xmm4,QWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x59, 0x21					}, { vpbroadcastq xmm4,QWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x59, 0xf4					}, { vpbroadcastq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x59, 0x21					}, { vpbroadcastq ymm4,QWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x59, 0x21					}, { vpbroadcastq ymm4,QWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x58, 0xe4					}, { vpbroadcastd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x58, 0x21					}, { vpbroadcastd ymm4,DWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x58, 0x21					}, { vpbroadcastd ymm4,DWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x58, 0xf4					}, { vpbroadcastd xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x58, 0x21					}, { vpbroadcastd xmm4,DWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x58, 0x21					}, { vpbroadcastd xmm4,DWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x79, 0xf4					}, { vpbroadcastw xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x79, 0x21					}, { vpbroadcastw xmm4,WORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x79, 0x21					}, { vpbroadcastw xmm4,WORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x79, 0xf4					}, { vpbroadcastw ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x79, 0x21					}, { vpbroadcastw ymm4,WORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x79, 0x21					}, { vpbroadcastw ymm4,WORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x78, 0xf4					}, { vpbroadcastb xmm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x79, 0x78, 0x21					}, { vpbroadcastb xmm4,BYTE [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x78, 0x21					}, { vpbroadcastb xmm4,BYTE [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x78, 0xf4					}, { vpbroadcastb ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x78, 0x21					}, { vpbroadcastb ymm4,BYTE [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x78, 0x21					}, { vpbroadcastb ymm4,BYTE [rcx]			}
testcase	{ 0xc4, 0xe2, 0x79, 0x18, 0xf4					}, { vbroadcastss xmm6,xmm4				}

; b/gas/testsuite/gas/i386/x86-64-avx256int-intel.d
testcase	{ 0xc5, 0xfd, 0xd7, 0xcc					}, { vpmovmskb ecx,ymm4					}
testcase	{ 0xc5, 0xfd, 0xd7, 0xcc					}, { vpmovmskb ecx,ymm4					}
testcase	{ 0xc5, 0xed, 0x72, 0xf6, 0x07					}, { vpslld ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xfe, 0x07					}, { vpslldq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xf6, 0x07					}, { vpsllq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xf6, 0x07					}, { vpsllw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x72, 0xe6, 0x07					}, { vpsrad ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xe6, 0x07					}, { vpsraw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x72, 0xd6, 0x07					}, { vpsrld ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xde, 0x07					}, { vpsrldq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xd6, 0x07					}, { vpsrlq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xd6, 0x07					}, { vpsrlw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfd, 0x70, 0xd6, 0x07					}, { vpshufd ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfd, 0x70, 0x31, 0x07					}, { vpshufd ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc5, 0xfe, 0x70, 0xd6, 0x07					}, { vpshufhw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfe, 0x70, 0x31, 0x07					}, { vpshufhw ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc5, 0xff, 0x70, 0xd6, 0x07					}, { vpshuflw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xff, 0x70, 0x31, 0x07					}, { vpshuflw ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc5, 0xcd, 0x6b, 0xd4					}, { vpackssdw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6b, 0x11					}, { vpackssdw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x63, 0xd4					}, { vpacksswb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x63, 0x11					}, { vpacksswb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x2b, 0xd4					}, { vpackusdw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x2b, 0x11					}, { vpackusdw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x67, 0xd4					}, { vpackuswb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x67, 0x11					}, { vpackuswb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfc, 0xd4					}, { vpaddb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfc, 0x11					}, { vpaddb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfd, 0xd4					}, { vpaddw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfd, 0x11					}, { vpaddw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfe, 0xd4					}, { vpaddd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfe, 0x11					}, { vpaddd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd4, 0xd4					}, { vpaddq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd4, 0x11					}, { vpaddq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xec, 0xd4					}, { vpaddsb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xec, 0x11					}, { vpaddsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xed, 0xd4					}, { vpaddsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xed, 0x11					}, { vpaddsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdc, 0xd4					}, { vpaddusb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdc, 0x11					}, { vpaddusb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdd, 0xd4					}, { vpaddusw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdd, 0x11					}, { vpaddusw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdb, 0xd4					}, { vpand ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdb, 0x11					}, { vpand ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdf, 0xd4					}, { vpandn ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdf, 0x11					}, { vpandn ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe0, 0xd4					}, { vpavgb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe0, 0x11					}, { vpavgb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe3, 0xd4					}, { vpavgw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe3, 0x11					}, { vpavgw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x74, 0xd4					}, { vpcmpeqb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x74, 0x11					}, { vpcmpeqb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x75, 0xd4					}, { vpcmpeqw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x75, 0x11					}, { vpcmpeqw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x76, 0xd4					}, { vpcmpeqd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x76, 0x11					}, { vpcmpeqd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x29, 0xd4					}, { vpcmpeqq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x29, 0x11					}, { vpcmpeqq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x64, 0xd4					}, { vpcmpgtb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x64, 0x11					}, { vpcmpgtb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x65, 0xd4					}, { vpcmpgtw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x65, 0x11					}, { vpcmpgtw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x66, 0xd4					}, { vpcmpgtd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x66, 0x11					}, { vpcmpgtd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x37, 0xd4					}, { vpcmpgtq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x37, 0x11					}, { vpcmpgtq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x01, 0xd4					}, { vphaddw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x01, 0x11					}, { vphaddw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x02, 0xd4					}, { vphaddd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x02, 0x11					}, { vphaddd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x03, 0xd4					}, { vphaddsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x03, 0x11					}, { vphaddsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x05, 0xd4					}, { vphsubw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x05, 0x11					}, { vphsubw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x06, 0xd4					}, { vphsubd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x06, 0x11					}, { vphsubd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x07, 0xd4					}, { vphsubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x07, 0x11					}, { vphsubsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf5, 0xd4					}, { vpmaddwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf5, 0x11					}, { vpmaddwd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x04, 0xd4					}, { vpmaddubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x04, 0x11					}, { vpmaddubsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3c, 0xd4					}, { vpmaxsb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3c, 0x11					}, { vpmaxsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xee, 0xd4					}, { vpmaxsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xee, 0x11					}, { vpmaxsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3d, 0xd4					}, { vpmaxsd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3d, 0x11					}, { vpmaxsd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xde, 0xd4					}, { vpmaxub ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xde, 0x11					}, { vpmaxub ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3e, 0xd4					}, { vpmaxuw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3e, 0x11					}, { vpmaxuw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3f, 0xd4					}, { vpmaxud ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3f, 0x11					}, { vpmaxud ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x38, 0xd4					}, { vpminsb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x38, 0x11					}, { vpminsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xea, 0xd4					}, { vpminsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xea, 0x11					}, { vpminsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x39, 0xd4					}, { vpminsd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x39, 0x11					}, { vpminsd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xda, 0xd4					}, { vpminub ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xda, 0x11					}, { vpminub ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3a, 0xd4					}, { vpminuw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3a, 0x11					}, { vpminuw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3b, 0xd4					}, { vpminud ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3b, 0x11					}, { vpminud ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe4, 0xd4					}, { vpmulhuw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe4, 0x11					}, { vpmulhuw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0b, 0xd4					}, { vpmulhrsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0b, 0x11					}, { vpmulhrsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe5, 0xd4					}, { vpmulhw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe5, 0x11					}, { vpmulhw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd5, 0xd4					}, { vpmullw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd5, 0x11					}, { vpmullw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x40, 0xd4					}, { vpmulld ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x40, 0x11					}, { vpmulld ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf4, 0xd4					}, { vpmuludq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf4, 0x11					}, { vpmuludq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x28, 0xd4					}, { vpmuldq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x28, 0x11					}, { vpmuldq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xeb, 0xd4					}, { vpor ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xeb, 0x11					}, { vpor ymm2,ymm6,YWORD [rcx]				}
testcase	{ 0xc5, 0xcd, 0xf6, 0xd4					}, { vpsadbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf6, 0x11					}, { vpsadbw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x00, 0xd4					}, { vpshufb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x00, 0x11					}, { vpshufb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x08, 0xd4					}, { vpsignb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x08, 0x11					}, { vpsignb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x09, 0xd4					}, { vpsignw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x09, 0x11					}, { vpsignw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0a, 0xd4					}, { vpsignd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0a, 0x11					}, { vpsignd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf8, 0xd4					}, { vpsubb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf8, 0x11					}, { vpsubb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf9, 0xd4					}, { vpsubw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf9, 0x11					}, { vpsubw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfa, 0xd4					}, { vpsubd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfa, 0x11					}, { vpsubd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfb, 0xd4					}, { vpsubq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfb, 0x11					}, { vpsubq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe8, 0xd4					}, { vpsubsb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe8, 0x11					}, { vpsubsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe9, 0xd4					}, { vpsubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe9, 0x11					}, { vpsubsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd8, 0xd4					}, { vpsubusb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd8, 0x11					}, { vpsubusb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd9, 0xd4					}, { vpsubusw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd9, 0x11					}, { vpsubusw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x68, 0xd4					}, { vpunpckhbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x68, 0x11					}, { vpunpckhbw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x69, 0xd4					}, { vpunpckhwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x69, 0x11					}, { vpunpckhwd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x6a, 0xd4					}, { vpunpckhdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6a, 0x11					}, { vpunpckhdq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x6d, 0xd4					}, { vpunpckhqdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6d, 0x11					}, { vpunpckhqdq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x60, 0xd4					}, { vpunpcklbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x60, 0x11					}, { vpunpcklbw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x61, 0xd4					}, { vpunpcklwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x61, 0x11					}, { vpunpcklwd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x62, 0xd4					}, { vpunpckldq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x62, 0x11					}, { vpunpckldq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x6c, 0xd4					}, { vpunpcklqdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6c, 0x11					}, { vpunpcklqdq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xef, 0xd4					}, { vpxor ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xef, 0x11					}, { vpxor ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1c, 0xf4					}, { vpabsb ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1c, 0x21					}, { vpabsb ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1d, 0xf4					}, { vpabsw ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1d, 0x21					}, { vpabsw ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1e, 0xf4					}, { vpabsd ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1e, 0x21					}, { vpabsd ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe3, 0x4d, 0x42, 0xd4, 0x07				}, { vmpsadbw ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x42, 0x11, 0x07				}, { vmpsadbw ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0f, 0xd4, 0x07				}, { vpalignr ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0f, 0x11, 0x07				}, { vpalignr ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0e, 0xd4, 0x07				}, { vpblendw ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0e, 0x11, 0x07				}, { vpblendw ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x6d, 0x4c, 0xfe, 0x40				}, { vpblendvb ymm7,ymm2,ymm6,ymm4			}
testcase	{ 0xc4, 0xe3, 0x6d, 0x4c, 0x39, 0x40				}, { vpblendvb ymm7,ymm2,YWORD [rcx],ymm4		}
testcase	{ 0xc5, 0xcd, 0xf1, 0xd4					}, { vpsllw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf1, 0x11					}, { vpsllw ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf2, 0xd4					}, { vpslld ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf2, 0x11					}, { vpslld ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf3, 0xd4					}, { vpsllq ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf3, 0x11					}, { vpsllq ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe1, 0xd4					}, { vpsraw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xe1, 0x11					}, { vpsraw ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe2, 0xd4					}, { vpsrad ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xe2, 0x11					}, { vpsrad ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd1, 0xd4					}, { vpsrlw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd1, 0x11					}, { vpsrlw ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd2, 0xd4					}, { vpsrld ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd2, 0x11					}, { vpsrld ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd3, 0xd4					}, { vpsrlq ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd3, 0x11					}, { vpsrlq ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x20, 0xe4					}, { vpmovsxbw ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x20, 0x21					}, { vpmovsxbw ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x23, 0xe4					}, { vpmovsxwd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x23, 0x21					}, { vpmovsxwd ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x25, 0xe4					}, { vpmovsxdq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x25, 0x21					}, { vpmovsxdq ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x30, 0xe4					}, { vpmovzxbw ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x30, 0x21					}, { vpmovzxbw ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x33, 0xe4					}, { vpmovzxwd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x33, 0x21					}, { vpmovzxwd ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x35, 0xe4					}, { vpmovzxdq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x35, 0x21					}, { vpmovzxdq ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x21, 0xf4					}, { vpmovsxbd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x21, 0x21					}, { vpmovsxbd ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x24, 0xf4					}, { vpmovsxwq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x24, 0x21					}, { vpmovsxwq ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x31, 0xf4					}, { vpmovzxbd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x31, 0x21					}, { vpmovzxbd ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x34, 0xf4					}, { vpmovzxwq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x34, 0x21					}, { vpmovzxwq ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x22, 0xe4					}, { vpmovsxbq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x22, 0x21					}, { vpmovsxbq ymm4,DWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x32, 0xe4					}, { vpmovzxbq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x32, 0x21					}, { vpmovzxbq ymm4,DWORD [rcx]				}
testcase	{ 0xc5, 0xfd, 0xd7, 0xcc					}, { vpmovmskb ecx,ymm4					}
testcase	{ 0xc5, 0xfd, 0xd7, 0xcc					}, { vpmovmskb ecx,ymm4					}
testcase	{ 0xc5, 0xed, 0x72, 0xf6, 0x07					}, { vpslld ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xfe, 0x07					}, { vpslldq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xf6, 0x07					}, { vpsllq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xf6, 0x07					}, { vpsllw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x72, 0xe6, 0x07					}, { vpsrad ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xe6, 0x07					}, { vpsraw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x72, 0xd6, 0x07					}, { vpsrld ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xde, 0x07					}, { vpsrldq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x73, 0xd6, 0x07					}, { vpsrlq ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xed, 0x71, 0xd6, 0x07					}, { vpsrlw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfd, 0x70, 0xd6, 0x07					}, { vpshufd ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfd, 0x70, 0x31, 0x07					}, { vpshufd ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc5, 0xfd, 0x70, 0x31, 0x07					}, { vpshufd ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc5, 0xfe, 0x70, 0xd6, 0x07					}, { vpshufhw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xfe, 0x70, 0x31, 0x07					}, { vpshufhw ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc5, 0xfe, 0x70, 0x31, 0x07					}, { vpshufhw ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc5, 0xff, 0x70, 0xd6, 0x07					}, { vpshuflw ymm2,ymm6,0x7				}
testcase	{ 0xc5, 0xff, 0x70, 0x31, 0x07					}, { vpshuflw ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc5, 0xff, 0x70, 0x31, 0x07					}, { vpshuflw ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc5, 0xcd, 0x6b, 0xd4					}, { vpackssdw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6b, 0x11					}, { vpackssdw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x6b, 0x11					}, { vpackssdw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x63, 0xd4					}, { vpacksswb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x63, 0x11					}, { vpacksswb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x63, 0x11					}, { vpacksswb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x2b, 0xd4					}, { vpackusdw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x2b, 0x11					}, { vpackusdw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x2b, 0x11					}, { vpackusdw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x67, 0xd4					}, { vpackuswb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x67, 0x11					}, { vpackuswb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x67, 0x11					}, { vpackuswb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfc, 0xd4					}, { vpaddb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfc, 0x11					}, { vpaddb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfc, 0x11					}, { vpaddb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfd, 0xd4					}, { vpaddw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfd, 0x11					}, { vpaddw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfd, 0x11					}, { vpaddw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfe, 0xd4					}, { vpaddd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfe, 0x11					}, { vpaddd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfe, 0x11					}, { vpaddd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd4, 0xd4					}, { vpaddq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd4, 0x11					}, { vpaddq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd4, 0x11					}, { vpaddq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xec, 0xd4					}, { vpaddsb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xec, 0x11					}, { vpaddsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xec, 0x11					}, { vpaddsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xed, 0xd4					}, { vpaddsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xed, 0x11					}, { vpaddsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xed, 0x11					}, { vpaddsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdc, 0xd4					}, { vpaddusb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdc, 0x11					}, { vpaddusb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdc, 0x11					}, { vpaddusb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdd, 0xd4					}, { vpaddusw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdd, 0x11					}, { vpaddusw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdd, 0x11					}, { vpaddusw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdb, 0xd4					}, { vpand ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdb, 0x11					}, { vpand ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdb, 0x11					}, { vpand ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdf, 0xd4					}, { vpandn ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xdf, 0x11					}, { vpandn ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xdf, 0x11					}, { vpandn ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe0, 0xd4					}, { vpavgb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe0, 0x11					}, { vpavgb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe0, 0x11					}, { vpavgb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe3, 0xd4					}, { vpavgw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe3, 0x11					}, { vpavgw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe3, 0x11					}, { vpavgw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x74, 0xd4					}, { vpcmpeqb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x74, 0x11					}, { vpcmpeqb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x74, 0x11					}, { vpcmpeqb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x75, 0xd4					}, { vpcmpeqw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x75, 0x11					}, { vpcmpeqw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x75, 0x11					}, { vpcmpeqw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x76, 0xd4					}, { vpcmpeqd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x76, 0x11					}, { vpcmpeqd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x76, 0x11					}, { vpcmpeqd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x29, 0xd4					}, { vpcmpeqq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x29, 0x11					}, { vpcmpeqq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x29, 0x11					}, { vpcmpeqq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x64, 0xd4					}, { vpcmpgtb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x64, 0x11					}, { vpcmpgtb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x64, 0x11					}, { vpcmpgtb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x65, 0xd4					}, { vpcmpgtw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x65, 0x11					}, { vpcmpgtw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x65, 0x11					}, { vpcmpgtw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x66, 0xd4					}, { vpcmpgtd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x66, 0x11					}, { vpcmpgtd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x66, 0x11					}, { vpcmpgtd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x37, 0xd4					}, { vpcmpgtq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x37, 0x11					}, { vpcmpgtq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x37, 0x11					}, { vpcmpgtq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x01, 0xd4					}, { vphaddw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x01, 0x11					}, { vphaddw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x01, 0x11					}, { vphaddw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x02, 0xd4					}, { vphaddd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x02, 0x11					}, { vphaddd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x02, 0x11					}, { vphaddd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x03, 0xd4					}, { vphaddsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x03, 0x11					}, { vphaddsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x03, 0x11					}, { vphaddsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x05, 0xd4					}, { vphsubw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x05, 0x11					}, { vphsubw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x05, 0x11					}, { vphsubw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x06, 0xd4					}, { vphsubd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x06, 0x11					}, { vphsubd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x06, 0x11					}, { vphsubd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x07, 0xd4					}, { vphsubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x07, 0x11					}, { vphsubsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x07, 0x11					}, { vphsubsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf5, 0xd4					}, { vpmaddwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf5, 0x11					}, { vpmaddwd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf5, 0x11					}, { vpmaddwd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x04, 0xd4					}, { vpmaddubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x04, 0x11					}, { vpmaddubsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x04, 0x11					}, { vpmaddubsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3c, 0xd4					}, { vpmaxsb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3c, 0x11					}, { vpmaxsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3c, 0x11					}, { vpmaxsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xee, 0xd4					}, { vpmaxsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xee, 0x11					}, { vpmaxsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xee, 0x11					}, { vpmaxsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3d, 0xd4					}, { vpmaxsd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3d, 0x11					}, { vpmaxsd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3d, 0x11					}, { vpmaxsd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xde, 0xd4					}, { vpmaxub ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xde, 0x11					}, { vpmaxub ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xde, 0x11					}, { vpmaxub ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3e, 0xd4					}, { vpmaxuw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3e, 0x11					}, { vpmaxuw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3e, 0x11					}, { vpmaxuw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3f, 0xd4					}, { vpmaxud ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3f, 0x11					}, { vpmaxud ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3f, 0x11					}, { vpmaxud ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x38, 0xd4					}, { vpminsb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x38, 0x11					}, { vpminsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x38, 0x11					}, { vpminsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xea, 0xd4					}, { vpminsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xea, 0x11					}, { vpminsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xea, 0x11					}, { vpminsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x39, 0xd4					}, { vpminsd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x39, 0x11					}, { vpminsd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x39, 0x11					}, { vpminsd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xda, 0xd4					}, { vpminub ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xda, 0x11					}, { vpminub ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xda, 0x11					}, { vpminub ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3a, 0xd4					}, { vpminuw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3a, 0x11					}, { vpminuw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3a, 0x11					}, { vpminuw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3b, 0xd4					}, { vpminud ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3b, 0x11					}, { vpminud ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x3b, 0x11					}, { vpminud ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe4, 0xd4					}, { vpmulhuw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe4, 0x11					}, { vpmulhuw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe4, 0x11					}, { vpmulhuw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0b, 0xd4					}, { vpmulhrsw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0b, 0x11					}, { vpmulhrsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0b, 0x11					}, { vpmulhrsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe5, 0xd4					}, { vpmulhw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe5, 0x11					}, { vpmulhw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe5, 0x11					}, { vpmulhw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd5, 0xd4					}, { vpmullw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd5, 0x11					}, { vpmullw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd5, 0x11					}, { vpmullw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x40, 0xd4					}, { vpmulld ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x40, 0x11					}, { vpmulld ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x40, 0x11					}, { vpmulld ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf4, 0xd4					}, { vpmuludq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf4, 0x11					}, { vpmuludq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf4, 0x11					}, { vpmuludq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x28, 0xd4					}, { vpmuldq ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x28, 0x11					}, { vpmuldq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x28, 0x11					}, { vpmuldq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xeb, 0xd4					}, { vpor ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xeb, 0x11					}, { vpor ymm2,ymm6,YWORD [rcx]				}
testcase	{ 0xc5, 0xcd, 0xeb, 0x11					}, { vpor ymm2,ymm6,YWORD [rcx]				}
testcase	{ 0xc5, 0xcd, 0xf6, 0xd4					}, { vpsadbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf6, 0x11					}, { vpsadbw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf6, 0x11					}, { vpsadbw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x00, 0xd4					}, { vpshufb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x00, 0x11					}, { vpshufb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x00, 0x11					}, { vpshufb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x08, 0xd4					}, { vpsignb ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x08, 0x11					}, { vpsignb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x08, 0x11					}, { vpsignb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x09, 0xd4					}, { vpsignw ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x09, 0x11					}, { vpsignw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x09, 0x11					}, { vpsignw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0a, 0xd4					}, { vpsignd ymm2,ymm6,ymm4				}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0a, 0x11					}, { vpsignd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x4d, 0x0a, 0x11					}, { vpsignd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf8, 0xd4					}, { vpsubb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf8, 0x11					}, { vpsubb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf8, 0x11					}, { vpsubb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf9, 0xd4					}, { vpsubw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xf9, 0x11					}, { vpsubw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf9, 0x11					}, { vpsubw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfa, 0xd4					}, { vpsubd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfa, 0x11					}, { vpsubd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfa, 0x11					}, { vpsubd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfb, 0xd4					}, { vpsubq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xfb, 0x11					}, { vpsubq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xfb, 0x11					}, { vpsubq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe8, 0xd4					}, { vpsubsb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe8, 0x11					}, { vpsubsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe8, 0x11					}, { vpsubsb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe9, 0xd4					}, { vpsubsw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xe9, 0x11					}, { vpsubsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe9, 0x11					}, { vpsubsw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd8, 0xd4					}, { vpsubusb ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd8, 0x11					}, { vpsubusb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd8, 0x11					}, { vpsubusb ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd9, 0xd4					}, { vpsubusw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xd9, 0x11					}, { vpsubusw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd9, 0x11					}, { vpsubusw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x68, 0xd4					}, { vpunpckhbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x68, 0x11					}, { vpunpckhbw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x68, 0x11					}, { vpunpckhbw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x69, 0xd4					}, { vpunpckhwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x69, 0x11					}, { vpunpckhwd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x69, 0x11					}, { vpunpckhwd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x6a, 0xd4					}, { vpunpckhdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6a, 0x11					}, { vpunpckhdq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x6a, 0x11					}, { vpunpckhdq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x6d, 0xd4					}, { vpunpckhqdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6d, 0x11					}, { vpunpckhqdq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x6d, 0x11					}, { vpunpckhqdq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x60, 0xd4					}, { vpunpcklbw ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x60, 0x11					}, { vpunpcklbw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x60, 0x11					}, { vpunpcklbw ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x61, 0xd4					}, { vpunpcklwd ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x61, 0x11					}, { vpunpcklwd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x61, 0x11					}, { vpunpcklwd ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x62, 0xd4					}, { vpunpckldq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x62, 0x11					}, { vpunpckldq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x62, 0x11					}, { vpunpckldq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x6c, 0xd4					}, { vpunpcklqdq ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0x6c, 0x11					}, { vpunpcklqdq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0x6c, 0x11					}, { vpunpcklqdq ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xef, 0xd4					}, { vpxor ymm2,ymm6,ymm4				}
testcase	{ 0xc5, 0xcd, 0xef, 0x11					}, { vpxor ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xef, 0x11					}, { vpxor ymm2,ymm6,YWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1c, 0xf4					}, { vpabsb ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1c, 0x21					}, { vpabsb ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1c, 0x21					}, { vpabsb ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1d, 0xf4					}, { vpabsw ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1d, 0x21					}, { vpabsw ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1d, 0x21					}, { vpabsw ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1e, 0xf4					}, { vpabsd ymm6,ymm4					}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1e, 0x21					}, { vpabsd ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x1e, 0x21					}, { vpabsd ymm4,YWORD [rcx]				}
testcase	{ 0xc4, 0xe3, 0x4d, 0x42, 0xd4, 0x07				}, { vmpsadbw ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x42, 0x11, 0x07				}, { vmpsadbw ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x42, 0x11, 0x07				}, { vmpsadbw ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0f, 0xd4, 0x07				}, { vpalignr ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0f, 0x11, 0x07				}, { vpalignr ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0f, 0x11, 0x07				}, { vpalignr ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0e, 0xd4, 0x07				}, { vpblendw ymm2,ymm6,ymm4,0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0e, 0x11, 0x07				}, { vpblendw ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x4d, 0x0e, 0x11, 0x07				}, { vpblendw ymm2,ymm6,YWORD [rcx],0x7			}
testcase	{ 0xc4, 0xe3, 0x6d, 0x4c, 0xfe, 0x40				}, { vpblendvb ymm7,ymm2,ymm6,ymm4			}
testcase	{ 0xc4, 0xe3, 0x6d, 0x4c, 0x39, 0x40				}, { vpblendvb ymm7,ymm2,YWORD [rcx],ymm4		}
testcase	{ 0xc4, 0xe3, 0x6d, 0x4c, 0x39, 0x40				}, { vpblendvb ymm7,ymm2,YWORD [rcx],ymm4		}
testcase	{ 0xc5, 0xcd, 0xf1, 0xd4					}, { vpsllw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf1, 0x11					}, { vpsllw ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf1, 0x11					}, { vpsllw ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf2, 0xd4					}, { vpslld ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf2, 0x11					}, { vpslld ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf2, 0x11					}, { vpslld ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf3, 0xd4					}, { vpsllq ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xf3, 0x11					}, { vpsllq ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xf3, 0x11					}, { vpsllq ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe1, 0xd4					}, { vpsraw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xe1, 0x11					}, { vpsraw ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe1, 0x11					}, { vpsraw ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe2, 0xd4					}, { vpsrad ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xe2, 0x11					}, { vpsrad ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xe2, 0x11					}, { vpsrad ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd1, 0xd4					}, { vpsrlw ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd1, 0x11					}, { vpsrlw ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd1, 0x11					}, { vpsrlw ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd2, 0xd4					}, { vpsrld ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd2, 0x11					}, { vpsrld ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd2, 0x11					}, { vpsrld ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd3, 0xd4					}, { vpsrlq ymm2,ymm6,xmm4				}
testcase	{ 0xc5, 0xcd, 0xd3, 0x11					}, { vpsrlq ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc5, 0xcd, 0xd3, 0x11					}, { vpsrlq ymm2,ymm6,OWORD [rcx]			}
testcase	{ 0xc4, 0xe2, 0x7d, 0x20, 0xe4					}, { vpmovsxbw ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x20, 0x21					}, { vpmovsxbw ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x20, 0x21					}, { vpmovsxbw ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x23, 0xe4					}, { vpmovsxwd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x23, 0x21					}, { vpmovsxwd ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x23, 0x21					}, { vpmovsxwd ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x25, 0xe4					}, { vpmovsxdq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x25, 0x21					}, { vpmovsxdq ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x25, 0x21					}, { vpmovsxdq ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x30, 0xe4					}, { vpmovzxbw ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x30, 0x21					}, { vpmovzxbw ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x30, 0x21					}, { vpmovzxbw ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x33, 0xe4					}, { vpmovzxwd ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x33, 0x21					}, { vpmovzxwd ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x33, 0x21					}, { vpmovzxwd ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x35, 0xe4					}, { vpmovzxdq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x35, 0x21					}, { vpmovzxdq ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x35, 0x21					}, { vpmovzxdq ymm4,OWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x21, 0xf4					}, { vpmovsxbd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x21, 0x21					}, { vpmovsxbd ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x21, 0x21					}, { vpmovsxbd ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x24, 0xf4					}, { vpmovsxwq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x24, 0x21					}, { vpmovsxwq ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x24, 0x21					}, { vpmovsxwq ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x31, 0xf4					}, { vpmovzxbd ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x31, 0x21					}, { vpmovzxbd ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x31, 0x21					}, { vpmovzxbd ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x34, 0xf4					}, { vpmovzxwq ymm6,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x34, 0x21					}, { vpmovzxwq ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x34, 0x21					}, { vpmovzxwq ymm4,QWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x22, 0xe4					}, { vpmovsxbq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x22, 0x21					}, { vpmovsxbq ymm4,DWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x22, 0x21					}, { vpmovsxbq ymm4,DWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x32, 0xe4					}, { vpmovzxbq ymm4,xmm4				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x32, 0x21					}, { vpmovzxbq ymm4,DWORD [rcx]				}
testcase	{ 0xc4, 0xe2, 0x7d, 0x32, 0x21					}, { vpmovzxbq ymm4,DWORD [rcx]				}

; EOF
