#include "ipbase.ih"

void IPbase::logData(Record const &record) const
{
    auto ptr = ShowSeconds::utcFormat();

    d_logDataStream << 
                    record.protocolStr()    << ',' <<
        setw(11) << ntohl(record.sourceIP())<< ',' <<
        setw(16) << record.sourceIPstr()    << ',' <<
        setw(8)  << record.sourcePort()     << ',';

    (this->*d_dstData)(record);
    (this->*d_viaData)(record);
    (this->*d_byteCountsData)(record);

    d_logDataStream <<
        setw(11) << record.inSeconds()      << ',' <<
        setw(11) << record.seconds()        << ", " <<
                     record.beginTime()     << ", " <<
                     record.endTime()       << ", " <<
        setw(10) << s_logTypeText[s_logType].second << endl;

    ShowSeconds::setFormat(ptr);
}






