/* $Id: ProjectFolder.hpp 431328 2014-04-02 21:18:04Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ProjectFolder.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: ProjectFolder_.hpp


#ifndef OBJECTS_GBPROJ_PROJECTFOLDER_HPP
#define OBJECTS_GBPROJ_PROJECTFOLDER_HPP


// generated includes
#include <objects/gbproj/ProjectFolder_.hpp>

// generated classes
#include <corelib/ncbicntr.hpp>
#include <objects/gbproj/ProjectItem.hpp>

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBPROJ_EXPORT CProjectFolder : public CProjectFolder_Base
{
    typedef CProjectFolder_Base Tparent;
public:
    typedef CAtomicCounter::TValue TId;

    class IProjectItemVisitor
    {
    public:
        virtual bool Visit(objects::CProjectItem& item) = 0;
        virtual ~IProjectItemVisitor()    {};
    };

public:
    // constructor
    CProjectFolder(void);
    // destructor
    ~CProjectFolder(void);

    TId GetId() const { return m_Id; }

    void    SetParentFolder(CProjectFolder*) {}
    CProjectFolder* GetParentFolder() { return 0; }

    const CProjectItem*   GetProjectItem(CProjectItem::TId id) const;
    CProjectItem*         GetProjectItem(CProjectItem::TId id);

    const CProjectFolder* GetProjectFolder(CProjectFolder::TId id) const;
    CProjectFolder*       GetProjectFolder(CProjectFolder::TId id);

    CProjectItem*         FindProjectItemById(CProjectItem::TId id);
    const CProjectItem*   FindProjectItemById(CProjectItem::TId id) const;

    CProjectItem*   FindProjectItemByLabel(const string& label);
    CProjectItem*   FindProjectItemByData(const CSerialObject& object, bool recursive);

    CProjectFolder* FindChildFolderByTitle(const string& title);

    const CProjectFolder* FindChildFolderById(TId id) const;
    CProjectFolder* FindChildFolderById(TId id);

    const CProjectFolder* FindProjectItemFolder(CProjectItem::TId id) const;
    CProjectFolder*       FindProjectItemFolder(CProjectItem::TId id);

    CRef<CProjectFolder>  RemoveProjectFolder(CProjectFolder::TId id);

    void    AddChildItem(CProjectItem& child_item);
    bool    RemoveChildItem(CProjectItem& child_item);
    bool    RemoveChildItem(CProjectItem::TId id);
    void    RemoveAllChildItems();

    void    AddChildFolder(CProjectFolder& child_folder);
    void    RemoveChildFolder(CProjectFolder& child_folder);
    void    RemoveChildFolder(CProjectFolder::TId folder_id);

    /// applies the given visitor to all project items until the visitor returns false
    bool    ForEachProjectItem(IProjectItemVisitor& visitor, bool recursive);

private:
    // Prohibit copy constructor and assignment operator
    CProjectFolder(const CProjectFolder& value);
    CProjectFolder& operator=(const CProjectFolder& value);

protected:
    static CAtomicCounter   m_IdCounter;

    TId m_Id;
};

/////////////////// CProjectFolder inline methods

// constructor
inline
CProjectFolder::CProjectFolder(void)
{
    m_Id = m_IdCounter.Add(1) - 1;
}


/////////////////// end of CProjectFolder inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_PROJECTFOLDER_HPP
/* Original file checksum: lines: 86, chars: 2486, CRC32: 1d8505d9 */
