/* $Id: SeqEdit_Cmd.hpp 103491 2007-05-04 17:18:18Z kazimird $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqEdit_Cmd.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqedit.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: SeqEdit_Cmd_.hpp


#ifndef OBJECTS_SEQEDIT_SEQEDIT_CMD_HPP
#define OBJECTS_SEQEDIT_SEQEDIT_CMD_HPP


// generated includes
#include <objects/seqedit/SeqEdit_Cmd_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQEDIT_EXPORT CSeqEdit_Cmd : public CSeqEdit_Cmd_Base
{
    typedef CSeqEdit_Cmd_Base Tparent;
public:
    // constructor
    CSeqEdit_Cmd(void);
    CSeqEdit_Cmd(const string& blobid);
    // destructor
    ~CSeqEdit_Cmd(void);

    const string& GetBlobId() const;

private:
    string m_BlobId;

    // Prohibit copy constructor and assignment operator
    CSeqEdit_Cmd(const CSeqEdit_Cmd& value);
    CSeqEdit_Cmd& operator=(const CSeqEdit_Cmd& value);

};

/////////////////// CSeqEdit_Cmd inline methods

// constructor
inline
CSeqEdit_Cmd::CSeqEdit_Cmd(void)
{
}

inline
CSeqEdit_Cmd::CSeqEdit_Cmd(const string& blobid)
    : m_BlobId(blobid)
{    
}

inline
const string& CSeqEdit_Cmd::GetBlobId() const
{
    return m_BlobId;
}

/////////////////// end of CSeqEdit_Cmd inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // OBJECTS_SEQEDIT_SEQEDIT_CMD_HPP
/* Original file checksum: lines: 94, chars: 2601, CRC32: 155a5602 */
