/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;

public abstract class DDBeanTableModel extends AbstractTableModel
{
	private List children;
        private CommonDDBean parent;

        protected abstract String[] getColumnNames();

        protected CommonDDBean getParent() {
            return parent;
        }

        protected List getChildren() {
            return children;
        }

	public int getColumnCount()
	{
		return getColumnNames().length;
	}


	public int getRowCount()
	{
		if (children != null)
		{
			return (children.size());
		}
		else
		{
			return (0);
		}
	}


    @Override
    public String getColumnName(int column)
    {
		return getColumnNames()[column];
	}
        
    @Override
	public boolean isCellEditable(int row, int column)
	{
		return (false);
	}

	public int getRowWithValue(int column, Object value)
	{
		for(int row = 0; row < getRowCount(); row++)
		{
			Object obj = getValueAt(row, column);
			if (obj.equals(value))
			{
				return (row);
			}
		}

		return (-1);
	}
        
	public abstract CommonDDBean addRow(Object[] values);

	public abstract void editRow(int row, Object[] values);
        
	public abstract void removeRow(int row);
        
	public void setData(CommonDDBean parent,CommonDDBean[] children) {
		this.parent = parent;
                this.children = new java.util.ArrayList();
                if (children==null) return;
                for(int i=0;i<children.length;i++)
                this.children.add(children[i]);
		fireTableDataChanged();
    }
        
}
