/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * SSHKeysPanel.java
 *
 * Created on 25.04.2010, 22:12:13
 */

package org.netbeans.modules.nativeexecution.ui;

import java.io.File;
import javax.swing.JFileChooser;

/**
 *
 * @author ak119685
 */
public class SSHKeysPanel extends javax.swing.JPanel {

    /** Creates new form SSHKeysPanel */
    public SSHKeysPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        fldIdentity = new javax.swing.JTextField();
        btnBrowseIdentity = new javax.swing.JButton();
        fldHosts = new javax.swing.JTextField();
        btnBrowseHosts = new javax.swing.JButton();

        jLabel1.setLabelFor(fldIdentity);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(SSHKeysPanel.class, "SSHKeysPanel.jLabel1.text")); // NOI18N

        jLabel2.setLabelFor(fldHosts);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(SSHKeysPanel.class, "SSHKeysPanel.jLabel2.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(btnBrowseIdentity, org.openide.util.NbBundle.getMessage(SSHKeysPanel.class, "SSHKeysPanel.btnBrowseIdentity.text")); // NOI18N
        btnBrowseIdentity.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnBrowseIdentityActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(btnBrowseHosts, org.openide.util.NbBundle.getMessage(SSHKeysPanel.class, "SSHKeysPanel.btnBrowseHosts.text")); // NOI18N
        btnBrowseHosts.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnBrowseHostsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 104, Short.MAX_VALUE)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(fldIdentity, javax.swing.GroupLayout.DEFAULT_SIZE, 263, Short.MAX_VALUE)
                    .addComponent(fldHosts, javax.swing.GroupLayout.DEFAULT_SIZE, 263, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(btnBrowseIdentity)
                    .addComponent(btnBrowseHosts)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(fldIdentity, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnBrowseIdentity))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(fldHosts, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnBrowseHosts)))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnBrowseIdentityActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnBrowseIdentityActionPerformed
        File file = openFile();
        if (file != null) {
            fldIdentity.setText(file.getAbsolutePath());
        }
    }//GEN-LAST:event_btnBrowseIdentityActionPerformed

    private void btnBrowseHostsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnBrowseHostsActionPerformed
         File file = openFile();
        if (file != null) {
            fldHosts.setText(file.getAbsolutePath());
        }
    }//GEN-LAST:event_btnBrowseHostsActionPerformed

    private File openFile() {
        String home = System.getProperty("user.home"); // NOI18N
        JFileChooser chooser = new JFileChooser(home);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(false);
        int dlgResult = chooser.showOpenDialog(this);
        if (JFileChooser.APPROVE_OPTION == dlgResult) {
            File result = chooser.getSelectedFile();
            if (result != null && !result.exists()) {
                result = null;
            }
            return result;
        } else {
            return null;
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnBrowseHosts;
    private javax.swing.JButton btnBrowseIdentity;
    private javax.swing.JTextField fldHosts;
    private javax.swing.JTextField fldIdentity;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    // End of variables declaration//GEN-END:variables

}
