/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.editor.global.format;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle.Messages;

/**
 *
 * @author lahvac
 */
public class ConfirmationPanel extends javax.swing.JPanel {

    private static final String PANEL_PROGRESS = "progress";
    private static final String PANEL_QUESTION = "question";
    
    @Messages({
        "LBL_FormattingQuestion=Recursively format the selected files and folders?",
        "LBL_FormattingInProgress=Formatting:"
    })
    public ConfirmationPanel(ProgressHandle handle) {
        initComponents();
        setLayout(new CardLayout());
        add(new JLabel(Bundle.LBL_FormattingQuestion()), PANEL_QUESTION);
        JPanel progress = new JPanel(new BorderLayout());
        JLabel inProgressLabel = new JLabel(Bundle.LBL_FormattingInProgress());
        inProgressLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        progress.add(inProgressLabel, BorderLayout.NORTH);
        progress.add(ProgressHandleFactory.createProgressComponent(handle), BorderLayout.CENTER);
        add(progress, PANEL_PROGRESS);
        ((CardLayout) getLayout()).show(this, PANEL_QUESTION);
    }
    
    public void started() {
        ((CardLayout) getLayout()).show(this, PANEL_PROGRESS);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 0, 12));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 354, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 288, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
