/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.git.ui.repository.remote;

/**
 *
 * @author Tomas Stupka
 */
public class RemoteRepositoryPanel extends javax.swing.JPanel {

    /** Creates new form RepositoryPanel */
    public RemoteRepositoryPanel() {
        initComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/git/ui/clone/Bundle"); // NOI18N
        setName(bundle.getString("BK2018")); // NOI18N
        setVerifyInputWhenFocusTarget(false);

        org.openide.awt.Mnemonics.setLocalizedText(tipLabel, "-"); // NOI18N
        tipLabel.setMaximumSize(new java.awt.Dimension(32767, 32767));

        org.openide.awt.Mnemonics.setLocalizedText(proxySettingsButton, org.openide.util.NbBundle.getMessage(RemoteRepositoryPanel.class, "BK0006")); // NOI18N
        proxySettingsButton.setToolTipText(org.openide.util.NbBundle.getMessage(RemoteRepositoryPanel.class, "ACSD_ProxyDialog")); // NOI18N
        proxySettingsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                proxySettingsButtonActionPerformed(evt);
            }
        });

        repositoryLabel.setLabelFor(urlComboBox);
        org.openide.awt.Mnemonics.setLocalizedText(repositoryLabel, org.openide.util.NbBundle.getMessage(RemoteRepositoryPanel.class, "BK0002")); // NOI18N
        repositoryLabel.setToolTipText(org.openide.util.NbBundle.getMessage(RemoteRepositoryPanel.class, "TT_RepositoryUrl")); // NOI18N

        urlComboBox.setEditable(true);
        java.awt.Component editorComp = urlComboBox.getEditor().getEditorComponent();
        if (editorComp instanceof javax.swing.JTextField) {
            ((javax.swing.JTextField) editorComp).setColumns(35);
        }

        org.openide.awt.Mnemonics.setLocalizedText(directoryBrowseButton, org.openide.util.NbBundle.getMessage(RemoteRepositoryPanel.class, "directoryBrowseButton.Name")); // NOI18N
        directoryBrowseButton.setToolTipText(org.openide.util.NbBundle.getMessage(RemoteRepositoryPanel.class, "TT_Browse")); // NOI18N

        connectionSettings.setLayout(new java.awt.BorderLayout());

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(repositoryLabel)
                .addGap(12, 12, 12)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(tipLabel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 383, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(urlComboBox, 0, 275, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(directoryBrowseButton))))
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(connectionSettings, javax.swing.GroupLayout.PREFERRED_SIZE, 496, Short.MAX_VALUE)
                    .addComponent(proxySettingsButton))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(repositoryLabel)
                    .addComponent(urlComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(directoryBrowseButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tipLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(connectionSettings, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(proxySettingsButton)
                .addContainerGap())
        );

        proxySettingsButton.getAccessibleContext().setAccessibleParent(this);
        repositoryLabel.getAccessibleContext().setAccessibleParent(this);
        urlComboBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(RemoteRepositoryPanel.class, "ACSN_RepositoryURL")); // NOI18N
        urlComboBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(RemoteRepositoryPanel.class, "ACSD_RepositoryURL")); // NOI18N
        urlComboBox.getAccessibleContext().setAccessibleParent(this);

        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(RemoteRepositoryPanel.class, "ACSD_RepositoryPanel")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void proxySettingsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_proxySettingsButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_proxySettingsButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JPanel connectionSettings = new javax.swing.JPanel();
    final javax.swing.JButton directoryBrowseButton = new javax.swing.JButton();
    final javax.swing.JButton proxySettingsButton = new javax.swing.JButton();
    final javax.swing.JLabel repositoryLabel = new javax.swing.JLabel();
    final javax.swing.JLabel tipLabel = new javax.swing.JLabel();
    final javax.swing.JComboBox urlComboBox = new javax.swing.JComboBox();
    // End of variables declaration//GEN-END:variables
        
}
