/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.hudson.constants;

/**
 * Constants provider for HudsonJob
 *
 * @author Michal Mocnak
 */
public class HudsonJobConstants {

    private HudsonJobConstants() {}
    
    public static final String JOB_DISPLAY_NAME = "job_display_name"; // NOI18N
    
    public static final String JOB_NAME = "job_name"; // NOI18N
    
    public static final String JOB_URL = "job_url"; // NOI18N
    
    public static final String JOB_COLOR = "job_color"; // NOI18N
    
    public static final String JOB_IN_QUEUE = "job_in_queue"; // NOI18N
    
    public static final String JOB_BUILDABLE = "job_buildable"; // NOI18N
    
    public static final String JOB_LAST_BUILD = "job_last_build"; // NOI18N
    
    public static final String JOB_LAST_STABLE_BUILD = "job_last_stable_build"; // NOI18N
    
    public static final String JOB_LAST_SUCCESSFUL_BUILD = "job_last_successful_build"; // NOI18N

    public static final String JOB_LAST_COMPLETED_BUILD = "job_last_completed_build"; // NOI18N

    public static final String JOB_LAST_FAILED_BUILD = "job_last_failed_build"; // NOI18N

}
