/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.palette.ui;

import java.awt.Image;
import java.io.File;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;

/**
 *
 * @author  S. Aubrecht
 */
class TextImporterUI extends javax.swing.JPanel {

    private String smallIconPath;
    private String largeIconPath;
    
    /** Creates new form TextImporterDlg */
    public TextImporterUI( String content, final JButton btnOk ) {
        initComponents();
        txtContent.setText(content);
        txtContent.setCaretPosition(0);
        
        DocumentListener dl = new DocumentListener() {
            public void insertUpdate(DocumentEvent e) {
                updateButton( btnOk );
            }

            public void removeUpdate(DocumentEvent e) {
                updateButton( btnOk );
            }

            public void changedUpdate(DocumentEvent e) {
                updateButton( btnOk );
            }
        };
        updateButton(btnOk);
        txtName.getDocument().addDocumentListener(dl);
        txtContent.getDocument().addDocumentListener(dl);
    }
    
    String getItemName() {
        return txtName.getText();
    }
    
    String getItemTooltip() {
        return txtTooltip.getText();
    }
    
    String getItemContent() {
        return txtContent.getText();
    }
    
    String getItemSmallIconPath() {
        return smallIconPath;
    }
    
    String getItemLargeIconPath() {
        return largeIconPath;
    }
    
    private void updateButton( final JButton btn ) {
        SwingUtilities.invokeLater( new Runnable() {
            public void run() {
                boolean enable = txtName.getText().length() > 0;
                enable &= txtContent.getText().length() > 0;
                btn.setEnabled(enable);
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        txtName = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        txtTooltip = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        txtContent = new javax.swing.JTextArea();
        lblLargeIcon = new javax.swing.JLabel();
        btnSelectLargeIcon = new javax.swing.JButton();
        lblSmallIcon = new javax.swing.JLabel();
        btnSelectSmallIcon = new javax.swing.JButton();

        jLabel1.setDisplayedMnemonic('N');
        jLabel1.setLabelFor(txtName);
        jLabel1.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.jLabel1.text")); // NOI18N

        txtName.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.txtName.text")); // NOI18N

        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setLabelFor(txtTooltip);
        jLabel2.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.jLabel2.text")); // NOI18N

        txtTooltip.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.txtTooltip.text")); // NOI18N

        jLabel3.setLabelFor(lblSmallIcon);
        jLabel3.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.jLabel3.text")); // NOI18N

        jLabel4.setLabelFor(lblLargeIcon);
        jLabel4.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.jLabel4.text")); // NOI18N

        jLabel5.setDisplayedMnemonic('C');
        jLabel5.setLabelFor(txtContent);
        jLabel5.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.jLabel5.text")); // NOI18N

        txtContent.setColumns(20);
        txtContent.setRows(5);
        jScrollPane1.setViewportView(txtContent);
        txtContent.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.txtContent.AccessibleContext.accessibleDescription")); // NOI18N

        lblLargeIcon.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblLargeIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/palette/resources/unknown32.gif"))); // NOI18N
        lblLargeIcon.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.lblLargeIcon.text")); // NOI18N
        lblLargeIcon.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        lblLargeIcon.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        lblLargeIcon.setIconTextGap(0);
        lblLargeIcon.setPreferredSize(new java.awt.Dimension(40, 40));

        btnSelectLargeIcon.setMnemonic('e');
        btnSelectLargeIcon.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.btnSelectLargeIcon.text")); // NOI18N
        btnSelectLargeIcon.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSelectLargeIconActionPerformed(evt);
            }
        });

        lblSmallIcon.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblSmallIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/palette/resources/unknown16.gif"))); // NOI18N
        lblSmallIcon.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.lblSmallIcon.text")); // NOI18N
        lblSmallIcon.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        lblSmallIcon.setFocusable(false);
        lblSmallIcon.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        lblSmallIcon.setIconTextGap(0);
        lblSmallIcon.setPreferredSize(new java.awt.Dimension(40, 40));

        btnSelectSmallIcon.setMnemonic('S');
        btnSelectSmallIcon.setText(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.btnSelectSmallIcon.text")); // NOI18N
        btnSelectSmallIcon.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSelectSmallIconActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 577, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel2))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(txtTooltip, javax.swing.GroupLayout.DEFAULT_SIZE, 511, Short.MAX_VALUE)
                            .addComponent(txtName, javax.swing.GroupLayout.DEFAULT_SIZE, 511, Short.MAX_VALUE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(lblSmallIcon, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnSelectSmallIcon)
                        .addGap(14, 14, 14)
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(lblLargeIcon, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnSelectLargeIcon))
                    .addComponent(jLabel5, javax.swing.GroupLayout.Alignment.LEADING))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(txtName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(txtTooltip, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblSmallIcon, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3)
                    .addComponent(btnSelectSmallIcon)
                    .addComponent(jLabel4)
                    .addComponent(lblLargeIcon, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnSelectLargeIcon))
                .addGap(18, 18, 18)
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 138, Short.MAX_VALUE)
                .addContainerGap())
        );

        txtName.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.txtName.AccessibleContext.accessibleName")); // NOI18N
        txtName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.txtName.AccessibleContext.accessibleDescription")); // NOI18N
        txtTooltip.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.txtTooltip.AccessibleContext.accessibleDescription")); // NOI18N
        lblLargeIcon.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.lblLargeIcon.AccessibleContext.accessibleName")); // NOI18N
        lblLargeIcon.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.lblLargeIcon.AccessibleContext.accessibleDescription")); // NOI18N
        btnSelectLargeIcon.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.btnSelectLargeIcon.AccessibleContext.accessibleDescription")); // NOI18N
        lblSmallIcon.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.lblSmallIcon.AccessibleContext.accessibleName")); // NOI18N
        lblSmallIcon.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.lblSmallIcon.AccessibleContext.accessibleDescription")); // NOI18N
        btnSelectSmallIcon.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TextImporterUI.class, "TextImporterUI.btnSelectSmallIcon.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

private void btnSelectLargeIconActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSelectLargeIconActionPerformed
    File iconFile = selectIconFile();
    if( null != iconFile ) {
        Icon icon = readIconFromFile( iconFile );
        if( null != icon ) {
            lblLargeIcon.setIcon(icon);
            try {
                largeIconPath = iconFile.toURL().toExternalForm();
            } catch (MalformedURLException ex) {
                //TODO log error
            }
        }
    }
}//GEN-LAST:event_btnSelectLargeIconActionPerformed

private void btnSelectSmallIconActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSelectSmallIconActionPerformed
    File iconFile = selectIconFile();
    if( null != iconFile ) {
        Icon icon = readIconFromFile( iconFile );
        if( null != icon ) {
            lblSmallIcon.setIcon(icon);
            try {
                smallIconPath = iconFile.toURL().toExternalForm();
            } catch (MalformedURLException ex) {
                //TODO log error
            }
        }
    }
}//GEN-LAST:event_btnSelectSmallIconActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnSelectLargeIcon;
    private javax.swing.JButton btnSelectSmallIcon;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblLargeIcon;
    private javax.swing.JLabel lblSmallIcon;
    private javax.swing.JTextArea txtContent;
    private javax.swing.JTextField txtName;
    private javax.swing.JTextField txtTooltip;
    // End of variables declaration//GEN-END:variables

    private static File defaultFolder;
    
    private File selectIconFile() {
        JFileChooser dlg = new JFileChooser( defaultFolder );
        dlg.setAcceptAllFileFilterUsed( true );
        dlg.setMultiSelectionEnabled( false );
        if( dlg.showOpenDialog(this) != JFileChooser.APPROVE_OPTION )
            return null;
        defaultFolder = dlg.getCurrentDirectory();
        return dlg.getSelectedFile();
    }
    
    private Icon readIconFromFile( File iconFile ) {
        try {
            Image img = ImageIO.read( iconFile.toURL() );
            if( null != img ) {
                ImageIcon res = new ImageIcon( img );
                if( res.getIconWidth() > 32 || res.getIconHeight() > 32 )  {
                    JOptionPane.showMessageDialog(this, NbBundle.getMessage(TextImporterUI.class, "Err_IconTooBig"), //NOI18N
                            NbBundle.getMessage(TextImporterUI.class, "Err_Title"), JOptionPane.ERROR_MESSAGE  ); //NOI18N
                    return null;
                }
                return res;
            }
        } catch( ThreadDeath td ) {
            throw td;
        } catch( Throwable ioE ) {
            //ignore
        }
        JOptionPane.showMessageDialog(this, 
                NbBundle.getMessage(TextImporterUI.class, "Err_CannotLoadIconFromFile", iconFile.getName()), //NOI18N
                NbBundle.getMessage(TextImporterUI.class, "Err_Title"), JOptionPane.ERROR_MESSAGE  ); //NOI18N
        return null;
    }
}
