<?php

interface Logger {
    public function log(string $msg);
}

$anonCls = new class implements Logger {
    public function log(string $msg) {
        echo $msg;
    }
};
var_dump($anonCls);

class Application {
    private $logger;

    public function getLogger(): Logger {
         return $this->logger;
    }

    public function setLogger(Logger $logger) {
         $this->logger = $logger;
    }
}

$app = new Application();
$app->setLogger(new class implements Logger {
    public function log(string $msg) {
        echo $msg;
    }
});

var_dump($app->getLogger());


// ----------------------------------------------------------------------

class SomeClass {
}
interface SomeInterface1 {
}
interface SomeInterface2 {
}
trait SomeTrait {
}

var_dump(new class(10) extends SomeClass implements SomeInterface1, SomeInterface2 {
    private $num;

    public function __construct($num) {
        $this->num = $num;
    }

    use SomeTrait;

});

// ----------------------------------------------------------------------

class Outer
{
    private $prop = 1;
    protected $prop2 = 2;

    protected function func1()
    {
        return 3;
    }

    public function func2()
    {
        return new class($this->prop) extends Outer {
            private $prop3;

            public function __construct($prop)
            {
                $this->prop3 = $prop;
            }

            public function func3()
            {
                return $this->prop2 + $this->prop3 + $this->func1();
            }
        };
    }
}

echo (new Outer)->func2()->func3();

// ----------------------------------------------------------------------

(new class implements Logger {
    public function log(string $msg) {
        echo $msg;
    }
})->log('hello world');
