/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.util.ResourceBundle;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.common.WebserviceDescription;
import org.netbeans.modules.j2ee.sun.ddloaders.SunDescriptorDataObject;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.BaseSectionNodeInnerPanel;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.DDTextFieldEditorModel;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.webservice.WebServiceNode;
import org.netbeans.modules.xml.multiview.ItemEditorHelper;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.openide.util.NbBundle;


/**
 *
 * @author Peter Williams
 */
public class WebServicePanel extends BaseSectionNodeInnerPanel {

    final ResourceBundle bundle = NbBundle.getBundle(
       "org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle"); // NOI18N

    // data model & version
    private WebServiceNode webServiceNode;


    public WebServicePanel(SectionNodeView sectionNodeView, final WebServiceNode webServiceNode, 
            final ASDDVersion version) {
        super(sectionNodeView, version);
        this.webServiceNode = webServiceNode;

        initComponents();
        initUserComponents(sectionNodeView);
    }

    private void initUserComponents(SectionNodeView sectionNodeView) {
        SunDescriptorDataObject dataObject = (SunDescriptorDataObject) sectionNodeView.getDataObject();
        XmlMultiViewDataSynchronizer synchronizer = dataObject.getModelSynchronizer();

        addRefreshable(new ItemEditorHelper(jTxtName, new WebServiceTextFieldEditorModel(synchronizer, WebserviceDescription.WEBSERVICE_DESCRIPTION_NAME)));
        addRefreshable(new ItemEditorHelper(jTxtWsdlPublishLocation, new WebServiceTextFieldEditorModel(synchronizer, WebserviceDescription.WSDL_PUBLISH_LOCATION)));

        jTxtName.setEditable(!webServiceNode.getBinding().isBound());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jLblName = new javax.swing.JLabel();
        jTxtName = new javax.swing.JTextField();
        jLblWsdlPublishLocation = new javax.swing.JLabel();
        jTxtWsdlPublishLocation = new javax.swing.JTextField();

        setAlignmentX(LEFT_ALIGNMENT);
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLblName.setLabelFor(jTxtName);
        jLblName.setText(bundle.getString("LBL_WebServiceDescriptionName_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel1.add(jLblName, gridBagConstraints);
        jLblName.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_WebServiceDescriptionName")); // NOI18N
        jLblName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_WebServiceDescriptionName")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPanel1.add(jTxtName, gridBagConstraints);

        jLblWsdlPublishLocation.setLabelFor(jTxtWsdlPublishLocation);
        jLblWsdlPublishLocation.setText(bundle.getString("LBL_WsdlPublishLocation_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(jLblWsdlPublishLocation, gridBagConstraints);
        jLblWsdlPublishLocation.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_WsdlPublishLocation")); // NOI18N
        jLblWsdlPublishLocation.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_WsdlPublishLocation")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel1.add(jTxtWsdlPublishLocation, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        add(jPanel1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLblName;
    private javax.swing.JLabel jLblWsdlPublishLocation;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTextField jTxtName;
    private javax.swing.JTextField jTxtWsdlPublishLocation;
    // End of variables declaration//GEN-END:variables

//	private void initUserComponents() {
//		// Add title panel
//		addTitlePanel(bundle.getString("TITLE_WebServiceDescriptor"));
//		getAccessibleContext().setAccessibleName(bundle.getString("ACSN_WebServiceDescriptor"));	// NOI18N
//		getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_WebServiceDescriptor"));	// NOI18N
//
//		/** Add selected endpoint panel */
//		selectedEndpointPanel = new SelectedEndpointPanel(this);
//
//        GridBagConstraints gridBagConstraints = new GridBagConstraints();
//        gridBagConstraints.gridwidth = GridBagConstraints.REMAINDER;
//        gridBagConstraints.fill = GridBagConstraints.BOTH;
//        gridBagConstraints.weightx = 1.0;
//        gridBagConstraints.weighty = 1.0;
//		gridBagConstraints.insets = new Insets(0, 6, 0, 5);
//        add(selectedEndpointPanel, gridBagConstraints);
//        
//		// Add error panel
//		addErrorPanel();
//	}
//
//	protected void initFields() {
//		jTxtName.setText(theBean.getWebServiceDescriptionName());
//        jTxtWsdlPublishLocation.setText(theBean.getWsdlPublishLocation());
//        
//        // endpoint combo & panel
//		// FIXME set combobox to proper value
//		endpointModel = new DefaultComboBoxModel();
//		List endpointList = theBean.getWebServiceEndpoints();
//		if(endpointList != null) {
//			Iterator iter = endpointList.iterator();
//			while(iter.hasNext()) {
//				WebserviceEndpoint endpoint = (WebserviceEndpoint) iter.next();
//				endpointModel.addElement(new EndpointMapping(endpoint));
//			}
//		}
//
//        // do endpoint panel enabling here, before we initialize the data.
//        // Otherwise, this method will undo certain selective enabling that is
//        // done on endpoint initialization.
//        enableButtonsAndPanels();
//        
//		jCbxPortSelector.setModel(endpointModel);
//
//		if(endpointModel.getSize() > 0) {
//			jCbxPortSelector.setSelectedIndex(0);
//		}
//	}
//    
//	private void enableButtonsAndPanels() {
//		boolean enabled = (endpointModel.getSize() > 0);
//		jCbxPortSelector.setEnabled(enabled);
//		selectedEndpointPanel.setContainerEnabled(selectedEndpointPanel, enabled);
//	}
//
//	public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
//		String eventName = propertyChangeEvent.getPropertyName();
//		
//		if(WebServiceDescriptor.WEBSERVICE_DESCRIPTION_NAME.equals(eventName)) {
//			jTxtName.setText(theBean.getWebServiceDescriptionName());
//		} else if(WebServiceDescriptor.ENDPOINT_SECURITY_BINDING.equals(eventName)) {
//            selectedEndpointPanel.reloadEndpointMapping();
//        }
//	}

    public String getHelpId() {
        return "AS_CFG_WebServiceDescriptor";    // NOI18N
    }

    // Model class for handling updates to the text fields
    private class WebServiceTextFieldEditorModel extends DDTextFieldEditorModel {

        public WebServiceTextFieldEditorModel(XmlMultiViewDataSynchronizer synchronizer, String propertyName) {
            super(synchronizer, propertyName);
        }

        public WebServiceTextFieldEditorModel(XmlMultiViewDataSynchronizer synchronizer, String propertyName, String attributeName) {
            super(synchronizer, propertyName, attributeName);
        }

        protected CommonDDBean getBean() {
            return webServiceNode.getBinding().getSunBean();
        }

        @Override
        protected void setValue(String value) {
            super.setValue(value);

            // If this was a virtual bean, commit it to the graph.
            if(webServiceNode.addVirtualBean()) {
                // update if necessary
            }
        }
    }
}
