/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */

package org.netbeans.modules.javacard.project.deps.ui;

import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ChooseDependencyKindPanelVisual extends JPanel {
    public static final String DEP_KIND_CLIENT_PROP = "_kind";
    private final WizardDescriptor wiz;

    /** Creates new form DependencyVisualPanel1 */
    ChooseDependencyKindPanelVisual(WizardDescriptor wiz) {
        this.wiz = wiz;
        initComponents();
        projectButton.putClientProperty(DEP_KIND_CLIENT_PROP, InitialDepKind.PROJECT);
        jarfileButton.putClientProperty(DEP_KIND_CLIENT_PROP, InitialDepKind.JAR_FILE);
        HelpCtx.setHelpIDString(this, "org.netbeans.modules.javacard.DependenciesPanel"); //NOI18N
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ChooseDependencyKindPanelVisual.class,
                "WIZARD_CHOOSE_LIBRARY_KIND"); //NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        projectButton = new javax.swing.JRadioButton();
        jarfileButton = new javax.swing.JRadioButton();
        projectDescription = new javax.swing.JLabel();
        jarFileDescription = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 12, 12));
        setLayout(new java.awt.GridBagLayout());

        buttonGroup1.add(projectButton);
        projectButton.setFont(projectButton.getFont().deriveFont(projectButton.getFont().getStyle() | java.awt.Font.BOLD));
        org.openide.awt.Mnemonics.setLocalizedText(projectButton, org.openide.util.NbBundle.getMessage(ChooseDependencyKindPanelVisual.class, "ChooseDependencyKindPanelVisual.projectButton.text")); // NOI18N
        projectButton.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                updateProjectKind(evt);
            }
        });
        projectButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onSelectKind(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(projectButton, gridBagConstraints);

        buttonGroup1.add(jarfileButton);
        jarfileButton.setFont(jarfileButton.getFont().deriveFont(jarfileButton.getFont().getStyle() | java.awt.Font.BOLD));
        org.openide.awt.Mnemonics.setLocalizedText(jarfileButton, org.openide.util.NbBundle.getMessage(ChooseDependencyKindPanelVisual.class, "ChooseDependencyKindPanelVisual.jarfileButton.text")); // NOI18N
        jarfileButton.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                updateProjectKind(evt);
            }
        });
        jarfileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onSelectKind(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jarfileButton, gridBagConstraints);

        projectDescription.setLabelFor(projectButton);
        org.openide.awt.Mnemonics.setLocalizedText(projectDescription, org.openide.util.NbBundle.getMessage(ChooseDependencyKindPanelVisual.class, "ChooseDependencyKindPanelVisual.projectDescription.text")); // NOI18N
        projectDescription.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 5, 0);
        add(projectDescription, gridBagConstraints);

        jarFileDescription.setLabelFor(jarfileButton);
        org.openide.awt.Mnemonics.setLocalizedText(jarFileDescription, org.openide.util.NbBundle.getMessage(ChooseDependencyKindPanelVisual.class, "ChooseDependencyKindPanelVisual.jarFileDescription.text")); // NOI18N
        jarFileDescription.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 5, 0);
        add(jarFileDescription, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void updateProjectKind(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_updateProjectKind
        if (inUpdate) {
            return;
        }
        AbstractButton[] btns = new AbstractButton[] {
            projectButton, jarfileButton
        };
        inUpdate = true;
        try {
            InitialDepKind k = null;
            for (AbstractButton b : btns) {
                if (b.isSelected()) {
                    k = (InitialDepKind) b.getClientProperty(DEP_KIND_CLIENT_PROP);
                    break;
                }
            }
            setDependencyKind(k);
        } finally {
            inUpdate = false;
        }

    }//GEN-LAST:event_updateProjectKind

    private void onSelectKind(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onSelectKind
        updateProjectKind(null);
    }//GEN-LAST:event_onSelectKind

    private final ChangeSupport supp = new ChangeSupport(this);
    boolean inUpdate = false;

    public void removeChangeListener(ChangeListener listener) {
        supp.removeChangeListener(listener);
    }

    boolean inFireChange;
    public void fireChange() {
        if (inFireChange) return;
        inFireChange = true;
        supp.fireChange();
        inFireChange = false;
    }

    public void addChangeListener(ChangeListener listener) {
        supp.addChangeListener(listener);
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JLabel jarFileDescription;
    private javax.swing.JRadioButton jarfileButton;
    private javax.swing.JRadioButton projectButton;
    private javax.swing.JLabel projectDescription;
    // End of variables declaration//GEN-END:variables

    private InitialDepKind kind = null;
    InitialDepKind getDependencyKind() {
        return kind;
    }

    void setDependencyKind (InitialDepKind kind) {
        InitialDepKind old = this.kind;
        this.kind = kind;
        if (!inUpdate) {
            AbstractButton[] btns = new AbstractButton[] {
                projectButton, jarfileButton
            };
            for (AbstractButton b : btns) {
                if (kind == null) {
                    b.setSelected(false);
                } else if (kind == b.getClientProperty(DEP_KIND_CLIENT_PROP)) {
                    b.setSelected(true);
                    break;
                }
            }
        }
        if (old != kind) {
            fireChange();
        }
    }
}

