#line 6 "ncx.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 8
/*
 *  Copyright (C) 2014, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: ncx.m4 2601 2016-11-07 04:54:42Z wkliao $ */

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wunused-parameter"
#endif

#line 22

#line 26


#line 34

#line 41

#line 41
#if HAVE_CONFIG_H
#line 41
#include <config.h>
#line 41
#endif
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#line 53

#line 53
#pragma GCC diagnostic ignored "-Wdeprecated"
#line 53
#include "ncx.h"
#line 53
#include "nc3dispatch.h"

#line 72




#ifdef HAVE_INTTYPES_H
#include <inttypes.h> /* uint16_t, uint32_t, uint64_t */
#elif defined(HAVE_STDINT_H)
#include <stdint.h>   /* uint16_t, uint32_t, uint64_t */
#endif

#line 103

#line 121

/*
 * The only error code returned from subroutines in this file is NC_ERANGE,
 * if errors are detected.
 */

/*
 * An external data representation interface.
 */

/* alias poorly named limits.h macros */
#define  SHORT_MAX  SHRT_MAX
#define  SHORT_MIN  SHRT_MIN
#define USHORT_MAX USHRT_MAX
#ifndef LLONG_MAX
#   define LLONG_MAX	9223372036854775807LL
#   define LLONG_MIN	(-LLONG_MAX - 1LL)
#   define ULLONG_MAX	18446744073709551615ULL
#endif
#ifndef LONG_LONG_MAX
#define LONG_LONG_MAX LLONG_MAX
#endif
#ifndef LONGLONG_MAX
#define LONGLONG_MAX LONG_LONG_MAX
#endif
#ifndef LONG_LONG_MIN
#define LONG_LONG_MIN LLONG_MIN
#endif
#ifndef LONGLONG_MIN
#define LONGLONG_MIN LONG_LONG_MIN
#endif
#ifndef ULONG_LONG_MAX
#define ULONG_LONG_MAX ULLONG_MAX
#endif
#ifndef ULONGLONG_MAX
#define ULONGLONG_MAX ULONG_LONG_MAX
#endif
#include <float.h>
#ifndef FLT_MAX /* This POSIX macro missing on some systems */
# ifndef NO_IEEE_FLOAT
# define FLT_MAX 3.40282347e+38f
# else
# error "You will need to define FLT_MAX"
# endif
#endif
/* alias poorly named float.h macros */
#define FLOAT_MAX FLT_MAX
#define FLOAT_MIN (-FLT_MAX)
#define DOUBLE_MAX DBL_MAX
#define DOUBLE_MIN (-DBL_MAX)
#define FLOAT_MAX_EXP FLT_MAX_EXP
#define DOUBLE_MAX_EXP DBL_MAX_EXP
#include <assert.h>
#define UCHAR_MIN 0
#define Min(a,b) ((a) < (b) ? (a) : (b))
#define Max(a,b) ((a) > (b) ? (a) : (b))

#ifndef SIZEOF_UCHAR
#ifdef  SIZEOF_UNSIGNED_CHAR
#define SIZEOF_UCHAR SIZEOF_UNSIGNED_CHAR
#else
#error "unknown SIZEOF_UCHAR"
#endif
#endif

#ifndef SIZEOF_USHORT
#ifdef  SIZEOF_UNSIGNED_SHORT_INT
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT_INT
#elif defined(SIZEOF_UNSIGNED_SHORT)
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT
#else
#error "unknown SIZEOF_USHORT"
#endif
#endif

#ifndef SIZEOF_UINT
#ifdef  SIZEOF_UNSIGNED_INT
#define SIZEOF_UINT SIZEOF_UNSIGNED_INT
#else
#error "unknown SIZEOF_UINT"
#endif
#endif

#ifndef SIZEOF_LONGLONG
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_LONGLONG SIZEOF_LONG_LONG
#else
#error "unknown SIZEOF_LONGLONG"
#endif
#endif

#ifndef SIZEOF_INT64
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_INT64 SIZEOF_LONG_LONG
#elif defined(SIZEOF_LONGLONG)
#define SIZEOF_INT64 SIZEOF_LONGLONG
#else
#error "unknown SIZEOF_INT64"
#endif
#endif

#ifndef SIZEOF_ULONGLONG
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_ULONGLONG SIZEOF_UNSIGNED_LONG_LONG
#else
#error "unknown SIZEOF_ULONGLONG"
#endif
#endif

#ifndef SIZEOF_UINT64
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_UINT64 SIZEOF_UNSIGNED_LONG_LONG
#elif defined(SIZEOF_ULONGLONG)
#define SIZEOF_UINT64 SIZEOF_ULONGLONG
#else
#error "unknown SIZEOF_UINT64"
#endif
#endif

/*
 * If the machine's float domain is "smaller" than the external one
 * use the machine domain
 */
#if defined(FLT_MAX_EXP) && FLT_MAX_EXP < 128 /* 128 is X_FLT_MAX_EXP */
#undef X_FLOAT_MAX
# define X_FLOAT_MAX FLT_MAX
#undef X_FLOAT_MIN
# define X_FLOAT_MIN (-X_FLOAT_MAX)
#endif

#if defined(_SX) && _SX != 0 /* NEC SUPER UX */
#define LOOPCNT 256    /* must be no longer than hardware vector length */
#if _INT64
#undef  INT_MAX /* workaround cpp bug */
#define INT_MAX  X_INT_MAX
#undef  INT_MIN /* workaround cpp bug */
#define INT_MIN  X_INT_MIN
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  X_INT_MAX
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN  X_INT_MIN
#elif _LONG64
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  4294967295L
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN -4294967295L
#endif
#if !_FLOAT0
#error "FLOAT1 and FLOAT2 not supported"
#endif
#endif /* _SX */

static const char nada[X_ALIGN] = {0, 0, 0, 0};

#ifndef WORDS_BIGENDIAN
/* LITTLE_ENDIAN: DEC and intel */
/*
 * Routines to convert to BIG ENDIAN.
 * Optimize the swapn?b() and swap?b() routines aggressively.
 */

#define SWAP2(a) ( (((a) & 0xff) << 8) | \
                   (((a) >> 8) & 0xff) )

#define SWAP4(a) ( ((a) << 24) | \
                  (((a) <<  8) & 0x00ff0000) | \
                  (((a) >>  8) & 0x0000ff00) | \
                  (((a) >> 24) & 0x000000ff) )

#define SWAP8(a) ( (((a) & 0x00000000000000FFULL) << 56) | \
                   (((a) & 0x000000000000FF00ULL) << 40) | \
                   (((a) & 0x0000000000FF0000ULL) << 24) | \
                   (((a) & 0x00000000FF000000ULL) <<  8) | \
                   (((a) & 0x000000FF00000000ULL) >>  8) | \
                   (((a) & 0x0000FF0000000000ULL) >> 24) | \
                   (((a) & 0x00FF000000000000ULL) >> 40) | \
                   (((a) & 0xFF00000000000000ULL) >> 56) )

#if defined(_MSC_VER) && _MSC_VER < 1900
#define inline __inline
#endif

inline static void
swapn2b(void *dst, const void *src, size_t nn)
{
    /* it is OK if dst == src */
    size_t i;
    uint16_t *op = (uint16_t*) dst;
    uint16_t *ip = (uint16_t*) src;
    uint16_t tmp;
    for (i=0; i<nn; i++) {
        /* memcpy is used to handle the case of unaligned memory */
        memcpy(&tmp, &ip[i], sizeof(tmp));
        tmp = SWAP2(tmp);
        memcpy(&op[i], &tmp, sizeof(tmp));
    }
}

# ifndef vax
inline static void
swap4b(void *dst, const void *src)
{
    uint32_t tmp;
    /* memcpy is used to handle the case of unaligned memory */
    memcpy(&tmp, src, sizeof(tmp));
    tmp = SWAP4(tmp);
    memcpy(dst, &tmp, 4);
}
# endif /* !vax */

inline static void
swapn4b(void *dst, const void *src, size_t nn)
{
    size_t i;
    uint32_t *op = (uint32_t*) dst;
    uint32_t *ip = (uint32_t*) src;
    uint32_t tmp;
    for (i=0; i<nn; i++) {
        /* memcpy is used to handle the case of unaligned memory */
        memcpy(&tmp, &ip[i], sizeof(tmp));
        tmp = SWAP4(tmp);
        memcpy(&op[i], &tmp, sizeof(tmp));
    }
}

# ifndef vax
inline static void
swap8b(void *dst, const void *src)
{
    uint64_t tmp;
    /* memcpy is used to handle the case of unaligned memory */
    memcpy(&tmp, src, sizeof(tmp));
    tmp = SWAP8(tmp);
    memcpy(dst, &tmp, 8);
}
# endif /* !vax */

# ifndef vax
inline static void
swapn8b(void *dst, const void *src, size_t nn)
{
    size_t i;
    uint64_t *op = (uint64_t*) dst;
    uint64_t *ip = (uint64_t*) src;
    uint64_t tmp;
    for (i=0; i<nn; i++) {
        /* memcpy is used to handle the case of unaligned memory */
        memcpy(&tmp, &ip[i], sizeof(tmp));
        tmp = SWAP8(tmp);
        memcpy(&op[i], &tmp, sizeof(tmp));
    }
}
# endif /* !vax */

#endif /* LITTLE_ENDIAN */

#line 400

#line 404

#line 416

#line 431


/*
 * Primitive numeric conversion functions.
 */

#line 459

#line 507

#line 540

#line 586

/* x_schar */
/* x_uchar */

/* We don't implement any x_schar and x_uchar primitives. */


/* external NC_SHORT --------------------------------------------------------*/

#if SHORT_MAX == X_SHORT_MAX
typedef short ix_short;
#define SIZEOF_IX_SHORT SIZEOF_SHORT
#define IX_SHORT_MAX SHORT_MAX
#elif INT_MAX >= X_SHORT_MAX
typedef int ix_short;
#define SIZEOF_IX_SHORT SIZEOF_INT
#define IX_SHORT_MAX INT_MAX
#elif LONG_MAX >= X_SHORT_MAX
typedef long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG
#define IX_SHORT_MAX LONG_MAX
#elif LLONG_MAX >= X_SHORT_MAX
typedef long long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONGLONG
#define IX_SHORT_MAX LLONG_MAX
#else
#error "ix_short implementation"
#endif

static void
get_ix_short(const void *xp, ix_short *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_short)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_short)(*ip | *cp);
}

static void
put_ix_short(void *xp, const ix_short *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 638
ncx_get_short_schar(const void *xp, schar *ip)
#line 638
{
#line 638
    int err=NC_NOERR;
#line 638
    ix_short xx = 0;
#line 638
    get_ix_short(xp, &xx);
#line 638

#line 638
#if IX_SHORT_MAX > SCHAR_MAX
#line 638
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 638
#ifdef ERANGE_FILL
#line 638
        *ip = NC_FILL_BYTE;
#line 638
        return NC_ERANGE;
#line 638
#else
#line 638
        err = NC_ERANGE;
#line 638
#endif
#line 638
    }
#line 638
#endif
#line 638

#line 638

#line 638
    *ip = (schar) xx;
#line 638
    return err;
#line 638
}
#line 638

static int
#line 639
ncx_get_short_short(const void *xp, short *ip)
#line 639
{
#line 639
    int err=NC_NOERR;
#line 639
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 639
    get_ix_short(xp, (ix_short *)ip);
#line 639
#else
#line 639
    ix_short xx = 0;
#line 639
    get_ix_short(xp, &xx);
#line 639

#line 639
#if IX_SHORT_MAX > SHORT_MAX
#line 639
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 639
#ifdef ERANGE_FILL
#line 639
        *ip = NC_FILL_SHORT;
#line 639
        return NC_ERANGE;
#line 639
#else
#line 639
        err = NC_ERANGE;
#line 639
#endif
#line 639
    }
#line 639
#endif
#line 639

#line 639

#line 639
    *ip = (short) xx;
#line 639
#endif
#line 639
    return err;
#line 639
}
#line 639

static int
#line 640
ncx_get_short_int(const void *xp, int *ip)
#line 640
{
#line 640
    int err=NC_NOERR;
#line 640
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 640
    get_ix_short(xp, (ix_short *)ip);
#line 640
#else
#line 640
    ix_short xx = 0;
#line 640
    get_ix_short(xp, &xx);
#line 640

#line 640
#if IX_SHORT_MAX > INT_MAX
#line 640
    if (xx > INT_MAX || xx < INT_MIN) {
#line 640
#ifdef ERANGE_FILL
#line 640
        *ip = NC_FILL_INT;
#line 640
        return NC_ERANGE;
#line 640
#else
#line 640
        err = NC_ERANGE;
#line 640
#endif
#line 640
    }
#line 640
#endif
#line 640

#line 640

#line 640
    *ip = (int) xx;
#line 640
#endif
#line 640
    return err;
#line 640
}
#line 640

static int
#line 641
ncx_get_short_long(const void *xp, long *ip)
#line 641
{
#line 641
    int err=NC_NOERR;
#line 641
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 641
    get_ix_short(xp, (ix_short *)ip);
#line 641
#else
#line 641
    ix_short xx = 0;
#line 641
    get_ix_short(xp, &xx);
#line 641

#line 641
#if IX_SHORT_MAX > LONG_MAX
#line 641
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 641
#ifdef ERANGE_FILL
#line 641
        *ip = NC_FILL_INT;
#line 641
        return NC_ERANGE;
#line 641
#else
#line 641
        err = NC_ERANGE;
#line 641
#endif
#line 641
    }
#line 641
#endif
#line 641

#line 641

#line 641
    *ip = (long) xx;
#line 641
#endif
#line 641
    return err;
#line 641
}
#line 641

static int
#line 642
ncx_get_short_longlong(const void *xp, longlong *ip)
#line 642
{
#line 642
    int err=NC_NOERR;
#line 642
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 642
    get_ix_short(xp, (ix_short *)ip);
#line 642
#else
#line 642
    ix_short xx = 0;
#line 642
    get_ix_short(xp, &xx);
#line 642

#line 642
#if IX_SHORT_MAX > LONGLONG_MAX
#line 642
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 642
#ifdef ERANGE_FILL
#line 642
        *ip = NC_FILL_INT64;
#line 642
        return NC_ERANGE;
#line 642
#else
#line 642
        err = NC_ERANGE;
#line 642
#endif
#line 642
    }
#line 642
#endif
#line 642

#line 642

#line 642
    *ip = (longlong) xx;
#line 642
#endif
#line 642
    return err;
#line 642
}
#line 642

static int
#line 643
ncx_get_short_ushort(const void *xp, ushort *ip)
#line 643
{
#line 643
    int err=NC_NOERR;
#line 643
    ix_short xx = 0;
#line 643
    get_ix_short(xp, &xx);
#line 643

#line 643
#if IX_SHORT_MAX > USHORT_MAX
#line 643
    if (xx > USHORT_MAX) {
#line 643
#ifdef ERANGE_FILL
#line 643
        *ip = NC_FILL_USHORT;
#line 643
        return NC_ERANGE;
#line 643
#else
#line 643
        err = NC_ERANGE;
#line 643
#endif
#line 643
    }
#line 643
#endif
#line 643

#line 643
    if (xx < 0) {
#line 643
#ifdef ERANGE_FILL
#line 643
        *ip = NC_FILL_USHORT;
#line 643
        return NC_ERANGE;
#line 643
#else
#line 643
        err = NC_ERANGE; /* because ip is unsigned */
#line 643
#endif
#line 643
    }
#line 643
    *ip = (ushort) xx;
#line 643
    return err;
#line 643
}
#line 643

static int
#line 644
ncx_get_short_uchar(const void *xp, uchar *ip)
#line 644
{
#line 644
    int err=NC_NOERR;
#line 644
    ix_short xx = 0;
#line 644
    get_ix_short(xp, &xx);
#line 644

#line 644
#if IX_SHORT_MAX > UCHAR_MAX
#line 644
    if (xx > UCHAR_MAX) {
#line 644
#ifdef ERANGE_FILL
#line 644
        *ip = NC_FILL_UBYTE;
#line 644
        return NC_ERANGE;
#line 644
#else
#line 644
        err = NC_ERANGE;
#line 644
#endif
#line 644
    }
#line 644
#endif
#line 644

#line 644
    if (xx < 0) {
#line 644
#ifdef ERANGE_FILL
#line 644
        *ip = NC_FILL_UBYTE;
#line 644
        return NC_ERANGE;
#line 644
#else
#line 644
        err = NC_ERANGE; /* because ip is unsigned */
#line 644
#endif
#line 644
    }
#line 644
    *ip = (uchar) xx;
#line 644
    return err;
#line 644
}
#line 644

static int
#line 645
ncx_get_short_uint(const void *xp, uint *ip)
#line 645
{
#line 645
    int err=NC_NOERR;
#line 645
    ix_short xx = 0;
#line 645
    get_ix_short(xp, &xx);
#line 645

#line 645
#if IX_SHORT_MAX > UINT_MAX
#line 645
    if (xx > UINT_MAX) {
#line 645
#ifdef ERANGE_FILL
#line 645
        *ip = NC_FILL_UINT;
#line 645
        return NC_ERANGE;
#line 645
#else
#line 645
        err = NC_ERANGE;
#line 645
#endif
#line 645
    }
#line 645
#endif
#line 645

#line 645
    if (xx < 0) {
#line 645
#ifdef ERANGE_FILL
#line 645
        *ip = NC_FILL_UINT;
#line 645
        return NC_ERANGE;
#line 645
#else
#line 645
        err = NC_ERANGE; /* because ip is unsigned */
#line 645
#endif
#line 645
    }
#line 645
    *ip = (uint) xx;
#line 645
    return err;
#line 645
}
#line 645

static int
#line 646
ncx_get_short_ulonglong(const void *xp, ulonglong *ip)
#line 646
{
#line 646
    int err=NC_NOERR;
#line 646
    ix_short xx = 0;
#line 646
    get_ix_short(xp, &xx);
#line 646

#line 646
#if IX_SHORT_MAX > ULONGLONG_MAX
#line 646
    if (xx > ULONGLONG_MAX) {
#line 646
#ifdef ERANGE_FILL
#line 646
        *ip = NC_FILL_UINT64;
#line 646
        return NC_ERANGE;
#line 646
#else
#line 646
        err = NC_ERANGE;
#line 646
#endif
#line 646
    }
#line 646
#endif
#line 646

#line 646
    if (xx < 0) {
#line 646
#ifdef ERANGE_FILL
#line 646
        *ip = NC_FILL_UINT64;
#line 646
        return NC_ERANGE;
#line 646
#else
#line 646
        err = NC_ERANGE; /* because ip is unsigned */
#line 646
#endif
#line 646
    }
#line 646
    *ip = (ulonglong) xx;
#line 646
    return err;
#line 646
}
#line 646

static int
#line 647
ncx_get_short_float(const void *xp, float *ip)
#line 647
{
#line 647
	ix_short xx = 0;
#line 647
	get_ix_short(xp, &xx);
#line 647
	*ip = (float)xx;
#line 647
	return NC_NOERR;
#line 647
}
#line 647

static int
#line 648
ncx_get_short_double(const void *xp, double *ip)
#line 648
{
#line 648
	ix_short xx = 0;
#line 648
	get_ix_short(xp, &xx);
#line 648
	*ip = (double)xx;
#line 648
	return NC_NOERR;
#line 648
}
#line 648


static int
ncx_put_short_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_short_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 671
ncx_put_short_short(void *xp, const short *ip, void *fillp)
#line 671
{
#line 671
    int err=NC_NOERR;
#line 671
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 671
    put_ix_short(xp, (const ix_short *)ip);
#line 671
#else
#line 671
    ix_short xx = NC_FILL_SHORT;
#line 671

#line 671
#if IX_SHORT_MAX < SHORT_MAX
#line 671
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 671
        
#line 671
#ifdef ERANGE_FILL
#line 671
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 671
#endif
#line 671
        err = NC_ERANGE;
#line 671
    }
#line 671
#ifdef ERANGE_FILL
#line 671
    else
#line 671
#endif
#line 671
#endif
#line 671
        xx = (ix_short)*ip;
#line 671

#line 671
    put_ix_short(xp, &xx);
#line 671
#endif
#line 671
    return err;
#line 671
}
#line 671

static int
#line 672
ncx_put_short_int(void *xp, const int *ip, void *fillp)
#line 672
{
#line 672
    int err=NC_NOERR;
#line 672
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 672
    put_ix_short(xp, (const ix_short *)ip);
#line 672
#else
#line 672
    ix_short xx = NC_FILL_SHORT;
#line 672

#line 672
#if IX_SHORT_MAX < INT_MAX
#line 672
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 672
        
#line 672
#ifdef ERANGE_FILL
#line 672
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 672
#endif
#line 672
        err = NC_ERANGE;
#line 672
    }
#line 672
#ifdef ERANGE_FILL
#line 672
    else
#line 672
#endif
#line 672
#endif
#line 672
        xx = (ix_short)*ip;
#line 672

#line 672
    put_ix_short(xp, &xx);
#line 672
#endif
#line 672
    return err;
#line 672
}
#line 672

static int
#line 673
ncx_put_short_long(void *xp, const long *ip, void *fillp)
#line 673
{
#line 673
    int err=NC_NOERR;
#line 673
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 673
    put_ix_short(xp, (const ix_short *)ip);
#line 673
#else
#line 673
    ix_short xx = NC_FILL_SHORT;
#line 673

#line 673
#if IX_SHORT_MAX < LONG_MAX
#line 673
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 673
        
#line 673
#ifdef ERANGE_FILL
#line 673
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 673
#endif
#line 673
        err = NC_ERANGE;
#line 673
    }
#line 673
#ifdef ERANGE_FILL
#line 673
    else
#line 673
#endif
#line 673
#endif
#line 673
        xx = (ix_short)*ip;
#line 673

#line 673
    put_ix_short(xp, &xx);
#line 673
#endif
#line 673
    return err;
#line 673
}
#line 673

static int
#line 674
ncx_put_short_longlong(void *xp, const longlong *ip, void *fillp)
#line 674
{
#line 674
    int err=NC_NOERR;
#line 674
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 674
    put_ix_short(xp, (const ix_short *)ip);
#line 674
#else
#line 674
    ix_short xx = NC_FILL_SHORT;
#line 674

#line 674
#if IX_SHORT_MAX < LONGLONG_MAX
#line 674
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 674
        
#line 674
#ifdef ERANGE_FILL
#line 674
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 674
#endif
#line 674
        err = NC_ERANGE;
#line 674
    }
#line 674
#ifdef ERANGE_FILL
#line 674
    else
#line 674
#endif
#line 674
#endif
#line 674
        xx = (ix_short)*ip;
#line 674

#line 674
    put_ix_short(xp, &xx);
#line 674
#endif
#line 674
    return err;
#line 674
}
#line 674

static int
#line 675
ncx_put_short_ushort(void *xp, const ushort *ip, void *fillp)
#line 675
{
#line 675
    int err=NC_NOERR;
#line 675
    ix_short xx = NC_FILL_SHORT;
#line 675

#line 675
#if IX_SHORT_MAX < USHORT_MAX
#line 675
    if (*ip > IX_SHORT_MAX) {
#line 675
        
#line 675
#ifdef ERANGE_FILL
#line 675
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 675
#endif
#line 675
        err = NC_ERANGE;
#line 675
    }
#line 675
#ifdef ERANGE_FILL
#line 675
    else
#line 675
#endif
#line 675
#endif
#line 675
        xx = (ix_short)*ip;
#line 675

#line 675
    put_ix_short(xp, &xx);
#line 675
    return err;
#line 675
}
#line 675

static int
#line 676
ncx_put_short_uint(void *xp, const uint *ip, void *fillp)
#line 676
{
#line 676
    int err=NC_NOERR;
#line 676
    ix_short xx = NC_FILL_SHORT;
#line 676

#line 676
#if IX_SHORT_MAX < UINT_MAX
#line 676
    if (*ip > IX_SHORT_MAX) {
#line 676
        
#line 676
#ifdef ERANGE_FILL
#line 676
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 676
#endif
#line 676
        err = NC_ERANGE;
#line 676
    }
#line 676
#ifdef ERANGE_FILL
#line 676
    else
#line 676
#endif
#line 676
#endif
#line 676
        xx = (ix_short)*ip;
#line 676

#line 676
    put_ix_short(xp, &xx);
#line 676
    return err;
#line 676
}
#line 676

static int
#line 677
ncx_put_short_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 677
{
#line 677
    int err=NC_NOERR;
#line 677
    ix_short xx = NC_FILL_SHORT;
#line 677

#line 677
#if IX_SHORT_MAX < ULONGLONG_MAX
#line 677
    if (*ip > IX_SHORT_MAX) {
#line 677
        
#line 677
#ifdef ERANGE_FILL
#line 677
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 677
#endif
#line 677
        err = NC_ERANGE;
#line 677
    }
#line 677
#ifdef ERANGE_FILL
#line 677
    else
#line 677
#endif
#line 677
#endif
#line 677
        xx = (ix_short)*ip;
#line 677

#line 677
    put_ix_short(xp, &xx);
#line 677
    return err;
#line 677
}
#line 677

static int
#line 678
ncx_put_short_float(void *xp, const float *ip, void *fillp)
#line 678
{
#line 678
    int err=NC_NOERR;
#line 678
    ix_short xx = NC_FILL_SHORT;
#line 678

#line 678
    if (*ip > (double)X_SHORT_MAX || *ip < (double)X_SHORT_MIN) {
#line 678
        
#line 678
#ifdef ERANGE_FILL
#line 678
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 678
#endif
#line 678
        err = NC_ERANGE;
#line 678
    }
#line 678
#ifdef ERANGE_FILL
#line 678
    else
#line 678
#endif
#line 678
        xx = (ix_short)*ip;
#line 678

#line 678
    put_ix_short(xp, &xx);
#line 678
    return err;
#line 678
}
#line 678

static int
#line 679
ncx_put_short_double(void *xp, const double *ip, void *fillp)
#line 679
{
#line 679
    int err=NC_NOERR;
#line 679
    ix_short xx = NC_FILL_SHORT;
#line 679

#line 679
    if (*ip > X_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 679
        
#line 679
#ifdef ERANGE_FILL
#line 679
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 679
#endif
#line 679
        err = NC_ERANGE;
#line 679
    }
#line 679
#ifdef ERANGE_FILL
#line 679
    else
#line 679
#endif
#line 679
        xx = (ix_short)*ip;
#line 679

#line 679
    put_ix_short(xp, &xx);
#line 679
    return err;
#line 679
}
#line 679


/* external NC_USHORT -------------------------------------------------------*/

#if USHORT_MAX == X_USHORT_MAX
typedef unsigned short ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_USHORT
#define IX_USHORT_MAX USHORT_MAX
#elif UINT_MAX >= X_USHORT_MAX
typedef unsigned int ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_UINT
#define IX_USHORT_MAX UINT_MAX
#elif ULONG_MAX >= X_USHORT_MAX
typedef unsigned long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONG
#define IX_USHORT_MAX ULONG_MAX
#elif ULLONG_MAX >= X_USHORT_MAX
typedef unsigned long long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONGLONG
#define IX_USHORT_MAX ULLONG_MAX
#else
#error "ix_ushort implementation"
#endif

static void
get_ix_ushort(const void *xp, ix_ushort *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_ushort)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_ushort)(*ip | *cp);
}

static void
put_ix_ushort(void *xp, const ix_ushort *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 726
ncx_get_ushort_schar(const void *xp, schar *ip)
#line 726
{
#line 726
    int err=NC_NOERR;
#line 726
    ix_ushort xx = 0;
#line 726
    get_ix_ushort(xp, &xx);
#line 726

#line 726
#if IX_USHORT_MAX > SCHAR_MAX
#line 726
    if (xx > SCHAR_MAX) {
#line 726
#ifdef ERANGE_FILL
#line 726
        *ip = NC_FILL_BYTE;
#line 726
        return NC_ERANGE;
#line 726
#else
#line 726
        err = NC_ERANGE;
#line 726
#endif
#line 726
    }
#line 726
#endif
#line 726

#line 726

#line 726
    *ip = (schar) xx;
#line 726
    return err;
#line 726
}
#line 726

static int
#line 727
ncx_get_ushort_short(const void *xp, short *ip)
#line 727
{
#line 727
    int err=NC_NOERR;
#line 727
    ix_ushort xx = 0;
#line 727
    get_ix_ushort(xp, &xx);
#line 727

#line 727
#if IX_USHORT_MAX > SHORT_MAX
#line 727
    if (xx > SHORT_MAX) {
#line 727
#ifdef ERANGE_FILL
#line 727
        *ip = NC_FILL_SHORT;
#line 727
        return NC_ERANGE;
#line 727
#else
#line 727
        err = NC_ERANGE;
#line 727
#endif
#line 727
    }
#line 727
#endif
#line 727

#line 727

#line 727
    *ip = (short) xx;
#line 727
    return err;
#line 727
}
#line 727

static int
#line 728
ncx_get_ushort_int(const void *xp, int *ip)
#line 728
{
#line 728
    int err=NC_NOERR;
#line 728
    ix_ushort xx = 0;
#line 728
    get_ix_ushort(xp, &xx);
#line 728

#line 728
#if IX_USHORT_MAX > INT_MAX
#line 728
    if (xx > INT_MAX) {
#line 728
#ifdef ERANGE_FILL
#line 728
        *ip = NC_FILL_INT;
#line 728
        return NC_ERANGE;
#line 728
#else
#line 728
        err = NC_ERANGE;
#line 728
#endif
#line 728
    }
#line 728
#endif
#line 728

#line 728

#line 728
    *ip = (int) xx;
#line 728
    return err;
#line 728
}
#line 728

static int
#line 729
ncx_get_ushort_long(const void *xp, long *ip)
#line 729
{
#line 729
    int err=NC_NOERR;
#line 729
    ix_ushort xx = 0;
#line 729
    get_ix_ushort(xp, &xx);
#line 729

#line 729
#if IX_USHORT_MAX > LONG_MAX
#line 729
    if (xx > LONG_MAX) {
#line 729
#ifdef ERANGE_FILL
#line 729
        *ip = NC_FILL_INT;
#line 729
        return NC_ERANGE;
#line 729
#else
#line 729
        err = NC_ERANGE;
#line 729
#endif
#line 729
    }
#line 729
#endif
#line 729

#line 729

#line 729
    *ip = (long) xx;
#line 729
    return err;
#line 729
}
#line 729

static int
#line 730
ncx_get_ushort_longlong(const void *xp, longlong *ip)
#line 730
{
#line 730
    int err=NC_NOERR;
#line 730
    ix_ushort xx = 0;
#line 730
    get_ix_ushort(xp, &xx);
#line 730

#line 730
#if IX_USHORT_MAX > LONGLONG_MAX
#line 730
    if (xx > LONGLONG_MAX) {
#line 730
#ifdef ERANGE_FILL
#line 730
        *ip = NC_FILL_INT64;
#line 730
        return NC_ERANGE;
#line 730
#else
#line 730
        err = NC_ERANGE;
#line 730
#endif
#line 730
    }
#line 730
#endif
#line 730

#line 730

#line 730
    *ip = (longlong) xx;
#line 730
    return err;
#line 730
}
#line 730

static int
#line 731
ncx_get_ushort_ushort(const void *xp, ushort *ip)
#line 731
{
#line 731
    int err=NC_NOERR;
#line 731
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 731
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 731
#else
#line 731
    ix_ushort xx = 0;
#line 731
    get_ix_ushort(xp, &xx);
#line 731

#line 731
#if IX_USHORT_MAX > USHORT_MAX
#line 731
    if (xx > USHORT_MAX) {
#line 731
#ifdef ERANGE_FILL
#line 731
        *ip = NC_FILL_USHORT;
#line 731
        return NC_ERANGE;
#line 731
#else
#line 731
        err = NC_ERANGE;
#line 731
#endif
#line 731
    }
#line 731
#endif
#line 731

#line 731

#line 731
    *ip = (ushort) xx;
#line 731
#endif
#line 731
    return err;
#line 731
}
#line 731

static int
#line 732
ncx_get_ushort_uchar(const void *xp, uchar *ip)
#line 732
{
#line 732
    int err=NC_NOERR;
#line 732
#if SIZEOF_IX_USHORT == SIZEOF_UCHAR && IX_USHORT_MAX == UCHAR_MAX
#line 732
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 732
#else
#line 732
    ix_ushort xx = 0;
#line 732
    get_ix_ushort(xp, &xx);
#line 732

#line 732
#if IX_USHORT_MAX > UCHAR_MAX
#line 732
    if (xx > UCHAR_MAX) {
#line 732
#ifdef ERANGE_FILL
#line 732
        *ip = NC_FILL_UBYTE;
#line 732
        return NC_ERANGE;
#line 732
#else
#line 732
        err = NC_ERANGE;
#line 732
#endif
#line 732
    }
#line 732
#endif
#line 732

#line 732

#line 732
    *ip = (uchar) xx;
#line 732
#endif
#line 732
    return err;
#line 732
}
#line 732

static int
#line 733
ncx_get_ushort_uint(const void *xp, uint *ip)
#line 733
{
#line 733
    int err=NC_NOERR;
#line 733
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 733
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 733
#else
#line 733
    ix_ushort xx = 0;
#line 733
    get_ix_ushort(xp, &xx);
#line 733

#line 733
#if IX_USHORT_MAX > UINT_MAX
#line 733
    if (xx > UINT_MAX) {
#line 733
#ifdef ERANGE_FILL
#line 733
        *ip = NC_FILL_UINT;
#line 733
        return NC_ERANGE;
#line 733
#else
#line 733
        err = NC_ERANGE;
#line 733
#endif
#line 733
    }
#line 733
#endif
#line 733

#line 733

#line 733
    *ip = (uint) xx;
#line 733
#endif
#line 733
    return err;
#line 733
}
#line 733

static int
#line 734
ncx_get_ushort_ulonglong(const void *xp, ulonglong *ip)
#line 734
{
#line 734
    int err=NC_NOERR;
#line 734
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 734
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 734
#else
#line 734
    ix_ushort xx = 0;
#line 734
    get_ix_ushort(xp, &xx);
#line 734

#line 734
#if IX_USHORT_MAX > ULONGLONG_MAX
#line 734
    if (xx > ULONGLONG_MAX) {
#line 734
#ifdef ERANGE_FILL
#line 734
        *ip = NC_FILL_UINT64;
#line 734
        return NC_ERANGE;
#line 734
#else
#line 734
        err = NC_ERANGE;
#line 734
#endif
#line 734
    }
#line 734
#endif
#line 734

#line 734

#line 734
    *ip = (ulonglong) xx;
#line 734
#endif
#line 734
    return err;
#line 734
}
#line 734

static int
#line 735
ncx_get_ushort_float(const void *xp, float *ip)
#line 735
{
#line 735
	ix_ushort xx = 0;
#line 735
	get_ix_ushort(xp, &xx);
#line 735
	*ip = (float)xx;
#line 735
	return NC_NOERR;
#line 735
}
#line 735

static int
#line 736
ncx_get_ushort_double(const void *xp, double *ip)
#line 736
{
#line 736
	ix_ushort xx = 0;
#line 736
	get_ix_ushort(xp, &xx);
#line 736
	*ip = (double)xx;
#line 736
	return NC_NOERR;
#line 736
}
#line 736


static int
ncx_put_ushort_schar(void *xp, const schar *ip, void *fillp)
{
    int err=NC_NOERR;
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 2);
#ifndef WORDS_BIGENDIAN
        swapn2b(xp, xp, 1);
#endif
        return NC_ERANGE;
#else
        err = NC_ERANGE;
#endif
    }

    cp = (uchar *) xp;
    if (*ip & 0x80)
        *cp++ = 0xff;
    else
        *cp++ = 0;
    *cp = (uchar)*ip;

    return err;
}

static int
ncx_put_ushort_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 774
ncx_put_ushort_short(void *xp, const short *ip, void *fillp)
#line 774
{
#line 774
    int err=NC_NOERR;
#line 774
    ix_ushort xx = NC_FILL_USHORT;
#line 774

#line 774
#if IX_USHORT_MAX < SHORT_MAX
#line 774
    if (*ip > IX_USHORT_MAX) {
#line 774
        
#line 774
#ifdef ERANGE_FILL
#line 774
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 774
#endif
#line 774
        err = NC_ERANGE;
#line 774
    }
#line 774
#ifdef ERANGE_FILL
#line 774
    else
#line 774
#endif
#line 774
#endif
#line 774
    if (*ip < 0) {
#line 774
        
#line 774
#ifdef ERANGE_FILL
#line 774
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 774
#endif
#line 774
        err = NC_ERANGE; /* because xp is unsigned */
#line 774
    }
#line 774
#ifdef ERANGE_FILL
#line 774
    else
#line 774
#endif
#line 774
        xx = (ix_ushort)*ip;
#line 774

#line 774
    put_ix_ushort(xp, &xx);
#line 774
    return err;
#line 774
}
#line 774

static int
#line 775
ncx_put_ushort_int(void *xp, const int *ip, void *fillp)
#line 775
{
#line 775
    int err=NC_NOERR;
#line 775
    ix_ushort xx = NC_FILL_USHORT;
#line 775

#line 775
#if IX_USHORT_MAX < INT_MAX
#line 775
    if (*ip > IX_USHORT_MAX) {
#line 775
        
#line 775
#ifdef ERANGE_FILL
#line 775
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 775
#endif
#line 775
        err = NC_ERANGE;
#line 775
    }
#line 775
#ifdef ERANGE_FILL
#line 775
    else
#line 775
#endif
#line 775
#endif
#line 775
    if (*ip < 0) {
#line 775
        
#line 775
#ifdef ERANGE_FILL
#line 775
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 775
#endif
#line 775
        err = NC_ERANGE; /* because xp is unsigned */
#line 775
    }
#line 775
#ifdef ERANGE_FILL
#line 775
    else
#line 775
#endif
#line 775
        xx = (ix_ushort)*ip;
#line 775

#line 775
    put_ix_ushort(xp, &xx);
#line 775
    return err;
#line 775
}
#line 775

static int
#line 776
ncx_put_ushort_long(void *xp, const long *ip, void *fillp)
#line 776
{
#line 776
    int err=NC_NOERR;
#line 776
    ix_ushort xx = NC_FILL_USHORT;
#line 776

#line 776
#if IX_USHORT_MAX < LONG_MAX
#line 776
    if (*ip > IX_USHORT_MAX) {
#line 776
        
#line 776
#ifdef ERANGE_FILL
#line 776
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 776
#endif
#line 776
        err = NC_ERANGE;
#line 776
    }
#line 776
#ifdef ERANGE_FILL
#line 776
    else
#line 776
#endif
#line 776
#endif
#line 776
    if (*ip < 0) {
#line 776
        
#line 776
#ifdef ERANGE_FILL
#line 776
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 776
#endif
#line 776
        err = NC_ERANGE; /* because xp is unsigned */
#line 776
    }
#line 776
#ifdef ERANGE_FILL
#line 776
    else
#line 776
#endif
#line 776
        xx = (ix_ushort)*ip;
#line 776

#line 776
    put_ix_ushort(xp, &xx);
#line 776
    return err;
#line 776
}
#line 776

static int
#line 777
ncx_put_ushort_longlong(void *xp, const longlong *ip, void *fillp)
#line 777
{
#line 777
    int err=NC_NOERR;
#line 777
    ix_ushort xx = NC_FILL_USHORT;
#line 777

#line 777
#if IX_USHORT_MAX < LONGLONG_MAX
#line 777
    if (*ip > IX_USHORT_MAX) {
#line 777
        
#line 777
#ifdef ERANGE_FILL
#line 777
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 777
#endif
#line 777
        err = NC_ERANGE;
#line 777
    }
#line 777
#ifdef ERANGE_FILL
#line 777
    else
#line 777
#endif
#line 777
#endif
#line 777
    if (*ip < 0) {
#line 777
        
#line 777
#ifdef ERANGE_FILL
#line 777
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 777
#endif
#line 777
        err = NC_ERANGE; /* because xp is unsigned */
#line 777
    }
#line 777
#ifdef ERANGE_FILL
#line 777
    else
#line 777
#endif
#line 777
        xx = (ix_ushort)*ip;
#line 777

#line 777
    put_ix_ushort(xp, &xx);
#line 777
    return err;
#line 777
}
#line 777

static int
#line 778
ncx_put_ushort_ushort(void *xp, const ushort *ip, void *fillp)
#line 778
{
#line 778
    int err=NC_NOERR;
#line 778
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 778
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 778
#else
#line 778
    ix_ushort xx = NC_FILL_USHORT;
#line 778

#line 778
#if IX_USHORT_MAX < USHORT_MAX
#line 778
    if (*ip > IX_USHORT_MAX) {
#line 778
        
#line 778
#ifdef ERANGE_FILL
#line 778
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 778
#endif
#line 778
        err = NC_ERANGE;
#line 778
    }
#line 778
#ifdef ERANGE_FILL
#line 778
    else
#line 778
#endif
#line 778
#endif
#line 778
        xx = (ix_ushort)*ip;
#line 778

#line 778
    put_ix_ushort(xp, &xx);
#line 778
#endif
#line 778
    return err;
#line 778
}
#line 778

static int
#line 779
ncx_put_ushort_uint(void *xp, const uint *ip, void *fillp)
#line 779
{
#line 779
    int err=NC_NOERR;
#line 779
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 779
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 779
#else
#line 779
    ix_ushort xx = NC_FILL_USHORT;
#line 779

#line 779
#if IX_USHORT_MAX < UINT_MAX
#line 779
    if (*ip > IX_USHORT_MAX) {
#line 779
        
#line 779
#ifdef ERANGE_FILL
#line 779
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 779
#endif
#line 779
        err = NC_ERANGE;
#line 779
    }
#line 779
#ifdef ERANGE_FILL
#line 779
    else
#line 779
#endif
#line 779
#endif
#line 779
        xx = (ix_ushort)*ip;
#line 779

#line 779
    put_ix_ushort(xp, &xx);
#line 779
#endif
#line 779
    return err;
#line 779
}
#line 779

static int
#line 780
ncx_put_ushort_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 780
{
#line 780
    int err=NC_NOERR;
#line 780
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 780
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 780
#else
#line 780
    ix_ushort xx = NC_FILL_USHORT;
#line 780

#line 780
#if IX_USHORT_MAX < ULONGLONG_MAX
#line 780
    if (*ip > IX_USHORT_MAX) {
#line 780
        
#line 780
#ifdef ERANGE_FILL
#line 780
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 780
#endif
#line 780
        err = NC_ERANGE;
#line 780
    }
#line 780
#ifdef ERANGE_FILL
#line 780
    else
#line 780
#endif
#line 780
#endif
#line 780
        xx = (ix_ushort)*ip;
#line 780

#line 780
    put_ix_ushort(xp, &xx);
#line 780
#endif
#line 780
    return err;
#line 780
}
#line 780

static int
#line 781
ncx_put_ushort_float(void *xp, const float *ip, void *fillp)
#line 781
{
#line 781
    int err=NC_NOERR;
#line 781
    ix_ushort xx = NC_FILL_USHORT;
#line 781

#line 781
    if (*ip > (double)X_USHORT_MAX || *ip < 0) {
#line 781
        
#line 781
#ifdef ERANGE_FILL
#line 781
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 781
#endif
#line 781
        err = NC_ERANGE;
#line 781
    }
#line 781
#ifdef ERANGE_FILL
#line 781
    else
#line 781
#endif
#line 781
        xx = (ix_ushort)*ip;
#line 781

#line 781
    put_ix_ushort(xp, &xx);
#line 781
    return err;
#line 781
}
#line 781

static int
#line 782
ncx_put_ushort_double(void *xp, const double *ip, void *fillp)
#line 782
{
#line 782
    int err=NC_NOERR;
#line 782
    ix_ushort xx = NC_FILL_USHORT;
#line 782

#line 782
    if (*ip > X_USHORT_MAX || *ip < 0) {
#line 782
        
#line 782
#ifdef ERANGE_FILL
#line 782
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 782
#endif
#line 782
        err = NC_ERANGE;
#line 782
    }
#line 782
#ifdef ERANGE_FILL
#line 782
    else
#line 782
#endif
#line 782
        xx = (ix_ushort)*ip;
#line 782

#line 782
    put_ix_ushort(xp, &xx);
#line 782
    return err;
#line 782
}
#line 782


/* external NC_INT ----------------------------------------------------------*/

#if SHORT_MAX == X_INT_MAX
typedef short ix_int;
#define SIZEOF_IX_INT SIZEOF_SHORT
#define IX_INT_MAX SHORT_MAX
#elif INT_MAX  >= X_INT_MAX
typedef int ix_int;
#define SIZEOF_IX_INT SIZEOF_INT
#define IX_INT_MAX INT_MAX
#elif LONG_MAX  >= X_INT_MAX
typedef long ix_int;
#define SIZEOF_IX_INT SIZEOF_LONG
#define IX_INT_MAX LONG_MAX
#else
#error "ix_int implementation"
#endif


static void
get_ix_int(const void *xp, ix_int *ip)
{
	const uchar *cp = (const uchar *) xp;

#if INT_MAX  >= X_INT_MAX
	*ip = (ix_int)((unsigned)(*cp++) << 24);
#else
	*ip = *cp++ << 24;
#endif
#if SIZEOF_IX_INT > X_SIZEOF_INT
	if (*ip & 0x80000000)
	{
		/* extern is negative */
		*ip |= (~(0xffffffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp;
}

static void
put_ix_int(void *xp, const ix_int *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)( (*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 837
ncx_get_int_int(const void *xp, int *ip)
#line 837
{
#line 837
    int err=NC_NOERR;
#line 837
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 837
    get_ix_int(xp, (ix_int *)ip);
#line 837
#else
#line 837
    ix_int xx = 0;
#line 837
    get_ix_int(xp, &xx);
#line 837

#line 837
#if IX_INT_MAX > INT_MAX
#line 837
    if (xx > INT_MAX || xx < INT_MIN) {
#line 837
#ifdef ERANGE_FILL
#line 837
        *ip = NC_FILL_INT;
#line 837
        return NC_ERANGE;
#line 837
#else
#line 837
        err = NC_ERANGE;
#line 837
#endif
#line 837
    }
#line 837
#endif
#line 837

#line 837

#line 837
    *ip = (int) xx;
#line 837
#endif
#line 837
    return err;
#line 837
}
#line 837

#endif
static int
#line 839
ncx_get_int_schar(const void *xp, schar *ip)
#line 839
{
#line 839
    int err=NC_NOERR;
#line 839
    ix_int xx = 0;
#line 839
    get_ix_int(xp, &xx);
#line 839

#line 839
#if IX_INT_MAX > SCHAR_MAX
#line 839
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 839
#ifdef ERANGE_FILL
#line 839
        *ip = NC_FILL_BYTE;
#line 839
        return NC_ERANGE;
#line 839
#else
#line 839
        err = NC_ERANGE;
#line 839
#endif
#line 839
    }
#line 839
#endif
#line 839

#line 839

#line 839
    *ip = (schar) xx;
#line 839
    return err;
#line 839
}
#line 839

static int
#line 840
ncx_get_int_short(const void *xp, short *ip)
#line 840
{
#line 840
    int err=NC_NOERR;
#line 840
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 840
    get_ix_int(xp, (ix_int *)ip);
#line 840
#else
#line 840
    ix_int xx = 0;
#line 840
    get_ix_int(xp, &xx);
#line 840

#line 840
#if IX_INT_MAX > SHORT_MAX
#line 840
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 840
#ifdef ERANGE_FILL
#line 840
        *ip = NC_FILL_SHORT;
#line 840
        return NC_ERANGE;
#line 840
#else
#line 840
        err = NC_ERANGE;
#line 840
#endif
#line 840
    }
#line 840
#endif
#line 840

#line 840

#line 840
    *ip = (short) xx;
#line 840
#endif
#line 840
    return err;
#line 840
}
#line 840

static int
#line 841
ncx_get_int_long(const void *xp, long *ip)
#line 841
{
#line 841
    int err=NC_NOERR;
#line 841
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 841
    get_ix_int(xp, (ix_int *)ip);
#line 841
#else
#line 841
    ix_int xx = 0;
#line 841
    get_ix_int(xp, &xx);
#line 841

#line 841
#if IX_INT_MAX > LONG_MAX
#line 841
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 841
#ifdef ERANGE_FILL
#line 841
        *ip = NC_FILL_INT;
#line 841
        return NC_ERANGE;
#line 841
#else
#line 841
        err = NC_ERANGE;
#line 841
#endif
#line 841
    }
#line 841
#endif
#line 841

#line 841

#line 841
    *ip = (long) xx;
#line 841
#endif
#line 841
    return err;
#line 841
}
#line 841

static int
#line 842
ncx_get_int_longlong(const void *xp, longlong *ip)
#line 842
{
#line 842
    int err=NC_NOERR;
#line 842
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 842
    get_ix_int(xp, (ix_int *)ip);
#line 842
#else
#line 842
    ix_int xx = 0;
#line 842
    get_ix_int(xp, &xx);
#line 842

#line 842
#if IX_INT_MAX > LONGLONG_MAX
#line 842
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 842
#ifdef ERANGE_FILL
#line 842
        *ip = NC_FILL_INT64;
#line 842
        return NC_ERANGE;
#line 842
#else
#line 842
        err = NC_ERANGE;
#line 842
#endif
#line 842
    }
#line 842
#endif
#line 842

#line 842

#line 842
    *ip = (longlong) xx;
#line 842
#endif
#line 842
    return err;
#line 842
}
#line 842

static int
#line 843
ncx_get_int_ushort(const void *xp, ushort *ip)
#line 843
{
#line 843
    int err=NC_NOERR;
#line 843
    ix_int xx = 0;
#line 843
    get_ix_int(xp, &xx);
#line 843

#line 843
#if IX_INT_MAX > USHORT_MAX
#line 843
    if (xx > USHORT_MAX) {
#line 843
#ifdef ERANGE_FILL
#line 843
        *ip = NC_FILL_USHORT;
#line 843
        return NC_ERANGE;
#line 843
#else
#line 843
        err = NC_ERANGE;
#line 843
#endif
#line 843
    }
#line 843
#endif
#line 843

#line 843
    if (xx < 0) {
#line 843
#ifdef ERANGE_FILL
#line 843
        *ip = NC_FILL_USHORT;
#line 843
        return NC_ERANGE;
#line 843
#else
#line 843
        err = NC_ERANGE; /* because ip is unsigned */
#line 843
#endif
#line 843
    }
#line 843
    *ip = (ushort) xx;
#line 843
    return err;
#line 843
}
#line 843

static int
#line 844
ncx_get_int_uchar(const void *xp, uchar *ip)
#line 844
{
#line 844
    int err=NC_NOERR;
#line 844
    ix_int xx = 0;
#line 844
    get_ix_int(xp, &xx);
#line 844

#line 844
#if IX_INT_MAX > UCHAR_MAX
#line 844
    if (xx > UCHAR_MAX) {
#line 844
#ifdef ERANGE_FILL
#line 844
        *ip = NC_FILL_UBYTE;
#line 844
        return NC_ERANGE;
#line 844
#else
#line 844
        err = NC_ERANGE;
#line 844
#endif
#line 844
    }
#line 844
#endif
#line 844

#line 844
    if (xx < 0) {
#line 844
#ifdef ERANGE_FILL
#line 844
        *ip = NC_FILL_UBYTE;
#line 844
        return NC_ERANGE;
#line 844
#else
#line 844
        err = NC_ERANGE; /* because ip is unsigned */
#line 844
#endif
#line 844
    }
#line 844
    *ip = (uchar) xx;
#line 844
    return err;
#line 844
}
#line 844

static int
#line 845
ncx_get_int_uint(const void *xp, uint *ip)
#line 845
{
#line 845
    int err=NC_NOERR;
#line 845
    ix_int xx = 0;
#line 845
    get_ix_int(xp, &xx);
#line 845

#line 845
#if IX_INT_MAX > UINT_MAX
#line 845
    if (xx > UINT_MAX) {
#line 845
#ifdef ERANGE_FILL
#line 845
        *ip = NC_FILL_UINT;
#line 845
        return NC_ERANGE;
#line 845
#else
#line 845
        err = NC_ERANGE;
#line 845
#endif
#line 845
    }
#line 845
#endif
#line 845

#line 845
    if (xx < 0) {
#line 845
#ifdef ERANGE_FILL
#line 845
        *ip = NC_FILL_UINT;
#line 845
        return NC_ERANGE;
#line 845
#else
#line 845
        err = NC_ERANGE; /* because ip is unsigned */
#line 845
#endif
#line 845
    }
#line 845
    *ip = (uint) xx;
#line 845
    return err;
#line 845
}
#line 845

static int
#line 846
ncx_get_int_ulonglong(const void *xp, ulonglong *ip)
#line 846
{
#line 846
    int err=NC_NOERR;
#line 846
    ix_int xx = 0;
#line 846
    get_ix_int(xp, &xx);
#line 846

#line 846
#if IX_INT_MAX > ULONGLONG_MAX
#line 846
    if (xx > ULONGLONG_MAX) {
#line 846
#ifdef ERANGE_FILL
#line 846
        *ip = NC_FILL_UINT64;
#line 846
        return NC_ERANGE;
#line 846
#else
#line 846
        err = NC_ERANGE;
#line 846
#endif
#line 846
    }
#line 846
#endif
#line 846

#line 846
    if (xx < 0) {
#line 846
#ifdef ERANGE_FILL
#line 846
        *ip = NC_FILL_UINT64;
#line 846
        return NC_ERANGE;
#line 846
#else
#line 846
        err = NC_ERANGE; /* because ip is unsigned */
#line 846
#endif
#line 846
    }
#line 846
    *ip = (ulonglong) xx;
#line 846
    return err;
#line 846
}
#line 846

static int
#line 847
ncx_get_int_float(const void *xp, float *ip)
#line 847
{
#line 847
	ix_int xx = 0;
#line 847
	get_ix_int(xp, &xx);
#line 847
	*ip = (float)xx;
#line 847
	return NC_NOERR;
#line 847
}
#line 847

static int
#line 848
ncx_get_int_double(const void *xp, double *ip)
#line 848
{
#line 848
	ix_int xx = 0;
#line 848
	get_ix_int(xp, &xx);
#line 848
	*ip = (double)xx;
#line 848
	return NC_NOERR;
#line 848
}
#line 848


static int
ncx_put_int_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
	{
		*cp++ = 0xff;
		*cp++ = 0xff;
		*cp++ = 0xff;
	}
	else
	{
		*cp++ = 0x00;
		*cp++ = 0x00;
		*cp++ = 0x00;
	}
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_int_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 882
ncx_put_int_int(void *xp, const int *ip, void *fillp)
#line 882
{
#line 882
    int err=NC_NOERR;
#line 882
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 882
    put_ix_int(xp, (const ix_int *)ip);
#line 882
#else
#line 882
    ix_int xx = NC_FILL_INT;
#line 882

#line 882
#if IX_INT_MAX < INT_MAX
#line 882
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 882
        
#line 882
#ifdef ERANGE_FILL
#line 882
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 882
#endif
#line 882
        err = NC_ERANGE;
#line 882
    }
#line 882
#ifdef ERANGE_FILL
#line 882
    else
#line 882
#endif
#line 882
#endif
#line 882
        xx = (ix_int)*ip;
#line 882

#line 882
    put_ix_int(xp, &xx);
#line 882
#endif
#line 882
    return err;
#line 882
}
#line 882

#endif
static int
#line 884
ncx_put_int_short(void *xp, const short *ip, void *fillp)
#line 884
{
#line 884
    int err=NC_NOERR;
#line 884
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 884
    put_ix_int(xp, (const ix_int *)ip);
#line 884
#else
#line 884
    ix_int xx = NC_FILL_INT;
#line 884

#line 884
#if IX_INT_MAX < SHORT_MAX
#line 884
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 884
        
#line 884
#ifdef ERANGE_FILL
#line 884
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 884
#endif
#line 884
        err = NC_ERANGE;
#line 884
    }
#line 884
#ifdef ERANGE_FILL
#line 884
    else
#line 884
#endif
#line 884
#endif
#line 884
        xx = (ix_int)*ip;
#line 884

#line 884
    put_ix_int(xp, &xx);
#line 884
#endif
#line 884
    return err;
#line 884
}
#line 884

static int
#line 885
ncx_put_int_long(void *xp, const long *ip, void *fillp)
#line 885
{
#line 885
    int err=NC_NOERR;
#line 885
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 885
    put_ix_int(xp, (const ix_int *)ip);
#line 885
#else
#line 885
    ix_int xx = NC_FILL_INT;
#line 885

#line 885
#if IX_INT_MAX < LONG_MAX
#line 885
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 885
        
#line 885
#ifdef ERANGE_FILL
#line 885
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 885
#endif
#line 885
        err = NC_ERANGE;
#line 885
    }
#line 885
#ifdef ERANGE_FILL
#line 885
    else
#line 885
#endif
#line 885
#endif
#line 885
        xx = (ix_int)*ip;
#line 885

#line 885
    put_ix_int(xp, &xx);
#line 885
#endif
#line 885
    return err;
#line 885
}
#line 885

static int
#line 886
ncx_put_int_longlong(void *xp, const longlong *ip, void *fillp)
#line 886
{
#line 886
    int err=NC_NOERR;
#line 886
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 886
    put_ix_int(xp, (const ix_int *)ip);
#line 886
#else
#line 886
    ix_int xx = NC_FILL_INT;
#line 886

#line 886
#if IX_INT_MAX < LONGLONG_MAX
#line 886
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 886
        
#line 886
#ifdef ERANGE_FILL
#line 886
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 886
#endif
#line 886
        err = NC_ERANGE;
#line 886
    }
#line 886
#ifdef ERANGE_FILL
#line 886
    else
#line 886
#endif
#line 886
#endif
#line 886
        xx = (ix_int)*ip;
#line 886

#line 886
    put_ix_int(xp, &xx);
#line 886
#endif
#line 886
    return err;
#line 886
}
#line 886

static int
#line 887
ncx_put_int_ushort(void *xp, const ushort *ip, void *fillp)
#line 887
{
#line 887
    int err=NC_NOERR;
#line 887
    ix_int xx = NC_FILL_INT;
#line 887

#line 887
#if IX_INT_MAX < USHORT_MAX
#line 887
    if (*ip > IX_INT_MAX) {
#line 887
        
#line 887
#ifdef ERANGE_FILL
#line 887
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 887
#endif
#line 887
        err = NC_ERANGE;
#line 887
    }
#line 887
#ifdef ERANGE_FILL
#line 887
    else
#line 887
#endif
#line 887
#endif
#line 887
        xx = (ix_int)*ip;
#line 887

#line 887
    put_ix_int(xp, &xx);
#line 887
    return err;
#line 887
}
#line 887

static int
#line 888
ncx_put_int_uint(void *xp, const uint *ip, void *fillp)
#line 888
{
#line 888
    int err=NC_NOERR;
#line 888
    ix_int xx = NC_FILL_INT;
#line 888

#line 888
#if IX_INT_MAX < UINT_MAX
#line 888
    if (*ip > IX_INT_MAX) {
#line 888
        
#line 888
#ifdef ERANGE_FILL
#line 888
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 888
#endif
#line 888
        err = NC_ERANGE;
#line 888
    }
#line 888
#ifdef ERANGE_FILL
#line 888
    else
#line 888
#endif
#line 888
#endif
#line 888
        xx = (ix_int)*ip;
#line 888

#line 888
    put_ix_int(xp, &xx);
#line 888
    return err;
#line 888
}
#line 888

static int
#line 889
ncx_put_int_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 889
{
#line 889
    int err=NC_NOERR;
#line 889
    ix_int xx = NC_FILL_INT;
#line 889

#line 889
#if IX_INT_MAX < ULONGLONG_MAX
#line 889
    if (*ip > IX_INT_MAX) {
#line 889
        
#line 889
#ifdef ERANGE_FILL
#line 889
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 889
#endif
#line 889
        err = NC_ERANGE;
#line 889
    }
#line 889
#ifdef ERANGE_FILL
#line 889
    else
#line 889
#endif
#line 889
#endif
#line 889
        xx = (ix_int)*ip;
#line 889

#line 889
    put_ix_int(xp, &xx);
#line 889
    return err;
#line 889
}
#line 889

static int
#line 890
ncx_put_int_float(void *xp, const float *ip, void *fillp)
#line 890
{
#line 890
    int err=NC_NOERR;
#line 890
    ix_int xx = NC_FILL_INT;
#line 890

#line 890
    if (*ip > (double)X_INT_MAX || *ip < (double)X_INT_MIN) {
#line 890
        
#line 890
#ifdef ERANGE_FILL
#line 890
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 890
#endif
#line 890
        err = NC_ERANGE;
#line 890
    }
#line 890
#ifdef ERANGE_FILL
#line 890
    else
#line 890
#endif
#line 890
        xx = (ix_int)*ip;
#line 890

#line 890
    put_ix_int(xp, &xx);
#line 890
    return err;
#line 890
}
#line 890

static int
#line 891
ncx_put_int_double(void *xp, const double *ip, void *fillp)
#line 891
{
#line 891
    int err=NC_NOERR;
#line 891
    ix_int xx = NC_FILL_INT;
#line 891

#line 891
    if (*ip > X_INT_MAX || *ip < X_INT_MIN) {
#line 891
        
#line 891
#ifdef ERANGE_FILL
#line 891
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 891
#endif
#line 891
        err = NC_ERANGE;
#line 891
    }
#line 891
#ifdef ERANGE_FILL
#line 891
    else
#line 891
#endif
#line 891
        xx = (ix_int)*ip;
#line 891

#line 891
    put_ix_int(xp, &xx);
#line 891
    return err;
#line 891
}
#line 891



/* external NC_UINT ---------------------------------------------------------*/

#if USHORT_MAX == X_UINT_MAX
typedef ushort ix_uint;
#define SIZEOF_IX_UINT SIZEOF_USHORT
#define IX_UINT_MAX USHORT_MAX
#elif UINT_MAX  >= X_UINT_MAX
typedef uint ix_uint;
#define SIZEOF_IX_UINT SIZEOF_UINT
#define IX_UINT_MAX UINT_MAX
#elif ULONG_MAX  >= X_UINT_MAX
typedef ulong ix_uint;
#define SIZEOF_IX_UINT SIZEOF_ULONG
#define IX_UINT_MAX ULONG_MAX
#else
#error "ix_uint implementation"
#endif


static void
get_ix_uint(const void *xp, ix_uint *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip = (ix_uint)(*cp++ << 24);
	*ip = (ix_uint)(*ip | (ix_uint)(*cp++ << 16));
	*ip = (ix_uint)(*ip | (ix_uint)(*cp++ << 8));
	*ip = (ix_uint)(*ip | *cp);
}

static void
put_ix_uint(void *xp, const ix_uint *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)((*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 936
ncx_get_uint_uint(const void *xp, uint *ip)
#line 936
{
#line 936
    int err=NC_NOERR;
#line 936
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 936
    get_ix_uint(xp, (ix_uint *)ip);
#line 936
#else
#line 936
    ix_uint xx = 0;
#line 936
    get_ix_uint(xp, &xx);
#line 936

#line 936
#if IX_UINT_MAX > UINT_MAX
#line 936
    if (xx > UINT_MAX) {
#line 936
#ifdef ERANGE_FILL
#line 936
        *ip = NC_FILL_UINT;
#line 936
        return NC_ERANGE;
#line 936
#else
#line 936
        err = NC_ERANGE;
#line 936
#endif
#line 936
    }
#line 936
#endif
#line 936

#line 936

#line 936
    *ip = (uint) xx;
#line 936
#endif
#line 936
    return err;
#line 936
}
#line 936

#endif

static int
#line 939
ncx_get_uint_schar(const void *xp, schar *ip)
#line 939
{
#line 939
    int err=NC_NOERR;
#line 939
    ix_uint xx = 0;
#line 939
    get_ix_uint(xp, &xx);
#line 939

#line 939
#if IX_UINT_MAX > SCHAR_MAX
#line 939
    if (xx > SCHAR_MAX) {
#line 939
#ifdef ERANGE_FILL
#line 939
        *ip = NC_FILL_BYTE;
#line 939
        return NC_ERANGE;
#line 939
#else
#line 939
        err = NC_ERANGE;
#line 939
#endif
#line 939
    }
#line 939
#endif
#line 939

#line 939

#line 939
    *ip = (schar) xx;
#line 939
    return err;
#line 939
}
#line 939

static int
#line 940
ncx_get_uint_short(const void *xp, short *ip)
#line 940
{
#line 940
    int err=NC_NOERR;
#line 940
    ix_uint xx = 0;
#line 940
    get_ix_uint(xp, &xx);
#line 940

#line 940
#if IX_UINT_MAX > SHORT_MAX
#line 940
    if (xx > SHORT_MAX) {
#line 940
#ifdef ERANGE_FILL
#line 940
        *ip = NC_FILL_SHORT;
#line 940
        return NC_ERANGE;
#line 940
#else
#line 940
        err = NC_ERANGE;
#line 940
#endif
#line 940
    }
#line 940
#endif
#line 940

#line 940

#line 940
    *ip = (short) xx;
#line 940
    return err;
#line 940
}
#line 940

static int
#line 941
ncx_get_uint_int(const void *xp, int *ip)
#line 941
{
#line 941
    int err=NC_NOERR;
#line 941
    ix_uint xx = 0;
#line 941
    get_ix_uint(xp, &xx);
#line 941

#line 941
#if IX_UINT_MAX > INT_MAX
#line 941
    if (xx > INT_MAX) {
#line 941
#ifdef ERANGE_FILL
#line 941
        *ip = NC_FILL_INT;
#line 941
        return NC_ERANGE;
#line 941
#else
#line 941
        err = NC_ERANGE;
#line 941
#endif
#line 941
    }
#line 941
#endif
#line 941

#line 941

#line 941
    *ip = (int) xx;
#line 941
    return err;
#line 941
}
#line 941

static int
#line 942
ncx_get_uint_long(const void *xp, long *ip)
#line 942
{
#line 942
    int err=NC_NOERR;
#line 942
    ix_uint xx = 0;
#line 942
    get_ix_uint(xp, &xx);
#line 942

#line 942
#if IX_UINT_MAX > LONG_MAX
#line 942
    if (xx > LONG_MAX) {
#line 942
#ifdef ERANGE_FILL
#line 942
        *ip = NC_FILL_INT;
#line 942
        return NC_ERANGE;
#line 942
#else
#line 942
        err = NC_ERANGE;
#line 942
#endif
#line 942
    }
#line 942
#endif
#line 942

#line 942

#line 942
    *ip = (long) xx;
#line 942
    return err;
#line 942
}
#line 942

static int
#line 943
ncx_get_uint_longlong(const void *xp, longlong *ip)
#line 943
{
#line 943
    int err=NC_NOERR;
#line 943
    ix_uint xx = 0;
#line 943
    get_ix_uint(xp, &xx);
#line 943

#line 943
#if IX_UINT_MAX > LONGLONG_MAX
#line 943
    if (xx > LONGLONG_MAX) {
#line 943
#ifdef ERANGE_FILL
#line 943
        *ip = NC_FILL_INT64;
#line 943
        return NC_ERANGE;
#line 943
#else
#line 943
        err = NC_ERANGE;
#line 943
#endif
#line 943
    }
#line 943
#endif
#line 943

#line 943

#line 943
    *ip = (longlong) xx;
#line 943
    return err;
#line 943
}
#line 943

static int
#line 944
ncx_get_uint_ushort(const void *xp, ushort *ip)
#line 944
{
#line 944
    int err=NC_NOERR;
#line 944
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 944
    get_ix_uint(xp, (ix_uint *)ip);
#line 944
#else
#line 944
    ix_uint xx = 0;
#line 944
    get_ix_uint(xp, &xx);
#line 944

#line 944
#if IX_UINT_MAX > USHORT_MAX
#line 944
    if (xx > USHORT_MAX) {
#line 944
#ifdef ERANGE_FILL
#line 944
        *ip = NC_FILL_USHORT;
#line 944
        return NC_ERANGE;
#line 944
#else
#line 944
        err = NC_ERANGE;
#line 944
#endif
#line 944
    }
#line 944
#endif
#line 944

#line 944

#line 944
    *ip = (ushort) xx;
#line 944
#endif
#line 944
    return err;
#line 944
}
#line 944

static int
#line 945
ncx_get_uint_uchar(const void *xp, uchar *ip)
#line 945
{
#line 945
    int err=NC_NOERR;
#line 945
#if SIZEOF_IX_UINT == SIZEOF_UCHAR && IX_UINT_MAX == UCHAR_MAX
#line 945
    get_ix_uint(xp, (ix_uint *)ip);
#line 945
#else
#line 945
    ix_uint xx = 0;
#line 945
    get_ix_uint(xp, &xx);
#line 945

#line 945
#if IX_UINT_MAX > UCHAR_MAX
#line 945
    if (xx > UCHAR_MAX) {
#line 945
#ifdef ERANGE_FILL
#line 945
        *ip = NC_FILL_UBYTE;
#line 945
        return NC_ERANGE;
#line 945
#else
#line 945
        err = NC_ERANGE;
#line 945
#endif
#line 945
    }
#line 945
#endif
#line 945

#line 945

#line 945
    *ip = (uchar) xx;
#line 945
#endif
#line 945
    return err;
#line 945
}
#line 945

static int
#line 946
ncx_get_uint_ulonglong(const void *xp, ulonglong *ip)
#line 946
{
#line 946
    int err=NC_NOERR;
#line 946
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 946
    get_ix_uint(xp, (ix_uint *)ip);
#line 946
#else
#line 946
    ix_uint xx = 0;
#line 946
    get_ix_uint(xp, &xx);
#line 946

#line 946
#if IX_UINT_MAX > ULONGLONG_MAX
#line 946
    if (xx > ULONGLONG_MAX) {
#line 946
#ifdef ERANGE_FILL
#line 946
        *ip = NC_FILL_UINT64;
#line 946
        return NC_ERANGE;
#line 946
#else
#line 946
        err = NC_ERANGE;
#line 946
#endif
#line 946
    }
#line 946
#endif
#line 946

#line 946

#line 946
    *ip = (ulonglong) xx;
#line 946
#endif
#line 946
    return err;
#line 946
}
#line 946

static int
#line 947
ncx_get_uint_float(const void *xp, float *ip)
#line 947
{
#line 947
	ix_uint xx = 0;
#line 947
	get_ix_uint(xp, &xx);
#line 947
	*ip = (float)xx;
#line 947
	return NC_NOERR;
#line 947
}
#line 947

static int
#line 948
ncx_get_uint_double(const void *xp, double *ip)
#line 948
{
#line 948
	ix_uint xx = 0;
#line 948
	get_ix_uint(xp, &xx);
#line 948
	*ip = (double)xx;
#line 948
	return NC_NOERR;
#line 948
}
#line 948


static int
ncx_put_uint_schar(void *xp, const schar *ip, void *fillp)
{
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 4);
#ifndef WORDS_BIGENDIAN
        swapn4b(xp, xp, 1);
#endif
#endif
        return NC_ERANGE;
    }

    cp = (uchar *) xp;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp = (uchar)*ip;

    return NC_NOERR;
}

static int
ncx_put_uint_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 985
ncx_put_uint_uint(void *xp, const uint *ip, void *fillp)
#line 985
{
#line 985
    int err=NC_NOERR;
#line 985
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 985
    put_ix_uint(xp, (const ix_uint *)ip);
#line 985
#else
#line 985
    ix_uint xx = NC_FILL_UINT;
#line 985

#line 985
#if IX_UINT_MAX < UINT_MAX
#line 985
    if (*ip > IX_UINT_MAX) {
#line 985
        
#line 985
#ifdef ERANGE_FILL
#line 985
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 985
#endif
#line 985
        err = NC_ERANGE;
#line 985
    }
#line 985
#ifdef ERANGE_FILL
#line 985
    else
#line 985
#endif
#line 985
#endif
#line 985
        xx = (ix_uint)*ip;
#line 985

#line 985
    put_ix_uint(xp, &xx);
#line 985
#endif
#line 985
    return err;
#line 985
}
#line 985

#endif

static int
#line 988
ncx_put_uint_short(void *xp, const short *ip, void *fillp)
#line 988
{
#line 988
    int err=NC_NOERR;
#line 988
    ix_uint xx = NC_FILL_UINT;
#line 988

#line 988
#if IX_UINT_MAX < SHORT_MAX
#line 988
    if (*ip > IX_UINT_MAX) {
#line 988
        
#line 988
#ifdef ERANGE_FILL
#line 988
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 988
#endif
#line 988
        err = NC_ERANGE;
#line 988
    }
#line 988
#ifdef ERANGE_FILL
#line 988
    else
#line 988
#endif
#line 988
#endif
#line 988
    if (*ip < 0) {
#line 988
        
#line 988
#ifdef ERANGE_FILL
#line 988
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 988
#endif
#line 988
        err = NC_ERANGE; /* because xp is unsigned */
#line 988
    }
#line 988
#ifdef ERANGE_FILL
#line 988
    else
#line 988
#endif
#line 988
        xx = (ix_uint)*ip;
#line 988

#line 988
    put_ix_uint(xp, &xx);
#line 988
    return err;
#line 988
}
#line 988

static int
#line 989
ncx_put_uint_int(void *xp, const int *ip, void *fillp)
#line 989
{
#line 989
    int err=NC_NOERR;
#line 989
    ix_uint xx = NC_FILL_UINT;
#line 989

#line 989
#if IX_UINT_MAX < INT_MAX
#line 989
    if (*ip > IX_UINT_MAX) {
#line 989
        
#line 989
#ifdef ERANGE_FILL
#line 989
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 989
#endif
#line 989
        err = NC_ERANGE;
#line 989
    }
#line 989
#ifdef ERANGE_FILL
#line 989
    else
#line 989
#endif
#line 989
#endif
#line 989
    if (*ip < 0) {
#line 989
        
#line 989
#ifdef ERANGE_FILL
#line 989
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 989
#endif
#line 989
        err = NC_ERANGE; /* because xp is unsigned */
#line 989
    }
#line 989
#ifdef ERANGE_FILL
#line 989
    else
#line 989
#endif
#line 989
        xx = (ix_uint)*ip;
#line 989

#line 989
    put_ix_uint(xp, &xx);
#line 989
    return err;
#line 989
}
#line 989

static int
#line 990
ncx_put_uint_long(void *xp, const long *ip, void *fillp)
#line 990
{
#line 990
    int err=NC_NOERR;
#line 990
    ix_uint xx = NC_FILL_UINT;
#line 990

#line 990
#if IX_UINT_MAX < LONG_MAX
#line 990
    if (*ip > IX_UINT_MAX) {
#line 990
        
#line 990
#ifdef ERANGE_FILL
#line 990
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 990
#endif
#line 990
        err = NC_ERANGE;
#line 990
    }
#line 990
#ifdef ERANGE_FILL
#line 990
    else
#line 990
#endif
#line 990
#endif
#line 990
    if (*ip < 0) {
#line 990
        
#line 990
#ifdef ERANGE_FILL
#line 990
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 990
#endif
#line 990
        err = NC_ERANGE; /* because xp is unsigned */
#line 990
    }
#line 990
#ifdef ERANGE_FILL
#line 990
    else
#line 990
#endif
#line 990
        xx = (ix_uint)*ip;
#line 990

#line 990
    put_ix_uint(xp, &xx);
#line 990
    return err;
#line 990
}
#line 990

static int
#line 991
ncx_put_uint_longlong(void *xp, const longlong *ip, void *fillp)
#line 991
{
#line 991
    int err=NC_NOERR;
#line 991
    ix_uint xx = NC_FILL_UINT;
#line 991

#line 991
#if IX_UINT_MAX < LONGLONG_MAX
#line 991
    if (*ip > IX_UINT_MAX) {
#line 991
        
#line 991
#ifdef ERANGE_FILL
#line 991
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 991
#endif
#line 991
        err = NC_ERANGE;
#line 991
    }
#line 991
#ifdef ERANGE_FILL
#line 991
    else
#line 991
#endif
#line 991
#endif
#line 991
    if (*ip < 0) {
#line 991
        
#line 991
#ifdef ERANGE_FILL
#line 991
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 991
#endif
#line 991
        err = NC_ERANGE; /* because xp is unsigned */
#line 991
    }
#line 991
#ifdef ERANGE_FILL
#line 991
    else
#line 991
#endif
#line 991
        xx = (ix_uint)*ip;
#line 991

#line 991
    put_ix_uint(xp, &xx);
#line 991
    return err;
#line 991
}
#line 991

static int
#line 992
ncx_put_uint_ushort(void *xp, const ushort *ip, void *fillp)
#line 992
{
#line 992
    int err=NC_NOERR;
#line 992
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 992
    put_ix_uint(xp, (const ix_uint *)ip);
#line 992
#else
#line 992
    ix_uint xx = NC_FILL_UINT;
#line 992

#line 992
#if IX_UINT_MAX < USHORT_MAX
#line 992
    if (*ip > IX_UINT_MAX) {
#line 992
        
#line 992
#ifdef ERANGE_FILL
#line 992
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 992
#endif
#line 992
        err = NC_ERANGE;
#line 992
    }
#line 992
#ifdef ERANGE_FILL
#line 992
    else
#line 992
#endif
#line 992
#endif
#line 992
        xx = (ix_uint)*ip;
#line 992

#line 992
    put_ix_uint(xp, &xx);
#line 992
#endif
#line 992
    return err;
#line 992
}
#line 992

static int
#line 993
ncx_put_uint_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 993
{
#line 993
    int err=NC_NOERR;
#line 993
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 993
    put_ix_uint(xp, (const ix_uint *)ip);
#line 993
#else
#line 993
    ix_uint xx = NC_FILL_UINT;
#line 993

#line 993
#if IX_UINT_MAX < ULONGLONG_MAX
#line 993
    if (*ip > IX_UINT_MAX) {
#line 993
        
#line 993
#ifdef ERANGE_FILL
#line 993
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 993
#endif
#line 993
        err = NC_ERANGE;
#line 993
    }
#line 993
#ifdef ERANGE_FILL
#line 993
    else
#line 993
#endif
#line 993
#endif
#line 993
        xx = (ix_uint)*ip;
#line 993

#line 993
    put_ix_uint(xp, &xx);
#line 993
#endif
#line 993
    return err;
#line 993
}
#line 993

static int
#line 994
ncx_put_uint_float(void *xp, const float *ip, void *fillp)
#line 994
{
#line 994
    int err=NC_NOERR;
#line 994
    ix_uint xx = NC_FILL_UINT;
#line 994

#line 994
    if (*ip > (double)X_UINT_MAX || *ip < 0) {
#line 994
        
#line 994
#ifdef ERANGE_FILL
#line 994
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 994
#endif
#line 994
        err = NC_ERANGE;
#line 994
    }
#line 994
#ifdef ERANGE_FILL
#line 994
    else
#line 994
#endif
#line 994
        xx = (ix_uint)*ip;
#line 994

#line 994
    put_ix_uint(xp, &xx);
#line 994
    return err;
#line 994
}
#line 994

static int
#line 995
ncx_put_uint_double(void *xp, const double *ip, void *fillp)
#line 995
{
#line 995
    int err=NC_NOERR;
#line 995
    ix_uint xx = NC_FILL_UINT;
#line 995

#line 995
    if (*ip > X_UINT_MAX || *ip < 0) {
#line 995
        
#line 995
#ifdef ERANGE_FILL
#line 995
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 995
#endif
#line 995
        err = NC_ERANGE;
#line 995
    }
#line 995
#ifdef ERANGE_FILL
#line 995
    else
#line 995
#endif
#line 995
        xx = (ix_uint)*ip;
#line 995

#line 995
    put_ix_uint(xp, &xx);
#line 995
    return err;
#line 995
}
#line 995



/* external NC_FLOAT --------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)

inline static void
get_ix_float(const void *xp, float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_FLOAT);
#else
	swap4b(ip, xp);
#endif
}

inline static void
put_ix_float(void *xp, const float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_FLOAT);
#else
	swap4b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE single precision floating point looks like on a Vax */
struct	ieee_single {
	unsigned int	exp_hi       : 7;
	unsigned int	sign         : 1;
	unsigned int 	mant_hi      : 7;
	unsigned int	exp_lo       : 1;
	unsigned int	mant_lo_hi   : 8;
	unsigned int	mant_lo_lo   : 8;
};

/* Vax single precision floating point */
struct	vax_single {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
};

#define VAX_SNG_BIAS	0x81
#define IEEE_SNG_BIAS	0x7f

static struct sgl_limits {
	struct vax_single s;
	struct ieee_single ieee;
} max = {
	{ 0x7f, 0xff, 0x0, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0x1, 0x0, 0x0 }		/* Max IEEE */
};
static struct sgl_limits min = {
	{ 0x0, 0x0, 0x0, 0x0 },	/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 }		/* Min IEEE */
};

#line 1109
static void
get_ix_float(const void *xp, float *ip)
{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 1112
		const struct ieee_single *const isp =
#line 1112
			 (const struct ieee_single *) xp;
#line 1112
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 1112

#line 1112
		switch(exp) {
#line 1112
		case 0 :
#line 1112
			/* ieee subnormal */
#line 1112
			if (isp->mant_hi == min.ieee.mant_hi
#line 1112
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 1112
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 1112
			{
#line 1112
				*vsp = min.s;
#line 1112
			}
#line 1112
			else
#line 1112
			{
#line 1112
				unsigned mantissa = (isp->mant_hi << 16)
#line 1112
					 | isp->mant_lo_hi << 8
#line 1112
					 | isp->mant_lo_lo;
#line 1112
				unsigned tmp = mantissa >> 20;
#line 1112
				if (tmp >= 4) {
#line 1112
					vsp->exp = 2;
#line 1112
				} else if (tmp >= 2) {
#line 1112
					vsp->exp = 1;
#line 1112
				} else {
#line 1112
					*vsp = min.s;
#line 1112
					break;
#line 1112
				} /* else */
#line 1112
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 1112
				tmp <<= 3 - vsp->exp;
#line 1112
				vsp->mantissa2 = tmp;
#line 1112
				vsp->mantissa1 = (tmp >> 16);
#line 1112
			}
#line 1112
			break;
#line 1112
		case 0xfe :
#line 1112
		case 0xff :
#line 1112
			*vsp = max.s;
#line 1112
			break;
#line 1112
		default :
#line 1112
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 1112
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 1112
			vsp->mantissa1 = isp->mant_hi;
#line 1112
		}
#line 1112

#line 1112
		vsp->sign = isp->sign;
#line 1112

}

#line 1166

static void
put_ix_float(void *xp, const float *ip)
{
		const struct vax_single *const vsp =
#line 1170
			 (const struct vax_single *)ip;
#line 1170
		struct ieee_single *const isp = (struct ieee_single *) xp;
#line 1170

#line 1170
		switch(vsp->exp){
#line 1170
		case 0 :
#line 1170
			/* all vax float with zero exponent map to zero */
#line 1170
			*isp = min.ieee;
#line 1170
			break;
#line 1170
		case 2 :
#line 1170
		case 1 :
#line 1170
		{
#line 1170
			/* These will map to subnormals */
#line 1170
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 1170
					 | vsp->mantissa2;
#line 1170
			mantissa >>= 3 - vsp->exp;
#line 1170
			mantissa += (1 << (20 + vsp->exp));
#line 1170
			isp->mant_lo_lo = mantissa;
#line 1170
			isp->mant_lo_hi = mantissa >> 8;
#line 1170
			isp->mant_hi = mantissa >> 16;
#line 1170
			isp->exp_lo = 0;
#line 1170
			isp->exp_hi = 0;
#line 1170
		}
#line 1170
			break;
#line 1170
		case 0xff : /* max.s.exp */
#line 1170
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 1170
			    vsp->mantissa1 == max.s.mantissa1)
#line 1170
			{
#line 1170
				/* map largest vax float to ieee infinity */
#line 1170
				*isp = max.ieee;
#line 1170
				break;
#line 1170
			} /* else, fall thru */
#line 1170
		default :
#line 1170
		{
#line 1170
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 1170
			isp->exp_hi = exp >> 1;
#line 1170
			isp->exp_lo = exp;
#line 1170
			isp->mant_lo_lo = vsp->mantissa2;
#line 1170
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 1170
			isp->mant_hi = vsp->mantissa1;
#line 1170
		}
#line 1170
		}
#line 1170

#line 1170
		isp->sign = vsp->sign;
#line 1170

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

/*
 * Return the number of bytes until the next "word" boundary
 * N.B. This is based on the very weird YMP address structure,
 * which puts the address within a word in the leftmost 3 bits
 * of the address.
 */
static size_t
word_align(const void *vp)
{
	const size_t rem = ((size_t)vp >> (64 - 3)) & 0x7;
	return (rem != 0);
}

struct ieee_single_hi {
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
	unsigned int	pad	:32;
};
typedef struct ieee_single_hi ieee_single_hi;

struct ieee_single_lo {
	unsigned int	pad	:32;
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
};
typedef struct ieee_single_lo ieee_single_lo;

static const int ieee_single_bias = 0x7f;

struct ieee_double {
	unsigned int	sign	: 1;
	unsigned int	 exp	:11;
	unsigned int	mant	:52;
};
typedef struct ieee_double ieee_double;

static const int ieee_double_bias = 0x3ff;

#if defined(NO_IEEE_FLOAT)

struct cray_single {
	unsigned int	sign	: 1;
	unsigned int	 exp	:15;
	unsigned int	mant	:48;
};
typedef struct cray_single cray_single;

static const int cs_ieis_bias = 0x4000 - 0x7f;

static const int cs_id_bias = 0x4000 - 0x3ff;

#line 1305

static void
get_ix_float(const void *xp, float *ip)
{

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1313

#line 1313
		if (isp->exp == 0)
#line 1313
		{
#line 1313
			/* ieee subnormal */
#line 1313
			*ip = (double)isp->mant;
#line 1313
			if (isp->mant != 0)
#line 1313
			{
#line 1313
				csp->exp -= (ieee_single_bias + 22);
#line 1313
			}
#line 1313
		}
#line 1313
		else
#line 1313
		{
#line 1313
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1313
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1313
			csp->mant |= (1 << (48 - 1));
#line 1313
		}
#line 1313
		csp->sign = isp->sign;
#line 1313

#line 1313

	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1318

#line 1318
		if (isp->exp == 0)
#line 1318
		{
#line 1318
			/* ieee subnormal */
#line 1318
			*ip = (double)isp->mant;
#line 1318
			if (isp->mant != 0)
#line 1318
			{
#line 1318
				csp->exp -= (ieee_single_bias + 22);
#line 1318
			}
#line 1318
		}
#line 1318
		else
#line 1318
		{
#line 1318
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1318
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1318
			csp->mant |= (1 << (48 - 1));
#line 1318
		}
#line 1318
		csp->sign = isp->sign;
#line 1318

#line 1318

	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1328
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1328

#line 1328
	isp->sign = csp->sign;
#line 1328

#line 1328
	if (ieee_exp >= 0xff)
#line 1328
	{
#line 1328
		/* NC_ERANGE => ieee Inf */
#line 1328
		isp->exp = 0xff;
#line 1328
		isp->mant = 0x0;
#line 1328
	}
#line 1328
	else if (ieee_exp > 0)
#line 1328
	{
#line 1328
		/* normal ieee representation */
#line 1328
		isp->exp  = ieee_exp;
#line 1328
		/* assumes cray rep is in normal form */
#line 1328
		assert(csp->mant & 0x800000000000);
#line 1328
		isp->mant = (((csp->mant << 1) &
#line 1328
				0xffffffffffff) >> (48 - 23));
#line 1328
	}
#line 1328
	else if (ieee_exp > -23)
#line 1328
	{
#line 1328
		/* ieee subnormal, right shift */
#line 1328
		const int rshift = (48 - 23 - ieee_exp);
#line 1328

#line 1328
		isp->mant = csp->mant >> rshift;
#line 1328

#line 1328
#if 0
#line 1328
		if (csp->mant & (1 << (rshift -1)))
#line 1328
		{
#line 1328
			/* round up */
#line 1328
			isp->mant++;
#line 1328
		}
#line 1328
#endif
#line 1328

#line 1328
		isp->exp  = 0;
#line 1328
	}
#line 1328
	else
#line 1328
	{
#line 1328
		/* smaller than ieee can represent */
#line 1328
		isp->exp = 0;
#line 1328
		isp->mant = 0;
#line 1328
	}
#line 1328

	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1333
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1333

#line 1333
	isp->sign = csp->sign;
#line 1333

#line 1333
	if (ieee_exp >= 0xff)
#line 1333
	{
#line 1333
		/* NC_ERANGE => ieee Inf */
#line 1333
		isp->exp = 0xff;
#line 1333
		isp->mant = 0x0;
#line 1333
	}
#line 1333
	else if (ieee_exp > 0)
#line 1333
	{
#line 1333
		/* normal ieee representation */
#line 1333
		isp->exp  = ieee_exp;
#line 1333
		/* assumes cray rep is in normal form */
#line 1333
		assert(csp->mant & 0x800000000000);
#line 1333
		isp->mant = (((csp->mant << 1) &
#line 1333
				0xffffffffffff) >> (48 - 23));
#line 1333
	}
#line 1333
	else if (ieee_exp > -23)
#line 1333
	{
#line 1333
		/* ieee subnormal, right shift */
#line 1333
		const int rshift = (48 - 23 - ieee_exp);
#line 1333

#line 1333
		isp->mant = csp->mant >> rshift;
#line 1333

#line 1333
#if 0
#line 1333
		if (csp->mant & (1 << (rshift -1)))
#line 1333
		{
#line 1333
			/* round up */
#line 1333
			isp->mant++;
#line 1333
		}
#line 1333
#endif
#line 1333

#line 1333
		isp->exp  = 0;
#line 1333
	}
#line 1333
	else
#line 1333
	{
#line 1333
		/* smaller than ieee can represent */
#line 1333
		isp->exp = 0;
#line 1333
		isp->mant = 0;
#line 1333
	}
#line 1333

	}
}

#else
	/* IEEE Cray with only doubles */
static void
get_ix_float(const void *xp, float *ip)
{

	ieee_double *idp = (ieee_double *) ip;

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	const ieee_double *idp = (const ieee_double *) ip;
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
}
#endif

#else
#error "ix_float implementation"
#endif

#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_get_float_float(const void *xp, float *ip, void *fillp)
{
	/* TODO */
	get_ix_float(xp, ip);
	return NC_NOERR;
}
#endif

#define ix_float float

static int
#line 1420
ncx_get_float_schar(const void *xp, schar *ip)
#line 1420
{
#line 1420
	ix_float xx = 0;
#line 1420
	get_ix_float(xp, &xx);
#line 1420
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1420
#ifdef ERANGE_FILL
#line 1420
            *ip = NC_FILL_BYTE;
#line 1420
#endif
#line 1420
            return NC_ERANGE;
#line 1420
        }
#line 1420
	*ip = (schar)xx;
#line 1420
	return NC_NOERR;
#line 1420
}
#line 1420

static int
#line 1421
ncx_get_float_short(const void *xp, short *ip)
#line 1421
{
#line 1421
	ix_float xx = 0;
#line 1421
	get_ix_float(xp, &xx);
#line 1421
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1421
#ifdef ERANGE_FILL
#line 1421
            *ip = NC_FILL_SHORT;
#line 1421
#endif
#line 1421
            return NC_ERANGE;
#line 1421
        }
#line 1421
	*ip = (short)xx;
#line 1421
	return NC_NOERR;
#line 1421
}
#line 1421

static int
#line 1422
ncx_get_float_int(const void *xp, int *ip)
#line 1422
{
#line 1422
	ix_float xx = 0;
#line 1422
	get_ix_float(xp, &xx);
#line 1422
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1422
#ifdef ERANGE_FILL
#line 1422
            *ip = NC_FILL_INT;
#line 1422
#endif
#line 1422
            return NC_ERANGE;
#line 1422
        }
#line 1422
	*ip = (int)xx;
#line 1422
	return NC_NOERR;
#line 1422
}
#line 1422

static int
#line 1423
ncx_get_float_long(const void *xp, long *ip)
#line 1423
{
#line 1423
	ix_float xx = 0;
#line 1423
	get_ix_float(xp, &xx);
#line 1423
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1423
#ifdef ERANGE_FILL
#line 1423
            *ip = NC_FILL_INT;
#line 1423
#endif
#line 1423
            return NC_ERANGE;
#line 1423
        }
#line 1423
	*ip = (long)xx;
#line 1423
	return NC_NOERR;
#line 1423
}
#line 1423

static int
#line 1424
ncx_get_float_double(const void *xp, double *ip)
#line 1424
{
#line 1424
	ix_float xx = 0;
#line 1424
	get_ix_float(xp, &xx);
#line 1424
	*ip = (double)xx;
#line 1424
	return NC_NOERR;
#line 1424
}
#line 1424

static int
#line 1425
ncx_get_float_longlong(const void *xp, longlong *ip)
#line 1425
{
#line 1425
	ix_float xx = 0;
#line 1425
	get_ix_float(xp, &xx);
#line 1425
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1425
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1425
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1425
#ifdef ERANGE_FILL
#line 1425
            *ip = NC_FILL_INT64;
#line 1425
#endif
#line 1425
            return NC_ERANGE;
#line 1425
        }
#line 1425
	else *ip = (longlong)xx;
#line 1425
	return NC_NOERR;
#line 1425
}
#line 1425

static int
#line 1426
ncx_get_float_uchar(const void *xp, uchar *ip)
#line 1426
{
#line 1426
	ix_float xx = 0;
#line 1426
	get_ix_float(xp, &xx);
#line 1426
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1426
#ifdef ERANGE_FILL
#line 1426
            *ip = NC_FILL_UBYTE;
#line 1426
#endif
#line 1426
            return NC_ERANGE;
#line 1426
        }
#line 1426
	*ip = (uchar)xx;
#line 1426
	return NC_NOERR;
#line 1426
}
#line 1426

static int
#line 1427
ncx_get_float_ushort(const void *xp, ushort *ip)
#line 1427
{
#line 1427
	ix_float xx = 0;
#line 1427
	get_ix_float(xp, &xx);
#line 1427
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1427
#ifdef ERANGE_FILL
#line 1427
            *ip = NC_FILL_USHORT;
#line 1427
#endif
#line 1427
            return NC_ERANGE;
#line 1427
        }
#line 1427
	*ip = (ushort)xx;
#line 1427
	return NC_NOERR;
#line 1427
}
#line 1427

static int
#line 1428
ncx_get_float_uint(const void *xp, uint *ip)
#line 1428
{
#line 1428
	ix_float xx = 0;
#line 1428
	get_ix_float(xp, &xx);
#line 1428
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1428
#ifdef ERANGE_FILL
#line 1428
            *ip = NC_FILL_UINT;
#line 1428
#endif
#line 1428
            return NC_ERANGE;
#line 1428
        }
#line 1428
	*ip = (uint)xx;
#line 1428
	return NC_NOERR;
#line 1428
}
#line 1428

static int
#line 1429
ncx_get_float_ulonglong(const void *xp, ulonglong *ip)
#line 1429
{
#line 1429
	ix_float xx = 0;
#line 1429
	get_ix_float(xp, &xx);
#line 1429
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1429
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1429
#ifdef ERANGE_FILL
#line 1429
            *ip = NC_FILL_UINT64;
#line 1429
#endif
#line 1429
            return NC_ERANGE;
#line 1429
        }
#line 1429
	else *ip = (ulonglong)xx;
#line 1429
	return NC_NOERR;
#line 1429
}
#line 1429


#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_put_float_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    float *_ip=ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    float tmp;
#endif
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
        
#line 1442
#ifdef ERANGE_FILL
#line 1442
            if (fillp != NULL) memcpy(&tmp, fillp, 4);
#line 1442
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_float(xp, _ip);
    return err;
}
#endif

static int
#line 1454
ncx_put_float_schar(void *xp, const schar *ip, void *fillp)
#line 1454
{
#line 1454
    int err=NC_NOERR;
#line 1454
    ix_float xx = NC_FILL_FLOAT;
#line 1454

#line 1454
    
#line 1454
        xx = (ix_float)*ip;
#line 1454

#line 1454
    put_ix_float(xp, &xx);
#line 1454
    return err;
#line 1454
}
#line 1454

static int
#line 1455
ncx_put_float_short(void *xp, const short *ip, void *fillp)
#line 1455
{
#line 1455
    int err=NC_NOERR;
#line 1455
    ix_float xx = NC_FILL_FLOAT;
#line 1455

#line 1455
    
#line 1455
        xx = (ix_float)*ip;
#line 1455

#line 1455
    put_ix_float(xp, &xx);
#line 1455
    return err;
#line 1455
}
#line 1455

static int
#line 1456
ncx_put_float_int(void *xp, const int *ip, void *fillp)
#line 1456
{
#line 1456
    int err=NC_NOERR;
#line 1456
    ix_float xx = NC_FILL_FLOAT;
#line 1456

#line 1456
    
#line 1456
        xx = (ix_float)*ip;
#line 1456

#line 1456
    put_ix_float(xp, &xx);
#line 1456
    return err;
#line 1456
}
#line 1456

static int
#line 1457
ncx_put_float_long(void *xp, const long *ip, void *fillp)
#line 1457
{
#line 1457
    int err=NC_NOERR;
#line 1457
    ix_float xx = NC_FILL_FLOAT;
#line 1457

#line 1457
    
#line 1457
        xx = (ix_float)*ip;
#line 1457

#line 1457
    put_ix_float(xp, &xx);
#line 1457
    return err;
#line 1457
}
#line 1457

static int
#line 1458
ncx_put_float_double(void *xp, const double *ip, void *fillp)
#line 1458
{
#line 1458
    int err=NC_NOERR;
#line 1458
    ix_float xx = NC_FILL_FLOAT;
#line 1458

#line 1458
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
#line 1458
        
#line 1458
#ifdef ERANGE_FILL
#line 1458
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1458
#endif
#line 1458
        err = NC_ERANGE;
#line 1458
    }
#line 1458
#ifdef ERANGE_FILL
#line 1458
    else
#line 1458
#endif
#line 1458
        xx = (ix_float)*ip;
#line 1458

#line 1458
    put_ix_float(xp, &xx);
#line 1458
    return err;
#line 1458
}
#line 1458

static int
#line 1459
ncx_put_float_longlong(void *xp, const longlong *ip, void *fillp)
#line 1459
{
#line 1459
    int err=NC_NOERR;
#line 1459
    ix_float xx = NC_FILL_FLOAT;
#line 1459

#line 1459
    
#line 1459
        xx = (ix_float)*ip;
#line 1459

#line 1459
    put_ix_float(xp, &xx);
#line 1459
    return err;
#line 1459
}
#line 1459

static int
#line 1460
ncx_put_float_uchar(void *xp, const uchar *ip, void *fillp)
#line 1460
{
#line 1460
    int err=NC_NOERR;
#line 1460
    ix_float xx = NC_FILL_FLOAT;
#line 1460

#line 1460
    
#line 1460
        xx = (ix_float)*ip;
#line 1460

#line 1460
    put_ix_float(xp, &xx);
#line 1460
    return err;
#line 1460
}
#line 1460

static int
#line 1461
ncx_put_float_ushort(void *xp, const ushort *ip, void *fillp)
#line 1461
{
#line 1461
    int err=NC_NOERR;
#line 1461
    ix_float xx = NC_FILL_FLOAT;
#line 1461

#line 1461
    
#line 1461
        xx = (ix_float)*ip;
#line 1461

#line 1461
    put_ix_float(xp, &xx);
#line 1461
    return err;
#line 1461
}
#line 1461

static int
#line 1462
ncx_put_float_uint(void *xp, const uint *ip, void *fillp)
#line 1462
{
#line 1462
    int err=NC_NOERR;
#line 1462
    ix_float xx = NC_FILL_FLOAT;
#line 1462

#line 1462
    
#line 1462
        xx = (ix_float)*ip;
#line 1462

#line 1462
    put_ix_float(xp, &xx);
#line 1462
    return err;
#line 1462
}
#line 1462

static int
#line 1463
ncx_put_float_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1463
{
#line 1463
    int err=NC_NOERR;
#line 1463
    ix_float xx = NC_FILL_FLOAT;
#line 1463

#line 1463
    
#line 1463
        xx = (ix_float)*ip;
#line 1463

#line 1463
    put_ix_float(xp, &xx);
#line 1463
    return err;
#line 1463
}
#line 1463



/* external NC_DOUBLE -------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE  && !defined(NO_IEEE_FLOAT)

static void
get_ix_double(const void *xp, double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_DOUBLE);
#else
	swap8b(ip, xp);
#endif
}

static void
put_ix_double(void *xp, const double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_DOUBLE);
#else
	swap8b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE double precision floating point looks like on a Vax */
struct	ieee_double {
	unsigned int	exp_hi   : 7;
	unsigned int	sign     : 1;
	unsigned int 	mant_6   : 4;
	unsigned int	exp_lo   : 4;
	unsigned int	mant_5   : 8;
	unsigned int	mant_4   : 8;

	unsigned int	mant_lo  : 32;
};

/* Vax double precision floating point */
struct  vax_double {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
	unsigned int	mantissa3 : 16;
	unsigned int	mantissa4 : 16;
};

#define VAX_DBL_BIAS	0x81
#define IEEE_DBL_BIAS	0x3ff
#define MASK(nbits)	((1 << nbits) - 1)

static const struct dbl_limits {
	struct	vax_double d;
	struct	ieee_double ieee;
} dbl_limits[2] = {
	{{ 0x7f, 0xff, 0x0, 0xffff, 0xffff, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0}}, /* Max IEEE */
	{{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},		/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}, /* Min IEEE */
};


#line 1577
static void
get_ix_double(const void *xp, double *ip)
{
	struct vax_double *const vdp =
#line 1580
			 (struct vax_double *)ip;
#line 1580
	const struct ieee_double *const idp =
#line 1580
			 (const struct ieee_double *) xp;
#line 1580
	{
#line 1580
		const struct dbl_limits *lim;
#line 1580
		int ii;
#line 1580
		for (ii = 0, lim = dbl_limits;
#line 1580
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 1580
			ii++, lim++)
#line 1580
		{
#line 1580
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 1580
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 1580
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 1580
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 1580
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 1580
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 1580
				)
#line 1580
			{
#line 1580
				*vdp = lim->d;
#line 1580
				goto doneit;
#line 1580
			}
#line 1580
		}
#line 1580
	}
#line 1580
	{
#line 1580
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 1580
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 1580
	}
#line 1580
	{
#line 1580
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 1580
				 | (idp->mant_5 << 8)
#line 1580
				 | idp->mant_4);
#line 1580
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 1580
		vdp->mantissa1 = (mant_hi >> 13);
#line 1580
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 1580
				| (mant_lo >> 29);
#line 1580
		vdp->mantissa3 = (mant_lo >> 13);
#line 1580
		vdp->mantissa4 = (mant_lo << 3);
#line 1580
	}
#line 1580
	doneit:
#line 1580
		vdp->sign = idp->sign;
#line 1580

}


#line 1650
static void
put_ix_double(void *xp, const double *ip)
{
	const struct vax_double *const vdp =
#line 1653
			(const struct vax_double *)ip;
#line 1653
	struct ieee_double *const idp =
#line 1653
			 (struct ieee_double *) xp;
#line 1653

#line 1653
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 1653
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 1653
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 1653
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 1653
		(vdp->exp == dbl_limits[0].d.exp))
#line 1653
	{
#line 1653
		*idp = dbl_limits[0].ieee;
#line 1653
		goto shipit;
#line 1653
	}
#line 1653
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 1653
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 1653
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 1653
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 1653
		(vdp->exp == dbl_limits[1].d.exp))
#line 1653
	{
#line 1653
		*idp = dbl_limits[1].ieee;
#line 1653
		goto shipit;
#line 1653
	}
#line 1653

#line 1653
	{
#line 1653
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 1653

#line 1653
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 1653
			(vdp->mantissa3 << 13) |
#line 1653
			((vdp->mantissa4 >> 3) & MASK(13));
#line 1653

#line 1653
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 1653
				 | (vdp->mantissa2 >> 3);
#line 1653

#line 1653
		if ((vdp->mantissa4 & 7) > 4)
#line 1653
		{
#line 1653
			/* round up */
#line 1653
			mant_lo++;
#line 1653
			if (mant_lo == 0)
#line 1653
			{
#line 1653
				mant_hi++;
#line 1653
				if (mant_hi > 0xffffff)
#line 1653
				{
#line 1653
					mant_hi = 0;
#line 1653
					exp++;
#line 1653
				}
#line 1653
			}
#line 1653
		}
#line 1653

#line 1653
		idp->mant_lo = SWAP4(mant_lo);
#line 1653
		idp->mant_6 = mant_hi >> 16;
#line 1653
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 1653
		idp->mant_4 = mant_hi;
#line 1653
		idp->exp_hi = exp >> 4;
#line 1653
		idp->exp_lo = exp;
#line 1653
	}
#line 1653

#line 1653
	shipit:
#line 1653
		idp->sign = vdp->sign;
#line 1653

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

static void
get_ix_double(const void *xp, double *ip)
{
	const ieee_double *idp = (const ieee_double *) xp;
	cray_single *csp = (cray_single *) ip;

	if (idp->exp == 0)
	{
		/* ieee subnormal */
		*ip = (double)idp->mant;
		if (idp->mant != 0)
		{
			csp->exp -= (ieee_double_bias + 51);
		}
	}
	else
	{
		csp->exp  = idp->exp + cs_id_bias + 1;
		csp->mant = idp->mant >> (52 - 48 + 1);
		csp->mant |= (1 << (48 - 1));
	}
	csp->sign = idp->sign;
}

static void
put_ix_double(void *xp, const double *ip)
{
	ieee_double *idp = (ieee_double *) xp;
	const cray_single *csp = (const cray_single *) ip;

	int ieee_exp = csp->exp - cs_id_bias -1;

	idp->sign = csp->sign;

	if (ieee_exp >= 0x7ff)
	{
		/* NC_ERANGE => ieee Inf */
		idp->exp = 0x7ff;
		idp->mant = 0x0;
	}
	else if (ieee_exp > 0)
	{
		/* normal ieee representation */
		idp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		idp->mant = (((csp->mant << 1) &
				0xffffffffffff) << (52 - 48));
	}
	else if (ieee_exp >= (-(52 -48)))
	{
		/* ieee subnormal, left shift */
		const int lshift = (52 - 48) + ieee_exp;
		idp->mant = csp->mant << lshift;
		idp->exp  = 0;
	}
	else if (ieee_exp >= -52)
	{
		/* ieee subnormal, right shift */
		const int rshift = (- (52 - 48) - ieee_exp);

		idp->mant = csp->mant >> rshift;

#if 0
		if (csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			idp->mant++;
		}
#endif

		idp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		idp->exp = 0;
		idp->mant = 0;
	}
}
#else
#error "ix_double implementation"
#endif

#define ix_double double

static int
#line 1745
ncx_get_double_schar(const void *xp, schar *ip)
#line 1745
{
#line 1745
	ix_double xx = 0;
#line 1745
	get_ix_double(xp, &xx);
#line 1745
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1745
#ifdef ERANGE_FILL
#line 1745
            *ip = NC_FILL_BYTE;
#line 1745
#endif
#line 1745
            return NC_ERANGE;
#line 1745
        }
#line 1745
	*ip = (schar)xx;
#line 1745
	return NC_NOERR;
#line 1745
}
#line 1745

static int
#line 1746
ncx_get_double_short(const void *xp, short *ip)
#line 1746
{
#line 1746
	ix_double xx = 0;
#line 1746
	get_ix_double(xp, &xx);
#line 1746
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1746
#ifdef ERANGE_FILL
#line 1746
            *ip = NC_FILL_SHORT;
#line 1746
#endif
#line 1746
            return NC_ERANGE;
#line 1746
        }
#line 1746
	*ip = (short)xx;
#line 1746
	return NC_NOERR;
#line 1746
}
#line 1746

static int
#line 1747
ncx_get_double_int(const void *xp, int *ip)
#line 1747
{
#line 1747
	ix_double xx = 0;
#line 1747
	get_ix_double(xp, &xx);
#line 1747
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1747
#ifdef ERANGE_FILL
#line 1747
            *ip = NC_FILL_INT;
#line 1747
#endif
#line 1747
            return NC_ERANGE;
#line 1747
        }
#line 1747
	*ip = (int)xx;
#line 1747
	return NC_NOERR;
#line 1747
}
#line 1747

static int
#line 1748
ncx_get_double_long(const void *xp, long *ip)
#line 1748
{
#line 1748
	ix_double xx = 0;
#line 1748
	get_ix_double(xp, &xx);
#line 1748
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1748
#ifdef ERANGE_FILL
#line 1748
            *ip = NC_FILL_INT;
#line 1748
#endif
#line 1748
            return NC_ERANGE;
#line 1748
        }
#line 1748
	*ip = (long)xx;
#line 1748
	return NC_NOERR;
#line 1748
}
#line 1748

static int
#line 1749
ncx_get_double_longlong(const void *xp, longlong *ip)
#line 1749
{
#line 1749
	ix_double xx = 0;
#line 1749
	get_ix_double(xp, &xx);
#line 1749
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1749
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1749
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1749
#ifdef ERANGE_FILL
#line 1749
            *ip = NC_FILL_INT64;
#line 1749
#endif
#line 1749
            return NC_ERANGE;
#line 1749
        }
#line 1749
	else *ip = (longlong)xx;
#line 1749
	return NC_NOERR;
#line 1749
}
#line 1749

static int
#line 1750
ncx_get_double_uchar(const void *xp, uchar *ip)
#line 1750
{
#line 1750
	ix_double xx = 0;
#line 1750
	get_ix_double(xp, &xx);
#line 1750
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1750
#ifdef ERANGE_FILL
#line 1750
            *ip = NC_FILL_UBYTE;
#line 1750
#endif
#line 1750
            return NC_ERANGE;
#line 1750
        }
#line 1750
	*ip = (uchar)xx;
#line 1750
	return NC_NOERR;
#line 1750
}
#line 1750

static int
#line 1751
ncx_get_double_ushort(const void *xp, ushort *ip)
#line 1751
{
#line 1751
	ix_double xx = 0;
#line 1751
	get_ix_double(xp, &xx);
#line 1751
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1751
#ifdef ERANGE_FILL
#line 1751
            *ip = NC_FILL_USHORT;
#line 1751
#endif
#line 1751
            return NC_ERANGE;
#line 1751
        }
#line 1751
	*ip = (ushort)xx;
#line 1751
	return NC_NOERR;
#line 1751
}
#line 1751

static int
#line 1752
ncx_get_double_uint(const void *xp, uint *ip)
#line 1752
{
#line 1752
	ix_double xx = 0;
#line 1752
	get_ix_double(xp, &xx);
#line 1752
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1752
#ifdef ERANGE_FILL
#line 1752
            *ip = NC_FILL_UINT;
#line 1752
#endif
#line 1752
            return NC_ERANGE;
#line 1752
        }
#line 1752
	*ip = (uint)xx;
#line 1752
	return NC_NOERR;
#line 1752
}
#line 1752

static int
#line 1753
ncx_get_double_ulonglong(const void *xp, ulonglong *ip)
#line 1753
{
#line 1753
	ix_double xx = 0;
#line 1753
	get_ix_double(xp, &xx);
#line 1753
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1753
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1753
#ifdef ERANGE_FILL
#line 1753
            *ip = NC_FILL_UINT64;
#line 1753
#endif
#line 1753
            return NC_ERANGE;
#line 1753
        }
#line 1753
	else *ip = (ulonglong)xx;
#line 1753
	return NC_NOERR;
#line 1753
}
#line 1753


static int
ncx_get_double_float(const void *xp, float *ip)
{
    double xx = 0.0;
    get_ix_double(xp, &xx);
    if (xx > FLT_MAX) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = FLT_MAX;
#endif
        return NC_ERANGE;
    }
    if (xx < (-FLT_MAX)) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = (-FLT_MAX);
#endif
        return NC_ERANGE;
    }
    *ip = (float) xx;
    return NC_NOERR;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_get_double_double(const void *xp, double *ip, void *fillp)
{
	/* TODO */
	get_ix_double(xp, ip);
	return NC_NOERR;
}
#endif

static int
#line 1790
ncx_put_double_schar(void *xp, const schar *ip, void *fillp)
#line 1790
{
#line 1790
    int err=NC_NOERR;
#line 1790
    ix_double xx = NC_FILL_DOUBLE;
#line 1790

#line 1790
    
#line 1790
        xx = (ix_double)*ip;
#line 1790

#line 1790
    put_ix_double(xp, &xx);
#line 1790
    return err;
#line 1790
}
#line 1790

static int
#line 1791
ncx_put_double_uchar(void *xp, const uchar *ip, void *fillp)
#line 1791
{
#line 1791
    int err=NC_NOERR;
#line 1791
    ix_double xx = NC_FILL_DOUBLE;
#line 1791

#line 1791
    
#line 1791
        xx = (ix_double)*ip;
#line 1791

#line 1791
    put_ix_double(xp, &xx);
#line 1791
    return err;
#line 1791
}
#line 1791

static int
#line 1792
ncx_put_double_short(void *xp, const short *ip, void *fillp)
#line 1792
{
#line 1792
    int err=NC_NOERR;
#line 1792
    ix_double xx = NC_FILL_DOUBLE;
#line 1792

#line 1792
    
#line 1792
        xx = (ix_double)*ip;
#line 1792

#line 1792
    put_ix_double(xp, &xx);
#line 1792
    return err;
#line 1792
}
#line 1792

static int
#line 1793
ncx_put_double_ushort(void *xp, const ushort *ip, void *fillp)
#line 1793
{
#line 1793
    int err=NC_NOERR;
#line 1793
    ix_double xx = NC_FILL_DOUBLE;
#line 1793

#line 1793
    
#line 1793
        xx = (ix_double)*ip;
#line 1793

#line 1793
    put_ix_double(xp, &xx);
#line 1793
    return err;
#line 1793
}
#line 1793

static int
#line 1794
ncx_put_double_int(void *xp, const int *ip, void *fillp)
#line 1794
{
#line 1794
    int err=NC_NOERR;
#line 1794
    ix_double xx = NC_FILL_DOUBLE;
#line 1794

#line 1794
    
#line 1794
        xx = (ix_double)*ip;
#line 1794

#line 1794
    put_ix_double(xp, &xx);
#line 1794
    return err;
#line 1794
}
#line 1794

static int
#line 1795
ncx_put_double_long(void *xp, const long *ip, void *fillp)
#line 1795
{
#line 1795
    int err=NC_NOERR;
#line 1795
    ix_double xx = NC_FILL_DOUBLE;
#line 1795

#line 1795
    
#line 1795
        xx = (ix_double)*ip;
#line 1795

#line 1795
    put_ix_double(xp, &xx);
#line 1795
    return err;
#line 1795
}
#line 1795

static int
#line 1796
ncx_put_double_uint(void *xp, const uint *ip, void *fillp)
#line 1796
{
#line 1796
    int err=NC_NOERR;
#line 1796
    ix_double xx = NC_FILL_DOUBLE;
#line 1796

#line 1796
    
#line 1796
        xx = (ix_double)*ip;
#line 1796

#line 1796
    put_ix_double(xp, &xx);
#line 1796
    return err;
#line 1796
}
#line 1796

static int
#line 1797
ncx_put_double_longlong(void *xp, const longlong *ip, void *fillp)
#line 1797
{
#line 1797
    int err=NC_NOERR;
#line 1797
    ix_double xx = NC_FILL_DOUBLE;
#line 1797

#line 1797
    
#line 1797
        xx = (ix_double)*ip;
#line 1797

#line 1797
    put_ix_double(xp, &xx);
#line 1797
    return err;
#line 1797
}
#line 1797

static int
#line 1798
ncx_put_double_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1798
{
#line 1798
    int err=NC_NOERR;
#line 1798
    ix_double xx = NC_FILL_DOUBLE;
#line 1798

#line 1798
    
#line 1798
        xx = (ix_double)*ip;
#line 1798

#line 1798
    put_ix_double(xp, &xx);
#line 1798
    return err;
#line 1798
}
#line 1798


static int
ncx_put_double_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    double xx = NC_FILL_DOUBLE;
#if 1	/* TODO: figure this out (if condition below will never be true)*/
    if ((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN) {
        
#line 1807
#ifdef ERANGE_FILL
#line 1807
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1807
#endif
        err = NC_ERANGE;
    }
#ifdef ERANGE_FILL
    else
#endif
#endif
        xx = (double) *ip;

    put_ix_double(xp, &xx);
    return err;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_put_double_double(void *xp, const double *ip, void *fillp)
{
    int err=NC_NOERR;
    double *_ip = ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    double tmp=NC_FILL_DOUBLE;
#endif
    if (*ip > X_DOUBLE_MAX || *ip < X_DOUBLE_MIN) {
        
#line 1831
#ifdef ERANGE_FILL
#line 1831
            if (fillp != NULL) memcpy(&tmp, fillp, 8);
#line 1831
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_double(xp, _ip);
    return err;
}
#endif


/* external NC_INT64 --------------------------------------------------------*/

#if SHORT_MAX == X_INT64_MAX
typedef short ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_SHORT
#define IX_INT64_MAX SHORT_MAX
#elif LONG_LONG_MAX  >= X_INT64_MAX
typedef longlong ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONGLONG
#define IX_INT64_MAX LONG_LONG_MAX
#elif LONG_MAX  >= X_INT64_MAX
typedef long ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONG
#define IX_INT64_MAX LONG_MAX
#else
#error "ix_int64 implementation"
#endif


static void
get_ix_int64(const void *xp, ix_int64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_int64)(*cp++) << 56);
    *ip |= ((ix_int64)(*cp++) << 48);
    *ip |= ((ix_int64)(*cp++) << 40);
    *ip |= ((ix_int64)(*cp++) << 32);
    *ip |= ((ix_int64)(*cp++) << 24);
    *ip |= ((ix_int64)(*cp++) << 16);
    *ip |= ((ix_int64)(*cp++) <<  8);
    *ip |=  (ix_int64)*cp;
}

static void
put_ix_int64(void *xp, const ix_int64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffLL);
}

#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 1894
ncx_get_longlong_longlong(const void *xp, longlong *ip)
#line 1894
{
#line 1894
    int err=NC_NOERR;
#line 1894
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 1894
    get_ix_int64(xp, (ix_int64 *)ip);
#line 1894
#else
#line 1894
    ix_int64 xx = 0;
#line 1894
    get_ix_int64(xp, &xx);
#line 1894

#line 1894
#if IX_INT64_MAX > LONGLONG_MAX
#line 1894
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 1894
#ifdef ERANGE_FILL
#line 1894
        *ip = NC_FILL_INT64;
#line 1894
        return NC_ERANGE;
#line 1894
#else
#line 1894
        err = NC_ERANGE;
#line 1894
#endif
#line 1894
    }
#line 1894
#endif
#line 1894

#line 1894

#line 1894
    *ip = (longlong) xx;
#line 1894
#endif
#line 1894
    return err;
#line 1894
}
#line 1894

#endif
static int
#line 1896
ncx_get_longlong_schar(const void *xp, schar *ip)
#line 1896
{
#line 1896
    int err=NC_NOERR;
#line 1896
    ix_int64 xx = 0;
#line 1896
    get_ix_int64(xp, &xx);
#line 1896

#line 1896
#if IX_INT64_MAX > SCHAR_MAX
#line 1896
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 1896
#ifdef ERANGE_FILL
#line 1896
        *ip = NC_FILL_BYTE;
#line 1896
        return NC_ERANGE;
#line 1896
#else
#line 1896
        err = NC_ERANGE;
#line 1896
#endif
#line 1896
    }
#line 1896
#endif
#line 1896

#line 1896

#line 1896
    *ip = (schar) xx;
#line 1896
    return err;
#line 1896
}
#line 1896

static int
#line 1897
ncx_get_longlong_short(const void *xp, short *ip)
#line 1897
{
#line 1897
    int err=NC_NOERR;
#line 1897
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 1897
    get_ix_int64(xp, (ix_int64 *)ip);
#line 1897
#else
#line 1897
    ix_int64 xx = 0;
#line 1897
    get_ix_int64(xp, &xx);
#line 1897

#line 1897
#if IX_INT64_MAX > SHORT_MAX
#line 1897
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 1897
#ifdef ERANGE_FILL
#line 1897
        *ip = NC_FILL_SHORT;
#line 1897
        return NC_ERANGE;
#line 1897
#else
#line 1897
        err = NC_ERANGE;
#line 1897
#endif
#line 1897
    }
#line 1897
#endif
#line 1897

#line 1897

#line 1897
    *ip = (short) xx;
#line 1897
#endif
#line 1897
    return err;
#line 1897
}
#line 1897

static int
#line 1898
ncx_get_longlong_int(const void *xp, int *ip)
#line 1898
{
#line 1898
    int err=NC_NOERR;
#line 1898
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 1898
    get_ix_int64(xp, (ix_int64 *)ip);
#line 1898
#else
#line 1898
    ix_int64 xx = 0;
#line 1898
    get_ix_int64(xp, &xx);
#line 1898

#line 1898
#if IX_INT64_MAX > INT_MAX
#line 1898
    if (xx > INT_MAX || xx < INT_MIN) {
#line 1898
#ifdef ERANGE_FILL
#line 1898
        *ip = NC_FILL_INT;
#line 1898
        return NC_ERANGE;
#line 1898
#else
#line 1898
        err = NC_ERANGE;
#line 1898
#endif
#line 1898
    }
#line 1898
#endif
#line 1898

#line 1898

#line 1898
    *ip = (int) xx;
#line 1898
#endif
#line 1898
    return err;
#line 1898
}
#line 1898

static int
#line 1899
ncx_get_longlong_long(const void *xp, long *ip)
#line 1899
{
#line 1899
    int err=NC_NOERR;
#line 1899
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 1899
    get_ix_int64(xp, (ix_int64 *)ip);
#line 1899
#else
#line 1899
    ix_int64 xx = 0;
#line 1899
    get_ix_int64(xp, &xx);
#line 1899

#line 1899
#if IX_INT64_MAX > LONG_MAX
#line 1899
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 1899
#ifdef ERANGE_FILL
#line 1899
        *ip = NC_FILL_INT;
#line 1899
        return NC_ERANGE;
#line 1899
#else
#line 1899
        err = NC_ERANGE;
#line 1899
#endif
#line 1899
    }
#line 1899
#endif
#line 1899

#line 1899

#line 1899
    *ip = (long) xx;
#line 1899
#endif
#line 1899
    return err;
#line 1899
}
#line 1899

static int
#line 1900
ncx_get_longlong_ushort(const void *xp, ushort *ip)
#line 1900
{
#line 1900
    int err=NC_NOERR;
#line 1900
    ix_int64 xx = 0;
#line 1900
    get_ix_int64(xp, &xx);
#line 1900

#line 1900
#if IX_INT64_MAX > USHORT_MAX
#line 1900
    if (xx > USHORT_MAX) {
#line 1900
#ifdef ERANGE_FILL
#line 1900
        *ip = NC_FILL_USHORT;
#line 1900
        return NC_ERANGE;
#line 1900
#else
#line 1900
        err = NC_ERANGE;
#line 1900
#endif
#line 1900
    }
#line 1900
#endif
#line 1900

#line 1900
    if (xx < 0) {
#line 1900
#ifdef ERANGE_FILL
#line 1900
        *ip = NC_FILL_USHORT;
#line 1900
        return NC_ERANGE;
#line 1900
#else
#line 1900
        err = NC_ERANGE; /* because ip is unsigned */
#line 1900
#endif
#line 1900
    }
#line 1900
    *ip = (ushort) xx;
#line 1900
    return err;
#line 1900
}
#line 1900

static int
#line 1901
ncx_get_longlong_uchar(const void *xp, uchar *ip)
#line 1901
{
#line 1901
    int err=NC_NOERR;
#line 1901
    ix_int64 xx = 0;
#line 1901
    get_ix_int64(xp, &xx);
#line 1901

#line 1901
#if IX_INT64_MAX > UCHAR_MAX
#line 1901
    if (xx > UCHAR_MAX) {
#line 1901
#ifdef ERANGE_FILL
#line 1901
        *ip = NC_FILL_UBYTE;
#line 1901
        return NC_ERANGE;
#line 1901
#else
#line 1901
        err = NC_ERANGE;
#line 1901
#endif
#line 1901
    }
#line 1901
#endif
#line 1901

#line 1901
    if (xx < 0) {
#line 1901
#ifdef ERANGE_FILL
#line 1901
        *ip = NC_FILL_UBYTE;
#line 1901
        return NC_ERANGE;
#line 1901
#else
#line 1901
        err = NC_ERANGE; /* because ip is unsigned */
#line 1901
#endif
#line 1901
    }
#line 1901
    *ip = (uchar) xx;
#line 1901
    return err;
#line 1901
}
#line 1901

static int
#line 1902
ncx_get_longlong_uint(const void *xp, uint *ip)
#line 1902
{
#line 1902
    int err=NC_NOERR;
#line 1902
    ix_int64 xx = 0;
#line 1902
    get_ix_int64(xp, &xx);
#line 1902

#line 1902
#if IX_INT64_MAX > UINT_MAX
#line 1902
    if (xx > UINT_MAX) {
#line 1902
#ifdef ERANGE_FILL
#line 1902
        *ip = NC_FILL_UINT;
#line 1902
        return NC_ERANGE;
#line 1902
#else
#line 1902
        err = NC_ERANGE;
#line 1902
#endif
#line 1902
    }
#line 1902
#endif
#line 1902

#line 1902
    if (xx < 0) {
#line 1902
#ifdef ERANGE_FILL
#line 1902
        *ip = NC_FILL_UINT;
#line 1902
        return NC_ERANGE;
#line 1902
#else
#line 1902
        err = NC_ERANGE; /* because ip is unsigned */
#line 1902
#endif
#line 1902
    }
#line 1902
    *ip = (uint) xx;
#line 1902
    return err;
#line 1902
}
#line 1902

static int
#line 1903
ncx_get_longlong_ulonglong(const void *xp, ulonglong *ip)
#line 1903
{
#line 1903
    int err=NC_NOERR;
#line 1903
    ix_int64 xx = 0;
#line 1903
    get_ix_int64(xp, &xx);
#line 1903

#line 1903
#if IX_INT64_MAX > ULONGLONG_MAX
#line 1903
    if (xx > ULONGLONG_MAX) {
#line 1903
#ifdef ERANGE_FILL
#line 1903
        *ip = NC_FILL_UINT64;
#line 1903
        return NC_ERANGE;
#line 1903
#else
#line 1903
        err = NC_ERANGE;
#line 1903
#endif
#line 1903
    }
#line 1903
#endif
#line 1903

#line 1903
    if (xx < 0) {
#line 1903
#ifdef ERANGE_FILL
#line 1903
        *ip = NC_FILL_UINT64;
#line 1903
        return NC_ERANGE;
#line 1903
#else
#line 1903
        err = NC_ERANGE; /* because ip is unsigned */
#line 1903
#endif
#line 1903
    }
#line 1903
    *ip = (ulonglong) xx;
#line 1903
    return err;
#line 1903
}
#line 1903

static int
#line 1904
ncx_get_longlong_float(const void *xp, float *ip)
#line 1904
{
#line 1904
	ix_int64 xx = 0;
#line 1904
	get_ix_int64(xp, &xx);
#line 1904
	*ip = (float)xx;
#line 1904
	return NC_NOERR;
#line 1904
}
#line 1904

static int
#line 1905
ncx_get_longlong_double(const void *xp, double *ip)
#line 1905
{
#line 1905
	ix_int64 xx = 0;
#line 1905
	get_ix_int64(xp, &xx);
#line 1905
	*ip = (double)xx;
#line 1905
	return NC_NOERR;
#line 1905
}
#line 1905


#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 1908
ncx_put_longlong_longlong(void *xp, const longlong *ip, void *fillp)
#line 1908
{
#line 1908
    int err=NC_NOERR;
#line 1908
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 1908
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 1908
#else
#line 1908
    ix_int64 xx = NC_FILL_INT64;
#line 1908

#line 1908
#if IX_INT64_MAX < LONGLONG_MAX
#line 1908
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 1908
        
#line 1908
#ifdef ERANGE_FILL
#line 1908
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1908
#endif
#line 1908
        err = NC_ERANGE;
#line 1908
    }
#line 1908
#ifdef ERANGE_FILL
#line 1908
    else
#line 1908
#endif
#line 1908
#endif
#line 1908
        xx = (ix_int64)*ip;
#line 1908

#line 1908
    put_ix_int64(xp, &xx);
#line 1908
#endif
#line 1908
    return err;
#line 1908
}
#line 1908

#endif
static int
#line 1910
ncx_put_longlong_schar(void *xp, const schar *ip, void *fillp)
#line 1910
{
#line 1910
    int err=NC_NOERR;
#line 1910
    ix_int64 xx = NC_FILL_INT64;
#line 1910

#line 1910
#if IX_INT64_MAX < SCHAR_MAX
#line 1910
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 1910
        
#line 1910
#ifdef ERANGE_FILL
#line 1910
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1910
#endif
#line 1910
        err = NC_ERANGE;
#line 1910
    }
#line 1910
#ifdef ERANGE_FILL
#line 1910
    else
#line 1910
#endif
#line 1910
#endif
#line 1910
        xx = (ix_int64)*ip;
#line 1910

#line 1910
    put_ix_int64(xp, &xx);
#line 1910
    return err;
#line 1910
}
#line 1910

static int
#line 1911
ncx_put_longlong_short(void *xp, const short *ip, void *fillp)
#line 1911
{
#line 1911
    int err=NC_NOERR;
#line 1911
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 1911
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 1911
#else
#line 1911
    ix_int64 xx = NC_FILL_INT64;
#line 1911

#line 1911
#if IX_INT64_MAX < SHORT_MAX
#line 1911
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 1911
        
#line 1911
#ifdef ERANGE_FILL
#line 1911
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1911
#endif
#line 1911
        err = NC_ERANGE;
#line 1911
    }
#line 1911
#ifdef ERANGE_FILL
#line 1911
    else
#line 1911
#endif
#line 1911
#endif
#line 1911
        xx = (ix_int64)*ip;
#line 1911

#line 1911
    put_ix_int64(xp, &xx);
#line 1911
#endif
#line 1911
    return err;
#line 1911
}
#line 1911

static int
#line 1912
ncx_put_longlong_int(void *xp, const int *ip, void *fillp)
#line 1912
{
#line 1912
    int err=NC_NOERR;
#line 1912
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 1912
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 1912
#else
#line 1912
    ix_int64 xx = NC_FILL_INT64;
#line 1912

#line 1912
#if IX_INT64_MAX < INT_MAX
#line 1912
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 1912
        
#line 1912
#ifdef ERANGE_FILL
#line 1912
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1912
#endif
#line 1912
        err = NC_ERANGE;
#line 1912
    }
#line 1912
#ifdef ERANGE_FILL
#line 1912
    else
#line 1912
#endif
#line 1912
#endif
#line 1912
        xx = (ix_int64)*ip;
#line 1912

#line 1912
    put_ix_int64(xp, &xx);
#line 1912
#endif
#line 1912
    return err;
#line 1912
}
#line 1912

static int
#line 1913
ncx_put_longlong_long(void *xp, const long *ip, void *fillp)
#line 1913
{
#line 1913
    int err=NC_NOERR;
#line 1913
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 1913
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 1913
#else
#line 1913
    ix_int64 xx = NC_FILL_INT64;
#line 1913

#line 1913
#if IX_INT64_MAX < LONG_MAX
#line 1913
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 1913
        
#line 1913
#ifdef ERANGE_FILL
#line 1913
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1913
#endif
#line 1913
        err = NC_ERANGE;
#line 1913
    }
#line 1913
#ifdef ERANGE_FILL
#line 1913
    else
#line 1913
#endif
#line 1913
#endif
#line 1913
        xx = (ix_int64)*ip;
#line 1913

#line 1913
    put_ix_int64(xp, &xx);
#line 1913
#endif
#line 1913
    return err;
#line 1913
}
#line 1913

static int
#line 1914
ncx_put_longlong_ushort(void *xp, const ushort *ip, void *fillp)
#line 1914
{
#line 1914
    int err=NC_NOERR;
#line 1914
    ix_int64 xx = NC_FILL_INT64;
#line 1914

#line 1914
#if IX_INT64_MAX < USHORT_MAX
#line 1914
    if (*ip > IX_INT64_MAX) {
#line 1914
        
#line 1914
#ifdef ERANGE_FILL
#line 1914
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1914
#endif
#line 1914
        err = NC_ERANGE;
#line 1914
    }
#line 1914
#ifdef ERANGE_FILL
#line 1914
    else
#line 1914
#endif
#line 1914
#endif
#line 1914
        xx = (ix_int64)*ip;
#line 1914

#line 1914
    put_ix_int64(xp, &xx);
#line 1914
    return err;
#line 1914
}
#line 1914

static int
#line 1915
ncx_put_longlong_uchar(void *xp, const uchar *ip, void *fillp)
#line 1915
{
#line 1915
    int err=NC_NOERR;
#line 1915
    ix_int64 xx = NC_FILL_INT64;
#line 1915

#line 1915
#if IX_INT64_MAX < UCHAR_MAX
#line 1915
    if (*ip > IX_INT64_MAX) {
#line 1915
        
#line 1915
#ifdef ERANGE_FILL
#line 1915
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1915
#endif
#line 1915
        err = NC_ERANGE;
#line 1915
    }
#line 1915
#ifdef ERANGE_FILL
#line 1915
    else
#line 1915
#endif
#line 1915
#endif
#line 1915
        xx = (ix_int64)*ip;
#line 1915

#line 1915
    put_ix_int64(xp, &xx);
#line 1915
    return err;
#line 1915
}
#line 1915

static int
#line 1916
ncx_put_longlong_uint(void *xp, const uint *ip, void *fillp)
#line 1916
{
#line 1916
    int err=NC_NOERR;
#line 1916
    ix_int64 xx = NC_FILL_INT64;
#line 1916

#line 1916
#if IX_INT64_MAX < UINT_MAX
#line 1916
    if (*ip > IX_INT64_MAX) {
#line 1916
        
#line 1916
#ifdef ERANGE_FILL
#line 1916
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1916
#endif
#line 1916
        err = NC_ERANGE;
#line 1916
    }
#line 1916
#ifdef ERANGE_FILL
#line 1916
    else
#line 1916
#endif
#line 1916
#endif
#line 1916
        xx = (ix_int64)*ip;
#line 1916

#line 1916
    put_ix_int64(xp, &xx);
#line 1916
    return err;
#line 1916
}
#line 1916

static int
#line 1917
ncx_put_longlong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1917
{
#line 1917
    int err=NC_NOERR;
#line 1917
    ix_int64 xx = NC_FILL_INT64;
#line 1917

#line 1917
#if IX_INT64_MAX < ULONGLONG_MAX
#line 1917
    if (*ip > IX_INT64_MAX) {
#line 1917
        
#line 1917
#ifdef ERANGE_FILL
#line 1917
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1917
#endif
#line 1917
        err = NC_ERANGE;
#line 1917
    }
#line 1917
#ifdef ERANGE_FILL
#line 1917
    else
#line 1917
#endif
#line 1917
#endif
#line 1917
        xx = (ix_int64)*ip;
#line 1917

#line 1917
    put_ix_int64(xp, &xx);
#line 1917
    return err;
#line 1917
}
#line 1917

static int
#line 1918
ncx_put_longlong_float(void *xp, const float *ip, void *fillp)
#line 1918
{
#line 1918
    int err=NC_NOERR;
#line 1918
    ix_int64 xx = NC_FILL_INT64;
#line 1918

#line 1918
    if (*ip > (double)X_INT64_MAX || *ip < (double)X_INT64_MIN) {
#line 1918
        
#line 1918
#ifdef ERANGE_FILL
#line 1918
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1918
#endif
#line 1918
        err = NC_ERANGE;
#line 1918
    }
#line 1918
#ifdef ERANGE_FILL
#line 1918
    else
#line 1918
#endif
#line 1918
        xx = (ix_int64)*ip;
#line 1918

#line 1918
    put_ix_int64(xp, &xx);
#line 1918
    return err;
#line 1918
}
#line 1918

static int
#line 1919
ncx_put_longlong_double(void *xp, const double *ip, void *fillp)
#line 1919
{
#line 1919
    int err=NC_NOERR;
#line 1919
    ix_int64 xx = NC_FILL_INT64;
#line 1919

#line 1919
    if (*ip > X_INT64_MAX || *ip < X_INT64_MIN) {
#line 1919
        
#line 1919
#ifdef ERANGE_FILL
#line 1919
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1919
#endif
#line 1919
        err = NC_ERANGE;
#line 1919
    }
#line 1919
#ifdef ERANGE_FILL
#line 1919
    else
#line 1919
#endif
#line 1919
        xx = (ix_int64)*ip;
#line 1919

#line 1919
    put_ix_int64(xp, &xx);
#line 1919
    return err;
#line 1919
}
#line 1919



/* external NC_UINT64 -------------------------------------------------------*/

#if USHORT_MAX == X_UINT64_MAX
typedef ushort ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_USHORT
#define IX_UINT64_MAX USHORT_MAX
#elif ULONG_LONG_MAX  >= X_UINT64_MAX
typedef ulonglong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONGLONG
#define IX_UINT64_MAX ULONG_LONG_MAX
#elif ULONG_MAX  >= X_UINT64_MAX
typedef ulong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONG
#define IX_UINT64_MAX ULONG_MAX
#else
#error "ix_uint64 implementation"
#endif


static void
get_ix_uint64(const void *xp, ix_uint64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_uint64)(*cp++) << 56);
    *ip |= ((ix_uint64)(*cp++) << 48);
    *ip |= ((ix_uint64)(*cp++) << 40);
    *ip |= ((ix_uint64)(*cp++) << 32);
    *ip |= ((ix_uint64)(*cp++) << 24);
    *ip |= ((ix_uint64)(*cp++) << 16);
    *ip |= ((ix_uint64)(*cp++) <<  8);
    *ip |=  (ix_uint64)*cp;
}

static void
put_ix_uint64(void *xp, const ix_uint64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000ULL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000ULL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000ULL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000ULL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000ULL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00ULL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffULL);
}

#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 1972
ncx_get_ulonglong_ulonglong(const void *xp, ulonglong *ip)
#line 1972
{
#line 1972
    int err=NC_NOERR;
#line 1972
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 1972
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 1972
#else
#line 1972
    ix_uint64 xx = 0;
#line 1972
    get_ix_uint64(xp, &xx);
#line 1972

#line 1972
#if IX_UINT64_MAX > ULONGLONG_MAX
#line 1972
    if (xx > ULONGLONG_MAX) {
#line 1972
#ifdef ERANGE_FILL
#line 1972
        *ip = NC_FILL_UINT64;
#line 1972
        return NC_ERANGE;
#line 1972
#else
#line 1972
        err = NC_ERANGE;
#line 1972
#endif
#line 1972
    }
#line 1972
#endif
#line 1972

#line 1972

#line 1972
    *ip = (ulonglong) xx;
#line 1972
#endif
#line 1972
    return err;
#line 1972
}
#line 1972

#endif
static int
#line 1974
ncx_get_ulonglong_schar(const void *xp, schar *ip)
#line 1974
{
#line 1974
    int err=NC_NOERR;
#line 1974
    ix_uint64 xx = 0;
#line 1974
    get_ix_uint64(xp, &xx);
#line 1974

#line 1974
#if IX_UINT64_MAX > SCHAR_MAX
#line 1974
    if (xx > SCHAR_MAX) {
#line 1974
#ifdef ERANGE_FILL
#line 1974
        *ip = NC_FILL_BYTE;
#line 1974
        return NC_ERANGE;
#line 1974
#else
#line 1974
        err = NC_ERANGE;
#line 1974
#endif
#line 1974
    }
#line 1974
#endif
#line 1974

#line 1974

#line 1974
    *ip = (schar) xx;
#line 1974
    return err;
#line 1974
}
#line 1974

static int
#line 1975
ncx_get_ulonglong_short(const void *xp, short *ip)
#line 1975
{
#line 1975
    int err=NC_NOERR;
#line 1975
    ix_uint64 xx = 0;
#line 1975
    get_ix_uint64(xp, &xx);
#line 1975

#line 1975
#if IX_UINT64_MAX > SHORT_MAX
#line 1975
    if (xx > SHORT_MAX) {
#line 1975
#ifdef ERANGE_FILL
#line 1975
        *ip = NC_FILL_SHORT;
#line 1975
        return NC_ERANGE;
#line 1975
#else
#line 1975
        err = NC_ERANGE;
#line 1975
#endif
#line 1975
    }
#line 1975
#endif
#line 1975

#line 1975

#line 1975
    *ip = (short) xx;
#line 1975
    return err;
#line 1975
}
#line 1975

static int
#line 1976
ncx_get_ulonglong_int(const void *xp, int *ip)
#line 1976
{
#line 1976
    int err=NC_NOERR;
#line 1976
    ix_uint64 xx = 0;
#line 1976
    get_ix_uint64(xp, &xx);
#line 1976

#line 1976
#if IX_UINT64_MAX > INT_MAX
#line 1976
    if (xx > INT_MAX) {
#line 1976
#ifdef ERANGE_FILL
#line 1976
        *ip = NC_FILL_INT;
#line 1976
        return NC_ERANGE;
#line 1976
#else
#line 1976
        err = NC_ERANGE;
#line 1976
#endif
#line 1976
    }
#line 1976
#endif
#line 1976

#line 1976

#line 1976
    *ip = (int) xx;
#line 1976
    return err;
#line 1976
}
#line 1976

static int
#line 1977
ncx_get_ulonglong_long(const void *xp, long *ip)
#line 1977
{
#line 1977
    int err=NC_NOERR;
#line 1977
    ix_uint64 xx = 0;
#line 1977
    get_ix_uint64(xp, &xx);
#line 1977

#line 1977
#if IX_UINT64_MAX > LONG_MAX
#line 1977
    if (xx > LONG_MAX) {
#line 1977
#ifdef ERANGE_FILL
#line 1977
        *ip = NC_FILL_INT;
#line 1977
        return NC_ERANGE;
#line 1977
#else
#line 1977
        err = NC_ERANGE;
#line 1977
#endif
#line 1977
    }
#line 1977
#endif
#line 1977

#line 1977

#line 1977
    *ip = (long) xx;
#line 1977
    return err;
#line 1977
}
#line 1977

static int
#line 1978
ncx_get_ulonglong_longlong(const void *xp, longlong *ip)
#line 1978
{
#line 1978
    int err=NC_NOERR;
#line 1978
    ix_uint64 xx = 0;
#line 1978
    get_ix_uint64(xp, &xx);
#line 1978

#line 1978
#if IX_UINT64_MAX > LONGLONG_MAX
#line 1978
    if (xx > LONGLONG_MAX) {
#line 1978
#ifdef ERANGE_FILL
#line 1978
        *ip = NC_FILL_INT64;
#line 1978
        return NC_ERANGE;
#line 1978
#else
#line 1978
        err = NC_ERANGE;
#line 1978
#endif
#line 1978
    }
#line 1978
#endif
#line 1978

#line 1978

#line 1978
    *ip = (longlong) xx;
#line 1978
    return err;
#line 1978
}
#line 1978

static int
#line 1979
ncx_get_ulonglong_ushort(const void *xp, ushort *ip)
#line 1979
{
#line 1979
    int err=NC_NOERR;
#line 1979
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 1979
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 1979
#else
#line 1979
    ix_uint64 xx = 0;
#line 1979
    get_ix_uint64(xp, &xx);
#line 1979

#line 1979
#if IX_UINT64_MAX > USHORT_MAX
#line 1979
    if (xx > USHORT_MAX) {
#line 1979
#ifdef ERANGE_FILL
#line 1979
        *ip = NC_FILL_USHORT;
#line 1979
        return NC_ERANGE;
#line 1979
#else
#line 1979
        err = NC_ERANGE;
#line 1979
#endif
#line 1979
    }
#line 1979
#endif
#line 1979

#line 1979

#line 1979
    *ip = (ushort) xx;
#line 1979
#endif
#line 1979
    return err;
#line 1979
}
#line 1979

static int
#line 1980
ncx_get_ulonglong_uchar(const void *xp, uchar *ip)
#line 1980
{
#line 1980
    int err=NC_NOERR;
#line 1980
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 1980
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 1980
#else
#line 1980
    ix_uint64 xx = 0;
#line 1980
    get_ix_uint64(xp, &xx);
#line 1980

#line 1980
#if IX_UINT64_MAX > UCHAR_MAX
#line 1980
    if (xx > UCHAR_MAX) {
#line 1980
#ifdef ERANGE_FILL
#line 1980
        *ip = NC_FILL_UBYTE;
#line 1980
        return NC_ERANGE;
#line 1980
#else
#line 1980
        err = NC_ERANGE;
#line 1980
#endif
#line 1980
    }
#line 1980
#endif
#line 1980

#line 1980

#line 1980
    *ip = (uchar) xx;
#line 1980
#endif
#line 1980
    return err;
#line 1980
}
#line 1980

static int
#line 1981
ncx_get_ulonglong_uint(const void *xp, uint *ip)
#line 1981
{
#line 1981
    int err=NC_NOERR;
#line 1981
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 1981
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 1981
#else
#line 1981
    ix_uint64 xx = 0;
#line 1981
    get_ix_uint64(xp, &xx);
#line 1981

#line 1981
#if IX_UINT64_MAX > UINT_MAX
#line 1981
    if (xx > UINT_MAX) {
#line 1981
#ifdef ERANGE_FILL
#line 1981
        *ip = NC_FILL_UINT;
#line 1981
        return NC_ERANGE;
#line 1981
#else
#line 1981
        err = NC_ERANGE;
#line 1981
#endif
#line 1981
    }
#line 1981
#endif
#line 1981

#line 1981

#line 1981
    *ip = (uint) xx;
#line 1981
#endif
#line 1981
    return err;
#line 1981
}
#line 1981

static int
#line 1982
ncx_get_ulonglong_float(const void *xp, float *ip)
#line 1982
{
#line 1982
	ix_uint64 xx = 0;
#line 1982
	get_ix_uint64(xp, &xx);
#line 1982
	*ip = (float)xx;
#line 1982
	return NC_NOERR;
#line 1982
}
#line 1982

static int
#line 1983
ncx_get_ulonglong_double(const void *xp, double *ip)
#line 1983
{
#line 1983
	ix_uint64 xx = 0;
#line 1983
	get_ix_uint64(xp, &xx);
#line 1983
	*ip = (double)xx;
#line 1983
	return NC_NOERR;
#line 1983
}
#line 1983


#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 1986
ncx_put_ulonglong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1986
{
#line 1986
    int err=NC_NOERR;
#line 1986
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 1986
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 1986
#else
#line 1986
    ix_uint64 xx = NC_FILL_UINT64;
#line 1986

#line 1986
#if IX_UINT64_MAX < ULONGLONG_MAX
#line 1986
    if (*ip > IX_UINT64_MAX) {
#line 1986
        
#line 1986
#ifdef ERANGE_FILL
#line 1986
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1986
#endif
#line 1986
        err = NC_ERANGE;
#line 1986
    }
#line 1986
#ifdef ERANGE_FILL
#line 1986
    else
#line 1986
#endif
#line 1986
#endif
#line 1986
        xx = (ix_uint64)*ip;
#line 1986

#line 1986
    put_ix_uint64(xp, &xx);
#line 1986
#endif
#line 1986
    return err;
#line 1986
}
#line 1986

#endif
static int
#line 1988
ncx_put_ulonglong_schar(void *xp, const schar *ip, void *fillp)
#line 1988
{
#line 1988
    int err=NC_NOERR;
#line 1988
    ix_uint64 xx = NC_FILL_UINT64;
#line 1988

#line 1988
#if IX_UINT64_MAX < SCHAR_MAX
#line 1988
    if (*ip > IX_UINT64_MAX) {
#line 1988
        
#line 1988
#ifdef ERANGE_FILL
#line 1988
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1988
#endif
#line 1988
        err = NC_ERANGE;
#line 1988
    }
#line 1988
#ifdef ERANGE_FILL
#line 1988
    else
#line 1988
#endif
#line 1988
#endif
#line 1988
    if (*ip < 0) {
#line 1988
        
#line 1988
#ifdef ERANGE_FILL
#line 1988
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1988
#endif
#line 1988
        err = NC_ERANGE; /* because xp is unsigned */
#line 1988
    }
#line 1988
#ifdef ERANGE_FILL
#line 1988
    else
#line 1988
#endif
#line 1988
        xx = (ix_uint64)*ip;
#line 1988

#line 1988
    put_ix_uint64(xp, &xx);
#line 1988
    return err;
#line 1988
}
#line 1988

static int
#line 1989
ncx_put_ulonglong_short(void *xp, const short *ip, void *fillp)
#line 1989
{
#line 1989
    int err=NC_NOERR;
#line 1989
    ix_uint64 xx = NC_FILL_UINT64;
#line 1989

#line 1989
#if IX_UINT64_MAX < SHORT_MAX
#line 1989
    if (*ip > IX_UINT64_MAX) {
#line 1989
        
#line 1989
#ifdef ERANGE_FILL
#line 1989
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1989
#endif
#line 1989
        err = NC_ERANGE;
#line 1989
    }
#line 1989
#ifdef ERANGE_FILL
#line 1989
    else
#line 1989
#endif
#line 1989
#endif
#line 1989
    if (*ip < 0) {
#line 1989
        
#line 1989
#ifdef ERANGE_FILL
#line 1989
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1989
#endif
#line 1989
        err = NC_ERANGE; /* because xp is unsigned */
#line 1989
    }
#line 1989
#ifdef ERANGE_FILL
#line 1989
    else
#line 1989
#endif
#line 1989
        xx = (ix_uint64)*ip;
#line 1989

#line 1989
    put_ix_uint64(xp, &xx);
#line 1989
    return err;
#line 1989
}
#line 1989

static int
#line 1990
ncx_put_ulonglong_int(void *xp, const int *ip, void *fillp)
#line 1990
{
#line 1990
    int err=NC_NOERR;
#line 1990
    ix_uint64 xx = NC_FILL_UINT64;
#line 1990

#line 1990
#if IX_UINT64_MAX < INT_MAX
#line 1990
    if (*ip > IX_UINT64_MAX) {
#line 1990
        
#line 1990
#ifdef ERANGE_FILL
#line 1990
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1990
#endif
#line 1990
        err = NC_ERANGE;
#line 1990
    }
#line 1990
#ifdef ERANGE_FILL
#line 1990
    else
#line 1990
#endif
#line 1990
#endif
#line 1990
    if (*ip < 0) {
#line 1990
        
#line 1990
#ifdef ERANGE_FILL
#line 1990
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1990
#endif
#line 1990
        err = NC_ERANGE; /* because xp is unsigned */
#line 1990
    }
#line 1990
#ifdef ERANGE_FILL
#line 1990
    else
#line 1990
#endif
#line 1990
        xx = (ix_uint64)*ip;
#line 1990

#line 1990
    put_ix_uint64(xp, &xx);
#line 1990
    return err;
#line 1990
}
#line 1990

static int
#line 1991
ncx_put_ulonglong_long(void *xp, const long *ip, void *fillp)
#line 1991
{
#line 1991
    int err=NC_NOERR;
#line 1991
    ix_uint64 xx = NC_FILL_UINT64;
#line 1991

#line 1991
#if IX_UINT64_MAX < LONG_MAX
#line 1991
    if (*ip > IX_UINT64_MAX) {
#line 1991
        
#line 1991
#ifdef ERANGE_FILL
#line 1991
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1991
#endif
#line 1991
        err = NC_ERANGE;
#line 1991
    }
#line 1991
#ifdef ERANGE_FILL
#line 1991
    else
#line 1991
#endif
#line 1991
#endif
#line 1991
    if (*ip < 0) {
#line 1991
        
#line 1991
#ifdef ERANGE_FILL
#line 1991
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1991
#endif
#line 1991
        err = NC_ERANGE; /* because xp is unsigned */
#line 1991
    }
#line 1991
#ifdef ERANGE_FILL
#line 1991
    else
#line 1991
#endif
#line 1991
        xx = (ix_uint64)*ip;
#line 1991

#line 1991
    put_ix_uint64(xp, &xx);
#line 1991
    return err;
#line 1991
}
#line 1991

static int
#line 1992
ncx_put_ulonglong_longlong(void *xp, const longlong *ip, void *fillp)
#line 1992
{
#line 1992
    int err=NC_NOERR;
#line 1992
    ix_uint64 xx = NC_FILL_UINT64;
#line 1992

#line 1992
#if IX_UINT64_MAX < LONGLONG_MAX
#line 1992
    if (*ip > IX_UINT64_MAX) {
#line 1992
        
#line 1992
#ifdef ERANGE_FILL
#line 1992
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1992
#endif
#line 1992
        err = NC_ERANGE;
#line 1992
    }
#line 1992
#ifdef ERANGE_FILL
#line 1992
    else
#line 1992
#endif
#line 1992
#endif
#line 1992
    if (*ip < 0) {
#line 1992
        
#line 1992
#ifdef ERANGE_FILL
#line 1992
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1992
#endif
#line 1992
        err = NC_ERANGE; /* because xp is unsigned */
#line 1992
    }
#line 1992
#ifdef ERANGE_FILL
#line 1992
    else
#line 1992
#endif
#line 1992
        xx = (ix_uint64)*ip;
#line 1992

#line 1992
    put_ix_uint64(xp, &xx);
#line 1992
    return err;
#line 1992
}
#line 1992

static int
#line 1993
ncx_put_ulonglong_uchar(void *xp, const uchar *ip, void *fillp)
#line 1993
{
#line 1993
    int err=NC_NOERR;
#line 1993
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 1993
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 1993
#else
#line 1993
    ix_uint64 xx = NC_FILL_UINT64;
#line 1993

#line 1993
#if IX_UINT64_MAX < UCHAR_MAX
#line 1993
    if (*ip > IX_UINT64_MAX) {
#line 1993
        
#line 1993
#ifdef ERANGE_FILL
#line 1993
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1993
#endif
#line 1993
        err = NC_ERANGE;
#line 1993
    }
#line 1993
#ifdef ERANGE_FILL
#line 1993
    else
#line 1993
#endif
#line 1993
#endif
#line 1993
        xx = (ix_uint64)*ip;
#line 1993

#line 1993
    put_ix_uint64(xp, &xx);
#line 1993
#endif
#line 1993
    return err;
#line 1993
}
#line 1993

static int
#line 1994
ncx_put_ulonglong_ushort(void *xp, const ushort *ip, void *fillp)
#line 1994
{
#line 1994
    int err=NC_NOERR;
#line 1994
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 1994
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 1994
#else
#line 1994
    ix_uint64 xx = NC_FILL_UINT64;
#line 1994

#line 1994
#if IX_UINT64_MAX < USHORT_MAX
#line 1994
    if (*ip > IX_UINT64_MAX) {
#line 1994
        
#line 1994
#ifdef ERANGE_FILL
#line 1994
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1994
#endif
#line 1994
        err = NC_ERANGE;
#line 1994
    }
#line 1994
#ifdef ERANGE_FILL
#line 1994
    else
#line 1994
#endif
#line 1994
#endif
#line 1994
        xx = (ix_uint64)*ip;
#line 1994

#line 1994
    put_ix_uint64(xp, &xx);
#line 1994
#endif
#line 1994
    return err;
#line 1994
}
#line 1994

static int
#line 1995
ncx_put_ulonglong_uint(void *xp, const uint *ip, void *fillp)
#line 1995
{
#line 1995
    int err=NC_NOERR;
#line 1995
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 1995
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 1995
#else
#line 1995
    ix_uint64 xx = NC_FILL_UINT64;
#line 1995

#line 1995
#if IX_UINT64_MAX < UINT_MAX
#line 1995
    if (*ip > IX_UINT64_MAX) {
#line 1995
        
#line 1995
#ifdef ERANGE_FILL
#line 1995
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1995
#endif
#line 1995
        err = NC_ERANGE;
#line 1995
    }
#line 1995
#ifdef ERANGE_FILL
#line 1995
    else
#line 1995
#endif
#line 1995
#endif
#line 1995
        xx = (ix_uint64)*ip;
#line 1995

#line 1995
    put_ix_uint64(xp, &xx);
#line 1995
#endif
#line 1995
    return err;
#line 1995
}
#line 1995

static int
#line 1996
ncx_put_ulonglong_float(void *xp, const float *ip, void *fillp)
#line 1996
{
#line 1996
    int err=NC_NOERR;
#line 1996
    ix_uint64 xx = NC_FILL_UINT64;
#line 1996

#line 1996
    if (*ip > (double)X_UINT64_MAX || *ip < 0) {
#line 1996
        
#line 1996
#ifdef ERANGE_FILL
#line 1996
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1996
#endif
#line 1996
        err = NC_ERANGE;
#line 1996
    }
#line 1996
#ifdef ERANGE_FILL
#line 1996
    else
#line 1996
#endif
#line 1996
        xx = (ix_uint64)*ip;
#line 1996

#line 1996
    put_ix_uint64(xp, &xx);
#line 1996
    return err;
#line 1996
}
#line 1996

static int
#line 1997
ncx_put_ulonglong_double(void *xp, const double *ip, void *fillp)
#line 1997
{
#line 1997
    int err=NC_NOERR;
#line 1997
    ix_uint64 xx = NC_FILL_UINT64;
#line 1997

#line 1997
    if (*ip > X_UINT64_MAX || *ip < 0) {
#line 1997
        
#line 1997
#ifdef ERANGE_FILL
#line 1997
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1997
#endif
#line 1997
        err = NC_ERANGE;
#line 1997
    }
#line 1997
#ifdef ERANGE_FILL
#line 1997
    else
#line 1997
#endif
#line 1997
        xx = (ix_uint64)*ip;
#line 1997

#line 1997
    put_ix_uint64(xp, &xx);
#line 1997
    return err;
#line 1997
}
#line 1997



/* x_size_t */

#if SIZEOF_SIZE_T < X_SIZEOF_SIZE_T
#error "x_size_t implementation"
/* netcdf requires size_t which can hold a values from 0 to 2^32 -1 */
#endif

int
ncx_put_size_t(void **xpp, const size_t *ulp)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
	assert(*ulp <= X_SIZE_MAX);

	*cp++ = (uchar)((*ulp) >> 24);
	*cp++ = (uchar)(((*ulp) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ulp) & 0x0000ff00) >>  8);
	*cp   = (uchar)((*ulp) & 0x000000ff);

	*xpp = (void *)((char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

int
ncx_get_size_t(const void **xpp,  size_t *ulp)
{
	/* similar to get_ix_int */
	const uchar *cp = (const uchar *) *xpp;

	*ulp  = (unsigned)(*cp++) << 24;
	*ulp |= (*cp++ << 16);
	*ulp |= (*cp++ << 8);
	*ulp |= *cp;

	*xpp = (const void *)((const char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

/* x_off_t */

int
ncx_put_off_t(void **xpp, const off_t *lp, size_t sizeof_off_t)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;

	/* No negative offsets stored in netcdf */
	if (*lp < 0) {
	  /* Assume this is an overflow of a 32-bit int... */
	  return NC_ERANGE;
	}

	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

	if (sizeof_off_t == 4) {
		*cp++ = (uchar) ((*lp)               >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
	} else {
#if SIZEOF_OFF_T == 4
/* Write a 64-bit offset on a system with only a 32-bit offset */
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;

		*cp++ = (uchar)(((*lp) & 0xff000000) >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
#else
		*cp++ = (uchar) ((*lp)                          >> 56);
		*cp++ = (uchar)(((*lp) & 0x00ff000000000000LL) >> 48);
		*cp++ = (uchar)(((*lp) & 0x0000ff0000000000LL) >> 40);
		*cp++ = (uchar)(((*lp) & 0x000000ff00000000LL) >> 32);
		*cp++ = (uchar)(((*lp) & 0x00000000ff000000LL) >> 24);
		*cp++ = (uchar)(((*lp) & 0x0000000000ff0000LL) >> 16);
		*cp++ = (uchar)(((*lp) & 0x000000000000ff00LL) >>  8);
		*cp   = (uchar)( (*lp) & 0x00000000000000ffLL);
#endif
	}
	*xpp = (void *)((char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

int
ncx_get_off_t(const void **xpp, off_t *lp, size_t sizeof_off_t)
{
	/* similar to get_ix_int() */
	const uchar *cp = (const uchar *) *xpp;
	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

 	if (sizeof_off_t == 4) {
		*lp =  (off_t)(*cp++ << 24);
		*lp |= (off_t)(*cp++ << 16);
		*lp |= (off_t)(*cp++ <<  8);
		*lp |= (off_t)*cp;
	} else {
#if SIZEOF_OFF_T == 4
/* Read a 64-bit offset on a system with only a 32-bit offset */
/* If the offset overflows, set an error code and return */
		*lp =  ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |= ((off_t)(*cp++));
/*
 * lp now contains the upper 32-bits of the 64-bit offset.  if lp is
 * not zero, then the dataset is larger than can be represented
 * on this system.  Set an error code and return.
 */
		if (*lp != 0) {
		  return NC_ERANGE;
		}

		*lp  = ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;

		if (*lp < 0) {
		  /*
		   * If this fails, then the offset is >2^31, but less
		   * than 2^32 which is not allowed, but is not caught
		   * by the previous check
		   */
		  return NC_ERANGE;
		}
#else
		*lp =  ((off_t)(*cp++) << 56);
		*lp |= ((off_t)(*cp++) << 48);
		*lp |= ((off_t)(*cp++) << 40);
		*lp |= ((off_t)(*cp++) << 32);
		*lp |= ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;
#endif
	}
	*xpp = (const void *)((const char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

/*----< ncx_get_uint32() >------------------------------------------*/
int
ncx_get_uint32(const void **xpp, uint *ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ip, *xpp, SIZEOF_UINT);
#else
    const uchar *cp = (const uchar *) *xpp;

    *ip = (uint)(*cp++ << 24);
    *ip = (uint)(*ip | (uint)(*cp++ << 16));
    *ip = (uint)(*ip | (uint)(*cp++ <<  8));
    *ip = (uint)(*ip | *cp);
#endif
    /* advance *xpp 4 bytes */
    *xpp = (void *)((const char *)(*xpp) + 4);

    return NC_NOERR;
}

/*----< ncx_get_uint64() >------------------------------------------*/
int
ncx_get_uint64(const void **xpp, unsigned long long *ullp)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ullp, *xpp, SIZEOF_UINT64);
#else
    const uchar *cp = (const uchar *) *xpp;

    /* below is the same as calling swap8b(ullp, *xpp) */
    *ullp = (unsigned long long)(*cp++) << 56;
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 48);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 40);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 32);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 24);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 16);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) <<  8);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp));
#endif
    /* advance *xpp 8 bytes */
    *xpp = (void *)((const char *)(*xpp) + 8);

    return NC_NOERR;
}

/*---< ncx_put_uint32() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 32-bit integer) to xpp in Big Endian
 * form and advance *xpp 4 bytes
 */
int
ncx_put_uint32(void **xpp, const unsigned int ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT);
#else
    /* bitwise shifts below are to produce an integer in Big Endian */
    uchar *cp = (uchar *) *xpp;
    *cp++ = (uchar)((ip & 0xff000000) >> 24);
    *cp++ = (uchar)((ip & 0x00ff0000) >> 16);
    *cp++ = (uchar)((ip & 0x0000ff00) >>  8);
    *cp   = (uchar)( ip & 0x000000ff);
#endif
    /* advance *xpp 4 bytes */
    *xpp  = (void *)((char *)(*xpp) + 4);

    return NC_NOERR;
}

/*---< ncx_put_uint64() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 64-bit integer) to xpp in Big Endian
 * form and advance *xpp 8 bytes
 */
int
ncx_put_uint64(void **xpp, const unsigned long long ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT64);
#else
    uchar *cp = (uchar *) *xpp;
    /* below is the same as calling swap8b(*xpp, &ip) */
    *cp++ = (uchar) (ip                         >> 56);
    *cp++ = (uchar)((ip & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)((ip & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)((ip & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)((ip & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)((ip & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)((ip & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar) (ip & 0x00000000000000ffLL);
#endif
    /* advance *xpp 8 bytes */
    *xpp  = (void *)((char *)(*xpp) + 8);

    return NC_NOERR;
}


/*
 * Aggregate numeric conversion functions.
 */
#line 2253

#line 2656

#line 2662

/* schar ---------------------------------------------------------------------*/

#line 2666
int
ncx_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2669
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2669
	return NC_NOERR;
#line 2669

}
int
#line 2671
ncx_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2671
{
#line 2671
    int status = NC_NOERR;
#line 2671
    schar *xp = (schar *)(*xpp);
#line 2671

#line 2671
    while (nelems-- != 0) {
#line 2671
        
#line 2671
        if (*xp < 0) {
#line 2671
#ifdef ERANGE_FILL
#line 2671
            *tp = NC_FILL_UBYTE;
#line 2671
#endif
#line 2671
            status = NC_ERANGE; /* because tp is unsigned */
#line 2671
            
#line 2671
#ifdef ERANGE_FILL
#line 2671
            xp++; tp++; continue;
#line 2671
#endif
#line 2671
        }
#line 2671
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2671
    }
#line 2671

#line 2671
    *xpp = (const void *)xp;
#line 2671
    return status;
#line 2671
}
#line 2671

int
#line 2672
ncx_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2672
{
#line 2672
    int status = NC_NOERR;
#line 2672
    schar *xp = (schar *)(*xpp);
#line 2672

#line 2672
    while (nelems-- != 0) {
#line 2672
        
#line 2672
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2672
    }
#line 2672

#line 2672
    *xpp = (const void *)xp;
#line 2672
    return status;
#line 2672
}
#line 2672

int
#line 2673
ncx_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2673
{
#line 2673
    int status = NC_NOERR;
#line 2673
    schar *xp = (schar *)(*xpp);
#line 2673

#line 2673
    while (nelems-- != 0) {
#line 2673
        
#line 2673
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2673
    }
#line 2673

#line 2673
    *xpp = (const void *)xp;
#line 2673
    return status;
#line 2673
}
#line 2673

int
#line 2674
ncx_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2674
{
#line 2674
    int status = NC_NOERR;
#line 2674
    schar *xp = (schar *)(*xpp);
#line 2674

#line 2674
    while (nelems-- != 0) {
#line 2674
        
#line 2674
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2674
    }
#line 2674

#line 2674
    *xpp = (const void *)xp;
#line 2674
    return status;
#line 2674
}
#line 2674

int
#line 2675
ncx_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2675
{
#line 2675
    int status = NC_NOERR;
#line 2675
    schar *xp = (schar *)(*xpp);
#line 2675

#line 2675
    while (nelems-- != 0) {
#line 2675
        
#line 2675
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2675
    }
#line 2675

#line 2675
    *xpp = (const void *)xp;
#line 2675
    return status;
#line 2675
}
#line 2675

int
#line 2676
ncx_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2676
{
#line 2676
    int status = NC_NOERR;
#line 2676
    schar *xp = (schar *)(*xpp);
#line 2676

#line 2676
    while (nelems-- != 0) {
#line 2676
        
#line 2676
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2676
    }
#line 2676

#line 2676
    *xpp = (const void *)xp;
#line 2676
    return status;
#line 2676
}
#line 2676

int
#line 2677
ncx_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2677
{
#line 2677
    int status = NC_NOERR;
#line 2677
    schar *xp = (schar *)(*xpp);
#line 2677

#line 2677
    while (nelems-- != 0) {
#line 2677
        
#line 2677
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2677
    }
#line 2677

#line 2677
    *xpp = (const void *)xp;
#line 2677
    return status;
#line 2677
}
#line 2677

int
#line 2678
ncx_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2678
{
#line 2678
    int status = NC_NOERR;
#line 2678
    schar *xp = (schar *)(*xpp);
#line 2678

#line 2678
    while (nelems-- != 0) {
#line 2678
        
#line 2678
        if (*xp < 0) {
#line 2678
#ifdef ERANGE_FILL
#line 2678
            *tp = NC_FILL_USHORT;
#line 2678
#endif
#line 2678
            status = NC_ERANGE; /* because tp is unsigned */
#line 2678
            
#line 2678
#ifdef ERANGE_FILL
#line 2678
            xp++; tp++; continue;
#line 2678
#endif
#line 2678
        }
#line 2678
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2678
    }
#line 2678

#line 2678
    *xpp = (const void *)xp;
#line 2678
    return status;
#line 2678
}
#line 2678

int
#line 2679
ncx_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2679
{
#line 2679
    int status = NC_NOERR;
#line 2679
    schar *xp = (schar *)(*xpp);
#line 2679

#line 2679
    while (nelems-- != 0) {
#line 2679
        
#line 2679
        if (*xp < 0) {
#line 2679
#ifdef ERANGE_FILL
#line 2679
            *tp = NC_FILL_UINT;
#line 2679
#endif
#line 2679
            status = NC_ERANGE; /* because tp is unsigned */
#line 2679
            
#line 2679
#ifdef ERANGE_FILL
#line 2679
            xp++; tp++; continue;
#line 2679
#endif
#line 2679
        }
#line 2679
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2679
    }
#line 2679

#line 2679
    *xpp = (const void *)xp;
#line 2679
    return status;
#line 2679
}
#line 2679

int
#line 2680
ncx_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2680
{
#line 2680
    int status = NC_NOERR;
#line 2680
    schar *xp = (schar *)(*xpp);
#line 2680

#line 2680
    while (nelems-- != 0) {
#line 2680
        
#line 2680
        if (*xp < 0) {
#line 2680
#ifdef ERANGE_FILL
#line 2680
            *tp = NC_FILL_UINT64;
#line 2680
#endif
#line 2680
            status = NC_ERANGE; /* because tp is unsigned */
#line 2680
            
#line 2680
#ifdef ERANGE_FILL
#line 2680
            xp++; tp++; continue;
#line 2680
#endif
#line 2680
        }
#line 2680
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2680
    }
#line 2680

#line 2680
    *xpp = (const void *)xp;
#line 2680
    return status;
#line 2680
}
#line 2680


#line 2683
int
ncx_pad_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2686

#line 2686
	if (rndup)
#line 2686
		rndup = X_ALIGN - rndup;
#line 2686

#line 2686
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2686
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2686

#line 2686
	return NC_NOERR;
#line 2686

}
int
#line 2688
ncx_pad_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2688
{
#line 2688
    int status = NC_NOERR;
#line 2688
    size_t rndup = nelems % X_ALIGN;
#line 2688
    schar *xp = (schar *) *xpp;
#line 2688

#line 2688
    if (rndup)
#line 2688
        rndup = X_ALIGN - rndup;
#line 2688

#line 2688
    while (nelems-- != 0) {
#line 2688
        
#line 2688
        if (*xp < 0) {
#line 2688
#ifdef ERANGE_FILL
#line 2688
            *tp = NC_FILL_UBYTE;
#line 2688
#endif
#line 2688
            status = NC_ERANGE; /* because tp is unsigned */
#line 2688
            
#line 2688
#ifdef ERANGE_FILL
#line 2688
            xp++; tp++; continue;
#line 2688
#endif
#line 2688
        }
#line 2688
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2688
    }
#line 2688

#line 2688
    *xpp = (void *)(xp + rndup);
#line 2688
    return status;
#line 2688
}
#line 2688

int
#line 2689
ncx_pad_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2689
{
#line 2689
    int status = NC_NOERR;
#line 2689
    size_t rndup = nelems % X_ALIGN;
#line 2689
    schar *xp = (schar *) *xpp;
#line 2689

#line 2689
    if (rndup)
#line 2689
        rndup = X_ALIGN - rndup;
#line 2689

#line 2689
    while (nelems-- != 0) {
#line 2689
        
#line 2689
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2689
    }
#line 2689

#line 2689
    *xpp = (void *)(xp + rndup);
#line 2689
    return status;
#line 2689
}
#line 2689

int
#line 2690
ncx_pad_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2690
{
#line 2690
    int status = NC_NOERR;
#line 2690
    size_t rndup = nelems % X_ALIGN;
#line 2690
    schar *xp = (schar *) *xpp;
#line 2690

#line 2690
    if (rndup)
#line 2690
        rndup = X_ALIGN - rndup;
#line 2690

#line 2690
    while (nelems-- != 0) {
#line 2690
        
#line 2690
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2690
    }
#line 2690

#line 2690
    *xpp = (void *)(xp + rndup);
#line 2690
    return status;
#line 2690
}
#line 2690

int
#line 2691
ncx_pad_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2691
{
#line 2691
    int status = NC_NOERR;
#line 2691
    size_t rndup = nelems % X_ALIGN;
#line 2691
    schar *xp = (schar *) *xpp;
#line 2691

#line 2691
    if (rndup)
#line 2691
        rndup = X_ALIGN - rndup;
#line 2691

#line 2691
    while (nelems-- != 0) {
#line 2691
        
#line 2691
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2691
    }
#line 2691

#line 2691
    *xpp = (void *)(xp + rndup);
#line 2691
    return status;
#line 2691
}
#line 2691

int
#line 2692
ncx_pad_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2692
{
#line 2692
    int status = NC_NOERR;
#line 2692
    size_t rndup = nelems % X_ALIGN;
#line 2692
    schar *xp = (schar *) *xpp;
#line 2692

#line 2692
    if (rndup)
#line 2692
        rndup = X_ALIGN - rndup;
#line 2692

#line 2692
    while (nelems-- != 0) {
#line 2692
        
#line 2692
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2692
    }
#line 2692

#line 2692
    *xpp = (void *)(xp + rndup);
#line 2692
    return status;
#line 2692
}
#line 2692

int
#line 2693
ncx_pad_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2693
{
#line 2693
    int status = NC_NOERR;
#line 2693
    size_t rndup = nelems % X_ALIGN;
#line 2693
    schar *xp = (schar *) *xpp;
#line 2693

#line 2693
    if (rndup)
#line 2693
        rndup = X_ALIGN - rndup;
#line 2693

#line 2693
    while (nelems-- != 0) {
#line 2693
        
#line 2693
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2693
    }
#line 2693

#line 2693
    *xpp = (void *)(xp + rndup);
#line 2693
    return status;
#line 2693
}
#line 2693

int
#line 2694
ncx_pad_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2694
{
#line 2694
    int status = NC_NOERR;
#line 2694
    size_t rndup = nelems % X_ALIGN;
#line 2694
    schar *xp = (schar *) *xpp;
#line 2694

#line 2694
    if (rndup)
#line 2694
        rndup = X_ALIGN - rndup;
#line 2694

#line 2694
    while (nelems-- != 0) {
#line 2694
        
#line 2694
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2694
    }
#line 2694

#line 2694
    *xpp = (void *)(xp + rndup);
#line 2694
    return status;
#line 2694
}
#line 2694

int
#line 2695
ncx_pad_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2695
{
#line 2695
    int status = NC_NOERR;
#line 2695
    size_t rndup = nelems % X_ALIGN;
#line 2695
    schar *xp = (schar *) *xpp;
#line 2695

#line 2695
    if (rndup)
#line 2695
        rndup = X_ALIGN - rndup;
#line 2695

#line 2695
    while (nelems-- != 0) {
#line 2695
        
#line 2695
        if (*xp < 0) {
#line 2695
#ifdef ERANGE_FILL
#line 2695
            *tp = NC_FILL_USHORT;
#line 2695
#endif
#line 2695
            status = NC_ERANGE; /* because tp is unsigned */
#line 2695
            
#line 2695
#ifdef ERANGE_FILL
#line 2695
            xp++; tp++; continue;
#line 2695
#endif
#line 2695
        }
#line 2695
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2695
    }
#line 2695

#line 2695
    *xpp = (void *)(xp + rndup);
#line 2695
    return status;
#line 2695
}
#line 2695

int
#line 2696
ncx_pad_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2696
{
#line 2696
    int status = NC_NOERR;
#line 2696
    size_t rndup = nelems % X_ALIGN;
#line 2696
    schar *xp = (schar *) *xpp;
#line 2696

#line 2696
    if (rndup)
#line 2696
        rndup = X_ALIGN - rndup;
#line 2696

#line 2696
    while (nelems-- != 0) {
#line 2696
        
#line 2696
        if (*xp < 0) {
#line 2696
#ifdef ERANGE_FILL
#line 2696
            *tp = NC_FILL_UINT;
#line 2696
#endif
#line 2696
            status = NC_ERANGE; /* because tp is unsigned */
#line 2696
            
#line 2696
#ifdef ERANGE_FILL
#line 2696
            xp++; tp++; continue;
#line 2696
#endif
#line 2696
        }
#line 2696
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2696
    }
#line 2696

#line 2696
    *xpp = (void *)(xp + rndup);
#line 2696
    return status;
#line 2696
}
#line 2696

int
#line 2697
ncx_pad_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2697
{
#line 2697
    int status = NC_NOERR;
#line 2697
    size_t rndup = nelems % X_ALIGN;
#line 2697
    schar *xp = (schar *) *xpp;
#line 2697

#line 2697
    if (rndup)
#line 2697
        rndup = X_ALIGN - rndup;
#line 2697

#line 2697
    while (nelems-- != 0) {
#line 2697
        
#line 2697
        if (*xp < 0) {
#line 2697
#ifdef ERANGE_FILL
#line 2697
            *tp = NC_FILL_UINT64;
#line 2697
#endif
#line 2697
            status = NC_ERANGE; /* because tp is unsigned */
#line 2697
            
#line 2697
#ifdef ERANGE_FILL
#line 2697
            xp++; tp++; continue;
#line 2697
#endif
#line 2697
        }
#line 2697
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2697
    }
#line 2697

#line 2697
    *xpp = (void *)(xp + rndup);
#line 2697
    return status;
#line 2697
}
#line 2697


#line 2700
int
ncx_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2703
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2703

#line 2703
	return NC_NOERR;
#line 2703

}
int
#line 2705
ncx_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2705
{
#line 2705
    int status = NC_NOERR;
#line 2705
    schar *xp = (schar *) *xpp;
#line 2705

#line 2705
    while (nelems-- != 0) {
#line 2705
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2705
            
#line 2705
#ifdef ERANGE_FILL
#line 2705
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2705
#endif
#line 2705
            status = NC_ERANGE;
#line 2705
            
#line 2705
#ifdef ERANGE_FILL
#line 2705
            xp++; tp++; continue;
#line 2705
#endif
#line 2705
        }
#line 2705
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2705
    }
#line 2705

#line 2705
    *xpp = (void *)xp;
#line 2705
    return status;
#line 2705
}
#line 2705

int
#line 2706
ncx_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2706
{
#line 2706
    int status = NC_NOERR;
#line 2706
    schar *xp = (schar *) *xpp;
#line 2706

#line 2706
    while (nelems-- != 0) {
#line 2706
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2706
            
#line 2706
#ifdef ERANGE_FILL
#line 2706
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2706
#endif
#line 2706
            status = NC_ERANGE;
#line 2706
            
#line 2706
#ifdef ERANGE_FILL
#line 2706
            xp++; tp++; continue;
#line 2706
#endif
#line 2706
        }
#line 2706
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2706
    }
#line 2706

#line 2706
    *xpp = (void *)xp;
#line 2706
    return status;
#line 2706
}
#line 2706

int
#line 2707
ncx_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2707
{
#line 2707
    int status = NC_NOERR;
#line 2707
    schar *xp = (schar *) *xpp;
#line 2707

#line 2707
    while (nelems-- != 0) {
#line 2707
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2707
            
#line 2707
#ifdef ERANGE_FILL
#line 2707
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2707
#endif
#line 2707
            status = NC_ERANGE;
#line 2707
            
#line 2707
#ifdef ERANGE_FILL
#line 2707
            xp++; tp++; continue;
#line 2707
#endif
#line 2707
        }
#line 2707
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2707
    }
#line 2707

#line 2707
    *xpp = (void *)xp;
#line 2707
    return status;
#line 2707
}
#line 2707

int
#line 2708
ncx_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2708
{
#line 2708
    int status = NC_NOERR;
#line 2708
    schar *xp = (schar *) *xpp;
#line 2708

#line 2708
    while (nelems-- != 0) {
#line 2708
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2708
            
#line 2708
#ifdef ERANGE_FILL
#line 2708
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2708
#endif
#line 2708
            status = NC_ERANGE;
#line 2708
            
#line 2708
#ifdef ERANGE_FILL
#line 2708
            xp++; tp++; continue;
#line 2708
#endif
#line 2708
        }
#line 2708
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2708
    }
#line 2708

#line 2708
    *xpp = (void *)xp;
#line 2708
    return status;
#line 2708
}
#line 2708

int
#line 2709
ncx_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2709
{
#line 2709
    int status = NC_NOERR;
#line 2709
    schar *xp = (schar *) *xpp;
#line 2709

#line 2709
    while (nelems-- != 0) {
#line 2709
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2709
            
#line 2709
#ifdef ERANGE_FILL
#line 2709
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2709
#endif
#line 2709
            status = NC_ERANGE;
#line 2709
            
#line 2709
#ifdef ERANGE_FILL
#line 2709
            xp++; tp++; continue;
#line 2709
#endif
#line 2709
        }
#line 2709
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2709
    }
#line 2709

#line 2709
    *xpp = (void *)xp;
#line 2709
    return status;
#line 2709
}
#line 2709

int
#line 2710
ncx_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2710
{
#line 2710
    int status = NC_NOERR;
#line 2710
    schar *xp = (schar *) *xpp;
#line 2710

#line 2710
    while (nelems-- != 0) {
#line 2710
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2710
            
#line 2710
#ifdef ERANGE_FILL
#line 2710
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2710
#endif
#line 2710
            status = NC_ERANGE;
#line 2710
            
#line 2710
#ifdef ERANGE_FILL
#line 2710
            xp++; tp++; continue;
#line 2710
#endif
#line 2710
        }
#line 2710
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2710
    }
#line 2710

#line 2710
    *xpp = (void *)xp;
#line 2710
    return status;
#line 2710
}
#line 2710

int
#line 2711
ncx_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2711
{
#line 2711
    int status = NC_NOERR;
#line 2711
    schar *xp = (schar *) *xpp;
#line 2711

#line 2711
    while (nelems-- != 0) {
#line 2711
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2711
            
#line 2711
#ifdef ERANGE_FILL
#line 2711
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2711
#endif
#line 2711
            status = NC_ERANGE;
#line 2711
            
#line 2711
#ifdef ERANGE_FILL
#line 2711
            xp++; tp++; continue;
#line 2711
#endif
#line 2711
        }
#line 2711
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2711
    }
#line 2711

#line 2711
    *xpp = (void *)xp;
#line 2711
    return status;
#line 2711
}
#line 2711

int
#line 2712
ncx_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2712
{
#line 2712
    int status = NC_NOERR;
#line 2712
    schar *xp = (schar *) *xpp;
#line 2712

#line 2712
    while (nelems-- != 0) {
#line 2712
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2712
            
#line 2712
#ifdef ERANGE_FILL
#line 2712
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2712
#endif
#line 2712
            status = NC_ERANGE;
#line 2712
            
#line 2712
#ifdef ERANGE_FILL
#line 2712
            xp++; tp++; continue;
#line 2712
#endif
#line 2712
        }
#line 2712
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2712
    }
#line 2712

#line 2712
    *xpp = (void *)xp;
#line 2712
    return status;
#line 2712
}
#line 2712

int
#line 2713
ncx_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2713
{
#line 2713
    int status = NC_NOERR;
#line 2713
    schar *xp = (schar *) *xpp;
#line 2713

#line 2713
    while (nelems-- != 0) {
#line 2713
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2713
            
#line 2713
#ifdef ERANGE_FILL
#line 2713
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2713
#endif
#line 2713
            status = NC_ERANGE;
#line 2713
            
#line 2713
#ifdef ERANGE_FILL
#line 2713
            xp++; tp++; continue;
#line 2713
#endif
#line 2713
        }
#line 2713
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2713
    }
#line 2713

#line 2713
    *xpp = (void *)xp;
#line 2713
    return status;
#line 2713
}
#line 2713

int
#line 2714
ncx_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2714
{
#line 2714
    int status = NC_NOERR;
#line 2714
    schar *xp = (schar *) *xpp;
#line 2714

#line 2714
    while (nelems-- != 0) {
#line 2714
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2714
            
#line 2714
#ifdef ERANGE_FILL
#line 2714
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2714
#endif
#line 2714
            status = NC_ERANGE;
#line 2714
            
#line 2714
#ifdef ERANGE_FILL
#line 2714
            xp++; tp++; continue;
#line 2714
#endif
#line 2714
        }
#line 2714
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2714
    }
#line 2714

#line 2714
    *xpp = (void *)xp;
#line 2714
    return status;
#line 2714
}
#line 2714


#line 2717
int
ncx_pad_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2720

#line 2720
	if (rndup)
#line 2720
		rndup = X_ALIGN - rndup;
#line 2720

#line 2720
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2720
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2720

#line 2720
	if (rndup)
#line 2720
	{
#line 2720
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 2720
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2720
	}
#line 2720

#line 2720
	return NC_NOERR;
#line 2720

}
int
#line 2722
ncx_pad_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2722
{
#line 2722
    int status = NC_NOERR;
#line 2722
    size_t rndup = nelems % X_ALIGN;
#line 2722
    schar *xp = (schar *) *xpp;
#line 2722

#line 2722
    if (rndup) rndup = X_ALIGN - rndup;
#line 2722

#line 2722
    while (nelems-- != 0) {
#line 2722
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2722
            
#line 2722
#ifdef ERANGE_FILL
#line 2722
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2722
#endif
#line 2722
            status = NC_ERANGE;
#line 2722
            
#line 2722
#ifdef ERANGE_FILL
#line 2722
            xp++; tp++; continue;
#line 2722
#endif
#line 2722
        }
#line 2722
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2722
    }
#line 2722

#line 2722

#line 2722
    if (rndup) {
#line 2722
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2722
        xp += rndup;
#line 2722
    }
#line 2722

#line 2722
    *xpp = (void *)xp;
#line 2722
    return status;
#line 2722
}
#line 2722

int
#line 2723
ncx_pad_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2723
{
#line 2723
    int status = NC_NOERR;
#line 2723
    size_t rndup = nelems % X_ALIGN;
#line 2723
    schar *xp = (schar *) *xpp;
#line 2723

#line 2723
    if (rndup) rndup = X_ALIGN - rndup;
#line 2723

#line 2723
    while (nelems-- != 0) {
#line 2723
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2723
            
#line 2723
#ifdef ERANGE_FILL
#line 2723
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2723
#endif
#line 2723
            status = NC_ERANGE;
#line 2723
            
#line 2723
#ifdef ERANGE_FILL
#line 2723
            xp++; tp++; continue;
#line 2723
#endif
#line 2723
        }
#line 2723
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2723
    }
#line 2723

#line 2723

#line 2723
    if (rndup) {
#line 2723
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2723
        xp += rndup;
#line 2723
    }
#line 2723

#line 2723
    *xpp = (void *)xp;
#line 2723
    return status;
#line 2723
}
#line 2723

int
#line 2724
ncx_pad_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2724
{
#line 2724
    int status = NC_NOERR;
#line 2724
    size_t rndup = nelems % X_ALIGN;
#line 2724
    schar *xp = (schar *) *xpp;
#line 2724

#line 2724
    if (rndup) rndup = X_ALIGN - rndup;
#line 2724

#line 2724
    while (nelems-- != 0) {
#line 2724
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2724
            
#line 2724
#ifdef ERANGE_FILL
#line 2724
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2724
#endif
#line 2724
            status = NC_ERANGE;
#line 2724
            
#line 2724
#ifdef ERANGE_FILL
#line 2724
            xp++; tp++; continue;
#line 2724
#endif
#line 2724
        }
#line 2724
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2724
    }
#line 2724

#line 2724

#line 2724
    if (rndup) {
#line 2724
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2724
        xp += rndup;
#line 2724
    }
#line 2724

#line 2724
    *xpp = (void *)xp;
#line 2724
    return status;
#line 2724
}
#line 2724

int
#line 2725
ncx_pad_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2725
{
#line 2725
    int status = NC_NOERR;
#line 2725
    size_t rndup = nelems % X_ALIGN;
#line 2725
    schar *xp = (schar *) *xpp;
#line 2725

#line 2725
    if (rndup) rndup = X_ALIGN - rndup;
#line 2725

#line 2725
    while (nelems-- != 0) {
#line 2725
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2725
            
#line 2725
#ifdef ERANGE_FILL
#line 2725
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2725
#endif
#line 2725
            status = NC_ERANGE;
#line 2725
            
#line 2725
#ifdef ERANGE_FILL
#line 2725
            xp++; tp++; continue;
#line 2725
#endif
#line 2725
        }
#line 2725
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2725
    }
#line 2725

#line 2725

#line 2725
    if (rndup) {
#line 2725
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2725
        xp += rndup;
#line 2725
    }
#line 2725

#line 2725
    *xpp = (void *)xp;
#line 2725
    return status;
#line 2725
}
#line 2725

int
#line 2726
ncx_pad_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2726
{
#line 2726
    int status = NC_NOERR;
#line 2726
    size_t rndup = nelems % X_ALIGN;
#line 2726
    schar *xp = (schar *) *xpp;
#line 2726

#line 2726
    if (rndup) rndup = X_ALIGN - rndup;
#line 2726

#line 2726
    while (nelems-- != 0) {
#line 2726
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2726
            
#line 2726
#ifdef ERANGE_FILL
#line 2726
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2726
#endif
#line 2726
            status = NC_ERANGE;
#line 2726
            
#line 2726
#ifdef ERANGE_FILL
#line 2726
            xp++; tp++; continue;
#line 2726
#endif
#line 2726
        }
#line 2726
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2726
    }
#line 2726

#line 2726

#line 2726
    if (rndup) {
#line 2726
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2726
        xp += rndup;
#line 2726
    }
#line 2726

#line 2726
    *xpp = (void *)xp;
#line 2726
    return status;
#line 2726
}
#line 2726

int
#line 2727
ncx_pad_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2727
{
#line 2727
    int status = NC_NOERR;
#line 2727
    size_t rndup = nelems % X_ALIGN;
#line 2727
    schar *xp = (schar *) *xpp;
#line 2727

#line 2727
    if (rndup) rndup = X_ALIGN - rndup;
#line 2727

#line 2727
    while (nelems-- != 0) {
#line 2727
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2727
            
#line 2727
#ifdef ERANGE_FILL
#line 2727
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2727
#endif
#line 2727
            status = NC_ERANGE;
#line 2727
            
#line 2727
#ifdef ERANGE_FILL
#line 2727
            xp++; tp++; continue;
#line 2727
#endif
#line 2727
        }
#line 2727
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2727
    }
#line 2727

#line 2727

#line 2727
    if (rndup) {
#line 2727
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2727
        xp += rndup;
#line 2727
    }
#line 2727

#line 2727
    *xpp = (void *)xp;
#line 2727
    return status;
#line 2727
}
#line 2727

int
#line 2728
ncx_pad_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2728
{
#line 2728
    int status = NC_NOERR;
#line 2728
    size_t rndup = nelems % X_ALIGN;
#line 2728
    schar *xp = (schar *) *xpp;
#line 2728

#line 2728
    if (rndup) rndup = X_ALIGN - rndup;
#line 2728

#line 2728
    while (nelems-- != 0) {
#line 2728
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2728
            
#line 2728
#ifdef ERANGE_FILL
#line 2728
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2728
#endif
#line 2728
            status = NC_ERANGE;
#line 2728
            
#line 2728
#ifdef ERANGE_FILL
#line 2728
            xp++; tp++; continue;
#line 2728
#endif
#line 2728
        }
#line 2728
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2728
    }
#line 2728

#line 2728

#line 2728
    if (rndup) {
#line 2728
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2728
        xp += rndup;
#line 2728
    }
#line 2728

#line 2728
    *xpp = (void *)xp;
#line 2728
    return status;
#line 2728
}
#line 2728

int
#line 2729
ncx_pad_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2729
{
#line 2729
    int status = NC_NOERR;
#line 2729
    size_t rndup = nelems % X_ALIGN;
#line 2729
    schar *xp = (schar *) *xpp;
#line 2729

#line 2729
    if (rndup) rndup = X_ALIGN - rndup;
#line 2729

#line 2729
    while (nelems-- != 0) {
#line 2729
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2729
            
#line 2729
#ifdef ERANGE_FILL
#line 2729
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2729
#endif
#line 2729
            status = NC_ERANGE;
#line 2729
            
#line 2729
#ifdef ERANGE_FILL
#line 2729
            xp++; tp++; continue;
#line 2729
#endif
#line 2729
        }
#line 2729
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2729
    }
#line 2729

#line 2729

#line 2729
    if (rndup) {
#line 2729
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2729
        xp += rndup;
#line 2729
    }
#line 2729

#line 2729
    *xpp = (void *)xp;
#line 2729
    return status;
#line 2729
}
#line 2729

int
#line 2730
ncx_pad_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2730
{
#line 2730
    int status = NC_NOERR;
#line 2730
    size_t rndup = nelems % X_ALIGN;
#line 2730
    schar *xp = (schar *) *xpp;
#line 2730

#line 2730
    if (rndup) rndup = X_ALIGN - rndup;
#line 2730

#line 2730
    while (nelems-- != 0) {
#line 2730
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2730
            
#line 2730
#ifdef ERANGE_FILL
#line 2730
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2730
#endif
#line 2730
            status = NC_ERANGE;
#line 2730
            
#line 2730
#ifdef ERANGE_FILL
#line 2730
            xp++; tp++; continue;
#line 2730
#endif
#line 2730
        }
#line 2730
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2730
    }
#line 2730

#line 2730

#line 2730
    if (rndup) {
#line 2730
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2730
        xp += rndup;
#line 2730
    }
#line 2730

#line 2730
    *xpp = (void *)xp;
#line 2730
    return status;
#line 2730
}
#line 2730

int
#line 2731
ncx_pad_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2731
{
#line 2731
    int status = NC_NOERR;
#line 2731
    size_t rndup = nelems % X_ALIGN;
#line 2731
    schar *xp = (schar *) *xpp;
#line 2731

#line 2731
    if (rndup) rndup = X_ALIGN - rndup;
#line 2731

#line 2731
    while (nelems-- != 0) {
#line 2731
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2731
            
#line 2731
#ifdef ERANGE_FILL
#line 2731
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2731
#endif
#line 2731
            status = NC_ERANGE;
#line 2731
            
#line 2731
#ifdef ERANGE_FILL
#line 2731
            xp++; tp++; continue;
#line 2731
#endif
#line 2731
        }
#line 2731
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2731
    }
#line 2731

#line 2731

#line 2731
    if (rndup) {
#line 2731
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2731
        xp += rndup;
#line 2731
    }
#line 2731

#line 2731
    *xpp = (void *)xp;
#line 2731
    return status;
#line 2731
}
#line 2731



/* uchar ---------------------------------------------------------------------*/
#line 2737
int
ncx_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *)(*xpp);

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
       	    status = NC_ERANGE;
            
#line 2747
#ifdef ERANGE_FILL
#line 2747
            xp++; tp++; continue;
#line 2747
#endif
        }
	*tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (const void *)xp;
    return status;
}
#line 2756
int
ncx_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2759
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2759
	return NC_NOERR;
#line 2759

}
int
#line 2761
ncx_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 2761
{
#line 2761
    int status = NC_NOERR;
#line 2761
    uchar *xp = (uchar *)(*xpp);
#line 2761

#line 2761
    while (nelems-- != 0) {
#line 2761
        
#line 2761
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 2761
    }
#line 2761

#line 2761
    *xpp = (const void *)xp;
#line 2761
    return status;
#line 2761
}
#line 2761

int
#line 2762
ncx_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 2762
{
#line 2762
    int status = NC_NOERR;
#line 2762
    uchar *xp = (uchar *)(*xpp);
#line 2762

#line 2762
    while (nelems-- != 0) {
#line 2762
        
#line 2762
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 2762
    }
#line 2762

#line 2762
    *xpp = (const void *)xp;
#line 2762
    return status;
#line 2762
}
#line 2762

int
#line 2763
ncx_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 2763
{
#line 2763
    int status = NC_NOERR;
#line 2763
    uchar *xp = (uchar *)(*xpp);
#line 2763

#line 2763
    while (nelems-- != 0) {
#line 2763
        
#line 2763
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 2763
    }
#line 2763

#line 2763
    *xpp = (const void *)xp;
#line 2763
    return status;
#line 2763
}
#line 2763

int
#line 2764
ncx_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 2764
{
#line 2764
    int status = NC_NOERR;
#line 2764
    uchar *xp = (uchar *)(*xpp);
#line 2764

#line 2764
    while (nelems-- != 0) {
#line 2764
        
#line 2764
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 2764
    }
#line 2764

#line 2764
    *xpp = (const void *)xp;
#line 2764
    return status;
#line 2764
}
#line 2764

int
#line 2765
ncx_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 2765
{
#line 2765
    int status = NC_NOERR;
#line 2765
    uchar *xp = (uchar *)(*xpp);
#line 2765

#line 2765
    while (nelems-- != 0) {
#line 2765
        
#line 2765
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 2765
    }
#line 2765

#line 2765
    *xpp = (const void *)xp;
#line 2765
    return status;
#line 2765
}
#line 2765

int
#line 2766
ncx_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2766
{
#line 2766
    int status = NC_NOERR;
#line 2766
    uchar *xp = (uchar *)(*xpp);
#line 2766

#line 2766
    while (nelems-- != 0) {
#line 2766
        
#line 2766
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 2766
    }
#line 2766

#line 2766
    *xpp = (const void *)xp;
#line 2766
    return status;
#line 2766
}
#line 2766

int
#line 2767
ncx_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2767
{
#line 2767
    int status = NC_NOERR;
#line 2767
    uchar *xp = (uchar *)(*xpp);
#line 2767

#line 2767
    while (nelems-- != 0) {
#line 2767
        
#line 2767
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 2767
    }
#line 2767

#line 2767
    *xpp = (const void *)xp;
#line 2767
    return status;
#line 2767
}
#line 2767

int
#line 2768
ncx_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2768
{
#line 2768
    int status = NC_NOERR;
#line 2768
    uchar *xp = (uchar *)(*xpp);
#line 2768

#line 2768
    while (nelems-- != 0) {
#line 2768
        
#line 2768
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 2768
    }
#line 2768

#line 2768
    *xpp = (const void *)xp;
#line 2768
    return status;
#line 2768
}
#line 2768

int
#line 2769
ncx_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2769
{
#line 2769
    int status = NC_NOERR;
#line 2769
    uchar *xp = (uchar *)(*xpp);
#line 2769

#line 2769
    while (nelems-- != 0) {
#line 2769
        
#line 2769
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 2769
    }
#line 2769

#line 2769
    *xpp = (const void *)xp;
#line 2769
    return status;
#line 2769
}
#line 2769


#line 2772
int
ncx_pad_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
            status = NC_ERANGE;
            
#line 2785
#ifdef ERANGE_FILL
#line 2785
            xp++; tp++; continue;
#line 2785
#endif
        }
        *tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (void *)(xp + rndup);
    return status;
}
#line 2794
int
ncx_pad_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2797

#line 2797
	if (rndup)
#line 2797
		rndup = X_ALIGN - rndup;
#line 2797

#line 2797
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2797
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2797

#line 2797
	return NC_NOERR;
#line 2797

}
int
#line 2799
ncx_pad_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 2799
{
#line 2799
    int status = NC_NOERR;
#line 2799
    size_t rndup = nelems % X_ALIGN;
#line 2799
    uchar *xp = (uchar *) *xpp;
#line 2799

#line 2799
    if (rndup)
#line 2799
        rndup = X_ALIGN - rndup;
#line 2799

#line 2799
    while (nelems-- != 0) {
#line 2799
        
#line 2799
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 2799
    }
#line 2799

#line 2799
    *xpp = (void *)(xp + rndup);
#line 2799
    return status;
#line 2799
}
#line 2799

int
#line 2800
ncx_pad_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 2800
{
#line 2800
    int status = NC_NOERR;
#line 2800
    size_t rndup = nelems % X_ALIGN;
#line 2800
    uchar *xp = (uchar *) *xpp;
#line 2800

#line 2800
    if (rndup)
#line 2800
        rndup = X_ALIGN - rndup;
#line 2800

#line 2800
    while (nelems-- != 0) {
#line 2800
        
#line 2800
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 2800
    }
#line 2800

#line 2800
    *xpp = (void *)(xp + rndup);
#line 2800
    return status;
#line 2800
}
#line 2800

int
#line 2801
ncx_pad_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 2801
{
#line 2801
    int status = NC_NOERR;
#line 2801
    size_t rndup = nelems % X_ALIGN;
#line 2801
    uchar *xp = (uchar *) *xpp;
#line 2801

#line 2801
    if (rndup)
#line 2801
        rndup = X_ALIGN - rndup;
#line 2801

#line 2801
    while (nelems-- != 0) {
#line 2801
        
#line 2801
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 2801
    }
#line 2801

#line 2801
    *xpp = (void *)(xp + rndup);
#line 2801
    return status;
#line 2801
}
#line 2801

int
#line 2802
ncx_pad_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 2802
{
#line 2802
    int status = NC_NOERR;
#line 2802
    size_t rndup = nelems % X_ALIGN;
#line 2802
    uchar *xp = (uchar *) *xpp;
#line 2802

#line 2802
    if (rndup)
#line 2802
        rndup = X_ALIGN - rndup;
#line 2802

#line 2802
    while (nelems-- != 0) {
#line 2802
        
#line 2802
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 2802
    }
#line 2802

#line 2802
    *xpp = (void *)(xp + rndup);
#line 2802
    return status;
#line 2802
}
#line 2802

int
#line 2803
ncx_pad_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 2803
{
#line 2803
    int status = NC_NOERR;
#line 2803
    size_t rndup = nelems % X_ALIGN;
#line 2803
    uchar *xp = (uchar *) *xpp;
#line 2803

#line 2803
    if (rndup)
#line 2803
        rndup = X_ALIGN - rndup;
#line 2803

#line 2803
    while (nelems-- != 0) {
#line 2803
        
#line 2803
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 2803
    }
#line 2803

#line 2803
    *xpp = (void *)(xp + rndup);
#line 2803
    return status;
#line 2803
}
#line 2803

int
#line 2804
ncx_pad_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2804
{
#line 2804
    int status = NC_NOERR;
#line 2804
    size_t rndup = nelems % X_ALIGN;
#line 2804
    uchar *xp = (uchar *) *xpp;
#line 2804

#line 2804
    if (rndup)
#line 2804
        rndup = X_ALIGN - rndup;
#line 2804

#line 2804
    while (nelems-- != 0) {
#line 2804
        
#line 2804
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 2804
    }
#line 2804

#line 2804
    *xpp = (void *)(xp + rndup);
#line 2804
    return status;
#line 2804
}
#line 2804

int
#line 2805
ncx_pad_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2805
{
#line 2805
    int status = NC_NOERR;
#line 2805
    size_t rndup = nelems % X_ALIGN;
#line 2805
    uchar *xp = (uchar *) *xpp;
#line 2805

#line 2805
    if (rndup)
#line 2805
        rndup = X_ALIGN - rndup;
#line 2805

#line 2805
    while (nelems-- != 0) {
#line 2805
        
#line 2805
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 2805
    }
#line 2805

#line 2805
    *xpp = (void *)(xp + rndup);
#line 2805
    return status;
#line 2805
}
#line 2805

int
#line 2806
ncx_pad_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2806
{
#line 2806
    int status = NC_NOERR;
#line 2806
    size_t rndup = nelems % X_ALIGN;
#line 2806
    uchar *xp = (uchar *) *xpp;
#line 2806

#line 2806
    if (rndup)
#line 2806
        rndup = X_ALIGN - rndup;
#line 2806

#line 2806
    while (nelems-- != 0) {
#line 2806
        
#line 2806
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 2806
    }
#line 2806

#line 2806
    *xpp = (void *)(xp + rndup);
#line 2806
    return status;
#line 2806
}
#line 2806

int
#line 2807
ncx_pad_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2807
{
#line 2807
    int status = NC_NOERR;
#line 2807
    size_t rndup = nelems % X_ALIGN;
#line 2807
    uchar *xp = (uchar *) *xpp;
#line 2807

#line 2807
    if (rndup)
#line 2807
        rndup = X_ALIGN - rndup;
#line 2807

#line 2807
    while (nelems-- != 0) {
#line 2807
        
#line 2807
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 2807
    }
#line 2807

#line 2807
    *xpp = (void *)(xp + rndup);
#line 2807
    return status;
#line 2807
}
#line 2807


#line 2810
int
ncx_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *) *xpp;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 2818
#ifdef ERANGE_FILL
#line 2818
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2818
#endif
            status = NC_ERANGE;
            
#line 2820
#ifdef ERANGE_FILL
#line 2820
            xp++; tp++; continue;
#line 2820
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    *xpp = (void *)xp;
    return status;
}
#line 2829
int
ncx_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2832
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2832

#line 2832
	return NC_NOERR;
#line 2832

}
int
#line 2834
ncx_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2834
{
#line 2834
    int status = NC_NOERR;
#line 2834
    uchar *xp = (uchar *) *xpp;
#line 2834

#line 2834
    while (nelems-- != 0) {
#line 2834
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 2834
            
#line 2834
#ifdef ERANGE_FILL
#line 2834
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2834
#endif
#line 2834
            status = NC_ERANGE;
#line 2834
            
#line 2834
#ifdef ERANGE_FILL
#line 2834
            xp++; tp++; continue;
#line 2834
#endif
#line 2834
        }
#line 2834
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 2834
    }
#line 2834

#line 2834
    *xpp = (void *)xp;
#line 2834
    return status;
#line 2834
}
#line 2834

int
#line 2835
ncx_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2835
{
#line 2835
    int status = NC_NOERR;
#line 2835
    uchar *xp = (uchar *) *xpp;
#line 2835

#line 2835
    while (nelems-- != 0) {
#line 2835
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 2835
            
#line 2835
#ifdef ERANGE_FILL
#line 2835
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2835
#endif
#line 2835
            status = NC_ERANGE;
#line 2835
            
#line 2835
#ifdef ERANGE_FILL
#line 2835
            xp++; tp++; continue;
#line 2835
#endif
#line 2835
        }
#line 2835
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 2835
    }
#line 2835

#line 2835
    *xpp = (void *)xp;
#line 2835
    return status;
#line 2835
}
#line 2835

int
#line 2836
ncx_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2836
{
#line 2836
    int status = NC_NOERR;
#line 2836
    uchar *xp = (uchar *) *xpp;
#line 2836

#line 2836
    while (nelems-- != 0) {
#line 2836
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 2836
            
#line 2836
#ifdef ERANGE_FILL
#line 2836
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2836
#endif
#line 2836
            status = NC_ERANGE;
#line 2836
            
#line 2836
#ifdef ERANGE_FILL
#line 2836
            xp++; tp++; continue;
#line 2836
#endif
#line 2836
        }
#line 2836
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 2836
    }
#line 2836

#line 2836
    *xpp = (void *)xp;
#line 2836
    return status;
#line 2836
}
#line 2836

int
#line 2837
ncx_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2837
{
#line 2837
    int status = NC_NOERR;
#line 2837
    uchar *xp = (uchar *) *xpp;
#line 2837

#line 2837
    while (nelems-- != 0) {
#line 2837
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 2837
            
#line 2837
#ifdef ERANGE_FILL
#line 2837
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2837
#endif
#line 2837
            status = NC_ERANGE;
#line 2837
            
#line 2837
#ifdef ERANGE_FILL
#line 2837
            xp++; tp++; continue;
#line 2837
#endif
#line 2837
        }
#line 2837
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 2837
    }
#line 2837

#line 2837
    *xpp = (void *)xp;
#line 2837
    return status;
#line 2837
}
#line 2837

int
#line 2838
ncx_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2838
{
#line 2838
    int status = NC_NOERR;
#line 2838
    uchar *xp = (uchar *) *xpp;
#line 2838

#line 2838
    while (nelems-- != 0) {
#line 2838
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 2838
            
#line 2838
#ifdef ERANGE_FILL
#line 2838
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2838
#endif
#line 2838
            status = NC_ERANGE;
#line 2838
            
#line 2838
#ifdef ERANGE_FILL
#line 2838
            xp++; tp++; continue;
#line 2838
#endif
#line 2838
        }
#line 2838
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 2838
    }
#line 2838

#line 2838
    *xpp = (void *)xp;
#line 2838
    return status;
#line 2838
}
#line 2838

int
#line 2839
ncx_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2839
{
#line 2839
    int status = NC_NOERR;
#line 2839
    uchar *xp = (uchar *) *xpp;
#line 2839

#line 2839
    while (nelems-- != 0) {
#line 2839
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 2839
            
#line 2839
#ifdef ERANGE_FILL
#line 2839
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2839
#endif
#line 2839
            status = NC_ERANGE;
#line 2839
            
#line 2839
#ifdef ERANGE_FILL
#line 2839
            xp++; tp++; continue;
#line 2839
#endif
#line 2839
        }
#line 2839
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 2839
    }
#line 2839

#line 2839
    *xpp = (void *)xp;
#line 2839
    return status;
#line 2839
}
#line 2839

int
#line 2840
ncx_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2840
{
#line 2840
    int status = NC_NOERR;
#line 2840
    uchar *xp = (uchar *) *xpp;
#line 2840

#line 2840
    while (nelems-- != 0) {
#line 2840
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 2840
            
#line 2840
#ifdef ERANGE_FILL
#line 2840
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2840
#endif
#line 2840
            status = NC_ERANGE;
#line 2840
            
#line 2840
#ifdef ERANGE_FILL
#line 2840
            xp++; tp++; continue;
#line 2840
#endif
#line 2840
        }
#line 2840
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 2840
    }
#line 2840

#line 2840
    *xpp = (void *)xp;
#line 2840
    return status;
#line 2840
}
#line 2840

int
#line 2841
ncx_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2841
{
#line 2841
    int status = NC_NOERR;
#line 2841
    uchar *xp = (uchar *) *xpp;
#line 2841

#line 2841
    while (nelems-- != 0) {
#line 2841
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 2841
            
#line 2841
#ifdef ERANGE_FILL
#line 2841
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2841
#endif
#line 2841
            status = NC_ERANGE;
#line 2841
            
#line 2841
#ifdef ERANGE_FILL
#line 2841
            xp++; tp++; continue;
#line 2841
#endif
#line 2841
        }
#line 2841
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 2841
    }
#line 2841

#line 2841
    *xpp = (void *)xp;
#line 2841
    return status;
#line 2841
}
#line 2841

int
#line 2842
ncx_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2842
{
#line 2842
    int status = NC_NOERR;
#line 2842
    uchar *xp = (uchar *) *xpp;
#line 2842

#line 2842
    while (nelems-- != 0) {
#line 2842
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 2842
            
#line 2842
#ifdef ERANGE_FILL
#line 2842
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2842
#endif
#line 2842
            status = NC_ERANGE;
#line 2842
            
#line 2842
#ifdef ERANGE_FILL
#line 2842
            xp++; tp++; continue;
#line 2842
#endif
#line 2842
        }
#line 2842
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 2842
    }
#line 2842

#line 2842
    *xpp = (void *)xp;
#line 2842
    return status;
#line 2842
}
#line 2842


#line 2845
int
ncx_pad_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 2856
#ifdef ERANGE_FILL
#line 2856
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2856
#endif
            status = NC_ERANGE;
            
#line 2858
#ifdef ERANGE_FILL
#line 2858
            xp++; tp++; continue;
#line 2858
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    if (rndup) {
        (void) memcpy(xp, nada, (size_t)rndup);
        xp += rndup;
    }

    *xpp = (void *)xp;
    return status;
}
#line 2872
int
ncx_pad_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2875

#line 2875
	if (rndup)
#line 2875
		rndup = X_ALIGN - rndup;
#line 2875

#line 2875
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2875
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2875

#line 2875
	if (rndup)
#line 2875
	{
#line 2875
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 2875
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2875
	}
#line 2875

#line 2875
	return NC_NOERR;
#line 2875

}
int
#line 2877
ncx_pad_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2877
{
#line 2877
    int status = NC_NOERR;
#line 2877
    size_t rndup = nelems % X_ALIGN;
#line 2877
    uchar *xp = (uchar *) *xpp;
#line 2877

#line 2877
    if (rndup) rndup = X_ALIGN - rndup;
#line 2877

#line 2877
    while (nelems-- != 0) {
#line 2877
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 2877
            
#line 2877
#ifdef ERANGE_FILL
#line 2877
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2877
#endif
#line 2877
            status = NC_ERANGE;
#line 2877
            
#line 2877
#ifdef ERANGE_FILL
#line 2877
            xp++; tp++; continue;
#line 2877
#endif
#line 2877
        }
#line 2877
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 2877
    }
#line 2877

#line 2877

#line 2877
    if (rndup) {
#line 2877
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2877
        xp += rndup;
#line 2877
    }
#line 2877

#line 2877
    *xpp = (void *)xp;
#line 2877
    return status;
#line 2877
}
#line 2877

int
#line 2878
ncx_pad_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2878
{
#line 2878
    int status = NC_NOERR;
#line 2878
    size_t rndup = nelems % X_ALIGN;
#line 2878
    uchar *xp = (uchar *) *xpp;
#line 2878

#line 2878
    if (rndup) rndup = X_ALIGN - rndup;
#line 2878

#line 2878
    while (nelems-- != 0) {
#line 2878
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 2878
            
#line 2878
#ifdef ERANGE_FILL
#line 2878
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2878
#endif
#line 2878
            status = NC_ERANGE;
#line 2878
            
#line 2878
#ifdef ERANGE_FILL
#line 2878
            xp++; tp++; continue;
#line 2878
#endif
#line 2878
        }
#line 2878
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 2878
    }
#line 2878

#line 2878

#line 2878
    if (rndup) {
#line 2878
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2878
        xp += rndup;
#line 2878
    }
#line 2878

#line 2878
    *xpp = (void *)xp;
#line 2878
    return status;
#line 2878
}
#line 2878

int
#line 2879
ncx_pad_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2879
{
#line 2879
    int status = NC_NOERR;
#line 2879
    size_t rndup = nelems % X_ALIGN;
#line 2879
    uchar *xp = (uchar *) *xpp;
#line 2879

#line 2879
    if (rndup) rndup = X_ALIGN - rndup;
#line 2879

#line 2879
    while (nelems-- != 0) {
#line 2879
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 2879
            
#line 2879
#ifdef ERANGE_FILL
#line 2879
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2879
#endif
#line 2879
            status = NC_ERANGE;
#line 2879
            
#line 2879
#ifdef ERANGE_FILL
#line 2879
            xp++; tp++; continue;
#line 2879
#endif
#line 2879
        }
#line 2879
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 2879
    }
#line 2879

#line 2879

#line 2879
    if (rndup) {
#line 2879
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2879
        xp += rndup;
#line 2879
    }
#line 2879

#line 2879
    *xpp = (void *)xp;
#line 2879
    return status;
#line 2879
}
#line 2879

int
#line 2880
ncx_pad_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2880
{
#line 2880
    int status = NC_NOERR;
#line 2880
    size_t rndup = nelems % X_ALIGN;
#line 2880
    uchar *xp = (uchar *) *xpp;
#line 2880

#line 2880
    if (rndup) rndup = X_ALIGN - rndup;
#line 2880

#line 2880
    while (nelems-- != 0) {
#line 2880
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 2880
            
#line 2880
#ifdef ERANGE_FILL
#line 2880
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2880
#endif
#line 2880
            status = NC_ERANGE;
#line 2880
            
#line 2880
#ifdef ERANGE_FILL
#line 2880
            xp++; tp++; continue;
#line 2880
#endif
#line 2880
        }
#line 2880
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 2880
    }
#line 2880

#line 2880

#line 2880
    if (rndup) {
#line 2880
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2880
        xp += rndup;
#line 2880
    }
#line 2880

#line 2880
    *xpp = (void *)xp;
#line 2880
    return status;
#line 2880
}
#line 2880

int
#line 2881
ncx_pad_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2881
{
#line 2881
    int status = NC_NOERR;
#line 2881
    size_t rndup = nelems % X_ALIGN;
#line 2881
    uchar *xp = (uchar *) *xpp;
#line 2881

#line 2881
    if (rndup) rndup = X_ALIGN - rndup;
#line 2881

#line 2881
    while (nelems-- != 0) {
#line 2881
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 2881
            
#line 2881
#ifdef ERANGE_FILL
#line 2881
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2881
#endif
#line 2881
            status = NC_ERANGE;
#line 2881
            
#line 2881
#ifdef ERANGE_FILL
#line 2881
            xp++; tp++; continue;
#line 2881
#endif
#line 2881
        }
#line 2881
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 2881
    }
#line 2881

#line 2881

#line 2881
    if (rndup) {
#line 2881
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2881
        xp += rndup;
#line 2881
    }
#line 2881

#line 2881
    *xpp = (void *)xp;
#line 2881
    return status;
#line 2881
}
#line 2881

int
#line 2882
ncx_pad_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2882
{
#line 2882
    int status = NC_NOERR;
#line 2882
    size_t rndup = nelems % X_ALIGN;
#line 2882
    uchar *xp = (uchar *) *xpp;
#line 2882

#line 2882
    if (rndup) rndup = X_ALIGN - rndup;
#line 2882

#line 2882
    while (nelems-- != 0) {
#line 2882
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 2882
            
#line 2882
#ifdef ERANGE_FILL
#line 2882
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2882
#endif
#line 2882
            status = NC_ERANGE;
#line 2882
            
#line 2882
#ifdef ERANGE_FILL
#line 2882
            xp++; tp++; continue;
#line 2882
#endif
#line 2882
        }
#line 2882
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 2882
    }
#line 2882

#line 2882

#line 2882
    if (rndup) {
#line 2882
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2882
        xp += rndup;
#line 2882
    }
#line 2882

#line 2882
    *xpp = (void *)xp;
#line 2882
    return status;
#line 2882
}
#line 2882

int
#line 2883
ncx_pad_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2883
{
#line 2883
    int status = NC_NOERR;
#line 2883
    size_t rndup = nelems % X_ALIGN;
#line 2883
    uchar *xp = (uchar *) *xpp;
#line 2883

#line 2883
    if (rndup) rndup = X_ALIGN - rndup;
#line 2883

#line 2883
    while (nelems-- != 0) {
#line 2883
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 2883
            
#line 2883
#ifdef ERANGE_FILL
#line 2883
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2883
#endif
#line 2883
            status = NC_ERANGE;
#line 2883
            
#line 2883
#ifdef ERANGE_FILL
#line 2883
            xp++; tp++; continue;
#line 2883
#endif
#line 2883
        }
#line 2883
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 2883
    }
#line 2883

#line 2883

#line 2883
    if (rndup) {
#line 2883
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2883
        xp += rndup;
#line 2883
    }
#line 2883

#line 2883
    *xpp = (void *)xp;
#line 2883
    return status;
#line 2883
}
#line 2883

int
#line 2884
ncx_pad_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2884
{
#line 2884
    int status = NC_NOERR;
#line 2884
    size_t rndup = nelems % X_ALIGN;
#line 2884
    uchar *xp = (uchar *) *xpp;
#line 2884

#line 2884
    if (rndup) rndup = X_ALIGN - rndup;
#line 2884

#line 2884
    while (nelems-- != 0) {
#line 2884
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 2884
            
#line 2884
#ifdef ERANGE_FILL
#line 2884
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2884
#endif
#line 2884
            status = NC_ERANGE;
#line 2884
            
#line 2884
#ifdef ERANGE_FILL
#line 2884
            xp++; tp++; continue;
#line 2884
#endif
#line 2884
        }
#line 2884
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 2884
    }
#line 2884

#line 2884

#line 2884
    if (rndup) {
#line 2884
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2884
        xp += rndup;
#line 2884
    }
#line 2884

#line 2884
    *xpp = (void *)xp;
#line 2884
    return status;
#line 2884
}
#line 2884

int
#line 2885
ncx_pad_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2885
{
#line 2885
    int status = NC_NOERR;
#line 2885
    size_t rndup = nelems % X_ALIGN;
#line 2885
    uchar *xp = (uchar *) *xpp;
#line 2885

#line 2885
    if (rndup) rndup = X_ALIGN - rndup;
#line 2885

#line 2885
    while (nelems-- != 0) {
#line 2885
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 2885
            
#line 2885
#ifdef ERANGE_FILL
#line 2885
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2885
#endif
#line 2885
            status = NC_ERANGE;
#line 2885
            
#line 2885
#ifdef ERANGE_FILL
#line 2885
            xp++; tp++; continue;
#line 2885
#endif
#line 2885
        }
#line 2885
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 2885
    }
#line 2885

#line 2885

#line 2885
    if (rndup) {
#line 2885
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2885
        xp += rndup;
#line 2885
    }
#line 2885

#line 2885
    *xpp = (void *)xp;
#line 2885
    return status;
#line 2885
}
#line 2885


/* short ---------------------------------------------------------------------*/

#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_SHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 2903
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 2903
{
#line 2903
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2903

#line 2903
 /* basic algorithm is:
#line 2903
  *   - ensure sane alignment of input data
#line 2903
  *   - copy (conversion happens automatically) input data
#line 2903
  *     to output
#line 2903
  *   - update xpp to point at next unconverted input, and tp to point
#line 2903
  *     at next location for converted output
#line 2903
  */
#line 2903
  long i, j, ni;
#line 2903
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2903
  short *xp;
#line 2903
  int nrange = 0;         /* number of range errors */
#line 2903
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2903
  long cxp = (long) *((char**)xpp);
#line 2903

#line 2903
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2903
  /* sjl: manually stripmine so we can limit amount of
#line 2903
   * vector work space reserved to LOOPCNT elements. Also
#line 2903
   * makes vectorisation easy */
#line 2903
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2903
    ni=Min(nelems-j,LOOPCNT);
#line 2903
    if (realign) {
#line 2903
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2903
      xp = tmp;
#line 2903
    } else {
#line 2903
      xp = (short *) *xpp;
#line 2903
    }
#line 2903
   /* copy the next block */
#line 2903
#pragma cdir loopcnt=LOOPCNT
#line 2903
#pragma cdir shortloop
#line 2903
    for (i=0; i<ni; i++) {
#line 2903
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2903
     /* test for range errors (not always needed but do it anyway) */
#line 2903
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2903
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2903
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 2903
    }
#line 2903
   /* update xpp and tp */
#line 2903
    if (realign) xp = (short *) *xpp;
#line 2903
    xp += ni;
#line 2903
    tp += ni;
#line 2903
    *xpp = (void*)xp;
#line 2903
  }
#line 2903
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2903

#line 2903
#else   /* not SX */
#line 2903
	const char *xp = (const char *) *xpp;
#line 2903
	int status = NC_NOERR;
#line 2903

#line 2903
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2903
	{
#line 2903
		const int lstatus = ncx_get_short_short(xp, tp);
#line 2903
		if (status == NC_NOERR) /* report the first encountered error */
#line 2903
			status = lstatus;
#line 2903
	}
#line 2903

#line 2903
	*xpp = (const void *)xp;
#line 2903
	return status;
#line 2903
#endif
#line 2903
}
#line 2903

#endif
int
#line 2905
ncx_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 2905
{
#line 2905
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2905

#line 2905
 /* basic algorithm is:
#line 2905
  *   - ensure sane alignment of input data
#line 2905
  *   - copy (conversion happens automatically) input data
#line 2905
  *     to output
#line 2905
  *   - update xpp to point at next unconverted input, and tp to point
#line 2905
  *     at next location for converted output
#line 2905
  */
#line 2905
  long i, j, ni;
#line 2905
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2905
  short *xp;
#line 2905
  int nrange = 0;         /* number of range errors */
#line 2905
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2905
  long cxp = (long) *((char**)xpp);
#line 2905

#line 2905
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2905
  /* sjl: manually stripmine so we can limit amount of
#line 2905
   * vector work space reserved to LOOPCNT elements. Also
#line 2905
   * makes vectorisation easy */
#line 2905
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2905
    ni=Min(nelems-j,LOOPCNT);
#line 2905
    if (realign) {
#line 2905
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2905
      xp = tmp;
#line 2905
    } else {
#line 2905
      xp = (short *) *xpp;
#line 2905
    }
#line 2905
   /* copy the next block */
#line 2905
#pragma cdir loopcnt=LOOPCNT
#line 2905
#pragma cdir shortloop
#line 2905
    for (i=0; i<ni; i++) {
#line 2905
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2905
     /* test for range errors (not always needed but do it anyway) */
#line 2905
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2905
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2905
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 2905
    }
#line 2905
   /* update xpp and tp */
#line 2905
    if (realign) xp = (short *) *xpp;
#line 2905
    xp += ni;
#line 2905
    tp += ni;
#line 2905
    *xpp = (void*)xp;
#line 2905
  }
#line 2905
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2905

#line 2905
#else   /* not SX */
#line 2905
	const char *xp = (const char *) *xpp;
#line 2905
	int status = NC_NOERR;
#line 2905

#line 2905
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2905
	{
#line 2905
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 2905
		if (status == NC_NOERR) /* report the first encountered error */
#line 2905
			status = lstatus;
#line 2905
	}
#line 2905

#line 2905
	*xpp = (const void *)xp;
#line 2905
	return status;
#line 2905
#endif
#line 2905
}
#line 2905

int
#line 2906
ncx_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 2906
{
#line 2906
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2906

#line 2906
 /* basic algorithm is:
#line 2906
  *   - ensure sane alignment of input data
#line 2906
  *   - copy (conversion happens automatically) input data
#line 2906
  *     to output
#line 2906
  *   - update xpp to point at next unconverted input, and tp to point
#line 2906
  *     at next location for converted output
#line 2906
  */
#line 2906
  long i, j, ni;
#line 2906
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2906
  short *xp;
#line 2906
  int nrange = 0;         /* number of range errors */
#line 2906
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2906
  long cxp = (long) *((char**)xpp);
#line 2906

#line 2906
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2906
  /* sjl: manually stripmine so we can limit amount of
#line 2906
   * vector work space reserved to LOOPCNT elements. Also
#line 2906
   * makes vectorisation easy */
#line 2906
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2906
    ni=Min(nelems-j,LOOPCNT);
#line 2906
    if (realign) {
#line 2906
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2906
      xp = tmp;
#line 2906
    } else {
#line 2906
      xp = (short *) *xpp;
#line 2906
    }
#line 2906
   /* copy the next block */
#line 2906
#pragma cdir loopcnt=LOOPCNT
#line 2906
#pragma cdir shortloop
#line 2906
    for (i=0; i<ni; i++) {
#line 2906
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2906
     /* test for range errors (not always needed but do it anyway) */
#line 2906
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2906
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2906
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 2906
    }
#line 2906
   /* update xpp and tp */
#line 2906
    if (realign) xp = (short *) *xpp;
#line 2906
    xp += ni;
#line 2906
    tp += ni;
#line 2906
    *xpp = (void*)xp;
#line 2906
  }
#line 2906
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2906

#line 2906
#else   /* not SX */
#line 2906
	const char *xp = (const char *) *xpp;
#line 2906
	int status = NC_NOERR;
#line 2906

#line 2906
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2906
	{
#line 2906
		const int lstatus = ncx_get_short_int(xp, tp);
#line 2906
		if (status == NC_NOERR) /* report the first encountered error */
#line 2906
			status = lstatus;
#line 2906
	}
#line 2906

#line 2906
	*xpp = (const void *)xp;
#line 2906
	return status;
#line 2906
#endif
#line 2906
}
#line 2906

int
#line 2907
ncx_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 2907
{
#line 2907
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2907

#line 2907
 /* basic algorithm is:
#line 2907
  *   - ensure sane alignment of input data
#line 2907
  *   - copy (conversion happens automatically) input data
#line 2907
  *     to output
#line 2907
  *   - update xpp to point at next unconverted input, and tp to point
#line 2907
  *     at next location for converted output
#line 2907
  */
#line 2907
  long i, j, ni;
#line 2907
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2907
  short *xp;
#line 2907
  int nrange = 0;         /* number of range errors */
#line 2907
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2907
  long cxp = (long) *((char**)xpp);
#line 2907

#line 2907
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2907
  /* sjl: manually stripmine so we can limit amount of
#line 2907
   * vector work space reserved to LOOPCNT elements. Also
#line 2907
   * makes vectorisation easy */
#line 2907
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2907
    ni=Min(nelems-j,LOOPCNT);
#line 2907
    if (realign) {
#line 2907
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2907
      xp = tmp;
#line 2907
    } else {
#line 2907
      xp = (short *) *xpp;
#line 2907
    }
#line 2907
   /* copy the next block */
#line 2907
#pragma cdir loopcnt=LOOPCNT
#line 2907
#pragma cdir shortloop
#line 2907
    for (i=0; i<ni; i++) {
#line 2907
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 2907
     /* test for range errors (not always needed but do it anyway) */
#line 2907
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2907
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2907
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 2907
    }
#line 2907
   /* update xpp and tp */
#line 2907
    if (realign) xp = (short *) *xpp;
#line 2907
    xp += ni;
#line 2907
    tp += ni;
#line 2907
    *xpp = (void*)xp;
#line 2907
  }
#line 2907
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2907

#line 2907
#else   /* not SX */
#line 2907
	const char *xp = (const char *) *xpp;
#line 2907
	int status = NC_NOERR;
#line 2907

#line 2907
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2907
	{
#line 2907
		const int lstatus = ncx_get_short_long(xp, tp);
#line 2907
		if (status == NC_NOERR) /* report the first encountered error */
#line 2907
			status = lstatus;
#line 2907
	}
#line 2907

#line 2907
	*xpp = (const void *)xp;
#line 2907
	return status;
#line 2907
#endif
#line 2907
}
#line 2907

int
#line 2908
ncx_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 2908
{
#line 2908
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2908

#line 2908
 /* basic algorithm is:
#line 2908
  *   - ensure sane alignment of input data
#line 2908
  *   - copy (conversion happens automatically) input data
#line 2908
  *     to output
#line 2908
  *   - update xpp to point at next unconverted input, and tp to point
#line 2908
  *     at next location for converted output
#line 2908
  */
#line 2908
  long i, j, ni;
#line 2908
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2908
  short *xp;
#line 2908
  int nrange = 0;         /* number of range errors */
#line 2908
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2908
  long cxp = (long) *((char**)xpp);
#line 2908

#line 2908
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2908
  /* sjl: manually stripmine so we can limit amount of
#line 2908
   * vector work space reserved to LOOPCNT elements. Also
#line 2908
   * makes vectorisation easy */
#line 2908
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2908
    ni=Min(nelems-j,LOOPCNT);
#line 2908
    if (realign) {
#line 2908
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2908
      xp = tmp;
#line 2908
    } else {
#line 2908
      xp = (short *) *xpp;
#line 2908
    }
#line 2908
   /* copy the next block */
#line 2908
#pragma cdir loopcnt=LOOPCNT
#line 2908
#pragma cdir shortloop
#line 2908
    for (i=0; i<ni; i++) {
#line 2908
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2908
     /* test for range errors (not always needed but do it anyway) */
#line 2908
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2908
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2908
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 2908
    }
#line 2908
   /* update xpp and tp */
#line 2908
    if (realign) xp = (short *) *xpp;
#line 2908
    xp += ni;
#line 2908
    tp += ni;
#line 2908
    *xpp = (void*)xp;
#line 2908
  }
#line 2908
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2908

#line 2908
#else   /* not SX */
#line 2908
	const char *xp = (const char *) *xpp;
#line 2908
	int status = NC_NOERR;
#line 2908

#line 2908
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2908
	{
#line 2908
		const int lstatus = ncx_get_short_float(xp, tp);
#line 2908
		if (status == NC_NOERR) /* report the first encountered error */
#line 2908
			status = lstatus;
#line 2908
	}
#line 2908

#line 2908
	*xpp = (const void *)xp;
#line 2908
	return status;
#line 2908
#endif
#line 2908
}
#line 2908

int
#line 2909
ncx_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 2909
{
#line 2909
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2909

#line 2909
 /* basic algorithm is:
#line 2909
  *   - ensure sane alignment of input data
#line 2909
  *   - copy (conversion happens automatically) input data
#line 2909
  *     to output
#line 2909
  *   - update xpp to point at next unconverted input, and tp to point
#line 2909
  *     at next location for converted output
#line 2909
  */
#line 2909
  long i, j, ni;
#line 2909
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2909
  short *xp;
#line 2909
  int nrange = 0;         /* number of range errors */
#line 2909
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2909
  long cxp = (long) *((char**)xpp);
#line 2909

#line 2909
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2909
  /* sjl: manually stripmine so we can limit amount of
#line 2909
   * vector work space reserved to LOOPCNT elements. Also
#line 2909
   * makes vectorisation easy */
#line 2909
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2909
    ni=Min(nelems-j,LOOPCNT);
#line 2909
    if (realign) {
#line 2909
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2909
      xp = tmp;
#line 2909
    } else {
#line 2909
      xp = (short *) *xpp;
#line 2909
    }
#line 2909
   /* copy the next block */
#line 2909
#pragma cdir loopcnt=LOOPCNT
#line 2909
#pragma cdir shortloop
#line 2909
    for (i=0; i<ni; i++) {
#line 2909
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2909
     /* test for range errors (not always needed but do it anyway) */
#line 2909
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2909
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2909
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 2909
    }
#line 2909
   /* update xpp and tp */
#line 2909
    if (realign) xp = (short *) *xpp;
#line 2909
    xp += ni;
#line 2909
    tp += ni;
#line 2909
    *xpp = (void*)xp;
#line 2909
  }
#line 2909
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2909

#line 2909
#else   /* not SX */
#line 2909
	const char *xp = (const char *) *xpp;
#line 2909
	int status = NC_NOERR;
#line 2909

#line 2909
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2909
	{
#line 2909
		const int lstatus = ncx_get_short_double(xp, tp);
#line 2909
		if (status == NC_NOERR) /* report the first encountered error */
#line 2909
			status = lstatus;
#line 2909
	}
#line 2909

#line 2909
	*xpp = (const void *)xp;
#line 2909
	return status;
#line 2909
#endif
#line 2909
}
#line 2909

int
#line 2910
ncx_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2910
{
#line 2910
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2910

#line 2910
 /* basic algorithm is:
#line 2910
  *   - ensure sane alignment of input data
#line 2910
  *   - copy (conversion happens automatically) input data
#line 2910
  *     to output
#line 2910
  *   - update xpp to point at next unconverted input, and tp to point
#line 2910
  *     at next location for converted output
#line 2910
  */
#line 2910
  long i, j, ni;
#line 2910
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2910
  short *xp;
#line 2910
  int nrange = 0;         /* number of range errors */
#line 2910
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2910
  long cxp = (long) *((char**)xpp);
#line 2910

#line 2910
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2910
  /* sjl: manually stripmine so we can limit amount of
#line 2910
   * vector work space reserved to LOOPCNT elements. Also
#line 2910
   * makes vectorisation easy */
#line 2910
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2910
    ni=Min(nelems-j,LOOPCNT);
#line 2910
    if (realign) {
#line 2910
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2910
      xp = tmp;
#line 2910
    } else {
#line 2910
      xp = (short *) *xpp;
#line 2910
    }
#line 2910
   /* copy the next block */
#line 2910
#pragma cdir loopcnt=LOOPCNT
#line 2910
#pragma cdir shortloop
#line 2910
    for (i=0; i<ni; i++) {
#line 2910
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2910
     /* test for range errors (not always needed but do it anyway) */
#line 2910
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2910
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2910
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 2910
    }
#line 2910
   /* update xpp and tp */
#line 2910
    if (realign) xp = (short *) *xpp;
#line 2910
    xp += ni;
#line 2910
    tp += ni;
#line 2910
    *xpp = (void*)xp;
#line 2910
  }
#line 2910
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2910

#line 2910
#else   /* not SX */
#line 2910
	const char *xp = (const char *) *xpp;
#line 2910
	int status = NC_NOERR;
#line 2910

#line 2910
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2910
	{
#line 2910
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 2910
		if (status == NC_NOERR) /* report the first encountered error */
#line 2910
			status = lstatus;
#line 2910
	}
#line 2910

#line 2910
	*xpp = (const void *)xp;
#line 2910
	return status;
#line 2910
#endif
#line 2910
}
#line 2910

int
#line 2911
ncx_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2911
{
#line 2911
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2911

#line 2911
 /* basic algorithm is:
#line 2911
  *   - ensure sane alignment of input data
#line 2911
  *   - copy (conversion happens automatically) input data
#line 2911
  *     to output
#line 2911
  *   - update xpp to point at next unconverted input, and tp to point
#line 2911
  *     at next location for converted output
#line 2911
  */
#line 2911
  long i, j, ni;
#line 2911
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2911
  short *xp;
#line 2911
  int nrange = 0;         /* number of range errors */
#line 2911
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2911
  long cxp = (long) *((char**)xpp);
#line 2911

#line 2911
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2911
  /* sjl: manually stripmine so we can limit amount of
#line 2911
   * vector work space reserved to LOOPCNT elements. Also
#line 2911
   * makes vectorisation easy */
#line 2911
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2911
    ni=Min(nelems-j,LOOPCNT);
#line 2911
    if (realign) {
#line 2911
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2911
      xp = tmp;
#line 2911
    } else {
#line 2911
      xp = (short *) *xpp;
#line 2911
    }
#line 2911
   /* copy the next block */
#line 2911
#pragma cdir loopcnt=LOOPCNT
#line 2911
#pragma cdir shortloop
#line 2911
    for (i=0; i<ni; i++) {
#line 2911
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2911
     /* test for range errors (not always needed but do it anyway) */
#line 2911
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2911
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2911
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 2911
    }
#line 2911
   /* update xpp and tp */
#line 2911
    if (realign) xp = (short *) *xpp;
#line 2911
    xp += ni;
#line 2911
    tp += ni;
#line 2911
    *xpp = (void*)xp;
#line 2911
  }
#line 2911
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2911

#line 2911
#else   /* not SX */
#line 2911
	const char *xp = (const char *) *xpp;
#line 2911
	int status = NC_NOERR;
#line 2911

#line 2911
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2911
	{
#line 2911
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 2911
		if (status == NC_NOERR) /* report the first encountered error */
#line 2911
			status = lstatus;
#line 2911
	}
#line 2911

#line 2911
	*xpp = (const void *)xp;
#line 2911
	return status;
#line 2911
#endif
#line 2911
}
#line 2911

int
#line 2912
ncx_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2912
{
#line 2912
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2912

#line 2912
 /* basic algorithm is:
#line 2912
  *   - ensure sane alignment of input data
#line 2912
  *   - copy (conversion happens automatically) input data
#line 2912
  *     to output
#line 2912
  *   - update xpp to point at next unconverted input, and tp to point
#line 2912
  *     at next location for converted output
#line 2912
  */
#line 2912
  long i, j, ni;
#line 2912
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2912
  short *xp;
#line 2912
  int nrange = 0;         /* number of range errors */
#line 2912
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2912
  long cxp = (long) *((char**)xpp);
#line 2912

#line 2912
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2912
  /* sjl: manually stripmine so we can limit amount of
#line 2912
   * vector work space reserved to LOOPCNT elements. Also
#line 2912
   * makes vectorisation easy */
#line 2912
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2912
    ni=Min(nelems-j,LOOPCNT);
#line 2912
    if (realign) {
#line 2912
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2912
      xp = tmp;
#line 2912
    } else {
#line 2912
      xp = (short *) *xpp;
#line 2912
    }
#line 2912
   /* copy the next block */
#line 2912
#pragma cdir loopcnt=LOOPCNT
#line 2912
#pragma cdir shortloop
#line 2912
    for (i=0; i<ni; i++) {
#line 2912
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 2912
     /* test for range errors (not always needed but do it anyway) */
#line 2912
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2912
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2912
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 2912
    }
#line 2912
   /* update xpp and tp */
#line 2912
    if (realign) xp = (short *) *xpp;
#line 2912
    xp += ni;
#line 2912
    tp += ni;
#line 2912
    *xpp = (void*)xp;
#line 2912
  }
#line 2912
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2912

#line 2912
#else   /* not SX */
#line 2912
	const char *xp = (const char *) *xpp;
#line 2912
	int status = NC_NOERR;
#line 2912

#line 2912
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2912
	{
#line 2912
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 2912
		if (status == NC_NOERR) /* report the first encountered error */
#line 2912
			status = lstatus;
#line 2912
	}
#line 2912

#line 2912
	*xpp = (const void *)xp;
#line 2912
	return status;
#line 2912
#endif
#line 2912
}
#line 2912

int
#line 2913
ncx_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 2913
{
#line 2913
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2913

#line 2913
 /* basic algorithm is:
#line 2913
  *   - ensure sane alignment of input data
#line 2913
  *   - copy (conversion happens automatically) input data
#line 2913
  *     to output
#line 2913
  *   - update xpp to point at next unconverted input, and tp to point
#line 2913
  *     at next location for converted output
#line 2913
  */
#line 2913
  long i, j, ni;
#line 2913
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2913
  short *xp;
#line 2913
  int nrange = 0;         /* number of range errors */
#line 2913
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2913
  long cxp = (long) *((char**)xpp);
#line 2913

#line 2913
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2913
  /* sjl: manually stripmine so we can limit amount of
#line 2913
   * vector work space reserved to LOOPCNT elements. Also
#line 2913
   * makes vectorisation easy */
#line 2913
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2913
    ni=Min(nelems-j,LOOPCNT);
#line 2913
    if (realign) {
#line 2913
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2913
      xp = tmp;
#line 2913
    } else {
#line 2913
      xp = (short *) *xpp;
#line 2913
    }
#line 2913
   /* copy the next block */
#line 2913
#pragma cdir loopcnt=LOOPCNT
#line 2913
#pragma cdir shortloop
#line 2913
    for (i=0; i<ni; i++) {
#line 2913
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2913
     /* test for range errors (not always needed but do it anyway) */
#line 2913
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2913
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2913
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 2913
    }
#line 2913
   /* update xpp and tp */
#line 2913
    if (realign) xp = (short *) *xpp;
#line 2913
    xp += ni;
#line 2913
    tp += ni;
#line 2913
    *xpp = (void*)xp;
#line 2913
  }
#line 2913
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2913

#line 2913
#else   /* not SX */
#line 2913
	const char *xp = (const char *) *xpp;
#line 2913
	int status = NC_NOERR;
#line 2913

#line 2913
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2913
	{
#line 2913
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 2913
		if (status == NC_NOERR) /* report the first encountered error */
#line 2913
			status = lstatus;
#line 2913
	}
#line 2913

#line 2913
	*xpp = (const void *)xp;
#line 2913
	return status;
#line 2913
#endif
#line 2913
}
#line 2913

int
#line 2914
ncx_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2914
{
#line 2914
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2914

#line 2914
 /* basic algorithm is:
#line 2914
  *   - ensure sane alignment of input data
#line 2914
  *   - copy (conversion happens automatically) input data
#line 2914
  *     to output
#line 2914
  *   - update xpp to point at next unconverted input, and tp to point
#line 2914
  *     at next location for converted output
#line 2914
  */
#line 2914
  long i, j, ni;
#line 2914
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2914
  short *xp;
#line 2914
  int nrange = 0;         /* number of range errors */
#line 2914
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2914
  long cxp = (long) *((char**)xpp);
#line 2914

#line 2914
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2914
  /* sjl: manually stripmine so we can limit amount of
#line 2914
   * vector work space reserved to LOOPCNT elements. Also
#line 2914
   * makes vectorisation easy */
#line 2914
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2914
    ni=Min(nelems-j,LOOPCNT);
#line 2914
    if (realign) {
#line 2914
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2914
      xp = tmp;
#line 2914
    } else {
#line 2914
      xp = (short *) *xpp;
#line 2914
    }
#line 2914
   /* copy the next block */
#line 2914
#pragma cdir loopcnt=LOOPCNT
#line 2914
#pragma cdir shortloop
#line 2914
    for (i=0; i<ni; i++) {
#line 2914
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2914
     /* test for range errors (not always needed but do it anyway) */
#line 2914
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2914
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2914
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 2914
    }
#line 2914
   /* update xpp and tp */
#line 2914
    if (realign) xp = (short *) *xpp;
#line 2914
    xp += ni;
#line 2914
    tp += ni;
#line 2914
    *xpp = (void*)xp;
#line 2914
  }
#line 2914
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2914

#line 2914
#else   /* not SX */
#line 2914
	const char *xp = (const char *) *xpp;
#line 2914
	int status = NC_NOERR;
#line 2914

#line 2914
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2914
	{
#line 2914
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 2914
		if (status == NC_NOERR) /* report the first encountered error */
#line 2914
			status = lstatus;
#line 2914
	}
#line 2914

#line 2914
	*xpp = (const void *)xp;
#line 2914
	return status;
#line 2914
#endif
#line 2914
}
#line 2914


int
#line 2916
ncx_pad_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 2916
{
#line 2916
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2916

#line 2916
	const char *xp = (const char *) *xpp;
#line 2916
	int status = NC_NOERR;
#line 2916

#line 2916
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2916
	{
#line 2916
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 2916
		if (status == NC_NOERR) /* report the first encountered error */
#line 2916
			status = lstatus;
#line 2916
	}
#line 2916

#line 2916
	if (rndup != 0)
#line 2916
		xp += X_SIZEOF_SHORT;
#line 2916

#line 2916
	*xpp = (void *)xp;
#line 2916
	return status;
#line 2916
}
#line 2916

int
#line 2917
ncx_pad_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2917
{
#line 2917
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2917

#line 2917
	const char *xp = (const char *) *xpp;
#line 2917
	int status = NC_NOERR;
#line 2917

#line 2917
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2917
	{
#line 2917
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 2917
		if (status == NC_NOERR) /* report the first encountered error */
#line 2917
			status = lstatus;
#line 2917
	}
#line 2917

#line 2917
	if (rndup != 0)
#line 2917
		xp += X_SIZEOF_SHORT;
#line 2917

#line 2917
	*xpp = (void *)xp;
#line 2917
	return status;
#line 2917
}
#line 2917

int
#line 2918
ncx_pad_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 2918
{
#line 2918
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2918

#line 2918
	const char *xp = (const char *) *xpp;
#line 2918
	int status = NC_NOERR;
#line 2918

#line 2918
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2918
	{
#line 2918
		const int lstatus = ncx_get_short_short(xp, tp);
#line 2918
		if (status == NC_NOERR) /* report the first encountered error */
#line 2918
			status = lstatus;
#line 2918
	}
#line 2918

#line 2918
	if (rndup != 0)
#line 2918
		xp += X_SIZEOF_SHORT;
#line 2918

#line 2918
	*xpp = (void *)xp;
#line 2918
	return status;
#line 2918
}
#line 2918

int
#line 2919
ncx_pad_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 2919
{
#line 2919
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2919

#line 2919
	const char *xp = (const char *) *xpp;
#line 2919
	int status = NC_NOERR;
#line 2919

#line 2919
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2919
	{
#line 2919
		const int lstatus = ncx_get_short_int(xp, tp);
#line 2919
		if (status == NC_NOERR) /* report the first encountered error */
#line 2919
			status = lstatus;
#line 2919
	}
#line 2919

#line 2919
	if (rndup != 0)
#line 2919
		xp += X_SIZEOF_SHORT;
#line 2919

#line 2919
	*xpp = (void *)xp;
#line 2919
	return status;
#line 2919
}
#line 2919

int
#line 2920
ncx_pad_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 2920
{
#line 2920
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2920

#line 2920
	const char *xp = (const char *) *xpp;
#line 2920
	int status = NC_NOERR;
#line 2920

#line 2920
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2920
	{
#line 2920
		const int lstatus = ncx_get_short_long(xp, tp);
#line 2920
		if (status == NC_NOERR) /* report the first encountered error */
#line 2920
			status = lstatus;
#line 2920
	}
#line 2920

#line 2920
	if (rndup != 0)
#line 2920
		xp += X_SIZEOF_SHORT;
#line 2920

#line 2920
	*xpp = (void *)xp;
#line 2920
	return status;
#line 2920
}
#line 2920

int
#line 2921
ncx_pad_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 2921
{
#line 2921
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2921

#line 2921
	const char *xp = (const char *) *xpp;
#line 2921
	int status = NC_NOERR;
#line 2921

#line 2921
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2921
	{
#line 2921
		const int lstatus = ncx_get_short_float(xp, tp);
#line 2921
		if (status == NC_NOERR) /* report the first encountered error */
#line 2921
			status = lstatus;
#line 2921
	}
#line 2921

#line 2921
	if (rndup != 0)
#line 2921
		xp += X_SIZEOF_SHORT;
#line 2921

#line 2921
	*xpp = (void *)xp;
#line 2921
	return status;
#line 2921
}
#line 2921

int
#line 2922
ncx_pad_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 2922
{
#line 2922
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2922

#line 2922
	const char *xp = (const char *) *xpp;
#line 2922
	int status = NC_NOERR;
#line 2922

#line 2922
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2922
	{
#line 2922
		const int lstatus = ncx_get_short_double(xp, tp);
#line 2922
		if (status == NC_NOERR) /* report the first encountered error */
#line 2922
			status = lstatus;
#line 2922
	}
#line 2922

#line 2922
	if (rndup != 0)
#line 2922
		xp += X_SIZEOF_SHORT;
#line 2922

#line 2922
	*xpp = (void *)xp;
#line 2922
	return status;
#line 2922
}
#line 2922

int
#line 2923
ncx_pad_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 2923
{
#line 2923
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2923

#line 2923
	const char *xp = (const char *) *xpp;
#line 2923
	int status = NC_NOERR;
#line 2923

#line 2923
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2923
	{
#line 2923
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 2923
		if (status == NC_NOERR) /* report the first encountered error */
#line 2923
			status = lstatus;
#line 2923
	}
#line 2923

#line 2923
	if (rndup != 0)
#line 2923
		xp += X_SIZEOF_SHORT;
#line 2923

#line 2923
	*xpp = (void *)xp;
#line 2923
	return status;
#line 2923
}
#line 2923

int
#line 2924
ncx_pad_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2924
{
#line 2924
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2924

#line 2924
	const char *xp = (const char *) *xpp;
#line 2924
	int status = NC_NOERR;
#line 2924

#line 2924
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2924
	{
#line 2924
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 2924
		if (status == NC_NOERR) /* report the first encountered error */
#line 2924
			status = lstatus;
#line 2924
	}
#line 2924

#line 2924
	if (rndup != 0)
#line 2924
		xp += X_SIZEOF_SHORT;
#line 2924

#line 2924
	*xpp = (void *)xp;
#line 2924
	return status;
#line 2924
}
#line 2924

int
#line 2925
ncx_pad_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2925
{
#line 2925
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2925

#line 2925
	const char *xp = (const char *) *xpp;
#line 2925
	int status = NC_NOERR;
#line 2925

#line 2925
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2925
	{
#line 2925
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 2925
		if (status == NC_NOERR) /* report the first encountered error */
#line 2925
			status = lstatus;
#line 2925
	}
#line 2925

#line 2925
	if (rndup != 0)
#line 2925
		xp += X_SIZEOF_SHORT;
#line 2925

#line 2925
	*xpp = (void *)xp;
#line 2925
	return status;
#line 2925
}
#line 2925

int
#line 2926
ncx_pad_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2926
{
#line 2926
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2926

#line 2926
	const char *xp = (const char *) *xpp;
#line 2926
	int status = NC_NOERR;
#line 2926

#line 2926
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2926
	{
#line 2926
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 2926
		if (status == NC_NOERR) /* report the first encountered error */
#line 2926
			status = lstatus;
#line 2926
	}
#line 2926

#line 2926
	if (rndup != 0)
#line 2926
		xp += X_SIZEOF_SHORT;
#line 2926

#line 2926
	*xpp = (void *)xp;
#line 2926
	return status;
#line 2926
}
#line 2926


#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_SHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 2942
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2942
{
#line 2942
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2942

#line 2942
 /* basic algorithm is:
#line 2942
  *   - ensure sane alignment of output data
#line 2942
  *   - copy (conversion happens automatically) input data
#line 2942
  *     to output
#line 2942
  *   - update tp to point at next unconverted input, and xpp to point
#line 2942
  *     at next location for converted output
#line 2942
  */
#line 2942
  long i, j, ni;
#line 2942
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2942
  short *xp;
#line 2942
  int nrange = 0;         /* number of range errors */
#line 2942
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2942
  long cxp = (long) *((char**)xpp);
#line 2942

#line 2942
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2942
  /* sjl: manually stripmine so we can limit amount of
#line 2942
   * vector work space reserved to LOOPCNT elements. Also
#line 2942
   * makes vectorisation easy */
#line 2942
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2942
    ni=Min(nelems-j,LOOPCNT);
#line 2942
    if (realign) {
#line 2942
      xp = tmp;
#line 2942
    } else {
#line 2942
      xp = (short *) *xpp;
#line 2942
    }
#line 2942
   /* copy the next block */
#line 2942
#pragma cdir loopcnt=LOOPCNT
#line 2942
#pragma cdir shortloop
#line 2942
    for (i=0; i<ni; i++) {
#line 2942
      /* the normal case: */
#line 2942
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2942
     /* test for range errors (not always needed but do it anyway) */
#line 2942
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2942
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2942
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2942
    }
#line 2942
   /* copy workspace back if necessary */
#line 2942
    if (realign) {
#line 2942
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2942
      xp = (short *) *xpp;
#line 2942
    }
#line 2942
   /* update xpp and tp */
#line 2942
    xp += ni;
#line 2942
    tp += ni;
#line 2942
    *xpp = (void*)xp;
#line 2942
  }
#line 2942
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2942

#line 2942
#else   /* not SX */
#line 2942

#line 2942
	char *xp = (char *) *xpp;
#line 2942
	int status = NC_NOERR;
#line 2942

#line 2942
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2942
	{
#line 2942
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 2942
		if (status == NC_NOERR) /* report the first encountered error */
#line 2942
			status = lstatus;
#line 2942
	}
#line 2942

#line 2942
	*xpp = (void *)xp;
#line 2942
	return status;
#line 2942
#endif
#line 2942
}
#line 2942

#endif
int
#line 2944
ncx_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 2944
{
#line 2944
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2944

#line 2944
 /* basic algorithm is:
#line 2944
  *   - ensure sane alignment of output data
#line 2944
  *   - copy (conversion happens automatically) input data
#line 2944
  *     to output
#line 2944
  *   - update tp to point at next unconverted input, and xpp to point
#line 2944
  *     at next location for converted output
#line 2944
  */
#line 2944
  long i, j, ni;
#line 2944
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2944
  short *xp;
#line 2944
  int nrange = 0;         /* number of range errors */
#line 2944
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2944
  long cxp = (long) *((char**)xpp);
#line 2944

#line 2944
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2944
  /* sjl: manually stripmine so we can limit amount of
#line 2944
   * vector work space reserved to LOOPCNT elements. Also
#line 2944
   * makes vectorisation easy */
#line 2944
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2944
    ni=Min(nelems-j,LOOPCNT);
#line 2944
    if (realign) {
#line 2944
      xp = tmp;
#line 2944
    } else {
#line 2944
      xp = (short *) *xpp;
#line 2944
    }
#line 2944
   /* copy the next block */
#line 2944
#pragma cdir loopcnt=LOOPCNT
#line 2944
#pragma cdir shortloop
#line 2944
    for (i=0; i<ni; i++) {
#line 2944
      /* the normal case: */
#line 2944
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2944
     /* test for range errors (not always needed but do it anyway) */
#line 2944
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2944
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2944
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2944
    }
#line 2944
   /* copy workspace back if necessary */
#line 2944
    if (realign) {
#line 2944
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2944
      xp = (short *) *xpp;
#line 2944
    }
#line 2944
   /* update xpp and tp */
#line 2944
    xp += ni;
#line 2944
    tp += ni;
#line 2944
    *xpp = (void*)xp;
#line 2944
  }
#line 2944
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2944

#line 2944
#else   /* not SX */
#line 2944

#line 2944
	char *xp = (char *) *xpp;
#line 2944
	int status = NC_NOERR;
#line 2944

#line 2944
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2944
	{
#line 2944
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 2944
		if (status == NC_NOERR) /* report the first encountered error */
#line 2944
			status = lstatus;
#line 2944
	}
#line 2944

#line 2944
	*xpp = (void *)xp;
#line 2944
	return status;
#line 2944
#endif
#line 2944
}
#line 2944

int
#line 2945
ncx_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2945
{
#line 2945
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2945

#line 2945
 /* basic algorithm is:
#line 2945
  *   - ensure sane alignment of output data
#line 2945
  *   - copy (conversion happens automatically) input data
#line 2945
  *     to output
#line 2945
  *   - update tp to point at next unconverted input, and xpp to point
#line 2945
  *     at next location for converted output
#line 2945
  */
#line 2945
  long i, j, ni;
#line 2945
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2945
  short *xp;
#line 2945
  int nrange = 0;         /* number of range errors */
#line 2945
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2945
  long cxp = (long) *((char**)xpp);
#line 2945

#line 2945
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2945
  /* sjl: manually stripmine so we can limit amount of
#line 2945
   * vector work space reserved to LOOPCNT elements. Also
#line 2945
   * makes vectorisation easy */
#line 2945
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2945
    ni=Min(nelems-j,LOOPCNT);
#line 2945
    if (realign) {
#line 2945
      xp = tmp;
#line 2945
    } else {
#line 2945
      xp = (short *) *xpp;
#line 2945
    }
#line 2945
   /* copy the next block */
#line 2945
#pragma cdir loopcnt=LOOPCNT
#line 2945
#pragma cdir shortloop
#line 2945
    for (i=0; i<ni; i++) {
#line 2945
      /* the normal case: */
#line 2945
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2945
     /* test for range errors (not always needed but do it anyway) */
#line 2945
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2945
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2945
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2945
    }
#line 2945
   /* copy workspace back if necessary */
#line 2945
    if (realign) {
#line 2945
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2945
      xp = (short *) *xpp;
#line 2945
    }
#line 2945
   /* update xpp and tp */
#line 2945
    xp += ni;
#line 2945
    tp += ni;
#line 2945
    *xpp = (void*)xp;
#line 2945
  }
#line 2945
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2945

#line 2945
#else   /* not SX */
#line 2945

#line 2945
	char *xp = (char *) *xpp;
#line 2945
	int status = NC_NOERR;
#line 2945

#line 2945
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2945
	{
#line 2945
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 2945
		if (status == NC_NOERR) /* report the first encountered error */
#line 2945
			status = lstatus;
#line 2945
	}
#line 2945

#line 2945
	*xpp = (void *)xp;
#line 2945
	return status;
#line 2945
#endif
#line 2945
}
#line 2945

int
#line 2946
ncx_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2946
{
#line 2946
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2946

#line 2946
 /* basic algorithm is:
#line 2946
  *   - ensure sane alignment of output data
#line 2946
  *   - copy (conversion happens automatically) input data
#line 2946
  *     to output
#line 2946
  *   - update tp to point at next unconverted input, and xpp to point
#line 2946
  *     at next location for converted output
#line 2946
  */
#line 2946
  long i, j, ni;
#line 2946
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2946
  short *xp;
#line 2946
  int nrange = 0;         /* number of range errors */
#line 2946
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2946
  long cxp = (long) *((char**)xpp);
#line 2946

#line 2946
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2946
  /* sjl: manually stripmine so we can limit amount of
#line 2946
   * vector work space reserved to LOOPCNT elements. Also
#line 2946
   * makes vectorisation easy */
#line 2946
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2946
    ni=Min(nelems-j,LOOPCNT);
#line 2946
    if (realign) {
#line 2946
      xp = tmp;
#line 2946
    } else {
#line 2946
      xp = (short *) *xpp;
#line 2946
    }
#line 2946
   /* copy the next block */
#line 2946
#pragma cdir loopcnt=LOOPCNT
#line 2946
#pragma cdir shortloop
#line 2946
    for (i=0; i<ni; i++) {
#line 2946
      /* the normal case: */
#line 2946
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2946
     /* test for range errors (not always needed but do it anyway) */
#line 2946
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2946
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2946
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2946
    }
#line 2946
   /* copy workspace back if necessary */
#line 2946
    if (realign) {
#line 2946
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2946
      xp = (short *) *xpp;
#line 2946
    }
#line 2946
   /* update xpp and tp */
#line 2946
    xp += ni;
#line 2946
    tp += ni;
#line 2946
    *xpp = (void*)xp;
#line 2946
  }
#line 2946
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2946

#line 2946
#else   /* not SX */
#line 2946

#line 2946
	char *xp = (char *) *xpp;
#line 2946
	int status = NC_NOERR;
#line 2946

#line 2946
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2946
	{
#line 2946
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 2946
		if (status == NC_NOERR) /* report the first encountered error */
#line 2946
			status = lstatus;
#line 2946
	}
#line 2946

#line 2946
	*xpp = (void *)xp;
#line 2946
	return status;
#line 2946
#endif
#line 2946
}
#line 2946

int
#line 2947
ncx_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2947
{
#line 2947
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2947

#line 2947
 /* basic algorithm is:
#line 2947
  *   - ensure sane alignment of output data
#line 2947
  *   - copy (conversion happens automatically) input data
#line 2947
  *     to output
#line 2947
  *   - update tp to point at next unconverted input, and xpp to point
#line 2947
  *     at next location for converted output
#line 2947
  */
#line 2947
  long i, j, ni;
#line 2947
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2947
  short *xp;
#line 2947
  int nrange = 0;         /* number of range errors */
#line 2947
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2947
  long cxp = (long) *((char**)xpp);
#line 2947

#line 2947
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2947
  /* sjl: manually stripmine so we can limit amount of
#line 2947
   * vector work space reserved to LOOPCNT elements. Also
#line 2947
   * makes vectorisation easy */
#line 2947
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2947
    ni=Min(nelems-j,LOOPCNT);
#line 2947
    if (realign) {
#line 2947
      xp = tmp;
#line 2947
    } else {
#line 2947
      xp = (short *) *xpp;
#line 2947
    }
#line 2947
   /* copy the next block */
#line 2947
#pragma cdir loopcnt=LOOPCNT
#line 2947
#pragma cdir shortloop
#line 2947
    for (i=0; i<ni; i++) {
#line 2947
      /* the normal case: */
#line 2947
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2947
     /* test for range errors (not always needed but do it anyway) */
#line 2947
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2947
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2947
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2947
    }
#line 2947
   /* copy workspace back if necessary */
#line 2947
    if (realign) {
#line 2947
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2947
      xp = (short *) *xpp;
#line 2947
    }
#line 2947
   /* update xpp and tp */
#line 2947
    xp += ni;
#line 2947
    tp += ni;
#line 2947
    *xpp = (void*)xp;
#line 2947
  }
#line 2947
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2947

#line 2947
#else   /* not SX */
#line 2947

#line 2947
	char *xp = (char *) *xpp;
#line 2947
	int status = NC_NOERR;
#line 2947

#line 2947
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2947
	{
#line 2947
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 2947
		if (status == NC_NOERR) /* report the first encountered error */
#line 2947
			status = lstatus;
#line 2947
	}
#line 2947

#line 2947
	*xpp = (void *)xp;
#line 2947
	return status;
#line 2947
#endif
#line 2947
}
#line 2947

int
#line 2948
ncx_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2948
{
#line 2948
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2948

#line 2948
 /* basic algorithm is:
#line 2948
  *   - ensure sane alignment of output data
#line 2948
  *   - copy (conversion happens automatically) input data
#line 2948
  *     to output
#line 2948
  *   - update tp to point at next unconverted input, and xpp to point
#line 2948
  *     at next location for converted output
#line 2948
  */
#line 2948
  long i, j, ni;
#line 2948
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2948
  short *xp;
#line 2948
  int nrange = 0;         /* number of range errors */
#line 2948
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2948
  long cxp = (long) *((char**)xpp);
#line 2948

#line 2948
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2948
  /* sjl: manually stripmine so we can limit amount of
#line 2948
   * vector work space reserved to LOOPCNT elements. Also
#line 2948
   * makes vectorisation easy */
#line 2948
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2948
    ni=Min(nelems-j,LOOPCNT);
#line 2948
    if (realign) {
#line 2948
      xp = tmp;
#line 2948
    } else {
#line 2948
      xp = (short *) *xpp;
#line 2948
    }
#line 2948
   /* copy the next block */
#line 2948
#pragma cdir loopcnt=LOOPCNT
#line 2948
#pragma cdir shortloop
#line 2948
    for (i=0; i<ni; i++) {
#line 2948
      /* the normal case: */
#line 2948
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2948
     /* test for range errors (not always needed but do it anyway) */
#line 2948
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2948
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2948
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2948
    }
#line 2948
   /* copy workspace back if necessary */
#line 2948
    if (realign) {
#line 2948
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2948
      xp = (short *) *xpp;
#line 2948
    }
#line 2948
   /* update xpp and tp */
#line 2948
    xp += ni;
#line 2948
    tp += ni;
#line 2948
    *xpp = (void*)xp;
#line 2948
  }
#line 2948
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2948

#line 2948
#else   /* not SX */
#line 2948

#line 2948
	char *xp = (char *) *xpp;
#line 2948
	int status = NC_NOERR;
#line 2948

#line 2948
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2948
	{
#line 2948
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 2948
		if (status == NC_NOERR) /* report the first encountered error */
#line 2948
			status = lstatus;
#line 2948
	}
#line 2948

#line 2948
	*xpp = (void *)xp;
#line 2948
	return status;
#line 2948
#endif
#line 2948
}
#line 2948

int
#line 2949
ncx_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2949
{
#line 2949
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2949

#line 2949
 /* basic algorithm is:
#line 2949
  *   - ensure sane alignment of output data
#line 2949
  *   - copy (conversion happens automatically) input data
#line 2949
  *     to output
#line 2949
  *   - update tp to point at next unconverted input, and xpp to point
#line 2949
  *     at next location for converted output
#line 2949
  */
#line 2949
  long i, j, ni;
#line 2949
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2949
  short *xp;
#line 2949
  int nrange = 0;         /* number of range errors */
#line 2949
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2949
  long cxp = (long) *((char**)xpp);
#line 2949

#line 2949
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2949
  /* sjl: manually stripmine so we can limit amount of
#line 2949
   * vector work space reserved to LOOPCNT elements. Also
#line 2949
   * makes vectorisation easy */
#line 2949
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2949
    ni=Min(nelems-j,LOOPCNT);
#line 2949
    if (realign) {
#line 2949
      xp = tmp;
#line 2949
    } else {
#line 2949
      xp = (short *) *xpp;
#line 2949
    }
#line 2949
   /* copy the next block */
#line 2949
#pragma cdir loopcnt=LOOPCNT
#line 2949
#pragma cdir shortloop
#line 2949
    for (i=0; i<ni; i++) {
#line 2949
      /* the normal case: */
#line 2949
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2949
     /* test for range errors (not always needed but do it anyway) */
#line 2949
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2949
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2949
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2949
    }
#line 2949
   /* copy workspace back if necessary */
#line 2949
    if (realign) {
#line 2949
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2949
      xp = (short *) *xpp;
#line 2949
    }
#line 2949
   /* update xpp and tp */
#line 2949
    xp += ni;
#line 2949
    tp += ni;
#line 2949
    *xpp = (void*)xp;
#line 2949
  }
#line 2949
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2949

#line 2949
#else   /* not SX */
#line 2949

#line 2949
	char *xp = (char *) *xpp;
#line 2949
	int status = NC_NOERR;
#line 2949

#line 2949
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2949
	{
#line 2949
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 2949
		if (status == NC_NOERR) /* report the first encountered error */
#line 2949
			status = lstatus;
#line 2949
	}
#line 2949

#line 2949
	*xpp = (void *)xp;
#line 2949
	return status;
#line 2949
#endif
#line 2949
}
#line 2949

int
#line 2950
ncx_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2950
{
#line 2950
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2950

#line 2950
 /* basic algorithm is:
#line 2950
  *   - ensure sane alignment of output data
#line 2950
  *   - copy (conversion happens automatically) input data
#line 2950
  *     to output
#line 2950
  *   - update tp to point at next unconverted input, and xpp to point
#line 2950
  *     at next location for converted output
#line 2950
  */
#line 2950
  long i, j, ni;
#line 2950
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2950
  short *xp;
#line 2950
  int nrange = 0;         /* number of range errors */
#line 2950
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2950
  long cxp = (long) *((char**)xpp);
#line 2950

#line 2950
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2950
  /* sjl: manually stripmine so we can limit amount of
#line 2950
   * vector work space reserved to LOOPCNT elements. Also
#line 2950
   * makes vectorisation easy */
#line 2950
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2950
    ni=Min(nelems-j,LOOPCNT);
#line 2950
    if (realign) {
#line 2950
      xp = tmp;
#line 2950
    } else {
#line 2950
      xp = (short *) *xpp;
#line 2950
    }
#line 2950
   /* copy the next block */
#line 2950
#pragma cdir loopcnt=LOOPCNT
#line 2950
#pragma cdir shortloop
#line 2950
    for (i=0; i<ni; i++) {
#line 2950
      /* the normal case: */
#line 2950
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2950
     /* test for range errors (not always needed but do it anyway) */
#line 2950
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2950
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2950
      nrange += tp[i] > X_SHORT_MAX ;
#line 2950
    }
#line 2950
   /* copy workspace back if necessary */
#line 2950
    if (realign) {
#line 2950
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2950
      xp = (short *) *xpp;
#line 2950
    }
#line 2950
   /* update xpp and tp */
#line 2950
    xp += ni;
#line 2950
    tp += ni;
#line 2950
    *xpp = (void*)xp;
#line 2950
  }
#line 2950
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2950

#line 2950
#else   /* not SX */
#line 2950

#line 2950
	char *xp = (char *) *xpp;
#line 2950
	int status = NC_NOERR;
#line 2950

#line 2950
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2950
	{
#line 2950
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 2950
		if (status == NC_NOERR) /* report the first encountered error */
#line 2950
			status = lstatus;
#line 2950
	}
#line 2950

#line 2950
	*xpp = (void *)xp;
#line 2950
	return status;
#line 2950
#endif
#line 2950
}
#line 2950

int
#line 2951
ncx_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2951
{
#line 2951
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2951

#line 2951
 /* basic algorithm is:
#line 2951
  *   - ensure sane alignment of output data
#line 2951
  *   - copy (conversion happens automatically) input data
#line 2951
  *     to output
#line 2951
  *   - update tp to point at next unconverted input, and xpp to point
#line 2951
  *     at next location for converted output
#line 2951
  */
#line 2951
  long i, j, ni;
#line 2951
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2951
  short *xp;
#line 2951
  int nrange = 0;         /* number of range errors */
#line 2951
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2951
  long cxp = (long) *((char**)xpp);
#line 2951

#line 2951
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2951
  /* sjl: manually stripmine so we can limit amount of
#line 2951
   * vector work space reserved to LOOPCNT elements. Also
#line 2951
   * makes vectorisation easy */
#line 2951
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2951
    ni=Min(nelems-j,LOOPCNT);
#line 2951
    if (realign) {
#line 2951
      xp = tmp;
#line 2951
    } else {
#line 2951
      xp = (short *) *xpp;
#line 2951
    }
#line 2951
   /* copy the next block */
#line 2951
#pragma cdir loopcnt=LOOPCNT
#line 2951
#pragma cdir shortloop
#line 2951
    for (i=0; i<ni; i++) {
#line 2951
      /* the normal case: */
#line 2951
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2951
     /* test for range errors (not always needed but do it anyway) */
#line 2951
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2951
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2951
      nrange += tp[i] > X_SHORT_MAX ;
#line 2951
    }
#line 2951
   /* copy workspace back if necessary */
#line 2951
    if (realign) {
#line 2951
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2951
      xp = (short *) *xpp;
#line 2951
    }
#line 2951
   /* update xpp and tp */
#line 2951
    xp += ni;
#line 2951
    tp += ni;
#line 2951
    *xpp = (void*)xp;
#line 2951
  }
#line 2951
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2951

#line 2951
#else   /* not SX */
#line 2951

#line 2951
	char *xp = (char *) *xpp;
#line 2951
	int status = NC_NOERR;
#line 2951

#line 2951
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2951
	{
#line 2951
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 2951
		if (status == NC_NOERR) /* report the first encountered error */
#line 2951
			status = lstatus;
#line 2951
	}
#line 2951

#line 2951
	*xpp = (void *)xp;
#line 2951
	return status;
#line 2951
#endif
#line 2951
}
#line 2951

int
#line 2952
ncx_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2952
{
#line 2952
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2952

#line 2952
 /* basic algorithm is:
#line 2952
  *   - ensure sane alignment of output data
#line 2952
  *   - copy (conversion happens automatically) input data
#line 2952
  *     to output
#line 2952
  *   - update tp to point at next unconverted input, and xpp to point
#line 2952
  *     at next location for converted output
#line 2952
  */
#line 2952
  long i, j, ni;
#line 2952
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2952
  short *xp;
#line 2952
  int nrange = 0;         /* number of range errors */
#line 2952
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2952
  long cxp = (long) *((char**)xpp);
#line 2952

#line 2952
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2952
  /* sjl: manually stripmine so we can limit amount of
#line 2952
   * vector work space reserved to LOOPCNT elements. Also
#line 2952
   * makes vectorisation easy */
#line 2952
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2952
    ni=Min(nelems-j,LOOPCNT);
#line 2952
    if (realign) {
#line 2952
      xp = tmp;
#line 2952
    } else {
#line 2952
      xp = (short *) *xpp;
#line 2952
    }
#line 2952
   /* copy the next block */
#line 2952
#pragma cdir loopcnt=LOOPCNT
#line 2952
#pragma cdir shortloop
#line 2952
    for (i=0; i<ni; i++) {
#line 2952
      /* the normal case: */
#line 2952
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2952
     /* test for range errors (not always needed but do it anyway) */
#line 2952
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2952
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2952
      nrange += tp[i] > X_SHORT_MAX ;
#line 2952
    }
#line 2952
   /* copy workspace back if necessary */
#line 2952
    if (realign) {
#line 2952
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2952
      xp = (short *) *xpp;
#line 2952
    }
#line 2952
   /* update xpp and tp */
#line 2952
    xp += ni;
#line 2952
    tp += ni;
#line 2952
    *xpp = (void*)xp;
#line 2952
  }
#line 2952
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2952

#line 2952
#else   /* not SX */
#line 2952

#line 2952
	char *xp = (char *) *xpp;
#line 2952
	int status = NC_NOERR;
#line 2952

#line 2952
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2952
	{
#line 2952
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 2952
		if (status == NC_NOERR) /* report the first encountered error */
#line 2952
			status = lstatus;
#line 2952
	}
#line 2952

#line 2952
	*xpp = (void *)xp;
#line 2952
	return status;
#line 2952
#endif
#line 2952
}
#line 2952

int
#line 2953
ncx_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2953
{
#line 2953
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2953

#line 2953
 /* basic algorithm is:
#line 2953
  *   - ensure sane alignment of output data
#line 2953
  *   - copy (conversion happens automatically) input data
#line 2953
  *     to output
#line 2953
  *   - update tp to point at next unconverted input, and xpp to point
#line 2953
  *     at next location for converted output
#line 2953
  */
#line 2953
  long i, j, ni;
#line 2953
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2953
  short *xp;
#line 2953
  int nrange = 0;         /* number of range errors */
#line 2953
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2953
  long cxp = (long) *((char**)xpp);
#line 2953

#line 2953
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2953
  /* sjl: manually stripmine so we can limit amount of
#line 2953
   * vector work space reserved to LOOPCNT elements. Also
#line 2953
   * makes vectorisation easy */
#line 2953
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2953
    ni=Min(nelems-j,LOOPCNT);
#line 2953
    if (realign) {
#line 2953
      xp = tmp;
#line 2953
    } else {
#line 2953
      xp = (short *) *xpp;
#line 2953
    }
#line 2953
   /* copy the next block */
#line 2953
#pragma cdir loopcnt=LOOPCNT
#line 2953
#pragma cdir shortloop
#line 2953
    for (i=0; i<ni; i++) {
#line 2953
      /* the normal case: */
#line 2953
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2953
     /* test for range errors (not always needed but do it anyway) */
#line 2953
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2953
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2953
      nrange += tp[i] > X_SHORT_MAX ;
#line 2953
    }
#line 2953
   /* copy workspace back if necessary */
#line 2953
    if (realign) {
#line 2953
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2953
      xp = (short *) *xpp;
#line 2953
    }
#line 2953
   /* update xpp and tp */
#line 2953
    xp += ni;
#line 2953
    tp += ni;
#line 2953
    *xpp = (void*)xp;
#line 2953
  }
#line 2953
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2953

#line 2953
#else   /* not SX */
#line 2953

#line 2953
	char *xp = (char *) *xpp;
#line 2953
	int status = NC_NOERR;
#line 2953

#line 2953
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2953
	{
#line 2953
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 2953
		if (status == NC_NOERR) /* report the first encountered error */
#line 2953
			status = lstatus;
#line 2953
	}
#line 2953

#line 2953
	*xpp = (void *)xp;
#line 2953
	return status;
#line 2953
#endif
#line 2953
}
#line 2953


int
#line 2955
ncx_pad_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 2955
{
#line 2955
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2955

#line 2955
	char *xp = (char *) *xpp;
#line 2955
	int status = NC_NOERR;
#line 2955

#line 2955
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2955
	{
#line 2955
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 2955
		if (status == NC_NOERR) /* report the first encountered error */
#line 2955
			status = lstatus;
#line 2955
	}
#line 2955

#line 2955
	if (rndup != 0)
#line 2955
	{
#line 2955
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2955
		xp += X_SIZEOF_SHORT;
#line 2955
	}
#line 2955

#line 2955
	*xpp = (void *)xp;
#line 2955
	return status;
#line 2955
}
#line 2955

int
#line 2956
ncx_pad_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2956
{
#line 2956
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2956

#line 2956
	char *xp = (char *) *xpp;
#line 2956
	int status = NC_NOERR;
#line 2956

#line 2956
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2956
	{
#line 2956
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 2956
		if (status == NC_NOERR) /* report the first encountered error */
#line 2956
			status = lstatus;
#line 2956
	}
#line 2956

#line 2956
	if (rndup != 0)
#line 2956
	{
#line 2956
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2956
		xp += X_SIZEOF_SHORT;
#line 2956
	}
#line 2956

#line 2956
	*xpp = (void *)xp;
#line 2956
	return status;
#line 2956
}
#line 2956

int
#line 2957
ncx_pad_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2957
{
#line 2957
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2957

#line 2957
	char *xp = (char *) *xpp;
#line 2957
	int status = NC_NOERR;
#line 2957

#line 2957
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2957
	{
#line 2957
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 2957
		if (status == NC_NOERR) /* report the first encountered error */
#line 2957
			status = lstatus;
#line 2957
	}
#line 2957

#line 2957
	if (rndup != 0)
#line 2957
	{
#line 2957
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2957
		xp += X_SIZEOF_SHORT;
#line 2957
	}
#line 2957

#line 2957
	*xpp = (void *)xp;
#line 2957
	return status;
#line 2957
}
#line 2957

int
#line 2958
ncx_pad_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2958
{
#line 2958
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2958

#line 2958
	char *xp = (char *) *xpp;
#line 2958
	int status = NC_NOERR;
#line 2958

#line 2958
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2958
	{
#line 2958
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 2958
		if (status == NC_NOERR) /* report the first encountered error */
#line 2958
			status = lstatus;
#line 2958
	}
#line 2958

#line 2958
	if (rndup != 0)
#line 2958
	{
#line 2958
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2958
		xp += X_SIZEOF_SHORT;
#line 2958
	}
#line 2958

#line 2958
	*xpp = (void *)xp;
#line 2958
	return status;
#line 2958
}
#line 2958

int
#line 2959
ncx_pad_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2959
{
#line 2959
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2959

#line 2959
	char *xp = (char *) *xpp;
#line 2959
	int status = NC_NOERR;
#line 2959

#line 2959
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2959
	{
#line 2959
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 2959
		if (status == NC_NOERR) /* report the first encountered error */
#line 2959
			status = lstatus;
#line 2959
	}
#line 2959

#line 2959
	if (rndup != 0)
#line 2959
	{
#line 2959
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2959
		xp += X_SIZEOF_SHORT;
#line 2959
	}
#line 2959

#line 2959
	*xpp = (void *)xp;
#line 2959
	return status;
#line 2959
}
#line 2959

int
#line 2960
ncx_pad_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2960
{
#line 2960
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2960

#line 2960
	char *xp = (char *) *xpp;
#line 2960
	int status = NC_NOERR;
#line 2960

#line 2960
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2960
	{
#line 2960
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 2960
		if (status == NC_NOERR) /* report the first encountered error */
#line 2960
			status = lstatus;
#line 2960
	}
#line 2960

#line 2960
	if (rndup != 0)
#line 2960
	{
#line 2960
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2960
		xp += X_SIZEOF_SHORT;
#line 2960
	}
#line 2960

#line 2960
	*xpp = (void *)xp;
#line 2960
	return status;
#line 2960
}
#line 2960

int
#line 2961
ncx_pad_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2961
{
#line 2961
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2961

#line 2961
	char *xp = (char *) *xpp;
#line 2961
	int status = NC_NOERR;
#line 2961

#line 2961
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2961
	{
#line 2961
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 2961
		if (status == NC_NOERR) /* report the first encountered error */
#line 2961
			status = lstatus;
#line 2961
	}
#line 2961

#line 2961
	if (rndup != 0)
#line 2961
	{
#line 2961
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2961
		xp += X_SIZEOF_SHORT;
#line 2961
	}
#line 2961

#line 2961
	*xpp = (void *)xp;
#line 2961
	return status;
#line 2961
}
#line 2961

int
#line 2962
ncx_pad_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2962
{
#line 2962
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2962

#line 2962
	char *xp = (char *) *xpp;
#line 2962
	int status = NC_NOERR;
#line 2962

#line 2962
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2962
	{
#line 2962
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 2962
		if (status == NC_NOERR) /* report the first encountered error */
#line 2962
			status = lstatus;
#line 2962
	}
#line 2962

#line 2962
	if (rndup != 0)
#line 2962
	{
#line 2962
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2962
		xp += X_SIZEOF_SHORT;
#line 2962
	}
#line 2962

#line 2962
	*xpp = (void *)xp;
#line 2962
	return status;
#line 2962
}
#line 2962

int
#line 2963
ncx_pad_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2963
{
#line 2963
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2963

#line 2963
	char *xp = (char *) *xpp;
#line 2963
	int status = NC_NOERR;
#line 2963

#line 2963
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2963
	{
#line 2963
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 2963
		if (status == NC_NOERR) /* report the first encountered error */
#line 2963
			status = lstatus;
#line 2963
	}
#line 2963

#line 2963
	if (rndup != 0)
#line 2963
	{
#line 2963
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2963
		xp += X_SIZEOF_SHORT;
#line 2963
	}
#line 2963

#line 2963
	*xpp = (void *)xp;
#line 2963
	return status;
#line 2963
}
#line 2963

int
#line 2964
ncx_pad_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2964
{
#line 2964
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2964

#line 2964
	char *xp = (char *) *xpp;
#line 2964
	int status = NC_NOERR;
#line 2964

#line 2964
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2964
	{
#line 2964
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 2964
		if (status == NC_NOERR) /* report the first encountered error */
#line 2964
			status = lstatus;
#line 2964
	}
#line 2964

#line 2964
	if (rndup != 0)
#line 2964
	{
#line 2964
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2964
		xp += X_SIZEOF_SHORT;
#line 2964
	}
#line 2964

#line 2964
	*xpp = (void *)xp;
#line 2964
	return status;
#line 2964
}
#line 2964

int
#line 2965
ncx_pad_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2965
{
#line 2965
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2965

#line 2965
	char *xp = (char *) *xpp;
#line 2965
	int status = NC_NOERR;
#line 2965

#line 2965
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2965
	{
#line 2965
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 2965
		if (status == NC_NOERR) /* report the first encountered error */
#line 2965
			status = lstatus;
#line 2965
	}
#line 2965

#line 2965
	if (rndup != 0)
#line 2965
	{
#line 2965
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2965
		xp += X_SIZEOF_SHORT;
#line 2965
	}
#line 2965

#line 2965
	*xpp = (void *)xp;
#line 2965
	return status;
#line 2965
}
#line 2965



/* ushort --------------------------------------------------------------------*/

#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, unsigned short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_USHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 2984
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2984
{
#line 2984
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2984

#line 2984
 /* basic algorithm is:
#line 2984
  *   - ensure sane alignment of input data
#line 2984
  *   - copy (conversion happens automatically) input data
#line 2984
  *     to output
#line 2984
  *   - update xpp to point at next unconverted input, and tp to point
#line 2984
  *     at next location for converted output
#line 2984
  */
#line 2984
  long i, j, ni;
#line 2984
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2984
  ushort *xp;
#line 2984
  int nrange = 0;         /* number of range errors */
#line 2984
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2984
  long cxp = (long) *((char**)xpp);
#line 2984

#line 2984
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2984
  /* sjl: manually stripmine so we can limit amount of
#line 2984
   * vector work space reserved to LOOPCNT elements. Also
#line 2984
   * makes vectorisation easy */
#line 2984
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2984
    ni=Min(nelems-j,LOOPCNT);
#line 2984
    if (realign) {
#line 2984
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2984
      xp = tmp;
#line 2984
    } else {
#line 2984
      xp = (ushort *) *xpp;
#line 2984
    }
#line 2984
   /* copy the next block */
#line 2984
#pragma cdir loopcnt=LOOPCNT
#line 2984
#pragma cdir shortloop
#line 2984
    for (i=0; i<ni; i++) {
#line 2984
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 2984
     /* test for range errors (not always needed but do it anyway) */
#line 2984
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2984
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2984
      nrange += xp[i] > USHORT_MAX ;
#line 2984
    }
#line 2984
   /* update xpp and tp */
#line 2984
    if (realign) xp = (ushort *) *xpp;
#line 2984
    xp += ni;
#line 2984
    tp += ni;
#line 2984
    *xpp = (void*)xp;
#line 2984
  }
#line 2984
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2984

#line 2984
#else   /* not SX */
#line 2984
	const char *xp = (const char *) *xpp;
#line 2984
	int status = NC_NOERR;
#line 2984

#line 2984
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2984
	{
#line 2984
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 2984
		if (status == NC_NOERR) /* report the first encountered error */
#line 2984
			status = lstatus;
#line 2984
	}
#line 2984

#line 2984
	*xpp = (const void *)xp;
#line 2984
	return status;
#line 2984
#endif
#line 2984
}
#line 2984

#endif
int
#line 2986
ncx_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 2986
{
#line 2986
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2986

#line 2986
 /* basic algorithm is:
#line 2986
  *   - ensure sane alignment of input data
#line 2986
  *   - copy (conversion happens automatically) input data
#line 2986
  *     to output
#line 2986
  *   - update xpp to point at next unconverted input, and tp to point
#line 2986
  *     at next location for converted output
#line 2986
  */
#line 2986
  long i, j, ni;
#line 2986
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2986
  ushort *xp;
#line 2986
  int nrange = 0;         /* number of range errors */
#line 2986
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2986
  long cxp = (long) *((char**)xpp);
#line 2986

#line 2986
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2986
  /* sjl: manually stripmine so we can limit amount of
#line 2986
   * vector work space reserved to LOOPCNT elements. Also
#line 2986
   * makes vectorisation easy */
#line 2986
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2986
    ni=Min(nelems-j,LOOPCNT);
#line 2986
    if (realign) {
#line 2986
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2986
      xp = tmp;
#line 2986
    } else {
#line 2986
      xp = (ushort *) *xpp;
#line 2986
    }
#line 2986
   /* copy the next block */
#line 2986
#pragma cdir loopcnt=LOOPCNT
#line 2986
#pragma cdir shortloop
#line 2986
    for (i=0; i<ni; i++) {
#line 2986
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2986
     /* test for range errors (not always needed but do it anyway) */
#line 2986
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2986
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2986
      nrange += xp[i] > SCHAR_MAX ;
#line 2986
    }
#line 2986
   /* update xpp and tp */
#line 2986
    if (realign) xp = (ushort *) *xpp;
#line 2986
    xp += ni;
#line 2986
    tp += ni;
#line 2986
    *xpp = (void*)xp;
#line 2986
  }
#line 2986
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2986

#line 2986
#else   /* not SX */
#line 2986
	const char *xp = (const char *) *xpp;
#line 2986
	int status = NC_NOERR;
#line 2986

#line 2986
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2986
	{
#line 2986
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 2986
		if (status == NC_NOERR) /* report the first encountered error */
#line 2986
			status = lstatus;
#line 2986
	}
#line 2986

#line 2986
	*xpp = (const void *)xp;
#line 2986
	return status;
#line 2986
#endif
#line 2986
}
#line 2986

int
#line 2987
ncx_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 2987
{
#line 2987
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2987

#line 2987
 /* basic algorithm is:
#line 2987
  *   - ensure sane alignment of input data
#line 2987
  *   - copy (conversion happens automatically) input data
#line 2987
  *     to output
#line 2987
  *   - update xpp to point at next unconverted input, and tp to point
#line 2987
  *     at next location for converted output
#line 2987
  */
#line 2987
  long i, j, ni;
#line 2987
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2987
  ushort *xp;
#line 2987
  int nrange = 0;         /* number of range errors */
#line 2987
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2987
  long cxp = (long) *((char**)xpp);
#line 2987

#line 2987
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2987
  /* sjl: manually stripmine so we can limit amount of
#line 2987
   * vector work space reserved to LOOPCNT elements. Also
#line 2987
   * makes vectorisation easy */
#line 2987
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2987
    ni=Min(nelems-j,LOOPCNT);
#line 2987
    if (realign) {
#line 2987
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2987
      xp = tmp;
#line 2987
    } else {
#line 2987
      xp = (ushort *) *xpp;
#line 2987
    }
#line 2987
   /* copy the next block */
#line 2987
#pragma cdir loopcnt=LOOPCNT
#line 2987
#pragma cdir shortloop
#line 2987
    for (i=0; i<ni; i++) {
#line 2987
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2987
     /* test for range errors (not always needed but do it anyway) */
#line 2987
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2987
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2987
      nrange += xp[i] > SHORT_MAX ;
#line 2987
    }
#line 2987
   /* update xpp and tp */
#line 2987
    if (realign) xp = (ushort *) *xpp;
#line 2987
    xp += ni;
#line 2987
    tp += ni;
#line 2987
    *xpp = (void*)xp;
#line 2987
  }
#line 2987
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2987

#line 2987
#else   /* not SX */
#line 2987
	const char *xp = (const char *) *xpp;
#line 2987
	int status = NC_NOERR;
#line 2987

#line 2987
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2987
	{
#line 2987
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 2987
		if (status == NC_NOERR) /* report the first encountered error */
#line 2987
			status = lstatus;
#line 2987
	}
#line 2987

#line 2987
	*xpp = (const void *)xp;
#line 2987
	return status;
#line 2987
#endif
#line 2987
}
#line 2987

int
#line 2988
ncx_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 2988
{
#line 2988
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2988

#line 2988
 /* basic algorithm is:
#line 2988
  *   - ensure sane alignment of input data
#line 2988
  *   - copy (conversion happens automatically) input data
#line 2988
  *     to output
#line 2988
  *   - update xpp to point at next unconverted input, and tp to point
#line 2988
  *     at next location for converted output
#line 2988
  */
#line 2988
  long i, j, ni;
#line 2988
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2988
  ushort *xp;
#line 2988
  int nrange = 0;         /* number of range errors */
#line 2988
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2988
  long cxp = (long) *((char**)xpp);
#line 2988

#line 2988
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2988
  /* sjl: manually stripmine so we can limit amount of
#line 2988
   * vector work space reserved to LOOPCNT elements. Also
#line 2988
   * makes vectorisation easy */
#line 2988
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2988
    ni=Min(nelems-j,LOOPCNT);
#line 2988
    if (realign) {
#line 2988
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2988
      xp = tmp;
#line 2988
    } else {
#line 2988
      xp = (ushort *) *xpp;
#line 2988
    }
#line 2988
   /* copy the next block */
#line 2988
#pragma cdir loopcnt=LOOPCNT
#line 2988
#pragma cdir shortloop
#line 2988
    for (i=0; i<ni; i++) {
#line 2988
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2988
     /* test for range errors (not always needed but do it anyway) */
#line 2988
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2988
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2988
      nrange += xp[i] > INT_MAX ;
#line 2988
    }
#line 2988
   /* update xpp and tp */
#line 2988
    if (realign) xp = (ushort *) *xpp;
#line 2988
    xp += ni;
#line 2988
    tp += ni;
#line 2988
    *xpp = (void*)xp;
#line 2988
  }
#line 2988
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2988

#line 2988
#else   /* not SX */
#line 2988
	const char *xp = (const char *) *xpp;
#line 2988
	int status = NC_NOERR;
#line 2988

#line 2988
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2988
	{
#line 2988
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 2988
		if (status == NC_NOERR) /* report the first encountered error */
#line 2988
			status = lstatus;
#line 2988
	}
#line 2988

#line 2988
	*xpp = (const void *)xp;
#line 2988
	return status;
#line 2988
#endif
#line 2988
}
#line 2988

int
#line 2989
ncx_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 2989
{
#line 2989
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2989

#line 2989
 /* basic algorithm is:
#line 2989
  *   - ensure sane alignment of input data
#line 2989
  *   - copy (conversion happens automatically) input data
#line 2989
  *     to output
#line 2989
  *   - update xpp to point at next unconverted input, and tp to point
#line 2989
  *     at next location for converted output
#line 2989
  */
#line 2989
  long i, j, ni;
#line 2989
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2989
  ushort *xp;
#line 2989
  int nrange = 0;         /* number of range errors */
#line 2989
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2989
  long cxp = (long) *((char**)xpp);
#line 2989

#line 2989
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2989
  /* sjl: manually stripmine so we can limit amount of
#line 2989
   * vector work space reserved to LOOPCNT elements. Also
#line 2989
   * makes vectorisation easy */
#line 2989
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2989
    ni=Min(nelems-j,LOOPCNT);
#line 2989
    if (realign) {
#line 2989
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2989
      xp = tmp;
#line 2989
    } else {
#line 2989
      xp = (ushort *) *xpp;
#line 2989
    }
#line 2989
   /* copy the next block */
#line 2989
#pragma cdir loopcnt=LOOPCNT
#line 2989
#pragma cdir shortloop
#line 2989
    for (i=0; i<ni; i++) {
#line 2989
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 2989
     /* test for range errors (not always needed but do it anyway) */
#line 2989
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2989
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2989
      nrange += xp[i] > LONG_MAX ;
#line 2989
    }
#line 2989
   /* update xpp and tp */
#line 2989
    if (realign) xp = (ushort *) *xpp;
#line 2989
    xp += ni;
#line 2989
    tp += ni;
#line 2989
    *xpp = (void*)xp;
#line 2989
  }
#line 2989
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2989

#line 2989
#else   /* not SX */
#line 2989
	const char *xp = (const char *) *xpp;
#line 2989
	int status = NC_NOERR;
#line 2989

#line 2989
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2989
	{
#line 2989
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 2989
		if (status == NC_NOERR) /* report the first encountered error */
#line 2989
			status = lstatus;
#line 2989
	}
#line 2989

#line 2989
	*xpp = (const void *)xp;
#line 2989
	return status;
#line 2989
#endif
#line 2989
}
#line 2989

int
#line 2990
ncx_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 2990
{
#line 2990
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2990

#line 2990
 /* basic algorithm is:
#line 2990
  *   - ensure sane alignment of input data
#line 2990
  *   - copy (conversion happens automatically) input data
#line 2990
  *     to output
#line 2990
  *   - update xpp to point at next unconverted input, and tp to point
#line 2990
  *     at next location for converted output
#line 2990
  */
#line 2990
  long i, j, ni;
#line 2990
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2990
  ushort *xp;
#line 2990
  int nrange = 0;         /* number of range errors */
#line 2990
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2990
  long cxp = (long) *((char**)xpp);
#line 2990

#line 2990
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2990
  /* sjl: manually stripmine so we can limit amount of
#line 2990
   * vector work space reserved to LOOPCNT elements. Also
#line 2990
   * makes vectorisation easy */
#line 2990
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2990
    ni=Min(nelems-j,LOOPCNT);
#line 2990
    if (realign) {
#line 2990
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2990
      xp = tmp;
#line 2990
    } else {
#line 2990
      xp = (ushort *) *xpp;
#line 2990
    }
#line 2990
   /* copy the next block */
#line 2990
#pragma cdir loopcnt=LOOPCNT
#line 2990
#pragma cdir shortloop
#line 2990
    for (i=0; i<ni; i++) {
#line 2990
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2990
     /* test for range errors (not always needed but do it anyway) */
#line 2990
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2990
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2990
      nrange += xp[i] > FLOAT_MAX ;
#line 2990
    }
#line 2990
   /* update xpp and tp */
#line 2990
    if (realign) xp = (ushort *) *xpp;
#line 2990
    xp += ni;
#line 2990
    tp += ni;
#line 2990
    *xpp = (void*)xp;
#line 2990
  }
#line 2990
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2990

#line 2990
#else   /* not SX */
#line 2990
	const char *xp = (const char *) *xpp;
#line 2990
	int status = NC_NOERR;
#line 2990

#line 2990
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2990
	{
#line 2990
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 2990
		if (status == NC_NOERR) /* report the first encountered error */
#line 2990
			status = lstatus;
#line 2990
	}
#line 2990

#line 2990
	*xpp = (const void *)xp;
#line 2990
	return status;
#line 2990
#endif
#line 2990
}
#line 2990

int
#line 2991
ncx_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 2991
{
#line 2991
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2991

#line 2991
 /* basic algorithm is:
#line 2991
  *   - ensure sane alignment of input data
#line 2991
  *   - copy (conversion happens automatically) input data
#line 2991
  *     to output
#line 2991
  *   - update xpp to point at next unconverted input, and tp to point
#line 2991
  *     at next location for converted output
#line 2991
  */
#line 2991
  long i, j, ni;
#line 2991
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2991
  ushort *xp;
#line 2991
  int nrange = 0;         /* number of range errors */
#line 2991
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2991
  long cxp = (long) *((char**)xpp);
#line 2991

#line 2991
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2991
  /* sjl: manually stripmine so we can limit amount of
#line 2991
   * vector work space reserved to LOOPCNT elements. Also
#line 2991
   * makes vectorisation easy */
#line 2991
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2991
    ni=Min(nelems-j,LOOPCNT);
#line 2991
    if (realign) {
#line 2991
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2991
      xp = tmp;
#line 2991
    } else {
#line 2991
      xp = (ushort *) *xpp;
#line 2991
    }
#line 2991
   /* copy the next block */
#line 2991
#pragma cdir loopcnt=LOOPCNT
#line 2991
#pragma cdir shortloop
#line 2991
    for (i=0; i<ni; i++) {
#line 2991
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2991
     /* test for range errors (not always needed but do it anyway) */
#line 2991
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2991
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2991
      nrange += xp[i] > DOUBLE_MAX ;
#line 2991
    }
#line 2991
   /* update xpp and tp */
#line 2991
    if (realign) xp = (ushort *) *xpp;
#line 2991
    xp += ni;
#line 2991
    tp += ni;
#line 2991
    *xpp = (void*)xp;
#line 2991
  }
#line 2991
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2991

#line 2991
#else   /* not SX */
#line 2991
	const char *xp = (const char *) *xpp;
#line 2991
	int status = NC_NOERR;
#line 2991

#line 2991
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2991
	{
#line 2991
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 2991
		if (status == NC_NOERR) /* report the first encountered error */
#line 2991
			status = lstatus;
#line 2991
	}
#line 2991

#line 2991
	*xpp = (const void *)xp;
#line 2991
	return status;
#line 2991
#endif
#line 2991
}
#line 2991

int
#line 2992
ncx_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2992
{
#line 2992
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2992

#line 2992
 /* basic algorithm is:
#line 2992
  *   - ensure sane alignment of input data
#line 2992
  *   - copy (conversion happens automatically) input data
#line 2992
  *     to output
#line 2992
  *   - update xpp to point at next unconverted input, and tp to point
#line 2992
  *     at next location for converted output
#line 2992
  */
#line 2992
  long i, j, ni;
#line 2992
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2992
  ushort *xp;
#line 2992
  int nrange = 0;         /* number of range errors */
#line 2992
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2992
  long cxp = (long) *((char**)xpp);
#line 2992

#line 2992
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2992
  /* sjl: manually stripmine so we can limit amount of
#line 2992
   * vector work space reserved to LOOPCNT elements. Also
#line 2992
   * makes vectorisation easy */
#line 2992
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2992
    ni=Min(nelems-j,LOOPCNT);
#line 2992
    if (realign) {
#line 2992
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2992
      xp = tmp;
#line 2992
    } else {
#line 2992
      xp = (ushort *) *xpp;
#line 2992
    }
#line 2992
   /* copy the next block */
#line 2992
#pragma cdir loopcnt=LOOPCNT
#line 2992
#pragma cdir shortloop
#line 2992
    for (i=0; i<ni; i++) {
#line 2992
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2992
     /* test for range errors (not always needed but do it anyway) */
#line 2992
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2992
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2992
      nrange += xp[i] > LONGLONG_MAX ;
#line 2992
    }
#line 2992
   /* update xpp and tp */
#line 2992
    if (realign) xp = (ushort *) *xpp;
#line 2992
    xp += ni;
#line 2992
    tp += ni;
#line 2992
    *xpp = (void*)xp;
#line 2992
  }
#line 2992
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2992

#line 2992
#else   /* not SX */
#line 2992
	const char *xp = (const char *) *xpp;
#line 2992
	int status = NC_NOERR;
#line 2992

#line 2992
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2992
	{
#line 2992
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 2992
		if (status == NC_NOERR) /* report the first encountered error */
#line 2992
			status = lstatus;
#line 2992
	}
#line 2992

#line 2992
	*xpp = (const void *)xp;
#line 2992
	return status;
#line 2992
#endif
#line 2992
}
#line 2992

int
#line 2993
ncx_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2993
{
#line 2993
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2993

#line 2993
 /* basic algorithm is:
#line 2993
  *   - ensure sane alignment of input data
#line 2993
  *   - copy (conversion happens automatically) input data
#line 2993
  *     to output
#line 2993
  *   - update xpp to point at next unconverted input, and tp to point
#line 2993
  *     at next location for converted output
#line 2993
  */
#line 2993
  long i, j, ni;
#line 2993
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2993
  ushort *xp;
#line 2993
  int nrange = 0;         /* number of range errors */
#line 2993
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2993
  long cxp = (long) *((char**)xpp);
#line 2993

#line 2993
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2993
  /* sjl: manually stripmine so we can limit amount of
#line 2993
   * vector work space reserved to LOOPCNT elements. Also
#line 2993
   * makes vectorisation easy */
#line 2993
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2993
    ni=Min(nelems-j,LOOPCNT);
#line 2993
    if (realign) {
#line 2993
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2993
      xp = tmp;
#line 2993
    } else {
#line 2993
      xp = (ushort *) *xpp;
#line 2993
    }
#line 2993
   /* copy the next block */
#line 2993
#pragma cdir loopcnt=LOOPCNT
#line 2993
#pragma cdir shortloop
#line 2993
    for (i=0; i<ni; i++) {
#line 2993
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2993
     /* test for range errors (not always needed but do it anyway) */
#line 2993
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2993
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2993
      nrange += xp[i] > UCHAR_MAX ;
#line 2993
    }
#line 2993
   /* update xpp and tp */
#line 2993
    if (realign) xp = (ushort *) *xpp;
#line 2993
    xp += ni;
#line 2993
    tp += ni;
#line 2993
    *xpp = (void*)xp;
#line 2993
  }
#line 2993
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2993

#line 2993
#else   /* not SX */
#line 2993
	const char *xp = (const char *) *xpp;
#line 2993
	int status = NC_NOERR;
#line 2993

#line 2993
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2993
	{
#line 2993
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 2993
		if (status == NC_NOERR) /* report the first encountered error */
#line 2993
			status = lstatus;
#line 2993
	}
#line 2993

#line 2993
	*xpp = (const void *)xp;
#line 2993
	return status;
#line 2993
#endif
#line 2993
}
#line 2993

int
#line 2994
ncx_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 2994
{
#line 2994
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2994

#line 2994
 /* basic algorithm is:
#line 2994
  *   - ensure sane alignment of input data
#line 2994
  *   - copy (conversion happens automatically) input data
#line 2994
  *     to output
#line 2994
  *   - update xpp to point at next unconverted input, and tp to point
#line 2994
  *     at next location for converted output
#line 2994
  */
#line 2994
  long i, j, ni;
#line 2994
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2994
  ushort *xp;
#line 2994
  int nrange = 0;         /* number of range errors */
#line 2994
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2994
  long cxp = (long) *((char**)xpp);
#line 2994

#line 2994
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2994
  /* sjl: manually stripmine so we can limit amount of
#line 2994
   * vector work space reserved to LOOPCNT elements. Also
#line 2994
   * makes vectorisation easy */
#line 2994
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2994
    ni=Min(nelems-j,LOOPCNT);
#line 2994
    if (realign) {
#line 2994
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2994
      xp = tmp;
#line 2994
    } else {
#line 2994
      xp = (ushort *) *xpp;
#line 2994
    }
#line 2994
   /* copy the next block */
#line 2994
#pragma cdir loopcnt=LOOPCNT
#line 2994
#pragma cdir shortloop
#line 2994
    for (i=0; i<ni; i++) {
#line 2994
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2994
     /* test for range errors (not always needed but do it anyway) */
#line 2994
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2994
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2994
      nrange += xp[i] > UINT_MAX ;
#line 2994
    }
#line 2994
   /* update xpp and tp */
#line 2994
    if (realign) xp = (ushort *) *xpp;
#line 2994
    xp += ni;
#line 2994
    tp += ni;
#line 2994
    *xpp = (void*)xp;
#line 2994
  }
#line 2994
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2994

#line 2994
#else   /* not SX */
#line 2994
	const char *xp = (const char *) *xpp;
#line 2994
	int status = NC_NOERR;
#line 2994

#line 2994
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2994
	{
#line 2994
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 2994
		if (status == NC_NOERR) /* report the first encountered error */
#line 2994
			status = lstatus;
#line 2994
	}
#line 2994

#line 2994
	*xpp = (const void *)xp;
#line 2994
	return status;
#line 2994
#endif
#line 2994
}
#line 2994

int
#line 2995
ncx_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2995
{
#line 2995
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2995

#line 2995
 /* basic algorithm is:
#line 2995
  *   - ensure sane alignment of input data
#line 2995
  *   - copy (conversion happens automatically) input data
#line 2995
  *     to output
#line 2995
  *   - update xpp to point at next unconverted input, and tp to point
#line 2995
  *     at next location for converted output
#line 2995
  */
#line 2995
  long i, j, ni;
#line 2995
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2995
  ushort *xp;
#line 2995
  int nrange = 0;         /* number of range errors */
#line 2995
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2995
  long cxp = (long) *((char**)xpp);
#line 2995

#line 2995
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2995
  /* sjl: manually stripmine so we can limit amount of
#line 2995
   * vector work space reserved to LOOPCNT elements. Also
#line 2995
   * makes vectorisation easy */
#line 2995
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2995
    ni=Min(nelems-j,LOOPCNT);
#line 2995
    if (realign) {
#line 2995
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2995
      xp = tmp;
#line 2995
    } else {
#line 2995
      xp = (ushort *) *xpp;
#line 2995
    }
#line 2995
   /* copy the next block */
#line 2995
#pragma cdir loopcnt=LOOPCNT
#line 2995
#pragma cdir shortloop
#line 2995
    for (i=0; i<ni; i++) {
#line 2995
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2995
     /* test for range errors (not always needed but do it anyway) */
#line 2995
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2995
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2995
      nrange += xp[i] > ULONGLONG_MAX ;
#line 2995
    }
#line 2995
   /* update xpp and tp */
#line 2995
    if (realign) xp = (ushort *) *xpp;
#line 2995
    xp += ni;
#line 2995
    tp += ni;
#line 2995
    *xpp = (void*)xp;
#line 2995
  }
#line 2995
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2995

#line 2995
#else   /* not SX */
#line 2995
	const char *xp = (const char *) *xpp;
#line 2995
	int status = NC_NOERR;
#line 2995

#line 2995
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2995
	{
#line 2995
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 2995
		if (status == NC_NOERR) /* report the first encountered error */
#line 2995
			status = lstatus;
#line 2995
	}
#line 2995

#line 2995
	*xpp = (const void *)xp;
#line 2995
	return status;
#line 2995
#endif
#line 2995
}
#line 2995


int
#line 2997
ncx_pad_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 2997
{
#line 2997
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2997

#line 2997
	const char *xp = (const char *) *xpp;
#line 2997
	int status = NC_NOERR;
#line 2997

#line 2997
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2997
	{
#line 2997
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 2997
		if (status == NC_NOERR) /* report the first encountered error */
#line 2997
			status = lstatus;
#line 2997
	}
#line 2997

#line 2997
	if (rndup != 0)
#line 2997
		xp += X_SIZEOF_USHORT;
#line 2997

#line 2997
	*xpp = (void *)xp;
#line 2997
	return status;
#line 2997
}
#line 2997

int
#line 2998
ncx_pad_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 2998
{
#line 2998
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2998

#line 2998
	const char *xp = (const char *) *xpp;
#line 2998
	int status = NC_NOERR;
#line 2998

#line 2998
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2998
	{
#line 2998
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 2998
		if (status == NC_NOERR) /* report the first encountered error */
#line 2998
			status = lstatus;
#line 2998
	}
#line 2998

#line 2998
	if (rndup != 0)
#line 2998
		xp += X_SIZEOF_USHORT;
#line 2998

#line 2998
	*xpp = (void *)xp;
#line 2998
	return status;
#line 2998
}
#line 2998

int
#line 2999
ncx_pad_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 2999
{
#line 2999
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2999

#line 2999
	const char *xp = (const char *) *xpp;
#line 2999
	int status = NC_NOERR;
#line 2999

#line 2999
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2999
	{
#line 2999
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 2999
		if (status == NC_NOERR) /* report the first encountered error */
#line 2999
			status = lstatus;
#line 2999
	}
#line 2999

#line 2999
	if (rndup != 0)
#line 2999
		xp += X_SIZEOF_USHORT;
#line 2999

#line 2999
	*xpp = (void *)xp;
#line 2999
	return status;
#line 2999
}
#line 2999

int
#line 3000
ncx_pad_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 3000
{
#line 3000
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3000

#line 3000
	const char *xp = (const char *) *xpp;
#line 3000
	int status = NC_NOERR;
#line 3000

#line 3000
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3000
	{
#line 3000
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 3000
		if (status == NC_NOERR) /* report the first encountered error */
#line 3000
			status = lstatus;
#line 3000
	}
#line 3000

#line 3000
	if (rndup != 0)
#line 3000
		xp += X_SIZEOF_USHORT;
#line 3000

#line 3000
	*xpp = (void *)xp;
#line 3000
	return status;
#line 3000
}
#line 3000

int
#line 3001
ncx_pad_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 3001
{
#line 3001
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3001

#line 3001
	const char *xp = (const char *) *xpp;
#line 3001
	int status = NC_NOERR;
#line 3001

#line 3001
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3001
	{
#line 3001
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 3001
		if (status == NC_NOERR) /* report the first encountered error */
#line 3001
			status = lstatus;
#line 3001
	}
#line 3001

#line 3001
	if (rndup != 0)
#line 3001
		xp += X_SIZEOF_USHORT;
#line 3001

#line 3001
	*xpp = (void *)xp;
#line 3001
	return status;
#line 3001
}
#line 3001

int
#line 3002
ncx_pad_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 3002
{
#line 3002
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3002

#line 3002
	const char *xp = (const char *) *xpp;
#line 3002
	int status = NC_NOERR;
#line 3002

#line 3002
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3002
	{
#line 3002
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 3002
		if (status == NC_NOERR) /* report the first encountered error */
#line 3002
			status = lstatus;
#line 3002
	}
#line 3002

#line 3002
	if (rndup != 0)
#line 3002
		xp += X_SIZEOF_USHORT;
#line 3002

#line 3002
	*xpp = (void *)xp;
#line 3002
	return status;
#line 3002
}
#line 3002

int
#line 3003
ncx_pad_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3003
{
#line 3003
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3003

#line 3003
	const char *xp = (const char *) *xpp;
#line 3003
	int status = NC_NOERR;
#line 3003

#line 3003
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3003
	{
#line 3003
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 3003
		if (status == NC_NOERR) /* report the first encountered error */
#line 3003
			status = lstatus;
#line 3003
	}
#line 3003

#line 3003
	if (rndup != 0)
#line 3003
		xp += X_SIZEOF_USHORT;
#line 3003

#line 3003
	*xpp = (void *)xp;
#line 3003
	return status;
#line 3003
}
#line 3003

int
#line 3004
ncx_pad_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3004
{
#line 3004
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3004

#line 3004
	const char *xp = (const char *) *xpp;
#line 3004
	int status = NC_NOERR;
#line 3004

#line 3004
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3004
	{
#line 3004
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 3004
		if (status == NC_NOERR) /* report the first encountered error */
#line 3004
			status = lstatus;
#line 3004
	}
#line 3004

#line 3004
	if (rndup != 0)
#line 3004
		xp += X_SIZEOF_USHORT;
#line 3004

#line 3004
	*xpp = (void *)xp;
#line 3004
	return status;
#line 3004
}
#line 3004

int
#line 3005
ncx_pad_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3005
{
#line 3005
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3005

#line 3005
	const char *xp = (const char *) *xpp;
#line 3005
	int status = NC_NOERR;
#line 3005

#line 3005
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3005
	{
#line 3005
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3005
		if (status == NC_NOERR) /* report the first encountered error */
#line 3005
			status = lstatus;
#line 3005
	}
#line 3005

#line 3005
	if (rndup != 0)
#line 3005
		xp += X_SIZEOF_USHORT;
#line 3005

#line 3005
	*xpp = (void *)xp;
#line 3005
	return status;
#line 3005
}
#line 3005

int
#line 3006
ncx_pad_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3006
{
#line 3006
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3006

#line 3006
	const char *xp = (const char *) *xpp;
#line 3006
	int status = NC_NOERR;
#line 3006

#line 3006
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3006
	{
#line 3006
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 3006
		if (status == NC_NOERR) /* report the first encountered error */
#line 3006
			status = lstatus;
#line 3006
	}
#line 3006

#line 3006
	if (rndup != 0)
#line 3006
		xp += X_SIZEOF_USHORT;
#line 3006

#line 3006
	*xpp = (void *)xp;
#line 3006
	return status;
#line 3006
}
#line 3006

int
#line 3007
ncx_pad_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3007
{
#line 3007
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3007

#line 3007
	const char *xp = (const char *) *xpp;
#line 3007
	int status = NC_NOERR;
#line 3007

#line 3007
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3007
	{
#line 3007
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3007
		if (status == NC_NOERR) /* report the first encountered error */
#line 3007
			status = lstatus;
#line 3007
	}
#line 3007

#line 3007
	if (rndup != 0)
#line 3007
		xp += X_SIZEOF_USHORT;
#line 3007

#line 3007
	*xpp = (void *)xp;
#line 3007
	return status;
#line 3007
}
#line 3007


#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const unsigned short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_USHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 3023
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3023
{
#line 3023
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3023

#line 3023
 /* basic algorithm is:
#line 3023
  *   - ensure sane alignment of output data
#line 3023
  *   - copy (conversion happens automatically) input data
#line 3023
  *     to output
#line 3023
  *   - update tp to point at next unconverted input, and xpp to point
#line 3023
  *     at next location for converted output
#line 3023
  */
#line 3023
  long i, j, ni;
#line 3023
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3023
  ushort *xp;
#line 3023
  int nrange = 0;         /* number of range errors */
#line 3023
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3023
  long cxp = (long) *((char**)xpp);
#line 3023

#line 3023
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3023
  /* sjl: manually stripmine so we can limit amount of
#line 3023
   * vector work space reserved to LOOPCNT elements. Also
#line 3023
   * makes vectorisation easy */
#line 3023
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3023
    ni=Min(nelems-j,LOOPCNT);
#line 3023
    if (realign) {
#line 3023
      xp = tmp;
#line 3023
    } else {
#line 3023
      xp = (ushort *) *xpp;
#line 3023
    }
#line 3023
   /* copy the next block */
#line 3023
#pragma cdir loopcnt=LOOPCNT
#line 3023
#pragma cdir shortloop
#line 3023
    for (i=0; i<ni; i++) {
#line 3023
      /* the normal case: */
#line 3023
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3023
     /* test for range errors (not always needed but do it anyway) */
#line 3023
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3023
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3023
      nrange += tp[i] > X_USHORT_MAX ;
#line 3023
    }
#line 3023
   /* copy workspace back if necessary */
#line 3023
    if (realign) {
#line 3023
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3023
      xp = (ushort *) *xpp;
#line 3023
    }
#line 3023
   /* update xpp and tp */
#line 3023
    xp += ni;
#line 3023
    tp += ni;
#line 3023
    *xpp = (void*)xp;
#line 3023
  }
#line 3023
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3023

#line 3023
#else   /* not SX */
#line 3023

#line 3023
	char *xp = (char *) *xpp;
#line 3023
	int status = NC_NOERR;
#line 3023

#line 3023
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3023
	{
#line 3023
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3023
		if (status == NC_NOERR) /* report the first encountered error */
#line 3023
			status = lstatus;
#line 3023
	}
#line 3023

#line 3023
	*xpp = (void *)xp;
#line 3023
	return status;
#line 3023
#endif
#line 3023
}
#line 3023

#endif
int
#line 3025
ncx_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3025
{
#line 3025
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3025

#line 3025
 /* basic algorithm is:
#line 3025
  *   - ensure sane alignment of output data
#line 3025
  *   - copy (conversion happens automatically) input data
#line 3025
  *     to output
#line 3025
  *   - update tp to point at next unconverted input, and xpp to point
#line 3025
  *     at next location for converted output
#line 3025
  */
#line 3025
  long i, j, ni;
#line 3025
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3025
  ushort *xp;
#line 3025
  int nrange = 0;         /* number of range errors */
#line 3025
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3025
  long cxp = (long) *((char**)xpp);
#line 3025

#line 3025
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3025
  /* sjl: manually stripmine so we can limit amount of
#line 3025
   * vector work space reserved to LOOPCNT elements. Also
#line 3025
   * makes vectorisation easy */
#line 3025
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3025
    ni=Min(nelems-j,LOOPCNT);
#line 3025
    if (realign) {
#line 3025
      xp = tmp;
#line 3025
    } else {
#line 3025
      xp = (ushort *) *xpp;
#line 3025
    }
#line 3025
   /* copy the next block */
#line 3025
#pragma cdir loopcnt=LOOPCNT
#line 3025
#pragma cdir shortloop
#line 3025
    for (i=0; i<ni; i++) {
#line 3025
      /* the normal case: */
#line 3025
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3025
     /* test for range errors (not always needed but do it anyway) */
#line 3025
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3025
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3025
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3025
    }
#line 3025
   /* copy workspace back if necessary */
#line 3025
    if (realign) {
#line 3025
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3025
      xp = (ushort *) *xpp;
#line 3025
    }
#line 3025
   /* update xpp and tp */
#line 3025
    xp += ni;
#line 3025
    tp += ni;
#line 3025
    *xpp = (void*)xp;
#line 3025
  }
#line 3025
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3025

#line 3025
#else   /* not SX */
#line 3025

#line 3025
	char *xp = (char *) *xpp;
#line 3025
	int status = NC_NOERR;
#line 3025

#line 3025
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3025
	{
#line 3025
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3025
		if (status == NC_NOERR) /* report the first encountered error */
#line 3025
			status = lstatus;
#line 3025
	}
#line 3025

#line 3025
	*xpp = (void *)xp;
#line 3025
	return status;
#line 3025
#endif
#line 3025
}
#line 3025

int
#line 3026
ncx_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3026
{
#line 3026
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3026

#line 3026
 /* basic algorithm is:
#line 3026
  *   - ensure sane alignment of output data
#line 3026
  *   - copy (conversion happens automatically) input data
#line 3026
  *     to output
#line 3026
  *   - update tp to point at next unconverted input, and xpp to point
#line 3026
  *     at next location for converted output
#line 3026
  */
#line 3026
  long i, j, ni;
#line 3026
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3026
  ushort *xp;
#line 3026
  int nrange = 0;         /* number of range errors */
#line 3026
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3026
  long cxp = (long) *((char**)xpp);
#line 3026

#line 3026
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3026
  /* sjl: manually stripmine so we can limit amount of
#line 3026
   * vector work space reserved to LOOPCNT elements. Also
#line 3026
   * makes vectorisation easy */
#line 3026
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3026
    ni=Min(nelems-j,LOOPCNT);
#line 3026
    if (realign) {
#line 3026
      xp = tmp;
#line 3026
    } else {
#line 3026
      xp = (ushort *) *xpp;
#line 3026
    }
#line 3026
   /* copy the next block */
#line 3026
#pragma cdir loopcnt=LOOPCNT
#line 3026
#pragma cdir shortloop
#line 3026
    for (i=0; i<ni; i++) {
#line 3026
      /* the normal case: */
#line 3026
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3026
     /* test for range errors (not always needed but do it anyway) */
#line 3026
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3026
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3026
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3026
    }
#line 3026
   /* copy workspace back if necessary */
#line 3026
    if (realign) {
#line 3026
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3026
      xp = (ushort *) *xpp;
#line 3026
    }
#line 3026
   /* update xpp and tp */
#line 3026
    xp += ni;
#line 3026
    tp += ni;
#line 3026
    *xpp = (void*)xp;
#line 3026
  }
#line 3026
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3026

#line 3026
#else   /* not SX */
#line 3026

#line 3026
	char *xp = (char *) *xpp;
#line 3026
	int status = NC_NOERR;
#line 3026

#line 3026
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3026
	{
#line 3026
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3026
		if (status == NC_NOERR) /* report the first encountered error */
#line 3026
			status = lstatus;
#line 3026
	}
#line 3026

#line 3026
	*xpp = (void *)xp;
#line 3026
	return status;
#line 3026
#endif
#line 3026
}
#line 3026

int
#line 3027
ncx_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3027
{
#line 3027
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3027

#line 3027
 /* basic algorithm is:
#line 3027
  *   - ensure sane alignment of output data
#line 3027
  *   - copy (conversion happens automatically) input data
#line 3027
  *     to output
#line 3027
  *   - update tp to point at next unconverted input, and xpp to point
#line 3027
  *     at next location for converted output
#line 3027
  */
#line 3027
  long i, j, ni;
#line 3027
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3027
  ushort *xp;
#line 3027
  int nrange = 0;         /* number of range errors */
#line 3027
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3027
  long cxp = (long) *((char**)xpp);
#line 3027

#line 3027
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3027
  /* sjl: manually stripmine so we can limit amount of
#line 3027
   * vector work space reserved to LOOPCNT elements. Also
#line 3027
   * makes vectorisation easy */
#line 3027
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3027
    ni=Min(nelems-j,LOOPCNT);
#line 3027
    if (realign) {
#line 3027
      xp = tmp;
#line 3027
    } else {
#line 3027
      xp = (ushort *) *xpp;
#line 3027
    }
#line 3027
   /* copy the next block */
#line 3027
#pragma cdir loopcnt=LOOPCNT
#line 3027
#pragma cdir shortloop
#line 3027
    for (i=0; i<ni; i++) {
#line 3027
      /* the normal case: */
#line 3027
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3027
     /* test for range errors (not always needed but do it anyway) */
#line 3027
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3027
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3027
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3027
    }
#line 3027
   /* copy workspace back if necessary */
#line 3027
    if (realign) {
#line 3027
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3027
      xp = (ushort *) *xpp;
#line 3027
    }
#line 3027
   /* update xpp and tp */
#line 3027
    xp += ni;
#line 3027
    tp += ni;
#line 3027
    *xpp = (void*)xp;
#line 3027
  }
#line 3027
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3027

#line 3027
#else   /* not SX */
#line 3027

#line 3027
	char *xp = (char *) *xpp;
#line 3027
	int status = NC_NOERR;
#line 3027

#line 3027
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3027
	{
#line 3027
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3027
		if (status == NC_NOERR) /* report the first encountered error */
#line 3027
			status = lstatus;
#line 3027
	}
#line 3027

#line 3027
	*xpp = (void *)xp;
#line 3027
	return status;
#line 3027
#endif
#line 3027
}
#line 3027

int
#line 3028
ncx_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3028
{
#line 3028
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3028

#line 3028
 /* basic algorithm is:
#line 3028
  *   - ensure sane alignment of output data
#line 3028
  *   - copy (conversion happens automatically) input data
#line 3028
  *     to output
#line 3028
  *   - update tp to point at next unconverted input, and xpp to point
#line 3028
  *     at next location for converted output
#line 3028
  */
#line 3028
  long i, j, ni;
#line 3028
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3028
  ushort *xp;
#line 3028
  int nrange = 0;         /* number of range errors */
#line 3028
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3028
  long cxp = (long) *((char**)xpp);
#line 3028

#line 3028
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3028
  /* sjl: manually stripmine so we can limit amount of
#line 3028
   * vector work space reserved to LOOPCNT elements. Also
#line 3028
   * makes vectorisation easy */
#line 3028
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3028
    ni=Min(nelems-j,LOOPCNT);
#line 3028
    if (realign) {
#line 3028
      xp = tmp;
#line 3028
    } else {
#line 3028
      xp = (ushort *) *xpp;
#line 3028
    }
#line 3028
   /* copy the next block */
#line 3028
#pragma cdir loopcnt=LOOPCNT
#line 3028
#pragma cdir shortloop
#line 3028
    for (i=0; i<ni; i++) {
#line 3028
      /* the normal case: */
#line 3028
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3028
     /* test for range errors (not always needed but do it anyway) */
#line 3028
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3028
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3028
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3028
    }
#line 3028
   /* copy workspace back if necessary */
#line 3028
    if (realign) {
#line 3028
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3028
      xp = (ushort *) *xpp;
#line 3028
    }
#line 3028
   /* update xpp and tp */
#line 3028
    xp += ni;
#line 3028
    tp += ni;
#line 3028
    *xpp = (void*)xp;
#line 3028
  }
#line 3028
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3028

#line 3028
#else   /* not SX */
#line 3028

#line 3028
	char *xp = (char *) *xpp;
#line 3028
	int status = NC_NOERR;
#line 3028

#line 3028
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3028
	{
#line 3028
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3028
		if (status == NC_NOERR) /* report the first encountered error */
#line 3028
			status = lstatus;
#line 3028
	}
#line 3028

#line 3028
	*xpp = (void *)xp;
#line 3028
	return status;
#line 3028
#endif
#line 3028
}
#line 3028

int
#line 3029
ncx_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3029
{
#line 3029
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3029

#line 3029
 /* basic algorithm is:
#line 3029
  *   - ensure sane alignment of output data
#line 3029
  *   - copy (conversion happens automatically) input data
#line 3029
  *     to output
#line 3029
  *   - update tp to point at next unconverted input, and xpp to point
#line 3029
  *     at next location for converted output
#line 3029
  */
#line 3029
  long i, j, ni;
#line 3029
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3029
  ushort *xp;
#line 3029
  int nrange = 0;         /* number of range errors */
#line 3029
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3029
  long cxp = (long) *((char**)xpp);
#line 3029

#line 3029
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3029
  /* sjl: manually stripmine so we can limit amount of
#line 3029
   * vector work space reserved to LOOPCNT elements. Also
#line 3029
   * makes vectorisation easy */
#line 3029
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3029
    ni=Min(nelems-j,LOOPCNT);
#line 3029
    if (realign) {
#line 3029
      xp = tmp;
#line 3029
    } else {
#line 3029
      xp = (ushort *) *xpp;
#line 3029
    }
#line 3029
   /* copy the next block */
#line 3029
#pragma cdir loopcnt=LOOPCNT
#line 3029
#pragma cdir shortloop
#line 3029
    for (i=0; i<ni; i++) {
#line 3029
      /* the normal case: */
#line 3029
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3029
     /* test for range errors (not always needed but do it anyway) */
#line 3029
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3029
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3029
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3029
    }
#line 3029
   /* copy workspace back if necessary */
#line 3029
    if (realign) {
#line 3029
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3029
      xp = (ushort *) *xpp;
#line 3029
    }
#line 3029
   /* update xpp and tp */
#line 3029
    xp += ni;
#line 3029
    tp += ni;
#line 3029
    *xpp = (void*)xp;
#line 3029
  }
#line 3029
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3029

#line 3029
#else   /* not SX */
#line 3029

#line 3029
	char *xp = (char *) *xpp;
#line 3029
	int status = NC_NOERR;
#line 3029

#line 3029
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3029
	{
#line 3029
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3029
		if (status == NC_NOERR) /* report the first encountered error */
#line 3029
			status = lstatus;
#line 3029
	}
#line 3029

#line 3029
	*xpp = (void *)xp;
#line 3029
	return status;
#line 3029
#endif
#line 3029
}
#line 3029

int
#line 3030
ncx_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3030
{
#line 3030
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3030

#line 3030
 /* basic algorithm is:
#line 3030
  *   - ensure sane alignment of output data
#line 3030
  *   - copy (conversion happens automatically) input data
#line 3030
  *     to output
#line 3030
  *   - update tp to point at next unconverted input, and xpp to point
#line 3030
  *     at next location for converted output
#line 3030
  */
#line 3030
  long i, j, ni;
#line 3030
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3030
  ushort *xp;
#line 3030
  int nrange = 0;         /* number of range errors */
#line 3030
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3030
  long cxp = (long) *((char**)xpp);
#line 3030

#line 3030
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3030
  /* sjl: manually stripmine so we can limit amount of
#line 3030
   * vector work space reserved to LOOPCNT elements. Also
#line 3030
   * makes vectorisation easy */
#line 3030
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3030
    ni=Min(nelems-j,LOOPCNT);
#line 3030
    if (realign) {
#line 3030
      xp = tmp;
#line 3030
    } else {
#line 3030
      xp = (ushort *) *xpp;
#line 3030
    }
#line 3030
   /* copy the next block */
#line 3030
#pragma cdir loopcnt=LOOPCNT
#line 3030
#pragma cdir shortloop
#line 3030
    for (i=0; i<ni; i++) {
#line 3030
      /* the normal case: */
#line 3030
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3030
     /* test for range errors (not always needed but do it anyway) */
#line 3030
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3030
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3030
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3030
    }
#line 3030
   /* copy workspace back if necessary */
#line 3030
    if (realign) {
#line 3030
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3030
      xp = (ushort *) *xpp;
#line 3030
    }
#line 3030
   /* update xpp and tp */
#line 3030
    xp += ni;
#line 3030
    tp += ni;
#line 3030
    *xpp = (void*)xp;
#line 3030
  }
#line 3030
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3030

#line 3030
#else   /* not SX */
#line 3030

#line 3030
	char *xp = (char *) *xpp;
#line 3030
	int status = NC_NOERR;
#line 3030

#line 3030
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3030
	{
#line 3030
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3030
		if (status == NC_NOERR) /* report the first encountered error */
#line 3030
			status = lstatus;
#line 3030
	}
#line 3030

#line 3030
	*xpp = (void *)xp;
#line 3030
	return status;
#line 3030
#endif
#line 3030
}
#line 3030

int
#line 3031
ncx_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3031
{
#line 3031
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3031

#line 3031
 /* basic algorithm is:
#line 3031
  *   - ensure sane alignment of output data
#line 3031
  *   - copy (conversion happens automatically) input data
#line 3031
  *     to output
#line 3031
  *   - update tp to point at next unconverted input, and xpp to point
#line 3031
  *     at next location for converted output
#line 3031
  */
#line 3031
  long i, j, ni;
#line 3031
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3031
  ushort *xp;
#line 3031
  int nrange = 0;         /* number of range errors */
#line 3031
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3031
  long cxp = (long) *((char**)xpp);
#line 3031

#line 3031
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3031
  /* sjl: manually stripmine so we can limit amount of
#line 3031
   * vector work space reserved to LOOPCNT elements. Also
#line 3031
   * makes vectorisation easy */
#line 3031
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3031
    ni=Min(nelems-j,LOOPCNT);
#line 3031
    if (realign) {
#line 3031
      xp = tmp;
#line 3031
    } else {
#line 3031
      xp = (ushort *) *xpp;
#line 3031
    }
#line 3031
   /* copy the next block */
#line 3031
#pragma cdir loopcnt=LOOPCNT
#line 3031
#pragma cdir shortloop
#line 3031
    for (i=0; i<ni; i++) {
#line 3031
      /* the normal case: */
#line 3031
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3031
     /* test for range errors (not always needed but do it anyway) */
#line 3031
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3031
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3031
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3031
    }
#line 3031
   /* copy workspace back if necessary */
#line 3031
    if (realign) {
#line 3031
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3031
      xp = (ushort *) *xpp;
#line 3031
    }
#line 3031
   /* update xpp and tp */
#line 3031
    xp += ni;
#line 3031
    tp += ni;
#line 3031
    *xpp = (void*)xp;
#line 3031
  }
#line 3031
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3031

#line 3031
#else   /* not SX */
#line 3031

#line 3031
	char *xp = (char *) *xpp;
#line 3031
	int status = NC_NOERR;
#line 3031

#line 3031
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3031
	{
#line 3031
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3031
		if (status == NC_NOERR) /* report the first encountered error */
#line 3031
			status = lstatus;
#line 3031
	}
#line 3031

#line 3031
	*xpp = (void *)xp;
#line 3031
	return status;
#line 3031
#endif
#line 3031
}
#line 3031

int
#line 3032
ncx_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3032
{
#line 3032
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3032

#line 3032
 /* basic algorithm is:
#line 3032
  *   - ensure sane alignment of output data
#line 3032
  *   - copy (conversion happens automatically) input data
#line 3032
  *     to output
#line 3032
  *   - update tp to point at next unconverted input, and xpp to point
#line 3032
  *     at next location for converted output
#line 3032
  */
#line 3032
  long i, j, ni;
#line 3032
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3032
  ushort *xp;
#line 3032
  int nrange = 0;         /* number of range errors */
#line 3032
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3032
  long cxp = (long) *((char**)xpp);
#line 3032

#line 3032
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3032
  /* sjl: manually stripmine so we can limit amount of
#line 3032
   * vector work space reserved to LOOPCNT elements. Also
#line 3032
   * makes vectorisation easy */
#line 3032
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3032
    ni=Min(nelems-j,LOOPCNT);
#line 3032
    if (realign) {
#line 3032
      xp = tmp;
#line 3032
    } else {
#line 3032
      xp = (ushort *) *xpp;
#line 3032
    }
#line 3032
   /* copy the next block */
#line 3032
#pragma cdir loopcnt=LOOPCNT
#line 3032
#pragma cdir shortloop
#line 3032
    for (i=0; i<ni; i++) {
#line 3032
      /* the normal case: */
#line 3032
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3032
     /* test for range errors (not always needed but do it anyway) */
#line 3032
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3032
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3032
      nrange += tp[i] > X_USHORT_MAX ;
#line 3032
    }
#line 3032
   /* copy workspace back if necessary */
#line 3032
    if (realign) {
#line 3032
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3032
      xp = (ushort *) *xpp;
#line 3032
    }
#line 3032
   /* update xpp and tp */
#line 3032
    xp += ni;
#line 3032
    tp += ni;
#line 3032
    *xpp = (void*)xp;
#line 3032
  }
#line 3032
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3032

#line 3032
#else   /* not SX */
#line 3032

#line 3032
	char *xp = (char *) *xpp;
#line 3032
	int status = NC_NOERR;
#line 3032

#line 3032
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3032
	{
#line 3032
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3032
		if (status == NC_NOERR) /* report the first encountered error */
#line 3032
			status = lstatus;
#line 3032
	}
#line 3032

#line 3032
	*xpp = (void *)xp;
#line 3032
	return status;
#line 3032
#endif
#line 3032
}
#line 3032

int
#line 3033
ncx_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3033
{
#line 3033
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3033

#line 3033
 /* basic algorithm is:
#line 3033
  *   - ensure sane alignment of output data
#line 3033
  *   - copy (conversion happens automatically) input data
#line 3033
  *     to output
#line 3033
  *   - update tp to point at next unconverted input, and xpp to point
#line 3033
  *     at next location for converted output
#line 3033
  */
#line 3033
  long i, j, ni;
#line 3033
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3033
  ushort *xp;
#line 3033
  int nrange = 0;         /* number of range errors */
#line 3033
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3033
  long cxp = (long) *((char**)xpp);
#line 3033

#line 3033
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3033
  /* sjl: manually stripmine so we can limit amount of
#line 3033
   * vector work space reserved to LOOPCNT elements. Also
#line 3033
   * makes vectorisation easy */
#line 3033
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3033
    ni=Min(nelems-j,LOOPCNT);
#line 3033
    if (realign) {
#line 3033
      xp = tmp;
#line 3033
    } else {
#line 3033
      xp = (ushort *) *xpp;
#line 3033
    }
#line 3033
   /* copy the next block */
#line 3033
#pragma cdir loopcnt=LOOPCNT
#line 3033
#pragma cdir shortloop
#line 3033
    for (i=0; i<ni; i++) {
#line 3033
      /* the normal case: */
#line 3033
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3033
     /* test for range errors (not always needed but do it anyway) */
#line 3033
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3033
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3033
      nrange += tp[i] > X_USHORT_MAX ;
#line 3033
    }
#line 3033
   /* copy workspace back if necessary */
#line 3033
    if (realign) {
#line 3033
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3033
      xp = (ushort *) *xpp;
#line 3033
    }
#line 3033
   /* update xpp and tp */
#line 3033
    xp += ni;
#line 3033
    tp += ni;
#line 3033
    *xpp = (void*)xp;
#line 3033
  }
#line 3033
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3033

#line 3033
#else   /* not SX */
#line 3033

#line 3033
	char *xp = (char *) *xpp;
#line 3033
	int status = NC_NOERR;
#line 3033

#line 3033
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3033
	{
#line 3033
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3033
		if (status == NC_NOERR) /* report the first encountered error */
#line 3033
			status = lstatus;
#line 3033
	}
#line 3033

#line 3033
	*xpp = (void *)xp;
#line 3033
	return status;
#line 3033
#endif
#line 3033
}
#line 3033

int
#line 3034
ncx_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3034
{
#line 3034
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3034

#line 3034
 /* basic algorithm is:
#line 3034
  *   - ensure sane alignment of output data
#line 3034
  *   - copy (conversion happens automatically) input data
#line 3034
  *     to output
#line 3034
  *   - update tp to point at next unconverted input, and xpp to point
#line 3034
  *     at next location for converted output
#line 3034
  */
#line 3034
  long i, j, ni;
#line 3034
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3034
  ushort *xp;
#line 3034
  int nrange = 0;         /* number of range errors */
#line 3034
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3034
  long cxp = (long) *((char**)xpp);
#line 3034

#line 3034
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3034
  /* sjl: manually stripmine so we can limit amount of
#line 3034
   * vector work space reserved to LOOPCNT elements. Also
#line 3034
   * makes vectorisation easy */
#line 3034
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3034
    ni=Min(nelems-j,LOOPCNT);
#line 3034
    if (realign) {
#line 3034
      xp = tmp;
#line 3034
    } else {
#line 3034
      xp = (ushort *) *xpp;
#line 3034
    }
#line 3034
   /* copy the next block */
#line 3034
#pragma cdir loopcnt=LOOPCNT
#line 3034
#pragma cdir shortloop
#line 3034
    for (i=0; i<ni; i++) {
#line 3034
      /* the normal case: */
#line 3034
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3034
     /* test for range errors (not always needed but do it anyway) */
#line 3034
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3034
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3034
      nrange += tp[i] > X_USHORT_MAX ;
#line 3034
    }
#line 3034
   /* copy workspace back if necessary */
#line 3034
    if (realign) {
#line 3034
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3034
      xp = (ushort *) *xpp;
#line 3034
    }
#line 3034
   /* update xpp and tp */
#line 3034
    xp += ni;
#line 3034
    tp += ni;
#line 3034
    *xpp = (void*)xp;
#line 3034
  }
#line 3034
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3034

#line 3034
#else   /* not SX */
#line 3034

#line 3034
	char *xp = (char *) *xpp;
#line 3034
	int status = NC_NOERR;
#line 3034

#line 3034
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3034
	{
#line 3034
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3034
		if (status == NC_NOERR) /* report the first encountered error */
#line 3034
			status = lstatus;
#line 3034
	}
#line 3034

#line 3034
	*xpp = (void *)xp;
#line 3034
	return status;
#line 3034
#endif
#line 3034
}
#line 3034


int
#line 3036
ncx_pad_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3036
{
#line 3036
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3036

#line 3036
	char *xp = (char *) *xpp;
#line 3036
	int status = NC_NOERR;
#line 3036

#line 3036
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3036
	{
#line 3036
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3036
		if (status == NC_NOERR) /* report the first encountered error */
#line 3036
			status = lstatus;
#line 3036
	}
#line 3036

#line 3036
	if (rndup != 0)
#line 3036
	{
#line 3036
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3036
		xp += X_SIZEOF_USHORT;
#line 3036
	}
#line 3036

#line 3036
	*xpp = (void *)xp;
#line 3036
	return status;
#line 3036
}
#line 3036

int
#line 3037
ncx_pad_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3037
{
#line 3037
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3037

#line 3037
	char *xp = (char *) *xpp;
#line 3037
	int status = NC_NOERR;
#line 3037

#line 3037
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3037
	{
#line 3037
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3037
		if (status == NC_NOERR) /* report the first encountered error */
#line 3037
			status = lstatus;
#line 3037
	}
#line 3037

#line 3037
	if (rndup != 0)
#line 3037
	{
#line 3037
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3037
		xp += X_SIZEOF_USHORT;
#line 3037
	}
#line 3037

#line 3037
	*xpp = (void *)xp;
#line 3037
	return status;
#line 3037
}
#line 3037

int
#line 3038
ncx_pad_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3038
{
#line 3038
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3038

#line 3038
	char *xp = (char *) *xpp;
#line 3038
	int status = NC_NOERR;
#line 3038

#line 3038
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3038
	{
#line 3038
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3038
		if (status == NC_NOERR) /* report the first encountered error */
#line 3038
			status = lstatus;
#line 3038
	}
#line 3038

#line 3038
	if (rndup != 0)
#line 3038
	{
#line 3038
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3038
		xp += X_SIZEOF_USHORT;
#line 3038
	}
#line 3038

#line 3038
	*xpp = (void *)xp;
#line 3038
	return status;
#line 3038
}
#line 3038

int
#line 3039
ncx_pad_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3039
{
#line 3039
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3039

#line 3039
	char *xp = (char *) *xpp;
#line 3039
	int status = NC_NOERR;
#line 3039

#line 3039
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3039
	{
#line 3039
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3039
		if (status == NC_NOERR) /* report the first encountered error */
#line 3039
			status = lstatus;
#line 3039
	}
#line 3039

#line 3039
	if (rndup != 0)
#line 3039
	{
#line 3039
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3039
		xp += X_SIZEOF_USHORT;
#line 3039
	}
#line 3039

#line 3039
	*xpp = (void *)xp;
#line 3039
	return status;
#line 3039
}
#line 3039

int
#line 3040
ncx_pad_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3040
{
#line 3040
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3040

#line 3040
	char *xp = (char *) *xpp;
#line 3040
	int status = NC_NOERR;
#line 3040

#line 3040
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3040
	{
#line 3040
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3040
		if (status == NC_NOERR) /* report the first encountered error */
#line 3040
			status = lstatus;
#line 3040
	}
#line 3040

#line 3040
	if (rndup != 0)
#line 3040
	{
#line 3040
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3040
		xp += X_SIZEOF_USHORT;
#line 3040
	}
#line 3040

#line 3040
	*xpp = (void *)xp;
#line 3040
	return status;
#line 3040
}
#line 3040

int
#line 3041
ncx_pad_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3041
{
#line 3041
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3041

#line 3041
	char *xp = (char *) *xpp;
#line 3041
	int status = NC_NOERR;
#line 3041

#line 3041
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3041
	{
#line 3041
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3041
		if (status == NC_NOERR) /* report the first encountered error */
#line 3041
			status = lstatus;
#line 3041
	}
#line 3041

#line 3041
	if (rndup != 0)
#line 3041
	{
#line 3041
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3041
		xp += X_SIZEOF_USHORT;
#line 3041
	}
#line 3041

#line 3041
	*xpp = (void *)xp;
#line 3041
	return status;
#line 3041
}
#line 3041

int
#line 3042
ncx_pad_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3042
{
#line 3042
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3042

#line 3042
	char *xp = (char *) *xpp;
#line 3042
	int status = NC_NOERR;
#line 3042

#line 3042
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3042
	{
#line 3042
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3042
		if (status == NC_NOERR) /* report the first encountered error */
#line 3042
			status = lstatus;
#line 3042
	}
#line 3042

#line 3042
	if (rndup != 0)
#line 3042
	{
#line 3042
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3042
		xp += X_SIZEOF_USHORT;
#line 3042
	}
#line 3042

#line 3042
	*xpp = (void *)xp;
#line 3042
	return status;
#line 3042
}
#line 3042

int
#line 3043
ncx_pad_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3043
{
#line 3043
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3043

#line 3043
	char *xp = (char *) *xpp;
#line 3043
	int status = NC_NOERR;
#line 3043

#line 3043
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3043
	{
#line 3043
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3043
		if (status == NC_NOERR) /* report the first encountered error */
#line 3043
			status = lstatus;
#line 3043
	}
#line 3043

#line 3043
	if (rndup != 0)
#line 3043
	{
#line 3043
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3043
		xp += X_SIZEOF_USHORT;
#line 3043
	}
#line 3043

#line 3043
	*xpp = (void *)xp;
#line 3043
	return status;
#line 3043
}
#line 3043

int
#line 3044
ncx_pad_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3044
{
#line 3044
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3044

#line 3044
	char *xp = (char *) *xpp;
#line 3044
	int status = NC_NOERR;
#line 3044

#line 3044
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3044
	{
#line 3044
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3044
		if (status == NC_NOERR) /* report the first encountered error */
#line 3044
			status = lstatus;
#line 3044
	}
#line 3044

#line 3044
	if (rndup != 0)
#line 3044
	{
#line 3044
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3044
		xp += X_SIZEOF_USHORT;
#line 3044
	}
#line 3044

#line 3044
	*xpp = (void *)xp;
#line 3044
	return status;
#line 3044
}
#line 3044

int
#line 3045
ncx_pad_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3045
{
#line 3045
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3045

#line 3045
	char *xp = (char *) *xpp;
#line 3045
	int status = NC_NOERR;
#line 3045

#line 3045
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3045
	{
#line 3045
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3045
		if (status == NC_NOERR) /* report the first encountered error */
#line 3045
			status = lstatus;
#line 3045
	}
#line 3045

#line 3045
	if (rndup != 0)
#line 3045
	{
#line 3045
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3045
		xp += X_SIZEOF_USHORT;
#line 3045
	}
#line 3045

#line 3045
	*xpp = (void *)xp;
#line 3045
	return status;
#line 3045
}
#line 3045

int
#line 3046
ncx_pad_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3046
{
#line 3046
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3046

#line 3046
	char *xp = (char *) *xpp;
#line 3046
	int status = NC_NOERR;
#line 3046

#line 3046
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3046
	{
#line 3046
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3046
		if (status == NC_NOERR) /* report the first encountered error */
#line 3046
			status = lstatus;
#line 3046
	}
#line 3046

#line 3046
	if (rndup != 0)
#line 3046
	{
#line 3046
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3046
		xp += X_SIZEOF_USHORT;
#line 3046
	}
#line 3046

#line 3046
	*xpp = (void *)xp;
#line 3046
	return status;
#line 3046
}
#line 3046



/* int -----------------------------------------------------------------------*/

#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_INT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3065
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
#line 3065
{
#line 3065
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3065

#line 3065
 /* basic algorithm is:
#line 3065
  *   - ensure sane alignment of input data
#line 3065
  *   - copy (conversion happens automatically) input data
#line 3065
  *     to output
#line 3065
  *   - update xpp to point at next unconverted input, and tp to point
#line 3065
  *     at next location for converted output
#line 3065
  */
#line 3065
  long i, j, ni;
#line 3065
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3065
  int *xp;
#line 3065
  int nrange = 0;         /* number of range errors */
#line 3065
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3065
  long cxp = (long) *((char**)xpp);
#line 3065

#line 3065
  realign = (cxp & 7) % SIZEOF_INT;
#line 3065
  /* sjl: manually stripmine so we can limit amount of
#line 3065
   * vector work space reserved to LOOPCNT elements. Also
#line 3065
   * makes vectorisation easy */
#line 3065
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3065
    ni=Min(nelems-j,LOOPCNT);
#line 3065
    if (realign) {
#line 3065
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3065
      xp = tmp;
#line 3065
    } else {
#line 3065
      xp = (int *) *xpp;
#line 3065
    }
#line 3065
   /* copy the next block */
#line 3065
#pragma cdir loopcnt=LOOPCNT
#line 3065
#pragma cdir shortloop
#line 3065
    for (i=0; i<ni; i++) {
#line 3065
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3065
     /* test for range errors (not always needed but do it anyway) */
#line 3065
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3065
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3065
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3065
    }
#line 3065
   /* update xpp and tp */
#line 3065
    if (realign) xp = (int *) *xpp;
#line 3065
    xp += ni;
#line 3065
    tp += ni;
#line 3065
    *xpp = (void*)xp;
#line 3065
  }
#line 3065
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3065

#line 3065
#else   /* not SX */
#line 3065
	const char *xp = (const char *) *xpp;
#line 3065
	int status = NC_NOERR;
#line 3065

#line 3065
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3065
	{
#line 3065
		const int lstatus = ncx_get_int_int(xp, tp);
#line 3065
		if (status == NC_NOERR) /* report the first encountered error */
#line 3065
			status = lstatus;
#line 3065
	}
#line 3065

#line 3065
	*xpp = (const void *)xp;
#line 3065
	return status;
#line 3065
#endif
#line 3065
}
#line 3065

#endif
int
#line 3067
ncx_getn_int_schar(const void **xpp, size_t nelems, schar *tp)
#line 3067
{
#line 3067
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3067

#line 3067
 /* basic algorithm is:
#line 3067
  *   - ensure sane alignment of input data
#line 3067
  *   - copy (conversion happens automatically) input data
#line 3067
  *     to output
#line 3067
  *   - update xpp to point at next unconverted input, and tp to point
#line 3067
  *     at next location for converted output
#line 3067
  */
#line 3067
  long i, j, ni;
#line 3067
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3067
  int *xp;
#line 3067
  int nrange = 0;         /* number of range errors */
#line 3067
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3067
  long cxp = (long) *((char**)xpp);
#line 3067

#line 3067
  realign = (cxp & 7) % SIZEOF_INT;
#line 3067
  /* sjl: manually stripmine so we can limit amount of
#line 3067
   * vector work space reserved to LOOPCNT elements. Also
#line 3067
   * makes vectorisation easy */
#line 3067
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3067
    ni=Min(nelems-j,LOOPCNT);
#line 3067
    if (realign) {
#line 3067
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3067
      xp = tmp;
#line 3067
    } else {
#line 3067
      xp = (int *) *xpp;
#line 3067
    }
#line 3067
   /* copy the next block */
#line 3067
#pragma cdir loopcnt=LOOPCNT
#line 3067
#pragma cdir shortloop
#line 3067
    for (i=0; i<ni; i++) {
#line 3067
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3067
     /* test for range errors (not always needed but do it anyway) */
#line 3067
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3067
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3067
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3067
    }
#line 3067
   /* update xpp and tp */
#line 3067
    if (realign) xp = (int *) *xpp;
#line 3067
    xp += ni;
#line 3067
    tp += ni;
#line 3067
    *xpp = (void*)xp;
#line 3067
  }
#line 3067
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3067

#line 3067
#else   /* not SX */
#line 3067
	const char *xp = (const char *) *xpp;
#line 3067
	int status = NC_NOERR;
#line 3067

#line 3067
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3067
	{
#line 3067
		const int lstatus = ncx_get_int_schar(xp, tp);
#line 3067
		if (status == NC_NOERR) /* report the first encountered error */
#line 3067
			status = lstatus;
#line 3067
	}
#line 3067

#line 3067
	*xpp = (const void *)xp;
#line 3067
	return status;
#line 3067
#endif
#line 3067
}
#line 3067

int
#line 3068
ncx_getn_int_short(const void **xpp, size_t nelems, short *tp)
#line 3068
{
#line 3068
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3068

#line 3068
 /* basic algorithm is:
#line 3068
  *   - ensure sane alignment of input data
#line 3068
  *   - copy (conversion happens automatically) input data
#line 3068
  *     to output
#line 3068
  *   - update xpp to point at next unconverted input, and tp to point
#line 3068
  *     at next location for converted output
#line 3068
  */
#line 3068
  long i, j, ni;
#line 3068
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3068
  int *xp;
#line 3068
  int nrange = 0;         /* number of range errors */
#line 3068
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3068
  long cxp = (long) *((char**)xpp);
#line 3068

#line 3068
  realign = (cxp & 7) % SIZEOF_INT;
#line 3068
  /* sjl: manually stripmine so we can limit amount of
#line 3068
   * vector work space reserved to LOOPCNT elements. Also
#line 3068
   * makes vectorisation easy */
#line 3068
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3068
    ni=Min(nelems-j,LOOPCNT);
#line 3068
    if (realign) {
#line 3068
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3068
      xp = tmp;
#line 3068
    } else {
#line 3068
      xp = (int *) *xpp;
#line 3068
    }
#line 3068
   /* copy the next block */
#line 3068
#pragma cdir loopcnt=LOOPCNT
#line 3068
#pragma cdir shortloop
#line 3068
    for (i=0; i<ni; i++) {
#line 3068
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3068
     /* test for range errors (not always needed but do it anyway) */
#line 3068
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3068
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3068
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3068
    }
#line 3068
   /* update xpp and tp */
#line 3068
    if (realign) xp = (int *) *xpp;
#line 3068
    xp += ni;
#line 3068
    tp += ni;
#line 3068
    *xpp = (void*)xp;
#line 3068
  }
#line 3068
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3068

#line 3068
#else   /* not SX */
#line 3068
	const char *xp = (const char *) *xpp;
#line 3068
	int status = NC_NOERR;
#line 3068

#line 3068
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3068
	{
#line 3068
		const int lstatus = ncx_get_int_short(xp, tp);
#line 3068
		if (status == NC_NOERR) /* report the first encountered error */
#line 3068
			status = lstatus;
#line 3068
	}
#line 3068

#line 3068
	*xpp = (const void *)xp;
#line 3068
	return status;
#line 3068
#endif
#line 3068
}
#line 3068

int
#line 3069
ncx_getn_int_long(const void **xpp, size_t nelems, long *tp)
#line 3069
{
#line 3069
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3069

#line 3069
 /* basic algorithm is:
#line 3069
  *   - ensure sane alignment of input data
#line 3069
  *   - copy (conversion happens automatically) input data
#line 3069
  *     to output
#line 3069
  *   - update xpp to point at next unconverted input, and tp to point
#line 3069
  *     at next location for converted output
#line 3069
  */
#line 3069
  long i, j, ni;
#line 3069
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3069
  int *xp;
#line 3069
  int nrange = 0;         /* number of range errors */
#line 3069
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3069
  long cxp = (long) *((char**)xpp);
#line 3069

#line 3069
  realign = (cxp & 7) % SIZEOF_INT;
#line 3069
  /* sjl: manually stripmine so we can limit amount of
#line 3069
   * vector work space reserved to LOOPCNT elements. Also
#line 3069
   * makes vectorisation easy */
#line 3069
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3069
    ni=Min(nelems-j,LOOPCNT);
#line 3069
    if (realign) {
#line 3069
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3069
      xp = tmp;
#line 3069
    } else {
#line 3069
      xp = (int *) *xpp;
#line 3069
    }
#line 3069
   /* copy the next block */
#line 3069
#pragma cdir loopcnt=LOOPCNT
#line 3069
#pragma cdir shortloop
#line 3069
    for (i=0; i<ni; i++) {
#line 3069
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3069
     /* test for range errors (not always needed but do it anyway) */
#line 3069
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3069
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3069
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3069
    }
#line 3069
   /* update xpp and tp */
#line 3069
    if (realign) xp = (int *) *xpp;
#line 3069
    xp += ni;
#line 3069
    tp += ni;
#line 3069
    *xpp = (void*)xp;
#line 3069
  }
#line 3069
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3069

#line 3069
#else   /* not SX */
#line 3069
	const char *xp = (const char *) *xpp;
#line 3069
	int status = NC_NOERR;
#line 3069

#line 3069
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3069
	{
#line 3069
		const int lstatus = ncx_get_int_long(xp, tp);
#line 3069
		if (status == NC_NOERR) /* report the first encountered error */
#line 3069
			status = lstatus;
#line 3069
	}
#line 3069

#line 3069
	*xpp = (const void *)xp;
#line 3069
	return status;
#line 3069
#endif
#line 3069
}
#line 3069

int
#line 3070
ncx_getn_int_float(const void **xpp, size_t nelems, float *tp)
#line 3070
{
#line 3070
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3070

#line 3070
 /* basic algorithm is:
#line 3070
  *   - ensure sane alignment of input data
#line 3070
  *   - copy (conversion happens automatically) input data
#line 3070
  *     to output
#line 3070
  *   - update xpp to point at next unconverted input, and tp to point
#line 3070
  *     at next location for converted output
#line 3070
  */
#line 3070
  long i, j, ni;
#line 3070
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3070
  int *xp;
#line 3070
  int nrange = 0;         /* number of range errors */
#line 3070
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3070
  long cxp = (long) *((char**)xpp);
#line 3070

#line 3070
  realign = (cxp & 7) % SIZEOF_INT;
#line 3070
  /* sjl: manually stripmine so we can limit amount of
#line 3070
   * vector work space reserved to LOOPCNT elements. Also
#line 3070
   * makes vectorisation easy */
#line 3070
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3070
    ni=Min(nelems-j,LOOPCNT);
#line 3070
    if (realign) {
#line 3070
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3070
      xp = tmp;
#line 3070
    } else {
#line 3070
      xp = (int *) *xpp;
#line 3070
    }
#line 3070
   /* copy the next block */
#line 3070
#pragma cdir loopcnt=LOOPCNT
#line 3070
#pragma cdir shortloop
#line 3070
    for (i=0; i<ni; i++) {
#line 3070
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3070
     /* test for range errors (not always needed but do it anyway) */
#line 3070
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3070
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3070
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3070
    }
#line 3070
   /* update xpp and tp */
#line 3070
    if (realign) xp = (int *) *xpp;
#line 3070
    xp += ni;
#line 3070
    tp += ni;
#line 3070
    *xpp = (void*)xp;
#line 3070
  }
#line 3070
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3070

#line 3070
#else   /* not SX */
#line 3070
	const char *xp = (const char *) *xpp;
#line 3070
	int status = NC_NOERR;
#line 3070

#line 3070
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3070
	{
#line 3070
		const int lstatus = ncx_get_int_float(xp, tp);
#line 3070
		if (status == NC_NOERR) /* report the first encountered error */
#line 3070
			status = lstatus;
#line 3070
	}
#line 3070

#line 3070
	*xpp = (const void *)xp;
#line 3070
	return status;
#line 3070
#endif
#line 3070
}
#line 3070

int
#line 3071
ncx_getn_int_double(const void **xpp, size_t nelems, double *tp)
#line 3071
{
#line 3071
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3071

#line 3071
 /* basic algorithm is:
#line 3071
  *   - ensure sane alignment of input data
#line 3071
  *   - copy (conversion happens automatically) input data
#line 3071
  *     to output
#line 3071
  *   - update xpp to point at next unconverted input, and tp to point
#line 3071
  *     at next location for converted output
#line 3071
  */
#line 3071
  long i, j, ni;
#line 3071
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3071
  int *xp;
#line 3071
  int nrange = 0;         /* number of range errors */
#line 3071
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3071
  long cxp = (long) *((char**)xpp);
#line 3071

#line 3071
  realign = (cxp & 7) % SIZEOF_INT;
#line 3071
  /* sjl: manually stripmine so we can limit amount of
#line 3071
   * vector work space reserved to LOOPCNT elements. Also
#line 3071
   * makes vectorisation easy */
#line 3071
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3071
    ni=Min(nelems-j,LOOPCNT);
#line 3071
    if (realign) {
#line 3071
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3071
      xp = tmp;
#line 3071
    } else {
#line 3071
      xp = (int *) *xpp;
#line 3071
    }
#line 3071
   /* copy the next block */
#line 3071
#pragma cdir loopcnt=LOOPCNT
#line 3071
#pragma cdir shortloop
#line 3071
    for (i=0; i<ni; i++) {
#line 3071
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3071
     /* test for range errors (not always needed but do it anyway) */
#line 3071
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3071
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3071
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3071
    }
#line 3071
   /* update xpp and tp */
#line 3071
    if (realign) xp = (int *) *xpp;
#line 3071
    xp += ni;
#line 3071
    tp += ni;
#line 3071
    *xpp = (void*)xp;
#line 3071
  }
#line 3071
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3071

#line 3071
#else   /* not SX */
#line 3071
	const char *xp = (const char *) *xpp;
#line 3071
	int status = NC_NOERR;
#line 3071

#line 3071
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3071
	{
#line 3071
		const int lstatus = ncx_get_int_double(xp, tp);
#line 3071
		if (status == NC_NOERR) /* report the first encountered error */
#line 3071
			status = lstatus;
#line 3071
	}
#line 3071

#line 3071
	*xpp = (const void *)xp;
#line 3071
	return status;
#line 3071
#endif
#line 3071
}
#line 3071

int
#line 3072
ncx_getn_int_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3072
{
#line 3072
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3072

#line 3072
 /* basic algorithm is:
#line 3072
  *   - ensure sane alignment of input data
#line 3072
  *   - copy (conversion happens automatically) input data
#line 3072
  *     to output
#line 3072
  *   - update xpp to point at next unconverted input, and tp to point
#line 3072
  *     at next location for converted output
#line 3072
  */
#line 3072
  long i, j, ni;
#line 3072
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3072
  int *xp;
#line 3072
  int nrange = 0;         /* number of range errors */
#line 3072
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3072
  long cxp = (long) *((char**)xpp);
#line 3072

#line 3072
  realign = (cxp & 7) % SIZEOF_INT;
#line 3072
  /* sjl: manually stripmine so we can limit amount of
#line 3072
   * vector work space reserved to LOOPCNT elements. Also
#line 3072
   * makes vectorisation easy */
#line 3072
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3072
    ni=Min(nelems-j,LOOPCNT);
#line 3072
    if (realign) {
#line 3072
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3072
      xp = tmp;
#line 3072
    } else {
#line 3072
      xp = (int *) *xpp;
#line 3072
    }
#line 3072
   /* copy the next block */
#line 3072
#pragma cdir loopcnt=LOOPCNT
#line 3072
#pragma cdir shortloop
#line 3072
    for (i=0; i<ni; i++) {
#line 3072
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3072
     /* test for range errors (not always needed but do it anyway) */
#line 3072
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3072
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3072
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3072
    }
#line 3072
   /* update xpp and tp */
#line 3072
    if (realign) xp = (int *) *xpp;
#line 3072
    xp += ni;
#line 3072
    tp += ni;
#line 3072
    *xpp = (void*)xp;
#line 3072
  }
#line 3072
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3072

#line 3072
#else   /* not SX */
#line 3072
	const char *xp = (const char *) *xpp;
#line 3072
	int status = NC_NOERR;
#line 3072

#line 3072
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3072
	{
#line 3072
		const int lstatus = ncx_get_int_longlong(xp, tp);
#line 3072
		if (status == NC_NOERR) /* report the first encountered error */
#line 3072
			status = lstatus;
#line 3072
	}
#line 3072

#line 3072
	*xpp = (const void *)xp;
#line 3072
	return status;
#line 3072
#endif
#line 3072
}
#line 3072

int
#line 3073
ncx_getn_int_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3073
{
#line 3073
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3073

#line 3073
 /* basic algorithm is:
#line 3073
  *   - ensure sane alignment of input data
#line 3073
  *   - copy (conversion happens automatically) input data
#line 3073
  *     to output
#line 3073
  *   - update xpp to point at next unconverted input, and tp to point
#line 3073
  *     at next location for converted output
#line 3073
  */
#line 3073
  long i, j, ni;
#line 3073
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3073
  int *xp;
#line 3073
  int nrange = 0;         /* number of range errors */
#line 3073
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3073
  long cxp = (long) *((char**)xpp);
#line 3073

#line 3073
  realign = (cxp & 7) % SIZEOF_INT;
#line 3073
  /* sjl: manually stripmine so we can limit amount of
#line 3073
   * vector work space reserved to LOOPCNT elements. Also
#line 3073
   * makes vectorisation easy */
#line 3073
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3073
    ni=Min(nelems-j,LOOPCNT);
#line 3073
    if (realign) {
#line 3073
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3073
      xp = tmp;
#line 3073
    } else {
#line 3073
      xp = (int *) *xpp;
#line 3073
    }
#line 3073
   /* copy the next block */
#line 3073
#pragma cdir loopcnt=LOOPCNT
#line 3073
#pragma cdir shortloop
#line 3073
    for (i=0; i<ni; i++) {
#line 3073
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3073
     /* test for range errors (not always needed but do it anyway) */
#line 3073
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3073
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3073
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3073
    }
#line 3073
   /* update xpp and tp */
#line 3073
    if (realign) xp = (int *) *xpp;
#line 3073
    xp += ni;
#line 3073
    tp += ni;
#line 3073
    *xpp = (void*)xp;
#line 3073
  }
#line 3073
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3073

#line 3073
#else   /* not SX */
#line 3073
	const char *xp = (const char *) *xpp;
#line 3073
	int status = NC_NOERR;
#line 3073

#line 3073
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3073
	{
#line 3073
		const int lstatus = ncx_get_int_uchar(xp, tp);
#line 3073
		if (status == NC_NOERR) /* report the first encountered error */
#line 3073
			status = lstatus;
#line 3073
	}
#line 3073

#line 3073
	*xpp = (const void *)xp;
#line 3073
	return status;
#line 3073
#endif
#line 3073
}
#line 3073

int
#line 3074
ncx_getn_int_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3074
{
#line 3074
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3074

#line 3074
 /* basic algorithm is:
#line 3074
  *   - ensure sane alignment of input data
#line 3074
  *   - copy (conversion happens automatically) input data
#line 3074
  *     to output
#line 3074
  *   - update xpp to point at next unconverted input, and tp to point
#line 3074
  *     at next location for converted output
#line 3074
  */
#line 3074
  long i, j, ni;
#line 3074
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3074
  int *xp;
#line 3074
  int nrange = 0;         /* number of range errors */
#line 3074
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3074
  long cxp = (long) *((char**)xpp);
#line 3074

#line 3074
  realign = (cxp & 7) % SIZEOF_INT;
#line 3074
  /* sjl: manually stripmine so we can limit amount of
#line 3074
   * vector work space reserved to LOOPCNT elements. Also
#line 3074
   * makes vectorisation easy */
#line 3074
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3074
    ni=Min(nelems-j,LOOPCNT);
#line 3074
    if (realign) {
#line 3074
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3074
      xp = tmp;
#line 3074
    } else {
#line 3074
      xp = (int *) *xpp;
#line 3074
    }
#line 3074
   /* copy the next block */
#line 3074
#pragma cdir loopcnt=LOOPCNT
#line 3074
#pragma cdir shortloop
#line 3074
    for (i=0; i<ni; i++) {
#line 3074
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3074
     /* test for range errors (not always needed but do it anyway) */
#line 3074
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3074
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3074
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3074
    }
#line 3074
   /* update xpp and tp */
#line 3074
    if (realign) xp = (int *) *xpp;
#line 3074
    xp += ni;
#line 3074
    tp += ni;
#line 3074
    *xpp = (void*)xp;
#line 3074
  }
#line 3074
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3074

#line 3074
#else   /* not SX */
#line 3074
	const char *xp = (const char *) *xpp;
#line 3074
	int status = NC_NOERR;
#line 3074

#line 3074
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3074
	{
#line 3074
		const int lstatus = ncx_get_int_ushort(xp, tp);
#line 3074
		if (status == NC_NOERR) /* report the first encountered error */
#line 3074
			status = lstatus;
#line 3074
	}
#line 3074

#line 3074
	*xpp = (const void *)xp;
#line 3074
	return status;
#line 3074
#endif
#line 3074
}
#line 3074

int
#line 3075
ncx_getn_int_uint(const void **xpp, size_t nelems, uint *tp)
#line 3075
{
#line 3075
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3075

#line 3075
 /* basic algorithm is:
#line 3075
  *   - ensure sane alignment of input data
#line 3075
  *   - copy (conversion happens automatically) input data
#line 3075
  *     to output
#line 3075
  *   - update xpp to point at next unconverted input, and tp to point
#line 3075
  *     at next location for converted output
#line 3075
  */
#line 3075
  long i, j, ni;
#line 3075
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3075
  int *xp;
#line 3075
  int nrange = 0;         /* number of range errors */
#line 3075
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3075
  long cxp = (long) *((char**)xpp);
#line 3075

#line 3075
  realign = (cxp & 7) % SIZEOF_INT;
#line 3075
  /* sjl: manually stripmine so we can limit amount of
#line 3075
   * vector work space reserved to LOOPCNT elements. Also
#line 3075
   * makes vectorisation easy */
#line 3075
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3075
    ni=Min(nelems-j,LOOPCNT);
#line 3075
    if (realign) {
#line 3075
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3075
      xp = tmp;
#line 3075
    } else {
#line 3075
      xp = (int *) *xpp;
#line 3075
    }
#line 3075
   /* copy the next block */
#line 3075
#pragma cdir loopcnt=LOOPCNT
#line 3075
#pragma cdir shortloop
#line 3075
    for (i=0; i<ni; i++) {
#line 3075
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3075
     /* test for range errors (not always needed but do it anyway) */
#line 3075
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3075
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3075
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3075
    }
#line 3075
   /* update xpp and tp */
#line 3075
    if (realign) xp = (int *) *xpp;
#line 3075
    xp += ni;
#line 3075
    tp += ni;
#line 3075
    *xpp = (void*)xp;
#line 3075
  }
#line 3075
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3075

#line 3075
#else   /* not SX */
#line 3075
	const char *xp = (const char *) *xpp;
#line 3075
	int status = NC_NOERR;
#line 3075

#line 3075
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3075
	{
#line 3075
		const int lstatus = ncx_get_int_uint(xp, tp);
#line 3075
		if (status == NC_NOERR) /* report the first encountered error */
#line 3075
			status = lstatus;
#line 3075
	}
#line 3075

#line 3075
	*xpp = (const void *)xp;
#line 3075
	return status;
#line 3075
#endif
#line 3075
}
#line 3075

int
#line 3076
ncx_getn_int_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3076
{
#line 3076
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3076

#line 3076
 /* basic algorithm is:
#line 3076
  *   - ensure sane alignment of input data
#line 3076
  *   - copy (conversion happens automatically) input data
#line 3076
  *     to output
#line 3076
  *   - update xpp to point at next unconverted input, and tp to point
#line 3076
  *     at next location for converted output
#line 3076
  */
#line 3076
  long i, j, ni;
#line 3076
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3076
  int *xp;
#line 3076
  int nrange = 0;         /* number of range errors */
#line 3076
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3076
  long cxp = (long) *((char**)xpp);
#line 3076

#line 3076
  realign = (cxp & 7) % SIZEOF_INT;
#line 3076
  /* sjl: manually stripmine so we can limit amount of
#line 3076
   * vector work space reserved to LOOPCNT elements. Also
#line 3076
   * makes vectorisation easy */
#line 3076
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3076
    ni=Min(nelems-j,LOOPCNT);
#line 3076
    if (realign) {
#line 3076
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3076
      xp = tmp;
#line 3076
    } else {
#line 3076
      xp = (int *) *xpp;
#line 3076
    }
#line 3076
   /* copy the next block */
#line 3076
#pragma cdir loopcnt=LOOPCNT
#line 3076
#pragma cdir shortloop
#line 3076
    for (i=0; i<ni; i++) {
#line 3076
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3076
     /* test for range errors (not always needed but do it anyway) */
#line 3076
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3076
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3076
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3076
    }
#line 3076
   /* update xpp and tp */
#line 3076
    if (realign) xp = (int *) *xpp;
#line 3076
    xp += ni;
#line 3076
    tp += ni;
#line 3076
    *xpp = (void*)xp;
#line 3076
  }
#line 3076
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3076

#line 3076
#else   /* not SX */
#line 3076
	const char *xp = (const char *) *xpp;
#line 3076
	int status = NC_NOERR;
#line 3076

#line 3076
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3076
	{
#line 3076
		const int lstatus = ncx_get_int_ulonglong(xp, tp);
#line 3076
		if (status == NC_NOERR) /* report the first encountered error */
#line 3076
			status = lstatus;
#line 3076
	}
#line 3076

#line 3076
	*xpp = (const void *)xp;
#line 3076
	return status;
#line 3076
#endif
#line 3076
}
#line 3076


#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3092
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3092
{
#line 3092
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3092

#line 3092
 /* basic algorithm is:
#line 3092
  *   - ensure sane alignment of output data
#line 3092
  *   - copy (conversion happens automatically) input data
#line 3092
  *     to output
#line 3092
  *   - update tp to point at next unconverted input, and xpp to point
#line 3092
  *     at next location for converted output
#line 3092
  */
#line 3092
  long i, j, ni;
#line 3092
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3092
  int *xp;
#line 3092
  int nrange = 0;         /* number of range errors */
#line 3092
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3092
  long cxp = (long) *((char**)xpp);
#line 3092

#line 3092
  realign = (cxp & 7) % SIZEOF_INT;
#line 3092
  /* sjl: manually stripmine so we can limit amount of
#line 3092
   * vector work space reserved to LOOPCNT elements. Also
#line 3092
   * makes vectorisation easy */
#line 3092
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3092
    ni=Min(nelems-j,LOOPCNT);
#line 3092
    if (realign) {
#line 3092
      xp = tmp;
#line 3092
    } else {
#line 3092
      xp = (int *) *xpp;
#line 3092
    }
#line 3092
   /* copy the next block */
#line 3092
#pragma cdir loopcnt=LOOPCNT
#line 3092
#pragma cdir shortloop
#line 3092
    for (i=0; i<ni; i++) {
#line 3092
      /* the normal case: */
#line 3092
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3092
     /* test for range errors (not always needed but do it anyway) */
#line 3092
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3092
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3092
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3092
    }
#line 3092
   /* copy workspace back if necessary */
#line 3092
    if (realign) {
#line 3092
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3092
      xp = (int *) *xpp;
#line 3092
    }
#line 3092
   /* update xpp and tp */
#line 3092
    xp += ni;
#line 3092
    tp += ni;
#line 3092
    *xpp = (void*)xp;
#line 3092
  }
#line 3092
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3092

#line 3092
#else   /* not SX */
#line 3092

#line 3092
	char *xp = (char *) *xpp;
#line 3092
	int status = NC_NOERR;
#line 3092

#line 3092
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3092
	{
#line 3092
		int lstatus = ncx_put_int_int(xp, tp, fillp);
#line 3092
		if (status == NC_NOERR) /* report the first encountered error */
#line 3092
			status = lstatus;
#line 3092
	}
#line 3092

#line 3092
	*xpp = (void *)xp;
#line 3092
	return status;
#line 3092
#endif
#line 3092
}
#line 3092

#endif
int
#line 3094
ncx_putn_int_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3094
{
#line 3094
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3094

#line 3094
 /* basic algorithm is:
#line 3094
  *   - ensure sane alignment of output data
#line 3094
  *   - copy (conversion happens automatically) input data
#line 3094
  *     to output
#line 3094
  *   - update tp to point at next unconverted input, and xpp to point
#line 3094
  *     at next location for converted output
#line 3094
  */
#line 3094
  long i, j, ni;
#line 3094
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3094
  int *xp;
#line 3094
  int nrange = 0;         /* number of range errors */
#line 3094
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3094
  long cxp = (long) *((char**)xpp);
#line 3094

#line 3094
  realign = (cxp & 7) % SIZEOF_INT;
#line 3094
  /* sjl: manually stripmine so we can limit amount of
#line 3094
   * vector work space reserved to LOOPCNT elements. Also
#line 3094
   * makes vectorisation easy */
#line 3094
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3094
    ni=Min(nelems-j,LOOPCNT);
#line 3094
    if (realign) {
#line 3094
      xp = tmp;
#line 3094
    } else {
#line 3094
      xp = (int *) *xpp;
#line 3094
    }
#line 3094
   /* copy the next block */
#line 3094
#pragma cdir loopcnt=LOOPCNT
#line 3094
#pragma cdir shortloop
#line 3094
    for (i=0; i<ni; i++) {
#line 3094
      /* the normal case: */
#line 3094
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3094
     /* test for range errors (not always needed but do it anyway) */
#line 3094
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3094
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3094
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3094
    }
#line 3094
   /* copy workspace back if necessary */
#line 3094
    if (realign) {
#line 3094
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3094
      xp = (int *) *xpp;
#line 3094
    }
#line 3094
   /* update xpp and tp */
#line 3094
    xp += ni;
#line 3094
    tp += ni;
#line 3094
    *xpp = (void*)xp;
#line 3094
  }
#line 3094
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3094

#line 3094
#else   /* not SX */
#line 3094

#line 3094
	char *xp = (char *) *xpp;
#line 3094
	int status = NC_NOERR;
#line 3094

#line 3094
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3094
	{
#line 3094
		int lstatus = ncx_put_int_schar(xp, tp, fillp);
#line 3094
		if (status == NC_NOERR) /* report the first encountered error */
#line 3094
			status = lstatus;
#line 3094
	}
#line 3094

#line 3094
	*xpp = (void *)xp;
#line 3094
	return status;
#line 3094
#endif
#line 3094
}
#line 3094

int
#line 3095
ncx_putn_int_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3095
{
#line 3095
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3095

#line 3095
 /* basic algorithm is:
#line 3095
  *   - ensure sane alignment of output data
#line 3095
  *   - copy (conversion happens automatically) input data
#line 3095
  *     to output
#line 3095
  *   - update tp to point at next unconverted input, and xpp to point
#line 3095
  *     at next location for converted output
#line 3095
  */
#line 3095
  long i, j, ni;
#line 3095
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3095
  int *xp;
#line 3095
  int nrange = 0;         /* number of range errors */
#line 3095
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3095
  long cxp = (long) *((char**)xpp);
#line 3095

#line 3095
  realign = (cxp & 7) % SIZEOF_INT;
#line 3095
  /* sjl: manually stripmine so we can limit amount of
#line 3095
   * vector work space reserved to LOOPCNT elements. Also
#line 3095
   * makes vectorisation easy */
#line 3095
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3095
    ni=Min(nelems-j,LOOPCNT);
#line 3095
    if (realign) {
#line 3095
      xp = tmp;
#line 3095
    } else {
#line 3095
      xp = (int *) *xpp;
#line 3095
    }
#line 3095
   /* copy the next block */
#line 3095
#pragma cdir loopcnt=LOOPCNT
#line 3095
#pragma cdir shortloop
#line 3095
    for (i=0; i<ni; i++) {
#line 3095
      /* the normal case: */
#line 3095
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3095
     /* test for range errors (not always needed but do it anyway) */
#line 3095
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3095
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3095
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3095
    }
#line 3095
   /* copy workspace back if necessary */
#line 3095
    if (realign) {
#line 3095
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3095
      xp = (int *) *xpp;
#line 3095
    }
#line 3095
   /* update xpp and tp */
#line 3095
    xp += ni;
#line 3095
    tp += ni;
#line 3095
    *xpp = (void*)xp;
#line 3095
  }
#line 3095
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3095

#line 3095
#else   /* not SX */
#line 3095

#line 3095
	char *xp = (char *) *xpp;
#line 3095
	int status = NC_NOERR;
#line 3095

#line 3095
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3095
	{
#line 3095
		int lstatus = ncx_put_int_short(xp, tp, fillp);
#line 3095
		if (status == NC_NOERR) /* report the first encountered error */
#line 3095
			status = lstatus;
#line 3095
	}
#line 3095

#line 3095
	*xpp = (void *)xp;
#line 3095
	return status;
#line 3095
#endif
#line 3095
}
#line 3095

int
#line 3096
ncx_putn_int_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3096
{
#line 3096
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3096

#line 3096
 /* basic algorithm is:
#line 3096
  *   - ensure sane alignment of output data
#line 3096
  *   - copy (conversion happens automatically) input data
#line 3096
  *     to output
#line 3096
  *   - update tp to point at next unconverted input, and xpp to point
#line 3096
  *     at next location for converted output
#line 3096
  */
#line 3096
  long i, j, ni;
#line 3096
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3096
  int *xp;
#line 3096
  int nrange = 0;         /* number of range errors */
#line 3096
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3096
  long cxp = (long) *((char**)xpp);
#line 3096

#line 3096
  realign = (cxp & 7) % SIZEOF_INT;
#line 3096
  /* sjl: manually stripmine so we can limit amount of
#line 3096
   * vector work space reserved to LOOPCNT elements. Also
#line 3096
   * makes vectorisation easy */
#line 3096
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3096
    ni=Min(nelems-j,LOOPCNT);
#line 3096
    if (realign) {
#line 3096
      xp = tmp;
#line 3096
    } else {
#line 3096
      xp = (int *) *xpp;
#line 3096
    }
#line 3096
   /* copy the next block */
#line 3096
#pragma cdir loopcnt=LOOPCNT
#line 3096
#pragma cdir shortloop
#line 3096
    for (i=0; i<ni; i++) {
#line 3096
      /* the normal case: */
#line 3096
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3096
     /* test for range errors (not always needed but do it anyway) */
#line 3096
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3096
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3096
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3096
    }
#line 3096
   /* copy workspace back if necessary */
#line 3096
    if (realign) {
#line 3096
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3096
      xp = (int *) *xpp;
#line 3096
    }
#line 3096
   /* update xpp and tp */
#line 3096
    xp += ni;
#line 3096
    tp += ni;
#line 3096
    *xpp = (void*)xp;
#line 3096
  }
#line 3096
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3096

#line 3096
#else   /* not SX */
#line 3096

#line 3096
	char *xp = (char *) *xpp;
#line 3096
	int status = NC_NOERR;
#line 3096

#line 3096
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3096
	{
#line 3096
		int lstatus = ncx_put_int_long(xp, tp, fillp);
#line 3096
		if (status == NC_NOERR) /* report the first encountered error */
#line 3096
			status = lstatus;
#line 3096
	}
#line 3096

#line 3096
	*xpp = (void *)xp;
#line 3096
	return status;
#line 3096
#endif
#line 3096
}
#line 3096

int
#line 3097
ncx_putn_int_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3097
{
#line 3097
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3097

#line 3097
 /* basic algorithm is:
#line 3097
  *   - ensure sane alignment of output data
#line 3097
  *   - copy (conversion happens automatically) input data
#line 3097
  *     to output
#line 3097
  *   - update tp to point at next unconverted input, and xpp to point
#line 3097
  *     at next location for converted output
#line 3097
  */
#line 3097
  long i, j, ni;
#line 3097
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3097
  int *xp;
#line 3097
  double d;               /* special case for ncx_putn_int_float */
#line 3097
  int nrange = 0;         /* number of range errors */
#line 3097
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3097
  long cxp = (long) *((char**)xpp);
#line 3097

#line 3097
  realign = (cxp & 7) % SIZEOF_INT;
#line 3097
  /* sjl: manually stripmine so we can limit amount of
#line 3097
   * vector work space reserved to LOOPCNT elements. Also
#line 3097
   * makes vectorisation easy */
#line 3097
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3097
    ni=Min(nelems-j,LOOPCNT);
#line 3097
    if (realign) {
#line 3097
      xp = tmp;
#line 3097
    } else {
#line 3097
      xp = (int *) *xpp;
#line 3097
    }
#line 3097
   /* copy the next block */
#line 3097
#pragma cdir loopcnt=LOOPCNT
#line 3097
#pragma cdir shortloop
#line 3097
    for (i=0; i<ni; i++) {
#line 3097
      /* for some reason int to float, for putn, requires a special case */
#line 3097
      d = tp[i];
#line 3097
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) d));
#line 3097
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3097
    }
#line 3097
   /* copy workspace back if necessary */
#line 3097
    if (realign) {
#line 3097
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3097
      xp = (int *) *xpp;
#line 3097
    }
#line 3097
   /* update xpp and tp */
#line 3097
    xp += ni;
#line 3097
    tp += ni;
#line 3097
    *xpp = (void*)xp;
#line 3097
  }
#line 3097
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3097

#line 3097
#else   /* not SX */
#line 3097

#line 3097
	char *xp = (char *) *xpp;
#line 3097
	int status = NC_NOERR;
#line 3097

#line 3097
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3097
	{
#line 3097
		int lstatus = ncx_put_int_float(xp, tp, fillp);
#line 3097
		if (status == NC_NOERR) /* report the first encountered error */
#line 3097
			status = lstatus;
#line 3097
	}
#line 3097

#line 3097
	*xpp = (void *)xp;
#line 3097
	return status;
#line 3097
#endif
#line 3097
}
#line 3097

int
#line 3098
ncx_putn_int_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3098
{
#line 3098
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3098

#line 3098
 /* basic algorithm is:
#line 3098
  *   - ensure sane alignment of output data
#line 3098
  *   - copy (conversion happens automatically) input data
#line 3098
  *     to output
#line 3098
  *   - update tp to point at next unconverted input, and xpp to point
#line 3098
  *     at next location for converted output
#line 3098
  */
#line 3098
  long i, j, ni;
#line 3098
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3098
  int *xp;
#line 3098
  int nrange = 0;         /* number of range errors */
#line 3098
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3098
  long cxp = (long) *((char**)xpp);
#line 3098

#line 3098
  realign = (cxp & 7) % SIZEOF_INT;
#line 3098
  /* sjl: manually stripmine so we can limit amount of
#line 3098
   * vector work space reserved to LOOPCNT elements. Also
#line 3098
   * makes vectorisation easy */
#line 3098
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3098
    ni=Min(nelems-j,LOOPCNT);
#line 3098
    if (realign) {
#line 3098
      xp = tmp;
#line 3098
    } else {
#line 3098
      xp = (int *) *xpp;
#line 3098
    }
#line 3098
   /* copy the next block */
#line 3098
#pragma cdir loopcnt=LOOPCNT
#line 3098
#pragma cdir shortloop
#line 3098
    for (i=0; i<ni; i++) {
#line 3098
      /* the normal case: */
#line 3098
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3098
     /* test for range errors (not always needed but do it anyway) */
#line 3098
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3098
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3098
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3098
    }
#line 3098
   /* copy workspace back if necessary */
#line 3098
    if (realign) {
#line 3098
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3098
      xp = (int *) *xpp;
#line 3098
    }
#line 3098
   /* update xpp and tp */
#line 3098
    xp += ni;
#line 3098
    tp += ni;
#line 3098
    *xpp = (void*)xp;
#line 3098
  }
#line 3098
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3098

#line 3098
#else   /* not SX */
#line 3098

#line 3098
	char *xp = (char *) *xpp;
#line 3098
	int status = NC_NOERR;
#line 3098

#line 3098
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3098
	{
#line 3098
		int lstatus = ncx_put_int_double(xp, tp, fillp);
#line 3098
		if (status == NC_NOERR) /* report the first encountered error */
#line 3098
			status = lstatus;
#line 3098
	}
#line 3098

#line 3098
	*xpp = (void *)xp;
#line 3098
	return status;
#line 3098
#endif
#line 3098
}
#line 3098

int
#line 3099
ncx_putn_int_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3099
{
#line 3099
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3099

#line 3099
 /* basic algorithm is:
#line 3099
  *   - ensure sane alignment of output data
#line 3099
  *   - copy (conversion happens automatically) input data
#line 3099
  *     to output
#line 3099
  *   - update tp to point at next unconverted input, and xpp to point
#line 3099
  *     at next location for converted output
#line 3099
  */
#line 3099
  long i, j, ni;
#line 3099
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3099
  int *xp;
#line 3099
  int nrange = 0;         /* number of range errors */
#line 3099
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3099
  long cxp = (long) *((char**)xpp);
#line 3099

#line 3099
  realign = (cxp & 7) % SIZEOF_INT;
#line 3099
  /* sjl: manually stripmine so we can limit amount of
#line 3099
   * vector work space reserved to LOOPCNT elements. Also
#line 3099
   * makes vectorisation easy */
#line 3099
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3099
    ni=Min(nelems-j,LOOPCNT);
#line 3099
    if (realign) {
#line 3099
      xp = tmp;
#line 3099
    } else {
#line 3099
      xp = (int *) *xpp;
#line 3099
    }
#line 3099
   /* copy the next block */
#line 3099
#pragma cdir loopcnt=LOOPCNT
#line 3099
#pragma cdir shortloop
#line 3099
    for (i=0; i<ni; i++) {
#line 3099
      /* the normal case: */
#line 3099
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3099
     /* test for range errors (not always needed but do it anyway) */
#line 3099
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3099
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3099
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3099
    }
#line 3099
   /* copy workspace back if necessary */
#line 3099
    if (realign) {
#line 3099
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3099
      xp = (int *) *xpp;
#line 3099
    }
#line 3099
   /* update xpp and tp */
#line 3099
    xp += ni;
#line 3099
    tp += ni;
#line 3099
    *xpp = (void*)xp;
#line 3099
  }
#line 3099
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3099

#line 3099
#else   /* not SX */
#line 3099

#line 3099
	char *xp = (char *) *xpp;
#line 3099
	int status = NC_NOERR;
#line 3099

#line 3099
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3099
	{
#line 3099
		int lstatus = ncx_put_int_longlong(xp, tp, fillp);
#line 3099
		if (status == NC_NOERR) /* report the first encountered error */
#line 3099
			status = lstatus;
#line 3099
	}
#line 3099

#line 3099
	*xpp = (void *)xp;
#line 3099
	return status;
#line 3099
#endif
#line 3099
}
#line 3099

int
#line 3100
ncx_putn_int_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3100
{
#line 3100
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3100

#line 3100
 /* basic algorithm is:
#line 3100
  *   - ensure sane alignment of output data
#line 3100
  *   - copy (conversion happens automatically) input data
#line 3100
  *     to output
#line 3100
  *   - update tp to point at next unconverted input, and xpp to point
#line 3100
  *     at next location for converted output
#line 3100
  */
#line 3100
  long i, j, ni;
#line 3100
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3100
  int *xp;
#line 3100
  int nrange = 0;         /* number of range errors */
#line 3100
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3100
  long cxp = (long) *((char**)xpp);
#line 3100

#line 3100
  realign = (cxp & 7) % SIZEOF_INT;
#line 3100
  /* sjl: manually stripmine so we can limit amount of
#line 3100
   * vector work space reserved to LOOPCNT elements. Also
#line 3100
   * makes vectorisation easy */
#line 3100
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3100
    ni=Min(nelems-j,LOOPCNT);
#line 3100
    if (realign) {
#line 3100
      xp = tmp;
#line 3100
    } else {
#line 3100
      xp = (int *) *xpp;
#line 3100
    }
#line 3100
   /* copy the next block */
#line 3100
#pragma cdir loopcnt=LOOPCNT
#line 3100
#pragma cdir shortloop
#line 3100
    for (i=0; i<ni; i++) {
#line 3100
      /* the normal case: */
#line 3100
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3100
     /* test for range errors (not always needed but do it anyway) */
#line 3100
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3100
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3100
      nrange += tp[i] > X_INT_MAX ;
#line 3100
    }
#line 3100
   /* copy workspace back if necessary */
#line 3100
    if (realign) {
#line 3100
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3100
      xp = (int *) *xpp;
#line 3100
    }
#line 3100
   /* update xpp and tp */
#line 3100
    xp += ni;
#line 3100
    tp += ni;
#line 3100
    *xpp = (void*)xp;
#line 3100
  }
#line 3100
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3100

#line 3100
#else   /* not SX */
#line 3100

#line 3100
	char *xp = (char *) *xpp;
#line 3100
	int status = NC_NOERR;
#line 3100

#line 3100
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3100
	{
#line 3100
		int lstatus = ncx_put_int_uchar(xp, tp, fillp);
#line 3100
		if (status == NC_NOERR) /* report the first encountered error */
#line 3100
			status = lstatus;
#line 3100
	}
#line 3100

#line 3100
	*xpp = (void *)xp;
#line 3100
	return status;
#line 3100
#endif
#line 3100
}
#line 3100

int
#line 3101
ncx_putn_int_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3101
{
#line 3101
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3101

#line 3101
 /* basic algorithm is:
#line 3101
  *   - ensure sane alignment of output data
#line 3101
  *   - copy (conversion happens automatically) input data
#line 3101
  *     to output
#line 3101
  *   - update tp to point at next unconverted input, and xpp to point
#line 3101
  *     at next location for converted output
#line 3101
  */
#line 3101
  long i, j, ni;
#line 3101
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3101
  int *xp;
#line 3101
  int nrange = 0;         /* number of range errors */
#line 3101
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3101
  long cxp = (long) *((char**)xpp);
#line 3101

#line 3101
  realign = (cxp & 7) % SIZEOF_INT;
#line 3101
  /* sjl: manually stripmine so we can limit amount of
#line 3101
   * vector work space reserved to LOOPCNT elements. Also
#line 3101
   * makes vectorisation easy */
#line 3101
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3101
    ni=Min(nelems-j,LOOPCNT);
#line 3101
    if (realign) {
#line 3101
      xp = tmp;
#line 3101
    } else {
#line 3101
      xp = (int *) *xpp;
#line 3101
    }
#line 3101
   /* copy the next block */
#line 3101
#pragma cdir loopcnt=LOOPCNT
#line 3101
#pragma cdir shortloop
#line 3101
    for (i=0; i<ni; i++) {
#line 3101
      /* the normal case: */
#line 3101
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3101
     /* test for range errors (not always needed but do it anyway) */
#line 3101
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3101
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3101
      nrange += tp[i] > X_INT_MAX ;
#line 3101
    }
#line 3101
   /* copy workspace back if necessary */
#line 3101
    if (realign) {
#line 3101
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3101
      xp = (int *) *xpp;
#line 3101
    }
#line 3101
   /* update xpp and tp */
#line 3101
    xp += ni;
#line 3101
    tp += ni;
#line 3101
    *xpp = (void*)xp;
#line 3101
  }
#line 3101
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3101

#line 3101
#else   /* not SX */
#line 3101

#line 3101
	char *xp = (char *) *xpp;
#line 3101
	int status = NC_NOERR;
#line 3101

#line 3101
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3101
	{
#line 3101
		int lstatus = ncx_put_int_ushort(xp, tp, fillp);
#line 3101
		if (status == NC_NOERR) /* report the first encountered error */
#line 3101
			status = lstatus;
#line 3101
	}
#line 3101

#line 3101
	*xpp = (void *)xp;
#line 3101
	return status;
#line 3101
#endif
#line 3101
}
#line 3101

int
#line 3102
ncx_putn_int_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3102
{
#line 3102
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3102

#line 3102
 /* basic algorithm is:
#line 3102
  *   - ensure sane alignment of output data
#line 3102
  *   - copy (conversion happens automatically) input data
#line 3102
  *     to output
#line 3102
  *   - update tp to point at next unconverted input, and xpp to point
#line 3102
  *     at next location for converted output
#line 3102
  */
#line 3102
  long i, j, ni;
#line 3102
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3102
  int *xp;
#line 3102
  int nrange = 0;         /* number of range errors */
#line 3102
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3102
  long cxp = (long) *((char**)xpp);
#line 3102

#line 3102
  realign = (cxp & 7) % SIZEOF_INT;
#line 3102
  /* sjl: manually stripmine so we can limit amount of
#line 3102
   * vector work space reserved to LOOPCNT elements. Also
#line 3102
   * makes vectorisation easy */
#line 3102
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3102
    ni=Min(nelems-j,LOOPCNT);
#line 3102
    if (realign) {
#line 3102
      xp = tmp;
#line 3102
    } else {
#line 3102
      xp = (int *) *xpp;
#line 3102
    }
#line 3102
   /* copy the next block */
#line 3102
#pragma cdir loopcnt=LOOPCNT
#line 3102
#pragma cdir shortloop
#line 3102
    for (i=0; i<ni; i++) {
#line 3102
      /* the normal case: */
#line 3102
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3102
     /* test for range errors (not always needed but do it anyway) */
#line 3102
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3102
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3102
      nrange += tp[i] > X_INT_MAX ;
#line 3102
    }
#line 3102
   /* copy workspace back if necessary */
#line 3102
    if (realign) {
#line 3102
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3102
      xp = (int *) *xpp;
#line 3102
    }
#line 3102
   /* update xpp and tp */
#line 3102
    xp += ni;
#line 3102
    tp += ni;
#line 3102
    *xpp = (void*)xp;
#line 3102
  }
#line 3102
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3102

#line 3102
#else   /* not SX */
#line 3102

#line 3102
	char *xp = (char *) *xpp;
#line 3102
	int status = NC_NOERR;
#line 3102

#line 3102
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3102
	{
#line 3102
		int lstatus = ncx_put_int_uint(xp, tp, fillp);
#line 3102
		if (status == NC_NOERR) /* report the first encountered error */
#line 3102
			status = lstatus;
#line 3102
	}
#line 3102

#line 3102
	*xpp = (void *)xp;
#line 3102
	return status;
#line 3102
#endif
#line 3102
}
#line 3102

int
#line 3103
ncx_putn_int_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3103
{
#line 3103
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3103

#line 3103
 /* basic algorithm is:
#line 3103
  *   - ensure sane alignment of output data
#line 3103
  *   - copy (conversion happens automatically) input data
#line 3103
  *     to output
#line 3103
  *   - update tp to point at next unconverted input, and xpp to point
#line 3103
  *     at next location for converted output
#line 3103
  */
#line 3103
  long i, j, ni;
#line 3103
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3103
  int *xp;
#line 3103
  int nrange = 0;         /* number of range errors */
#line 3103
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3103
  long cxp = (long) *((char**)xpp);
#line 3103

#line 3103
  realign = (cxp & 7) % SIZEOF_INT;
#line 3103
  /* sjl: manually stripmine so we can limit amount of
#line 3103
   * vector work space reserved to LOOPCNT elements. Also
#line 3103
   * makes vectorisation easy */
#line 3103
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3103
    ni=Min(nelems-j,LOOPCNT);
#line 3103
    if (realign) {
#line 3103
      xp = tmp;
#line 3103
    } else {
#line 3103
      xp = (int *) *xpp;
#line 3103
    }
#line 3103
   /* copy the next block */
#line 3103
#pragma cdir loopcnt=LOOPCNT
#line 3103
#pragma cdir shortloop
#line 3103
    for (i=0; i<ni; i++) {
#line 3103
      /* the normal case: */
#line 3103
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3103
     /* test for range errors (not always needed but do it anyway) */
#line 3103
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3103
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3103
      nrange += tp[i] > X_INT_MAX ;
#line 3103
    }
#line 3103
   /* copy workspace back if necessary */
#line 3103
    if (realign) {
#line 3103
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3103
      xp = (int *) *xpp;
#line 3103
    }
#line 3103
   /* update xpp and tp */
#line 3103
    xp += ni;
#line 3103
    tp += ni;
#line 3103
    *xpp = (void*)xp;
#line 3103
  }
#line 3103
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3103

#line 3103
#else   /* not SX */
#line 3103

#line 3103
	char *xp = (char *) *xpp;
#line 3103
	int status = NC_NOERR;
#line 3103

#line 3103
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3103
	{
#line 3103
		int lstatus = ncx_put_int_ulonglong(xp, tp, fillp);
#line 3103
		if (status == NC_NOERR) /* report the first encountered error */
#line 3103
			status = lstatus;
#line 3103
	}
#line 3103

#line 3103
	*xpp = (void *)xp;
#line 3103
	return status;
#line 3103
#endif
#line 3103
}
#line 3103


/* uint ----------------------------------------------------------------------*/

#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_getn_uint_uint(const void **xpp, size_t nelems, unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UINT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3121
ncx_getn_uint_uint(const void **xpp, size_t nelems, uint *tp)
#line 3121
{
#line 3121
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3121

#line 3121
 /* basic algorithm is:
#line 3121
  *   - ensure sane alignment of input data
#line 3121
  *   - copy (conversion happens automatically) input data
#line 3121
  *     to output
#line 3121
  *   - update xpp to point at next unconverted input, and tp to point
#line 3121
  *     at next location for converted output
#line 3121
  */
#line 3121
  long i, j, ni;
#line 3121
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3121
  uint *xp;
#line 3121
  int nrange = 0;         /* number of range errors */
#line 3121
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3121
  long cxp = (long) *((char**)xpp);
#line 3121

#line 3121
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3121
  /* sjl: manually stripmine so we can limit amount of
#line 3121
   * vector work space reserved to LOOPCNT elements. Also
#line 3121
   * makes vectorisation easy */
#line 3121
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3121
    ni=Min(nelems-j,LOOPCNT);
#line 3121
    if (realign) {
#line 3121
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3121
      xp = tmp;
#line 3121
    } else {
#line 3121
      xp = (uint *) *xpp;
#line 3121
    }
#line 3121
   /* copy the next block */
#line 3121
#pragma cdir loopcnt=LOOPCNT
#line 3121
#pragma cdir shortloop
#line 3121
    for (i=0; i<ni; i++) {
#line 3121
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3121
     /* test for range errors (not always needed but do it anyway) */
#line 3121
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3121
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3121
      nrange += xp[i] > UINT_MAX ;
#line 3121
    }
#line 3121
   /* update xpp and tp */
#line 3121
    if (realign) xp = (uint *) *xpp;
#line 3121
    xp += ni;
#line 3121
    tp += ni;
#line 3121
    *xpp = (void*)xp;
#line 3121
  }
#line 3121
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3121

#line 3121
#else   /* not SX */
#line 3121
	const char *xp = (const char *) *xpp;
#line 3121
	int status = NC_NOERR;
#line 3121

#line 3121
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3121
	{
#line 3121
		const int lstatus = ncx_get_uint_uint(xp, tp);
#line 3121
		if (status == NC_NOERR) /* report the first encountered error */
#line 3121
			status = lstatus;
#line 3121
	}
#line 3121

#line 3121
	*xpp = (const void *)xp;
#line 3121
	return status;
#line 3121
#endif
#line 3121
}
#line 3121

#endif
int
#line 3123
ncx_getn_uint_schar(const void **xpp, size_t nelems, schar *tp)
#line 3123
{
#line 3123
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3123

#line 3123
 /* basic algorithm is:
#line 3123
  *   - ensure sane alignment of input data
#line 3123
  *   - copy (conversion happens automatically) input data
#line 3123
  *     to output
#line 3123
  *   - update xpp to point at next unconverted input, and tp to point
#line 3123
  *     at next location for converted output
#line 3123
  */
#line 3123
  long i, j, ni;
#line 3123
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3123
  uint *xp;
#line 3123
  int nrange = 0;         /* number of range errors */
#line 3123
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3123
  long cxp = (long) *((char**)xpp);
#line 3123

#line 3123
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3123
  /* sjl: manually stripmine so we can limit amount of
#line 3123
   * vector work space reserved to LOOPCNT elements. Also
#line 3123
   * makes vectorisation easy */
#line 3123
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3123
    ni=Min(nelems-j,LOOPCNT);
#line 3123
    if (realign) {
#line 3123
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3123
      xp = tmp;
#line 3123
    } else {
#line 3123
      xp = (uint *) *xpp;
#line 3123
    }
#line 3123
   /* copy the next block */
#line 3123
#pragma cdir loopcnt=LOOPCNT
#line 3123
#pragma cdir shortloop
#line 3123
    for (i=0; i<ni; i++) {
#line 3123
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3123
     /* test for range errors (not always needed but do it anyway) */
#line 3123
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3123
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3123
      nrange += xp[i] > SCHAR_MAX ;
#line 3123
    }
#line 3123
   /* update xpp and tp */
#line 3123
    if (realign) xp = (uint *) *xpp;
#line 3123
    xp += ni;
#line 3123
    tp += ni;
#line 3123
    *xpp = (void*)xp;
#line 3123
  }
#line 3123
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3123

#line 3123
#else   /* not SX */
#line 3123
	const char *xp = (const char *) *xpp;
#line 3123
	int status = NC_NOERR;
#line 3123

#line 3123
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3123
	{
#line 3123
		const int lstatus = ncx_get_uint_schar(xp, tp);
#line 3123
		if (status == NC_NOERR) /* report the first encountered error */
#line 3123
			status = lstatus;
#line 3123
	}
#line 3123

#line 3123
	*xpp = (const void *)xp;
#line 3123
	return status;
#line 3123
#endif
#line 3123
}
#line 3123

int
#line 3124
ncx_getn_uint_short(const void **xpp, size_t nelems, short *tp)
#line 3124
{
#line 3124
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3124

#line 3124
 /* basic algorithm is:
#line 3124
  *   - ensure sane alignment of input data
#line 3124
  *   - copy (conversion happens automatically) input data
#line 3124
  *     to output
#line 3124
  *   - update xpp to point at next unconverted input, and tp to point
#line 3124
  *     at next location for converted output
#line 3124
  */
#line 3124
  long i, j, ni;
#line 3124
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3124
  uint *xp;
#line 3124
  int nrange = 0;         /* number of range errors */
#line 3124
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3124
  long cxp = (long) *((char**)xpp);
#line 3124

#line 3124
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3124
  /* sjl: manually stripmine so we can limit amount of
#line 3124
   * vector work space reserved to LOOPCNT elements. Also
#line 3124
   * makes vectorisation easy */
#line 3124
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3124
    ni=Min(nelems-j,LOOPCNT);
#line 3124
    if (realign) {
#line 3124
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3124
      xp = tmp;
#line 3124
    } else {
#line 3124
      xp = (uint *) *xpp;
#line 3124
    }
#line 3124
   /* copy the next block */
#line 3124
#pragma cdir loopcnt=LOOPCNT
#line 3124
#pragma cdir shortloop
#line 3124
    for (i=0; i<ni; i++) {
#line 3124
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3124
     /* test for range errors (not always needed but do it anyway) */
#line 3124
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3124
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3124
      nrange += xp[i] > SHORT_MAX ;
#line 3124
    }
#line 3124
   /* update xpp and tp */
#line 3124
    if (realign) xp = (uint *) *xpp;
#line 3124
    xp += ni;
#line 3124
    tp += ni;
#line 3124
    *xpp = (void*)xp;
#line 3124
  }
#line 3124
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3124

#line 3124
#else   /* not SX */
#line 3124
	const char *xp = (const char *) *xpp;
#line 3124
	int status = NC_NOERR;
#line 3124

#line 3124
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3124
	{
#line 3124
		const int lstatus = ncx_get_uint_short(xp, tp);
#line 3124
		if (status == NC_NOERR) /* report the first encountered error */
#line 3124
			status = lstatus;
#line 3124
	}
#line 3124

#line 3124
	*xpp = (const void *)xp;
#line 3124
	return status;
#line 3124
#endif
#line 3124
}
#line 3124

int
#line 3125
ncx_getn_uint_int(const void **xpp, size_t nelems, int *tp)
#line 3125
{
#line 3125
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3125

#line 3125
 /* basic algorithm is:
#line 3125
  *   - ensure sane alignment of input data
#line 3125
  *   - copy (conversion happens automatically) input data
#line 3125
  *     to output
#line 3125
  *   - update xpp to point at next unconverted input, and tp to point
#line 3125
  *     at next location for converted output
#line 3125
  */
#line 3125
  long i, j, ni;
#line 3125
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3125
  uint *xp;
#line 3125
  int nrange = 0;         /* number of range errors */
#line 3125
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3125
  long cxp = (long) *((char**)xpp);
#line 3125

#line 3125
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3125
  /* sjl: manually stripmine so we can limit amount of
#line 3125
   * vector work space reserved to LOOPCNT elements. Also
#line 3125
   * makes vectorisation easy */
#line 3125
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3125
    ni=Min(nelems-j,LOOPCNT);
#line 3125
    if (realign) {
#line 3125
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3125
      xp = tmp;
#line 3125
    } else {
#line 3125
      xp = (uint *) *xpp;
#line 3125
    }
#line 3125
   /* copy the next block */
#line 3125
#pragma cdir loopcnt=LOOPCNT
#line 3125
#pragma cdir shortloop
#line 3125
    for (i=0; i<ni; i++) {
#line 3125
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3125
     /* test for range errors (not always needed but do it anyway) */
#line 3125
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3125
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3125
      nrange += xp[i] > INT_MAX ;
#line 3125
    }
#line 3125
   /* update xpp and tp */
#line 3125
    if (realign) xp = (uint *) *xpp;
#line 3125
    xp += ni;
#line 3125
    tp += ni;
#line 3125
    *xpp = (void*)xp;
#line 3125
  }
#line 3125
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3125

#line 3125
#else   /* not SX */
#line 3125
	const char *xp = (const char *) *xpp;
#line 3125
	int status = NC_NOERR;
#line 3125

#line 3125
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3125
	{
#line 3125
		const int lstatus = ncx_get_uint_int(xp, tp);
#line 3125
		if (status == NC_NOERR) /* report the first encountered error */
#line 3125
			status = lstatus;
#line 3125
	}
#line 3125

#line 3125
	*xpp = (const void *)xp;
#line 3125
	return status;
#line 3125
#endif
#line 3125
}
#line 3125

int
#line 3126
ncx_getn_uint_long(const void **xpp, size_t nelems, long *tp)
#line 3126
{
#line 3126
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3126

#line 3126
 /* basic algorithm is:
#line 3126
  *   - ensure sane alignment of input data
#line 3126
  *   - copy (conversion happens automatically) input data
#line 3126
  *     to output
#line 3126
  *   - update xpp to point at next unconverted input, and tp to point
#line 3126
  *     at next location for converted output
#line 3126
  */
#line 3126
  long i, j, ni;
#line 3126
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3126
  uint *xp;
#line 3126
  int nrange = 0;         /* number of range errors */
#line 3126
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3126
  long cxp = (long) *((char**)xpp);
#line 3126

#line 3126
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3126
  /* sjl: manually stripmine so we can limit amount of
#line 3126
   * vector work space reserved to LOOPCNT elements. Also
#line 3126
   * makes vectorisation easy */
#line 3126
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3126
    ni=Min(nelems-j,LOOPCNT);
#line 3126
    if (realign) {
#line 3126
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3126
      xp = tmp;
#line 3126
    } else {
#line 3126
      xp = (uint *) *xpp;
#line 3126
    }
#line 3126
   /* copy the next block */
#line 3126
#pragma cdir loopcnt=LOOPCNT
#line 3126
#pragma cdir shortloop
#line 3126
    for (i=0; i<ni; i++) {
#line 3126
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3126
     /* test for range errors (not always needed but do it anyway) */
#line 3126
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3126
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3126
      nrange += xp[i] > LONG_MAX ;
#line 3126
    }
#line 3126
   /* update xpp and tp */
#line 3126
    if (realign) xp = (uint *) *xpp;
#line 3126
    xp += ni;
#line 3126
    tp += ni;
#line 3126
    *xpp = (void*)xp;
#line 3126
  }
#line 3126
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3126

#line 3126
#else   /* not SX */
#line 3126
	const char *xp = (const char *) *xpp;
#line 3126
	int status = NC_NOERR;
#line 3126

#line 3126
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3126
	{
#line 3126
		const int lstatus = ncx_get_uint_long(xp, tp);
#line 3126
		if (status == NC_NOERR) /* report the first encountered error */
#line 3126
			status = lstatus;
#line 3126
	}
#line 3126

#line 3126
	*xpp = (const void *)xp;
#line 3126
	return status;
#line 3126
#endif
#line 3126
}
#line 3126

int
#line 3127
ncx_getn_uint_float(const void **xpp, size_t nelems, float *tp)
#line 3127
{
#line 3127
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3127

#line 3127
 /* basic algorithm is:
#line 3127
  *   - ensure sane alignment of input data
#line 3127
  *   - copy (conversion happens automatically) input data
#line 3127
  *     to output
#line 3127
  *   - update xpp to point at next unconverted input, and tp to point
#line 3127
  *     at next location for converted output
#line 3127
  */
#line 3127
  long i, j, ni;
#line 3127
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3127
  uint *xp;
#line 3127
  int nrange = 0;         /* number of range errors */
#line 3127
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3127
  long cxp = (long) *((char**)xpp);
#line 3127

#line 3127
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3127
  /* sjl: manually stripmine so we can limit amount of
#line 3127
   * vector work space reserved to LOOPCNT elements. Also
#line 3127
   * makes vectorisation easy */
#line 3127
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3127
    ni=Min(nelems-j,LOOPCNT);
#line 3127
    if (realign) {
#line 3127
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3127
      xp = tmp;
#line 3127
    } else {
#line 3127
      xp = (uint *) *xpp;
#line 3127
    }
#line 3127
   /* copy the next block */
#line 3127
#pragma cdir loopcnt=LOOPCNT
#line 3127
#pragma cdir shortloop
#line 3127
    for (i=0; i<ni; i++) {
#line 3127
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3127
     /* test for range errors (not always needed but do it anyway) */
#line 3127
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3127
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3127
      nrange += xp[i] > FLOAT_MAX ;
#line 3127
    }
#line 3127
   /* update xpp and tp */
#line 3127
    if (realign) xp = (uint *) *xpp;
#line 3127
    xp += ni;
#line 3127
    tp += ni;
#line 3127
    *xpp = (void*)xp;
#line 3127
  }
#line 3127
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3127

#line 3127
#else   /* not SX */
#line 3127
	const char *xp = (const char *) *xpp;
#line 3127
	int status = NC_NOERR;
#line 3127

#line 3127
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3127
	{
#line 3127
		const int lstatus = ncx_get_uint_float(xp, tp);
#line 3127
		if (status == NC_NOERR) /* report the first encountered error */
#line 3127
			status = lstatus;
#line 3127
	}
#line 3127

#line 3127
	*xpp = (const void *)xp;
#line 3127
	return status;
#line 3127
#endif
#line 3127
}
#line 3127

int
#line 3128
ncx_getn_uint_double(const void **xpp, size_t nelems, double *tp)
#line 3128
{
#line 3128
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3128

#line 3128
 /* basic algorithm is:
#line 3128
  *   - ensure sane alignment of input data
#line 3128
  *   - copy (conversion happens automatically) input data
#line 3128
  *     to output
#line 3128
  *   - update xpp to point at next unconverted input, and tp to point
#line 3128
  *     at next location for converted output
#line 3128
  */
#line 3128
  long i, j, ni;
#line 3128
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3128
  uint *xp;
#line 3128
  int nrange = 0;         /* number of range errors */
#line 3128
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3128
  long cxp = (long) *((char**)xpp);
#line 3128

#line 3128
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3128
  /* sjl: manually stripmine so we can limit amount of
#line 3128
   * vector work space reserved to LOOPCNT elements. Also
#line 3128
   * makes vectorisation easy */
#line 3128
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3128
    ni=Min(nelems-j,LOOPCNT);
#line 3128
    if (realign) {
#line 3128
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3128
      xp = tmp;
#line 3128
    } else {
#line 3128
      xp = (uint *) *xpp;
#line 3128
    }
#line 3128
   /* copy the next block */
#line 3128
#pragma cdir loopcnt=LOOPCNT
#line 3128
#pragma cdir shortloop
#line 3128
    for (i=0; i<ni; i++) {
#line 3128
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3128
     /* test for range errors (not always needed but do it anyway) */
#line 3128
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3128
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3128
      nrange += xp[i] > DOUBLE_MAX ;
#line 3128
    }
#line 3128
   /* update xpp and tp */
#line 3128
    if (realign) xp = (uint *) *xpp;
#line 3128
    xp += ni;
#line 3128
    tp += ni;
#line 3128
    *xpp = (void*)xp;
#line 3128
  }
#line 3128
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3128

#line 3128
#else   /* not SX */
#line 3128
	const char *xp = (const char *) *xpp;
#line 3128
	int status = NC_NOERR;
#line 3128

#line 3128
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3128
	{
#line 3128
		const int lstatus = ncx_get_uint_double(xp, tp);
#line 3128
		if (status == NC_NOERR) /* report the first encountered error */
#line 3128
			status = lstatus;
#line 3128
	}
#line 3128

#line 3128
	*xpp = (const void *)xp;
#line 3128
	return status;
#line 3128
#endif
#line 3128
}
#line 3128

int
#line 3129
ncx_getn_uint_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3129
{
#line 3129
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3129

#line 3129
 /* basic algorithm is:
#line 3129
  *   - ensure sane alignment of input data
#line 3129
  *   - copy (conversion happens automatically) input data
#line 3129
  *     to output
#line 3129
  *   - update xpp to point at next unconverted input, and tp to point
#line 3129
  *     at next location for converted output
#line 3129
  */
#line 3129
  long i, j, ni;
#line 3129
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3129
  uint *xp;
#line 3129
  int nrange = 0;         /* number of range errors */
#line 3129
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3129
  long cxp = (long) *((char**)xpp);
#line 3129

#line 3129
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3129
  /* sjl: manually stripmine so we can limit amount of
#line 3129
   * vector work space reserved to LOOPCNT elements. Also
#line 3129
   * makes vectorisation easy */
#line 3129
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3129
    ni=Min(nelems-j,LOOPCNT);
#line 3129
    if (realign) {
#line 3129
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3129
      xp = tmp;
#line 3129
    } else {
#line 3129
      xp = (uint *) *xpp;
#line 3129
    }
#line 3129
   /* copy the next block */
#line 3129
#pragma cdir loopcnt=LOOPCNT
#line 3129
#pragma cdir shortloop
#line 3129
    for (i=0; i<ni; i++) {
#line 3129
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3129
     /* test for range errors (not always needed but do it anyway) */
#line 3129
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3129
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3129
      nrange += xp[i] > LONGLONG_MAX ;
#line 3129
    }
#line 3129
   /* update xpp and tp */
#line 3129
    if (realign) xp = (uint *) *xpp;
#line 3129
    xp += ni;
#line 3129
    tp += ni;
#line 3129
    *xpp = (void*)xp;
#line 3129
  }
#line 3129
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3129

#line 3129
#else   /* not SX */
#line 3129
	const char *xp = (const char *) *xpp;
#line 3129
	int status = NC_NOERR;
#line 3129

#line 3129
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3129
	{
#line 3129
		const int lstatus = ncx_get_uint_longlong(xp, tp);
#line 3129
		if (status == NC_NOERR) /* report the first encountered error */
#line 3129
			status = lstatus;
#line 3129
	}
#line 3129

#line 3129
	*xpp = (const void *)xp;
#line 3129
	return status;
#line 3129
#endif
#line 3129
}
#line 3129

int
#line 3130
ncx_getn_uint_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3130
{
#line 3130
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3130

#line 3130
 /* basic algorithm is:
#line 3130
  *   - ensure sane alignment of input data
#line 3130
  *   - copy (conversion happens automatically) input data
#line 3130
  *     to output
#line 3130
  *   - update xpp to point at next unconverted input, and tp to point
#line 3130
  *     at next location for converted output
#line 3130
  */
#line 3130
  long i, j, ni;
#line 3130
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3130
  uint *xp;
#line 3130
  int nrange = 0;         /* number of range errors */
#line 3130
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3130
  long cxp = (long) *((char**)xpp);
#line 3130

#line 3130
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3130
  /* sjl: manually stripmine so we can limit amount of
#line 3130
   * vector work space reserved to LOOPCNT elements. Also
#line 3130
   * makes vectorisation easy */
#line 3130
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3130
    ni=Min(nelems-j,LOOPCNT);
#line 3130
    if (realign) {
#line 3130
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3130
      xp = tmp;
#line 3130
    } else {
#line 3130
      xp = (uint *) *xpp;
#line 3130
    }
#line 3130
   /* copy the next block */
#line 3130
#pragma cdir loopcnt=LOOPCNT
#line 3130
#pragma cdir shortloop
#line 3130
    for (i=0; i<ni; i++) {
#line 3130
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3130
     /* test for range errors (not always needed but do it anyway) */
#line 3130
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3130
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3130
      nrange += xp[i] > UCHAR_MAX ;
#line 3130
    }
#line 3130
   /* update xpp and tp */
#line 3130
    if (realign) xp = (uint *) *xpp;
#line 3130
    xp += ni;
#line 3130
    tp += ni;
#line 3130
    *xpp = (void*)xp;
#line 3130
  }
#line 3130
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3130

#line 3130
#else   /* not SX */
#line 3130
	const char *xp = (const char *) *xpp;
#line 3130
	int status = NC_NOERR;
#line 3130

#line 3130
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3130
	{
#line 3130
		const int lstatus = ncx_get_uint_uchar(xp, tp);
#line 3130
		if (status == NC_NOERR) /* report the first encountered error */
#line 3130
			status = lstatus;
#line 3130
	}
#line 3130

#line 3130
	*xpp = (const void *)xp;
#line 3130
	return status;
#line 3130
#endif
#line 3130
}
#line 3130

int
#line 3131
ncx_getn_uint_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3131
{
#line 3131
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3131

#line 3131
 /* basic algorithm is:
#line 3131
  *   - ensure sane alignment of input data
#line 3131
  *   - copy (conversion happens automatically) input data
#line 3131
  *     to output
#line 3131
  *   - update xpp to point at next unconverted input, and tp to point
#line 3131
  *     at next location for converted output
#line 3131
  */
#line 3131
  long i, j, ni;
#line 3131
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3131
  uint *xp;
#line 3131
  int nrange = 0;         /* number of range errors */
#line 3131
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3131
  long cxp = (long) *((char**)xpp);
#line 3131

#line 3131
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3131
  /* sjl: manually stripmine so we can limit amount of
#line 3131
   * vector work space reserved to LOOPCNT elements. Also
#line 3131
   * makes vectorisation easy */
#line 3131
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3131
    ni=Min(nelems-j,LOOPCNT);
#line 3131
    if (realign) {
#line 3131
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3131
      xp = tmp;
#line 3131
    } else {
#line 3131
      xp = (uint *) *xpp;
#line 3131
    }
#line 3131
   /* copy the next block */
#line 3131
#pragma cdir loopcnt=LOOPCNT
#line 3131
#pragma cdir shortloop
#line 3131
    for (i=0; i<ni; i++) {
#line 3131
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3131
     /* test for range errors (not always needed but do it anyway) */
#line 3131
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3131
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3131
      nrange += xp[i] > USHORT_MAX ;
#line 3131
    }
#line 3131
   /* update xpp and tp */
#line 3131
    if (realign) xp = (uint *) *xpp;
#line 3131
    xp += ni;
#line 3131
    tp += ni;
#line 3131
    *xpp = (void*)xp;
#line 3131
  }
#line 3131
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3131

#line 3131
#else   /* not SX */
#line 3131
	const char *xp = (const char *) *xpp;
#line 3131
	int status = NC_NOERR;
#line 3131

#line 3131
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3131
	{
#line 3131
		const int lstatus = ncx_get_uint_ushort(xp, tp);
#line 3131
		if (status == NC_NOERR) /* report the first encountered error */
#line 3131
			status = lstatus;
#line 3131
	}
#line 3131

#line 3131
	*xpp = (const void *)xp;
#line 3131
	return status;
#line 3131
#endif
#line 3131
}
#line 3131

int
#line 3132
ncx_getn_uint_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3132
{
#line 3132
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3132

#line 3132
 /* basic algorithm is:
#line 3132
  *   - ensure sane alignment of input data
#line 3132
  *   - copy (conversion happens automatically) input data
#line 3132
  *     to output
#line 3132
  *   - update xpp to point at next unconverted input, and tp to point
#line 3132
  *     at next location for converted output
#line 3132
  */
#line 3132
  long i, j, ni;
#line 3132
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3132
  uint *xp;
#line 3132
  int nrange = 0;         /* number of range errors */
#line 3132
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3132
  long cxp = (long) *((char**)xpp);
#line 3132

#line 3132
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3132
  /* sjl: manually stripmine so we can limit amount of
#line 3132
   * vector work space reserved to LOOPCNT elements. Also
#line 3132
   * makes vectorisation easy */
#line 3132
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3132
    ni=Min(nelems-j,LOOPCNT);
#line 3132
    if (realign) {
#line 3132
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3132
      xp = tmp;
#line 3132
    } else {
#line 3132
      xp = (uint *) *xpp;
#line 3132
    }
#line 3132
   /* copy the next block */
#line 3132
#pragma cdir loopcnt=LOOPCNT
#line 3132
#pragma cdir shortloop
#line 3132
    for (i=0; i<ni; i++) {
#line 3132
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3132
     /* test for range errors (not always needed but do it anyway) */
#line 3132
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3132
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3132
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3132
    }
#line 3132
   /* update xpp and tp */
#line 3132
    if (realign) xp = (uint *) *xpp;
#line 3132
    xp += ni;
#line 3132
    tp += ni;
#line 3132
    *xpp = (void*)xp;
#line 3132
  }
#line 3132
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3132

#line 3132
#else   /* not SX */
#line 3132
	const char *xp = (const char *) *xpp;
#line 3132
	int status = NC_NOERR;
#line 3132

#line 3132
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3132
	{
#line 3132
		const int lstatus = ncx_get_uint_ulonglong(xp, tp);
#line 3132
		if (status == NC_NOERR) /* report the first encountered error */
#line 3132
			status = lstatus;
#line 3132
	}
#line 3132

#line 3132
	*xpp = (const void *)xp;
#line 3132
	return status;
#line 3132
#endif
#line 3132
}
#line 3132


#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_putn_uint_uint(void **xpp, size_t nelems, const unsigned int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3148
ncx_putn_uint_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3148
{
#line 3148
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3148

#line 3148
 /* basic algorithm is:
#line 3148
  *   - ensure sane alignment of output data
#line 3148
  *   - copy (conversion happens automatically) input data
#line 3148
  *     to output
#line 3148
  *   - update tp to point at next unconverted input, and xpp to point
#line 3148
  *     at next location for converted output
#line 3148
  */
#line 3148
  long i, j, ni;
#line 3148
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3148
  uint *xp;
#line 3148
  int nrange = 0;         /* number of range errors */
#line 3148
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3148
  long cxp = (long) *((char**)xpp);
#line 3148

#line 3148
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3148
  /* sjl: manually stripmine so we can limit amount of
#line 3148
   * vector work space reserved to LOOPCNT elements. Also
#line 3148
   * makes vectorisation easy */
#line 3148
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3148
    ni=Min(nelems-j,LOOPCNT);
#line 3148
    if (realign) {
#line 3148
      xp = tmp;
#line 3148
    } else {
#line 3148
      xp = (uint *) *xpp;
#line 3148
    }
#line 3148
   /* copy the next block */
#line 3148
#pragma cdir loopcnt=LOOPCNT
#line 3148
#pragma cdir shortloop
#line 3148
    for (i=0; i<ni; i++) {
#line 3148
      /* the normal case: */
#line 3148
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3148
     /* test for range errors (not always needed but do it anyway) */
#line 3148
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3148
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3148
      nrange += tp[i] > X_UINT_MAX ;
#line 3148
    }
#line 3148
   /* copy workspace back if necessary */
#line 3148
    if (realign) {
#line 3148
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3148
      xp = (uint *) *xpp;
#line 3148
    }
#line 3148
   /* update xpp and tp */
#line 3148
    xp += ni;
#line 3148
    tp += ni;
#line 3148
    *xpp = (void*)xp;
#line 3148
  }
#line 3148
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3148

#line 3148
#else   /* not SX */
#line 3148

#line 3148
	char *xp = (char *) *xpp;
#line 3148
	int status = NC_NOERR;
#line 3148

#line 3148
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3148
	{
#line 3148
		int lstatus = ncx_put_uint_uint(xp, tp, fillp);
#line 3148
		if (status == NC_NOERR) /* report the first encountered error */
#line 3148
			status = lstatus;
#line 3148
	}
#line 3148

#line 3148
	*xpp = (void *)xp;
#line 3148
	return status;
#line 3148
#endif
#line 3148
}
#line 3148

#endif
int
#line 3150
ncx_putn_uint_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3150
{
#line 3150
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3150

#line 3150
 /* basic algorithm is:
#line 3150
  *   - ensure sane alignment of output data
#line 3150
  *   - copy (conversion happens automatically) input data
#line 3150
  *     to output
#line 3150
  *   - update tp to point at next unconverted input, and xpp to point
#line 3150
  *     at next location for converted output
#line 3150
  */
#line 3150
  long i, j, ni;
#line 3150
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3150
  uint *xp;
#line 3150
  int nrange = 0;         /* number of range errors */
#line 3150
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3150
  long cxp = (long) *((char**)xpp);
#line 3150

#line 3150
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3150
  /* sjl: manually stripmine so we can limit amount of
#line 3150
   * vector work space reserved to LOOPCNT elements. Also
#line 3150
   * makes vectorisation easy */
#line 3150
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3150
    ni=Min(nelems-j,LOOPCNT);
#line 3150
    if (realign) {
#line 3150
      xp = tmp;
#line 3150
    } else {
#line 3150
      xp = (uint *) *xpp;
#line 3150
    }
#line 3150
   /* copy the next block */
#line 3150
#pragma cdir loopcnt=LOOPCNT
#line 3150
#pragma cdir shortloop
#line 3150
    for (i=0; i<ni; i++) {
#line 3150
      /* the normal case: */
#line 3150
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3150
     /* test for range errors (not always needed but do it anyway) */
#line 3150
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3150
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3150
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3150
    }
#line 3150
   /* copy workspace back if necessary */
#line 3150
    if (realign) {
#line 3150
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3150
      xp = (uint *) *xpp;
#line 3150
    }
#line 3150
   /* update xpp and tp */
#line 3150
    xp += ni;
#line 3150
    tp += ni;
#line 3150
    *xpp = (void*)xp;
#line 3150
  }
#line 3150
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3150

#line 3150
#else   /* not SX */
#line 3150

#line 3150
	char *xp = (char *) *xpp;
#line 3150
	int status = NC_NOERR;
#line 3150

#line 3150
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3150
	{
#line 3150
		int lstatus = ncx_put_uint_schar(xp, tp, fillp);
#line 3150
		if (status == NC_NOERR) /* report the first encountered error */
#line 3150
			status = lstatus;
#line 3150
	}
#line 3150

#line 3150
	*xpp = (void *)xp;
#line 3150
	return status;
#line 3150
#endif
#line 3150
}
#line 3150

int
#line 3151
ncx_putn_uint_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3151
{
#line 3151
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3151

#line 3151
 /* basic algorithm is:
#line 3151
  *   - ensure sane alignment of output data
#line 3151
  *   - copy (conversion happens automatically) input data
#line 3151
  *     to output
#line 3151
  *   - update tp to point at next unconverted input, and xpp to point
#line 3151
  *     at next location for converted output
#line 3151
  */
#line 3151
  long i, j, ni;
#line 3151
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3151
  uint *xp;
#line 3151
  int nrange = 0;         /* number of range errors */
#line 3151
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3151
  long cxp = (long) *((char**)xpp);
#line 3151

#line 3151
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3151
  /* sjl: manually stripmine so we can limit amount of
#line 3151
   * vector work space reserved to LOOPCNT elements. Also
#line 3151
   * makes vectorisation easy */
#line 3151
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3151
    ni=Min(nelems-j,LOOPCNT);
#line 3151
    if (realign) {
#line 3151
      xp = tmp;
#line 3151
    } else {
#line 3151
      xp = (uint *) *xpp;
#line 3151
    }
#line 3151
   /* copy the next block */
#line 3151
#pragma cdir loopcnt=LOOPCNT
#line 3151
#pragma cdir shortloop
#line 3151
    for (i=0; i<ni; i++) {
#line 3151
      /* the normal case: */
#line 3151
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3151
     /* test for range errors (not always needed but do it anyway) */
#line 3151
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3151
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3151
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3151
    }
#line 3151
   /* copy workspace back if necessary */
#line 3151
    if (realign) {
#line 3151
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3151
      xp = (uint *) *xpp;
#line 3151
    }
#line 3151
   /* update xpp and tp */
#line 3151
    xp += ni;
#line 3151
    tp += ni;
#line 3151
    *xpp = (void*)xp;
#line 3151
  }
#line 3151
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3151

#line 3151
#else   /* not SX */
#line 3151

#line 3151
	char *xp = (char *) *xpp;
#line 3151
	int status = NC_NOERR;
#line 3151

#line 3151
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3151
	{
#line 3151
		int lstatus = ncx_put_uint_short(xp, tp, fillp);
#line 3151
		if (status == NC_NOERR) /* report the first encountered error */
#line 3151
			status = lstatus;
#line 3151
	}
#line 3151

#line 3151
	*xpp = (void *)xp;
#line 3151
	return status;
#line 3151
#endif
#line 3151
}
#line 3151

int
#line 3152
ncx_putn_uint_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3152
{
#line 3152
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3152

#line 3152
 /* basic algorithm is:
#line 3152
  *   - ensure sane alignment of output data
#line 3152
  *   - copy (conversion happens automatically) input data
#line 3152
  *     to output
#line 3152
  *   - update tp to point at next unconverted input, and xpp to point
#line 3152
  *     at next location for converted output
#line 3152
  */
#line 3152
  long i, j, ni;
#line 3152
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3152
  uint *xp;
#line 3152
  int nrange = 0;         /* number of range errors */
#line 3152
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3152
  long cxp = (long) *((char**)xpp);
#line 3152

#line 3152
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3152
  /* sjl: manually stripmine so we can limit amount of
#line 3152
   * vector work space reserved to LOOPCNT elements. Also
#line 3152
   * makes vectorisation easy */
#line 3152
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3152
    ni=Min(nelems-j,LOOPCNT);
#line 3152
    if (realign) {
#line 3152
      xp = tmp;
#line 3152
    } else {
#line 3152
      xp = (uint *) *xpp;
#line 3152
    }
#line 3152
   /* copy the next block */
#line 3152
#pragma cdir loopcnt=LOOPCNT
#line 3152
#pragma cdir shortloop
#line 3152
    for (i=0; i<ni; i++) {
#line 3152
      /* the normal case: */
#line 3152
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3152
     /* test for range errors (not always needed but do it anyway) */
#line 3152
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3152
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3152
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3152
    }
#line 3152
   /* copy workspace back if necessary */
#line 3152
    if (realign) {
#line 3152
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3152
      xp = (uint *) *xpp;
#line 3152
    }
#line 3152
   /* update xpp and tp */
#line 3152
    xp += ni;
#line 3152
    tp += ni;
#line 3152
    *xpp = (void*)xp;
#line 3152
  }
#line 3152
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3152

#line 3152
#else   /* not SX */
#line 3152

#line 3152
	char *xp = (char *) *xpp;
#line 3152
	int status = NC_NOERR;
#line 3152

#line 3152
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3152
	{
#line 3152
		int lstatus = ncx_put_uint_int(xp, tp, fillp);
#line 3152
		if (status == NC_NOERR) /* report the first encountered error */
#line 3152
			status = lstatus;
#line 3152
	}
#line 3152

#line 3152
	*xpp = (void *)xp;
#line 3152
	return status;
#line 3152
#endif
#line 3152
}
#line 3152

int
#line 3153
ncx_putn_uint_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3153
{
#line 3153
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3153

#line 3153
 /* basic algorithm is:
#line 3153
  *   - ensure sane alignment of output data
#line 3153
  *   - copy (conversion happens automatically) input data
#line 3153
  *     to output
#line 3153
  *   - update tp to point at next unconverted input, and xpp to point
#line 3153
  *     at next location for converted output
#line 3153
  */
#line 3153
  long i, j, ni;
#line 3153
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3153
  uint *xp;
#line 3153
  int nrange = 0;         /* number of range errors */
#line 3153
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3153
  long cxp = (long) *((char**)xpp);
#line 3153

#line 3153
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3153
  /* sjl: manually stripmine so we can limit amount of
#line 3153
   * vector work space reserved to LOOPCNT elements. Also
#line 3153
   * makes vectorisation easy */
#line 3153
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3153
    ni=Min(nelems-j,LOOPCNT);
#line 3153
    if (realign) {
#line 3153
      xp = tmp;
#line 3153
    } else {
#line 3153
      xp = (uint *) *xpp;
#line 3153
    }
#line 3153
   /* copy the next block */
#line 3153
#pragma cdir loopcnt=LOOPCNT
#line 3153
#pragma cdir shortloop
#line 3153
    for (i=0; i<ni; i++) {
#line 3153
      /* the normal case: */
#line 3153
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3153
     /* test for range errors (not always needed but do it anyway) */
#line 3153
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3153
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3153
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3153
    }
#line 3153
   /* copy workspace back if necessary */
#line 3153
    if (realign) {
#line 3153
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3153
      xp = (uint *) *xpp;
#line 3153
    }
#line 3153
   /* update xpp and tp */
#line 3153
    xp += ni;
#line 3153
    tp += ni;
#line 3153
    *xpp = (void*)xp;
#line 3153
  }
#line 3153
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3153

#line 3153
#else   /* not SX */
#line 3153

#line 3153
	char *xp = (char *) *xpp;
#line 3153
	int status = NC_NOERR;
#line 3153

#line 3153
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3153
	{
#line 3153
		int lstatus = ncx_put_uint_long(xp, tp, fillp);
#line 3153
		if (status == NC_NOERR) /* report the first encountered error */
#line 3153
			status = lstatus;
#line 3153
	}
#line 3153

#line 3153
	*xpp = (void *)xp;
#line 3153
	return status;
#line 3153
#endif
#line 3153
}
#line 3153

int
#line 3154
ncx_putn_uint_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3154
{
#line 3154
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3154

#line 3154
 /* basic algorithm is:
#line 3154
  *   - ensure sane alignment of output data
#line 3154
  *   - copy (conversion happens automatically) input data
#line 3154
  *     to output
#line 3154
  *   - update tp to point at next unconverted input, and xpp to point
#line 3154
  *     at next location for converted output
#line 3154
  */
#line 3154
  long i, j, ni;
#line 3154
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3154
  uint *xp;
#line 3154
  int nrange = 0;         /* number of range errors */
#line 3154
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3154
  long cxp = (long) *((char**)xpp);
#line 3154

#line 3154
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3154
  /* sjl: manually stripmine so we can limit amount of
#line 3154
   * vector work space reserved to LOOPCNT elements. Also
#line 3154
   * makes vectorisation easy */
#line 3154
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3154
    ni=Min(nelems-j,LOOPCNT);
#line 3154
    if (realign) {
#line 3154
      xp = tmp;
#line 3154
    } else {
#line 3154
      xp = (uint *) *xpp;
#line 3154
    }
#line 3154
   /* copy the next block */
#line 3154
#pragma cdir loopcnt=LOOPCNT
#line 3154
#pragma cdir shortloop
#line 3154
    for (i=0; i<ni; i++) {
#line 3154
      /* the normal case: */
#line 3154
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3154
     /* test for range errors (not always needed but do it anyway) */
#line 3154
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3154
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3154
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3154
    }
#line 3154
   /* copy workspace back if necessary */
#line 3154
    if (realign) {
#line 3154
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3154
      xp = (uint *) *xpp;
#line 3154
    }
#line 3154
   /* update xpp and tp */
#line 3154
    xp += ni;
#line 3154
    tp += ni;
#line 3154
    *xpp = (void*)xp;
#line 3154
  }
#line 3154
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3154

#line 3154
#else   /* not SX */
#line 3154

#line 3154
	char *xp = (char *) *xpp;
#line 3154
	int status = NC_NOERR;
#line 3154

#line 3154
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3154
	{
#line 3154
		int lstatus = ncx_put_uint_float(xp, tp, fillp);
#line 3154
		if (status == NC_NOERR) /* report the first encountered error */
#line 3154
			status = lstatus;
#line 3154
	}
#line 3154

#line 3154
	*xpp = (void *)xp;
#line 3154
	return status;
#line 3154
#endif
#line 3154
}
#line 3154

int
#line 3155
ncx_putn_uint_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3155
{
#line 3155
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3155

#line 3155
 /* basic algorithm is:
#line 3155
  *   - ensure sane alignment of output data
#line 3155
  *   - copy (conversion happens automatically) input data
#line 3155
  *     to output
#line 3155
  *   - update tp to point at next unconverted input, and xpp to point
#line 3155
  *     at next location for converted output
#line 3155
  */
#line 3155
  long i, j, ni;
#line 3155
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3155
  uint *xp;
#line 3155
  int nrange = 0;         /* number of range errors */
#line 3155
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3155
  long cxp = (long) *((char**)xpp);
#line 3155

#line 3155
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3155
  /* sjl: manually stripmine so we can limit amount of
#line 3155
   * vector work space reserved to LOOPCNT elements. Also
#line 3155
   * makes vectorisation easy */
#line 3155
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3155
    ni=Min(nelems-j,LOOPCNT);
#line 3155
    if (realign) {
#line 3155
      xp = tmp;
#line 3155
    } else {
#line 3155
      xp = (uint *) *xpp;
#line 3155
    }
#line 3155
   /* copy the next block */
#line 3155
#pragma cdir loopcnt=LOOPCNT
#line 3155
#pragma cdir shortloop
#line 3155
    for (i=0; i<ni; i++) {
#line 3155
      /* the normal case: */
#line 3155
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3155
     /* test for range errors (not always needed but do it anyway) */
#line 3155
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3155
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3155
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3155
    }
#line 3155
   /* copy workspace back if necessary */
#line 3155
    if (realign) {
#line 3155
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3155
      xp = (uint *) *xpp;
#line 3155
    }
#line 3155
   /* update xpp and tp */
#line 3155
    xp += ni;
#line 3155
    tp += ni;
#line 3155
    *xpp = (void*)xp;
#line 3155
  }
#line 3155
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3155

#line 3155
#else   /* not SX */
#line 3155

#line 3155
	char *xp = (char *) *xpp;
#line 3155
	int status = NC_NOERR;
#line 3155

#line 3155
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3155
	{
#line 3155
		int lstatus = ncx_put_uint_double(xp, tp, fillp);
#line 3155
		if (status == NC_NOERR) /* report the first encountered error */
#line 3155
			status = lstatus;
#line 3155
	}
#line 3155

#line 3155
	*xpp = (void *)xp;
#line 3155
	return status;
#line 3155
#endif
#line 3155
}
#line 3155

int
#line 3156
ncx_putn_uint_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3156
{
#line 3156
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3156

#line 3156
 /* basic algorithm is:
#line 3156
  *   - ensure sane alignment of output data
#line 3156
  *   - copy (conversion happens automatically) input data
#line 3156
  *     to output
#line 3156
  *   - update tp to point at next unconverted input, and xpp to point
#line 3156
  *     at next location for converted output
#line 3156
  */
#line 3156
  long i, j, ni;
#line 3156
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3156
  uint *xp;
#line 3156
  int nrange = 0;         /* number of range errors */
#line 3156
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3156
  long cxp = (long) *((char**)xpp);
#line 3156

#line 3156
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3156
  /* sjl: manually stripmine so we can limit amount of
#line 3156
   * vector work space reserved to LOOPCNT elements. Also
#line 3156
   * makes vectorisation easy */
#line 3156
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3156
    ni=Min(nelems-j,LOOPCNT);
#line 3156
    if (realign) {
#line 3156
      xp = tmp;
#line 3156
    } else {
#line 3156
      xp = (uint *) *xpp;
#line 3156
    }
#line 3156
   /* copy the next block */
#line 3156
#pragma cdir loopcnt=LOOPCNT
#line 3156
#pragma cdir shortloop
#line 3156
    for (i=0; i<ni; i++) {
#line 3156
      /* the normal case: */
#line 3156
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3156
     /* test for range errors (not always needed but do it anyway) */
#line 3156
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3156
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3156
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3156
    }
#line 3156
   /* copy workspace back if necessary */
#line 3156
    if (realign) {
#line 3156
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3156
      xp = (uint *) *xpp;
#line 3156
    }
#line 3156
   /* update xpp and tp */
#line 3156
    xp += ni;
#line 3156
    tp += ni;
#line 3156
    *xpp = (void*)xp;
#line 3156
  }
#line 3156
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3156

#line 3156
#else   /* not SX */
#line 3156

#line 3156
	char *xp = (char *) *xpp;
#line 3156
	int status = NC_NOERR;
#line 3156

#line 3156
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3156
	{
#line 3156
		int lstatus = ncx_put_uint_longlong(xp, tp, fillp);
#line 3156
		if (status == NC_NOERR) /* report the first encountered error */
#line 3156
			status = lstatus;
#line 3156
	}
#line 3156

#line 3156
	*xpp = (void *)xp;
#line 3156
	return status;
#line 3156
#endif
#line 3156
}
#line 3156

int
#line 3157
ncx_putn_uint_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3157
{
#line 3157
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3157

#line 3157
 /* basic algorithm is:
#line 3157
  *   - ensure sane alignment of output data
#line 3157
  *   - copy (conversion happens automatically) input data
#line 3157
  *     to output
#line 3157
  *   - update tp to point at next unconverted input, and xpp to point
#line 3157
  *     at next location for converted output
#line 3157
  */
#line 3157
  long i, j, ni;
#line 3157
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3157
  uint *xp;
#line 3157
  int nrange = 0;         /* number of range errors */
#line 3157
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3157
  long cxp = (long) *((char**)xpp);
#line 3157

#line 3157
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3157
  /* sjl: manually stripmine so we can limit amount of
#line 3157
   * vector work space reserved to LOOPCNT elements. Also
#line 3157
   * makes vectorisation easy */
#line 3157
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3157
    ni=Min(nelems-j,LOOPCNT);
#line 3157
    if (realign) {
#line 3157
      xp = tmp;
#line 3157
    } else {
#line 3157
      xp = (uint *) *xpp;
#line 3157
    }
#line 3157
   /* copy the next block */
#line 3157
#pragma cdir loopcnt=LOOPCNT
#line 3157
#pragma cdir shortloop
#line 3157
    for (i=0; i<ni; i++) {
#line 3157
      /* the normal case: */
#line 3157
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3157
     /* test for range errors (not always needed but do it anyway) */
#line 3157
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3157
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3157
      nrange += tp[i] > X_UINT_MAX ;
#line 3157
    }
#line 3157
   /* copy workspace back if necessary */
#line 3157
    if (realign) {
#line 3157
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3157
      xp = (uint *) *xpp;
#line 3157
    }
#line 3157
   /* update xpp and tp */
#line 3157
    xp += ni;
#line 3157
    tp += ni;
#line 3157
    *xpp = (void*)xp;
#line 3157
  }
#line 3157
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3157

#line 3157
#else   /* not SX */
#line 3157

#line 3157
	char *xp = (char *) *xpp;
#line 3157
	int status = NC_NOERR;
#line 3157

#line 3157
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3157
	{
#line 3157
		int lstatus = ncx_put_uint_uchar(xp, tp, fillp);
#line 3157
		if (status == NC_NOERR) /* report the first encountered error */
#line 3157
			status = lstatus;
#line 3157
	}
#line 3157

#line 3157
	*xpp = (void *)xp;
#line 3157
	return status;
#line 3157
#endif
#line 3157
}
#line 3157

int
#line 3158
ncx_putn_uint_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3158
{
#line 3158
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3158

#line 3158
 /* basic algorithm is:
#line 3158
  *   - ensure sane alignment of output data
#line 3158
  *   - copy (conversion happens automatically) input data
#line 3158
  *     to output
#line 3158
  *   - update tp to point at next unconverted input, and xpp to point
#line 3158
  *     at next location for converted output
#line 3158
  */
#line 3158
  long i, j, ni;
#line 3158
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3158
  uint *xp;
#line 3158
  int nrange = 0;         /* number of range errors */
#line 3158
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3158
  long cxp = (long) *((char**)xpp);
#line 3158

#line 3158
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3158
  /* sjl: manually stripmine so we can limit amount of
#line 3158
   * vector work space reserved to LOOPCNT elements. Also
#line 3158
   * makes vectorisation easy */
#line 3158
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3158
    ni=Min(nelems-j,LOOPCNT);
#line 3158
    if (realign) {
#line 3158
      xp = tmp;
#line 3158
    } else {
#line 3158
      xp = (uint *) *xpp;
#line 3158
    }
#line 3158
   /* copy the next block */
#line 3158
#pragma cdir loopcnt=LOOPCNT
#line 3158
#pragma cdir shortloop
#line 3158
    for (i=0; i<ni; i++) {
#line 3158
      /* the normal case: */
#line 3158
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3158
     /* test for range errors (not always needed but do it anyway) */
#line 3158
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3158
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3158
      nrange += tp[i] > X_UINT_MAX ;
#line 3158
    }
#line 3158
   /* copy workspace back if necessary */
#line 3158
    if (realign) {
#line 3158
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3158
      xp = (uint *) *xpp;
#line 3158
    }
#line 3158
   /* update xpp and tp */
#line 3158
    xp += ni;
#line 3158
    tp += ni;
#line 3158
    *xpp = (void*)xp;
#line 3158
  }
#line 3158
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3158

#line 3158
#else   /* not SX */
#line 3158

#line 3158
	char *xp = (char *) *xpp;
#line 3158
	int status = NC_NOERR;
#line 3158

#line 3158
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3158
	{
#line 3158
		int lstatus = ncx_put_uint_ushort(xp, tp, fillp);
#line 3158
		if (status == NC_NOERR) /* report the first encountered error */
#line 3158
			status = lstatus;
#line 3158
	}
#line 3158

#line 3158
	*xpp = (void *)xp;
#line 3158
	return status;
#line 3158
#endif
#line 3158
}
#line 3158

int
#line 3159
ncx_putn_uint_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3159
{
#line 3159
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3159

#line 3159
 /* basic algorithm is:
#line 3159
  *   - ensure sane alignment of output data
#line 3159
  *   - copy (conversion happens automatically) input data
#line 3159
  *     to output
#line 3159
  *   - update tp to point at next unconverted input, and xpp to point
#line 3159
  *     at next location for converted output
#line 3159
  */
#line 3159
  long i, j, ni;
#line 3159
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3159
  uint *xp;
#line 3159
  int nrange = 0;         /* number of range errors */
#line 3159
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3159
  long cxp = (long) *((char**)xpp);
#line 3159

#line 3159
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3159
  /* sjl: manually stripmine so we can limit amount of
#line 3159
   * vector work space reserved to LOOPCNT elements. Also
#line 3159
   * makes vectorisation easy */
#line 3159
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3159
    ni=Min(nelems-j,LOOPCNT);
#line 3159
    if (realign) {
#line 3159
      xp = tmp;
#line 3159
    } else {
#line 3159
      xp = (uint *) *xpp;
#line 3159
    }
#line 3159
   /* copy the next block */
#line 3159
#pragma cdir loopcnt=LOOPCNT
#line 3159
#pragma cdir shortloop
#line 3159
    for (i=0; i<ni; i++) {
#line 3159
      /* the normal case: */
#line 3159
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3159
     /* test for range errors (not always needed but do it anyway) */
#line 3159
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3159
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3159
      nrange += tp[i] > X_UINT_MAX ;
#line 3159
    }
#line 3159
   /* copy workspace back if necessary */
#line 3159
    if (realign) {
#line 3159
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3159
      xp = (uint *) *xpp;
#line 3159
    }
#line 3159
   /* update xpp and tp */
#line 3159
    xp += ni;
#line 3159
    tp += ni;
#line 3159
    *xpp = (void*)xp;
#line 3159
  }
#line 3159
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3159

#line 3159
#else   /* not SX */
#line 3159

#line 3159
	char *xp = (char *) *xpp;
#line 3159
	int status = NC_NOERR;
#line 3159

#line 3159
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3159
	{
#line 3159
		int lstatus = ncx_put_uint_ulonglong(xp, tp, fillp);
#line 3159
		if (status == NC_NOERR) /* report the first encountered error */
#line 3159
			status = lstatus;
#line 3159
	}
#line 3159

#line 3159
	*xpp = (void *)xp;
#line 3159
	return status;
#line 3159
#endif
#line 3159
}
#line 3159



/* float ---------------------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_FLOAT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_float_float(const void **xpp, size_t nfloats, float *ip)
{
	float *const end = ip + nfloats;

	while (ip < end)
	{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 3185
		const struct ieee_single *const isp =
#line 3185
			 (const struct ieee_single *) (*xpp);
#line 3185
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 3185

#line 3185
		switch(exp) {
#line 3185
		case 0 :
#line 3185
			/* ieee subnormal */
#line 3185
			if (isp->mant_hi == min.ieee.mant_hi
#line 3185
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 3185
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 3185
			{
#line 3185
				*vsp = min.s;
#line 3185
			}
#line 3185
			else
#line 3185
			{
#line 3185
				unsigned mantissa = (isp->mant_hi << 16)
#line 3185
					 | isp->mant_lo_hi << 8
#line 3185
					 | isp->mant_lo_lo;
#line 3185
				unsigned tmp = mantissa >> 20;
#line 3185
				if (tmp >= 4) {
#line 3185
					vsp->exp = 2;
#line 3185
				} else if (tmp >= 2) {
#line 3185
					vsp->exp = 1;
#line 3185
				} else {
#line 3185
					*vsp = min.s;
#line 3185
					break;
#line 3185
				} /* else */
#line 3185
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 3185
				tmp <<= 3 - vsp->exp;
#line 3185
				vsp->mantissa2 = tmp;
#line 3185
				vsp->mantissa1 = (tmp >> 16);
#line 3185
			}
#line 3185
			break;
#line 3185
		case 0xfe :
#line 3185
		case 0xff :
#line 3185
			*vsp = max.s;
#line 3185
			break;
#line 3185
		default :
#line 3185
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 3185
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 3185
			vsp->mantissa1 = isp->mant_hi;
#line 3185
		}
#line 3185

#line 3185
		vsp->sign = isp->sign;
#line 3185


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}

#endif
int
#line 3211
ncx_getn_float_schar(const void **xpp, size_t nelems, schar *tp)
#line 3211
{
#line 3211
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3211

#line 3211
 /* basic algorithm is:
#line 3211
  *   - ensure sane alignment of input data
#line 3211
  *   - copy (conversion happens automatically) input data
#line 3211
  *     to output
#line 3211
  *   - update xpp to point at next unconverted input, and tp to point
#line 3211
  *     at next location for converted output
#line 3211
  */
#line 3211
  long i, j, ni;
#line 3211
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3211
  float *xp;
#line 3211
  int nrange = 0;         /* number of range errors */
#line 3211
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3211
  long cxp = (long) *((char**)xpp);
#line 3211

#line 3211
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3211
  /* sjl: manually stripmine so we can limit amount of
#line 3211
   * vector work space reserved to LOOPCNT elements. Also
#line 3211
   * makes vectorisation easy */
#line 3211
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3211
    ni=Min(nelems-j,LOOPCNT);
#line 3211
    if (realign) {
#line 3211
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3211
      xp = tmp;
#line 3211
    } else {
#line 3211
      xp = (float *) *xpp;
#line 3211
    }
#line 3211
   /* copy the next block */
#line 3211
#pragma cdir loopcnt=LOOPCNT
#line 3211
#pragma cdir shortloop
#line 3211
    for (i=0; i<ni; i++) {
#line 3211
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3211
     /* test for range errors (not always needed but do it anyway) */
#line 3211
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3211
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3211
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3211
    }
#line 3211
   /* update xpp and tp */
#line 3211
    if (realign) xp = (float *) *xpp;
#line 3211
    xp += ni;
#line 3211
    tp += ni;
#line 3211
    *xpp = (void*)xp;
#line 3211
  }
#line 3211
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3211

#line 3211
#else   /* not SX */
#line 3211
	const char *xp = (const char *) *xpp;
#line 3211
	int status = NC_NOERR;
#line 3211

#line 3211
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3211
	{
#line 3211
		const int lstatus = ncx_get_float_schar(xp, tp);
#line 3211
		if (status == NC_NOERR) /* report the first encountered error */
#line 3211
			status = lstatus;
#line 3211
	}
#line 3211

#line 3211
	*xpp = (const void *)xp;
#line 3211
	return status;
#line 3211
#endif
#line 3211
}
#line 3211

int
#line 3212
ncx_getn_float_short(const void **xpp, size_t nelems, short *tp)
#line 3212
{
#line 3212
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3212

#line 3212
 /* basic algorithm is:
#line 3212
  *   - ensure sane alignment of input data
#line 3212
  *   - copy (conversion happens automatically) input data
#line 3212
  *     to output
#line 3212
  *   - update xpp to point at next unconverted input, and tp to point
#line 3212
  *     at next location for converted output
#line 3212
  */
#line 3212
  long i, j, ni;
#line 3212
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3212
  float *xp;
#line 3212
  int nrange = 0;         /* number of range errors */
#line 3212
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3212
  long cxp = (long) *((char**)xpp);
#line 3212

#line 3212
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3212
  /* sjl: manually stripmine so we can limit amount of
#line 3212
   * vector work space reserved to LOOPCNT elements. Also
#line 3212
   * makes vectorisation easy */
#line 3212
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3212
    ni=Min(nelems-j,LOOPCNT);
#line 3212
    if (realign) {
#line 3212
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3212
      xp = tmp;
#line 3212
    } else {
#line 3212
      xp = (float *) *xpp;
#line 3212
    }
#line 3212
   /* copy the next block */
#line 3212
#pragma cdir loopcnt=LOOPCNT
#line 3212
#pragma cdir shortloop
#line 3212
    for (i=0; i<ni; i++) {
#line 3212
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3212
     /* test for range errors (not always needed but do it anyway) */
#line 3212
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3212
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3212
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3212
    }
#line 3212
   /* update xpp and tp */
#line 3212
    if (realign) xp = (float *) *xpp;
#line 3212
    xp += ni;
#line 3212
    tp += ni;
#line 3212
    *xpp = (void*)xp;
#line 3212
  }
#line 3212
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3212

#line 3212
#else   /* not SX */
#line 3212
	const char *xp = (const char *) *xpp;
#line 3212
	int status = NC_NOERR;
#line 3212

#line 3212
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3212
	{
#line 3212
		const int lstatus = ncx_get_float_short(xp, tp);
#line 3212
		if (status == NC_NOERR) /* report the first encountered error */
#line 3212
			status = lstatus;
#line 3212
	}
#line 3212

#line 3212
	*xpp = (const void *)xp;
#line 3212
	return status;
#line 3212
#endif
#line 3212
}
#line 3212

int
#line 3213
ncx_getn_float_int(const void **xpp, size_t nelems, int *tp)
#line 3213
{
#line 3213
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3213

#line 3213
 /* basic algorithm is:
#line 3213
  *   - ensure sane alignment of input data
#line 3213
  *   - copy (conversion happens automatically) input data
#line 3213
  *     to output
#line 3213
  *   - update xpp to point at next unconverted input, and tp to point
#line 3213
  *     at next location for converted output
#line 3213
  */
#line 3213
  long i, j, ni;
#line 3213
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3213
  float *xp;
#line 3213
  int nrange = 0;         /* number of range errors */
#line 3213
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3213
  long cxp = (long) *((char**)xpp);
#line 3213

#line 3213
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3213
  /* sjl: manually stripmine so we can limit amount of
#line 3213
   * vector work space reserved to LOOPCNT elements. Also
#line 3213
   * makes vectorisation easy */
#line 3213
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3213
    ni=Min(nelems-j,LOOPCNT);
#line 3213
    if (realign) {
#line 3213
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3213
      xp = tmp;
#line 3213
    } else {
#line 3213
      xp = (float *) *xpp;
#line 3213
    }
#line 3213
   /* copy the next block */
#line 3213
#pragma cdir loopcnt=LOOPCNT
#line 3213
#pragma cdir shortloop
#line 3213
    for (i=0; i<ni; i++) {
#line 3213
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3213
     /* test for range errors (not always needed but do it anyway) */
#line 3213
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3213
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3213
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3213
    }
#line 3213
   /* update xpp and tp */
#line 3213
    if (realign) xp = (float *) *xpp;
#line 3213
    xp += ni;
#line 3213
    tp += ni;
#line 3213
    *xpp = (void*)xp;
#line 3213
  }
#line 3213
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3213

#line 3213
#else   /* not SX */
#line 3213
	const char *xp = (const char *) *xpp;
#line 3213
	int status = NC_NOERR;
#line 3213

#line 3213
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3213
	{
#line 3213
		const int lstatus = ncx_get_float_int(xp, tp);
#line 3213
		if (status == NC_NOERR) /* report the first encountered error */
#line 3213
			status = lstatus;
#line 3213
	}
#line 3213

#line 3213
	*xpp = (const void *)xp;
#line 3213
	return status;
#line 3213
#endif
#line 3213
}
#line 3213

int
#line 3214
ncx_getn_float_long(const void **xpp, size_t nelems, long *tp)
#line 3214
{
#line 3214
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3214

#line 3214
 /* basic algorithm is:
#line 3214
  *   - ensure sane alignment of input data
#line 3214
  *   - copy (conversion happens automatically) input data
#line 3214
  *     to output
#line 3214
  *   - update xpp to point at next unconverted input, and tp to point
#line 3214
  *     at next location for converted output
#line 3214
  */
#line 3214
  long i, j, ni;
#line 3214
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3214
  float *xp;
#line 3214
  int nrange = 0;         /* number of range errors */
#line 3214
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3214
  long cxp = (long) *((char**)xpp);
#line 3214

#line 3214
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3214
  /* sjl: manually stripmine so we can limit amount of
#line 3214
   * vector work space reserved to LOOPCNT elements. Also
#line 3214
   * makes vectorisation easy */
#line 3214
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3214
    ni=Min(nelems-j,LOOPCNT);
#line 3214
    if (realign) {
#line 3214
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3214
      xp = tmp;
#line 3214
    } else {
#line 3214
      xp = (float *) *xpp;
#line 3214
    }
#line 3214
   /* copy the next block */
#line 3214
#pragma cdir loopcnt=LOOPCNT
#line 3214
#pragma cdir shortloop
#line 3214
    for (i=0; i<ni; i++) {
#line 3214
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3214
     /* test for range errors (not always needed but do it anyway) */
#line 3214
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3214
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3214
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3214
    }
#line 3214
   /* update xpp and tp */
#line 3214
    if (realign) xp = (float *) *xpp;
#line 3214
    xp += ni;
#line 3214
    tp += ni;
#line 3214
    *xpp = (void*)xp;
#line 3214
  }
#line 3214
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3214

#line 3214
#else   /* not SX */
#line 3214
	const char *xp = (const char *) *xpp;
#line 3214
	int status = NC_NOERR;
#line 3214

#line 3214
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3214
	{
#line 3214
		const int lstatus = ncx_get_float_long(xp, tp);
#line 3214
		if (status == NC_NOERR) /* report the first encountered error */
#line 3214
			status = lstatus;
#line 3214
	}
#line 3214

#line 3214
	*xpp = (const void *)xp;
#line 3214
	return status;
#line 3214
#endif
#line 3214
}
#line 3214

int
#line 3215
ncx_getn_float_double(const void **xpp, size_t nelems, double *tp)
#line 3215
{
#line 3215
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3215

#line 3215
 /* basic algorithm is:
#line 3215
  *   - ensure sane alignment of input data
#line 3215
  *   - copy (conversion happens automatically) input data
#line 3215
  *     to output
#line 3215
  *   - update xpp to point at next unconverted input, and tp to point
#line 3215
  *     at next location for converted output
#line 3215
  */
#line 3215
  long i, j, ni;
#line 3215
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3215
  float *xp;
#line 3215
  int nrange = 0;         /* number of range errors */
#line 3215
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3215
  long cxp = (long) *((char**)xpp);
#line 3215

#line 3215
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3215
  /* sjl: manually stripmine so we can limit amount of
#line 3215
   * vector work space reserved to LOOPCNT elements. Also
#line 3215
   * makes vectorisation easy */
#line 3215
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3215
    ni=Min(nelems-j,LOOPCNT);
#line 3215
    if (realign) {
#line 3215
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3215
      xp = tmp;
#line 3215
    } else {
#line 3215
      xp = (float *) *xpp;
#line 3215
    }
#line 3215
   /* copy the next block */
#line 3215
#pragma cdir loopcnt=LOOPCNT
#line 3215
#pragma cdir shortloop
#line 3215
    for (i=0; i<ni; i++) {
#line 3215
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3215
     /* test for range errors (not always needed but do it anyway) */
#line 3215
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3215
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3215
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3215
    }
#line 3215
   /* update xpp and tp */
#line 3215
    if (realign) xp = (float *) *xpp;
#line 3215
    xp += ni;
#line 3215
    tp += ni;
#line 3215
    *xpp = (void*)xp;
#line 3215
  }
#line 3215
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3215

#line 3215
#else   /* not SX */
#line 3215
	const char *xp = (const char *) *xpp;
#line 3215
	int status = NC_NOERR;
#line 3215

#line 3215
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3215
	{
#line 3215
		const int lstatus = ncx_get_float_double(xp, tp);
#line 3215
		if (status == NC_NOERR) /* report the first encountered error */
#line 3215
			status = lstatus;
#line 3215
	}
#line 3215

#line 3215
	*xpp = (const void *)xp;
#line 3215
	return status;
#line 3215
#endif
#line 3215
}
#line 3215

int
#line 3216
ncx_getn_float_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3216
{
#line 3216
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3216

#line 3216
 /* basic algorithm is:
#line 3216
  *   - ensure sane alignment of input data
#line 3216
  *   - copy (conversion happens automatically) input data
#line 3216
  *     to output
#line 3216
  *   - update xpp to point at next unconverted input, and tp to point
#line 3216
  *     at next location for converted output
#line 3216
  */
#line 3216
  long i, j, ni;
#line 3216
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3216
  float *xp;
#line 3216
  int nrange = 0;         /* number of range errors */
#line 3216
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3216
  long cxp = (long) *((char**)xpp);
#line 3216

#line 3216
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3216
  /* sjl: manually stripmine so we can limit amount of
#line 3216
   * vector work space reserved to LOOPCNT elements. Also
#line 3216
   * makes vectorisation easy */
#line 3216
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3216
    ni=Min(nelems-j,LOOPCNT);
#line 3216
    if (realign) {
#line 3216
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3216
      xp = tmp;
#line 3216
    } else {
#line 3216
      xp = (float *) *xpp;
#line 3216
    }
#line 3216
   /* copy the next block */
#line 3216
#pragma cdir loopcnt=LOOPCNT
#line 3216
#pragma cdir shortloop
#line 3216
    for (i=0; i<ni; i++) {
#line 3216
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3216
     /* test for range errors (not always needed but do it anyway) */
#line 3216
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3216
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3216
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3216
    }
#line 3216
   /* update xpp and tp */
#line 3216
    if (realign) xp = (float *) *xpp;
#line 3216
    xp += ni;
#line 3216
    tp += ni;
#line 3216
    *xpp = (void*)xp;
#line 3216
  }
#line 3216
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3216

#line 3216
#else   /* not SX */
#line 3216
	const char *xp = (const char *) *xpp;
#line 3216
	int status = NC_NOERR;
#line 3216

#line 3216
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3216
	{
#line 3216
		const int lstatus = ncx_get_float_longlong(xp, tp);
#line 3216
		if (status == NC_NOERR) /* report the first encountered error */
#line 3216
			status = lstatus;
#line 3216
	}
#line 3216

#line 3216
	*xpp = (const void *)xp;
#line 3216
	return status;
#line 3216
#endif
#line 3216
}
#line 3216

int
#line 3217
ncx_getn_float_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3217
{
#line 3217
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3217

#line 3217
 /* basic algorithm is:
#line 3217
  *   - ensure sane alignment of input data
#line 3217
  *   - copy (conversion happens automatically) input data
#line 3217
  *     to output
#line 3217
  *   - update xpp to point at next unconverted input, and tp to point
#line 3217
  *     at next location for converted output
#line 3217
  */
#line 3217
  long i, j, ni;
#line 3217
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3217
  float *xp;
#line 3217
  int nrange = 0;         /* number of range errors */
#line 3217
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3217
  long cxp = (long) *((char**)xpp);
#line 3217

#line 3217
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3217
  /* sjl: manually stripmine so we can limit amount of
#line 3217
   * vector work space reserved to LOOPCNT elements. Also
#line 3217
   * makes vectorisation easy */
#line 3217
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3217
    ni=Min(nelems-j,LOOPCNT);
#line 3217
    if (realign) {
#line 3217
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3217
      xp = tmp;
#line 3217
    } else {
#line 3217
      xp = (float *) *xpp;
#line 3217
    }
#line 3217
   /* copy the next block */
#line 3217
#pragma cdir loopcnt=LOOPCNT
#line 3217
#pragma cdir shortloop
#line 3217
    for (i=0; i<ni; i++) {
#line 3217
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3217
     /* test for range errors (not always needed but do it anyway) */
#line 3217
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3217
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3217
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3217
    }
#line 3217
   /* update xpp and tp */
#line 3217
    if (realign) xp = (float *) *xpp;
#line 3217
    xp += ni;
#line 3217
    tp += ni;
#line 3217
    *xpp = (void*)xp;
#line 3217
  }
#line 3217
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3217

#line 3217
#else   /* not SX */
#line 3217
	const char *xp = (const char *) *xpp;
#line 3217
	int status = NC_NOERR;
#line 3217

#line 3217
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3217
	{
#line 3217
		const int lstatus = ncx_get_float_ushort(xp, tp);
#line 3217
		if (status == NC_NOERR) /* report the first encountered error */
#line 3217
			status = lstatus;
#line 3217
	}
#line 3217

#line 3217
	*xpp = (const void *)xp;
#line 3217
	return status;
#line 3217
#endif
#line 3217
}
#line 3217

int
#line 3218
ncx_getn_float_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3218
{
#line 3218
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3218

#line 3218
 /* basic algorithm is:
#line 3218
  *   - ensure sane alignment of input data
#line 3218
  *   - copy (conversion happens automatically) input data
#line 3218
  *     to output
#line 3218
  *   - update xpp to point at next unconverted input, and tp to point
#line 3218
  *     at next location for converted output
#line 3218
  */
#line 3218
  long i, j, ni;
#line 3218
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3218
  float *xp;
#line 3218
  int nrange = 0;         /* number of range errors */
#line 3218
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3218
  long cxp = (long) *((char**)xpp);
#line 3218

#line 3218
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3218
  /* sjl: manually stripmine so we can limit amount of
#line 3218
   * vector work space reserved to LOOPCNT elements. Also
#line 3218
   * makes vectorisation easy */
#line 3218
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3218
    ni=Min(nelems-j,LOOPCNT);
#line 3218
    if (realign) {
#line 3218
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3218
      xp = tmp;
#line 3218
    } else {
#line 3218
      xp = (float *) *xpp;
#line 3218
    }
#line 3218
   /* copy the next block */
#line 3218
#pragma cdir loopcnt=LOOPCNT
#line 3218
#pragma cdir shortloop
#line 3218
    for (i=0; i<ni; i++) {
#line 3218
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3218
     /* test for range errors (not always needed but do it anyway) */
#line 3218
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3218
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3218
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3218
    }
#line 3218
   /* update xpp and tp */
#line 3218
    if (realign) xp = (float *) *xpp;
#line 3218
    xp += ni;
#line 3218
    tp += ni;
#line 3218
    *xpp = (void*)xp;
#line 3218
  }
#line 3218
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3218

#line 3218
#else   /* not SX */
#line 3218
	const char *xp = (const char *) *xpp;
#line 3218
	int status = NC_NOERR;
#line 3218

#line 3218
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3218
	{
#line 3218
		const int lstatus = ncx_get_float_uchar(xp, tp);
#line 3218
		if (status == NC_NOERR) /* report the first encountered error */
#line 3218
			status = lstatus;
#line 3218
	}
#line 3218

#line 3218
	*xpp = (const void *)xp;
#line 3218
	return status;
#line 3218
#endif
#line 3218
}
#line 3218

int
#line 3219
ncx_getn_float_uint(const void **xpp, size_t nelems, uint *tp)
#line 3219
{
#line 3219
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3219

#line 3219
 /* basic algorithm is:
#line 3219
  *   - ensure sane alignment of input data
#line 3219
  *   - copy (conversion happens automatically) input data
#line 3219
  *     to output
#line 3219
  *   - update xpp to point at next unconverted input, and tp to point
#line 3219
  *     at next location for converted output
#line 3219
  */
#line 3219
  long i, j, ni;
#line 3219
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3219
  float *xp;
#line 3219
  int nrange = 0;         /* number of range errors */
#line 3219
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3219
  long cxp = (long) *((char**)xpp);
#line 3219

#line 3219
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3219
  /* sjl: manually stripmine so we can limit amount of
#line 3219
   * vector work space reserved to LOOPCNT elements. Also
#line 3219
   * makes vectorisation easy */
#line 3219
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3219
    ni=Min(nelems-j,LOOPCNT);
#line 3219
    if (realign) {
#line 3219
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3219
      xp = tmp;
#line 3219
    } else {
#line 3219
      xp = (float *) *xpp;
#line 3219
    }
#line 3219
   /* copy the next block */
#line 3219
#pragma cdir loopcnt=LOOPCNT
#line 3219
#pragma cdir shortloop
#line 3219
    for (i=0; i<ni; i++) {
#line 3219
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3219
     /* test for range errors (not always needed but do it anyway) */
#line 3219
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3219
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3219
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3219
    }
#line 3219
   /* update xpp and tp */
#line 3219
    if (realign) xp = (float *) *xpp;
#line 3219
    xp += ni;
#line 3219
    tp += ni;
#line 3219
    *xpp = (void*)xp;
#line 3219
  }
#line 3219
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3219

#line 3219
#else   /* not SX */
#line 3219
	const char *xp = (const char *) *xpp;
#line 3219
	int status = NC_NOERR;
#line 3219

#line 3219
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3219
	{
#line 3219
		const int lstatus = ncx_get_float_uint(xp, tp);
#line 3219
		if (status == NC_NOERR) /* report the first encountered error */
#line 3219
			status = lstatus;
#line 3219
	}
#line 3219

#line 3219
	*xpp = (const void *)xp;
#line 3219
	return status;
#line 3219
#endif
#line 3219
}
#line 3219

int
#line 3220
ncx_getn_float_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3220
{
#line 3220
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3220

#line 3220
 /* basic algorithm is:
#line 3220
  *   - ensure sane alignment of input data
#line 3220
  *   - copy (conversion happens automatically) input data
#line 3220
  *     to output
#line 3220
  *   - update xpp to point at next unconverted input, and tp to point
#line 3220
  *     at next location for converted output
#line 3220
  */
#line 3220
  long i, j, ni;
#line 3220
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3220
  float *xp;
#line 3220
  int nrange = 0;         /* number of range errors */
#line 3220
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3220
  long cxp = (long) *((char**)xpp);
#line 3220

#line 3220
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3220
  /* sjl: manually stripmine so we can limit amount of
#line 3220
   * vector work space reserved to LOOPCNT elements. Also
#line 3220
   * makes vectorisation easy */
#line 3220
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3220
    ni=Min(nelems-j,LOOPCNT);
#line 3220
    if (realign) {
#line 3220
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3220
      xp = tmp;
#line 3220
    } else {
#line 3220
      xp = (float *) *xpp;
#line 3220
    }
#line 3220
   /* copy the next block */
#line 3220
#pragma cdir loopcnt=LOOPCNT
#line 3220
#pragma cdir shortloop
#line 3220
    for (i=0; i<ni; i++) {
#line 3220
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3220
     /* test for range errors (not always needed but do it anyway) */
#line 3220
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3220
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3220
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3220
    }
#line 3220
   /* update xpp and tp */
#line 3220
    if (realign) xp = (float *) *xpp;
#line 3220
    xp += ni;
#line 3220
    tp += ni;
#line 3220
    *xpp = (void*)xp;
#line 3220
  }
#line 3220
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3220

#line 3220
#else   /* not SX */
#line 3220
	const char *xp = (const char *) *xpp;
#line 3220
	int status = NC_NOERR;
#line 3220

#line 3220
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3220
	{
#line 3220
		const int lstatus = ncx_get_float_ulonglong(xp, tp);
#line 3220
		if (status == NC_NOERR) /* report the first encountered error */
#line 3220
			status = lstatus;
#line 3220
	}
#line 3220

#line 3220
	*xpp = (const void *)xp;
#line 3220
	return status;
#line 3220
#endif
#line 3220
}
#line 3220


int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_FLOAT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
{
	const float *const end = tp + nelems;

	while (tp < end) {
				const struct vax_single *const vsp =
#line 3240
			 (const struct vax_single *)ip;
#line 3240
		struct ieee_single *const isp = (struct ieee_single *) (*xpp);
#line 3240

#line 3240
		switch(vsp->exp){
#line 3240
		case 0 :
#line 3240
			/* all vax float with zero exponent map to zero */
#line 3240
			*isp = min.ieee;
#line 3240
			break;
#line 3240
		case 2 :
#line 3240
		case 1 :
#line 3240
		{
#line 3240
			/* These will map to subnormals */
#line 3240
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 3240
					 | vsp->mantissa2;
#line 3240
			mantissa >>= 3 - vsp->exp;
#line 3240
			mantissa += (1 << (20 + vsp->exp));
#line 3240
			isp->mant_lo_lo = mantissa;
#line 3240
			isp->mant_lo_hi = mantissa >> 8;
#line 3240
			isp->mant_hi = mantissa >> 16;
#line 3240
			isp->exp_lo = 0;
#line 3240
			isp->exp_hi = 0;
#line 3240
		}
#line 3240
			break;
#line 3240
		case 0xff : /* max.s.exp */
#line 3240
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 3240
			    vsp->mantissa1 == max.s.mantissa1)
#line 3240
			{
#line 3240
				/* map largest vax float to ieee infinity */
#line 3240
				*isp = max.ieee;
#line 3240
				break;
#line 3240
			} /* else, fall thru */
#line 3240
		default :
#line 3240
		{
#line 3240
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 3240
			isp->exp_hi = exp >> 1;
#line 3240
			isp->exp_lo = exp;
#line 3240
			isp->mant_lo_lo = vsp->mantissa2;
#line 3240
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 3240
			isp->mant_hi = vsp->mantissa1;
#line 3240
		}
#line 3240
		}
#line 3240

#line 3240
		isp->sign = vsp->sign;
#line 3240

		tp++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++) {
		int lstatus = ncx_put_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3261
ncx_putn_float_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3261
{
#line 3261
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3261

#line 3261
 /* basic algorithm is:
#line 3261
  *   - ensure sane alignment of output data
#line 3261
  *   - copy (conversion happens automatically) input data
#line 3261
  *     to output
#line 3261
  *   - update tp to point at next unconverted input, and xpp to point
#line 3261
  *     at next location for converted output
#line 3261
  */
#line 3261
  long i, j, ni;
#line 3261
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3261
  float *xp;
#line 3261
  int nrange = 0;         /* number of range errors */
#line 3261
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3261
  long cxp = (long) *((char**)xpp);
#line 3261

#line 3261
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3261
  /* sjl: manually stripmine so we can limit amount of
#line 3261
   * vector work space reserved to LOOPCNT elements. Also
#line 3261
   * makes vectorisation easy */
#line 3261
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3261
    ni=Min(nelems-j,LOOPCNT);
#line 3261
    if (realign) {
#line 3261
      xp = tmp;
#line 3261
    } else {
#line 3261
      xp = (float *) *xpp;
#line 3261
    }
#line 3261
   /* copy the next block */
#line 3261
#pragma cdir loopcnt=LOOPCNT
#line 3261
#pragma cdir shortloop
#line 3261
    for (i=0; i<ni; i++) {
#line 3261
      /* the normal case: */
#line 3261
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3261
     /* test for range errors (not always needed but do it anyway) */
#line 3261
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3261
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3261
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3261
    }
#line 3261
   /* copy workspace back if necessary */
#line 3261
    if (realign) {
#line 3261
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3261
      xp = (float *) *xpp;
#line 3261
    }
#line 3261
   /* update xpp and tp */
#line 3261
    xp += ni;
#line 3261
    tp += ni;
#line 3261
    *xpp = (void*)xp;
#line 3261
  }
#line 3261
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3261

#line 3261
#else   /* not SX */
#line 3261

#line 3261
	char *xp = (char *) *xpp;
#line 3261
	int status = NC_NOERR;
#line 3261

#line 3261
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3261
	{
#line 3261
		int lstatus = ncx_put_float_schar(xp, tp, fillp);
#line 3261
		if (status == NC_NOERR) /* report the first encountered error */
#line 3261
			status = lstatus;
#line 3261
	}
#line 3261

#line 3261
	*xpp = (void *)xp;
#line 3261
	return status;
#line 3261
#endif
#line 3261
}
#line 3261

int
#line 3262
ncx_putn_float_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3262
{
#line 3262
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3262

#line 3262
 /* basic algorithm is:
#line 3262
  *   - ensure sane alignment of output data
#line 3262
  *   - copy (conversion happens automatically) input data
#line 3262
  *     to output
#line 3262
  *   - update tp to point at next unconverted input, and xpp to point
#line 3262
  *     at next location for converted output
#line 3262
  */
#line 3262
  long i, j, ni;
#line 3262
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3262
  float *xp;
#line 3262
  int nrange = 0;         /* number of range errors */
#line 3262
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3262
  long cxp = (long) *((char**)xpp);
#line 3262

#line 3262
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3262
  /* sjl: manually stripmine so we can limit amount of
#line 3262
   * vector work space reserved to LOOPCNT elements. Also
#line 3262
   * makes vectorisation easy */
#line 3262
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3262
    ni=Min(nelems-j,LOOPCNT);
#line 3262
    if (realign) {
#line 3262
      xp = tmp;
#line 3262
    } else {
#line 3262
      xp = (float *) *xpp;
#line 3262
    }
#line 3262
   /* copy the next block */
#line 3262
#pragma cdir loopcnt=LOOPCNT
#line 3262
#pragma cdir shortloop
#line 3262
    for (i=0; i<ni; i++) {
#line 3262
      /* the normal case: */
#line 3262
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3262
     /* test for range errors (not always needed but do it anyway) */
#line 3262
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3262
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3262
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3262
    }
#line 3262
   /* copy workspace back if necessary */
#line 3262
    if (realign) {
#line 3262
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3262
      xp = (float *) *xpp;
#line 3262
    }
#line 3262
   /* update xpp and tp */
#line 3262
    xp += ni;
#line 3262
    tp += ni;
#line 3262
    *xpp = (void*)xp;
#line 3262
  }
#line 3262
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3262

#line 3262
#else   /* not SX */
#line 3262

#line 3262
	char *xp = (char *) *xpp;
#line 3262
	int status = NC_NOERR;
#line 3262

#line 3262
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3262
	{
#line 3262
		int lstatus = ncx_put_float_short(xp, tp, fillp);
#line 3262
		if (status == NC_NOERR) /* report the first encountered error */
#line 3262
			status = lstatus;
#line 3262
	}
#line 3262

#line 3262
	*xpp = (void *)xp;
#line 3262
	return status;
#line 3262
#endif
#line 3262
}
#line 3262

int
#line 3263
ncx_putn_float_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3263
{
#line 3263
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3263

#line 3263
 /* basic algorithm is:
#line 3263
  *   - ensure sane alignment of output data
#line 3263
  *   - copy (conversion happens automatically) input data
#line 3263
  *     to output
#line 3263
  *   - update tp to point at next unconverted input, and xpp to point
#line 3263
  *     at next location for converted output
#line 3263
  */
#line 3263
  long i, j, ni;
#line 3263
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3263
  float *xp;
#line 3263
  int nrange = 0;         /* number of range errors */
#line 3263
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3263
  long cxp = (long) *((char**)xpp);
#line 3263

#line 3263
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3263
  /* sjl: manually stripmine so we can limit amount of
#line 3263
   * vector work space reserved to LOOPCNT elements. Also
#line 3263
   * makes vectorisation easy */
#line 3263
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3263
    ni=Min(nelems-j,LOOPCNT);
#line 3263
    if (realign) {
#line 3263
      xp = tmp;
#line 3263
    } else {
#line 3263
      xp = (float *) *xpp;
#line 3263
    }
#line 3263
   /* copy the next block */
#line 3263
#pragma cdir loopcnt=LOOPCNT
#line 3263
#pragma cdir shortloop
#line 3263
    for (i=0; i<ni; i++) {
#line 3263
      /* the normal case: */
#line 3263
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3263
     /* test for range errors (not always needed but do it anyway) */
#line 3263
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3263
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3263
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3263
    }
#line 3263
   /* copy workspace back if necessary */
#line 3263
    if (realign) {
#line 3263
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3263
      xp = (float *) *xpp;
#line 3263
    }
#line 3263
   /* update xpp and tp */
#line 3263
    xp += ni;
#line 3263
    tp += ni;
#line 3263
    *xpp = (void*)xp;
#line 3263
  }
#line 3263
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3263

#line 3263
#else   /* not SX */
#line 3263

#line 3263
	char *xp = (char *) *xpp;
#line 3263
	int status = NC_NOERR;
#line 3263

#line 3263
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3263
	{
#line 3263
		int lstatus = ncx_put_float_int(xp, tp, fillp);
#line 3263
		if (status == NC_NOERR) /* report the first encountered error */
#line 3263
			status = lstatus;
#line 3263
	}
#line 3263

#line 3263
	*xpp = (void *)xp;
#line 3263
	return status;
#line 3263
#endif
#line 3263
}
#line 3263

int
#line 3264
ncx_putn_float_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3264
{
#line 3264
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3264

#line 3264
 /* basic algorithm is:
#line 3264
  *   - ensure sane alignment of output data
#line 3264
  *   - copy (conversion happens automatically) input data
#line 3264
  *     to output
#line 3264
  *   - update tp to point at next unconverted input, and xpp to point
#line 3264
  *     at next location for converted output
#line 3264
  */
#line 3264
  long i, j, ni;
#line 3264
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3264
  float *xp;
#line 3264
  int nrange = 0;         /* number of range errors */
#line 3264
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3264
  long cxp = (long) *((char**)xpp);
#line 3264

#line 3264
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3264
  /* sjl: manually stripmine so we can limit amount of
#line 3264
   * vector work space reserved to LOOPCNT elements. Also
#line 3264
   * makes vectorisation easy */
#line 3264
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3264
    ni=Min(nelems-j,LOOPCNT);
#line 3264
    if (realign) {
#line 3264
      xp = tmp;
#line 3264
    } else {
#line 3264
      xp = (float *) *xpp;
#line 3264
    }
#line 3264
   /* copy the next block */
#line 3264
#pragma cdir loopcnt=LOOPCNT
#line 3264
#pragma cdir shortloop
#line 3264
    for (i=0; i<ni; i++) {
#line 3264
      /* the normal case: */
#line 3264
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3264
     /* test for range errors (not always needed but do it anyway) */
#line 3264
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3264
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3264
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3264
    }
#line 3264
   /* copy workspace back if necessary */
#line 3264
    if (realign) {
#line 3264
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3264
      xp = (float *) *xpp;
#line 3264
    }
#line 3264
   /* update xpp and tp */
#line 3264
    xp += ni;
#line 3264
    tp += ni;
#line 3264
    *xpp = (void*)xp;
#line 3264
  }
#line 3264
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3264

#line 3264
#else   /* not SX */
#line 3264

#line 3264
	char *xp = (char *) *xpp;
#line 3264
	int status = NC_NOERR;
#line 3264

#line 3264
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3264
	{
#line 3264
		int lstatus = ncx_put_float_long(xp, tp, fillp);
#line 3264
		if (status == NC_NOERR) /* report the first encountered error */
#line 3264
			status = lstatus;
#line 3264
	}
#line 3264

#line 3264
	*xpp = (void *)xp;
#line 3264
	return status;
#line 3264
#endif
#line 3264
}
#line 3264

int
#line 3265
ncx_putn_float_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3265
{
#line 3265
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3265

#line 3265
 /* basic algorithm is:
#line 3265
  *   - ensure sane alignment of output data
#line 3265
  *   - copy (conversion happens automatically) input data
#line 3265
  *     to output
#line 3265
  *   - update tp to point at next unconverted input, and xpp to point
#line 3265
  *     at next location for converted output
#line 3265
  */
#line 3265
  long i, j, ni;
#line 3265
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3265
  float *xp;
#line 3265
  int nrange = 0;         /* number of range errors */
#line 3265
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3265
  long cxp = (long) *((char**)xpp);
#line 3265

#line 3265
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3265
  /* sjl: manually stripmine so we can limit amount of
#line 3265
   * vector work space reserved to LOOPCNT elements. Also
#line 3265
   * makes vectorisation easy */
#line 3265
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3265
    ni=Min(nelems-j,LOOPCNT);
#line 3265
    if (realign) {
#line 3265
      xp = tmp;
#line 3265
    } else {
#line 3265
      xp = (float *) *xpp;
#line 3265
    }
#line 3265
   /* copy the next block */
#line 3265
#pragma cdir loopcnt=LOOPCNT
#line 3265
#pragma cdir shortloop
#line 3265
    for (i=0; i<ni; i++) {
#line 3265
      /* the normal case: */
#line 3265
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3265
     /* test for range errors (not always needed but do it anyway) */
#line 3265
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3265
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3265
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3265
    }
#line 3265
   /* copy workspace back if necessary */
#line 3265
    if (realign) {
#line 3265
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3265
      xp = (float *) *xpp;
#line 3265
    }
#line 3265
   /* update xpp and tp */
#line 3265
    xp += ni;
#line 3265
    tp += ni;
#line 3265
    *xpp = (void*)xp;
#line 3265
  }
#line 3265
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3265

#line 3265
#else   /* not SX */
#line 3265

#line 3265
	char *xp = (char *) *xpp;
#line 3265
	int status = NC_NOERR;
#line 3265

#line 3265
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3265
	{
#line 3265
		int lstatus = ncx_put_float_double(xp, tp, fillp);
#line 3265
		if (status == NC_NOERR) /* report the first encountered error */
#line 3265
			status = lstatus;
#line 3265
	}
#line 3265

#line 3265
	*xpp = (void *)xp;
#line 3265
	return status;
#line 3265
#endif
#line 3265
}
#line 3265

int
#line 3266
ncx_putn_float_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3266
{
#line 3266
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3266

#line 3266
 /* basic algorithm is:
#line 3266
  *   - ensure sane alignment of output data
#line 3266
  *   - copy (conversion happens automatically) input data
#line 3266
  *     to output
#line 3266
  *   - update tp to point at next unconverted input, and xpp to point
#line 3266
  *     at next location for converted output
#line 3266
  */
#line 3266
  long i, j, ni;
#line 3266
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3266
  float *xp;
#line 3266
  int nrange = 0;         /* number of range errors */
#line 3266
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3266
  long cxp = (long) *((char**)xpp);
#line 3266

#line 3266
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3266
  /* sjl: manually stripmine so we can limit amount of
#line 3266
   * vector work space reserved to LOOPCNT elements. Also
#line 3266
   * makes vectorisation easy */
#line 3266
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3266
    ni=Min(nelems-j,LOOPCNT);
#line 3266
    if (realign) {
#line 3266
      xp = tmp;
#line 3266
    } else {
#line 3266
      xp = (float *) *xpp;
#line 3266
    }
#line 3266
   /* copy the next block */
#line 3266
#pragma cdir loopcnt=LOOPCNT
#line 3266
#pragma cdir shortloop
#line 3266
    for (i=0; i<ni; i++) {
#line 3266
      /* the normal case: */
#line 3266
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3266
     /* test for range errors (not always needed but do it anyway) */
#line 3266
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3266
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3266
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3266
    }
#line 3266
   /* copy workspace back if necessary */
#line 3266
    if (realign) {
#line 3266
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3266
      xp = (float *) *xpp;
#line 3266
    }
#line 3266
   /* update xpp and tp */
#line 3266
    xp += ni;
#line 3266
    tp += ni;
#line 3266
    *xpp = (void*)xp;
#line 3266
  }
#line 3266
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3266

#line 3266
#else   /* not SX */
#line 3266

#line 3266
	char *xp = (char *) *xpp;
#line 3266
	int status = NC_NOERR;
#line 3266

#line 3266
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3266
	{
#line 3266
		int lstatus = ncx_put_float_longlong(xp, tp, fillp);
#line 3266
		if (status == NC_NOERR) /* report the first encountered error */
#line 3266
			status = lstatus;
#line 3266
	}
#line 3266

#line 3266
	*xpp = (void *)xp;
#line 3266
	return status;
#line 3266
#endif
#line 3266
}
#line 3266

int
#line 3267
ncx_putn_float_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3267
{
#line 3267
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3267

#line 3267
 /* basic algorithm is:
#line 3267
  *   - ensure sane alignment of output data
#line 3267
  *   - copy (conversion happens automatically) input data
#line 3267
  *     to output
#line 3267
  *   - update tp to point at next unconverted input, and xpp to point
#line 3267
  *     at next location for converted output
#line 3267
  */
#line 3267
  long i, j, ni;
#line 3267
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3267
  float *xp;
#line 3267
  int nrange = 0;         /* number of range errors */
#line 3267
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3267
  long cxp = (long) *((char**)xpp);
#line 3267

#line 3267
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3267
  /* sjl: manually stripmine so we can limit amount of
#line 3267
   * vector work space reserved to LOOPCNT elements. Also
#line 3267
   * makes vectorisation easy */
#line 3267
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3267
    ni=Min(nelems-j,LOOPCNT);
#line 3267
    if (realign) {
#line 3267
      xp = tmp;
#line 3267
    } else {
#line 3267
      xp = (float *) *xpp;
#line 3267
    }
#line 3267
   /* copy the next block */
#line 3267
#pragma cdir loopcnt=LOOPCNT
#line 3267
#pragma cdir shortloop
#line 3267
    for (i=0; i<ni; i++) {
#line 3267
      /* the normal case: */
#line 3267
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3267
     /* test for range errors (not always needed but do it anyway) */
#line 3267
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3267
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3267
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3267
    }
#line 3267
   /* copy workspace back if necessary */
#line 3267
    if (realign) {
#line 3267
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3267
      xp = (float *) *xpp;
#line 3267
    }
#line 3267
   /* update xpp and tp */
#line 3267
    xp += ni;
#line 3267
    tp += ni;
#line 3267
    *xpp = (void*)xp;
#line 3267
  }
#line 3267
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3267

#line 3267
#else   /* not SX */
#line 3267

#line 3267
	char *xp = (char *) *xpp;
#line 3267
	int status = NC_NOERR;
#line 3267

#line 3267
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3267
	{
#line 3267
		int lstatus = ncx_put_float_uchar(xp, tp, fillp);
#line 3267
		if (status == NC_NOERR) /* report the first encountered error */
#line 3267
			status = lstatus;
#line 3267
	}
#line 3267

#line 3267
	*xpp = (void *)xp;
#line 3267
	return status;
#line 3267
#endif
#line 3267
}
#line 3267

int
#line 3268
ncx_putn_float_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3268
{
#line 3268
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3268

#line 3268
 /* basic algorithm is:
#line 3268
  *   - ensure sane alignment of output data
#line 3268
  *   - copy (conversion happens automatically) input data
#line 3268
  *     to output
#line 3268
  *   - update tp to point at next unconverted input, and xpp to point
#line 3268
  *     at next location for converted output
#line 3268
  */
#line 3268
  long i, j, ni;
#line 3268
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3268
  float *xp;
#line 3268
  int nrange = 0;         /* number of range errors */
#line 3268
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3268
  long cxp = (long) *((char**)xpp);
#line 3268

#line 3268
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3268
  /* sjl: manually stripmine so we can limit amount of
#line 3268
   * vector work space reserved to LOOPCNT elements. Also
#line 3268
   * makes vectorisation easy */
#line 3268
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3268
    ni=Min(nelems-j,LOOPCNT);
#line 3268
    if (realign) {
#line 3268
      xp = tmp;
#line 3268
    } else {
#line 3268
      xp = (float *) *xpp;
#line 3268
    }
#line 3268
   /* copy the next block */
#line 3268
#pragma cdir loopcnt=LOOPCNT
#line 3268
#pragma cdir shortloop
#line 3268
    for (i=0; i<ni; i++) {
#line 3268
      /* the normal case: */
#line 3268
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3268
     /* test for range errors (not always needed but do it anyway) */
#line 3268
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3268
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3268
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3268
    }
#line 3268
   /* copy workspace back if necessary */
#line 3268
    if (realign) {
#line 3268
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3268
      xp = (float *) *xpp;
#line 3268
    }
#line 3268
   /* update xpp and tp */
#line 3268
    xp += ni;
#line 3268
    tp += ni;
#line 3268
    *xpp = (void*)xp;
#line 3268
  }
#line 3268
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3268

#line 3268
#else   /* not SX */
#line 3268

#line 3268
	char *xp = (char *) *xpp;
#line 3268
	int status = NC_NOERR;
#line 3268

#line 3268
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3268
	{
#line 3268
		int lstatus = ncx_put_float_ushort(xp, tp, fillp);
#line 3268
		if (status == NC_NOERR) /* report the first encountered error */
#line 3268
			status = lstatus;
#line 3268
	}
#line 3268

#line 3268
	*xpp = (void *)xp;
#line 3268
	return status;
#line 3268
#endif
#line 3268
}
#line 3268

int
#line 3269
ncx_putn_float_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3269
{
#line 3269
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3269

#line 3269
 /* basic algorithm is:
#line 3269
  *   - ensure sane alignment of output data
#line 3269
  *   - copy (conversion happens automatically) input data
#line 3269
  *     to output
#line 3269
  *   - update tp to point at next unconverted input, and xpp to point
#line 3269
  *     at next location for converted output
#line 3269
  */
#line 3269
  long i, j, ni;
#line 3269
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3269
  float *xp;
#line 3269
  int nrange = 0;         /* number of range errors */
#line 3269
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3269
  long cxp = (long) *((char**)xpp);
#line 3269

#line 3269
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3269
  /* sjl: manually stripmine so we can limit amount of
#line 3269
   * vector work space reserved to LOOPCNT elements. Also
#line 3269
   * makes vectorisation easy */
#line 3269
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3269
    ni=Min(nelems-j,LOOPCNT);
#line 3269
    if (realign) {
#line 3269
      xp = tmp;
#line 3269
    } else {
#line 3269
      xp = (float *) *xpp;
#line 3269
    }
#line 3269
   /* copy the next block */
#line 3269
#pragma cdir loopcnt=LOOPCNT
#line 3269
#pragma cdir shortloop
#line 3269
    for (i=0; i<ni; i++) {
#line 3269
      /* the normal case: */
#line 3269
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3269
     /* test for range errors (not always needed but do it anyway) */
#line 3269
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3269
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3269
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3269
    }
#line 3269
   /* copy workspace back if necessary */
#line 3269
    if (realign) {
#line 3269
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3269
      xp = (float *) *xpp;
#line 3269
    }
#line 3269
   /* update xpp and tp */
#line 3269
    xp += ni;
#line 3269
    tp += ni;
#line 3269
    *xpp = (void*)xp;
#line 3269
  }
#line 3269
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3269

#line 3269
#else   /* not SX */
#line 3269

#line 3269
	char *xp = (char *) *xpp;
#line 3269
	int status = NC_NOERR;
#line 3269

#line 3269
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3269
	{
#line 3269
		int lstatus = ncx_put_float_uint(xp, tp, fillp);
#line 3269
		if (status == NC_NOERR) /* report the first encountered error */
#line 3269
			status = lstatus;
#line 3269
	}
#line 3269

#line 3269
	*xpp = (void *)xp;
#line 3269
	return status;
#line 3269
#endif
#line 3269
}
#line 3269

int
#line 3270
ncx_putn_float_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3270
{
#line 3270
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3270

#line 3270
 /* basic algorithm is:
#line 3270
  *   - ensure sane alignment of output data
#line 3270
  *   - copy (conversion happens automatically) input data
#line 3270
  *     to output
#line 3270
  *   - update tp to point at next unconverted input, and xpp to point
#line 3270
  *     at next location for converted output
#line 3270
  */
#line 3270
  long i, j, ni;
#line 3270
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3270
  float *xp;
#line 3270
  int nrange = 0;         /* number of range errors */
#line 3270
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3270
  long cxp = (long) *((char**)xpp);
#line 3270

#line 3270
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3270
  /* sjl: manually stripmine so we can limit amount of
#line 3270
   * vector work space reserved to LOOPCNT elements. Also
#line 3270
   * makes vectorisation easy */
#line 3270
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3270
    ni=Min(nelems-j,LOOPCNT);
#line 3270
    if (realign) {
#line 3270
      xp = tmp;
#line 3270
    } else {
#line 3270
      xp = (float *) *xpp;
#line 3270
    }
#line 3270
   /* copy the next block */
#line 3270
#pragma cdir loopcnt=LOOPCNT
#line 3270
#pragma cdir shortloop
#line 3270
    for (i=0; i<ni; i++) {
#line 3270
      /* the normal case: */
#line 3270
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3270
     /* test for range errors (not always needed but do it anyway) */
#line 3270
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3270
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3270
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3270
    }
#line 3270
   /* copy workspace back if necessary */
#line 3270
    if (realign) {
#line 3270
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3270
      xp = (float *) *xpp;
#line 3270
    }
#line 3270
   /* update xpp and tp */
#line 3270
    xp += ni;
#line 3270
    tp += ni;
#line 3270
    *xpp = (void*)xp;
#line 3270
  }
#line 3270
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3270

#line 3270
#else   /* not SX */
#line 3270

#line 3270
	char *xp = (char *) *xpp;
#line 3270
	int status = NC_NOERR;
#line 3270

#line 3270
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3270
	{
#line 3270
		int lstatus = ncx_put_float_ulonglong(xp, tp, fillp);
#line 3270
		if (status == NC_NOERR) /* report the first encountered error */
#line 3270
			status = lstatus;
#line 3270
	}
#line 3270

#line 3270
	*xpp = (void *)xp;
#line 3270
	return status;
#line 3270
#endif
#line 3270
}
#line 3270


/* double --------------------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_DOUBLE);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_double_double(const void **xpp, size_t ndoubles, double *ip)
{
	double *const end = ip + ndoubles;

	while (ip < end)
	{
	struct vax_double *const vdp =
#line 3295
			 (struct vax_double *)ip;
#line 3295
	const struct ieee_double *const idp =
#line 3295
			 (const struct ieee_double *) (*xpp);
#line 3295
	{
#line 3295
		const struct dbl_limits *lim;
#line 3295
		int ii;
#line 3295
		for (ii = 0, lim = dbl_limits;
#line 3295
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 3295
			ii++, lim++)
#line 3295
		{
#line 3295
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 3295
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 3295
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 3295
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 3295
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 3295
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 3295
				)
#line 3295
			{
#line 3295
				*vdp = lim->d;
#line 3295
				goto doneit;
#line 3295
			}
#line 3295
		}
#line 3295
	}
#line 3295
	{
#line 3295
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 3295
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 3295
	}
#line 3295
	{
#line 3295
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 3295
				 | (idp->mant_5 << 8)
#line 3295
				 | idp->mant_4);
#line 3295
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 3295
		vdp->mantissa1 = (mant_hi >> 13);
#line 3295
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 3295
				| (mant_lo >> 29);
#line 3295
		vdp->mantissa3 = (mant_lo >> 13);
#line 3295
		vdp->mantissa4 = (mant_lo << 3);
#line 3295
	}
#line 3295
	doneit:
#line 3295
		vdp->sign = idp->sign;
#line 3295

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}
#endif
int
#line 3320
ncx_getn_double_schar(const void **xpp, size_t nelems, schar *tp)
#line 3320
{
#line 3320
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3320

#line 3320
 /* basic algorithm is:
#line 3320
  *   - ensure sane alignment of input data
#line 3320
  *   - copy (conversion happens automatically) input data
#line 3320
  *     to output
#line 3320
  *   - update xpp to point at next unconverted input, and tp to point
#line 3320
  *     at next location for converted output
#line 3320
  */
#line 3320
  long i, j, ni;
#line 3320
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3320
  double *xp;
#line 3320
  int nrange = 0;         /* number of range errors */
#line 3320
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3320
  long cxp = (long) *((char**)xpp);
#line 3320

#line 3320
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3320
  /* sjl: manually stripmine so we can limit amount of
#line 3320
   * vector work space reserved to LOOPCNT elements. Also
#line 3320
   * makes vectorisation easy */
#line 3320
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3320
    ni=Min(nelems-j,LOOPCNT);
#line 3320
    if (realign) {
#line 3320
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3320
      xp = tmp;
#line 3320
    } else {
#line 3320
      xp = (double *) *xpp;
#line 3320
    }
#line 3320
   /* copy the next block */
#line 3320
#pragma cdir loopcnt=LOOPCNT
#line 3320
#pragma cdir shortloop
#line 3320
    for (i=0; i<ni; i++) {
#line 3320
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3320
     /* test for range errors (not always needed but do it anyway) */
#line 3320
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3320
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3320
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3320
    }
#line 3320
   /* update xpp and tp */
#line 3320
    if (realign) xp = (double *) *xpp;
#line 3320
    xp += ni;
#line 3320
    tp += ni;
#line 3320
    *xpp = (void*)xp;
#line 3320
  }
#line 3320
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3320

#line 3320
#else   /* not SX */
#line 3320
	const char *xp = (const char *) *xpp;
#line 3320
	int status = NC_NOERR;
#line 3320

#line 3320
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3320
	{
#line 3320
		const int lstatus = ncx_get_double_schar(xp, tp);
#line 3320
		if (status == NC_NOERR) /* report the first encountered error */
#line 3320
			status = lstatus;
#line 3320
	}
#line 3320

#line 3320
	*xpp = (const void *)xp;
#line 3320
	return status;
#line 3320
#endif
#line 3320
}
#line 3320

int
#line 3321
ncx_getn_double_short(const void **xpp, size_t nelems, short *tp)
#line 3321
{
#line 3321
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3321

#line 3321
 /* basic algorithm is:
#line 3321
  *   - ensure sane alignment of input data
#line 3321
  *   - copy (conversion happens automatically) input data
#line 3321
  *     to output
#line 3321
  *   - update xpp to point at next unconverted input, and tp to point
#line 3321
  *     at next location for converted output
#line 3321
  */
#line 3321
  long i, j, ni;
#line 3321
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3321
  double *xp;
#line 3321
  int nrange = 0;         /* number of range errors */
#line 3321
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3321
  long cxp = (long) *((char**)xpp);
#line 3321

#line 3321
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3321
  /* sjl: manually stripmine so we can limit amount of
#line 3321
   * vector work space reserved to LOOPCNT elements. Also
#line 3321
   * makes vectorisation easy */
#line 3321
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3321
    ni=Min(nelems-j,LOOPCNT);
#line 3321
    if (realign) {
#line 3321
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3321
      xp = tmp;
#line 3321
    } else {
#line 3321
      xp = (double *) *xpp;
#line 3321
    }
#line 3321
   /* copy the next block */
#line 3321
#pragma cdir loopcnt=LOOPCNT
#line 3321
#pragma cdir shortloop
#line 3321
    for (i=0; i<ni; i++) {
#line 3321
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3321
     /* test for range errors (not always needed but do it anyway) */
#line 3321
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3321
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3321
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3321
    }
#line 3321
   /* update xpp and tp */
#line 3321
    if (realign) xp = (double *) *xpp;
#line 3321
    xp += ni;
#line 3321
    tp += ni;
#line 3321
    *xpp = (void*)xp;
#line 3321
  }
#line 3321
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3321

#line 3321
#else   /* not SX */
#line 3321
	const char *xp = (const char *) *xpp;
#line 3321
	int status = NC_NOERR;
#line 3321

#line 3321
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3321
	{
#line 3321
		const int lstatus = ncx_get_double_short(xp, tp);
#line 3321
		if (status == NC_NOERR) /* report the first encountered error */
#line 3321
			status = lstatus;
#line 3321
	}
#line 3321

#line 3321
	*xpp = (const void *)xp;
#line 3321
	return status;
#line 3321
#endif
#line 3321
}
#line 3321

int
#line 3322
ncx_getn_double_int(const void **xpp, size_t nelems, int *tp)
#line 3322
{
#line 3322
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3322

#line 3322
 /* basic algorithm is:
#line 3322
  *   - ensure sane alignment of input data
#line 3322
  *   - copy (conversion happens automatically) input data
#line 3322
  *     to output
#line 3322
  *   - update xpp to point at next unconverted input, and tp to point
#line 3322
  *     at next location for converted output
#line 3322
  */
#line 3322
  long i, j, ni;
#line 3322
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3322
  double *xp;
#line 3322
  int nrange = 0;         /* number of range errors */
#line 3322
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3322
  long cxp = (long) *((char**)xpp);
#line 3322

#line 3322
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3322
  /* sjl: manually stripmine so we can limit amount of
#line 3322
   * vector work space reserved to LOOPCNT elements. Also
#line 3322
   * makes vectorisation easy */
#line 3322
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3322
    ni=Min(nelems-j,LOOPCNT);
#line 3322
    if (realign) {
#line 3322
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3322
      xp = tmp;
#line 3322
    } else {
#line 3322
      xp = (double *) *xpp;
#line 3322
    }
#line 3322
   /* copy the next block */
#line 3322
#pragma cdir loopcnt=LOOPCNT
#line 3322
#pragma cdir shortloop
#line 3322
    for (i=0; i<ni; i++) {
#line 3322
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3322
     /* test for range errors (not always needed but do it anyway) */
#line 3322
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3322
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3322
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3322
    }
#line 3322
   /* update xpp and tp */
#line 3322
    if (realign) xp = (double *) *xpp;
#line 3322
    xp += ni;
#line 3322
    tp += ni;
#line 3322
    *xpp = (void*)xp;
#line 3322
  }
#line 3322
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3322

#line 3322
#else   /* not SX */
#line 3322
	const char *xp = (const char *) *xpp;
#line 3322
	int status = NC_NOERR;
#line 3322

#line 3322
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3322
	{
#line 3322
		const int lstatus = ncx_get_double_int(xp, tp);
#line 3322
		if (status == NC_NOERR) /* report the first encountered error */
#line 3322
			status = lstatus;
#line 3322
	}
#line 3322

#line 3322
	*xpp = (const void *)xp;
#line 3322
	return status;
#line 3322
#endif
#line 3322
}
#line 3322

int
#line 3323
ncx_getn_double_long(const void **xpp, size_t nelems, long *tp)
#line 3323
{
#line 3323
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3323

#line 3323
 /* basic algorithm is:
#line 3323
  *   - ensure sane alignment of input data
#line 3323
  *   - copy (conversion happens automatically) input data
#line 3323
  *     to output
#line 3323
  *   - update xpp to point at next unconverted input, and tp to point
#line 3323
  *     at next location for converted output
#line 3323
  */
#line 3323
  long i, j, ni;
#line 3323
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3323
  double *xp;
#line 3323
  int nrange = 0;         /* number of range errors */
#line 3323
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3323
  long cxp = (long) *((char**)xpp);
#line 3323

#line 3323
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3323
  /* sjl: manually stripmine so we can limit amount of
#line 3323
   * vector work space reserved to LOOPCNT elements. Also
#line 3323
   * makes vectorisation easy */
#line 3323
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3323
    ni=Min(nelems-j,LOOPCNT);
#line 3323
    if (realign) {
#line 3323
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3323
      xp = tmp;
#line 3323
    } else {
#line 3323
      xp = (double *) *xpp;
#line 3323
    }
#line 3323
   /* copy the next block */
#line 3323
#pragma cdir loopcnt=LOOPCNT
#line 3323
#pragma cdir shortloop
#line 3323
    for (i=0; i<ni; i++) {
#line 3323
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3323
     /* test for range errors (not always needed but do it anyway) */
#line 3323
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3323
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3323
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3323
    }
#line 3323
   /* update xpp and tp */
#line 3323
    if (realign) xp = (double *) *xpp;
#line 3323
    xp += ni;
#line 3323
    tp += ni;
#line 3323
    *xpp = (void*)xp;
#line 3323
  }
#line 3323
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3323

#line 3323
#else   /* not SX */
#line 3323
	const char *xp = (const char *) *xpp;
#line 3323
	int status = NC_NOERR;
#line 3323

#line 3323
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3323
	{
#line 3323
		const int lstatus = ncx_get_double_long(xp, tp);
#line 3323
		if (status == NC_NOERR) /* report the first encountered error */
#line 3323
			status = lstatus;
#line 3323
	}
#line 3323

#line 3323
	*xpp = (const void *)xp;
#line 3323
	return status;
#line 3323
#endif
#line 3323
}
#line 3323

int
#line 3324
ncx_getn_double_float(const void **xpp, size_t nelems, float *tp)
#line 3324
{
#line 3324
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3324

#line 3324
 /* basic algorithm is:
#line 3324
  *   - ensure sane alignment of input data
#line 3324
  *   - copy (conversion happens automatically) input data
#line 3324
  *     to output
#line 3324
  *   - update xpp to point at next unconverted input, and tp to point
#line 3324
  *     at next location for converted output
#line 3324
  */
#line 3324
  long i, j, ni;
#line 3324
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3324
  double *xp;
#line 3324
  int nrange = 0;         /* number of range errors */
#line 3324
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3324
  long cxp = (long) *((char**)xpp);
#line 3324

#line 3324
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3324
  /* sjl: manually stripmine so we can limit amount of
#line 3324
   * vector work space reserved to LOOPCNT elements. Also
#line 3324
   * makes vectorisation easy */
#line 3324
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3324
    ni=Min(nelems-j,LOOPCNT);
#line 3324
    if (realign) {
#line 3324
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3324
      xp = tmp;
#line 3324
    } else {
#line 3324
      xp = (double *) *xpp;
#line 3324
    }
#line 3324
   /* copy the next block */
#line 3324
#pragma cdir loopcnt=LOOPCNT
#line 3324
#pragma cdir shortloop
#line 3324
    for (i=0; i<ni; i++) {
#line 3324
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3324
     /* test for range errors (not always needed but do it anyway) */
#line 3324
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3324
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3324
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3324
    }
#line 3324
   /* update xpp and tp */
#line 3324
    if (realign) xp = (double *) *xpp;
#line 3324
    xp += ni;
#line 3324
    tp += ni;
#line 3324
    *xpp = (void*)xp;
#line 3324
  }
#line 3324
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3324

#line 3324
#else   /* not SX */
#line 3324
	const char *xp = (const char *) *xpp;
#line 3324
	int status = NC_NOERR;
#line 3324

#line 3324
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3324
	{
#line 3324
		const int lstatus = ncx_get_double_float(xp, tp);
#line 3324
		if (status == NC_NOERR) /* report the first encountered error */
#line 3324
			status = lstatus;
#line 3324
	}
#line 3324

#line 3324
	*xpp = (const void *)xp;
#line 3324
	return status;
#line 3324
#endif
#line 3324
}
#line 3324

int
#line 3325
ncx_getn_double_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3325
{
#line 3325
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3325

#line 3325
 /* basic algorithm is:
#line 3325
  *   - ensure sane alignment of input data
#line 3325
  *   - copy (conversion happens automatically) input data
#line 3325
  *     to output
#line 3325
  *   - update xpp to point at next unconverted input, and tp to point
#line 3325
  *     at next location for converted output
#line 3325
  */
#line 3325
  long i, j, ni;
#line 3325
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3325
  double *xp;
#line 3325
  int nrange = 0;         /* number of range errors */
#line 3325
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3325
  long cxp = (long) *((char**)xpp);
#line 3325

#line 3325
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3325
  /* sjl: manually stripmine so we can limit amount of
#line 3325
   * vector work space reserved to LOOPCNT elements. Also
#line 3325
   * makes vectorisation easy */
#line 3325
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3325
    ni=Min(nelems-j,LOOPCNT);
#line 3325
    if (realign) {
#line 3325
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3325
      xp = tmp;
#line 3325
    } else {
#line 3325
      xp = (double *) *xpp;
#line 3325
    }
#line 3325
   /* copy the next block */
#line 3325
#pragma cdir loopcnt=LOOPCNT
#line 3325
#pragma cdir shortloop
#line 3325
    for (i=0; i<ni; i++) {
#line 3325
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3325
     /* test for range errors (not always needed but do it anyway) */
#line 3325
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3325
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3325
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3325
    }
#line 3325
   /* update xpp and tp */
#line 3325
    if (realign) xp = (double *) *xpp;
#line 3325
    xp += ni;
#line 3325
    tp += ni;
#line 3325
    *xpp = (void*)xp;
#line 3325
  }
#line 3325
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3325

#line 3325
#else   /* not SX */
#line 3325
	const char *xp = (const char *) *xpp;
#line 3325
	int status = NC_NOERR;
#line 3325

#line 3325
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3325
	{
#line 3325
		const int lstatus = ncx_get_double_longlong(xp, tp);
#line 3325
		if (status == NC_NOERR) /* report the first encountered error */
#line 3325
			status = lstatus;
#line 3325
	}
#line 3325

#line 3325
	*xpp = (const void *)xp;
#line 3325
	return status;
#line 3325
#endif
#line 3325
}
#line 3325

int
#line 3326
ncx_getn_double_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3326
{
#line 3326
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3326

#line 3326
 /* basic algorithm is:
#line 3326
  *   - ensure sane alignment of input data
#line 3326
  *   - copy (conversion happens automatically) input data
#line 3326
  *     to output
#line 3326
  *   - update xpp to point at next unconverted input, and tp to point
#line 3326
  *     at next location for converted output
#line 3326
  */
#line 3326
  long i, j, ni;
#line 3326
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3326
  double *xp;
#line 3326
  int nrange = 0;         /* number of range errors */
#line 3326
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3326
  long cxp = (long) *((char**)xpp);
#line 3326

#line 3326
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3326
  /* sjl: manually stripmine so we can limit amount of
#line 3326
   * vector work space reserved to LOOPCNT elements. Also
#line 3326
   * makes vectorisation easy */
#line 3326
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3326
    ni=Min(nelems-j,LOOPCNT);
#line 3326
    if (realign) {
#line 3326
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3326
      xp = tmp;
#line 3326
    } else {
#line 3326
      xp = (double *) *xpp;
#line 3326
    }
#line 3326
   /* copy the next block */
#line 3326
#pragma cdir loopcnt=LOOPCNT
#line 3326
#pragma cdir shortloop
#line 3326
    for (i=0; i<ni; i++) {
#line 3326
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3326
     /* test for range errors (not always needed but do it anyway) */
#line 3326
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3326
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3326
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3326
    }
#line 3326
   /* update xpp and tp */
#line 3326
    if (realign) xp = (double *) *xpp;
#line 3326
    xp += ni;
#line 3326
    tp += ni;
#line 3326
    *xpp = (void*)xp;
#line 3326
  }
#line 3326
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3326

#line 3326
#else   /* not SX */
#line 3326
	const char *xp = (const char *) *xpp;
#line 3326
	int status = NC_NOERR;
#line 3326

#line 3326
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3326
	{
#line 3326
		const int lstatus = ncx_get_double_uchar(xp, tp);
#line 3326
		if (status == NC_NOERR) /* report the first encountered error */
#line 3326
			status = lstatus;
#line 3326
	}
#line 3326

#line 3326
	*xpp = (const void *)xp;
#line 3326
	return status;
#line 3326
#endif
#line 3326
}
#line 3326

int
#line 3327
ncx_getn_double_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3327
{
#line 3327
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3327

#line 3327
 /* basic algorithm is:
#line 3327
  *   - ensure sane alignment of input data
#line 3327
  *   - copy (conversion happens automatically) input data
#line 3327
  *     to output
#line 3327
  *   - update xpp to point at next unconverted input, and tp to point
#line 3327
  *     at next location for converted output
#line 3327
  */
#line 3327
  long i, j, ni;
#line 3327
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3327
  double *xp;
#line 3327
  int nrange = 0;         /* number of range errors */
#line 3327
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3327
  long cxp = (long) *((char**)xpp);
#line 3327

#line 3327
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3327
  /* sjl: manually stripmine so we can limit amount of
#line 3327
   * vector work space reserved to LOOPCNT elements. Also
#line 3327
   * makes vectorisation easy */
#line 3327
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3327
    ni=Min(nelems-j,LOOPCNT);
#line 3327
    if (realign) {
#line 3327
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3327
      xp = tmp;
#line 3327
    } else {
#line 3327
      xp = (double *) *xpp;
#line 3327
    }
#line 3327
   /* copy the next block */
#line 3327
#pragma cdir loopcnt=LOOPCNT
#line 3327
#pragma cdir shortloop
#line 3327
    for (i=0; i<ni; i++) {
#line 3327
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3327
     /* test for range errors (not always needed but do it anyway) */
#line 3327
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3327
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3327
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3327
    }
#line 3327
   /* update xpp and tp */
#line 3327
    if (realign) xp = (double *) *xpp;
#line 3327
    xp += ni;
#line 3327
    tp += ni;
#line 3327
    *xpp = (void*)xp;
#line 3327
  }
#line 3327
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3327

#line 3327
#else   /* not SX */
#line 3327
	const char *xp = (const char *) *xpp;
#line 3327
	int status = NC_NOERR;
#line 3327

#line 3327
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3327
	{
#line 3327
		const int lstatus = ncx_get_double_ushort(xp, tp);
#line 3327
		if (status == NC_NOERR) /* report the first encountered error */
#line 3327
			status = lstatus;
#line 3327
	}
#line 3327

#line 3327
	*xpp = (const void *)xp;
#line 3327
	return status;
#line 3327
#endif
#line 3327
}
#line 3327

int
#line 3328
ncx_getn_double_uint(const void **xpp, size_t nelems, uint *tp)
#line 3328
{
#line 3328
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3328

#line 3328
 /* basic algorithm is:
#line 3328
  *   - ensure sane alignment of input data
#line 3328
  *   - copy (conversion happens automatically) input data
#line 3328
  *     to output
#line 3328
  *   - update xpp to point at next unconverted input, and tp to point
#line 3328
  *     at next location for converted output
#line 3328
  */
#line 3328
  long i, j, ni;
#line 3328
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3328
  double *xp;
#line 3328
  int nrange = 0;         /* number of range errors */
#line 3328
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3328
  long cxp = (long) *((char**)xpp);
#line 3328

#line 3328
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3328
  /* sjl: manually stripmine so we can limit amount of
#line 3328
   * vector work space reserved to LOOPCNT elements. Also
#line 3328
   * makes vectorisation easy */
#line 3328
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3328
    ni=Min(nelems-j,LOOPCNT);
#line 3328
    if (realign) {
#line 3328
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3328
      xp = tmp;
#line 3328
    } else {
#line 3328
      xp = (double *) *xpp;
#line 3328
    }
#line 3328
   /* copy the next block */
#line 3328
#pragma cdir loopcnt=LOOPCNT
#line 3328
#pragma cdir shortloop
#line 3328
    for (i=0; i<ni; i++) {
#line 3328
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3328
     /* test for range errors (not always needed but do it anyway) */
#line 3328
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3328
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3328
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3328
    }
#line 3328
   /* update xpp and tp */
#line 3328
    if (realign) xp = (double *) *xpp;
#line 3328
    xp += ni;
#line 3328
    tp += ni;
#line 3328
    *xpp = (void*)xp;
#line 3328
  }
#line 3328
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3328

#line 3328
#else   /* not SX */
#line 3328
	const char *xp = (const char *) *xpp;
#line 3328
	int status = NC_NOERR;
#line 3328

#line 3328
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3328
	{
#line 3328
		const int lstatus = ncx_get_double_uint(xp, tp);
#line 3328
		if (status == NC_NOERR) /* report the first encountered error */
#line 3328
			status = lstatus;
#line 3328
	}
#line 3328

#line 3328
	*xpp = (const void *)xp;
#line 3328
	return status;
#line 3328
#endif
#line 3328
}
#line 3328

int
#line 3329
ncx_getn_double_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3329
{
#line 3329
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3329

#line 3329
 /* basic algorithm is:
#line 3329
  *   - ensure sane alignment of input data
#line 3329
  *   - copy (conversion happens automatically) input data
#line 3329
  *     to output
#line 3329
  *   - update xpp to point at next unconverted input, and tp to point
#line 3329
  *     at next location for converted output
#line 3329
  */
#line 3329
  long i, j, ni;
#line 3329
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3329
  double *xp;
#line 3329
  int nrange = 0;         /* number of range errors */
#line 3329
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3329
  long cxp = (long) *((char**)xpp);
#line 3329

#line 3329
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3329
  /* sjl: manually stripmine so we can limit amount of
#line 3329
   * vector work space reserved to LOOPCNT elements. Also
#line 3329
   * makes vectorisation easy */
#line 3329
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3329
    ni=Min(nelems-j,LOOPCNT);
#line 3329
    if (realign) {
#line 3329
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3329
      xp = tmp;
#line 3329
    } else {
#line 3329
      xp = (double *) *xpp;
#line 3329
    }
#line 3329
   /* copy the next block */
#line 3329
#pragma cdir loopcnt=LOOPCNT
#line 3329
#pragma cdir shortloop
#line 3329
    for (i=0; i<ni; i++) {
#line 3329
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3329
     /* test for range errors (not always needed but do it anyway) */
#line 3329
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3329
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3329
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3329
    }
#line 3329
   /* update xpp and tp */
#line 3329
    if (realign) xp = (double *) *xpp;
#line 3329
    xp += ni;
#line 3329
    tp += ni;
#line 3329
    *xpp = (void*)xp;
#line 3329
  }
#line 3329
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3329

#line 3329
#else   /* not SX */
#line 3329
	const char *xp = (const char *) *xpp;
#line 3329
	int status = NC_NOERR;
#line 3329

#line 3329
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3329
	{
#line 3329
		const int lstatus = ncx_get_double_ulonglong(xp, tp);
#line 3329
		if (status == NC_NOERR) /* report the first encountered error */
#line 3329
			status = lstatus;
#line 3329
	}
#line 3329

#line 3329
	*xpp = (const void *)xp;
#line 3329
	return status;
#line 3329
#endif
#line 3329
}
#line 3329


#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_DOUBLE);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_putn_double_double(void **xpp, size_t ndoubles, const double *ip, void *fillp)
{
	const double *const end = ip + ndoubles;

	while (ip < end)
	{
	const struct vax_double *const vdp =
#line 3352
			(const struct vax_double *)ip;
#line 3352
	struct ieee_double *const idp =
#line 3352
			 (struct ieee_double *) (*xpp);
#line 3352

#line 3352
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 3352
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 3352
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 3352
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 3352
		(vdp->exp == dbl_limits[0].d.exp))
#line 3352
	{
#line 3352
		*idp = dbl_limits[0].ieee;
#line 3352
		goto shipit;
#line 3352
	}
#line 3352
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 3352
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 3352
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 3352
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 3352
		(vdp->exp == dbl_limits[1].d.exp))
#line 3352
	{
#line 3352
		*idp = dbl_limits[1].ieee;
#line 3352
		goto shipit;
#line 3352
	}
#line 3352

#line 3352
	{
#line 3352
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 3352

#line 3352
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 3352
			(vdp->mantissa3 << 13) |
#line 3352
			((vdp->mantissa4 >> 3) & MASK(13));
#line 3352

#line 3352
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 3352
				 | (vdp->mantissa2 >> 3);
#line 3352

#line 3352
		if ((vdp->mantissa4 & 7) > 4)
#line 3352
		{
#line 3352
			/* round up */
#line 3352
			mant_lo++;
#line 3352
			if (mant_lo == 0)
#line 3352
			{
#line 3352
				mant_hi++;
#line 3352
				if (mant_hi > 0xffffff)
#line 3352
				{
#line 3352
					mant_hi = 0;
#line 3352
					exp++;
#line 3352
				}
#line 3352
			}
#line 3352
		}
#line 3352

#line 3352
		idp->mant_lo = SWAP4(mant_lo);
#line 3352
		idp->mant_6 = mant_hi >> 16;
#line 3352
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 3352
		idp->mant_4 = mant_hi;
#line 3352
		idp->exp_hi = exp >> 4;
#line 3352
		idp->exp_lo = exp;
#line 3352
	}
#line 3352

#line 3352
	shipit:
#line 3352
		idp->sign = vdp->sign;
#line 3352

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3377
ncx_putn_double_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3377
{
#line 3377
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3377

#line 3377
 /* basic algorithm is:
#line 3377
  *   - ensure sane alignment of output data
#line 3377
  *   - copy (conversion happens automatically) input data
#line 3377
  *     to output
#line 3377
  *   - update tp to point at next unconverted input, and xpp to point
#line 3377
  *     at next location for converted output
#line 3377
  */
#line 3377
  long i, j, ni;
#line 3377
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3377
  double *xp;
#line 3377
  int nrange = 0;         /* number of range errors */
#line 3377
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3377
  long cxp = (long) *((char**)xpp);
#line 3377

#line 3377
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3377
  /* sjl: manually stripmine so we can limit amount of
#line 3377
   * vector work space reserved to LOOPCNT elements. Also
#line 3377
   * makes vectorisation easy */
#line 3377
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3377
    ni=Min(nelems-j,LOOPCNT);
#line 3377
    if (realign) {
#line 3377
      xp = tmp;
#line 3377
    } else {
#line 3377
      xp = (double *) *xpp;
#line 3377
    }
#line 3377
   /* copy the next block */
#line 3377
#pragma cdir loopcnt=LOOPCNT
#line 3377
#pragma cdir shortloop
#line 3377
    for (i=0; i<ni; i++) {
#line 3377
      /* the normal case: */
#line 3377
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3377
     /* test for range errors (not always needed but do it anyway) */
#line 3377
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3377
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3377
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3377
    }
#line 3377
   /* copy workspace back if necessary */
#line 3377
    if (realign) {
#line 3377
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3377
      xp = (double *) *xpp;
#line 3377
    }
#line 3377
   /* update xpp and tp */
#line 3377
    xp += ni;
#line 3377
    tp += ni;
#line 3377
    *xpp = (void*)xp;
#line 3377
  }
#line 3377
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3377

#line 3377
#else   /* not SX */
#line 3377

#line 3377
	char *xp = (char *) *xpp;
#line 3377
	int status = NC_NOERR;
#line 3377

#line 3377
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3377
	{
#line 3377
		int lstatus = ncx_put_double_schar(xp, tp, fillp);
#line 3377
		if (status == NC_NOERR) /* report the first encountered error */
#line 3377
			status = lstatus;
#line 3377
	}
#line 3377

#line 3377
	*xpp = (void *)xp;
#line 3377
	return status;
#line 3377
#endif
#line 3377
}
#line 3377

int
#line 3378
ncx_putn_double_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3378
{
#line 3378
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3378

#line 3378
 /* basic algorithm is:
#line 3378
  *   - ensure sane alignment of output data
#line 3378
  *   - copy (conversion happens automatically) input data
#line 3378
  *     to output
#line 3378
  *   - update tp to point at next unconverted input, and xpp to point
#line 3378
  *     at next location for converted output
#line 3378
  */
#line 3378
  long i, j, ni;
#line 3378
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3378
  double *xp;
#line 3378
  int nrange = 0;         /* number of range errors */
#line 3378
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3378
  long cxp = (long) *((char**)xpp);
#line 3378

#line 3378
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3378
  /* sjl: manually stripmine so we can limit amount of
#line 3378
   * vector work space reserved to LOOPCNT elements. Also
#line 3378
   * makes vectorisation easy */
#line 3378
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3378
    ni=Min(nelems-j,LOOPCNT);
#line 3378
    if (realign) {
#line 3378
      xp = tmp;
#line 3378
    } else {
#line 3378
      xp = (double *) *xpp;
#line 3378
    }
#line 3378
   /* copy the next block */
#line 3378
#pragma cdir loopcnt=LOOPCNT
#line 3378
#pragma cdir shortloop
#line 3378
    for (i=0; i<ni; i++) {
#line 3378
      /* the normal case: */
#line 3378
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3378
     /* test for range errors (not always needed but do it anyway) */
#line 3378
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3378
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3378
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3378
    }
#line 3378
   /* copy workspace back if necessary */
#line 3378
    if (realign) {
#line 3378
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3378
      xp = (double *) *xpp;
#line 3378
    }
#line 3378
   /* update xpp and tp */
#line 3378
    xp += ni;
#line 3378
    tp += ni;
#line 3378
    *xpp = (void*)xp;
#line 3378
  }
#line 3378
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3378

#line 3378
#else   /* not SX */
#line 3378

#line 3378
	char *xp = (char *) *xpp;
#line 3378
	int status = NC_NOERR;
#line 3378

#line 3378
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3378
	{
#line 3378
		int lstatus = ncx_put_double_short(xp, tp, fillp);
#line 3378
		if (status == NC_NOERR) /* report the first encountered error */
#line 3378
			status = lstatus;
#line 3378
	}
#line 3378

#line 3378
	*xpp = (void *)xp;
#line 3378
	return status;
#line 3378
#endif
#line 3378
}
#line 3378

int
#line 3379
ncx_putn_double_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3379
{
#line 3379
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3379

#line 3379
 /* basic algorithm is:
#line 3379
  *   - ensure sane alignment of output data
#line 3379
  *   - copy (conversion happens automatically) input data
#line 3379
  *     to output
#line 3379
  *   - update tp to point at next unconverted input, and xpp to point
#line 3379
  *     at next location for converted output
#line 3379
  */
#line 3379
  long i, j, ni;
#line 3379
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3379
  double *xp;
#line 3379
  int nrange = 0;         /* number of range errors */
#line 3379
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3379
  long cxp = (long) *((char**)xpp);
#line 3379

#line 3379
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3379
  /* sjl: manually stripmine so we can limit amount of
#line 3379
   * vector work space reserved to LOOPCNT elements. Also
#line 3379
   * makes vectorisation easy */
#line 3379
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3379
    ni=Min(nelems-j,LOOPCNT);
#line 3379
    if (realign) {
#line 3379
      xp = tmp;
#line 3379
    } else {
#line 3379
      xp = (double *) *xpp;
#line 3379
    }
#line 3379
   /* copy the next block */
#line 3379
#pragma cdir loopcnt=LOOPCNT
#line 3379
#pragma cdir shortloop
#line 3379
    for (i=0; i<ni; i++) {
#line 3379
      /* the normal case: */
#line 3379
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3379
     /* test for range errors (not always needed but do it anyway) */
#line 3379
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3379
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3379
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3379
    }
#line 3379
   /* copy workspace back if necessary */
#line 3379
    if (realign) {
#line 3379
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3379
      xp = (double *) *xpp;
#line 3379
    }
#line 3379
   /* update xpp and tp */
#line 3379
    xp += ni;
#line 3379
    tp += ni;
#line 3379
    *xpp = (void*)xp;
#line 3379
  }
#line 3379
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3379

#line 3379
#else   /* not SX */
#line 3379

#line 3379
	char *xp = (char *) *xpp;
#line 3379
	int status = NC_NOERR;
#line 3379

#line 3379
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3379
	{
#line 3379
		int lstatus = ncx_put_double_int(xp, tp, fillp);
#line 3379
		if (status == NC_NOERR) /* report the first encountered error */
#line 3379
			status = lstatus;
#line 3379
	}
#line 3379

#line 3379
	*xpp = (void *)xp;
#line 3379
	return status;
#line 3379
#endif
#line 3379
}
#line 3379

int
#line 3380
ncx_putn_double_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3380
{
#line 3380
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3380

#line 3380
 /* basic algorithm is:
#line 3380
  *   - ensure sane alignment of output data
#line 3380
  *   - copy (conversion happens automatically) input data
#line 3380
  *     to output
#line 3380
  *   - update tp to point at next unconverted input, and xpp to point
#line 3380
  *     at next location for converted output
#line 3380
  */
#line 3380
  long i, j, ni;
#line 3380
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3380
  double *xp;
#line 3380
  int nrange = 0;         /* number of range errors */
#line 3380
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3380
  long cxp = (long) *((char**)xpp);
#line 3380

#line 3380
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3380
  /* sjl: manually stripmine so we can limit amount of
#line 3380
   * vector work space reserved to LOOPCNT elements. Also
#line 3380
   * makes vectorisation easy */
#line 3380
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3380
    ni=Min(nelems-j,LOOPCNT);
#line 3380
    if (realign) {
#line 3380
      xp = tmp;
#line 3380
    } else {
#line 3380
      xp = (double *) *xpp;
#line 3380
    }
#line 3380
   /* copy the next block */
#line 3380
#pragma cdir loopcnt=LOOPCNT
#line 3380
#pragma cdir shortloop
#line 3380
    for (i=0; i<ni; i++) {
#line 3380
      /* the normal case: */
#line 3380
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3380
     /* test for range errors (not always needed but do it anyway) */
#line 3380
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3380
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3380
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3380
    }
#line 3380
   /* copy workspace back if necessary */
#line 3380
    if (realign) {
#line 3380
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3380
      xp = (double *) *xpp;
#line 3380
    }
#line 3380
   /* update xpp and tp */
#line 3380
    xp += ni;
#line 3380
    tp += ni;
#line 3380
    *xpp = (void*)xp;
#line 3380
  }
#line 3380
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3380

#line 3380
#else   /* not SX */
#line 3380

#line 3380
	char *xp = (char *) *xpp;
#line 3380
	int status = NC_NOERR;
#line 3380

#line 3380
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3380
	{
#line 3380
		int lstatus = ncx_put_double_long(xp, tp, fillp);
#line 3380
		if (status == NC_NOERR) /* report the first encountered error */
#line 3380
			status = lstatus;
#line 3380
	}
#line 3380

#line 3380
	*xpp = (void *)xp;
#line 3380
	return status;
#line 3380
#endif
#line 3380
}
#line 3380

int
#line 3381
ncx_putn_double_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3381
{
#line 3381
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3381

#line 3381
 /* basic algorithm is:
#line 3381
  *   - ensure sane alignment of output data
#line 3381
  *   - copy (conversion happens automatically) input data
#line 3381
  *     to output
#line 3381
  *   - update tp to point at next unconverted input, and xpp to point
#line 3381
  *     at next location for converted output
#line 3381
  */
#line 3381
  long i, j, ni;
#line 3381
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3381
  double *xp;
#line 3381
  int nrange = 0;         /* number of range errors */
#line 3381
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3381
  long cxp = (long) *((char**)xpp);
#line 3381

#line 3381
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3381
  /* sjl: manually stripmine so we can limit amount of
#line 3381
   * vector work space reserved to LOOPCNT elements. Also
#line 3381
   * makes vectorisation easy */
#line 3381
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3381
    ni=Min(nelems-j,LOOPCNT);
#line 3381
    if (realign) {
#line 3381
      xp = tmp;
#line 3381
    } else {
#line 3381
      xp = (double *) *xpp;
#line 3381
    }
#line 3381
   /* copy the next block */
#line 3381
#pragma cdir loopcnt=LOOPCNT
#line 3381
#pragma cdir shortloop
#line 3381
    for (i=0; i<ni; i++) {
#line 3381
      /* the normal case: */
#line 3381
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3381
     /* test for range errors (not always needed but do it anyway) */
#line 3381
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3381
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3381
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3381
    }
#line 3381
   /* copy workspace back if necessary */
#line 3381
    if (realign) {
#line 3381
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3381
      xp = (double *) *xpp;
#line 3381
    }
#line 3381
   /* update xpp and tp */
#line 3381
    xp += ni;
#line 3381
    tp += ni;
#line 3381
    *xpp = (void*)xp;
#line 3381
  }
#line 3381
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3381

#line 3381
#else   /* not SX */
#line 3381

#line 3381
	char *xp = (char *) *xpp;
#line 3381
	int status = NC_NOERR;
#line 3381

#line 3381
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3381
	{
#line 3381
		int lstatus = ncx_put_double_float(xp, tp, fillp);
#line 3381
		if (status == NC_NOERR) /* report the first encountered error */
#line 3381
			status = lstatus;
#line 3381
	}
#line 3381

#line 3381
	*xpp = (void *)xp;
#line 3381
	return status;
#line 3381
#endif
#line 3381
}
#line 3381

int
#line 3382
ncx_putn_double_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3382
{
#line 3382
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3382

#line 3382
 /* basic algorithm is:
#line 3382
  *   - ensure sane alignment of output data
#line 3382
  *   - copy (conversion happens automatically) input data
#line 3382
  *     to output
#line 3382
  *   - update tp to point at next unconverted input, and xpp to point
#line 3382
  *     at next location for converted output
#line 3382
  */
#line 3382
  long i, j, ni;
#line 3382
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3382
  double *xp;
#line 3382
  int nrange = 0;         /* number of range errors */
#line 3382
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3382
  long cxp = (long) *((char**)xpp);
#line 3382

#line 3382
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3382
  /* sjl: manually stripmine so we can limit amount of
#line 3382
   * vector work space reserved to LOOPCNT elements. Also
#line 3382
   * makes vectorisation easy */
#line 3382
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3382
    ni=Min(nelems-j,LOOPCNT);
#line 3382
    if (realign) {
#line 3382
      xp = tmp;
#line 3382
    } else {
#line 3382
      xp = (double *) *xpp;
#line 3382
    }
#line 3382
   /* copy the next block */
#line 3382
#pragma cdir loopcnt=LOOPCNT
#line 3382
#pragma cdir shortloop
#line 3382
    for (i=0; i<ni; i++) {
#line 3382
      /* the normal case: */
#line 3382
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3382
     /* test for range errors (not always needed but do it anyway) */
#line 3382
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3382
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3382
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3382
    }
#line 3382
   /* copy workspace back if necessary */
#line 3382
    if (realign) {
#line 3382
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3382
      xp = (double *) *xpp;
#line 3382
    }
#line 3382
   /* update xpp and tp */
#line 3382
    xp += ni;
#line 3382
    tp += ni;
#line 3382
    *xpp = (void*)xp;
#line 3382
  }
#line 3382
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3382

#line 3382
#else   /* not SX */
#line 3382

#line 3382
	char *xp = (char *) *xpp;
#line 3382
	int status = NC_NOERR;
#line 3382

#line 3382
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3382
	{
#line 3382
		int lstatus = ncx_put_double_longlong(xp, tp, fillp);
#line 3382
		if (status == NC_NOERR) /* report the first encountered error */
#line 3382
			status = lstatus;
#line 3382
	}
#line 3382

#line 3382
	*xpp = (void *)xp;
#line 3382
	return status;
#line 3382
#endif
#line 3382
}
#line 3382

int
#line 3383
ncx_putn_double_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3383
{
#line 3383
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3383

#line 3383
 /* basic algorithm is:
#line 3383
  *   - ensure sane alignment of output data
#line 3383
  *   - copy (conversion happens automatically) input data
#line 3383
  *     to output
#line 3383
  *   - update tp to point at next unconverted input, and xpp to point
#line 3383
  *     at next location for converted output
#line 3383
  */
#line 3383
  long i, j, ni;
#line 3383
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3383
  double *xp;
#line 3383
  int nrange = 0;         /* number of range errors */
#line 3383
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3383
  long cxp = (long) *((char**)xpp);
#line 3383

#line 3383
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3383
  /* sjl: manually stripmine so we can limit amount of
#line 3383
   * vector work space reserved to LOOPCNT elements. Also
#line 3383
   * makes vectorisation easy */
#line 3383
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3383
    ni=Min(nelems-j,LOOPCNT);
#line 3383
    if (realign) {
#line 3383
      xp = tmp;
#line 3383
    } else {
#line 3383
      xp = (double *) *xpp;
#line 3383
    }
#line 3383
   /* copy the next block */
#line 3383
#pragma cdir loopcnt=LOOPCNT
#line 3383
#pragma cdir shortloop
#line 3383
    for (i=0; i<ni; i++) {
#line 3383
      /* the normal case: */
#line 3383
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3383
     /* test for range errors (not always needed but do it anyway) */
#line 3383
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3383
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3383
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3383
    }
#line 3383
   /* copy workspace back if necessary */
#line 3383
    if (realign) {
#line 3383
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3383
      xp = (double *) *xpp;
#line 3383
    }
#line 3383
   /* update xpp and tp */
#line 3383
    xp += ni;
#line 3383
    tp += ni;
#line 3383
    *xpp = (void*)xp;
#line 3383
  }
#line 3383
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3383

#line 3383
#else   /* not SX */
#line 3383

#line 3383
	char *xp = (char *) *xpp;
#line 3383
	int status = NC_NOERR;
#line 3383

#line 3383
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3383
	{
#line 3383
		int lstatus = ncx_put_double_uchar(xp, tp, fillp);
#line 3383
		if (status == NC_NOERR) /* report the first encountered error */
#line 3383
			status = lstatus;
#line 3383
	}
#line 3383

#line 3383
	*xpp = (void *)xp;
#line 3383
	return status;
#line 3383
#endif
#line 3383
}
#line 3383

int
#line 3384
ncx_putn_double_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3384
{
#line 3384
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3384

#line 3384
 /* basic algorithm is:
#line 3384
  *   - ensure sane alignment of output data
#line 3384
  *   - copy (conversion happens automatically) input data
#line 3384
  *     to output
#line 3384
  *   - update tp to point at next unconverted input, and xpp to point
#line 3384
  *     at next location for converted output
#line 3384
  */
#line 3384
  long i, j, ni;
#line 3384
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3384
  double *xp;
#line 3384
  int nrange = 0;         /* number of range errors */
#line 3384
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3384
  long cxp = (long) *((char**)xpp);
#line 3384

#line 3384
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3384
  /* sjl: manually stripmine so we can limit amount of
#line 3384
   * vector work space reserved to LOOPCNT elements. Also
#line 3384
   * makes vectorisation easy */
#line 3384
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3384
    ni=Min(nelems-j,LOOPCNT);
#line 3384
    if (realign) {
#line 3384
      xp = tmp;
#line 3384
    } else {
#line 3384
      xp = (double *) *xpp;
#line 3384
    }
#line 3384
   /* copy the next block */
#line 3384
#pragma cdir loopcnt=LOOPCNT
#line 3384
#pragma cdir shortloop
#line 3384
    for (i=0; i<ni; i++) {
#line 3384
      /* the normal case: */
#line 3384
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3384
     /* test for range errors (not always needed but do it anyway) */
#line 3384
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3384
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3384
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3384
    }
#line 3384
   /* copy workspace back if necessary */
#line 3384
    if (realign) {
#line 3384
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3384
      xp = (double *) *xpp;
#line 3384
    }
#line 3384
   /* update xpp and tp */
#line 3384
    xp += ni;
#line 3384
    tp += ni;
#line 3384
    *xpp = (void*)xp;
#line 3384
  }
#line 3384
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3384

#line 3384
#else   /* not SX */
#line 3384

#line 3384
	char *xp = (char *) *xpp;
#line 3384
	int status = NC_NOERR;
#line 3384

#line 3384
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3384
	{
#line 3384
		int lstatus = ncx_put_double_ushort(xp, tp, fillp);
#line 3384
		if (status == NC_NOERR) /* report the first encountered error */
#line 3384
			status = lstatus;
#line 3384
	}
#line 3384

#line 3384
	*xpp = (void *)xp;
#line 3384
	return status;
#line 3384
#endif
#line 3384
}
#line 3384

int
#line 3385
ncx_putn_double_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3385
{
#line 3385
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3385

#line 3385
 /* basic algorithm is:
#line 3385
  *   - ensure sane alignment of output data
#line 3385
  *   - copy (conversion happens automatically) input data
#line 3385
  *     to output
#line 3385
  *   - update tp to point at next unconverted input, and xpp to point
#line 3385
  *     at next location for converted output
#line 3385
  */
#line 3385
  long i, j, ni;
#line 3385
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3385
  double *xp;
#line 3385
  int nrange = 0;         /* number of range errors */
#line 3385
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3385
  long cxp = (long) *((char**)xpp);
#line 3385

#line 3385
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3385
  /* sjl: manually stripmine so we can limit amount of
#line 3385
   * vector work space reserved to LOOPCNT elements. Also
#line 3385
   * makes vectorisation easy */
#line 3385
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3385
    ni=Min(nelems-j,LOOPCNT);
#line 3385
    if (realign) {
#line 3385
      xp = tmp;
#line 3385
    } else {
#line 3385
      xp = (double *) *xpp;
#line 3385
    }
#line 3385
   /* copy the next block */
#line 3385
#pragma cdir loopcnt=LOOPCNT
#line 3385
#pragma cdir shortloop
#line 3385
    for (i=0; i<ni; i++) {
#line 3385
      /* the normal case: */
#line 3385
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3385
     /* test for range errors (not always needed but do it anyway) */
#line 3385
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3385
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3385
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3385
    }
#line 3385
   /* copy workspace back if necessary */
#line 3385
    if (realign) {
#line 3385
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3385
      xp = (double *) *xpp;
#line 3385
    }
#line 3385
   /* update xpp and tp */
#line 3385
    xp += ni;
#line 3385
    tp += ni;
#line 3385
    *xpp = (void*)xp;
#line 3385
  }
#line 3385
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3385

#line 3385
#else   /* not SX */
#line 3385

#line 3385
	char *xp = (char *) *xpp;
#line 3385
	int status = NC_NOERR;
#line 3385

#line 3385
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3385
	{
#line 3385
		int lstatus = ncx_put_double_uint(xp, tp, fillp);
#line 3385
		if (status == NC_NOERR) /* report the first encountered error */
#line 3385
			status = lstatus;
#line 3385
	}
#line 3385

#line 3385
	*xpp = (void *)xp;
#line 3385
	return status;
#line 3385
#endif
#line 3385
}
#line 3385

int
#line 3386
ncx_putn_double_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3386
{
#line 3386
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3386

#line 3386
 /* basic algorithm is:
#line 3386
  *   - ensure sane alignment of output data
#line 3386
  *   - copy (conversion happens automatically) input data
#line 3386
  *     to output
#line 3386
  *   - update tp to point at next unconverted input, and xpp to point
#line 3386
  *     at next location for converted output
#line 3386
  */
#line 3386
  long i, j, ni;
#line 3386
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3386
  double *xp;
#line 3386
  int nrange = 0;         /* number of range errors */
#line 3386
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3386
  long cxp = (long) *((char**)xpp);
#line 3386

#line 3386
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3386
  /* sjl: manually stripmine so we can limit amount of
#line 3386
   * vector work space reserved to LOOPCNT elements. Also
#line 3386
   * makes vectorisation easy */
#line 3386
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3386
    ni=Min(nelems-j,LOOPCNT);
#line 3386
    if (realign) {
#line 3386
      xp = tmp;
#line 3386
    } else {
#line 3386
      xp = (double *) *xpp;
#line 3386
    }
#line 3386
   /* copy the next block */
#line 3386
#pragma cdir loopcnt=LOOPCNT
#line 3386
#pragma cdir shortloop
#line 3386
    for (i=0; i<ni; i++) {
#line 3386
      /* the normal case: */
#line 3386
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3386
     /* test for range errors (not always needed but do it anyway) */
#line 3386
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3386
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3386
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3386
    }
#line 3386
   /* copy workspace back if necessary */
#line 3386
    if (realign) {
#line 3386
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3386
      xp = (double *) *xpp;
#line 3386
    }
#line 3386
   /* update xpp and tp */
#line 3386
    xp += ni;
#line 3386
    tp += ni;
#line 3386
    *xpp = (void*)xp;
#line 3386
  }
#line 3386
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3386

#line 3386
#else   /* not SX */
#line 3386

#line 3386
	char *xp = (char *) *xpp;
#line 3386
	int status = NC_NOERR;
#line 3386

#line 3386
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3386
	{
#line 3386
		int lstatus = ncx_put_double_ulonglong(xp, tp, fillp);
#line 3386
		if (status == NC_NOERR) /* report the first encountered error */
#line 3386
			status = lstatus;
#line 3386
	}
#line 3386

#line 3386
	*xpp = (void *)xp;
#line 3386
	return status;
#line 3386
#endif
#line 3386
}
#line 3386



/* longlong ------------------------------------------------------------------*/

#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3405
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3405
{
#line 3405
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3405

#line 3405
 /* basic algorithm is:
#line 3405
  *   - ensure sane alignment of input data
#line 3405
  *   - copy (conversion happens automatically) input data
#line 3405
  *     to output
#line 3405
  *   - update xpp to point at next unconverted input, and tp to point
#line 3405
  *     at next location for converted output
#line 3405
  */
#line 3405
  long i, j, ni;
#line 3405
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3405
  int64 *xp;
#line 3405
  int nrange = 0;         /* number of range errors */
#line 3405
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3405
  long cxp = (long) *((char**)xpp);
#line 3405

#line 3405
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3405
  /* sjl: manually stripmine so we can limit amount of
#line 3405
   * vector work space reserved to LOOPCNT elements. Also
#line 3405
   * makes vectorisation easy */
#line 3405
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3405
    ni=Min(nelems-j,LOOPCNT);
#line 3405
    if (realign) {
#line 3405
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3405
      xp = tmp;
#line 3405
    } else {
#line 3405
      xp = (int64 *) *xpp;
#line 3405
    }
#line 3405
   /* copy the next block */
#line 3405
#pragma cdir loopcnt=LOOPCNT
#line 3405
#pragma cdir shortloop
#line 3405
    for (i=0; i<ni; i++) {
#line 3405
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3405
     /* test for range errors (not always needed but do it anyway) */
#line 3405
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3405
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3405
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3405
    }
#line 3405
   /* update xpp and tp */
#line 3405
    if (realign) xp = (int64 *) *xpp;
#line 3405
    xp += ni;
#line 3405
    tp += ni;
#line 3405
    *xpp = (void*)xp;
#line 3405
  }
#line 3405
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3405

#line 3405
#else   /* not SX */
#line 3405
	const char *xp = (const char *) *xpp;
#line 3405
	int status = NC_NOERR;
#line 3405

#line 3405
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3405
	{
#line 3405
		const int lstatus = ncx_get_longlong_longlong(xp, tp);
#line 3405
		if (status == NC_NOERR) /* report the first encountered error */
#line 3405
			status = lstatus;
#line 3405
	}
#line 3405

#line 3405
	*xpp = (const void *)xp;
#line 3405
	return status;
#line 3405
#endif
#line 3405
}
#line 3405

#endif
int
#line 3407
ncx_getn_longlong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3407
{
#line 3407
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3407

#line 3407
 /* basic algorithm is:
#line 3407
  *   - ensure sane alignment of input data
#line 3407
  *   - copy (conversion happens automatically) input data
#line 3407
  *     to output
#line 3407
  *   - update xpp to point at next unconverted input, and tp to point
#line 3407
  *     at next location for converted output
#line 3407
  */
#line 3407
  long i, j, ni;
#line 3407
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3407
  int64 *xp;
#line 3407
  int nrange = 0;         /* number of range errors */
#line 3407
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3407
  long cxp = (long) *((char**)xpp);
#line 3407

#line 3407
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3407
  /* sjl: manually stripmine so we can limit amount of
#line 3407
   * vector work space reserved to LOOPCNT elements. Also
#line 3407
   * makes vectorisation easy */
#line 3407
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3407
    ni=Min(nelems-j,LOOPCNT);
#line 3407
    if (realign) {
#line 3407
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3407
      xp = tmp;
#line 3407
    } else {
#line 3407
      xp = (int64 *) *xpp;
#line 3407
    }
#line 3407
   /* copy the next block */
#line 3407
#pragma cdir loopcnt=LOOPCNT
#line 3407
#pragma cdir shortloop
#line 3407
    for (i=0; i<ni; i++) {
#line 3407
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3407
     /* test for range errors (not always needed but do it anyway) */
#line 3407
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3407
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3407
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3407
    }
#line 3407
   /* update xpp and tp */
#line 3407
    if (realign) xp = (int64 *) *xpp;
#line 3407
    xp += ni;
#line 3407
    tp += ni;
#line 3407
    *xpp = (void*)xp;
#line 3407
  }
#line 3407
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3407

#line 3407
#else   /* not SX */
#line 3407
	const char *xp = (const char *) *xpp;
#line 3407
	int status = NC_NOERR;
#line 3407

#line 3407
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3407
	{
#line 3407
		const int lstatus = ncx_get_longlong_schar(xp, tp);
#line 3407
		if (status == NC_NOERR) /* report the first encountered error */
#line 3407
			status = lstatus;
#line 3407
	}
#line 3407

#line 3407
	*xpp = (const void *)xp;
#line 3407
	return status;
#line 3407
#endif
#line 3407
}
#line 3407

int
#line 3408
ncx_getn_longlong_short(const void **xpp, size_t nelems, short *tp)
#line 3408
{
#line 3408
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3408

#line 3408
 /* basic algorithm is:
#line 3408
  *   - ensure sane alignment of input data
#line 3408
  *   - copy (conversion happens automatically) input data
#line 3408
  *     to output
#line 3408
  *   - update xpp to point at next unconverted input, and tp to point
#line 3408
  *     at next location for converted output
#line 3408
  */
#line 3408
  long i, j, ni;
#line 3408
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3408
  int64 *xp;
#line 3408
  int nrange = 0;         /* number of range errors */
#line 3408
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3408
  long cxp = (long) *((char**)xpp);
#line 3408

#line 3408
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3408
  /* sjl: manually stripmine so we can limit amount of
#line 3408
   * vector work space reserved to LOOPCNT elements. Also
#line 3408
   * makes vectorisation easy */
#line 3408
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3408
    ni=Min(nelems-j,LOOPCNT);
#line 3408
    if (realign) {
#line 3408
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3408
      xp = tmp;
#line 3408
    } else {
#line 3408
      xp = (int64 *) *xpp;
#line 3408
    }
#line 3408
   /* copy the next block */
#line 3408
#pragma cdir loopcnt=LOOPCNT
#line 3408
#pragma cdir shortloop
#line 3408
    for (i=0; i<ni; i++) {
#line 3408
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3408
     /* test for range errors (not always needed but do it anyway) */
#line 3408
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3408
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3408
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3408
    }
#line 3408
   /* update xpp and tp */
#line 3408
    if (realign) xp = (int64 *) *xpp;
#line 3408
    xp += ni;
#line 3408
    tp += ni;
#line 3408
    *xpp = (void*)xp;
#line 3408
  }
#line 3408
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3408

#line 3408
#else   /* not SX */
#line 3408
	const char *xp = (const char *) *xpp;
#line 3408
	int status = NC_NOERR;
#line 3408

#line 3408
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3408
	{
#line 3408
		const int lstatus = ncx_get_longlong_short(xp, tp);
#line 3408
		if (status == NC_NOERR) /* report the first encountered error */
#line 3408
			status = lstatus;
#line 3408
	}
#line 3408

#line 3408
	*xpp = (const void *)xp;
#line 3408
	return status;
#line 3408
#endif
#line 3408
}
#line 3408

int
#line 3409
ncx_getn_longlong_int(const void **xpp, size_t nelems, int *tp)
#line 3409
{
#line 3409
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3409

#line 3409
 /* basic algorithm is:
#line 3409
  *   - ensure sane alignment of input data
#line 3409
  *   - copy (conversion happens automatically) input data
#line 3409
  *     to output
#line 3409
  *   - update xpp to point at next unconverted input, and tp to point
#line 3409
  *     at next location for converted output
#line 3409
  */
#line 3409
  long i, j, ni;
#line 3409
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3409
  int64 *xp;
#line 3409
  int nrange = 0;         /* number of range errors */
#line 3409
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3409
  long cxp = (long) *((char**)xpp);
#line 3409

#line 3409
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3409
  /* sjl: manually stripmine so we can limit amount of
#line 3409
   * vector work space reserved to LOOPCNT elements. Also
#line 3409
   * makes vectorisation easy */
#line 3409
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3409
    ni=Min(nelems-j,LOOPCNT);
#line 3409
    if (realign) {
#line 3409
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3409
      xp = tmp;
#line 3409
    } else {
#line 3409
      xp = (int64 *) *xpp;
#line 3409
    }
#line 3409
   /* copy the next block */
#line 3409
#pragma cdir loopcnt=LOOPCNT
#line 3409
#pragma cdir shortloop
#line 3409
    for (i=0; i<ni; i++) {
#line 3409
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3409
     /* test for range errors (not always needed but do it anyway) */
#line 3409
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3409
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3409
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3409
    }
#line 3409
   /* update xpp and tp */
#line 3409
    if (realign) xp = (int64 *) *xpp;
#line 3409
    xp += ni;
#line 3409
    tp += ni;
#line 3409
    *xpp = (void*)xp;
#line 3409
  }
#line 3409
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3409

#line 3409
#else   /* not SX */
#line 3409
	const char *xp = (const char *) *xpp;
#line 3409
	int status = NC_NOERR;
#line 3409

#line 3409
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3409
	{
#line 3409
		const int lstatus = ncx_get_longlong_int(xp, tp);
#line 3409
		if (status == NC_NOERR) /* report the first encountered error */
#line 3409
			status = lstatus;
#line 3409
	}
#line 3409

#line 3409
	*xpp = (const void *)xp;
#line 3409
	return status;
#line 3409
#endif
#line 3409
}
#line 3409

int
#line 3410
ncx_getn_longlong_long(const void **xpp, size_t nelems, long *tp)
#line 3410
{
#line 3410
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3410

#line 3410
 /* basic algorithm is:
#line 3410
  *   - ensure sane alignment of input data
#line 3410
  *   - copy (conversion happens automatically) input data
#line 3410
  *     to output
#line 3410
  *   - update xpp to point at next unconverted input, and tp to point
#line 3410
  *     at next location for converted output
#line 3410
  */
#line 3410
  long i, j, ni;
#line 3410
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3410
  int64 *xp;
#line 3410
  int nrange = 0;         /* number of range errors */
#line 3410
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3410
  long cxp = (long) *((char**)xpp);
#line 3410

#line 3410
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3410
  /* sjl: manually stripmine so we can limit amount of
#line 3410
   * vector work space reserved to LOOPCNT elements. Also
#line 3410
   * makes vectorisation easy */
#line 3410
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3410
    ni=Min(nelems-j,LOOPCNT);
#line 3410
    if (realign) {
#line 3410
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3410
      xp = tmp;
#line 3410
    } else {
#line 3410
      xp = (int64 *) *xpp;
#line 3410
    }
#line 3410
   /* copy the next block */
#line 3410
#pragma cdir loopcnt=LOOPCNT
#line 3410
#pragma cdir shortloop
#line 3410
    for (i=0; i<ni; i++) {
#line 3410
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3410
     /* test for range errors (not always needed but do it anyway) */
#line 3410
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3410
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3410
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3410
    }
#line 3410
   /* update xpp and tp */
#line 3410
    if (realign) xp = (int64 *) *xpp;
#line 3410
    xp += ni;
#line 3410
    tp += ni;
#line 3410
    *xpp = (void*)xp;
#line 3410
  }
#line 3410
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3410

#line 3410
#else   /* not SX */
#line 3410
	const char *xp = (const char *) *xpp;
#line 3410
	int status = NC_NOERR;
#line 3410

#line 3410
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3410
	{
#line 3410
		const int lstatus = ncx_get_longlong_long(xp, tp);
#line 3410
		if (status == NC_NOERR) /* report the first encountered error */
#line 3410
			status = lstatus;
#line 3410
	}
#line 3410

#line 3410
	*xpp = (const void *)xp;
#line 3410
	return status;
#line 3410
#endif
#line 3410
}
#line 3410

int
#line 3411
ncx_getn_longlong_float(const void **xpp, size_t nelems, float *tp)
#line 3411
{
#line 3411
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3411

#line 3411
 /* basic algorithm is:
#line 3411
  *   - ensure sane alignment of input data
#line 3411
  *   - copy (conversion happens automatically) input data
#line 3411
  *     to output
#line 3411
  *   - update xpp to point at next unconverted input, and tp to point
#line 3411
  *     at next location for converted output
#line 3411
  */
#line 3411
  long i, j, ni;
#line 3411
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3411
  int64 *xp;
#line 3411
  int nrange = 0;         /* number of range errors */
#line 3411
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3411
  long cxp = (long) *((char**)xpp);
#line 3411

#line 3411
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3411
  /* sjl: manually stripmine so we can limit amount of
#line 3411
   * vector work space reserved to LOOPCNT elements. Also
#line 3411
   * makes vectorisation easy */
#line 3411
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3411
    ni=Min(nelems-j,LOOPCNT);
#line 3411
    if (realign) {
#line 3411
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3411
      xp = tmp;
#line 3411
    } else {
#line 3411
      xp = (int64 *) *xpp;
#line 3411
    }
#line 3411
   /* copy the next block */
#line 3411
#pragma cdir loopcnt=LOOPCNT
#line 3411
#pragma cdir shortloop
#line 3411
    for (i=0; i<ni; i++) {
#line 3411
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3411
     /* test for range errors (not always needed but do it anyway) */
#line 3411
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3411
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3411
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3411
    }
#line 3411
   /* update xpp and tp */
#line 3411
    if (realign) xp = (int64 *) *xpp;
#line 3411
    xp += ni;
#line 3411
    tp += ni;
#line 3411
    *xpp = (void*)xp;
#line 3411
  }
#line 3411
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3411

#line 3411
#else   /* not SX */
#line 3411
	const char *xp = (const char *) *xpp;
#line 3411
	int status = NC_NOERR;
#line 3411

#line 3411
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3411
	{
#line 3411
		const int lstatus = ncx_get_longlong_float(xp, tp);
#line 3411
		if (status == NC_NOERR) /* report the first encountered error */
#line 3411
			status = lstatus;
#line 3411
	}
#line 3411

#line 3411
	*xpp = (const void *)xp;
#line 3411
	return status;
#line 3411
#endif
#line 3411
}
#line 3411

int
#line 3412
ncx_getn_longlong_double(const void **xpp, size_t nelems, double *tp)
#line 3412
{
#line 3412
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3412

#line 3412
 /* basic algorithm is:
#line 3412
  *   - ensure sane alignment of input data
#line 3412
  *   - copy (conversion happens automatically) input data
#line 3412
  *     to output
#line 3412
  *   - update xpp to point at next unconverted input, and tp to point
#line 3412
  *     at next location for converted output
#line 3412
  */
#line 3412
  long i, j, ni;
#line 3412
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3412
  int64 *xp;
#line 3412
  int nrange = 0;         /* number of range errors */
#line 3412
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3412
  long cxp = (long) *((char**)xpp);
#line 3412

#line 3412
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3412
  /* sjl: manually stripmine so we can limit amount of
#line 3412
   * vector work space reserved to LOOPCNT elements. Also
#line 3412
   * makes vectorisation easy */
#line 3412
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3412
    ni=Min(nelems-j,LOOPCNT);
#line 3412
    if (realign) {
#line 3412
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3412
      xp = tmp;
#line 3412
    } else {
#line 3412
      xp = (int64 *) *xpp;
#line 3412
    }
#line 3412
   /* copy the next block */
#line 3412
#pragma cdir loopcnt=LOOPCNT
#line 3412
#pragma cdir shortloop
#line 3412
    for (i=0; i<ni; i++) {
#line 3412
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3412
     /* test for range errors (not always needed but do it anyway) */
#line 3412
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3412
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3412
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3412
    }
#line 3412
   /* update xpp and tp */
#line 3412
    if (realign) xp = (int64 *) *xpp;
#line 3412
    xp += ni;
#line 3412
    tp += ni;
#line 3412
    *xpp = (void*)xp;
#line 3412
  }
#line 3412
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3412

#line 3412
#else   /* not SX */
#line 3412
	const char *xp = (const char *) *xpp;
#line 3412
	int status = NC_NOERR;
#line 3412

#line 3412
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3412
	{
#line 3412
		const int lstatus = ncx_get_longlong_double(xp, tp);
#line 3412
		if (status == NC_NOERR) /* report the first encountered error */
#line 3412
			status = lstatus;
#line 3412
	}
#line 3412

#line 3412
	*xpp = (const void *)xp;
#line 3412
	return status;
#line 3412
#endif
#line 3412
}
#line 3412

int
#line 3413
ncx_getn_longlong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3413
{
#line 3413
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3413

#line 3413
 /* basic algorithm is:
#line 3413
  *   - ensure sane alignment of input data
#line 3413
  *   - copy (conversion happens automatically) input data
#line 3413
  *     to output
#line 3413
  *   - update xpp to point at next unconverted input, and tp to point
#line 3413
  *     at next location for converted output
#line 3413
  */
#line 3413
  long i, j, ni;
#line 3413
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3413
  int64 *xp;
#line 3413
  int nrange = 0;         /* number of range errors */
#line 3413
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3413
  long cxp = (long) *((char**)xpp);
#line 3413

#line 3413
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3413
  /* sjl: manually stripmine so we can limit amount of
#line 3413
   * vector work space reserved to LOOPCNT elements. Also
#line 3413
   * makes vectorisation easy */
#line 3413
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3413
    ni=Min(nelems-j,LOOPCNT);
#line 3413
    if (realign) {
#line 3413
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3413
      xp = tmp;
#line 3413
    } else {
#line 3413
      xp = (int64 *) *xpp;
#line 3413
    }
#line 3413
   /* copy the next block */
#line 3413
#pragma cdir loopcnt=LOOPCNT
#line 3413
#pragma cdir shortloop
#line 3413
    for (i=0; i<ni; i++) {
#line 3413
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3413
     /* test for range errors (not always needed but do it anyway) */
#line 3413
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3413
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3413
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3413
    }
#line 3413
   /* update xpp and tp */
#line 3413
    if (realign) xp = (int64 *) *xpp;
#line 3413
    xp += ni;
#line 3413
    tp += ni;
#line 3413
    *xpp = (void*)xp;
#line 3413
  }
#line 3413
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3413

#line 3413
#else   /* not SX */
#line 3413
	const char *xp = (const char *) *xpp;
#line 3413
	int status = NC_NOERR;
#line 3413

#line 3413
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3413
	{
#line 3413
		const int lstatus = ncx_get_longlong_uchar(xp, tp);
#line 3413
		if (status == NC_NOERR) /* report the first encountered error */
#line 3413
			status = lstatus;
#line 3413
	}
#line 3413

#line 3413
	*xpp = (const void *)xp;
#line 3413
	return status;
#line 3413
#endif
#line 3413
}
#line 3413

int
#line 3414
ncx_getn_longlong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3414
{
#line 3414
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3414

#line 3414
 /* basic algorithm is:
#line 3414
  *   - ensure sane alignment of input data
#line 3414
  *   - copy (conversion happens automatically) input data
#line 3414
  *     to output
#line 3414
  *   - update xpp to point at next unconverted input, and tp to point
#line 3414
  *     at next location for converted output
#line 3414
  */
#line 3414
  long i, j, ni;
#line 3414
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3414
  int64 *xp;
#line 3414
  int nrange = 0;         /* number of range errors */
#line 3414
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3414
  long cxp = (long) *((char**)xpp);
#line 3414

#line 3414
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3414
  /* sjl: manually stripmine so we can limit amount of
#line 3414
   * vector work space reserved to LOOPCNT elements. Also
#line 3414
   * makes vectorisation easy */
#line 3414
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3414
    ni=Min(nelems-j,LOOPCNT);
#line 3414
    if (realign) {
#line 3414
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3414
      xp = tmp;
#line 3414
    } else {
#line 3414
      xp = (int64 *) *xpp;
#line 3414
    }
#line 3414
   /* copy the next block */
#line 3414
#pragma cdir loopcnt=LOOPCNT
#line 3414
#pragma cdir shortloop
#line 3414
    for (i=0; i<ni; i++) {
#line 3414
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3414
     /* test for range errors (not always needed but do it anyway) */
#line 3414
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3414
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3414
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3414
    }
#line 3414
   /* update xpp and tp */
#line 3414
    if (realign) xp = (int64 *) *xpp;
#line 3414
    xp += ni;
#line 3414
    tp += ni;
#line 3414
    *xpp = (void*)xp;
#line 3414
  }
#line 3414
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3414

#line 3414
#else   /* not SX */
#line 3414
	const char *xp = (const char *) *xpp;
#line 3414
	int status = NC_NOERR;
#line 3414

#line 3414
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3414
	{
#line 3414
		const int lstatus = ncx_get_longlong_ushort(xp, tp);
#line 3414
		if (status == NC_NOERR) /* report the first encountered error */
#line 3414
			status = lstatus;
#line 3414
	}
#line 3414

#line 3414
	*xpp = (const void *)xp;
#line 3414
	return status;
#line 3414
#endif
#line 3414
}
#line 3414

int
#line 3415
ncx_getn_longlong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3415
{
#line 3415
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3415

#line 3415
 /* basic algorithm is:
#line 3415
  *   - ensure sane alignment of input data
#line 3415
  *   - copy (conversion happens automatically) input data
#line 3415
  *     to output
#line 3415
  *   - update xpp to point at next unconverted input, and tp to point
#line 3415
  *     at next location for converted output
#line 3415
  */
#line 3415
  long i, j, ni;
#line 3415
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3415
  int64 *xp;
#line 3415
  int nrange = 0;         /* number of range errors */
#line 3415
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3415
  long cxp = (long) *((char**)xpp);
#line 3415

#line 3415
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3415
  /* sjl: manually stripmine so we can limit amount of
#line 3415
   * vector work space reserved to LOOPCNT elements. Also
#line 3415
   * makes vectorisation easy */
#line 3415
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3415
    ni=Min(nelems-j,LOOPCNT);
#line 3415
    if (realign) {
#line 3415
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3415
      xp = tmp;
#line 3415
    } else {
#line 3415
      xp = (int64 *) *xpp;
#line 3415
    }
#line 3415
   /* copy the next block */
#line 3415
#pragma cdir loopcnt=LOOPCNT
#line 3415
#pragma cdir shortloop
#line 3415
    for (i=0; i<ni; i++) {
#line 3415
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3415
     /* test for range errors (not always needed but do it anyway) */
#line 3415
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3415
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3415
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3415
    }
#line 3415
   /* update xpp and tp */
#line 3415
    if (realign) xp = (int64 *) *xpp;
#line 3415
    xp += ni;
#line 3415
    tp += ni;
#line 3415
    *xpp = (void*)xp;
#line 3415
  }
#line 3415
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3415

#line 3415
#else   /* not SX */
#line 3415
	const char *xp = (const char *) *xpp;
#line 3415
	int status = NC_NOERR;
#line 3415

#line 3415
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3415
	{
#line 3415
		const int lstatus = ncx_get_longlong_uint(xp, tp);
#line 3415
		if (status == NC_NOERR) /* report the first encountered error */
#line 3415
			status = lstatus;
#line 3415
	}
#line 3415

#line 3415
	*xpp = (const void *)xp;
#line 3415
	return status;
#line 3415
#endif
#line 3415
}
#line 3415

int
#line 3416
ncx_getn_longlong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3416
{
#line 3416
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3416

#line 3416
 /* basic algorithm is:
#line 3416
  *   - ensure sane alignment of input data
#line 3416
  *   - copy (conversion happens automatically) input data
#line 3416
  *     to output
#line 3416
  *   - update xpp to point at next unconverted input, and tp to point
#line 3416
  *     at next location for converted output
#line 3416
  */
#line 3416
  long i, j, ni;
#line 3416
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3416
  int64 *xp;
#line 3416
  int nrange = 0;         /* number of range errors */
#line 3416
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3416
  long cxp = (long) *((char**)xpp);
#line 3416

#line 3416
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3416
  /* sjl: manually stripmine so we can limit amount of
#line 3416
   * vector work space reserved to LOOPCNT elements. Also
#line 3416
   * makes vectorisation easy */
#line 3416
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3416
    ni=Min(nelems-j,LOOPCNT);
#line 3416
    if (realign) {
#line 3416
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3416
      xp = tmp;
#line 3416
    } else {
#line 3416
      xp = (int64 *) *xpp;
#line 3416
    }
#line 3416
   /* copy the next block */
#line 3416
#pragma cdir loopcnt=LOOPCNT
#line 3416
#pragma cdir shortloop
#line 3416
    for (i=0; i<ni; i++) {
#line 3416
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3416
     /* test for range errors (not always needed but do it anyway) */
#line 3416
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3416
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3416
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3416
    }
#line 3416
   /* update xpp and tp */
#line 3416
    if (realign) xp = (int64 *) *xpp;
#line 3416
    xp += ni;
#line 3416
    tp += ni;
#line 3416
    *xpp = (void*)xp;
#line 3416
  }
#line 3416
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3416

#line 3416
#else   /* not SX */
#line 3416
	const char *xp = (const char *) *xpp;
#line 3416
	int status = NC_NOERR;
#line 3416

#line 3416
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3416
	{
#line 3416
		const int lstatus = ncx_get_longlong_ulonglong(xp, tp);
#line 3416
		if (status == NC_NOERR) /* report the first encountered error */
#line 3416
			status = lstatus;
#line 3416
	}
#line 3416

#line 3416
	*xpp = (const void *)xp;
#line 3416
	return status;
#line 3416
#endif
#line 3416
}
#line 3416


#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3432
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3432
{
#line 3432
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3432

#line 3432
 /* basic algorithm is:
#line 3432
  *   - ensure sane alignment of output data
#line 3432
  *   - copy (conversion happens automatically) input data
#line 3432
  *     to output
#line 3432
  *   - update tp to point at next unconverted input, and xpp to point
#line 3432
  *     at next location for converted output
#line 3432
  */
#line 3432
  long i, j, ni;
#line 3432
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3432
  int64 *xp;
#line 3432
  int nrange = 0;         /* number of range errors */
#line 3432
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3432
  long cxp = (long) *((char**)xpp);
#line 3432

#line 3432
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3432
  /* sjl: manually stripmine so we can limit amount of
#line 3432
   * vector work space reserved to LOOPCNT elements. Also
#line 3432
   * makes vectorisation easy */
#line 3432
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3432
    ni=Min(nelems-j,LOOPCNT);
#line 3432
    if (realign) {
#line 3432
      xp = tmp;
#line 3432
    } else {
#line 3432
      xp = (int64 *) *xpp;
#line 3432
    }
#line 3432
   /* copy the next block */
#line 3432
#pragma cdir loopcnt=LOOPCNT
#line 3432
#pragma cdir shortloop
#line 3432
    for (i=0; i<ni; i++) {
#line 3432
      /* the normal case: */
#line 3432
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3432
     /* test for range errors (not always needed but do it anyway) */
#line 3432
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3432
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3432
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3432
    }
#line 3432
   /* copy workspace back if necessary */
#line 3432
    if (realign) {
#line 3432
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3432
      xp = (int64 *) *xpp;
#line 3432
    }
#line 3432
   /* update xpp and tp */
#line 3432
    xp += ni;
#line 3432
    tp += ni;
#line 3432
    *xpp = (void*)xp;
#line 3432
  }
#line 3432
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3432

#line 3432
#else   /* not SX */
#line 3432

#line 3432
	char *xp = (char *) *xpp;
#line 3432
	int status = NC_NOERR;
#line 3432

#line 3432
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3432
	{
#line 3432
		int lstatus = ncx_put_longlong_longlong(xp, tp, fillp);
#line 3432
		if (status == NC_NOERR) /* report the first encountered error */
#line 3432
			status = lstatus;
#line 3432
	}
#line 3432

#line 3432
	*xpp = (void *)xp;
#line 3432
	return status;
#line 3432
#endif
#line 3432
}
#line 3432

#endif
int
#line 3434
ncx_putn_longlong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3434
{
#line 3434
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3434

#line 3434
 /* basic algorithm is:
#line 3434
  *   - ensure sane alignment of output data
#line 3434
  *   - copy (conversion happens automatically) input data
#line 3434
  *     to output
#line 3434
  *   - update tp to point at next unconverted input, and xpp to point
#line 3434
  *     at next location for converted output
#line 3434
  */
#line 3434
  long i, j, ni;
#line 3434
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3434
  int64 *xp;
#line 3434
  int nrange = 0;         /* number of range errors */
#line 3434
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3434
  long cxp = (long) *((char**)xpp);
#line 3434

#line 3434
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3434
  /* sjl: manually stripmine so we can limit amount of
#line 3434
   * vector work space reserved to LOOPCNT elements. Also
#line 3434
   * makes vectorisation easy */
#line 3434
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3434
    ni=Min(nelems-j,LOOPCNT);
#line 3434
    if (realign) {
#line 3434
      xp = tmp;
#line 3434
    } else {
#line 3434
      xp = (int64 *) *xpp;
#line 3434
    }
#line 3434
   /* copy the next block */
#line 3434
#pragma cdir loopcnt=LOOPCNT
#line 3434
#pragma cdir shortloop
#line 3434
    for (i=0; i<ni; i++) {
#line 3434
      /* the normal case: */
#line 3434
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3434
     /* test for range errors (not always needed but do it anyway) */
#line 3434
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3434
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3434
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3434
    }
#line 3434
   /* copy workspace back if necessary */
#line 3434
    if (realign) {
#line 3434
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3434
      xp = (int64 *) *xpp;
#line 3434
    }
#line 3434
   /* update xpp and tp */
#line 3434
    xp += ni;
#line 3434
    tp += ni;
#line 3434
    *xpp = (void*)xp;
#line 3434
  }
#line 3434
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3434

#line 3434
#else   /* not SX */
#line 3434

#line 3434
	char *xp = (char *) *xpp;
#line 3434
	int status = NC_NOERR;
#line 3434

#line 3434
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3434
	{
#line 3434
		int lstatus = ncx_put_longlong_schar(xp, tp, fillp);
#line 3434
		if (status == NC_NOERR) /* report the first encountered error */
#line 3434
			status = lstatus;
#line 3434
	}
#line 3434

#line 3434
	*xpp = (void *)xp;
#line 3434
	return status;
#line 3434
#endif
#line 3434
}
#line 3434

int
#line 3435
ncx_putn_longlong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3435
{
#line 3435
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3435

#line 3435
 /* basic algorithm is:
#line 3435
  *   - ensure sane alignment of output data
#line 3435
  *   - copy (conversion happens automatically) input data
#line 3435
  *     to output
#line 3435
  *   - update tp to point at next unconverted input, and xpp to point
#line 3435
  *     at next location for converted output
#line 3435
  */
#line 3435
  long i, j, ni;
#line 3435
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3435
  int64 *xp;
#line 3435
  int nrange = 0;         /* number of range errors */
#line 3435
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3435
  long cxp = (long) *((char**)xpp);
#line 3435

#line 3435
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3435
  /* sjl: manually stripmine so we can limit amount of
#line 3435
   * vector work space reserved to LOOPCNT elements. Also
#line 3435
   * makes vectorisation easy */
#line 3435
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3435
    ni=Min(nelems-j,LOOPCNT);
#line 3435
    if (realign) {
#line 3435
      xp = tmp;
#line 3435
    } else {
#line 3435
      xp = (int64 *) *xpp;
#line 3435
    }
#line 3435
   /* copy the next block */
#line 3435
#pragma cdir loopcnt=LOOPCNT
#line 3435
#pragma cdir shortloop
#line 3435
    for (i=0; i<ni; i++) {
#line 3435
      /* the normal case: */
#line 3435
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3435
     /* test for range errors (not always needed but do it anyway) */
#line 3435
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3435
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3435
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3435
    }
#line 3435
   /* copy workspace back if necessary */
#line 3435
    if (realign) {
#line 3435
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3435
      xp = (int64 *) *xpp;
#line 3435
    }
#line 3435
   /* update xpp and tp */
#line 3435
    xp += ni;
#line 3435
    tp += ni;
#line 3435
    *xpp = (void*)xp;
#line 3435
  }
#line 3435
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3435

#line 3435
#else   /* not SX */
#line 3435

#line 3435
	char *xp = (char *) *xpp;
#line 3435
	int status = NC_NOERR;
#line 3435

#line 3435
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3435
	{
#line 3435
		int lstatus = ncx_put_longlong_short(xp, tp, fillp);
#line 3435
		if (status == NC_NOERR) /* report the first encountered error */
#line 3435
			status = lstatus;
#line 3435
	}
#line 3435

#line 3435
	*xpp = (void *)xp;
#line 3435
	return status;
#line 3435
#endif
#line 3435
}
#line 3435

int
#line 3436
ncx_putn_longlong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3436
{
#line 3436
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3436

#line 3436
 /* basic algorithm is:
#line 3436
  *   - ensure sane alignment of output data
#line 3436
  *   - copy (conversion happens automatically) input data
#line 3436
  *     to output
#line 3436
  *   - update tp to point at next unconverted input, and xpp to point
#line 3436
  *     at next location for converted output
#line 3436
  */
#line 3436
  long i, j, ni;
#line 3436
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3436
  int64 *xp;
#line 3436
  int nrange = 0;         /* number of range errors */
#line 3436
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3436
  long cxp = (long) *((char**)xpp);
#line 3436

#line 3436
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3436
  /* sjl: manually stripmine so we can limit amount of
#line 3436
   * vector work space reserved to LOOPCNT elements. Also
#line 3436
   * makes vectorisation easy */
#line 3436
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3436
    ni=Min(nelems-j,LOOPCNT);
#line 3436
    if (realign) {
#line 3436
      xp = tmp;
#line 3436
    } else {
#line 3436
      xp = (int64 *) *xpp;
#line 3436
    }
#line 3436
   /* copy the next block */
#line 3436
#pragma cdir loopcnt=LOOPCNT
#line 3436
#pragma cdir shortloop
#line 3436
    for (i=0; i<ni; i++) {
#line 3436
      /* the normal case: */
#line 3436
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3436
     /* test for range errors (not always needed but do it anyway) */
#line 3436
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3436
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3436
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3436
    }
#line 3436
   /* copy workspace back if necessary */
#line 3436
    if (realign) {
#line 3436
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3436
      xp = (int64 *) *xpp;
#line 3436
    }
#line 3436
   /* update xpp and tp */
#line 3436
    xp += ni;
#line 3436
    tp += ni;
#line 3436
    *xpp = (void*)xp;
#line 3436
  }
#line 3436
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3436

#line 3436
#else   /* not SX */
#line 3436

#line 3436
	char *xp = (char *) *xpp;
#line 3436
	int status = NC_NOERR;
#line 3436

#line 3436
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3436
	{
#line 3436
		int lstatus = ncx_put_longlong_int(xp, tp, fillp);
#line 3436
		if (status == NC_NOERR) /* report the first encountered error */
#line 3436
			status = lstatus;
#line 3436
	}
#line 3436

#line 3436
	*xpp = (void *)xp;
#line 3436
	return status;
#line 3436
#endif
#line 3436
}
#line 3436

int
#line 3437
ncx_putn_longlong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3437
{
#line 3437
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3437

#line 3437
 /* basic algorithm is:
#line 3437
  *   - ensure sane alignment of output data
#line 3437
  *   - copy (conversion happens automatically) input data
#line 3437
  *     to output
#line 3437
  *   - update tp to point at next unconverted input, and xpp to point
#line 3437
  *     at next location for converted output
#line 3437
  */
#line 3437
  long i, j, ni;
#line 3437
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3437
  int64 *xp;
#line 3437
  int nrange = 0;         /* number of range errors */
#line 3437
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3437
  long cxp = (long) *((char**)xpp);
#line 3437

#line 3437
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3437
  /* sjl: manually stripmine so we can limit amount of
#line 3437
   * vector work space reserved to LOOPCNT elements. Also
#line 3437
   * makes vectorisation easy */
#line 3437
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3437
    ni=Min(nelems-j,LOOPCNT);
#line 3437
    if (realign) {
#line 3437
      xp = tmp;
#line 3437
    } else {
#line 3437
      xp = (int64 *) *xpp;
#line 3437
    }
#line 3437
   /* copy the next block */
#line 3437
#pragma cdir loopcnt=LOOPCNT
#line 3437
#pragma cdir shortloop
#line 3437
    for (i=0; i<ni; i++) {
#line 3437
      /* the normal case: */
#line 3437
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3437
     /* test for range errors (not always needed but do it anyway) */
#line 3437
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3437
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3437
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3437
    }
#line 3437
   /* copy workspace back if necessary */
#line 3437
    if (realign) {
#line 3437
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3437
      xp = (int64 *) *xpp;
#line 3437
    }
#line 3437
   /* update xpp and tp */
#line 3437
    xp += ni;
#line 3437
    tp += ni;
#line 3437
    *xpp = (void*)xp;
#line 3437
  }
#line 3437
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3437

#line 3437
#else   /* not SX */
#line 3437

#line 3437
	char *xp = (char *) *xpp;
#line 3437
	int status = NC_NOERR;
#line 3437

#line 3437
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3437
	{
#line 3437
		int lstatus = ncx_put_longlong_long(xp, tp, fillp);
#line 3437
		if (status == NC_NOERR) /* report the first encountered error */
#line 3437
			status = lstatus;
#line 3437
	}
#line 3437

#line 3437
	*xpp = (void *)xp;
#line 3437
	return status;
#line 3437
#endif
#line 3437
}
#line 3437

int
#line 3438
ncx_putn_longlong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3438
{
#line 3438
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3438

#line 3438
 /* basic algorithm is:
#line 3438
  *   - ensure sane alignment of output data
#line 3438
  *   - copy (conversion happens automatically) input data
#line 3438
  *     to output
#line 3438
  *   - update tp to point at next unconverted input, and xpp to point
#line 3438
  *     at next location for converted output
#line 3438
  */
#line 3438
  long i, j, ni;
#line 3438
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3438
  int64 *xp;
#line 3438
  int nrange = 0;         /* number of range errors */
#line 3438
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3438
  long cxp = (long) *((char**)xpp);
#line 3438

#line 3438
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3438
  /* sjl: manually stripmine so we can limit amount of
#line 3438
   * vector work space reserved to LOOPCNT elements. Also
#line 3438
   * makes vectorisation easy */
#line 3438
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3438
    ni=Min(nelems-j,LOOPCNT);
#line 3438
    if (realign) {
#line 3438
      xp = tmp;
#line 3438
    } else {
#line 3438
      xp = (int64 *) *xpp;
#line 3438
    }
#line 3438
   /* copy the next block */
#line 3438
#pragma cdir loopcnt=LOOPCNT
#line 3438
#pragma cdir shortloop
#line 3438
    for (i=0; i<ni; i++) {
#line 3438
      /* the normal case: */
#line 3438
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3438
     /* test for range errors (not always needed but do it anyway) */
#line 3438
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3438
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3438
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3438
    }
#line 3438
   /* copy workspace back if necessary */
#line 3438
    if (realign) {
#line 3438
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3438
      xp = (int64 *) *xpp;
#line 3438
    }
#line 3438
   /* update xpp and tp */
#line 3438
    xp += ni;
#line 3438
    tp += ni;
#line 3438
    *xpp = (void*)xp;
#line 3438
  }
#line 3438
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3438

#line 3438
#else   /* not SX */
#line 3438

#line 3438
	char *xp = (char *) *xpp;
#line 3438
	int status = NC_NOERR;
#line 3438

#line 3438
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3438
	{
#line 3438
		int lstatus = ncx_put_longlong_float(xp, tp, fillp);
#line 3438
		if (status == NC_NOERR) /* report the first encountered error */
#line 3438
			status = lstatus;
#line 3438
	}
#line 3438

#line 3438
	*xpp = (void *)xp;
#line 3438
	return status;
#line 3438
#endif
#line 3438
}
#line 3438

int
#line 3439
ncx_putn_longlong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3439
{
#line 3439
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3439

#line 3439
 /* basic algorithm is:
#line 3439
  *   - ensure sane alignment of output data
#line 3439
  *   - copy (conversion happens automatically) input data
#line 3439
  *     to output
#line 3439
  *   - update tp to point at next unconverted input, and xpp to point
#line 3439
  *     at next location for converted output
#line 3439
  */
#line 3439
  long i, j, ni;
#line 3439
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3439
  int64 *xp;
#line 3439
  int nrange = 0;         /* number of range errors */
#line 3439
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3439
  long cxp = (long) *((char**)xpp);
#line 3439

#line 3439
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3439
  /* sjl: manually stripmine so we can limit amount of
#line 3439
   * vector work space reserved to LOOPCNT elements. Also
#line 3439
   * makes vectorisation easy */
#line 3439
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3439
    ni=Min(nelems-j,LOOPCNT);
#line 3439
    if (realign) {
#line 3439
      xp = tmp;
#line 3439
    } else {
#line 3439
      xp = (int64 *) *xpp;
#line 3439
    }
#line 3439
   /* copy the next block */
#line 3439
#pragma cdir loopcnt=LOOPCNT
#line 3439
#pragma cdir shortloop
#line 3439
    for (i=0; i<ni; i++) {
#line 3439
      /* the normal case: */
#line 3439
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3439
     /* test for range errors (not always needed but do it anyway) */
#line 3439
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3439
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3439
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3439
    }
#line 3439
   /* copy workspace back if necessary */
#line 3439
    if (realign) {
#line 3439
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3439
      xp = (int64 *) *xpp;
#line 3439
    }
#line 3439
   /* update xpp and tp */
#line 3439
    xp += ni;
#line 3439
    tp += ni;
#line 3439
    *xpp = (void*)xp;
#line 3439
  }
#line 3439
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3439

#line 3439
#else   /* not SX */
#line 3439

#line 3439
	char *xp = (char *) *xpp;
#line 3439
	int status = NC_NOERR;
#line 3439

#line 3439
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3439
	{
#line 3439
		int lstatus = ncx_put_longlong_double(xp, tp, fillp);
#line 3439
		if (status == NC_NOERR) /* report the first encountered error */
#line 3439
			status = lstatus;
#line 3439
	}
#line 3439

#line 3439
	*xpp = (void *)xp;
#line 3439
	return status;
#line 3439
#endif
#line 3439
}
#line 3439

int
#line 3440
ncx_putn_longlong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3440
{
#line 3440
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3440

#line 3440
 /* basic algorithm is:
#line 3440
  *   - ensure sane alignment of output data
#line 3440
  *   - copy (conversion happens automatically) input data
#line 3440
  *     to output
#line 3440
  *   - update tp to point at next unconverted input, and xpp to point
#line 3440
  *     at next location for converted output
#line 3440
  */
#line 3440
  long i, j, ni;
#line 3440
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3440
  int64 *xp;
#line 3440
  int nrange = 0;         /* number of range errors */
#line 3440
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3440
  long cxp = (long) *((char**)xpp);
#line 3440

#line 3440
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3440
  /* sjl: manually stripmine so we can limit amount of
#line 3440
   * vector work space reserved to LOOPCNT elements. Also
#line 3440
   * makes vectorisation easy */
#line 3440
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3440
    ni=Min(nelems-j,LOOPCNT);
#line 3440
    if (realign) {
#line 3440
      xp = tmp;
#line 3440
    } else {
#line 3440
      xp = (int64 *) *xpp;
#line 3440
    }
#line 3440
   /* copy the next block */
#line 3440
#pragma cdir loopcnt=LOOPCNT
#line 3440
#pragma cdir shortloop
#line 3440
    for (i=0; i<ni; i++) {
#line 3440
      /* the normal case: */
#line 3440
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3440
     /* test for range errors (not always needed but do it anyway) */
#line 3440
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3440
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3440
      nrange += tp[i] > X_INT64_MAX ;
#line 3440
    }
#line 3440
   /* copy workspace back if necessary */
#line 3440
    if (realign) {
#line 3440
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3440
      xp = (int64 *) *xpp;
#line 3440
    }
#line 3440
   /* update xpp and tp */
#line 3440
    xp += ni;
#line 3440
    tp += ni;
#line 3440
    *xpp = (void*)xp;
#line 3440
  }
#line 3440
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3440

#line 3440
#else   /* not SX */
#line 3440

#line 3440
	char *xp = (char *) *xpp;
#line 3440
	int status = NC_NOERR;
#line 3440

#line 3440
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3440
	{
#line 3440
		int lstatus = ncx_put_longlong_uchar(xp, tp, fillp);
#line 3440
		if (status == NC_NOERR) /* report the first encountered error */
#line 3440
			status = lstatus;
#line 3440
	}
#line 3440

#line 3440
	*xpp = (void *)xp;
#line 3440
	return status;
#line 3440
#endif
#line 3440
}
#line 3440

int
#line 3441
ncx_putn_longlong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3441
{
#line 3441
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3441

#line 3441
 /* basic algorithm is:
#line 3441
  *   - ensure sane alignment of output data
#line 3441
  *   - copy (conversion happens automatically) input data
#line 3441
  *     to output
#line 3441
  *   - update tp to point at next unconverted input, and xpp to point
#line 3441
  *     at next location for converted output
#line 3441
  */
#line 3441
  long i, j, ni;
#line 3441
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3441
  int64 *xp;
#line 3441
  int nrange = 0;         /* number of range errors */
#line 3441
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3441
  long cxp = (long) *((char**)xpp);
#line 3441

#line 3441
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3441
  /* sjl: manually stripmine so we can limit amount of
#line 3441
   * vector work space reserved to LOOPCNT elements. Also
#line 3441
   * makes vectorisation easy */
#line 3441
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3441
    ni=Min(nelems-j,LOOPCNT);
#line 3441
    if (realign) {
#line 3441
      xp = tmp;
#line 3441
    } else {
#line 3441
      xp = (int64 *) *xpp;
#line 3441
    }
#line 3441
   /* copy the next block */
#line 3441
#pragma cdir loopcnt=LOOPCNT
#line 3441
#pragma cdir shortloop
#line 3441
    for (i=0; i<ni; i++) {
#line 3441
      /* the normal case: */
#line 3441
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3441
     /* test for range errors (not always needed but do it anyway) */
#line 3441
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3441
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3441
      nrange += tp[i] > X_INT64_MAX ;
#line 3441
    }
#line 3441
   /* copy workspace back if necessary */
#line 3441
    if (realign) {
#line 3441
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3441
      xp = (int64 *) *xpp;
#line 3441
    }
#line 3441
   /* update xpp and tp */
#line 3441
    xp += ni;
#line 3441
    tp += ni;
#line 3441
    *xpp = (void*)xp;
#line 3441
  }
#line 3441
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3441

#line 3441
#else   /* not SX */
#line 3441

#line 3441
	char *xp = (char *) *xpp;
#line 3441
	int status = NC_NOERR;
#line 3441

#line 3441
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3441
	{
#line 3441
		int lstatus = ncx_put_longlong_ushort(xp, tp, fillp);
#line 3441
		if (status == NC_NOERR) /* report the first encountered error */
#line 3441
			status = lstatus;
#line 3441
	}
#line 3441

#line 3441
	*xpp = (void *)xp;
#line 3441
	return status;
#line 3441
#endif
#line 3441
}
#line 3441

int
#line 3442
ncx_putn_longlong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3442
{
#line 3442
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3442

#line 3442
 /* basic algorithm is:
#line 3442
  *   - ensure sane alignment of output data
#line 3442
  *   - copy (conversion happens automatically) input data
#line 3442
  *     to output
#line 3442
  *   - update tp to point at next unconverted input, and xpp to point
#line 3442
  *     at next location for converted output
#line 3442
  */
#line 3442
  long i, j, ni;
#line 3442
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3442
  int64 *xp;
#line 3442
  int nrange = 0;         /* number of range errors */
#line 3442
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3442
  long cxp = (long) *((char**)xpp);
#line 3442

#line 3442
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3442
  /* sjl: manually stripmine so we can limit amount of
#line 3442
   * vector work space reserved to LOOPCNT elements. Also
#line 3442
   * makes vectorisation easy */
#line 3442
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3442
    ni=Min(nelems-j,LOOPCNT);
#line 3442
    if (realign) {
#line 3442
      xp = tmp;
#line 3442
    } else {
#line 3442
      xp = (int64 *) *xpp;
#line 3442
    }
#line 3442
   /* copy the next block */
#line 3442
#pragma cdir loopcnt=LOOPCNT
#line 3442
#pragma cdir shortloop
#line 3442
    for (i=0; i<ni; i++) {
#line 3442
      /* the normal case: */
#line 3442
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3442
     /* test for range errors (not always needed but do it anyway) */
#line 3442
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3442
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3442
      nrange += tp[i] > X_INT64_MAX ;
#line 3442
    }
#line 3442
   /* copy workspace back if necessary */
#line 3442
    if (realign) {
#line 3442
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3442
      xp = (int64 *) *xpp;
#line 3442
    }
#line 3442
   /* update xpp and tp */
#line 3442
    xp += ni;
#line 3442
    tp += ni;
#line 3442
    *xpp = (void*)xp;
#line 3442
  }
#line 3442
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3442

#line 3442
#else   /* not SX */
#line 3442

#line 3442
	char *xp = (char *) *xpp;
#line 3442
	int status = NC_NOERR;
#line 3442

#line 3442
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3442
	{
#line 3442
		int lstatus = ncx_put_longlong_uint(xp, tp, fillp);
#line 3442
		if (status == NC_NOERR) /* report the first encountered error */
#line 3442
			status = lstatus;
#line 3442
	}
#line 3442

#line 3442
	*xpp = (void *)xp;
#line 3442
	return status;
#line 3442
#endif
#line 3442
}
#line 3442

int
#line 3443
ncx_putn_longlong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3443
{
#line 3443
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3443

#line 3443
 /* basic algorithm is:
#line 3443
  *   - ensure sane alignment of output data
#line 3443
  *   - copy (conversion happens automatically) input data
#line 3443
  *     to output
#line 3443
  *   - update tp to point at next unconverted input, and xpp to point
#line 3443
  *     at next location for converted output
#line 3443
  */
#line 3443
  long i, j, ni;
#line 3443
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3443
  int64 *xp;
#line 3443
  int nrange = 0;         /* number of range errors */
#line 3443
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3443
  long cxp = (long) *((char**)xpp);
#line 3443

#line 3443
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3443
  /* sjl: manually stripmine so we can limit amount of
#line 3443
   * vector work space reserved to LOOPCNT elements. Also
#line 3443
   * makes vectorisation easy */
#line 3443
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3443
    ni=Min(nelems-j,LOOPCNT);
#line 3443
    if (realign) {
#line 3443
      xp = tmp;
#line 3443
    } else {
#line 3443
      xp = (int64 *) *xpp;
#line 3443
    }
#line 3443
   /* copy the next block */
#line 3443
#pragma cdir loopcnt=LOOPCNT
#line 3443
#pragma cdir shortloop
#line 3443
    for (i=0; i<ni; i++) {
#line 3443
      /* the normal case: */
#line 3443
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3443
     /* test for range errors (not always needed but do it anyway) */
#line 3443
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3443
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3443
      nrange += tp[i] > X_INT64_MAX ;
#line 3443
    }
#line 3443
   /* copy workspace back if necessary */
#line 3443
    if (realign) {
#line 3443
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3443
      xp = (int64 *) *xpp;
#line 3443
    }
#line 3443
   /* update xpp and tp */
#line 3443
    xp += ni;
#line 3443
    tp += ni;
#line 3443
    *xpp = (void*)xp;
#line 3443
  }
#line 3443
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3443

#line 3443
#else   /* not SX */
#line 3443

#line 3443
	char *xp = (char *) *xpp;
#line 3443
	int status = NC_NOERR;
#line 3443

#line 3443
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3443
	{
#line 3443
		int lstatus = ncx_put_longlong_ulonglong(xp, tp, fillp);
#line 3443
		if (status == NC_NOERR) /* report the first encountered error */
#line 3443
			status = lstatus;
#line 3443
	}
#line 3443

#line 3443
	*xpp = (void *)xp;
#line 3443
	return status;
#line 3443
#endif
#line 3443
}
#line 3443


/* uint64 --------------------------------------------------------------------*/

#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, unsigned long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UNSIGNED_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3461
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3461
{
#line 3461
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3461

#line 3461
 /* basic algorithm is:
#line 3461
  *   - ensure sane alignment of input data
#line 3461
  *   - copy (conversion happens automatically) input data
#line 3461
  *     to output
#line 3461
  *   - update xpp to point at next unconverted input, and tp to point
#line 3461
  *     at next location for converted output
#line 3461
  */
#line 3461
  long i, j, ni;
#line 3461
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3461
  uint64 *xp;
#line 3461
  int nrange = 0;         /* number of range errors */
#line 3461
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3461
  long cxp = (long) *((char**)xpp);
#line 3461

#line 3461
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3461
  /* sjl: manually stripmine so we can limit amount of
#line 3461
   * vector work space reserved to LOOPCNT elements. Also
#line 3461
   * makes vectorisation easy */
#line 3461
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3461
    ni=Min(nelems-j,LOOPCNT);
#line 3461
    if (realign) {
#line 3461
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3461
      xp = tmp;
#line 3461
    } else {
#line 3461
      xp = (uint64 *) *xpp;
#line 3461
    }
#line 3461
   /* copy the next block */
#line 3461
#pragma cdir loopcnt=LOOPCNT
#line 3461
#pragma cdir shortloop
#line 3461
    for (i=0; i<ni; i++) {
#line 3461
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3461
     /* test for range errors (not always needed but do it anyway) */
#line 3461
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3461
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3461
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3461
    }
#line 3461
   /* update xpp and tp */
#line 3461
    if (realign) xp = (uint64 *) *xpp;
#line 3461
    xp += ni;
#line 3461
    tp += ni;
#line 3461
    *xpp = (void*)xp;
#line 3461
  }
#line 3461
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3461

#line 3461
#else   /* not SX */
#line 3461
	const char *xp = (const char *) *xpp;
#line 3461
	int status = NC_NOERR;
#line 3461

#line 3461
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3461
	{
#line 3461
		const int lstatus = ncx_get_ulonglong_ulonglong(xp, tp);
#line 3461
		if (status == NC_NOERR) /* report the first encountered error */
#line 3461
			status = lstatus;
#line 3461
	}
#line 3461

#line 3461
	*xpp = (const void *)xp;
#line 3461
	return status;
#line 3461
#endif
#line 3461
}
#line 3461

#endif
int
#line 3463
ncx_getn_ulonglong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3463
{
#line 3463
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3463

#line 3463
 /* basic algorithm is:
#line 3463
  *   - ensure sane alignment of input data
#line 3463
  *   - copy (conversion happens automatically) input data
#line 3463
  *     to output
#line 3463
  *   - update xpp to point at next unconverted input, and tp to point
#line 3463
  *     at next location for converted output
#line 3463
  */
#line 3463
  long i, j, ni;
#line 3463
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3463
  uint64 *xp;
#line 3463
  int nrange = 0;         /* number of range errors */
#line 3463
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3463
  long cxp = (long) *((char**)xpp);
#line 3463

#line 3463
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3463
  /* sjl: manually stripmine so we can limit amount of
#line 3463
   * vector work space reserved to LOOPCNT elements. Also
#line 3463
   * makes vectorisation easy */
#line 3463
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3463
    ni=Min(nelems-j,LOOPCNT);
#line 3463
    if (realign) {
#line 3463
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3463
      xp = tmp;
#line 3463
    } else {
#line 3463
      xp = (uint64 *) *xpp;
#line 3463
    }
#line 3463
   /* copy the next block */
#line 3463
#pragma cdir loopcnt=LOOPCNT
#line 3463
#pragma cdir shortloop
#line 3463
    for (i=0; i<ni; i++) {
#line 3463
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3463
     /* test for range errors (not always needed but do it anyway) */
#line 3463
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3463
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3463
      nrange += xp[i] > SCHAR_MAX ;
#line 3463
    }
#line 3463
   /* update xpp and tp */
#line 3463
    if (realign) xp = (uint64 *) *xpp;
#line 3463
    xp += ni;
#line 3463
    tp += ni;
#line 3463
    *xpp = (void*)xp;
#line 3463
  }
#line 3463
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3463

#line 3463
#else   /* not SX */
#line 3463
	const char *xp = (const char *) *xpp;
#line 3463
	int status = NC_NOERR;
#line 3463

#line 3463
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3463
	{
#line 3463
		const int lstatus = ncx_get_ulonglong_schar(xp, tp);
#line 3463
		if (status == NC_NOERR) /* report the first encountered error */
#line 3463
			status = lstatus;
#line 3463
	}
#line 3463

#line 3463
	*xpp = (const void *)xp;
#line 3463
	return status;
#line 3463
#endif
#line 3463
}
#line 3463

int
#line 3464
ncx_getn_ulonglong_short(const void **xpp, size_t nelems, short *tp)
#line 3464
{
#line 3464
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3464

#line 3464
 /* basic algorithm is:
#line 3464
  *   - ensure sane alignment of input data
#line 3464
  *   - copy (conversion happens automatically) input data
#line 3464
  *     to output
#line 3464
  *   - update xpp to point at next unconverted input, and tp to point
#line 3464
  *     at next location for converted output
#line 3464
  */
#line 3464
  long i, j, ni;
#line 3464
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3464
  uint64 *xp;
#line 3464
  int nrange = 0;         /* number of range errors */
#line 3464
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3464
  long cxp = (long) *((char**)xpp);
#line 3464

#line 3464
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3464
  /* sjl: manually stripmine so we can limit amount of
#line 3464
   * vector work space reserved to LOOPCNT elements. Also
#line 3464
   * makes vectorisation easy */
#line 3464
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3464
    ni=Min(nelems-j,LOOPCNT);
#line 3464
    if (realign) {
#line 3464
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3464
      xp = tmp;
#line 3464
    } else {
#line 3464
      xp = (uint64 *) *xpp;
#line 3464
    }
#line 3464
   /* copy the next block */
#line 3464
#pragma cdir loopcnt=LOOPCNT
#line 3464
#pragma cdir shortloop
#line 3464
    for (i=0; i<ni; i++) {
#line 3464
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3464
     /* test for range errors (not always needed but do it anyway) */
#line 3464
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3464
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3464
      nrange += xp[i] > SHORT_MAX ;
#line 3464
    }
#line 3464
   /* update xpp and tp */
#line 3464
    if (realign) xp = (uint64 *) *xpp;
#line 3464
    xp += ni;
#line 3464
    tp += ni;
#line 3464
    *xpp = (void*)xp;
#line 3464
  }
#line 3464
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3464

#line 3464
#else   /* not SX */
#line 3464
	const char *xp = (const char *) *xpp;
#line 3464
	int status = NC_NOERR;
#line 3464

#line 3464
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3464
	{
#line 3464
		const int lstatus = ncx_get_ulonglong_short(xp, tp);
#line 3464
		if (status == NC_NOERR) /* report the first encountered error */
#line 3464
			status = lstatus;
#line 3464
	}
#line 3464

#line 3464
	*xpp = (const void *)xp;
#line 3464
	return status;
#line 3464
#endif
#line 3464
}
#line 3464

int
#line 3465
ncx_getn_ulonglong_int(const void **xpp, size_t nelems, int *tp)
#line 3465
{
#line 3465
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3465

#line 3465
 /* basic algorithm is:
#line 3465
  *   - ensure sane alignment of input data
#line 3465
  *   - copy (conversion happens automatically) input data
#line 3465
  *     to output
#line 3465
  *   - update xpp to point at next unconverted input, and tp to point
#line 3465
  *     at next location for converted output
#line 3465
  */
#line 3465
  long i, j, ni;
#line 3465
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3465
  uint64 *xp;
#line 3465
  int nrange = 0;         /* number of range errors */
#line 3465
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3465
  long cxp = (long) *((char**)xpp);
#line 3465

#line 3465
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3465
  /* sjl: manually stripmine so we can limit amount of
#line 3465
   * vector work space reserved to LOOPCNT elements. Also
#line 3465
   * makes vectorisation easy */
#line 3465
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3465
    ni=Min(nelems-j,LOOPCNT);
#line 3465
    if (realign) {
#line 3465
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3465
      xp = tmp;
#line 3465
    } else {
#line 3465
      xp = (uint64 *) *xpp;
#line 3465
    }
#line 3465
   /* copy the next block */
#line 3465
#pragma cdir loopcnt=LOOPCNT
#line 3465
#pragma cdir shortloop
#line 3465
    for (i=0; i<ni; i++) {
#line 3465
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3465
     /* test for range errors (not always needed but do it anyway) */
#line 3465
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3465
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3465
      nrange += xp[i] > INT_MAX ;
#line 3465
    }
#line 3465
   /* update xpp and tp */
#line 3465
    if (realign) xp = (uint64 *) *xpp;
#line 3465
    xp += ni;
#line 3465
    tp += ni;
#line 3465
    *xpp = (void*)xp;
#line 3465
  }
#line 3465
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3465

#line 3465
#else   /* not SX */
#line 3465
	const char *xp = (const char *) *xpp;
#line 3465
	int status = NC_NOERR;
#line 3465

#line 3465
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3465
	{
#line 3465
		const int lstatus = ncx_get_ulonglong_int(xp, tp);
#line 3465
		if (status == NC_NOERR) /* report the first encountered error */
#line 3465
			status = lstatus;
#line 3465
	}
#line 3465

#line 3465
	*xpp = (const void *)xp;
#line 3465
	return status;
#line 3465
#endif
#line 3465
}
#line 3465

int
#line 3466
ncx_getn_ulonglong_long(const void **xpp, size_t nelems, long *tp)
#line 3466
{
#line 3466
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3466

#line 3466
 /* basic algorithm is:
#line 3466
  *   - ensure sane alignment of input data
#line 3466
  *   - copy (conversion happens automatically) input data
#line 3466
  *     to output
#line 3466
  *   - update xpp to point at next unconverted input, and tp to point
#line 3466
  *     at next location for converted output
#line 3466
  */
#line 3466
  long i, j, ni;
#line 3466
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3466
  uint64 *xp;
#line 3466
  int nrange = 0;         /* number of range errors */
#line 3466
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3466
  long cxp = (long) *((char**)xpp);
#line 3466

#line 3466
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3466
  /* sjl: manually stripmine so we can limit amount of
#line 3466
   * vector work space reserved to LOOPCNT elements. Also
#line 3466
   * makes vectorisation easy */
#line 3466
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3466
    ni=Min(nelems-j,LOOPCNT);
#line 3466
    if (realign) {
#line 3466
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3466
      xp = tmp;
#line 3466
    } else {
#line 3466
      xp = (uint64 *) *xpp;
#line 3466
    }
#line 3466
   /* copy the next block */
#line 3466
#pragma cdir loopcnt=LOOPCNT
#line 3466
#pragma cdir shortloop
#line 3466
    for (i=0; i<ni; i++) {
#line 3466
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3466
     /* test for range errors (not always needed but do it anyway) */
#line 3466
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3466
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3466
      nrange += xp[i] > LONG_MAX ;
#line 3466
    }
#line 3466
   /* update xpp and tp */
#line 3466
    if (realign) xp = (uint64 *) *xpp;
#line 3466
    xp += ni;
#line 3466
    tp += ni;
#line 3466
    *xpp = (void*)xp;
#line 3466
  }
#line 3466
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3466

#line 3466
#else   /* not SX */
#line 3466
	const char *xp = (const char *) *xpp;
#line 3466
	int status = NC_NOERR;
#line 3466

#line 3466
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3466
	{
#line 3466
		const int lstatus = ncx_get_ulonglong_long(xp, tp);
#line 3466
		if (status == NC_NOERR) /* report the first encountered error */
#line 3466
			status = lstatus;
#line 3466
	}
#line 3466

#line 3466
	*xpp = (const void *)xp;
#line 3466
	return status;
#line 3466
#endif
#line 3466
}
#line 3466

int
#line 3467
ncx_getn_ulonglong_float(const void **xpp, size_t nelems, float *tp)
#line 3467
{
#line 3467
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3467

#line 3467
 /* basic algorithm is:
#line 3467
  *   - ensure sane alignment of input data
#line 3467
  *   - copy (conversion happens automatically) input data
#line 3467
  *     to output
#line 3467
  *   - update xpp to point at next unconverted input, and tp to point
#line 3467
  *     at next location for converted output
#line 3467
  */
#line 3467
  long i, j, ni;
#line 3467
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3467
  uint64 *xp;
#line 3467
  int nrange = 0;         /* number of range errors */
#line 3467
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3467
  long cxp = (long) *((char**)xpp);
#line 3467

#line 3467
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3467
  /* sjl: manually stripmine so we can limit amount of
#line 3467
   * vector work space reserved to LOOPCNT elements. Also
#line 3467
   * makes vectorisation easy */
#line 3467
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3467
    ni=Min(nelems-j,LOOPCNT);
#line 3467
    if (realign) {
#line 3467
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3467
      xp = tmp;
#line 3467
    } else {
#line 3467
      xp = (uint64 *) *xpp;
#line 3467
    }
#line 3467
   /* copy the next block */
#line 3467
#pragma cdir loopcnt=LOOPCNT
#line 3467
#pragma cdir shortloop
#line 3467
    for (i=0; i<ni; i++) {
#line 3467
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3467
     /* test for range errors (not always needed but do it anyway) */
#line 3467
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3467
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3467
      nrange += xp[i] > FLOAT_MAX ;
#line 3467
    }
#line 3467
   /* update xpp and tp */
#line 3467
    if (realign) xp = (uint64 *) *xpp;
#line 3467
    xp += ni;
#line 3467
    tp += ni;
#line 3467
    *xpp = (void*)xp;
#line 3467
  }
#line 3467
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3467

#line 3467
#else   /* not SX */
#line 3467
	const char *xp = (const char *) *xpp;
#line 3467
	int status = NC_NOERR;
#line 3467

#line 3467
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3467
	{
#line 3467
		const int lstatus = ncx_get_ulonglong_float(xp, tp);
#line 3467
		if (status == NC_NOERR) /* report the first encountered error */
#line 3467
			status = lstatus;
#line 3467
	}
#line 3467

#line 3467
	*xpp = (const void *)xp;
#line 3467
	return status;
#line 3467
#endif
#line 3467
}
#line 3467

int
#line 3468
ncx_getn_ulonglong_double(const void **xpp, size_t nelems, double *tp)
#line 3468
{
#line 3468
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3468

#line 3468
 /* basic algorithm is:
#line 3468
  *   - ensure sane alignment of input data
#line 3468
  *   - copy (conversion happens automatically) input data
#line 3468
  *     to output
#line 3468
  *   - update xpp to point at next unconverted input, and tp to point
#line 3468
  *     at next location for converted output
#line 3468
  */
#line 3468
  long i, j, ni;
#line 3468
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3468
  uint64 *xp;
#line 3468
  int nrange = 0;         /* number of range errors */
#line 3468
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3468
  long cxp = (long) *((char**)xpp);
#line 3468

#line 3468
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3468
  /* sjl: manually stripmine so we can limit amount of
#line 3468
   * vector work space reserved to LOOPCNT elements. Also
#line 3468
   * makes vectorisation easy */
#line 3468
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3468
    ni=Min(nelems-j,LOOPCNT);
#line 3468
    if (realign) {
#line 3468
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3468
      xp = tmp;
#line 3468
    } else {
#line 3468
      xp = (uint64 *) *xpp;
#line 3468
    }
#line 3468
   /* copy the next block */
#line 3468
#pragma cdir loopcnt=LOOPCNT
#line 3468
#pragma cdir shortloop
#line 3468
    for (i=0; i<ni; i++) {
#line 3468
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3468
     /* test for range errors (not always needed but do it anyway) */
#line 3468
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3468
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3468
      nrange += xp[i] > DOUBLE_MAX ;
#line 3468
    }
#line 3468
   /* update xpp and tp */
#line 3468
    if (realign) xp = (uint64 *) *xpp;
#line 3468
    xp += ni;
#line 3468
    tp += ni;
#line 3468
    *xpp = (void*)xp;
#line 3468
  }
#line 3468
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3468

#line 3468
#else   /* not SX */
#line 3468
	const char *xp = (const char *) *xpp;
#line 3468
	int status = NC_NOERR;
#line 3468

#line 3468
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3468
	{
#line 3468
		const int lstatus = ncx_get_ulonglong_double(xp, tp);
#line 3468
		if (status == NC_NOERR) /* report the first encountered error */
#line 3468
			status = lstatus;
#line 3468
	}
#line 3468

#line 3468
	*xpp = (const void *)xp;
#line 3468
	return status;
#line 3468
#endif
#line 3468
}
#line 3468

int
#line 3469
ncx_getn_ulonglong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3469
{
#line 3469
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3469

#line 3469
 /* basic algorithm is:
#line 3469
  *   - ensure sane alignment of input data
#line 3469
  *   - copy (conversion happens automatically) input data
#line 3469
  *     to output
#line 3469
  *   - update xpp to point at next unconverted input, and tp to point
#line 3469
  *     at next location for converted output
#line 3469
  */
#line 3469
  long i, j, ni;
#line 3469
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3469
  uint64 *xp;
#line 3469
  int nrange = 0;         /* number of range errors */
#line 3469
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3469
  long cxp = (long) *((char**)xpp);
#line 3469

#line 3469
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3469
  /* sjl: manually stripmine so we can limit amount of
#line 3469
   * vector work space reserved to LOOPCNT elements. Also
#line 3469
   * makes vectorisation easy */
#line 3469
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3469
    ni=Min(nelems-j,LOOPCNT);
#line 3469
    if (realign) {
#line 3469
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3469
      xp = tmp;
#line 3469
    } else {
#line 3469
      xp = (uint64 *) *xpp;
#line 3469
    }
#line 3469
   /* copy the next block */
#line 3469
#pragma cdir loopcnt=LOOPCNT
#line 3469
#pragma cdir shortloop
#line 3469
    for (i=0; i<ni; i++) {
#line 3469
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3469
     /* test for range errors (not always needed but do it anyway) */
#line 3469
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3469
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3469
      nrange += xp[i] > LONGLONG_MAX ;
#line 3469
    }
#line 3469
   /* update xpp and tp */
#line 3469
    if (realign) xp = (uint64 *) *xpp;
#line 3469
    xp += ni;
#line 3469
    tp += ni;
#line 3469
    *xpp = (void*)xp;
#line 3469
  }
#line 3469
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3469

#line 3469
#else   /* not SX */
#line 3469
	const char *xp = (const char *) *xpp;
#line 3469
	int status = NC_NOERR;
#line 3469

#line 3469
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3469
	{
#line 3469
		const int lstatus = ncx_get_ulonglong_longlong(xp, tp);
#line 3469
		if (status == NC_NOERR) /* report the first encountered error */
#line 3469
			status = lstatus;
#line 3469
	}
#line 3469

#line 3469
	*xpp = (const void *)xp;
#line 3469
	return status;
#line 3469
#endif
#line 3469
}
#line 3469

int
#line 3470
ncx_getn_ulonglong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3470
{
#line 3470
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3470

#line 3470
 /* basic algorithm is:
#line 3470
  *   - ensure sane alignment of input data
#line 3470
  *   - copy (conversion happens automatically) input data
#line 3470
  *     to output
#line 3470
  *   - update xpp to point at next unconverted input, and tp to point
#line 3470
  *     at next location for converted output
#line 3470
  */
#line 3470
  long i, j, ni;
#line 3470
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3470
  uint64 *xp;
#line 3470
  int nrange = 0;         /* number of range errors */
#line 3470
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3470
  long cxp = (long) *((char**)xpp);
#line 3470

#line 3470
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3470
  /* sjl: manually stripmine so we can limit amount of
#line 3470
   * vector work space reserved to LOOPCNT elements. Also
#line 3470
   * makes vectorisation easy */
#line 3470
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3470
    ni=Min(nelems-j,LOOPCNT);
#line 3470
    if (realign) {
#line 3470
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3470
      xp = tmp;
#line 3470
    } else {
#line 3470
      xp = (uint64 *) *xpp;
#line 3470
    }
#line 3470
   /* copy the next block */
#line 3470
#pragma cdir loopcnt=LOOPCNT
#line 3470
#pragma cdir shortloop
#line 3470
    for (i=0; i<ni; i++) {
#line 3470
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3470
     /* test for range errors (not always needed but do it anyway) */
#line 3470
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3470
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3470
      nrange += xp[i] > UCHAR_MAX ;
#line 3470
    }
#line 3470
   /* update xpp and tp */
#line 3470
    if (realign) xp = (uint64 *) *xpp;
#line 3470
    xp += ni;
#line 3470
    tp += ni;
#line 3470
    *xpp = (void*)xp;
#line 3470
  }
#line 3470
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3470

#line 3470
#else   /* not SX */
#line 3470
	const char *xp = (const char *) *xpp;
#line 3470
	int status = NC_NOERR;
#line 3470

#line 3470
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3470
	{
#line 3470
		const int lstatus = ncx_get_ulonglong_uchar(xp, tp);
#line 3470
		if (status == NC_NOERR) /* report the first encountered error */
#line 3470
			status = lstatus;
#line 3470
	}
#line 3470

#line 3470
	*xpp = (const void *)xp;
#line 3470
	return status;
#line 3470
#endif
#line 3470
}
#line 3470

int
#line 3471
ncx_getn_ulonglong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3471
{
#line 3471
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3471

#line 3471
 /* basic algorithm is:
#line 3471
  *   - ensure sane alignment of input data
#line 3471
  *   - copy (conversion happens automatically) input data
#line 3471
  *     to output
#line 3471
  *   - update xpp to point at next unconverted input, and tp to point
#line 3471
  *     at next location for converted output
#line 3471
  */
#line 3471
  long i, j, ni;
#line 3471
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3471
  uint64 *xp;
#line 3471
  int nrange = 0;         /* number of range errors */
#line 3471
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3471
  long cxp = (long) *((char**)xpp);
#line 3471

#line 3471
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3471
  /* sjl: manually stripmine so we can limit amount of
#line 3471
   * vector work space reserved to LOOPCNT elements. Also
#line 3471
   * makes vectorisation easy */
#line 3471
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3471
    ni=Min(nelems-j,LOOPCNT);
#line 3471
    if (realign) {
#line 3471
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3471
      xp = tmp;
#line 3471
    } else {
#line 3471
      xp = (uint64 *) *xpp;
#line 3471
    }
#line 3471
   /* copy the next block */
#line 3471
#pragma cdir loopcnt=LOOPCNT
#line 3471
#pragma cdir shortloop
#line 3471
    for (i=0; i<ni; i++) {
#line 3471
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3471
     /* test for range errors (not always needed but do it anyway) */
#line 3471
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3471
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3471
      nrange += xp[i] > USHORT_MAX ;
#line 3471
    }
#line 3471
   /* update xpp and tp */
#line 3471
    if (realign) xp = (uint64 *) *xpp;
#line 3471
    xp += ni;
#line 3471
    tp += ni;
#line 3471
    *xpp = (void*)xp;
#line 3471
  }
#line 3471
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3471

#line 3471
#else   /* not SX */
#line 3471
	const char *xp = (const char *) *xpp;
#line 3471
	int status = NC_NOERR;
#line 3471

#line 3471
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3471
	{
#line 3471
		const int lstatus = ncx_get_ulonglong_ushort(xp, tp);
#line 3471
		if (status == NC_NOERR) /* report the first encountered error */
#line 3471
			status = lstatus;
#line 3471
	}
#line 3471

#line 3471
	*xpp = (const void *)xp;
#line 3471
	return status;
#line 3471
#endif
#line 3471
}
#line 3471

int
#line 3472
ncx_getn_ulonglong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3472
{
#line 3472
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3472

#line 3472
 /* basic algorithm is:
#line 3472
  *   - ensure sane alignment of input data
#line 3472
  *   - copy (conversion happens automatically) input data
#line 3472
  *     to output
#line 3472
  *   - update xpp to point at next unconverted input, and tp to point
#line 3472
  *     at next location for converted output
#line 3472
  */
#line 3472
  long i, j, ni;
#line 3472
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3472
  uint64 *xp;
#line 3472
  int nrange = 0;         /* number of range errors */
#line 3472
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3472
  long cxp = (long) *((char**)xpp);
#line 3472

#line 3472
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3472
  /* sjl: manually stripmine so we can limit amount of
#line 3472
   * vector work space reserved to LOOPCNT elements. Also
#line 3472
   * makes vectorisation easy */
#line 3472
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3472
    ni=Min(nelems-j,LOOPCNT);
#line 3472
    if (realign) {
#line 3472
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3472
      xp = tmp;
#line 3472
    } else {
#line 3472
      xp = (uint64 *) *xpp;
#line 3472
    }
#line 3472
   /* copy the next block */
#line 3472
#pragma cdir loopcnt=LOOPCNT
#line 3472
#pragma cdir shortloop
#line 3472
    for (i=0; i<ni; i++) {
#line 3472
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3472
     /* test for range errors (not always needed but do it anyway) */
#line 3472
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3472
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3472
      nrange += xp[i] > UINT_MAX ;
#line 3472
    }
#line 3472
   /* update xpp and tp */
#line 3472
    if (realign) xp = (uint64 *) *xpp;
#line 3472
    xp += ni;
#line 3472
    tp += ni;
#line 3472
    *xpp = (void*)xp;
#line 3472
  }
#line 3472
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3472

#line 3472
#else   /* not SX */
#line 3472
	const char *xp = (const char *) *xpp;
#line 3472
	int status = NC_NOERR;
#line 3472

#line 3472
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3472
	{
#line 3472
		const int lstatus = ncx_get_ulonglong_uint(xp, tp);
#line 3472
		if (status == NC_NOERR) /* report the first encountered error */
#line 3472
			status = lstatus;
#line 3472
	}
#line 3472

#line 3472
	*xpp = (const void *)xp;
#line 3472
	return status;
#line 3472
#endif
#line 3472
}
#line 3472


#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const unsigned long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3488
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3488
{
#line 3488
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3488

#line 3488
 /* basic algorithm is:
#line 3488
  *   - ensure sane alignment of output data
#line 3488
  *   - copy (conversion happens automatically) input data
#line 3488
  *     to output
#line 3488
  *   - update tp to point at next unconverted input, and xpp to point
#line 3488
  *     at next location for converted output
#line 3488
  */
#line 3488
  long i, j, ni;
#line 3488
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3488
  uint64 *xp;
#line 3488
  int nrange = 0;         /* number of range errors */
#line 3488
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3488
  long cxp = (long) *((char**)xpp);
#line 3488

#line 3488
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3488
  /* sjl: manually stripmine so we can limit amount of
#line 3488
   * vector work space reserved to LOOPCNT elements. Also
#line 3488
   * makes vectorisation easy */
#line 3488
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3488
    ni=Min(nelems-j,LOOPCNT);
#line 3488
    if (realign) {
#line 3488
      xp = tmp;
#line 3488
    } else {
#line 3488
      xp = (uint64 *) *xpp;
#line 3488
    }
#line 3488
   /* copy the next block */
#line 3488
#pragma cdir loopcnt=LOOPCNT
#line 3488
#pragma cdir shortloop
#line 3488
    for (i=0; i<ni; i++) {
#line 3488
      /* the normal case: */
#line 3488
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3488
     /* test for range errors (not always needed but do it anyway) */
#line 3488
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3488
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3488
      nrange += tp[i] > X_UINT64_MAX ;
#line 3488
    }
#line 3488
   /* copy workspace back if necessary */
#line 3488
    if (realign) {
#line 3488
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3488
      xp = (uint64 *) *xpp;
#line 3488
    }
#line 3488
   /* update xpp and tp */
#line 3488
    xp += ni;
#line 3488
    tp += ni;
#line 3488
    *xpp = (void*)xp;
#line 3488
  }
#line 3488
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3488

#line 3488
#else   /* not SX */
#line 3488

#line 3488
	char *xp = (char *) *xpp;
#line 3488
	int status = NC_NOERR;
#line 3488

#line 3488
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3488
	{
#line 3488
		int lstatus = ncx_put_ulonglong_ulonglong(xp, tp, fillp);
#line 3488
		if (status == NC_NOERR) /* report the first encountered error */
#line 3488
			status = lstatus;
#line 3488
	}
#line 3488

#line 3488
	*xpp = (void *)xp;
#line 3488
	return status;
#line 3488
#endif
#line 3488
}
#line 3488

#endif
int
#line 3490
ncx_putn_ulonglong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3490
{
#line 3490
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3490

#line 3490
 /* basic algorithm is:
#line 3490
  *   - ensure sane alignment of output data
#line 3490
  *   - copy (conversion happens automatically) input data
#line 3490
  *     to output
#line 3490
  *   - update tp to point at next unconverted input, and xpp to point
#line 3490
  *     at next location for converted output
#line 3490
  */
#line 3490
  long i, j, ni;
#line 3490
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3490
  uint64 *xp;
#line 3490
  int nrange = 0;         /* number of range errors */
#line 3490
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3490
  long cxp = (long) *((char**)xpp);
#line 3490

#line 3490
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3490
  /* sjl: manually stripmine so we can limit amount of
#line 3490
   * vector work space reserved to LOOPCNT elements. Also
#line 3490
   * makes vectorisation easy */
#line 3490
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3490
    ni=Min(nelems-j,LOOPCNT);
#line 3490
    if (realign) {
#line 3490
      xp = tmp;
#line 3490
    } else {
#line 3490
      xp = (uint64 *) *xpp;
#line 3490
    }
#line 3490
   /* copy the next block */
#line 3490
#pragma cdir loopcnt=LOOPCNT
#line 3490
#pragma cdir shortloop
#line 3490
    for (i=0; i<ni; i++) {
#line 3490
      /* the normal case: */
#line 3490
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3490
     /* test for range errors (not always needed but do it anyway) */
#line 3490
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3490
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3490
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3490
    }
#line 3490
   /* copy workspace back if necessary */
#line 3490
    if (realign) {
#line 3490
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3490
      xp = (uint64 *) *xpp;
#line 3490
    }
#line 3490
   /* update xpp and tp */
#line 3490
    xp += ni;
#line 3490
    tp += ni;
#line 3490
    *xpp = (void*)xp;
#line 3490
  }
#line 3490
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3490

#line 3490
#else   /* not SX */
#line 3490

#line 3490
	char *xp = (char *) *xpp;
#line 3490
	int status = NC_NOERR;
#line 3490

#line 3490
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3490
	{
#line 3490
		int lstatus = ncx_put_ulonglong_schar(xp, tp, fillp);
#line 3490
		if (status == NC_NOERR) /* report the first encountered error */
#line 3490
			status = lstatus;
#line 3490
	}
#line 3490

#line 3490
	*xpp = (void *)xp;
#line 3490
	return status;
#line 3490
#endif
#line 3490
}
#line 3490

int
#line 3491
ncx_putn_ulonglong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3491
{
#line 3491
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3491

#line 3491
 /* basic algorithm is:
#line 3491
  *   - ensure sane alignment of output data
#line 3491
  *   - copy (conversion happens automatically) input data
#line 3491
  *     to output
#line 3491
  *   - update tp to point at next unconverted input, and xpp to point
#line 3491
  *     at next location for converted output
#line 3491
  */
#line 3491
  long i, j, ni;
#line 3491
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3491
  uint64 *xp;
#line 3491
  int nrange = 0;         /* number of range errors */
#line 3491
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3491
  long cxp = (long) *((char**)xpp);
#line 3491

#line 3491
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3491
  /* sjl: manually stripmine so we can limit amount of
#line 3491
   * vector work space reserved to LOOPCNT elements. Also
#line 3491
   * makes vectorisation easy */
#line 3491
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3491
    ni=Min(nelems-j,LOOPCNT);
#line 3491
    if (realign) {
#line 3491
      xp = tmp;
#line 3491
    } else {
#line 3491
      xp = (uint64 *) *xpp;
#line 3491
    }
#line 3491
   /* copy the next block */
#line 3491
#pragma cdir loopcnt=LOOPCNT
#line 3491
#pragma cdir shortloop
#line 3491
    for (i=0; i<ni; i++) {
#line 3491
      /* the normal case: */
#line 3491
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3491
     /* test for range errors (not always needed but do it anyway) */
#line 3491
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3491
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3491
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3491
    }
#line 3491
   /* copy workspace back if necessary */
#line 3491
    if (realign) {
#line 3491
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3491
      xp = (uint64 *) *xpp;
#line 3491
    }
#line 3491
   /* update xpp and tp */
#line 3491
    xp += ni;
#line 3491
    tp += ni;
#line 3491
    *xpp = (void*)xp;
#line 3491
  }
#line 3491
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3491

#line 3491
#else   /* not SX */
#line 3491

#line 3491
	char *xp = (char *) *xpp;
#line 3491
	int status = NC_NOERR;
#line 3491

#line 3491
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3491
	{
#line 3491
		int lstatus = ncx_put_ulonglong_short(xp, tp, fillp);
#line 3491
		if (status == NC_NOERR) /* report the first encountered error */
#line 3491
			status = lstatus;
#line 3491
	}
#line 3491

#line 3491
	*xpp = (void *)xp;
#line 3491
	return status;
#line 3491
#endif
#line 3491
}
#line 3491

int
#line 3492
ncx_putn_ulonglong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3492
{
#line 3492
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3492

#line 3492
 /* basic algorithm is:
#line 3492
  *   - ensure sane alignment of output data
#line 3492
  *   - copy (conversion happens automatically) input data
#line 3492
  *     to output
#line 3492
  *   - update tp to point at next unconverted input, and xpp to point
#line 3492
  *     at next location for converted output
#line 3492
  */
#line 3492
  long i, j, ni;
#line 3492
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3492
  uint64 *xp;
#line 3492
  int nrange = 0;         /* number of range errors */
#line 3492
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3492
  long cxp = (long) *((char**)xpp);
#line 3492

#line 3492
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3492
  /* sjl: manually stripmine so we can limit amount of
#line 3492
   * vector work space reserved to LOOPCNT elements. Also
#line 3492
   * makes vectorisation easy */
#line 3492
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3492
    ni=Min(nelems-j,LOOPCNT);
#line 3492
    if (realign) {
#line 3492
      xp = tmp;
#line 3492
    } else {
#line 3492
      xp = (uint64 *) *xpp;
#line 3492
    }
#line 3492
   /* copy the next block */
#line 3492
#pragma cdir loopcnt=LOOPCNT
#line 3492
#pragma cdir shortloop
#line 3492
    for (i=0; i<ni; i++) {
#line 3492
      /* the normal case: */
#line 3492
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3492
     /* test for range errors (not always needed but do it anyway) */
#line 3492
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3492
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3492
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3492
    }
#line 3492
   /* copy workspace back if necessary */
#line 3492
    if (realign) {
#line 3492
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3492
      xp = (uint64 *) *xpp;
#line 3492
    }
#line 3492
   /* update xpp and tp */
#line 3492
    xp += ni;
#line 3492
    tp += ni;
#line 3492
    *xpp = (void*)xp;
#line 3492
  }
#line 3492
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3492

#line 3492
#else   /* not SX */
#line 3492

#line 3492
	char *xp = (char *) *xpp;
#line 3492
	int status = NC_NOERR;
#line 3492

#line 3492
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3492
	{
#line 3492
		int lstatus = ncx_put_ulonglong_int(xp, tp, fillp);
#line 3492
		if (status == NC_NOERR) /* report the first encountered error */
#line 3492
			status = lstatus;
#line 3492
	}
#line 3492

#line 3492
	*xpp = (void *)xp;
#line 3492
	return status;
#line 3492
#endif
#line 3492
}
#line 3492

int
#line 3493
ncx_putn_ulonglong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3493
{
#line 3493
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3493

#line 3493
 /* basic algorithm is:
#line 3493
  *   - ensure sane alignment of output data
#line 3493
  *   - copy (conversion happens automatically) input data
#line 3493
  *     to output
#line 3493
  *   - update tp to point at next unconverted input, and xpp to point
#line 3493
  *     at next location for converted output
#line 3493
  */
#line 3493
  long i, j, ni;
#line 3493
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3493
  uint64 *xp;
#line 3493
  int nrange = 0;         /* number of range errors */
#line 3493
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3493
  long cxp = (long) *((char**)xpp);
#line 3493

#line 3493
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3493
  /* sjl: manually stripmine so we can limit amount of
#line 3493
   * vector work space reserved to LOOPCNT elements. Also
#line 3493
   * makes vectorisation easy */
#line 3493
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3493
    ni=Min(nelems-j,LOOPCNT);
#line 3493
    if (realign) {
#line 3493
      xp = tmp;
#line 3493
    } else {
#line 3493
      xp = (uint64 *) *xpp;
#line 3493
    }
#line 3493
   /* copy the next block */
#line 3493
#pragma cdir loopcnt=LOOPCNT
#line 3493
#pragma cdir shortloop
#line 3493
    for (i=0; i<ni; i++) {
#line 3493
      /* the normal case: */
#line 3493
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3493
     /* test for range errors (not always needed but do it anyway) */
#line 3493
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3493
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3493
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3493
    }
#line 3493
   /* copy workspace back if necessary */
#line 3493
    if (realign) {
#line 3493
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3493
      xp = (uint64 *) *xpp;
#line 3493
    }
#line 3493
   /* update xpp and tp */
#line 3493
    xp += ni;
#line 3493
    tp += ni;
#line 3493
    *xpp = (void*)xp;
#line 3493
  }
#line 3493
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3493

#line 3493
#else   /* not SX */
#line 3493

#line 3493
	char *xp = (char *) *xpp;
#line 3493
	int status = NC_NOERR;
#line 3493

#line 3493
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3493
	{
#line 3493
		int lstatus = ncx_put_ulonglong_long(xp, tp, fillp);
#line 3493
		if (status == NC_NOERR) /* report the first encountered error */
#line 3493
			status = lstatus;
#line 3493
	}
#line 3493

#line 3493
	*xpp = (void *)xp;
#line 3493
	return status;
#line 3493
#endif
#line 3493
}
#line 3493

int
#line 3494
ncx_putn_ulonglong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3494
{
#line 3494
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3494

#line 3494
 /* basic algorithm is:
#line 3494
  *   - ensure sane alignment of output data
#line 3494
  *   - copy (conversion happens automatically) input data
#line 3494
  *     to output
#line 3494
  *   - update tp to point at next unconverted input, and xpp to point
#line 3494
  *     at next location for converted output
#line 3494
  */
#line 3494
  long i, j, ni;
#line 3494
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3494
  uint64 *xp;
#line 3494
  int nrange = 0;         /* number of range errors */
#line 3494
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3494
  long cxp = (long) *((char**)xpp);
#line 3494

#line 3494
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3494
  /* sjl: manually stripmine so we can limit amount of
#line 3494
   * vector work space reserved to LOOPCNT elements. Also
#line 3494
   * makes vectorisation easy */
#line 3494
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3494
    ni=Min(nelems-j,LOOPCNT);
#line 3494
    if (realign) {
#line 3494
      xp = tmp;
#line 3494
    } else {
#line 3494
      xp = (uint64 *) *xpp;
#line 3494
    }
#line 3494
   /* copy the next block */
#line 3494
#pragma cdir loopcnt=LOOPCNT
#line 3494
#pragma cdir shortloop
#line 3494
    for (i=0; i<ni; i++) {
#line 3494
      /* the normal case: */
#line 3494
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3494
     /* test for range errors (not always needed but do it anyway) */
#line 3494
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3494
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3494
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3494
    }
#line 3494
   /* copy workspace back if necessary */
#line 3494
    if (realign) {
#line 3494
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3494
      xp = (uint64 *) *xpp;
#line 3494
    }
#line 3494
   /* update xpp and tp */
#line 3494
    xp += ni;
#line 3494
    tp += ni;
#line 3494
    *xpp = (void*)xp;
#line 3494
  }
#line 3494
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3494

#line 3494
#else   /* not SX */
#line 3494

#line 3494
	char *xp = (char *) *xpp;
#line 3494
	int status = NC_NOERR;
#line 3494

#line 3494
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3494
	{
#line 3494
		int lstatus = ncx_put_ulonglong_float(xp, tp, fillp);
#line 3494
		if (status == NC_NOERR) /* report the first encountered error */
#line 3494
			status = lstatus;
#line 3494
	}
#line 3494

#line 3494
	*xpp = (void *)xp;
#line 3494
	return status;
#line 3494
#endif
#line 3494
}
#line 3494

int
#line 3495
ncx_putn_ulonglong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3495
{
#line 3495
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3495

#line 3495
 /* basic algorithm is:
#line 3495
  *   - ensure sane alignment of output data
#line 3495
  *   - copy (conversion happens automatically) input data
#line 3495
  *     to output
#line 3495
  *   - update tp to point at next unconverted input, and xpp to point
#line 3495
  *     at next location for converted output
#line 3495
  */
#line 3495
  long i, j, ni;
#line 3495
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3495
  uint64 *xp;
#line 3495
  int nrange = 0;         /* number of range errors */
#line 3495
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3495
  long cxp = (long) *((char**)xpp);
#line 3495

#line 3495
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3495
  /* sjl: manually stripmine so we can limit amount of
#line 3495
   * vector work space reserved to LOOPCNT elements. Also
#line 3495
   * makes vectorisation easy */
#line 3495
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3495
    ni=Min(nelems-j,LOOPCNT);
#line 3495
    if (realign) {
#line 3495
      xp = tmp;
#line 3495
    } else {
#line 3495
      xp = (uint64 *) *xpp;
#line 3495
    }
#line 3495
   /* copy the next block */
#line 3495
#pragma cdir loopcnt=LOOPCNT
#line 3495
#pragma cdir shortloop
#line 3495
    for (i=0; i<ni; i++) {
#line 3495
      /* the normal case: */
#line 3495
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3495
     /* test for range errors (not always needed but do it anyway) */
#line 3495
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3495
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3495
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3495
    }
#line 3495
   /* copy workspace back if necessary */
#line 3495
    if (realign) {
#line 3495
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3495
      xp = (uint64 *) *xpp;
#line 3495
    }
#line 3495
   /* update xpp and tp */
#line 3495
    xp += ni;
#line 3495
    tp += ni;
#line 3495
    *xpp = (void*)xp;
#line 3495
  }
#line 3495
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3495

#line 3495
#else   /* not SX */
#line 3495

#line 3495
	char *xp = (char *) *xpp;
#line 3495
	int status = NC_NOERR;
#line 3495

#line 3495
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3495
	{
#line 3495
		int lstatus = ncx_put_ulonglong_double(xp, tp, fillp);
#line 3495
		if (status == NC_NOERR) /* report the first encountered error */
#line 3495
			status = lstatus;
#line 3495
	}
#line 3495

#line 3495
	*xpp = (void *)xp;
#line 3495
	return status;
#line 3495
#endif
#line 3495
}
#line 3495

int
#line 3496
ncx_putn_ulonglong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3496
{
#line 3496
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3496

#line 3496
 /* basic algorithm is:
#line 3496
  *   - ensure sane alignment of output data
#line 3496
  *   - copy (conversion happens automatically) input data
#line 3496
  *     to output
#line 3496
  *   - update tp to point at next unconverted input, and xpp to point
#line 3496
  *     at next location for converted output
#line 3496
  */
#line 3496
  long i, j, ni;
#line 3496
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3496
  uint64 *xp;
#line 3496
  int nrange = 0;         /* number of range errors */
#line 3496
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3496
  long cxp = (long) *((char**)xpp);
#line 3496

#line 3496
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3496
  /* sjl: manually stripmine so we can limit amount of
#line 3496
   * vector work space reserved to LOOPCNT elements. Also
#line 3496
   * makes vectorisation easy */
#line 3496
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3496
    ni=Min(nelems-j,LOOPCNT);
#line 3496
    if (realign) {
#line 3496
      xp = tmp;
#line 3496
    } else {
#line 3496
      xp = (uint64 *) *xpp;
#line 3496
    }
#line 3496
   /* copy the next block */
#line 3496
#pragma cdir loopcnt=LOOPCNT
#line 3496
#pragma cdir shortloop
#line 3496
    for (i=0; i<ni; i++) {
#line 3496
      /* the normal case: */
#line 3496
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3496
     /* test for range errors (not always needed but do it anyway) */
#line 3496
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3496
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3496
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3496
    }
#line 3496
   /* copy workspace back if necessary */
#line 3496
    if (realign) {
#line 3496
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3496
      xp = (uint64 *) *xpp;
#line 3496
    }
#line 3496
   /* update xpp and tp */
#line 3496
    xp += ni;
#line 3496
    tp += ni;
#line 3496
    *xpp = (void*)xp;
#line 3496
  }
#line 3496
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3496

#line 3496
#else   /* not SX */
#line 3496

#line 3496
	char *xp = (char *) *xpp;
#line 3496
	int status = NC_NOERR;
#line 3496

#line 3496
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3496
	{
#line 3496
		int lstatus = ncx_put_ulonglong_longlong(xp, tp, fillp);
#line 3496
		if (status == NC_NOERR) /* report the first encountered error */
#line 3496
			status = lstatus;
#line 3496
	}
#line 3496

#line 3496
	*xpp = (void *)xp;
#line 3496
	return status;
#line 3496
#endif
#line 3496
}
#line 3496

int
#line 3497
ncx_putn_ulonglong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3497
{
#line 3497
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3497

#line 3497
 /* basic algorithm is:
#line 3497
  *   - ensure sane alignment of output data
#line 3497
  *   - copy (conversion happens automatically) input data
#line 3497
  *     to output
#line 3497
  *   - update tp to point at next unconverted input, and xpp to point
#line 3497
  *     at next location for converted output
#line 3497
  */
#line 3497
  long i, j, ni;
#line 3497
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3497
  uint64 *xp;
#line 3497
  int nrange = 0;         /* number of range errors */
#line 3497
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3497
  long cxp = (long) *((char**)xpp);
#line 3497

#line 3497
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3497
  /* sjl: manually stripmine so we can limit amount of
#line 3497
   * vector work space reserved to LOOPCNT elements. Also
#line 3497
   * makes vectorisation easy */
#line 3497
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3497
    ni=Min(nelems-j,LOOPCNT);
#line 3497
    if (realign) {
#line 3497
      xp = tmp;
#line 3497
    } else {
#line 3497
      xp = (uint64 *) *xpp;
#line 3497
    }
#line 3497
   /* copy the next block */
#line 3497
#pragma cdir loopcnt=LOOPCNT
#line 3497
#pragma cdir shortloop
#line 3497
    for (i=0; i<ni; i++) {
#line 3497
      /* the normal case: */
#line 3497
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3497
     /* test for range errors (not always needed but do it anyway) */
#line 3497
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3497
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3497
      nrange += tp[i] > X_UINT64_MAX ;
#line 3497
    }
#line 3497
   /* copy workspace back if necessary */
#line 3497
    if (realign) {
#line 3497
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3497
      xp = (uint64 *) *xpp;
#line 3497
    }
#line 3497
   /* update xpp and tp */
#line 3497
    xp += ni;
#line 3497
    tp += ni;
#line 3497
    *xpp = (void*)xp;
#line 3497
  }
#line 3497
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3497

#line 3497
#else   /* not SX */
#line 3497

#line 3497
	char *xp = (char *) *xpp;
#line 3497
	int status = NC_NOERR;
#line 3497

#line 3497
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3497
	{
#line 3497
		int lstatus = ncx_put_ulonglong_uchar(xp, tp, fillp);
#line 3497
		if (status == NC_NOERR) /* report the first encountered error */
#line 3497
			status = lstatus;
#line 3497
	}
#line 3497

#line 3497
	*xpp = (void *)xp;
#line 3497
	return status;
#line 3497
#endif
#line 3497
}
#line 3497

int
#line 3498
ncx_putn_ulonglong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3498
{
#line 3498
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3498

#line 3498
 /* basic algorithm is:
#line 3498
  *   - ensure sane alignment of output data
#line 3498
  *   - copy (conversion happens automatically) input data
#line 3498
  *     to output
#line 3498
  *   - update tp to point at next unconverted input, and xpp to point
#line 3498
  *     at next location for converted output
#line 3498
  */
#line 3498
  long i, j, ni;
#line 3498
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3498
  uint64 *xp;
#line 3498
  int nrange = 0;         /* number of range errors */
#line 3498
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3498
  long cxp = (long) *((char**)xpp);
#line 3498

#line 3498
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3498
  /* sjl: manually stripmine so we can limit amount of
#line 3498
   * vector work space reserved to LOOPCNT elements. Also
#line 3498
   * makes vectorisation easy */
#line 3498
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3498
    ni=Min(nelems-j,LOOPCNT);
#line 3498
    if (realign) {
#line 3498
      xp = tmp;
#line 3498
    } else {
#line 3498
      xp = (uint64 *) *xpp;
#line 3498
    }
#line 3498
   /* copy the next block */
#line 3498
#pragma cdir loopcnt=LOOPCNT
#line 3498
#pragma cdir shortloop
#line 3498
    for (i=0; i<ni; i++) {
#line 3498
      /* the normal case: */
#line 3498
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3498
     /* test for range errors (not always needed but do it anyway) */
#line 3498
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3498
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3498
      nrange += tp[i] > X_UINT64_MAX ;
#line 3498
    }
#line 3498
   /* copy workspace back if necessary */
#line 3498
    if (realign) {
#line 3498
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3498
      xp = (uint64 *) *xpp;
#line 3498
    }
#line 3498
   /* update xpp and tp */
#line 3498
    xp += ni;
#line 3498
    tp += ni;
#line 3498
    *xpp = (void*)xp;
#line 3498
  }
#line 3498
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3498

#line 3498
#else   /* not SX */
#line 3498

#line 3498
	char *xp = (char *) *xpp;
#line 3498
	int status = NC_NOERR;
#line 3498

#line 3498
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3498
	{
#line 3498
		int lstatus = ncx_put_ulonglong_ushort(xp, tp, fillp);
#line 3498
		if (status == NC_NOERR) /* report the first encountered error */
#line 3498
			status = lstatus;
#line 3498
	}
#line 3498

#line 3498
	*xpp = (void *)xp;
#line 3498
	return status;
#line 3498
#endif
#line 3498
}
#line 3498

int
#line 3499
ncx_putn_ulonglong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3499
{
#line 3499
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3499

#line 3499
 /* basic algorithm is:
#line 3499
  *   - ensure sane alignment of output data
#line 3499
  *   - copy (conversion happens automatically) input data
#line 3499
  *     to output
#line 3499
  *   - update tp to point at next unconverted input, and xpp to point
#line 3499
  *     at next location for converted output
#line 3499
  */
#line 3499
  long i, j, ni;
#line 3499
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3499
  uint64 *xp;
#line 3499
  int nrange = 0;         /* number of range errors */
#line 3499
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3499
  long cxp = (long) *((char**)xpp);
#line 3499

#line 3499
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3499
  /* sjl: manually stripmine so we can limit amount of
#line 3499
   * vector work space reserved to LOOPCNT elements. Also
#line 3499
   * makes vectorisation easy */
#line 3499
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3499
    ni=Min(nelems-j,LOOPCNT);
#line 3499
    if (realign) {
#line 3499
      xp = tmp;
#line 3499
    } else {
#line 3499
      xp = (uint64 *) *xpp;
#line 3499
    }
#line 3499
   /* copy the next block */
#line 3499
#pragma cdir loopcnt=LOOPCNT
#line 3499
#pragma cdir shortloop
#line 3499
    for (i=0; i<ni; i++) {
#line 3499
      /* the normal case: */
#line 3499
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3499
     /* test for range errors (not always needed but do it anyway) */
#line 3499
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3499
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3499
      nrange += tp[i] > X_UINT64_MAX ;
#line 3499
    }
#line 3499
   /* copy workspace back if necessary */
#line 3499
    if (realign) {
#line 3499
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3499
      xp = (uint64 *) *xpp;
#line 3499
    }
#line 3499
   /* update xpp and tp */
#line 3499
    xp += ni;
#line 3499
    tp += ni;
#line 3499
    *xpp = (void*)xp;
#line 3499
  }
#line 3499
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3499

#line 3499
#else   /* not SX */
#line 3499

#line 3499
	char *xp = (char *) *xpp;
#line 3499
	int status = NC_NOERR;
#line 3499

#line 3499
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3499
	{
#line 3499
		int lstatus = ncx_put_ulonglong_uint(xp, tp, fillp);
#line 3499
		if (status == NC_NOERR) /* report the first encountered error */
#line 3499
			status = lstatus;
#line 3499
	}
#line 3499

#line 3499
	*xpp = (void *)xp;
#line 3499
	return status;
#line 3499
#endif
#line 3499
}
#line 3499



/*
 * Other aggregate conversion functions.
 */

/* text */

int
ncx_getn_text(const void **xpp, size_t nelems, char *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3511
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3511
	return NC_NOERR;
#line 3511

}

int
ncx_pad_getn_text(const void **xpp, size_t nelems, char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3517

#line 3517
	if (rndup)
#line 3517
		rndup = X_ALIGN - rndup;
#line 3517

#line 3517
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3517
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3517

#line 3517
	return NC_NOERR;
#line 3517

}

int
ncx_putn_text(void **xpp, size_t nelems, const char *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3523
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3523

#line 3523
	return NC_NOERR;
#line 3523

}

int
ncx_pad_putn_text(void **xpp, size_t nelems, const char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3529

#line 3529
	if (rndup)
#line 3529
		rndup = X_ALIGN - rndup;
#line 3529

#line 3529
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3529
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3529

#line 3529
	if (rndup)
#line 3529
	{
#line 3529
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3529
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3529
	}
#line 3529

#line 3529
	return NC_NOERR;
#line 3529

}


/* opaque */

int
ncx_getn_void(const void **xpp, size_t nelems, void *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3538
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3538
	return NC_NOERR;
#line 3538

}

int
ncx_pad_getn_void(const void **xpp, size_t nelems, void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3544

#line 3544
	if (rndup)
#line 3544
		rndup = X_ALIGN - rndup;
#line 3544

#line 3544
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3544
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3544

#line 3544
	return NC_NOERR;
#line 3544

}

int
ncx_putn_void(void **xpp, size_t nelems, const void *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3550
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3550

#line 3550
	return NC_NOERR;
#line 3550

}

int
ncx_pad_putn_void(void **xpp, size_t nelems, const void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3556

#line 3556
	if (rndup)
#line 3556
		rndup = X_ALIGN - rndup;
#line 3556

#line 3556
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3556
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3556

#line 3556
	if (rndup)
#line 3556
	{
#line 3556
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3556
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3556
	}
#line 3556

#line 3556
	return NC_NOERR;
#line 3556

}
