#ifndef _PDU_GRE_H
#define _PDU_GRE_H  1

/* pdu-gre.h
 
   Function prototypes and variables used by the builder of GRE PDUs.

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define ETH_P_IPX 0x8137 /* IPX over DIX */

struct gre_header {
#ifdef WORDS_BIGENDIAN
    unsigned do_cksum:1;
    unsigned reserved1:7;
    unsigned reserved2:5;
    unsigned version:3;
#else
    unsigned reserved1:7;
    unsigned do_cksum:1;
    unsigned version:3;
    unsigned reserved2:5;
#endif
    uint16_t protocol;
};

struct gre_cksum {
    uint16_t cksum;
    uint16_t reserved;
};

struct grehdr_options {
    int do_cksum;
    numspec_t *protocol;
};

#endif
