/*
 * This file is part of Hubbub.
 * Licensed under the MIT License,
 *                http://www.opensource.org/licenses/mit-license.php
 * Copyright 2021 Michael Drake <tlsa@netsurf-browser.org>
 */

#include "treebuilder/element-type.h"

/* Auto-generated by `gperf`. */
#include "treebuilder/autogenerated-element-type.c"

/* Exported function, documented in element-type.h */
element_type element_type_from_name(
		hubbub_treebuilder *treebuilder,
		const hubbub_string *tag_name)
{
	const struct element_type_map *value;

	UNUSED(treebuilder);

	value = hubbub_element_type_generated_lookup(
			(const char *)tag_name->ptr,
			tag_name->len);
	if (value == NULL) {
		return UNKNOWN;
	}

	return value->type;
}

/**
 * Convert an element type to a name
 *
 * \param type  The element type
 * \return Pointer to name
 */
const char *element_type_to_name(element_type type)
{
	size_t i;

	for (i = 0; i < sizeof(wordlist) / sizeof(wordlist[0]); i++) {
		if (wordlist[i].type == type) {
			return wordlist[i].name;
		}
	}

	return "UNKNOWN";
}
