export var defaultRelativeTime = {
    future : 'in %s',
    past   : '%s ago',
    s  : 'a few seconds',
    m  : 'a minute',
    mm : '%d minutes',
    h  : 'an hour',
    hh : '%d hours',
    d  : 'a day',
    dd : '%d days',
    M  : 'a month',
    MM : '%d months',
    y  : 'a year',
    yy : '%d years'
};

export function relativeTime (number, withoutSuffix, string, isFuture) {
    var output = this._relativeTime[string];
    return (typeof output === 'function') ?
        output(number, withoutSuffix, string, isFuture) :
        output.replace(/%d/i, number);
}

export function pastFuture (diff, output) {
    var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
    return typeof format === 'function' ? format(output) : format.replace(/%s/i, output);
}
