var actual = fn("!**/a/*/b/c/.js");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/a\/(?!\.)(?=.)[^/]*?\/b\/c\/\.js)$).*$/);

var actual = fn("!**/a/*/b/c.d/.js");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/a\/(?!\.)(?=.)[^/]*?\/b\/c\.d\/\.js)$).*$/);

var actual = fn("!**/*.{*,gitignore}");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.[^/]*?|(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.gitignore)$).*$/);

var actual = fn("!**/*.{js,gitignore}");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.gitignore)$).*$/);

var actual = fn("!**/{a,/.gitignore}");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/a|(?:(?!(?:\/|^)\.).)*?\/\.gitignore)$).*$/);

var actual = fn("!**/{a..z..2}/*.js");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/a\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/c\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/e\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/g\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/i\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/k\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/m\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/o\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/q\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/s\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/u\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/w\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/y\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!**/{a..c}/*.js");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/a\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/b\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/c\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!**/{1..10}/*.js");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/1\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/2\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/3\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/4\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/5\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/6\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/7\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/8\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/9\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/10\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!**/{1..10..2}/*.js");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/1\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/3\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/5\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/7\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/9\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!a/{b..s}/xyz/*-{01..10}.js");
actual.should.eql(/^(?!^(?:a\/b\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/b\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/b\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/b\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/b\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/b\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/b\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/b\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/b\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/b\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/c\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/c\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/c\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/c\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/c\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/c\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/c\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/c\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/c\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/c\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/d\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/d\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/d\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/d\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/d\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/d\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/d\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/d\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/d\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/d\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/e\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/e\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/e\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/e\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/e\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/e\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/e\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/e\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/e\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/e\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/f\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/f\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/f\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/f\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/f\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/f\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/f\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/f\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/f\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/f\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/g\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/g\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/g\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/g\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/g\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/g\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/g\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/g\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/g\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/g\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/h\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/h\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/h\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/h\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/h\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/h\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/h\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/h\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/h\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/h\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/i\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/i\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/i\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/i\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/i\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/i\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/i\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/i\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/i\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/i\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/j\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/j\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/j\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/j\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/j\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/j\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/j\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/j\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/j\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/j\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/k\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/k\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/k\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/k\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/k\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/k\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/k\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/k\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/k\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/k\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/l\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/l\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/l\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/l\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/l\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/l\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/l\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/l\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/l\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/l\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/m\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/m\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/m\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/m\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/m\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/m\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/m\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/m\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/m\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/m\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/n\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/n\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/n\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/n\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/n\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/n\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/n\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/n\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/n\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/n\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/o\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/o\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/o\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/o\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/o\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/o\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/o\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/o\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/o\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/o\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/p\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/p\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/p\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/p\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/p\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/p\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/p\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/p\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/p\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/p\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/q\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/q\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/q\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/q\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/q\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/q\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/q\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/q\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/q\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/q\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/r\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/r\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/r\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/r\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/r\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/r\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/r\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/r\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/r\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/r\/xyz\/(?!\.)(?=.)[^/]*?-10\.js|a\/s\/xyz\/(?!\.)(?=.)[^/]*?-01\.js|a\/s\/xyz\/(?!\.)(?=.)[^/]*?-02\.js|a\/s\/xyz\/(?!\.)(?=.)[^/]*?-03\.js|a\/s\/xyz\/(?!\.)(?=.)[^/]*?-04\.js|a\/s\/xyz\/(?!\.)(?=.)[^/]*?-05\.js|a\/s\/xyz\/(?!\.)(?=.)[^/]*?-06\.js|a\/s\/xyz\/(?!\.)(?=.)[^/]*?-07\.js|a\/s\/xyz\/(?!\.)(?=.)[^/]*?-08\.js|a\/s\/xyz\/(?!\.)(?=.)[^/]*?-09\.js|a\/s\/xyz\/(?!\.)(?=.)[^/]*?-10\.js)$).*$/);

var actual = fn("!a");
actual.should.eql(/^(?!^(?:a)$).*$/);

var actual = fn("!a/");
actual.should.eql(/^(?!^(?:a\/)$).*$/);

var actual = fn("!a/*");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?)$).*$/);

var actual = fn("!.*");
actual.should.eql(/^(?!^(?:(?=.)\.[^/]*?)$).*$/);

var actual = fn("!**/**/.*");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?:(?!(?:\/|^)\.).)*?\/(?=.)\.[^/]*?)$).*$/);

var actual = fn("!**/**/.*");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?:(?!(?:\/|^)\.).)*?\/(?=.)\.[^/]*?)$).*$/);

var actual = fn("!**/.*/.*");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?=.)\.[^/]*?\/(?=.)\.[^/]*?)$).*$/);

var actual = fn("!**/.*");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?=.)\.[^/]*?)$).*$/);

var actual = fn("!**/*.*");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.[^/]*?)$).*$/);

var actual = fn("!**/*.");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.)$).*$/);

var actual = fn("!**/*.a");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.a)$).*$/);

var actual = fn("!**/*.js");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!**/*.md");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!**/.*");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?=.)\.[^/]*?)$).*$/);

var actual = fn("!**/.*.js");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?=.)\.[^/]*?\.js)$).*$/);

var actual = fn("!**/.*.md");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?=.)\.[^/]*?\.md)$).*$/);

var actual = fn("!**/.a");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/\.a)$).*$/);

var actual = fn("!**/.a.js");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/\.a\.js)$).*$/);

var actual = fn("!**/.gitignore");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/\.gitignore)$).*$/);

var actual = fn("!*.*");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\.[^/]*?)$).*$/);

var actual = fn("!*.a");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\.a)$).*$/);

var actual = fn("!*.gitignore");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\.gitignore)$).*$/);

var actual = fn("!*.{gitignore,*}");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\.gitignore|(?!\.)(?=.)[^/]*?\.[^/]*?)$).*$/);

var actual = fn("!*.{*,gitignore,js}");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\.[^/]*?|(?!\.)(?=.)[^/]*?\.gitignore|(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!*.{*,gitignore}");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\.[^/]*?|(?!\.)(?=.)[^/]*?\.gitignore)$).*$/);

var actual = fn("!.{*,gitignore}");
actual.should.eql(/^(?!^(?:(?=.)\.[^/]*?|\.gitignore)$).*$/);

var actual = fn("!**/.{*,gitignore}");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?=.)\.[^/]*?|(?:(?!(?:\/|^)\.).)*?\/\.gitignore)$).*$/);

var actual = fn("!**/.{js,gitignore}");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/\.js|(?:(?!(?:\/|^)\.).)*?\/\.gitignore)$).*$/);

var actual = fn("!**/.{js,md}");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/\.js|(?:(?!(?:\/|^)\.).)*?\/\.md)$).*$/);

var actual = fn("!**/*.{js,md}");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!**/(a|b)/*.{js,md}");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/\(a\|b\)\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/\(a\|b\)\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!**/[a-z]/*.{js,md}");
actual.should.eql(/^(?!^(?:(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[a-z]\/(?!\.)(?=.)[^/]*?\.js|(?:(?!(?:\/|^)\.).)*?\/(?!\.)(?=.)[a-z]\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!*.js");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!*.md");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!*.{js,txt}");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\.js|(?!\.)(?=.)[^/]*?\.txt)$).*$/);

var actual = fn("!*/*.gitignore");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\/(?!\.)(?=.)[^/]*?\.gitignore)$).*$/);

var actual = fn("!*/.gitignore");
actual.should.eql(/^(?!^(?:(?!\.)(?=.)[^/]*?\/\.gitignore)$).*$/);

var actual = fn("!.a");
actual.should.eql(/^(?!^(?:\.a)$).*$/);

var actual = fn("!.gitignore");
actual.should.eql(/^(?!^(?:\.gitignore)$).*$/);

var actual = fn("!.js");
actual.should.eql(/^(?!^(?:\.js)$).*$/);

var actual = fn("!.md");
actual.should.eql(/^(?!^(?:\.md)$).*$/);

var actual = fn("!a/**/c/*.js");
actual.should.eql(/^(?!^(?:a\/(?:(?!(?:\/|^)\.).)*?\/c\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!a/**/c/*.md");
actual.should.eql(/^(?!^(?:a\/(?:(?!(?:\/|^)\.).)*?\/c\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!a/**/j/**/z/*.js");
actual.should.eql(/^(?!^(?:a\/(?:(?!(?:\/|^)\.).)*?\/j\/(?:(?!(?:\/|^)\.).)*?\/z\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!a/**/j/**/z/*.md");
actual.should.eql(/^(?!^(?:a\/(?:(?!(?:\/|^)\.).)*?\/j\/(?:(?!(?:\/|^)\.).)*?\/z\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!a/**/z/*.js");
actual.should.eql(/^(?!^(?:a\/(?:(?!(?:\/|^)\.).)*?\/z\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!a/**/z/*.md");
actual.should.eql(/^(?!^(?:a\/(?:(?!(?:\/|^)\.).)*?\/z\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!a/*.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!a/*.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!a/*.txt");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?\.txt)$).*$/);

var actual = fn("!a/*/.b");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?\/\.b)$).*$/);

var actual = fn("!a/*/.b.a");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?\/\.b\.a)$).*$/);

var actual = fn("!a/*/?/**/e.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?\/(?!\.)(?=.)[^/]\/(?:(?!(?:\/|^)\.).)*?\/e\.js)$).*$/);

var actual = fn("!a/*/?/**/e.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?\/(?!\.)(?=.)[^/]\/(?:(?!(?:\/|^)\.).)*?\/e\.md)$).*$/);

var actual = fn("!a/*/b");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?\/b)$).*$/);

var actual = fn("!a/*/c/*.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?\/c\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!a/*/c/*.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]*?\/c\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!a/.*/b");
actual.should.eql(/^(?!^(?:a\/(?=.)\.[^/]*?\/b)$).*$/);

var actual = fn("!a/?/**/e.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]\/(?:(?!(?:\/|^)\.).)*?\/e\.js)$).*$/);

var actual = fn("!a/?/**/e.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]\/(?:(?!(?:\/|^)\.).)*?\/e\.md)$).*$/);

var actual = fn("!a/?/c.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]\/c\.js)$).*$/);

var actual = fn("!a/?/c.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]\/c\.md)$).*$/);

var actual = fn("!a/?/c/?/*/e.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]\/c\/(?!\.)(?=.)[^/]\/(?!\.)(?=.)[^/]*?\/e\.js)$).*$/);

var actual = fn("!a/?/c/?/*/e.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]\/c\/(?!\.)(?=.)[^/]\/(?!\.)(?=.)[^/]*?\/e\.md)$).*$/);

var actual = fn("!a/?/c/?/e.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]\/c\/(?!\.)(?=.)[^/]\/e\.js)$).*$/);

var actual = fn("!a/?/c/?/e.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]\/c\/(?!\.)(?=.)[^/]\/e\.md)$).*$/);

var actual = fn("!a/?/c/???/e.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]\/c\/(?!\.)(?=.)[^/][^/][^/]\/e\.js)$).*$/);

var actual = fn("!a/?/c/???/e.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/]\/c\/(?!\.)(?=.)[^/][^/][^/]\/e\.md)$).*$/);

var actual = fn("!a/??/c.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/][^/]\/c\.js)$).*$/);

var actual = fn("!a/??/c.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/][^/]\/c\.md)$).*$/);

var actual = fn("!a/???/c.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/][^/][^/]\/c\.js)$).*$/);

var actual = fn("!a/???/c.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/][^/][^/]\/c\.md)$).*$/);

var actual = fn("!a/????/c.js");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/][^/][^/][^/]\/c\.js)$).*$/);

var actual = fn("!a/????/c.md");
actual.should.eql(/^(?!^(?:a\/(?!\.)(?=.)[^/][^/][^/][^/]\/c\.md)$).*$/);

var actual = fn("!a/b/**/c{d,e}/**/xyz.js");
actual.should.eql(/^(?!^(?:a\/b\/(?:(?!(?:\/|^)\.).)*?\/cd\/(?:(?!(?:\/|^)\.).)*?\/xyz\.js|a\/b\/(?:(?!(?:\/|^)\.).)*?\/ce\/(?:(?!(?:\/|^)\.).)*?\/xyz\.js)$).*$/);

var actual = fn("!a/b/**/c{d,e}/**/xyz.md");
actual.should.eql(/^(?!^(?:a\/b\/(?:(?!(?:\/|^)\.).)*?\/cd\/(?:(?!(?:\/|^)\.).)*?\/xyz\.md|a\/b\/(?:(?!(?:\/|^)\.).)*?\/ce\/(?:(?!(?:\/|^)\.).)*?\/xyz\.md)$).*$/);

var actual = fn("!a/b/c/*.js");
actual.should.eql(/^(?!^(?:a\/b\/c\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!A/b/C/*.js");
actual.should.eql(/^(?!^(?:A\/b\/C\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!a/b/c/*.md");
actual.should.eql(/^(?!^(?:a\/b\/c\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!A/b/C/*.md");
actual.should.eql(/^(?!^(?:A\/b\/C\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!A/b/C/*.MD");
actual.should.eql(/^(?!^(?:A\/b\/C\/(?!\.)(?=.)[^/]*?\.MD)$).*$/);

var actual = fn("!a/b/c{d,e{f,g}}/*.js");
actual.should.eql(/^(?!^(?:a\/b\/cd\/(?!\.)(?=.)[^/]*?\.js|a\/b\/cef\/(?!\.)(?=.)[^/]*?\.js|a\/b\/ceg\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!a/b/c{d,e{f,g}}/*.md");
actual.should.eql(/^(?!^(?:a\/b\/cd\/(?!\.)(?=.)[^/]*?\.md|a\/b\/cef\/(?!\.)(?=.)[^/]*?\.md|a\/b\/ceg\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!a/b/c{d,e}/*.js");
actual.should.eql(/^(?!^(?:a\/b\/cd\/(?!\.)(?=.)[^/]*?\.js|a\/b\/ce\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!a/b/c{d,e}/*.md");
actual.should.eql(/^(?!^(?:a\/b\/cd\/(?!\.)(?=.)[^/]*?\.md|a\/b\/ce\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!a/b/c{d,e}/xyz.js");
actual.should.eql(/^(?!^(?:a\/b\/cd\/xyz\.js|a\/b\/ce\/xyz\.js)$).*$/);

var actual = fn("!a/b/c{d,e}/xyz.md");
actual.should.eql(/^(?!^(?:a\/b\/cd\/xyz\.md|a\/b\/ce\/xyz\.md)$).*$/);

var actual = fn("!a/{c..e}.js");
actual.should.eql(/^(?!^(?:a\/c\.js|a\/d\.js|a\/e\.js)$).*$/);

var actual = fn("!E:**/*.js");
actual.should.eql(/^(?!^(?:(?=.)E:[^/]*?[^/]*?\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!E:**/*.md");
actual.should.eql(/^(?!^(?:(?=.)E:[^/]*?[^/]*?\/(?!\.)(?=.)[^/]*?\.md)$).*$/);

var actual = fn("!E:\\**/*.js");
actual.should.eql(/^(?!^(?:(?=.)E:\\[^/]*?[^/]*?\/(?!\.)(?=.)[^/]*?\.js)$).*$/);

var actual = fn("!E:\\**/*.md");
actual.should.eql(/^(?!^(?:(?=.)E:\\[^/]*?[^/]*?\/(?!\.)(?=.)[^/]*?\.md)$).*$/);
