"""Combined argparse and ConfigParser."""

import argparse

class UsageError(RuntimeError):
    pass

class ConfigError(RuntimeError):
    pass

class ConfigArgumentParser(argparse.ArgumentParser):

    def error(self, message):
        raise UsageError(message)

    def configure_defaults(self, config, defaults_section):
        """Merge those configurations files in the list `config_paths` which
        exist and return the corresponding `ConfigParser` object.  Later files
        take presedence over former.  Variables from `defaults_section` will be
        used as defaults for the argument parser options."""

        if not isinstance(defaults_section, list):
            defaults_section = [defaults_section]
        for section in defaults_section:
            if config.has_section(section):
                defaults = [(var, config.get(section, var))
                            for var in config.options(section)]
                self.set_defaults(**dict(defaults))
                break

        # TODO: Validation can be refined. Ideally we should check each config
        # variable individually and report a) the variable name rather than
        # the option name and b) the line number of the bad value.
        try:
            self.parse_args()
        except argparse.ArgumentTypeError as exn:
            raise ConfigError(
                    'The configuration corresponding to a command-line '
                    'option failed: %s' % exn)
