/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __NB_NOTE_H__
#define __NB_NOTE_H__

#include <glib.h>

#include "nb_attachment.h"
#include "nb_attachment_list.h"

typedef enum _note_type NoteType;

enum _note_type {
	NOTE,
	PERSONAL,
	PROBLEM,
	TIPNTRICK,
	BOOKMARK
};

static const gchar * note_type_string[5] = {
	"Note",
	"Personal",
	"Problem",
	"Tips 'n Tricks",
	"Bookmark",
};

typedef enum _note_status NoteStatus; 

enum _note_status {
	NONE,
	OPEN,
	SOLVED
};

static const gchar * note_status_string[3] = {
	"None",
	"Open",
	"Solved",
};

typedef struct _export_type ExportType;
                                                                                                                                        
struct _export_type
{
	gboolean note;
	gboolean personal;
	gboolean problem;
	gboolean trick;
	gboolean bookmark;
};


typedef struct _note Note;

struct _note
{
	gchar * title;
	gchar * text;
	GDate * date;
	GDate * update;
	NoteType type;
	NoteStatus status;
	AttachmentList * attachments;
};

/* create and free object */
Note		* nb_note_new (void);
void		nb_note_free (Note * self);

/* read/write from/to xml doc */
Note		* nb_note_new_from_xml_doc (xmlDocPtr doc, xmlNodePtr cur);
GDate		* nb_date_new_from_xml_doc (xmlDocPtr doc, xmlNodePtr cur);
gchar 		* nb_note_get_text_from_file (xmlDocPtr doc, xmlNodePtr cur);
xmlNodePtr	nb_note_get_xml_pointer (Note * self, xmlNsPtr ns, gint index);

/* update attributes */
void		nb_note_set_title (Note * self, gchar * title);
void		nb_note_set_text (Note * self, gchar * text);
void		nb_note_set_type (Note * self, NoteType type);
void		nb_note_set_status (Note * self, NoteStatus status);
void		nb_note_set_date (Note * self, GDate * date);
void		nb_note_set_lastupdate (Note * self, GDate * update);
void		nb_note_clear_text (Note * self);

/* attachments */
gboolean	nb_note_add_attachment (Note * self, Attachment * a);
gboolean	nb_note_remove_attachment (Note * self, Attachment * a);
gint		nb_note_get_nb_attachments (Note * self);
void		nb_note_check_attachments (Note * self);

/* queries */
gboolean	nb_note_matches_query (Note * self, gchar * query);
gboolean	nb_note_matches_type (Note * self, ExportType * type);

#endif
