/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "nb_ui_statusbar.h"

void
nb_ui_statusbar_push (gchar * text)
{
	extern GladeXML * xml;
	GtkWidget * statusbar;
	guint context_id;

	statusbar = glade_xml_get_widget (xml, "statusbar");
	context_id = gtk_statusbar_get_context_id ( GTK_STATUSBAR (statusbar), "main");

	gtk_statusbar_pop ( GTK_STATUSBAR (statusbar), context_id);
	gtk_statusbar_push ( GTK_STATUSBAR (statusbar), context_id, text);
}
