/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.authorization;

import com.sourceforge.knecs.dsm.authorization.DSIAuthService;
import com.sourceforge.knecs.dsm.authorization.DSIPrivilege;
import com.sourceforge.knecs.dsm.authorization.NormalizedAce;
import com.sourceforge.knecs.util.LoggerUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Privilege;

public class NormalizedAceList {
    protected static Logger mLogger = null;
    protected Hashtable mAces;
    protected String mPath;

    public NormalizedAceList(String urlPath) {
        this.mPath = urlPath;
        this.mAces = new Hashtable();
        mLogger = LoggerUtils.getLogger(this);
        mLogger.fine("NormalizedAceList for resource: " + this.mPath);
    }

    public NormalizedAceList(NormalizedAceList aces) {
        this.mPath = aces.mPath;
        mLogger = LoggerUtils.getLogger(this);
        this.mAces = new Hashtable();
        Enumeration keys = aces.mAces.keys();
        while (keys.hasMoreElements()) {
            String userId = (String)keys.nextElement();
            NormalizedAce curAce = (NormalizedAce)aces.mAces.get(userId);
            NormalizedAce newAce = new NormalizedAce(curAce);
            this.mAces.put(userId, newAce);
        }
    }

    public void mergeAce(Ace curAce) {
        int inheritanceLevel;
        String curUser = curAce.getPrincipal();
        mLogger.fine("Merging ace for principal: " + curUser);
        NormalizedAce nAce = (NormalizedAce)this.mAces.get(curUser);
        if (nAce == null) {
            nAce = new NormalizedAce();
            nAce.setUser(curUser);
            this.mAces.put(curUser, nAce);
        }
        if (!curAce.isInherited()) {
            inheritanceLevel = 0;
        } else {
            String inheritedFrom = curAce.getInheritedFrom();
            inheritanceLevel = this.getInheritanceLevel(inheritedFrom);
        }
        boolean deny = curAce.isNegative();
        Enumeration privs = curAce.enumeratePrivileges();
        while (privs.hasMoreElements()) {
            Privilege curPriv = (Privilege)privs.nextElement();
            String privName = DSIPrivilege.convertSlidePrivilege(curPriv);
            DSIPrivilege dsiPriv = new DSIPrivilege(privName, inheritanceLevel, deny);
            nAce.put(privName, dsiPriv);
        }
    }

    public void addPrivilege(String userID, String privName, boolean deny) {
        DSIPrivilege priv;
        String userPrin = DSIAuthService.getUserPrincipalURI(userID);
        NormalizedAce ace = (NormalizedAce)this.mAces.get(userPrin);
        if (ace == null) {
            ace = new NormalizedAce();
            ace.setUser(userPrin);
            this.mAces.put(userPrin, ace);
        }
        if ((priv = ace.getPrivilege(privName)) != null && priv.getInheritanceLevel() == 0) {
            ace.remove(privName);
        }
        DSIPrivilege read = (DSIPrivilege)ace.get(DSIPrivilege.READ);
        DSIPrivilege write = (DSIPrivilege)ace.get(DSIPrivilege.WRITE);
        DSIPrivilege readAcl = (DSIPrivilege)ace.get(DSIPrivilege.READ_ACL);
        DSIPrivilege writeAcl = (DSIPrivilege)ace.get(DSIPrivilege.WRITE_ACL);
        if (privName.equals(DSIPrivilege.ALL)) {
            if (read != null && read.getInheritanceLevel() == 0) {
                ace.remove(DSIPrivilege.READ);
            }
            if (write != null && write.getInheritanceLevel() == 0) {
                ace.remove(DSIPrivilege.WRITE);
            }
            if (readAcl != null && readAcl.getInheritanceLevel() == 0) {
                ace.remove(DSIPrivilege.READ_ACL);
            }
            if (writeAcl != null && writeAcl.getInheritanceLevel() == 0) {
                ace.remove(DSIPrivilege.WRITE_ACL);
            }
        }
        if ((priv = ace.getPrivilege(privName)) == null && deny) {
            return;
        }
        if (priv != null && priv.getDeny() == deny) {
            return;
        }
        DSIPrivilege newPriv = new DSIPrivilege(privName, 0, deny);
        ace.put(privName, newPriv);
    }

    public DSIPrivilege getPrivilege(String userID, String privName) {
        DSIPrivilege temp;
        String userPrin = DSIAuthService.getUserPrincipalURI(userID);
        boolean checkAuth = false;
        boolean checkUser = false;
        if (!userPrin.equals("all")) {
            checkAuth = true;
            if (!userPrin.equals(DSIAuthService.getAuthUserURI())) {
                checkUser = true;
            }
        }
        DSIPrivilege priv = null;
        NormalizedAce curAce = (NormalizedAce)this.mAces.get("all");
        if (curAce != null) {
            priv = curAce.getPrivilege(privName);
        }
        if (checkAuth && (curAce = (NormalizedAce)this.mAces.get(DSIAuthService.getAuthUserURI())) != null) {
            temp = curAce.getPrivilege(privName);
            if (priv == null) {
                priv = temp;
            } else if (temp != null) {
                if (temp.getInheritanceLevel() == priv.getInheritanceLevel() && temp.getDeny()) {
                    priv = temp;
                } else if (temp.getInheritanceLevel() < priv.getInheritanceLevel()) {
                    priv = temp;
                }
            }
        }
        if (checkUser && (curAce = (NormalizedAce)this.mAces.get(userPrin)) != null) {
            temp = curAce.getPrivilege(privName);
            if (priv == null) {
                priv = temp;
            } else if (temp != null) {
                if (temp.getInheritanceLevel() == priv.getInheritanceLevel() && temp.getDeny()) {
                    priv = temp;
                } else if (temp.getInheritanceLevel() < priv.getInheritanceLevel()) {
                    priv = temp;
                }
            }
        }
        return priv;
    }

    public boolean isAuthorized(String userID, Privilege priv) {
        String dsiPriv = DSIPrivilege.convertSlidePrivilege(priv);
        return this.isAuthorized(userID, dsiPriv);
    }

    public boolean isAuthorized(String userID, String privName) {
        String userPrin = DSIAuthService.getUserPrincipalURI(userID);
        DSIPrivilege priv = this.getPrivilege(userPrin, privName);
        boolean ret = false;
        if (priv != null) {
            ret = !priv.getDeny();
        }
        mLogger.fine("isAuthorized " + userPrin + ":" + privName + "=" + ret);
        return ret;
    }

    public Enumeration getUsers() {
        return this.mAces.keys();
    }

    public String getCmcsUserId(String userPrincipal) {
        return DSIAuthService.getCmcsUserId(userPrincipal);
    }

    public String getUserPrincipalURI(String userID) {
        return DSIAuthService.getUserPrincipalURI(userID);
    }

    public NormalizedAce getAce(String userPrin) {
        return (NormalizedAce)this.mAces.get(userPrin);
    }

    protected int getInheritanceLevel(String inheritedPath) {
        if (this.mPath.length() > 1 && this.mPath.endsWith("/")) {
            this.mPath = this.mPath.substring(0, this.mPath.length() - 1);
        }
        if (inheritedPath.length() > 1 && inheritedPath.endsWith("/")) {
            inheritedPath = inheritedPath.substring(0, inheritedPath.length() - 1);
        }
        mLogger.fine("resource path = " + this.mPath);
        mLogger.fine("inheritedFrom path = " + inheritedPath);
        String diff = this.mPath.substring(inheritedPath.length());
        int slashCount = 0;
        int length = diff.length();
        for (int i = 0; i < length; ++i) {
            if (diff.charAt(i) != '/') continue;
            ++slashCount;
        }
        if (inheritedPath.equals("/")) {
            ++slashCount;
        }
        mLogger.fine("inheritanceLevel = " + slashCount);
        return slashCount;
    }
}

