/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject;

import com.sourceforge.knecs.dsm.resourceobject.DataChangeEvent;
import com.sourceforge.knecs.dsm.resourceobject.DataChangeListener;
import com.sourceforge.knecs.dsm.resourceobject.IRISService;
import com.sourceforge.knecs.dsm.resourceobject.IServiceConnection;
import com.sourceforge.knecs.dsm.resourceobject.RISException;
import com.sourceforge.knecs.dsm.resourceobject.RISNaming;
import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;
import com.sourceforge.knecs.dsm.resourceobject.Task;
import com.sourceforge.knecs.dsm.search.QueryPredicate;
import com.sourceforge.knecs.dsm.util.DAVResource;
import com.sourceforge.knecs.dsm.util.DAVResourcePropertyVector;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;

public class RISConnection
implements IRISService {
    private Vector mChangeListeners = new Vector();
    protected IServiceConnection mServiceConnection;
    protected RISNaming mRisNaming;
    private Logger mLog;
    private CMCSProperties mCmcsProps;

    protected RISConnection() {
    }

    protected RISConnection(IServiceConnection serviceConnection) {
        this.mLog = LoggerUtils.getLogger(this);
        this.mServiceConnection = serviceConnection;
        this.mRisNaming = new RISNaming(this.mServiceConnection);
        this.mCmcsProps = CMCSProperties.getCMCSProperties();
    }

    public void connect(String aUserID, String anAuthToken) {
        this.mServiceConnection.connect(aUserID, anAuthToken);
    }

    public void close() {
        this.mServiceConnection.close();
        this.mServiceConnection = null;
        this.mRisNaming = null;
    }

    public String replace(ResourceObject oldObjectVersion, ResourceObject newObjectVersion) throws RISException {
        String fullPath = null;
        if (oldObjectVersion == null || newObjectVersion == null) {
            this.mLog.warning("Unable to replace object, one or both objects are null");
            throw new RISException("Unable to replace object, one or both objects are null");
        }
        try {
            String parentPath = this.mRisNaming.getParentPath(newObjectVersion);
            String newCtxName = newObjectVersion.getId();
            String oldCtxName = oldObjectVersion.getId();
            if (newCtxName == null || newCtxName.length() == 0 || oldCtxName == null || oldCtxName.length() == 0 || !newCtxName.equals(oldCtxName)) {
                this.mLog.warning("Unable to replace object, the versions have different names");
                throw new RISException("Unable to replace object, the versions have different names");
            }
            fullPath = parentPath + "/" + newCtxName;
            Hashtable newProps = (Hashtable)newObjectVersion.getAttributes().clone();
            Hashtable oldProps = (Hashtable)oldObjectVersion.getAttributes().clone();
            Set oldKeys = oldProps.keySet();
            Enumeration newKeys = newProps.keys();
            while (newKeys.hasMoreElements()) {
                String currentKey = (String)newKeys.nextElement();
                if (!oldKeys.contains(currentKey)) continue;
                Object oldValue = oldProps.get(currentKey);
                Object newValue = newProps.get(currentKey);
                Class attributeClass = newObjectVersion.getAttributeType(currentKey);
                boolean theSame = false;
                if (attributeClass.getName().equals(oldObjectVersion.getAttributeType(currentKey).getName())) {
                    if (attributeClass.isArray()) {
                        if (Arrays.equals((Object[])oldValue, (Object[])newValue)) {
                            theSame = true;
                        }
                    } else if (oldValue.equals(newValue)) {
                        theSame = true;
                    }
                }
                oldKeys.remove(currentKey);
                if (!theSame) continue;
                newProps.remove(currentKey);
            }
            this.mServiceConnection.modify(fullPath, newObjectVersion.getContent(), newProps, oldKeys);
            this.fireDataSaveEvent(newObjectVersion);
        }
        catch (Exception ex) {
            throw new RISException(ex.getMessage());
        }
        return fullPath;
    }

    public String save(ResourceObject aResourceObject) throws RISException {
        String ctxName = null;
        String fullPath = null;
        try {
            String parentPath = this.mRisNaming.getParentPath(aResourceObject);
            ctxName = aResourceObject.getId();
            if (ctxName != null && ctxName.length() > 0) {
                fullPath = parentPath + "/" + ctxName;
                this.mServiceConnection.modify(fullPath, aResourceObject.getContent(), aResourceObject.getAttributes());
            } else {
                ctxName = this.mRisNaming.getName(aResourceObject);
                aResourceObject.setId(ctxName);
                fullPath = parentPath + "/" + ctxName;
                this.mServiceConnection.save(fullPath, aResourceObject.getContent(), aResourceObject.getAttributes());
            }
            this.fireDataSaveEvent(aResourceObject);
        }
        catch (Exception ex) {
            throw new RISException(ex.getMessage());
        }
        return fullPath;
    }

    public String remove(ResourceObject aResourceObject) throws RISException {
        String ctxName = null;
        try {
            ctxName = this.mRisNaming.getPath(aResourceObject);
            this.mServiceConnection.delete(ctxName);
            this.fireDataRemoveEvent(ctxName);
        }
        catch (Exception ex) {
            throw new RISException(ex.getMessage());
        }
        return ctxName;
    }

    public ResourceObject getResourceObject(String resourcePathname) throws RISException {
        ResourceObject returnValue = null;
        Vector<DAVResource> tmpVec = new Vector<DAVResource>();
        try {
            Class resourceClass = this.mRisNaming.getClass(resourcePathname);
            if (resourceClass != null) {
                ResourceObject tmpObj = (ResourceObject)resourceClass.newInstance();
                String[] classProps = tmpObj.getAllValidAttributeNames();
                Vector<NSProperty> returnProperties = new Vector<NSProperty>();
                for (int i = 0; i < classProps.length; ++i) {
                    NSProperty tmpProp = new NSProperty(classProps[i]);
                    returnProperties.add(tmpProp);
                }
                returnProperties.add(CMCSProperties.getPropertyAsNSProperty("resourcetype"));
                returnProperties.add(CMCSProperties.getPropertyAsNSProperty("resourceurl"));
                returnProperties.add(CMCSProperties.getPropertyAsNSProperty("contentlength"));
                DAVResource retrievedObj = this.mServiceConnection.get(resourcePathname, returnProperties);
                if (retrievedObj != null) {
                    tmpVec.add(retrievedObj);
                }
            }
        }
        catch (Exception ex) {
            this.mLog.severe("Exception caught in get call to DAVConnection " + ex.toString() + " " + ex.getStackTrace().toString());
            throw new RISException(ex.getMessage());
        }
        Vector convertedResults = this.convertSearchResultsToObjects(tmpVec);
        if (convertedResults.size() > 0) {
            returnValue = (ResourceObject)convertedResults.elementAt(0);
        }
        return returnValue;
    }

    public ResourceObject[] getResourceObjects(Class objectType, QueryPredicate searchPredicate) throws RISException {
        QueryPredicate[] tmpPredicate = null;
        if (searchPredicate != null) {
            tmpPredicate = new QueryPredicate[]{searchPredicate};
        }
        return this.getResourceObjects(objectType, tmpPredicate);
    }

    public ResourceObject[] getResourceObjects(Class objectType, QueryPredicate[] searchPredicate) throws RISException {
        Vector searchResults = null;
        try {
            String ctxName = this.mRisNaming.getParentPath(objectType);
            ResourceObject tmpObj = (ResourceObject)objectType.newInstance();
            String[] classProps = tmpObj.getAllValidAttributeNames();
            HashSet<NSProperty> returnProperties = new HashSet<NSProperty>();
            for (int i = 0; i < classProps.length; ++i) {
                NSProperty tmpProp = new NSProperty(classProps[i]);
                returnProperties.add(tmpProp);
            }
            returnProperties.add(CMCSProperties.getPropertyAsNSProperty("resourcetype"));
            returnProperties.add(CMCSProperties.getPropertyAsNSProperty("resourceurl"));
            returnProperties.add(CMCSProperties.getPropertyAsNSProperty("contentlength"));
            searchResults = this.mServiceConnection.search(ctxName, returnProperties, searchPredicate, 1);
        }
        catch (Exception ex) {
            this.mLog.severe("Exception caught in search call to DAVConnection " + ex.toString() + " " + ex.getStackTrace().toString());
            throw new RISException(ex.getMessage());
        }
        Vector convertedResults = this.convertSearchResultsToObjects(searchResults);
        ResourceObject[] returnValue = null;
        if (convertedResults.size() > 0) {
            returnValue = new ResourceObject[convertedResults.size()];
            for (int i = 0; i < convertedResults.size(); ++i) {
                returnValue[i] = (ResourceObject)convertedResults.get(i);
            }
        }
        return returnValue;
    }

    private Vector convertSearchResultsToObjects(Vector results) throws RISException {
        Vector<ResourceObject> returnValue = new Vector<ResourceObject>();
        String implClass = null;
        try {
            Enumeration entries = results.elements();
            while (entries.hasMoreElements()) {
                DAVResource entry = (DAVResource)entries.nextElement();
                if (entry.isCollection()) continue;
                entry.remove(CMCSProperties.getPropertyAsNSProperty("resourcetype"));
                entry.remove(CMCSProperties.getPropertyAsNSProperty("resourceurl"));
                entry.remove(CMCSProperties.getPropertyAsNSProperty("contentlength"));
                DAVResourcePropertyVector objClassVec = (DAVResourcePropertyVector)entry.get(new NSProperty("http://purl.org/dc/elements/1.1/:type"));
                if (objClassVec != null && objClassVec.size() > 0) {
                    implClass = (String)objClassVec.get(0);
                    if (implClass != null && implClass != "") {
                        implClass = implClass.replaceFirst("org.scidac.cmcs.dsmgmt", "com.sourceforge.knecs.dsm");
                        ResourceObject targetObject = this.createObject(Class.forName(implClass), entry);
                        targetObject.setContent(entry.getContent());
                        returnValue.add(targetObject);
                        continue;
                    }
                    this.mLog.warning("Empty class definition property found when trying to instantiate a Java object returned from search. Continuing...");
                    continue;
                }
                this.mLog.warning("Class definition property not found, unable to instantiate a Java object returned from search.  Continuing...");
            }
        }
        catch (ClassNotFoundException ex) {
            this.mLog.severe("ClassNotFoundException caught when creating resource object, " + implClass + " not defined");
            throw new RISException(ex.getMessage());
        }
        return returnValue;
    }

    private ResourceObject createObject(Class risClass, DAVResource entry) throws RISException {
        ResourceObject targetObject;
        try {
            targetObject = (ResourceObject)risClass.newInstance();
            Enumeration attributeNames = entry.keys();
            while (attributeNames.hasMoreElements()) {
                NSProperty anAttributeName = (NSProperty)attributeNames.nextElement();
                DAVResourcePropertyVector propVec = (DAVResourcePropertyVector)entry.get(anAttributeName);
                String[] attVal = null;
                if (propVec == null || propVec.size() <= 0) continue;
                attVal = ResourceObject.toStringArray(propVec);
                if (targetObject instanceof Task) {
                    this.mLog.info("task property " + anAttributeName.toString() + attVal + "->" + attVal.toString());
                }
                targetObject.set(anAttributeName.toString(), attVal);
            }
        }
        catch (Exception ex) {
            this.mLog.severe("Some exception caught creating object" + ex.getMessage());
            throw new RISException(ex.getMessage());
        }
        return targetObject;
    }

    private String stringArrayToString(String[] arr) {
        StringBuffer buf = new StringBuffer();
        if (arr != null) {
            for (int idx = 0; idx < arr.length; ++idx) {
                buf.append(arr[idx]);
                if (idx == arr.length + 1) continue;
                buf.append(",");
            }
        }
        return new String(buf);
    }

    public synchronized void addDataChangeListener(DataChangeListener l) {
        if (!this.mChangeListeners.contains(l)) {
            this.mChangeListeners.add(l);
        }
    }

    public synchronized void removeDataChangeListener(DataChangeListener l) {
        this.mChangeListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataSaveEvent(ResourceObject object) {
        Vector l;
        RISConnection rISConnection = this;
        synchronized (rISConnection) {
            l = (Vector)this.mChangeListeners.clone();
        }
        int size = l.size();
        if (size > 0) {
            DataChangeEvent event = new DataChangeEvent(object);
            for (int idx = 0; idx < size; ++idx) {
                DataChangeListener listener = (DataChangeListener)l.elementAt(idx);
                listener.dataChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataRemoveEvent(String event) {
        Vector l;
        RISConnection rISConnection = this;
        synchronized (rISConnection) {
            l = (Vector)this.mChangeListeners.clone();
        }
        int size = l.size();
        if (size > 0) {
            for (int idx = 0; idx < size; ++idx) {
                DataChangeListener listener = (DataChangeListener)l.elementAt(idx);
                listener.dataDeleted(event);
            }
        }
    }
}

