/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject;

import com.sourceforge.knecs.dsm.resourceobject.AutoRmHashtable;
import com.sourceforge.knecs.dsm.util.PedigreeUtils;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class ResourceObject {
    public static final String OWNERID = "http://purl.oclc.org/NET/cmcs/internal/schema/:ownerid";
    public static final String OBJECTCLASS = "http://purl.org/dc/elements/1.1/:type";
    public static final String KEY = "http://purl.org/dc/elements/1.1/:identifier";
    protected Hashtable mResourceEntry = null;
    protected Hashtable mAttributeTypes = null;
    protected String mContent = "";
    protected Logger mLog = LoggerUtils.getLogger(this);

    protected ResourceObject() {
        this.mResourceEntry = new AutoRmHashtable();
        this.mAttributeTypes = new Hashtable();
        this.setAttributeTypes();
    }

    private void setAttributeTypes() {
        this.mAttributeTypes.put(OWNERID, String.class);
        this.mAttributeTypes.put(OBJECTCLASS, String.class);
        this.mAttributeTypes.put(KEY, String.class);
    }

    protected Hashtable getAttributes() {
        return this.mResourceEntry;
    }

    public String getContent() {
        return this.mContent;
    }

    public void setContent(String value) {
        this.mContent = value;
    }

    public String[] getAsStringArray(String key) {
        Class<?> vclass;
        String[] ret = null;
        Object value = this.mResourceEntry.get(key);
        if (value != null && (vclass = value.getClass()).isArray()) {
            ret = (String[])value;
            ret = (String[])ret.clone();
        }
        return ret;
    }

    public String getOwnerId() {
        Object ownerId = this.mResourceEntry.get(OWNERID);
        return (String)ownerId;
    }

    public String getId() {
        Object id = this.mResourceEntry.get(KEY);
        return (String)id;
    }

    public void setOwnerId(String ownerId) {
        this.mResourceEntry.put(OWNERID, ownerId);
    }

    public void setId(String id) {
        String name = id;
        int pos = id.lastIndexOf(47);
        if (pos != -1) {
            name = id.substring(pos + 1);
        }
        this.mResourceEntry.put(KEY, name);
    }

    protected String[] getAttributeNames() {
        String[] attribNames = new String[this.mResourceEntry.size()];
        Enumeration attribKeys = this.mResourceEntry.keys();
        int index = 0;
        while (attribKeys.hasMoreElements()) {
            attribNames[index] = (String)attribKeys.nextElement();
            ++index;
        }
        return attribNames;
    }

    protected Enumeration getAttributeNamesAsEnumeration() {
        return this.mResourceEntry.keys();
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        String name = this.getClass().getName();
        int dotPos = name.lastIndexOf(".");
        if (dotPos != -1) {
            name = name.substring(dotPos + 1);
        }
        buf.append("<" + name + ">\n");
        Enumeration entries = this.mResourceEntry.keys();
        boolean index = false;
        while (entries.hasMoreElements()) {
            String key = (String)entries.nextElement();
            NSProperty nsprop = new NSProperty(key);
            buf.append("  <" + nsprop.getLocalName() + ">");
            Class attributeClass = this.getAttributeType(key);
            if (attributeClass.isArray()) {
                Object[] oarray = (Object[])this.mResourceEntry.get(key);
                buf.append(PedigreeUtils.makeRDFBag(ResourceObject.toVector(oarray)));
            } else {
                buf.append(this.mResourceEntry.get(key).toString());
            }
            buf.append("</" + nsprop.getLocalName() + ">\n");
        }
        buf.append("<content>" + this.getContent() + "</content>");
        buf.append("</" + name + ">\n");
        return new String(buf);
    }

    public void log() {
        StringBuffer buf = new StringBuffer();
        buf.append("Dumping: " + this.getClass().getName() + "\n");
        buf.append(this.toString());
        this.mLog.info(new String(buf));
    }

    protected String[] getAllValidAttributeNames() {
        String[] attribNames = new String[this.mAttributeTypes.size()];
        Enumeration attribKeys = this.mAttributeTypes.keys();
        int index = 0;
        while (attribKeys.hasMoreElements()) {
            attribNames[index] = (String)attribKeys.nextElement();
            ++index;
        }
        return attribNames;
    }

    protected Class getAttributeType(String attr) {
        return (Class)this.mAttributeTypes.get(attr);
    }

    protected Object get(String attr) {
        Class attributeClass;
        Object retValue = this.mResourceEntry.get(attr);
        if (retValue != null && (attributeClass = this.getAttributeType(attr)).isArray()) {
            retValue = ((Object[])retValue).clone();
            if (attributeClass.getComponentType().isArray()) {
                for (int idx = 0; idx < ((Object[])retValue).length; ++idx) {
                    ((Object[])retValue)[idx] = ((Object[])((Object[])retValue)[idx]).clone();
                }
            }
        }
        return retValue;
    }

    protected void set(String attr, Object value) throws Exception {
        if (this.getAttributeType(attr) == null) {
            throw new Exception("Invalid attribute: " + attr);
        }
        Object convertedValue = this.convertAttribute(attr, value);
        this.mResourceEntry.put(attr, convertedValue);
    }

    protected void add(String attr, Object value) throws Exception {
        Class attributeClass = this.getAttributeType(attr);
        if (attributeClass == null) {
            throw new Exception("Invalid attribute: " + attr);
        }
        Object currentValue = this.mResourceEntry.get(attr);
        if (currentValue == null || !attributeClass.isArray()) {
            this.set(attr, value);
        } else {
            Object convertedValue = this.convertAttribute(attr, value);
            Object combinedValue = Array.newInstance(attributeClass.getComponentType(), Array.getLength(currentValue) + Array.getLength(convertedValue));
            for (int i = 0; i < Array.getLength(currentValue); ++i) {
                Array.set(combinedValue, i, Array.get(currentValue, i));
            }
            int startIndex = Array.getLength(currentValue);
            for (int i = 0; i < Array.getLength(convertedValue); ++i) {
                Array.set(combinedValue, startIndex + i, Array.get(convertedValue, i));
            }
            this.mResourceEntry.put(attr, combinedValue);
        }
    }

    public static String[] toStringArray(Vector vec) {
        String[] ret = new String[vec.size()];
        for (int idx = 0; idx < vec.size(); ++idx) {
            ret[idx] = (String)vec.elementAt(idx);
        }
        return ret;
    }

    public static Vector toVector(String[] array) {
        Vector<String> ret = new Vector<String>();
        for (int idx = 0; idx < array.length; ++idx) {
            ret.add(array[idx]);
        }
        return ret;
    }

    public static Vector toVector(Object[] array) {
        Vector<Object> ret = new Vector<Object>();
        for (int idx = 0; idx < array.length; ++idx) {
            ret.add(array[idx]);
        }
        return ret;
    }

    private Object convertAttribute(String attributeName, Object attributeValue) throws Exception {
        Class<?> inputAttributeBaseType;
        boolean inputIsArray;
        Class<?> targetAttributeBaseType = this.getAttributeType(attributeName);
        Object targetAttribute = null;
        boolean targetIsArray = targetAttributeBaseType.isArray();
        if (targetIsArray) {
            targetAttributeBaseType = targetAttributeBaseType.getComponentType();
        }
        if (inputIsArray = (inputAttributeBaseType = attributeValue.getClass()).isArray()) {
            inputAttributeBaseType = inputAttributeBaseType.getComponentType();
        }
        if (targetAttributeBaseType == inputAttributeBaseType) {
            if (targetIsArray) {
                if (inputIsArray) {
                    targetAttribute = Array.newInstance(targetAttributeBaseType, Array.getLength(attributeValue));
                    System.arraycopy(attributeValue, 0, targetAttribute, 0, Array.getLength(attributeValue));
                } else {
                    targetAttribute = Array.newInstance(targetAttributeBaseType, 1);
                    Array.set(targetAttribute, 0, attributeValue);
                }
            } else {
                targetAttribute = inputIsArray ? Array.get(attributeValue, 0) : attributeValue;
            }
        } else {
            targetAttribute = this.convertData(attributeValue, inputAttributeBaseType, inputIsArray, targetAttributeBaseType, targetIsArray);
        }
        return targetAttribute;
    }

    private Object convertData(Object dataValue, Class inputComponentType, boolean inputIsArray, Class targetComponentType, boolean targetIsArray) throws Exception {
        Object returnValue = null;
        if (targetComponentType == Byte[].class || targetComponentType == Byte.class) {
            if (inputComponentType != byte[].class && inputComponentType != Byte.TYPE) {
                throw new Exception("Unexpected data conversion requested, input datatype: " + inputComponentType + " target datatype: " + targetComponentType);
            }
            if (targetComponentType == Byte.class) {
                byte[] inputValue = inputComponentType == byte[].class ? (byte[])Array.get(dataValue, 0) : (byte[])dataValue;
                returnValue = new Byte[inputValue.length];
                for (int i = 0; i < inputValue.length; ++i) {
                    ((Byte[])returnValue)[i] = new Byte(inputValue[i]);
                }
            } else {
                int returnLength = inputComponentType == byte[].class ? Array.getLength(dataValue) : 1;
                returnValue = new Byte[returnLength][];
                for (int i = 0; i < returnLength; ++i) {
                    byte[] inputValue = inputComponentType == byte[].class ? (byte[])Array.get(dataValue, i) : (byte[])dataValue;
                    ((Byte[][])returnValue)[i] = new Byte[inputValue.length];
                    for (int j = 0; j < inputValue.length; ++j) {
                        ((Byte[][])returnValue)[i][j] = new Byte(inputValue[j]);
                    }
                }
            }
        } else {
            Class[] argClass = new Class[1];
            Array.set(argClass, 0, inputComponentType);
            Constructor targetConstructor = targetComponentType.getConstructor(argClass);
            Object[] argObject = (Object[])Array.newInstance(inputComponentType, 1);
            if (targetIsArray) {
                int returnLength = inputIsArray ? Array.getLength(dataValue) : 1;
                returnValue = Array.newInstance(targetComponentType, returnLength);
                for (int i = 0; i < returnLength; ++i) {
                    Array.set(argObject, 0, inputIsArray ? Array.get(dataValue, i) : dataValue);
                    Object convertedValue = targetConstructor.newInstance(argObject);
                    Array.set(returnValue, i, convertedValue);
                }
            } else {
                Object value = inputIsArray ? Array.get(dataValue, 0) : dataValue;
                Array.set(argObject, 0, value);
                returnValue = targetConstructor.newInstance(argObject);
            }
        }
        return returnValue;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration entries = this.mResourceEntry.keys();
        boolean index = false;
        while (entries.hasMoreElements()) {
            String key = (String)entries.nextElement();
            buf.append("\t");
            buf.append(key);
            buf.append("->");
            Class attributeClass = this.getAttributeType(key);
            if (attributeClass.isArray()) {
                Object[] arr = (Object[])this.mResourceEntry.get(key);
                StringBuffer tmp = new StringBuffer();
                if (arr != null) {
                    for (int idx = 0; idx < arr.length; ++idx) {
                        tmp.append(arr[idx].toString());
                        if (idx == arr.length - 1) continue;
                        tmp.append(",");
                    }
                }
                buf.append(new String(tmp) + "\n");
                continue;
            }
            buf.append(this.mResourceEntry.get(key).toString() + "\n");
        }
        return new String(buf);
    }
}

