/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.util;

import java.util.Enumeration;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;

public class JMSUtil {
    public static void log(Logger logger, Message msg) {
        StringBuffer buf = new StringBuffer("JMSMessage Content:\n");
        try {
            Enumeration names = msg.getPropertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                try {
                    String value = msg.getStringProperty(name);
                    buf.append("\t" + name + "->" + value + "\n");
                }
                catch (MessageFormatException ignore) {
                    buf.append("\t" + name + "->" + "oops not a string" + "\n");
                }
            }
        }
        catch (JMSException bad) {
            logger.severe("JMS Exception " + bad.getMessage());
            return;
        }
        logger.info(new String(buf));
    }

    public static String toXML(Message msg) {
        StringBuffer buf = new StringBuffer("<SAMMessage>\n");
        try {
            Enumeration names = msg.getPropertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                try {
                    String value = msg.getStringProperty(name);
                    buf.append("\t" + name + "->" + value + "\n");
                    buf.append("<" + name + ">");
                    buf.append(value);
                    buf.append("</" + name + ">\n");
                }
                catch (MessageFormatException ignore) {}
            }
            buf.append("</SAMMessage>\n");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return new String(buf);
    }
}

